/* valaccodemethodmodule.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodemethodmodule.h>
#include <vala/valatypesymbol.h>
#include <vala/valasymbol.h>
#include <vala/valatrystatement.h>
#include <gee/hashmap.h>
#include <vala/valaclass.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeblock.h>
#include <vala/valablock.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <gee/collection.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valaattribute.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodestruct.h>
#include <float.h>
#include <math.h>
#include <vala/valamember.h>
#include <vala/valastruct.h>
#include <vala/valainterface.h>
#include <vala/valastructvaluetype.h>
#include <vala/valaenum.h>
#include <vala/valaenumvaluetype.h>
#include <vala/valaclasstype.h>
#include <vala/valatypeparameter.h>
#include <vala/valaformalparameter.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <vala/valamethodtype.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <vala/valareferencetype.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <vala/valaintegertype.h>
#include <vala/valapointertype.h>
#include <vala/valavoidtype.h>
#include <vala/valacodecontext.h>
#include <vala/valastatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodewhilestatement.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_METHOD_MODULE_DUMMY_PROPERTY
};
static gboolean vala_ccode_method_module_real_method_has_wrapper (ValaCCodeModule* base, ValaMethod* method);
static char* vala_ccode_method_module_real_get_custom_creturn_type (ValaCCodeModule* base, ValaMethod* m);
static char* vala_ccode_method_module_get_creturn_type (ValaCCodeMethodModule* self, ValaMethod* m, const char* default_value);
static void vala_ccode_method_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m);
static void vala_ccode_method_module_real_generate_cparameters (ValaCCodeModule* base, ValaMethod* m, ValaDataType* creturn_type, gboolean in_gtypeinstance_creation_method, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
static ValaCCodeStatement* vala_ccode_method_module_create_method_type_check_statement (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_ccode_method_module_create_precondition_statement (ValaCCodeMethodModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition);
static ValaCCodeStatement* vala_ccode_method_module_create_postcondition_statement (ValaCCodeMethodModule* self, ValaExpression* postcondition);
static ValaTypeSymbol* vala_ccode_method_module_find_parent_type (ValaCCodeMethodModule* self, ValaSymbol* sym);
static void vala_ccode_method_module_add_object_creation (ValaCCodeMethodModule* self, ValaCCodeBlock* b, gboolean has_params);
static void vala_ccode_method_module_real_visit_creation_method (ValaCCodeModule* base, ValaCreationMethod* m);
static gpointer vala_ccode_method_module_parent_class = NULL;



ValaCCodeMethodModule* vala_ccode_method_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodModule*) vala_ccode_struct_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodModule* vala_ccode_method_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_module_construct (VALA_TYPE_CCODE_METHOD_MODULE, codegen, next);
}


static gboolean vala_ccode_method_module_real_method_has_wrapper (ValaCCodeModule* base, ValaMethod* method) {
	ValaCCodeMethodModule * self;
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	self = (ValaCCodeMethodModule*) base;
	g_return_val_if_fail (method != NULL, FALSE);
	_tmp0 = NULL;
	return (_tmp1 = ((_tmp0 = vala_code_node_get_attribute ((ValaCodeNode*) method, "NoWrapper")) == NULL), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)), _tmp1);
}


static char* vala_ccode_method_module_real_get_custom_creturn_type (ValaCCodeModule* base, ValaMethod* m) {
	ValaCCodeMethodModule * self;
	ValaAttribute* attr;
	char* _tmp1;
	self = (ValaCCodeMethodModule*) base;
	g_return_val_if_fail (m != NULL, NULL);
	attr = vala_code_node_get_attribute ((ValaCodeNode*) m, "CCode");
	if (attr != NULL) {
		char* type;
		type = vala_attribute_get_string (attr, "type");
		if (type != NULL) {
			char* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = type, (attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL)), _tmp0);
		}
		type = (g_free (type), NULL);
	}
	_tmp1 = NULL;
	return (_tmp1 = NULL, (attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL)), _tmp1);
}


static char* vala_ccode_method_module_get_creturn_type (ValaCCodeMethodModule* self, ValaMethod* m, const char* default_value) {
	char* type;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (default_value != NULL, NULL);
	type = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, m);
	if (type == NULL) {
		const char* _tmp0;
		char* _tmp1;
		_tmp0 = NULL;
		_tmp1 = NULL;
		return (_tmp1 = (_tmp0 = default_value, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), type = (g_free (type), NULL), _tmp1);
	}
	return type;
}


static void vala_ccode_method_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m) {
	ValaCCodeMethodModule * self;
	ValaTypeSymbol* _tmp0;
	ValaTypeSymbol* old_type_symbol;
	ValaSymbol* _tmp1;
	ValaSymbol* old_symbol;
	ValaMethod* _tmp2;
	ValaMethod* old_method;
	ValaDataType* _tmp3;
	ValaDataType* old_return_type;
	gboolean old_method_inner_error;
	gint old_next_temp_var_id;
	GeeMap* _tmp4;
	GeeMap* old_variable_name_map;
	ValaTryStatement* _tmp5;
	ValaTryStatement* old_try;
	ValaSymbol* _tmp9;
	ValaSymbol* _tmp8;
	ValaMethod* _tmp11;
	ValaMethod* _tmp10;
	ValaDataType* _tmp13;
	ValaDataType* _tmp12;
	GeeMap* _tmp14;
	ValaTryStatement* _tmp15;
	gboolean in_gtypeinstance_creation_method;
	gboolean in_gobject_creation_method;
	gboolean in_fundamental_creation_method;
	ValaDataType* _tmp20;
	ValaDataType* creturn_type;
	gboolean inner_error;
	ValaTypeSymbol* _tmp43;
	ValaTypeSymbol* _tmp42;
	ValaSymbol* _tmp45;
	ValaSymbol* _tmp44;
	ValaMethod* _tmp47;
	ValaMethod* _tmp46;
	ValaDataType* _tmp49;
	ValaDataType* _tmp48;
	GeeMap* _tmp51;
	GeeMap* _tmp50;
	ValaTryStatement* _tmp53;
	ValaTryStatement* _tmp52;
	ValaCCodeFunction* _tmp57;
	char* _tmp56;
	char* _tmp55;
	char* _tmp54;
	GeeHashMap* cparam_map;
	ValaCCodeFunctionDeclarator* vdeclarator;
	gboolean _tmp58;
	gboolean visible;
	gboolean _tmp63;
	gboolean _tmp245;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	_tmp0 = NULL;
	old_type_symbol = (_tmp0 = ((ValaCCodeBaseModule*) self)->current_type_symbol, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	old_symbol = (_tmp1 = ((ValaCCodeBaseModule*) self)->current_symbol, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = NULL;
	old_method = (_tmp2 = ((ValaCCodeBaseModule*) self)->current_method, (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = NULL;
	old_return_type = (_tmp3 = ((ValaCCodeBaseModule*) self)->current_return_type, (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	old_method_inner_error = ((ValaCCodeBaseModule*) self)->current_method_inner_error;
	old_next_temp_var_id = ((ValaCCodeBaseModule*) self)->next_temp_var_id;
	_tmp4 = NULL;
	old_variable_name_map = (_tmp4 = ((ValaCCodeBaseModule*) self)->variable_name_map, (_tmp4 == NULL) ? NULL : gee_collection_object_ref (_tmp4));
	_tmp5 = NULL;
	old_try = (_tmp5 = ((ValaCCodeBaseModule*) self)->current_try, (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
	if (VALA_IS_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
		ValaTypeSymbol* _tmp7;
		ValaTypeSymbol* _tmp6;
		_tmp7 = NULL;
		_tmp6 = NULL;
		((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp7 = (_tmp6 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp7);
	}
	_tmp9 = NULL;
	_tmp8 = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp9 = (_tmp8 = (ValaSymbol*) m, (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	((ValaCCodeBaseModule*) self)->current_method = (_tmp11 = (_tmp10 = m, (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10)), (((ValaCCodeBaseModule*) self)->current_method == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_method), NULL)), _tmp11);
	_tmp13 = NULL;
	_tmp12 = NULL;
	((ValaCCodeBaseModule*) self)->current_return_type = (_tmp13 = (_tmp12 = vala_method_get_return_type (m), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12)), (((ValaCCodeBaseModule*) self)->current_return_type == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_return_type = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_return_type), NULL)), _tmp13);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = FALSE;
	((ValaCCodeBaseModule*) self)->next_temp_var_id = 0;
	_tmp14 = NULL;
	((ValaCCodeBaseModule*) self)->variable_name_map = (_tmp14 = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal), (((ValaCCodeBaseModule*) self)->variable_name_map == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->variable_name_map = (gee_collection_object_unref (((ValaCCodeBaseModule*) self)->variable_name_map), NULL)), _tmp14);
	_tmp15 = NULL;
	((ValaCCodeBaseModule*) self)->current_try = (_tmp15 = NULL, (((ValaCCodeBaseModule*) self)->current_try == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_try = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_try), NULL)), _tmp15);
	in_gtypeinstance_creation_method = FALSE;
	in_gobject_creation_method = FALSE;
	in_fundamental_creation_method = FALSE;
	vala_ccode_base_module_check_type ((ValaCCodeBaseModule*) self, vala_method_get_return_type (m));
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaClass* _tmp17;
		ValaTypeSymbol* _tmp16;
		ValaClass* cl;
		gboolean _tmp18;
		((ValaCCodeBaseModule*) self)->in_creation_method = TRUE;
		_tmp17 = NULL;
		_tmp16 = NULL;
		cl = (_tmp17 = (_tmp16 = ((ValaCCodeBaseModule*) self)->current_type_symbol, VALA_IS_CLASS (_tmp16) ? ((ValaClass*) _tmp16) : NULL), (_tmp17 == NULL) ? NULL : vala_code_node_ref (_tmp17));
		_tmp18 = FALSE;
		if (cl != NULL) {
			_tmp18 = !vala_class_get_is_compact (cl);
		} else {
			_tmp18 = FALSE;
		}
		if (_tmp18) {
			in_gtypeinstance_creation_method = TRUE;
			if (vala_class_get_base_class (cl) == NULL) {
				in_fundamental_creation_method = TRUE;
			} else {
				if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type)) {
					in_gobject_creation_method = TRUE;
				}
			}
		}
		if (cl != NULL) {
			ValaDataType* _tmp19;
			_tmp19 = NULL;
			((ValaCCodeBaseModule*) self)->current_return_type = (_tmp19 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) cl), (((ValaCCodeBaseModule*) self)->current_return_type == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_return_type = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_return_type), NULL)), _tmp19);
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	}
	_tmp20 = NULL;
	creturn_type = (_tmp20 = ((ValaCCodeBaseModule*) self)->current_return_type, (_tmp20 == NULL) ? NULL : vala_code_node_ref (_tmp20));
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (VALA_IS_CREATION_METHOD (m)) {
		gboolean _tmp21;
		_tmp21 = FALSE;
		if (in_gobject_creation_method) {
			_tmp21 = vala_method_get_body (m) != NULL;
		} else {
			_tmp21 = FALSE;
		}
		if (_tmp21) {
			ValaCCodeBlock* cblock;
			cblock = vala_ccode_block_new ();
			if (!vala_creation_method_get_chain_up ((VALA_CREATION_METHOD (m)))) {
				gboolean _tmp29;
				/* set construct properties*/
				{
					GeeList* _tmp22;
					GeeIterator* _tmp23;
					GeeIterator* _stmt_it;
					/* set construct properties*/
					_tmp22 = NULL;
					_tmp23 = NULL;
					_stmt_it = (_tmp23 = gee_iterable_iterator ((GeeIterable*) (_tmp22 = vala_block_get_statements (vala_method_get_body (m)))), (_tmp22 == NULL) ? NULL : (_tmp22 = (gee_collection_object_unref (_tmp22), NULL)), _tmp23);
					/* set construct properties*/
					while (gee_iterator_next (_stmt_it)) {
						ValaCodeNode* stmt;
						ValaExpressionStatement* _tmp25;
						ValaCodeNode* _tmp24;
						ValaExpressionStatement* expr_stmt;
						/* set construct properties*/
						stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_stmt_it));
						_tmp25 = NULL;
						_tmp24 = NULL;
						expr_stmt = (_tmp25 = (_tmp24 = stmt, VALA_IS_EXPRESSION_STATEMENT (_tmp24) ? ((ValaExpressionStatement*) _tmp24) : NULL), (_tmp25 == NULL) ? NULL : vala_code_node_ref (_tmp25));
						if (expr_stmt != NULL) {
							ValaProperty* prop;
							gboolean _tmp26;
							prop = vala_expression_statement_assigned_property (expr_stmt);
							_tmp26 = FALSE;
							if (prop != NULL) {
								_tmp26 = vala_property_accessor_get_construction (vala_property_get_set_accessor (prop));
							} else {
								_tmp26 = FALSE;
							}
							if (_tmp26) {
								if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
									{
										GeeList* _tmp27;
										GeeIterator* _tmp28;
										GeeIterator* _cstmt_it;
										_tmp27 = NULL;
										_tmp28 = NULL;
										_cstmt_it = (_tmp28 = gee_iterable_iterator ((GeeIterable*) (_tmp27 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt)))))), (_tmp27 == NULL) ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL)), _tmp28);
										while (gee_iterator_next (_cstmt_it)) {
											ValaCCodeNode* cstmt;
											cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
											vala_ccode_block_add_statement (cblock, cstmt);
											(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
										}
										(_cstmt_it == NULL) ? NULL : (_cstmt_it = (gee_collection_object_unref (_cstmt_it), NULL));
									}
								} else {
									vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
								}
							}
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
						}
						(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
						(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
					}
					(_stmt_it == NULL) ? NULL : (_stmt_it = (gee_collection_object_unref (_stmt_it), NULL));
				}
				_tmp29 = FALSE;
				if (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0) {
					_tmp29 = TRUE;
				} else {
					GeeList* _tmp30;
					_tmp30 = NULL;
					_tmp29 = gee_collection_get_size ((GeeCollection*) (_tmp30 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))) > 0;
					(_tmp30 == NULL) ? NULL : (_tmp30 = (gee_collection_object_unref (_tmp30), NULL));
				}
				vala_ccode_method_module_add_object_creation (self, cblock, _tmp29);
			} else {
				char* _tmp32;
				char* _tmp31;
				ValaCCodeDeclaration* _tmp33;
				ValaCCodeDeclaration* cdeclaration;
				ValaCCodeVariableDeclarator* _tmp34;
				_tmp32 = NULL;
				_tmp31 = NULL;
				_tmp33 = NULL;
				cdeclaration = (_tmp33 = vala_ccode_declaration_new (_tmp32 = g_strdup_printf ("%s *", _tmp31 = vala_typesymbol_get_cname ((ValaTypeSymbol*) (VALA_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)), FALSE))), _tmp32 = (g_free (_tmp32), NULL), _tmp31 = (g_free (_tmp31), NULL), _tmp33);
				_tmp34 = NULL;
				vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) (_tmp34 = vala_ccode_variable_declarator_new ("self", NULL)));
				(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdeclaration);
				(cdeclaration == NULL) ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL));
			}
			/* other initialization code*/
			{
				GeeList* _tmp35;
				GeeIterator* _tmp36;
				GeeIterator* _stmt_it;
				/* other initialization code*/
				_tmp35 = NULL;
				_tmp36 = NULL;
				_stmt_it = (_tmp36 = gee_iterable_iterator ((GeeIterable*) (_tmp35 = vala_block_get_statements (vala_method_get_body (m)))), (_tmp35 == NULL) ? NULL : (_tmp35 = (gee_collection_object_unref (_tmp35), NULL)), _tmp36);
				/* other initialization code*/
				while (gee_iterator_next (_stmt_it)) {
					ValaCodeNode* stmt;
					ValaExpressionStatement* _tmp38;
					ValaCodeNode* _tmp37;
					ValaExpressionStatement* expr_stmt;
					/* other initialization code*/
					stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_stmt_it));
					_tmp38 = NULL;
					_tmp37 = NULL;
					expr_stmt = (_tmp38 = (_tmp37 = stmt, VALA_IS_EXPRESSION_STATEMENT (_tmp37) ? ((ValaExpressionStatement*) _tmp37) : NULL), (_tmp38 == NULL) ? NULL : vala_code_node_ref (_tmp38));
					if (expr_stmt != NULL) {
						ValaProperty* prop;
						gboolean _tmp39;
						prop = vala_expression_statement_assigned_property (expr_stmt);
						_tmp39 = FALSE;
						if (prop != NULL) {
							_tmp39 = vala_property_accessor_get_construction (vala_property_get_set_accessor (prop));
						} else {
							_tmp39 = FALSE;
						}
						if (_tmp39) {
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
							(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
							(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
							continue;
						}
						(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					}
					if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
						{
							GeeList* _tmp40;
							GeeIterator* _tmp41;
							GeeIterator* _cstmt_it;
							_tmp40 = NULL;
							_tmp41 = NULL;
							_cstmt_it = (_tmp41 = gee_iterable_iterator ((GeeIterable*) (_tmp40 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt)))))), (_tmp40 == NULL) ? NULL : (_tmp40 = (gee_collection_object_unref (_tmp40), NULL)), _tmp41);
							while (gee_iterator_next (_cstmt_it)) {
								ValaCCodeNode* cstmt;
								cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
								vala_ccode_block_add_statement (cblock, cstmt);
								(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
							}
							(_cstmt_it == NULL) ? NULL : (_cstmt_it = (gee_collection_object_unref (_cstmt_it), NULL));
						}
					} else {
						vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
					}
					(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
					(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
				}
				(_stmt_it == NULL) ? NULL : (_stmt_it = (gee_collection_object_unref (_stmt_it), NULL));
			}
			vala_code_node_set_ccodenode ((ValaCodeNode*) vala_method_get_body (m), (ValaCCodeNode*) cblock);
			(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		}
		((ValaCCodeBaseModule*) self)->in_creation_method = FALSE;
	}
	inner_error = ((ValaCCodeBaseModule*) self)->current_method_inner_error;
	_tmp43 = NULL;
	_tmp42 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp43 = (_tmp42 = old_type_symbol, (_tmp42 == NULL) ? NULL : vala_code_node_ref (_tmp42)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp43);
	_tmp45 = NULL;
	_tmp44 = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp45 = (_tmp44 = old_symbol, (_tmp44 == NULL) ? NULL : vala_code_node_ref (_tmp44)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp45);
	_tmp47 = NULL;
	_tmp46 = NULL;
	((ValaCCodeBaseModule*) self)->current_method = (_tmp47 = (_tmp46 = old_method, (_tmp46 == NULL) ? NULL : vala_code_node_ref (_tmp46)), (((ValaCCodeBaseModule*) self)->current_method == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_method), NULL)), _tmp47);
	_tmp49 = NULL;
	_tmp48 = NULL;
	((ValaCCodeBaseModule*) self)->current_return_type = (_tmp49 = (_tmp48 = old_return_type, (_tmp48 == NULL) ? NULL : vala_code_node_ref (_tmp48)), (((ValaCCodeBaseModule*) self)->current_return_type == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_return_type = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_return_type), NULL)), _tmp49);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = old_method_inner_error;
	((ValaCCodeBaseModule*) self)->next_temp_var_id = old_next_temp_var_id;
	_tmp51 = NULL;
	_tmp50 = NULL;
	((ValaCCodeBaseModule*) self)->variable_name_map = (_tmp51 = (_tmp50 = old_variable_name_map, (_tmp50 == NULL) ? NULL : gee_collection_object_ref (_tmp50)), (((ValaCCodeBaseModule*) self)->variable_name_map == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->variable_name_map = (gee_collection_object_unref (((ValaCCodeBaseModule*) self)->variable_name_map), NULL)), _tmp51);
	_tmp53 = NULL;
	_tmp52 = NULL;
	((ValaCCodeBaseModule*) self)->current_try = (_tmp53 = (_tmp52 = old_try, (_tmp52 == NULL) ? NULL : vala_code_node_ref (_tmp52)), (((ValaCCodeBaseModule*) self)->current_try == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_try = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_try), NULL)), _tmp53);
	_tmp57 = NULL;
	_tmp56 = NULL;
	_tmp55 = NULL;
	_tmp54 = NULL;
	((ValaCCodeBaseModule*) self)->function = (_tmp57 = vala_ccode_function_new (_tmp54 = vala_method_get_real_cname (m), _tmp56 = vala_ccode_method_module_get_creturn_type (self, m, _tmp55 = vala_data_type_get_cname (creturn_type))), (((ValaCCodeBaseModule*) self)->function == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->function = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->function), NULL)), _tmp57);
	_tmp56 = (g_free (_tmp56), NULL);
	_tmp55 = (g_free (_tmp55), NULL);
	_tmp54 = (g_free (_tmp54), NULL);
	vala_code_node_set_ccodenode ((ValaCodeNode*) m, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
	if (vala_method_get_is_inline (m)) {
		vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) self)->function) | (VALA_CCODE_MODIFIERS_INLINE));
	}
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	vdeclarator = NULL;
	_tmp58 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp58 = TRUE;
	} else {
		_tmp58 = vala_method_get_is_virtual (m);
	}
	if (_tmp58) {
		char* _tmp60;
		char* _tmp59;
		ValaCCodeDeclaration* _tmp61;
		ValaCCodeDeclaration* vdecl;
		ValaCCodeFunctionDeclarator* _tmp62;
		_tmp60 = NULL;
		_tmp59 = NULL;
		_tmp61 = NULL;
		vdecl = (_tmp61 = vala_ccode_declaration_new (_tmp60 = vala_ccode_method_module_get_creturn_type (self, m, _tmp59 = vala_data_type_get_cname (creturn_type))), _tmp60 = (g_free (_tmp60), NULL), _tmp59 = (g_free (_tmp59), NULL), _tmp61);
		_tmp62 = NULL;
		vdeclarator = (_tmp62 = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m)), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp62);
		vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
		vala_ccode_struct_add_declaration (((ValaCCodeBaseModule*) self)->type_struct, vdecl);
		(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	}
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, creturn_type, in_gtypeinstance_creation_method, (GeeMap*) cparam_map, ((ValaCCodeBaseModule*) self)->function, vdeclarator, NULL, NULL, 3);
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	_tmp63 = FALSE;
	if (!vala_method_get_is_abstract (m)) {
		_tmp63 = TRUE;
	} else {
		gboolean _tmp64;
		_tmp64 = FALSE;
		if (vala_method_get_is_abstract (m)) {
			_tmp64 = VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol);
		} else {
			_tmp64 = FALSE;
		}
		_tmp63 = (_tmp64);
	}
	/* generate *_real_* functions for virtual methods
	 also generate them for abstract methods of classes to prevent faulty subclassing*/
	if (_tmp63) {
		gboolean _tmp65;
		gboolean _tmp66;
		_tmp65 = FALSE;
		_tmp66 = FALSE;
		if (visible) {
			_tmp66 = vala_method_get_base_method (m) == NULL;
		} else {
			_tmp66 = FALSE;
		}
		if (_tmp66) {
			_tmp65 = vala_method_get_base_interface_method (m) == NULL;
		} else {
			_tmp65 = FALSE;
		}
		if (_tmp65) {
			ValaCCodeFunction* _tmp67;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			_tmp67 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp67 = vala_ccode_function_copy (((ValaCCodeBaseModule*) self)->function)));
			(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
		} else {
			ValaCCodeFunction* _tmp68;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, vala_ccode_function_get_modifiers (((ValaCCodeBaseModule*) self)->function) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp68 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp68 = vala_ccode_function_copy (((ValaCCodeBaseModule*) self)->function)));
			(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			gboolean _tmp229;
			vala_ccode_function_set_block (((ValaCCodeBaseModule*) self)->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_get_body (m))));
			vala_ccode_node_set_line ((ValaCCodeNode*) vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
			cinit = vala_ccode_fragment_new ();
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) cinit);
			if (vala_method_get_coroutine (m)) {
				char* _tmp70;
				char* _tmp69;
				ValaCCodeFunction* _tmp71;
				ValaCCodeFunction* co_function;
				ValaCCodeFormalParameter* _tmp75;
				char* _tmp74;
				char* _tmp73;
				char* _tmp72;
				ValaCCodeFunction* _tmp76;
				ValaCCodeMemberAccess* _tmp78;
				ValaCCodeIdentifier* _tmp77;
				ValaCCodeSwitchStatement* _tmp79;
				ValaCCodeSwitchStatement* cswitch;
				ValaCCodeCaseStatement* _tmp81;
				ValaCCodeConstant* _tmp80;
				ValaCCodeIdentifier* _tmp82;
				ValaCCodeFunctionCall* _tmp83;
				ValaCCodeFunctionCall* object_creation;
				ValaCCodeConstant* _tmp84;
				ValaCCodeConstant* _tmp85;
				ValaCCodeConstant* _tmp86;
				ValaCCodeIdentifier* _tmp87;
				ValaCCodeFunctionCall* _tmp88;
				ValaCCodeFunctionCall* async_result_creation;
				ValaCCodeMemberAccess* _tmp90;
				ValaCCodeIdentifier* _tmp89;
				ValaCCodeMemberAccess* _tmp92;
				ValaCCodeIdentifier* _tmp91;
				ValaCCodeIdentifier* _tmp93;
				ValaCCodeIdentifier* _tmp94;
				ValaCCodeFunctionCall* _tmp95;
				ValaCCodeFunctionCall* completecall;
				ValaCCodeExpressionStatement* _tmp96;
				ValaCCodeReturnStatement* _tmp98;
				ValaCCodeConstant* _tmp97;
				ValaCCodeBlock* _tmp99;
				_tmp70 = NULL;
				_tmp69 = NULL;
				_tmp71 = NULL;
				co_function = (_tmp71 = vala_ccode_function_new (_tmp70 = g_strconcat (_tmp69 = vala_method_get_real_cname (m), "_co", NULL), "gboolean"), _tmp70 = (g_free (_tmp70), NULL), _tmp69 = (g_free (_tmp69), NULL), _tmp71);
				/* data struct to hold parameters, local variables, and the return value*/
				_tmp75 = NULL;
				_tmp74 = NULL;
				_tmp73 = NULL;
				_tmp72 = NULL;
				vala_ccode_function_add_parameter (co_function, _tmp75 = vala_ccode_formal_parameter_new ("data", _tmp74 = g_strconcat (_tmp73 = vala_symbol_lower_case_to_camel_case (_tmp72 = vala_method_get_cname (m)), "Data*", NULL)));
				(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
				_tmp74 = (g_free (_tmp74), NULL);
				_tmp73 = (g_free (_tmp73), NULL);
				_tmp72 = (g_free (_tmp72), NULL);
				vala_ccode_function_set_modifiers (co_function, vala_ccode_function_get_modifiers (co_function) | (VALA_CCODE_MODIFIERS_STATIC));
				_tmp76 = NULL;
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp76 = vala_ccode_function_copy (co_function)));
				(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
				_tmp78 = NULL;
				_tmp77 = NULL;
				_tmp79 = NULL;
				cswitch = (_tmp79 = vala_ccode_switch_statement_new ((ValaCCodeExpression*) (_tmp78 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp77 = vala_ccode_identifier_new ("data")), "state"))), (_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)), (_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)), _tmp79);
				/* initial coroutine state*/
				_tmp81 = NULL;
				_tmp80 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp81 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp80 = vala_ccode_constant_new ("0")))));
				(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
				(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
				/* coroutine body*/
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function));
				/* complete async call by invoking callback*/
				_tmp82 = NULL;
				_tmp83 = NULL;
				object_creation = (_tmp83 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp82 = vala_ccode_identifier_new ("g_object_newv"))), (_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL)), _tmp83);
				_tmp84 = NULL;
				vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp84 = vala_ccode_constant_new ("G_TYPE_OBJECT")));
				(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
				_tmp85 = NULL;
				vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp85 = vala_ccode_constant_new ("0")));
				(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
				_tmp86 = NULL;
				vala_ccode_function_call_add_argument (object_creation, (ValaCCodeExpression*) (_tmp86 = vala_ccode_constant_new ("NULL")));
				(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
				_tmp87 = NULL;
				_tmp88 = NULL;
				async_result_creation = (_tmp88 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp87 = vala_ccode_identifier_new ("g_simple_async_result_new"))), (_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL)), _tmp88);
				vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) object_creation);
				_tmp90 = NULL;
				_tmp89 = NULL;
				vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp90 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp89 = vala_ccode_identifier_new ("data")), "callback")));
				(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
				(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
				_tmp92 = NULL;
				_tmp91 = NULL;
				vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp92 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp91 = vala_ccode_identifier_new ("data")), "user_data")));
				(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
				(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
				_tmp93 = NULL;
				vala_ccode_function_call_add_argument (async_result_creation, (ValaCCodeExpression*) (_tmp93 = vala_ccode_identifier_new ("data")));
				(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
				_tmp94 = NULL;
				_tmp95 = NULL;
				completecall = (_tmp95 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new ("g_simple_async_result_complete"))), (_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)), _tmp95);
				vala_ccode_function_call_add_argument (completecall, (ValaCCodeExpression*) async_result_creation);
				_tmp96 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp96 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) completecall)));
				(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
				_tmp98 = NULL;
				_tmp97 = NULL;
				vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp98 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp97 = vala_ccode_constant_new ("FALSE")))));
				(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
				(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
				_tmp99 = NULL;
				vala_ccode_function_set_block (co_function, _tmp99 = vala_ccode_block_new ());
				(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
				vala_ccode_block_add_statement (vala_ccode_function_get_block (co_function), (ValaCCodeNode*) cswitch);
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) co_function);
				(co_function == NULL) ? NULL : (co_function = (vala_ccode_node_unref (co_function), NULL));
				(cswitch == NULL) ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL));
				(object_creation == NULL) ? NULL : (object_creation = (vala_ccode_node_unref (object_creation), NULL));
				(async_result_creation == NULL) ? NULL : (async_result_creation = (vala_ccode_node_unref (async_result_creation), NULL));
				(completecall == NULL) ? NULL : (completecall = (vala_ccode_node_unref (completecall), NULL));
			}
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
				ValaClass* _tmp100;
				ValaClass* cl;
				gboolean _tmp101;
				_tmp100 = NULL;
				cl = (_tmp100 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp100 == NULL) ? NULL : vala_code_node_ref (_tmp100));
				_tmp101 = FALSE;
				if (vala_method_get_overrides (m)) {
					_tmp101 = TRUE;
				} else {
					gboolean _tmp102;
					gboolean _tmp103;
					_tmp102 = FALSE;
					_tmp103 = FALSE;
					if (vala_method_get_base_interface_method (m) != NULL) {
						_tmp103 = !vala_method_get_is_abstract (m);
					} else {
						_tmp103 = FALSE;
					}
					if (_tmp103) {
						_tmp102 = !vala_method_get_is_virtual (m);
					} else {
						_tmp102 = FALSE;
					}
					_tmp101 = (_tmp102);
				}
				if (_tmp101) {
					ValaMethod* base_method;
					ValaReferenceType* base_expression_type;
					ValaObjectType* self_target_type;
					ValaCCodeIdentifier* _tmp110;
					ValaCCodeExpression* _tmp111;
					ValaCCodeExpression* cself;
					char* _tmp113;
					char* _tmp112;
					ValaCCodeDeclaration* _tmp114;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp115;
					base_method = NULL;
					base_expression_type = NULL;
					if (vala_method_get_overrides (m)) {
						ValaMethod* _tmp105;
						ValaMethod* _tmp104;
						ValaReferenceType* _tmp106;
						_tmp105 = NULL;
						_tmp104 = NULL;
						base_method = (_tmp105 = (_tmp104 = vala_method_get_base_method (m), (_tmp104 == NULL) ? NULL : vala_code_node_ref (_tmp104)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp105);
						_tmp106 = NULL;
						base_expression_type = (_tmp106 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method))), (base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL)), _tmp106);
					} else {
						ValaMethod* _tmp108;
						ValaMethod* _tmp107;
						ValaReferenceType* _tmp109;
						_tmp108 = NULL;
						_tmp107 = NULL;
						base_method = (_tmp108 = (_tmp107 = vala_method_get_base_interface_method (m), (_tmp107 == NULL) ? NULL : vala_code_node_ref (_tmp107)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp108);
						_tmp109 = NULL;
						base_expression_type = (_tmp109 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method))), (base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL)), _tmp109);
					}
					self_target_type = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp110 = NULL;
					_tmp111 = NULL;
					cself = (_tmp111 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp110 = vala_ccode_identifier_new ("base")), (ValaDataType*) base_expression_type, (ValaDataType*) self_target_type, NULL), (_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL)), _tmp111);
					_tmp113 = NULL;
					_tmp112 = NULL;
					_tmp114 = NULL;
					cdecl_ = (_tmp114 = vala_ccode_declaration_new (_tmp113 = g_strdup_printf ("%s *", _tmp112 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp113 = (g_free (_tmp113), NULL), _tmp112 = (g_free (_tmp112), NULL), _tmp114);
					_tmp115 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp115 = vala_ccode_variable_declarator_new ("self", cself)));
					(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
					vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
					(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
					(base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL));
					(self_target_type == NULL) ? NULL : (self_target_type = (vala_code_node_unref (self_target_type), NULL));
					(cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL));
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				} else {
					gboolean _tmp116;
					_tmp116 = FALSE;
					if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
						_tmp116 = !(VALA_IS_CREATION_METHOD (m));
					} else {
						_tmp116 = FALSE;
					}
					if (_tmp116) {
						ValaCCodeStatement* ccheckstmt;
						ccheckstmt = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, (ValaTypeSymbol*) cl, TRUE, "self");
						if (ccheckstmt != NULL) {
							vala_ccode_node_set_line ((ValaCCodeNode*) ccheckstmt, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) ccheckstmt);
						}
						(ccheckstmt == NULL) ? NULL : (ccheckstmt = (vala_ccode_node_unref (ccheckstmt), NULL));
					}
				}
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			}
			{
				GeeList* _tmp117;
				GeeIterator* _tmp118;
				GeeIterator* _param_it;
				_tmp117 = NULL;
				_tmp118 = NULL;
				_param_it = (_tmp118 = gee_iterable_iterator ((GeeIterable*) (_tmp117 = vala_method_get_parameters (m))), (_tmp117 == NULL) ? NULL : (_tmp117 = (gee_collection_object_unref (_tmp117), NULL)), _tmp118);
				while (gee_iterator_next (_param_it)) {
					ValaFormalParameter* param;
					ValaTypeSymbol* _tmp119;
					ValaTypeSymbol* t;
					gboolean _tmp120;
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					if (vala_formal_parameter_get_ellipsis (param)) {
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						break;
					}
					_tmp119 = NULL;
					t = (_tmp119 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)), (_tmp119 == NULL) ? NULL : vala_code_node_ref (_tmp119));
					_tmp120 = FALSE;
					if (t != NULL) {
						_tmp120 = vala_typesymbol_is_reference_type (t);
					} else {
						_tmp120 = FALSE;
					}
					if (_tmp120) {
						if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
							ValaCCodeStatement* type_check;
							type_check = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, t, !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param)), vala_symbol_get_name ((ValaSymbol*) param));
							if (type_check != NULL) {
								vala_ccode_node_set_line ((ValaCCodeNode*) type_check, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) type_check);
							}
							(type_check == NULL) ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL));
						} else {
							ValaCCodeConstant* _tmp123;
							ValaCCodeUnaryExpression* _tmp122;
							ValaCCodeIdentifier* _tmp121;
							ValaCCodeAssignment* _tmp124;
							ValaCCodeAssignment* a;
							ValaCCodeExpressionStatement* _tmp125;
							/* ensure that the passed reference for output parameter is cleared*/
							_tmp123 = NULL;
							_tmp122 = NULL;
							_tmp121 = NULL;
							_tmp124 = NULL;
							a = (_tmp124 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp122 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp121 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))), (ValaCCodeExpression*) (_tmp123 = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)), (_tmp122 == NULL) ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL)), (_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL)), _tmp124);
							_tmp125 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp125 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) a)));
							(_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL));
							(a == NULL) ? NULL : (a = (vala_ccode_node_unref (a), NULL));
						}
					}
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
				}
				(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
			}
			if (inner_error) {
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				if (vala_method_get_coroutine (m)) {
					vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "GError *", "inner_error");
				} else {
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp127;
					ValaCCodeConstant* _tmp126;
					/* no initialization necessary, closure struct is zeroed*/
					cdecl_ = vala_ccode_declaration_new ("GError *");
					_tmp127 = NULL;
					_tmp126 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp127 = vala_ccode_variable_declarator_new ("inner_error", (ValaCCodeExpression*) (_tmp126 = vala_ccode_constant_new ("NULL")))));
					(_tmp127 == NULL) ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL));
					(_tmp126 == NULL) ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL));
					vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				}
			}
			if (!vala_method_get_coroutine (m)) {
				gboolean _tmp128;
				_tmp128 = FALSE;
				if (vala_code_node_get_source_reference ((ValaCodeNode*) m) != NULL) {
					_tmp128 = vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)) != NULL;
				} else {
					_tmp128 = FALSE;
				}
				if (_tmp128) {
					ValaCCodeComment* _tmp129;
					_tmp129 = NULL;
					vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp129 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)))));
					(_tmp129 == NULL) ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL));
				}
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
			}
			if (VALA_IS_CREATION_METHOD (m)) {
				if (in_gobject_creation_method) {
					gint n_params;
					gboolean _tmp130;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					_tmp130 = FALSE;
					if (n_params > 0) {
						_tmp130 = TRUE;
					} else {
						GeeList* _tmp131;
						_tmp131 = NULL;
						_tmp130 = gee_collection_get_size ((GeeCollection*) (_tmp131 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))) > 0;
						(_tmp131 == NULL) ? NULL : (_tmp131 = (gee_collection_object_unref (_tmp131), NULL));
					}
					if (_tmp130) {
						ValaCCodeIdentifier* _tmp132;
						ValaCCodeFunctionCall* _tmp133;
						ValaCCodeFunctionCall* cparamsinit;
						ValaCCodeIdentifier* _tmp134;
						ValaCCodeConstant* _tmp137;
						char* _tmp136;
						GeeList* _tmp135;
						ValaCCodeDeclaration* cdecl_;
						ValaCCodeVariableDeclarator* _tmp138;
						ValaCCodeDeclaration* _tmp139;
						ValaCCodeVariableDeclarator* _tmp141;
						ValaCCodeIdentifier* _tmp140;
						/* declare construction parameter array*/
						_tmp132 = NULL;
						_tmp133 = NULL;
						cparamsinit = (_tmp133 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp132 = vala_ccode_identifier_new ("g_new0"))), (_tmp132 == NULL) ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL)), _tmp133);
						_tmp134 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, (ValaCCodeExpression*) (_tmp134 = vala_ccode_identifier_new ("GParameter")));
						(_tmp134 == NULL) ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL));
						_tmp137 = NULL;
						_tmp136 = NULL;
						_tmp135 = NULL;
						vala_ccode_function_call_add_argument (cparamsinit, (ValaCCodeExpression*) (_tmp137 = vala_ccode_constant_new (_tmp136 = g_strdup_printf ("%i", (n_params + (3 * gee_collection_get_size ((GeeCollection*) (_tmp135 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class)))))))));
						(_tmp137 == NULL) ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL));
						_tmp136 = (g_free (_tmp136), NULL);
						(_tmp135 == NULL) ? NULL : (_tmp135 = (gee_collection_object_unref (_tmp135), NULL));
						cdecl_ = vala_ccode_declaration_new ("GParameter *");
						_tmp138 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp138 = vala_ccode_variable_declarator_new ("__params", (ValaCCodeExpression*) cparamsinit)));
						(_tmp138 == NULL) ? NULL : (_tmp138 = (vala_ccode_node_unref (_tmp138), NULL));
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
						_tmp139 = NULL;
						cdecl_ = (_tmp139 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp139);
						_tmp141 = NULL;
						_tmp140 = NULL;
						vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp141 = vala_ccode_variable_declarator_new ("__params_it", (ValaCCodeExpression*) (_tmp140 = vala_ccode_identifier_new ("__params")))));
						(_tmp141 == NULL) ? NULL : (_tmp141 = (vala_ccode_node_unref (_tmp141), NULL));
						(_tmp140 == NULL) ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL));
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
						(cparamsinit == NULL) ? NULL : (cparamsinit = (vala_ccode_node_unref (cparamsinit), NULL));
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					}
					/* type, dup func, and destroy func properties for generic types */
					{
						GeeList* _tmp142;
						GeeIterator* _tmp143;
						GeeIterator* _type_param_it;
						/* type, dup func, and destroy func properties for generic types */
						_tmp142 = NULL;
						_tmp143 = NULL;
						_type_param_it = (_tmp143 = gee_iterable_iterator ((GeeIterable*) (_tmp142 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))), (_tmp142 == NULL) ? NULL : (_tmp142 = (gee_collection_object_unref (_tmp142), NULL)), _tmp143);
						/* type, dup func, and destroy func properties for generic types */
						while (gee_iterator_next (_type_param_it)) {
							ValaTypeParameter* type_param;
							ValaCCodeConstant* prop_name;
							ValaCCodeIdentifier* param_name;
							ValaCCodeConstant* _tmp146;
							char* _tmp145;
							char* _tmp144;
							ValaCCodeIdentifier* _tmp149;
							char* _tmp148;
							char* _tmp147;
							ValaCCodeExpressionStatement* _tmp152;
							ValaCCodeExpression* _tmp151;
							ValaIntegerType* _tmp150;
							ValaCCodeConstant* _tmp155;
							char* _tmp154;
							char* _tmp153;
							ValaCCodeIdentifier* _tmp158;
							char* _tmp157;
							char* _tmp156;
							ValaCCodeExpressionStatement* _tmp162;
							ValaCCodeExpression* _tmp161;
							ValaPointerType* _tmp160;
							ValaVoidType* _tmp159;
							ValaCCodeConstant* _tmp165;
							char* _tmp164;
							char* _tmp163;
							ValaCCodeIdentifier* _tmp168;
							char* _tmp167;
							char* _tmp166;
							ValaCCodeExpressionStatement* _tmp172;
							ValaCCodeExpression* _tmp171;
							ValaPointerType* _tmp170;
							ValaVoidType* _tmp169;
							/* type, dup func, and destroy func properties for generic types */
							type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
							prop_name = NULL;
							param_name = NULL;
							_tmp146 = NULL;
							_tmp145 = NULL;
							_tmp144 = NULL;
							prop_name = (_tmp146 = vala_ccode_constant_new (_tmp145 = g_strdup_printf ("\"%s-type\"", _tmp144 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)), _tmp146);
							_tmp145 = (g_free (_tmp145), NULL);
							_tmp144 = (g_free (_tmp144), NULL);
							_tmp149 = NULL;
							_tmp148 = NULL;
							_tmp147 = NULL;
							param_name = (_tmp149 = vala_ccode_identifier_new (_tmp148 = g_strdup_printf ("%s_type", _tmp147 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp149);
							_tmp148 = (g_free (_tmp148), NULL);
							_tmp147 = (g_free (_tmp147), NULL);
							_tmp152 = NULL;
							_tmp151 = NULL;
							_tmp150 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp152 = vala_ccode_expression_statement_new (_tmp151 = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp150 = vala_integer_type_new (VALA_STRUCT (((ValaCCodeBaseModule*) self)->gtype_type), NULL, NULL)), (ValaCCodeExpression*) param_name))));
							(_tmp152 == NULL) ? NULL : (_tmp152 = (vala_ccode_node_unref (_tmp152), NULL));
							(_tmp151 == NULL) ? NULL : (_tmp151 = (vala_ccode_node_unref (_tmp151), NULL));
							(_tmp150 == NULL) ? NULL : (_tmp150 = (vala_code_node_unref (_tmp150), NULL));
							_tmp155 = NULL;
							_tmp154 = NULL;
							_tmp153 = NULL;
							prop_name = (_tmp155 = vala_ccode_constant_new (_tmp154 = g_strdup_printf ("\"%s-dup-func\"", _tmp153 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)), _tmp155);
							_tmp154 = (g_free (_tmp154), NULL);
							_tmp153 = (g_free (_tmp153), NULL);
							_tmp158 = NULL;
							_tmp157 = NULL;
							_tmp156 = NULL;
							param_name = (_tmp158 = vala_ccode_identifier_new (_tmp157 = g_strdup_printf ("%s_dup_func", _tmp156 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp158);
							_tmp157 = (g_free (_tmp157), NULL);
							_tmp156 = (g_free (_tmp156), NULL);
							_tmp162 = NULL;
							_tmp161 = NULL;
							_tmp160 = NULL;
							_tmp159 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp162 = vala_ccode_expression_statement_new (_tmp161 = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp160 = vala_pointer_type_new ((ValaDataType*) (_tmp159 = vala_void_type_new (NULL)), NULL)), (ValaCCodeExpression*) param_name))));
							(_tmp162 == NULL) ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL));
							(_tmp161 == NULL) ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL));
							(_tmp160 == NULL) ? NULL : (_tmp160 = (vala_code_node_unref (_tmp160), NULL));
							(_tmp159 == NULL) ? NULL : (_tmp159 = (vala_code_node_unref (_tmp159), NULL));
							_tmp165 = NULL;
							_tmp164 = NULL;
							_tmp163 = NULL;
							prop_name = (_tmp165 = vala_ccode_constant_new (_tmp164 = g_strdup_printf ("\"%s-destroy-func\"", _tmp163 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL)), _tmp165);
							_tmp164 = (g_free (_tmp164), NULL);
							_tmp163 = (g_free (_tmp163), NULL);
							_tmp168 = NULL;
							_tmp167 = NULL;
							_tmp166 = NULL;
							param_name = (_tmp168 = vala_ccode_identifier_new (_tmp167 = g_strdup_printf ("%s_destroy_func", _tmp166 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp168);
							_tmp167 = (g_free (_tmp167), NULL);
							_tmp166 = (g_free (_tmp166), NULL);
							_tmp172 = NULL;
							_tmp171 = NULL;
							_tmp170 = NULL;
							_tmp169 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp172 = vala_ccode_expression_statement_new (_tmp171 = vala_ccode_module_get_construct_property_assignment ((ValaCCodeModule*) self, prop_name, (ValaDataType*) (_tmp170 = vala_pointer_type_new ((ValaDataType*) (_tmp169 = vala_void_type_new (NULL)), NULL)), (ValaCCodeExpression*) param_name))));
							(_tmp172 == NULL) ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL));
							(_tmp171 == NULL) ? NULL : (_tmp171 = (vala_ccode_node_unref (_tmp171), NULL));
							(_tmp170 == NULL) ? NULL : (_tmp170 = (vala_code_node_unref (_tmp170), NULL));
							(_tmp169 == NULL) ? NULL : (_tmp169 = (vala_code_node_unref (_tmp169), NULL));
							(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
							(prop_name == NULL) ? NULL : (prop_name = (vala_ccode_node_unref (prop_name), NULL));
							(param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL));
						}
						(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
					}
				} else {
					if (in_gtypeinstance_creation_method) {
						ValaClass* _tmp173;
						ValaClass* cl;
						char* _tmp175;
						char* _tmp174;
						ValaCCodeDeclaration* _tmp176;
						ValaCCodeDeclaration* cdeclaration;
						ValaCCodeVariableDeclarator* cdecl_;
						_tmp173 = NULL;
						cl = (_tmp173 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp173 == NULL) ? NULL : vala_code_node_ref (_tmp173));
						_tmp175 = NULL;
						_tmp174 = NULL;
						_tmp176 = NULL;
						cdeclaration = (_tmp176 = vala_ccode_declaration_new (_tmp175 = g_strconcat (_tmp174 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp175 = (g_free (_tmp175), NULL), _tmp174 = (g_free (_tmp174), NULL), _tmp176);
						cdecl_ = vala_ccode_variable_declarator_new ("self", NULL);
						vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) cdecl_);
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdeclaration);
						if (!vala_creation_method_get_chain_up ((VALA_CREATION_METHOD (m)))) {
							ValaCCodeIdentifier* _tmp177;
							ValaCCodeFunctionCall* _tmp178;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp179;
							ValaCCodeCastExpression* _tmp182;
							char* _tmp181;
							char* _tmp180;
							/* TODO implicitly chain up to base class as in add_object_creation*/
							_tmp177 = NULL;
							_tmp178 = NULL;
							ccall = (_tmp178 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp177 = vala_ccode_identifier_new ("g_type_create_instance"))), (_tmp177 == NULL) ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL)), _tmp178);
							_tmp179 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp179 = vala_ccode_identifier_new ("object_type")));
							(_tmp179 == NULL) ? NULL : (_tmp179 = (vala_ccode_node_unref (_tmp179), NULL));
							_tmp182 = NULL;
							_tmp181 = NULL;
							_tmp180 = NULL;
							vala_ccode_variable_declarator_set_initializer (cdecl_, (ValaCCodeExpression*) (_tmp182 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp181 = g_strconcat (_tmp180 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL))));
							(_tmp182 == NULL) ? NULL : (_tmp182 = (vala_ccode_node_unref (_tmp182), NULL));
							_tmp181 = (g_free (_tmp181), NULL);
							_tmp180 = (g_free (_tmp180), NULL);
							(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
						}
						/* type, dup func, and destroy func fields for generic types */
						{
							GeeList* _tmp183;
							GeeIterator* _tmp184;
							GeeIterator* _type_param_it;
							/* type, dup func, and destroy func fields for generic types */
							_tmp183 = NULL;
							_tmp184 = NULL;
							_type_param_it = (_tmp184 = gee_iterable_iterator ((GeeIterable*) (_tmp183 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))), (_tmp183 == NULL) ? NULL : (_tmp183 = (gee_collection_object_unref (_tmp183), NULL)), _tmp184);
							/* type, dup func, and destroy func fields for generic types */
							while (gee_iterator_next (_type_param_it)) {
								ValaTypeParameter* type_param;
								ValaCCodeIdentifier* param_name;
								ValaCCodeAssignment* assign;
								ValaCCodeIdentifier* _tmp185;
								ValaCCodeMemberAccess* _tmp186;
								ValaCCodeMemberAccess* priv_access;
								ValaCCodeIdentifier* _tmp189;
								char* _tmp188;
								char* _tmp187;
								ValaCCodeAssignment* _tmp191;
								ValaCCodeMemberAccess* _tmp190;
								ValaCCodeExpressionStatement* _tmp192;
								ValaCCodeIdentifier* _tmp195;
								char* _tmp194;
								char* _tmp193;
								ValaCCodeAssignment* _tmp197;
								ValaCCodeMemberAccess* _tmp196;
								ValaCCodeExpressionStatement* _tmp198;
								ValaCCodeIdentifier* _tmp201;
								char* _tmp200;
								char* _tmp199;
								ValaCCodeAssignment* _tmp203;
								ValaCCodeMemberAccess* _tmp202;
								ValaCCodeExpressionStatement* _tmp204;
								/* type, dup func, and destroy func fields for generic types */
								type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
								param_name = NULL;
								assign = NULL;
								_tmp185 = NULL;
								_tmp186 = NULL;
								priv_access = (_tmp186 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp185 = vala_ccode_identifier_new ("self")), "priv"), (_tmp185 == NULL) ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL)), _tmp186);
								_tmp189 = NULL;
								_tmp188 = NULL;
								_tmp187 = NULL;
								param_name = (_tmp189 = vala_ccode_identifier_new (_tmp188 = g_strdup_printf ("%s_type", _tmp187 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp189);
								_tmp188 = (g_free (_tmp188), NULL);
								_tmp187 = (g_free (_tmp187), NULL);
								_tmp191 = NULL;
								_tmp190 = NULL;
								assign = (_tmp191 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp190 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)), _tmp191);
								(_tmp190 == NULL) ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL));
								_tmp192 = NULL;
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp192 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
								(_tmp192 == NULL) ? NULL : (_tmp192 = (vala_ccode_node_unref (_tmp192), NULL));
								_tmp195 = NULL;
								_tmp194 = NULL;
								_tmp193 = NULL;
								param_name = (_tmp195 = vala_ccode_identifier_new (_tmp194 = g_strdup_printf ("%s_dup_func", _tmp193 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp195);
								_tmp194 = (g_free (_tmp194), NULL);
								_tmp193 = (g_free (_tmp193), NULL);
								_tmp197 = NULL;
								_tmp196 = NULL;
								assign = (_tmp197 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp196 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)), _tmp197);
								(_tmp196 == NULL) ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL));
								_tmp198 = NULL;
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp198 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
								(_tmp198 == NULL) ? NULL : (_tmp198 = (vala_ccode_node_unref (_tmp198), NULL));
								_tmp201 = NULL;
								_tmp200 = NULL;
								_tmp199 = NULL;
								param_name = (_tmp201 = vala_ccode_identifier_new (_tmp200 = g_strdup_printf ("%s_destroy_func", _tmp199 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL)), _tmp201);
								_tmp200 = (g_free (_tmp200), NULL);
								_tmp199 = (g_free (_tmp199), NULL);
								_tmp203 = NULL;
								_tmp202 = NULL;
								assign = (_tmp203 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp202 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) priv_access, vala_ccode_identifier_get_name (param_name))), (ValaCCodeExpression*) param_name, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)), _tmp203);
								(_tmp202 == NULL) ? NULL : (_tmp202 = (vala_ccode_node_unref (_tmp202), NULL));
								_tmp204 = NULL;
								vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp204 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
								(_tmp204 == NULL) ? NULL : (_tmp204 = (vala_ccode_node_unref (_tmp204), NULL));
								(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
								(param_name == NULL) ? NULL : (param_name = (vala_ccode_node_unref (param_name), NULL));
								(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
								(priv_access == NULL) ? NULL : (priv_access = (vala_ccode_node_unref (priv_access), NULL));
							}
							(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
						}
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(cdeclaration == NULL) ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL));
						(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
					} else {
						if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
							ValaClass* _tmp205;
							ValaClass* cl;
							char* _tmp207;
							char* _tmp206;
							ValaCCodeDeclaration* _tmp208;
							ValaCCodeDeclaration* cdecl_;
							ValaCCodeIdentifier* _tmp209;
							ValaCCodeFunctionCall* _tmp210;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeIdentifier* _tmp212;
							char* _tmp211;
							ValaCCodeVariableDeclarator* _tmp213;
							ValaCCodeIdentifier* _tmp216;
							char* _tmp215;
							char* _tmp214;
							ValaCCodeFunctionCall* _tmp217;
							ValaCCodeFunctionCall* cinitcall;
							ValaCCodeIdentifier* _tmp218;
							ValaCCodeExpressionStatement* _tmp219;
							_tmp205 = NULL;
							cl = (_tmp205 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp205 == NULL) ? NULL : vala_code_node_ref (_tmp205));
							_tmp207 = NULL;
							_tmp206 = NULL;
							_tmp208 = NULL;
							cdecl_ = (_tmp208 = vala_ccode_declaration_new (_tmp207 = g_strconcat (_tmp206 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp207 = (g_free (_tmp207), NULL), _tmp206 = (g_free (_tmp206), NULL), _tmp208);
							_tmp209 = NULL;
							_tmp210 = NULL;
							ccall = (_tmp210 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp209 = vala_ccode_identifier_new ("g_slice_new0"))), (_tmp209 == NULL) ? NULL : (_tmp209 = (vala_ccode_node_unref (_tmp209), NULL)), _tmp210);
							_tmp212 = NULL;
							_tmp211 = NULL;
							vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp212 = vala_ccode_identifier_new (_tmp211 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
							(_tmp212 == NULL) ? NULL : (_tmp212 = (vala_ccode_node_unref (_tmp212), NULL));
							_tmp211 = (g_free (_tmp211), NULL);
							_tmp213 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp213 = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) ccall)));
							(_tmp213 == NULL) ? NULL : (_tmp213 = (vala_ccode_node_unref (_tmp213), NULL));
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) cdecl_);
							_tmp216 = NULL;
							_tmp215 = NULL;
							_tmp214 = NULL;
							_tmp217 = NULL;
							cinitcall = (_tmp217 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp216 = vala_ccode_identifier_new (_tmp215 = g_strdup_printf ("%s_instance_init", _tmp214 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL))))), (_tmp216 == NULL) ? NULL : (_tmp216 = (vala_ccode_node_unref (_tmp216), NULL)), _tmp215 = (g_free (_tmp215), NULL), _tmp214 = (g_free (_tmp214), NULL), _tmp217);
							_tmp218 = NULL;
							vala_ccode_function_call_add_argument (cinitcall, (ValaCCodeExpression*) (_tmp218 = vala_ccode_identifier_new ("self")));
							(_tmp218 == NULL) ? NULL : (_tmp218 = (vala_ccode_node_unref (_tmp218), NULL));
							_tmp219 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp219 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinitcall)));
							(_tmp219 == NULL) ? NULL : (_tmp219 = (vala_ccode_node_unref (_tmp219), NULL));
							(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
							(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
							(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
							(cinitcall == NULL) ? NULL : (cinitcall = (vala_ccode_node_unref (cinitcall), NULL));
						} else {
							ValaStruct* _tmp220;
							ValaStruct* st;
							ValaCCodeIdentifier* _tmp221;
							ValaCCodeFunctionCall* _tmp222;
							ValaCCodeFunctionCall* czero;
							ValaCCodeIdentifier* _tmp223;
							ValaCCodeConstant* _tmp224;
							ValaCCodeIdentifier* _tmp227;
							char* _tmp226;
							char* _tmp225;
							ValaCCodeExpressionStatement* _tmp228;
							_tmp220 = NULL;
							st = (_tmp220 = VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp220 == NULL) ? NULL : vala_code_node_ref (_tmp220));
							/* memset needs string.h*/
							((ValaCCodeBaseModule*) self)->string_h_needed = TRUE;
							_tmp221 = NULL;
							_tmp222 = NULL;
							czero = (_tmp222 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp221 = vala_ccode_identifier_new ("memset"))), (_tmp221 == NULL) ? NULL : (_tmp221 = (vala_ccode_node_unref (_tmp221), NULL)), _tmp222);
							_tmp223 = NULL;
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp223 = vala_ccode_identifier_new ("self")));
							(_tmp223 == NULL) ? NULL : (_tmp223 = (vala_ccode_node_unref (_tmp223), NULL));
							_tmp224 = NULL;
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp224 = vala_ccode_constant_new ("0")));
							(_tmp224 == NULL) ? NULL : (_tmp224 = (vala_ccode_node_unref (_tmp224), NULL));
							_tmp227 = NULL;
							_tmp226 = NULL;
							_tmp225 = NULL;
							vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp227 = vala_ccode_identifier_new (_tmp226 = g_strdup_printf ("sizeof (%s)", _tmp225 = vala_typesymbol_get_cname ((ValaTypeSymbol*) st, FALSE)))));
							(_tmp227 == NULL) ? NULL : (_tmp227 = (vala_ccode_node_unref (_tmp227), NULL));
							_tmp226 = (g_free (_tmp226), NULL);
							_tmp225 = (g_free (_tmp225), NULL);
							_tmp228 = NULL;
							vala_ccode_fragment_append (cinit, (ValaCCodeNode*) (_tmp228 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) czero)));
							(_tmp228 == NULL) ? NULL : (_tmp228 = (vala_ccode_node_unref (_tmp228), NULL));
							(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
							(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
						}
					}
				}
			}
			_tmp229 = FALSE;
			if (vala_code_context_get_module_init_method (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self)) == m) {
				_tmp229 = ((ValaCCodeBaseModule*) self)->in_plugin;
			} else {
				_tmp229 = FALSE;
			}
			if (_tmp229) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->module_init_fragment);
			}
			{
				GeeList* _tmp230;
				GeeIterator* _tmp231;
				GeeIterator* _precondition_it;
				_tmp230 = NULL;
				_tmp231 = NULL;
				_precondition_it = (_tmp231 = gee_iterable_iterator ((GeeIterable*) (_tmp230 = vala_method_get_preconditions (m))), (_tmp230 == NULL) ? NULL : (_tmp230 = (gee_collection_object_unref (_tmp230), NULL)), _tmp231);
				while (gee_iterator_next (_precondition_it)) {
					ValaExpression* precondition;
					ValaCCodeStatement* check_stmt;
					precondition = (ValaExpression*) gee_iterator_get (_precondition_it);
					check_stmt = vala_ccode_method_module_create_precondition_statement (self, (ValaCodeNode*) m, creturn_type, precondition);
					if (check_stmt != NULL) {
						vala_ccode_fragment_append (cinit, (ValaCCodeNode*) check_stmt);
					}
					(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
					(check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL));
				}
				(_precondition_it == NULL) ? NULL : (_precondition_it = (gee_collection_object_unref (_precondition_it), NULL));
			}
			(cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL));
		} else {
			if (vala_method_get_is_abstract (m)) {
				ValaCCodeBlock* cblock;
				ValaCCodeStatement* check_stmt;
				ValaCCodeIdentifier* _tmp232;
				ValaCCodeFunctionCall* _tmp233;
				ValaCCodeFunctionCall* type_from_instance_call;
				ValaCCodeIdentifier* _tmp234;
				ValaCCodeIdentifier* _tmp235;
				ValaCCodeFunctionCall* _tmp236;
				ValaCCodeFunctionCall* type_name_call;
				char* _tmp237;
				char* _tmp238;
				char* error_string;
				ValaCCodeIdentifier* _tmp239;
				ValaCCodeFunctionCall* _tmp240;
				ValaCCodeFunctionCall* cerrorcall;
				ValaCCodeConstant* _tmp241;
				ValaCCodeExpressionStatement* _tmp242;
				ValaCCodeReturnStatement* _tmp244;
				ValaCCodeExpression* _tmp243;
				/* generate helpful error message if a sublcass does not implement an abstract method.
				 This is only meaningful for subclasses implemented in C since the vala compiler would
				 complain during compile time of such en error.*/
				cblock = vala_ccode_block_new ();
				/* add a typecheck statement for "self"*/
				check_stmt = vala_ccode_method_module_create_method_type_check_statement (self, m, creturn_type, ((ValaCCodeBaseModule*) self)->current_type_symbol, TRUE, "self");
				if (check_stmt != NULL) {
					vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) check_stmt);
				}
				/* add critical warning that this method should not have been called*/
				_tmp232 = NULL;
				_tmp233 = NULL;
				type_from_instance_call = (_tmp233 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp232 = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE"))), (_tmp232 == NULL) ? NULL : (_tmp232 = (vala_ccode_node_unref (_tmp232), NULL)), _tmp233);
				_tmp234 = NULL;
				vala_ccode_function_call_add_argument (type_from_instance_call, (ValaCCodeExpression*) (_tmp234 = vala_ccode_identifier_new ("self")));
				(_tmp234 == NULL) ? NULL : (_tmp234 = (vala_ccode_node_unref (_tmp234), NULL));
				_tmp235 = NULL;
				_tmp236 = NULL;
				type_name_call = (_tmp236 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp235 = vala_ccode_identifier_new ("g_type_name"))), (_tmp235 == NULL) ? NULL : (_tmp235 = (vala_ccode_node_unref (_tmp235), NULL)), _tmp236);
				vala_ccode_function_call_add_argument (type_name_call, (ValaCCodeExpression*) type_from_instance_call);
				_tmp237 = NULL;
				_tmp238 = NULL;
				error_string = (_tmp238 = g_strdup_printf ("\"Type `%%s' does not implement abstract method `%s'\"", _tmp237 = vala_method_get_cname (m)), _tmp237 = (g_free (_tmp237), NULL), _tmp238);
				_tmp239 = NULL;
				_tmp240 = NULL;
				cerrorcall = (_tmp240 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp239 = vala_ccode_identifier_new ("g_critical"))), (_tmp239 == NULL) ? NULL : (_tmp239 = (vala_ccode_node_unref (_tmp239), NULL)), _tmp240);
				_tmp241 = NULL;
				vala_ccode_function_call_add_argument (cerrorcall, (ValaCCodeExpression*) (_tmp241 = vala_ccode_constant_new (error_string)));
				(_tmp241 == NULL) ? NULL : (_tmp241 = (vala_ccode_node_unref (_tmp241), NULL));
				vala_ccode_function_call_add_argument (cerrorcall, (ValaCCodeExpression*) type_name_call);
				_tmp242 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp242 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cerrorcall)));
				(_tmp242 == NULL) ? NULL : (_tmp242 = (vala_ccode_node_unref (_tmp242), NULL));
				/* add return statement*/
				_tmp244 = NULL;
				_tmp243 = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp244 = vala_ccode_return_statement_new (_tmp243 = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, creturn_type, FALSE))));
				(_tmp244 == NULL) ? NULL : (_tmp244 = (vala_ccode_node_unref (_tmp244), NULL));
				(_tmp243 == NULL) ? NULL : (_tmp243 = (vala_ccode_node_unref (_tmp243), NULL));
				vala_ccode_function_set_block (((ValaCCodeBaseModule*) self)->function, cblock);
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
				(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
				(check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL));
				(type_from_instance_call == NULL) ? NULL : (type_from_instance_call = (vala_ccode_node_unref (type_from_instance_call), NULL));
				(type_name_call == NULL) ? NULL : (type_name_call = (vala_ccode_node_unref (type_name_call), NULL));
				error_string = (g_free (error_string), NULL);
				(cerrorcall == NULL) ? NULL : (cerrorcall = (vala_ccode_node_unref (cerrorcall), NULL));
			}
		}
	}
	_tmp245 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp245 = TRUE;
	} else {
		_tmp245 = vala_method_get_is_virtual (m);
	}
	if (_tmp245) {
		GeeHashMap* _tmp246;
		GeeHashMap* carg_map;
		_tmp246 = NULL;
		cparam_map = (_tmp246 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), _tmp246);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		vala_ccode_method_module_generate_vfunc (self, m, creturn_type, (GeeMap*) cparam_map, (GeeMap*) carg_map, "", 3);
		(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	}
	if (vala_method_get_entry_point (m)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* _tmp247;
		ValaCCodeFormalParameter* _tmp248;
		ValaCCodeBlock* main_block;
		ValaCCodeFunctionCall* _tmp254;
		ValaCCodeIdentifier* _tmp253;
		ValaCCodeExpressionStatement* _tmp255;
		ValaCCodeExpressionStatement* type_init_call;
		ValaCCodeIdentifier* _tmp256;
		ValaCCodeFunctionCall* _tmp257;
		ValaCCodeFunctionCall* main_call;
		GeeList* _tmp258;
		gboolean _tmp259;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		vala_ccode_node_set_line ((ValaCCodeNode*) cmain, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
		_tmp247 = NULL;
		vala_ccode_function_add_parameter (cmain, _tmp247 = vala_ccode_formal_parameter_new ("argc", "int"));
		(_tmp247 == NULL) ? NULL : (_tmp247 = (vala_ccode_node_unref (_tmp247), NULL));
		_tmp248 = NULL;
		vala_ccode_function_add_parameter (cmain, _tmp248 = vala_ccode_formal_parameter_new ("argv", "char **"));
		(_tmp248 == NULL) ? NULL : (_tmp248 = (vala_ccode_node_unref (_tmp248), NULL));
		main_block = vala_ccode_block_new ();
		if (vala_code_context_get_thread (vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self))) {
			ValaCCodeIdentifier* _tmp249;
			ValaCCodeFunctionCall* _tmp250;
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* _tmp251;
			ValaCCodeExpressionStatement* _tmp252;
			_tmp249 = NULL;
			_tmp250 = NULL;
			thread_init_call = (_tmp250 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp249 = vala_ccode_identifier_new ("g_thread_init"))), (_tmp249 == NULL) ? NULL : (_tmp249 = (vala_ccode_node_unref (_tmp249), NULL)), _tmp250);
			vala_ccode_node_set_line ((ValaCCodeNode*) thread_init_call, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			_tmp251 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, (ValaCCodeExpression*) (_tmp251 = vala_ccode_constant_new ("NULL")));
			(_tmp251 == NULL) ? NULL : (_tmp251 = (vala_ccode_node_unref (_tmp251), NULL));
			_tmp252 = NULL;
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) (_tmp252 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) thread_init_call)));
			(_tmp252 == NULL) ? NULL : (_tmp252 = (vala_ccode_node_unref (_tmp252), NULL));
			(thread_init_call == NULL) ? NULL : (thread_init_call = (vala_ccode_node_unref (thread_init_call), NULL));
		}
		_tmp254 = NULL;
		_tmp253 = NULL;
		_tmp255 = NULL;
		type_init_call = (_tmp255 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp254 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp253 = vala_ccode_identifier_new ("g_type_init"))))), (_tmp254 == NULL) ? NULL : (_tmp254 = (vala_ccode_node_unref (_tmp254), NULL)), (_tmp253 == NULL) ? NULL : (_tmp253 = (vala_ccode_node_unref (_tmp253), NULL)), _tmp255);
		vala_ccode_node_set_line ((ValaCCodeNode*) type_init_call, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
		vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) type_init_call);
		_tmp256 = NULL;
		_tmp257 = NULL;
		main_call = (_tmp257 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp256 = vala_ccode_identifier_new (vala_ccode_function_get_name (((ValaCCodeBaseModule*) self)->function)))), (_tmp256 == NULL) ? NULL : (_tmp256 = (vala_ccode_node_unref (_tmp256), NULL)), _tmp257);
		_tmp258 = NULL;
		if ((_tmp259 = gee_collection_get_size ((GeeCollection*) (_tmp258 = vala_method_get_parameters (m))) == 1, (_tmp258 == NULL) ? NULL : (_tmp258 = (gee_collection_object_unref (_tmp258), NULL)), _tmp259)) {
			ValaCCodeIdentifier* _tmp260;
			ValaCCodeIdentifier* _tmp261;
			_tmp260 = NULL;
			vala_ccode_function_call_add_argument (main_call, (ValaCCodeExpression*) (_tmp260 = vala_ccode_identifier_new ("argv")));
			(_tmp260 == NULL) ? NULL : (_tmp260 = (vala_ccode_node_unref (_tmp260), NULL));
			_tmp261 = NULL;
			vala_ccode_function_call_add_argument (main_call, (ValaCCodeExpression*) (_tmp261 = vala_ccode_identifier_new ("argc")));
			(_tmp261 == NULL) ? NULL : (_tmp261 = (vala_ccode_node_unref (_tmp261), NULL));
		}
		if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
			ValaCCodeExpressionStatement* main_stmt;
			ValaCCodeConstant* _tmp262;
			ValaCCodeReturnStatement* _tmp263;
			ValaCCodeReturnStatement* ret_stmt;
			/* method returns void, always use 0 as exit code*/
			main_stmt = vala_ccode_expression_statement_new ((ValaCCodeExpression*) main_call);
			vala_ccode_node_set_line ((ValaCCodeNode*) main_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) main_stmt);
			_tmp262 = NULL;
			_tmp263 = NULL;
			ret_stmt = (_tmp263 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp262 = vala_ccode_constant_new ("0"))), (_tmp262 == NULL) ? NULL : (_tmp262 = (vala_ccode_node_unref (_tmp262), NULL)), _tmp263);
			vala_ccode_node_set_line ((ValaCCodeNode*) ret_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) ret_stmt);
			(main_stmt == NULL) ? NULL : (main_stmt = (vala_ccode_node_unref (main_stmt), NULL));
			(ret_stmt == NULL) ? NULL : (ret_stmt = (vala_ccode_node_unref (ret_stmt), NULL));
		} else {
			ValaCCodeReturnStatement* main_stmt;
			main_stmt = vala_ccode_return_statement_new ((ValaCCodeExpression*) main_call);
			vala_ccode_node_set_line ((ValaCCodeNode*) main_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) cmain));
			vala_ccode_block_add_statement (main_block, (ValaCCodeNode*) main_stmt);
			(main_stmt == NULL) ? NULL : (main_stmt = (vala_ccode_node_unref (main_stmt), NULL));
		}
		vala_ccode_function_set_block (cmain, main_block);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cmain);
		(cmain == NULL) ? NULL : (cmain = (vala_ccode_node_unref (cmain), NULL));
		(main_block == NULL) ? NULL : (main_block = (vala_ccode_node_unref (main_block), NULL));
		(type_init_call == NULL) ? NULL : (type_init_call = (vala_ccode_node_unref (type_init_call), NULL));
		(main_call == NULL) ? NULL : (main_call = (vala_ccode_node_unref (main_call), NULL));
	}
	(old_type_symbol == NULL) ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL));
	(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
	(old_method == NULL) ? NULL : (old_method = (vala_code_node_unref (old_method), NULL));
	(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
	(old_variable_name_map == NULL) ? NULL : (old_variable_name_map = (gee_collection_object_unref (old_variable_name_map), NULL));
	(old_try == NULL) ? NULL : (old_try = (vala_code_node_unref (old_try), NULL));
	(creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
}


static void vala_ccode_method_module_real_generate_cparameters (ValaCCodeModule* base, ValaMethod* m, ValaDataType* creturn_type, gboolean in_gtypeinstance_creation_method, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction) {
	ValaCCodeMethodModule * self;
	gboolean _tmp0;
	gint last_pos;
	gint min_pos;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	g_return_if_fail (creturn_type != NULL);
	g_return_if_fail (cparam_map != NULL);
	g_return_if_fail (func != NULL);
	_tmp0 = FALSE;
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
		_tmp0 = VALA_IS_CREATION_METHOD (m);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaClass* _tmp1;
		ValaClass* cl;
		gboolean _tmp2;
		_tmp1 = NULL;
		cl = (_tmp1 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = FALSE;
		if (!vala_class_get_is_compact (cl)) {
			_tmp2 = vcall == NULL;
		} else {
			_tmp2 = FALSE;
		}
		if (_tmp2) {
			ValaCCodeFormalParameter* _tmp3;
			_tmp3 = NULL;
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), _tmp3 = vala_ccode_formal_parameter_new ("object_type", "GType"));
			(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		gboolean _tmp4;
		_tmp4 = FALSE;
		if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
			_tmp4 = TRUE;
		} else {
			gboolean _tmp5;
			_tmp5 = FALSE;
			if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
				_tmp5 = VALA_IS_CREATION_METHOD (m);
			} else {
				_tmp5 = FALSE;
			}
			_tmp4 = (_tmp5);
		}
		if (_tmp4) {
			ValaTypeSymbol* parent_type;
			ValaDataType* this_type;
			ValaCCodeFormalParameter* instance_param;
			gboolean _tmp10;
			gboolean _tmp11;
			parent_type = vala_ccode_method_module_find_parent_type (self, (ValaSymbol*) m);
			this_type = NULL;
			if (VALA_IS_CLASS (parent_type)) {
				ValaDataType* _tmp6;
				_tmp6 = NULL;
				this_type = (_tmp6 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp6);
			} else {
				if (VALA_IS_INTERFACE (parent_type)) {
					ValaDataType* _tmp7;
					_tmp7 = NULL;
					this_type = (_tmp7 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp7);
				} else {
					if (VALA_IS_STRUCT (parent_type)) {
						ValaDataType* _tmp8;
						_tmp8 = NULL;
						this_type = (_tmp8 = (ValaDataType*) vala_struct_value_type_new (VALA_STRUCT (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp8);
					} else {
						if (VALA_IS_ENUM (parent_type)) {
							ValaDataType* _tmp9;
							_tmp9 = NULL;
							this_type = (_tmp9 = (ValaDataType*) vala_enum_value_type_new (VALA_ENUM (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp9);
						} else {
							g_assert_not_reached ();
						}
					}
				}
			}
			instance_param = NULL;
			_tmp10 = FALSE;
			_tmp11 = FALSE;
			if (vala_method_get_base_interface_method (m) != NULL) {
				_tmp11 = !vala_method_get_is_abstract (m);
			} else {
				_tmp11 = FALSE;
			}
			if (_tmp11) {
				_tmp10 = !vala_method_get_is_virtual (m);
			} else {
				_tmp10 = FALSE;
			}
			if (_tmp10) {
				ValaObjectType* base_type;
				ValaCCodeFormalParameter* _tmp13;
				char* _tmp12;
				base_type = vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m))));
				_tmp13 = NULL;
				_tmp12 = NULL;
				instance_param = (_tmp13 = vala_ccode_formal_parameter_new ("base", _tmp12 = vala_data_type_get_cname ((ValaDataType*) base_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp13);
				_tmp12 = (g_free (_tmp12), NULL);
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			} else {
				if (vala_method_get_overrides (m)) {
					ValaObjectType* base_type;
					ValaCCodeFormalParameter* _tmp15;
					char* _tmp14;
					base_type = vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m))));
					_tmp15 = NULL;
					_tmp14 = NULL;
					instance_param = (_tmp15 = vala_ccode_formal_parameter_new ("base", _tmp14 = vala_data_type_get_cname ((ValaDataType*) base_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp15);
					_tmp14 = (g_free (_tmp14), NULL);
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				} else {
					gboolean _tmp16;
					_tmp16 = FALSE;
					if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
						_tmp16 = !vala_struct_is_simple_type ((VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) m))));
					} else {
						_tmp16 = FALSE;
					}
					if (_tmp16) {
						ValaCCodeFormalParameter* _tmp18;
						char* _tmp17;
						_tmp18 = NULL;
						_tmp17 = NULL;
						instance_param = (_tmp18 = vala_ccode_formal_parameter_new ("*self", _tmp17 = vala_data_type_get_cname (this_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp18);
						_tmp17 = (g_free (_tmp17), NULL);
					} else {
						ValaCCodeFormalParameter* _tmp20;
						char* _tmp19;
						_tmp20 = NULL;
						_tmp19 = NULL;
						instance_param = (_tmp20 = vala_ccode_formal_parameter_new ("self", _tmp19 = vala_data_type_get_cname (this_type)), (instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL)), _tmp20);
						_tmp19 = (g_free (_tmp19), NULL);
					}
				}
			}
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance_param);
			(parent_type == NULL) ? NULL : (parent_type = (vala_code_node_unref (parent_type), NULL));
			(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
			(instance_param == NULL) ? NULL : (instance_param = (vala_ccode_node_unref (instance_param), NULL));
		} else {
			if (vala_method_get_binding (m) == MEMBER_BINDING_CLASS) {
				ValaTypeSymbol* parent_type;
				ValaDataType* this_type;
				ValaDataType* _tmp21;
				char* _tmp22;
				ValaCCodeFormalParameter* _tmp23;
				ValaCCodeFormalParameter* class_param;
				parent_type = vala_ccode_method_module_find_parent_type (self, (ValaSymbol*) m);
				this_type = NULL;
				_tmp21 = NULL;
				this_type = (_tmp21 = (ValaDataType*) vala_class_type_new (VALA_CLASS (parent_type)), (this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL)), _tmp21);
				_tmp22 = NULL;
				_tmp23 = NULL;
				class_param = (_tmp23 = vala_ccode_formal_parameter_new ("klass", _tmp22 = vala_data_type_get_cname (this_type)), _tmp22 = (g_free (_tmp22), NULL), _tmp23);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), class_param);
				(parent_type == NULL) ? NULL : (parent_type = (vala_code_node_unref (parent_type), NULL));
				(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
				(class_param == NULL) ? NULL : (class_param = (vala_ccode_node_unref (class_param), NULL));
			}
		}
	}
	if (in_gtypeinstance_creation_method) {
		gint type_param_index;
		/* memory management for generic types*/
		type_param_index = 0;
		{
			GeeList* _tmp24;
			GeeIterator* _tmp25;
			GeeIterator* _type_param_it;
			_tmp24 = NULL;
			_tmp25 = NULL;
			_type_param_it = (_tmp25 = gee_iterable_iterator ((GeeIterable*) (_tmp24 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))), (_tmp24 == NULL) ? NULL : (_tmp24 = (gee_collection_object_unref (_tmp24), NULL)), _tmp25);
			while (gee_iterator_next (_type_param_it)) {
				ValaTypeParameter* type_param;
				ValaCCodeFormalParameter* _tmp28;
				char* _tmp27;
				char* _tmp26;
				ValaCCodeFormalParameter* _tmp31;
				char* _tmp30;
				char* _tmp29;
				ValaCCodeFormalParameter* _tmp34;
				char* _tmp33;
				char* _tmp32;
				type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
				_tmp28 = NULL;
				_tmp27 = NULL;
				_tmp26 = NULL;
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), _tmp28 = vala_ccode_formal_parameter_new (_tmp27 = g_strdup_printf ("%s_type", _tmp26 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GType"));
				(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
				_tmp27 = (g_free (_tmp27), NULL);
				_tmp26 = (g_free (_tmp26), NULL);
				_tmp31 = NULL;
				_tmp30 = NULL;
				_tmp29 = NULL;
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), _tmp31 = vala_ccode_formal_parameter_new (_tmp30 = g_strdup_printf ("%s_dup_func", _tmp29 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GBoxedCopyFunc"));
				(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
				_tmp30 = (g_free (_tmp30), NULL);
				_tmp29 = (g_free (_tmp29), NULL);
				_tmp34 = NULL;
				_tmp33 = NULL;
				_tmp32 = NULL;
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), _tmp34 = vala_ccode_formal_parameter_new (_tmp33 = g_strdup_printf ("%s_destroy_func", _tmp32 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), "GDestroyNotify"));
				(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
				_tmp33 = (g_free (_tmp33), NULL);
				_tmp32 = (g_free (_tmp32), NULL);
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp37;
					char* _tmp36;
					char* _tmp35;
					ValaCCodeIdentifier* _tmp40;
					char* _tmp39;
					char* _tmp38;
					ValaCCodeIdentifier* _tmp43;
					char* _tmp42;
					char* _tmp41;
					_tmp37 = NULL;
					_tmp36 = NULL;
					_tmp35 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new (_tmp36 = g_strdup_printf ("%s_type", _tmp35 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
					_tmp36 = (g_free (_tmp36), NULL);
					_tmp35 = (g_free (_tmp35), NULL);
					_tmp40 = NULL;
					_tmp39 = NULL;
					_tmp38 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new (_tmp39 = g_strdup_printf ("%s_dup_func", _tmp38 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
					_tmp39 = (g_free (_tmp39), NULL);
					_tmp38 = (g_free (_tmp38), NULL);
					_tmp43 = NULL;
					_tmp42 = NULL;
					_tmp41 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) (_tmp43 = vala_ccode_identifier_new (_tmp42 = g_strdup_printf ("%s_destroy_func", _tmp41 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)))));
					(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
					_tmp42 = (g_free (_tmp42), NULL);
					_tmp41 = (g_free (_tmp41), NULL);
				}
				type_param_index++;
				(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
			}
			(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
		}
	}
	{
		GeeList* _tmp44;
		GeeIterator* _tmp45;
		GeeIterator* _param_it;
		_tmp44 = NULL;
		_tmp45 = NULL;
		_param_it = (_tmp45 = gee_iterable_iterator ((GeeIterable*) (_tmp44 = vala_method_get_parameters (m))), (_tmp44 == NULL) ? NULL : (_tmp44 = (gee_collection_object_unref (_tmp44), NULL)), _tmp45);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp46;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
				if ((direction & 1) == 0) {
					/* no in paramters*/
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					continue;
				}
			} else {
				if ((direction & 2) == 0) {
					/* no out paramters*/
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					continue;
				}
			}
			_tmp46 = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp46 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp46 = FALSE;
			}
			if (_tmp46) {
				ValaArrayType* _tmp47;
				ValaArrayType* array_type;
				char* length_ctype;
				_tmp47 = NULL;
				array_type = (_tmp47 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp47 == NULL) ? NULL : vala_code_node_ref (_tmp47));
				length_ctype = g_strdup ("int");
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					char* _tmp48;
					_tmp48 = NULL;
					length_ctype = (_tmp48 = g_strdup ("int*"), length_ctype = (g_free (length_ctype), NULL), _tmp48);
				}
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						char* _tmp49;
						ValaCCodeFormalParameter* _tmp50;
						ValaCCodeFormalParameter* cparam;
						_tmp49 = NULL;
						_tmp50 = NULL;
						cparam = (_tmp50 = vala_ccode_formal_parameter_new (_tmp49 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), dim), length_ctype), _tmp49 = (g_free (_tmp49), NULL), _tmp50);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), cparam);
						if (carg_map != NULL) {
							ValaCCodeIdentifier* _tmp51;
							_tmp51 = NULL;
							gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
							(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
						}
						(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				length_ctype = (g_free (length_ctype), NULL);
			}
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
			if (carg_map != NULL) {
				ValaCCodeIdentifier* _tmp52;
				_tmp52 = NULL;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
				(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
			}
			if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
				ValaDelegateType* _tmp53;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp54;
				ValaDelegate* d;
				_tmp53 = NULL;
				deleg_type = (_tmp53 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp53 == NULL) ? NULL : vala_code_node_ref (_tmp53));
				_tmp54 = NULL;
				d = (_tmp54 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp54 == NULL) ? NULL : vala_code_node_ref (_tmp54));
				if (vala_delegate_get_has_target (d)) {
					char* _tmp55;
					ValaCCodeFormalParameter* _tmp56;
					ValaCCodeFormalParameter* cparam;
					_tmp55 = NULL;
					_tmp56 = NULL;
					cparam = (_tmp56 = vala_ccode_formal_parameter_new (_tmp55 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), "void*"), _tmp55 = (g_free (_tmp55), NULL), _tmp56);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp57;
						_tmp57 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp57 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
						(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
					}
					if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
						ValaCCodeFormalParameter* _tmp59;
						char* _tmp58;
						_tmp59 = NULL;
						_tmp58 = NULL;
						cparam = (_tmp59 = vala_ccode_formal_parameter_new (_tmp58 = vala_ccode_base_module_get_delegate_target_destroy_notify_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), "GDestroyNotify"), (cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)), _tmp59);
						_tmp58 = (g_free (_tmp58), NULL);
						gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), cparam);
						if (carg_map != NULL) {
							ValaCCodeIdentifier* _tmp60;
							_tmp60 = NULL;
							gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), (ValaCCodeExpression*) (_tmp60 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
							(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
						}
					}
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
				(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
				(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			} else {
				if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					char* _tmp61;
					ValaCCodeFormalParameter* _tmp62;
					ValaCCodeFormalParameter* cparam;
					_tmp61 = NULL;
					_tmp62 = NULL;
					cparam = (_tmp62 = vala_ccode_formal_parameter_new (_tmp61 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), "void*"), _tmp61 = (g_free (_tmp61), NULL), _tmp62);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp63;
						_tmp63 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
						(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
					}
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if ((direction & 2) != 0) {
		gboolean _tmp64;
		GeeList* _tmp74;
		gboolean _tmp75;
		_tmp64 = FALSE;
		if (!vala_method_get_no_array_length (m)) {
			_tmp64 = VALA_IS_ARRAY_TYPE (creturn_type);
		} else {
			_tmp64 = FALSE;
		}
		if (_tmp64) {
			ValaArrayType* _tmp65;
			ValaArrayType* array_type;
			/* return array length if appropriate*/
			_tmp65 = NULL;
			array_type = (_tmp65 = VALA_ARRAY_TYPE (creturn_type), (_tmp65 == NULL) ? NULL : vala_code_node_ref (_tmp65));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					char* _tmp66;
					ValaCCodeFormalParameter* _tmp67;
					ValaCCodeFormalParameter* cparam;
					_tmp66 = NULL;
					_tmp67 = NULL;
					cparam = (_tmp67 = vala_ccode_formal_parameter_new (_tmp66 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _tmp66 = (g_free (_tmp66), NULL), _tmp67);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp68;
						_tmp68 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp68 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
						(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
					}
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		} else {
			if (VALA_IS_DELEGATE_TYPE (creturn_type)) {
				ValaDelegateType* _tmp69;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp70;
				ValaDelegate* d;
				/* return delegate target if appropriate*/
				_tmp69 = NULL;
				deleg_type = (_tmp69 = VALA_DELEGATE_TYPE (creturn_type), (_tmp69 == NULL) ? NULL : vala_code_node_ref (_tmp69));
				_tmp70 = NULL;
				d = (_tmp70 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp70 == NULL) ? NULL : vala_code_node_ref (_tmp70));
				if (vala_delegate_get_has_target (d)) {
					char* _tmp71;
					ValaCCodeFormalParameter* _tmp72;
					ValaCCodeFormalParameter* cparam;
					_tmp71 = NULL;
					_tmp72 = NULL;
					cparam = (_tmp72 = vala_ccode_formal_parameter_new (_tmp71 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, "result"), "void*"), _tmp71 = (g_free (_tmp71), NULL), _tmp72);
					gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), cparam);
					if (carg_map != NULL) {
						ValaCCodeIdentifier* _tmp73;
						_tmp73 = NULL;
						gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp73 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
						(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
					}
					(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
				}
				(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
				(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			}
		}
		_tmp74 = NULL;
		if ((_tmp75 = gee_collection_get_size ((GeeCollection*) (_tmp74 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp74 == NULL) ? NULL : (_tmp74 = (gee_collection_object_unref (_tmp74), NULL)), _tmp75)) {
			ValaCCodeFormalParameter* cparam;
			cparam = vala_ccode_formal_parameter_new ("error", "GError**");
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), cparam);
			if (carg_map != NULL) {
				ValaCCodeIdentifier* _tmp76;
				_tmp76 = NULL;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp76 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
				(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
			}
			(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
		}
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp81;
		min_pos = -1;
		{
			GeeSet* _tmp77;
			GeeIterator* _tmp78;
			GeeIterator* _pos_it;
			_tmp77 = NULL;
			_tmp78 = NULL;
			_pos_it = (_tmp78 = gee_iterable_iterator ((GeeIterable*) (_tmp77 = gee_map_get_keys (cparam_map))), (_tmp77 == NULL) ? NULL : (_tmp77 = (gee_collection_object_unref (_tmp77), NULL)), _tmp78);
			while (gee_iterator_next (_pos_it)) {
				gint pos;
				gboolean _tmp79;
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp79 = FALSE;
				if (pos > last_pos) {
					gboolean _tmp80;
					_tmp80 = FALSE;
					if (min_pos == (-1)) {
						_tmp80 = TRUE;
					} else {
						_tmp80 = pos < min_pos;
					}
					_tmp79 = (_tmp80);
				} else {
					_tmp79 = FALSE;
				}
				if (_tmp79) {
					min_pos = pos;
				}
			}
			(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp81 = NULL;
		vala_ccode_function_add_parameter (func, _tmp81 = (ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)));
		(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
		if (vdeclarator != NULL) {
			ValaCCodeFormalParameter* _tmp82;
			_tmp82 = NULL;
			vala_ccode_function_declarator_add_parameter (vdeclarator, _tmp82 = (ValaCCodeFormalParameter*) gee_map_get (cparam_map, GINT_TO_POINTER (min_pos)));
			(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
		}
		if (vcall != NULL) {
			ValaCCodeExpression* _tmp83;
			_tmp83 = NULL;
			vala_ccode_function_call_add_argument (vcall, _tmp83 = (ValaCCodeExpression*) gee_map_get (carg_map, GINT_TO_POINTER (min_pos)));
			(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
		}
		last_pos = min_pos;
	}
}


void vala_ccode_method_module_generate_vfunc (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, GeeMap* cparam_map, GeeMap* carg_map, const char* suffix, gint direction) {
	gboolean visible;
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* vfunc;
	ValaCCodeBlock* vblock;
	ValaCCodeFunctionCall* vcast;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeMemberAccess* _tmp18;
	char* _tmp17;
	ValaCCodeFunctionCall* _tmp19;
	ValaCCodeFunctionCall* vcall;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeStatement* cstmt;
	GeeList* _tmp31;
	gboolean _tmp32;
	gboolean _tmp40;
	gboolean _tmp41;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (return_type != NULL);
	g_return_if_fail (cparam_map != NULL);
	g_return_if_fail (carg_map != NULL);
	g_return_if_fail (suffix != NULL);
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	vfunc = (_tmp3 = vala_ccode_function_new (_tmp1 = g_strconcat (_tmp0 = vala_method_get_cname (m), suffix, NULL), _tmp2 = vala_data_type_get_cname (return_type)), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp3);
	vala_ccode_node_set_line ((ValaCCodeNode*) vfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
	vblock = vala_ccode_block_new ();
	{
		GeeList* _tmp4;
		GeeIterator* _tmp5;
		GeeIterator* _precondition_it;
		_tmp4 = NULL;
		_tmp5 = NULL;
		_precondition_it = (_tmp5 = gee_iterable_iterator ((GeeIterable*) (_tmp4 = vala_method_get_preconditions (m))), (_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)), _tmp5);
		while (gee_iterator_next (_precondition_it)) {
			ValaExpression* precondition;
			ValaCCodeStatement* check_stmt;
			precondition = (ValaExpression*) gee_iterator_get (_precondition_it);
			check_stmt = vala_ccode_method_module_create_precondition_statement (self, (ValaCodeNode*) m, return_type, precondition);
			if (check_stmt != NULL) {
				vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) check_stmt);
			}
			(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
			(check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL));
		}
		(_precondition_it == NULL) ? NULL : (_precondition_it = (gee_collection_object_unref (_precondition_it), NULL));
	}
	vcast = NULL;
	if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) m))) {
		ValaInterface* _tmp6;
		ValaInterface* iface;
		ValaCCodeFunctionCall* _tmp10;
		ValaCCodeIdentifier* _tmp9;
		char* _tmp8;
		char* _tmp7;
		_tmp6 = NULL;
		iface = (_tmp6 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		_tmp7 = NULL;
		vcast = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new (_tmp8 = g_strdup_printf ("%s_GET_INTERFACE", _tmp7 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp10);
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		_tmp8 = (g_free (_tmp8), NULL);
		_tmp7 = (g_free (_tmp7), NULL);
		(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
	} else {
		ValaClass* _tmp11;
		ValaClass* cl;
		ValaCCodeFunctionCall* _tmp15;
		ValaCCodeIdentifier* _tmp14;
		char* _tmp13;
		char* _tmp12;
		_tmp11 = NULL;
		cl = (_tmp11 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp11 == NULL) ? NULL : vala_code_node_ref (_tmp11));
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp12 = NULL;
		vcast = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new (_tmp13 = g_strdup_printf ("%s_GET_CLASS", _tmp12 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp15);
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		_tmp13 = (g_free (_tmp13), NULL);
		_tmp12 = (g_free (_tmp12), NULL);
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	}
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("self")));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp19 = NULL;
	vcall = (_tmp19 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp17 = g_strconcat (vala_method_get_vfunc_name (m), suffix, NULL)))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp17 = (g_free (_tmp17), NULL), _tmp19);
	_tmp20 = NULL;
	gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("self")));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, return_type, FALSE, cparam_map, vfunc, NULL, carg_map, vcall, direction);
	cstmt = NULL;
	if (VALA_IS_VOID_TYPE (return_type)) {
		ValaCCodeStatement* _tmp21;
		_tmp21 = NULL;
		cstmt = (_tmp21 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) vcall), (cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)), _tmp21);
	} else {
		GeeList* _tmp22;
		gboolean _tmp23;
		_tmp22 = NULL;
		if ((_tmp23 = gee_collection_get_size ((GeeCollection*) (_tmp22 = vala_method_get_postconditions (m))) == 0, (_tmp22 == NULL) ? NULL : (_tmp22 = (gee_collection_object_unref (_tmp22), NULL)), _tmp23)) {
			ValaCCodeStatement* _tmp24;
			/* pass method return value */
			_tmp24 = NULL;
			cstmt = (_tmp24 = (ValaCCodeStatement*) vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall), (cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)), _tmp24);
		} else {
			char* _tmp26;
			char* _tmp25;
			ValaCCodeDeclaration* _tmp27;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp28;
			ValaCCodeStatement* _tmp30;
			ValaCCodeStatement* _tmp29;
			/* store method return value for postconditions */
			_tmp26 = NULL;
			_tmp25 = NULL;
			_tmp27 = NULL;
			cdecl_ = (_tmp27 = vala_ccode_declaration_new (_tmp26 = vala_ccode_method_module_get_creturn_type (self, m, _tmp25 = vala_data_type_get_cname (return_type))), _tmp26 = (g_free (_tmp26), NULL), _tmp25 = (g_free (_tmp25), NULL), _tmp27);
			_tmp28 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp28 = vala_ccode_variable_declarator_new ("result", (ValaCCodeExpression*) vcall)));
			(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
			_tmp30 = NULL;
			_tmp29 = NULL;
			cstmt = (_tmp30 = (_tmp29 = (ValaCCodeStatement*) cdecl_, (_tmp29 == NULL) ? NULL : vala_ccode_node_ref (_tmp29)), (cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL)), _tmp30);
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		}
	}
	vala_ccode_node_set_line ((ValaCCodeNode*) cstmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
	vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cstmt);
	_tmp31 = NULL;
	if ((_tmp32 = gee_collection_get_size ((GeeCollection*) (_tmp31 = vala_method_get_postconditions (m))) > 0, (_tmp31 == NULL) ? NULL : (_tmp31 = (gee_collection_object_unref (_tmp31), NULL)), _tmp32)) {
		{
			GeeList* _tmp33;
			GeeIterator* _tmp34;
			GeeIterator* _postcondition_it;
			_tmp33 = NULL;
			_tmp34 = NULL;
			_postcondition_it = (_tmp34 = gee_iterable_iterator ((GeeIterable*) (_tmp33 = vala_method_get_postconditions (m))), (_tmp33 == NULL) ? NULL : (_tmp33 = (gee_collection_object_unref (_tmp33), NULL)), _tmp34);
			while (gee_iterator_next (_postcondition_it)) {
				ValaExpression* postcondition;
				ValaCCodeStatement* _tmp35;
				postcondition = (ValaExpression*) gee_iterator_get (_postcondition_it);
				_tmp35 = NULL;
				vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) (_tmp35 = vala_ccode_method_module_create_postcondition_statement (self, postcondition)));
				(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
				(postcondition == NULL) ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL));
			}
			(_postcondition_it == NULL) ? NULL : (_postcondition_it = (gee_collection_object_unref (_postcondition_it), NULL));
		}
		if (!(VALA_IS_VOID_TYPE (return_type))) {
			ValaCCodeIdentifier* _tmp36;
			ValaCCodeReturnStatement* _tmp37;
			ValaCCodeReturnStatement* cret_stmt;
			_tmp36 = NULL;
			_tmp37 = NULL;
			cret_stmt = (_tmp37 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("result"))), (_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)), _tmp37);
			vala_ccode_node_set_line ((ValaCCodeNode*) cret_stmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
			vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cret_stmt);
			(cret_stmt == NULL) ? NULL : (cret_stmt = (vala_ccode_node_unref (cret_stmt), NULL));
		}
	}
	if (visible) {
		ValaCCodeFunction* _tmp38;
		_tmp38 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp38 = vala_ccode_function_copy (vfunc)));
		(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	} else {
		ValaCCodeFunction* _tmp39;
		vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
		_tmp39 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp39 = vala_ccode_function_copy (vfunc)));
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	}
	vala_ccode_function_set_block (vfunc, vblock);
	_tmp40 = FALSE;
	_tmp41 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp41 = vala_code_node_get_source_reference ((ValaCodeNode*) m) != NULL;
	} else {
		_tmp41 = FALSE;
	}
	if (_tmp41) {
		_tmp40 = vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)) != NULL;
	} else {
		_tmp40 = FALSE;
	}
	if (_tmp40) {
		ValaCCodeComment* _tmp42;
		_tmp42 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp42 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) m)))));
		(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	}
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) vfunc);
	(vfunc == NULL) ? NULL : (vfunc = (vala_ccode_node_unref (vfunc), NULL));
	(vblock == NULL) ? NULL : (vblock = (vala_ccode_node_unref (vblock), NULL));
	(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
	(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
	(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
}


static ValaCCodeStatement* vala_ccode_method_module_create_method_type_check_statement (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (vala_method_get_coroutine (m)) {
		return NULL;
	} else {
		return vala_ccode_base_module_create_type_check_statement ((ValaCCodeBaseModule*) self, (ValaCodeNode*) m, return_type, t, non_null, var_name);
	}
}


static ValaCCodeStatement* vala_ccode_method_module_create_precondition_statement (ValaCCodeMethodModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaExpression* precondition) {
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeStatement* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (method_node != NULL, NULL);
	g_return_val_if_fail (ret_type != NULL, NULL);
	g_return_val_if_fail (precondition != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) precondition)));
	if (VALA_IS_VOID_TYPE (ret_type)) {
		ValaCCodeIdentifier* _tmp0;
		/* void function */
		_tmp0 = NULL;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_return_if_fail")));
		(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	} else {
		ValaCCodeIdentifier* _tmp1;
		ValaCCodeExpression* cdefault;
		_tmp1 = NULL;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp1 = vala_ccode_identifier_new ("g_return_val_if_fail")));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
		cdefault = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, ret_type, FALSE);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeStatement* _tmp2;
			_tmp2 = NULL;
			return (_tmp2 = NULL, (cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL)), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), _tmp2);
		}
		(cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL));
	}
	_tmp3 = NULL;
	return (_tmp3 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccheck), (ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL)), _tmp3);
}


static ValaCCodeStatement* vala_ccode_method_module_create_postcondition_statement (ValaCCodeMethodModule* self, ValaExpression* postcondition) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cassert;
	ValaCCodeStatement* _tmp2;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (postcondition != NULL, NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cassert = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_assert"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) postcondition)));
	_tmp2 = NULL;
	return (_tmp2 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) cassert), (cassert == NULL) ? NULL : (cassert = (vala_ccode_node_unref (cassert), NULL)), _tmp2);
}


static ValaTypeSymbol* vala_ccode_method_module_find_parent_type (ValaCCodeMethodModule* self, ValaSymbol* sym) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	while (sym != NULL) {
		if (VALA_IS_TYPESYMBOL (sym)) {
			ValaTypeSymbol* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = VALA_TYPESYMBOL (sym), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		}
		sym = vala_symbol_get_parent_symbol (sym);
	}
	return NULL;
}


static void vala_ccode_method_module_add_object_creation (ValaCCodeMethodModule* self, ValaCCodeBlock* b, gboolean has_params) {
	ValaClass* _tmp0;
	ValaClass* cl;
	gboolean chain_up;
	ValaCreationMethod* cm;
	gboolean _tmp7;
	gboolean _tmp8;
	ValaCCodeVariableDeclarator* cdecl_;
	char* _tmp24;
	char* _tmp23;
	ValaCCodeDeclaration* _tmp25;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_tmp0 = NULL;
	cl = (_tmp0 = VALA_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	chain_up = FALSE;
	cm = NULL;
	if (vala_class_get_base_class (cl) != NULL) {
		ValaCreationMethod* _tmp3;
		ValaCreationMethod* _tmp2;
		ValaMethod* _tmp1;
		gboolean _tmp4;
		gboolean _tmp5;
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		cm = (_tmp3 = (_tmp2 = (_tmp1 = vala_class_get_default_construction_method (vala_class_get_base_class (cl)), VALA_IS_CREATION_METHOD (_tmp1) ? ((ValaCreationMethod*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL)), _tmp3);
		_tmp4 = FALSE;
		_tmp5 = FALSE;
		if (cm != NULL) {
			GeeList* _tmp6;
			_tmp6 = NULL;
			_tmp5 = gee_collection_get_size ((GeeCollection*) (_tmp6 = vala_method_get_parameters ((ValaMethod*) cm))) == 0;
			(_tmp6 == NULL) ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL));
		} else {
			_tmp5 = FALSE;
		}
		if (_tmp5) {
			_tmp4 = vala_method_get_has_construct_function ((ValaMethod*) cm);
		} else {
			_tmp4 = FALSE;
		}
		if (_tmp4) {
			if (!has_params) {
				chain_up = TRUE;
			}
		}
	}
	_tmp7 = FALSE;
	_tmp8 = FALSE;
	if (!has_params) {
		_tmp8 = !chain_up;
	} else {
		_tmp8 = FALSE;
	}
	if (_tmp8) {
		_tmp7 = VALA_TYPESYMBOL (vala_class_get_base_class (cl)) != ((ValaCCodeBaseModule*) self)->gobject_type;
	} else {
		_tmp7 = FALSE;
	}
	if (_tmp7) {
	}
	/* possibly report warning or error about missing base call*/
	cdecl_ = vala_ccode_variable_declarator_new ("self", NULL);
	if (chain_up) {
		ValaCCodeIdentifier* _tmp10;
		char* _tmp9;
		ValaCCodeFunctionCall* _tmp11;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp12;
		ValaCCodeCastExpression* _tmp15;
		char* _tmp14;
		char* _tmp13;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp11 = NULL;
		ccall = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new (_tmp9 = vala_method_get_real_cname ((ValaMethod*) cm)))), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp9 = (g_free (_tmp9), NULL), _tmp11);
		_tmp12 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("object_type")));
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_variable_declarator_set_initializer (cdecl_, (ValaCCodeExpression*) (_tmp15 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp14 = g_strdup_printf ("%s*", _tmp13 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))));
		(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		_tmp14 = (g_free (_tmp14), NULL);
		_tmp13 = (g_free (_tmp13), NULL);
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	} else {
		ValaCCodeIdentifier* _tmp16;
		ValaCCodeFunctionCall* _tmp17;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp18;
		_tmp16 = NULL;
		_tmp17 = NULL;
		ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("g_object_newv"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
		_tmp18 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("object_type")));
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		if (has_params) {
			ValaCCodeConstant* _tmp19;
			ValaCCodeConstant* _tmp20;
			_tmp19 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp19 = vala_ccode_constant_new ("__params_it - __params")));
			(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
			_tmp20 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp20 = vala_ccode_constant_new ("__params")));
			(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
		} else {
			ValaCCodeConstant* _tmp21;
			ValaCCodeConstant* _tmp22;
			_tmp21 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new ("0")));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			_tmp22 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22 = vala_ccode_constant_new ("NULL")));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		}
		vala_ccode_variable_declarator_set_initializer (cdecl_, (ValaCCodeExpression*) ccall);
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	}
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp25 = NULL;
	cdeclaration = (_tmp25 = vala_ccode_declaration_new (_tmp24 = g_strdup_printf ("%s *", _tmp23 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp24 = (g_free (_tmp24), NULL), _tmp23 = (g_free (_tmp23), NULL), _tmp25);
	vala_ccode_declaration_add_declarator (cdeclaration, (ValaCCodeDeclarator*) cdecl_);
	vala_ccode_block_add_statement (b, (ValaCCodeNode*) cdeclaration);
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(cdeclaration == NULL) ? NULL : (cdeclaration = (vala_ccode_node_unref (cdeclaration), NULL));
}


static void vala_ccode_method_module_real_visit_creation_method (ValaCCodeModule* base, ValaCreationMethod* m) {
	ValaCCodeMethodModule * self;
	gboolean visible;
	gboolean _tmp0;
	gboolean _tmp1;
	ValaDataType* creturn_type;
	gboolean _tmp9;
	gboolean _tmp20;
	gboolean _tmp21;
	self = (ValaCCodeMethodModule*) base;
	g_return_if_fail (m != NULL);
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (vala_method_get_body ((ValaMethod*) m) != NULL) {
		_tmp1 = VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol);
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		gint n_params;
		n_params = 0;
		{
			GeeList* _tmp2;
			GeeIterator* _tmp3;
			GeeIterator* _stmt_it;
			_tmp2 = NULL;
			_tmp3 = NULL;
			_stmt_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_block_get_statements (vala_method_get_body ((ValaMethod*) m)))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
			while (gee_iterator_next (_stmt_it)) {
				ValaStatement* stmt;
				ValaExpressionStatement* _tmp5;
				ValaStatement* _tmp4;
				ValaExpressionStatement* expr_stmt;
				stmt = (ValaStatement*) gee_iterator_get (_stmt_it);
				_tmp5 = NULL;
				_tmp4 = NULL;
				expr_stmt = (_tmp5 = (_tmp4 = stmt, VALA_IS_EXPRESSION_STATEMENT (_tmp4) ? ((ValaExpressionStatement*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
				if (expr_stmt != NULL) {
					ValaProperty* prop;
					gboolean _tmp6;
					prop = vala_expression_statement_assigned_property (expr_stmt);
					_tmp6 = FALSE;
					if (prop != NULL) {
						_tmp6 = vala_property_accessor_get_construction (vala_property_get_set_accessor (prop));
					} else {
						_tmp6 = FALSE;
					}
					if (_tmp6) {
						n_params++;
					}
					(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				}
				(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
				(expr_stmt == NULL) ? NULL : (expr_stmt = (vala_code_node_unref (expr_stmt), NULL));
			}
			(_stmt_it == NULL) ? NULL : (_stmt_it = (gee_collection_object_unref (_stmt_it), NULL));
		}
		vala_creation_method_set_n_construction_params (m, n_params);
	}
	vala_ccode_module_visit_method (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaMethod*) m);
	creturn_type = NULL;
	if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
		ValaDataType* _tmp7;
		_tmp7 = NULL;
		creturn_type = (_tmp7 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class), (creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)), _tmp7);
	} else {
		ValaDataType* _tmp8;
		_tmp8 = NULL;
		creturn_type = (_tmp8 = (ValaDataType*) vala_void_type_new (NULL), (creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL)), _tmp8);
	}
	_tmp9 = FALSE;
	if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
		_tmp9 = !vala_class_get_is_compact (((ValaCCodeBaseModule*) self)->current_class);
	} else {
		_tmp9 = FALSE;
	}
	if (_tmp9) {
		char* _tmp11;
		char* _tmp10;
		ValaCCodeFunction* _tmp12;
		ValaCCodeFunction* vfunc;
		GeeHashMap* cparam_map;
		GeeHashMap* carg_map;
		ValaCCodeBlock* vblock;
		ValaCCodeIdentifier* _tmp14;
		char* _tmp13;
		ValaCCodeFunctionCall* _tmp15;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* _tmp17;
		char* _tmp16;
		ValaCCodeStatement* cstmt;
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp12 = NULL;
		vfunc = (_tmp12 = vala_ccode_function_new (_tmp10 = vala_method_get_cname ((ValaMethod*) m), _tmp11 = vala_data_type_get_cname (creturn_type)), _tmp11 = (g_free (_tmp11), NULL), _tmp10 = (g_free (_tmp10), NULL), _tmp12);
		vala_ccode_node_set_line ((ValaCCodeNode*) vfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
		cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		vblock = vala_ccode_block_new ();
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp15 = NULL;
		vcall = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new (_tmp13 = vala_method_get_real_cname ((ValaMethod*) m)))), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)), _tmp13 = (g_free (_tmp13), NULL), _tmp15);
		_tmp17 = NULL;
		_tmp16 = NULL;
		vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (_tmp16 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))));
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		_tmp16 = (g_free (_tmp16), NULL);
		vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, (ValaMethod*) m, creturn_type, TRUE, (GeeMap*) cparam_map, vfunc, NULL, (GeeMap*) carg_map, vcall, 3);
		cstmt = (ValaCCodeStatement*) vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall);
		vala_ccode_node_set_line ((ValaCCodeNode*) cstmt, vala_ccode_node_get_line ((ValaCCodeNode*) vfunc));
		vala_ccode_block_add_statement (vblock, (ValaCCodeNode*) cstmt);
		if (visible) {
			ValaCCodeFunction* _tmp18;
			_tmp18 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp18 = vala_ccode_function_copy (vfunc)));
			(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		} else {
			ValaCCodeFunction* _tmp19;
			vala_ccode_function_set_modifiers (vfunc, vala_ccode_function_get_modifiers (vfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp19 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp19 = vala_ccode_function_copy (vfunc)));
			(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
		}
		vala_ccode_function_set_block (vfunc, vblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) vfunc);
		(vfunc == NULL) ? NULL : (vfunc = (vala_ccode_node_unref (vfunc), NULL));
		(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
		(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
		(vblock == NULL) ? NULL : (vblock = (vala_ccode_node_unref (vblock), NULL));
		(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
		(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
	}
	_tmp20 = FALSE;
	_tmp21 = FALSE;
	if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
		_tmp21 = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp21 = FALSE;
	}
	if (_tmp21) {
		gboolean _tmp22;
		_tmp22 = FALSE;
		if (vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m))) > 0) {
			_tmp22 = TRUE;
		} else {
			GeeList* _tmp23;
			_tmp23 = NULL;
			_tmp22 = gee_collection_get_size ((GeeCollection*) (_tmp23 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class))) > 0;
			(_tmp23 == NULL) ? NULL : (_tmp23 = (gee_collection_object_unref (_tmp23), NULL));
		}
		_tmp20 = (_tmp22);
	} else {
		_tmp20 = FALSE;
	}
	if (_tmp20) {
		ValaCCodeIdentifier* _tmp25;
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeBinaryExpression* _tmp26;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeBlock* cdofreeparam;
		ValaCCodeExpressionStatement* _tmp29;
		ValaCCodeUnaryExpression* _tmp28;
		ValaCCodeIdentifier* _tmp27;
		ValaCCodeIdentifier* _tmp30;
		ValaCCodeFunctionCall* _tmp31;
		ValaCCodeFunctionCall* cunsetcall;
		ValaCCodeUnaryExpression* _tmp34;
		ValaCCodeMemberAccess* _tmp33;
		ValaCCodeIdentifier* _tmp32;
		ValaCCodeExpressionStatement* _tmp35;
		ValaCCodeWhileStatement* _tmp36;
		ValaCCodeIdentifier* _tmp37;
		ValaCCodeFunctionCall* _tmp38;
		ValaCCodeFunctionCall* cfreeparams;
		ValaCCodeIdentifier* _tmp39;
		ValaCCodeExpressionStatement* _tmp40;
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp26 = NULL;
		ccond = (_tmp26 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("__params_it")), (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("__params"))), (_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp26);
		cdofreeparam = vala_ccode_block_new ();
		_tmp29 = NULL;
		_tmp28 = NULL;
		_tmp27 = NULL;
		vala_ccode_block_add_statement (cdofreeparam, (ValaCCodeNode*) (_tmp29 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, (ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("__params_it")))))));
		(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
		(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		_tmp30 = NULL;
		_tmp31 = NULL;
		cunsetcall = (_tmp31 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("g_value_unset"))), (_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)), _tmp31);
		_tmp34 = NULL;
		_tmp33 = NULL;
		_tmp32 = NULL;
		vala_ccode_function_call_add_argument (cunsetcall, (ValaCCodeExpression*) (_tmp34 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp33 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new ("__params_it")), "value")))));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
		(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
		_tmp35 = NULL;
		vala_ccode_block_add_statement (cdofreeparam, (ValaCCodeNode*) (_tmp35 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cunsetcall)));
		(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
		_tmp36 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) (_tmp36 = vala_ccode_while_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cdofreeparam)));
		(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
		_tmp37 = NULL;
		_tmp38 = NULL;
		cfreeparams = (_tmp38 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("g_free"))), (_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)), _tmp38);
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (cfreeparams, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("__params")));
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
		_tmp40 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) (_tmp40 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreeparams)));
		(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
		(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
		(cdofreeparam == NULL) ? NULL : (cdofreeparam = (vala_ccode_node_unref (cdofreeparam), NULL));
		(cunsetcall == NULL) ? NULL : (cunsetcall = (vala_ccode_node_unref (cunsetcall), NULL));
		(cfreeparams == NULL) ? NULL : (cfreeparams = (vala_ccode_node_unref (cfreeparams), NULL));
	}
	if (VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol)) {
		ValaCCodeExpression* cresult;
		char* _tmp41;
		gboolean _tmp42;
		ValaCCodeReturnStatement* creturn;
		cresult = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
		_tmp41 = NULL;
		if ((_tmp42 = (_tmp41 = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, (ValaMethod*) m)) != NULL, _tmp41 = (g_free (_tmp41), NULL), _tmp42)) {
			ValaCCodeExpression* _tmp44;
			char* _tmp43;
			_tmp44 = NULL;
			_tmp43 = NULL;
			cresult = (_tmp44 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cresult, _tmp43 = vala_ccode_module_get_custom_creturn_type ((ValaCCodeModule*) self, (ValaMethod*) m)), (cresult == NULL) ? NULL : (cresult = (vala_ccode_node_unref (cresult), NULL)), _tmp44);
			_tmp43 = (g_free (_tmp43), NULL);
		}
		creturn = vala_ccode_return_statement_new (NULL);
		vala_ccode_return_statement_set_return_expression (creturn, cresult);
		vala_ccode_block_add_statement (vala_ccode_function_get_block (((ValaCCodeBaseModule*) self)->function), (ValaCCodeNode*) creturn);
		(cresult == NULL) ? NULL : (cresult = (vala_ccode_node_unref (cresult), NULL));
		(creturn == NULL) ? NULL : (creturn = (vala_ccode_node_unref (creturn), NULL));
	}
	(creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL));
}


static void vala_ccode_method_module_class_init (ValaCCodeMethodModuleClass * klass) {
	vala_ccode_method_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->method_has_wrapper = vala_ccode_method_module_real_method_has_wrapper;
	VALA_CCODE_MODULE_CLASS (klass)->get_custom_creturn_type = vala_ccode_method_module_real_get_custom_creturn_type;
	VALA_CCODE_MODULE_CLASS (klass)->visit_method = vala_ccode_method_module_real_visit_method;
	VALA_CCODE_MODULE_CLASS (klass)->generate_cparameters = vala_ccode_method_module_real_generate_cparameters;
	VALA_CCODE_MODULE_CLASS (klass)->visit_creation_method = vala_ccode_method_module_real_visit_creation_method;
}


static void vala_ccode_method_module_instance_init (ValaCCodeMethodModule * self) {
}


GType vala_ccode_method_module_get_type (void) {
	static GType vala_ccode_method_module_type_id = 0;
	if (vala_ccode_method_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodModule), 0, (GInstanceInitFunc) vala_ccode_method_module_instance_init, NULL };
		vala_ccode_method_module_type_id = g_type_register_static (VALA_TYPE_CCODE_STRUCT_MODULE, "ValaCCodeMethodModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_module_type_id;
}




