/* valagtypemodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;

#define VALA_TYPE_CLASS_REGISTER_FUNCTION (vala_class_register_function_get_type ())
#define VALA_CLASS_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunction))
#define VALA_CLASS_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionClass))
#define VALA_IS_CLASS_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION))
#define VALA_IS_CLASS_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS_REGISTER_FUNCTION))
#define VALA_CLASS_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionClass))

typedef struct _ValaClassRegisterFunction ValaClassRegisterFunction;
typedef struct _ValaClassRegisterFunctionClass ValaClassRegisterFunctionClass;

#define VALA_TYPE_INTERFACE_REGISTER_FUNCTION (vala_interface_register_function_get_type ())
#define VALA_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunction))
#define VALA_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_INTERFACE_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))

typedef struct _ValaInterfaceRegisterFunction ValaInterfaceRegisterFunction;
typedef struct _ValaInterfaceRegisterFunctionClass ValaInterfaceRegisterFunctionClass;

#define VALA_TYPE_STRUCT_REGISTER_FUNCTION (vala_struct_register_function_get_type ())
#define VALA_STRUCT_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunction))
#define VALA_STRUCT_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionClass))
#define VALA_IS_STRUCT_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION))
#define VALA_IS_STRUCT_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_REGISTER_FUNCTION))
#define VALA_STRUCT_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionClass))

typedef struct _ValaStructRegisterFunction ValaStructRegisterFunction;
typedef struct _ValaStructRegisterFunctionClass ValaStructRegisterFunctionClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	ValaCCodeStatement* (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
	void (*generate_class_init) (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block);
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
GType vala_gerror_module_get_type (void);
GType vala_gtype_module_get_type (void);
enum  {
	VALA_GTYPE_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaGErrorModule* vala_gerror_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGErrorModule* vala_gerror_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGTypeModule* vala_gtype_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGTypeModule* vala_gtype_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGTypeModule* vala_gtype_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
void vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
void vala_ccode_base_module_generate_type_declaration (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeDeclarationSpace* decl_space);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
static void vala_gtype_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
gboolean vala_ccode_declaration_space_add_symbol_declaration (ValaCCodeDeclarationSpace* self, ValaSymbol* sym, const char* name);
void vala_ccode_base_module_generate_class_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_declaration_space_add_type_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
char* vala_ccode_base_module_get_type_check_function (ValaCCodeBaseModule* self, ValaTypeSymbol* type);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
ValaClassRegisterFunction* vala_class_register_function_new (ValaClass* cl, ValaCodeContext* context);
ValaClassRegisterFunction* vala_class_register_function_construct (GType object_type, ValaClass* cl, ValaCodeContext* context);
gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
GType vala_class_register_function_get_type (void);
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin);
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self);
static void vala_gtype_module_real_generate_class_declaration (ValaCCodeBaseModule* base, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_class_struct_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_interface_declaration (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
void vala_gtype_module_generate_virtual_method_declaration (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
char* vala_ccode_module_get_array_size_cname (ValaCCodeModule* self, const char* array_cname);
char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_gtype_module_real_generate_class_struct_declaration (ValaCCodeBaseModule* base, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_cparameters (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
static void vala_gtype_module_real_generate_virtual_method_declaration (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
char* vala_ccode_base_module_get_symbol_lock_name (ValaCCodeBaseModule* self, ValaSymbol* sym);
static void vala_gtype_module_generate_class_private_declaration (ValaGTypeModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
static void vala_gtype_module_add_type_value_table_init_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_type_value_table_free_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_type_value_table_copy_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_type_value_table_peek_pointer_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_type_value_table_collect_value_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_type_value_table_lcopy_value_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_g_param_spec_type_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_g_value_get_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_g_value_set_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_base_init_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_class_init_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_base_finalize_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_class_finalize_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_interface_init_function (ValaGTypeModule* self, ValaClass* cl, ValaInterface* iface);
static void vala_gtype_module_add_instance_init_function (ValaGTypeModule* self, ValaClass* cl);
static void vala_gtype_module_add_finalize_function (ValaGTypeModule* self, ValaClass* cl);
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self);
static void vala_gtype_module_real_visit_class (ValaCCodeModule* base, ValaClass* cl);
void vala_gtype_module_generate_class_init (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block);
static void vala_gtype_module_real_generate_class_init (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block);
ValaCCodeFunctionCall* vala_ccode_module_get_signal_creation (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
ValaCCodeFragment* vala_ccode_module_register_dbus_info (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
void vala_ccode_base_module_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
static ValaCCodeFunctionCall* vala_gtype_module_real_get_param_spec (ValaCCodeModule* base, ValaProperty* prop);
ValaInterfaceRegisterFunction* vala_interface_register_function_new (ValaInterface* iface, ValaCodeContext* context);
ValaInterfaceRegisterFunction* vala_interface_register_function_construct (GType object_type, ValaInterface* iface, ValaCodeContext* context);
GType vala_interface_register_function_get_type (void);
static void vala_gtype_module_real_generate_interface_declaration (ValaCCodeBaseModule* base, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
static void vala_gtype_module_add_interface_base_init_function (ValaGTypeModule* self, ValaInterface* iface);
static void vala_gtype_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface);
ValaCCodeFunctionCall* vala_ccode_module_get_param_spec (ValaCCodeModule* self, ValaProperty* prop);
void vala_ccode_module_visit_struct (ValaCCodeModule* self, ValaStruct* st);
ValaStructRegisterFunction* vala_struct_register_function_new (ValaStruct* st, ValaCodeContext* context);
ValaStructRegisterFunction* vala_struct_register_function_construct (GType object_type, ValaStruct* st, ValaCodeContext* context);
GType vala_struct_register_function_get_type (void);
static void vala_gtype_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st);
static gpointer vala_gtype_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaGTypeModule* vala_gtype_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGTypeModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGTypeModule*) vala_gerror_module_construct (object_type, codegen, next);
	return self;
}


ValaGTypeModule* vala_gtype_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gtype_module_construct (VALA_TYPE_GTYPE_MODULE, codegen, next);
}


static void vala_gtype_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map) {
	ValaGTypeModule * self;
	char* ctypename;
	ValaCCodeFormalParameter* _tmp2_;
	char* _tmp1_;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (param != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (cparam_map != NULL);
	if (!VALA_IS_OBJECT_TYPE (vala_formal_parameter_get_parameter_type (param))) {
		VALA_CCODE_METHOD_MODULE_CLASS (vala_gtype_module_parent_class)->generate_parameter ((ValaCCodeMethodModule*) VALA_GERROR_MODULE (self), param, decl_space, cparam_map, carg_map);
		return;
	}
	vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), decl_space);
	ctypename = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param));
	if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
		char* _tmp0_;
		_tmp0_ = NULL;
		ctypename = (_tmp0_ = g_strconcat (ctypename, "*", NULL), ctypename = (g_free (ctypename), NULL), _tmp0_);
	}
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) param, (ValaCCodeNode*) (_tmp2_ = vala_ccode_formal_parameter_new (_tmp1_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), ctypename)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp1_ = (g_free (_tmp1_), NULL);
	gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
	if (carg_map != NULL) {
		ValaCCodeExpression* _tmp3_;
		_tmp3_ = NULL;
		gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), _tmp3_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)));
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	}
	ctypename = (g_free (ctypename), NULL);
}


static void vala_gtype_module_real_generate_class_declaration (ValaCCodeBaseModule* base, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space) {
	ValaGTypeModule * self;
	char* _tmp0_;
	gboolean _tmp1_;
	gboolean is_gtypeinstance;
	gboolean _tmp2_;
	gboolean is_fundamental;
	ValaCCodeTypeDefinition* _tmp41_;
	ValaCCodeVariableDeclarator* _tmp40_;
	char* _tmp39_;
	char* _tmp38_;
	char* _tmp37_;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (cl != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) cl, _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		return;
	}
	if (vala_class_get_base_class (cl) != NULL) {
		/* base class declaration
		 necessary for ref and unref function declarations*/
		vala_ccode_base_module_generate_class_declaration ((ValaCCodeBaseModule*) self, vala_class_get_base_class (cl), decl_space);
	}
	is_gtypeinstance = !vala_class_get_is_compact (cl);
	_tmp2_ = FALSE;
	if (is_gtypeinstance) {
		_tmp2_ = vala_class_get_base_class (cl) == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	is_fundamental = _tmp2_;
	if (is_gtypeinstance) {
		ValaCCodeNewline* _tmp3_;
		char* _tmp4_;
		char* _tmp5_;
		char* macro;
		ValaCCodeMacroReplacement* _tmp7_;
		char* _tmp6_;
		char* _tmp10_;
		char* _tmp9_;
		char* _tmp8_;
		ValaCCodeMacroReplacement* _tmp13_;
		char* _tmp12_;
		char* _tmp11_;
		char* _tmp16_;
		char* _tmp15_;
		char* _tmp14_;
		ValaCCodeMacroReplacement* _tmp19_;
		char* _tmp18_;
		char* _tmp17_;
		char* _tmp21_;
		char* _tmp20_;
		ValaCCodeMacroReplacement* _tmp24_;
		char* _tmp23_;
		char* _tmp22_;
		char* _tmp26_;
		char* _tmp25_;
		ValaCCodeMacroReplacement* _tmp29_;
		char* _tmp28_;
		char* _tmp27_;
		char* _tmp32_;
		char* _tmp31_;
		char* _tmp30_;
		ValaCCodeMacroReplacement* _tmp35_;
		char* _tmp34_;
		char* _tmp33_;
		ValaCCodeNewline* _tmp36_;
		_tmp3_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp3_ = vala_ccode_newline_new ()));
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
		_tmp4_ = NULL;
		_tmp5_ = NULL;
		macro = (_tmp5_ = g_strdup_printf ("(%s_get_type ())", _tmp4_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_);
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp7_ = vala_ccode_macro_replacement_new (_tmp6_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl), macro)));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		_tmp6_ = (g_free (_tmp6_), NULL);
		_tmp10_ = NULL;
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		macro = (_tmp10_ = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", _tmp8_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl), _tmp9_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), macro = (g_free (macro), NULL), _tmp10_);
		_tmp9_ = (g_free (_tmp9_), NULL);
		_tmp8_ = (g_free (_tmp8_), NULL);
		_tmp13_ = NULL;
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp13_ = vala_ccode_macro_replacement_new (_tmp12_ = g_strdup_printf ("%s(obj)", _tmp11_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), macro)));
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
		_tmp12_ = (g_free (_tmp12_), NULL);
		_tmp11_ = (g_free (_tmp11_), NULL);
		_tmp16_ = NULL;
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		macro = (_tmp16_ = g_strdup_printf ("(G_TYPE_CHECK_CLASS_CAST ((klass), %s, %sClass))", _tmp14_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl), _tmp15_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), macro = (g_free (macro), NULL), _tmp16_);
		_tmp15_ = (g_free (_tmp15_), NULL);
		_tmp14_ = (g_free (_tmp14_), NULL);
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		_tmp17_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp19_ = vala_ccode_macro_replacement_new (_tmp18_ = g_strdup_printf ("%s_CLASS(klass)", _tmp17_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), macro)));
		(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
		_tmp18_ = (g_free (_tmp18_), NULL);
		_tmp17_ = (g_free (_tmp17_), NULL);
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		macro = (_tmp21_ = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", _tmp20_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl)), macro = (g_free (macro), NULL), _tmp21_);
		_tmp20_ = (g_free (_tmp20_), NULL);
		_tmp24_ = NULL;
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp24_ = vala_ccode_macro_replacement_new (_tmp23_ = g_strdup_printf ("%s(obj)", _tmp22_ = vala_ccode_base_module_get_type_check_function ((ValaCCodeBaseModule*) self, (ValaTypeSymbol*) cl)), macro)));
		(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
		_tmp23_ = (g_free (_tmp23_), NULL);
		_tmp22_ = (g_free (_tmp22_), NULL);
		_tmp26_ = NULL;
		_tmp25_ = NULL;
		macro = (_tmp26_ = g_strdup_printf ("(G_TYPE_CHECK_CLASS_TYPE ((klass), %s))", _tmp25_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl)), macro = (g_free (macro), NULL), _tmp26_);
		_tmp25_ = (g_free (_tmp25_), NULL);
		_tmp29_ = NULL;
		_tmp28_ = NULL;
		_tmp27_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp29_ = vala_ccode_macro_replacement_new (_tmp28_ = g_strdup_printf ("%s_CLASS(klass)", _tmp27_ = vala_ccode_base_module_get_type_check_function ((ValaCCodeBaseModule*) self, (ValaTypeSymbol*) cl)), macro)));
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
		_tmp28_ = (g_free (_tmp28_), NULL);
		_tmp27_ = (g_free (_tmp27_), NULL);
		_tmp32_ = NULL;
		_tmp31_ = NULL;
		_tmp30_ = NULL;
		macro = (_tmp32_ = g_strdup_printf ("(G_TYPE_INSTANCE_GET_CLASS ((obj), %s, %sClass))", _tmp30_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl), _tmp31_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), macro = (g_free (macro), NULL), _tmp32_);
		_tmp31_ = (g_free (_tmp31_), NULL);
		_tmp30_ = (g_free (_tmp30_), NULL);
		_tmp35_ = NULL;
		_tmp34_ = NULL;
		_tmp33_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp35_ = vala_ccode_macro_replacement_new (_tmp34_ = g_strdup_printf ("%s_GET_CLASS(obj)", _tmp33_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), macro)));
		(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
		_tmp34_ = (g_free (_tmp34_), NULL);
		_tmp33_ = (g_free (_tmp33_), NULL);
		_tmp36_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp36_ = vala_ccode_newline_new ()));
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
		macro = (g_free (macro), NULL);
	}
	_tmp41_ = NULL;
	_tmp40_ = NULL;
	_tmp39_ = NULL;
	_tmp38_ = NULL;
	_tmp37_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp41_ = vala_ccode_type_definition_new (_tmp38_ = g_strdup_printf ("struct _%s", _tmp37_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), (ValaCCodeDeclarator*) (_tmp40_ = vala_ccode_variable_declarator_new (_tmp39_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), NULL, NULL)))));
	(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
	_tmp39_ = (g_free (_tmp39_), NULL);
	_tmp38_ = (g_free (_tmp38_), NULL);
	_tmp37_ = (g_free (_tmp37_), NULL);
	if (is_fundamental) {
		char* _tmp43_;
		char* _tmp42_;
		ValaCCodeFunction* _tmp44_;
		ValaCCodeFunction* ref_fun;
		char* _tmp46_;
		char* _tmp45_;
		ValaCCodeFunction* _tmp47_;
		ValaCCodeFunction* unref_fun;
		ValaCCodeFormalParameter* _tmp48_;
		ValaCCodeFormalParameter* _tmp49_;
		ValaCCodeFunction* _tmp50_;
		ValaCCodeFunction* _tmp51_;
		char* function_name;
		ValaCCodeFunction* function;
		ValaCCodeFormalParameter* _tmp52_;
		ValaCCodeFormalParameter* _tmp53_;
		ValaCCodeFormalParameter* _tmp54_;
		ValaCCodeFormalParameter* _tmp55_;
		ValaCCodeFormalParameter* _tmp56_;
		ValaCCodeFunction* _tmp58_;
		char* _tmp57_;
		ValaCCodeFormalParameter* _tmp59_;
		ValaCCodeFormalParameter* _tmp60_;
		ValaCCodeFunction* _tmp62_;
		char* _tmp61_;
		ValaCCodeFormalParameter* _tmp63_;
		_tmp43_ = NULL;
		_tmp42_ = NULL;
		_tmp44_ = NULL;
		ref_fun = (_tmp44_ = vala_ccode_function_new (_tmp43_ = g_strconcat (_tmp42_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "ref", NULL), "gpointer"), _tmp43_ = (g_free (_tmp43_), NULL), _tmp42_ = (g_free (_tmp42_), NULL), _tmp44_);
		_tmp46_ = NULL;
		_tmp45_ = NULL;
		_tmp47_ = NULL;
		unref_fun = (_tmp47_ = vala_ccode_function_new (_tmp46_ = g_strconcat (_tmp45_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "unref", NULL), "void"), _tmp46_ = (g_free (_tmp46_), NULL), _tmp45_ = (g_free (_tmp45_), NULL), _tmp47_);
		if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (ref_fun, VALA_CCODE_MODIFIERS_STATIC);
			vala_ccode_function_set_modifiers (unref_fun, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp48_ = NULL;
		vala_ccode_function_add_parameter (ref_fun, _tmp48_ = vala_ccode_formal_parameter_new ("instance", "gpointer"));
		(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
		_tmp49_ = NULL;
		vala_ccode_function_add_parameter (unref_fun, _tmp49_ = vala_ccode_formal_parameter_new ("instance", "gpointer"));
		(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
		_tmp50_ = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) (_tmp50_ = vala_ccode_function_copy (ref_fun)));
		(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
		_tmp51_ = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) (_tmp51_ = vala_ccode_function_copy (unref_fun)));
		(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
		/* GParamSpec and GValue functions*/
		function_name = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "param_spec_");
		function = vala_ccode_function_new (function_name, "GParamSpec*");
		_tmp52_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp52_ = vala_ccode_formal_parameter_new ("name", "const gchar*"));
		(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
		_tmp53_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp53_ = vala_ccode_formal_parameter_new ("nick", "const gchar*"));
		(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
		_tmp54_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp54_ = vala_ccode_formal_parameter_new ("blurb", "const gchar*"));
		(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
		_tmp55_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp55_ = vala_ccode_formal_parameter_new ("object_type", "GType"));
		(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
		_tmp56_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp56_ = vala_ccode_formal_parameter_new ("flags", "GParamFlags"));
		(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
		vala_class_set_param_spec_function (cl, function_name);
		if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) function);
		_tmp58_ = NULL;
		_tmp57_ = NULL;
		function = (_tmp58_ = vala_ccode_function_new (_tmp57_ = vala_typesymbol_get_set_value_function ((ValaTypeSymbol*) cl), "void"), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), _tmp58_);
		_tmp57_ = (g_free (_tmp57_), NULL);
		_tmp59_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp59_ = vala_ccode_formal_parameter_new ("value", "GValue*"));
		(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
		_tmp60_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp60_ = vala_ccode_formal_parameter_new ("v_object", "gpointer"));
		(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
		if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) function);
		_tmp62_ = NULL;
		_tmp61_ = NULL;
		function = (_tmp62_ = vala_ccode_function_new (_tmp61_ = vala_typesymbol_get_get_value_function ((ValaTypeSymbol*) cl), "gpointer"), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), _tmp62_);
		_tmp61_ = (g_free (_tmp61_), NULL);
		_tmp63_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp63_ = vala_ccode_formal_parameter_new ("value", "const GValue*"));
		(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
		if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) function);
		(ref_fun == NULL) ? NULL : (ref_fun = (vala_ccode_node_unref (ref_fun), NULL));
		(unref_fun == NULL) ? NULL : (unref_fun = (vala_ccode_node_unref (unref_fun), NULL));
		function_name = (g_free (function_name), NULL);
		(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	}
	if (is_gtypeinstance) {
		ValaCCodeTypeDefinition* _tmp69_;
		ValaCCodeVariableDeclarator* _tmp68_;
		char* _tmp67_;
		char* _tmp66_;
		char* _tmp65_;
		char* _tmp64_;
		ValaClassRegisterFunction* type_fun;
		ValaCCodeFragment* _tmp70_;
		_tmp69_ = NULL;
		_tmp68_ = NULL;
		_tmp67_ = NULL;
		_tmp66_ = NULL;
		_tmp65_ = NULL;
		_tmp64_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp69_ = vala_ccode_type_definition_new (_tmp65_ = g_strdup_printf ("struct _%sClass", _tmp64_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), (ValaCCodeDeclarator*) (_tmp68_ = vala_ccode_variable_declarator_new (_tmp67_ = g_strdup_printf ("%sClass", _tmp66_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), NULL, NULL)))));
		(_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL));
		(_tmp68_ == NULL) ? NULL : (_tmp68_ = (vala_ccode_node_unref (_tmp68_), NULL));
		_tmp67_ = (g_free (_tmp67_), NULL);
		_tmp66_ = (g_free (_tmp66_), NULL);
		_tmp65_ = (g_free (_tmp65_), NULL);
		_tmp64_ = (g_free (_tmp64_), NULL);
		type_fun = vala_class_register_function_new (cl, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
		vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, ((ValaCCodeBaseModule*) self)->in_plugin);
		_tmp70_ = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) (_tmp70_ = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
		(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
		(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
	}
}


static void vala_gtype_module_real_generate_class_struct_declaration (ValaCCodeBaseModule* base, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space) {
	ValaGTypeModule * self;
	char* _tmp1_;
	char* _tmp0_;
	gboolean _tmp2_;
	gboolean is_gtypeinstance;
	gboolean _tmp7_;
	gboolean is_fundamental;
	char* _tmp9_;
	char* _tmp8_;
	ValaCCodeStruct* _tmp10_;
	ValaCCodeStruct* instance_struct;
	char* _tmp12_;
	char* _tmp11_;
	ValaCCodeStruct* _tmp13_;
	ValaCCodeStruct* type_struct;
	gboolean _tmp15_;
	gboolean _tmp16_;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (cl != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	if ((_tmp2_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) cl, _tmp1_ = g_strconcat ("struct _", _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), NULL)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_)) {
		return;
	}
	if (vala_class_get_base_class (cl) != NULL) {
		/* base class declaration*/
		vala_ccode_base_module_generate_class_struct_declaration ((ValaCCodeBaseModule*) self, vala_class_get_base_class (cl), decl_space);
	}
	{
		GeeList* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _base_type_it;
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		_base_type_it = (_tmp4_ = gee_iterable_iterator ((GeeIterable*) (_tmp3_ = vala_class_get_base_types (cl))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (gee_collection_object_unref (_tmp3_), NULL)), _tmp4_);
		while (gee_iterator_next (_base_type_it)) {
			ValaDataType* base_type;
			ValaInterface* _tmp6_;
			ValaTypeSymbol* _tmp5_;
			ValaInterface* iface;
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			iface = (_tmp6_ = (_tmp5_ = vala_data_type_get_data_type (base_type), VALA_IS_INTERFACE (_tmp5_) ? ((ValaInterface*) _tmp5_) : NULL), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
			if (iface != NULL) {
				vala_ccode_base_module_generate_interface_declaration ((ValaCCodeBaseModule*) self, iface, decl_space);
			}
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
		}
		(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
	}
	vala_ccode_base_module_generate_class_declaration ((ValaCCodeBaseModule*) self, cl, decl_space);
	is_gtypeinstance = !vala_class_get_is_compact (cl);
	_tmp7_ = FALSE;
	if (is_gtypeinstance) {
		_tmp7_ = vala_class_get_base_class (cl) == NULL;
	} else {
		_tmp7_ = FALSE;
	}
	is_fundamental = _tmp7_;
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp10_ = NULL;
	instance_struct = (_tmp10_ = vala_ccode_struct_new (_tmp9_ = g_strdup_printf ("_%s", _tmp8_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp9_ = (g_free (_tmp9_), NULL), _tmp8_ = (g_free (_tmp8_), NULL), _tmp10_);
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	_tmp13_ = NULL;
	type_struct = (_tmp13_ = vala_ccode_struct_new (_tmp12_ = g_strdup_printf ("_%sClass", _tmp11_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp12_ = (g_free (_tmp12_), NULL), _tmp11_ = (g_free (_tmp11_), NULL), _tmp13_);
	if (vala_class_get_base_class (cl) != NULL) {
		char* _tmp14_;
		_tmp14_ = NULL;
		vala_ccode_struct_add_field (instance_struct, _tmp14_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_class_get_base_class (cl), FALSE), "parent_instance");
		_tmp14_ = (g_free (_tmp14_), NULL);
	} else {
		if (is_fundamental) {
			vala_ccode_declaration_space_add_include (decl_space, "glib-object.h", FALSE);
			vala_ccode_struct_add_field (instance_struct, "GTypeInstance", "parent_instance");
			vala_ccode_struct_add_field (instance_struct, "volatile int", "ref_count");
		}
	}
	_tmp15_ = FALSE;
	_tmp16_ = FALSE;
	if (vala_class_get_is_compact (cl)) {
		_tmp16_ = vala_class_get_base_class (cl) == NULL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		GeeList* _tmp17_;
		_tmp17_ = NULL;
		_tmp15_ = gee_collection_get_size ((GeeCollection*) (_tmp17_ = vala_class_get_fields (cl))) == 0;
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (gee_collection_object_unref (_tmp17_), NULL));
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		/* add dummy member, C doesn't allow empty structs*/
		vala_ccode_struct_add_field (instance_struct, "int", "dummy");
	}
	if (is_gtypeinstance) {
		ValaCCodeTypeDefinition* _tmp22_;
		ValaCCodeVariableDeclarator* _tmp21_;
		char* _tmp20_;
		char* _tmp19_;
		char* _tmp18_;
		char* _tmp24_;
		char* _tmp23_;
		_tmp22_ = NULL;
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp22_ = vala_ccode_type_definition_new (_tmp18_ = g_strdup_printf ("struct %sPrivate", vala_ccode_struct_get_name (instance_struct)), (ValaCCodeDeclarator*) (_tmp21_ = vala_ccode_variable_declarator_new (_tmp20_ = g_strdup_printf ("%sPrivate", _tmp19_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), NULL, NULL)))));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		_tmp20_ = (g_free (_tmp20_), NULL);
		_tmp19_ = (g_free (_tmp19_), NULL);
		_tmp18_ = (g_free (_tmp18_), NULL);
		_tmp24_ = NULL;
		_tmp23_ = NULL;
		vala_ccode_struct_add_field (instance_struct, _tmp24_ = g_strdup_printf ("%sPrivate *", _tmp23_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), "priv");
		_tmp24_ = (g_free (_tmp24_), NULL);
		_tmp23_ = (g_free (_tmp23_), NULL);
		if (is_fundamental) {
			vala_ccode_struct_add_field (type_struct, "GTypeClass", "parent_class");
		} else {
			char* _tmp26_;
			char* _tmp25_;
			_tmp26_ = NULL;
			_tmp25_ = NULL;
			vala_ccode_struct_add_field (type_struct, _tmp26_ = g_strdup_printf ("%sClass", _tmp25_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_class_get_base_class (cl), FALSE)), "parent_class");
			_tmp26_ = (g_free (_tmp26_), NULL);
			_tmp25_ = (g_free (_tmp25_), NULL);
		}
		if (is_fundamental) {
			char* _tmp28_;
			char* _tmp27_;
			_tmp28_ = NULL;
			_tmp27_ = NULL;
			vala_ccode_struct_add_field (type_struct, "void", _tmp28_ = g_strdup_printf ("(*finalize) (%s *self)", _tmp27_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)));
			_tmp28_ = (g_free (_tmp28_), NULL);
			_tmp27_ = (g_free (_tmp27_), NULL);
		}
	}
	{
		GeeList* _tmp29_;
		GeeIterator* _tmp30_;
		GeeIterator* _m_it;
		_tmp29_ = NULL;
		_tmp30_ = NULL;
		_m_it = (_tmp30_ = gee_iterable_iterator ((GeeIterable*) (_tmp29_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl))), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (gee_collection_object_unref (_tmp29_), NULL)), _tmp30_);
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			m = (ValaMethod*) gee_iterator_get (_m_it);
			vala_gtype_module_generate_virtual_method_declaration (self, m, decl_space, type_struct);
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	{
		GeeList* _tmp31_;
		GeeIterator* _tmp32_;
		GeeIterator* _prop_it;
		_tmp31_ = NULL;
		_tmp32_ = NULL;
		_prop_it = (_tmp32_ = gee_iterable_iterator ((GeeIterable*) (_tmp31_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), (_tmp31_ == NULL) ? NULL : (_tmp31_ = (gee_collection_object_unref (_tmp31_), NULL)), _tmp32_);
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			gboolean _tmp33_;
			ValaObjectTypeSymbol* _tmp34_;
			ValaObjectTypeSymbol* t;
			gboolean returns_real_struct;
			ValaObjectType* this_type;
			char* _tmp35_;
			ValaCCodeFormalParameter* _tmp36_;
			ValaCCodeFormalParameter* cselfparam;
			ValaCCodeFormalParameter* cvalueparam;
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			_tmp33_ = FALSE;
			if (!vala_property_get_is_abstract (prop)) {
				_tmp33_ = !vala_property_get_is_virtual (prop);
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_property_get_property_type (prop), decl_space);
			_tmp34_ = NULL;
			t = (_tmp34_ = VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp34_ == NULL) ? NULL : vala_code_node_ref (_tmp34_));
			returns_real_struct = vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
			this_type = vala_object_type_new (t);
			_tmp35_ = NULL;
			_tmp36_ = NULL;
			cselfparam = (_tmp36_ = vala_ccode_formal_parameter_new ("self", _tmp35_ = vala_data_type_get_cname ((ValaDataType*) this_type)), _tmp35_ = (g_free (_tmp35_), NULL), _tmp36_);
			cvalueparam = NULL;
			if (returns_real_struct) {
				ValaCCodeFormalParameter* _tmp39_;
				char* _tmp38_;
				char* _tmp37_;
				_tmp39_ = NULL;
				_tmp38_ = NULL;
				_tmp37_ = NULL;
				cvalueparam = (_tmp39_ = vala_ccode_formal_parameter_new ("value", _tmp38_ = g_strconcat (_tmp37_ = vala_data_type_get_cname (vala_property_get_property_type (prop)), "*", NULL)), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp39_);
				_tmp38_ = (g_free (_tmp38_), NULL);
				_tmp37_ = (g_free (_tmp37_), NULL);
			} else {
				ValaCCodeFormalParameter* _tmp41_;
				char* _tmp40_;
				_tmp41_ = NULL;
				_tmp40_ = NULL;
				cvalueparam = (_tmp41_ = vala_ccode_formal_parameter_new ("value", _tmp40_ = vala_data_type_get_cname (vala_property_get_property_type (prop))), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp41_);
				_tmp40_ = (g_free (_tmp40_), NULL);
			}
			if (vala_property_get_get_accessor (prop) != NULL) {
				char* _tmp42_;
				ValaCCodeFunctionDeclarator* _tmp43_;
				ValaCCodeFunctionDeclarator* vdeclarator;
				char* creturn_type;
				ValaCCodeDeclaration* vdecl;
				_tmp42_ = NULL;
				_tmp43_ = NULL;
				vdeclarator = (_tmp43_ = vala_ccode_function_declarator_new (_tmp42_ = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))), _tmp42_ = (g_free (_tmp42_), NULL), _tmp43_);
				vala_ccode_function_declarator_add_parameter (vdeclarator, cselfparam);
				creturn_type = NULL;
				if (returns_real_struct) {
					char* _tmp44_;
					vala_ccode_function_declarator_add_parameter (vdeclarator, cvalueparam);
					_tmp44_ = NULL;
					creturn_type = (_tmp44_ = g_strdup ("void"), creturn_type = (g_free (creturn_type), NULL), _tmp44_);
				} else {
					char* _tmp45_;
					_tmp45_ = NULL;
					creturn_type = (_tmp45_ = vala_data_type_get_cname (vala_property_get_property_type (prop)), creturn_type = (g_free (creturn_type), NULL), _tmp45_);
				}
				vdecl = vala_ccode_declaration_new (creturn_type);
				vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
				vala_ccode_struct_add_declaration (type_struct, vdecl);
				(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
				creturn_type = (g_free (creturn_type), NULL);
				(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
			}
			if (vala_property_get_set_accessor (prop) != NULL) {
				char* _tmp46_;
				ValaCCodeFunctionDeclarator* _tmp47_;
				ValaCCodeFunctionDeclarator* vdeclarator;
				ValaCCodeDeclaration* vdecl;
				_tmp46_ = NULL;
				_tmp47_ = NULL;
				vdeclarator = (_tmp47_ = vala_ccode_function_declarator_new (_tmp46_ = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))), _tmp46_ = (g_free (_tmp46_), NULL), _tmp47_);
				vala_ccode_function_declarator_add_parameter (vdeclarator, cselfparam);
				vala_ccode_function_declarator_add_parameter (vdeclarator, cvalueparam);
				vdecl = vala_ccode_declaration_new ("void");
				vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
				vala_ccode_struct_add_declaration (type_struct, vdecl);
				(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
				(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
			(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
			(cselfparam == NULL) ? NULL : (cselfparam = (vala_ccode_node_unref (cselfparam), NULL));
			(cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	{
		GeeList* _tmp48_;
		GeeIterator* _tmp49_;
		GeeIterator* _f_it;
		_tmp48_ = NULL;
		_tmp49_ = NULL;
		_f_it = (_tmp49_ = gee_iterable_iterator ((GeeIterable*) (_tmp48_ = vala_class_get_fields (cl))), (_tmp48_ == NULL) ? NULL : (_tmp48_ = (gee_collection_object_unref (_tmp48_), NULL)), _tmp49_);
		while (gee_iterator_next (_f_it)) {
			ValaField* f;
			char* field_ctype;
			gboolean _tmp51_;
			f = (ValaField*) gee_iterator_get (_f_it);
			field_ctype = vala_data_type_get_cname (vala_field_get_field_type (f));
			if (vala_field_get_is_volatile (f)) {
				char* _tmp50_;
				_tmp50_ = NULL;
				field_ctype = (_tmp50_ = g_strconcat ("volatile ", field_ctype, NULL), field_ctype = (g_free (field_ctype), NULL), _tmp50_);
			}
			_tmp51_ = FALSE;
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				_tmp51_ = vala_symbol_get_access ((ValaSymbol*) f) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp51_ = FALSE;
			}
			if (_tmp51_) {
				char* _tmp52_;
				gboolean _tmp53_;
				vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f), decl_space);
				_tmp52_ = NULL;
				vala_ccode_struct_add_field (instance_struct, field_ctype, _tmp52_ = vala_field_get_cname (f));
				_tmp52_ = (g_free (_tmp52_), NULL);
				_tmp53_ = FALSE;
				if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
					_tmp53_ = !vala_field_get_no_array_length (f);
				} else {
					_tmp53_ = FALSE;
				}
				if (_tmp53_) {
					ValaArrayType* _tmp54_;
					ValaArrayType* array_type;
					ValaDataType* len_type;
					gboolean _tmp57_;
					/* create fields to store array dimensions*/
					_tmp54_ = NULL;
					array_type = (_tmp54_ = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp54_ == NULL) ? NULL : vala_code_node_ref (_tmp54_));
					len_type = vala_data_type_copy (((ValaCCodeBaseModule*) self)->int_type);
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp56_;
							char* _tmp55_;
							_tmp56_ = NULL;
							_tmp55_ = NULL;
							vala_ccode_struct_add_field (instance_struct, _tmp55_ = vala_data_type_get_cname (len_type), _tmp56_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) f), dim));
							_tmp56_ = (g_free (_tmp56_), NULL);
							_tmp55_ = (g_free (_tmp55_), NULL);
						}
					}
					_tmp57_ = FALSE;
					if (vala_array_type_get_rank (array_type) == 1) {
						_tmp57_ = vala_symbol_is_internal_symbol ((ValaSymbol*) f);
					} else {
						_tmp57_ = FALSE;
					}
					if (_tmp57_) {
						char* _tmp59_;
						char* _tmp58_;
						_tmp59_ = NULL;
						_tmp58_ = NULL;
						vala_ccode_struct_add_field (instance_struct, _tmp58_ = vala_data_type_get_cname (len_type), _tmp59_ = vala_ccode_module_get_array_size_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) f)));
						_tmp59_ = (g_free (_tmp59_), NULL);
						_tmp58_ = (g_free (_tmp58_), NULL);
					}
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
				} else {
					if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
						ValaDelegateType* _tmp60_;
						ValaDelegateType* delegate_type;
						_tmp60_ = NULL;
						delegate_type = (_tmp60_ = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp60_ == NULL) ? NULL : vala_code_node_ref (_tmp60_));
						if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
							char* _tmp61_;
							/* create field to store delegate target*/
							_tmp61_ = NULL;
							vala_ccode_struct_add_field (instance_struct, "gpointer", _tmp61_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) f)));
							_tmp61_ = (g_free (_tmp61_), NULL);
						}
						(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
					}
				}
			} else {
				gboolean _tmp62_;
				_tmp62_ = FALSE;
				if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
					_tmp62_ = vala_symbol_get_access ((ValaSymbol*) f) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp62_ = FALSE;
				}
				if (_tmp62_) {
					char* _tmp63_;
					_tmp63_ = NULL;
					vala_ccode_struct_add_field (type_struct, field_ctype, _tmp63_ = vala_field_get_cname (f));
					_tmp63_ = (g_free (_tmp63_), NULL);
				}
			}
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			field_ctype = (g_free (field_ctype), NULL);
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) cl)) != NULL) {
		ValaCCodeComment* _tmp64_;
		_tmp64_ = NULL;
		vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp64_ = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) cl)))));
		(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_ccode_node_unref (_tmp64_), NULL));
	}
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) instance_struct);
	if (is_gtypeinstance) {
		vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) type_struct);
	}
	(instance_struct == NULL) ? NULL : (instance_struct = (vala_ccode_node_unref (instance_struct), NULL));
	(type_struct == NULL) ? NULL : (type_struct = (vala_ccode_node_unref (type_struct), NULL));
}


static void vala_gtype_module_real_generate_virtual_method_declaration (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct) {
	gboolean _tmp0_;
	ValaCCodeFunctionDeclarator* vdeclarator;
	GeeHashMap* cparam_map;
	ValaCCodeFunction* _tmp1_;
	char* _tmp2_;
	ValaCCodeDeclaration* _tmp3_;
	ValaCCodeDeclaration* vdecl;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (type_struct != NULL);
	_tmp0_ = FALSE;
	if (!vala_method_get_is_abstract (m)) {
		_tmp0_ = !vala_method_get_is_virtual (m);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	/* add vfunc field to the type struct*/
	vdeclarator = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m));
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp1_ = NULL;
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, decl_space, (GeeMap*) cparam_map, _tmp1_ = vala_ccode_function_new ("fake", "void"), vdeclarator, NULL, NULL, 3);
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	vdecl = (_tmp3_ = vala_ccode_declaration_new (_tmp2_ = vala_data_type_get_cname (vala_method_get_return_type (m))), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
	vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
	vala_ccode_struct_add_declaration (type_struct, vdecl);
	(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
}


void vala_gtype_module_generate_virtual_method_declaration (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct) {
	VALA_GTYPE_MODULE_GET_CLASS (self)->generate_virtual_method_declaration (self, m, decl_space, type_struct);
}


static void vala_gtype_module_generate_class_private_declaration (ValaGTypeModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space) {
	char* _tmp1_;
	char* _tmp0_;
	gboolean _tmp2_;
	gboolean is_gtypeinstance;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeStruct* _tmp5_;
	ValaCCodeStruct* instance_priv_struct;
	char* _tmp7_;
	char* _tmp6_;
	ValaCCodeStruct* _tmp8_;
	ValaCCodeStruct* type_priv_struct;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	if ((_tmp2_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) cl, _tmp1_ = g_strconcat (_tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "Private", NULL)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_)) {
		return;
	}
	is_gtypeinstance = !vala_class_get_is_compact (cl);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp5_ = NULL;
	instance_priv_struct = (_tmp5_ = vala_ccode_struct_new (_tmp4_ = g_strdup_printf ("_%sPrivate", _tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp4_ = (g_free (_tmp4_), NULL), _tmp3_ = (g_free (_tmp3_), NULL), _tmp5_);
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	_tmp8_ = NULL;
	type_priv_struct = (_tmp8_ = vala_ccode_struct_new (_tmp7_ = g_strdup_printf ("_%sClassPrivate", _tmp6_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp7_ = (g_free (_tmp7_), NULL), _tmp6_ = (g_free (_tmp6_), NULL), _tmp8_);
	if (is_gtypeinstance) {
		/* create type, dup_func, and destroy_func fields for generic types */
		{
			GeeList* _tmp9_;
			GeeIterator* _tmp10_;
			GeeIterator* _type_param_it;
			/* create type, dup_func, and destroy_func fields for generic types */
			_tmp9_ = NULL;
			_tmp10_ = NULL;
			_type_param_it = (_tmp10_ = gee_iterable_iterator ((GeeIterable*) (_tmp9_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (gee_collection_object_unref (_tmp9_), NULL)), _tmp10_);
			/* create type, dup_func, and destroy_func fields for generic types */
			while (gee_iterator_next (_type_param_it)) {
				ValaTypeParameter* type_param;
				char* func_name;
				char* _tmp12_;
				char* _tmp11_;
				char* _tmp14_;
				char* _tmp13_;
				char* _tmp16_;
				char* _tmp15_;
				/* create type, dup_func, and destroy_func fields for generic types */
				type_param = (ValaTypeParameter*) gee_iterator_get (_type_param_it);
				func_name = NULL;
				_tmp12_ = NULL;
				_tmp11_ = NULL;
				func_name = (_tmp12_ = g_strdup_printf ("%s_type", _tmp11_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp12_);
				_tmp11_ = (g_free (_tmp11_), NULL);
				vala_ccode_struct_add_field (instance_priv_struct, "GType", func_name);
				_tmp14_ = NULL;
				_tmp13_ = NULL;
				func_name = (_tmp14_ = g_strdup_printf ("%s_dup_func", _tmp13_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp14_);
				_tmp13_ = (g_free (_tmp13_), NULL);
				vala_ccode_struct_add_field (instance_priv_struct, "GBoxedCopyFunc", func_name);
				_tmp16_ = NULL;
				_tmp15_ = NULL;
				func_name = (_tmp16_ = g_strdup_printf ("%s_destroy_func", _tmp15_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp16_);
				_tmp15_ = (g_free (_tmp15_), NULL);
				vala_ccode_struct_add_field (instance_priv_struct, "GDestroyNotify", func_name);
				(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
				func_name = (g_free (func_name), NULL);
			}
			(_type_param_it == NULL) ? NULL : (_type_param_it = (gee_collection_object_unref (_type_param_it), NULL));
		}
	}
	{
		GeeList* _tmp17_;
		GeeIterator* _tmp18_;
		GeeIterator* _f_it;
		_tmp17_ = NULL;
		_tmp18_ = NULL;
		_f_it = (_tmp18_ = gee_iterable_iterator ((GeeIterable*) (_tmp17_ = vala_class_get_fields (cl))), (_tmp17_ == NULL) ? NULL : (_tmp17_ = (gee_collection_object_unref (_tmp17_), NULL)), _tmp18_);
		while (gee_iterator_next (_f_it)) {
			ValaField* f;
			char* field_ctype;
			gboolean _tmp20_;
			f = (ValaField*) gee_iterator_get (_f_it);
			field_ctype = vala_data_type_get_cname (vala_field_get_field_type (f));
			if (vala_field_get_is_volatile (f)) {
				char* _tmp19_;
				_tmp19_ = NULL;
				field_ctype = (_tmp19_ = g_strconcat ("volatile ", field_ctype, NULL), field_ctype = (g_free (field_ctype), NULL), _tmp19_);
			}
			_tmp20_ = FALSE;
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				_tmp20_ = vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				char* _tmp21_;
				gboolean _tmp22_;
				vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_field_get_field_type (f), decl_space);
				_tmp21_ = NULL;
				vala_ccode_struct_add_field (instance_priv_struct, field_ctype, _tmp21_ = vala_field_get_cname (f));
				_tmp21_ = (g_free (_tmp21_), NULL);
				_tmp22_ = FALSE;
				if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
					_tmp22_ = !vala_field_get_no_array_length (f);
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					ValaArrayType* _tmp23_;
					ValaArrayType* array_type;
					ValaDataType* len_type;
					gboolean _tmp26_;
					/* create fields to store array dimensions*/
					_tmp23_ = NULL;
					array_type = (_tmp23_ = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp23_ == NULL) ? NULL : vala_code_node_ref (_tmp23_));
					len_type = vala_data_type_copy (((ValaCCodeBaseModule*) self)->int_type);
					{
						gint dim;
						dim = 1;
						for (; dim <= vala_array_type_get_rank (array_type); dim++) {
							char* _tmp25_;
							char* _tmp24_;
							_tmp25_ = NULL;
							_tmp24_ = NULL;
							vala_ccode_struct_add_field (instance_priv_struct, _tmp24_ = vala_data_type_get_cname (len_type), _tmp25_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) f), dim));
							_tmp25_ = (g_free (_tmp25_), NULL);
							_tmp24_ = (g_free (_tmp24_), NULL);
						}
					}
					_tmp26_ = FALSE;
					if (vala_array_type_get_rank (array_type) == 1) {
						_tmp26_ = vala_symbol_is_internal_symbol ((ValaSymbol*) f);
					} else {
						_tmp26_ = FALSE;
					}
					if (_tmp26_) {
						char* _tmp28_;
						char* _tmp27_;
						_tmp28_ = NULL;
						_tmp27_ = NULL;
						vala_ccode_struct_add_field (instance_priv_struct, _tmp27_ = vala_data_type_get_cname (len_type), _tmp28_ = vala_ccode_module_get_array_size_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) f)));
						_tmp28_ = (g_free (_tmp28_), NULL);
						_tmp27_ = (g_free (_tmp27_), NULL);
					}
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
				} else {
					if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
						ValaDelegateType* _tmp29_;
						ValaDelegateType* delegate_type;
						_tmp29_ = NULL;
						delegate_type = (_tmp29_ = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp29_ == NULL) ? NULL : vala_code_node_ref (_tmp29_));
						if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
							char* _tmp30_;
							/* create field to store delegate target*/
							_tmp30_ = NULL;
							vala_ccode_struct_add_field (instance_priv_struct, "gpointer", _tmp30_ = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) f)));
							_tmp30_ = (g_free (_tmp30_), NULL);
						}
						(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
					}
				}
				if (vala_lockable_get_lock_used ((ValaLockable*) f)) {
					char* _tmp32_;
					char* _tmp31_;
					/* add field for mutex*/
					_tmp32_ = NULL;
					_tmp31_ = NULL;
					vala_ccode_struct_add_field (instance_priv_struct, _tmp31_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->mutex_type, FALSE), _tmp32_ = vala_ccode_base_module_get_symbol_lock_name ((ValaCCodeBaseModule*) self, (ValaSymbol*) f));
					_tmp32_ = (g_free (_tmp32_), NULL);
					_tmp31_ = (g_free (_tmp31_), NULL);
				}
			} else {
				gboolean _tmp33_;
				_tmp33_ = FALSE;
				if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
					_tmp33_ = vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp33_ = FALSE;
				}
				if (_tmp33_) {
					char* _tmp34_;
					_tmp34_ = NULL;
					vala_ccode_struct_add_field (type_priv_struct, field_ctype, _tmp34_ = vala_field_get_cname (f));
					_tmp34_ = (g_free (_tmp34_), NULL);
				}
			}
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
			field_ctype = (g_free (field_ctype), NULL);
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	if (is_gtypeinstance) {
		gboolean _tmp44_;
		if (vala_class_get_has_class_private_fields (cl)) {
			ValaCCodeTypeDefinition* _tmp39_;
			ValaCCodeVariableDeclarator* _tmp38_;
			char* _tmp37_;
			char* _tmp36_;
			char* _tmp35_;
			ValaCCodeDeclaration* _cdecl_;
			ValaCCodeVariableDeclarator* _tmp43_;
			ValaCCodeConstant* _tmp42_;
			char* _tmp41_;
			char* _tmp40_;
			_tmp39_ = NULL;
			_tmp38_ = NULL;
			_tmp37_ = NULL;
			_tmp36_ = NULL;
			_tmp35_ = NULL;
			vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp39_ = vala_ccode_type_definition_new (_tmp35_ = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (type_priv_struct)), (ValaCCodeDeclarator*) (_tmp38_ = vala_ccode_variable_declarator_new (_tmp37_ = g_strdup_printf ("%sClassPrivate", _tmp36_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), NULL, NULL)))));
			(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
			(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
			_tmp37_ = (g_free (_tmp37_), NULL);
			_tmp36_ = (g_free (_tmp36_), NULL);
			_tmp35_ = (g_free (_tmp35_), NULL);
			_cdecl_ = vala_ccode_declaration_new ("GQuark");
			_tmp43_ = NULL;
			_tmp42_ = NULL;
			_tmp41_ = NULL;
			_tmp40_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp43_ = vala_ccode_variable_declarator_new (_tmp41_ = g_strdup_printf ("_vala_%s_class_private_quark", _tmp40_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), (ValaCCodeExpression*) (_tmp42_ = vala_ccode_constant_new ("0")), NULL)));
			(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
			(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
			_tmp41_ = (g_free (_tmp41_), NULL);
			_tmp40_ = (g_free (_tmp40_), NULL);
			vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
			vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) _cdecl_);
			(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
		}
		_tmp44_ = FALSE;
		if (vala_class_get_has_private_fields (cl)) {
			_tmp44_ = TRUE;
		} else {
			GeeList* _tmp45_;
			_tmp45_ = NULL;
			_tmp44_ = gee_collection_get_size ((GeeCollection*) (_tmp45_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
			(_tmp45_ == NULL) ? NULL : (_tmp45_ = (gee_collection_object_unref (_tmp45_), NULL));
		}
		/* only add the *Private struct if it is not empty, i.e. we actually have private data */
		if (_tmp44_) {
			char* _tmp47_;
			char* _tmp46_;
			char* _tmp48_;
			char* macro;
			ValaCCodeMacroReplacement* _tmp51_;
			char* _tmp50_;
			char* _tmp49_;
			vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) instance_priv_struct);
			_tmp47_ = NULL;
			_tmp46_ = NULL;
			_tmp48_ = NULL;
			macro = (_tmp48_ = g_strdup_printf ("(G_TYPE_INSTANCE_GET_PRIVATE ((o), %s, %sPrivate))", _tmp46_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl), _tmp47_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), _tmp47_ = (g_free (_tmp47_), NULL), _tmp46_ = (g_free (_tmp46_), NULL), _tmp48_);
			_tmp51_ = NULL;
			_tmp50_ = NULL;
			_tmp49_ = NULL;
			vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) (_tmp51_ = vala_ccode_macro_replacement_new (_tmp50_ = g_strdup_printf ("%s_GET_PRIVATE(o)", _tmp49_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), macro)));
			(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
			_tmp50_ = (g_free (_tmp50_), NULL);
			_tmp49_ = (g_free (_tmp49_), NULL);
			macro = (g_free (macro), NULL);
		}
		if (vala_class_get_has_class_private_fields (cl)) {
			char* _tmp53_;
			char* _tmp52_;
			char* _tmp54_;
			char* macro;
			ValaCCodeMacroReplacement* _tmp57_;
			char* _tmp56_;
			char* _tmp55_;
			vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) type_priv_struct);
			_tmp53_ = NULL;
			_tmp52_ = NULL;
			_tmp54_ = NULL;
			macro = (_tmp54_ = g_strdup_printf ("((%sClassPrivate *) g_type_get_qdata (type, _vala_%s_class_private_quark))", _tmp52_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), _tmp53_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), _tmp53_ = (g_free (_tmp53_), NULL), _tmp52_ = (g_free (_tmp52_), NULL), _tmp54_);
			_tmp57_ = NULL;
			_tmp56_ = NULL;
			_tmp55_ = NULL;
			vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) (_tmp57_ = vala_ccode_macro_replacement_new (_tmp56_ = g_strdup_printf ("%s_GET_CLASS_PRIVATE(type)", _tmp55_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), macro)));
			(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
			_tmp56_ = (g_free (_tmp56_), NULL);
			_tmp55_ = (g_free (_tmp55_), NULL);
			macro = (g_free (macro), NULL);
		}
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->prop_enum);
	} else {
		char* _tmp59_;
		char* _tmp58_;
		ValaCCodeFunction* _tmp60_;
		ValaCCodeFunction* function;
		ValaCCodeFormalParameter* _tmp63_;
		char* _tmp62_;
		char* _tmp61_;
		_tmp59_ = NULL;
		_tmp58_ = NULL;
		_tmp60_ = NULL;
		function = (_tmp60_ = vala_ccode_function_new (_tmp59_ = g_strconcat (_tmp58_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "free", NULL), "void"), _tmp59_ = (g_free (_tmp59_), NULL), _tmp58_ = (g_free (_tmp58_), NULL), _tmp60_);
		if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp63_ = NULL;
		_tmp62_ = NULL;
		_tmp61_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp63_ = vala_ccode_formal_parameter_new ("self", _tmp62_ = g_strconcat (_tmp61_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)));
		(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
		_tmp62_ = (g_free (_tmp62_), NULL);
		_tmp61_ = (g_free (_tmp61_), NULL);
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) function);
		(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	}
	(instance_priv_struct == NULL) ? NULL : (instance_priv_struct = (vala_ccode_node_unref (instance_priv_struct), NULL));
	(type_priv_struct == NULL) ? NULL : (type_priv_struct = (vala_ccode_node_unref (type_priv_struct), NULL));
}


static void vala_gtype_module_real_visit_class (ValaCCodeModule* base, ValaClass* cl) {
	ValaGTypeModule * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* old_symbol;
	ValaTypeSymbol* _tmp1_;
	ValaTypeSymbol* old_type_symbol;
	ValaClass* _tmp2_;
	ValaClass* old_class;
	ValaCCodeStruct* _tmp3_;
	ValaCCodeStruct* old_param_spec_struct;
	ValaCCodeEnum* _tmp4_;
	ValaCCodeEnum* old_prop_enum;
	ValaCCodeFragment* _tmp5_;
	ValaCCodeFragment* old_class_init_fragment;
	ValaCCodeFragment* _tmp6_;
	ValaCCodeFragment* old_base_init_fragment;
	ValaCCodeFragment* _tmp7_;
	ValaCCodeFragment* old_class_finalize_fragment;
	ValaCCodeFragment* _tmp8_;
	ValaCCodeFragment* old_base_finalize_fragment;
	ValaCCodeFragment* _tmp9_;
	ValaCCodeFragment* old_instance_init_fragment;
	ValaCCodeFragment* _tmp10_;
	ValaCCodeFragment* old_instance_finalize_fragment;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp11_;
	ValaTypeSymbol* _tmp14_;
	ValaTypeSymbol* _tmp13_;
	ValaClass* _tmp16_;
	ValaClass* _tmp15_;
	gboolean is_gtypeinstance;
	gboolean _tmp17_;
	gboolean is_fundamental;
	char* _tmp18_;
	gboolean _tmp19_;
	ValaCCodeEnum* _tmp22_;
	ValaCCodeEnumValue* _tmp25_;
	char* _tmp24_;
	char* _tmp23_;
	ValaCCodeFragment* _tmp26_;
	ValaCCodeFragment* _tmp27_;
	ValaCCodeFragment* _tmp28_;
	ValaCCodeFragment* _tmp29_;
	ValaCCodeFragment* _tmp30_;
	ValaCCodeFragment* _tmp31_;
	ValaSymbol* _tmp118_;
	ValaSymbol* _tmp117_;
	ValaTypeSymbol* _tmp120_;
	ValaTypeSymbol* _tmp119_;
	ValaClass* _tmp122_;
	ValaClass* _tmp121_;
	ValaCCodeStruct* _tmp124_;
	ValaCCodeStruct* _tmp123_;
	ValaCCodeEnum* _tmp126_;
	ValaCCodeEnum* _tmp125_;
	ValaCCodeFragment* _tmp128_;
	ValaCCodeFragment* _tmp127_;
	ValaCCodeFragment* _tmp130_;
	ValaCCodeFragment* _tmp129_;
	ValaCCodeFragment* _tmp132_;
	ValaCCodeFragment* _tmp131_;
	ValaCCodeFragment* _tmp134_;
	ValaCCodeFragment* _tmp133_;
	ValaCCodeFragment* _tmp136_;
	ValaCCodeFragment* _tmp135_;
	ValaCCodeFragment* _tmp138_;
	ValaCCodeFragment* _tmp137_;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = NULL;
	old_symbol = (_tmp0_ = ((ValaCCodeBaseModule*) self)->current_symbol, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	_tmp1_ = NULL;
	old_type_symbol = (_tmp1_ = ((ValaCCodeBaseModule*) self)->current_type_symbol, (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = NULL;
	old_class = (_tmp2_ = ((ValaCCodeBaseModule*) self)->current_class, (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	_tmp3_ = NULL;
	old_param_spec_struct = (_tmp3_ = ((ValaCCodeBaseModule*) self)->param_spec_struct, (_tmp3_ == NULL) ? NULL : vala_ccode_node_ref (_tmp3_));
	_tmp4_ = NULL;
	old_prop_enum = (_tmp4_ = ((ValaCCodeBaseModule*) self)->prop_enum, (_tmp4_ == NULL) ? NULL : vala_ccode_node_ref (_tmp4_));
	_tmp5_ = NULL;
	old_class_init_fragment = (_tmp5_ = ((ValaCCodeBaseModule*) self)->class_init_fragment, (_tmp5_ == NULL) ? NULL : vala_ccode_node_ref (_tmp5_));
	_tmp6_ = NULL;
	old_base_init_fragment = (_tmp6_ = ((ValaCCodeBaseModule*) self)->base_init_fragment, (_tmp6_ == NULL) ? NULL : vala_ccode_node_ref (_tmp6_));
	_tmp7_ = NULL;
	old_class_finalize_fragment = (_tmp7_ = ((ValaCCodeBaseModule*) self)->class_finalize_fragment, (_tmp7_ == NULL) ? NULL : vala_ccode_node_ref (_tmp7_));
	_tmp8_ = NULL;
	old_base_finalize_fragment = (_tmp8_ = ((ValaCCodeBaseModule*) self)->base_finalize_fragment, (_tmp8_ == NULL) ? NULL : vala_ccode_node_ref (_tmp8_));
	_tmp9_ = NULL;
	old_instance_init_fragment = (_tmp9_ = ((ValaCCodeBaseModule*) self)->instance_init_fragment, (_tmp9_ == NULL) ? NULL : vala_ccode_node_ref (_tmp9_));
	_tmp10_ = NULL;
	old_instance_finalize_fragment = (_tmp10_ = ((ValaCCodeBaseModule*) self)->instance_finalize_fragment, (_tmp10_ == NULL) ? NULL : vala_ccode_node_ref (_tmp10_));
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp12_ = (_tmp11_ = (ValaSymbol*) cl, (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp12_);
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp14_ = (_tmp13_ = (ValaTypeSymbol*) cl, (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp14_);
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	((ValaCCodeBaseModule*) self)->current_class = (_tmp16_ = (_tmp15_ = cl, (_tmp15_ == NULL) ? NULL : vala_code_node_ref (_tmp15_)), (((ValaCCodeBaseModule*) self)->current_class == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_class = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_class), NULL)), _tmp16_);
	is_gtypeinstance = !vala_class_get_is_compact (cl);
	_tmp17_ = FALSE;
	if (is_gtypeinstance) {
		_tmp17_ = vala_class_get_base_class (cl) == NULL;
	} else {
		_tmp17_ = FALSE;
	}
	is_fundamental = _tmp17_;
	_tmp18_ = NULL;
	if ((_tmp19_ = g_utf8_strlen (_tmp18_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), -1) < 3, _tmp18_ = (g_free (_tmp18_), NULL), _tmp19_)) {
		char* _tmp21_;
		char* _tmp20_;
		vala_code_node_set_error ((ValaCodeNode*) cl, TRUE);
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) cl), _tmp21_ = g_strdup_printf ("Class name `%s' is too short", _tmp20_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)));
		_tmp21_ = (g_free (_tmp21_), NULL);
		_tmp20_ = (g_free (_tmp20_), NULL);
		(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
		(old_type_symbol == NULL) ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL));
		(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
		(old_param_spec_struct == NULL) ? NULL : (old_param_spec_struct = (vala_ccode_node_unref (old_param_spec_struct), NULL));
		(old_prop_enum == NULL) ? NULL : (old_prop_enum = (vala_ccode_node_unref (old_prop_enum), NULL));
		(old_class_init_fragment == NULL) ? NULL : (old_class_init_fragment = (vala_ccode_node_unref (old_class_init_fragment), NULL));
		(old_base_init_fragment == NULL) ? NULL : (old_base_init_fragment = (vala_ccode_node_unref (old_base_init_fragment), NULL));
		(old_class_finalize_fragment == NULL) ? NULL : (old_class_finalize_fragment = (vala_ccode_node_unref (old_class_finalize_fragment), NULL));
		(old_base_finalize_fragment == NULL) ? NULL : (old_base_finalize_fragment = (vala_ccode_node_unref (old_base_finalize_fragment), NULL));
		(old_instance_init_fragment == NULL) ? NULL : (old_instance_init_fragment = (vala_ccode_node_unref (old_instance_init_fragment), NULL));
		(old_instance_finalize_fragment == NULL) ? NULL : (old_instance_finalize_fragment = (vala_ccode_node_unref (old_instance_finalize_fragment), NULL));
		return;
	}
	_tmp22_ = NULL;
	((ValaCCodeBaseModule*) self)->prop_enum = (_tmp22_ = vala_ccode_enum_new (NULL), (((ValaCCodeBaseModule*) self)->prop_enum == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->prop_enum = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->prop_enum), NULL)), _tmp22_);
	_tmp25_ = NULL;
	_tmp24_ = NULL;
	_tmp23_ = NULL;
	vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp25_ = vala_ccode_enum_value_new (_tmp24_ = g_strdup_printf ("%s_DUMMY_PROPERTY", _tmp23_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), NULL));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp24_ = (g_free (_tmp24_), NULL);
	_tmp23_ = (g_free (_tmp23_), NULL);
	_tmp26_ = NULL;
	((ValaCCodeBaseModule*) self)->class_init_fragment = (_tmp26_ = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->class_init_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->class_init_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->class_init_fragment), NULL)), _tmp26_);
	_tmp27_ = NULL;
	((ValaCCodeBaseModule*) self)->base_init_fragment = (_tmp27_ = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->base_init_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->base_init_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->base_init_fragment), NULL)), _tmp27_);
	_tmp28_ = NULL;
	((ValaCCodeBaseModule*) self)->class_finalize_fragment = (_tmp28_ = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->class_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->class_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->class_finalize_fragment), NULL)), _tmp28_);
	_tmp29_ = NULL;
	((ValaCCodeBaseModule*) self)->base_finalize_fragment = (_tmp29_ = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->base_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->base_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->base_finalize_fragment), NULL)), _tmp29_);
	_tmp30_ = NULL;
	((ValaCCodeBaseModule*) self)->instance_init_fragment = (_tmp30_ = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->instance_init_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_init_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_init_fragment), NULL)), _tmp30_);
	_tmp31_ = NULL;
	((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (_tmp31_ = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->instance_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_finalize_fragment), NULL)), _tmp31_);
	vala_ccode_base_module_generate_class_struct_declaration ((ValaCCodeBaseModule*) self, cl, ((ValaCCodeBaseModule*) self)->source_declarations);
	vala_gtype_module_generate_class_private_declaration (self, cl, ((ValaCCodeBaseModule*) self)->source_declarations);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) cl)) {
		vala_ccode_base_module_generate_class_struct_declaration ((ValaCCodeBaseModule*) self, cl, ((ValaCCodeBaseModule*) self)->header_declarations);
	}
	vala_ccode_base_module_generate_class_struct_declaration ((ValaCCodeBaseModule*) self, cl, ((ValaCCodeBaseModule*) self)->internal_header_declarations);
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (is_gtypeinstance) {
		gboolean _tmp45_;
		gboolean _tmp46_;
		gboolean _tmp49_;
		ValaClassRegisterFunction* type_fun;
		ValaCCodeFragment* _tmp54_;
		if (is_fundamental) {
			ValaCCodeStruct* _tmp34_;
			char* _tmp33_;
			char* _tmp32_;
			ValaCCodeTypeDefinition* _tmp39_;
			ValaCCodeVariableDeclarator* _tmp38_;
			char* _tmp37_;
			char* _tmp36_;
			char* _tmp35_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeMemberAccess* _tmp41_;
			ValaCCodeIdentifier* _tmp40_;
			ValaCCodeAssignment* _tmp43_;
			ValaCCodeAssignment* ref_count;
			ValaCCodeExpressionStatement* _tmp44_;
			_tmp34_ = NULL;
			_tmp33_ = NULL;
			_tmp32_ = NULL;
			((ValaCCodeBaseModule*) self)->param_spec_struct = (_tmp34_ = vala_ccode_struct_new (_tmp33_ = g_strdup_printf ("_%sParamSpec%s", _tmp32_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) cl)), vala_symbol_get_name ((ValaSymbol*) cl))), (((ValaCCodeBaseModule*) self)->param_spec_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->param_spec_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->param_spec_struct), NULL)), _tmp34_);
			_tmp33_ = (g_free (_tmp33_), NULL);
			_tmp32_ = (g_free (_tmp32_), NULL);
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->param_spec_struct, "GParamSpec", "parent_instance");
			vala_ccode_declaration_space_add_type_definition (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->param_spec_struct);
			_tmp39_ = NULL;
			_tmp38_ = NULL;
			_tmp37_ = NULL;
			_tmp36_ = NULL;
			_tmp35_ = NULL;
			vala_ccode_declaration_space_add_type_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp39_ = vala_ccode_type_definition_new (_tmp35_ = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (((ValaCCodeBaseModule*) self)->param_spec_struct)), (ValaCCodeDeclarator*) (_tmp38_ = vala_ccode_variable_declarator_new (_tmp37_ = g_strdup_printf ("%sParamSpec%s", _tmp36_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) cl)), vala_symbol_get_name ((ValaSymbol*) cl)), NULL, NULL)))));
			(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
			(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
			_tmp37_ = (g_free (_tmp37_), NULL);
			_tmp36_ = (g_free (_tmp36_), NULL);
			_tmp35_ = (g_free (_tmp35_), NULL);
			((ValaCCodeBaseModule*) self)->gvaluecollector_h_needed = TRUE;
			vala_gtype_module_add_type_value_table_init_function (self, cl);
			vala_gtype_module_add_type_value_table_free_function (self, cl);
			vala_gtype_module_add_type_value_table_copy_function (self, cl);
			vala_gtype_module_add_type_value_table_peek_pointer_function (self, cl);
			vala_gtype_module_add_type_value_table_collect_value_function (self, cl);
			vala_gtype_module_add_type_value_table_lcopy_value_function (self, cl);
			vala_gtype_module_add_g_param_spec_type_function (self, cl);
			vala_gtype_module_add_g_value_get_function (self, cl);
			vala_gtype_module_add_g_value_set_function (self, cl);
			_tmp42_ = NULL;
			_tmp41_ = NULL;
			_tmp40_ = NULL;
			_tmp43_ = NULL;
			ref_count = (_tmp43_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp41_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("self")), "ref_count")), (ValaCCodeExpression*) (_tmp42_ = vala_ccode_constant_new ("1")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL)), (_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL)), (_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL)), _tmp43_);
			_tmp44_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->instance_init_fragment, (ValaCCodeNode*) (_tmp44_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ref_count)));
			(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
			(ref_count == NULL) ? NULL : (ref_count = (vala_ccode_node_unref (ref_count), NULL));
		}
		_tmp45_ = FALSE;
		if (vala_class_get_class_constructor (cl) != NULL) {
			_tmp45_ = TRUE;
		} else {
			_tmp45_ = vala_class_get_has_class_private_fields (cl);
		}
		if (_tmp45_) {
			vala_gtype_module_add_base_init_function (self, cl);
		}
		vala_gtype_module_add_class_init_function (self, cl);
		_tmp46_ = FALSE;
		if (vala_class_get_class_destructor (cl) != NULL) {
			_tmp46_ = TRUE;
		} else {
			_tmp46_ = vala_class_get_has_class_private_fields (cl);
		}
		if (_tmp46_) {
			vala_gtype_module_add_base_finalize_function (self, cl);
		}
		if (vala_class_get_static_destructor (cl) != NULL) {
			vala_gtype_module_add_class_finalize_function (self, cl);
		}
		{
			GeeList* _tmp47_;
			GeeIterator* _tmp48_;
			GeeIterator* _base_type_it;
			_tmp47_ = NULL;
			_tmp48_ = NULL;
			_base_type_it = (_tmp48_ = gee_iterable_iterator ((GeeIterable*) (_tmp47_ = vala_class_get_base_types (cl))), (_tmp47_ == NULL) ? NULL : (_tmp47_ = (gee_collection_object_unref (_tmp47_), NULL)), _tmp48_);
			while (gee_iterator_next (_base_type_it)) {
				ValaDataType* base_type;
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					vala_gtype_module_add_interface_init_function (self, cl, VALA_INTERFACE (vala_data_type_get_data_type (base_type)));
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
		vala_gtype_module_add_instance_init_function (self, cl);
		_tmp49_ = FALSE;
		if (!vala_class_get_is_compact (cl)) {
			gboolean _tmp50_;
			gboolean _tmp51_;
			GeeList* _tmp52_;
			gboolean _tmp53_;
			_tmp50_ = FALSE;
			_tmp51_ = FALSE;
			_tmp52_ = NULL;
			if ((_tmp53_ = gee_collection_get_size ((GeeCollection*) (_tmp52_ = vala_class_get_fields (cl))) > 0, (_tmp52_ == NULL) ? NULL : (_tmp52_ = (gee_collection_object_unref (_tmp52_), NULL)), _tmp53_)) {
				_tmp51_ = TRUE;
			} else {
				_tmp51_ = vala_class_get_destructor (cl) != NULL;
			}
			if (_tmp51_) {
				_tmp50_ = TRUE;
			} else {
				_tmp50_ = vala_class_is_fundamental (cl);
			}
			_tmp49_ = _tmp50_;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			vala_gtype_module_add_finalize_function (self, cl);
		}
		type_fun = vala_class_register_function_new (cl, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
		vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, ((ValaCCodeBaseModule*) self)->in_plugin);
		_tmp54_ = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp54_ = vala_typeregister_function_get_definition ((ValaTypeRegisterFunction*) type_fun)));
		(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
		if (((ValaCCodeBaseModule*) self)->in_plugin) {
			ValaCCodeIdentifier* _tmp57_;
			char* _tmp56_;
			char* _tmp55_;
			ValaCCodeFunctionCall* _tmp58_;
			ValaCCodeFunctionCall* register_call;
			ValaCCodeIdentifier* _tmp59_;
			ValaCCodeExpressionStatement* _tmp60_;
			/* FIXME resolve potential dependency issues, i.e. base types have to be registered before derived types*/
			_tmp57_ = NULL;
			_tmp56_ = NULL;
			_tmp55_ = NULL;
			_tmp58_ = NULL;
			register_call = (_tmp58_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp57_ = vala_ccode_identifier_new (_tmp56_ = g_strdup_printf ("%s_register_type", _tmp55_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL))))), (_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL)), _tmp56_ = (g_free (_tmp56_), NULL), _tmp55_ = (g_free (_tmp55_), NULL), _tmp58_);
			_tmp59_ = NULL;
			vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new (((ValaCCodeBaseModule*) self)->module_init_param_name)));
			(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
			_tmp60_ = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->module_init_fragment, (ValaCCodeNode*) (_tmp60_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) register_call)));
			(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
			(register_call == NULL) ? NULL : (register_call = (vala_ccode_node_unref (register_call), NULL));
		}
		if (is_fundamental) {
			char* _tmp62_;
			char* _tmp61_;
			ValaCCodeFunction* _tmp63_;
			ValaCCodeFunction* ref_fun;
			char* _tmp65_;
			char* _tmp64_;
			ValaCCodeFunction* _tmp66_;
			ValaCCodeFunction* unref_fun;
			ValaCCodeFormalParameter* _tmp67_;
			ValaCCodeFormalParameter* _tmp68_;
			ValaCCodeBlock* ref_block;
			ValaCCodeBlock* unref_block;
			char* _tmp70_;
			char* _tmp69_;
			ValaCCodeDeclaration* _tmp71_;
			ValaCCodeDeclaration* _cdecl_;
			ValaCCodeVariableDeclarator* _tmp73_;
			ValaCCodeIdentifier* _tmp72_;
			ValaCCodeIdentifier* _tmp74_;
			ValaCCodeMemberAccess* _tmp75_;
			ValaCCodeMemberAccess* ref_count;
			ValaCCodeIdentifier* _tmp76_;
			ValaCCodeFunctionCall* _tmp77_;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeUnaryExpression* _tmp78_;
			ValaCCodeExpressionStatement* _tmp79_;
			ValaCCodeReturnStatement* _tmp81_;
			ValaCCodeIdentifier* _tmp80_;
			ValaCCodeBlock* destroy_block;
			ValaCCodeIdentifier* _tmp84_;
			char* _tmp83_;
			char* _tmp82_;
			ValaCCodeFunctionCall* _tmp85_;
			ValaCCodeFunctionCall* get_class;
			ValaCCodeIdentifier* _tmp86_;
			ValaCCodeIdentifier* _tmp89_;
			char* _tmp88_;
			char* _tmp87_;
			ValaCCodeFunctionCall* _tmp90_;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp91_;
			ValaCCodeFunctionCall* _tmp93_;
			ValaCCodeMemberAccess* _tmp92_;
			ValaCCodeIdentifier* _tmp94_;
			ValaCCodeExpressionStatement* _tmp95_;
			ValaCCodeIdentifier* _tmp96_;
			ValaCCodeFunctionCall* _tmp97_;
			ValaCCodeFunctionCall* free;
			ValaCCodeCastExpression* _tmp99_;
			ValaCCodeIdentifier* _tmp98_;
			ValaCCodeExpressionStatement* _tmp100_;
			ValaCCodeFunctionCall* _tmp102_;
			ValaCCodeIdentifier* _tmp101_;
			ValaCCodeUnaryExpression* _tmp103_;
			ValaCCodeIfStatement* _tmp104_;
			_tmp62_ = NULL;
			_tmp61_ = NULL;
			_tmp63_ = NULL;
			ref_fun = (_tmp63_ = vala_ccode_function_new (_tmp62_ = g_strconcat (_tmp61_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "ref", NULL), "gpointer"), _tmp62_ = (g_free (_tmp62_), NULL), _tmp61_ = (g_free (_tmp61_), NULL), _tmp63_);
			_tmp65_ = NULL;
			_tmp64_ = NULL;
			_tmp66_ = NULL;
			unref_fun = (_tmp66_ = vala_ccode_function_new (_tmp65_ = g_strconcat (_tmp64_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "unref", NULL), "void"), _tmp65_ = (g_free (_tmp65_), NULL), _tmp64_ = (g_free (_tmp64_), NULL), _tmp66_);
			if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				vala_ccode_function_set_modifiers (ref_fun, VALA_CCODE_MODIFIERS_STATIC);
				vala_ccode_function_set_modifiers (unref_fun, VALA_CCODE_MODIFIERS_STATIC);
			}
			_tmp67_ = NULL;
			vala_ccode_function_add_parameter (ref_fun, _tmp67_ = vala_ccode_formal_parameter_new ("instance", "gpointer"));
			(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
			_tmp68_ = NULL;
			vala_ccode_function_add_parameter (unref_fun, _tmp68_ = vala_ccode_formal_parameter_new ("instance", "gpointer"));
			(_tmp68_ == NULL) ? NULL : (_tmp68_ = (vala_ccode_node_unref (_tmp68_), NULL));
			ref_block = vala_ccode_block_new ();
			unref_block = vala_ccode_block_new ();
			_tmp70_ = NULL;
			_tmp69_ = NULL;
			_tmp71_ = NULL;
			_cdecl_ = (_tmp71_ = vala_ccode_declaration_new (_tmp70_ = g_strconcat (_tmp69_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp70_ = (g_free (_tmp70_), NULL), _tmp69_ = (g_free (_tmp69_), NULL), _tmp71_);
			_tmp73_ = NULL;
			_tmp72_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp73_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) (_tmp72_ = vala_ccode_identifier_new ("instance")), NULL)));
			(_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_ccode_node_unref (_tmp73_), NULL));
			(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
			vala_ccode_block_add_statement (ref_block, (ValaCCodeNode*) _cdecl_);
			vala_ccode_block_add_statement (unref_block, (ValaCCodeNode*) _cdecl_);
			_tmp74_ = NULL;
			_tmp75_ = NULL;
			ref_count = (_tmp75_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp74_ = vala_ccode_identifier_new ("self")), "ref_count"), (_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL)), _tmp75_);
			_tmp76_ = NULL;
			_tmp77_ = NULL;
			ccall = (_tmp77_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp76_ = vala_ccode_identifier_new ("g_atomic_int_inc"))), (_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL)), _tmp77_);
			_tmp78_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp78_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ref_count)));
			(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
			_tmp79_ = NULL;
			vala_ccode_block_add_statement (ref_block, (ValaCCodeNode*) (_tmp79_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
			_tmp81_ = NULL;
			_tmp80_ = NULL;
			vala_ccode_block_add_statement (ref_block, (ValaCCodeNode*) (_tmp81_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp80_ = vala_ccode_identifier_new ("instance")))));
			(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
			(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
			destroy_block = vala_ccode_block_new ();
			_tmp84_ = NULL;
			_tmp83_ = NULL;
			_tmp82_ = NULL;
			_tmp85_ = NULL;
			get_class = (_tmp85_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp84_ = vala_ccode_identifier_new (_tmp83_ = g_strdup_printf ("%s_GET_CLASS", _tmp82_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL)), _tmp83_ = (g_free (_tmp83_), NULL), _tmp82_ = (g_free (_tmp82_), NULL), _tmp85_);
			_tmp86_ = NULL;
			vala_ccode_function_call_add_argument (get_class, (ValaCCodeExpression*) (_tmp86_ = vala_ccode_identifier_new ("self")));
			(_tmp86_ == NULL) ? NULL : (_tmp86_ = (vala_ccode_node_unref (_tmp86_), NULL));
			/* finalize class*/
			_tmp89_ = NULL;
			_tmp88_ = NULL;
			_tmp87_ = NULL;
			_tmp90_ = NULL;
			ccast = (_tmp90_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp89_ = vala_ccode_identifier_new (_tmp88_ = g_strdup_printf ("%s_GET_CLASS", _tmp87_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL)), _tmp88_ = (g_free (_tmp88_), NULL), _tmp87_ = (g_free (_tmp87_), NULL), _tmp90_);
			_tmp91_ = NULL;
			vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp91_ = vala_ccode_identifier_new ("self")));
			(_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL));
			_tmp93_ = NULL;
			_tmp92_ = NULL;
			ccall = (_tmp93_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp92_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, "finalize"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp93_);
			(_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_ccode_node_unref (_tmp92_), NULL));
			_tmp94_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp94_ = vala_ccode_identifier_new ("self")));
			(_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_ccode_node_unref (_tmp94_), NULL));
			_tmp95_ = NULL;
			vala_ccode_block_add_statement (destroy_block, (ValaCCodeNode*) (_tmp95_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL));
			/* free type instance*/
			_tmp96_ = NULL;
			_tmp97_ = NULL;
			free = (_tmp97_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp96_ = vala_ccode_identifier_new ("g_type_free_instance"))), (_tmp96_ == NULL) ? NULL : (_tmp96_ = (vala_ccode_node_unref (_tmp96_), NULL)), _tmp97_);
			_tmp99_ = NULL;
			_tmp98_ = NULL;
			vala_ccode_function_call_add_argument (free, (ValaCCodeExpression*) (_tmp99_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp98_ = vala_ccode_identifier_new ("self")), "GTypeInstance *")));
			(_tmp99_ == NULL) ? NULL : (_tmp99_ = (vala_ccode_node_unref (_tmp99_), NULL));
			(_tmp98_ == NULL) ? NULL : (_tmp98_ = (vala_ccode_node_unref (_tmp98_), NULL));
			_tmp100_ = NULL;
			vala_ccode_block_add_statement (destroy_block, (ValaCCodeNode*) (_tmp100_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) free)));
			(_tmp100_ == NULL) ? NULL : (_tmp100_ = (vala_ccode_node_unref (_tmp100_), NULL));
			_tmp102_ = NULL;
			_tmp101_ = NULL;
			ccall = (_tmp102_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp101_ = vala_ccode_identifier_new ("g_atomic_int_dec_and_test"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp102_);
			(_tmp101_ == NULL) ? NULL : (_tmp101_ = (vala_ccode_node_unref (_tmp101_), NULL));
			_tmp103_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp103_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ref_count)));
			(_tmp103_ == NULL) ? NULL : (_tmp103_ = (vala_ccode_node_unref (_tmp103_), NULL));
			_tmp104_ = NULL;
			vala_ccode_block_add_statement (unref_block, (ValaCCodeNode*) (_tmp104_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccall, (ValaCCodeStatement*) destroy_block, NULL)));
			(_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_ccode_node_unref (_tmp104_), NULL));
			vala_ccode_function_set_block (ref_fun, ref_block);
			vala_ccode_function_set_block (unref_fun, unref_block);
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ref_fun);
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) unref_fun);
			(ref_fun == NULL) ? NULL : (ref_fun = (vala_ccode_node_unref (ref_fun), NULL));
			(unref_fun == NULL) ? NULL : (unref_fun = (vala_ccode_node_unref (unref_fun), NULL));
			(ref_block == NULL) ? NULL : (ref_block = (vala_ccode_node_unref (ref_block), NULL));
			(unref_block == NULL) ? NULL : (unref_block = (vala_ccode_node_unref (unref_block), NULL));
			(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
			(ref_count == NULL) ? NULL : (ref_count = (vala_ccode_node_unref (ref_count), NULL));
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			(destroy_block == NULL) ? NULL : (destroy_block = (vala_ccode_node_unref (destroy_block), NULL));
			(get_class == NULL) ? NULL : (get_class = (vala_ccode_node_unref (get_class), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
			(free == NULL) ? NULL : (free = (vala_ccode_node_unref (free), NULL));
		}
		(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
	} else {
		char* _tmp106_;
		char* _tmp105_;
		ValaCCodeFunction* _tmp107_;
		ValaCCodeFunction* function;
		ValaCCodeFormalParameter* _tmp110_;
		char* _tmp109_;
		char* _tmp108_;
		ValaCCodeBlock* cblock;
		ValaCCodeIdentifier* _tmp111_;
		ValaCCodeFunctionCall* _tmp112_;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp114_;
		char* _tmp113_;
		ValaCCodeIdentifier* _tmp115_;
		ValaCCodeExpressionStatement* _tmp116_;
		vala_gtype_module_add_instance_init_function (self, cl);
		_tmp106_ = NULL;
		_tmp105_ = NULL;
		_tmp107_ = NULL;
		function = (_tmp107_ = vala_ccode_function_new (_tmp106_ = g_strconcat (_tmp105_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "free", NULL), "void"), _tmp106_ = (g_free (_tmp106_), NULL), _tmp105_ = (g_free (_tmp105_), NULL), _tmp107_);
		if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp110_ = NULL;
		_tmp109_ = NULL;
		_tmp108_ = NULL;
		vala_ccode_function_add_parameter (function, _tmp110_ = vala_ccode_formal_parameter_new ("self", _tmp109_ = g_strconcat (_tmp108_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)));
		(_tmp110_ == NULL) ? NULL : (_tmp110_ = (vala_ccode_node_unref (_tmp110_), NULL));
		_tmp109_ = (g_free (_tmp109_), NULL);
		_tmp108_ = (g_free (_tmp108_), NULL);
		cblock = vala_ccode_block_new ();
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_finalize_fragment);
		if (vala_class_get_destructor (cl) != NULL) {
			vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_class_get_destructor (cl)));
		}
		_tmp111_ = NULL;
		_tmp112_ = NULL;
		ccall = (_tmp112_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp111_ = vala_ccode_identifier_new ("g_slice_free"))), (_tmp111_ == NULL) ? NULL : (_tmp111_ = (vala_ccode_node_unref (_tmp111_), NULL)), _tmp112_);
		_tmp114_ = NULL;
		_tmp113_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp114_ = vala_ccode_identifier_new (_tmp113_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
		(_tmp114_ == NULL) ? NULL : (_tmp114_ = (vala_ccode_node_unref (_tmp114_), NULL));
		_tmp113_ = (g_free (_tmp113_), NULL);
		_tmp115_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp115_ = vala_ccode_identifier_new ("self")));
		(_tmp115_ == NULL) ? NULL : (_tmp115_ = (vala_ccode_node_unref (_tmp115_), NULL));
		_tmp116_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp116_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp116_ == NULL) ? NULL : (_tmp116_ = (vala_ccode_node_unref (_tmp116_), NULL));
		vala_ccode_function_set_block (function, cblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
		(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
		(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	}
	_tmp118_ = NULL;
	_tmp117_ = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp118_ = (_tmp117_ = old_symbol, (_tmp117_ == NULL) ? NULL : vala_code_node_ref (_tmp117_)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp118_);
	_tmp120_ = NULL;
	_tmp119_ = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp120_ = (_tmp119_ = old_type_symbol, (_tmp119_ == NULL) ? NULL : vala_code_node_ref (_tmp119_)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp120_);
	_tmp122_ = NULL;
	_tmp121_ = NULL;
	((ValaCCodeBaseModule*) self)->current_class = (_tmp122_ = (_tmp121_ = old_class, (_tmp121_ == NULL) ? NULL : vala_code_node_ref (_tmp121_)), (((ValaCCodeBaseModule*) self)->current_class == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_class = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_class), NULL)), _tmp122_);
	_tmp124_ = NULL;
	_tmp123_ = NULL;
	((ValaCCodeBaseModule*) self)->param_spec_struct = (_tmp124_ = (_tmp123_ = old_param_spec_struct, (_tmp123_ == NULL) ? NULL : vala_ccode_node_ref (_tmp123_)), (((ValaCCodeBaseModule*) self)->param_spec_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->param_spec_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->param_spec_struct), NULL)), _tmp124_);
	_tmp126_ = NULL;
	_tmp125_ = NULL;
	((ValaCCodeBaseModule*) self)->prop_enum = (_tmp126_ = (_tmp125_ = old_prop_enum, (_tmp125_ == NULL) ? NULL : vala_ccode_node_ref (_tmp125_)), (((ValaCCodeBaseModule*) self)->prop_enum == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->prop_enum = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->prop_enum), NULL)), _tmp126_);
	_tmp128_ = NULL;
	_tmp127_ = NULL;
	((ValaCCodeBaseModule*) self)->class_init_fragment = (_tmp128_ = (_tmp127_ = old_class_init_fragment, (_tmp127_ == NULL) ? NULL : vala_ccode_node_ref (_tmp127_)), (((ValaCCodeBaseModule*) self)->class_init_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->class_init_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->class_init_fragment), NULL)), _tmp128_);
	_tmp130_ = NULL;
	_tmp129_ = NULL;
	((ValaCCodeBaseModule*) self)->base_init_fragment = (_tmp130_ = (_tmp129_ = old_base_init_fragment, (_tmp129_ == NULL) ? NULL : vala_ccode_node_ref (_tmp129_)), (((ValaCCodeBaseModule*) self)->base_init_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->base_init_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->base_init_fragment), NULL)), _tmp130_);
	_tmp132_ = NULL;
	_tmp131_ = NULL;
	((ValaCCodeBaseModule*) self)->class_finalize_fragment = (_tmp132_ = (_tmp131_ = old_class_finalize_fragment, (_tmp131_ == NULL) ? NULL : vala_ccode_node_ref (_tmp131_)), (((ValaCCodeBaseModule*) self)->class_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->class_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->class_finalize_fragment), NULL)), _tmp132_);
	_tmp134_ = NULL;
	_tmp133_ = NULL;
	((ValaCCodeBaseModule*) self)->base_finalize_fragment = (_tmp134_ = (_tmp133_ = old_base_finalize_fragment, (_tmp133_ == NULL) ? NULL : vala_ccode_node_ref (_tmp133_)), (((ValaCCodeBaseModule*) self)->base_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->base_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->base_finalize_fragment), NULL)), _tmp134_);
	_tmp136_ = NULL;
	_tmp135_ = NULL;
	((ValaCCodeBaseModule*) self)->instance_init_fragment = (_tmp136_ = (_tmp135_ = old_instance_init_fragment, (_tmp135_ == NULL) ? NULL : vala_ccode_node_ref (_tmp135_)), (((ValaCCodeBaseModule*) self)->instance_init_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_init_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_init_fragment), NULL)), _tmp136_);
	_tmp138_ = NULL;
	_tmp137_ = NULL;
	((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (_tmp138_ = (_tmp137_ = old_instance_finalize_fragment, (_tmp137_ == NULL) ? NULL : vala_ccode_node_ref (_tmp137_)), (((ValaCCodeBaseModule*) self)->instance_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_finalize_fragment), NULL)), _tmp138_);
	(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
	(old_type_symbol == NULL) ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL));
	(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
	(old_param_spec_struct == NULL) ? NULL : (old_param_spec_struct = (vala_ccode_node_unref (old_param_spec_struct), NULL));
	(old_prop_enum == NULL) ? NULL : (old_prop_enum = (vala_ccode_node_unref (old_prop_enum), NULL));
	(old_class_init_fragment == NULL) ? NULL : (old_class_init_fragment = (vala_ccode_node_unref (old_class_init_fragment), NULL));
	(old_base_init_fragment == NULL) ? NULL : (old_base_init_fragment = (vala_ccode_node_unref (old_base_init_fragment), NULL));
	(old_class_finalize_fragment == NULL) ? NULL : (old_class_finalize_fragment = (vala_ccode_node_unref (old_class_finalize_fragment), NULL));
	(old_base_finalize_fragment == NULL) ? NULL : (old_base_finalize_fragment = (vala_ccode_node_unref (old_base_finalize_fragment), NULL));
	(old_instance_init_fragment == NULL) ? NULL : (old_instance_init_fragment = (vala_ccode_node_unref (old_instance_init_fragment), NULL));
	(old_instance_finalize_fragment == NULL) ? NULL : (old_instance_finalize_fragment = (vala_ccode_node_unref (old_instance_finalize_fragment), NULL));
}


static void vala_gtype_module_add_type_value_table_init_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeBlock* init_block;
	ValaCCodeExpressionStatement* _tmp9_;
	ValaCCodeAssignment* _tmp8_;
	ValaCCodeConstant* _tmp7_;
	ValaCCodeMemberAccess* _tmp6_;
	ValaCCodeMemberAccess* _tmp5_;
	ValaCCodeIdentifier* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	function = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_init", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("value", "GValue*"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp9_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE)), (ValaCCodeExpression*) (_tmp7_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
}


static void vala_gtype_module_add_type_value_table_free_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeBlock* init_block;
	ValaCCodeMemberAccess* _tmp5_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeMemberAccess* _tmp6_;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeIdentifier* _tmp9_;
	char* _tmp8_;
	char* _tmp7_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBlock* ifbody;
	ValaCCodeExpressionStatement* _tmp11_;
	ValaCCodeIfStatement* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	function = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_free_value", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("value", "GValue*"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp6_ = NULL;
	vpointer = (_tmp6_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp6_);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp10_ = NULL;
	ccall = (_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new (_tmp8_ = g_strconcat (_tmp7_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "unref", NULL)))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), _tmp8_ = (g_free (_tmp8_), NULL), _tmp7_ = (g_free (_tmp7_), NULL), _tmp10_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) vpointer);
	ifbody = vala_ccode_block_new ();
	_tmp11_ = NULL;
	vala_ccode_block_add_statement (ifbody, (ValaCCodeNode*) (_tmp11_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp12_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp12_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) vpointer, (ValaCCodeStatement*) ifbody, NULL)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(ifbody == NULL) ? NULL : (ifbody = (vala_ccode_node_unref (ifbody), NULL));
}


static void vala_gtype_module_add_type_value_table_copy_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeBlock* init_block;
	ValaCCodeMemberAccess* _tmp6_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeMemberAccess* _tmp7_;
	ValaCCodeMemberAccess* dest_vpointer;
	ValaCCodeMemberAccess* _tmp9_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeMemberAccess* _tmp10_;
	ValaCCodeMemberAccess* src_vpointer;
	ValaCCodeIdentifier* _tmp13_;
	char* _tmp12_;
	char* _tmp11_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* ref_ccall;
	ValaCCodeBlock* true_stmt;
	ValaCCodeExpressionStatement* _tmp16_;
	ValaCCodeAssignment* _tmp15_;
	ValaCCodeBlock* false_stmt;
	ValaCCodeExpressionStatement* _tmp19_;
	ValaCCodeAssignment* _tmp18_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeIfStatement* if_statement;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	function = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_copy_value", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("src_value", "const GValue*"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp4_ = vala_ccode_formal_parameter_new ("dest_value", "GValue*"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	_tmp7_ = NULL;
	dest_vpointer = (_tmp7_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("dest_value")), "data[0]")), "v_pointer", FALSE), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp7_);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp10_ = NULL;
	src_vpointer = (_tmp10_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp9_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("src_value")), "data[0]")), "v_pointer", FALSE), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp10_);
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	_tmp14_ = NULL;
	ref_ccall = (_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new (_tmp12_ = g_strconcat (_tmp11_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "ref", NULL)))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp12_ = (g_free (_tmp12_), NULL), _tmp11_ = (g_free (_tmp11_), NULL), _tmp14_);
	vala_ccode_function_call_add_argument (ref_ccall, (ValaCCodeExpression*) src_vpointer);
	true_stmt = vala_ccode_block_new ();
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp16_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_assignment_new ((ValaCCodeExpression*) dest_vpointer, (ValaCCodeExpression*) ref_ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	false_stmt = vala_ccode_block_new ();
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	vala_ccode_block_add_statement (false_stmt, (ValaCCodeNode*) (_tmp19_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_assignment_new ((ValaCCodeExpression*) dest_vpointer, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	if_statement = vala_ccode_if_statement_new ((ValaCCodeExpression*) src_vpointer, (ValaCCodeStatement*) true_stmt, (ValaCCodeStatement*) false_stmt);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_statement);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(dest_vpointer == NULL) ? NULL : (dest_vpointer = (vala_ccode_node_unref (dest_vpointer), NULL));
	(src_vpointer == NULL) ? NULL : (src_vpointer = (vala_ccode_node_unref (src_vpointer), NULL));
	(ref_ccall == NULL) ? NULL : (ref_ccall = (vala_ccode_node_unref (ref_ccall), NULL));
	(true_stmt == NULL) ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL));
	(false_stmt == NULL) ? NULL : (false_stmt = (vala_ccode_node_unref (false_stmt), NULL));
	(if_statement == NULL) ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL));
}


static void vala_gtype_module_add_type_value_table_peek_pointer_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeBlock* init_block;
	ValaCCodeMemberAccess* _tmp5_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeMemberAccess* _tmp6_;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeReturnStatement* ret;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	function = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_peek_pointer", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "gpointer"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("value", "const GValue*"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp6_ = NULL;
	vpointer = (_tmp6_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp6_);
	ret = vala_ccode_return_statement_new ((ValaCCodeExpression*) vpointer);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ret);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(ret == NULL) ? NULL : (ret = (vala_ccode_node_unref (ret), NULL));
}


static void vala_gtype_module_add_type_value_table_lcopy_value_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeFormalParameter* _tmp6_;
	ValaCCodeMemberAccess* _tmp8_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeMemberAccess* _tmp9_;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeIdentifier* object_p_ptr;
	ValaCCodeConstant* null_;
	ValaCCodeBlock* init_block;
	char* _tmp11_;
	char* _tmp10_;
	ValaCCodeDeclaration* _tmp12_;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeMemberAccess* _tmp14_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeFunctionCall* _tmp17_;
	ValaCCodeFunctionCall* value_type_name_fct;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeUnaryExpression* _tmp20_;
	ValaCCodeUnaryExpression* assert_condition;
	ValaCCodeBlock* assert_true;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* assert_printf;
	ValaCCodeConstant* _tmp23_;
	ValaCCodeReturnStatement* _tmp24_;
	ValaCCodeIfStatement* if_assert;
	ValaCCodeBlock* main_else_true;
	ValaCCodeBlock* main_else_if_true;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeBinaryExpression* _tmp27_;
	ValaCCodeBinaryExpression* main_else_if_condition;
	ValaCCodeIfStatement* main_else_if;
	ValaCCodeBlock* main_true;
	ValaCCodeUnaryExpression* main_condition;
	ValaCCodeIfStatement* if_main;
	ValaCCodeIdentifier* _tmp29_;
	char* _tmp28_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeFunctionCall* ref_fct;
	ValaCCodeExpressionStatement* _tmp32_;
	ValaCCodeAssignment* _tmp31_;
	ValaCCodeExpressionStatement* _tmp34_;
	ValaCCodeAssignment* _tmp33_;
	ValaCCodeExpressionStatement* _tmp36_;
	ValaCCodeAssignment* _tmp35_;
	ValaCCodeReturnStatement* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	function = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_lcopy_value", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "gchar*"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("value", "const GValue*"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp4_ = vala_ccode_formal_parameter_new ("n_collect_values", "guint"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp5_ = vala_ccode_formal_parameter_new ("collect_values", "GTypeCValue*"));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp6_ = vala_ccode_formal_parameter_new ("collect_flags", "guint"));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp9_ = NULL;
	vpointer = (_tmp9_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), _tmp9_);
	object_p_ptr = vala_ccode_identifier_new ("*object_p");
	null_ = vala_ccode_constant_new ("NULL");
	init_block = vala_ccode_block_new ();
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	_tmp12_ = NULL;
	ctypedecl = (_tmp12_ = vala_ccode_declaration_new (_tmp11_ = g_strconcat (_tmp10_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "**", NULL)), _tmp11_ = (g_free (_tmp11_), NULL), _tmp10_ = (g_free (_tmp10_), NULL), _tmp12_);
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp15_ = vala_ccode_variable_declarator_new ("object_p", (ValaCCodeExpression*) (_tmp14_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("collect_values[0]")), "v_pointer", FALSE)), NULL)));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ctypedecl);
	_tmp16_ = NULL;
	_tmp17_ = NULL;
	value_type_name_fct = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("G_VALUE_TYPE_NAME"))), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp17_);
	_tmp18_ = NULL;
	vala_ccode_function_call_add_argument (value_type_name_fct, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_constant_new ("value")));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	_tmp19_ = NULL;
	_tmp20_ = NULL;
	assert_condition = (_tmp20_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("object_p"))), (_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL)), _tmp20_);
	vala_ccode_function_set_block (function, init_block);
	assert_true = vala_ccode_block_new ();
	_tmp21_ = NULL;
	_tmp22_ = NULL;
	assert_printf = (_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("g_strdup_printf"))), (_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL)), _tmp22_);
	_tmp23_ = NULL;
	vala_ccode_function_call_add_argument (assert_printf, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_constant_new ("\"value location for `%s' passed as NULL\"")));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	vala_ccode_function_call_add_argument (assert_printf, (ValaCCodeExpression*) value_type_name_fct);
	_tmp24_ = NULL;
	vala_ccode_block_add_statement (assert_true, (ValaCCodeNode*) (_tmp24_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) assert_printf)));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	if_assert = vala_ccode_if_statement_new ((ValaCCodeExpression*) assert_condition, (ValaCCodeStatement*) assert_true, NULL);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_assert);
	main_else_true = vala_ccode_block_new ();
	main_else_if_true = vala_ccode_block_new ();
	_tmp26_ = NULL;
	_tmp25_ = NULL;
	_tmp27_ = NULL;
	main_else_if_condition = (_tmp27_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("collect_flags")), (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("G_VALUE_NOCOPY_CONTENTS"))), (_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL)), (_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL)), _tmp27_);
	main_else_if = vala_ccode_if_statement_new ((ValaCCodeExpression*) main_else_if_condition, (ValaCCodeStatement*) main_else_if_true, (ValaCCodeStatement*) main_else_true);
	main_true = vala_ccode_block_new ();
	main_condition = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaCCodeExpression*) vpointer);
	if_main = vala_ccode_if_statement_new ((ValaCCodeExpression*) main_condition, (ValaCCodeStatement*) main_true, (ValaCCodeStatement*) main_else_if);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_main);
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	_tmp30_ = NULL;
	ref_fct = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new (_tmp28_ = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) cl)))), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL)), _tmp28_ = (g_free (_tmp28_), NULL), _tmp30_);
	vala_ccode_function_call_add_argument (ref_fct, (ValaCCodeExpression*) vpointer);
	_tmp32_ = NULL;
	_tmp31_ = NULL;
	vala_ccode_block_add_statement (main_true, (ValaCCodeNode*) (_tmp32_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_assignment_new ((ValaCCodeExpression*) object_p_ptr, (ValaCCodeExpression*) null_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	_tmp34_ = NULL;
	_tmp33_ = NULL;
	vala_ccode_block_add_statement (main_else_if_true, (ValaCCodeNode*) (_tmp34_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_assignment_new ((ValaCCodeExpression*) object_p_ptr, (ValaCCodeExpression*) vpointer, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	_tmp36_ = NULL;
	_tmp35_ = NULL;
	vala_ccode_block_add_statement (main_else_true, (ValaCCodeNode*) (_tmp36_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_assignment_new ((ValaCCodeExpression*) object_p_ptr, (ValaCCodeExpression*) ref_fct, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
	(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	_tmp37_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp37_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) null_)));
	(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(object_p_ptr == NULL) ? NULL : (object_p_ptr = (vala_ccode_node_unref (object_p_ptr), NULL));
	(null_ == NULL) ? NULL : (null_ = (vala_ccode_node_unref (null_), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
	(value_type_name_fct == NULL) ? NULL : (value_type_name_fct = (vala_ccode_node_unref (value_type_name_fct), NULL));
	(assert_condition == NULL) ? NULL : (assert_condition = (vala_ccode_node_unref (assert_condition), NULL));
	(assert_true == NULL) ? NULL : (assert_true = (vala_ccode_node_unref (assert_true), NULL));
	(assert_printf == NULL) ? NULL : (assert_printf = (vala_ccode_node_unref (assert_printf), NULL));
	(if_assert == NULL) ? NULL : (if_assert = (vala_ccode_node_unref (if_assert), NULL));
	(main_else_true == NULL) ? NULL : (main_else_true = (vala_ccode_node_unref (main_else_true), NULL));
	(main_else_if_true == NULL) ? NULL : (main_else_if_true = (vala_ccode_node_unref (main_else_if_true), NULL));
	(main_else_if_condition == NULL) ? NULL : (main_else_if_condition = (vala_ccode_node_unref (main_else_if_condition), NULL));
	(main_else_if == NULL) ? NULL : (main_else_if = (vala_ccode_node_unref (main_else_if), NULL));
	(main_true == NULL) ? NULL : (main_true = (vala_ccode_node_unref (main_true), NULL));
	(main_condition == NULL) ? NULL : (main_condition = (vala_ccode_node_unref (main_condition), NULL));
	(if_main == NULL) ? NULL : (if_main = (vala_ccode_node_unref (if_main), NULL));
	(ref_fct == NULL) ? NULL : (ref_fct = (vala_ccode_node_unref (ref_fct), NULL));
}


static void vala_gtype_module_add_type_value_table_collect_value_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeFormalParameter* _tmp6_;
	ValaCCodeMemberAccess* _tmp8_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeMemberAccess* _tmp9_;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeBlock* init_block;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeMemberAccess* _tmp11_;
	ValaCCodeMemberAccess* collect_vpointer;
	ValaCCodeBlock* true_stmt;
	ValaCCodeBlock* false_stmt;
	ValaCCodeIfStatement* if_statement;
	ValaCCodeIdentifier* obj_identifier;
	char* _tmp13_;
	char* _tmp12_;
	ValaCCodeDeclaration* _tmp14_;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeMemberAccess* _tmp16_;
	ValaCCodeMemberAccess* _tmp17_;
	ValaCCodeMemberAccess* l_expression;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeBinaryExpression* _tmp19_;
	ValaCCodeBinaryExpression* sub_condition;
	ValaCCodeBlock* sub_true_stmt;
	ValaCCodeBlock* sub_false_stmt;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunctionCall* type_check;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* type_name_fct;
	ValaCCodeIdentifier* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeFunctionCall* stored_type;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeFunctionCall* value_type_name_fct;
	ValaCCodeConstant* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunctionCall* _tmp34_;
	ValaCCodeFunctionCall* true_return;
	ValaCCodeConstant* _tmp35_;
	ValaCCodeConstant* _tmp36_;
	ValaCCodeConstant* _tmp37_;
	ValaCCodeReturnStatement* _tmp38_;
	ValaCCodeIdentifier* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* false_return;
	ValaCCodeConstant* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeReturnStatement* _tmp45_;
	ValaCCodeUnaryExpression* _tmp46_;
	ValaCCodeIfStatement* _tmp47_;
	ValaCCodeIfStatement* sub_else_if_statement;
	ValaCCodeIfStatement* sub_if_statement;
	ValaCCodeIdentifier* _tmp49_;
	char* _tmp48_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeFunctionCall* ref_call;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeAssignment* _tmp52_;
	ValaCCodeExpressionStatement* _tmp53_;
	ValaCCodeExpressionStatement* true_assignment;
	ValaCCodeAssignment* _tmp55_;
	ValaCCodeConstant* _tmp54_;
	ValaCCodeExpressionStatement* _tmp56_;
	ValaCCodeExpressionStatement* else_assigment;
	ValaCCodeReturnStatement* _tmp58_;
	ValaCCodeConstant* _tmp57_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	function = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_collect_value", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "gchar*"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("value", "GValue*"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp4_ = vala_ccode_formal_parameter_new ("n_collect_values", "guint"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp5_ = vala_ccode_formal_parameter_new ("collect_values", "GTypeCValue*"));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp6_ = vala_ccode_formal_parameter_new ("collect_flags", "guint"));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp9_ = NULL;
	vpointer = (_tmp9_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), _tmp9_);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	collect_vpointer = (_tmp11_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("collect_values[0]")), "v_pointer", FALSE), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
	true_stmt = vala_ccode_block_new ();
	false_stmt = vala_ccode_block_new ();
	if_statement = vala_ccode_if_statement_new ((ValaCCodeExpression*) collect_vpointer, (ValaCCodeStatement*) true_stmt, (ValaCCodeStatement*) false_stmt);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_statement);
	obj_identifier = vala_ccode_identifier_new ("object");
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	_tmp14_ = NULL;
	ctypedecl = (_tmp14_ = vala_ccode_declaration_new (_tmp13_ = g_strconcat (_tmp12_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp13_ = (g_free (_tmp13_), NULL), _tmp12_ = (g_free (_tmp12_), NULL), _tmp14_);
	_tmp15_ = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp15_ = vala_ccode_variable_declarator_new ("object", (ValaCCodeExpression*) collect_vpointer, NULL)));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) ctypedecl);
	_tmp16_ = NULL;
	_tmp17_ = NULL;
	l_expression = (_tmp17_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) obj_identifier, "parent_instance")), "g_class", FALSE), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp17_);
	_tmp18_ = NULL;
	_tmp19_ = NULL;
	sub_condition = (_tmp19_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) l_expression, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_constant_new ("NULL"))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp19_);
	sub_true_stmt = vala_ccode_block_new ();
	sub_false_stmt = vala_ccode_block_new ();
	_tmp20_ = NULL;
	_tmp21_ = NULL;
	reg_call = (_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("g_value_type_compatible"))), (_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL)), _tmp21_);
	_tmp22_ = NULL;
	_tmp23_ = NULL;
	type_check = (_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE"))), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL)), _tmp23_);
	_tmp24_ = NULL;
	vala_ccode_function_call_add_argument (type_check, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("object")));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) type_check);
	_tmp25_ = NULL;
	_tmp26_ = NULL;
	type_name_fct = (_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("g_type_name"))), (_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL)), _tmp26_);
	vala_ccode_function_call_add_argument (type_name_fct, (ValaCCodeExpression*) type_check);
	_tmp27_ = NULL;
	_tmp28_ = NULL;
	stored_type = (_tmp28_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("G_VALUE_TYPE"))), (_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL)), _tmp28_);
	_tmp29_ = NULL;
	vala_ccode_function_call_add_argument (stored_type, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("value")));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) stored_type);
	_tmp30_ = NULL;
	_tmp31_ = NULL;
	value_type_name_fct = (_tmp31_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("G_VALUE_TYPE_NAME"))), (_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL)), _tmp31_);
	_tmp32_ = NULL;
	vala_ccode_function_call_add_argument (value_type_name_fct, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_constant_new ("value")));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	_tmp33_ = NULL;
	_tmp34_ = NULL;
	true_return = (_tmp34_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("g_strconcat"))), (_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL)), _tmp34_);
	_tmp35_ = NULL;
	vala_ccode_function_call_add_argument (true_return, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_constant_new ("\"invalid unclassed object pointer for value type `\"")));
	(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	vala_ccode_function_call_add_argument (true_return, (ValaCCodeExpression*) value_type_name_fct);
	_tmp36_ = NULL;
	vala_ccode_function_call_add_argument (true_return, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_constant_new ("\"'\"")));
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
	_tmp37_ = NULL;
	vala_ccode_function_call_add_argument (true_return, (ValaCCodeExpression*) (_tmp37_ = vala_ccode_constant_new ("NULL")));
	(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
	_tmp38_ = NULL;
	vala_ccode_block_add_statement (sub_true_stmt, (ValaCCodeNode*) (_tmp38_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) true_return)));
	(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
	_tmp39_ = NULL;
	_tmp40_ = NULL;
	false_return = (_tmp40_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp39_ = vala_ccode_identifier_new ("g_strconcat"))), (_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL)), _tmp40_);
	_tmp41_ = NULL;
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_constant_new ("\"invalid object type `\"")));
	(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) type_name_fct);
	_tmp42_ = NULL;
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_constant_new ("\"' for value type `\"")));
	(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) value_type_name_fct);
	_tmp43_ = NULL;
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_constant_new ("\"'\"")));
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	_tmp44_ = NULL;
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_constant_new ("NULL")));
	(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
	_tmp45_ = NULL;
	vala_ccode_block_add_statement (sub_false_stmt, (ValaCCodeNode*) (_tmp45_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) false_return)));
	(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
	_tmp46_ = NULL;
	_tmp47_ = NULL;
	sub_else_if_statement = (_tmp47_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp46_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaCCodeExpression*) reg_call)), (ValaCCodeStatement*) sub_false_stmt, NULL), (_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL)), _tmp47_);
	vala_ccode_if_statement_set_else_if (sub_else_if_statement, TRUE);
	sub_if_statement = vala_ccode_if_statement_new ((ValaCCodeExpression*) sub_condition, (ValaCCodeStatement*) sub_true_stmt, (ValaCCodeStatement*) sub_else_if_statement);
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) sub_if_statement);
	_tmp49_ = NULL;
	_tmp48_ = NULL;
	_tmp50_ = NULL;
	ref_call = (_tmp50_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp49_ = vala_ccode_identifier_new (_tmp48_ = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) cl)))), (_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL)), _tmp48_ = (g_free (_tmp48_), NULL), _tmp50_);
	_tmp51_ = NULL;
	vala_ccode_function_call_add_argument (ref_call, (ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new ("object")));
	(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
	_tmp52_ = NULL;
	_tmp53_ = NULL;
	true_assignment = (_tmp53_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp52_ = vala_ccode_assignment_new ((ValaCCodeExpression*) vpointer, (ValaCCodeExpression*) ref_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))), (_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL)), _tmp53_);
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) true_assignment);
	_tmp55_ = NULL;
	_tmp54_ = NULL;
	_tmp56_ = NULL;
	else_assigment = (_tmp56_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp55_ = vala_ccode_assignment_new ((ValaCCodeExpression*) vpointer, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))), (_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL)), (_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL)), _tmp56_);
	vala_ccode_block_add_statement (false_stmt, (ValaCCodeNode*) else_assigment);
	_tmp58_ = NULL;
	_tmp57_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp58_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp57_ = vala_ccode_constant_new ("NULL")))));
	(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(collect_vpointer == NULL) ? NULL : (collect_vpointer = (vala_ccode_node_unref (collect_vpointer), NULL));
	(true_stmt == NULL) ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL));
	(false_stmt == NULL) ? NULL : (false_stmt = (vala_ccode_node_unref (false_stmt), NULL));
	(if_statement == NULL) ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL));
	(obj_identifier == NULL) ? NULL : (obj_identifier = (vala_ccode_node_unref (obj_identifier), NULL));
	(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
	(l_expression == NULL) ? NULL : (l_expression = (vala_ccode_node_unref (l_expression), NULL));
	(sub_condition == NULL) ? NULL : (sub_condition = (vala_ccode_node_unref (sub_condition), NULL));
	(sub_true_stmt == NULL) ? NULL : (sub_true_stmt = (vala_ccode_node_unref (sub_true_stmt), NULL));
	(sub_false_stmt == NULL) ? NULL : (sub_false_stmt = (vala_ccode_node_unref (sub_false_stmt), NULL));
	(reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL));
	(type_check == NULL) ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL));
	(type_name_fct == NULL) ? NULL : (type_name_fct = (vala_ccode_node_unref (type_name_fct), NULL));
	(stored_type == NULL) ? NULL : (stored_type = (vala_ccode_node_unref (stored_type), NULL));
	(value_type_name_fct == NULL) ? NULL : (value_type_name_fct = (vala_ccode_node_unref (value_type_name_fct), NULL));
	(true_return == NULL) ? NULL : (true_return = (vala_ccode_node_unref (true_return), NULL));
	(false_return == NULL) ? NULL : (false_return = (vala_ccode_node_unref (false_return), NULL));
	(sub_else_if_statement == NULL) ? NULL : (sub_else_if_statement = (vala_ccode_node_unref (sub_else_if_statement), NULL));
	(sub_if_statement == NULL) ? NULL : (sub_if_statement = (vala_ccode_node_unref (sub_if_statement), NULL));
	(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
	(true_assignment == NULL) ? NULL : (true_assignment = (vala_ccode_node_unref (true_assignment), NULL));
	(else_assigment == NULL) ? NULL : (else_assigment = (vala_ccode_node_unref (else_assigment), NULL));
}


static void vala_gtype_module_add_g_param_spec_type_function (ValaGTypeModule* self, ValaClass* cl) {
	char* function_name;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp0_;
	ValaCCodeFormalParameter* _tmp1_;
	ValaCCodeFormalParameter* _tmp2_;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeBlock* init_block;
	char* _tmp6_;
	char* _tmp5_;
	ValaCCodeDeclaration* _tmp7_;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaCCodeFunctionCall* subccall;
	ValaCCodeIdentifier* _tmp11_;
	ValaCCodeIdentifier* _tmp13_;
	char* _tmp12_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeExpressionStatement* _tmp17_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeExpressionStatement* _tmp27_;
	ValaCCodeAssignment* _tmp26_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp29_;
	ValaCCodeIdentifier* _tmp28_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeExpressionStatement* _tmp34_;
	ValaCCodeAssignment* _tmp33_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeMemberAccess* _tmp31_;
	ValaCCodeReturnStatement* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	function_name = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "param_spec_");
	function = vala_ccode_function_new (function_name, "GParamSpec*");
	_tmp0_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp0_ = vala_ccode_formal_parameter_new ("name", "const gchar*"));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp1_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp1_ = vala_ccode_formal_parameter_new ("nick", "const gchar*"));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp2_ = vala_ccode_formal_parameter_new ("blurb", "const gchar*"));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("object_type", "GType"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp4_ = vala_ccode_formal_parameter_new ("flags", "GParamFlags"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	vala_class_set_param_spec_function (cl, function_name);
	if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	_tmp7_ = NULL;
	ctypedecl = (_tmp7_ = vala_ccode_declaration_new (_tmp6_ = g_strdup_printf ("%sParamSpec%s*", _tmp5_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) cl)), vala_symbol_get_name ((ValaSymbol*) cl))), _tmp6_ = (g_free (_tmp6_), NULL), _tmp5_ = (g_free (_tmp5_), NULL), _tmp7_);
	_tmp8_ = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp8_ = vala_ccode_variable_declarator_new ("spec", NULL, NULL)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ctypedecl);
	_tmp9_ = NULL;
	_tmp10_ = NULL;
	subccall = (_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("g_type_is_a"))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), _tmp10_);
	_tmp11_ = NULL;
	vala_ccode_function_call_add_argument (subccall, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("object_type")));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	vala_ccode_function_call_add_argument (subccall, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new (_tmp12_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl))));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	_tmp12_ = (g_free (_tmp12_), NULL);
	_tmp14_ = NULL;
	_tmp15_ = NULL;
	ccall = (_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("g_return_val_if_fail"))), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), _tmp15_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) subccall);
	_tmp16_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("NULL")));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp17_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp17_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	ccall = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("g_param_spec_internal"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp19_);
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	_tmp20_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("G_TYPE_PARAM_OBJECT")));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	_tmp21_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("name")));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	_tmp22_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("nick")));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp23_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new ("blurb")));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	_tmp24_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("flags")));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp27_ = NULL;
	_tmp26_ = NULL;
	_tmp25_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp27_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp26_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("spec")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	ccall = (_tmp29_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new ("G_PARAM_SPEC"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp29_);
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp30_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("spec")));
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	_tmp34_ = NULL;
	_tmp33_ = NULL;
	_tmp32_ = NULL;
	_tmp31_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp34_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, "value_type")), (ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("object_type")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	_tmp35_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp35_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	function_name = (g_free (function_name), NULL);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
	(subccall == NULL) ? NULL : (subccall = (vala_ccode_node_unref (subccall), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_gtype_module_add_g_value_set_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp2_;
	ValaCCodeFormalParameter* _tmp3_;
	ValaCCodeMemberAccess* _tmp5_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeMemberAccess* _tmp6_;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeBlock* init_block;
	char* _tmp8_;
	char* _tmp7_;
	ValaCCodeDeclaration* _tmp9_;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp10_;
	ValaCCodeIdentifier* _tmp11_;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeFunctionCall* ccall_typecheck;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeIdentifier* _tmp15_;
	char* _tmp14_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeFunctionCall* _tmp17_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpressionStatement* _tmp18_;
	ValaCCodeExpressionStatement* _tmp21_;
	ValaCCodeAssignment* _tmp20_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeBlock* true_stmt;
	ValaCCodeBlock* false_stmt;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeIfStatement* _tmp23_;
	ValaCCodeIfStatement* if_statement;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeIdentifier* _tmp28_;
	char* _tmp27_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeExpressionStatement* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeFunctionCall* _tmp33_;
	ValaCCodeFunctionCall* ccall_typefrominstance;
	ValaCCodeIdentifier* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* ccall_gvaluetype;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* ccall_typecompatible;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeIdentifier* _tmp40_;
	ValaCCodeExpressionStatement* _tmp42_;
	ValaCCodeExpressionStatement* _tmp45_;
	ValaCCodeAssignment* _tmp44_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeFunctionCall* _tmp48_;
	ValaCCodeIdentifier* _tmp47_;
	char* _tmp46_;
	ValaCCodeExpressionStatement* _tmp49_;
	ValaCCodeExpressionStatement* _tmp52_;
	ValaCCodeAssignment* _tmp51_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeBlock* _tmp53_;
	ValaCCodeIfStatement* _tmp55_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp58_;
	ValaCCodeIdentifier* _tmp57_;
	char* _tmp56_;
	ValaCCodeIdentifier* _tmp59_;
	ValaCCodeExpressionStatement* _tmp60_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	function = (_tmp1_ = vala_ccode_function_new (_tmp0_ = vala_typesymbol_get_set_value_function ((ValaTypeSymbol*) cl), "void"), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp2_ = vala_ccode_formal_parameter_new ("value", "GValue*"));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("v_object", "gpointer"));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp6_ = NULL;
	vpointer = (_tmp6_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp6_);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp9_ = NULL;
	ctypedecl = (_tmp9_ = vala_ccode_declaration_new (_tmp8_ = g_strconcat (_tmp7_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp8_ = (g_free (_tmp8_), NULL), _tmp7_ = (g_free (_tmp7_), NULL), _tmp9_);
	_tmp10_ = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp10_ = vala_ccode_variable_declarator_new ("old", NULL, NULL)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ctypedecl);
	_tmp11_ = NULL;
	_tmp12_ = NULL;
	ccall_typecheck = (_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("G_TYPE_CHECK_VALUE_TYPE"))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL)), _tmp12_);
	_tmp13_ = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("value")));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new (_tmp14_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl))));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp14_ = (g_free (_tmp14_), NULL);
	_tmp16_ = NULL;
	_tmp17_ = NULL;
	ccall = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("g_return_if_fail"))), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp17_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall_typecheck);
	_tmp18_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp18_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp21_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_constant_new ("old")), (ValaCCodeExpression*) vpointer, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	true_stmt = vala_ccode_block_new ();
	false_stmt = vala_ccode_block_new ();
	_tmp22_ = NULL;
	_tmp23_ = NULL;
	if_statement = (_tmp23_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("v_object")), (ValaCCodeStatement*) true_stmt, (ValaCCodeStatement*) false_stmt), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL)), _tmp23_);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_statement);
	_tmp25_ = NULL;
	_tmp24_ = NULL;
	ccall_typecheck = (_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("G_TYPE_CHECK_INSTANCE_TYPE"))), (ccall_typecheck == NULL) ? NULL : (ccall_typecheck = (vala_ccode_node_unref (ccall_typecheck), NULL)), _tmp25_);
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp26_ = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("v_object")));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new (_tmp27_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl))));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp27_ = (g_free (_tmp27_), NULL);
	_tmp30_ = NULL;
	_tmp29_ = NULL;
	ccall = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("g_return_if_fail"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp30_);
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall_typecheck);
	_tmp31_ = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp31_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	_tmp32_ = NULL;
	_tmp33_ = NULL;
	ccall_typefrominstance = (_tmp33_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE"))), (_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL)), _tmp33_);
	_tmp34_ = NULL;
	vala_ccode_function_call_add_argument (ccall_typefrominstance, (ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new ("v_object")));
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
	_tmp35_ = NULL;
	_tmp36_ = NULL;
	ccall_gvaluetype = (_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("G_VALUE_TYPE"))), (_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL)), _tmp36_);
	_tmp37_ = NULL;
	vala_ccode_function_call_add_argument (ccall_gvaluetype, (ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new ("value")));
	(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
	_tmp38_ = NULL;
	_tmp39_ = NULL;
	ccall_typecompatible = (_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new ("g_value_type_compatible"))), (_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL)), _tmp39_);
	vala_ccode_function_call_add_argument (ccall_typecompatible, (ValaCCodeExpression*) ccall_typefrominstance);
	vala_ccode_function_call_add_argument (ccall_typecompatible, (ValaCCodeExpression*) ccall_gvaluetype);
	_tmp41_ = NULL;
	_tmp40_ = NULL;
	ccall = (_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("g_return_if_fail"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp41_);
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall_typecompatible);
	_tmp42_ = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp42_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	_tmp45_ = NULL;
	_tmp44_ = NULL;
	_tmp43_ = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp45_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_assignment_new ((ValaCCodeExpression*) vpointer, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_constant_new ("v_object")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
	(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	_tmp48_ = NULL;
	_tmp47_ = NULL;
	_tmp46_ = NULL;
	ccall = (_tmp48_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new (_tmp46_ = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) cl)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp48_);
	(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	_tmp46_ = (g_free (_tmp46_), NULL);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) vpointer);
	_tmp49_ = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp49_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
	_tmp52_ = NULL;
	_tmp51_ = NULL;
	_tmp50_ = NULL;
	vala_ccode_block_add_statement (false_stmt, (ValaCCodeNode*) (_tmp52_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp51_ = vala_ccode_assignment_new ((ValaCCodeExpression*) vpointer, (ValaCCodeExpression*) (_tmp50_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
	(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
	(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
	_tmp53_ = NULL;
	true_stmt = (_tmp53_ = vala_ccode_block_new (), (true_stmt == NULL) ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL)), _tmp53_);
	_tmp55_ = NULL;
	_tmp54_ = NULL;
	if_statement = (_tmp55_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new ("old")), (ValaCCodeStatement*) true_stmt, NULL), (if_statement == NULL) ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL)), _tmp55_);
	(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_statement);
	_tmp58_ = NULL;
	_tmp57_ = NULL;
	_tmp56_ = NULL;
	ccall = (_tmp58_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp57_ = vala_ccode_identifier_new (_tmp56_ = vala_typesymbol_get_unref_function ((ValaTypeSymbol*) cl)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp58_);
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	_tmp56_ = (g_free (_tmp56_), NULL);
	_tmp59_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new ("old")));
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	_tmp60_ = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp60_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
	(ccall_typecheck == NULL) ? NULL : (ccall_typecheck = (vala_ccode_node_unref (ccall_typecheck), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(true_stmt == NULL) ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL));
	(false_stmt == NULL) ? NULL : (false_stmt = (vala_ccode_node_unref (false_stmt), NULL));
	(if_statement == NULL) ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL));
	(ccall_typefrominstance == NULL) ? NULL : (ccall_typefrominstance = (vala_ccode_node_unref (ccall_typefrominstance), NULL));
	(ccall_gvaluetype == NULL) ? NULL : (ccall_gvaluetype = (vala_ccode_node_unref (ccall_gvaluetype), NULL));
	(ccall_typecompatible == NULL) ? NULL : (ccall_typecompatible = (vala_ccode_node_unref (ccall_typecompatible), NULL));
}


static void vala_gtype_module_add_g_value_get_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp2_;
	ValaCCodeMemberAccess* _tmp4_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeMemberAccess* _tmp5_;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeBlock* init_block;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeFunctionCall* ccall_typecheck;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp10_;
	char* _tmp9_;
	ValaCCodeIdentifier* _tmp11_;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeExpressionStatement* _tmp14_;
	ValaCCodeReturnStatement* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	function = (_tmp1_ = vala_ccode_function_new (_tmp0_ = vala_typesymbol_get_get_value_function ((ValaTypeSymbol*) cl), "gpointer"), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp2_ = vala_ccode_formal_parameter_new ("value", "const GValue*"));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	}
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp5_ = NULL;
	vpointer = (_tmp5_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL)), _tmp5_);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp6_ = NULL;
	_tmp7_ = NULL;
	ccall_typecheck = (_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("G_TYPE_CHECK_VALUE_TYPE"))), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp7_);
	_tmp8_ = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("value")));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new (_tmp9_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl))));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp9_ = (g_free (_tmp9_), NULL);
	_tmp11_ = NULL;
	_tmp12_ = NULL;
	ccall = (_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("g_return_val_if_fail"))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL)), _tmp12_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall_typecheck);
	_tmp13_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("NULL")));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	_tmp14_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp14_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	_tmp15_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp15_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) vpointer)));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ccall_typecheck == NULL) ? NULL : (ccall_typecheck = (vala_ccode_node_unref (ccall_typecheck), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_gtype_module_add_base_init_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* base_init;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeBlock* init_block;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	base_init = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_base_init", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (base_init, _tmp5_ = vala_ccode_formal_parameter_new ("klass", _tmp4_ = g_strdup_printf ("%sClass *", _tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp3_ = (g_free (_tmp3_), NULL);
	vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (base_init, init_block);
	if (vala_class_get_has_class_private_fields (cl)) {
		ValaCCodeBlock* block;
		char* _tmp7_;
		char* _tmp6_;
		ValaCCodeDeclaration* _tmp8_;
		ValaCCodeDeclaration* _cdecl_;
		ValaCCodeVariableDeclarator* _tmp9_;
		ValaCCodeDeclaration* _tmp12_;
		char* _tmp11_;
		char* _tmp10_;
		ValaCCodeVariableDeclarator* _tmp14_;
		ValaCCodeConstant* _tmp13_;
		ValaCCodeDeclaration* _tmp15_;
		ValaCCodeVariableDeclarator* _tmp16_;
		ValaCCodeIdentifier* _tmp17_;
		ValaCCodeFunctionCall* _tmp18_;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp19_;
		ValaCCodeFunctionCall* _tmp20_;
		ValaCCodeFunctionCall* ccall2;
		ValaCCodeIdentifier* _tmp21_;
		ValaCCodeExpressionStatement* _tmp24_;
		ValaCCodeAssignment* _tmp23_;
		ValaCCodeIdentifier* _tmp22_;
		ValaCCodeBlock* iftrue;
		ValaCCodeFunctionCall* _tmp28_;
		ValaCCodeIdentifier* _tmp27_;
		char* _tmp26_;
		char* _tmp25_;
		ValaCCodeIdentifier* _tmp29_;
		ValaCCodeExpressionStatement* _tmp32_;
		ValaCCodeAssignment* _tmp31_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIfStatement* _tmp34_;
		ValaCCodeIdentifier* _tmp33_;
		ValaCCodeFunctionCall* _tmp36_;
		ValaCCodeIdentifier* _tmp35_;
		ValaCCodeIdentifier* _tmp39_;
		char* _tmp38_;
		char* _tmp37_;
		ValaCCodeExpressionStatement* _tmp42_;
		ValaCCodeAssignment* _tmp41_;
		ValaCCodeIdentifier* _tmp40_;
		ValaCCodeBlock* _tmp43_;
		ValaCCodeFunctionCall* _tmp45_;
		ValaCCodeIdentifier* _tmp44_;
		ValaCCodeIdentifier* _tmp46_;
		ValaCCodeIdentifier* _tmp47_;
		ValaCCodeIdentifier* _tmp50_;
		char* _tmp49_;
		char* _tmp48_;
		ValaCCodeExpressionStatement* _tmp51_;
		ValaCCodeIfStatement* _tmp53_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeFunctionCall* _tmp55_;
		ValaCCodeIdentifier* _tmp54_;
		ValaCCodeFunctionCall* _tmp57_;
		ValaCCodeIdentifier* _tmp56_;
		ValaCCodeIdentifier* _tmp58_;
		ValaCCodeIdentifier* _tmp61_;
		char* _tmp60_;
		char* _tmp59_;
		ValaCCodeIdentifier* _tmp62_;
		ValaCCodeExpressionStatement* _tmp63_;
		ValaCCodeBlock* _tmp64_;
		ValaCCodeDeclaration* _tmp67_;
		char* _tmp66_;
		char* _tmp65_;
		ValaCCodeVariableDeclarator* _tmp68_;
		ValaCCodeFunctionCall* _tmp72_;
		ValaCCodeIdentifier* _tmp71_;
		char* _tmp70_;
		char* _tmp69_;
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeIdentifier* _tmp75_;
		ValaCCodeExpressionStatement* _tmp78_;
		ValaCCodeAssignment* _tmp77_;
		ValaCCodeIdentifier* _tmp76_;
		ValaCCodeFunctionCall* _tmp80_;
		ValaCCodeIdentifier* _tmp79_;
		ValaCCodeIdentifier* _tmp83_;
		char* _tmp82_;
		char* _tmp81_;
		ValaCCodeIdentifier* _tmp84_;
		ValaCCodeExpressionStatement* _tmp85_;
		block = vala_ccode_block_new ();
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		_tmp8_ = NULL;
		_cdecl_ = (_tmp8_ = vala_ccode_declaration_new (_tmp7_ = g_strdup_printf ("%sClassPrivate *", _tmp6_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp7_ = (g_free (_tmp7_), NULL), _tmp6_ = (g_free (_tmp6_), NULL), _tmp8_);
		_tmp9_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp9_ = vala_ccode_variable_declarator_new ("priv", NULL, NULL)));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		_cdecl_ = (_tmp12_ = vala_ccode_declaration_new (_tmp11_ = g_strdup_printf ("%sClassPrivate *", _tmp10_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp12_);
		_tmp11_ = (g_free (_tmp11_), NULL);
		_tmp10_ = (g_free (_tmp10_), NULL);
		_tmp14_ = NULL;
		_tmp13_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp14_ = vala_ccode_variable_declarator_new ("parent_priv", (ValaCCodeExpression*) (_tmp13_ = vala_ccode_constant_new ("NULL")), NULL)));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
		_tmp15_ = NULL;
		_cdecl_ = (_tmp15_ = vala_ccode_declaration_new ("GType"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp15_);
		_tmp16_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp16_ = vala_ccode_variable_declarator_new ("parent_type", NULL, NULL)));
		(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
		_tmp17_ = NULL;
		_tmp18_ = NULL;
		ccall = (_tmp18_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("g_type_parent"))), (_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL)), _tmp18_);
		_tmp19_ = NULL;
		_tmp20_ = NULL;
		ccall2 = (_tmp20_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("G_TYPE_FROM_CLASS"))), (_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL)), _tmp20_);
		_tmp21_ = NULL;
		vala_ccode_function_call_add_argument (ccall2, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("klass")));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall2);
		_tmp24_ = NULL;
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp24_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp23_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("parent_type")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
		(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
		iftrue = vala_ccode_block_new ();
		_tmp28_ = NULL;
		_tmp27_ = NULL;
		_tmp26_ = NULL;
		_tmp25_ = NULL;
		ccall = (_tmp28_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new (_tmp26_ = g_strdup_printf ("%s_GET_CLASS_PRIVATE", _tmp25_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp28_);
		(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
		_tmp26_ = (g_free (_tmp26_), NULL);
		_tmp25_ = (g_free (_tmp25_), NULL);
		_tmp29_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("parent_type")));
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
		_tmp32_ = NULL;
		_tmp31_ = NULL;
		_tmp30_ = NULL;
		vala_ccode_block_add_statement (iftrue, (ValaCCodeNode*) (_tmp32_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("parent_priv")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
		(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
		(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
		_tmp34_ = NULL;
		_tmp33_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp34_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("parent_type")), (ValaCCodeStatement*) iftrue, NULL)));
		(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
		(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
		_tmp36_ = NULL;
		_tmp35_ = NULL;
		ccall = (_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("g_slice_new0"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp36_);
		(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
		_tmp39_ = NULL;
		_tmp38_ = NULL;
		_tmp37_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_identifier_new (_tmp38_ = g_strdup_printf ("%sClassPrivate", _tmp37_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))));
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
		_tmp38_ = (g_free (_tmp38_), NULL);
		_tmp37_ = (g_free (_tmp37_), NULL);
		_tmp42_ = NULL;
		_tmp41_ = NULL;
		_tmp40_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp42_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp41_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("priv")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
		(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
		(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "string.h", FALSE);
		_tmp43_ = NULL;
		iftrue = (_tmp43_ = vala_ccode_block_new (), (iftrue == NULL) ? NULL : (iftrue = (vala_ccode_node_unref (iftrue), NULL)), _tmp43_);
		_tmp45_ = NULL;
		_tmp44_ = NULL;
		ccall = (_tmp45_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new ("memcpy"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp45_);
		(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
		_tmp46_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new ("priv")));
		(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
		_tmp47_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new ("parent_priv")));
		(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
		_tmp50_ = NULL;
		_tmp49_ = NULL;
		_tmp48_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp50_ = vala_ccode_identifier_new (_tmp49_ = g_strdup_printf ("sizeof (%sClassPrivate)", _tmp48_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))));
		(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
		_tmp49_ = (g_free (_tmp49_), NULL);
		_tmp48_ = (g_free (_tmp48_), NULL);
		_tmp51_ = NULL;
		vala_ccode_block_add_statement (iftrue, (ValaCCodeNode*) (_tmp51_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
		_tmp53_ = NULL;
		_tmp52_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp53_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp52_ = vala_ccode_identifier_new ("parent_priv")), (ValaCCodeStatement*) iftrue, NULL)));
		(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
		(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
		_tmp55_ = NULL;
		_tmp54_ = NULL;
		ccall = (_tmp55_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new ("g_type_set_qdata"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp55_);
		(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
		_tmp57_ = NULL;
		_tmp56_ = NULL;
		ccall2 = (_tmp57_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp56_ = vala_ccode_identifier_new ("G_TYPE_FROM_CLASS"))), (ccall2 == NULL) ? NULL : (ccall2 = (vala_ccode_node_unref (ccall2), NULL)), _tmp57_);
		(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
		_tmp58_ = NULL;
		vala_ccode_function_call_add_argument (ccall2, (ValaCCodeExpression*) (_tmp58_ = vala_ccode_identifier_new ("klass")));
		(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall2);
		_tmp61_ = NULL;
		_tmp60_ = NULL;
		_tmp59_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp61_ = vala_ccode_identifier_new (_tmp60_ = g_strdup_printf ("_vala_%s_class_private_quark", _tmp59_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))));
		(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
		_tmp60_ = (g_free (_tmp60_), NULL);
		_tmp59_ = (g_free (_tmp59_), NULL);
		_tmp62_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp62_ = vala_ccode_identifier_new ("priv")));
		(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
		_tmp63_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp63_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) block);
		_tmp64_ = NULL;
		block = (_tmp64_ = vala_ccode_block_new (), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp64_);
		_tmp67_ = NULL;
		_tmp66_ = NULL;
		_tmp65_ = NULL;
		_cdecl_ = (_tmp67_ = vala_ccode_declaration_new (_tmp66_ = g_strdup_printf ("%sClassPrivate *", _tmp65_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp67_);
		_tmp66_ = (g_free (_tmp66_), NULL);
		_tmp65_ = (g_free (_tmp65_), NULL);
		_tmp68_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp68_ = vala_ccode_variable_declarator_new ("priv", NULL, NULL)));
		(_tmp68_ == NULL) ? NULL : (_tmp68_ = (vala_ccode_node_unref (_tmp68_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
		_tmp72_ = NULL;
		_tmp71_ = NULL;
		_tmp70_ = NULL;
		_tmp69_ = NULL;
		ccall = (_tmp72_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp71_ = vala_ccode_identifier_new (_tmp70_ = g_strdup_printf ("%s_GET_CLASS_PRIVATE", _tmp69_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp72_);
		(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
		_tmp70_ = (g_free (_tmp70_), NULL);
		_tmp69_ = (g_free (_tmp69_), NULL);
		_tmp74_ = NULL;
		_tmp73_ = NULL;
		ccall2 = (_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp73_ = vala_ccode_identifier_new ("G_TYPE_FROM_CLASS"))), (ccall2 == NULL) ? NULL : (ccall2 = (vala_ccode_node_unref (ccall2), NULL)), _tmp74_);
		(_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_ccode_node_unref (_tmp73_), NULL));
		_tmp75_ = NULL;
		vala_ccode_function_call_add_argument (ccall2, (ValaCCodeExpression*) (_tmp75_ = vala_ccode_identifier_new ("klass")));
		(_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL));
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall2);
		_tmp78_ = NULL;
		_tmp77_ = NULL;
		_tmp76_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp78_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp77_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp76_ = vala_ccode_identifier_new ("priv")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
		(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
		(_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL));
		_tmp80_ = NULL;
		_tmp79_ = NULL;
		ccall = (_tmp80_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp79_ = vala_ccode_identifier_new ("g_slice_free"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp80_);
		(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
		_tmp83_ = NULL;
		_tmp82_ = NULL;
		_tmp81_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp83_ = vala_ccode_identifier_new (_tmp82_ = g_strdup_printf ("%sClassPrivate", _tmp81_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))));
		(_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL));
		_tmp82_ = (g_free (_tmp82_), NULL);
		_tmp81_ = (g_free (_tmp81_), NULL);
		_tmp84_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp84_ = vala_ccode_identifier_new ("priv")));
		(_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL));
		_tmp85_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp85_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->base_finalize_fragment, (ValaCCodeNode*) block);
		(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
		(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		(ccall2 == NULL) ? NULL : (ccall2 = (vala_ccode_node_unref (ccall2), NULL));
		(iftrue == NULL) ? NULL : (iftrue = (vala_ccode_node_unref (iftrue), NULL));
	}
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->base_init_fragment);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) base_init);
	(base_init == NULL) ? NULL : (base_init = (vala_ccode_node_unref (base_init), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
}


static void vala_gtype_module_real_generate_class_init (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	g_return_if_fail (init_block != NULL);
}


void vala_gtype_module_generate_class_init (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block) {
	VALA_GTYPE_MODULE_GET_CLASS (self)->generate_class_init (self, cl, init_block);
}


static void vala_gtype_module_add_class_init_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* class_init;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeDeclaration* parent_decl;
	char* _tmp7_;
	char* _tmp6_;
	ValaCCodeVariableDeclarator* _tmp8_;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp15_;
	char* _tmp14_;
	char* _tmp13_;
	ValaCCodeAssignment* _tmp16_;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp38_;
	GeeList* fields;
	ValaCCodeFragment* _tmp101_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	class_init = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_class_init", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (class_init, _tmp5_ = vala_ccode_formal_parameter_new ("klass", _tmp4_ = g_strdup_printf ("%sClass *", _tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp3_ = (g_free (_tmp3_), NULL);
	vala_ccode_function_set_modifiers (class_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (class_init, init_block);
	ccall = NULL;
	/* save pointer to parent class */
	parent_decl = vala_ccode_declaration_new ("gpointer");
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	_tmp8_ = NULL;
	parent_var_decl = (_tmp8_ = vala_ccode_variable_declarator_new (_tmp7_ = g_strdup_printf ("%s_parent_class", _tmp6_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), NULL, NULL), _tmp7_ = (g_free (_tmp7_), NULL), _tmp6_ = (g_free (_tmp6_), NULL), _tmp8_);
	_tmp9_ = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("NULL")));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	vala_ccode_declaration_add_declarator (parent_decl, (ValaCCodeDeclarator*) parent_var_decl);
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) parent_decl);
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	ccall = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp11_);
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp12_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("klass")));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	_tmp16_ = NULL;
	parent_assignment = (_tmp16_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new (_tmp14_ = g_strdup_printf ("%s_parent_class", _tmp13_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL)), _tmp14_ = (g_free (_tmp14_), NULL), _tmp13_ = (g_free (_tmp13_), NULL), _tmp16_);
	_tmp17_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp17_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) parent_assignment)));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	_tmp18_ = FALSE;
	_tmp19_ = FALSE;
	if (!vala_class_get_is_compact (cl)) {
		_tmp19_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gboolean _tmp20_;
		gboolean _tmp21_;
		GeeList* _tmp22_;
		gboolean _tmp23_;
		_tmp20_ = FALSE;
		_tmp21_ = FALSE;
		_tmp22_ = NULL;
		if ((_tmp23_ = gee_collection_get_size ((GeeCollection*) (_tmp22_ = vala_class_get_fields (cl))) > 0, (_tmp22_ == NULL) ? NULL : (_tmp22_ = (gee_collection_object_unref (_tmp22_), NULL)), _tmp23_)) {
			_tmp21_ = TRUE;
		} else {
			_tmp21_ = vala_class_get_destructor (cl) != NULL;
		}
		if (_tmp21_) {
			_tmp20_ = TRUE;
		} else {
			_tmp20_ = vala_class_is_fundamental (cl);
		}
		_tmp18_ = _tmp20_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ValaClass* _tmp24_;
		ValaClass* fundamental_class;
		ValaCCodeFunctionCall* _tmp30_;
		ValaCCodeIdentifier* _tmp29_;
		char* _tmp28_;
		char* _tmp27_;
		ValaCCodeIdentifier* _tmp31_;
		ValaCCodeIdentifier* _tmp35_;
		char* _tmp34_;
		char* _tmp33_;
		ValaCCodeMemberAccess* _tmp32_;
		ValaCCodeAssignment* _tmp36_;
		ValaCCodeAssignment* finalize_assignment;
		ValaCCodeExpressionStatement* _tmp37_;
		/* set finalize function*/
		_tmp24_ = NULL;
		fundamental_class = (_tmp24_ = cl, (_tmp24_ == NULL) ? NULL : vala_code_node_ref (_tmp24_));
		while (vala_class_get_base_class (fundamental_class) != NULL) {
			ValaClass* _tmp26_;
			ValaClass* _tmp25_;
			_tmp26_ = NULL;
			_tmp25_ = NULL;
			fundamental_class = (_tmp26_ = (_tmp25_ = vala_class_get_base_class (fundamental_class), (_tmp25_ == NULL) ? NULL : vala_code_node_ref (_tmp25_)), (fundamental_class == NULL) ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL)), _tmp26_);
		}
		_tmp30_ = NULL;
		_tmp29_ = NULL;
		_tmp28_ = NULL;
		_tmp27_ = NULL;
		ccall = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new (_tmp28_ = g_strdup_printf ("%s_CLASS", _tmp27_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) fundamental_class, NULL))))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp30_);
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
		_tmp28_ = (g_free (_tmp28_), NULL);
		_tmp27_ = (g_free (_tmp27_), NULL);
		_tmp31_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("klass")));
		(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
		_tmp35_ = NULL;
		_tmp34_ = NULL;
		_tmp33_ = NULL;
		_tmp32_ = NULL;
		_tmp36_ = NULL;
		finalize_assignment = (_tmp36_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, "finalize")), (ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new (_tmp34_ = g_strconcat (_tmp33_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "finalize", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL)), _tmp34_ = (g_free (_tmp34_), NULL), _tmp33_ = (g_free (_tmp33_), NULL), (_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL)), _tmp36_);
		_tmp37_ = NULL;
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp37_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) finalize_assignment)));
		(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
		(fundamental_class == NULL) ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL));
		(finalize_assignment == NULL) ? NULL : (finalize_assignment = (vala_ccode_node_unref (finalize_assignment), NULL));
	}
	_tmp38_ = FALSE;
	if (vala_class_get_has_private_fields (cl)) {
		_tmp38_ = TRUE;
	} else {
		GeeList* _tmp39_;
		_tmp39_ = NULL;
		_tmp38_ = gee_collection_get_size ((GeeCollection*) (_tmp39_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (gee_collection_object_unref (_tmp39_), NULL));
	}
	/* add struct for private fields */
	if (_tmp38_) {
		ValaCCodeFunctionCall* _tmp41_;
		ValaCCodeIdentifier* _tmp40_;
		ValaCCodeIdentifier* _tmp42_;
		ValaCCodeConstant* _tmp45_;
		char* _tmp44_;
		char* _tmp43_;
		ValaCCodeExpressionStatement* _tmp46_;
		_tmp41_ = NULL;
		_tmp40_ = NULL;
		ccall = (_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("g_type_class_add_private"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp41_);
		(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		_tmp42_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new ("klass")));
		(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
		_tmp45_ = NULL;
		_tmp44_ = NULL;
		_tmp43_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp45_ = vala_ccode_constant_new (_tmp44_ = g_strdup_printf ("sizeof (%sPrivate)", _tmp43_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))));
		(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
		_tmp44_ = (g_free (_tmp44_), NULL);
		_tmp43_ = (g_free (_tmp43_), NULL);
		_tmp46_ = NULL;
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp46_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
	}
	/* connect overridden methods */
	{
		GeeList* _tmp47_;
		GeeIterator* _tmp48_;
		GeeIterator* _m_it;
		/* connect overridden methods */
		_tmp47_ = NULL;
		_tmp48_ = NULL;
		_m_it = (_tmp48_ = gee_iterable_iterator ((GeeIterable*) (_tmp47_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl))), (_tmp47_ == NULL) ? NULL : (_tmp47_ = (gee_collection_object_unref (_tmp47_), NULL)), _tmp48_);
		/* connect overridden methods */
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			ValaSymbol* _tmp49_;
			ValaSymbol* base_type;
			ValaCCodeIdentifier* _tmp52_;
			char* _tmp51_;
			char* _tmp50_;
			ValaCCodeFunctionCall* _tmp53_;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeExpressionStatement* _tmp59_;
			ValaCCodeAssignment* _tmp58_;
			ValaCCodeIdentifier* _tmp57_;
			char* _tmp56_;
			ValaCCodeMemberAccess* _tmp55_;
			/* connect overridden methods */
			m = (ValaMethod*) gee_iterator_get (_m_it);
			if (vala_method_get_base_method (m) == NULL) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			_tmp49_ = NULL;
			base_type = (_tmp49_ = vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m)), (_tmp49_ == NULL) ? NULL : vala_code_node_ref (_tmp49_));
			_tmp52_ = NULL;
			_tmp51_ = NULL;
			_tmp50_ = NULL;
			_tmp53_ = NULL;
			ccast = (_tmp53_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp52_ = vala_ccode_identifier_new (_tmp51_ = g_strdup_printf ("%s_CLASS", _tmp50_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) VALA_CLASS (base_type), NULL))))), (_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL)), _tmp51_ = (g_free (_tmp51_), NULL), _tmp50_ = (g_free (_tmp50_), NULL), _tmp53_);
			_tmp54_ = NULL;
			vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new ("klass")));
			(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
			_tmp59_ = NULL;
			_tmp58_ = NULL;
			_tmp57_ = NULL;
			_tmp56_ = NULL;
			_tmp55_ = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp59_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp58_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp55_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, vala_method_get_vfunc_name (vala_method_get_base_method (m)))), (ValaCCodeExpression*) (_tmp57_ = vala_ccode_identifier_new (_tmp56_ = vala_method_get_real_cname (m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
			(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
			(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
			_tmp56_ = (g_free (_tmp56_), NULL);
			(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	/* connect overridden properties */
	{
		GeeList* _tmp60_;
		GeeIterator* _tmp61_;
		GeeIterator* _prop_it;
		/* connect overridden properties */
		_tmp60_ = NULL;
		_tmp61_ = NULL;
		_prop_it = (_tmp61_ = gee_iterable_iterator ((GeeIterable*) (_tmp60_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), (_tmp60_ == NULL) ? NULL : (_tmp60_ = (gee_collection_object_unref (_tmp60_), NULL)), _tmp61_);
		/* connect overridden properties */
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			ValaSymbol* _tmp62_;
			ValaSymbol* base_type;
			ValaCCodeIdentifier* _tmp65_;
			char* _tmp64_;
			char* _tmp63_;
			ValaCCodeFunctionCall* _tmp66_;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp67_;
			/* connect overridden properties */
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			if (vala_property_get_base_property (prop) == NULL) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			_tmp62_ = NULL;
			base_type = (_tmp62_ = vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop)), (_tmp62_ == NULL) ? NULL : vala_code_node_ref (_tmp62_));
			_tmp65_ = NULL;
			_tmp64_ = NULL;
			_tmp63_ = NULL;
			_tmp66_ = NULL;
			ccast = (_tmp66_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp65_ = vala_ccode_identifier_new (_tmp64_ = g_strdup_printf ("%s_CLASS", _tmp63_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) VALA_CLASS (base_type), NULL))))), (_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_ccode_node_unref (_tmp65_), NULL)), _tmp64_ = (g_free (_tmp64_), NULL), _tmp63_ = (g_free (_tmp63_), NULL), _tmp66_);
			_tmp67_ = NULL;
			vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp67_ = vala_ccode_identifier_new ("klass")));
			(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
			if (vala_property_get_get_accessor (prop) != NULL) {
				char* _tmp68_;
				char* _tmp69_;
				char* cname;
				ValaCCodeExpressionStatement* _tmp74_;
				ValaCCodeAssignment* _tmp73_;
				ValaCCodeIdentifier* _tmp72_;
				ValaCCodeMemberAccess* _tmp71_;
				char* _tmp70_;
				_tmp68_ = NULL;
				_tmp69_ = NULL;
				cname = (_tmp69_ = g_strdup_printf ("%s_real_get_%s", _tmp68_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), _tmp68_ = (g_free (_tmp68_), NULL), _tmp69_);
				_tmp74_ = NULL;
				_tmp73_ = NULL;
				_tmp72_ = NULL;
				_tmp71_ = NULL;
				_tmp70_ = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp74_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp73_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp71_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, _tmp70_ = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp72_ = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
				(_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_ccode_node_unref (_tmp73_), NULL));
				(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
				(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
				_tmp70_ = (g_free (_tmp70_), NULL);
				cname = (g_free (cname), NULL);
			}
			if (vala_property_get_set_accessor (prop) != NULL) {
				char* _tmp75_;
				char* _tmp76_;
				char* cname;
				ValaCCodeExpressionStatement* _tmp81_;
				ValaCCodeAssignment* _tmp80_;
				ValaCCodeIdentifier* _tmp79_;
				ValaCCodeMemberAccess* _tmp78_;
				char* _tmp77_;
				_tmp75_ = NULL;
				_tmp76_ = NULL;
				cname = (_tmp76_ = g_strdup_printf ("%s_real_set_%s", _tmp75_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), _tmp75_ = (g_free (_tmp75_), NULL), _tmp76_);
				_tmp81_ = NULL;
				_tmp80_ = NULL;
				_tmp79_ = NULL;
				_tmp78_ = NULL;
				_tmp77_ = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp81_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp80_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp78_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, _tmp77_ = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp79_ = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
				(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
				(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
				(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
				_tmp77_ = (g_free (_tmp77_), NULL);
				cname = (g_free (cname), NULL);
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	/* initialize class fields */
	fields = vala_class_get_fields (cl);
	{
		GeeIterator* _field_it;
		_field_it = gee_iterable_iterator ((GeeIterable*) fields);
		while (gee_iterator_next (_field_it)) {
			ValaField* field;
			gboolean _tmp82_;
			ValaCCodeExpression* left;
			ValaCCodeExpression* _tmp95_;
			ValaCCodeExpression* right;
			ValaCCodeAssignment* assign;
			ValaCCodeExpressionStatement* _tmp96_;
			field = (ValaField*) gee_iterator_get (_field_it);
			_tmp82_ = FALSE;
			if (vala_field_get_binding (field) != MEMBER_BINDING_CLASS) {
				_tmp82_ = TRUE;
			} else {
				_tmp82_ = vala_field_get_initializer (field) == NULL;
			}
			if (_tmp82_) {
				(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
				continue;
			}
			left = NULL;
			if (vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunctionCall* _tmp86_;
				ValaCCodeIdentifier* _tmp85_;
				char* _tmp84_;
				char* _tmp83_;
				ValaCCodeIdentifier* _tmp87_;
				ValaCCodeFunctionCall* _tmp88_;
				ValaCCodeFunctionCall* ccall2;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeExpression* _tmp91_;
				char* _tmp90_;
				_tmp86_ = NULL;
				_tmp85_ = NULL;
				_tmp84_ = NULL;
				_tmp83_ = NULL;
				ccall = (_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp85_ = vala_ccode_identifier_new (_tmp84_ = g_strdup_printf ("%s_GET_CLASS_PRIVATE", _tmp83_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp86_);
				(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
				_tmp84_ = (g_free (_tmp84_), NULL);
				_tmp83_ = (g_free (_tmp83_), NULL);
				_tmp87_ = NULL;
				_tmp88_ = NULL;
				ccall2 = (_tmp88_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp87_ = vala_ccode_identifier_new ("G_TYPE_FROM_CLASS"))), (_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL)), _tmp88_);
				_tmp89_ = NULL;
				vala_ccode_function_call_add_argument (ccall2, (ValaCCodeExpression*) (_tmp89_ = vala_ccode_identifier_new ("klass")));
				(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall2);
				_tmp91_ = NULL;
				_tmp90_ = NULL;
				left = (_tmp91_ = (ValaCCodeExpression*) vala_ccode_member_access_new ((ValaCCodeExpression*) ccall, _tmp90_ = vala_field_get_cname (field), TRUE), (left == NULL) ? NULL : (left = (vala_ccode_node_unref (left), NULL)), _tmp91_);
				_tmp90_ = (g_free (_tmp90_), NULL);
				(ccall2 == NULL) ? NULL : (ccall2 = (vala_ccode_node_unref (ccall2), NULL));
			} else {
				ValaCCodeExpression* _tmp94_;
				char* _tmp93_;
				ValaCCodeIdentifier* _tmp92_;
				_tmp94_ = NULL;
				_tmp93_ = NULL;
				_tmp92_ = NULL;
				left = (_tmp94_ = (ValaCCodeExpression*) vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp92_ = vala_ccode_identifier_new ("klass")), _tmp93_ = vala_field_get_cname (field), TRUE), (left == NULL) ? NULL : (left = (vala_ccode_node_unref (left), NULL)), _tmp94_);
				_tmp93_ = (g_free (_tmp93_), NULL);
				(_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_ccode_node_unref (_tmp92_), NULL));
			}
			_tmp95_ = NULL;
			right = (_tmp95_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (field))), (_tmp95_ == NULL) ? NULL : vala_ccode_node_ref (_tmp95_));
			assign = vala_ccode_assignment_new (left, right, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_tmp96_ = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp96_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
			(_tmp96_ == NULL) ? NULL : (_tmp96_ = (vala_ccode_node_unref (_tmp96_), NULL));
			(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
			(left == NULL) ? NULL : (left = (vala_ccode_node_unref (left), NULL));
			(right == NULL) ? NULL : (right = (vala_ccode_node_unref (right), NULL));
			(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
		}
		(_field_it == NULL) ? NULL : (_field_it = (gee_collection_object_unref (_field_it), NULL));
	}
	vala_gtype_module_generate_class_init (self, cl, init_block);
	if (!vala_class_get_is_compact (cl)) {
		/* create signals */
		{
			GeeList* _tmp97_;
			GeeIterator* _tmp98_;
			GeeIterator* _sig_it;
			/* create signals */
			_tmp97_ = NULL;
			_tmp98_ = NULL;
			_sig_it = (_tmp98_ = gee_iterable_iterator ((GeeIterable*) (_tmp97_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) cl))), (_tmp97_ == NULL) ? NULL : (_tmp97_ = (gee_collection_object_unref (_tmp97_), NULL)), _tmp98_);
			/* create signals */
			while (gee_iterator_next (_sig_it)) {
				ValaSignal* sig;
				ValaCCodeExpressionStatement* _tmp100_;
				ValaCCodeFunctionCall* _tmp99_;
				/* create signals */
				sig = (ValaSignal*) gee_iterator_get (_sig_it);
				_tmp100_ = NULL;
				_tmp99_ = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp100_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp99_ = vala_ccode_module_get_signal_creation (vala_ccode_module_get_head ((ValaCCodeModule*) self), sig, (ValaTypeSymbol*) cl)))));
				(_tmp100_ == NULL) ? NULL : (_tmp100_ = (vala_ccode_node_unref (_tmp100_), NULL));
				(_tmp99_ == NULL) ? NULL : (_tmp99_ = (vala_ccode_node_unref (_tmp99_), NULL));
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
			}
			(_sig_it == NULL) ? NULL : (_sig_it = (gee_collection_object_unref (_sig_it), NULL));
		}
	}
	_tmp101_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp101_ = vala_ccode_module_register_dbus_info (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaObjectTypeSymbol*) cl)));
	(_tmp101_ == NULL) ? NULL : (_tmp101_ = (vala_ccode_node_unref (_tmp101_), NULL));
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->class_init_fragment);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) class_init);
	(class_init == NULL) ? NULL : (class_init = (vala_ccode_node_unref (class_init), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(parent_decl == NULL) ? NULL : (parent_decl = (vala_ccode_node_unref (parent_decl), NULL));
	(parent_var_decl == NULL) ? NULL : (parent_var_decl = (vala_ccode_node_unref (parent_var_decl), NULL));
	(parent_assignment == NULL) ? NULL : (parent_assignment = (vala_ccode_node_unref (parent_assignment), NULL));
	(fields == NULL) ? NULL : (fields = (gee_collection_object_unref (fields), NULL));
}


static void vala_gtype_module_add_interface_init_function (ValaGTypeModule* self, ValaClass* cl, ValaInterface* iface) {
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeFunction* iface_init;
	ValaCCodeFormalParameter* _tmp6_;
	char* _tmp5_;
	char* _tmp4_;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	char* _tmp8_;
	char* _tmp7_;
	char* _tmp9_;
	char* parent_iface_var;
	char* _tmp11_;
	char* _tmp10_;
	ValaCCodeDeclaration* _tmp12_;
	ValaCCodeDeclaration* parent_decl;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp13_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeAssignment* _tmp18_;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	g_return_if_fail (iface != NULL);
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp3_ = NULL;
	iface_init = (_tmp3_ = vala_ccode_function_new (_tmp2_ = g_strdup_printf ("%s_%s_interface_init", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), _tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), "void"), _tmp2_ = (g_free (_tmp2_), NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp3_);
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (iface_init, _tmp6_ = vala_ccode_formal_parameter_new ("iface", _tmp5_ = g_strdup_printf ("%s *", _tmp4_ = vala_interface_get_type_cname (iface))));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp5_ = (g_free (_tmp5_), NULL);
	_tmp4_ = (g_free (_tmp4_), NULL);
	vala_ccode_function_set_modifiers (iface_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (iface_init, init_block);
	ccall = NULL;
	/* save pointer to parent vtable */
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp9_ = NULL;
	parent_iface_var = (_tmp9_ = g_strdup_printf ("%s_%s_parent_iface", _tmp7_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), _tmp8_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), _tmp8_ = (g_free (_tmp8_), NULL), _tmp7_ = (g_free (_tmp7_), NULL), _tmp9_);
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	_tmp12_ = NULL;
	parent_decl = (_tmp12_ = vala_ccode_declaration_new (_tmp11_ = g_strconcat (_tmp10_ = vala_interface_get_type_cname (iface), "*", NULL)), _tmp11_ = (g_free (_tmp11_), NULL), _tmp10_ = (g_free (_tmp10_), NULL), _tmp12_);
	parent_var_decl = vala_ccode_variable_declarator_new (parent_iface_var, NULL, NULL);
	_tmp13_ = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_constant_new ("NULL")));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	vala_ccode_declaration_add_declarator (parent_decl, (ValaCCodeDeclarator*) parent_var_decl);
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) parent_decl);
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	ccall = (_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("g_type_interface_peek_parent"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp15_);
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	_tmp16_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("iface")));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp17_ = NULL;
	_tmp18_ = NULL;
	parent_assignment = (_tmp18_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new (parent_iface_var)), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL)), _tmp18_);
	_tmp19_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp19_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) parent_assignment)));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	{
		GeeList* _tmp20_;
		GeeIterator* _tmp21_;
		GeeIterator* _m_it;
		_tmp20_ = NULL;
		_tmp21_ = NULL;
		_m_it = (_tmp21_ = gee_iterable_iterator ((GeeIterable*) (_tmp20_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl))), (_tmp20_ == NULL) ? NULL : (_tmp20_ = (gee_collection_object_unref (_tmp20_), NULL)), _tmp21_);
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			ValaSymbol* _tmp22_;
			ValaSymbol* base_type;
			ValaCCodeIdentifier* ciface;
			ValaCCodeExpression* cfunc;
			gboolean _tmp23_;
			ValaCCodeExpressionStatement* _tmp46_;
			ValaCCodeAssignment* _tmp45_;
			ValaCCodeMemberAccess* _tmp44_;
			m = (ValaMethod*) gee_iterator_get (_m_it);
			if (vala_method_get_base_interface_method (m) == NULL) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			_tmp22_ = NULL;
			base_type = (_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m)), (_tmp22_ == NULL) ? NULL : vala_code_node_ref (_tmp22_));
			if (base_type != VALA_SYMBOL (iface)) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				continue;
			}
			ciface = vala_ccode_identifier_new ("iface");
			cfunc = NULL;
			_tmp23_ = FALSE;
			if (vala_method_get_is_abstract (m)) {
				_tmp23_ = TRUE;
			} else {
				_tmp23_ = vala_method_get_is_virtual (m);
			}
			if (_tmp23_) {
				ValaCCodeExpression* _tmp25_;
				char* _tmp24_;
				char* _tmp26_;
				char* _tmp27_;
				char* cast;
				char* _tmp28_;
				char* _tmp29_;
				char* cast_args;
				ValaCCodeFunctionDeclarator* vdeclarator;
				GeeHashMap* cparam_map;
				ValaCCodeFunction* _tmp30_;
				gint last_pos;
				gint min_pos;
				char* _tmp40_;
				char* _tmp39_;
				char* _tmp38_;
				ValaCCodeExpression* _tmp41_;
				_tmp25_ = NULL;
				_tmp24_ = NULL;
				cfunc = (_tmp25_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp24_ = vala_method_get_cname (m)), (cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL)), _tmp25_);
				_tmp24_ = (g_free (_tmp24_), NULL);
				/* Cast the function pointer to match the interface*/
				_tmp26_ = NULL;
				_tmp27_ = NULL;
				cast = (_tmp27_ = g_strconcat (_tmp26_ = vala_data_type_get_cname (vala_method_get_return_type (m)), " (*)", NULL), _tmp26_ = (g_free (_tmp26_), NULL), _tmp27_);
				_tmp28_ = NULL;
				_tmp29_ = NULL;
				cast_args = (_tmp29_ = g_strconcat (_tmp28_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), "*", NULL), _tmp28_ = (g_free (_tmp28_), NULL), _tmp29_);
				vdeclarator = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m));
				cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
				_tmp30_ = NULL;
				vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, _tmp30_ = vala_ccode_function_new ("fake", "void"), vdeclarator, NULL, NULL, 3);
				(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
				/* append C arguments in the right order*/
				last_pos = -1;
				min_pos = 0;
				while (TRUE) {
					min_pos = -1;
					{
						GeeSet* _tmp31_;
						GeeIterator* _tmp32_;
						GeeIterator* _pos_it;
						_tmp31_ = NULL;
						_tmp32_ = NULL;
						_pos_it = (_tmp32_ = gee_iterable_iterator ((GeeIterable*) (_tmp31_ = gee_map_get_keys ((GeeMap*) cparam_map))), (_tmp31_ == NULL) ? NULL : (_tmp31_ = (gee_collection_object_unref (_tmp31_), NULL)), _tmp32_);
						while (gee_iterator_next (_pos_it)) {
							gint pos;
							gboolean _tmp33_;
							pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
							_tmp33_ = FALSE;
							if (pos > last_pos) {
								gboolean _tmp34_;
								_tmp34_ = FALSE;
								if (min_pos == (-1)) {
									_tmp34_ = TRUE;
								} else {
									_tmp34_ = pos < min_pos;
								}
								_tmp33_ = _tmp34_;
							} else {
								_tmp33_ = FALSE;
							}
							if (_tmp33_) {
								min_pos = pos;
							}
						}
						(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
					}
					if (last_pos != (-1)) {
						char* _tmp37_;
						char* _tmp36_;
						ValaCCodeFormalParameter* _tmp35_;
						/* Skip the 1st parameter*/
						if (min_pos == (-1)) {
							break;
						}
						_tmp37_ = NULL;
						_tmp36_ = NULL;
						_tmp35_ = NULL;
						cast_args = (_tmp37_ = g_strconcat (cast_args, _tmp36_ = g_strconcat (" ,", vala_ccode_formal_parameter_get_type_name (_tmp35_ = (ValaCCodeFormalParameter*) gee_map_get ((GeeMap*) cparam_map, GINT_TO_POINTER (min_pos))), NULL), NULL), cast_args = (g_free (cast_args), NULL), _tmp37_);
						_tmp36_ = (g_free (_tmp36_), NULL);
						(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
					}
					last_pos = min_pos;
				}
				_tmp40_ = NULL;
				_tmp39_ = NULL;
				_tmp38_ = NULL;
				cast = (_tmp40_ = g_strconcat (cast, _tmp39_ = g_strconcat (_tmp38_ = g_strconcat ("(", cast_args, NULL), ")", NULL), NULL), cast = (g_free (cast), NULL), _tmp40_);
				_tmp39_ = (g_free (_tmp39_), NULL);
				_tmp38_ = (g_free (_tmp38_), NULL);
				_tmp41_ = NULL;
				cfunc = (_tmp41_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cfunc, cast), (cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL)), _tmp41_);
				cast = (g_free (cast), NULL);
				cast_args = (g_free (cast_args), NULL);
				(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
				(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
			} else {
				ValaCCodeExpression* _tmp43_;
				char* _tmp42_;
				_tmp43_ = NULL;
				_tmp42_ = NULL;
				cfunc = (_tmp43_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp42_ = vala_method_get_real_cname (m)), (cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL)), _tmp43_);
				_tmp42_ = (g_free (_tmp42_), NULL);
			}
			_tmp46_ = NULL;
			_tmp45_ = NULL;
			_tmp44_ = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp46_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp45_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, vala_method_get_vfunc_name (vala_method_get_base_interface_method (m)))), cfunc, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
			(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
			(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
			(cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	/* connect inherited implementations*/
	{
		GeeList* _tmp47_;
		GeeIterator* _tmp48_;
		GeeIterator* _m_it;
		/* connect inherited implementations*/
		_tmp47_ = NULL;
		_tmp48_ = NULL;
		_m_it = (_tmp48_ = gee_iterable_iterator ((GeeIterable*) (_tmp47_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), (_tmp47_ == NULL) ? NULL : (_tmp47_ = (gee_collection_object_unref (_tmp47_), NULL)), _tmp48_);
		/* connect inherited implementations*/
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			/* connect inherited implementations*/
			m = (ValaMethod*) gee_iterator_get (_m_it);
			if (vala_method_get_is_abstract (m)) {
				ValaMethod* cl_method;
				ValaClass* _tmp49_;
				ValaClass* base_class;
				gboolean _tmp55_;
				cl_method = NULL;
				_tmp49_ = NULL;
				base_class = (_tmp49_ = cl, (_tmp49_ == NULL) ? NULL : vala_code_node_ref (_tmp49_));
				while (TRUE) {
					gboolean _tmp50_;
					ValaMethod* _tmp52_;
					ValaSymbol* _tmp51_;
					ValaClass* _tmp54_;
					ValaClass* _tmp53_;
					_tmp50_ = FALSE;
					if (base_class != NULL) {
						_tmp50_ = cl_method == NULL;
					} else {
						_tmp50_ = FALSE;
					}
					if (!_tmp50_) {
						break;
					}
					_tmp52_ = NULL;
					_tmp51_ = NULL;
					cl_method = (_tmp52_ = (_tmp51_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) base_class), vala_symbol_get_name ((ValaSymbol*) m)), VALA_IS_METHOD (_tmp51_) ? ((ValaMethod*) _tmp51_) : NULL), (cl_method == NULL) ? NULL : (cl_method = (vala_code_node_unref (cl_method), NULL)), _tmp52_);
					_tmp54_ = NULL;
					_tmp53_ = NULL;
					base_class = (_tmp54_ = (_tmp53_ = vala_class_get_base_class (base_class), (_tmp53_ == NULL) ? NULL : vala_code_node_ref (_tmp53_)), (base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)), _tmp54_);
				}
				_tmp55_ = FALSE;
				if (base_class != NULL) {
					_tmp55_ = vala_symbol_get_parent_symbol ((ValaSymbol*) cl_method) != VALA_SYMBOL (cl);
				} else {
					_tmp55_ = FALSE;
				}
				if (_tmp55_) {
					ValaMethod* _tmp56_;
					ValaMethod* base_method;
					ValaCCodeIdentifier* ciface;
					ValaCCodeExpressionStatement* _tmp65_;
					ValaCCodeAssignment* _tmp64_;
					ValaCCodeIdentifier* _tmp63_;
					char* _tmp62_;
					ValaCCodeMemberAccess* _tmp61_;
					/* method inherited from base class*/
					_tmp56_ = NULL;
					base_method = (_tmp56_ = cl_method, (_tmp56_ == NULL) ? NULL : vala_code_node_ref (_tmp56_));
					if (vala_method_get_base_method (cl_method) != NULL) {
						ValaMethod* _tmp58_;
						ValaMethod* _tmp57_;
						_tmp58_ = NULL;
						_tmp57_ = NULL;
						base_method = (_tmp58_ = (_tmp57_ = vala_method_get_base_method (cl_method), (_tmp57_ == NULL) ? NULL : vala_code_node_ref (_tmp57_)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp58_);
					} else {
						if (vala_method_get_base_interface_method (cl_method) != NULL) {
							ValaMethod* _tmp60_;
							ValaMethod* _tmp59_;
							_tmp60_ = NULL;
							_tmp59_ = NULL;
							base_method = (_tmp60_ = (_tmp59_ = vala_method_get_base_interface_method (cl_method), (_tmp59_ == NULL) ? NULL : vala_code_node_ref (_tmp59_)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp60_);
						}
					}
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, base_method, ((ValaCCodeBaseModule*) self)->source_declarations);
					ciface = vala_ccode_identifier_new ("iface");
					_tmp65_ = NULL;
					_tmp64_ = NULL;
					_tmp63_ = NULL;
					_tmp62_ = NULL;
					_tmp61_ = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp65_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp64_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp61_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, vala_method_get_vfunc_name (m))), (ValaCCodeExpression*) (_tmp63_ = vala_ccode_identifier_new (_tmp62_ = vala_method_get_cname (base_method))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_ccode_node_unref (_tmp65_), NULL));
					(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_ccode_node_unref (_tmp64_), NULL));
					(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
					_tmp62_ = (g_free (_tmp62_), NULL);
					(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
					(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
					(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
				}
				(cl_method == NULL) ? NULL : (cl_method = (vala_code_node_unref (cl_method), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	{
		GeeList* _tmp66_;
		GeeIterator* _tmp67_;
		GeeIterator* _prop_it;
		_tmp66_ = NULL;
		_tmp67_ = NULL;
		_prop_it = (_tmp67_ = gee_iterable_iterator ((GeeIterable*) (_tmp66_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), (_tmp66_ == NULL) ? NULL : (_tmp66_ = (gee_collection_object_unref (_tmp66_), NULL)), _tmp67_);
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			ValaSymbol* _tmp68_;
			ValaSymbol* base_type;
			ValaCCodeIdentifier* ciface;
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			if (vala_property_get_base_interface_property (prop) == NULL) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			_tmp68_ = NULL;
			base_type = (_tmp68_ = vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop)), (_tmp68_ == NULL) ? NULL : vala_code_node_ref (_tmp68_));
			if (base_type != VALA_SYMBOL (iface)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				continue;
			}
			ciface = vala_ccode_identifier_new ("iface");
			if (vala_property_get_get_accessor (prop) != NULL) {
				char* _tmp69_;
				char* _tmp70_;
				char* cname;
				gboolean _tmp71_;
				ValaCCodeExpressionStatement* _tmp78_;
				ValaCCodeAssignment* _tmp77_;
				ValaCCodeIdentifier* _tmp76_;
				ValaCCodeMemberAccess* _tmp75_;
				char* _tmp74_;
				_tmp69_ = NULL;
				_tmp70_ = NULL;
				cname = (_tmp70_ = g_strdup_printf ("%s_real_get_%s", _tmp69_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), _tmp69_ = (g_free (_tmp69_), NULL), _tmp70_);
				_tmp71_ = FALSE;
				if (vala_property_get_is_abstract (prop)) {
					_tmp71_ = TRUE;
				} else {
					_tmp71_ = vala_property_get_is_virtual (prop);
				}
				if (_tmp71_) {
					char* _tmp73_;
					char* _tmp72_;
					_tmp73_ = NULL;
					_tmp72_ = NULL;
					cname = (_tmp73_ = g_strdup_printf ("%s_get_%s", _tmp72_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), cname = (g_free (cname), NULL), _tmp73_);
					_tmp72_ = (g_free (_tmp72_), NULL);
				}
				_tmp78_ = NULL;
				_tmp77_ = NULL;
				_tmp76_ = NULL;
				_tmp75_ = NULL;
				_tmp74_ = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp78_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp77_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp75_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, _tmp74_ = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp76_ = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
				(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
				(_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL));
				(_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL));
				_tmp74_ = (g_free (_tmp74_), NULL);
				cname = (g_free (cname), NULL);
			}
			if (vala_property_get_set_accessor (prop) != NULL) {
				char* _tmp79_;
				char* _tmp80_;
				char* cname;
				gboolean _tmp81_;
				ValaCCodeExpressionStatement* _tmp88_;
				ValaCCodeAssignment* _tmp87_;
				ValaCCodeIdentifier* _tmp86_;
				ValaCCodeMemberAccess* _tmp85_;
				char* _tmp84_;
				_tmp79_ = NULL;
				_tmp80_ = NULL;
				cname = (_tmp80_ = g_strdup_printf ("%s_real_set_%s", _tmp79_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), _tmp79_ = (g_free (_tmp79_), NULL), _tmp80_);
				_tmp81_ = FALSE;
				if (vala_property_get_is_abstract (prop)) {
					_tmp81_ = TRUE;
				} else {
					_tmp81_ = vala_property_get_is_virtual (prop);
				}
				if (_tmp81_) {
					char* _tmp83_;
					char* _tmp82_;
					_tmp83_ = NULL;
					_tmp82_ = NULL;
					cname = (_tmp83_ = g_strdup_printf ("%s_set_%s", _tmp82_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), cname = (g_free (cname), NULL), _tmp83_);
					_tmp82_ = (g_free (_tmp82_), NULL);
				}
				_tmp88_ = NULL;
				_tmp87_ = NULL;
				_tmp86_ = NULL;
				_tmp85_ = NULL;
				_tmp84_ = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp88_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp87_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp85_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, _tmp84_ = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp86_ = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp88_ == NULL) ? NULL : (_tmp88_ = (vala_ccode_node_unref (_tmp88_), NULL));
				(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
				(_tmp86_ == NULL) ? NULL : (_tmp86_ = (vala_ccode_node_unref (_tmp86_), NULL));
				(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
				_tmp84_ = (g_free (_tmp84_), NULL);
				cname = (g_free (cname), NULL);
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	{
		GeeList* _tmp89_;
		GeeIterator* _tmp90_;
		GeeIterator* _prop_it;
		_tmp89_ = NULL;
		_tmp90_ = NULL;
		_prop_it = (_tmp90_ = gee_iterable_iterator ((GeeIterable*) (_tmp89_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface))), (_tmp89_ == NULL) ? NULL : (_tmp89_ = (gee_collection_object_unref (_tmp89_), NULL)), _tmp90_);
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			ValaProperty* cl_prop;
			ValaClass* _tmp91_;
			ValaClass* base_class;
			gboolean _tmp97_;
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			if (!vala_property_get_is_abstract (prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			cl_prop = NULL;
			_tmp91_ = NULL;
			base_class = (_tmp91_ = cl, (_tmp91_ == NULL) ? NULL : vala_code_node_ref (_tmp91_));
			while (TRUE) {
				gboolean _tmp92_;
				ValaProperty* _tmp94_;
				ValaSymbol* _tmp93_;
				ValaClass* _tmp96_;
				ValaClass* _tmp95_;
				_tmp92_ = FALSE;
				if (base_class != NULL) {
					_tmp92_ = cl_prop == NULL;
				} else {
					_tmp92_ = FALSE;
				}
				if (!_tmp92_) {
					break;
				}
				_tmp94_ = NULL;
				_tmp93_ = NULL;
				cl_prop = (_tmp94_ = (_tmp93_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) base_class), vala_symbol_get_name ((ValaSymbol*) prop)), VALA_IS_PROPERTY (_tmp93_) ? ((ValaProperty*) _tmp93_) : NULL), (cl_prop == NULL) ? NULL : (cl_prop = (vala_code_node_unref (cl_prop), NULL)), _tmp94_);
				_tmp96_ = NULL;
				_tmp95_ = NULL;
				base_class = (_tmp96_ = (_tmp95_ = vala_class_get_base_class (base_class), (_tmp95_ == NULL) ? NULL : vala_code_node_ref (_tmp95_)), (base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)), _tmp96_);
			}
			_tmp97_ = FALSE;
			if (base_class != NULL) {
				_tmp97_ = vala_symbol_get_parent_symbol ((ValaSymbol*) cl_prop) != VALA_SYMBOL (cl);
			} else {
				_tmp97_ = FALSE;
			}
			if (_tmp97_) {
				ValaProperty* _tmp98_;
				ValaProperty* base_property;
				ValaCCodeIdentifier* ciface;
				/* property inherited from base class*/
				_tmp98_ = NULL;
				base_property = (_tmp98_ = cl_prop, (_tmp98_ == NULL) ? NULL : vala_code_node_ref (_tmp98_));
				if (vala_property_get_base_property (cl_prop) != NULL) {
					ValaProperty* _tmp100_;
					ValaProperty* _tmp99_;
					_tmp100_ = NULL;
					_tmp99_ = NULL;
					base_property = (_tmp100_ = (_tmp99_ = vala_property_get_base_property (cl_prop), (_tmp99_ == NULL) ? NULL : vala_code_node_ref (_tmp99_)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp100_);
				} else {
					if (vala_property_get_base_interface_property (cl_prop) != NULL) {
						ValaProperty* _tmp102_;
						ValaProperty* _tmp101_;
						_tmp102_ = NULL;
						_tmp101_ = NULL;
						base_property = (_tmp102_ = (_tmp101_ = vala_property_get_base_interface_property (cl_prop), (_tmp101_ == NULL) ? NULL : vala_code_node_ref (_tmp101_)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp102_);
					}
				}
				ciface = vala_ccode_identifier_new ("iface");
				if (vala_property_get_get_accessor (base_property) != NULL) {
					char* cname;
					ValaCCodeExpressionStatement* _tmp107_;
					ValaCCodeAssignment* _tmp106_;
					ValaCCodeIdentifier* _tmp105_;
					ValaCCodeMemberAccess* _tmp104_;
					char* _tmp103_;
					cname = vala_property_accessor_get_cname (vala_property_get_get_accessor (base_property));
					_tmp107_ = NULL;
					_tmp106_ = NULL;
					_tmp105_ = NULL;
					_tmp104_ = NULL;
					_tmp103_ = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp107_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp106_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp104_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, _tmp103_ = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp105_ = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp107_ == NULL) ? NULL : (_tmp107_ = (vala_ccode_node_unref (_tmp107_), NULL));
					(_tmp106_ == NULL) ? NULL : (_tmp106_ = (vala_ccode_node_unref (_tmp106_), NULL));
					(_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_ccode_node_unref (_tmp105_), NULL));
					(_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_ccode_node_unref (_tmp104_), NULL));
					_tmp103_ = (g_free (_tmp103_), NULL);
					cname = (g_free (cname), NULL);
				}
				if (vala_property_get_set_accessor (base_property) != NULL) {
					char* cname;
					ValaCCodeExpressionStatement* _tmp112_;
					ValaCCodeAssignment* _tmp111_;
					ValaCCodeIdentifier* _tmp110_;
					ValaCCodeMemberAccess* _tmp109_;
					char* _tmp108_;
					cname = vala_property_accessor_get_cname (vala_property_get_set_accessor (base_property));
					_tmp112_ = NULL;
					_tmp111_ = NULL;
					_tmp110_ = NULL;
					_tmp109_ = NULL;
					_tmp108_ = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp112_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp111_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp109_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, _tmp108_ = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp110_ = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp112_ == NULL) ? NULL : (_tmp112_ = (vala_ccode_node_unref (_tmp112_), NULL));
					(_tmp111_ == NULL) ? NULL : (_tmp111_ = (vala_ccode_node_unref (_tmp111_), NULL));
					(_tmp110_ == NULL) ? NULL : (_tmp110_ = (vala_ccode_node_unref (_tmp110_), NULL));
					(_tmp109_ == NULL) ? NULL : (_tmp109_ = (vala_ccode_node_unref (_tmp109_), NULL));
					_tmp108_ = (g_free (_tmp108_), NULL);
					cname = (g_free (cname), NULL);
				}
				(base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL));
				(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(cl_prop == NULL) ? NULL : (cl_prop = (vala_code_node_unref (cl_prop), NULL));
			(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) iface_init);
	(iface_init == NULL) ? NULL : (iface_init = (vala_ccode_node_unref (iface_init), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	parent_iface_var = (g_free (parent_iface_var), NULL);
	(parent_decl == NULL) ? NULL : (parent_decl = (vala_ccode_node_unref (parent_decl), NULL));
	(parent_var_decl == NULL) ? NULL : (parent_var_decl = (vala_ccode_node_unref (parent_var_decl), NULL));
	(parent_assignment == NULL) ? NULL : (parent_assignment = (vala_ccode_node_unref (parent_assignment), NULL));
}


static void vala_gtype_module_add_instance_init_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* instance_init;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeBlock* init_block;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	instance_init = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_instance_init", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (instance_init, _tmp5_ = vala_ccode_formal_parameter_new ("self", _tmp4_ = g_strdup_printf ("%s *", _tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp3_ = (g_free (_tmp3_), NULL);
	vala_ccode_function_set_modifiers (instance_init, VALA_CCODE_MODIFIERS_STATIC);
	if (vala_class_get_is_compact (cl)) {
		ValaCCodeFunction* _tmp6_;
		/* Add declaration, since the instance_init function is explicitly called
		 by the creation methods*/
		_tmp6_ = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp6_ = vala_ccode_function_copy (instance_init)));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	}
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (instance_init, init_block);
	_tmp7_ = FALSE;
	if (!vala_class_get_is_compact (cl)) {
		gboolean _tmp8_;
		_tmp8_ = FALSE;
		if (vala_class_get_has_private_fields (cl)) {
			_tmp8_ = TRUE;
		} else {
			GeeList* _tmp9_;
			_tmp9_ = NULL;
			_tmp8_ = gee_collection_get_size ((GeeCollection*) (_tmp9_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (gee_collection_object_unref (_tmp9_), NULL));
		}
		_tmp7_ = _tmp8_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaCCodeIdentifier* _tmp12_;
		char* _tmp11_;
		char* _tmp10_;
		ValaCCodeFunctionCall* _tmp13_;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeExpressionStatement* _tmp18_;
		ValaCCodeAssignment* _tmp17_;
		ValaCCodeMemberAccess* _tmp16_;
		ValaCCodeIdentifier* _tmp15_;
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		_tmp13_ = NULL;
		ccall = (_tmp13_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new (_tmp11_ = g_strdup_printf ("%s_GET_PRIVATE", _tmp10_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL)), _tmp11_ = (g_free (_tmp11_), NULL), _tmp10_ = (g_free (_tmp10_), NULL), _tmp13_);
		_tmp14_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("self")));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
		_tmp18_ = NULL;
		_tmp17_ = NULL;
		_tmp16_ = NULL;
		_tmp15_ = NULL;
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp18_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("self")), "priv")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
		(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
		(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	}
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_init_fragment);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) instance_init);
	(instance_init == NULL) ? NULL : (instance_init = (vala_ccode_node_unref (instance_init), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
}


static void vala_gtype_module_add_class_finalize_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeBlock* cblock;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	function = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_class_finalize", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp5_ = vala_ccode_formal_parameter_new ("klass", _tmp4_ = g_strconcat (_tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "Class *", NULL)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp6_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp6_ = vala_ccode_function_copy (function)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	cblock = vala_ccode_block_new ();
	if (vala_class_get_class_destructor (cl) != NULL) {
		vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_class_get_class_destructor (cl)));
	}
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->class_finalize_fragment);
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
}


static void vala_gtype_module_add_base_finalize_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeBlock* cblock;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	function = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_base_finalize", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp5_ = vala_ccode_formal_parameter_new ("klass", _tmp4_ = g_strconcat (_tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "Class *", NULL)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp6_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp6_ = vala_ccode_function_copy (function)));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	cblock = vala_ccode_block_new ();
	if (vala_class_get_class_destructor (cl) != NULL) {
		vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_class_get_class_destructor (cl)));
	}
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->base_finalize_fragment);
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
}


static void vala_gtype_module_add_finalize_function (ValaGTypeModule* self, ValaClass* cl) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* function;
	ValaClass* _tmp3_;
	ValaClass* fundamental_class;
	ValaCCodeFormalParameter* _tmp8_;
	char* _tmp7_;
	char* _tmp6_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeBlock* cblock;
	ValaCCodeIdentifier* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	ValaCCodeFunctionCall* ccall;
	char* _tmp13_;
	char* _tmp12_;
	ValaCCodeDeclaration* _tmp14_;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	function = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_finalize", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3_ = NULL;
	fundamental_class = (_tmp3_ = cl, (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	while (vala_class_get_base_class (fundamental_class) != NULL) {
		ValaClass* _tmp5_;
		ValaClass* _tmp4_;
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		fundamental_class = (_tmp5_ = (_tmp4_ = vala_class_get_base_class (fundamental_class), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_)), (fundamental_class == NULL) ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL)), _tmp5_);
	}
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp8_ = vala_ccode_formal_parameter_new ("obj", _tmp7_ = g_strconcat (_tmp6_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) fundamental_class, FALSE), "*", NULL)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp9_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp9_ = vala_ccode_function_copy (function)));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	cblock = vala_ccode_block_new ();
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	ccall = (_tmp11_ = (ValaCCodeFunctionCall*) vala_instance_cast_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("obj")), (ValaTypeSymbol*) cl), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	_tmp14_ = NULL;
	_cdecl_ = (_tmp14_ = vala_ccode_declaration_new (_tmp13_ = g_strdup_printf ("%s *", _tmp12_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp13_ = (g_free (_tmp13_), NULL), _tmp12_ = (g_free (_tmp12_), NULL), _tmp14_);
	_tmp15_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp15_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) ccall, NULL)));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) _cdecl_);
	if (vala_class_get_destructor (cl) != NULL) {
		vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_class_get_destructor (cl)));
	}
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_finalize_fragment);
	/* chain up to finalize function of the base class*/
	if (vala_class_get_base_class (cl) != NULL) {
		ValaCCodeIdentifier* _tmp18_;
		char* _tmp17_;
		char* _tmp16_;
		ValaCCodeFunctionCall* _tmp19_;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* _tmp22_;
		char* _tmp21_;
		char* _tmp20_;
		ValaCCodeFunctionCall* _tmp24_;
		ValaCCodeMemberAccess* _tmp23_;
		ValaCCodeIdentifier* _tmp25_;
		ValaCCodeExpressionStatement* _tmp26_;
		_tmp18_ = NULL;
		_tmp17_ = NULL;
		_tmp16_ = NULL;
		_tmp19_ = NULL;
		ccast = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new (_tmp17_ = g_strdup_printf ("%s_CLASS", _tmp16_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) fundamental_class, NULL))))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp17_ = (g_free (_tmp17_), NULL), _tmp16_ = (g_free (_tmp16_), NULL), _tmp19_);
		_tmp22_ = NULL;
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new (_tmp21_ = g_strdup_printf ("%s_parent_class", _tmp20_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
		_tmp21_ = (g_free (_tmp21_), NULL);
		_tmp20_ = (g_free (_tmp20_), NULL);
		_tmp24_ = NULL;
		_tmp23_ = NULL;
		ccall = (_tmp24_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, "finalize"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp24_);
		(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
		_tmp25_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("obj")));
		(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
		_tmp26_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp26_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
		(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
	}
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(fundamental_class == NULL) ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
}


static ValaCCodeFunctionCall* vala_gtype_module_real_get_param_spec (ValaCCodeModule* base, ValaProperty* prop) {
	ValaGTypeModule * self;
	ValaCCodeFunctionCall* cspec;
	ValaCCodeConstant* _tmp0_;
	ValaCCodeConstant* _tmp2_;
	char* _tmp1_;
	ValaCCodeConstant* _tmp4_;
	char* _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	char* pflags;
	ValaCCodeConstant* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	self = (ValaGTypeModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	cspec = vala_ccode_function_call_new (NULL);
	_tmp0_ = NULL;
	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp0_ = vala_property_get_canonical_cconstant (prop)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_constant_new (_tmp1_ = g_strdup_printf ("\"%s\"", vala_property_get_nick (prop)))));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new (_tmp3_ = g_strdup_printf ("\"%s\"", vala_property_get_blurb (prop)))));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp5_ = FALSE;
	_tmp6_ = FALSE;
	if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
		_tmp6_ = !vala_class_get_is_compact (VALA_CLASS (vala_data_type_get_data_type (vala_property_get_property_type (prop))));
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = VALA_IS_INTERFACE (vala_data_type_get_data_type (vala_property_get_property_type (prop)));
	}
	if (_tmp5_) {
		char* param_spec_name;
		param_spec_name = vala_typesymbol_get_param_spec_function (vala_data_type_get_data_type (vala_property_get_property_type (prop)));
		if (param_spec_name == NULL) {
			ValaCCodeIdentifier* _tmp7_;
			_tmp7_ = NULL;
			vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("g_param_spec_pointer")));
			(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		} else {
			ValaCCodeIdentifier* _tmp8_;
			ValaCCodeIdentifier* _tmp10_;
			char* _tmp9_;
			_tmp8_ = NULL;
			vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new (param_spec_name)));
			(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
			_tmp10_ = NULL;
			_tmp9_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new (_tmp9_ = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_property_get_property_type (prop))))));
			(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
			_tmp9_ = (g_free (_tmp9_), NULL);
		}
		param_spec_name = (g_free (param_spec_name), NULL);
	} else {
		if (vala_data_type_get_data_type (vala_property_get_property_type (prop)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
			ValaCCodeIdentifier* _tmp11_;
			ValaCCodeConstant* _tmp12_;
			_tmp11_ = NULL;
			vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("g_param_spec_string")));
			(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
			_tmp12_ = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_constant_new ("NULL")));
			(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
		} else {
			if (VALA_IS_ENUM (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
				ValaEnum* _tmp14_;
				ValaTypeSymbol* _tmp13_;
				ValaEnum* e;
				_tmp14_ = NULL;
				_tmp13_ = NULL;
				e = (_tmp14_ = (_tmp13_ = vala_data_type_get_data_type (vala_property_get_property_type (prop)), VALA_IS_ENUM (_tmp13_) ? ((ValaEnum*) _tmp13_) : NULL), (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_));
				if (vala_enum_get_has_type_id (e)) {
					ValaCCodeIdentifier* _tmp18_;
					char* _tmp17_;
					if (vala_enum_get_is_flags (e)) {
						ValaCCodeIdentifier* _tmp15_;
						_tmp15_ = NULL;
						vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("g_param_spec_flags")));
						(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
					} else {
						ValaCCodeIdentifier* _tmp16_;
						_tmp16_ = NULL;
						vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("g_param_spec_enum")));
						(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
					}
					_tmp18_ = NULL;
					_tmp17_ = NULL;
					vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new (_tmp17_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) e))));
					(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
					_tmp17_ = (g_free (_tmp17_), NULL);
				} else {
					if (vala_enum_get_is_flags (e)) {
						ValaCCodeIdentifier* _tmp19_;
						ValaCCodeConstant* _tmp20_;
						ValaCCodeConstant* _tmp21_;
						_tmp19_ = NULL;
						vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("g_param_spec_uint")));
						(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
						_tmp20_ = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_constant_new ("0")));
						(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
						_tmp21_ = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_constant_new ("G_MAXUINT")));
						(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
					} else {
						ValaCCodeIdentifier* _tmp22_;
						ValaCCodeConstant* _tmp23_;
						ValaCCodeConstant* _tmp24_;
						_tmp22_ = NULL;
						vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("g_param_spec_int")));
						(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
						_tmp23_ = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_constant_new ("G_MININT")));
						(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
						_tmp24_ = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_constant_new ("G_MAXINT")));
						(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
					}
				}
				if (vala_property_get_default_expression (prop) != NULL) {
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
				} else {
					ValaCCodeConstant* _tmp26_;
					char* _tmp25_;
					_tmp26_ = NULL;
					_tmp25_ = NULL;
					vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_constant_new (_tmp25_ = vala_typesymbol_get_default_value (vala_data_type_get_data_type (vala_property_get_property_type (prop))))));
					(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
					_tmp25_ = (g_free (_tmp25_), NULL);
				}
				(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
			} else {
				if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
					ValaStruct* _tmp27_;
					ValaStruct* st;
					char* _tmp28_;
					gboolean _tmp29_;
					_tmp27_ = NULL;
					st = (_tmp27_ = VALA_STRUCT (vala_data_type_get_data_type (vala_property_get_property_type (prop))), (_tmp27_ == NULL) ? NULL : vala_code_node_ref (_tmp27_));
					_tmp28_ = NULL;
					if ((_tmp29_ = _vala_strcmp0 (_tmp28_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_INT") == 0, _tmp28_ = (g_free (_tmp28_), NULL), _tmp29_)) {
						ValaCCodeIdentifier* _tmp30_;
						ValaCCodeConstant* _tmp31_;
						ValaCCodeConstant* _tmp32_;
						_tmp30_ = NULL;
						vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("g_param_spec_int")));
						(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
						_tmp31_ = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp31_ = vala_ccode_constant_new ("G_MININT")));
						(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
						_tmp32_ = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_constant_new ("G_MAXINT")));
						(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
						if (vala_property_get_default_expression (prop) != NULL) {
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
						} else {
							ValaCCodeConstant* _tmp33_;
							_tmp33_ = NULL;
							vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_constant_new ("0")));
							(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
						}
					} else {
						char* _tmp34_;
						gboolean _tmp35_;
						_tmp34_ = NULL;
						if ((_tmp35_ = _vala_strcmp0 (_tmp34_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_UINT") == 0, _tmp34_ = (g_free (_tmp34_), NULL), _tmp35_)) {
							ValaCCodeIdentifier* _tmp36_;
							ValaCCodeConstant* _tmp37_;
							ValaCCodeConstant* _tmp38_;
							_tmp36_ = NULL;
							vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new ("g_param_spec_uint")));
							(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
							_tmp37_ = NULL;
							vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp37_ = vala_ccode_constant_new ("0")));
							(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
							_tmp38_ = NULL;
							vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp38_ = vala_ccode_constant_new ("G_MAXUINT")));
							(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
							if (vala_property_get_default_expression (prop) != NULL) {
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
							} else {
								ValaCCodeConstant* _tmp39_;
								_tmp39_ = NULL;
								vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_constant_new ("0U")));
								(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
							}
						} else {
							char* _tmp40_;
							gboolean _tmp41_;
							_tmp40_ = NULL;
							if ((_tmp41_ = _vala_strcmp0 (_tmp40_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_INT64") == 0, _tmp40_ = (g_free (_tmp40_), NULL), _tmp41_)) {
								ValaCCodeIdentifier* _tmp42_;
								ValaCCodeConstant* _tmp43_;
								ValaCCodeConstant* _tmp44_;
								_tmp42_ = NULL;
								vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new ("g_param_spec_int64")));
								(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
								_tmp43_ = NULL;
								vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_constant_new ("G_MININT64")));
								(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
								_tmp44_ = NULL;
								vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_constant_new ("G_MAXINT64")));
								(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
								if (vala_property_get_default_expression (prop) != NULL) {
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
								} else {
									ValaCCodeConstant* _tmp45_;
									_tmp45_ = NULL;
									vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp45_ = vala_ccode_constant_new ("0")));
									(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
								}
							} else {
								char* _tmp46_;
								gboolean _tmp47_;
								_tmp46_ = NULL;
								if ((_tmp47_ = _vala_strcmp0 (_tmp46_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_UINT64") == 0, _tmp46_ = (g_free (_tmp46_), NULL), _tmp47_)) {
									ValaCCodeIdentifier* _tmp48_;
									ValaCCodeConstant* _tmp49_;
									ValaCCodeConstant* _tmp50_;
									_tmp48_ = NULL;
									vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_identifier_new ("g_param_spec_uint64")));
									(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
									_tmp49_ = NULL;
									vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp49_ = vala_ccode_constant_new ("0")));
									(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
									_tmp50_ = NULL;
									vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp50_ = vala_ccode_constant_new ("G_MAXUINT64")));
									(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
									if (vala_property_get_default_expression (prop) != NULL) {
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
									} else {
										ValaCCodeConstant* _tmp51_;
										_tmp51_ = NULL;
										vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp51_ = vala_ccode_constant_new ("0U")));
										(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
									}
								} else {
									char* _tmp52_;
									gboolean _tmp53_;
									_tmp52_ = NULL;
									if ((_tmp53_ = _vala_strcmp0 (_tmp52_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_LONG") == 0, _tmp52_ = (g_free (_tmp52_), NULL), _tmp53_)) {
										ValaCCodeIdentifier* _tmp54_;
										ValaCCodeConstant* _tmp55_;
										ValaCCodeConstant* _tmp56_;
										_tmp54_ = NULL;
										vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new ("g_param_spec_long")));
										(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
										_tmp55_ = NULL;
										vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp55_ = vala_ccode_constant_new ("G_MINLONG")));
										(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
										_tmp56_ = NULL;
										vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_constant_new ("G_MAXLONG")));
										(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
										if (vala_property_get_default_expression (prop) != NULL) {
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
										} else {
											ValaCCodeConstant* _tmp57_;
											_tmp57_ = NULL;
											vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp57_ = vala_ccode_constant_new ("0L")));
											(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
										}
									} else {
										char* _tmp58_;
										gboolean _tmp59_;
										_tmp58_ = NULL;
										if ((_tmp59_ = _vala_strcmp0 (_tmp58_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_ULONG") == 0, _tmp58_ = (g_free (_tmp58_), NULL), _tmp59_)) {
											ValaCCodeIdentifier* _tmp60_;
											ValaCCodeConstant* _tmp61_;
											ValaCCodeConstant* _tmp62_;
											_tmp60_ = NULL;
											vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp60_ = vala_ccode_identifier_new ("g_param_spec_ulong")));
											(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
											_tmp61_ = NULL;
											vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp61_ = vala_ccode_constant_new ("0")));
											(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
											_tmp62_ = NULL;
											vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp62_ = vala_ccode_constant_new ("G_MAXULONG")));
											(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
											if (vala_property_get_default_expression (prop) != NULL) {
												vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
											} else {
												ValaCCodeConstant* _tmp63_;
												_tmp63_ = NULL;
												vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp63_ = vala_ccode_constant_new ("0UL")));
												(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
											}
										} else {
											char* _tmp64_;
											gboolean _tmp65_;
											_tmp64_ = NULL;
											if ((_tmp65_ = _vala_strcmp0 (_tmp64_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_BOOLEAN") == 0, _tmp64_ = (g_free (_tmp64_), NULL), _tmp65_)) {
												ValaCCodeIdentifier* _tmp66_;
												_tmp66_ = NULL;
												vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp66_ = vala_ccode_identifier_new ("g_param_spec_boolean")));
												(_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL));
												if (vala_property_get_default_expression (prop) != NULL) {
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
												} else {
													ValaCCodeConstant* _tmp67_;
													_tmp67_ = NULL;
													vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp67_ = vala_ccode_constant_new ("FALSE")));
													(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
												}
											} else {
												char* _tmp68_;
												gboolean _tmp69_;
												_tmp68_ = NULL;
												if ((_tmp69_ = _vala_strcmp0 (_tmp68_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_CHAR") == 0, _tmp68_ = (g_free (_tmp68_), NULL), _tmp69_)) {
													ValaCCodeIdentifier* _tmp70_;
													ValaCCodeConstant* _tmp71_;
													ValaCCodeConstant* _tmp72_;
													_tmp70_ = NULL;
													vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp70_ = vala_ccode_identifier_new ("g_param_spec_char")));
													(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
													_tmp71_ = NULL;
													vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp71_ = vala_ccode_constant_new ("G_MININT8")));
													(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
													_tmp72_ = NULL;
													vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp72_ = vala_ccode_constant_new ("G_MAXINT8")));
													(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
													if (vala_property_get_default_expression (prop) != NULL) {
														vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
													} else {
														ValaCCodeConstant* _tmp73_;
														_tmp73_ = NULL;
														vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp73_ = vala_ccode_constant_new ("0")));
														(_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_ccode_node_unref (_tmp73_), NULL));
													}
												} else {
													char* _tmp74_;
													gboolean _tmp75_;
													_tmp74_ = NULL;
													if ((_tmp75_ = _vala_strcmp0 (_tmp74_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_UCHAR") == 0, _tmp74_ = (g_free (_tmp74_), NULL), _tmp75_)) {
														ValaCCodeIdentifier* _tmp76_;
														ValaCCodeConstant* _tmp77_;
														ValaCCodeConstant* _tmp78_;
														_tmp76_ = NULL;
														vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp76_ = vala_ccode_identifier_new ("g_param_spec_uchar")));
														(_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL));
														_tmp77_ = NULL;
														vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp77_ = vala_ccode_constant_new ("0")));
														(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
														_tmp78_ = NULL;
														vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp78_ = vala_ccode_constant_new ("G_MAXUINT8")));
														(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
														if (vala_property_get_default_expression (prop) != NULL) {
															vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
														} else {
															ValaCCodeConstant* _tmp79_;
															_tmp79_ = NULL;
															vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp79_ = vala_ccode_constant_new ("0")));
															(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
														}
													} else {
														char* _tmp80_;
														gboolean _tmp81_;
														_tmp80_ = NULL;
														if ((_tmp81_ = _vala_strcmp0 (_tmp80_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_FLOAT") == 0, _tmp80_ = (g_free (_tmp80_), NULL), _tmp81_)) {
															ValaCCodeIdentifier* _tmp82_;
															ValaCCodeConstant* _tmp83_;
															ValaCCodeConstant* _tmp84_;
															_tmp82_ = NULL;
															vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp82_ = vala_ccode_identifier_new ("g_param_spec_float")));
															(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
															_tmp83_ = NULL;
															vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp83_ = vala_ccode_constant_new ("-G_MAXFLOAT")));
															(_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL));
															_tmp84_ = NULL;
															vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp84_ = vala_ccode_constant_new ("G_MAXFLOAT")));
															(_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL));
															if (vala_property_get_default_expression (prop) != NULL) {
																vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
															} else {
																ValaCCodeConstant* _tmp85_;
																_tmp85_ = NULL;
																vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp85_ = vala_ccode_constant_new ("0.0F")));
																(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
															}
														} else {
															char* _tmp86_;
															gboolean _tmp87_;
															_tmp86_ = NULL;
															if ((_tmp87_ = _vala_strcmp0 (_tmp86_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_DOUBLE") == 0, _tmp86_ = (g_free (_tmp86_), NULL), _tmp87_)) {
																ValaCCodeIdentifier* _tmp88_;
																ValaCCodeConstant* _tmp89_;
																ValaCCodeConstant* _tmp90_;
																_tmp88_ = NULL;
																vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp88_ = vala_ccode_identifier_new ("g_param_spec_double")));
																(_tmp88_ == NULL) ? NULL : (_tmp88_ = (vala_ccode_node_unref (_tmp88_), NULL));
																_tmp89_ = NULL;
																vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp89_ = vala_ccode_constant_new ("-G_MAXDOUBLE")));
																(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
																_tmp90_ = NULL;
																vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp90_ = vala_ccode_constant_new ("G_MAXDOUBLE")));
																(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
																if (vala_property_get_default_expression (prop) != NULL) {
																	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
																} else {
																	ValaCCodeConstant* _tmp91_;
																	_tmp91_ = NULL;
																	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp91_ = vala_ccode_constant_new ("0.0")));
																	(_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL));
																}
															} else {
																char* _tmp92_;
																gboolean _tmp93_;
																_tmp92_ = NULL;
																if ((_tmp93_ = _vala_strcmp0 (_tmp92_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_GTYPE") == 0, _tmp92_ = (g_free (_tmp92_), NULL), _tmp93_)) {
																	ValaCCodeIdentifier* _tmp94_;
																	_tmp94_ = NULL;
																	vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp94_ = vala_ccode_identifier_new ("g_param_spec_gtype")));
																	(_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_ccode_node_unref (_tmp94_), NULL));
																	if (vala_property_get_default_expression (prop) != NULL) {
																		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
																	} else {
																		ValaCCodeConstant* _tmp95_;
																		_tmp95_ = NULL;
																		vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp95_ = vala_ccode_constant_new ("G_TYPE_NONE")));
																		(_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL));
																	}
																} else {
																	ValaCCodeIdentifier* _tmp96_;
																	ValaCCodeIdentifier* _tmp98_;
																	char* _tmp97_;
																	_tmp96_ = NULL;
																	vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp96_ = vala_ccode_identifier_new ("g_param_spec_boxed")));
																	(_tmp96_ == NULL) ? NULL : (_tmp96_ = (vala_ccode_node_unref (_tmp96_), NULL));
																	_tmp98_ = NULL;
																	_tmp97_ = NULL;
																	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp98_ = vala_ccode_identifier_new (_tmp97_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st))));
																	(_tmp98_ == NULL) ? NULL : (_tmp98_ = (vala_ccode_node_unref (_tmp98_), NULL));
																	_tmp97_ = (g_free (_tmp97_), NULL);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				} else {
					ValaCCodeIdentifier* _tmp99_;
					_tmp99_ = NULL;
					vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp99_ = vala_ccode_identifier_new ("g_param_spec_pointer")));
					(_tmp99_ == NULL) ? NULL : (_tmp99_ = (vala_ccode_node_unref (_tmp99_), NULL));
				}
			}
		}
	}
	pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* _tmp100_;
		_tmp100_ = NULL;
		pflags = (_tmp100_ = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), pflags = (g_free (pflags), NULL), _tmp100_);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* _tmp101_;
		_tmp101_ = NULL;
		pflags = (_tmp101_ = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), pflags = (g_free (pflags), NULL), _tmp101_);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* _tmp102_;
				_tmp102_ = NULL;
				pflags = (_tmp102_ = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), pflags = (g_free (pflags), NULL), _tmp102_);
			} else {
				char* _tmp103_;
				_tmp103_ = NULL;
				pflags = (_tmp103_ = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), pflags = (g_free (pflags), NULL), _tmp103_);
			}
		}
	}
	_tmp104_ = NULL;
	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp104_ = vala_ccode_constant_new (pflags)));
	(_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_ccode_node_unref (_tmp104_), NULL));
	_tmp105_ = NULL;
	return (_tmp105_ = cspec, pflags = (g_free (pflags), NULL), _tmp105_);
}


static void vala_gtype_module_real_generate_interface_declaration (ValaCCodeBaseModule* base, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space) {
	ValaGTypeModule * self;
	char* _tmp0_;
	gboolean _tmp1_;
	char* _tmp9_;
	char* _tmp8_;
	ValaCCodeStruct* _tmp10_;
	ValaCCodeStruct* type_struct;
	ValaCCodeNewline* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* macro;
	ValaCCodeMacroReplacement* _tmp15_;
	char* _tmp14_;
	char* _tmp18_;
	char* _tmp17_;
	char* _tmp16_;
	ValaCCodeMacroReplacement* _tmp21_;
	char* _tmp20_;
	char* _tmp19_;
	char* _tmp23_;
	char* _tmp22_;
	ValaCCodeMacroReplacement* _tmp26_;
	char* _tmp25_;
	char* _tmp24_;
	char* _tmp29_;
	char* _tmp28_;
	char* _tmp27_;
	ValaCCodeMacroReplacement* _tmp32_;
	char* _tmp31_;
	char* _tmp30_;
	ValaCCodeNewline* _tmp33_;
	ValaCCodeTypeDefinition* _tmp38_;
	ValaCCodeVariableDeclarator* _tmp37_;
	char* _tmp36_;
	char* _tmp35_;
	char* _tmp34_;
	ValaCCodeTypeDefinition* _tmp42_;
	ValaCCodeVariableDeclarator* _tmp41_;
	char* _tmp40_;
	char* _tmp39_;
	ValaInterfaceRegisterFunction* type_fun;
	ValaCCodeFragment* _tmp71_;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (iface != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) iface, _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		return;
	}
	{
		GeeList* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _prerequisite_it;
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		_prerequisite_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = vala_interface_get_prerequisites (iface))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (gee_collection_object_unref (_tmp2_), NULL)), _tmp3_);
		while (gee_iterator_next (_prerequisite_it)) {
			ValaDataType* prerequisite;
			ValaClass* _tmp5_;
			ValaTypeSymbol* _tmp4_;
			ValaClass* prereq_cl;
			ValaInterface* _tmp7_;
			ValaTypeSymbol* _tmp6_;
			ValaInterface* prereq_iface;
			prerequisite = (ValaDataType*) gee_iterator_get (_prerequisite_it);
			_tmp5_ = NULL;
			_tmp4_ = NULL;
			prereq_cl = (_tmp5_ = (_tmp4_ = vala_data_type_get_data_type (prerequisite), VALA_IS_CLASS (_tmp4_) ? ((ValaClass*) _tmp4_) : NULL), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			prereq_iface = (_tmp7_ = (_tmp6_ = vala_data_type_get_data_type (prerequisite), VALA_IS_INTERFACE (_tmp6_) ? ((ValaInterface*) _tmp6_) : NULL), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
			if (prereq_cl != NULL) {
				vala_ccode_base_module_generate_class_declaration ((ValaCCodeBaseModule*) self, prereq_cl, decl_space);
			} else {
				if (prereq_iface != NULL) {
					vala_ccode_base_module_generate_interface_declaration ((ValaCCodeBaseModule*) self, prereq_iface, decl_space);
				}
			}
			(prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL));
			(prereq_cl == NULL) ? NULL : (prereq_cl = (vala_code_node_unref (prereq_cl), NULL));
			(prereq_iface == NULL) ? NULL : (prereq_iface = (vala_code_node_unref (prereq_iface), NULL));
		}
		(_prerequisite_it == NULL) ? NULL : (_prerequisite_it = (gee_collection_object_unref (_prerequisite_it), NULL));
	}
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp10_ = NULL;
	type_struct = (_tmp10_ = vala_ccode_struct_new (_tmp9_ = g_strdup_printf ("_%s", _tmp8_ = vala_interface_get_type_cname (iface))), _tmp9_ = (g_free (_tmp9_), NULL), _tmp8_ = (g_free (_tmp8_), NULL), _tmp10_);
	_tmp11_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp11_ = vala_ccode_newline_new ()));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp12_ = NULL;
	_tmp13_ = NULL;
	macro = (_tmp13_ = g_strdup_printf ("(%s_get_type ())", _tmp12_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), _tmp12_ = (g_free (_tmp12_), NULL), _tmp13_);
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp15_ = vala_ccode_macro_replacement_new (_tmp14_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface), macro)));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp14_ = (g_free (_tmp14_), NULL);
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	macro = (_tmp18_ = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", _tmp16_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface), _tmp17_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)), macro = (g_free (macro), NULL), _tmp18_);
	_tmp17_ = (g_free (_tmp17_), NULL);
	_tmp16_ = (g_free (_tmp16_), NULL);
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp21_ = vala_ccode_macro_replacement_new (_tmp20_ = g_strdup_printf ("%s(obj)", _tmp19_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL)), macro)));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	_tmp20_ = (g_free (_tmp20_), NULL);
	_tmp19_ = (g_free (_tmp19_), NULL);
	_tmp23_ = NULL;
	_tmp22_ = NULL;
	macro = (_tmp23_ = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", _tmp22_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface)), macro = (g_free (macro), NULL), _tmp23_);
	_tmp22_ = (g_free (_tmp22_), NULL);
	_tmp26_ = NULL;
	_tmp25_ = NULL;
	_tmp24_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp26_ = vala_ccode_macro_replacement_new (_tmp25_ = g_strdup_printf ("%s(obj)", _tmp24_ = vala_ccode_base_module_get_type_check_function ((ValaCCodeBaseModule*) self, (ValaTypeSymbol*) iface)), macro)));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	_tmp25_ = (g_free (_tmp25_), NULL);
	_tmp24_ = (g_free (_tmp24_), NULL);
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	macro = (_tmp29_ = g_strdup_printf ("(G_TYPE_INSTANCE_GET_INTERFACE ((obj), %s, %s))", _tmp27_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface), _tmp28_ = vala_interface_get_type_cname (iface)), macro = (g_free (macro), NULL), _tmp29_);
	_tmp28_ = (g_free (_tmp28_), NULL);
	_tmp27_ = (g_free (_tmp27_), NULL);
	_tmp32_ = NULL;
	_tmp31_ = NULL;
	_tmp30_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp32_ = vala_ccode_macro_replacement_new (_tmp31_ = g_strdup_printf ("%s_GET_INTERFACE(obj)", _tmp30_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL)), macro)));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	_tmp31_ = (g_free (_tmp31_), NULL);
	_tmp30_ = (g_free (_tmp30_), NULL);
	_tmp33_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp33_ = vala_ccode_newline_new ()));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	_tmp38_ = NULL;
	_tmp37_ = NULL;
	_tmp36_ = NULL;
	_tmp35_ = NULL;
	_tmp34_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp38_ = vala_ccode_type_definition_new (_tmp35_ = g_strdup_printf ("struct _%s", _tmp34_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)), (ValaCCodeDeclarator*) (_tmp37_ = vala_ccode_variable_declarator_new (_tmp36_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), NULL, NULL)))));
	(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
	(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
	_tmp36_ = (g_free (_tmp36_), NULL);
	_tmp35_ = (g_free (_tmp35_), NULL);
	_tmp34_ = (g_free (_tmp34_), NULL);
	_tmp42_ = NULL;
	_tmp41_ = NULL;
	_tmp40_ = NULL;
	_tmp39_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp42_ = vala_ccode_type_definition_new (_tmp39_ = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (type_struct)), (ValaCCodeDeclarator*) (_tmp41_ = vala_ccode_variable_declarator_new (_tmp40_ = vala_interface_get_type_cname (iface), NULL, NULL)))));
	(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	_tmp40_ = (g_free (_tmp40_), NULL);
	_tmp39_ = (g_free (_tmp39_), NULL);
	vala_ccode_struct_add_field (type_struct, "GTypeInterface", "parent_iface");
	{
		GeeList* _tmp43_;
		GeeIterator* _tmp44_;
		GeeIterator* _m_it;
		_tmp43_ = NULL;
		_tmp44_ = NULL;
		_m_it = (_tmp44_ = gee_iterable_iterator ((GeeIterable*) (_tmp43_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), (_tmp43_ == NULL) ? NULL : (_tmp43_ = (gee_collection_object_unref (_tmp43_), NULL)), _tmp44_);
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			gboolean _tmp45_;
			gboolean _tmp46_;
			ValaCCodeFunctionDeclarator* vdeclarator;
			GeeHashMap* cparam_map;
			ValaCCodeFunction* _tmp47_;
			char* _tmp48_;
			ValaCCodeDeclaration* _tmp49_;
			ValaCCodeDeclaration* vdecl;
			m = (ValaMethod*) gee_iterator_get (_m_it);
			_tmp45_ = FALSE;
			_tmp46_ = FALSE;
			if (!vala_method_get_is_abstract (m)) {
				_tmp46_ = !vala_method_get_is_virtual (m);
			} else {
				_tmp46_ = FALSE;
			}
			if (_tmp46_) {
				_tmp45_ = TRUE;
			} else {
				_tmp45_ = vala_method_get_coroutine (m);
			}
			if (_tmp45_) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			/* add vfunc field to the type struct*/
			vdeclarator = vala_ccode_function_declarator_new (vala_method_get_vfunc_name (m));
			cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
			_tmp47_ = NULL;
			vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, decl_space, (GeeMap*) cparam_map, _tmp47_ = vala_ccode_function_new ("fake", "void"), vdeclarator, NULL, NULL, 3);
			(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
			_tmp48_ = NULL;
			_tmp49_ = NULL;
			vdecl = (_tmp49_ = vala_ccode_declaration_new (_tmp48_ = vala_data_type_get_cname (vala_method_get_return_type (m))), _tmp48_ = (g_free (_tmp48_), NULL), _tmp49_);
			vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
			vala_ccode_struct_add_declaration (type_struct, vdecl);
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
			(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
			(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	{
		GeeList* _tmp50_;
		GeeIterator* _tmp51_;
		GeeIterator* _prop_it;
		_tmp50_ = NULL;
		_tmp51_ = NULL;
		_prop_it = (_tmp51_ = gee_iterable_iterator ((GeeIterable*) (_tmp50_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface))), (_tmp50_ == NULL) ? NULL : (_tmp50_ = (gee_collection_object_unref (_tmp50_), NULL)), _tmp51_);
		while (gee_iterator_next (_prop_it)) {
			ValaProperty* prop;
			gboolean _tmp52_;
			ValaObjectTypeSymbol* _tmp53_;
			ValaObjectTypeSymbol* t;
			gboolean returns_real_struct;
			ValaObjectType* this_type;
			char* _tmp54_;
			ValaCCodeFormalParameter* _tmp55_;
			ValaCCodeFormalParameter* cselfparam;
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			_tmp52_ = FALSE;
			if (!vala_property_get_is_abstract (prop)) {
				_tmp52_ = !vala_property_get_is_virtual (prop);
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			vala_ccode_base_module_generate_type_declaration ((ValaCCodeBaseModule*) self, vala_property_get_property_type (prop), decl_space);
			_tmp53_ = NULL;
			t = (_tmp53_ = VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp53_ == NULL) ? NULL : vala_code_node_ref (_tmp53_));
			returns_real_struct = vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
			this_type = vala_object_type_new (t);
			_tmp54_ = NULL;
			_tmp55_ = NULL;
			cselfparam = (_tmp55_ = vala_ccode_formal_parameter_new ("self", _tmp54_ = vala_data_type_get_cname ((ValaDataType*) this_type)), _tmp54_ = (g_free (_tmp54_), NULL), _tmp55_);
			if (vala_property_get_get_accessor (prop) != NULL) {
				char* _tmp56_;
				ValaCCodeFunctionDeclarator* _tmp57_;
				ValaCCodeFunctionDeclarator* vdeclarator;
				char* creturn_type;
				ValaCCodeDeclaration* vdecl;
				_tmp56_ = NULL;
				_tmp57_ = NULL;
				vdeclarator = (_tmp57_ = vala_ccode_function_declarator_new (_tmp56_ = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))), _tmp56_ = (g_free (_tmp56_), NULL), _tmp57_);
				vala_ccode_function_declarator_add_parameter (vdeclarator, cselfparam);
				creturn_type = NULL;
				if (returns_real_struct) {
					char* _tmp59_;
					char* _tmp58_;
					ValaCCodeFormalParameter* _tmp60_;
					ValaCCodeFormalParameter* cvalueparam;
					char* _tmp61_;
					_tmp59_ = NULL;
					_tmp58_ = NULL;
					_tmp60_ = NULL;
					cvalueparam = (_tmp60_ = vala_ccode_formal_parameter_new ("value", _tmp59_ = g_strconcat (_tmp58_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop))), "*", NULL)), _tmp59_ = (g_free (_tmp59_), NULL), _tmp58_ = (g_free (_tmp58_), NULL), _tmp60_);
					vala_ccode_function_declarator_add_parameter (vdeclarator, cvalueparam);
					_tmp61_ = NULL;
					creturn_type = (_tmp61_ = g_strdup ("void"), creturn_type = (g_free (creturn_type), NULL), _tmp61_);
					(cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL));
				} else {
					char* _tmp62_;
					_tmp62_ = NULL;
					creturn_type = (_tmp62_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (vala_property_get_get_accessor (prop))), creturn_type = (g_free (creturn_type), NULL), _tmp62_);
				}
				vdecl = vala_ccode_declaration_new (creturn_type);
				vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
				vala_ccode_struct_add_declaration (type_struct, vdecl);
				(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
				creturn_type = (g_free (creturn_type), NULL);
				(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
			}
			if (vala_property_get_set_accessor (prop) != NULL) {
				char* _tmp63_;
				ValaCCodeFunctionDeclarator* _tmp64_;
				ValaCCodeFunctionDeclarator* vdeclarator;
				ValaCCodeDeclaration* vdecl;
				_tmp63_ = NULL;
				_tmp64_ = NULL;
				vdeclarator = (_tmp64_ = vala_ccode_function_declarator_new (_tmp63_ = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))), _tmp63_ = (g_free (_tmp63_), NULL), _tmp64_);
				vala_ccode_function_declarator_add_parameter (vdeclarator, cselfparam);
				if (returns_real_struct) {
					char* _tmp66_;
					char* _tmp65_;
					ValaCCodeFormalParameter* _tmp67_;
					ValaCCodeFormalParameter* cvalueparam;
					_tmp66_ = NULL;
					_tmp65_ = NULL;
					_tmp67_ = NULL;
					cvalueparam = (_tmp67_ = vala_ccode_formal_parameter_new ("value", _tmp66_ = g_strconcat (_tmp65_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (vala_property_get_set_accessor (prop))), "*", NULL)), _tmp66_ = (g_free (_tmp66_), NULL), _tmp65_ = (g_free (_tmp65_), NULL), _tmp67_);
					vala_ccode_function_declarator_add_parameter (vdeclarator, cvalueparam);
					(cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL));
				} else {
					char* _tmp68_;
					ValaCCodeFormalParameter* _tmp69_;
					ValaCCodeFormalParameter* cvalueparam;
					_tmp68_ = NULL;
					_tmp69_ = NULL;
					cvalueparam = (_tmp69_ = vala_ccode_formal_parameter_new ("value", _tmp68_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (vala_property_get_set_accessor (prop)))), _tmp68_ = (g_free (_tmp68_), NULL), _tmp69_);
					vala_ccode_function_declarator_add_parameter (vdeclarator, cvalueparam);
					(cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL));
				}
				vdecl = vala_ccode_declaration_new ("void");
				vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
				vala_ccode_struct_add_declaration (type_struct, vdecl);
				(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
				(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
			(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
			(cselfparam == NULL) ? NULL : (cselfparam = (vala_ccode_node_unref (cselfparam), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) iface)) != NULL) {
		ValaCCodeComment* _tmp70_;
		_tmp70_ = NULL;
		vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp70_ = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) iface)))));
		(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
	}
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) type_struct);
	type_fun = vala_interface_register_function_new (iface, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
	vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, FALSE);
	_tmp71_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) (_tmp71_ = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
	(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
	(type_struct == NULL) ? NULL : (type_struct = (vala_ccode_node_unref (type_struct), NULL));
	macro = (g_free (macro), NULL);
	(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
}


static void vala_gtype_module_real_visit_interface (ValaCCodeModule* base, ValaInterface* iface) {
	ValaGTypeModule * self;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp0_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp2_;
	char* _tmp4_;
	gboolean _tmp5_;
	ValaInterfaceRegisterFunction* type_fun;
	ValaCCodeFragment* _tmp8_;
	ValaTypeSymbol* _tmp9_;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (iface != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp1_ = (_tmp0_ = (ValaSymbol*) iface, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp1_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp3_ = (_tmp2_ = (ValaTypeSymbol*) iface, (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp3_);
	_tmp4_ = NULL;
	if ((_tmp5_ = g_utf8_strlen (_tmp4_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE), -1) < 3, _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_)) {
		char* _tmp7_;
		char* _tmp6_;
		vala_code_node_set_error ((ValaCodeNode*) iface, TRUE);
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) iface), _tmp7_ = g_strdup_printf ("Interface name `%s' is too short", _tmp6_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE)));
		_tmp7_ = (g_free (_tmp7_), NULL);
		_tmp6_ = (g_free (_tmp6_), NULL);
		return;
	}
	vala_ccode_base_module_generate_interface_declaration ((ValaCCodeBaseModule*) self, iface, ((ValaCCodeBaseModule*) self)->source_declarations);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_gtype_module_add_interface_base_init_function (self, iface);
	type_fun = vala_interface_register_function_new (iface, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
	vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, FALSE);
	_tmp8_ = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp8_ = vala_typeregister_function_get_definition ((ValaTypeRegisterFunction*) type_fun)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp9_ = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp9_ = NULL, (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp9_);
	(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
}


static void vala_gtype_module_add_interface_base_init_function (ValaGTypeModule* self, ValaInterface* iface) {
	char* _tmp1_;
	char* _tmp0_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeFunction* base_init;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeBlock* init_block;
	ValaCCodeBlock* _tmp6_;
	char* _tmp7_;
	ValaCCodeDeclaration* _tmp8_;
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* _tmp10_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeUnaryExpression* _tmp12_;
	ValaCCodeIdentifier* _tmp11_;
	ValaCCodeIfStatement* _tmp13_;
	ValaCCodeIfStatement* cif;
	ValaCCodeExpressionStatement* _tmp17_;
	ValaCCodeAssignment* _tmp16_;
	ValaCCodeConstant* _tmp15_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeFragment* _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	base_init = (_tmp2_ = vala_ccode_function_new (_tmp1_ = g_strdup_printf ("%s_base_init", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), "void"), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_function_add_parameter (base_init, _tmp5_ = vala_ccode_formal_parameter_new ("iface", _tmp4_ = g_strdup_printf ("%sIface *", _tmp3_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) iface, FALSE))));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp3_ = (g_free (_tmp3_), NULL);
	vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	/* make sure not to run the initialization code twice */
	_tmp6_ = NULL;
	vala_ccode_function_set_block (base_init, _tmp6_ = vala_ccode_block_new ());
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp7_ = NULL;
	_tmp8_ = NULL;
	decl = (_tmp8_ = vala_ccode_declaration_new (_tmp7_ = vala_data_type_get_cname (((ValaCCodeBaseModule*) self)->bool_type)), _tmp7_ = (g_free (_tmp7_), NULL), _tmp8_);
	vala_ccode_declaration_set_modifiers (decl, vala_ccode_declaration_get_modifiers (decl) | VALA_CCODE_MODIFIERS_STATIC);
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	vala_ccode_declaration_add_declarator (decl, (ValaCCodeDeclarator*) (_tmp10_ = vala_ccode_variable_declarator_new ("initialized", (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("FALSE")), NULL)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), (ValaCCodeNode*) decl);
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	_tmp13_ = NULL;
	cif = (_tmp13_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp12_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new ("initialized")))), (ValaCCodeStatement*) init_block, NULL), (_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL)), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL)), _tmp13_);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), (ValaCCodeNode*) cif);
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp17_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("initialized")), (ValaCCodeExpression*) (_tmp15_ = vala_ccode_constant_new ("TRUE")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) iface, ((ValaCCodeBaseModule*) self)->gobject_type)) {
		GeeList* props;
		/* create properties */
		props = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface);
		{
			GeeIterator* _prop_it;
			_prop_it = gee_iterable_iterator ((GeeIterable*) props);
			while (gee_iterator_next (_prop_it)) {
				ValaProperty* prop;
				prop = (ValaProperty*) gee_iterator_get (_prop_it);
				if (vala_property_get_is_abstract (prop)) {
					ValaCCodeIdentifier* _tmp18_;
					ValaCCodeFunctionCall* _tmp19_;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeIdentifier* _tmp20_;
					ValaCCodeFunctionCall* _tmp21_;
					ValaCCodeExpressionStatement* _tmp22_;
					_tmp18_ = NULL;
					_tmp19_ = NULL;
					cinst = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("g_object_interface_install_property"))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp19_);
					_tmp20_ = NULL;
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("iface")));
					(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
					_tmp21_ = NULL;
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_module_get_param_spec (vala_ccode_module_get_head ((ValaCCodeModule*) self), prop)));
					(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
					_tmp22_ = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp22_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
					(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
					(cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL));
				}
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			}
			(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
		}
		(props == NULL) ? NULL : (props = (gee_collection_object_unref (props), NULL));
	}
	/* create signals */
	{
		GeeList* _tmp23_;
		GeeIterator* _tmp24_;
		GeeIterator* _sig_it;
		/* create signals */
		_tmp23_ = NULL;
		_tmp24_ = NULL;
		_sig_it = (_tmp24_ = gee_iterable_iterator ((GeeIterable*) (_tmp23_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) iface))), (_tmp23_ == NULL) ? NULL : (_tmp23_ = (gee_collection_object_unref (_tmp23_), NULL)), _tmp24_);
		/* create signals */
		while (gee_iterator_next (_sig_it)) {
			ValaSignal* sig;
			ValaCCodeExpressionStatement* _tmp26_;
			ValaCCodeFunctionCall* _tmp25_;
			/* create signals */
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			_tmp26_ = NULL;
			_tmp25_ = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp26_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_module_get_signal_creation (vala_ccode_module_get_head ((ValaCCodeModule*) self), sig, (ValaTypeSymbol*) iface)))));
			(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
			(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		}
		(_sig_it == NULL) ? NULL : (_sig_it = (gee_collection_object_unref (_sig_it), NULL));
	}
	/* connect default implementations*/
	{
		GeeList* _tmp27_;
		GeeIterator* _tmp28_;
		GeeIterator* _m_it;
		/* connect default implementations*/
		_tmp27_ = NULL;
		_tmp28_ = NULL;
		_m_it = (_tmp28_ = gee_iterable_iterator ((GeeIterable*) (_tmp27_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), (_tmp27_ == NULL) ? NULL : (_tmp27_ = (gee_collection_object_unref (_tmp27_), NULL)), _tmp28_);
		/* connect default implementations*/
		while (gee_iterator_next (_m_it)) {
			ValaMethod* m;
			/* connect default implementations*/
			m = (ValaMethod*) gee_iterator_get (_m_it);
			if (vala_method_get_is_virtual (m)) {
				ValaCCodeIdentifier* ciface;
				char* cname;
				ValaCCodeExpressionStatement* _tmp32_;
				ValaCCodeAssignment* _tmp31_;
				ValaCCodeIdentifier* _tmp30_;
				ValaCCodeMemberAccess* _tmp29_;
				ciface = vala_ccode_identifier_new ("iface");
				cname = vala_method_get_real_cname (m);
				_tmp32_ = NULL;
				_tmp31_ = NULL;
				_tmp30_ = NULL;
				_tmp29_ = NULL;
				vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), (ValaCCodeNode*) (_tmp32_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, vala_method_get_vfunc_name (m))), (ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
				(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
				(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
				(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
				(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
				cname = (g_free (cname), NULL);
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	_tmp33_ = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp33_ = vala_ccode_module_register_dbus_info (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaObjectTypeSymbol*) iface)));
	(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) base_init);
	(base_init == NULL) ? NULL : (base_init = (vala_ccode_node_unref (base_init), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(decl == NULL) ? NULL : (decl = (vala_ccode_node_unref (decl), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
}


static void vala_gtype_module_real_visit_struct (ValaCCodeModule* base, ValaStruct* st) {
	ValaGTypeModule * self;
	self = (ValaGTypeModule*) base;
	g_return_if_fail (st != NULL);
	VALA_CCODE_MODULE_CLASS (vala_gtype_module_parent_class)->visit_struct ((ValaCCodeModule*) VALA_GERROR_MODULE (self), st);
	if (vala_struct_get_has_type_id (st)) {
		ValaStructRegisterFunction* type_fun;
		ValaCCodeFragment* _tmp0_;
		type_fun = vala_struct_register_function_new (st, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
		vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, FALSE);
		_tmp0_ = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp0_ = vala_typeregister_function_get_definition ((ValaTypeRegisterFunction*) type_fun)));
		(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
		(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
	}
}


static void vala_gtype_module_class_init (ValaGTypeModuleClass * klass) {
	vala_gtype_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_METHOD_MODULE_CLASS (klass)->generate_parameter = vala_gtype_module_real_generate_parameter;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_class_declaration = vala_gtype_module_real_generate_class_declaration;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_class_struct_declaration = vala_gtype_module_real_generate_class_struct_declaration;
	VALA_GTYPE_MODULE_CLASS (klass)->generate_virtual_method_declaration = vala_gtype_module_real_generate_virtual_method_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_class = vala_gtype_module_real_visit_class;
	VALA_GTYPE_MODULE_CLASS (klass)->generate_class_init = vala_gtype_module_real_generate_class_init;
	VALA_CCODE_MODULE_CLASS (klass)->get_param_spec = vala_gtype_module_real_get_param_spec;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_interface_declaration = vala_gtype_module_real_generate_interface_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_interface = vala_gtype_module_real_visit_interface;
	VALA_CCODE_MODULE_CLASS (klass)->visit_struct = vala_gtype_module_real_visit_struct;
}


static void vala_gtype_module_instance_init (ValaGTypeModule * self) {
}


GType vala_gtype_module_get_type (void) {
	static GType vala_gtype_module_type_id = 0;
	if (vala_gtype_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGTypeModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gtype_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGTypeModule), 0, (GInstanceInitFunc) vala_gtype_module_instance_init, NULL };
		vala_gtype_module_type_id = g_type_register_static (VALA_TYPE_GERROR_MODULE, "ValaGTypeModule", &g_define_type_info, 0);
	}
	return vala_gtype_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




