/* valaccodebasemodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;
typedef struct _ValaCCodeDeclarationSpacePrivate ValaCCodeDeclarationSpacePrivate;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	gboolean (*variable_accessible_in_finally) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
};

struct _ValaCCodeBaseModulePrivate {
	ValaCodeContext* _context;
	GeeSet* reserved_identifiers;
	GeeSet* generated_external_symbols;
};

struct _ValaCCodeDeclarationSpace {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeDeclarationSpacePrivate * priv;
	ValaCCodeFragment* include_directives;
	ValaCCodeFragment* type_declaration;
	ValaCCodeFragment* type_definition;
	ValaCCodeFragment* type_member_declaration;
	ValaCCodeFragment* constant_declaration;
};

struct _ValaCCodeDeclarationSpaceClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeDeclarationSpace *self);
};


static gpointer vala_ccode_base_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
#define VALA_CCODE_BASE_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModulePrivate))
enum  {
	VALA_CCODE_BASE_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeModule* vala_ccode_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeModule* vala_ccode_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeBaseModule* vala_ccode_base_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeBaseModule* vala_ccode_base_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
void vala_ccode_base_module_set_context (ValaCCodeBaseModule* self, ValaCodeContext* value);
ValaCCodeDeclarationSpace* vala_ccode_declaration_space_new (void);
ValaCCodeDeclarationSpace* vala_ccode_declaration_space_construct (GType object_type);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
static char* vala_ccode_base_module_get_define_for_filename (const char* filename);
static void vala_ccode_base_module_real_emit (ValaCCodeModule* base, ValaCodeContext* context);
static ValaCCodeIdentifier* vala_ccode_base_module_real_get_value_setter_function (ValaCCodeModule* base, ValaDataType* type_reference);
void vala_ccode_base_module_append_vala_array_free (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_real_append_vala_array_free (ValaCCodeBaseModule* self);
void vala_ccode_base_module_append_vala_array_move (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_real_append_vala_array_move (ValaCCodeBaseModule* self);
void vala_ccode_base_module_append_vala_array_length (ValaCCodeBaseModule* self);
static void vala_ccode_base_module_real_append_vala_array_length (ValaCCodeBaseModule* self);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_ccode_base_module_append_vala_strcmp0 (ValaCCodeBaseModule* self);
ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
void vala_ccode_declaration_space_add_type_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_ccode_base_module_real_visit_source_file (ValaCCodeModule* base, ValaSourceFile* source_file);
gboolean vala_ccode_declaration_space_add_symbol_declaration (ValaCCodeDeclarationSpace* self, ValaSymbol* sym, const char* name);
void vala_ccode_base_module_generate_enum_declaration (ValaCCodeBaseModule* self, ValaEnum* en, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_base_module_real_visit_enum (ValaCCodeModule* base, ValaEnum* en);
char* vala_ccode_base_module_get_symbol_lock_name (ValaCCodeBaseModule* self, const char* symname);
static void vala_ccode_base_module_real_visit_member (ValaCCodeModule* base, ValaMember* m);
void vala_ccode_declaration_space_add_constant_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
void vala_ccode_base_module_generate_constant_declaration (ValaCCodeBaseModule* self, ValaConstant* c, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_base_module_real_visit_constant (ValaCCodeModule* base, ValaConstant* c);
void vala_ccode_base_module_generate_type_declaration (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
void vala_ccode_base_module_generate_field_declaration (ValaCCodeBaseModule* self, ValaField* f, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_check_type (ValaCCodeBaseModule* self, ValaDataType* type);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_default_value_for_type (ValaCCodeBaseModule* self, ValaDataType* type, gboolean initializer_expression);
gboolean vala_ccode_base_module_is_constant_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr);
char* vala_ccode_module_get_array_size_cname (ValaCCodeModule* self, const char* array_cname);
static void vala_ccode_base_module_real_visit_field (ValaCCodeModule* base, ValaField* f);
gboolean vala_ccode_base_module_is_pure_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr);
static void vala_ccode_base_module_real_visit_formal_parameter (ValaCCodeModule* base, ValaFormalParameter* p);
static void vala_ccode_base_module_real_visit_property (ValaCCodeModule* base, ValaProperty* prop);
void vala_ccode_base_module_generate_class_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_interface_declaration (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_delegate_declaration (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_struct_declaration (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_error_domain_declaration (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_class_struct_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_base_module_real_generate_class_struct_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_base_module_real_generate_struct_declaration (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_base_module_real_generate_delegate_declaration (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_cparameters (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
static void vala_ccode_base_module_real_generate_cparameters (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
void vala_ccode_base_module_generate_property_accessor_declaration (ValaCCodeBaseModule* self, ValaPropertyAccessor* acc, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeStatement* vala_ccode_base_module_create_property_type_check_statement (ValaCCodeBaseModule* self, ValaProperty* prop, gboolean check_return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
gboolean vala_ccode_base_module_is_gobject_property (ValaCCodeBaseModule* self, ValaProperty* prop);
static void vala_ccode_base_module_real_visit_property_accessor (ValaCCodeModule* base, ValaPropertyAccessor* acc);
static void vala_ccode_base_module_real_visit_destructor (ValaCCodeModule* base, ValaDestructor* d);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
static void vala_ccode_base_module_real_visit_block (ValaCCodeModule* base, ValaBlock* b);
static void vala_ccode_base_module_real_visit_empty_statement (ValaCCodeModule* base, ValaEmptyStatement* stmt);
void vala_ccode_base_module_create_temp_decl (ValaCCodeBaseModule* self, ValaStatement* stmt, GeeList* temp_vars);
static void vala_ccode_base_module_real_visit_declaration_statement (ValaCCodeModule* base, ValaDeclarationStatement* stmt);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
void vala_ccode_module_add_simple_check (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
static void vala_ccode_base_module_real_visit_local_variable (ValaCCodeModule* base, ValaLocalVariable* local);
static void vala_ccode_base_module_real_visit_initializer_list (ValaCCodeModule* base, ValaInitializerList* list);
static gboolean vala_ccode_base_module_is_in_generic_type (ValaCCodeBaseModule* self, ValaDataType* type);
static ValaCCodeExpression* vala_ccode_base_module_get_type_id_expression (ValaCCodeBaseModule* self, ValaDataType* type, gboolean is_chainup);
static char* vala_ccode_base_module_generate_struct_dup_wrapper (ValaCCodeBaseModule* self, ValaValueType* value_type);
ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
static ValaCCodeExpression* vala_ccode_base_module_real_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name);
char* vala_ccode_base_module_generate_destroy_func_wrapper (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, gboolean is_chainup);
static char* vala_ccode_base_module_generate_glist_free_wrapper (ValaCCodeBaseModule* self, ValaDataType* list_type, ValaCCodeIdentifier* element_destroy_func_expression);
char* vala_ccode_base_module_append_struct_array_free (ValaCCodeBaseModule* self, ValaStruct* st);
static char* vala_ccode_base_module_real_append_struct_array_free (ValaCCodeBaseModule* self, ValaStruct* st);
static ValaCCodeExpression* vala_ccode_base_module_real_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_end_full_expression (ValaCCodeModule* base, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_expression_statement (ValaCCodeModule* base, ValaExpressionStatement* stmt);
void vala_ccode_base_module_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
static void vala_ccode_base_module_append_param_free (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFragment* cfrag);
static void vala_ccode_base_module_real_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
void vala_ccode_base_module_append_error_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, ValaTryStatement* current_try);
void vala_ccode_base_module_create_local_free (ValaCCodeBaseModule* self, ValaCodeNode* stmt, gboolean stop_at_loop);
gboolean vala_ccode_base_module_variable_accessible_in_finally (ValaCCodeBaseModule* self, ValaLocalVariable* local);
static gboolean vala_ccode_base_module_real_variable_accessible_in_finally (ValaCCodeBaseModule* self, ValaLocalVariable* local);
ValaCCodeStatement* vala_ccode_base_module_create_postcondition_statement (ValaCCodeBaseModule* self, ValaExpression* postcondition);
static void vala_ccode_base_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt);
static void vala_ccode_base_module_real_visit_lock_statement (ValaCCodeModule* base, ValaLockStatement* stmt);
static void vala_ccode_base_module_real_visit_delete_statement (ValaCCodeModule* base, ValaDeleteStatement* stmt);
ValaCCodeExpression* vala_ccode_base_module_convert_from_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
ValaCCodeExpression* vala_ccode_base_module_convert_to_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type);
static void vala_ccode_base_module_real_visit_expression (ValaCCodeModule* base, ValaExpression* expr);
static void vala_ccode_base_module_real_visit_boolean_literal (ValaCCodeModule* base, ValaBooleanLiteral* expr);
static void vala_ccode_base_module_real_visit_character_literal (ValaCCodeModule* base, ValaCharacterLiteral* expr);
static void vala_ccode_base_module_real_visit_integer_literal (ValaCCodeModule* base, ValaIntegerLiteral* expr);
static void vala_ccode_base_module_real_visit_real_literal (ValaCCodeModule* base, ValaRealLiteral* expr);
static void vala_ccode_base_module_real_visit_string_literal (ValaCCodeModule* base, ValaStringLiteral* expr);
static void vala_ccode_base_module_real_visit_null_literal (ValaCCodeModule* base, ValaNullLiteral* expr);
static char* vala_ccode_base_module_real_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static ValaCCodeExpression* vala_ccode_base_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
char* vala_ccode_base_module_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static char* vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static void vala_ccode_base_module_real_visit_base_access (ValaCCodeModule* base, ValaBaseAccess* expr);
static ValaMemberAccess* vala_ccode_base_module_find_property_access (ValaCCodeBaseModule* self, ValaExpression* expr);
ValaCCodeFunctionCall* vala_ccode_base_module_get_property_set_call (ValaCCodeBaseModule* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr, ValaExpression* rhs);
static void vala_ccode_base_module_real_visit_postfix_expression (ValaCCodeModule* base, ValaPostfixExpression* expr);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
static gboolean vala_ccode_base_module_is_ref_function_void (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
static ValaCCodeExpression* vala_ccode_base_module_real_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
static gboolean vala_ccode_base_module_is_reference_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg);
static gboolean vala_ccode_base_module_is_nullable_value_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg);
static gboolean vala_ccode_base_module_is_signed_integer_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg);
static gboolean vala_ccode_base_module_is_unsigned_integer_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg);
static void vala_ccode_base_module_check_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg);
static void vala_ccode_base_module_real_generate_class_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_base_module_real_generate_interface_declaration (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_base_module_real_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_base_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_add_generic_type_arguments (ValaCCodeBaseModule* self, ValaCCodeFunctionCall* ccall, GeeList* type_args, ValaCodeNode* expr, gboolean is_chainup);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr);
char* vala_ccode_module_get_custom_creturn_type (ValaCCodeModule* self, ValaMethod* m);
static void vala_ccode_base_module_real_visit_object_creation_expression (ValaCCodeModule* base, ValaObjectCreationExpression* expr);
static void vala_ccode_base_module_real_visit_sizeof_expression (ValaCCodeModule* base, ValaSizeofExpression* expr);
static void vala_ccode_base_module_real_visit_typeof_expression (ValaCCodeModule* base, ValaTypeofExpression* expr);
static void vala_ccode_base_module_real_visit_unary_expression (ValaCCodeModule* base, ValaUnaryExpression* expr);
static ValaCCodeExpression* vala_ccode_base_module_create_type_check (ValaCCodeBaseModule* self, ValaCCodeNode* ccodenode, ValaDataType* type);
static void vala_ccode_base_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr);
static void vala_ccode_base_module_real_visit_pointer_indirection (ValaCCodeModule* base, ValaPointerIndirection* expr);
static void vala_ccode_base_module_real_visit_addressof_expression (ValaCCodeModule* base, ValaAddressofExpression* expr);
static void vala_ccode_base_module_real_visit_reference_transfer_expression (ValaCCodeModule* base, ValaReferenceTransferExpression* expr);
static void vala_ccode_base_module_real_visit_binary_expression (ValaCCodeModule* base, ValaBinaryExpression* expr);
char* vala_ccode_base_module_get_type_check_function (ValaCCodeBaseModule* self, ValaTypeSymbol* type);
static void vala_ccode_base_module_real_visit_type_check (ValaCCodeModule* base, ValaTypeCheck* expr);
static void vala_ccode_base_module_real_visit_lambda_expression (ValaCCodeModule* base, ValaLambdaExpression* l);
ValaCCodeIdentifier* vala_ccode_module_get_value_setter_function (ValaCCodeModule* self, ValaDataType* type_reference);
ValaCCodeExpression* vala_ccode_base_module_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_base_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node);
char* vala_ccode_module_get_dynamic_property_setter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
gboolean vala_ccode_base_module_is_address_of_possible (ValaCCodeBaseModule* self, ValaExpression* e);
ValaCCodeExpression* vala_ccode_base_module_get_address_of_expression (ValaCCodeBaseModule* self, ValaExpression* e, ValaCCodeExpression* ce);
gboolean vala_ccode_base_module_add_generated_external_symbol (ValaCCodeBaseModule* self, ValaSymbol* external_symbol);
ValaCCodeStatement* vala_ccode_base_module_create_type_check_statement (ValaCCodeBaseModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name);
static void vala_ccode_base_module_real_visit_class (ValaCCodeModule* base, ValaClass* cl);
static gboolean vala_ccode_base_module_real_is_gobject_property (ValaCCodeBaseModule* self, ValaProperty* prop);
static void vala_ccode_base_module_finalize (ValaCCodeModule* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeBaseModule* vala_ccode_base_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeBaseModule* self;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeBaseModule*) vala_ccode_module_construct (object_type, codegen, next);
	_tmp0_ = NULL;
	self->predefined_marshal_set = (_tmp0_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->predefined_marshal_set == NULL) ? NULL : (self->predefined_marshal_set = (gee_collection_object_unref (self->predefined_marshal_set), NULL)), _tmp0_);
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:VOID");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:BOOLEAN");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:CHAR");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:UCHAR");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:INT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:UINT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:LONG");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:ULONG");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:ENUM");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:FLAGS");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:FLOAT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:DOUBLE");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:STRING");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:POINTER");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:OBJECT");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "STRING:OBJECT,POINTER");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "VOID:UINT,POINTER");
	gee_collection_add ((GeeCollection*) self->predefined_marshal_set, "BOOLEAN:FLAGS");
	_tmp1_ = NULL;
	self->priv->reserved_identifiers = (_tmp1_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->priv->reserved_identifiers == NULL) ? NULL : (self->priv->reserved_identifiers = (gee_collection_object_unref (self->priv->reserved_identifiers), NULL)), _tmp1_);
	/* C99 keywords*/
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "_Bool");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "_Complex");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "_Imaginary");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "auto");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "break");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "case");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "char");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "const");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "continue");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "default");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "do");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "double");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "else");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "enum");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "extern");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "float");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "for");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "goto");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "if");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "inline");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "int");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "long");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "register");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "restrict");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "return");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "short");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "signed");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "sizeof");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "static");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "struct");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "switch");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "typedef");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "union");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "unsigned");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "void");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "volatile");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "while");
	/* MSVC keywords*/
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "cdecl");
	/* reserved for Vala/GObject naming conventions*/
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "error");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "result");
	gee_collection_add ((GeeCollection*) self->priv->reserved_identifiers, "self");
	return self;
}


ValaCCodeBaseModule* vala_ccode_base_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_base_module_construct (VALA_TYPE_CCODE_BASE_MODULE, codegen, next);
}


static void vala_ccode_base_module_real_emit (ValaCCodeModule* base, ValaCodeContext* context) {
	ValaCCodeBaseModule * self;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp0_;
	ValaDataType* _tmp3_;
	ValaStruct* _tmp2_;
	ValaDataType* _tmp5_;
	ValaStruct* _tmp4_;
	ValaDataType* _tmp7_;
	ValaStruct* _tmp6_;
	ValaDataType* _tmp9_;
	ValaStruct* _tmp8_;
	ValaDataType* _tmp11_;
	ValaStruct* _tmp10_;
	ValaDataType* _tmp13_;
	ValaStruct* _tmp12_;
	ValaDataType* _tmp15_;
	ValaStruct* _tmp14_;
	ValaDataType* _tmp17_;
	ValaStruct* _tmp16_;
	ValaDataType* _tmp19_;
	ValaStruct* _tmp18_;
	ValaDataType* _tmp21_;
	ValaStruct* _tmp20_;
	ValaDataType* _tmp23_;
	ValaStruct* _tmp22_;
	ValaDataType* _tmp25_;
	ValaStruct* _tmp24_;
	ValaDataType* _tmp27_;
	ValaStruct* _tmp26_;
	ValaDataType* _tmp29_;
	ValaStruct* _tmp28_;
	ValaDataType* _tmp31_;
	ValaStruct* _tmp30_;
	ValaDataType* _tmp33_;
	ValaStruct* _tmp32_;
	ValaDataType* _tmp35_;
	ValaStruct* _tmp34_;
	ValaDataType* _tmp37_;
	ValaStruct* _tmp36_;
	ValaDataType* _tmp39_;
	ValaStruct* _tmp38_;
	ValaDataType* _tmp41_;
	ValaClass* _tmp40_;
	ValaStruct* unichar_struct;
	ValaCCodeDeclarationSpace* _tmp64_;
	ValaCCodeDeclarationSpace* _tmp65_;
	GeeList* source_files;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (context != NULL);
	vala_ccode_base_module_set_context (self, context);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->root_symbol = (_tmp1_ = (_tmp0_ = (ValaSymbol*) vala_code_context_get_root (context), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->root_symbol == NULL) ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL)), _tmp1_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	self->bool_type = (_tmp3_ = (ValaDataType*) vala_boolean_type_new (_tmp2_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "bool"))), (self->bool_type == NULL) ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL)), _tmp3_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL));
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	self->char_type = (_tmp5_ = (ValaDataType*) vala_integer_type_new (_tmp4_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "char")), NULL, NULL), (self->char_type == NULL) ? NULL : (self->char_type = (vala_code_node_unref (self->char_type), NULL)), _tmp5_);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_code_node_unref (_tmp4_), NULL));
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	self->uchar_type = (_tmp7_ = (ValaDataType*) vala_integer_type_new (_tmp6_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uchar")), NULL, NULL), (self->uchar_type == NULL) ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL)), _tmp7_);
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	self->short_type = (_tmp9_ = (ValaDataType*) vala_integer_type_new (_tmp8_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "short")), NULL, NULL), (self->short_type == NULL) ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL)), _tmp9_);
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_code_node_unref (_tmp8_), NULL));
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	self->ushort_type = (_tmp11_ = (ValaDataType*) vala_integer_type_new (_tmp10_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ushort")), NULL, NULL), (self->ushort_type == NULL) ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL)), _tmp11_);
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_code_node_unref (_tmp10_), NULL));
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	self->int_type = (_tmp13_ = (ValaDataType*) vala_integer_type_new (_tmp12_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int")), NULL, NULL), (self->int_type == NULL) ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL)), _tmp13_);
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_code_node_unref (_tmp12_), NULL));
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	self->uint_type = (_tmp15_ = (ValaDataType*) vala_integer_type_new (_tmp14_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint")), NULL, NULL), (self->uint_type == NULL) ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL)), _tmp15_);
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_code_node_unref (_tmp14_), NULL));
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	self->long_type = (_tmp17_ = (ValaDataType*) vala_integer_type_new (_tmp16_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "long")), NULL, NULL), (self->long_type == NULL) ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL)), _tmp17_);
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_code_node_unref (_tmp16_), NULL));
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	self->ulong_type = (_tmp19_ = (ValaDataType*) vala_integer_type_new (_tmp18_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ulong")), NULL, NULL), (self->ulong_type == NULL) ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL)), _tmp19_);
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_code_node_unref (_tmp18_), NULL));
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	self->int8_type = (_tmp21_ = (ValaDataType*) vala_integer_type_new (_tmp20_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int8")), NULL, NULL), (self->int8_type == NULL) ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL)), _tmp21_);
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_code_node_unref (_tmp20_), NULL));
	_tmp23_ = NULL;
	_tmp22_ = NULL;
	self->uint8_type = (_tmp23_ = (ValaDataType*) vala_integer_type_new (_tmp22_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint8")), NULL, NULL), (self->uint8_type == NULL) ? NULL : (self->uint8_type = (vala_code_node_unref (self->uint8_type), NULL)), _tmp23_);
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_code_node_unref (_tmp22_), NULL));
	_tmp25_ = NULL;
	_tmp24_ = NULL;
	self->int16_type = (_tmp25_ = (ValaDataType*) vala_integer_type_new (_tmp24_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int16")), NULL, NULL), (self->int16_type == NULL) ? NULL : (self->int16_type = (vala_code_node_unref (self->int16_type), NULL)), _tmp25_);
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_code_node_unref (_tmp24_), NULL));
	_tmp27_ = NULL;
	_tmp26_ = NULL;
	self->uint16_type = (_tmp27_ = (ValaDataType*) vala_integer_type_new (_tmp26_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint16")), NULL, NULL), (self->uint16_type == NULL) ? NULL : (self->uint16_type = (vala_code_node_unref (self->uint16_type), NULL)), _tmp27_);
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_code_node_unref (_tmp26_), NULL));
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	self->int32_type = (_tmp29_ = (ValaDataType*) vala_integer_type_new (_tmp28_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int32")), NULL, NULL), (self->int32_type == NULL) ? NULL : (self->int32_type = (vala_code_node_unref (self->int32_type), NULL)), _tmp29_);
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_code_node_unref (_tmp28_), NULL));
	_tmp31_ = NULL;
	_tmp30_ = NULL;
	self->uint32_type = (_tmp31_ = (ValaDataType*) vala_integer_type_new (_tmp30_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint32")), NULL, NULL), (self->uint32_type == NULL) ? NULL : (self->uint32_type = (vala_code_node_unref (self->uint32_type), NULL)), _tmp31_);
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_code_node_unref (_tmp30_), NULL));
	_tmp33_ = NULL;
	_tmp32_ = NULL;
	self->int64_type = (_tmp33_ = (ValaDataType*) vala_integer_type_new (_tmp32_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int64")), NULL, NULL), (self->int64_type == NULL) ? NULL : (self->int64_type = (vala_code_node_unref (self->int64_type), NULL)), _tmp33_);
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_code_node_unref (_tmp32_), NULL));
	_tmp35_ = NULL;
	_tmp34_ = NULL;
	self->uint64_type = (_tmp35_ = (ValaDataType*) vala_integer_type_new (_tmp34_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint64")), NULL, NULL), (self->uint64_type == NULL) ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL)), _tmp35_);
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_code_node_unref (_tmp34_), NULL));
	_tmp37_ = NULL;
	_tmp36_ = NULL;
	self->float_type = (_tmp37_ = (ValaDataType*) vala_floating_type_new (_tmp36_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "float"))), (self->float_type == NULL) ? NULL : (self->float_type = (vala_code_node_unref (self->float_type), NULL)), _tmp37_);
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_code_node_unref (_tmp36_), NULL));
	_tmp39_ = NULL;
	_tmp38_ = NULL;
	self->double_type = (_tmp39_ = (ValaDataType*) vala_floating_type_new (_tmp38_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "double"))), (self->double_type == NULL) ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL)), _tmp39_);
	(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_code_node_unref (_tmp38_), NULL));
	_tmp41_ = NULL;
	_tmp40_ = NULL;
	self->string_type = (_tmp41_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp40_ = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "string")))), (self->string_type == NULL) ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL)), _tmp41_);
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_code_node_unref (_tmp40_), NULL));
	unichar_struct = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "unichar"));
	if (unichar_struct != NULL) {
		ValaDataType* _tmp42_;
		_tmp42_ = NULL;
		self->unichar_type = (_tmp42_ = (ValaDataType*) vala_integer_type_new (unichar_struct, NULL, NULL), (self->unichar_type == NULL) ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL)), _tmp42_);
	}
	if (vala_code_context_get_profile (context) == VALA_PROFILE_GOBJECT) {
		ValaSymbol* glib_ns;
		ValaTypeSymbol* _tmp43_;
		ValaTypeSymbol* _tmp44_;
		ValaErrorType* _tmp45_;
		ValaClass* _tmp46_;
		ValaClass* _tmp47_;
		ValaClass* _tmp48_;
		ValaTypeSymbol* _tmp49_;
		ValaTypeSymbol* _tmp50_;
		ValaTypeSymbol* _tmp51_;
		ValaTypeSymbol* _tmp52_;
		ValaDataType* _tmp54_;
		ValaStruct* _tmp53_;
		ValaStruct* _tmp55_;
		ValaStruct* _tmp56_;
		ValaTypeSymbol* _tmp57_;
		ValaSymbol* dbus_ns;
		glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "GLib");
		_tmp43_ = NULL;
		self->gtype_type = (_tmp43_ = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Type")), (self->gtype_type == NULL) ? NULL : (self->gtype_type = (vala_code_node_unref (self->gtype_type), NULL)), _tmp43_);
		_tmp44_ = NULL;
		self->gobject_type = (_tmp44_ = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->gobject_type == NULL) ? NULL : (self->gobject_type = (vala_code_node_unref (self->gobject_type), NULL)), _tmp44_);
		_tmp45_ = NULL;
		self->gerror_type = (_tmp45_ = vala_error_type_new (NULL, NULL, NULL), (self->gerror_type == NULL) ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL)), _tmp45_);
		_tmp46_ = NULL;
		self->glist_type = (_tmp46_ = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")), (self->glist_type == NULL) ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL)), _tmp46_);
		_tmp47_ = NULL;
		self->gslist_type = (_tmp47_ = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")), (self->gslist_type == NULL) ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL)), _tmp47_);
		_tmp48_ = NULL;
		self->gvaluearray_type = (_tmp48_ = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "ValueArray")), (self->gvaluearray_type == NULL) ? NULL : (self->gvaluearray_type = (vala_code_node_unref (self->gvaluearray_type), NULL)), _tmp48_);
		_tmp49_ = NULL;
		self->gstringbuilder_type = (_tmp49_ = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "StringBuilder")), (self->gstringbuilder_type == NULL) ? NULL : (self->gstringbuilder_type = (vala_code_node_unref (self->gstringbuilder_type), NULL)), _tmp49_);
		_tmp50_ = NULL;
		self->garray_type = (_tmp50_ = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Array")), (self->garray_type == NULL) ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL)), _tmp50_);
		_tmp51_ = NULL;
		self->gbytearray_type = (_tmp51_ = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "ByteArray")), (self->gbytearray_type == NULL) ? NULL : (self->gbytearray_type = (vala_code_node_unref (self->gbytearray_type), NULL)), _tmp51_);
		_tmp52_ = NULL;
		self->gptrarray_type = (_tmp52_ = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "PtrArray")), (self->gptrarray_type == NULL) ? NULL : (self->gptrarray_type = (vala_code_node_unref (self->gptrarray_type), NULL)), _tmp52_);
		_tmp54_ = NULL;
		_tmp53_ = NULL;
		self->gquark_type = (_tmp54_ = (ValaDataType*) vala_integer_type_new (_tmp53_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Quark")), NULL, NULL), (self->gquark_type == NULL) ? NULL : (self->gquark_type = (vala_code_node_unref (self->gquark_type), NULL)), _tmp54_);
		(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_code_node_unref (_tmp53_), NULL));
		_tmp55_ = NULL;
		self->gvalue_type = (_tmp55_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Value")), (self->gvalue_type == NULL) ? NULL : (self->gvalue_type = (vala_code_node_unref (self->gvalue_type), NULL)), _tmp55_);
		_tmp56_ = NULL;
		self->mutex_type = (_tmp56_ = VALA_STRUCT (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "StaticRecMutex")), (self->mutex_type == NULL) ? NULL : (self->mutex_type = (vala_code_node_unref (self->mutex_type), NULL)), _tmp56_);
		_tmp57_ = NULL;
		self->type_module_type = (_tmp57_ = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "TypeModule")), (self->type_module_type == NULL) ? NULL : (self->type_module_type = (vala_code_node_unref (self->type_module_type), NULL)), _tmp57_);
		if (vala_code_context_get_module_init_method (context) != NULL) {
			ValaCCodeFragment* _tmp58_;
			_tmp58_ = NULL;
			self->module_init_fragment = (_tmp58_ = vala_ccode_fragment_new (), (self->module_init_fragment == NULL) ? NULL : (self->module_init_fragment = (vala_ccode_node_unref (self->module_init_fragment), NULL)), _tmp58_);
			{
				GeeList* _tmp59_;
				GeeIterator* _tmp60_;
				GeeIterator* _parameter_it;
				_tmp59_ = NULL;
				_tmp60_ = NULL;
				_parameter_it = (_tmp60_ = gee_iterable_iterator ((GeeIterable*) (_tmp59_ = vala_method_get_parameters (vala_code_context_get_module_init_method (context)))), (_tmp59_ == NULL) ? NULL : (_tmp59_ = (gee_collection_object_unref (_tmp59_), NULL)), _tmp60_);
				while (TRUE) {
					ValaFormalParameter* parameter;
					if (!gee_iterator_next (_parameter_it)) {
						break;
					}
					parameter = (ValaFormalParameter*) gee_iterator_get (_parameter_it);
					if (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (parameter)) == self->type_module_type) {
						char* _tmp62_;
						const char* _tmp61_;
						self->in_plugin = TRUE;
						_tmp62_ = NULL;
						_tmp61_ = NULL;
						self->module_init_param_name = (_tmp62_ = (_tmp61_ = vala_symbol_get_name ((ValaSymbol*) parameter), (_tmp61_ == NULL) ? NULL : g_strdup (_tmp61_)), self->module_init_param_name = (g_free (self->module_init_param_name), NULL), _tmp62_);
						(parameter == NULL) ? NULL : (parameter = (vala_code_node_unref (parameter), NULL));
						break;
					}
					(parameter == NULL) ? NULL : (parameter = (vala_code_node_unref (parameter), NULL));
				}
				(_parameter_it == NULL) ? NULL : (_parameter_it = (gee_collection_object_unref (_parameter_it), NULL));
			}
		}
		dbus_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "DBus");
		if (dbus_ns != NULL) {
			ValaTypeSymbol* _tmp63_;
			_tmp63_ = NULL;
			self->dbus_object_type = (_tmp63_ = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (dbus_ns), "Object")), (self->dbus_object_type == NULL) ? NULL : (self->dbus_object_type = (vala_code_node_unref (self->dbus_object_type), NULL)), _tmp63_);
		}
		(glib_ns == NULL) ? NULL : (glib_ns = (vala_code_node_unref (glib_ns), NULL));
		(dbus_ns == NULL) ? NULL : (dbus_ns = (vala_code_node_unref (dbus_ns), NULL));
	}
	_tmp64_ = NULL;
	self->header_declarations = (_tmp64_ = vala_ccode_declaration_space_new (), (self->header_declarations == NULL) ? NULL : (self->header_declarations = (vala_ccode_declaration_space_unref (self->header_declarations), NULL)), _tmp64_);
	_tmp65_ = NULL;
	self->internal_header_declarations = (_tmp65_ = vala_ccode_declaration_space_new (), (self->internal_header_declarations == NULL) ? NULL : (self->internal_header_declarations = (vala_ccode_declaration_space_unref (self->internal_header_declarations), NULL)), _tmp65_);
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GeeIterator* _file_it;
		_file_it = gee_iterable_iterator ((GeeIterable*) source_files);
		while (TRUE) {
			ValaSourceFile* file;
			if (!gee_iterator_next (_file_it)) {
				break;
			}
			file = (ValaSourceFile*) gee_iterator_get (_file_it);
			if (!vala_source_file_get_external_package (file)) {
				vala_source_file_accept (file, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
			}
			(file == NULL) ? NULL : (file = (vala_source_file_unref (file), NULL));
		}
		(_file_it == NULL) ? NULL : (_file_it = (gee_collection_object_unref (_file_it), NULL));
	}
	/* generate C header file for public API*/
	if (vala_code_context_get_header_filename (context) != NULL) {
		ValaCCodeWriter* writer;
		char* _tmp67_;
		ValaCCodeOnceSection* _tmp68_;
		ValaCCodeOnceSection* once;
		ValaCCodeNewline* _tmp69_;
		ValaCCodeNewline* _tmp70_;
		ValaCCodeNewline* _tmp73_;
		ValaCCodeNewline* _tmp74_;
		ValaCCodeNewline* _tmp75_;
		ValaCCodeNewline* _tmp76_;
		ValaCCodeNewline* _tmp77_;
		ValaCCodeNewline* _tmp80_;
		writer = vala_ccode_writer_new (vala_code_context_get_header_filename (context));
		if (!vala_ccode_writer_open (writer)) {
			char* _tmp66_;
			_tmp66_ = NULL;
			vala_report_error (NULL, _tmp66_ = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer)));
			_tmp66_ = (g_free (_tmp66_), NULL);
			(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
			(unichar_struct == NULL) ? NULL : (unichar_struct = (vala_code_node_unref (unichar_struct), NULL));
			(source_files == NULL) ? NULL : (source_files = (gee_collection_object_unref (source_files), NULL));
			return;
		}
		vala_ccode_writer_write_newline (writer);
		_tmp67_ = NULL;
		_tmp68_ = NULL;
		once = (_tmp68_ = vala_ccode_once_section_new (_tmp67_ = vala_ccode_base_module_get_define_for_filename (vala_ccode_writer_get_filename (writer))), _tmp67_ = (g_free (_tmp67_), NULL), _tmp68_);
		_tmp69_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp69_ = vala_ccode_newline_new ()));
		(_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_declarations->include_directives);
		_tmp70_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp70_ = vala_ccode_newline_new ()));
		(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
		if (vala_code_context_get_profile (context) == VALA_PROFILE_GOBJECT) {
			ValaCCodeIdentifier* _tmp71_;
			ValaCCodeNewline* _tmp72_;
			_tmp71_ = NULL;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp71_ = vala_ccode_identifier_new ("G_BEGIN_DECLS")));
			(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
			_tmp72_ = NULL;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp72_ = vala_ccode_newline_new ()));
			(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
		}
		_tmp73_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp73_ = vala_ccode_newline_new ()));
		(_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_ccode_node_unref (_tmp73_), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_declarations->type_declaration);
		_tmp74_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp74_ = vala_ccode_newline_new ()));
		(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_declarations->type_definition);
		_tmp75_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp75_ = vala_ccode_newline_new ()));
		(_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_declarations->type_member_declaration);
		_tmp76_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp76_ = vala_ccode_newline_new ()));
		(_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->header_declarations->constant_declaration);
		_tmp77_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp77_ = vala_ccode_newline_new ()));
		(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
		if (vala_code_context_get_profile (context) == VALA_PROFILE_GOBJECT) {
			ValaCCodeIdentifier* _tmp78_;
			ValaCCodeNewline* _tmp79_;
			_tmp78_ = NULL;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp78_ = vala_ccode_identifier_new ("G_END_DECLS")));
			(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
			_tmp79_ = NULL;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp79_ = vala_ccode_newline_new ()));
			(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
		}
		_tmp80_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp80_ = vala_ccode_newline_new ()));
		(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
		vala_ccode_node_write ((ValaCCodeNode*) once, writer);
		vala_ccode_writer_close (writer);
		(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
		(once == NULL) ? NULL : (once = (vala_ccode_node_unref (once), NULL));
	}
	/* generate C header file for internal API*/
	if (vala_code_context_get_internal_header_filename (context) != NULL) {
		ValaCCodeWriter* writer;
		char* _tmp82_;
		ValaCCodeOnceSection* _tmp83_;
		ValaCCodeOnceSection* once;
		ValaCCodeNewline* _tmp84_;
		ValaCCodeNewline* _tmp85_;
		ValaCCodeNewline* _tmp88_;
		ValaCCodeNewline* _tmp89_;
		ValaCCodeNewline* _tmp90_;
		ValaCCodeNewline* _tmp91_;
		ValaCCodeNewline* _tmp92_;
		ValaCCodeNewline* _tmp95_;
		writer = vala_ccode_writer_new (vala_code_context_get_internal_header_filename (context));
		if (!vala_ccode_writer_open (writer)) {
			char* _tmp81_;
			_tmp81_ = NULL;
			vala_report_error (NULL, _tmp81_ = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer)));
			_tmp81_ = (g_free (_tmp81_), NULL);
			(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
			(unichar_struct == NULL) ? NULL : (unichar_struct = (vala_code_node_unref (unichar_struct), NULL));
			(source_files == NULL) ? NULL : (source_files = (gee_collection_object_unref (source_files), NULL));
			return;
		}
		vala_ccode_writer_write_newline (writer);
		_tmp82_ = NULL;
		_tmp83_ = NULL;
		once = (_tmp83_ = vala_ccode_once_section_new (_tmp82_ = vala_ccode_base_module_get_define_for_filename (vala_ccode_writer_get_filename (writer))), _tmp82_ = (g_free (_tmp82_), NULL), _tmp83_);
		_tmp84_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp84_ = vala_ccode_newline_new ()));
		(_tmp84_ == NULL) ? NULL : (_tmp84_ = (vala_ccode_node_unref (_tmp84_), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->internal_header_declarations->include_directives);
		_tmp85_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp85_ = vala_ccode_newline_new ()));
		(_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL));
		if (vala_code_context_get_profile (context) == VALA_PROFILE_GOBJECT) {
			ValaCCodeIdentifier* _tmp86_;
			ValaCCodeNewline* _tmp87_;
			_tmp86_ = NULL;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp86_ = vala_ccode_identifier_new ("G_BEGIN_DECLS")));
			(_tmp86_ == NULL) ? NULL : (_tmp86_ = (vala_ccode_node_unref (_tmp86_), NULL));
			_tmp87_ = NULL;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp87_ = vala_ccode_newline_new ()));
			(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
		}
		_tmp88_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp88_ = vala_ccode_newline_new ()));
		(_tmp88_ == NULL) ? NULL : (_tmp88_ = (vala_ccode_node_unref (_tmp88_), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->internal_header_declarations->type_declaration);
		_tmp89_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp89_ = vala_ccode_newline_new ()));
		(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->internal_header_declarations->type_definition);
		_tmp90_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp90_ = vala_ccode_newline_new ()));
		(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->internal_header_declarations->type_member_declaration);
		_tmp91_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp91_ = vala_ccode_newline_new ()));
		(_tmp91_ == NULL) ? NULL : (_tmp91_ = (vala_ccode_node_unref (_tmp91_), NULL));
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->internal_header_declarations->constant_declaration);
		_tmp92_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp92_ = vala_ccode_newline_new ()));
		(_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_ccode_node_unref (_tmp92_), NULL));
		if (vala_code_context_get_profile (context) == VALA_PROFILE_GOBJECT) {
			ValaCCodeIdentifier* _tmp93_;
			ValaCCodeNewline* _tmp94_;
			_tmp93_ = NULL;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp93_ = vala_ccode_identifier_new ("G_END_DECLS")));
			(_tmp93_ == NULL) ? NULL : (_tmp93_ = (vala_ccode_node_unref (_tmp93_), NULL));
			_tmp94_ = NULL;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp94_ = vala_ccode_newline_new ()));
			(_tmp94_ == NULL) ? NULL : (_tmp94_ = (vala_ccode_node_unref (_tmp94_), NULL));
		}
		_tmp95_ = NULL;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) (_tmp95_ = vala_ccode_newline_new ()));
		(_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL));
		vala_ccode_node_write ((ValaCCodeNode*) once, writer);
		vala_ccode_writer_close (writer);
		(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
		(once == NULL) ? NULL : (once = (vala_ccode_node_unref (once), NULL));
	}
	(unichar_struct == NULL) ? NULL : (unichar_struct = (vala_code_node_unref (unichar_struct), NULL));
	(source_files == NULL) ? NULL : (source_files = (gee_collection_object_unref (source_files), NULL));
}


static ValaCCodeIdentifier* vala_ccode_base_module_real_get_value_setter_function (ValaCCodeModule* base, ValaDataType* type_reference) {
	ValaCCodeBaseModule * self;
	ValaCCodeIdentifier* result;
	self = (ValaCCodeBaseModule*) base;
	g_return_val_if_fail (type_reference != NULL, NULL);
	if (vala_data_type_get_data_type (type_reference) != NULL) {
		char* _tmp0_;
		ValaCCodeIdentifier* _tmp1_;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		result = (_tmp1_ = vala_ccode_identifier_new (_tmp0_ = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (type_reference))), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
		return result;
	} else {
		result = vala_ccode_identifier_new ("g_value_set_pointer");
		return result;
	}
}


static void vala_ccode_base_module_real_append_vala_array_free (ValaCCodeBaseModule* self) {
	g_return_if_fail (self != NULL);
}


void vala_ccode_base_module_append_vala_array_free (ValaCCodeBaseModule* self) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_vala_array_free (self);
}


static void vala_ccode_base_module_real_append_vala_array_move (ValaCCodeBaseModule* self) {
	g_return_if_fail (self != NULL);
}


void vala_ccode_base_module_append_vala_array_move (ValaCCodeBaseModule* self) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_vala_array_move (self);
}


static void vala_ccode_base_module_real_append_vala_array_length (ValaCCodeBaseModule* self) {
	g_return_if_fail (self != NULL);
}


void vala_ccode_base_module_append_vala_array_length (ValaCCodeBaseModule* self) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_vala_array_length (self);
}


static void vala_ccode_base_module_append_vala_strcmp0 (ValaCCodeBaseModule* self) {
	ValaCCodeFunction* fun;
	ValaCCodeFormalParameter* _tmp0_;
	ValaCCodeFormalParameter* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeBinaryExpression* _tmp5_;
	ValaCCodeBinaryExpression* cineq;
	ValaCCodeBlock* _tmp6_;
	ValaCCodeBlock* cblock;
	ValaCCodeBinaryExpression* _tmp9_;
	ValaCCodeConstant* _tmp8_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIfStatement* _tmp10_;
	ValaCCodeIfStatement* cif;
	ValaCCodeReturnStatement* _tmp12_;
	ValaCCodeUnaryExpression* _tmp11_;
	ValaCCodeBlock* _tmp13_;
	ValaCCodeIfStatement* _tmp17_;
	ValaCCodeBinaryExpression* _tmp16_;
	ValaCCodeConstant* _tmp15_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeReturnStatement* _tmp18_;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeFunctionCall* _tmp20_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeReturnStatement* _tmp23_;
	g_return_if_fail (self != NULL);
	fun = vala_ccode_function_new ("_vala_strcmp0", "int");
	vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
	_tmp0_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp0_ = vala_ccode_formal_parameter_new ("str1", "const char *"));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp1_ = NULL;
	vala_ccode_function_add_parameter (fun, _tmp1_ = vala_ccode_formal_parameter_new ("str2", "const char *"));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	_tmp2_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp2_ = vala_ccode_function_copy (fun)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	/* (str1 != str2)*/
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp5_ = NULL;
	cineq = (_tmp5_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("str1")), (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("str2"))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL)), _tmp5_);
	_tmp6_ = NULL;
	vala_ccode_function_set_block (fun, _tmp6_ = vala_ccode_block_new ());
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	cblock = vala_ccode_block_new ();
	/* if (str1 == NULL)*/
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp10_ = NULL;
	cif = (_tmp10_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp9_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("str1")), (ValaCCodeExpression*) (_tmp8_ = vala_ccode_constant_new ("NULL")))), (ValaCCodeStatement*) cblock, NULL), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL)), _tmp10_);
	/* return -(str1 != str2);*/
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp12_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_MINUS, (ValaCCodeExpression*) cineq)))));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	_tmp13_ = NULL;
	cblock = (_tmp13_ = vala_ccode_block_new (), (cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)), _tmp13_);
	/* if (str2 == NULL)*/
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	cif = (_tmp17_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("str2")), (ValaCCodeExpression*) (_tmp15_ = vala_ccode_constant_new ("NULL")))), (ValaCCodeStatement*) cblock, NULL), (cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL)), _tmp17_);
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	/* return (str1 != str2);*/
	_tmp18_ = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp18_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) cineq)));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) cif);
	/* strcmp (str1, str2)*/
	_tmp19_ = NULL;
	_tmp20_ = NULL;
	ccall = (_tmp20_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("strcmp"))), (_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL)), _tmp20_);
	_tmp21_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("str1")));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	_tmp22_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("str2")));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	/* return strcmp (str1, str2);*/
	_tmp23_ = NULL;
	vala_ccode_block_add_statement (vala_ccode_function_get_block (fun), (ValaCCodeNode*) (_tmp23_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) fun);
	(fun == NULL) ? NULL : (fun = (vala_ccode_node_unref (fun), NULL));
	(cineq == NULL) ? NULL : (cineq = (vala_ccode_node_unref (cineq), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_ccode_base_module_real_visit_source_file (ValaCCodeModule* base, ValaSourceFile* source_file) {
	ValaCCodeBaseModule * self;
	ValaCCodeDeclarationSpace* _tmp0_;
	ValaCCodeFragment* _tmp1_;
	ValaCCodeFragment* _tmp2_;
	ValaCCodeFragment* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	gboolean _tmp7_;
	ValaCCodeComment* comment;
	char* _tmp62_;
	ValaCCodeWriter* _tmp63_;
	ValaCCodeWriter* writer;
	ValaCCodeDeclarationSpace* _tmp65_;
	ValaCCodeFragment* _tmp66_;
	ValaCCodeFragment* _tmp67_;
	ValaCCodeFragment* _tmp68_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = NULL;
	self->source_declarations = (_tmp0_ = vala_ccode_declaration_space_new (), (self->source_declarations == NULL) ? NULL : (self->source_declarations = (vala_ccode_declaration_space_unref (self->source_declarations), NULL)), _tmp0_);
	_tmp1_ = NULL;
	self->source_type_member_definition = (_tmp1_ = vala_ccode_fragment_new (), (self->source_type_member_definition == NULL) ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL)), _tmp1_);
	_tmp2_ = NULL;
	self->source_signal_marshaller_definition = (_tmp2_ = vala_ccode_fragment_new (), (self->source_signal_marshaller_definition == NULL) ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL)), _tmp2_);
	_tmp3_ = NULL;
	self->source_signal_marshaller_declaration = (_tmp3_ = vala_ccode_fragment_new (), (self->source_signal_marshaller_declaration == NULL) ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL)), _tmp3_);
	_tmp4_ = NULL;
	self->user_marshal_set = (_tmp4_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->user_marshal_set == NULL) ? NULL : (self->user_marshal_set = (gee_collection_object_unref (self->user_marshal_set), NULL)), _tmp4_);
	self->next_temp_var_id = 0;
	gee_map_clear (self->variable_name_map);
	self->gvaluecollector_h_needed = FALSE;
	self->dbus_glib_h_needed = FALSE;
	self->dbus_glib_h_needed_in_header = FALSE;
	self->requires_array_free = FALSE;
	self->requires_array_move = FALSE;
	self->requires_array_length = FALSE;
	self->requires_strcmp0 = FALSE;
	_tmp5_ = NULL;
	self->wrappers = (_tmp5_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal), (self->wrappers == NULL) ? NULL : (self->wrappers = (gee_collection_object_unref (self->wrappers), NULL)), _tmp5_);
	_tmp6_ = NULL;
	self->priv->generated_external_symbols = (_tmp6_ = (GeeSet*) gee_hash_set_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_hash, g_direct_equal), (self->priv->generated_external_symbols == NULL) ? NULL : (self->priv->generated_external_symbols = (gee_collection_object_unref (self->priv->generated_external_symbols), NULL)), _tmp6_);
	if (vala_code_context_get_profile (self->priv->_context) == VALA_PROFILE_GOBJECT) {
		vala_ccode_declaration_space_add_include (self->header_declarations, "glib.h", FALSE);
		vala_ccode_declaration_space_add_include (self->internal_header_declarations, "glib.h", FALSE);
		vala_ccode_declaration_space_add_include (self->source_declarations, "glib.h", FALSE);
		vala_ccode_declaration_space_add_include (self->source_declarations, "glib-object.h", FALSE);
	}
	vala_source_file_accept_children (source_file, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->_context)) > 0) {
		return;
	}
	if (self->requires_array_free) {
		vala_ccode_base_module_append_vala_array_free (self);
	}
	if (self->requires_array_move) {
		vala_ccode_base_module_append_vala_array_move (self);
	}
	if (self->requires_array_length) {
		vala_ccode_base_module_append_vala_array_length (self);
	}
	if (self->requires_strcmp0) {
		vala_ccode_base_module_append_vala_strcmp0 (self);
	}
	if (self->gvaluecollector_h_needed) {
		vala_ccode_declaration_space_add_include (self->source_declarations, "gobject/gvaluecollector.h", FALSE);
	}
	if (self->dbus_glib_h_needed) {
		vala_ccode_declaration_space_add_include (self->source_declarations, "dbus/dbus.h", FALSE);
		vala_ccode_declaration_space_add_include (self->source_declarations, "dbus/dbus-glib.h", FALSE);
		vala_ccode_declaration_space_add_include (self->source_declarations, "dbus/dbus-glib-lowlevel.h", FALSE);
	}
	_tmp7_ = FALSE;
	if (self->dbus_glib_h_needed_in_header) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = self->dbus_glib_h_needed;
	}
	if (_tmp7_) {
		ValaCCodeStruct* dbusvtable;
		ValaCCodeTypeDefinition* _tmp9_;
		ValaCCodeVariableDeclarator* _tmp8_;
		ValaCCodeFunction* cfunc;
		ValaCCodeFormalParameter* _tmp10_;
		ValaCCodeFormalParameter* _tmp11_;
		ValaCCodeFormalParameter* _tmp12_;
		ValaCCodeFunction* _tmp13_;
		ValaCCodeBlock* block;
		ValaCCodeDeclaration* _cdecl_;
		ValaCCodeVariableDeclarator* _tmp14_;
		ValaCCodeIdentifier* _tmp15_;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeFunctionCall* quark;
		ValaCCodeConstant* _tmp17_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeFunctionCall* _tmp19_;
		ValaCCodeFunctionCall* get_qdata;
		ValaCCodeIdentifier* _tmp20_;
		ValaCCodeExpressionStatement* _tmp23_;
		ValaCCodeAssignment* _tmp22_;
		ValaCCodeIdentifier* _tmp21_;
		ValaCCodeMemberAccess* _tmp25_;
		ValaCCodeIdentifier* _tmp24_;
		ValaCCodeFunctionCall* _tmp26_;
		ValaCCodeFunctionCall* cregister;
		ValaCCodeIdentifier* _tmp27_;
		ValaCCodeIdentifier* _tmp28_;
		ValaCCodeIdentifier* _tmp29_;
		ValaCCodeBlock* ifblock;
		ValaCCodeExpressionStatement* _tmp30_;
		ValaCCodeBlock* elseblock;
		ValaCCodeIdentifier* _tmp31_;
		ValaCCodeFunctionCall* _tmp32_;
		ValaCCodeFunctionCall* warn;
		ValaCCodeConstant* _tmp33_;
		ValaCCodeExpressionStatement* _tmp34_;
		ValaCCodeIfStatement* _tmp36_;
		ValaCCodeIdentifier* _tmp35_;
		ValaCCodeFunction* _tmp37_;
		ValaCCodeFormalParameter* _tmp38_;
		ValaCCodeFormalParameter* _tmp39_;
		ValaCCodeFunction* _tmp40_;
		ValaCCodeBlock* _tmp41_;
		ValaCCodeDeclaration* _tmp42_;
		ValaCCodeVariableDeclarator* _tmp43_;
		ValaCCodeIdentifier* _tmp44_;
		ValaCCodeFunctionCall* _tmp45_;
		ValaCCodeFunctionCall* path;
		ValaCCodeCastExpression* _tmp47_;
		ValaCCodeIdentifier* _tmp46_;
		ValaCCodeConstant* _tmp48_;
		ValaCCodeExpressionStatement* _tmp51_;
		ValaCCodeAssignment* _tmp50_;
		ValaCCodeIdentifier* _tmp49_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeFunctionCall* _tmp53_;
		ValaCCodeFunctionCall* unregister_call;
		ValaCCodeIdentifier* _tmp54_;
		ValaCCodeIdentifier* _tmp55_;
		ValaCCodeExpressionStatement* _tmp56_;
		ValaCCodeIdentifier* _tmp57_;
		ValaCCodeFunctionCall* _tmp58_;
		ValaCCodeFunctionCall* path_free;
		ValaCCodeIdentifier* _tmp59_;
		ValaCCodeExpressionStatement* _tmp60_;
		dbusvtable = vala_ccode_struct_new ("_DBusObjectVTable");
		vala_ccode_struct_add_field (dbusvtable, "void", "(*register_object) (DBusConnection*, const char*, void*)");
		vala_ccode_declaration_space_add_type_definition (self->source_declarations, (ValaCCodeNode*) dbusvtable);
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		vala_ccode_declaration_space_add_type_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp9_ = vala_ccode_type_definition_new ("struct _DBusObjectVTable", (ValaCCodeDeclarator*) (_tmp8_ = vala_ccode_variable_declarator_new ("_DBusObjectVTable", NULL, NULL)))));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		cfunc = vala_ccode_function_new ("_vala_dbus_register_object", "void");
		_tmp10_ = NULL;
		vala_ccode_function_add_parameter (cfunc, _tmp10_ = vala_ccode_formal_parameter_new ("connection", "DBusConnection*"));
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
		_tmp11_ = NULL;
		vala_ccode_function_add_parameter (cfunc, _tmp11_ = vala_ccode_formal_parameter_new ("path", "const char*"));
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
		_tmp12_ = NULL;
		vala_ccode_function_add_parameter (cfunc, _tmp12_ = vala_ccode_formal_parameter_new ("object", "void*"));
		(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
		vala_ccode_function_set_modifiers (cfunc, vala_ccode_function_get_modifiers (cfunc) | VALA_CCODE_MODIFIERS_STATIC);
		_tmp13_ = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp13_ = vala_ccode_function_copy (cfunc)));
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
		block = vala_ccode_block_new ();
		vala_ccode_function_set_block (cfunc, block);
		_cdecl_ = vala_ccode_declaration_new ("const _DBusObjectVTable *");
		_tmp14_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp14_ = vala_ccode_variable_declarator_new ("vtable", NULL, NULL)));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
		_tmp15_ = NULL;
		_tmp16_ = NULL;
		quark = (_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("g_quark_from_static_string"))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL)), _tmp16_);
		_tmp17_ = NULL;
		vala_ccode_function_call_add_argument (quark, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_constant_new ("\"DBusObjectVTable\"")));
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
		_tmp18_ = NULL;
		_tmp19_ = NULL;
		get_qdata = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("g_type_get_qdata"))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp19_);
		_tmp20_ = NULL;
		vala_ccode_function_call_add_argument (get_qdata, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE (object)")));
		(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
		vala_ccode_function_call_add_argument (get_qdata, (ValaCCodeExpression*) quark);
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		_tmp21_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp23_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("vtable")), (ValaCCodeExpression*) get_qdata, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		_tmp25_ = NULL;
		_tmp24_ = NULL;
		_tmp26_ = NULL;
		cregister = (_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("vtable")), "register_object"))), (_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL)), (_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL)), _tmp26_);
		_tmp27_ = NULL;
		vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("connection")));
		(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
		_tmp28_ = NULL;
		vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new ("path")));
		(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
		_tmp29_ = NULL;
		vala_ccode_function_call_add_argument (cregister, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("object")));
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
		ifblock = vala_ccode_block_new ();
		_tmp30_ = NULL;
		vala_ccode_block_add_statement (ifblock, (ValaCCodeNode*) (_tmp30_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cregister)));
		(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
		elseblock = vala_ccode_block_new ();
		_tmp31_ = NULL;
		_tmp32_ = NULL;
		warn = (_tmp32_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("g_warning"))), (_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL)), _tmp32_);
		_tmp33_ = NULL;
		vala_ccode_function_call_add_argument (warn, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_constant_new ("\"Object does not implement any D-Bus interface\"")));
		(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
		_tmp34_ = NULL;
		vala_ccode_block_add_statement (elseblock, (ValaCCodeNode*) (_tmp34_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) warn)));
		(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
		_tmp36_ = NULL;
		_tmp35_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp36_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("vtable")), (ValaCCodeStatement*) ifblock, (ValaCCodeStatement*) elseblock)));
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
		(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
		vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) cfunc);
		/* unregister function*/
		_tmp37_ = NULL;
		cfunc = (_tmp37_ = vala_ccode_function_new ("_vala_dbus_unregister_object", "void"), (cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL)), _tmp37_);
		_tmp38_ = NULL;
		vala_ccode_function_add_parameter (cfunc, _tmp38_ = vala_ccode_formal_parameter_new ("connection", "gpointer"));
		(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		_tmp39_ = NULL;
		vala_ccode_function_add_parameter (cfunc, _tmp39_ = vala_ccode_formal_parameter_new ("object", "GObject*"));
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
		vala_ccode_function_set_modifiers (cfunc, vala_ccode_function_get_modifiers (cfunc) | VALA_CCODE_MODIFIERS_STATIC);
		_tmp40_ = NULL;
		vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp40_ = vala_ccode_function_copy (cfunc)));
		(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		_tmp41_ = NULL;
		block = (_tmp41_ = vala_ccode_block_new (), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp41_);
		vala_ccode_function_set_block (cfunc, block);
		_tmp42_ = NULL;
		_cdecl_ = (_tmp42_ = vala_ccode_declaration_new ("char*"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp42_);
		_tmp43_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp43_ = vala_ccode_variable_declarator_new ("path", NULL, NULL)));
		(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
		_tmp44_ = NULL;
		_tmp45_ = NULL;
		path = (_tmp45_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new ("g_object_steal_data"))), (_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL)), _tmp45_);
		_tmp47_ = NULL;
		_tmp46_ = NULL;
		vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new ("object")), "GObject*")));
		(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
		(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
		_tmp48_ = NULL;
		vala_ccode_function_call_add_argument (path, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_constant_new ("\"dbus_object_path\"")));
		(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
		_tmp51_ = NULL;
		_tmp50_ = NULL;
		_tmp49_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp51_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp50_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp49_ = vala_ccode_identifier_new ("path")), (ValaCCodeExpression*) path, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
		(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
		(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
		_tmp52_ = NULL;
		_tmp53_ = NULL;
		unregister_call = (_tmp53_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp52_ = vala_ccode_identifier_new ("dbus_connection_unregister_object_path"))), (_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL)), _tmp53_);
		_tmp54_ = NULL;
		vala_ccode_function_call_add_argument (unregister_call, (ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new ("connection")));
		(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
		_tmp55_ = NULL;
		vala_ccode_function_call_add_argument (unregister_call, (ValaCCodeExpression*) (_tmp55_ = vala_ccode_identifier_new ("path")));
		(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
		_tmp56_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp56_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) unregister_call)));
		(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
		_tmp57_ = NULL;
		_tmp58_ = NULL;
		path_free = (_tmp58_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp57_ = vala_ccode_identifier_new ("g_free"))), (_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL)), _tmp58_);
		_tmp59_ = NULL;
		vala_ccode_function_call_add_argument (path_free, (ValaCCodeExpression*) (_tmp59_ = vala_ccode_identifier_new ("path")));
		(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
		_tmp60_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp60_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) path_free)));
		(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
		vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) cfunc);
		(dbusvtable == NULL) ? NULL : (dbusvtable = (vala_ccode_node_unref (dbusvtable), NULL));
		(cfunc == NULL) ? NULL : (cfunc = (vala_ccode_node_unref (cfunc), NULL));
		(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
		(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
		(quark == NULL) ? NULL : (quark = (vala_ccode_node_unref (quark), NULL));
		(get_qdata == NULL) ? NULL : (get_qdata = (vala_ccode_node_unref (get_qdata), NULL));
		(cregister == NULL) ? NULL : (cregister = (vala_ccode_node_unref (cregister), NULL));
		(ifblock == NULL) ? NULL : (ifblock = (vala_ccode_node_unref (ifblock), NULL));
		(elseblock == NULL) ? NULL : (elseblock = (vala_ccode_node_unref (elseblock), NULL));
		(warn == NULL) ? NULL : (warn = (vala_ccode_node_unref (warn), NULL));
		(path == NULL) ? NULL : (path = (vala_ccode_node_unref (path), NULL));
		(unregister_call == NULL) ? NULL : (unregister_call = (vala_ccode_node_unref (unregister_call), NULL));
		(path_free == NULL) ? NULL : (path_free = (vala_ccode_node_unref (path_free), NULL));
	}
	comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* _tmp61_;
		_tmp61_ = NULL;
		comment = (_tmp61_ = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL)), _tmp61_);
	}
	_tmp62_ = NULL;
	_tmp63_ = NULL;
	writer = (_tmp63_ = vala_ccode_writer_new (_tmp62_ = vala_source_file_get_csource_filename (source_file)), _tmp62_ = (g_free (_tmp62_), NULL), _tmp63_);
	if (!vala_ccode_writer_open (writer)) {
		char* _tmp64_;
		_tmp64_ = NULL;
		vala_report_error (NULL, _tmp64_ = g_strdup_printf ("unable to open `%s' for writing", vala_ccode_writer_get_filename (writer)));
		_tmp64_ = (g_free (_tmp64_), NULL);
		(comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL));
		(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
		return;
	}
	vala_ccode_writer_set_line_directives (writer, vala_code_context_get_debug (self->priv->_context));
	if (comment != NULL) {
		vala_ccode_node_write ((ValaCCodeNode*) comment, writer);
	}
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_declarations->include_directives, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined ((ValaCCodeNode*) self->source_declarations->type_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined ((ValaCCodeNode*) self->source_declarations->type_definition, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration ((ValaCCodeNode*) self->source_declarations->type_member_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_declarations->type_member_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_combined ((ValaCCodeNode*) self->source_declarations->constant_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration ((ValaCCodeNode*) self->source_signal_marshaller_declaration, writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_signal_marshaller_declaration, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_type_member_definition, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write ((ValaCCodeNode*) self->source_signal_marshaller_definition, writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	_tmp65_ = NULL;
	self->source_declarations = (_tmp65_ = NULL, (self->source_declarations == NULL) ? NULL : (self->source_declarations = (vala_ccode_declaration_space_unref (self->source_declarations), NULL)), _tmp65_);
	_tmp66_ = NULL;
	self->source_type_member_definition = (_tmp66_ = NULL, (self->source_type_member_definition == NULL) ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL)), _tmp66_);
	_tmp67_ = NULL;
	self->source_signal_marshaller_definition = (_tmp67_ = NULL, (self->source_signal_marshaller_definition == NULL) ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL)), _tmp67_);
	_tmp68_ = NULL;
	self->source_signal_marshaller_declaration = (_tmp68_ = NULL, (self->source_signal_marshaller_declaration == NULL) ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL)), _tmp68_);
	(comment == NULL) ? NULL : (comment = (vala_ccode_node_unref (comment), NULL));
	(writer == NULL) ? NULL : (writer = (vala_ccode_writer_unref (writer), NULL));
}


static char* vala_ccode_base_module_get_define_for_filename (const char* filename) {
	char* result;
	GString* define;
	const char* _tmp0_;
	char* i;
	const char* _tmp4_;
	g_return_val_if_fail (filename != NULL, NULL);
	define = g_string_new ("__");
	_tmp0_ = NULL;
	i = (_tmp0_ = filename, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	while (TRUE) {
		gunichar c;
		gboolean _tmp1_;
		char* _tmp3_;
		const char* _tmp2_;
		if (!(g_utf8_strlen (i, -1) > 0)) {
			break;
		}
		c = g_utf8_get_char (i);
		_tmp1_ = FALSE;
		if (g_unichar_isalnum (c)) {
			_tmp1_ = c < 0x80;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		i = (_tmp3_ = (_tmp2_ = g_utf8_next_char (i), (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_)), i = (g_free (i), NULL), _tmp3_);
	}
	g_string_append (define, "__");
	_tmp4_ = NULL;
	result = (_tmp4_ = define->str, (_tmp4_ == NULL) ? NULL : g_strdup (_tmp4_));
	(define == NULL) ? NULL : (define = (g_string_free (define, TRUE), NULL));
	i = (g_free (i), NULL);
	return result;
	(define == NULL) ? NULL : (define = (g_string_free (define, TRUE), NULL));
	i = (g_free (i), NULL);
}


void vala_ccode_base_module_generate_enum_declaration (ValaCCodeBaseModule* self, ValaEnum* en, ValaCCodeDeclarationSpace* decl_space) {
	char* _tmp0_;
	gboolean _tmp1_;
	char* _tmp2_;
	ValaCCodeEnum* _tmp3_;
	ValaCCodeEnum* cenum;
	ValaCCodeNewline* _tmp11_;
	ValaCCodeNewline* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	char* macro;
	ValaCCodeMacroReplacement* _tmp16_;
	char* _tmp15_;
	char* _tmp17_;
	char* _tmp18_;
	char* fun_name;
	ValaCCodeFunction* regfun;
	g_return_if_fail (self != NULL);
	g_return_if_fail (en != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) en, _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) en, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		return;
	}
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	cenum = (_tmp3_ = vala_ccode_enum_new (_tmp2_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) en, FALSE)), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
	{
		GeeList* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _ev_it;
		_tmp4_ = NULL;
		_tmp5_ = NULL;
		_ev_it = (_tmp5_ = gee_iterable_iterator ((GeeIterable*) (_tmp4_ = vala_enum_get_values (en))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (gee_collection_object_unref (_tmp4_), NULL)), _tmp5_);
		while (TRUE) {
			ValaEnumValue* ev;
			if (!gee_iterator_next (_ev_it)) {
				break;
			}
			ev = (ValaEnumValue*) gee_iterator_get (_ev_it);
			if (vala_enum_value_get_value (ev) == NULL) {
				ValaCCodeEnumValue* _tmp7_;
				char* _tmp6_;
				_tmp7_ = NULL;
				_tmp6_ = NULL;
				vala_ccode_enum_add_value (cenum, _tmp7_ = vala_ccode_enum_value_new (_tmp6_ = vala_enum_value_get_cname (ev), NULL));
				(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
				_tmp6_ = (g_free (_tmp6_), NULL);
			} else {
				ValaCCodeEnumValue* _tmp9_;
				char* _tmp8_;
				vala_code_node_accept ((ValaCodeNode*) vala_enum_value_get_value (ev), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
				_tmp9_ = NULL;
				_tmp8_ = NULL;
				vala_ccode_enum_add_value (cenum, _tmp9_ = vala_ccode_enum_value_new (_tmp8_ = vala_enum_value_get_cname (ev), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_enum_value_get_value (ev)))));
				(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
				_tmp8_ = (g_free (_tmp8_), NULL);
			}
			(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
		}
		(_ev_it == NULL) ? NULL : (_ev_it = (gee_collection_object_unref (_ev_it), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) en)) != NULL) {
		ValaCCodeComment* _tmp10_;
		_tmp10_ = NULL;
		vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp10_ = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) en)))));
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	}
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) cenum);
	_tmp11_ = NULL;
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp11_ = vala_ccode_newline_new ()));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	if (!vala_enum_get_has_type_id (en)) {
		(cenum == NULL) ? NULL : (cenum = (vala_ccode_node_unref (cenum), NULL));
		return;
	}
	_tmp12_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp12_ = vala_ccode_newline_new ()));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	_tmp13_ = NULL;
	_tmp14_ = NULL;
	macro = (_tmp14_ = g_strdup_printf ("(%s_get_type ())", _tmp13_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) en, NULL)), _tmp13_ = (g_free (_tmp13_), NULL), _tmp14_);
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp16_ = vala_ccode_macro_replacement_new (_tmp15_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) en), macro)));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp15_ = (g_free (_tmp15_), NULL);
	_tmp17_ = NULL;
	_tmp18_ = NULL;
	fun_name = (_tmp18_ = g_strdup_printf ("%s_get_type", _tmp17_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) en, NULL)), _tmp17_ = (g_free (_tmp17_), NULL), _tmp18_);
	regfun = vala_ccode_function_new (fun_name, "GType");
	if (vala_symbol_get_access ((ValaSymbol*) en) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (regfun, VALA_CCODE_MODIFIERS_STATIC);
	}
	vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) regfun);
	(cenum == NULL) ? NULL : (cenum = (vala_ccode_node_unref (cenum), NULL));
	macro = (g_free (macro), NULL);
	fun_name = (g_free (fun_name), NULL);
	(regfun == NULL) ? NULL : (regfun = (vala_ccode_node_unref (regfun), NULL));
}


static void vala_ccode_base_module_real_visit_enum (ValaCCodeModule* base, ValaEnum* en) {
	ValaCCodeBaseModule * self;
	ValaCCodeInitializerList* clist;
	ValaCCodeInitializerList* clist_ev;
	ValaCCodeInitializerList* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeConstant* _tmp12_;
	ValaCCodeVariableDeclarator* enum_decl;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeBlock* type_init;
	char* _tmp15_;
	char* _tmp16_;
	char* fun_name;
	ValaCCodeFunction* regfun;
	ValaCCodeBlock* regblock;
	ValaCCodeDeclaration* _tmp17_;
	char* _tmp18_;
	char* _tmp19_;
	char* type_id_name;
	ValaCCodeVariableDeclarator* _tmp21_;
	ValaCCodeConstant* _tmp20_;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeConstant* _tmp28_;
	char* _tmp27_;
	char* _tmp26_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeExpressionStatement* _tmp32_;
	ValaCCodeAssignment* _tmp31_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunctionCall* _tmp34_;
	ValaCCodeFunctionCall* cond;
	ValaCCodeBinaryExpression* _tmp37_;
	ValaCCodeConstant* _tmp36_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIfStatement* cif;
	ValaCCodeReturnStatement* _tmp39_;
	ValaCCodeConstant* _tmp38_;
	ValaCCodeNewline* _tmp40_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (en != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_base_module_generate_enum_declaration (self, en, self->source_declarations);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) en)) {
		vala_ccode_base_module_generate_enum_declaration (self, en, self->header_declarations);
	}
	vala_ccode_base_module_generate_enum_declaration (self, en, self->internal_header_declarations);
	if (!vala_enum_get_has_type_id (en)) {
		return;
	}
	clist = vala_ccode_initializer_list_new ();
	/* or during visit time? */
	clist_ev = NULL;
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _ev_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_ev_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_enum_get_values (en))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaEnumValue* ev;
			ValaCCodeInitializerList* _tmp2_;
			ValaCCodeConstant* _tmp4_;
			char* _tmp3_;
			ValaCCodeIdentifier* _tmp7_;
			char* _tmp6_;
			char* _tmp5_;
			ValaCCodeConstant* _tmp8_;
			if (!gee_iterator_next (_ev_it)) {
				break;
			}
			ev = (ValaEnumValue*) gee_iterator_get (_ev_it);
			_tmp2_ = NULL;
			clist_ev = (_tmp2_ = vala_ccode_initializer_list_new (), (clist_ev == NULL) ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL)), _tmp2_);
			_tmp4_ = NULL;
			_tmp3_ = NULL;
			vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new (_tmp3_ = vala_enum_value_get_cname (ev))));
			(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
			_tmp3_ = (g_free (_tmp3_), NULL);
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (_tmp6_ = g_strdup_printf ("\"%s\"", _tmp5_ = vala_enum_value_get_cname (ev)))));
			(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
			_tmp6_ = (g_free (_tmp6_), NULL);
			_tmp5_ = (g_free (_tmp5_), NULL);
			_tmp8_ = NULL;
			vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp8_ = vala_enum_value_get_canonical_cconstant (ev)));
			(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
			vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) clist_ev);
			(ev == NULL) ? NULL : (ev = (vala_code_node_unref (ev), NULL));
		}
		(_ev_it == NULL) ? NULL : (_ev_it = (gee_collection_object_unref (_ev_it), NULL));
	}
	_tmp9_ = NULL;
	clist_ev = (_tmp9_ = vala_ccode_initializer_list_new (), (clist_ev == NULL) ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL)), _tmp9_);
	_tmp10_ = NULL;
	vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_constant_new ("0")));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp11_ = NULL;
	vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new ("NULL")));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp12_ = NULL;
	vala_ccode_initializer_list_append (clist_ev, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_constant_new ("NULL")));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) clist_ev);
	enum_decl = vala_ccode_variable_declarator_new ("values[]", (ValaCCodeExpression*) clist, NULL);
	_cdecl_ = NULL;
	if (vala_enum_get_is_flags (en)) {
		ValaCCodeDeclaration* _tmp13_;
		_tmp13_ = NULL;
		_cdecl_ = (_tmp13_ = vala_ccode_declaration_new ("const GFlagsValue"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp13_);
	} else {
		ValaCCodeDeclaration* _tmp14_;
		_tmp14_ = NULL;
		_cdecl_ = (_tmp14_ = vala_ccode_declaration_new ("const GEnumValue"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp14_);
	}
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) enum_decl);
	vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	type_init = vala_ccode_block_new ();
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) _cdecl_);
	_tmp15_ = NULL;
	_tmp16_ = NULL;
	fun_name = (_tmp16_ = g_strdup_printf ("%s_get_type", _tmp15_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) en, NULL)), _tmp15_ = (g_free (_tmp15_), NULL), _tmp16_);
	regfun = vala_ccode_function_new (fun_name, "GType");
	regblock = vala_ccode_block_new ();
	_tmp17_ = NULL;
	_cdecl_ = (_tmp17_ = vala_ccode_declaration_new ("GType"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp17_);
	_tmp18_ = NULL;
	_tmp19_ = NULL;
	type_id_name = (_tmp19_ = g_strdup_printf ("%s_type_id", _tmp18_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) en, NULL)), _tmp18_ = (g_free (_tmp18_), NULL), _tmp19_);
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp21_ = vala_ccode_variable_declarator_new (type_id_name, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_constant_new ("0")), NULL)));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_block_add_statement (regblock, (ValaCCodeNode*) _cdecl_);
	reg_call = NULL;
	if (vala_enum_get_is_flags (en)) {
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeIdentifier* _tmp22_;
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		reg_call = (_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("g_flags_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp23_);
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	} else {
		ValaCCodeFunctionCall* _tmp25_;
		ValaCCodeIdentifier* _tmp24_;
		_tmp25_ = NULL;
		_tmp24_ = NULL;
		reg_call = (_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new ("g_enum_register_static"))), (reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)), _tmp25_);
		(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	}
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	_tmp26_ = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_constant_new (_tmp27_ = g_strdup_printf ("\"%s\"", _tmp26_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) en, FALSE)))));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp27_ = (g_free (_tmp27_), NULL);
	_tmp26_ = (g_free (_tmp26_), NULL);
	_tmp29_ = NULL;
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("values")));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	_tmp32_ = NULL;
	_tmp31_ = NULL;
	_tmp30_ = NULL;
	vala_ccode_block_add_statement (type_init, (ValaCCodeNode*) (_tmp32_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new (type_id_name)), (ValaCCodeExpression*) reg_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	_tmp33_ = NULL;
	_tmp34_ = NULL;
	cond = (_tmp34_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("G_UNLIKELY"))), (_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL)), _tmp34_);
	_tmp37_ = NULL;
	_tmp36_ = NULL;
	_tmp35_ = NULL;
	vala_ccode_function_call_add_argument (cond, (ValaCCodeExpression*) (_tmp37_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new (type_id_name)), (ValaCCodeExpression*) (_tmp36_ = vala_ccode_constant_new ("0")))));
	(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
	(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
	cif = vala_ccode_if_statement_new ((ValaCCodeExpression*) cond, (ValaCCodeStatement*) type_init, NULL);
	vala_ccode_block_add_statement (regblock, (ValaCCodeNode*) cif);
	_tmp39_ = NULL;
	_tmp38_ = NULL;
	vala_ccode_block_add_statement (regblock, (ValaCCodeNode*) (_tmp39_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp38_ = vala_ccode_constant_new (type_id_name)))));
	(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
	(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
	if (vala_symbol_get_access ((ValaSymbol*) en) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_ccode_function_set_modifiers (regfun, VALA_CCODE_MODIFIERS_STATIC);
	}
	vala_ccode_function_set_block (regfun, regblock);
	_tmp40_ = NULL;
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) (_tmp40_ = vala_ccode_newline_new ()));
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) regfun);
	(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
	(clist_ev == NULL) ? NULL : (clist_ev = (vala_ccode_node_unref (clist_ev), NULL));
	(enum_decl == NULL) ? NULL : (enum_decl = (vala_ccode_node_unref (enum_decl), NULL));
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	(type_init == NULL) ? NULL : (type_init = (vala_ccode_node_unref (type_init), NULL));
	fun_name = (g_free (fun_name), NULL);
	(regfun == NULL) ? NULL : (regfun = (vala_ccode_node_unref (regfun), NULL));
	(regblock == NULL) ? NULL : (regblock = (vala_ccode_node_unref (regblock), NULL));
	type_id_name = (g_free (type_id_name), NULL);
	(reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL));
	(cond == NULL) ? NULL : (cond = (vala_ccode_node_unref (cond), NULL));
	(cif == NULL) ? NULL : (cif = (vala_ccode_node_unref (cif), NULL));
}


static void vala_ccode_base_module_real_visit_member (ValaCCodeModule* base, ValaMember* m) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = FALSE;
	if (VALA_IS_LOCKABLE (m)) {
		_tmp0_ = vala_lockable_get_lock_used (VALA_LOCKABLE (m));
	} else {
		_tmp0_ = FALSE;
	}
	/* stuff meant for all lockable members */
	if (_tmp0_) {
		ValaCCodeExpression* l;
		ValaCCodeFragment* _tmp1_;
		ValaCCodeFragment* init_fragment;
		ValaCCodeFragment* _tmp2_;
		ValaCCodeFragment* finalize_fragment;
		ValaCCodeIdentifier* _tmp22_;
		char* _tmp21_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeFunctionCall* initf;
		ValaCCodeUnaryExpression* _tmp24_;
		ValaCCodeExpressionStatement* _tmp25_;
		l = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
		_tmp1_ = NULL;
		init_fragment = (_tmp1_ = self->class_init_fragment, (_tmp1_ == NULL) ? NULL : vala_ccode_node_ref (_tmp1_));
		_tmp2_ = NULL;
		finalize_fragment = (_tmp2_ = self->class_finalize_fragment, (_tmp2_ == NULL) ? NULL : vala_ccode_node_ref (_tmp2_));
		if (vala_symbol_is_instance_member ((ValaSymbol*) m)) {
			ValaCCodeExpression* _tmp5_;
			char* _tmp4_;
			ValaCCodeMemberAccess* _tmp3_;
			ValaCCodeFragment* _tmp7_;
			ValaCCodeFragment* _tmp6_;
			ValaCCodeFragment* _tmp9_;
			ValaCCodeFragment* _tmp8_;
			_tmp5_ = NULL;
			_tmp4_ = NULL;
			_tmp3_ = NULL;
			l = (_tmp5_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_member_access_new_pointer (l, "priv")), _tmp4_ = vala_ccode_base_module_get_symbol_lock_name (self, vala_symbol_get_name ((ValaSymbol*) m))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp5_);
			_tmp4_ = (g_free (_tmp4_), NULL);
			(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			init_fragment = (_tmp7_ = (_tmp6_ = self->instance_init_fragment, (_tmp6_ == NULL) ? NULL : vala_ccode_node_ref (_tmp6_)), (init_fragment == NULL) ? NULL : (init_fragment = (vala_ccode_node_unref (init_fragment), NULL)), _tmp7_);
			_tmp9_ = NULL;
			_tmp8_ = NULL;
			finalize_fragment = (_tmp9_ = (_tmp8_ = self->instance_finalize_fragment, (_tmp8_ == NULL) ? NULL : vala_ccode_node_ref (_tmp8_)), (finalize_fragment == NULL) ? NULL : (finalize_fragment = (vala_ccode_node_unref (finalize_fragment), NULL)), _tmp9_);
		} else {
			if (vala_symbol_is_class_member ((ValaSymbol*) m)) {
				ValaTypeSymbol* _tmp10_;
				ValaTypeSymbol* parent;
				ValaCCodeExpression* _tmp14_;
				char* _tmp13_;
				char* _tmp12_;
				char* _tmp11_;
				ValaCCodeExpression* _tmp16_;
				char* _tmp15_;
				_tmp10_ = NULL;
				parent = (_tmp10_ = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_));
				_tmp14_ = NULL;
				_tmp13_ = NULL;
				_tmp12_ = NULL;
				_tmp11_ = NULL;
				l = (_tmp14_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp13_ = g_strdup_printf ("%s_GET_CLASS_PRIVATE(%s)", _tmp11_ = vala_typesymbol_get_upper_case_cname (parent, NULL), _tmp12_ = vala_typesymbol_get_type_id (parent))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp14_);
				_tmp13_ = (g_free (_tmp13_), NULL);
				_tmp12_ = (g_free (_tmp12_), NULL);
				_tmp11_ = (g_free (_tmp11_), NULL);
				_tmp16_ = NULL;
				_tmp15_ = NULL;
				l = (_tmp16_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (l, _tmp15_ = vala_ccode_base_module_get_symbol_lock_name (self, vala_symbol_get_name ((ValaSymbol*) m))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp16_);
				_tmp15_ = (g_free (_tmp15_), NULL);
				(parent == NULL) ? NULL : (parent = (vala_code_node_unref (parent), NULL));
			} else {
				ValaCCodeExpression* _tmp20_;
				char* _tmp19_;
				char* _tmp18_;
				char* _tmp17_;
				_tmp20_ = NULL;
				_tmp19_ = NULL;
				_tmp18_ = NULL;
				_tmp17_ = NULL;
				l = (_tmp20_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp19_ = vala_ccode_base_module_get_symbol_lock_name (self, _tmp18_ = g_strdup_printf ("%s_%s", _tmp17_ = vala_symbol_get_lower_case_cname (vala_symbol_get_parent_symbol ((ValaSymbol*) m), NULL), vala_symbol_get_name ((ValaSymbol*) m)))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp20_);
				_tmp19_ = (g_free (_tmp19_), NULL);
				_tmp18_ = (g_free (_tmp18_), NULL);
				_tmp17_ = (g_free (_tmp17_), NULL);
			}
		}
		_tmp22_ = NULL;
		_tmp21_ = NULL;
		_tmp23_ = NULL;
		initf = (_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new (_tmp21_ = vala_method_get_cname (vala_struct_get_default_construction_method (self->mutex_type))))), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL)), _tmp21_ = (g_free (_tmp21_), NULL), _tmp23_);
		_tmp24_ = NULL;
		vala_ccode_function_call_add_argument (initf, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
		(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
		_tmp25_ = NULL;
		vala_ccode_fragment_append (init_fragment, (ValaCCodeNode*) (_tmp25_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) initf)));
		(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
		if (finalize_fragment != NULL) {
			ValaCCodeIdentifier* _tmp26_;
			ValaCCodeFunctionCall* _tmp27_;
			ValaCCodeFunctionCall* fc;
			ValaCCodeUnaryExpression* _tmp28_;
			ValaCCodeExpressionStatement* _tmp29_;
			_tmp26_ = NULL;
			_tmp27_ = NULL;
			fc = (_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new ("g_static_rec_mutex_free"))), (_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL)), _tmp27_);
			_tmp28_ = NULL;
			vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
			(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
			_tmp29_ = NULL;
			vala_ccode_fragment_append (finalize_fragment, (ValaCCodeNode*) (_tmp29_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
			(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
			(fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL));
		}
		(l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL));
		(init_fragment == NULL) ? NULL : (init_fragment = (vala_ccode_node_unref (init_fragment), NULL));
		(finalize_fragment == NULL) ? NULL : (finalize_fragment = (vala_ccode_node_unref (finalize_fragment), NULL));
		(initf == NULL) ? NULL : (initf = (vala_ccode_node_unref (initf), NULL));
	}
}


void vala_ccode_base_module_generate_constant_declaration (ValaCCodeBaseModule* self, ValaConstant* c, ValaCCodeDeclarationSpace* decl_space) {
	char* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) c, _tmp0_ = vala_constant_get_cname (c)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) c, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (!vala_symbol_get_external ((ValaSymbol*) c)) {
		if (VALA_IS_INITIALIZER_LIST (vala_constant_get_initializer (c))) {
			char* _tmp2_;
			ValaCCodeDeclaration* _tmp3_;
			ValaCCodeDeclaration* _cdecl_;
			char* arr;
			ValaCCodeVariableDeclarator* _tmp7_;
			char* _tmp6_;
			char* _tmp5_;
			_tmp2_ = NULL;
			_tmp3_ = NULL;
			_cdecl_ = (_tmp3_ = vala_ccode_declaration_new (_tmp2_ = vala_data_type_get_const_cname (vala_constant_get_type_reference (c))), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
			arr = g_strdup ("");
			if (VALA_IS_ARRAY_TYPE (vala_constant_get_type_reference (c))) {
				char* _tmp4_;
				_tmp4_ = NULL;
				arr = (_tmp4_ = g_strdup ("[]"), arr = (g_free (arr), NULL), _tmp4_);
			}
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp7_ = vala_ccode_variable_declarator_new (_tmp6_ = g_strdup_printf ("%s%s", _tmp5_ = vala_constant_get_cname (c), arr), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constant_get_initializer (c))), NULL)));
			(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
			_tmp6_ = (g_free (_tmp6_), NULL);
			_tmp5_ = (g_free (_tmp5_), NULL);
			vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
			vala_ccode_declaration_space_add_constant_declaration (decl_space, (ValaCCodeNode*) _cdecl_);
			(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
			arr = (g_free (arr), NULL);
		} else {
			char* _tmp8_;
			ValaCCodeMacroReplacement* _tmp9_;
			ValaCCodeMacroReplacement* cdefine;
			_tmp8_ = NULL;
			_tmp9_ = NULL;
			cdefine = (_tmp9_ = vala_ccode_macro_replacement_new_with_expression (_tmp8_ = vala_constant_get_cname (c), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constant_get_initializer (c)))), _tmp8_ = (g_free (_tmp8_), NULL), _tmp9_);
			vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) cdefine);
			(cdefine == NULL) ? NULL : (cdefine = (vala_ccode_node_unref (cdefine), NULL));
		}
	}
}


static void vala_ccode_base_module_real_visit_constant (ValaCCodeModule* base, ValaConstant* c) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (c != NULL);
	vala_ccode_base_module_generate_constant_declaration (self, c, self->source_declarations);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) c)) {
		vala_ccode_base_module_generate_constant_declaration (self, c, self->header_declarations);
	}
	vala_ccode_base_module_generate_constant_declaration (self, c, self->internal_header_declarations);
}


void vala_ccode_base_module_generate_field_declaration (ValaCCodeBaseModule* self, ValaField* f, ValaCCodeDeclarationSpace* decl_space) {
	char* _tmp0_;
	gboolean _tmp1_;
	char* field_ctype;
	ValaCCodeDeclaration* _cdecl_;
	ValaCCodeVariableDeclarator* _tmp4_;
	char* _tmp3_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) f, _tmp0_ = vala_field_get_cname (f)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		return;
	}
	vala_ccode_base_module_generate_type_declaration (self, vala_field_get_field_type (f), decl_space);
	field_ctype = vala_data_type_get_cname (vala_field_get_field_type (f));
	if (vala_field_get_is_volatile (f)) {
		char* _tmp2_;
		_tmp2_ = NULL;
		field_ctype = (_tmp2_ = g_strconcat ("volatile ", field_ctype, NULL), field_ctype = (g_free (field_ctype), NULL), _tmp2_);
	}
	_cdecl_ = vala_ccode_declaration_new (field_ctype);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp4_ = vala_ccode_variable_declarator_new (_tmp3_ = vala_field_get_cname (f), NULL, NULL)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp3_ = (g_free (_tmp3_), NULL);
	if (vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
		vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	} else {
		vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
	}
	vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) _cdecl_);
	if (vala_lockable_get_lock_used ((ValaLockable*) f)) {
		char* _tmp5_;
		ValaCCodeDeclaration* _tmp6_;
		ValaCCodeDeclaration* flock;
		ValaCCodeConstant* _tmp9_;
		char* _tmp8_;
		char* _tmp7_;
		ValaCCodeVariableDeclarator* _tmp10_;
		ValaCCodeVariableDeclarator* flock_decl;
		/* Declare mutex for static member*/
		_tmp5_ = NULL;
		_tmp6_ = NULL;
		flock = (_tmp6_ = vala_ccode_declaration_new (_tmp5_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) self->mutex_type, FALSE)), _tmp5_ = (g_free (_tmp5_), NULL), _tmp6_);
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		_tmp10_ = NULL;
		flock_decl = (_tmp10_ = vala_ccode_variable_declarator_new (_tmp8_ = vala_ccode_base_module_get_symbol_lock_name (self, _tmp7_ = vala_field_get_cname (f)), (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("{0}")), NULL), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), _tmp8_ = (g_free (_tmp8_), NULL), _tmp7_ = (g_free (_tmp7_), NULL), _tmp10_);
		vala_ccode_declaration_add_declarator (flock, (ValaCCodeDeclarator*) flock_decl);
		if (vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
			vala_ccode_declaration_set_modifiers (flock, VALA_CCODE_MODIFIERS_STATIC);
		} else {
			vala_ccode_declaration_set_modifiers (flock, VALA_CCODE_MODIFIERS_EXTERN);
		}
		vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) flock);
		(flock == NULL) ? NULL : (flock = (vala_ccode_node_unref (flock), NULL));
		(flock_decl == NULL) ? NULL : (flock_decl = (vala_ccode_node_unref (flock_decl), NULL));
	}
	_tmp11_ = FALSE;
	if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
		_tmp11_ = !vala_field_get_no_array_length (f);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaArrayType* _tmp12_;
		ValaArrayType* array_type;
		_tmp12_ = NULL;
		array_type = (_tmp12_ = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp12_ == NULL) ? NULL : vala_code_node_ref (_tmp12_));
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp13_;
				_tmp13_ = TRUE;
				while (TRUE) {
					ValaDataType* len_type;
					ValaCCodeDeclaration* _tmp15_;
					char* _tmp14_;
					ValaCCodeVariableDeclarator* _tmp18_;
					char* _tmp17_;
					char* _tmp16_;
					if (!_tmp13_) {
						dim++;
					}
					_tmp13_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					len_type = vala_data_type_copy (self->int_type);
					_tmp15_ = NULL;
					_tmp14_ = NULL;
					_cdecl_ = (_tmp15_ = vala_ccode_declaration_new (_tmp14_ = vala_data_type_get_cname (len_type)), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp15_);
					_tmp14_ = (g_free (_tmp14_), NULL);
					_tmp18_ = NULL;
					_tmp17_ = NULL;
					_tmp16_ = NULL;
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp18_ = vala_ccode_variable_declarator_new (_tmp17_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp16_ = vala_field_get_cname (f), dim), NULL, NULL)));
					(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
					_tmp17_ = (g_free (_tmp17_), NULL);
					_tmp16_ = (g_free (_tmp16_), NULL);
					if (vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
						vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
					} else {
						vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
					}
					vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) _cdecl_);
					(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
			ValaDelegateType* _tmp19_;
			ValaDelegateType* delegate_type;
			_tmp19_ = NULL;
			delegate_type = (_tmp19_ = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp19_ == NULL) ? NULL : vala_code_node_ref (_tmp19_));
			if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
				ValaCCodeDeclaration* _tmp20_;
				ValaCCodeVariableDeclarator* _tmp23_;
				char* _tmp22_;
				char* _tmp21_;
				/* create field to store delegate target*/
				_tmp20_ = NULL;
				_cdecl_ = (_tmp20_ = vala_ccode_declaration_new ("gpointer"), (_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL)), _tmp20_);
				_tmp23_ = NULL;
				_tmp22_ = NULL;
				_tmp21_ = NULL;
				vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp23_ = vala_ccode_variable_declarator_new (_tmp22_ = vala_ccode_base_module_get_delegate_target_cname (self, _tmp21_ = vala_field_get_cname (f)), NULL, NULL)));
				(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
				_tmp22_ = (g_free (_tmp22_), NULL);
				_tmp21_ = (g_free (_tmp21_), NULL);
				if (vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
					vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
				} else {
					vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_EXTERN);
				}
				vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) _cdecl_);
			}
			(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
		}
	}
	field_ctype = (g_free (field_ctype), NULL);
	(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
}


static void vala_ccode_base_module_real_visit_field (ValaCCodeModule* base, ValaField* f) {
	ValaCCodeBaseModule * self;
	ValaClass* _tmp1_;
	ValaSymbol* _tmp0_;
	ValaClass* cl;
	gboolean _tmp2_;
	gboolean is_gtypeinstance;
	ValaCCodeExpression* lhs;
	char* field_ctype;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (f != NULL);
	vala_ccode_base_module_check_type (self, vala_field_get_field_type (f));
	vala_code_node_accept_children ((ValaCodeNode*) f, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	cl = (_tmp1_ = (_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) f), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (cl != NULL) {
		_tmp2_ = !vala_class_get_is_compact (cl);
	} else {
		_tmp2_ = FALSE;
	}
	is_gtypeinstance = _tmp2_;
	lhs = NULL;
	field_ctype = vala_data_type_get_cname (vala_field_get_field_type (f));
	if (vala_field_get_is_volatile (f)) {
		char* _tmp3_;
		_tmp3_ = NULL;
		field_ctype = (_tmp3_ = g_strconcat ("volatile ", field_ctype, NULL), field_ctype = (g_free (field_ctype), NULL), _tmp3_);
	}
	if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
		gboolean _tmp4_;
		gboolean _tmp23_;
		_tmp4_ = FALSE;
		if (is_gtypeinstance) {
			_tmp4_ = vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaCCodeExpression* _tmp8_;
			char* _tmp7_;
			ValaCCodeMemberAccess* _tmp6_;
			ValaCCodeIdentifier* _tmp5_;
			_tmp8_ = NULL;
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			lhs = (_tmp8_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("self")), "priv")), _tmp7_ = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp8_);
			_tmp7_ = (g_free (_tmp7_), NULL);
			(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
			(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
		} else {
			ValaCCodeExpression* _tmp11_;
			char* _tmp10_;
			ValaCCodeIdentifier* _tmp9_;
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			_tmp9_ = NULL;
			lhs = (_tmp11_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("self")), _tmp10_ = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp11_);
			_tmp10_ = (g_free (_tmp10_), NULL);
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpression* _tmp12_;
			ValaCCodeExpression* rhs;
			ValaCCodeExpressionStatement* _tmp14_;
			ValaCCodeAssignment* _tmp13_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp12_ = NULL;
			rhs = (_tmp12_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (f))), (_tmp12_ == NULL) ? NULL : vala_ccode_node_ref (_tmp12_));
			_tmp14_ = NULL;
			_tmp13_ = NULL;
			vala_ccode_fragment_append (self->instance_init_fragment, (ValaCCodeNode*) (_tmp14_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
			(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
			_tmp15_ = FALSE;
			_tmp16_ = FALSE;
			if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
				_tmp16_ = !vala_field_get_no_array_length (f);
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				_tmp15_ = VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f));
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				ValaArrayType* _tmp17_;
				ValaArrayType* array_type;
				ValaMemberAccess* this_access;
				ValaDataType* _tmp18_;
				ValaCCodeIdentifier* _tmp19_;
				ValaMemberAccess* ma;
				GeeList* sizes;
				_tmp17_ = NULL;
				array_type = (_tmp17_ = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp17_ == NULL) ? NULL : vala_code_node_ref (_tmp17_));
				this_access = vala_member_access_new_simple ("this", NULL);
				_tmp18_ = NULL;
				vala_expression_set_value_type ((ValaExpression*) this_access, _tmp18_ = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f))));
				(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_code_node_unref (_tmp18_), NULL));
				_tmp19_ = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp19_ = vala_ccode_identifier_new ("self")));
				(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
				ma = vala_member_access_new ((ValaExpression*) this_access, vala_symbol_get_name ((ValaSymbol*) f), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) f);
				sizes = vala_array_creation_expression_get_sizes (VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f)));
				{
					gint dim;
					dim = 1;
					{
						gboolean _tmp20_;
						_tmp20_ = TRUE;
						while (TRUE) {
							ValaCCodeExpression* array_len_lhs;
							ValaExpression* size;
							ValaCCodeExpressionStatement* _tmp22_;
							ValaCCodeAssignment* _tmp21_;
							if (!_tmp20_) {
								dim++;
							}
							_tmp20_ = FALSE;
							if (!(dim <= vala_array_type_get_rank (array_type))) {
								break;
							}
							array_len_lhs = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaExpression*) ma, dim);
							size = (ValaExpression*) gee_list_get (sizes, dim - 1);
							_tmp22_ = NULL;
							_tmp21_ = NULL;
							vala_ccode_fragment_append (self->instance_init_fragment, (ValaCCodeNode*) (_tmp22_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) size)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
							(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
							(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
							(array_len_lhs == NULL) ? NULL : (array_len_lhs = (vala_ccode_node_unref (array_len_lhs), NULL));
							(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
						}
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				(this_access == NULL) ? NULL : (this_access = (vala_code_node_unref (this_access), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				(sizes == NULL) ? NULL : (sizes = (gee_collection_object_unref (sizes), NULL));
			}
			vala_ccode_base_module_append_temp_decl (self, self->instance_init_fragment, (GeeList*) self->temp_vars);
			gee_collection_clear ((GeeCollection*) self->temp_vars);
			(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
		}
		_tmp23_ = FALSE;
		if (vala_ccode_base_module_requires_destroy (self, vala_field_get_field_type (f))) {
			_tmp23_ = self->instance_finalize_fragment != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			ValaMemberAccess* this_access;
			ValaDataType* _tmp24_;
			ValaStruct* _tmp26_;
			ValaSymbol* _tmp25_;
			ValaStruct* field_st;
			gboolean _tmp27_;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp31_;
			ValaCCodeExpression* _tmp30_;
			this_access = vala_member_access_new_simple ("this", NULL);
			_tmp24_ = NULL;
			vala_expression_set_value_type ((ValaExpression*) this_access, _tmp24_ = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f))));
			(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_code_node_unref (_tmp24_), NULL));
			_tmp26_ = NULL;
			_tmp25_ = NULL;
			field_st = (_tmp26_ = (_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) f), VALA_IS_STRUCT (_tmp25_) ? ((ValaStruct*) _tmp25_) : NULL), (_tmp26_ == NULL) ? NULL : vala_code_node_ref (_tmp26_));
			_tmp27_ = FALSE;
			if (field_st != NULL) {
				_tmp27_ = !vala_struct_is_simple_type (field_st);
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				ValaCCodeIdentifier* _tmp28_;
				_tmp28_ = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp28_ = vala_ccode_identifier_new ("(*self)")));
				(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
			} else {
				ValaCCodeIdentifier* _tmp29_;
				_tmp29_ = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) this_access, (ValaCCodeNode*) (_tmp29_ = vala_ccode_identifier_new ("self")));
				(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
			}
			ma = vala_member_access_new ((ValaExpression*) this_access, vala_symbol_get_name ((ValaSymbol*) f), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) f);
			_tmp31_ = NULL;
			_tmp30_ = NULL;
			vala_ccode_fragment_append (self->instance_finalize_fragment, (ValaCCodeNode*) (_tmp31_ = vala_ccode_expression_statement_new (_tmp30_ = vala_ccode_base_module_get_unref_expression (self, lhs, vala_field_get_field_type (f), (ValaExpression*) ma))));
			(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
			(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
			(this_access == NULL) ? NULL : (this_access = (vala_code_node_unref (this_access), NULL));
			(field_st == NULL) ? NULL : (field_st = (vala_code_node_unref (field_st), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
	} else {
		if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
			if (!is_gtypeinstance) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "class fields are not supported in compact classes");
				vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
				(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
				field_ctype = (g_free (field_ctype), NULL);
				return;
			}
		} else {
			ValaCCodeExpression* _tmp33_;
			char* _tmp32_;
			char* _tmp34_;
			ValaCCodeVariableDeclarator* _tmp35_;
			ValaCCodeVariableDeclarator* var_decl;
			ValaCCodeExpression* _tmp36_;
			ValaCCodeDeclaration* var_def;
			gboolean _tmp38_;
			vala_ccode_base_module_generate_field_declaration (self, f, self->source_declarations);
			if (!vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
				vala_ccode_base_module_generate_field_declaration (self, f, self->header_declarations);
			}
			vala_ccode_base_module_generate_field_declaration (self, f, self->internal_header_declarations);
			_tmp33_ = NULL;
			_tmp32_ = NULL;
			lhs = (_tmp33_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp32_ = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp33_);
			_tmp32_ = (g_free (_tmp32_), NULL);
			_tmp34_ = NULL;
			_tmp35_ = NULL;
			var_decl = (_tmp35_ = vala_ccode_variable_declarator_new (_tmp34_ = vala_field_get_cname (f), NULL, NULL), _tmp34_ = (g_free (_tmp34_), NULL), _tmp35_);
			_tmp36_ = NULL;
			vala_ccode_variable_declarator_set_initializer (var_decl, _tmp36_ = vala_ccode_base_module_default_value_for_type (self, vala_field_get_field_type (f), TRUE));
			(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
			if (vala_field_get_initializer (f) != NULL) {
				ValaCCodeExpression* _tmp37_;
				ValaCCodeExpression* init;
				_tmp37_ = NULL;
				init = (_tmp37_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (f))), (_tmp37_ == NULL) ? NULL : vala_ccode_node_ref (_tmp37_));
				if (vala_ccode_base_module_is_constant_ccode_expression (self, init)) {
					vala_ccode_variable_declarator_set_initializer (var_decl, init);
				}
				(init == NULL) ? NULL : (init = (vala_ccode_node_unref (init), NULL));
			}
			var_def = vala_ccode_declaration_new (field_ctype);
			vala_ccode_declaration_add_declarator (var_def, (ValaCCodeDeclarator*) var_decl);
			if (!vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
				vala_ccode_declaration_set_modifiers (var_def, VALA_CCODE_MODIFIERS_EXTERN);
			} else {
				vala_ccode_declaration_set_modifiers (var_def, VALA_CCODE_MODIFIERS_STATIC);
			}
			vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) var_def);
			_tmp38_ = FALSE;
			if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
				_tmp38_ = !vala_field_get_no_array_length (f);
			} else {
				_tmp38_ = FALSE;
			}
			/* add array length fields where necessary */
			if (_tmp38_) {
				ValaArrayType* _tmp39_;
				ValaArrayType* array_type;
				gboolean _tmp47_;
				_tmp39_ = NULL;
				array_type = (_tmp39_ = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp39_ == NULL) ? NULL : vala_code_node_ref (_tmp39_));
				{
					gint dim;
					dim = 1;
					{
						gboolean _tmp40_;
						_tmp40_ = TRUE;
						while (TRUE) {
							ValaDataType* len_type;
							char* _tmp41_;
							ValaCCodeDeclaration* _tmp42_;
							ValaCCodeDeclaration* len_def;
							ValaCCodeVariableDeclarator* _tmp46_;
							ValaCCodeConstant* _tmp45_;
							char* _tmp44_;
							char* _tmp43_;
							if (!_tmp40_) {
								dim++;
							}
							_tmp40_ = FALSE;
							if (!(dim <= vala_array_type_get_rank (array_type))) {
								break;
							}
							len_type = vala_data_type_copy (self->int_type);
							_tmp41_ = NULL;
							_tmp42_ = NULL;
							len_def = (_tmp42_ = vala_ccode_declaration_new (_tmp41_ = vala_data_type_get_cname (len_type)), _tmp41_ = (g_free (_tmp41_), NULL), _tmp42_);
							_tmp46_ = NULL;
							_tmp45_ = NULL;
							_tmp44_ = NULL;
							_tmp43_ = NULL;
							vala_ccode_declaration_add_declarator (len_def, (ValaCCodeDeclarator*) (_tmp46_ = vala_ccode_variable_declarator_new (_tmp44_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp43_ = vala_field_get_cname (f), dim), (ValaCCodeExpression*) (_tmp45_ = vala_ccode_constant_new ("0")), NULL)));
							(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
							(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
							_tmp44_ = (g_free (_tmp44_), NULL);
							_tmp43_ = (g_free (_tmp43_), NULL);
							if (!vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
								vala_ccode_declaration_set_modifiers (len_def, VALA_CCODE_MODIFIERS_EXTERN);
							} else {
								vala_ccode_declaration_set_modifiers (len_def, VALA_CCODE_MODIFIERS_STATIC);
							}
							vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) len_def);
							(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
							(len_def == NULL) ? NULL : (len_def = (vala_ccode_node_unref (len_def), NULL));
						}
					}
				}
				_tmp47_ = FALSE;
				if (vala_array_type_get_rank (array_type) == 1) {
					_tmp47_ = vala_symbol_is_internal_symbol ((ValaSymbol*) f);
				} else {
					_tmp47_ = FALSE;
				}
				if (_tmp47_) {
					ValaDataType* len_type;
					char* _tmp48_;
					ValaCCodeDeclaration* _tmp49_;
					ValaCCodeDeclaration* _cdecl_;
					ValaCCodeVariableDeclarator* _tmp53_;
					ValaCCodeConstant* _tmp52_;
					char* _tmp51_;
					char* _tmp50_;
					len_type = vala_data_type_copy (self->int_type);
					_tmp48_ = NULL;
					_tmp49_ = NULL;
					_cdecl_ = (_tmp49_ = vala_ccode_declaration_new (_tmp48_ = vala_data_type_get_cname (len_type)), _tmp48_ = (g_free (_tmp48_), NULL), _tmp49_);
					_tmp53_ = NULL;
					_tmp52_ = NULL;
					_tmp51_ = NULL;
					_tmp50_ = NULL;
					vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp53_ = vala_ccode_variable_declarator_new (_tmp51_ = vala_ccode_module_get_array_size_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp50_ = vala_field_get_cname (f)), (ValaCCodeExpression*) (_tmp52_ = vala_ccode_constant_new ("0")), NULL)));
					(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
					(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
					_tmp51_ = (g_free (_tmp51_), NULL);
					_tmp50_ = (g_free (_tmp50_), NULL);
					vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
					vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) _cdecl_);
					(len_type == NULL) ? NULL : (len_type = (vala_code_node_unref (len_type), NULL));
					(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			} else {
				if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
					ValaDelegateType* _tmp54_;
					ValaDelegateType* delegate_type;
					_tmp54_ = NULL;
					delegate_type = (_tmp54_ = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp54_ == NULL) ? NULL : vala_code_node_ref (_tmp54_));
					if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
						ValaCCodeDeclaration* target_def;
						ValaCCodeVariableDeclarator* _tmp58_;
						ValaCCodeConstant* _tmp57_;
						char* _tmp56_;
						char* _tmp55_;
						/* create field to store delegate target*/
						target_def = vala_ccode_declaration_new ("gpointer");
						_tmp58_ = NULL;
						_tmp57_ = NULL;
						_tmp56_ = NULL;
						_tmp55_ = NULL;
						vala_ccode_declaration_add_declarator (target_def, (ValaCCodeDeclarator*) (_tmp58_ = vala_ccode_variable_declarator_new (_tmp56_ = vala_ccode_base_module_get_delegate_target_cname (self, _tmp55_ = vala_field_get_cname (f)), (ValaCCodeExpression*) (_tmp57_ = vala_ccode_constant_new ("NULL")), NULL)));
						(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
						(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
						_tmp56_ = (g_free (_tmp56_), NULL);
						_tmp55_ = (g_free (_tmp55_), NULL);
						if (!vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
							vala_ccode_declaration_set_modifiers (target_def, VALA_CCODE_MODIFIERS_EXTERN);
						} else {
							vala_ccode_declaration_set_modifiers (target_def, VALA_CCODE_MODIFIERS_STATIC);
						}
						vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) target_def);
						(target_def == NULL) ? NULL : (target_def = (vala_ccode_node_unref (target_def), NULL));
					}
					(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
				}
			}
			if (vala_field_get_initializer (f) != NULL) {
				ValaCCodeExpression* _tmp59_;
				ValaCCodeExpression* rhs;
				_tmp59_ = NULL;
				rhs = (_tmp59_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (f))), (_tmp59_ == NULL) ? NULL : vala_ccode_node_ref (_tmp59_));
				if (!vala_ccode_base_module_is_constant_ccode_expression (self, rhs)) {
					if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) f))) {
						ValaCCodeExpressionStatement* _tmp61_;
						ValaCCodeAssignment* _tmp60_;
						gboolean _tmp62_;
						gboolean _tmp63_;
						_tmp61_ = NULL;
						_tmp60_ = NULL;
						vala_ccode_fragment_append (self->class_init_fragment, (ValaCCodeNode*) (_tmp61_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp60_ = vala_ccode_assignment_new (lhs, rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
						(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
						(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
						_tmp62_ = FALSE;
						_tmp63_ = FALSE;
						if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
							_tmp63_ = !vala_field_get_no_array_length (f);
						} else {
							_tmp63_ = FALSE;
						}
						if (_tmp63_) {
							_tmp62_ = VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f));
						} else {
							_tmp62_ = FALSE;
						}
						if (_tmp62_) {
							ValaArrayType* _tmp64_;
							ValaArrayType* array_type;
							ValaMemberAccess* ma;
							GeeList* sizes;
							_tmp64_ = NULL;
							array_type = (_tmp64_ = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp64_ == NULL) ? NULL : vala_code_node_ref (_tmp64_));
							ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) f), NULL);
							vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) f);
							sizes = vala_array_creation_expression_get_sizes (VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f)));
							{
								gint dim;
								dim = 1;
								{
									gboolean _tmp65_;
									_tmp65_ = TRUE;
									while (TRUE) {
										ValaCCodeExpression* array_len_lhs;
										ValaExpression* size;
										ValaCCodeExpressionStatement* _tmp67_;
										ValaCCodeAssignment* _tmp66_;
										if (!_tmp65_) {
											dim++;
										}
										_tmp65_ = FALSE;
										if (!(dim <= vala_array_type_get_rank (array_type))) {
											break;
										}
										array_len_lhs = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaExpression*) ma, dim);
										size = (ValaExpression*) gee_list_get (sizes, dim - 1);
										_tmp67_ = NULL;
										_tmp66_ = NULL;
										vala_ccode_fragment_append (self->class_init_fragment, (ValaCCodeNode*) (_tmp67_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp66_ = vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) size)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
										(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
										(_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL));
										(array_len_lhs == NULL) ? NULL : (array_len_lhs = (vala_ccode_node_unref (array_len_lhs), NULL));
										(size == NULL) ? NULL : (size = (vala_code_node_unref (size), NULL));
									}
								}
							}
							(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
							(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
							(sizes == NULL) ? NULL : (sizes = (gee_collection_object_unref (sizes), NULL));
						}
						vala_ccode_base_module_append_temp_decl (self, self->class_init_fragment, (GeeList*) self->temp_vars);
						gee_collection_clear ((GeeCollection*) self->temp_vars);
					} else {
						vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "Non-constant field initializers not supported in this context");
						(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
						(var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL));
						(var_def == NULL) ? NULL : (var_def = (vala_ccode_node_unref (var_def), NULL));
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
						field_ctype = (g_free (field_ctype), NULL);
						return;
					}
				}
				(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
			}
			(var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL));
			(var_def == NULL) ? NULL : (var_def = (vala_ccode_node_unref (var_def), NULL));
		}
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
	field_ctype = (g_free (field_ctype), NULL);
}


gboolean vala_ccode_base_module_is_constant_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr) {
	gboolean result;
	ValaCCodeParenthesizedExpression* _tmp4_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeParenthesizedExpression* cparenthesized;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cexpr != NULL, FALSE);
	if (VALA_IS_CCODE_CONSTANT (cexpr)) {
		result = TRUE;
		return result;
	} else {
		if (VALA_IS_CCODE_CAST_EXPRESSION (cexpr)) {
			ValaCCodeCastExpression* _tmp0_;
			ValaCCodeCastExpression* ccast;
			_tmp0_ = NULL;
			ccast = (_tmp0_ = VALA_CCODE_CAST_EXPRESSION (cexpr), (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
			result = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_cast_expression_get_inner (ccast));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
			return result;
		} else {
			if (VALA_IS_CCODE_BINARY_EXPRESSION (cexpr)) {
				ValaCCodeBinaryExpression* _tmp1_;
				ValaCCodeBinaryExpression* cbinary;
				gboolean _tmp2_;
				_tmp1_ = NULL;
				cbinary = (_tmp1_ = VALA_CCODE_BINARY_EXPRESSION (cexpr), (_tmp1_ == NULL) ? NULL : vala_ccode_node_ref (_tmp1_));
				_tmp2_ = FALSE;
				if (vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_left (cbinary))) {
					_tmp2_ = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_right (cbinary));
				} else {
					_tmp2_ = FALSE;
				}
				result = _tmp2_;
				(cbinary == NULL) ? NULL : (cbinary = (vala_ccode_node_unref (cbinary), NULL));
				return result;
			}
		}
	}
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	cparenthesized = (_tmp4_ = (_tmp3_ = cexpr, VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (_tmp3_) ? ((ValaCCodeParenthesizedExpression*) _tmp3_) : NULL), (_tmp4_ == NULL) ? NULL : vala_ccode_node_ref (_tmp4_));
	_tmp5_ = FALSE;
	if (NULL != cparenthesized) {
		_tmp5_ = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized));
	} else {
		_tmp5_ = FALSE;
	}
	result = _tmp5_;
	(cparenthesized == NULL) ? NULL : (cparenthesized = (vala_ccode_node_unref (cparenthesized), NULL));
	return result;
}


/**
 * Returns whether the passed cexpr is a pure expression, i.e. an
 * expression without side-effects.
 */
gboolean vala_ccode_base_module_is_pure_ccode_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cexpr != NULL, FALSE);
	_tmp0_ = FALSE;
	if (VALA_IS_CCODE_CONSTANT (cexpr)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CCODE_IDENTIFIER (cexpr);
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		if (VALA_IS_CCODE_BINARY_EXPRESSION (cexpr)) {
			ValaCCodeBinaryExpression* _tmp1_;
			ValaCCodeBinaryExpression* cbinary;
			gboolean _tmp2_;
			_tmp1_ = NULL;
			cbinary = (_tmp1_ = VALA_CCODE_BINARY_EXPRESSION (cexpr), (_tmp1_ == NULL) ? NULL : vala_ccode_node_ref (_tmp1_));
			_tmp2_ = FALSE;
			if (vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_binary_expression_get_left (cbinary))) {
				_tmp2_ = vala_ccode_base_module_is_constant_ccode_expression (self, vala_ccode_binary_expression_get_right (cbinary));
			} else {
				_tmp2_ = FALSE;
			}
			result = _tmp2_;
			(cbinary == NULL) ? NULL : (cbinary = (vala_ccode_node_unref (cbinary), NULL));
			return result;
		} else {
			if (VALA_IS_CCODE_UNARY_EXPRESSION (cexpr)) {
				ValaCCodeUnaryExpression* _tmp3_;
				ValaCCodeUnaryExpression* cunary;
				_tmp3_ = NULL;
				cunary = (_tmp3_ = VALA_CCODE_UNARY_EXPRESSION (cexpr), (_tmp3_ == NULL) ? NULL : vala_ccode_node_ref (_tmp3_));
				switch (vala_ccode_unary_expression_get_operator (cunary)) {
					case VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT:
					case VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT:
					case VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT:
					case VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT:
					{
						result = FALSE;
						(cunary == NULL) ? NULL : (cunary = (vala_ccode_node_unref (cunary), NULL));
						return result;
					}
					default:
					{
						result = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_unary_expression_get_inner (cunary));
						(cunary == NULL) ? NULL : (cunary = (vala_ccode_node_unref (cunary), NULL));
						return result;
					}
				}
				(cunary == NULL) ? NULL : (cunary = (vala_ccode_node_unref (cunary), NULL));
			} else {
				if (VALA_IS_CCODE_MEMBER_ACCESS (cexpr)) {
					ValaCCodeMemberAccess* _tmp4_;
					ValaCCodeMemberAccess* cma;
					_tmp4_ = NULL;
					cma = (_tmp4_ = VALA_CCODE_MEMBER_ACCESS (cexpr), (_tmp4_ == NULL) ? NULL : vala_ccode_node_ref (_tmp4_));
					result = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_member_access_get_inner (cma));
					(cma == NULL) ? NULL : (cma = (vala_ccode_node_unref (cma), NULL));
					return result;
				} else {
					if (VALA_IS_CCODE_ELEMENT_ACCESS (cexpr)) {
						ValaCCodeElementAccess* _tmp5_;
						ValaCCodeElementAccess* cea;
						gboolean _tmp6_;
						_tmp5_ = NULL;
						cea = (_tmp5_ = VALA_CCODE_ELEMENT_ACCESS (cexpr), (_tmp5_ == NULL) ? NULL : vala_ccode_node_ref (_tmp5_));
						_tmp6_ = FALSE;
						if (vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_element_access_get_container (cea))) {
							_tmp6_ = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_element_access_get_index (cea));
						} else {
							_tmp6_ = FALSE;
						}
						result = _tmp6_;
						(cea == NULL) ? NULL : (cea = (vala_ccode_node_unref (cea), NULL));
						return result;
					} else {
						if (VALA_IS_CCODE_CAST_EXPRESSION (cexpr)) {
							ValaCCodeCastExpression* _tmp7_;
							ValaCCodeCastExpression* ccast;
							_tmp7_ = NULL;
							ccast = (_tmp7_ = VALA_CCODE_CAST_EXPRESSION (cexpr), (_tmp7_ == NULL) ? NULL : vala_ccode_node_ref (_tmp7_));
							result = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_cast_expression_get_inner (ccast));
							(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
							return result;
						} else {
							if (VALA_IS_CCODE_PARENTHESIZED_EXPRESSION (cexpr)) {
								ValaCCodeParenthesizedExpression* _tmp8_;
								ValaCCodeParenthesizedExpression* cparenthesized;
								_tmp8_ = NULL;
								cparenthesized = (_tmp8_ = VALA_CCODE_PARENTHESIZED_EXPRESSION (cexpr), (_tmp8_ == NULL) ? NULL : vala_ccode_node_ref (_tmp8_));
								result = vala_ccode_base_module_is_pure_ccode_expression (self, vala_ccode_parenthesized_expression_get_inner (cparenthesized));
								(cparenthesized == NULL) ? NULL : (cparenthesized = (vala_ccode_node_unref (cparenthesized), NULL));
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void vala_ccode_base_module_real_visit_formal_parameter (ValaCCodeModule* base, ValaFormalParameter* p) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (p != NULL);
	vala_ccode_base_module_check_type (self, vala_formal_parameter_get_parameter_type (p));
	vala_code_node_accept_children ((ValaCodeNode*) p, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
}


static void vala_ccode_base_module_real_visit_property (ValaCCodeModule* base, ValaProperty* prop) {
	ValaCCodeBaseModule * self;
	gint old_next_temp_var_id;
	GeeArrayList* _tmp0_;
	GeeArrayList* old_temp_vars;
	GeeArrayList* _tmp1_;
	GeeArrayList* old_temp_ref_vars;
	GeeMap* _tmp2_;
	GeeMap* old_variable_name_map;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeMap* _tmp5_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp8_;
	GeeMap* _tmp11_;
	GeeMap* _tmp10_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (prop != NULL);
	vala_ccode_base_module_check_type (self, vala_property_get_property_type (prop));
	old_next_temp_var_id = self->next_temp_var_id;
	_tmp0_ = NULL;
	old_temp_vars = (_tmp0_ = self->temp_vars, (_tmp0_ == NULL) ? NULL : gee_collection_object_ref (_tmp0_));
	_tmp1_ = NULL;
	old_temp_ref_vars = (_tmp1_ = self->temp_ref_vars, (_tmp1_ == NULL) ? NULL : gee_collection_object_ref (_tmp1_));
	_tmp2_ = NULL;
	old_variable_name_map = (_tmp2_ = self->variable_name_map, (_tmp2_ == NULL) ? NULL : gee_collection_object_ref (_tmp2_));
	self->next_temp_var_id = 0;
	_tmp3_ = NULL;
	self->temp_vars = (_tmp3_ = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL)), _tmp3_);
	_tmp4_ = NULL;
	self->temp_ref_vars = (_tmp4_ = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL)), _tmp4_);
	_tmp5_ = NULL;
	self->variable_name_map = (_tmp5_ = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal), (self->variable_name_map == NULL) ? NULL : (self->variable_name_map = (gee_collection_object_unref (self->variable_name_map), NULL)), _tmp5_);
	vala_code_node_accept_children ((ValaCodeNode*) prop, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	self->next_temp_var_id = old_next_temp_var_id;
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	self->temp_vars = (_tmp7_ = (_tmp6_ = old_temp_vars, (_tmp6_ == NULL) ? NULL : gee_collection_object_ref (_tmp6_)), (self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL)), _tmp7_);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	self->temp_ref_vars = (_tmp9_ = (_tmp8_ = old_temp_ref_vars, (_tmp8_ == NULL) ? NULL : gee_collection_object_ref (_tmp8_)), (self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL)), _tmp9_);
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	self->variable_name_map = (_tmp11_ = (_tmp10_ = old_variable_name_map, (_tmp10_ == NULL) ? NULL : gee_collection_object_ref (_tmp10_)), (self->variable_name_map == NULL) ? NULL : (self->variable_name_map = (gee_collection_object_unref (self->variable_name_map), NULL)), _tmp11_);
	(old_temp_vars == NULL) ? NULL : (old_temp_vars = (gee_collection_object_unref (old_temp_vars), NULL));
	(old_temp_ref_vars == NULL) ? NULL : (old_temp_ref_vars = (gee_collection_object_unref (old_temp_ref_vars), NULL));
	(old_variable_name_map == NULL) ? NULL : (old_variable_name_map = (gee_collection_object_unref (old_variable_name_map), NULL));
}


void vala_ccode_base_module_generate_type_declaration (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeDeclarationSpace* decl_space) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (decl_space != NULL);
	if (VALA_IS_OBJECT_TYPE (type)) {
		ValaObjectType* _tmp0_;
		ValaObjectType* object_type;
		_tmp0_ = NULL;
		object_type = (_tmp0_ = VALA_OBJECT_TYPE (type), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		if (VALA_IS_CLASS (vala_object_type_get_type_symbol (object_type))) {
			vala_ccode_base_module_generate_class_declaration (self, VALA_CLASS (vala_object_type_get_type_symbol (object_type)), decl_space);
		} else {
			if (VALA_IS_INTERFACE (vala_object_type_get_type_symbol (object_type))) {
				vala_ccode_base_module_generate_interface_declaration (self, VALA_INTERFACE (vala_object_type_get_type_symbol (object_type)), decl_space);
			}
		}
		(object_type == NULL) ? NULL : (object_type = (vala_code_node_unref (object_type), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (type)) {
			ValaDelegateType* _tmp1_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp2_;
			ValaDelegate* d;
			_tmp1_ = NULL;
			deleg_type = (_tmp1_ = VALA_DELEGATE_TYPE (type), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
			_tmp2_ = NULL;
			d = (_tmp2_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
			vala_ccode_base_module_generate_delegate_declaration (self, d, decl_space);
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		} else {
			if (VALA_IS_ENUM (vala_data_type_get_data_type (type))) {
				ValaEnum* _tmp3_;
				ValaEnum* en;
				_tmp3_ = NULL;
				en = (_tmp3_ = VALA_ENUM (vala_data_type_get_data_type (type)), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
				vala_ccode_base_module_generate_enum_declaration (self, en, decl_space);
				(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
			} else {
				if (VALA_IS_VALUE_TYPE (type)) {
					ValaValueType* _tmp4_;
					ValaValueType* value_type;
					_tmp4_ = NULL;
					value_type = (_tmp4_ = VALA_VALUE_TYPE (type), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
					vala_ccode_base_module_generate_struct_declaration (self, VALA_STRUCT (vala_value_type_get_type_symbol (value_type)), decl_space);
					(value_type == NULL) ? NULL : (value_type = (vala_code_node_unref (value_type), NULL));
				} else {
					if (VALA_IS_ARRAY_TYPE (type)) {
						ValaArrayType* _tmp5_;
						ValaArrayType* array_type;
						_tmp5_ = NULL;
						array_type = (_tmp5_ = VALA_ARRAY_TYPE (type), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
						vala_ccode_base_module_generate_type_declaration (self, vala_array_type_get_element_type (array_type), decl_space);
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					} else {
						if (VALA_IS_ERROR_TYPE (type)) {
							ValaErrorType* _tmp6_;
							ValaErrorType* error_type;
							_tmp6_ = NULL;
							error_type = (_tmp6_ = VALA_ERROR_TYPE (type), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
							if (vala_error_type_get_error_domain (error_type) != NULL) {
								vala_ccode_base_module_generate_error_domain_declaration (self, vala_error_type_get_error_domain (error_type), decl_space);
							}
							(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
						} else {
							if (VALA_IS_POINTER_TYPE (type)) {
								ValaPointerType* _tmp7_;
								ValaPointerType* pointer_type;
								_tmp7_ = NULL;
								pointer_type = (_tmp7_ = VALA_POINTER_TYPE (type), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
								vala_ccode_base_module_generate_type_declaration (self, vala_pointer_type_get_base_type (pointer_type), decl_space);
								(pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL));
							}
						}
					}
				}
			}
		}
	}
	{
		GeeList* _tmp8_;
		GeeIterator* _tmp9_;
		GeeIterator* _type_arg_it;
		_tmp8_ = NULL;
		_tmp9_ = NULL;
		_type_arg_it = (_tmp9_ = gee_iterable_iterator ((GeeIterable*) (_tmp8_ = vala_data_type_get_type_arguments (type))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (gee_collection_object_unref (_tmp8_), NULL)), _tmp9_);
		while (TRUE) {
			ValaDataType* type_arg;
			if (!gee_iterator_next (_type_arg_it)) {
				break;
			}
			type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
			vala_ccode_base_module_generate_type_declaration (self, type_arg, decl_space);
			(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
		}
		(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
	}
}


static void vala_ccode_base_module_real_generate_class_struct_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	g_return_if_fail (decl_space != NULL);
}


void vala_ccode_base_module_generate_class_struct_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->generate_class_struct_declaration (self, cl, decl_space);
}


static void vala_ccode_base_module_real_generate_struct_declaration (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	g_return_if_fail (decl_space != NULL);
}


void vala_ccode_base_module_generate_struct_declaration (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->generate_struct_declaration (self, st, decl_space);
}


static void vala_ccode_base_module_real_generate_delegate_declaration (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (decl_space != NULL);
}


void vala_ccode_base_module_generate_delegate_declaration (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->generate_delegate_declaration (self, d, decl_space);
}


static void vala_ccode_base_module_real_generate_cparameters (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (cparam_map != NULL);
	g_return_if_fail (func != NULL);
}


void vala_ccode_base_module_generate_cparameters (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->generate_cparameters (self, m, decl_space, cparam_map, func, vdeclarator, carg_map, vcall, direction);
}


void vala_ccode_base_module_generate_property_accessor_declaration (ValaCCodeBaseModule* self, ValaPropertyAccessor* acc, ValaCCodeDeclarationSpace* decl_space) {
	char* _tmp0_;
	gboolean _tmp1_;
	ValaProperty* _tmp2_;
	ValaProperty* prop;
	gboolean returns_real_struct;
	ValaCCodeFormalParameter* cvalueparam;
	gboolean _tmp8_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (acc != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) vala_property_accessor_get_prop (acc), _tmp0_ = vala_property_accessor_get_cname (acc)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		return;
	}
	_tmp2_ = NULL;
	prop = (_tmp2_ = VALA_PROPERTY (vala_property_accessor_get_prop (acc)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	returns_real_struct = vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
	cvalueparam = NULL;
	if (returns_real_struct) {
		ValaCCodeFormalParameter* _tmp5_;
		char* _tmp4_;
		char* _tmp3_;
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		_tmp3_ = NULL;
		cvalueparam = (_tmp5_ = vala_ccode_formal_parameter_new ("value", _tmp4_ = g_strconcat (_tmp3_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (acc)), "*", NULL)), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp5_);
		_tmp4_ = (g_free (_tmp4_), NULL);
		_tmp3_ = (g_free (_tmp3_), NULL);
	} else {
		ValaCCodeFormalParameter* _tmp7_;
		char* _tmp6_;
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		cvalueparam = (_tmp7_ = vala_ccode_formal_parameter_new ("value", _tmp6_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (acc))), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp7_);
		_tmp6_ = (g_free (_tmp6_), NULL);
	}
	vala_ccode_base_module_generate_type_declaration (self, vala_property_accessor_get_value_type (acc), decl_space);
	_tmp8_ = FALSE;
	if (vala_property_accessor_get_readable (acc)) {
		_tmp8_ = !returns_real_struct;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaCCodeFunction* _tmp11_;
		char* _tmp10_;
		char* _tmp9_;
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		_tmp9_ = NULL;
		self->function = (_tmp11_ = vala_ccode_function_new (_tmp9_ = vala_property_accessor_get_cname (acc), _tmp10_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (acc))), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp11_);
		_tmp10_ = (g_free (_tmp10_), NULL);
		_tmp9_ = (g_free (_tmp9_), NULL);
	} else {
		ValaCCodeFunction* _tmp13_;
		char* _tmp12_;
		_tmp13_ = NULL;
		_tmp12_ = NULL;
		self->function = (_tmp13_ = vala_ccode_function_new (_tmp12_ = vala_property_accessor_get_cname (acc), "void"), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp13_);
		_tmp12_ = (g_free (_tmp12_), NULL);
	}
	if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
		ValaObjectTypeSymbol* _tmp14_;
		ValaObjectTypeSymbol* t;
		ValaObjectType* this_type;
		char* _tmp15_;
		ValaCCodeFormalParameter* _tmp16_;
		ValaCCodeFormalParameter* cselfparam;
		_tmp14_ = NULL;
		t = (_tmp14_ = VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_));
		this_type = vala_object_type_new (t);
		vala_ccode_base_module_generate_type_declaration (self, (ValaDataType*) this_type, decl_space);
		_tmp15_ = NULL;
		_tmp16_ = NULL;
		cselfparam = (_tmp16_ = vala_ccode_formal_parameter_new ("self", _tmp15_ = vala_data_type_get_cname ((ValaDataType*) this_type)), _tmp15_ = (g_free (_tmp15_), NULL), _tmp16_);
		vala_ccode_function_add_parameter (self->function, cselfparam);
		(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
		(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
		(cselfparam == NULL) ? NULL : (cselfparam = (vala_ccode_node_unref (cselfparam), NULL));
	}
	_tmp17_ = FALSE;
	_tmp18_ = FALSE;
	if (vala_property_accessor_get_writable (acc)) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = vala_property_accessor_get_construction (acc);
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = returns_real_struct;
	}
	if (_tmp17_) {
		vala_ccode_function_add_parameter (self->function, cvalueparam);
	}
	if (VALA_IS_ARRAY_TYPE (vala_property_accessor_get_value_type (acc))) {
		ValaArrayType* _tmp19_;
		ValaArrayType* array_type;
		char* length_ctype;
		_tmp19_ = NULL;
		array_type = (_tmp19_ = VALA_ARRAY_TYPE (vala_property_accessor_get_value_type (acc)), (_tmp19_ == NULL) ? NULL : vala_code_node_ref (_tmp19_));
		length_ctype = g_strdup ("int");
		if (vala_property_accessor_get_readable (acc)) {
			char* _tmp20_;
			_tmp20_ = NULL;
			length_ctype = (_tmp20_ = g_strdup ("int*"), length_ctype = (g_free (length_ctype), NULL), _tmp20_);
		}
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp21_;
				_tmp21_ = TRUE;
				while (TRUE) {
					const char* _tmp22_;
					ValaCCodeFormalParameter* _tmp24_;
					char* _tmp23_;
					if (!_tmp21_) {
						dim++;
					}
					_tmp21_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					_tmp22_ = NULL;
					if (vala_property_accessor_get_readable (acc)) {
						_tmp22_ = "result";
					} else {
						_tmp22_ = "value";
					}
					_tmp24_ = NULL;
					_tmp23_ = NULL;
					vala_ccode_function_add_parameter (self->function, _tmp24_ = vala_ccode_formal_parameter_new (_tmp23_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp22_, dim), length_ctype));
					(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
					_tmp23_ = (g_free (_tmp23_), NULL);
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		length_ctype = (g_free (length_ctype), NULL);
	} else {
		gboolean _tmp25_;
		_tmp25_ = FALSE;
		if (VALA_IS_DELEGATE_TYPE (vala_property_accessor_get_value_type (acc))) {
			_tmp25_ = vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (VALA_DELEGATE_TYPE (vala_property_accessor_get_value_type (acc))));
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			const char* _tmp26_;
			const char* _tmp27_;
			ValaCCodeFormalParameter* _tmp29_;
			char* _tmp28_;
			_tmp26_ = NULL;
			if (vala_property_accessor_get_readable (acc)) {
				_tmp26_ = "result";
			} else {
				_tmp26_ = "value";
			}
			_tmp27_ = NULL;
			if (vala_property_accessor_get_readable (acc)) {
				_tmp27_ = "gpointer*";
			} else {
				_tmp27_ = "gpointer";
			}
			_tmp29_ = NULL;
			_tmp28_ = NULL;
			vala_ccode_function_add_parameter (self->function, _tmp29_ = vala_ccode_formal_parameter_new (_tmp28_ = vala_ccode_base_module_get_delegate_target_cname (self, _tmp26_), _tmp27_));
			(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
			_tmp28_ = (g_free (_tmp28_), NULL);
		}
	}
	_tmp30_ = FALSE;
	_tmp31_ = FALSE;
	if (vala_symbol_is_private_symbol ((ValaSymbol*) prop)) {
		_tmp31_ = TRUE;
	} else {
		gboolean _tmp32_;
		_tmp32_ = FALSE;
		if (!vala_property_accessor_get_readable (acc)) {
			_tmp32_ = !vala_property_accessor_get_writable (acc);
		} else {
			_tmp32_ = FALSE;
		}
		_tmp31_ = _tmp32_;
	}
	if (_tmp31_) {
		_tmp30_ = TRUE;
	} else {
		_tmp30_ = vala_property_accessor_get_access (acc) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
	}
	if (_tmp30_) {
		vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | VALA_CCODE_MODIFIERS_STATIC);
	}
	vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) self->function);
	(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
	(cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL));
}


static void vala_ccode_base_module_real_visit_property_accessor (ValaCCodeModule* base, ValaPropertyAccessor* acc) {
	ValaCCodeBaseModule * self;
	ValaPropertyAccessor* _tmp0_;
	ValaPropertyAccessor* old_property_accessor;
	gboolean old_method_inner_error;
	ValaPropertyAccessor* _tmp2_;
	ValaPropertyAccessor* _tmp1_;
	ValaProperty* _tmp3_;
	ValaProperty* prop;
	gboolean returns_real_struct;
	ValaDataType* _tmp4_;
	ValaDataType* old_return_type;
	gboolean _tmp5_;
	ValaObjectTypeSymbol* _tmp9_;
	ValaObjectTypeSymbol* t;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	ValaObjectType* this_type;
	char* _tmp17_;
	ValaCCodeFormalParameter* _tmp18_;
	ValaCCodeFormalParameter* cselfparam;
	ValaCCodeFormalParameter* cvalueparam;
	gboolean _tmp24_;
	ValaPropertyAccessor* _tmp132_;
	ValaPropertyAccessor* _tmp131_;
	ValaDataType* _tmp134_;
	ValaDataType* _tmp133_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (acc != NULL);
	_tmp0_ = NULL;
	old_property_accessor = (_tmp0_ = self->current_property_accessor, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	old_method_inner_error = self->current_method_inner_error;
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->current_property_accessor = (_tmp2_ = (_tmp1_ = acc, (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_)), (self->current_property_accessor == NULL) ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL)), _tmp2_);
	self->current_method_inner_error = FALSE;
	_tmp3_ = NULL;
	prop = (_tmp3_ = VALA_PROPERTY (vala_property_accessor_get_prop (acc)), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	returns_real_struct = vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
	_tmp4_ = NULL;
	old_return_type = (_tmp4_ = self->current_return_type, (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
	_tmp5_ = FALSE;
	if (vala_property_accessor_get_readable (acc)) {
		_tmp5_ = !returns_real_struct;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaDataType* _tmp7_;
		ValaDataType* _tmp6_;
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		self->current_return_type = (_tmp7_ = (_tmp6_ = vala_property_accessor_get_value_type (acc), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_)), (self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL)), _tmp7_);
	} else {
		ValaDataType* _tmp8_;
		_tmp8_ = NULL;
		self->current_return_type = (_tmp8_ = (ValaDataType*) vala_void_type_new (NULL), (self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL)), _tmp8_);
	}
	vala_code_node_accept_children ((ValaCodeNode*) acc, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp9_ = NULL;
	t = (_tmp9_ = VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_));
	_tmp10_ = FALSE;
	if (vala_property_accessor_get_construction (acc)) {
		_tmp10_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) t, self->gobject_type);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) acc), "construct properties require GLib.Object");
		vala_code_node_set_error ((ValaCodeNode*) acc, TRUE);
		(old_property_accessor == NULL) ? NULL : (old_property_accessor = (vala_code_node_unref (old_property_accessor), NULL));
		(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
		(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
		return;
	}
	_tmp11_ = FALSE;
	_tmp12_ = FALSE;
	if (vala_property_get_is_abstract (prop)) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = vala_property_get_is_virtual (prop);
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		gboolean _tmp13_;
		_tmp13_ = FALSE;
		if (vala_property_get_base_property (prop) == NULL) {
			_tmp13_ = vala_property_get_base_interface_property (prop) == NULL;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp11_ = _tmp13_;
	}
	/* do not declare overriding properties and interface implementations*/
	if (_tmp11_) {
		gboolean _tmp14_;
		vala_ccode_base_module_generate_property_accessor_declaration (self, acc, self->source_declarations);
		_tmp14_ = FALSE;
		if (vala_property_accessor_get_readable (acc)) {
			_tmp14_ = TRUE;
		} else {
			_tmp14_ = vala_property_accessor_get_writable (acc);
		}
		/* do not declare construct-only properties in header files*/
		if (_tmp14_) {
			gboolean _tmp15_;
			_tmp15_ = FALSE;
			if (!vala_symbol_is_internal_symbol ((ValaSymbol*) prop)) {
				gboolean _tmp16_;
				_tmp16_ = FALSE;
				if (vala_property_accessor_get_access (acc) == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
					_tmp16_ = TRUE;
				} else {
					_tmp16_ = vala_property_accessor_get_access (acc) == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
				}
				_tmp15_ = _tmp16_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				vala_ccode_base_module_generate_property_accessor_declaration (self, acc, self->header_declarations);
			}
			vala_ccode_base_module_generate_property_accessor_declaration (self, acc, self->internal_header_declarations);
		}
	}
	this_type = vala_object_type_new (t);
	_tmp17_ = NULL;
	_tmp18_ = NULL;
	cselfparam = (_tmp18_ = vala_ccode_formal_parameter_new ("self", _tmp17_ = vala_data_type_get_cname ((ValaDataType*) this_type)), _tmp17_ = (g_free (_tmp17_), NULL), _tmp18_);
	cvalueparam = NULL;
	if (returns_real_struct) {
		ValaCCodeFormalParameter* _tmp21_;
		char* _tmp20_;
		char* _tmp19_;
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		cvalueparam = (_tmp21_ = vala_ccode_formal_parameter_new ("value", _tmp20_ = g_strconcat (_tmp19_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (acc)), "*", NULL)), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp21_);
		_tmp20_ = (g_free (_tmp20_), NULL);
		_tmp19_ = (g_free (_tmp19_), NULL);
	} else {
		ValaCCodeFormalParameter* _tmp23_;
		char* _tmp22_;
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		cvalueparam = (_tmp23_ = vala_ccode_formal_parameter_new ("value", _tmp22_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (acc))), (cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL)), _tmp23_);
		_tmp22_ = (g_free (_tmp22_), NULL);
	}
	_tmp24_ = FALSE;
	if (vala_property_get_is_abstract (prop)) {
		_tmp24_ = TRUE;
	} else {
		_tmp24_ = vala_property_get_is_virtual (prop);
	}
	if (_tmp24_) {
		gboolean _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp43_;
		gboolean _tmp44_;
		ValaCCodeBlock* block;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* _tmp56_;
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* _tmp27_;
			char* _tmp26_;
			char* _tmp25_;
			_tmp27_ = NULL;
			_tmp26_ = NULL;
			_tmp25_ = NULL;
			self->function = (_tmp27_ = vala_ccode_function_new (_tmp25_ = vala_property_accessor_get_cname (acc), _tmp26_ = vala_data_type_get_cname (self->current_return_type)), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp27_);
			_tmp26_ = (g_free (_tmp26_), NULL);
			_tmp25_ = (g_free (_tmp25_), NULL);
		} else {
			ValaCCodeFunction* _tmp29_;
			char* _tmp28_;
			_tmp29_ = NULL;
			_tmp28_ = NULL;
			self->function = (_tmp29_ = vala_ccode_function_new (_tmp28_ = vala_property_accessor_get_cname (acc), "void"), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp29_);
			_tmp28_ = (g_free (_tmp28_), NULL);
		}
		vala_ccode_function_add_parameter (self->function, cselfparam);
		_tmp30_ = FALSE;
		_tmp31_ = FALSE;
		if (vala_property_accessor_get_writable (acc)) {
			_tmp31_ = TRUE;
		} else {
			_tmp31_ = vala_property_accessor_get_construction (acc);
		}
		if (_tmp31_) {
			_tmp30_ = TRUE;
		} else {
			_tmp30_ = returns_real_struct;
		}
		if (_tmp30_) {
			vala_ccode_function_add_parameter (self->function, cvalueparam);
		}
		if (VALA_IS_ARRAY_TYPE (vala_property_accessor_get_value_type (acc))) {
			ValaArrayType* _tmp32_;
			ValaArrayType* array_type;
			char* length_ctype;
			_tmp32_ = NULL;
			array_type = (_tmp32_ = VALA_ARRAY_TYPE (vala_property_accessor_get_value_type (acc)), (_tmp32_ == NULL) ? NULL : vala_code_node_ref (_tmp32_));
			length_ctype = g_strdup ("int");
			if (vala_property_accessor_get_readable (acc)) {
				char* _tmp33_;
				_tmp33_ = NULL;
				length_ctype = (_tmp33_ = g_strdup ("int*"), length_ctype = (g_free (length_ctype), NULL), _tmp33_);
			}
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp34_;
					_tmp34_ = TRUE;
					while (TRUE) {
						const char* _tmp35_;
						ValaCCodeFormalParameter* _tmp37_;
						char* _tmp36_;
						if (!_tmp34_) {
							dim++;
						}
						_tmp34_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (array_type))) {
							break;
						}
						_tmp35_ = NULL;
						if (vala_property_accessor_get_readable (acc)) {
							_tmp35_ = "result";
						} else {
							_tmp35_ = "value";
						}
						_tmp37_ = NULL;
						_tmp36_ = NULL;
						vala_ccode_function_add_parameter (self->function, _tmp37_ = vala_ccode_formal_parameter_new (_tmp36_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp35_, dim), length_ctype));
						(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
						_tmp36_ = (g_free (_tmp36_), NULL);
					}
				}
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			length_ctype = (g_free (length_ctype), NULL);
		} else {
			gboolean _tmp38_;
			_tmp38_ = FALSE;
			if (VALA_IS_DELEGATE_TYPE (vala_property_accessor_get_value_type (acc))) {
				_tmp38_ = vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (VALA_DELEGATE_TYPE (vala_property_accessor_get_value_type (acc))));
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				const char* _tmp39_;
				const char* _tmp40_;
				ValaCCodeFormalParameter* _tmp42_;
				char* _tmp41_;
				_tmp39_ = NULL;
				if (vala_property_accessor_get_readable (acc)) {
					_tmp39_ = "result";
				} else {
					_tmp39_ = "value";
				}
				_tmp40_ = NULL;
				if (vala_property_accessor_get_readable (acc)) {
					_tmp40_ = "gpointer*";
				} else {
					_tmp40_ = "gpointer";
				}
				_tmp42_ = NULL;
				_tmp41_ = NULL;
				vala_ccode_function_add_parameter (self->function, _tmp42_ = vala_ccode_formal_parameter_new (_tmp41_ = vala_ccode_base_module_get_delegate_target_cname (self, _tmp39_), _tmp40_));
				(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
				_tmp41_ = (g_free (_tmp41_), NULL);
			}
		}
		_tmp43_ = FALSE;
		_tmp44_ = FALSE;
		if (vala_symbol_is_private_symbol ((ValaSymbol*) prop)) {
			_tmp44_ = TRUE;
		} else {
			gboolean _tmp45_;
			_tmp45_ = FALSE;
			if (vala_property_accessor_get_readable (acc)) {
				_tmp45_ = TRUE;
			} else {
				_tmp45_ = vala_property_accessor_get_writable (acc);
			}
			_tmp44_ = !_tmp45_;
		}
		if (_tmp44_) {
			_tmp43_ = TRUE;
		} else {
			_tmp43_ = vala_property_accessor_get_access (acc) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		}
		if (_tmp43_) {
			/* accessor function should be private if the property is an internal symbol or it's a construct-only setter*/
			vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | VALA_CCODE_MODIFIERS_STATIC);
		}
		block = vala_ccode_block_new ();
		vala_ccode_function_set_block (self->function, block);
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) prop))) {
			ValaInterface* _tmp46_;
			ValaInterface* iface;
			ValaCCodeFunctionCall* _tmp50_;
			ValaCCodeIdentifier* _tmp49_;
			char* _tmp48_;
			char* _tmp47_;
			_tmp46_ = NULL;
			iface = (_tmp46_ = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp46_ == NULL) ? NULL : vala_code_node_ref (_tmp46_));
			_tmp50_ = NULL;
			_tmp49_ = NULL;
			_tmp48_ = NULL;
			_tmp47_ = NULL;
			vcast = (_tmp50_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp49_ = vala_ccode_identifier_new (_tmp48_ = g_strdup_printf ("%s_GET_INTERFACE", _tmp47_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) iface, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp50_);
			(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
			_tmp48_ = (g_free (_tmp48_), NULL);
			_tmp47_ = (g_free (_tmp47_), NULL);
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
		} else {
			ValaClass* _tmp51_;
			ValaClass* cl;
			ValaCCodeFunctionCall* _tmp55_;
			ValaCCodeIdentifier* _tmp54_;
			char* _tmp53_;
			char* _tmp52_;
			_tmp51_ = NULL;
			cl = (_tmp51_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) prop)), (_tmp51_ == NULL) ? NULL : vala_code_node_ref (_tmp51_));
			_tmp55_ = NULL;
			_tmp54_ = NULL;
			_tmp53_ = NULL;
			_tmp52_ = NULL;
			vcast = (_tmp55_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp54_ = vala_ccode_identifier_new (_tmp53_ = g_strdup_printf ("%s_GET_CLASS", _tmp52_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)), _tmp55_);
			(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
			_tmp53_ = (g_free (_tmp53_), NULL);
			_tmp52_ = (g_free (_tmp52_), NULL);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		}
		_tmp56_ = NULL;
		vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_identifier_new ("self")));
		(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeMemberAccess* _tmp58_;
			char* _tmp57_;
			ValaCCodeFunctionCall* _tmp59_;
			ValaCCodeFunctionCall* vcall;
			ValaCCodeIdentifier* _tmp60_;
			_tmp58_ = NULL;
			_tmp57_ = NULL;
			_tmp59_ = NULL;
			vcall = (_tmp59_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp58_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp57_ = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL)), _tmp57_ = (g_free (_tmp57_), NULL), _tmp59_);
			_tmp60_ = NULL;
			vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp60_ = vala_ccode_identifier_new ("self")));
			(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
			if (returns_real_struct) {
				ValaCCodeIdentifier* _tmp61_;
				ValaCCodeExpressionStatement* _tmp62_;
				_tmp61_ = NULL;
				vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp61_ = vala_ccode_identifier_new ("value")));
				(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
				_tmp62_ = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp62_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) vcall)));
				(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
			} else {
				ValaCCodeReturnStatement* _tmp67_;
				if (VALA_IS_ARRAY_TYPE (vala_property_accessor_get_value_type (acc))) {
					ValaArrayType* _tmp63_;
					ValaArrayType* array_type;
					_tmp63_ = NULL;
					array_type = (_tmp63_ = VALA_ARRAY_TYPE (vala_property_accessor_get_value_type (acc)), (_tmp63_ == NULL) ? NULL : vala_code_node_ref (_tmp63_));
					{
						gint dim;
						dim = 1;
						{
							gboolean _tmp64_;
							_tmp64_ = TRUE;
							while (TRUE) {
								char* _tmp65_;
								ValaCCodeIdentifier* _tmp66_;
								ValaCCodeIdentifier* len_expr;
								if (!_tmp64_) {
									dim++;
								}
								_tmp64_ = FALSE;
								if (!(dim <= vala_array_type_get_rank (array_type))) {
									break;
								}
								_tmp65_ = NULL;
								_tmp66_ = NULL;
								len_expr = (_tmp66_ = vala_ccode_identifier_new (_tmp65_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim)), _tmp65_ = (g_free (_tmp65_), NULL), _tmp66_);
								vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) len_expr);
								(len_expr == NULL) ? NULL : (len_expr = (vala_ccode_node_unref (len_expr), NULL));
							}
						}
					}
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				}
				_tmp67_ = NULL;
				vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp67_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) vcall)));
				(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
			}
			(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
		} else {
			ValaCCodeMemberAccess* _tmp69_;
			char* _tmp68_;
			ValaCCodeFunctionCall* _tmp70_;
			ValaCCodeFunctionCall* vcall;
			ValaCCodeIdentifier* _tmp71_;
			ValaCCodeIdentifier* _tmp72_;
			ValaCCodeExpressionStatement* _tmp77_;
			_tmp69_ = NULL;
			_tmp68_ = NULL;
			_tmp70_ = NULL;
			vcall = (_tmp70_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp69_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp68_ = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL)), _tmp68_ = (g_free (_tmp68_), NULL), _tmp70_);
			_tmp71_ = NULL;
			vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp71_ = vala_ccode_identifier_new ("self")));
			(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
			_tmp72_ = NULL;
			vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) (_tmp72_ = vala_ccode_identifier_new ("value")));
			(_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL));
			if (VALA_IS_ARRAY_TYPE (vala_property_accessor_get_value_type (acc))) {
				ValaArrayType* _tmp73_;
				ValaArrayType* array_type;
				_tmp73_ = NULL;
				array_type = (_tmp73_ = VALA_ARRAY_TYPE (vala_property_accessor_get_value_type (acc)), (_tmp73_ == NULL) ? NULL : vala_code_node_ref (_tmp73_));
				{
					gint dim;
					dim = 1;
					{
						gboolean _tmp74_;
						_tmp74_ = TRUE;
						while (TRUE) {
							char* _tmp75_;
							ValaCCodeIdentifier* _tmp76_;
							ValaCCodeIdentifier* len_expr;
							if (!_tmp74_) {
								dim++;
							}
							_tmp74_ = FALSE;
							if (!(dim <= vala_array_type_get_rank (array_type))) {
								break;
							}
							_tmp75_ = NULL;
							_tmp76_ = NULL;
							len_expr = (_tmp76_ = vala_ccode_identifier_new (_tmp75_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "value", dim)), _tmp75_ = (g_free (_tmp75_), NULL), _tmp76_);
							vala_ccode_function_call_add_argument (vcall, (ValaCCodeExpression*) len_expr);
							(len_expr == NULL) ? NULL : (len_expr = (vala_ccode_node_unref (len_expr), NULL));
						}
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			_tmp77_ = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp77_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) vcall)));
			(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
			(vcall == NULL) ? NULL : (vcall = (vala_ccode_node_unref (vcall), NULL));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) self->function);
		(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
		(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean _tmp78_;
		gboolean is_virtual;
		char* cname;
		gboolean _tmp84_;
		gboolean _tmp85_;
		ValaObjectType* base_type;
		gboolean _tmp93_;
		gboolean _tmp94_;
		gboolean _tmp119_;
		gboolean _tmp122_;
		gboolean _tmp123_;
		_tmp78_ = FALSE;
		if (vala_property_get_base_property (prop) != NULL) {
			_tmp78_ = TRUE;
		} else {
			_tmp78_ = vala_property_get_base_interface_property (prop) != NULL;
		}
		is_virtual = _tmp78_;
		cname = NULL;
		if (is_virtual) {
			if (vala_property_accessor_get_readable (acc)) {
				char* _tmp80_;
				char* _tmp79_;
				_tmp80_ = NULL;
				_tmp79_ = NULL;
				cname = (_tmp80_ = g_strdup_printf ("%s_real_get_%s", _tmp79_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) t, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), cname = (g_free (cname), NULL), _tmp80_);
				_tmp79_ = (g_free (_tmp79_), NULL);
			} else {
				char* _tmp82_;
				char* _tmp81_;
				_tmp82_ = NULL;
				_tmp81_ = NULL;
				cname = (_tmp82_ = g_strdup_printf ("%s_real_set_%s", _tmp81_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) t, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), cname = (g_free (cname), NULL), _tmp82_);
				_tmp81_ = (g_free (_tmp81_), NULL);
			}
		} else {
			char* _tmp83_;
			_tmp83_ = NULL;
			cname = (_tmp83_ = vala_property_accessor_get_cname (acc), cname = (g_free (cname), NULL), _tmp83_);
		}
		_tmp84_ = FALSE;
		_tmp85_ = FALSE;
		if (vala_property_accessor_get_writable (acc)) {
			_tmp85_ = TRUE;
		} else {
			_tmp85_ = vala_property_accessor_get_construction (acc);
		}
		if (_tmp85_) {
			_tmp84_ = TRUE;
		} else {
			_tmp84_ = returns_real_struct;
		}
		if (_tmp84_) {
			ValaCCodeFunction* _tmp86_;
			_tmp86_ = NULL;
			self->function = (_tmp86_ = vala_ccode_function_new (cname, "void"), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp86_);
		} else {
			ValaCCodeFunction* _tmp88_;
			char* _tmp87_;
			_tmp88_ = NULL;
			_tmp87_ = NULL;
			self->function = (_tmp88_ = vala_ccode_function_new (cname, _tmp87_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (acc))), (self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL)), _tmp88_);
			_tmp87_ = (g_free (_tmp87_), NULL);
		}
		base_type = NULL;
		if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
			if (is_virtual) {
				ValaCCodeFormalParameter* _tmp92_;
				char* _tmp91_;
				if (vala_property_get_base_property (prop) != NULL) {
					ValaObjectType* _tmp89_;
					_tmp89_ = NULL;
					base_type = (_tmp89_ = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop)))), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp89_);
				} else {
					if (vala_property_get_base_interface_property (prop) != NULL) {
						ValaObjectType* _tmp90_;
						_tmp90_ = NULL;
						base_type = (_tmp90_ = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop)))), (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), _tmp90_);
					}
				}
				vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | VALA_CCODE_MODIFIERS_STATIC);
				_tmp92_ = NULL;
				_tmp91_ = NULL;
				vala_ccode_function_add_parameter (self->function, _tmp92_ = vala_ccode_formal_parameter_new ("base", _tmp91_ = vala_data_type_get_cname ((ValaDataType*) base_type)));
				(_tmp92_ == NULL) ? NULL : (_tmp92_ = (vala_ccode_node_unref (_tmp92_), NULL));
				_tmp91_ = (g_free (_tmp91_), NULL);
			} else {
				vala_ccode_function_add_parameter (self->function, cselfparam);
			}
		}
		_tmp93_ = FALSE;
		_tmp94_ = FALSE;
		if (vala_property_accessor_get_writable (acc)) {
			_tmp94_ = TRUE;
		} else {
			_tmp94_ = vala_property_accessor_get_construction (acc);
		}
		if (_tmp94_) {
			_tmp93_ = TRUE;
		} else {
			_tmp93_ = returns_real_struct;
		}
		if (_tmp93_) {
			vala_ccode_function_add_parameter (self->function, cvalueparam);
		}
		if (VALA_IS_ARRAY_TYPE (vala_property_accessor_get_value_type (acc))) {
			ValaArrayType* _tmp95_;
			ValaArrayType* array_type;
			char* length_ctype;
			_tmp95_ = NULL;
			array_type = (_tmp95_ = VALA_ARRAY_TYPE (vala_property_accessor_get_value_type (acc)), (_tmp95_ == NULL) ? NULL : vala_code_node_ref (_tmp95_));
			length_ctype = g_strdup ("int");
			if (vala_property_accessor_get_readable (acc)) {
				char* _tmp96_;
				_tmp96_ = NULL;
				length_ctype = (_tmp96_ = g_strdup ("int*"), length_ctype = (g_free (length_ctype), NULL), _tmp96_);
			}
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp97_;
					_tmp97_ = TRUE;
					while (TRUE) {
						const char* _tmp98_;
						ValaCCodeFormalParameter* _tmp100_;
						char* _tmp99_;
						if (!_tmp97_) {
							dim++;
						}
						_tmp97_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (array_type))) {
							break;
						}
						_tmp98_ = NULL;
						if (vala_property_accessor_get_readable (acc)) {
							_tmp98_ = "result";
						} else {
							_tmp98_ = "value";
						}
						_tmp100_ = NULL;
						_tmp99_ = NULL;
						vala_ccode_function_add_parameter (self->function, _tmp100_ = vala_ccode_formal_parameter_new (_tmp99_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp98_, dim), length_ctype));
						(_tmp100_ == NULL) ? NULL : (_tmp100_ = (vala_ccode_node_unref (_tmp100_), NULL));
						_tmp99_ = (g_free (_tmp99_), NULL);
					}
				}
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			length_ctype = (g_free (length_ctype), NULL);
		} else {
			gboolean _tmp101_;
			_tmp101_ = FALSE;
			if (VALA_IS_DELEGATE_TYPE (vala_property_accessor_get_value_type (acc))) {
				_tmp101_ = vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (VALA_DELEGATE_TYPE (vala_property_accessor_get_value_type (acc))));
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				const char* _tmp102_;
				const char* _tmp103_;
				ValaCCodeFormalParameter* _tmp105_;
				char* _tmp104_;
				_tmp102_ = NULL;
				if (vala_property_accessor_get_readable (acc)) {
					_tmp102_ = "result";
				} else {
					_tmp102_ = "value";
				}
				_tmp103_ = NULL;
				if (vala_property_accessor_get_readable (acc)) {
					_tmp103_ = "gpointer*";
				} else {
					_tmp103_ = "gpointer";
				}
				_tmp105_ = NULL;
				_tmp104_ = NULL;
				vala_ccode_function_add_parameter (self->function, _tmp105_ = vala_ccode_formal_parameter_new (_tmp104_ = vala_ccode_base_module_get_delegate_target_cname (self, _tmp102_), _tmp103_));
				(_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_ccode_node_unref (_tmp105_), NULL));
				_tmp104_ = (g_free (_tmp104_), NULL);
			}
		}
		if (!is_virtual) {
			gboolean _tmp106_;
			gboolean _tmp107_;
			_tmp106_ = FALSE;
			_tmp107_ = FALSE;
			if (vala_symbol_is_private_symbol ((ValaSymbol*) prop)) {
				_tmp107_ = TRUE;
			} else {
				gboolean _tmp108_;
				_tmp108_ = FALSE;
				if (vala_property_accessor_get_readable (acc)) {
					_tmp108_ = TRUE;
				} else {
					_tmp108_ = vala_property_accessor_get_writable (acc);
				}
				_tmp107_ = !_tmp108_;
			}
			if (_tmp107_) {
				_tmp106_ = TRUE;
			} else {
				_tmp106_ = vala_property_accessor_get_access (acc) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			}
			if (_tmp106_) {
				/* accessor function should be private if the property is an internal symbol or it's a construct-only setter*/
				vala_ccode_function_set_modifiers (self->function, vala_ccode_function_get_modifiers (self->function) | VALA_CCODE_MODIFIERS_STATIC);
			}
		}
		vala_ccode_function_set_block (self->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_accessor_get_body (acc))));
		if (is_virtual) {
			char* _tmp109_;
			ValaCCodeDeclaration* _tmp110_;
			ValaCCodeDeclaration* _cdecl_;
			ValaCCodeVariableDeclarator* _tmp113_;
			ValaCCodeExpression* _tmp112_;
			ValaCCodeIdentifier* _tmp111_;
			_tmp109_ = NULL;
			_tmp110_ = NULL;
			_cdecl_ = (_tmp110_ = vala_ccode_declaration_new (_tmp109_ = vala_data_type_get_cname ((ValaDataType*) this_type)), _tmp109_ = (g_free (_tmp109_), NULL), _tmp110_);
			_tmp113_ = NULL;
			_tmp112_ = NULL;
			_tmp111_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp113_ = vala_ccode_variable_declarator_new ("self", _tmp112_ = vala_ccode_base_module_transform_expression (self, (ValaCCodeExpression*) (_tmp111_ = vala_ccode_identifier_new ("base")), (ValaDataType*) base_type, (ValaDataType*) this_type, NULL), NULL)));
			(_tmp113_ == NULL) ? NULL : (_tmp113_ = (vala_ccode_node_unref (_tmp113_), NULL));
			(_tmp112_ == NULL) ? NULL : (_tmp112_ = (vala_ccode_node_unref (_tmp112_), NULL));
			(_tmp111_ == NULL) ? NULL : (_tmp111_ = (vala_ccode_node_unref (_tmp111_), NULL));
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) _cdecl_);
			(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
		}
		if (vala_property_accessor_get_readable (acc)) {
			char* _tmp114_;
			ValaCCodeDeclaration* _tmp115_;
			ValaCCodeDeclaration* _cdecl_;
			ValaCCodeVariableDeclarator* _tmp116_;
			_tmp114_ = NULL;
			_tmp115_ = NULL;
			_cdecl_ = (_tmp115_ = vala_ccode_declaration_new (_tmp114_ = vala_data_type_get_cname (vala_property_accessor_get_value_type (acc))), _tmp114_ = (g_free (_tmp114_), NULL), _tmp115_);
			_tmp116_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp116_ = vala_ccode_variable_declarator_new ("result", NULL, NULL)));
			(_tmp116_ == NULL) ? NULL : (_tmp116_ = (vala_ccode_node_unref (_tmp116_), NULL));
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) _cdecl_);
			(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
		}
		if (self->current_method_inner_error) {
			ValaCCodeDeclaration* _cdecl_;
			ValaCCodeVariableDeclarator* _tmp118_;
			ValaCCodeConstant* _tmp117_;
			_cdecl_ = vala_ccode_declaration_new ("GError *");
			_tmp118_ = NULL;
			_tmp117_ = NULL;
			vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp118_ = vala_ccode_variable_declarator_new ("_inner_error_", (ValaCCodeExpression*) (_tmp117_ = vala_ccode_constant_new ("NULL")), NULL)));
			(_tmp118_ == NULL) ? NULL : (_tmp118_ = (vala_ccode_node_unref (_tmp118_), NULL));
			(_tmp117_ == NULL) ? NULL : (_tmp117_ = (vala_ccode_node_unref (_tmp117_), NULL));
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) _cdecl_);
			(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
		}
		_tmp119_ = FALSE;
		if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
			_tmp119_ = !is_virtual;
		} else {
			_tmp119_ = FALSE;
		}
		if (_tmp119_) {
			ValaCCodeStatement* check_stmt;
			check_stmt = NULL;
			if (returns_real_struct) {
				ValaCCodeStatement* _tmp120_;
				_tmp120_ = NULL;
				check_stmt = (_tmp120_ = vala_ccode_base_module_create_property_type_check_statement (self, prop, FALSE, (ValaTypeSymbol*) t, TRUE, "self"), (check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL)), _tmp120_);
			} else {
				ValaCCodeStatement* _tmp121_;
				_tmp121_ = NULL;
				check_stmt = (_tmp121_ = vala_ccode_base_module_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), (ValaTypeSymbol*) t, TRUE, "self"), (check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL)), _tmp121_);
			}
			if (check_stmt != NULL) {
				vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) check_stmt);
			}
			(check_stmt == NULL) ? NULL : (check_stmt = (vala_ccode_node_unref (check_stmt), NULL));
		}
		_tmp122_ = FALSE;
		_tmp123_ = FALSE;
		if (vala_ccode_base_module_is_gobject_property (self, prop)) {
			_tmp123_ = vala_property_get_notify (prop);
		} else {
			_tmp123_ = FALSE;
		}
		if (_tmp123_) {
			gboolean _tmp124_;
			_tmp124_ = FALSE;
			if (vala_property_accessor_get_writable (acc)) {
				_tmp124_ = TRUE;
			} else {
				_tmp124_ = vala_property_accessor_get_construction (acc);
			}
			_tmp122_ = _tmp124_;
		} else {
			_tmp122_ = FALSE;
		}
		/* notify on property changes*/
		if (_tmp122_) {
			ValaCCodeIdentifier* _tmp125_;
			ValaCCodeFunctionCall* _tmp126_;
			ValaCCodeFunctionCall* notify_call;
			ValaCCodeCastExpression* _tmp128_;
			ValaCCodeIdentifier* _tmp127_;
			ValaCCodeConstant* _tmp129_;
			ValaCCodeExpressionStatement* _tmp130_;
			_tmp125_ = NULL;
			_tmp126_ = NULL;
			notify_call = (_tmp126_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp125_ = vala_ccode_identifier_new ("g_object_notify"))), (_tmp125_ == NULL) ? NULL : (_tmp125_ = (vala_ccode_node_unref (_tmp125_), NULL)), _tmp126_);
			_tmp128_ = NULL;
			_tmp127_ = NULL;
			vala_ccode_function_call_add_argument (notify_call, (ValaCCodeExpression*) (_tmp128_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp127_ = vala_ccode_identifier_new ("self")), "GObject *")));
			(_tmp128_ == NULL) ? NULL : (_tmp128_ = (vala_ccode_node_unref (_tmp128_), NULL));
			(_tmp127_ == NULL) ? NULL : (_tmp127_ = (vala_ccode_node_unref (_tmp127_), NULL));
			_tmp129_ = NULL;
			vala_ccode_function_call_add_argument (notify_call, (ValaCCodeExpression*) (_tmp129_ = vala_property_get_canonical_cconstant (prop)));
			(_tmp129_ == NULL) ? NULL : (_tmp129_ = (vala_ccode_node_unref (_tmp129_), NULL));
			_tmp130_ = NULL;
			vala_ccode_block_add_statement (vala_ccode_function_get_block (self->function), (ValaCCodeNode*) (_tmp130_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) notify_call)));
			(_tmp130_ == NULL) ? NULL : (_tmp130_ = (vala_ccode_node_unref (_tmp130_), NULL));
			(notify_call == NULL) ? NULL : (notify_call = (vala_ccode_node_unref (notify_call), NULL));
		}
		vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) self->function);
		cname = (g_free (cname), NULL);
		(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
	}
	_tmp132_ = NULL;
	_tmp131_ = NULL;
	self->current_property_accessor = (_tmp132_ = (_tmp131_ = old_property_accessor, (_tmp131_ == NULL) ? NULL : vala_code_node_ref (_tmp131_)), (self->current_property_accessor == NULL) ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL)), _tmp132_);
	_tmp134_ = NULL;
	_tmp133_ = NULL;
	self->current_return_type = (_tmp134_ = (_tmp133_ = old_return_type, (_tmp133_ == NULL) ? NULL : vala_code_node_ref (_tmp133_)), (self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL)), _tmp134_);
	self->current_method_inner_error = old_method_inner_error;
	(old_property_accessor == NULL) ? NULL : (old_property_accessor = (vala_code_node_unref (old_property_accessor), NULL));
	(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
	(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
	(t == NULL) ? NULL : (t = (vala_code_node_unref (t), NULL));
	(this_type == NULL) ? NULL : (this_type = (vala_code_node_unref (this_type), NULL));
	(cselfparam == NULL) ? NULL : (cselfparam = (vala_ccode_node_unref (cselfparam), NULL));
	(cvalueparam == NULL) ? NULL : (cvalueparam = (vala_ccode_node_unref (cvalueparam), NULL));
}


static void vala_ccode_base_module_real_visit_destructor (ValaCCodeModule* base, ValaDestructor* d) {
	ValaCCodeBaseModule * self;
	gboolean old_method_inner_error;
	gboolean _tmp0_;
	ValaCCodeFragment* cfrag;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (d != NULL);
	old_method_inner_error = self->current_method_inner_error;
	self->current_method_inner_error = FALSE;
	vala_code_node_accept_children ((ValaCodeNode*) d, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0_ = FALSE;
	if (vala_destructor_get_binding (d) == MEMBER_BINDING_STATIC) {
		_tmp0_ = !self->in_plugin;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) d), "static destructors are only supported for dynamic types");
		vala_code_node_set_error ((ValaCodeNode*) d, TRUE);
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	if (self->current_method_inner_error) {
		ValaCCodeDeclaration* _cdecl_;
		ValaCCodeVariableDeclarator* _tmp2_;
		ValaCCodeConstant* _tmp1_;
		_cdecl_ = vala_ccode_declaration_new ("GError *");
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp2_ = vala_ccode_variable_declarator_new ("_inner_error_", (ValaCCodeExpression*) (_tmp1_ = vala_ccode_constant_new ("NULL")), NULL)));
		(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) _cdecl_);
		(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	}
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_destructor_get_body (d)));
	vala_code_node_set_ccodenode ((ValaCodeNode*) d, (ValaCCodeNode*) cfrag);
	self->current_method_inner_error = old_method_inner_error;
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_ccode_base_module_real_visit_block (ValaCCodeModule* base, ValaBlock* b) {
	ValaCCodeBaseModule * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* old_symbol;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp1_;
	GeeList* local_vars;
	ValaCCodeBlock* cblock;
	ValaSymbol* _tmp22_;
	ValaSymbol* _tmp21_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (b != NULL);
	_tmp0_ = NULL;
	old_symbol = (_tmp0_ = self->current_symbol, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	self->current_symbol = (_tmp2_ = (_tmp1_ = (ValaSymbol*) b, (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_)), (self->current_symbol == NULL) ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL)), _tmp2_);
	vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (TRUE) {
			ValaLocalVariable* local;
			if (!gee_iterator_next (_local_it)) {
				break;
			}
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			vala_symbol_set_active ((ValaSymbol*) local, FALSE);
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	cblock = vala_ccode_block_new ();
	{
		GeeList* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _stmt_it;
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		_stmt_it = (_tmp4_ = gee_iterable_iterator ((GeeIterable*) (_tmp3_ = vala_block_get_statements (b))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (gee_collection_object_unref (_tmp3_), NULL)), _tmp4_);
		while (TRUE) {
			ValaCodeNode* stmt;
			ValaSourceReference* _tmp5_;
			ValaSourceReference* src;
			gboolean _tmp6_;
			if (!gee_iterator_next (_stmt_it)) {
				break;
			}
			stmt = (ValaCodeNode*) ((ValaStatement*) gee_iterator_get (_stmt_it));
			if (vala_code_node_get_error (stmt)) {
				(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
				continue;
			}
			_tmp5_ = NULL;
			src = (_tmp5_ = vala_code_node_get_source_reference (stmt), (_tmp5_ == NULL) ? NULL : vala_source_reference_ref (_tmp5_));
			_tmp6_ = FALSE;
			if (src != NULL) {
				_tmp6_ = vala_source_reference_get_comment (src) != NULL;
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				ValaCCodeComment* _tmp7_;
				_tmp7_ = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp7_ = vala_ccode_comment_new (vala_source_reference_get_comment (src))));
				(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
			}
			if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))) {
				{
					GeeList* _tmp8_;
					GeeIterator* _tmp9_;
					GeeIterator* _cstmt_it;
					_tmp8_ = NULL;
					_tmp9_ = NULL;
					_cstmt_it = (_tmp9_ = gee_iterable_iterator ((GeeIterable*) (_tmp8_ = vala_ccode_fragment_get_children (VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (stmt))))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (gee_collection_object_unref (_tmp8_), NULL)), _tmp9_);
					while (TRUE) {
						ValaCCodeNode* cstmt;
						if (!gee_iterator_next (_cstmt_it)) {
							break;
						}
						cstmt = (ValaCCodeNode*) gee_iterator_get (_cstmt_it);
						vala_ccode_block_add_statement (cblock, cstmt);
						(cstmt == NULL) ? NULL : (cstmt = (vala_ccode_node_unref (cstmt), NULL));
					}
					(_cstmt_it == NULL) ? NULL : (_cstmt_it = (gee_collection_object_unref (_cstmt_it), NULL));
				}
			} else {
				vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (stmt));
			}
			(stmt == NULL) ? NULL : (stmt = (vala_code_node_unref (stmt), NULL));
			(src == NULL) ? NULL : (src = (vala_source_reference_unref (src), NULL));
		}
		(_stmt_it == NULL) ? NULL : (_stmt_it = (gee_collection_object_unref (_stmt_it), NULL));
	}
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (TRUE) {
			ValaLocalVariable* local;
			gboolean _tmp10_;
			if (!gee_iterator_next (_local_it)) {
				break;
			}
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			_tmp10_ = FALSE;
			if (!vala_local_variable_get_floating (local)) {
				_tmp10_ = vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local));
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp13_;
				ValaCCodeExpression* _tmp12_;
				ValaCCodeExpression* _tmp11_;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp13_ = NULL;
				_tmp12_ = NULL;
				_tmp11_ = NULL;
				vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp13_ = vala_ccode_expression_statement_new (_tmp12_ = vala_ccode_base_module_get_unref_expression (self, _tmp11_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
				(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
				(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
				(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	if (VALA_IS_METHOD (vala_symbol_get_parent_symbol ((ValaSymbol*) b))) {
		ValaMethod* _tmp14_;
		ValaMethod* m;
		_tmp14_ = NULL;
		m = (_tmp14_ = VALA_METHOD (vala_symbol_get_parent_symbol ((ValaSymbol*) b)), (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_));
		{
			GeeList* _tmp15_;
			GeeIterator* _tmp16_;
			GeeIterator* _param_it;
			_tmp15_ = NULL;
			_tmp16_ = NULL;
			_param_it = (_tmp16_ = gee_iterable_iterator ((GeeIterable*) (_tmp15_ = vala_method_get_parameters (m))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (gee_collection_object_unref (_tmp15_), NULL)), _tmp16_);
			while (TRUE) {
				ValaFormalParameter* param;
				gboolean _tmp17_;
				if (!gee_iterator_next (_param_it)) {
					break;
				}
				param = (ValaFormalParameter*) gee_iterator_get (_param_it);
				_tmp17_ = FALSE;
				if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param))) {
					_tmp17_ = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					ValaMemberAccess* ma;
					ValaCCodeExpressionStatement* _tmp20_;
					ValaCCodeExpression* _tmp19_;
					ValaCCodeExpression* _tmp18_;
					ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) param), NULL);
					vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) param);
					_tmp20_ = NULL;
					_tmp19_ = NULL;
					_tmp18_ = NULL;
					vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp20_ = vala_ccode_expression_statement_new (_tmp19_ = vala_ccode_base_module_get_unref_expression (self, _tmp18_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) param)), vala_formal_parameter_get_parameter_type (param), (ValaExpression*) ma))));
					(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
					(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
					(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
					(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
				}
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
		}
		(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) b, (ValaCCodeNode*) cblock);
	_tmp22_ = NULL;
	_tmp21_ = NULL;
	self->current_symbol = (_tmp22_ = (_tmp21_ = old_symbol, (_tmp21_ == NULL) ? NULL : vala_code_node_ref (_tmp21_)), (self->current_symbol == NULL) ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL)), _tmp22_);
	(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
	(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
}


static void vala_ccode_base_module_real_visit_empty_statement (ValaCCodeModule* base, ValaEmptyStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeEmptyStatement* _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0_ = vala_ccode_empty_statement_new ()));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
}


static void vala_ccode_base_module_real_visit_declaration_statement (ValaCCodeModule* base, ValaDeclarationStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaLocalVariable* _tmp1_;
	ValaSymbol* _tmp0_;
	ValaLocalVariable* local;
	gboolean _tmp2_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_declaration_statement_get_declaration (stmt), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_declaration_statement_get_declaration (stmt)));
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	local = (_tmp1_ = (_tmp0_ = vala_declaration_statement_get_declaration (stmt), VALA_IS_LOCAL_VARIABLE (_tmp0_) ? ((ValaLocalVariable*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (local != NULL) {
		_tmp2_ = vala_local_variable_get_initializer (local) != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		vala_ccode_base_module_create_temp_decl (self, (ValaStatement*) stmt, (GeeList*) vala_local_variable_get_initializer (local)->temp_vars);
	}
	vala_ccode_base_module_create_temp_decl (self, (ValaStatement*) stmt, (GeeList*) self->temp_vars);
	gee_collection_clear ((GeeCollection*) self->temp_vars);
	(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name) {
	ValaCCodeExpression* result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = FALSE;
	if (self->current_method != NULL) {
		_tmp0_ = vala_method_get_coroutine (self->current_method);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp2_;
		ValaCCodeIdentifier* _tmp1_;
		ValaCCodeExpression* _tmp3_;
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		_tmp3_ = NULL;
		result = (_tmp3_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new ("data")), _tmp2_ = vala_ccode_base_module_get_variable_cname (self, name)), _tmp2_ = (g_free (_tmp2_), NULL), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL)), _tmp3_);
		return result;
	} else {
		char* _tmp4_;
		ValaCCodeExpression* _tmp5_;
		_tmp4_ = NULL;
		_tmp5_ = NULL;
		result = (_tmp5_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp4_ = vala_ccode_base_module_get_variable_cname (self, name)), _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_);
		return result;
	}
}


char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (g_utf8_get_char (g_utf8_offset_to_pointer (name, 0)) == '.') {
		/* compiler-internal variable*/
		if (!gee_map_contains (self->variable_name_map, name)) {
			char* _tmp0_;
			_tmp0_ = NULL;
			gee_map_set (self->variable_name_map, name, _tmp0_ = g_strdup_printf ("_tmp%d_", self->next_temp_var_id));
			_tmp0_ = (g_free (_tmp0_), NULL);
			self->next_temp_var_id++;
		}
		result = (char*) gee_map_get (self->variable_name_map, name);
		return result;
	} else {
		if (gee_collection_contains ((GeeCollection*) self->priv->reserved_identifiers, name)) {
			result = g_strdup_printf ("_%s_", name);
			return result;
		} else {
			const char* _tmp1_;
			_tmp1_ = NULL;
			result = (_tmp1_ = name, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
			return result;
		}
	}
}


static void vala_ccode_base_module_real_visit_local_variable (ValaCCodeModule* base, ValaLocalVariable* local) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* rhs;
	gboolean _tmp17_;
	ValaCCodeFragment* cfrag;
	gboolean _tmp62_;
	gboolean _tmp78_;
	gboolean _tmp91_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (local != NULL);
	vala_ccode_base_module_check_type (self, vala_local_variable_get_variable_type (local));
	vala_code_node_accept_children ((ValaCodeNode*) local, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_base_module_generate_type_declaration (self, vala_local_variable_get_variable_type (local), self->source_declarations);
	if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
		ValaArrayType* _tmp0_;
		ValaArrayType* array_type;
		/* create variables to store array dimensions*/
		_tmp0_ = NULL;
		array_type = (_tmp0_ = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		if (!vala_array_type_get_fixed_length (array_type)) {
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp1_;
					_tmp1_ = TRUE;
					while (TRUE) {
						char* _tmp4_;
						char* _tmp3_;
						ValaDataType* _tmp2_;
						ValaLocalVariable* _tmp5_;
						ValaLocalVariable* len_var;
						if (!_tmp1_) {
							dim++;
						}
						_tmp1_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (array_type))) {
							break;
						}
						_tmp4_ = NULL;
						_tmp3_ = NULL;
						_tmp2_ = NULL;
						_tmp5_ = NULL;
						len_var = (_tmp5_ = vala_local_variable_new (_tmp2_ = vala_data_type_copy (self->int_type), _tmp4_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp3_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), dim), NULL, NULL), _tmp4_ = (g_free (_tmp4_), NULL), _tmp3_ = (g_free (_tmp3_), NULL), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL)), _tmp5_);
						gee_list_insert ((GeeList*) self->temp_vars, 0, len_var);
						(len_var == NULL) ? NULL : (len_var = (vala_code_node_unref (len_var), NULL));
					}
				}
			}
			if (vala_array_type_get_rank (array_type) == 1) {
				char* _tmp8_;
				char* _tmp7_;
				ValaDataType* _tmp6_;
				ValaLocalVariable* _tmp9_;
				ValaLocalVariable* size_var;
				_tmp8_ = NULL;
				_tmp7_ = NULL;
				_tmp6_ = NULL;
				_tmp9_ = NULL;
				size_var = (_tmp9_ = vala_local_variable_new (_tmp6_ = vala_data_type_copy (self->int_type), _tmp8_ = vala_ccode_module_get_array_size_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp7_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local))), NULL, NULL), _tmp8_ = (g_free (_tmp8_), NULL), _tmp7_ = (g_free (_tmp7_), NULL), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL)), _tmp9_);
				gee_list_insert ((GeeList*) self->temp_vars, 0, size_var);
				(size_var == NULL) ? NULL : (size_var = (vala_code_node_unref (size_var), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
			ValaDelegateType* _tmp10_;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp11_;
			ValaDelegate* d;
			_tmp10_ = NULL;
			deleg_type = (_tmp10_ = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_));
			_tmp11_ = NULL;
			d = (_tmp11_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_));
			if (vala_delegate_get_has_target (d)) {
				char* _tmp15_;
				char* _tmp14_;
				ValaPointerType* _tmp13_;
				ValaVoidType* _tmp12_;
				ValaLocalVariable* _tmp16_;
				ValaLocalVariable* target_var;
				/* create variable to store delegate target*/
				_tmp15_ = NULL;
				_tmp14_ = NULL;
				_tmp13_ = NULL;
				_tmp12_ = NULL;
				_tmp16_ = NULL;
				target_var = (_tmp16_ = vala_local_variable_new ((ValaDataType*) (_tmp13_ = vala_pointer_type_new ((ValaDataType*) (_tmp12_ = vala_void_type_new (NULL)), NULL)), _tmp15_ = vala_ccode_base_module_get_delegate_target_cname (self, _tmp14_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local))), NULL, NULL), _tmp15_ = (g_free (_tmp15_), NULL), _tmp14_ = (g_free (_tmp14_), NULL), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_code_node_unref (_tmp13_), NULL)), (_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_code_node_unref (_tmp12_), NULL)), _tmp16_);
				gee_list_insert ((GeeList*) self->temp_vars, 0, target_var);
				(target_var == NULL) ? NULL : (target_var = (vala_code_node_unref (target_var), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	rhs = NULL;
	_tmp17_ = FALSE;
	if (vala_local_variable_get_initializer (local) != NULL) {
		_tmp17_ = vala_code_node_get_ccodenode ((ValaCodeNode*) vala_local_variable_get_initializer (local)) != NULL;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaCCodeExpression* _tmp19_;
		ValaCCodeExpression* _tmp18_;
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		rhs = (_tmp19_ = (_tmp18_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_local_variable_get_initializer (local))), (_tmp18_ == NULL) ? NULL : vala_ccode_node_ref (_tmp18_)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp19_);
		if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
			ValaArrayType* _tmp20_;
			ValaArrayType* array_type;
			_tmp20_ = NULL;
			array_type = (_tmp20_ = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp20_ == NULL) ? NULL : vala_code_node_ref (_tmp20_));
			if (vala_array_type_get_fixed_length (array_type)) {
				ValaCCodeExpression* _tmp21_;
				_tmp21_ = NULL;
				rhs = (_tmp21_ = NULL, (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp21_);
			} else {
				ValaCCodeCommaExpression* ccomma;
				ValaLocalVariable* temp_var;
				ValaCCodeAssignment* _tmp23_;
				ValaCCodeExpression* _tmp22_;
				ValaCCodeExpression* _tmp36_;
				ValaCCodeExpression* _tmp38_;
				ValaCCodeExpression* _tmp37_;
				ccomma = vala_ccode_comma_expression_new ();
				temp_var = vala_ccode_base_module_get_temp_variable (self, vala_local_variable_get_variable_type (local), TRUE, (ValaCodeNode*) local);
				gee_list_insert ((GeeList*) self->temp_vars, 0, temp_var);
				_tmp23_ = NULL;
				_tmp22_ = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_assignment_new (_tmp22_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_var)), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
				(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
				{
					gint dim;
					dim = 1;
					{
						gboolean _tmp24_;
						_tmp24_ = TRUE;
						while (TRUE) {
							char* _tmp26_;
							char* _tmp25_;
							ValaCCodeExpression* _tmp27_;
							ValaCCodeExpression* lhs_array_len;
							ValaCCodeExpression* rhs_array_len;
							ValaCCodeAssignment* _tmp28_;
							if (!_tmp24_) {
								dim++;
							}
							_tmp24_ = FALSE;
							if (!(dim <= vala_array_type_get_rank (array_type))) {
								break;
							}
							_tmp26_ = NULL;
							_tmp25_ = NULL;
							_tmp27_ = NULL;
							lhs_array_len = (_tmp27_ = vala_ccode_base_module_get_variable_cexpression (self, _tmp26_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp25_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), dim)), _tmp26_ = (g_free (_tmp26_), NULL), _tmp25_ = (g_free (_tmp25_), NULL), _tmp27_);
							rhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_local_variable_get_initializer (local), dim);
							_tmp28_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
							(lhs_array_len == NULL) ? NULL : (lhs_array_len = (vala_ccode_node_unref (lhs_array_len), NULL));
							(rhs_array_len == NULL) ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL));
						}
					}
				}
				if (vala_array_type_get_rank (array_type) == 1) {
					char* _tmp30_;
					char* _tmp29_;
					ValaCCodeExpression* _tmp31_;
					ValaCCodeExpression* lhs_array_size;
					char* _tmp33_;
					char* _tmp32_;
					ValaCCodeExpression* _tmp34_;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp35_;
					_tmp30_ = NULL;
					_tmp29_ = NULL;
					_tmp31_ = NULL;
					lhs_array_size = (_tmp31_ = vala_ccode_base_module_get_variable_cexpression (self, _tmp30_ = vala_ccode_module_get_array_size_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp29_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)))), _tmp30_ = (g_free (_tmp30_), NULL), _tmp29_ = (g_free (_tmp29_), NULL), _tmp31_);
					_tmp33_ = NULL;
					_tmp32_ = NULL;
					_tmp34_ = NULL;
					rhs_array_len = (_tmp34_ = vala_ccode_base_module_get_variable_cexpression (self, _tmp33_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp32_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), 1)), _tmp33_ = (g_free (_tmp33_), NULL), _tmp32_ = (g_free (_tmp32_), NULL), _tmp34_);
					_tmp35_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_assignment_new (lhs_array_size, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
					(lhs_array_size == NULL) ? NULL : (lhs_array_size = (vala_ccode_node_unref (lhs_array_size), NULL));
					(rhs_array_len == NULL) ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL));
				}
				_tmp36_ = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, _tmp36_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_var)));
				(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
				_tmp38_ = NULL;
				_tmp37_ = NULL;
				rhs = (_tmp38_ = (_tmp37_ = (ValaCCodeExpression*) ccomma, (_tmp37_ == NULL) ? NULL : vala_ccode_node_ref (_tmp37_)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp38_);
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		} else {
			if (VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaDelegateType* _tmp39_;
				ValaDelegateType* deleg_type;
				ValaDelegate* _tmp40_;
				ValaDelegate* d;
				_tmp39_ = NULL;
				deleg_type = (_tmp39_ = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp39_ == NULL) ? NULL : vala_code_node_ref (_tmp39_));
				_tmp40_ = NULL;
				d = (_tmp40_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp40_ == NULL) ? NULL : vala_code_node_ref (_tmp40_));
				if (vala_delegate_get_has_target (d)) {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp42_;
					ValaCCodeExpression* _tmp41_;
					char* _tmp44_;
					char* _tmp43_;
					ValaCCodeExpression* _tmp45_;
					ValaCCodeExpression* lhs_delegate_target;
					ValaCCodeExpression* rhs_delegate_target;
					ValaCCodeAssignment* _tmp46_;
					ValaCCodeExpression* _tmp47_;
					ValaCCodeExpression* _tmp49_;
					ValaCCodeExpression* _tmp48_;
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable (self, vala_local_variable_get_variable_type (local), TRUE, (ValaCodeNode*) local);
					gee_list_insert ((GeeList*) self->temp_vars, 0, temp_var);
					_tmp42_ = NULL;
					_tmp41_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_assignment_new (_tmp41_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_var)), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
					(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
					_tmp44_ = NULL;
					_tmp43_ = NULL;
					_tmp45_ = NULL;
					lhs_delegate_target = (_tmp45_ = vala_ccode_base_module_get_variable_cexpression (self, _tmp44_ = vala_ccode_base_module_get_delegate_target_cname (self, _tmp43_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)))), _tmp44_ = (g_free (_tmp44_), NULL), _tmp43_ = (g_free (_tmp43_), NULL), _tmp45_);
					rhs_delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (self, vala_local_variable_get_initializer (local));
					_tmp46_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp46_ = vala_ccode_assignment_new (lhs_delegate_target, rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
					_tmp47_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, _tmp47_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_var)));
					(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
					_tmp49_ = NULL;
					_tmp48_ = NULL;
					rhs = (_tmp49_ = (_tmp48_ = (ValaCCodeExpression*) ccomma, (_tmp48_ == NULL) ? NULL : vala_ccode_node_ref (_tmp48_)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp49_);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(lhs_delegate_target == NULL) ? NULL : (lhs_delegate_target = (vala_ccode_node_unref (lhs_delegate_target), NULL));
					(rhs_delegate_target == NULL) ? NULL : (rhs_delegate_target = (vala_ccode_node_unref (rhs_delegate_target), NULL));
				}
				(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
				(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
			}
		}
	} else {
		if (vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local))) {
			ValaCCodeExpression* _tmp50_;
			_tmp50_ = NULL;
			rhs = (_tmp50_ = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp50_);
			if (VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaArrayType* _tmp51_;
				ValaArrayType* array_type;
				/* initialize array length variables*/
				_tmp51_ = NULL;
				array_type = (_tmp51_ = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp51_ == NULL) ? NULL : vala_code_node_ref (_tmp51_));
				if (vala_array_type_get_fixed_length (array_type)) {
					ValaCCodeExpression* _tmp52_;
					_tmp52_ = NULL;
					rhs = (_tmp52_ = NULL, (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp52_);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeExpression* _tmp60_;
					ValaCCodeExpression* _tmp59_;
					ccomma = vala_ccode_comma_expression_new ();
					{
						gint dim;
						dim = 1;
						{
							gboolean _tmp53_;
							_tmp53_ = TRUE;
							while (TRUE) {
								ValaCCodeAssignment* _tmp58_;
								ValaCCodeConstant* _tmp57_;
								ValaCCodeExpression* _tmp56_;
								char* _tmp55_;
								char* _tmp54_;
								if (!_tmp53_) {
									dim++;
								}
								_tmp53_ = FALSE;
								if (!(dim <= vala_array_type_get_rank (array_type))) {
									break;
								}
								_tmp58_ = NULL;
								_tmp57_ = NULL;
								_tmp56_ = NULL;
								_tmp55_ = NULL;
								_tmp54_ = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp58_ = vala_ccode_assignment_new (_tmp56_ = vala_ccode_base_module_get_variable_cexpression (self, _tmp55_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp54_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), dim)), (ValaCCodeExpression*) (_tmp57_ = vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
								(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
								(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
								(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
								_tmp55_ = (g_free (_tmp55_), NULL);
								_tmp54_ = (g_free (_tmp54_), NULL);
							}
						}
					}
					vala_ccode_comma_expression_append_expression (ccomma, rhs);
					_tmp60_ = NULL;
					_tmp59_ = NULL;
					rhs = (_tmp60_ = (_tmp59_ = (ValaCCodeExpression*) ccomma, (_tmp59_ == NULL) ? NULL : vala_ccode_node_ref (_tmp59_)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp60_);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
		}
	}
	cfrag = vala_ccode_fragment_new ();
	if (self->pre_statement_fragment != NULL) {
		ValaCCodeFragment* _tmp61_;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) self->pre_statement_fragment);
		_tmp61_ = NULL;
		self->pre_statement_fragment = (_tmp61_ = NULL, (self->pre_statement_fragment == NULL) ? NULL : (self->pre_statement_fragment = (vala_ccode_node_unref (self->pre_statement_fragment), NULL)), _tmp61_);
	}
	_tmp62_ = FALSE;
	if (self->current_method != NULL) {
		_tmp62_ = vala_method_get_coroutine (self->current_method);
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		char* _tmp66_;
		char* _tmp65_;
		char* _tmp64_;
		char* _tmp63_;
		_tmp66_ = NULL;
		_tmp65_ = NULL;
		_tmp64_ = NULL;
		_tmp63_ = NULL;
		vala_ccode_struct_add_field (self->closure_struct, _tmp63_ = vala_data_type_get_cname (vala_local_variable_get_variable_type (local)), _tmp66_ = g_strconcat (_tmp64_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), _tmp65_ = vala_data_type_get_cdeclarator_suffix (vala_local_variable_get_variable_type (local)), NULL));
		_tmp66_ = (g_free (_tmp66_), NULL);
		_tmp65_ = (g_free (_tmp65_), NULL);
		_tmp64_ = (g_free (_tmp64_), NULL);
		_tmp63_ = (g_free (_tmp63_), NULL);
		if (vala_local_variable_get_initializer (local) != NULL) {
			ValaCCodeExpressionStatement* _tmp71_;
			ValaCCodeAssignment* _tmp70_;
			ValaCCodeMemberAccess* _tmp69_;
			char* _tmp68_;
			ValaCCodeIdentifier* _tmp67_;
			_tmp71_ = NULL;
			_tmp70_ = NULL;
			_tmp69_ = NULL;
			_tmp68_ = NULL;
			_tmp67_ = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp71_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp70_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp69_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp67_ = vala_ccode_identifier_new ("data")), _tmp68_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
			(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
			(_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL));
			_tmp68_ = (g_free (_tmp68_), NULL);
			(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
		}
	} else {
		char* _tmp73_;
		char* _tmp72_;
		ValaCCodeVariableDeclarator* _tmp74_;
		ValaCCodeVariableDeclarator* cvar;
		char* _tmp75_;
		ValaCCodeDeclaration* _tmp76_;
		ValaCCodeDeclaration* _cdecl_;
		_tmp73_ = NULL;
		_tmp72_ = NULL;
		_tmp74_ = NULL;
		cvar = (_tmp74_ = vala_ccode_variable_declarator_new (_tmp72_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) local)), rhs, _tmp73_ = vala_data_type_get_cdeclarator_suffix (vala_local_variable_get_variable_type (local))), _tmp73_ = (g_free (_tmp73_), NULL), _tmp72_ = (g_free (_tmp72_), NULL), _tmp74_);
		_tmp75_ = NULL;
		_tmp76_ = NULL;
		_cdecl_ = (_tmp76_ = vala_ccode_declaration_new (_tmp75_ = vala_data_type_get_cname (vala_local_variable_get_variable_type (local))), _tmp75_ = (g_free (_tmp75_), NULL), _tmp76_);
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) cvar);
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) _cdecl_);
		/* try to initialize uninitialized variables
		 initialization not necessary for variables stored in closure*/
		if (vala_ccode_variable_declarator_get_initializer (cvar) == NULL) {
			ValaCCodeExpression* _tmp77_;
			_tmp77_ = NULL;
			vala_ccode_variable_declarator_set_initializer (cvar, _tmp77_ = vala_ccode_base_module_default_value_for_type (self, vala_local_variable_get_variable_type (local), TRUE));
			(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
		}
		(cvar == NULL) ? NULL : (cvar = (vala_ccode_node_unref (cvar), NULL));
		(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	}
	_tmp78_ = FALSE;
	if (vala_local_variable_get_initializer (local) != NULL) {
		_tmp78_ = VALA_IS_ARRAY_TYPE (vala_local_variable_get_variable_type (local));
	} else {
		_tmp78_ = FALSE;
	}
	if (_tmp78_) {
		ValaArrayType* _tmp79_;
		ValaArrayType* array_type;
		_tmp79_ = NULL;
		array_type = (_tmp79_ = VALA_ARRAY_TYPE (vala_local_variable_get_variable_type (local)), (_tmp79_ == NULL) ? NULL : vala_code_node_ref (_tmp79_));
		if (vala_array_type_get_fixed_length (array_type)) {
			ValaCCodeIdentifier* _tmp80_;
			ValaCCodeFunctionCall* _tmp81_;
			ValaCCodeFunctionCall* sizeof_call;
			ValaCCodeIdentifier* _tmp83_;
			char* _tmp82_;
			ValaCCodeConstant* _tmp85_;
			char* _tmp84_;
			ValaCCodeBinaryExpression* _tmp86_;
			ValaCCodeBinaryExpression* size;
			ValaCCodeIdentifier* _tmp87_;
			ValaCCodeFunctionCall* _tmp88_;
			ValaCCodeFunctionCall* ccopy;
			ValaCCodeExpression* _tmp89_;
			ValaCCodeExpressionStatement* _tmp90_;
			vala_ccode_declaration_space_add_include (self->source_declarations, "string.h", FALSE);
			/* it is necessary to use memcpy for fixed-length (stack-allocated) arrays
			 simple assignments do not work in C*/
			_tmp80_ = NULL;
			_tmp81_ = NULL;
			sizeof_call = (_tmp81_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp80_ = vala_ccode_identifier_new ("sizeof"))), (_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL)), _tmp81_);
			_tmp83_ = NULL;
			_tmp82_ = NULL;
			vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp83_ = vala_ccode_identifier_new (_tmp82_ = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
			(_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL));
			_tmp82_ = (g_free (_tmp82_), NULL);
			_tmp85_ = NULL;
			_tmp84_ = NULL;
			_tmp86_ = NULL;
			size = (_tmp86_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) (_tmp85_ = vala_ccode_constant_new (_tmp84_ = g_strdup_printf ("%d", vala_array_type_get_length (array_type)))), (ValaCCodeExpression*) sizeof_call), (_tmp85_ == NULL) ? NULL : (_tmp85_ = (vala_ccode_node_unref (_tmp85_), NULL)), _tmp84_ = (g_free (_tmp84_), NULL), _tmp86_);
			_tmp87_ = NULL;
			_tmp88_ = NULL;
			ccopy = (_tmp88_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp87_ = vala_ccode_identifier_new ("memcpy"))), (_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL)), _tmp88_);
			_tmp89_ = NULL;
			vala_ccode_function_call_add_argument (ccopy, _tmp89_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) local)));
			(_tmp89_ == NULL) ? NULL : (_tmp89_ = (vala_ccode_node_unref (_tmp89_), NULL));
			vala_ccode_function_call_add_argument (ccopy, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_local_variable_get_initializer (local))));
			vala_ccode_function_call_add_argument (ccopy, (ValaCCodeExpression*) size);
			_tmp90_ = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp90_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccopy)));
			(_tmp90_ == NULL) ? NULL : (_tmp90_ = (vala_ccode_node_unref (_tmp90_), NULL));
			(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
			(size == NULL) ? NULL : (size = (vala_ccode_node_unref (size), NULL));
			(ccopy == NULL) ? NULL : (ccopy = (vala_ccode_node_unref (ccopy), NULL));
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	_tmp91_ = FALSE;
	if (vala_local_variable_get_initializer (local) != NULL) {
		_tmp91_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_local_variable_get_initializer (local));
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_local_variable_get_initializer (local), cfrag);
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) local, (ValaCCodeNode*) cfrag);
	vala_symbol_set_active ((ValaSymbol*) local, TRUE);
	(rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_ccode_base_module_real_visit_initializer_list (ValaCCodeModule* base, ValaInitializerList* list) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (list != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) list, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type ((ValaExpression*) list)))) {
		ValaStruct* _tmp0_;
		ValaStruct* st;
		ValaCCodeInitializerList* clist;
		GeeList* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* field_it;
		/* initializer is used as struct initializer */
		_tmp0_ = NULL;
		st = (_tmp0_ = VALA_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type ((ValaExpression*) list))), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		clist = vala_ccode_initializer_list_new ();
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		field_it = (_tmp2_ = gee_iterable_iterator ((GeeIterable*) (_tmp1_ = vala_struct_get_fields (st))), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (gee_collection_object_unref (_tmp1_), NULL)), _tmp2_);
		{
			GeeList* _tmp3_;
			GeeIterator* _tmp4_;
			GeeIterator* _expr_it;
			_tmp3_ = NULL;
			_tmp4_ = NULL;
			_expr_it = (_tmp4_ = gee_iterable_iterator ((GeeIterable*) (_tmp3_ = vala_initializer_list_get_initializers (list))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (gee_collection_object_unref (_tmp3_), NULL)), _tmp4_);
			while (TRUE) {
				ValaExpression* expr;
				ValaField* field;
				ValaCCodeExpression* _tmp7_;
				ValaCCodeExpression* cexpr;
				char* ctype;
				if (!gee_iterator_next (_expr_it)) {
					break;
				}
				expr = (ValaExpression*) gee_iterator_get (_expr_it);
				field = NULL;
				while (TRUE) {
					ValaField* _tmp5_;
					if (!(field == NULL)) {
						break;
					}
					gee_iterator_next (field_it);
					_tmp5_ = NULL;
					field = (_tmp5_ = (ValaField*) gee_iterator_get (field_it), (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp5_);
					if (vala_field_get_binding (field) != MEMBER_BINDING_INSTANCE) {
						ValaField* _tmp6_;
						/* we only initialize instance fields*/
						_tmp6_ = NULL;
						field = (_tmp6_ = NULL, (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), _tmp6_);
					}
				}
				_tmp7_ = NULL;
				cexpr = (_tmp7_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), (_tmp7_ == NULL) ? NULL : vala_ccode_node_ref (_tmp7_));
				ctype = vala_field_get_ctype (field);
				if (ctype != NULL) {
					ValaCCodeExpression* _tmp8_;
					_tmp8_ = NULL;
					cexpr = (_tmp8_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, ctype), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp8_);
				}
				vala_ccode_initializer_list_append (clist, cexpr);
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
				(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
				(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
				ctype = (g_free (ctype), NULL);
			}
			(_expr_it == NULL) ? NULL : (_expr_it = (gee_collection_object_unref (_expr_it), NULL));
		}
		vala_code_node_set_ccodenode ((ValaCodeNode*) list, (ValaCCodeNode*) clist);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
		(field_it == NULL) ? NULL : (field_it = (gee_collection_object_unref (field_it), NULL));
	} else {
		ValaCCodeInitializerList* clist;
		clist = vala_ccode_initializer_list_new ();
		{
			GeeList* _tmp9_;
			GeeIterator* _tmp10_;
			GeeIterator* _expr_it;
			_tmp9_ = NULL;
			_tmp10_ = NULL;
			_expr_it = (_tmp10_ = gee_iterable_iterator ((GeeIterable*) (_tmp9_ = vala_initializer_list_get_initializers (list))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (gee_collection_object_unref (_tmp9_), NULL)), _tmp10_);
			while (TRUE) {
				ValaExpression* expr;
				if (!gee_iterator_next (_expr_it)) {
					break;
				}
				expr = (ValaExpression*) gee_iterator_get (_expr_it);
				vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
				(expr == NULL) ? NULL : (expr = (vala_code_node_unref (expr), NULL));
			}
			(_expr_it == NULL) ? NULL : (_expr_it = (gee_collection_object_unref (_expr_it), NULL));
		}
		vala_code_node_set_ccodenode ((ValaCodeNode*) list, (ValaCCodeNode*) clist);
		(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
	}
}


ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference) {
	ValaLocalVariable* result;
	ValaDataType* var_type;
	char* _tmp0_;
	ValaLocalVariable* _tmp1_;
	ValaLocalVariable* local;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	var_type = vala_data_type_copy (type);
	vala_data_type_set_value_owned (var_type, value_owned);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	local = (_tmp1_ = vala_local_variable_new (var_type, _tmp0_ = g_strdup_printf ("_tmp%d_", self->next_temp_var_id), NULL, NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	if (node_reference != NULL) {
		vala_code_node_set_source_reference ((ValaCodeNode*) local, vala_code_node_get_source_reference (node_reference));
	}
	self->next_temp_var_id++;
	result = local;
	(var_type == NULL) ? NULL : (var_type = (vala_code_node_unref (var_type), NULL));
	return result;
}


static gboolean vala_ccode_base_module_is_in_generic_type (ValaCCodeBaseModule* self, ValaDataType* type) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = FALSE;
	if (VALA_IS_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_data_type_get_type_parameter (type)))) {
		gboolean _tmp1_;
		_tmp1_ = FALSE;
		if (self->current_method == NULL) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = vala_method_get_binding (self->current_method) == MEMBER_BINDING_INSTANCE;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static ValaCCodeExpression* vala_ccode_base_module_get_type_id_expression (ValaCCodeBaseModule* self, ValaDataType* type, gboolean is_chainup) {
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if (VALA_IS_GENERIC_TYPE (type)) {
		char* _tmp0_;
		char* _tmp1_;
		char* var_name;
		gboolean _tmp2_;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		var_name = (_tmp1_ = g_strdup_printf ("%s_type", _tmp0_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type)), -1)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
		_tmp2_ = FALSE;
		if (vala_ccode_base_module_is_in_generic_type (self, type)) {
			_tmp2_ = !is_chainup;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			ValaCCodeMemberAccess* _tmp4_;
			ValaCCodeIdentifier* _tmp3_;
			ValaCCodeExpression* _tmp5_;
			_tmp4_ = NULL;
			_tmp3_ = NULL;
			_tmp5_ = NULL;
			result = (_tmp5_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("self")), "priv")), var_name), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL)), _tmp5_);
			var_name = (g_free (var_name), NULL);
			return result;
		} else {
			result = (ValaCCodeExpression*) vala_ccode_identifier_new (var_name);
			var_name = (g_free (var_name), NULL);
			return result;
		}
		var_name = (g_free (var_name), NULL);
	} else {
		char* type_id;
		type_id = vala_data_type_get_type_id (type);
		if (type_id == NULL) {
			char* _tmp6_;
			_tmp6_ = NULL;
			type_id = (_tmp6_ = g_strdup ("G_TYPE_INVALID"), type_id = (g_free (type_id), NULL), _tmp6_);
		} else {
			vala_ccode_base_module_generate_type_declaration (self, type, self->source_declarations);
		}
		result = (ValaCCodeExpression*) vala_ccode_identifier_new (type_id);
		type_id = (g_free (type_id), NULL);
		return result;
	}
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup) {
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	if (VALA_IS_ERROR_TYPE (type)) {
		result = (ValaCCodeExpression*) vala_ccode_identifier_new ("g_error_copy");
		return result;
	} else {
		if (vala_data_type_get_data_type (type) != NULL) {
			char* dup_function;
			ValaClass* _tmp1_;
			ValaTypeSymbol* _tmp0_;
			ValaClass* cl;
			dup_function = NULL;
			_tmp1_ = NULL;
			_tmp0_ = NULL;
			cl = (_tmp1_ = (_tmp0_ = vala_data_type_get_data_type (type), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
			if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
				char* _tmp2_;
				gboolean _tmp3_;
				_tmp2_ = NULL;
				dup_function = (_tmp2_ = vala_typesymbol_get_ref_function (vala_data_type_get_data_type (type)), dup_function = (g_free (dup_function), NULL), _tmp2_);
				_tmp3_ = FALSE;
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (type))) {
					_tmp3_ = dup_function == NULL;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					char* _tmp5_;
					char* _tmp4_;
					_tmp5_ = NULL;
					_tmp4_ = NULL;
					vala_report_error (source_reference, _tmp5_ = g_strdup_printf ("missing class prerequisite for interface `%s', add GLib.Object to interface declaration if unsure", _tmp4_ = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
					_tmp5_ = (g_free (_tmp5_), NULL);
					_tmp4_ = (g_free (_tmp4_), NULL);
					result = NULL;
					dup_function = (g_free (dup_function), NULL);
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					return result;
				}
			} else {
				gboolean _tmp6_;
				_tmp6_ = FALSE;
				if (cl != NULL) {
					_tmp6_ = vala_class_get_is_immutable (cl);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					char* _tmp7_;
					/* allow duplicates of immutable instances as for example strings*/
					_tmp7_ = NULL;
					dup_function = (_tmp7_ = vala_typesymbol_get_dup_function (vala_data_type_get_data_type (type)), dup_function = (g_free (dup_function), NULL), _tmp7_);
					if (dup_function == NULL) {
						char* _tmp8_;
						_tmp8_ = NULL;
						dup_function = (_tmp8_ = g_strdup (""), dup_function = (g_free (dup_function), NULL), _tmp8_);
					}
				} else {
					if (VALA_IS_VALUE_TYPE (type)) {
						char* _tmp9_;
						gboolean _tmp10_;
						_tmp9_ = NULL;
						dup_function = (_tmp9_ = vala_typesymbol_get_dup_function (vala_data_type_get_data_type (type)), dup_function = (g_free (dup_function), NULL), _tmp9_);
						_tmp10_ = FALSE;
						if (dup_function == NULL) {
							_tmp10_ = vala_data_type_get_nullable (type);
						} else {
							_tmp10_ = FALSE;
						}
						if (_tmp10_) {
							char* _tmp11_;
							_tmp11_ = NULL;
							dup_function = (_tmp11_ = vala_ccode_base_module_generate_struct_dup_wrapper (self, VALA_VALUE_TYPE (type)), dup_function = (g_free (dup_function), NULL), _tmp11_);
						} else {
							if (dup_function == NULL) {
								char* _tmp12_;
								_tmp12_ = NULL;
								dup_function = (_tmp12_ = g_strdup (""), dup_function = (g_free (dup_function), NULL), _tmp12_);
							}
						}
					} else {
						char* _tmp13_;
						/* duplicating non-reference counted objects may cause side-effects (and performance issues)*/
						_tmp13_ = NULL;
						vala_report_error (source_reference, _tmp13_ = g_strdup_printf ("duplicating %s instance, use unowned variable or explicitly invoke copy method", vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
						_tmp13_ = (g_free (_tmp13_), NULL);
						result = NULL;
						dup_function = (g_free (dup_function), NULL);
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
						return result;
					}
				}
			}
			result = (ValaCCodeExpression*) vala_ccode_identifier_new (dup_function);
			dup_function = (g_free (dup_function), NULL);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			return result;
		} else {
			gboolean _tmp14_;
			_tmp14_ = FALSE;
			if (vala_data_type_get_type_parameter (type) != NULL) {
				_tmp14_ = VALA_IS_CLASS (self->current_type_symbol);
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				char* _tmp15_;
				char* _tmp16_;
				char* func_name;
				gboolean _tmp17_;
				_tmp15_ = NULL;
				_tmp16_ = NULL;
				func_name = (_tmp16_ = g_strdup_printf ("%s_dup_func", _tmp15_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type)), -1)), _tmp15_ = (g_free (_tmp15_), NULL), _tmp16_);
				_tmp17_ = FALSE;
				if (vala_ccode_base_module_is_in_generic_type (self, type)) {
					_tmp17_ = !is_chainup;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					ValaCCodeMemberAccess* _tmp19_;
					ValaCCodeIdentifier* _tmp18_;
					ValaCCodeExpression* _tmp20_;
					_tmp19_ = NULL;
					_tmp18_ = NULL;
					_tmp20_ = NULL;
					result = (_tmp20_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("self")), "priv")), func_name), (_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL)), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp20_);
					func_name = (g_free (func_name), NULL);
					return result;
				} else {
					result = (ValaCCodeExpression*) vala_ccode_identifier_new (func_name);
					func_name = (g_free (func_name), NULL);
					return result;
				}
				func_name = (g_free (func_name), NULL);
			} else {
				if (VALA_IS_POINTER_TYPE (type)) {
					ValaPointerType* _tmp21_;
					ValaPointerType* pointer_type;
					_tmp21_ = NULL;
					pointer_type = (_tmp21_ = VALA_POINTER_TYPE (type), (_tmp21_ == NULL) ? NULL : vala_code_node_ref (_tmp21_));
					result = vala_ccode_base_module_get_dup_func_expression (self, vala_pointer_type_get_base_type (pointer_type), source_reference, FALSE);
					(pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL));
					return result;
				} else {
					result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
					return result;
				}
			}
		}
	}
}


ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_dup_func_expression (self, type, source_reference, is_chainup);
}


static char* vala_ccode_base_module_generate_struct_dup_wrapper (ValaCCodeBaseModule* self, ValaValueType* value_type) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* dup_func;
	char* _tmp2_;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp5_;
	char* _tmp4_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp42_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	dup_func = (_tmp1_ = g_strdup_printf ("_%sdup", _tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) vala_value_type_get_type_symbol (value_type))), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	if (!vala_ccode_base_module_add_wrapper (self, dup_func)) {
		/* wrapper already defined*/
		result = dup_func;
		return result;
	}
	/* declaration*/
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	function = (_tmp3_ = vala_ccode_function_new (dup_func, _tmp2_ = vala_data_type_get_cname ((ValaDataType*) value_type)), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp5_ = vala_ccode_formal_parameter_new ("self", _tmp4_ = vala_data_type_get_cname ((ValaDataType*) value_type)));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp4_ = (g_free (_tmp4_), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	if (vala_value_type_get_type_symbol (value_type) == VALA_TYPESYMBOL (self->gvalue_type)) {
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeFunctionCall* _tmp7_;
		ValaCCodeFunctionCall* dup_call;
		ValaCCodeIdentifier* _tmp8_;
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeReturnStatement* _tmp10_;
		_tmp6_ = NULL;
		_tmp7_ = NULL;
		dup_call = (_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("g_boxed_copy"))), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp7_);
		_tmp8_ = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("G_TYPE_VALUE")));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		_tmp9_ = NULL;
		vala_ccode_function_call_add_argument (dup_call, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("self")));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		_tmp10_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp10_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) dup_call)));
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
		(dup_call == NULL) ? NULL : (dup_call = (vala_ccode_node_unref (dup_call), NULL));
	} else {
		char* _tmp11_;
		ValaCCodeDeclaration* _tmp12_;
		ValaCCodeDeclaration* _cdecl_;
		ValaCCodeVariableDeclarator* _tmp13_;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeFunctionCall* _tmp15_;
		ValaCCodeFunctionCall* creation_call;
		ValaCCodeConstant* _tmp17_;
		char* _tmp16_;
		ValaCCodeConstant* _tmp18_;
		ValaCCodeExpressionStatement* _tmp21_;
		ValaCCodeAssignment* _tmp20_;
		ValaCCodeIdentifier* _tmp19_;
		ValaStruct* _tmp23_;
		ValaTypeSymbol* _tmp22_;
		ValaStruct* st;
		gboolean _tmp24_;
		ValaCCodeReturnStatement* _tmp41_;
		ValaCCodeIdentifier* _tmp40_;
		_tmp11_ = NULL;
		_tmp12_ = NULL;
		_cdecl_ = (_tmp12_ = vala_ccode_declaration_new (_tmp11_ = vala_data_type_get_cname ((ValaDataType*) value_type)), _tmp11_ = (g_free (_tmp11_), NULL), _tmp12_);
		_tmp13_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp13_ = vala_ccode_variable_declarator_new ("dup", NULL, NULL)));
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) _cdecl_);
		_tmp14_ = NULL;
		_tmp15_ = NULL;
		creation_call = (_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_identifier_new ("g_new0"))), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), _tmp15_);
		_tmp17_ = NULL;
		_tmp16_ = NULL;
		vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_constant_new (_tmp16_ = vala_typesymbol_get_cname (vala_data_type_get_data_type ((ValaDataType*) value_type), FALSE))));
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
		_tmp16_ = (g_free (_tmp16_), NULL);
		_tmp18_ = NULL;
		vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_constant_new ("1")));
		(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp21_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("dup")), (ValaCCodeExpression*) creation_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
		(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
		_tmp23_ = NULL;
		_tmp22_ = NULL;
		st = (_tmp23_ = (_tmp22_ = vala_data_type_get_data_type ((ValaDataType*) value_type), VALA_IS_STRUCT (_tmp22_) ? ((ValaStruct*) _tmp22_) : NULL), (_tmp23_ == NULL) ? NULL : vala_code_node_ref (_tmp23_));
		_tmp24_ = FALSE;
		if (st != NULL) {
			_tmp24_ = vala_struct_is_disposable (st);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaCCodeIdentifier* _tmp26_;
			char* _tmp25_;
			ValaCCodeFunctionCall* _tmp27_;
			ValaCCodeFunctionCall* copy_call;
			ValaCCodeIdentifier* _tmp28_;
			ValaCCodeIdentifier* _tmp29_;
			ValaCCodeExpressionStatement* _tmp30_;
			_tmp26_ = NULL;
			_tmp25_ = NULL;
			_tmp27_ = NULL;
			copy_call = (_tmp27_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new (_tmp25_ = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st)))), (_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL)), _tmp25_ = (g_free (_tmp25_), NULL), _tmp27_);
			_tmp28_ = NULL;
			vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new ("self")));
			(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
			_tmp29_ = NULL;
			vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("dup")));
			(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
			_tmp30_ = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp30_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) copy_call)));
			(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
			(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
		} else {
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeFunctionCall* _tmp32_;
			ValaCCodeFunctionCall* sizeof_call;
			ValaCCodeConstant* _tmp34_;
			char* _tmp33_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaCCodeFunctionCall* copy_call;
			ValaCCodeIdentifier* _tmp37_;
			ValaCCodeIdentifier* _tmp38_;
			ValaCCodeExpressionStatement* _tmp39_;
			vala_ccode_declaration_space_add_include (self->source_declarations, "string.h", FALSE);
			_tmp31_ = NULL;
			_tmp32_ = NULL;
			sizeof_call = (_tmp32_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new ("sizeof"))), (_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL)), _tmp32_);
			_tmp34_ = NULL;
			_tmp33_ = NULL;
			vala_ccode_function_call_add_argument (sizeof_call, (ValaCCodeExpression*) (_tmp34_ = vala_ccode_constant_new (_tmp33_ = vala_typesymbol_get_cname (vala_data_type_get_data_type ((ValaDataType*) value_type), FALSE))));
			(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
			_tmp33_ = (g_free (_tmp33_), NULL);
			_tmp35_ = NULL;
			_tmp36_ = NULL;
			copy_call = (_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("memcpy"))), (_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL)), _tmp36_);
			_tmp37_ = NULL;
			vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new ("dup")));
			(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
			_tmp38_ = NULL;
			vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new ("self")));
			(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
			vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) sizeof_call);
			_tmp39_ = NULL;
			vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp39_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) copy_call)));
			(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
			(sizeof_call == NULL) ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL));
			(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
		}
		_tmp41_ = NULL;
		_tmp40_ = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp41_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("dup")))));
		(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
		(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
		(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	}
	/* append to file*/
	_tmp42_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp42_ = vala_ccode_function_copy (function)));
	(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) function);
	result = dup_func;
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	return result;
}


char* vala_ccode_base_module_generate_destroy_func_wrapper (ValaCCodeBaseModule* self, ValaDataType* type) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* destroy_func;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3_;
	char* _tmp2_;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp5_;
	char* _tmp4_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* free_call;
	ValaCCodeUnaryExpression* _tmp8_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeExpressionStatement* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	destroy_func = (_tmp1_ = g_strdup_printf ("_vala_%s_free", _tmp0_ = vala_typesymbol_get_cname (vala_data_type_get_data_type (type), FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	if (!vala_ccode_base_module_add_wrapper (self, destroy_func)) {
		/* wrapper already defined*/
		result = destroy_func;
		return result;
	}
	/* declaration*/
	function = vala_ccode_function_new (destroy_func, "void");
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("self", _tmp2_ = vala_data_type_get_cname (type)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp2_ = (g_free (_tmp2_), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	_tmp6_ = NULL;
	free_call = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new (_tmp4_ = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type))))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp4_ = (g_free (_tmp4_), NULL), _tmp6_);
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (free_call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new ("self")))));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp9_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp9_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) free_call)));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	/* append to file*/
	_tmp10_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp10_ = vala_ccode_function_copy (function)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) function);
	result = destroy_func;
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(free_call == NULL) ? NULL : (free_call = (vala_ccode_node_unref (free_call), NULL));
	return result;
}


ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, gboolean is_chainup) {
	ValaCCodeExpression* result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = FALSE;
	if (vala_code_context_get_profile (self->priv->_context) == VALA_PROFILE_GOBJECT) {
		gboolean _tmp1_;
		_tmp1_ = FALSE;
		if (vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->glist_type)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->gslist_type);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean elements_require_free;
		ValaCCodeExpression* element_destroy_func_expression;
		gboolean _tmp5_;
		/* create wrapper function to free list elements if necessary*/
		elements_require_free = FALSE;
		element_destroy_func_expression = NULL;
		{
			GeeList* _tmp2_;
			GeeIterator* _tmp3_;
			GeeIterator* _type_arg_it;
			_tmp2_ = NULL;
			_tmp3_ = NULL;
			_type_arg_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = vala_data_type_get_type_arguments (type))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (gee_collection_object_unref (_tmp2_), NULL)), _tmp3_);
			while (TRUE) {
				ValaDataType* type_arg;
				if (!gee_iterator_next (_type_arg_it)) {
					break;
				}
				type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
				elements_require_free = vala_ccode_base_module_requires_destroy (self, type_arg);
				if (elements_require_free) {
					ValaCCodeExpression* _tmp4_;
					_tmp4_ = NULL;
					element_destroy_func_expression = (_tmp4_ = vala_ccode_base_module_get_destroy_func_expression (self, type_arg, FALSE), (element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL)), _tmp4_);
				}
				(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
			}
			(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
		}
		_tmp5_ = FALSE;
		if (elements_require_free) {
			_tmp5_ = VALA_IS_CCODE_IDENTIFIER (element_destroy_func_expression);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			char* _tmp6_;
			ValaCCodeExpression* _tmp7_;
			_tmp6_ = NULL;
			_tmp7_ = NULL;
			result = (_tmp7_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp6_ = vala_ccode_base_module_generate_glist_free_wrapper (self, type, VALA_CCODE_IDENTIFIER (element_destroy_func_expression))), _tmp6_ = (g_free (_tmp6_), NULL), _tmp7_);
			(element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL));
			return result;
		} else {
			char* _tmp8_;
			ValaCCodeExpression* _tmp9_;
			_tmp8_ = NULL;
			_tmp9_ = NULL;
			result = (_tmp9_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp8_ = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type))), _tmp8_ = (g_free (_tmp8_), NULL), _tmp9_);
			(element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL));
			return result;
		}
		(element_destroy_func_expression == NULL) ? NULL : (element_destroy_func_expression = (vala_ccode_node_unref (element_destroy_func_expression), NULL));
	} else {
		if (VALA_IS_ERROR_TYPE (type)) {
			result = (ValaCCodeExpression*) vala_ccode_identifier_new ("g_error_free");
			return result;
		} else {
			if (vala_data_type_get_data_type (type) != NULL) {
				char* unref_function;
				unref_function = NULL;
				if (VALA_IS_REFERENCE_TYPE (type)) {
					if (vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type))) {
						char* _tmp10_;
						gboolean _tmp11_;
						_tmp10_ = NULL;
						unref_function = (_tmp10_ = vala_typesymbol_get_unref_function (vala_data_type_get_data_type (type)), unref_function = (g_free (unref_function), NULL), _tmp10_);
						_tmp11_ = FALSE;
						if (VALA_IS_INTERFACE (vala_data_type_get_data_type (type))) {
							_tmp11_ = unref_function == NULL;
						} else {
							_tmp11_ = FALSE;
						}
						if (_tmp11_) {
							char* _tmp13_;
							char* _tmp12_;
							_tmp13_ = NULL;
							_tmp12_ = NULL;
							vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) type), _tmp13_ = g_strdup_printf ("missing class prerequisite for interface `%s', add GLib.Object to interface declaration if unsure", _tmp12_ = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
							_tmp13_ = (g_free (_tmp13_), NULL);
							_tmp12_ = (g_free (_tmp12_), NULL);
							result = NULL;
							unref_function = (g_free (unref_function), NULL);
							return result;
						}
					} else {
						ValaClass* _tmp15_;
						ValaTypeSymbol* _tmp14_;
						ValaClass* cl;
						gboolean _tmp16_;
						_tmp15_ = NULL;
						_tmp14_ = NULL;
						cl = (_tmp15_ = (_tmp14_ = vala_data_type_get_data_type (type), VALA_IS_CLASS (_tmp14_) ? ((ValaClass*) _tmp14_) : NULL), (_tmp15_ == NULL) ? NULL : vala_code_node_ref (_tmp15_));
						_tmp16_ = FALSE;
						if (cl != NULL) {
							_tmp16_ = vala_class_get_free_function_address_of (cl);
						} else {
							_tmp16_ = FALSE;
						}
						if (_tmp16_) {
							char* _tmp17_;
							_tmp17_ = NULL;
							unref_function = (_tmp17_ = vala_ccode_base_module_generate_destroy_func_wrapper (self, type), unref_function = (g_free (unref_function), NULL), _tmp17_);
						} else {
							char* _tmp18_;
							_tmp18_ = NULL;
							unref_function = (_tmp18_ = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), unref_function = (g_free (unref_function), NULL), _tmp18_);
						}
						(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					}
				} else {
					if (vala_data_type_get_nullable (type)) {
						char* _tmp19_;
						_tmp19_ = NULL;
						unref_function = (_tmp19_ = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), unref_function = (g_free (unref_function), NULL), _tmp19_);
						if (unref_function == NULL) {
							char* _tmp20_;
							_tmp20_ = NULL;
							unref_function = (_tmp20_ = g_strdup ("g_free"), unref_function = (g_free (unref_function), NULL), _tmp20_);
						}
					} else {
						ValaStruct* _tmp21_;
						ValaStruct* st;
						char* _tmp22_;
						_tmp21_ = NULL;
						st = (_tmp21_ = VALA_STRUCT (vala_data_type_get_data_type (type)), (_tmp21_ == NULL) ? NULL : vala_code_node_ref (_tmp21_));
						_tmp22_ = NULL;
						unref_function = (_tmp22_ = vala_typesymbol_get_destroy_function ((ValaTypeSymbol*) st), unref_function = (g_free (unref_function), NULL), _tmp22_);
						(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					}
				}
				if (unref_function == NULL) {
					result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
					unref_function = (g_free (unref_function), NULL);
					return result;
				}
				result = (ValaCCodeExpression*) vala_ccode_identifier_new (unref_function);
				unref_function = (g_free (unref_function), NULL);
				return result;
			} else {
				gboolean _tmp23_;
				_tmp23_ = FALSE;
				if (vala_data_type_get_type_parameter (type) != NULL) {
					_tmp23_ = VALA_IS_CLASS (self->current_type_symbol);
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					char* _tmp24_;
					char* _tmp25_;
					char* func_name;
					gboolean _tmp26_;
					_tmp24_ = NULL;
					_tmp25_ = NULL;
					func_name = (_tmp25_ = g_strdup_printf ("%s_destroy_func", _tmp24_ = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type)), -1)), _tmp24_ = (g_free (_tmp24_), NULL), _tmp25_);
					_tmp26_ = FALSE;
					if (vala_ccode_base_module_is_in_generic_type (self, type)) {
						_tmp26_ = !is_chainup;
					} else {
						_tmp26_ = FALSE;
					}
					if (_tmp26_) {
						ValaCCodeMemberAccess* _tmp28_;
						ValaCCodeIdentifier* _tmp27_;
						ValaCCodeExpression* _tmp29_;
						_tmp28_ = NULL;
						_tmp27_ = NULL;
						_tmp29_ = NULL;
						result = (_tmp29_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("self")), "priv")), func_name), (_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL)), (_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL)), _tmp29_);
						func_name = (g_free (func_name), NULL);
						return result;
					} else {
						result = (ValaCCodeExpression*) vala_ccode_identifier_new (func_name);
						func_name = (g_free (func_name), NULL);
						return result;
					}
					func_name = (g_free (func_name), NULL);
				} else {
					if (VALA_IS_ARRAY_TYPE (type)) {
						result = (ValaCCodeExpression*) vala_ccode_identifier_new ("g_free");
						return result;
					} else {
						if (VALA_IS_POINTER_TYPE (type)) {
							result = (ValaCCodeExpression*) vala_ccode_identifier_new ("g_free");
							return result;
						} else {
							result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
							return result;
						}
					}
				}
			}
		}
	}
}


static char* vala_ccode_base_module_generate_glist_free_wrapper (ValaCCodeBaseModule* self, ValaDataType* list_type, ValaCCodeIdentifier* element_destroy_func_expression) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* destroy_func;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3_;
	char* _tmp2_;
	ValaCCodeBlock* block;
	ValaCCodeFunctionCall* element_free_call;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeCastExpression* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeExpressionStatement* _tmp11_;
	ValaCCodeIdentifier* _tmp13_;
	char* _tmp12_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* cfreecall;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeExpressionStatement* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list_type != NULL, NULL);
	g_return_val_if_fail (element_destroy_func_expression != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	destroy_func = (_tmp1_ = g_strdup_printf ("_%s_%s", _tmp0_ = vala_typesymbol_get_free_function (vala_data_type_get_data_type (list_type)), vala_ccode_identifier_get_name (element_destroy_func_expression)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	if (!vala_ccode_base_module_add_wrapper (self, destroy_func)) {
		/* wrapper already defined*/
		result = destroy_func;
		return result;
	}
	/* declaration*/
	function = vala_ccode_function_new (destroy_func, "void");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_add_parameter (function, _tmp3_ = vala_ccode_formal_parameter_new ("self", _tmp2_ = vala_data_type_get_cname (list_type)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp2_ = (g_free (_tmp2_), NULL);
	/* definition*/
	block = vala_ccode_block_new ();
	element_free_call = NULL;
	if (vala_data_type_get_data_type (list_type) == VALA_TYPESYMBOL (self->glist_type)) {
		ValaCCodeFunctionCall* _tmp5_;
		ValaCCodeIdentifier* _tmp4_;
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		element_free_call = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("g_list_foreach"))), (element_free_call == NULL) ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL)), _tmp5_);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	} else {
		ValaCCodeFunctionCall* _tmp7_;
		ValaCCodeIdentifier* _tmp6_;
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		element_free_call = (_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("g_slist_foreach"))), (element_free_call == NULL) ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL)), _tmp7_);
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	}
	_tmp8_ = NULL;
	vala_ccode_function_call_add_argument (element_free_call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("self")));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp9_ = NULL;
	vala_ccode_function_call_add_argument (element_free_call, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) element_destroy_func_expression, "GFunc")));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp10_ = NULL;
	vala_ccode_function_call_add_argument (element_free_call, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_constant_new ("NULL")));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp11_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp11_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) element_free_call)));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	_tmp14_ = NULL;
	cfreecall = (_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new (_tmp12_ = vala_typesymbol_get_free_function (vala_data_type_get_data_type (list_type))))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp12_ = (g_free (_tmp12_), NULL), _tmp14_);
	_tmp15_ = NULL;
	vala_ccode_function_call_add_argument (cfreecall, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("self")));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp16_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp16_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cfreecall)));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	/* append to file*/
	_tmp17_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (self->source_declarations, (ValaCCodeNode*) (_tmp17_ = vala_ccode_function_copy (function)));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (self->source_type_member_definition, (ValaCCodeNode*) function);
	result = destroy_func;
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(element_free_call == NULL) ? NULL : (element_free_call = (vala_ccode_node_unref (element_free_call), NULL));
	(cfreecall == NULL) ? NULL : (cfreecall = (vala_ccode_node_unref (cfreecall), NULL));
	return result;
}


static char* vala_ccode_base_module_real_append_struct_array_free (ValaCCodeBaseModule* self, ValaStruct* st) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (st != NULL, NULL);
	result = NULL;
	return result;
}


char* vala_ccode_base_module_append_struct_array_free (ValaCCodeBaseModule* self, ValaStruct* st) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_struct_array_free (self, st);
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr) {
	ValaCCodeExpression* result;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* ccall;
	gboolean _tmp2_;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeBinaryExpression* _tmp12_;
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeCommaExpression* ccomma;
	gboolean _tmp18_;
	ValaCCodeConstant* _tmp36_;
	ValaCCodeAssignment* cassign;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gboolean uses_gfree;
	gboolean _tmp40_;
	ValaCCodeConstant* _tmp41_;
	ValaCCodeExpression* _tmp42_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cvar != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	ccall = (_tmp1_ = vala_ccode_function_call_new (_tmp0_ = vala_ccode_base_module_get_destroy_func_expression (self, type, FALSE)), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = FALSE;
	if (VALA_IS_VALUE_TYPE (type)) {
		_tmp2_ = !vala_data_type_get_nullable (type);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaCCodeUnaryExpression* _tmp3_;
		gboolean _tmp4_;
		/* normal value type, no null check*/
		_tmp3_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cvar)));
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
		_tmp4_ = FALSE;
		if (self->gvalue_type != NULL) {
			_tmp4_ = vala_data_type_get_data_type (type) == VALA_TYPESYMBOL (self->gvalue_type);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeFunctionCall* _tmp6_;
			ValaCCodeFunctionCall* cisvalid;
			ValaCCodeUnaryExpression* _tmp7_;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeConstant* _tmp8_;
			ValaCCodeConstant* _tmp9_;
			ValaCCodeExpression* _tmp10_;
			/* g_value_unset must not be called for already unset values*/
			_tmp5_ = NULL;
			_tmp6_ = NULL;
			cisvalid = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("G_IS_VALUE"))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp6_);
			_tmp7_ = NULL;
			vala_ccode_function_call_add_argument (cisvalid, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cvar)));
			(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
			_tmp8_ = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_constant_new ("NULL")));
			(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
			_tmp9_ = NULL;
			_tmp10_ = NULL;
			result = (_tmp10_ = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisvalid, (ValaCCodeExpression*) ccomma, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("NULL"))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), _tmp10_);
			(cisvalid == NULL) ? NULL : (cisvalid = (vala_ccode_node_unref (cisvalid), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			return result;
			(cisvalid == NULL) ? NULL : (cisvalid = (vala_ccode_node_unref (cisvalid), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
		} else {
			result = (ValaCCodeExpression*) ccall;
			return result;
		}
	}
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	_tmp11_ = NULL;
	_tmp12_ = NULL;
	cisnull = (_tmp12_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new ("NULL"))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL)), _tmp12_);
	if (vala_data_type_get_type_parameter (type) != NULL) {
		gboolean _tmp13_;
		ValaCCodeConstant* _tmp15_;
		ValaCCodeExpression* _tmp14_;
		ValaCCodeBinaryExpression* _tmp16_;
		ValaCCodeBinaryExpression* cunrefisnull;
		ValaCCodeBinaryExpression* _tmp17_;
		_tmp13_ = FALSE;
		if (!VALA_IS_CLASS (self->current_type_symbol)) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = vala_class_get_is_compact (self->current_class);
		}
		if (_tmp13_) {
			result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			(cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL));
			return result;
		}
		/* unref functions are optional for type parameters*/
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		_tmp16_ = NULL;
		cunrefisnull = (_tmp16_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp14_ = vala_ccode_base_module_get_destroy_func_expression (self, type, FALSE), (ValaCCodeExpression*) (_tmp15_ = vala_ccode_constant_new ("NULL"))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL)), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), _tmp16_);
		_tmp17_ = NULL;
		cisnull = (_tmp17_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) cunrefisnull), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), _tmp17_);
		(cunrefisnull == NULL) ? NULL : (cunrefisnull = (vala_ccode_node_unref (cunrefisnull), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ccomma = vala_ccode_comma_expression_new ();
	_tmp18_ = FALSE;
	if (vala_code_context_get_profile (self->priv->_context) == VALA_PROFILE_GOBJECT) {
		gboolean _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp19_ = FALSE;
		_tmp20_ = FALSE;
		_tmp21_ = FALSE;
		if (vala_data_type_get_data_type (type) == self->gstringbuilder_type) {
			_tmp21_ = TRUE;
		} else {
			_tmp21_ = vala_data_type_get_data_type (type) == self->garray_type;
		}
		if (_tmp21_) {
			_tmp20_ = TRUE;
		} else {
			_tmp20_ = vala_data_type_get_data_type (type) == self->gbytearray_type;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			_tmp19_ = vala_data_type_get_data_type (type) == self->gptrarray_type;
		}
		_tmp18_ = _tmp19_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ValaCCodeConstant* _tmp22_;
		_tmp22_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_constant_new ("TRUE")));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	} else {
		if (VALA_IS_ARRAY_TYPE (type)) {
			ValaArrayType* _tmp23_;
			ValaArrayType* array_type;
			_tmp23_ = NULL;
			array_type = (_tmp23_ = VALA_ARRAY_TYPE (type), (_tmp23_ == NULL) ? NULL : vala_code_node_ref (_tmp23_));
			if (vala_ccode_base_module_requires_destroy (self, vala_array_type_get_element_type (array_type))) {
				ValaCCodeExpression* csizeexpr;
				gboolean first;
				ValaStruct* _tmp29_;
				ValaTypeSymbol* _tmp28_;
				ValaStruct* st;
				gboolean _tmp30_;
				csizeexpr = NULL;
				first = TRUE;
				{
					gint dim;
					dim = 1;
					{
						gboolean _tmp24_;
						_tmp24_ = TRUE;
						while (TRUE) {
							if (!_tmp24_) {
								dim++;
							}
							_tmp24_ = FALSE;
							if (!(dim <= vala_array_type_get_rank (array_type))) {
								break;
							}
							if (first) {
								ValaCCodeExpression* _tmp25_;
								_tmp25_ = NULL;
								csizeexpr = (_tmp25_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp25_);
								first = FALSE;
							} else {
								ValaCCodeExpression* _tmp27_;
								ValaCCodeExpression* _tmp26_;
								_tmp27_ = NULL;
								_tmp26_ = NULL;
								csizeexpr = (_tmp27_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, _tmp26_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim)), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp27_);
								(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
							}
						}
					}
				}
				_tmp29_ = NULL;
				_tmp28_ = NULL;
				st = (_tmp29_ = (_tmp28_ = vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)), VALA_IS_STRUCT (_tmp28_) ? ((ValaStruct*) _tmp28_) : NULL), (_tmp29_ == NULL) ? NULL : vala_code_node_ref (_tmp29_));
				_tmp30_ = FALSE;
				if (st != NULL) {
					_tmp30_ = !vala_data_type_get_nullable (vala_array_type_get_element_type (array_type));
				} else {
					_tmp30_ = FALSE;
				}
				if (_tmp30_) {
					ValaCCodeIdentifier* _tmp32_;
					char* _tmp31_;
					_tmp32_ = NULL;
					_tmp31_ = NULL;
					vala_ccode_function_call_set_call (ccall, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_identifier_new (_tmp31_ = vala_ccode_base_module_append_struct_array_free (self, st))));
					(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
					_tmp31_ = (g_free (_tmp31_), NULL);
					vala_ccode_function_call_add_argument (ccall, csizeexpr);
				} else {
					ValaCCodeIdentifier* _tmp33_;
					ValaCCodeCastExpression* _tmp35_;
					ValaCCodeExpression* _tmp34_;
					self->requires_array_free = TRUE;
					_tmp33_ = NULL;
					vala_ccode_function_call_set_call (ccall, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_identifier_new ("_vala_array_free")));
					(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
					vala_ccode_function_call_add_argument (ccall, csizeexpr);
					_tmp35_ = NULL;
					_tmp34_ = NULL;
					vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_cast_expression_new (_tmp34_ = vala_ccode_base_module_get_destroy_func_expression (self, vala_array_type_get_element_type (array_type), FALSE), "GDestroyNotify")));
					(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
					(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
				}
				(csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL));
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		}
	}
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
	_tmp36_ = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_constant_new ("NULL")));
	(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
	cassign = vala_ccode_assignment_new (cvar, (ValaCCodeExpression*) ccomma, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp37_ = FALSE;
	_tmp38_ = FALSE;
	if (vala_data_type_get_data_type (type) != NULL) {
		_tmp38_ = !vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (type));
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		char* _tmp39_;
		_tmp39_ = NULL;
		_tmp37_ = _vala_strcmp0 (_tmp39_ = vala_typesymbol_get_free_function (vala_data_type_get_data_type (type)), "g_free") == 0;
		_tmp39_ = (g_free (_tmp39_), NULL);
	} else {
		_tmp37_ = FALSE;
	}
	/* g_free (NULL) is allowed*/
	uses_gfree = _tmp37_;
	_tmp40_ = FALSE;
	if (uses_gfree) {
		_tmp40_ = TRUE;
	} else {
		_tmp40_ = VALA_IS_ARRAY_TYPE (type);
	}
	uses_gfree = _tmp40_;
	if (uses_gfree) {
		result = (ValaCCodeExpression*) cassign;
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		(cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
		return result;
	}
	_tmp41_ = NULL;
	_tmp42_ = NULL;
	result = (_tmp42_ = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_constant_new ("NULL")), (ValaCCodeExpression*) cassign), (_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL)), _tmp42_);
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL));
	(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	(cassign == NULL) ? NULL : (cassign = (vala_ccode_node_unref (cassign), NULL));
	return result;
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL));
	(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	(cassign == NULL) ? NULL : (cassign = (vala_ccode_node_unref (cassign), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_unref_expression (self, cvar, type, expr);
}


static void vala_ccode_base_module_real_visit_end_full_expression (ValaCCodeModule* base, ValaExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaDataType* _tmp0_;
	ValaDataType* expr_type;
	ValaLocalVariable* full_expr_var;
	ValaCCodeCommaExpression* expr_list;
	ValaCCodeAssignment* _tmp4_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeExpression* _tmp7_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	gee_collection_clear ((GeeCollection*) expr->temp_vars);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) self->temp_vars);
		while (TRUE) {
			ValaLocalVariable* local;
			if (!gee_iterator_next (_local_it)) {
				break;
			}
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			gee_collection_add ((GeeCollection*) expr->temp_vars, local);
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	gee_collection_clear ((GeeCollection*) self->temp_vars);
	if (gee_collection_get_size ((GeeCollection*) GEE_LIST (self->temp_ref_vars)) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	_tmp0_ = NULL;
	expr_type = (_tmp0_ = vala_expression_get_value_type (expr), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	if (vala_expression_get_target_type (expr) != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp1_;
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		expr_type = (_tmp2_ = (_tmp1_ = vala_expression_get_target_type (expr), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_)), (expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL)), _tmp2_);
	}
	full_expr_var = vala_ccode_base_module_get_temp_variable (self, expr_type, TRUE, (ValaCodeNode*) expr);
	gee_collection_add ((GeeCollection*) expr->temp_vars, full_expr_var);
	expr_list = vala_ccode_comma_expression_new ();
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_assignment_new (_tmp3_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) full_expr_var)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) self->temp_ref_vars);
		while (TRUE) {
			ValaLocalVariable* local;
			ValaMemberAccess* ma;
			ValaCCodeExpression* _tmp6_;
			ValaCCodeExpression* _tmp5_;
			if (!gee_iterator_next (_local_it)) {
				break;
			}
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			vala_ccode_comma_expression_append_expression (expr_list, _tmp6_ = vala_ccode_base_module_get_unref_expression (self, _tmp5_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma));
			(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
			(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	_tmp7_ = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, _tmp7_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) full_expr_var)));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) expr_list);
	gee_collection_clear ((GeeCollection*) self->temp_ref_vars);
	(expr_type == NULL) ? NULL : (expr_type = (vala_code_node_unref (expr_type), NULL));
	(full_expr_var == NULL) ? NULL : (full_expr_var = (vala_code_node_unref (full_expr_var), NULL));
	(expr_list == NULL) ? NULL : (expr_list = (vala_ccode_node_unref (expr_list), NULL));
}


void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cfrag != NULL);
	g_return_if_fail (temp_vars != NULL);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) temp_vars);
		while (TRUE) {
			ValaLocalVariable* local;
			gboolean _tmp0_;
			if (!gee_iterator_next (_local_it)) {
				break;
			}
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			_tmp0_ = FALSE;
			if (self->current_method != NULL) {
				_tmp0_ = vala_method_get_coroutine (self->current_method);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				char* _tmp1_;
				_tmp1_ = NULL;
				vala_ccode_struct_add_field (self->closure_struct, _tmp1_ = vala_data_type_get_cname (vala_local_variable_get_variable_type (local)), vala_symbol_get_name ((ValaSymbol*) local));
				_tmp1_ = (g_free (_tmp1_), NULL);
			} else {
				char* _tmp2_;
				ValaCCodeDeclaration* _tmp3_;
				ValaCCodeDeclaration* _cdecl_;
				char* _tmp4_;
				ValaCCodeVariableDeclarator* _tmp5_;
				ValaCCodeVariableDeclarator* vardecl;
				ValaStruct* _tmp7_;
				ValaTypeSymbol* _tmp6_;
				ValaStruct* st;
				ValaArrayType* _tmp9_;
				ValaDataType* _tmp8_;
				ValaArrayType* array_type;
				/* no initialization necessary, closure struct is zeroed*/
				_tmp2_ = NULL;
				_tmp3_ = NULL;
				_cdecl_ = (_tmp3_ = vala_ccode_declaration_new (_tmp2_ = vala_data_type_get_cname (vala_local_variable_get_variable_type (local))), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
				_tmp4_ = NULL;
				_tmp5_ = NULL;
				vardecl = (_tmp5_ = vala_ccode_variable_declarator_new (vala_symbol_get_name ((ValaSymbol*) local), NULL, _tmp4_ = vala_data_type_get_cdeclarator_suffix (vala_local_variable_get_variable_type (local))), _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_);
				/* sets #line*/
				vala_code_node_set_ccodenode ((ValaCodeNode*) local, (ValaCCodeNode*) vardecl);
				vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) vardecl);
				_tmp7_ = NULL;
				_tmp6_ = NULL;
				st = (_tmp7_ = (_tmp6_ = vala_data_type_get_data_type (vala_local_variable_get_variable_type (local)), VALA_IS_STRUCT (_tmp6_) ? ((ValaStruct*) _tmp6_) : NULL), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
				_tmp9_ = NULL;
				_tmp8_ = NULL;
				array_type = (_tmp9_ = (_tmp8_ = vala_local_variable_get_variable_type (local), VALA_IS_ARRAY_TYPE (_tmp8_) ? ((ValaArrayType*) _tmp8_) : NULL), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_));
				if (g_str_has_prefix (vala_symbol_get_name ((ValaSymbol*) local), "*")) {
				} else {
					gboolean _tmp10_;
					gboolean _tmp11_;
					_tmp10_ = FALSE;
					_tmp11_ = FALSE;
					if (!vala_data_type_get_nullable (vala_local_variable_get_variable_type (local))) {
						gboolean _tmp12_;
						_tmp12_ = FALSE;
						if (st != NULL) {
							_tmp12_ = !vala_struct_is_simple_type (st);
						} else {
							_tmp12_ = FALSE;
						}
						_tmp11_ = _tmp12_;
					} else {
						_tmp11_ = FALSE;
					}
					if (_tmp11_) {
						_tmp10_ = TRUE;
					} else {
						gboolean _tmp13_;
						_tmp13_ = FALSE;
						if (array_type != NULL) {
							_tmp13_ = vala_array_type_get_fixed_length (array_type);
						} else {
							_tmp13_ = FALSE;
						}
						_tmp10_ = _tmp13_;
					}
					if (_tmp10_) {
						ValaCCodeInitializerList* clist;
						ValaCCodeConstant* _tmp14_;
						/* 0-initialize struct with struct initializer { 0 }
						 necessary as they will be passed by reference*/
						clist = vala_ccode_initializer_list_new ();
						_tmp14_ = NULL;
						vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_constant_new ("0")));
						(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
						vala_ccode_variable_declarator_set_initializer (vardecl, (ValaCCodeExpression*) clist);
						(clist == NULL) ? NULL : (clist = (vala_ccode_node_unref (clist), NULL));
					} else {
						gboolean _tmp15_;
						_tmp15_ = FALSE;
						if (vala_data_type_is_reference_type_or_type_parameter (vala_local_variable_get_variable_type (local))) {
							_tmp15_ = TRUE;
						} else {
							_tmp15_ = vala_data_type_get_nullable (vala_local_variable_get_variable_type (local));
						}
						if (_tmp15_) {
							ValaCCodeConstant* _tmp16_;
							_tmp16_ = NULL;
							vala_ccode_variable_declarator_set_initializer (vardecl, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_constant_new ("NULL")));
							(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
						}
					}
				}
				vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) _cdecl_);
				(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
				(vardecl == NULL) ? NULL : (vardecl = (vala_ccode_node_unref (vardecl), NULL));
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
}


static void vala_ccode_base_module_real_visit_expression_statement (ValaCCodeModule* base, ValaExpressionStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpressionStatement* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaCCodeFragment* cfrag;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_code_node_get_error ((ValaCodeNode*) vala_expression_statement_get_expression (stmt))) {
		vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
		return;
	}
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp0_ = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_expression_statement_get_expression (stmt))))));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp1_ = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp1_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_expression_statement_get_expression (stmt));
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_expression_statement_get_expression (stmt), cfrag);
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	}
	_tmp2_ = FALSE;
	if (gee_collection_get_size ((GeeCollection*) GEE_LIST (self->temp_vars)) == 0) {
		_tmp2_ = self->pre_statement_fragment == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	/* free temporary objects */
	if (_tmp2_) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl (self, cfrag, (GeeList*) self->temp_vars);
	if (self->pre_statement_fragment != NULL) {
		ValaCCodeFragment* _tmp3_;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) self->pre_statement_fragment);
		_tmp3_ = NULL;
		self->pre_statement_fragment = (_tmp3_ = NULL, (self->pre_statement_fragment == NULL) ? NULL : (self->pre_statement_fragment = (vala_ccode_node_unref (self->pre_statement_fragment), NULL)), _tmp3_);
	}
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) self->temp_ref_vars);
		while (TRUE) {
			ValaLocalVariable* local;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp6_;
			ValaCCodeExpression* _tmp5_;
			ValaCCodeIdentifier* _tmp4_;
			if (!gee_iterator_next (_local_it)) {
				break;
			}
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			_tmp4_ = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp6_ = vala_ccode_expression_statement_new (_tmp5_ = vala_ccode_base_module_get_unref_expression (self, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) local))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
			(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
			(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
			(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	gee_collection_clear ((GeeCollection*) self->temp_vars);
	gee_collection_clear ((GeeCollection*) self->temp_ref_vars);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


void vala_ccode_base_module_create_temp_decl (ValaCCodeBaseModule* self, ValaStatement* stmt, GeeList* temp_vars) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (temp_vars != NULL);
	/* declare temporary variables */
	if (gee_collection_get_size ((GeeCollection*) temp_vars) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl (self, cfrag, temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_ccode_base_module_real_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop) {
	ValaBlock* _tmp0_;
	ValaBlock* b;
	GeeList* local_vars;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (cfrag != NULL);
	_tmp0_ = NULL;
	b = (_tmp0_ = VALA_BLOCK (sym), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (TRUE) {
			ValaLocalVariable* local;
			gboolean _tmp1_;
			gboolean _tmp2_;
			if (!gee_iterator_next (_local_it)) {
				break;
			}
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			_tmp1_ = FALSE;
			_tmp2_ = FALSE;
			if (vala_symbol_get_active ((ValaSymbol*) local)) {
				_tmp2_ = !vala_local_variable_get_floating (local);
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				_tmp1_ = vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local));
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp5_;
				ValaCCodeExpression* _tmp4_;
				ValaCCodeExpression* _tmp3_;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp5_ = NULL;
				_tmp4_ = NULL;
				_tmp3_ = NULL;
				vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp5_ = vala_ccode_expression_statement_new (_tmp4_ = vala_ccode_base_module_get_unref_expression (self, _tmp3_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
				(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
				(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
				(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	if (stop_at_loop) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = FALSE;
		_tmp7_ = FALSE;
		if (VALA_IS_LOOP (vala_code_node_get_parent_node ((ValaCodeNode*) b))) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = VALA_IS_FOREACH_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b));
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = VALA_IS_SWITCH_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) b));
		}
		if (_tmp6_) {
			(b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL));
			(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
			return;
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		vala_ccode_base_module_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			vala_ccode_base_module_append_param_free (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), cfrag);
		}
	}
	(b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL));
	(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
}


void vala_ccode_base_module_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->append_local_free (self, sym, cfrag, stop_at_loop);
}


void vala_ccode_base_module_append_error_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, ValaTryStatement* current_try) {
	ValaBlock* _tmp0_;
	ValaBlock* b;
	GeeList* local_vars;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (cfrag != NULL);
	g_return_if_fail (current_try != NULL);
	_tmp0_ = NULL;
	b = (_tmp0_ = VALA_BLOCK (sym), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	local_vars = vala_block_get_local_variables (b);
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) local_vars);
		while (TRUE) {
			ValaLocalVariable* local;
			gboolean _tmp1_;
			gboolean _tmp2_;
			if (!gee_iterator_next (_local_it)) {
				break;
			}
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			_tmp1_ = FALSE;
			_tmp2_ = FALSE;
			if (vala_symbol_get_active ((ValaSymbol*) local)) {
				_tmp2_ = !vala_local_variable_get_floating (local);
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				_tmp1_ = vala_ccode_base_module_requires_destroy (self, vala_local_variable_get_variable_type (local));
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp5_;
				ValaCCodeExpression* _tmp4_;
				ValaCCodeExpression* _tmp3_;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
				_tmp5_ = NULL;
				_tmp4_ = NULL;
				_tmp3_ = NULL;
				vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp5_ = vala_ccode_expression_statement_new (_tmp4_ = vala_ccode_base_module_get_unref_expression (self, _tmp3_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) local)), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
				(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
				(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
				(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	if (sym == VALA_SYMBOL (vala_try_statement_get_body (current_try))) {
		(b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL));
		(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
		return;
	}
	if (VALA_IS_BLOCK (vala_symbol_get_parent_symbol (sym))) {
		vala_ccode_base_module_append_error_free (self, vala_symbol_get_parent_symbol (sym), cfrag, current_try);
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (sym))) {
			vala_ccode_base_module_append_param_free (self, VALA_METHOD (vala_symbol_get_parent_symbol (sym)), cfrag);
		}
	}
	(b == NULL) ? NULL : (b = (vala_code_node_unref (b), NULL));
	(local_vars == NULL) ? NULL : (local_vars = (gee_collection_object_unref (local_vars), NULL));
}


static void vala_ccode_base_module_append_param_free (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFragment* cfrag) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (cfrag != NULL);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _param_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_param_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_method_get_parameters (m))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaFormalParameter* param;
			gboolean _tmp2_;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp2_ = FALSE;
			if (vala_ccode_base_module_requires_destroy (self, vala_formal_parameter_get_parameter_type (param))) {
				_tmp2_ = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				ValaMemberAccess* ma;
				ValaCCodeExpressionStatement* _tmp5_;
				ValaCCodeExpression* _tmp4_;
				ValaCCodeExpression* _tmp3_;
				ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) param), NULL);
				vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) param);
				_tmp5_ = NULL;
				_tmp4_ = NULL;
				_tmp3_ = NULL;
				vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp5_ = vala_ccode_expression_statement_new (_tmp4_ = vala_ccode_base_module_get_unref_expression (self, _tmp3_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) param)), vala_formal_parameter_get_parameter_type (param), (ValaExpression*) ma))));
				(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
				(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
				(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
				(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
}


void vala_ccode_base_module_create_local_free (ValaCCodeBaseModule* self, ValaCodeNode* stmt, gboolean stop_at_loop) {
	ValaCCodeFragment* cfrag;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free (self, self->current_symbol, cfrag, stop_at_loop);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (stmt));
	vala_code_node_set_ccodenode (stmt, (ValaCCodeNode*) cfrag);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static gboolean vala_ccode_base_module_real_variable_accessible_in_finally (ValaCCodeBaseModule* self, ValaLocalVariable* local) {
	gboolean result;
	ValaSymbol* _tmp0_;
	ValaSymbol* sym;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (local != NULL, FALSE);
	if (self->current_try == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = NULL;
	sym = (_tmp0_ = self->current_symbol, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp6_;
		_tmp1_ = FALSE;
		if (!VALA_IS_METHOD (sym)) {
			ValaSymbol* _tmp2_;
			_tmp2_ = NULL;
			_tmp1_ = (_tmp2_ = vala_scope_lookup (vala_symbol_get_scope (sym), vala_symbol_get_name ((ValaSymbol*) local))) == NULL;
			(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL));
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp3_ = FALSE;
		_tmp4_ = FALSE;
		if (VALA_IS_TRY_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) sym))) {
			_tmp4_ = vala_try_statement_get_finally_body (VALA_TRY_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) sym))) != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_;
			_tmp5_ = FALSE;
			if (VALA_IS_CATCH_CLAUSE (vala_code_node_get_parent_node ((ValaCodeNode*) sym))) {
				_tmp5_ = vala_try_statement_get_finally_body (VALA_TRY_STATEMENT (vala_code_node_get_parent_node (vala_code_node_get_parent_node ((ValaCodeNode*) sym)))) != NULL;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp3_ = _tmp5_;
		}
		if (_tmp3_) {
			result = TRUE;
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			return result;
		}
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		sym = (_tmp7_ = (_tmp6_ = vala_symbol_get_parent_symbol (sym), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp7_);
	}
	result = FALSE;
	(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
	return result;
}


gboolean vala_ccode_base_module_variable_accessible_in_finally (ValaCCodeBaseModule* self, ValaLocalVariable* local) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->variable_accessible_in_finally (self, local);
}


static void vala_ccode_base_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	/* avoid unnecessary ref/unref pair*/
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		ValaLocalVariable* _tmp1_;
		ValaSymbol* _tmp0_;
		ValaLocalVariable* local;
		gboolean _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		local = (_tmp1_ = (_tmp0_ = vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)), VALA_IS_LOCAL_VARIABLE (_tmp0_) ? ((ValaLocalVariable*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		_tmp2_ = FALSE;
		_tmp3_ = FALSE;
		_tmp4_ = FALSE;
		if (vala_data_type_get_value_owned (self->current_return_type)) {
			_tmp4_ = local != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_tmp3_ = vala_data_type_get_value_owned (vala_local_variable_get_variable_type (local));
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = !vala_ccode_base_module_variable_accessible_in_finally (self, local);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			/* return expression is local variable taking ownership and
			 * current method is transferring ownership 
			 don't ref expression*/
			vala_data_type_set_value_owned (vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)), TRUE);
		}
		(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeFragment* cfrag;
		ValaCCodeReturnStatement* _tmp8_;
		cfrag = vala_ccode_fragment_new ();
		/* free local variables*/
		vala_ccode_base_module_append_local_free (self, self->current_symbol, cfrag, FALSE);
		if (self->current_method != NULL) {
			/* check postconditions*/
			{
				GeeList* _tmp5_;
				GeeIterator* _tmp6_;
				GeeIterator* _postcondition_it;
				/* check postconditions*/
				_tmp5_ = NULL;
				_tmp6_ = NULL;
				_postcondition_it = (_tmp6_ = gee_iterable_iterator ((GeeIterable*) (_tmp5_ = vala_method_get_postconditions (self->current_method))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (gee_collection_object_unref (_tmp5_), NULL)), _tmp6_);
				/* check postconditions*/
				while (TRUE) {
					ValaExpression* postcondition;
					ValaCCodeStatement* _tmp7_;
					/* check postconditions*/
					if (!gee_iterator_next (_postcondition_it)) {
						/* check postconditions*/
						break;
					}
					/* check postconditions*/
					postcondition = (ValaExpression*) gee_iterator_get (_postcondition_it);
					_tmp7_ = NULL;
					vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp7_ = vala_ccode_base_module_create_postcondition_statement (self, postcondition)));
					(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
					(postcondition == NULL) ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL));
				}
				(_postcondition_it == NULL) ? NULL : (_postcondition_it = (gee_collection_object_unref (_postcondition_it), NULL));
			}
		}
		_tmp8_ = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp8_ = vala_ccode_return_statement_new (NULL)));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	} else {
		ValaSymbol* return_expression_symbol;
		ValaLocalVariable* _tmp10_;
		ValaSymbol* _tmp9_;
		ValaLocalVariable* local;
		gboolean _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		ValaCCodeFragment* cfrag;
		ValaCCodeExpressionStatement* _tmp40_;
		ValaCCodeAssignment* _tmp39_;
		ValaCCodeIdentifier* _tmp38_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		_tmp10_ = NULL;
		_tmp9_ = NULL;
		local = (_tmp10_ = (_tmp9_ = vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)), VALA_IS_LOCAL_VARIABLE (_tmp9_) ? ((ValaLocalVariable*) _tmp9_) : NULL), (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_));
		_tmp11_ = FALSE;
		_tmp12_ = FALSE;
		_tmp13_ = FALSE;
		if (vala_data_type_get_value_owned (self->current_return_type)) {
			_tmp13_ = local != NULL;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			_tmp12_ = vala_data_type_get_value_owned (vala_local_variable_get_variable_type (local));
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			_tmp11_ = !vala_ccode_base_module_variable_accessible_in_finally (self, local);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp14_;
			/* return expression is local variable taking ownership and
			 * current method is transferring ownership 
			 don't unref variable*/
			_tmp15_ = NULL;
			_tmp14_ = NULL;
			return_expression_symbol = (_tmp15_ = (_tmp14_ = (ValaSymbol*) local, (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_)), (return_expression_symbol == NULL) ? NULL : (return_expression_symbol = (vala_code_node_unref (return_expression_symbol), NULL)), _tmp15_);
			vala_symbol_set_active (return_expression_symbol, FALSE);
		}
		_tmp16_ = FALSE;
		_tmp17_ = FALSE;
		_tmp18_ = FALSE;
		if (self->current_method != NULL) {
			_tmp18_ = !vala_method_get_no_array_length (self->current_method);
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = self->current_property_accessor != NULL;
		}
		if (_tmp17_) {
			_tmp16_ = VALA_IS_ARRAY_TYPE (self->current_return_type);
		} else {
			_tmp16_ = FALSE;
		}
		/* return array length if appropriate*/
		if (_tmp16_) {
			ValaLocalVariable* return_expr_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp20_;
			ValaCCodeExpression* _tmp19_;
			ValaArrayType* _tmp21_;
			ValaArrayType* array_type;
			ValaCCodeExpression* _tmp27_;
			return_expr_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)), TRUE, (ValaCodeNode*) stmt);
			ccomma = vala_ccode_comma_expression_new ();
			_tmp20_ = NULL;
			_tmp19_ = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_assignment_new (_tmp19_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) return_expr_decl)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
			(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
			_tmp21_ = NULL;
			array_type = (_tmp21_ = VALA_ARRAY_TYPE (self->current_return_type), (_tmp21_ == NULL) ? NULL : vala_code_node_ref (_tmp21_));
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp22_;
					_tmp22_ = TRUE;
					while (TRUE) {
						ValaCCodeIdentifier* _tmp24_;
						char* _tmp23_;
						ValaCCodeUnaryExpression* _tmp25_;
						ValaCCodeUnaryExpression* len_l;
						ValaCCodeExpression* len_r;
						ValaCCodeAssignment* _tmp26_;
						if (!_tmp22_) {
							dim++;
						}
						_tmp22_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (array_type))) {
							break;
						}
						_tmp24_ = NULL;
						_tmp23_ = NULL;
						_tmp25_ = NULL;
						len_l = (_tmp25_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new (_tmp23_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim)))), (_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL)), _tmp23_ = (g_free (_tmp23_), NULL), _tmp25_);
						len_r = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_return_statement_get_return_expression (stmt), dim);
						_tmp26_ = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_assignment_new ((ValaCCodeExpression*) len_l, len_r, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
						(len_l == NULL) ? NULL : (len_l = (vala_ccode_node_unref (len_l), NULL));
						(len_r == NULL) ? NULL : (len_r = (vala_ccode_node_unref (len_r), NULL));
					}
				}
			}
			_tmp27_ = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, _tmp27_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) return_expr_decl)));
			(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
			vala_code_node_set_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt), (ValaCCodeNode*) ccomma);
			gee_collection_add ((GeeCollection*) vala_return_statement_get_return_expression (stmt)->temp_vars, return_expr_decl);
			(return_expr_decl == NULL) ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		} else {
			gboolean _tmp28_;
			gboolean _tmp29_;
			_tmp28_ = FALSE;
			_tmp29_ = FALSE;
			if (self->current_method != NULL) {
				_tmp29_ = TRUE;
			} else {
				_tmp29_ = self->current_property_accessor != NULL;
			}
			if (_tmp29_) {
				_tmp28_ = VALA_IS_DELEGATE_TYPE (self->current_return_type);
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				ValaDelegateType* _tmp30_;
				ValaDelegateType* delegate_type;
				_tmp30_ = NULL;
				delegate_type = (_tmp30_ = VALA_DELEGATE_TYPE (self->current_return_type), (_tmp30_ == NULL) ? NULL : vala_code_node_ref (_tmp30_));
				if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
					ValaLocalVariable* return_expr_decl;
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeAssignment* _tmp32_;
					ValaCCodeExpression* _tmp31_;
					ValaCCodeIdentifier* _tmp34_;
					char* _tmp33_;
					ValaCCodeUnaryExpression* _tmp35_;
					ValaCCodeUnaryExpression* len_l;
					ValaCCodeExpression* len_r;
					ValaCCodeAssignment* _tmp36_;
					ValaCCodeExpression* _tmp37_;
					return_expr_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)), TRUE, (ValaCodeNode*) stmt);
					ccomma = vala_ccode_comma_expression_new ();
					_tmp32_ = NULL;
					_tmp31_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp32_ = vala_ccode_assignment_new (_tmp31_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) return_expr_decl)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
					(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
					_tmp34_ = NULL;
					_tmp33_ = NULL;
					_tmp35_ = NULL;
					len_l = (_tmp35_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new (_tmp33_ = vala_ccode_base_module_get_delegate_target_cname (self, "result")))), (_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL)), _tmp33_ = (g_free (_tmp33_), NULL), _tmp35_);
					len_r = vala_ccode_base_module_get_delegate_target_cexpression (self, vala_return_statement_get_return_expression (stmt));
					_tmp36_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_assignment_new ((ValaCCodeExpression*) len_l, len_r, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
					_tmp37_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, _tmp37_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) return_expr_decl)));
					(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
					vala_code_node_set_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt), (ValaCCodeNode*) ccomma);
					gee_collection_add ((GeeCollection*) vala_return_statement_get_return_expression (stmt)->temp_vars, return_expr_decl);
					(return_expr_decl == NULL) ? NULL : (return_expr_decl = (vala_code_node_unref (return_expr_decl), NULL));
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(len_l == NULL) ? NULL : (len_l = (vala_ccode_node_unref (len_l), NULL));
					(len_r == NULL) ? NULL : (len_r = (vala_ccode_node_unref (len_r), NULL));
				}
				(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
			}
		}
		cfrag = vala_ccode_fragment_new ();
		/* assign method result to `result'*/
		_tmp40_ = NULL;
		_tmp39_ = NULL;
		_tmp38_ = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp40_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp39_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new ("result")), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
		(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		/* free local variables*/
		vala_ccode_base_module_append_local_free (self, self->current_symbol, cfrag, FALSE);
		if (self->current_method != NULL) {
			/* check postconditions*/
			{
				GeeList* _tmp41_;
				GeeIterator* _tmp42_;
				GeeIterator* _postcondition_it;
				/* check postconditions*/
				_tmp41_ = NULL;
				_tmp42_ = NULL;
				_postcondition_it = (_tmp42_ = gee_iterable_iterator ((GeeIterable*) (_tmp41_ = vala_method_get_postconditions (self->current_method))), (_tmp41_ == NULL) ? NULL : (_tmp41_ = (gee_collection_object_unref (_tmp41_), NULL)), _tmp42_);
				/* check postconditions*/
				while (TRUE) {
					ValaExpression* postcondition;
					ValaCCodeStatement* _tmp43_;
					/* check postconditions*/
					if (!gee_iterator_next (_postcondition_it)) {
						/* check postconditions*/
						break;
					}
					/* check postconditions*/
					postcondition = (ValaExpression*) gee_iterator_get (_postcondition_it);
					_tmp43_ = NULL;
					vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp43_ = vala_ccode_base_module_create_postcondition_statement (self, postcondition)));
					(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
					(postcondition == NULL) ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL));
				}
				(_postcondition_it == NULL) ? NULL : (_postcondition_it = (gee_collection_object_unref (_postcondition_it), NULL));
			}
		}
		_tmp44_ = FALSE;
		_tmp45_ = FALSE;
		if (self->current_property_accessor != NULL) {
			_tmp45_ = vala_property_accessor_get_readable (self->current_property_accessor);
		} else {
			_tmp45_ = FALSE;
		}
		if (_tmp45_) {
			_tmp44_ = vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (self->current_property_accessor)));
		} else {
			_tmp44_ = FALSE;
		}
		/* Property getters of non simple structs shall return the struct value as out parameter,
		 therefore replace any return statement with an assignment statement to the out formal
		 paramenter and insert an empty return statement afterwards.*/
		if (_tmp44_) {
			ValaCCodeExpressionStatement* _tmp49_;
			ValaCCodeAssignment* _tmp48_;
			ValaCCodeIdentifier* _tmp47_;
			ValaCCodeIdentifier* _tmp46_;
			ValaCCodeReturnStatement* _tmp50_;
			_tmp49_ = NULL;
			_tmp48_ = NULL;
			_tmp47_ = NULL;
			_tmp46_ = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp49_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp48_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new ("*value")), (ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new ("result")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
			(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
			(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
			(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
			_tmp50_ = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp50_ = vala_ccode_return_statement_new (NULL)));
			(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
		} else {
			ValaCCodeReturnStatement* _tmp52_;
			ValaCCodeIdentifier* _tmp51_;
			_tmp52_ = NULL;
			_tmp51_ = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp52_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new ("result")))));
			(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
			(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
		}
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		vala_ccode_base_module_create_temp_decl (self, (ValaStatement*) stmt, (GeeList*) vala_return_statement_get_return_expression (stmt)->temp_vars);
		if (return_expression_symbol != NULL) {
			vala_symbol_set_active (return_expression_symbol, TRUE);
		}
		(return_expression_symbol == NULL) ? NULL : (return_expression_symbol = (vala_code_node_unref (return_expression_symbol), NULL));
		(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	}
}


char* vala_ccode_base_module_get_symbol_lock_name (ValaCCodeBaseModule* self, const char* symname) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symname != NULL, NULL);
	result = g_strdup_printf ("__lock_%s", symname);
	return result;
}


static void vala_ccode_base_module_real_visit_lock_statement (ValaCCodeModule* base, ValaLockStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaCCodeFragment* cn;
	ValaCCodeExpression* l;
	ValaCCodeFunctionCall* fc;
	ValaExpression* _tmp0_;
	ValaExpression* inner_node;
	ValaMember* _tmp1_;
	ValaMember* member;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* parent;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeIdentifier* _tmp22_;
	char* _tmp21_;
	ValaMethod* _tmp20_;
	ValaCCodeUnaryExpression* _tmp24_;
	ValaCCodeExpressionStatement* _tmp25_;
	ValaCCodeFunctionCall* _tmp29_;
	ValaCCodeIdentifier* _tmp28_;
	char* _tmp27_;
	ValaMethod* _tmp26_;
	ValaCCodeUnaryExpression* _tmp30_;
	ValaCCodeExpressionStatement* _tmp31_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	cn = vala_ccode_fragment_new ();
	l = NULL;
	fc = NULL;
	_tmp0_ = NULL;
	inner_node = (_tmp0_ = vala_member_access_get_inner (VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt))), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	_tmp1_ = NULL;
	member = (_tmp1_ = VALA_MEMBER (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = NULL;
	parent = (_tmp2_ = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	if (vala_symbol_is_instance_member ((ValaSymbol*) member)) {
		ValaCCodeExpression* _tmp9_;
		char* _tmp8_;
		ValaCCodeMemberAccess* _tmp7_;
		if (inner_node == NULL) {
			ValaCCodeExpression* _tmp3_;
			_tmp3_ = NULL;
			l = (_tmp3_ = (ValaCCodeExpression*) vala_ccode_identifier_new ("self"), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp3_);
		} else {
			if (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))) != VALA_SYMBOL (self->current_type_symbol)) {
				ValaCCodeExpression* _tmp4_;
				_tmp4_ = NULL;
				l = (_tmp4_ = (ValaCCodeExpression*) vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) inner_node)), parent), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp4_);
			} else {
				ValaCCodeExpression* _tmp6_;
				ValaCCodeExpression* _tmp5_;
				_tmp6_ = NULL;
				_tmp5_ = NULL;
				l = (_tmp6_ = (_tmp5_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) inner_node)), (_tmp5_ == NULL) ? NULL : vala_ccode_node_ref (_tmp5_)), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp6_);
			}
		}
		_tmp9_ = NULL;
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		l = (_tmp9_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_member_access_new_pointer (l, "priv")), _tmp8_ = vala_ccode_base_module_get_symbol_lock_name (self, vala_symbol_get_name (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp9_);
		_tmp8_ = (g_free (_tmp8_), NULL);
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	} else {
		if (vala_symbol_is_class_member ((ValaSymbol*) member)) {
			ValaCCodeExpression* _tmp13_;
			char* _tmp12_;
			char* _tmp11_;
			char* _tmp10_;
			ValaCCodeExpression* _tmp15_;
			char* _tmp14_;
			_tmp13_ = NULL;
			_tmp12_ = NULL;
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			l = (_tmp13_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp12_ = g_strdup_printf ("%s_GET_CLASS_PRIVATE(%s)", _tmp10_ = vala_typesymbol_get_upper_case_cname (parent, NULL), _tmp11_ = vala_typesymbol_get_type_id (parent))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp13_);
			_tmp12_ = (g_free (_tmp12_), NULL);
			_tmp11_ = (g_free (_tmp11_), NULL);
			_tmp10_ = (g_free (_tmp10_), NULL);
			_tmp15_ = NULL;
			_tmp14_ = NULL;
			l = (_tmp15_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (l, _tmp14_ = vala_ccode_base_module_get_symbol_lock_name (self, vala_symbol_get_name (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp15_);
			_tmp14_ = (g_free (_tmp14_), NULL);
		} else {
			char* _tmp16_;
			char* _tmp17_;
			char* lock_name;
			ValaCCodeExpression* _tmp19_;
			char* _tmp18_;
			_tmp16_ = NULL;
			_tmp17_ = NULL;
			lock_name = (_tmp17_ = g_strdup_printf ("%s_%s", _tmp16_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) parent, NULL), vala_symbol_get_name (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))), _tmp16_ = (g_free (_tmp16_), NULL), _tmp17_);
			_tmp19_ = NULL;
			_tmp18_ = NULL;
			l = (_tmp19_ = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp18_ = vala_ccode_base_module_get_symbol_lock_name (self, lock_name)), (l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL)), _tmp19_);
			_tmp18_ = (g_free (_tmp18_), NULL);
			lock_name = (g_free (lock_name), NULL);
		}
	}
	_tmp23_ = NULL;
	_tmp22_ = NULL;
	_tmp21_ = NULL;
	_tmp20_ = NULL;
	fc = (_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new (_tmp21_ = vala_method_get_cname (_tmp20_ = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) self->mutex_type), "lock")))))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp23_);
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp21_ = (g_free (_tmp21_), NULL);
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_code_node_unref (_tmp20_), NULL));
	_tmp24_ = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
	_tmp25_ = NULL;
	vala_ccode_fragment_append (cn, (ValaCCodeNode*) (_tmp25_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_lock_statement_get_body (stmt)));
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	_tmp26_ = NULL;
	fc = (_tmp29_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new (_tmp27_ = vala_method_get_cname (_tmp26_ = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) self->mutex_type), "unlock")))))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp29_);
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	_tmp27_ = (g_free (_tmp27_), NULL);
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_code_node_unref (_tmp26_), NULL));
	_tmp30_ = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, l)));
	(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	_tmp31_ = NULL;
	vala_ccode_fragment_append (cn, (ValaCCodeNode*) (_tmp31_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cn);
	(cn == NULL) ? NULL : (cn = (vala_ccode_node_unref (cn), NULL));
	(l == NULL) ? NULL : (l = (vala_ccode_node_unref (l), NULL));
	(fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL));
	(inner_node == NULL) ? NULL : (inner_node = (vala_code_node_unref (inner_node), NULL));
	(member == NULL) ? NULL : (member = (vala_code_node_unref (member), NULL));
	(parent == NULL) ? NULL : (parent = (vala_code_node_unref (parent), NULL));
}


static void vala_ccode_base_module_real_visit_delete_statement (ValaCCodeModule* base, ValaDeleteStatement* stmt) {
	ValaCCodeBaseModule * self;
	ValaPointerType* _tmp0_;
	ValaPointerType* pointer_type;
	ValaDataType* _tmp1_;
	ValaDataType* type;
	gboolean _tmp2_;
	ValaCCodeExpression* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpressionStatement* _tmp7_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0_ = NULL;
	pointer_type = (_tmp0_ = VALA_POINTER_TYPE (vala_expression_get_value_type (vala_delete_statement_get_expression (stmt))), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	_tmp1_ = NULL;
	type = (_tmp1_ = (ValaDataType*) pointer_type, (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (vala_data_type_get_data_type (vala_pointer_type_get_base_type (pointer_type)) != NULL) {
		_tmp2_ = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (vala_pointer_type_get_base_type (pointer_type)));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp3_;
		_tmp4_ = NULL;
		_tmp3_ = NULL;
		type = (_tmp4_ = (_tmp3_ = vala_pointer_type_get_base_type (pointer_type), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp4_);
	}
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	ccall = (_tmp6_ = vala_ccode_function_call_new (_tmp5_ = vala_ccode_base_module_get_destroy_func_expression (self, type, FALSE)), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp6_);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_delete_statement_get_expression (stmt))));
	_tmp7_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp7_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	(pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL));
	(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_ccode_base_module_real_visit_expression (ValaCCodeModule* base, ValaExpression* expr) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = FALSE;
	if (vala_code_node_get_ccodenode ((ValaCodeNode*) expr) != NULL) {
		_tmp0_ = !vala_expression_get_lvalue (expr);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp1_;
		ValaCCodeExpression* _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = FALSE;
		if (VALA_IS_GENERIC_TYPE (vala_expression_get_formal_value_type (expr))) {
			_tmp1_ = !VALA_IS_GENERIC_TYPE (vala_expression_get_value_type (expr));
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			if (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_data_type_get_type_parameter (vala_expression_get_formal_value_type (expr))) != VALA_SYMBOL (self->garray_type)) {
				ValaCCodeExpression* _tmp2_;
				/* GArray doesn't use pointer-based generics*/
				_tmp2_ = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp2_ = vala_ccode_base_module_convert_from_generic_pointer (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_value_type (expr))));
				(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
			}
		}
		/* memory management, implicit casts, and boxing/unboxing*/
		_tmp3_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp3_ = vala_ccode_base_module_transform_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_value_type (expr), vala_expression_get_target_type (expr), expr)));
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
		_tmp4_ = FALSE;
		if (VALA_IS_GENERIC_TYPE (vala_expression_get_formal_target_type (expr))) {
			_tmp4_ = !VALA_IS_GENERIC_TYPE (vala_expression_get_target_type (expr));
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			if (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_data_type_get_type_parameter (vala_expression_get_formal_target_type (expr))) != VALA_SYMBOL (self->garray_type)) {
				ValaCCodeExpression* _tmp5_;
				/* GArray doesn't use pointer-based generics*/
				_tmp5_ = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp5_ = vala_ccode_base_module_convert_to_generic_pointer (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)), vala_expression_get_target_type (expr))));
				(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
			}
		}
	}
}


static void vala_ccode_base_module_real_visit_boolean_literal (ValaCCodeModule* base, ValaBooleanLiteral* expr) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	if (vala_code_context_get_profile (self->priv->_context) == VALA_PROFILE_GOBJECT) {
		const char* _tmp0_;
		ValaCCodeConstant* _tmp1_;
		_tmp0_ = NULL;
		if (vala_boolean_literal_get_value (expr)) {
			_tmp0_ = "TRUE";
		} else {
			_tmp0_ = "FALSE";
		}
		_tmp1_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp1_ = vala_ccode_constant_new (_tmp0_)));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	} else {
		const char* _tmp2_;
		ValaCCodeConstant* _tmp3_;
		vala_ccode_declaration_space_add_include (self->source_declarations, "stdbool.h", FALSE);
		_tmp2_ = NULL;
		if (vala_boolean_literal_get_value (expr)) {
			_tmp2_ = "true";
		} else {
			_tmp2_ = "false";
		}
		_tmp3_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp3_ = vala_ccode_constant_new (_tmp2_)));
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	}
}


static void vala_ccode_base_module_real_visit_character_literal (ValaCCodeModule* base, ValaCharacterLiteral* expr) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = FALSE;
	if (vala_character_literal_get_char (expr) >= 0x20) {
		_tmp0_ = vala_character_literal_get_char (expr) < 0x80;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeConstant* _tmp1_;
		_tmp1_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp1_ = vala_ccode_constant_new (vala_character_literal_get_value (expr))));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	} else {
		ValaCCodeConstant* _tmp3_;
		char* _tmp2_;
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp3_ = vala_ccode_constant_new (_tmp2_ = g_strdup_printf ("%uU", (guint) vala_character_literal_get_char (expr)))));
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
		_tmp2_ = (g_free (_tmp2_), NULL);
	}
}


static void vala_ccode_base_module_real_visit_integer_literal (ValaCCodeModule* base, ValaIntegerLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0_ = vala_ccode_constant_new (vala_integer_literal_get_value (expr))));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static void vala_ccode_base_module_real_visit_real_literal (ValaCCodeModule* base, ValaRealLiteral* expr) {
	ValaCCodeBaseModule * self;
	const char* _tmp0_;
	char* c_literal;
	gboolean _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValaCCodeConstant* _tmp9_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = NULL;
	c_literal = (_tmp0_ = vala_real_literal_get_value (expr), (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	_tmp1_ = FALSE;
	if (g_str_has_suffix (c_literal, "d")) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_str_has_suffix (c_literal, "D");
	}
	if (_tmp1_) {
		char* _tmp2_;
		/* there is no suffix for double in C*/
		_tmp2_ = NULL;
		c_literal = (_tmp2_ = string_substring (c_literal, (glong) 0, string_get_length (c_literal) - 1), c_literal = (g_free (c_literal), NULL), _tmp2_);
	}
	_tmp3_ = FALSE;
	_tmp4_ = FALSE;
	if (string_contains (c_literal, ".")) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = string_contains (c_literal, "e");
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = string_contains (c_literal, "E");
	}
	if (!_tmp3_) {
		gboolean _tmp5_;
		_tmp5_ = FALSE;
		if (string_contains (c_literal, "f")) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = string_contains (c_literal, "F");
		}
		/* C requires period or exponent part for floating constants*/
		if (_tmp5_) {
			char* _tmp7_;
			char* _tmp6_;
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			c_literal = (_tmp7_ = g_strconcat (_tmp6_ = string_substring (c_literal, (glong) 0, string_get_length (c_literal) - 1), ".f", NULL), c_literal = (g_free (c_literal), NULL), _tmp7_);
			_tmp6_ = (g_free (_tmp6_), NULL);
		} else {
			char* _tmp8_;
			_tmp8_ = NULL;
			c_literal = (_tmp8_ = g_strconcat (c_literal, ".", NULL), c_literal = (g_free (c_literal), NULL), _tmp8_);
		}
	}
	_tmp9_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp9_ = vala_ccode_constant_new (c_literal)));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	c_literal = (g_free (c_literal), NULL);
}


static void vala_ccode_base_module_real_visit_string_literal (ValaCCodeModule* base, ValaStringLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0_ = vala_ccode_constant_new (vala_string_literal_get_value (expr))));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
}


static void vala_ccode_base_module_real_visit_null_literal (ValaCCodeModule* base, ValaNullLiteral* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeConstant* _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	if (vala_code_context_get_profile (self->priv->_context) != VALA_PROFILE_GOBJECT) {
		vala_ccode_declaration_space_add_include (self->source_declarations, "stddef.h", FALSE);
	}
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0_ = vala_ccode_constant_new ("NULL")));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
}


static char* vala_ccode_base_module_real_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_cname (self, delegate_cname);
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr) {
	ValaCCodeExpression* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_expr != NULL, NULL);
	g_assert_not_reached ();
}


ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_cexpression (self, delegate_expr);
}


static char* vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	g_assert_not_reached ();
}


char* vala_ccode_base_module_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_delegate_target_destroy_notify_cname (self, delegate_cname);
}


static void vala_ccode_base_module_real_visit_base_access (ValaCCodeModule* base, ValaBaseAccess* expr) {
	ValaCCodeBaseModule * self;
	ValaInstanceCast* _tmp1_;
	ValaCCodeIdentifier* _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp1_ = vala_instance_cast_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("self")), vala_data_type_get_data_type (vala_expression_get_value_type ((ValaExpression*) expr)))));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
}


static void vala_ccode_base_module_real_visit_postfix_expression (ValaCCodeModule* base, ValaPostfixExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaMemberAccess* ma;
	ValaCCodeUnaryOperator _tmp8_;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp9_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	ma = vala_ccode_base_module_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		ValaProperty* _tmp0_;
		ValaProperty* prop;
		ValaCCodeCommaExpression* ccomma;
		ValaLocalVariable* temp_decl;
		ValaCCodeAssignment* _tmp2_;
		ValaCCodeExpression* _tmp1_;
		ValaCCodeBinaryOperator _tmp3_;
		ValaCCodeBinaryOperator op;
		ValaCCodeConstant* _tmp5_;
		ValaCCodeExpression* _tmp4_;
		ValaCCodeBinaryExpression* _tmp6_;
		ValaCCodeBinaryExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp7_;
		/* property postfix expression*/
		_tmp0_ = NULL;
		prop = (_tmp0_ = VALA_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) ma)), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		ccomma = vala_ccode_comma_expression_new ();
		/* assign current value to temp variable*/
		temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_property_get_property_type (prop), TRUE, (ValaCodeNode*) expr);
		gee_list_insert ((GeeList*) self->temp_vars, 0, temp_decl);
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_assignment_new (_tmp1_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_decl)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_postfix_expression_get_inner (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
		_tmp3_ = 0;
		if (vala_postfix_expression_get_increment (expr)) {
			_tmp3_ = VALA_CCODE_BINARY_OPERATOR_PLUS;
		} else {
			_tmp3_ = VALA_CCODE_BINARY_OPERATOR_MINUS;
		}
		/* increment/decrement property*/
		op = _tmp3_;
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		_tmp6_ = NULL;
		cexpr = (_tmp6_ = vala_ccode_binary_expression_new (op, _tmp4_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_decl)), (ValaCCodeExpression*) (_tmp5_ = vala_ccode_constant_new ("1"))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp6_);
		ccall = vala_ccode_base_module_get_property_set_call (self, prop, ma, (ValaCCodeExpression*) cexpr, NULL);
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
		/* return previous value*/
		_tmp7_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
		(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		return;
	}
	_tmp8_ = 0;
	if (vala_postfix_expression_get_increment (expr)) {
		_tmp8_ = VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT;
	} else {
		_tmp8_ = VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT;
	}
	op = _tmp8_;
	_tmp9_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp9_ = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_postfix_expression_get_inner (expr))))));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
}


static ValaMemberAccess* vala_ccode_base_module_find_property_access (ValaCCodeBaseModule* self, ValaExpression* expr) {
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* ma;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (!VALA_IS_MEMBER_ACCESS (expr)) {
		result = NULL;
		return result;
	}
	_tmp0_ = NULL;
	ma = (_tmp0_ = VALA_MEMBER_ACCESS (expr), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		result = ma;
		return result;
	}
	result = NULL;
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	return result;
}


gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type) {
	gboolean result;
	ValaClass* _tmp1_;
	ValaTypeSymbol* _tmp0_;
	ValaClass* cl;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (!vala_data_type_is_disposable (type)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	cl = (_tmp1_ = (_tmp0_ = vala_data_type_get_data_type (type), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	_tmp3_ = FALSE;
	if (cl != NULL) {
		_tmp3_ = vala_typesymbol_is_reference_counting ((ValaTypeSymbol*) cl);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		char* _tmp4_;
		_tmp4_ = NULL;
		_tmp2_ = _vala_strcmp0 (_tmp4_ = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) cl), "") == 0;
		_tmp4_ = (g_free (_tmp4_), NULL);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		/* empty ref_function => no ref necessary*/
		result = FALSE;
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return result;
	}
	if (vala_data_type_get_type_parameter (type) != NULL) {
		gboolean _tmp5_;
		_tmp5_ = FALSE;
		if (!VALA_IS_CLASS (self->current_type_symbol)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = vala_class_get_is_compact (self->current_class);
		}
		if (_tmp5_) {
			result = FALSE;
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			return result;
		}
	}
	result = TRUE;
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	return result;
}


gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type) {
	gboolean result;
	ValaArrayType* _tmp1_;
	ValaDataType* _tmp0_;
	ValaArrayType* array_type;
	gboolean _tmp2_;
	ValaClass* _tmp4_;
	ValaTypeSymbol* _tmp3_;
	ValaClass* cl;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (!vala_data_type_is_disposable (type)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	array_type = (_tmp1_ = (_tmp0_ = type, VALA_IS_ARRAY_TYPE (_tmp0_) ? ((ValaArrayType*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (array_type != NULL) {
		_tmp2_ = vala_array_type_get_fixed_length (array_type);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = vala_ccode_base_module_requires_destroy (self, vala_array_type_get_element_type (array_type));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return result;
	}
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	cl = (_tmp4_ = (_tmp3_ = vala_data_type_get_data_type (type), VALA_IS_CLASS (_tmp3_) ? ((ValaClass*) _tmp3_) : NULL), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
	_tmp5_ = FALSE;
	_tmp6_ = FALSE;
	if (cl != NULL) {
		_tmp6_ = vala_typesymbol_is_reference_counting ((ValaTypeSymbol*) cl);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		char* _tmp7_;
		_tmp7_ = NULL;
		_tmp5_ = _vala_strcmp0 (_tmp7_ = vala_typesymbol_get_unref_function ((ValaTypeSymbol*) cl), "") == 0;
		_tmp7_ = (g_free (_tmp7_), NULL);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		/* empty unref_function => no unref necessary*/
		result = FALSE;
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return result;
	}
	if (vala_data_type_get_type_parameter (type) != NULL) {
		gboolean _tmp8_;
		_tmp8_ = FALSE;
		if (!VALA_IS_CLASS (self->current_type_symbol)) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = vala_class_get_is_compact (self->current_class);
		}
		if (_tmp8_) {
			result = FALSE;
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			return result;
		}
	}
	result = TRUE;
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	return result;
}


static gboolean vala_ccode_base_module_is_ref_function_void (ValaCCodeBaseModule* self, ValaDataType* type) {
	gboolean result;
	ValaClass* _tmp1_;
	ValaTypeSymbol* _tmp0_;
	ValaClass* cl;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	cl = (_tmp1_ = (_tmp0_ = vala_data_type_get_data_type (type), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (cl != NULL) {
		_tmp2_ = vala_class_get_ref_function_void (cl);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return result;
	} else {
		result = FALSE;
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return result;
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node) {
	ValaCCodeExpression* result;
	gboolean _tmp0_;
	ValaCCodeExpression* dupexpr;
	ValaCCodeFunctionCall* ccall;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression_type != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = FALSE;
	if (VALA_IS_VALUE_TYPE (expression_type)) {
		_tmp0_ = !vala_data_type_get_nullable (expression_type);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaLocalVariable* decl;
		ValaCCodeExpression* ctemp;
		ValaValueType* _tmp1_;
		ValaValueType* vt;
		ValaStruct* _tmp2_;
		ValaStruct* st;
		ValaCCodeIdentifier* _tmp4_;
		char* _tmp3_;
		ValaCCodeFunctionCall* _tmp5_;
		ValaCCodeFunctionCall* copy_call;
		ValaCCodeUnaryExpression* _tmp6_;
		ValaCCodeUnaryExpression* _tmp7_;
		ValaCCodeCommaExpression* ccomma;
		char* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp16_;
		/* normal value type, no null check
		 (copy (&expr, &temp), temp)*/
		decl = vala_ccode_base_module_get_temp_variable (self, expression_type, FALSE, node);
		gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
		ctemp = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl));
		_tmp1_ = NULL;
		vt = (_tmp1_ = VALA_VALUE_TYPE (expression_type), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		_tmp2_ = NULL;
		st = (_tmp2_ = VALA_STRUCT (vala_value_type_get_type_symbol (vt)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
		_tmp4_ = NULL;
		_tmp3_ = NULL;
		_tmp5_ = NULL;
		copy_call = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new (_tmp3_ = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st)))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp3_ = (g_free (_tmp3_), NULL), _tmp5_);
		_tmp6_ = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
		_tmp7_ = NULL;
		vala_ccode_function_call_add_argument (copy_call, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ctemp)));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp8_ = NULL;
		if ((_tmp9_ = _vala_strcmp0 (_tmp8_ = vala_typesymbol_get_copy_function ((ValaTypeSymbol*) st), "g_value_copy") == 0, _tmp8_ = (g_free (_tmp8_), NULL), _tmp9_)) {
			ValaCCodeIdentifier* _tmp10_;
			ValaCCodeFunctionCall* _tmp11_;
			ValaCCodeFunctionCall* value_type_call;
			ValaCCodeUnaryExpression* _tmp12_;
			ValaCCodeIdentifier* _tmp13_;
			ValaCCodeFunctionCall* _tmp14_;
			ValaCCodeFunctionCall* init_call;
			ValaCCodeUnaryExpression* _tmp15_;
			/* GValue requires g_value_init in addition to g_value_copy*/
			_tmp10_ = NULL;
			_tmp11_ = NULL;
			value_type_call = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("G_VALUE_TYPE"))), (_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL)), _tmp11_);
			_tmp12_ = NULL;
			vala_ccode_function_call_add_argument (value_type_call, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)));
			(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
			_tmp13_ = NULL;
			_tmp14_ = NULL;
			init_call = (_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("g_value_init"))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp14_);
			_tmp15_ = NULL;
			vala_ccode_function_call_add_argument (init_call, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ctemp)));
			(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
			vala_ccode_function_call_add_argument (init_call, (ValaCCodeExpression*) value_type_call);
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) init_call);
			(value_type_call == NULL) ? NULL : (value_type_call = (vala_ccode_node_unref (value_type_call), NULL));
			(init_call == NULL) ? NULL : (init_call = (vala_ccode_node_unref (init_call), NULL));
		}
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) copy_call);
		vala_ccode_comma_expression_append_expression (ccomma, ctemp);
		_tmp16_ = FALSE;
		if (self->gvalue_type != NULL) {
			_tmp16_ = vala_data_type_get_data_type (expression_type) == VALA_TYPESYMBOL (self->gvalue_type);
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValaCCodeIdentifier* _tmp17_;
			ValaCCodeFunctionCall* _tmp18_;
			ValaCCodeFunctionCall* cisvalid;
			ValaCCodeUnaryExpression* _tmp19_;
			/* g_value_init/copy must not be called for uninitialized values*/
			_tmp17_ = NULL;
			_tmp18_ = NULL;
			cisvalid = (_tmp18_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new ("G_IS_VALUE"))), (_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL)), _tmp18_);
			_tmp19_ = NULL;
			vala_ccode_function_call_add_argument (cisvalid, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr)));
			(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
			result = (ValaCCodeExpression*) vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisvalid, (ValaCCodeExpression*) ccomma, cexpr);
			(cisvalid == NULL) ? NULL : (cisvalid = (vala_ccode_node_unref (cisvalid), NULL));
			(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
			(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
			(vt == NULL) ? NULL : (vt = (vala_code_node_unref (vt), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			return result;
		} else {
			result = (ValaCCodeExpression*) ccomma;
			(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
			(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
			(vt == NULL) ? NULL : (vt = (vala_code_node_unref (vt), NULL));
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
			return result;
		}
		(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
		(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
		(vt == NULL) ? NULL : (vt = (vala_code_node_unref (vt), NULL));
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		(copy_call == NULL) ? NULL : (copy_call = (vala_ccode_node_unref (copy_call), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	}
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	dupexpr = vala_ccode_base_module_get_dup_func_expression (self, expression_type, vala_code_node_get_source_reference (node), FALSE);
	if (dupexpr == NULL) {
		vala_code_node_set_error (node, TRUE);
		result = NULL;
		(dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL));
		return result;
	}
	ccall = vala_ccode_function_call_new (dupexpr);
	_tmp20_ = FALSE;
	_tmp21_ = FALSE;
	_tmp22_ = FALSE;
	if (!VALA_IS_ARRAY_TYPE (expression_type)) {
		_tmp22_ = expr != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		_tmp21_ = vala_expression_is_non_null (expr);
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		_tmp20_ = !vala_ccode_base_module_is_ref_function_void (self, expression_type);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		/* expression is non-null*/
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
		result = (ValaCCodeExpression*) ccall;
		(dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL));
		return result;
	} else {
		ValaLocalVariable* decl;
		ValaCCodeExpression* ctemp;
		ValaCCodeConstant* _tmp23_;
		ValaCCodeBinaryExpression* _tmp24_;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp36_;
		ValaCCodeExpression* cifnull;
		ValaCCodeConditionalExpression* _tmp39_;
		decl = vala_ccode_base_module_get_temp_variable (self, expression_type, FALSE, node);
		gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
		ctemp = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl));
		_tmp23_ = NULL;
		_tmp24_ = NULL;
		cisnull = (_tmp24_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, ctemp, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_constant_new ("NULL"))), (_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL)), _tmp24_);
		if (vala_data_type_get_type_parameter (expression_type) != NULL) {
			ValaCCodeConstant* _tmp27_;
			ValaCCodeExpression* _tmp26_;
			ValaCCodeBinaryExpression* _tmp28_;
			ValaCCodeBinaryExpression* cdupisnull;
			ValaCCodeBinaryExpression* _tmp29_;
			if (!VALA_IS_CLASS (self->current_type_symbol)) {
				ValaCCodeExpression* _tmp25_;
				_tmp25_ = NULL;
				result = (_tmp25_ = cexpr, (_tmp25_ == NULL) ? NULL : vala_ccode_node_ref (_tmp25_));
				(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
				(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
				(cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL));
				(dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL));
				(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
				return result;
			}
			/* dup functions are optional for type parameters*/
			_tmp27_ = NULL;
			_tmp26_ = NULL;
			_tmp28_ = NULL;
			cdupisnull = (_tmp28_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp26_ = vala_ccode_base_module_get_dup_func_expression (self, expression_type, vala_code_node_get_source_reference (node), FALSE), (ValaCCodeExpression*) (_tmp27_ = vala_ccode_constant_new ("NULL"))), (_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL)), (_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL)), _tmp28_);
			_tmp29_ = NULL;
			cisnull = (_tmp29_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cisnull, (ValaCCodeExpression*) cdupisnull), (cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL)), _tmp29_);
			(cdupisnull == NULL) ? NULL : (cdupisnull = (vala_ccode_node_unref (cdupisnull), NULL));
		}
		if (vala_data_type_get_type_parameter (expression_type) != NULL) {
			ValaCCodeCastExpression* _tmp30_;
			/* cast from gconstpointer to gpointer as GBoxedCopyFunc expects gpointer*/
			_tmp30_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp30_ = vala_ccode_cast_expression_new (ctemp, "gpointer")));
			(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
		} else {
			vala_ccode_function_call_add_argument (ccall, ctemp);
		}
		if (VALA_IS_ARRAY_TYPE (expression_type)) {
			ValaArrayType* _tmp31_;
			ValaArrayType* array_type;
			gboolean first;
			ValaCCodeExpression* csizeexpr;
			_tmp31_ = NULL;
			array_type = (_tmp31_ = VALA_ARRAY_TYPE (expression_type), (_tmp31_ == NULL) ? NULL : vala_code_node_ref (_tmp31_));
			first = TRUE;
			csizeexpr = NULL;
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp32_;
					_tmp32_ = TRUE;
					while (TRUE) {
						if (!_tmp32_) {
							dim++;
						}
						_tmp32_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (array_type))) {
							break;
						}
						if (first) {
							ValaCCodeExpression* _tmp33_;
							_tmp33_ = NULL;
							csizeexpr = (_tmp33_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp33_);
							first = FALSE;
						} else {
							ValaCCodeExpression* _tmp35_;
							ValaCCodeExpression* _tmp34_;
							_tmp35_ = NULL;
							_tmp34_ = NULL;
							csizeexpr = (_tmp35_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, csizeexpr, _tmp34_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim)), (csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL)), _tmp35_);
							(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
						}
					}
				}
			}
			vala_ccode_function_call_add_argument (ccall, csizeexpr);
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			(csizeexpr == NULL) ? NULL : (csizeexpr = (vala_ccode_node_unref (csizeexpr), NULL));
		}
		ccomma = vala_ccode_comma_expression_new ();
		_tmp36_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_assignment_new (ctemp, cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
		cifnull = NULL;
		if (vala_data_type_get_data_type (expression_type) != NULL) {
			ValaCCodeExpression* _tmp37_;
			_tmp37_ = NULL;
			cifnull = (_tmp37_ = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (cifnull == NULL) ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL)), _tmp37_);
		} else {
			ValaCCodeExpression* _tmp38_;
			/* the value might be non-null even when the dup function is null,
			 so we may not just use NULL for type parameters
			 cast from gconstpointer to gpointer as methods in
			 generic classes may not return gconstpointer*/
			_tmp38_ = NULL;
			cifnull = (_tmp38_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (ctemp, "gpointer"), (cifnull == NULL) ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL)), _tmp38_);
		}
		_tmp39_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) cisnull, cifnull, (ValaCCodeExpression*) ccall)));
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
		/* repeat temp variable at the end of the comma expression
		 if the ref function returns void*/
		if (vala_ccode_base_module_is_ref_function_void (self, expression_type)) {
			vala_ccode_comma_expression_append_expression (ccomma, ctemp);
		}
		result = (ValaCCodeExpression*) ccomma;
		(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
		(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
		(cisnull == NULL) ? NULL : (cisnull = (vala_ccode_node_unref (cisnull), NULL));
		(cifnull == NULL) ? NULL : (cifnull = (vala_ccode_node_unref (cifnull), NULL));
		(dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		return result;
	}
	(dupexpr == NULL) ? NULL : (dupexpr = (vala_ccode_node_unref (dupexpr), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_get_ref_cexpression (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_ref_cexpression (self, expression_type, cexpr, expr, node);
}


static gboolean vala_ccode_base_module_is_reference_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	_tmp0_ = FALSE;
	if (vala_data_type_get_data_type (type_arg) != NULL) {
		_tmp0_ = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (type_arg));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean vala_ccode_base_module_is_nullable_value_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	_tmp0_ = FALSE;
	if (VALA_IS_VALUE_TYPE (type_arg)) {
		_tmp0_ = vala_data_type_get_nullable (type_arg);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean vala_ccode_base_module_is_signed_integer_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg) {
	gboolean result;
	ValaStruct* _tmp1_;
	ValaTypeSymbol* _tmp0_;
	ValaStruct* st;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	st = (_tmp1_ = (_tmp0_ = vala_data_type_get_data_type (type_arg), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	if (vala_data_type_get_nullable (type_arg)) {
		result = FALSE;
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		return result;
	} else {
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->bool_type)) {
			result = TRUE;
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			return result;
		} else {
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->char_type)) {
				result = TRUE;
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				return result;
			} else {
				gboolean _tmp2_;
				_tmp2_ = FALSE;
				if (self->unichar_type != NULL) {
					_tmp2_ = VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->unichar_type);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					result = TRUE;
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					return result;
				} else {
					if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->short_type)) {
						result = TRUE;
						(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
						return result;
					} else {
						if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->int_type)) {
							result = TRUE;
							(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
							return result;
						} else {
							if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->long_type)) {
								result = TRUE;
								(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
								return result;
							} else {
								if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->int8_type)) {
									result = TRUE;
									(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
									return result;
								} else {
									if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->int16_type)) {
										result = TRUE;
										(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
										return result;
									} else {
										if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->int32_type)) {
											result = TRUE;
											(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
											return result;
										} else {
											if (VALA_TYPESYMBOL (st) == self->gtype_type) {
												result = TRUE;
												(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
												return result;
											} else {
												result = FALSE;
												(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
												return result;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
}


static gboolean vala_ccode_base_module_is_unsigned_integer_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg) {
	gboolean result;
	ValaStruct* _tmp1_;
	ValaTypeSymbol* _tmp0_;
	ValaStruct* st;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_arg != NULL, FALSE);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	st = (_tmp1_ = (_tmp0_ = vala_data_type_get_data_type (type_arg), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	if (vala_data_type_get_nullable (type_arg)) {
		result = FALSE;
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		return result;
	} else {
		if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uchar_type)) {
			result = TRUE;
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			return result;
		} else {
			if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->ushort_type)) {
				result = TRUE;
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				return result;
			} else {
				if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint_type)) {
					result = TRUE;
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					return result;
				} else {
					if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->ulong_type)) {
						result = TRUE;
						(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
						return result;
					} else {
						if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint8_type)) {
							result = TRUE;
							(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
							return result;
						} else {
							if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint16_type)) {
								result = TRUE;
								(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
								return result;
							} else {
								if (VALA_TYPESYMBOL (st) == vala_data_type_get_data_type (self->uint32_type)) {
									result = TRUE;
									(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
									return result;
								} else {
									result = FALSE;
									(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
}


void vala_ccode_base_module_check_type (ValaCCodeBaseModule* self, ValaDataType* type) {
	ValaArrayType* _tmp1_;
	ValaDataType* _tmp0_;
	ValaArrayType* array_type;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	array_type = (_tmp1_ = (_tmp0_ = type, VALA_IS_ARRAY_TYPE (_tmp0_) ? ((ValaArrayType*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	if (array_type != NULL) {
		vala_ccode_base_module_check_type (self, vala_array_type_get_element_type (array_type));
	}
	{
		GeeList* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _type_arg_it;
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		_type_arg_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = vala_data_type_get_type_arguments (type))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (gee_collection_object_unref (_tmp2_), NULL)), _tmp3_);
		while (TRUE) {
			ValaDataType* type_arg;
			if (!gee_iterator_next (_type_arg_it)) {
				break;
			}
			type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
			vala_ccode_base_module_check_type (self, type_arg);
			vala_ccode_base_module_check_type_argument (self, type_arg);
			(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
		}
		(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
	}
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
}


static void vala_ccode_base_module_check_type_argument (ValaCCodeBaseModule* self, ValaDataType* type_arg) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_arg != NULL);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	_tmp2_ = FALSE;
	_tmp3_ = FALSE;
	_tmp4_ = FALSE;
	if (VALA_IS_GENERIC_TYPE (type_arg)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = VALA_IS_POINTER_TYPE (type_arg);
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = vala_ccode_base_module_is_reference_type_argument (self, type_arg);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = vala_ccode_base_module_is_nullable_value_type_argument (self, type_arg);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = vala_ccode_base_module_is_signed_integer_type_argument (self, type_arg);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_ccode_base_module_is_unsigned_integer_type_argument (self, type_arg);
	}
	if (_tmp0_) {
	} else {
		if (VALA_IS_DELEGATE_TYPE (type_arg)) {
			ValaDelegateType* _tmp5_;
			ValaDelegateType* delegate_type;
			_tmp5_ = NULL;
			delegate_type = (_tmp5_ = VALA_DELEGATE_TYPE (type_arg), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
			if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) type_arg), "Delegates with target are not supported as generic type arguments");
			}
			(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
		} else {
			char* _tmp7_;
			char* _tmp6_;
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) type_arg), _tmp7_ = g_strdup_printf ("`%s' is not a supported generic type argument, use `?' to box value types", _tmp6_ = vala_code_node_to_string ((ValaCodeNode*) type_arg)));
			_tmp7_ = (g_free (_tmp7_), NULL);
			_tmp6_ = (g_free (_tmp6_), NULL);
		}
	}
}


static void vala_ccode_base_module_real_generate_class_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space) {
	char* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) cl, _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		return;
	}
}


void vala_ccode_base_module_generate_class_declaration (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->generate_class_declaration (self, cl, decl_space);
}


static void vala_ccode_base_module_real_generate_interface_declaration (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (decl_space != NULL);
}


void vala_ccode_base_module_generate_interface_declaration (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->generate_interface_declaration (self, iface, decl_space);
}


static void vala_ccode_base_module_real_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (decl_space != NULL);
}


void vala_ccode_base_module_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->generate_method_declaration (self, m, decl_space);
}


static void vala_ccode_base_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (edomain != NULL);
	g_return_if_fail (decl_space != NULL);
}


void vala_ccode_base_module_generate_error_domain_declaration (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space) {
	VALA_CCODE_BASE_MODULE_GET_CLASS (self)->generate_error_domain_declaration (self, edomain, decl_space);
}


void vala_ccode_base_module_add_generic_type_arguments (ValaCCodeBaseModule* self, ValaCCodeFunctionCall* ccall, GeeList* type_args, ValaCodeNode* expr, gboolean is_chainup) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ccall != NULL);
	g_return_if_fail (type_args != NULL);
	g_return_if_fail (expr != NULL);
	{
		GeeIterator* _type_arg_it;
		_type_arg_it = gee_iterable_iterator ((GeeIterable*) type_args);
		while (TRUE) {
			ValaDataType* type_arg;
			ValaCCodeExpression* _tmp0_;
			if (!gee_iterator_next (_type_arg_it)) {
				break;
			}
			type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
			_tmp0_ = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp0_ = vala_ccode_base_module_get_type_id_expression (self, type_arg, is_chainup));
			(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
			if (vala_ccode_base_module_requires_copy (self, type_arg)) {
				ValaCCodeExpression* dup_func;
				ValaCCodeCastExpression* _tmp1_;
				ValaCCodeExpression* _tmp2_;
				dup_func = vala_ccode_base_module_get_dup_func_expression (self, type_arg, vala_code_node_get_source_reference ((ValaCodeNode*) type_arg), is_chainup);
				if (dup_func == NULL) {
					/* type doesn't contain a copy function*/
					vala_code_node_set_error (expr, TRUE);
					(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
					(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
					(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
					return;
				}
				_tmp1_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp1_ = vala_ccode_cast_expression_new (dup_func, "GBoxedCopyFunc")));
				(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
				_tmp2_ = NULL;
				vala_ccode_function_call_add_argument (ccall, _tmp2_ = vala_ccode_base_module_get_destroy_func_expression (self, type_arg, is_chainup));
				(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
				(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
			} else {
				ValaCCodeConstant* _tmp3_;
				ValaCCodeConstant* _tmp4_;
				_tmp3_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_constant_new ("NULL")));
				(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
				_tmp4_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new ("NULL")));
				(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
			}
			(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
		}
		(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
	}
}


static void vala_ccode_base_module_real_visit_object_creation_expression (ValaCCodeModule* base, ValaObjectCreationExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* instance;
	ValaCCodeExpression* creation_expr;
	ValaStruct* _tmp1_;
	ValaTypeSymbol* _tmp0_;
	ValaStruct* st;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	instance = NULL;
	creation_expr = NULL;
	vala_ccode_base_module_check_type (self, vala_object_creation_expression_get_type_reference (expr));
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	st = (_tmp1_ = (_tmp0_ = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	_tmp3_ = FALSE;
	if (st != NULL) {
		_tmp3_ = !vala_struct_is_simple_type (st);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		GeeList* _tmp4_;
		_tmp4_ = NULL;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) (_tmp4_ = vala_object_creation_expression_get_object_initializer (expr))) > 0;
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (gee_collection_object_unref (_tmp4_), NULL));
	}
	if (_tmp2_) {
		ValaLocalVariable* temp_decl;
		ValaCCodeExpression* _tmp6_;
		char* _tmp5_;
		/* value-type initialization or object creation expression with object initializer*/
		temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_object_creation_expression_get_type_reference (expr), FALSE, (ValaCodeNode*) expr);
		gee_collection_add ((GeeCollection*) self->temp_vars, temp_decl);
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		instance = (_tmp6_ = vala_ccode_base_module_get_variable_cexpression (self, _tmp5_ = vala_ccode_base_module_get_variable_cname (self, vala_symbol_get_name ((ValaSymbol*) temp_decl))), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp6_);
		_tmp5_ = (g_free (_tmp5_), NULL);
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
	}
	if (vala_expression_get_symbol_reference ((ValaExpression*) expr) == NULL) {
		ValaCCodeFunctionCall* creation_call;
		gboolean _tmp7_;
		ValaCCodeExpression* _tmp28_;
		ValaCCodeExpression* _tmp27_;
		creation_call = NULL;
		_tmp7_ = FALSE;
		if (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == VALA_TYPESYMBOL (self->glist_type)) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == VALA_TYPESYMBOL (self->gslist_type);
		}
		/* no creation method*/
		if (_tmp7_) {
			ValaCCodeConstant* _tmp8_;
			/* NULL is an empty list*/
			_tmp8_ = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp8_ = vala_ccode_constant_new ("NULL")));
			(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		} else {
			gboolean _tmp9_;
			_tmp9_ = FALSE;
			if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
				_tmp9_ = vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), self->gobject_type);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				ValaCCodeFunctionCall* _tmp11_;
				ValaCCodeIdentifier* _tmp10_;
				ValaCCodeConstant* _tmp13_;
				char* _tmp12_;
				ValaCCodeConstant* _tmp14_;
				vala_ccode_base_module_generate_class_declaration (self, VALA_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))), self->source_declarations);
				_tmp11_ = NULL;
				_tmp10_ = NULL;
				creation_call = (_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("g_object_new"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp11_);
				(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
				_tmp13_ = NULL;
				_tmp12_ = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_constant_new (_tmp12_ = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr))))));
				(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
				_tmp12_ = (g_free (_tmp12_), NULL);
				_tmp14_ = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_constant_new ("NULL")));
				(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
			} else {
				if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
					ValaCCodeFunctionCall* _tmp16_;
					ValaCCodeIdentifier* _tmp15_;
					ValaCCodeConstant* _tmp18_;
					char* _tmp17_;
					ValaCCodeConstant* _tmp19_;
					_tmp16_ = NULL;
					_tmp15_ = NULL;
					creation_call = (_tmp16_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("g_new0"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp16_);
					(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
					_tmp18_ = NULL;
					_tmp17_ = NULL;
					vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_constant_new (_tmp17_ = vala_typesymbol_get_cname (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE))));
					(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
					_tmp17_ = (g_free (_tmp17_), NULL);
					_tmp19_ = NULL;
					vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_constant_new ("1")));
					(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
						ValaCCodeFunctionCall* _tmp21_;
						ValaCCodeIdentifier* _tmp20_;
						ValaCCodeUnaryExpression* _tmp22_;
						ValaCCodeConstant* _tmp23_;
						ValaCCodeIdentifier* _tmp26_;
						char* _tmp25_;
						char* _tmp24_;
						/* memset needs string.h*/
						vala_ccode_declaration_space_add_include (self->source_declarations, "string.h", FALSE);
						_tmp21_ = NULL;
						_tmp20_ = NULL;
						creation_call = (_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new ("memset"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp21_);
						(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
						_tmp22_ = NULL;
						vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)));
						(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
						_tmp23_ = NULL;
						vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_constant_new ("0")));
						(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
						_tmp26_ = NULL;
						_tmp25_ = NULL;
						_tmp24_ = NULL;
						vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_identifier_new (_tmp25_ = g_strdup_printf ("sizeof (%s)", _tmp24_ = vala_data_type_get_cname (vala_object_creation_expression_get_type_reference (expr))))));
						(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
						_tmp25_ = (g_free (_tmp25_), NULL);
						_tmp24_ = (g_free (_tmp24_), NULL);
					}
				}
			}
		}
		_tmp28_ = NULL;
		_tmp27_ = NULL;
		creation_expr = (_tmp28_ = (_tmp27_ = (ValaCCodeExpression*) creation_call, (_tmp27_ == NULL) ? NULL : vala_ccode_node_ref (_tmp27_)), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp28_);
		(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
	} else {
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
			ValaMethod* _tmp29_;
			ValaMethod* m;
			GeeList* params;
			ValaCCodeFunctionCall* creation_call;
			ValaCCodeFunctionCall* _tmp32_;
			ValaCCodeIdentifier* _tmp31_;
			char* _tmp30_;
			gboolean _tmp33_;
			gboolean _tmp34_;
			ValaClass* _tmp37_;
			ValaTypeSymbol* _tmp36_;
			ValaClass* cl;
			gboolean _tmp38_;
			GeeHashMap* carg_map;
			gboolean ellipsis;
			gint i;
			gint arg_pos;
			GeeIterator* params_it;
			gint last_pos;
			gint min_pos;
			gboolean _tmp57_;
			gboolean _tmp58_;
			ValaCCodeExpression* _tmp66_;
			ValaCCodeExpression* _tmp65_;
			char* _tmp67_;
			gboolean _tmp68_;
			/* use creation method*/
			_tmp29_ = NULL;
			m = (_tmp29_ = VALA_METHOD (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp29_ == NULL) ? NULL : vala_code_node_ref (_tmp29_));
			params = vala_method_get_parameters (m);
			creation_call = NULL;
			vala_ccode_base_module_generate_method_declaration (self, m, self->source_declarations);
			_tmp32_ = NULL;
			_tmp31_ = NULL;
			_tmp30_ = NULL;
			creation_call = (_tmp32_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31_ = vala_ccode_identifier_new (_tmp30_ = vala_method_get_cname (m)))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp32_);
			(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
			_tmp30_ = (g_free (_tmp30_), NULL);
			_tmp33_ = FALSE;
			_tmp34_ = FALSE;
			if (st != NULL) {
				_tmp34_ = !vala_struct_is_simple_type (st);
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				_tmp33_ = !(vala_method_get_cinstance_parameter_position (m) < 0);
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				ValaCCodeUnaryExpression* _tmp35_;
				_tmp35_ = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)));
				(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
			}
			vala_ccode_base_module_generate_type_declaration (self, vala_object_creation_expression_get_type_reference (expr), self->source_declarations);
			_tmp37_ = NULL;
			_tmp36_ = NULL;
			cl = (_tmp37_ = (_tmp36_ = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), VALA_IS_CLASS (_tmp36_) ? ((ValaClass*) _tmp36_) : NULL), (_tmp37_ == NULL) ? NULL : vala_code_node_ref (_tmp37_));
			_tmp38_ = FALSE;
			if (cl != NULL) {
				_tmp38_ = !vala_class_get_is_compact (cl);
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				GeeList* _tmp39_;
				_tmp39_ = NULL;
				vala_ccode_base_module_add_generic_type_arguments (self, creation_call, _tmp39_ = vala_data_type_get_type_arguments (vala_object_creation_expression_get_type_reference (expr)), (ValaCodeNode*) expr, FALSE);
				(_tmp39_ == NULL) ? NULL : (_tmp39_ = (gee_collection_object_unref (_tmp39_), NULL));
			}
			carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
			ellipsis = FALSE;
			i = 1;
			arg_pos = 0;
			params_it = gee_iterable_iterator ((GeeIterable*) params);
			{
				GeeList* _tmp40_;
				GeeIterator* _tmp41_;
				GeeIterator* _arg_it;
				_tmp40_ = NULL;
				_tmp41_ = NULL;
				_arg_it = (_tmp41_ = gee_iterable_iterator ((GeeIterable*) (_tmp40_ = vala_object_creation_expression_get_argument_list (expr))), (_tmp40_ == NULL) ? NULL : (_tmp40_ = (gee_collection_object_unref (_tmp40_), NULL)), _tmp41_);
				while (TRUE) {
					ValaExpression* arg;
					ValaCCodeExpression* _tmp42_;
					ValaCCodeExpression* cexpr;
					ValaFormalParameter* param;
					if (!gee_iterator_next (_arg_it)) {
						break;
					}
					arg = (ValaExpression*) gee_iterator_get (_arg_it);
					_tmp42_ = NULL;
					cexpr = (_tmp42_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)), (_tmp42_ == NULL) ? NULL : vala_ccode_node_ref (_tmp42_));
					param = NULL;
					if (gee_iterator_next (params_it)) {
						ValaFormalParameter* _tmp43_;
						_tmp43_ = NULL;
						param = (_tmp43_ = (ValaFormalParameter*) gee_iterator_get (params_it), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), _tmp43_);
						ellipsis = vala_formal_parameter_get_ellipsis (param);
						if (!ellipsis) {
							gboolean _tmp44_;
							ValaCCodeExpression* _tmp50_;
							_tmp44_ = FALSE;
							if (!vala_formal_parameter_get_no_array_length (param)) {
								_tmp44_ = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
							} else {
								_tmp44_ = FALSE;
							}
							if (_tmp44_) {
								ValaArrayType* _tmp45_;
								ValaArrayType* array_type;
								_tmp45_ = NULL;
								array_type = (_tmp45_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp45_ == NULL) ? NULL : vala_code_node_ref (_tmp45_));
								{
									gint dim;
									dim = 1;
									{
										gboolean _tmp46_;
										_tmp46_ = TRUE;
										while (TRUE) {
											ValaCCodeExpression* _tmp47_;
											if (!_tmp46_) {
												dim++;
											}
											_tmp46_ = FALSE;
											if (!(dim <= vala_array_type_get_rank (array_type))) {
												break;
											}
											_tmp47_ = NULL;
											gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp47_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), arg, dim));
											(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
										}
									}
								}
								(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
							} else {
								if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
									ValaDelegateType* _tmp48_;
									ValaDelegateType* deleg_type;
									ValaDelegate* _tmp49_;
									ValaDelegate* d;
									_tmp48_ = NULL;
									deleg_type = (_tmp48_ = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp48_ == NULL) ? NULL : vala_code_node_ref (_tmp48_));
									_tmp49_ = NULL;
									d = (_tmp49_ = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp49_ == NULL) ? NULL : vala_code_node_ref (_tmp49_));
									if (vala_delegate_get_has_target (d)) {
										ValaCCodeExpression* delegate_target;
										delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (self, arg);
										gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
										(delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL));
									}
									(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
									(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
								}
							}
							_tmp50_ = NULL;
							cexpr = (_tmp50_ = vala_ccode_base_module_handle_struct_argument (self, param, arg, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp50_);
						}
						arg_pos = vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
					} else {
						/* default argument position*/
						arg_pos = vala_ccode_base_module_get_param_pos (self, (double) i, ellipsis);
					}
					gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (arg_pos), cexpr);
					i++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
			}
			while (TRUE) {
				ValaFormalParameter* param;
				if (!gee_iterator_next (params_it)) {
					break;
				}
				param = (ValaFormalParameter*) gee_iterator_get (params_it);
				if (vala_formal_parameter_get_ellipsis (param)) {
					ellipsis = TRUE;
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					break;
				}
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* _tmp51_;
					_tmp51_ = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), _tmp51_ = g_strdup_printf ("no default expression for argument %d", i));
					_tmp51_ = (g_free (_tmp51_), NULL);
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
					(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
					(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
					(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
					(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
					(creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL));
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					return;
				}
				/* evaluate default expression here as the code
				 * generator might not have visited the formal
				 * parameter yet */
				vala_code_node_accept ((ValaCodeNode*) vala_formal_parameter_get_default_expression (param), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos (self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_formal_parameter_get_default_expression (param))));
				i++;
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			/* append C arguments in the right order*/
			last_pos = -1;
			min_pos = 0;
			while (TRUE) {
				ValaCCodeExpression* _tmp56_;
				min_pos = -1;
				{
					GeeSet* _tmp52_;
					GeeIterator* _tmp53_;
					GeeIterator* _pos_it;
					_tmp52_ = NULL;
					_tmp53_ = NULL;
					_pos_it = (_tmp53_ = gee_iterable_iterator ((GeeIterable*) (_tmp52_ = gee_map_get_keys ((GeeMap*) carg_map))), (_tmp52_ == NULL) ? NULL : (_tmp52_ = (gee_collection_object_unref (_tmp52_), NULL)), _tmp53_);
					while (TRUE) {
						gint pos;
						gboolean _tmp54_;
						if (!gee_iterator_next (_pos_it)) {
							break;
						}
						pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
						_tmp54_ = FALSE;
						if (pos > last_pos) {
							gboolean _tmp55_;
							_tmp55_ = FALSE;
							if (min_pos == (-1)) {
								_tmp55_ = TRUE;
							} else {
								_tmp55_ = pos < min_pos;
							}
							_tmp54_ = _tmp55_;
						} else {
							_tmp54_ = FALSE;
						}
						if (_tmp54_) {
							min_pos = pos;
						}
					}
					(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
				}
				if (min_pos == (-1)) {
					break;
				}
				_tmp56_ = NULL;
				vala_ccode_function_call_add_argument (creation_call, _tmp56_ = (ValaCCodeExpression*) gee_map_get ((GeeMap*) carg_map, GINT_TO_POINTER (min_pos)));
				(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
				last_pos = min_pos;
			}
			_tmp57_ = FALSE;
			_tmp58_ = FALSE;
			if (st != NULL) {
				_tmp58_ = !vala_struct_is_simple_type (st);
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				_tmp57_ = vala_method_get_cinstance_parameter_position (m) < 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeUnaryExpression* _tmp59_;
				/* instance parameter is at the end in a struct creation method*/
				_tmp59_ = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp59_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)));
				(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
			}
			if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr)) {
				ValaCCodeUnaryExpression* _tmp61_;
				ValaCCodeIdentifier* _tmp60_;
				/* method can fail*/
				self->current_method_inner_error = TRUE;
				_tmp61_ = NULL;
				_tmp60_ = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp61_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp60_ = vala_ccode_identifier_new ("_inner_error_")))));
				(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
				(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
			}
			if (ellipsis) {
				gboolean _tmp62_;
				gboolean _tmp63_;
				_tmp62_ = FALSE;
				_tmp63_ = FALSE;
				if (!vala_method_get_printf_format (m)) {
					_tmp63_ = !vala_method_get_scanf_format (m);
				} else {
					_tmp63_ = FALSE;
				}
				if (_tmp63_) {
					_tmp62_ = _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0;
				} else {
					_tmp62_ = FALSE;
				}
				/* ensure variable argument list ends with NULL
				 * except when using printf-style arguments */
				if (_tmp62_) {
					ValaCCodeConstant* _tmp64_;
					_tmp64_ = NULL;
					vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp64_ = vala_ccode_constant_new (vala_method_get_sentinel (m))));
					(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_ccode_node_unref (_tmp64_), NULL));
				}
			}
			_tmp66_ = NULL;
			_tmp65_ = NULL;
			creation_expr = (_tmp66_ = (_tmp65_ = (ValaCCodeExpression*) creation_call, (_tmp65_ == NULL) ? NULL : vala_ccode_node_ref (_tmp65_)), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp66_);
			/* cast the return value of the creation method back to the intended type if
			 it requested a special C return type*/
			_tmp67_ = NULL;
			if ((_tmp68_ = (_tmp67_ = vala_ccode_module_get_custom_creturn_type (vala_ccode_module_get_head ((ValaCCodeModule*) self), m)) != NULL, _tmp67_ = (g_free (_tmp67_), NULL), _tmp68_)) {
				ValaCCodeExpression* _tmp70_;
				char* _tmp69_;
				_tmp70_ = NULL;
				_tmp69_ = NULL;
				creation_expr = (_tmp70_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (creation_expr, _tmp69_ = vala_data_type_get_cname (vala_object_creation_expression_get_type_reference (expr))), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp70_);
				_tmp69_ = (g_free (_tmp69_), NULL);
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
			(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
			(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
		} else {
			if (VALA_IS_ERROR_CODE (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
				ValaErrorCode* _tmp71_;
				ValaErrorCode* ecode;
				ValaErrorDomain* _tmp72_;
				ValaErrorDomain* edomain;
				ValaCCodeFunctionCall* creation_call;
				GeeList* _tmp73_;
				gboolean _tmp74_;
				ValaCCodeIdentifier* _tmp80_;
				char* _tmp79_;
				ValaCCodeIdentifier* _tmp82_;
				char* _tmp81_;
				ValaCCodeExpression* _tmp86_;
				ValaCCodeExpression* _tmp85_;
				_tmp71_ = NULL;
				ecode = (_tmp71_ = VALA_ERROR_CODE (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp71_ == NULL) ? NULL : vala_code_node_ref (_tmp71_));
				_tmp72_ = NULL;
				edomain = (_tmp72_ = VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol ((ValaSymbol*) ecode)), (_tmp72_ == NULL) ? NULL : vala_code_node_ref (_tmp72_));
				creation_call = NULL;
				vala_ccode_base_module_generate_error_domain_declaration (self, edomain, self->source_declarations);
				_tmp73_ = NULL;
				if ((_tmp74_ = gee_collection_get_size ((GeeCollection*) (_tmp73_ = vala_object_creation_expression_get_argument_list (expr))) == 1, (_tmp73_ == NULL) ? NULL : (_tmp73_ = (gee_collection_object_unref (_tmp73_), NULL)), _tmp74_)) {
					ValaCCodeFunctionCall* _tmp76_;
					ValaCCodeIdentifier* _tmp75_;
					/* must not be a format argument*/
					_tmp76_ = NULL;
					_tmp75_ = NULL;
					creation_call = (_tmp76_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp75_ = vala_ccode_identifier_new ("g_error_new_literal"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp76_);
					(_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL));
				} else {
					ValaCCodeFunctionCall* _tmp78_;
					ValaCCodeIdentifier* _tmp77_;
					_tmp78_ = NULL;
					_tmp77_ = NULL;
					creation_call = (_tmp78_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp77_ = vala_ccode_identifier_new ("g_error_new"))), (creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL)), _tmp78_);
					(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
				}
				_tmp80_ = NULL;
				_tmp79_ = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp80_ = vala_ccode_identifier_new (_tmp79_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) edomain, NULL))));
				(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
				_tmp79_ = (g_free (_tmp79_), NULL);
				_tmp82_ = NULL;
				_tmp81_ = NULL;
				vala_ccode_function_call_add_argument (creation_call, (ValaCCodeExpression*) (_tmp82_ = vala_ccode_identifier_new (_tmp81_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE))));
				(_tmp82_ == NULL) ? NULL : (_tmp82_ = (vala_ccode_node_unref (_tmp82_), NULL));
				_tmp81_ = (g_free (_tmp81_), NULL);
				{
					GeeList* _tmp83_;
					GeeIterator* _tmp84_;
					GeeIterator* _arg_it;
					_tmp83_ = NULL;
					_tmp84_ = NULL;
					_arg_it = (_tmp84_ = gee_iterable_iterator ((GeeIterable*) (_tmp83_ = vala_object_creation_expression_get_argument_list (expr))), (_tmp83_ == NULL) ? NULL : (_tmp83_ = (gee_collection_object_unref (_tmp83_), NULL)), _tmp84_);
					while (TRUE) {
						ValaExpression* arg;
						if (!gee_iterator_next (_arg_it)) {
							break;
						}
						arg = (ValaExpression*) gee_iterator_get (_arg_it);
						vala_ccode_function_call_add_argument (creation_call, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)));
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					}
					(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
				}
				_tmp86_ = NULL;
				_tmp85_ = NULL;
				creation_expr = (_tmp86_ = (_tmp85_ = (ValaCCodeExpression*) creation_call, (_tmp85_ == NULL) ? NULL : vala_ccode_node_ref (_tmp85_)), (creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL)), _tmp86_);
				(ecode == NULL) ? NULL : (ecode = (vala_code_node_unref (ecode), NULL));
				(edomain == NULL) ? NULL : (edomain = (vala_code_node_unref (edomain), NULL));
				(creation_call == NULL) ? NULL : (creation_call = (vala_ccode_node_unref (creation_call), NULL));
			} else {
				g_assert (FALSE);
			}
		}
	}
	if (instance != NULL) {
		ValaCCodeCommaExpression* ccomma;
		ccomma = vala_ccode_comma_expression_new ();
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			vala_ccode_comma_expression_append_expression (ccomma, creation_expr);
		} else {
			ValaCCodeAssignment* _tmp87_;
			_tmp87_ = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp87_ = vala_ccode_assignment_new (instance, creation_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp87_ == NULL) ? NULL : (_tmp87_ = (vala_ccode_node_unref (_tmp87_), NULL));
		}
		{
			GeeList* _tmp88_;
			GeeIterator* _tmp89_;
			GeeIterator* _init_it;
			_tmp88_ = NULL;
			_tmp89_ = NULL;
			_init_it = (_tmp89_ = gee_iterable_iterator ((GeeIterable*) (_tmp88_ = vala_object_creation_expression_get_object_initializer (expr))), (_tmp88_ == NULL) ? NULL : (_tmp88_ = (gee_collection_object_unref (_tmp88_), NULL)), _tmp89_);
			while (TRUE) {
				ValaMemberInitializer* init;
				if (!gee_iterator_next (_init_it)) {
					break;
				}
				init = (ValaMemberInitializer*) gee_iterator_get (_init_it);
				if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
					ValaField* _tmp90_;
					ValaField* f;
					ValaDataType* instance_target_type;
					ValaCCodeExpression* typed_inst;
					ValaCCodeExpression* lhs;
					ValaCCodeAssignment* _tmp95_;
					gboolean _tmp96_;
					_tmp90_ = NULL;
					f = (_tmp90_ = VALA_FIELD (vala_member_initializer_get_symbol_reference (init)), (_tmp90_ == NULL) ? NULL : vala_code_node_ref (_tmp90_));
					instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) f)));
					typed_inst = vala_ccode_base_module_transform_expression (self, instance, vala_object_creation_expression_get_type_reference (expr), instance_target_type, NULL);
					lhs = NULL;
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
						ValaCCodeExpression* _tmp92_;
						char* _tmp91_;
						_tmp92_ = NULL;
						_tmp91_ = NULL;
						lhs = (_tmp92_ = (ValaCCodeExpression*) vala_ccode_member_access_new (typed_inst, _tmp91_ = vala_field_get_cname (f), FALSE), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp92_);
						_tmp91_ = (g_free (_tmp91_), NULL);
					} else {
						ValaCCodeExpression* _tmp94_;
						char* _tmp93_;
						_tmp94_ = NULL;
						_tmp93_ = NULL;
						lhs = (_tmp94_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, _tmp93_ = vala_field_get_cname (f)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp94_);
						_tmp93_ = (g_free (_tmp93_), NULL);
					}
					_tmp95_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp95_ = vala_ccode_assignment_new (lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_initializer_get_initializer (init))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp95_ == NULL) ? NULL : (_tmp95_ = (vala_ccode_node_unref (_tmp95_), NULL));
					_tmp96_ = FALSE;
					if (VALA_IS_ARRAY_TYPE (vala_field_get_field_type (f))) {
						_tmp96_ = !vala_field_get_no_array_length (f);
					} else {
						_tmp96_ = FALSE;
					}
					if (_tmp96_) {
						ValaArrayType* _tmp97_;
						ValaArrayType* array_type;
						_tmp97_ = NULL;
						array_type = (_tmp97_ = VALA_ARRAY_TYPE (vala_field_get_field_type (f)), (_tmp97_ == NULL) ? NULL : vala_code_node_ref (_tmp97_));
						{
							gint dim;
							dim = 1;
							{
								gboolean _tmp98_;
								_tmp98_ = TRUE;
								while (TRUE) {
									ValaCCodeExpression* rhs_array_len;
									ValaCCodeAssignment* _tmp105_;
									if (!_tmp98_) {
										dim++;
									}
									_tmp98_ = FALSE;
									if (!(dim <= vala_array_type_get_rank (array_type))) {
										break;
									}
									if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
										ValaCCodeExpression* _tmp101_;
										char* _tmp100_;
										char* _tmp99_;
										_tmp101_ = NULL;
										_tmp100_ = NULL;
										_tmp99_ = NULL;
										lhs = (_tmp101_ = (ValaCCodeExpression*) vala_ccode_member_access_new (typed_inst, _tmp100_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp99_ = vala_field_get_cname (f), dim), FALSE), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp101_);
										_tmp100_ = (g_free (_tmp100_), NULL);
										_tmp99_ = (g_free (_tmp99_), NULL);
									} else {
										ValaCCodeExpression* _tmp104_;
										char* _tmp103_;
										char* _tmp102_;
										_tmp104_ = NULL;
										_tmp103_ = NULL;
										_tmp102_ = NULL;
										lhs = (_tmp104_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, _tmp103_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp102_ = vala_field_get_cname (f), dim)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp104_);
										_tmp103_ = (g_free (_tmp103_), NULL);
										_tmp102_ = (g_free (_tmp102_), NULL);
									}
									rhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_initializer_get_initializer (init), dim);
									_tmp105_ = NULL;
									vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp105_ = vala_ccode_assignment_new (lhs, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
									(_tmp105_ == NULL) ? NULL : (_tmp105_ = (vala_ccode_node_unref (_tmp105_), NULL));
									(rhs_array_len == NULL) ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL));
								}
							}
						}
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					} else {
						gboolean _tmp106_;
						_tmp106_ = FALSE;
						if (VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
							_tmp106_ = !vala_field_get_no_delegate_target (f);
						} else {
							_tmp106_ = FALSE;
						}
						if (_tmp106_) {
							ValaCCodeExpression* rhs_delegate_target;
							ValaCCodeAssignment* _tmp113_;
							if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
								ValaCCodeExpression* _tmp109_;
								char* _tmp108_;
								char* _tmp107_;
								_tmp109_ = NULL;
								_tmp108_ = NULL;
								_tmp107_ = NULL;
								lhs = (_tmp109_ = (ValaCCodeExpression*) vala_ccode_member_access_new (typed_inst, _tmp108_ = vala_ccode_base_module_get_delegate_target_cname (self, _tmp107_ = vala_field_get_cname (f)), FALSE), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp109_);
								_tmp108_ = (g_free (_tmp108_), NULL);
								_tmp107_ = (g_free (_tmp107_), NULL);
							} else {
								ValaCCodeExpression* _tmp112_;
								char* _tmp111_;
								char* _tmp110_;
								_tmp112_ = NULL;
								_tmp111_ = NULL;
								_tmp110_ = NULL;
								lhs = (_tmp112_ = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, _tmp111_ = vala_ccode_base_module_get_delegate_target_cname (self, _tmp110_ = vala_field_get_cname (f))), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp112_);
								_tmp111_ = (g_free (_tmp111_), NULL);
								_tmp110_ = (g_free (_tmp110_), NULL);
							}
							rhs_delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (self, vala_member_initializer_get_initializer (init));
							_tmp113_ = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp113_ = vala_ccode_assignment_new (lhs, rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp113_ == NULL) ? NULL : (_tmp113_ = (vala_ccode_node_unref (_tmp113_), NULL));
							(rhs_delegate_target == NULL) ? NULL : (rhs_delegate_target = (vala_ccode_node_unref (rhs_delegate_target), NULL));
						}
					}
					(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
					(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
					(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
					(lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL));
				} else {
					if (VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init))) {
						ValaMemberAccess* inst_ma;
						ValaMemberAccess* ma;
						ValaCCodeFunctionCall* _tmp114_;
						inst_ma = vala_member_access_new_simple ("new", NULL);
						vala_expression_set_value_type ((ValaExpression*) inst_ma, vala_object_creation_expression_get_type_reference (expr));
						vala_code_node_set_ccodenode ((ValaCodeNode*) inst_ma, (ValaCCodeNode*) instance);
						ma = vala_member_access_new ((ValaExpression*) inst_ma, vala_member_initializer_get_name (init), NULL);
						_tmp114_ = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp114_ = vala_ccode_base_module_get_property_set_call (self, VALA_PROPERTY (vala_member_initializer_get_symbol_reference (init)), ma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_initializer_get_initializer (init))), NULL)));
						(_tmp114_ == NULL) ? NULL : (_tmp114_ = (vala_ccode_node_unref (_tmp114_), NULL));
						(inst_ma == NULL) ? NULL : (inst_ma = (vala_code_node_unref (inst_ma), NULL));
						(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
					}
				}
				(init == NULL) ? NULL : (init = (vala_code_node_unref (init), NULL));
			}
			(_init_it == NULL) ? NULL : (_init_it = (gee_collection_object_unref (_init_it), NULL));
		}
		vala_ccode_comma_expression_append_expression (ccomma, instance);
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	} else {
		if (creation_expr != NULL) {
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) creation_expr);
		}
	}
	(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
	(creation_expr == NULL) ? NULL : (creation_expr = (vala_ccode_node_unref (creation_expr), NULL));
	(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr) {
	ValaCCodeExpression* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCCodeExpression* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	g_return_val_if_fail (arg != NULL, NULL);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	if (!VALA_IS_NULL_TYPE (vala_expression_get_value_type (arg))) {
		_tmp1_ = VALA_IS_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param)));
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !vala_struct_is_simple_type (VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))));
	} else {
		_tmp0_ = FALSE;
	}
	/* pass non-simple struct instances always by reference*/
	if (_tmp0_) {
		gboolean _tmp2_;
		_tmp2_ = FALSE;
		if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
			_tmp2_ = !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param));
		} else {
			_tmp2_ = FALSE;
		}
		/* we already use a reference for arguments of ref, out, and nullable parameters*/
		if (_tmp2_) {
			ValaCCodeUnaryExpression* _tmp4_;
			ValaCCodeExpression* _tmp3_;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp5_;
			_tmp4_ = NULL;
			_tmp3_ = NULL;
			unary = (_tmp4_ = (_tmp3_ = cexpr, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp3_) ? ((ValaCCodeUnaryExpression*) _tmp3_) : NULL), (_tmp4_ == NULL) ? NULL : vala_ccode_node_ref (_tmp4_));
			_tmp5_ = FALSE;
			if (unary != NULL) {
				_tmp5_ = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				ValaCCodeExpression* _tmp6_;
				/* *expr => expr*/
				_tmp6_ = NULL;
				result = (_tmp6_ = vala_ccode_unary_expression_get_inner (unary), (_tmp6_ == NULL) ? NULL : vala_ccode_node_ref (_tmp6_));
				(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
				return result;
			} else {
				gboolean _tmp7_;
				_tmp7_ = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (cexpr)) {
					_tmp7_ = TRUE;
				} else {
					_tmp7_ = VALA_IS_CCODE_MEMBER_ACCESS (cexpr);
				}
				if (_tmp7_) {
					result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr);
					(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
					return result;
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp9_;
					ValaCCodeExpression* _tmp8_;
					ValaCCodeUnaryExpression* _tmp11_;
					ValaCCodeIdentifier* _tmp10_;
					/* if cexpr is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable (self, vala_formal_parameter_get_parameter_type (param), TRUE, NULL);
					gee_list_insert ((GeeList*) self->temp_vars, 0, temp_var);
					_tmp9_ = NULL;
					_tmp8_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_assignment_new (_tmp8_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_var)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
					(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
					_tmp11_ = NULL;
					_tmp10_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_var))))));
					(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
					(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
					result = (ValaCCodeExpression*) ccomma;
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
					return result;
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		}
	}
	_tmp12_ = NULL;
	result = (_tmp12_ = cexpr, (_tmp12_ == NULL) ? NULL : vala_ccode_node_ref (_tmp12_));
	return result;
}


static void vala_ccode_base_module_real_visit_sizeof_expression (ValaCCodeModule* base, ValaSizeofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* csizeof;
	ValaCCodeIdentifier* _tmp3_;
	char* _tmp2_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	csizeof = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("sizeof"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new (_tmp2_ = vala_data_type_get_cname (vala_sizeof_expression_get_type_reference (expr)))));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp2_ = (g_free (_tmp2_), NULL);
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) csizeof);
	(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
}


static void vala_ccode_base_module_real_visit_typeof_expression (ValaCCodeModule* base, ValaTypeofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0_ = vala_ccode_base_module_get_type_id_expression (self, vala_typeof_expression_get_type_reference (expr), FALSE)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
}


static void vala_ccode_base_module_real_visit_unary_expression (ValaCCodeModule* base, ValaUnaryExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	op = 0;
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								} else {
									g_assert_not_reached ();
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0_ = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (expr))))));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
}


static void vala_ccode_base_module_real_visit_cast_expression (ValaCCodeModule* base, ValaCastExpression* expr) {
	ValaCCodeBaseModule * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaClass* _tmp9_;
	ValaTypeSymbol* _tmp8_;
	ValaClass* cl;
	ValaInterface* _tmp11_;
	ValaTypeSymbol* _tmp10_;
	ValaInterface* iface;
	gboolean _tmp12_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
	_tmp2_ = FALSE;
	if (vala_expression_get_value_type (vala_cast_expression_get_inner (expr)) != NULL) {
		_tmp2_ = self->gvalue_type != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = vala_data_type_get_data_type (vala_expression_get_value_type (vala_cast_expression_get_inner (expr))) == VALA_TYPESYMBOL (self->gvalue_type);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		char* _tmp3_;
		_tmp3_ = NULL;
		_tmp0_ = (_tmp3_ = vala_data_type_get_type_id (vala_cast_expression_get_type_reference (expr))) != NULL;
		_tmp3_ = (g_free (_tmp3_), NULL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeIdentifier* _tmp5_;
		char* _tmp4_;
		ValaCCodeFunctionCall* _tmp6_;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeUnaryExpression* _tmp7_;
		/* explicit conversion from GValue*/
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		_tmp6_ = NULL;
		ccall = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new (_tmp4_ = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)))))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp4_ = (g_free (_tmp4_), NULL), _tmp6_);
		_tmp7_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_cast_expression_get_inner (expr))))));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		return;
	}
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	cl = (_tmp9_ = (_tmp8_ = vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)), VALA_IS_CLASS (_tmp8_) ? ((ValaClass*) _tmp8_) : NULL), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_));
	_tmp11_ = NULL;
	_tmp10_ = NULL;
	iface = (_tmp11_ = (_tmp10_ = vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)), VALA_IS_INTERFACE (_tmp10_) ? ((ValaInterface*) _tmp10_) : NULL), (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_));
	_tmp12_ = FALSE;
	if (vala_code_context_get_profile (self->priv->_context) == VALA_PROFILE_GOBJECT) {
		gboolean _tmp13_;
		_tmp13_ = FALSE;
		if (iface != NULL) {
			_tmp13_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = FALSE;
			if (cl != NULL) {
				_tmp14_ = !vala_class_get_is_compact (cl);
			} else {
				_tmp14_ = FALSE;
			}
			_tmp13_ = _tmp14_;
		}
		_tmp12_ = _tmp13_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		/* checked cast for strict subtypes of GTypeInstance*/
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeExpression* ctemp;
			ValaCCodeAssignment* cinit;
			ValaCCodeExpression* ccheck;
			char* _tmp15_;
			ValaCCodeCastExpression* _tmp16_;
			ValaCCodeCastExpression* ccast;
			ValaCCodeConstant* cnull;
			ValaCCodeConditionalExpression* _tmp17_;
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (vala_cast_expression_get_inner (expr)), TRUE, (ValaCodeNode*) expr);
			gee_collection_add ((GeeCollection*) self->temp_vars, temp_decl);
			ctemp = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
			cinit = vala_ccode_assignment_new (ctemp, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_cast_expression_get_inner (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			ccheck = vala_ccode_base_module_create_type_check (self, (ValaCCodeNode*) ctemp, vala_cast_expression_get_type_reference (expr));
			_tmp15_ = NULL;
			_tmp16_ = NULL;
			ccast = (_tmp16_ = vala_ccode_cast_expression_new (ctemp, _tmp15_ = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr))), _tmp15_ = (g_free (_tmp15_), NULL), _tmp16_);
			cnull = vala_ccode_constant_new ("NULL");
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cinit);
			_tmp17_ = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp17_ = vala_ccode_conditional_expression_new (ccheck, (ValaCCodeExpression*) ccast, (ValaCCodeExpression*) cnull)));
			(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
			(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
			(cinit == NULL) ? NULL : (cinit = (vala_ccode_node_unref (cinit), NULL));
			(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
			(cnull == NULL) ? NULL : (cnull = (vala_ccode_node_unref (cnull), NULL));
		} else {
			ValaInstanceCast* _tmp18_;
			_tmp18_ = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp18_ = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_cast_expression_get_inner (expr))), vala_data_type_get_data_type (vala_cast_expression_get_type_reference (expr)))));
			(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
		}
	} else {
		ValaArrayType* _tmp20_;
		ValaDataType* _tmp19_;
		ValaArrayType* array_type;
		ValaCCodeCastExpression* _tmp24_;
		char* _tmp23_;
		if (vala_cast_expression_get_is_silent_cast (expr)) {
			vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), "Operation not supported for this type");
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			return;
		}
		/* retain array length*/
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		array_type = (_tmp20_ = (_tmp19_ = vala_cast_expression_get_type_reference (expr), VALA_IS_ARRAY_TYPE (_tmp19_) ? ((ValaArrayType*) _tmp19_) : NULL), (_tmp20_ == NULL) ? NULL : vala_code_node_ref (_tmp20_));
		if (array_type != NULL) {
			{
				gint dim;
				dim = 1;
				{
					gboolean _tmp21_;
					_tmp21_ = TRUE;
					while (TRUE) {
						ValaCCodeExpression* _tmp22_;
						if (!_tmp21_) {
							dim++;
						}
						_tmp21_ = FALSE;
						if (!(dim <= vala_array_type_get_rank (array_type))) {
							break;
						}
						_tmp22_ = NULL;
						vala_expression_append_array_size ((ValaExpression*) expr, _tmp22_ = vala_ccode_module_get_array_length_cexpression ((ValaCCodeModule*) self, vala_cast_expression_get_inner (expr), dim));
						(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
					}
				}
			}
		}
		_tmp24_ = NULL;
		_tmp23_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp24_ = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_cast_expression_get_inner (expr))), _tmp23_ = vala_data_type_get_cname (vala_cast_expression_get_type_reference (expr)))));
		(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
		_tmp23_ = (g_free (_tmp23_), NULL);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
}


static void vala_ccode_base_module_real_visit_pointer_indirection (ValaCCodeModule* base, ValaPointerIndirection* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryExpression* _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_pointer_indirection_get_inner (expr))))));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
}


static void vala_ccode_base_module_real_visit_addressof_expression (ValaCCodeModule* base, ValaAddressofExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeUnaryExpression* _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_addressof_expression_get_inner (expr))))));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
}


static void vala_ccode_base_module_real_visit_reference_transfer_expression (ValaCCodeModule* base, ValaReferenceTransferExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* temp_decl;
	ValaCCodeExpression* cvar;
	ValaCCodeAssignment* _tmp0_;
	ValaCCodeAssignment* _tmp2_;
	ValaCCodeConstant* _tmp1_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* (tmp = var, var = null, tmp) */
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type ((ValaExpression*) expr), TRUE, (ValaCodeNode*) expr);
	gee_list_insert ((GeeList*) self->temp_vars, 0, temp_decl);
	cvar = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
	_tmp0_ = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp0_ = vala_ccode_assignment_new (cvar, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (expr))), (ValaCCodeExpression*) (_tmp1_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	vala_ccode_comma_expression_append_expression (ccomma, cvar);
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
	(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
	(cvar == NULL) ? NULL : (cvar = (vala_ccode_node_unref (cvar), NULL));
}


static void vala_ccode_base_module_real_visit_binary_expression (ValaCCodeModule* base, ValaBinaryExpression* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* cleft;
	ValaCCodeExpression* _tmp1_;
	ValaCCodeExpression* cright;
	ValaCCodeBinaryOperator op;
	gboolean _tmp4_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	ValaCCodeBinaryExpression* _tmp47_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0_ = NULL;
	cleft = (_tmp0_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_binary_expression_get_left (expr))), (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
	_tmp1_ = NULL;
	cright = (_tmp1_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_binary_expression_get_right (expr))), (_tmp1_ == NULL) ? NULL : vala_ccode_node_ref (_tmp1_));
	op = 0;
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		} else {
																			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_IN) {
																				ValaCCodeBinaryExpression* _tmp3_;
																				ValaCCodeBinaryExpression* _tmp2_;
																				_tmp3_ = NULL;
																				_tmp2_ = NULL;
																				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp3_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_BITWISE_AND, cright, cleft)), cleft)));
																				(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
																				(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
																				(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
																				(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
																				return;
																			} else {
																				g_assert_not_reached ();
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp4_ = FALSE;
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY;
	}
	if (_tmp4_) {
		ValaStruct* _tmp6_;
		ValaTypeSymbol* _tmp5_;
		ValaStruct* left_type_as_struct;
		ValaStruct* _tmp8_;
		ValaTypeSymbol* _tmp7_;
		ValaStruct* right_type_as_struct;
		gboolean _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		left_type_as_struct = (_tmp6_ = (_tmp5_ = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr))), VALA_IS_STRUCT (_tmp5_) ? ((ValaStruct*) _tmp5_) : NULL), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		right_type_as_struct = (_tmp8_ = (_tmp7_ = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))), VALA_IS_STRUCT (_tmp7_) ? ((ValaStruct*) _tmp7_) : NULL), (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_));
		_tmp9_ = FALSE;
		_tmp10_ = FALSE;
		_tmp11_ = FALSE;
		if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr))))) {
			_tmp11_ = !vala_class_get_is_compact (VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))));
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			_tmp10_ = VALA_IS_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))));
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			_tmp9_ = !vala_class_get_is_compact (VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))));
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaClass* _tmp12_;
			ValaClass* left_cl;
			ValaClass* _tmp13_;
			ValaClass* right_cl;
			_tmp12_ = NULL;
			left_cl = (_tmp12_ = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))), (_tmp12_ == NULL) ? NULL : vala_code_node_ref (_tmp12_));
			_tmp13_ = NULL;
			right_cl = (_tmp13_ = VALA_CLASS (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))), (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_));
			if (left_cl != right_cl) {
				if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) left_cl, (ValaTypeSymbol*) right_cl)) {
					ValaCCodeExpression* _tmp14_;
					_tmp14_ = NULL;
					cleft = (_tmp14_ = (ValaCCodeExpression*) vala_instance_cast_new (cleft, (ValaTypeSymbol*) right_cl), (cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)), _tmp14_);
				} else {
					if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) right_cl, (ValaTypeSymbol*) left_cl)) {
						ValaCCodeExpression* _tmp15_;
						_tmp15_ = NULL;
						cright = (_tmp15_ = (ValaCCodeExpression*) vala_instance_cast_new (cright, (ValaTypeSymbol*) left_cl), (cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)), _tmp15_);
					}
				}
			}
			(left_cl == NULL) ? NULL : (left_cl = (vala_code_node_unref (left_cl), NULL));
			(right_cl == NULL) ? NULL : (right_cl = (vala_code_node_unref (right_cl), NULL));
		} else {
			gboolean _tmp16_;
			_tmp16_ = FALSE;
			if (left_type_as_struct != NULL) {
				_tmp16_ = right_type_as_struct != NULL;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				gboolean _tmp17_;
				_tmp17_ = FALSE;
				if (vala_data_type_get_nullable (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))) {
					_tmp17_ = vala_data_type_get_nullable (vala_expression_get_value_type (vala_binary_expression_get_right (expr)));
				} else {
					_tmp17_ = FALSE;
				}
				/* FIXME generate and use compare/equal function for real structs*/
				if (_tmp17_) {
				} else {
					if (vala_data_type_get_nullable (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))) {
						ValaCCodeExpression* _tmp18_;
						/* FIXME check left value is not null*/
						_tmp18_ = NULL;
						cleft = (_tmp18_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, cleft), (cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)), _tmp18_);
					} else {
						if (vala_data_type_get_nullable (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))) {
							ValaCCodeExpression* _tmp19_;
							/* FIXME check right value is not null*/
							_tmp19_ = NULL;
							cright = (_tmp19_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, cright), (cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)), _tmp19_);
						}
					}
				}
			}
		}
		(left_type_as_struct == NULL) ? NULL : (left_type_as_struct = (vala_code_node_unref (left_type_as_struct), NULL));
		(right_type_as_struct == NULL) ? NULL : (right_type_as_struct = (vala_code_node_unref (right_type_as_struct), NULL));
	}
	_tmp20_ = FALSE;
	_tmp21_ = FALSE;
	_tmp22_ = FALSE;
	if (!VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))) {
		_tmp22_ = vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_left (expr)), self->string_type);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		_tmp21_ = !VALA_IS_NULL_TYPE (vala_expression_get_value_type (vala_binary_expression_get_right (expr)));
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		_tmp20_ = vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_right (expr)), self->string_type);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
			gboolean _tmp23_;
			_tmp23_ = FALSE;
			if (vala_expression_is_constant (vala_binary_expression_get_left (expr))) {
				_tmp23_ = vala_expression_is_constant (vala_binary_expression_get_right (expr));
			} else {
				_tmp23_ = FALSE;
			}
			/* string concatenation*/
			if (_tmp23_) {
				char* left;
				char* right;
				ValaCCodeConstant* _tmp33_;
				char* _tmp32_;
				left = NULL;
				right = NULL;
				if (VALA_IS_CCODE_IDENTIFIER (cleft)) {
					char* _tmp25_;
					const char* _tmp24_;
					_tmp25_ = NULL;
					_tmp24_ = NULL;
					left = (_tmp25_ = (_tmp24_ = vala_ccode_identifier_get_name (VALA_CCODE_IDENTIFIER (cleft)), (_tmp24_ == NULL) ? NULL : g_strdup (_tmp24_)), left = (g_free (left), NULL), _tmp25_);
				} else {
					if (VALA_IS_CCODE_CONSTANT (cleft)) {
						char* _tmp27_;
						const char* _tmp26_;
						_tmp27_ = NULL;
						_tmp26_ = NULL;
						left = (_tmp27_ = (_tmp26_ = vala_ccode_constant_get_name (VALA_CCODE_CONSTANT (cleft)), (_tmp26_ == NULL) ? NULL : g_strdup (_tmp26_)), left = (g_free (left), NULL), _tmp27_);
					} else {
						g_assert_not_reached ();
					}
				}
				if (VALA_IS_CCODE_IDENTIFIER (cright)) {
					char* _tmp29_;
					const char* _tmp28_;
					_tmp29_ = NULL;
					_tmp28_ = NULL;
					right = (_tmp29_ = (_tmp28_ = vala_ccode_identifier_get_name (VALA_CCODE_IDENTIFIER (cright)), (_tmp28_ == NULL) ? NULL : g_strdup (_tmp28_)), right = (g_free (right), NULL), _tmp29_);
				} else {
					if (VALA_IS_CCODE_CONSTANT (cright)) {
						char* _tmp31_;
						const char* _tmp30_;
						_tmp31_ = NULL;
						_tmp30_ = NULL;
						right = (_tmp31_ = (_tmp30_ = vala_ccode_constant_get_name (VALA_CCODE_CONSTANT (cright)), (_tmp30_ == NULL) ? NULL : g_strdup (_tmp30_)), right = (g_free (right), NULL), _tmp31_);
					} else {
						g_assert_not_reached ();
					}
				}
				_tmp33_ = NULL;
				_tmp32_ = NULL;
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp33_ = vala_ccode_constant_new (_tmp32_ = g_strdup_printf ("%s %s", left, right))));
				(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
				_tmp32_ = (g_free (_tmp32_), NULL);
				left = (g_free (left), NULL);
				right = (g_free (right), NULL);
				(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
				(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
				return;
			} else {
				ValaCCodeIdentifier* _tmp34_;
				ValaCCodeFunctionCall* _tmp35_;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeConstant* _tmp36_;
				/* convert to g_strconcat (a, b, NULL)*/
				_tmp34_ = NULL;
				_tmp35_ = NULL;
				ccall = (_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new ("g_strconcat"))), (_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL)), _tmp35_);
				vala_ccode_function_call_add_argument (ccall, cleft);
				vala_ccode_function_call_add_argument (ccall, cright);
				_tmp36_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_constant_new ("NULL")));
				(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
				vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
				(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
				(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
				(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
				return;
			}
		} else {
			gboolean _tmp37_;
			gboolean _tmp38_;
			gboolean _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp37_ = FALSE;
			_tmp38_ = FALSE;
			_tmp39_ = FALSE;
			_tmp40_ = FALSE;
			_tmp41_ = FALSE;
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
				_tmp41_ = TRUE;
			} else {
				_tmp41_ = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY;
			}
			if (_tmp41_) {
				_tmp40_ = TRUE;
			} else {
				_tmp40_ = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN;
			}
			if (_tmp40_) {
				_tmp39_ = TRUE;
			} else {
				_tmp39_ = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN;
			}
			if (_tmp39_) {
				_tmp38_ = TRUE;
			} else {
				_tmp38_ = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
			}
			if (_tmp38_) {
				_tmp37_ = TRUE;
			} else {
				_tmp37_ = vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
			}
			if (_tmp37_) {
				ValaCCodeIdentifier* _tmp42_;
				ValaCCodeFunctionCall* _tmp43_;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeExpression* _tmp45_;
				ValaCCodeExpression* _tmp44_;
				ValaCCodeExpression* _tmp46_;
				self->requires_strcmp0 = TRUE;
				_tmp42_ = NULL;
				_tmp43_ = NULL;
				ccall = (_tmp43_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new ("_vala_strcmp0"))), (_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL)), _tmp43_);
				vala_ccode_function_call_add_argument (ccall, cleft);
				vala_ccode_function_call_add_argument (ccall, cright);
				_tmp45_ = NULL;
				_tmp44_ = NULL;
				cleft = (_tmp45_ = (_tmp44_ = (ValaCCodeExpression*) ccall, (_tmp44_ == NULL) ? NULL : vala_ccode_node_ref (_tmp44_)), (cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL)), _tmp45_);
				_tmp46_ = NULL;
				cright = (_tmp46_ = (ValaCCodeExpression*) vala_ccode_constant_new ("0"), (cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL)), _tmp46_);
				(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			}
		}
	}
	_tmp47_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp47_ = vala_ccode_binary_expression_new (op, cleft, cright)));
	(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	(cleft == NULL) ? NULL : (cleft = (vala_ccode_node_unref (cleft), NULL));
	(cright == NULL) ? NULL : (cright = (vala_ccode_node_unref (cright), NULL));
}


char* vala_ccode_base_module_get_type_check_function (ValaCCodeBaseModule* self, ValaTypeSymbol* type) {
	char* result;
	ValaClass* _tmp1_;
	ValaTypeSymbol* _tmp0_;
	ValaClass* cl;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	cl = (_tmp1_ = (_tmp0_ = type, VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (cl != NULL) {
		_tmp2_ = vala_class_get_type_check_function (cl) != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const char* _tmp3_;
		_tmp3_ = NULL;
		result = (_tmp3_ = vala_class_get_type_check_function (cl), (_tmp3_ == NULL) ? NULL : g_strdup (_tmp3_));
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return result;
	} else {
		result = vala_typesymbol_get_upper_case_cname (type, "IS_");
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return result;
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static ValaCCodeExpression* vala_ccode_base_module_create_type_check (ValaCCodeBaseModule* self, ValaCCodeNode* ccodenode, ValaDataType* type) {
	ValaCCodeExpression* result;
	ValaErrorType* _tmp1_;
	ValaDataType* _tmp0_;
	ValaErrorType* et;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ccodenode != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	et = (_tmp1_ = (_tmp0_ = type, VALA_IS_ERROR_TYPE (_tmp0_) ? ((ValaErrorType*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (et != NULL) {
		_tmp2_ = vala_error_type_get_error_code (et) != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeFunctionCall* _tmp4_;
		ValaCCodeFunctionCall* matches_call;
		ValaCCodeIdentifier* _tmp6_;
		char* _tmp5_;
		ValaCCodeIdentifier* _tmp8_;
		char* _tmp7_;
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		matches_call = (_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("g_error_matches"))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL)), _tmp4_);
		vala_ccode_function_call_add_argument (matches_call, VALA_CCODE_EXPRESSION (ccodenode));
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		vala_ccode_function_call_add_argument (matches_call, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new (_tmp5_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) vala_error_type_get_error_domain (et), NULL))));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
		_tmp5_ = (g_free (_tmp5_), NULL);
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		vala_ccode_function_call_add_argument (matches_call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new (_tmp7_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_error_type_get_error_code (et), FALSE))));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		_tmp7_ = (g_free (_tmp7_), NULL);
		result = (ValaCCodeExpression*) matches_call;
		(et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL));
		return result;
	} else {
		gboolean _tmp9_;
		_tmp9_ = FALSE;
		if (et != NULL) {
			_tmp9_ = vala_error_type_get_error_domain (et) != NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaCCodeMemberAccess* instance_domain;
			char* _tmp10_;
			ValaCCodeIdentifier* _tmp11_;
			ValaCCodeIdentifier* type_domain;
			instance_domain = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccodenode), "domain");
			_tmp10_ = NULL;
			_tmp11_ = NULL;
			type_domain = (_tmp11_ = vala_ccode_identifier_new (_tmp10_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) vala_error_type_get_error_domain (et), NULL)), _tmp10_ = (g_free (_tmp10_), NULL), _tmp11_);
			result = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) instance_domain, (ValaCCodeExpression*) type_domain);
			(instance_domain == NULL) ? NULL : (instance_domain = (vala_ccode_node_unref (instance_domain), NULL));
			(type_domain == NULL) ? NULL : (type_domain = (vala_ccode_node_unref (type_domain), NULL));
			(et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL));
			return result;
		} else {
			ValaCCodeIdentifier* _tmp13_;
			char* _tmp12_;
			ValaCCodeFunctionCall* _tmp14_;
			ValaCCodeFunctionCall* ccheck;
			_tmp13_ = NULL;
			_tmp12_ = NULL;
			_tmp14_ = NULL;
			ccheck = (_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new (_tmp12_ = vala_ccode_base_module_get_type_check_function (self, vala_data_type_get_data_type (type))))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp12_ = (g_free (_tmp12_), NULL), _tmp14_);
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (ccodenode));
			result = (ValaCCodeExpression*) ccheck;
			(et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL));
			return result;
		}
	}
	(et == NULL) ? NULL : (et = (vala_code_node_unref (et), NULL));
}


static void vala_ccode_base_module_real_visit_type_check (ValaCCodeModule* base, ValaTypeCheck* expr) {
	ValaCCodeBaseModule * self;
	ValaCCodeExpression* _tmp0_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (expr != NULL);
	vala_ccode_base_module_generate_type_declaration (self, vala_typecheck_get_type_reference (expr), self->source_declarations);
	_tmp0_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp0_ = vala_ccode_base_module_create_type_check (self, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_typecheck_get_expression (expr)), vala_typecheck_get_type_reference (expr))));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
}


static void vala_ccode_base_module_real_visit_lambda_expression (ValaCCodeModule* base, ValaLambdaExpression* l) {
	ValaCCodeBaseModule * self;
	ValaDelegateType* _tmp0_;
	ValaDelegateType* dt;
	GeeArrayList* _tmp1_;
	GeeArrayList* old_temp_vars;
	GeeArrayList* _tmp2_;
	GeeArrayList* old_temp_ref_vars;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp7_;
	ValaCCodeIdentifier* _tmp10_;
	char* _tmp9_;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (l != NULL);
	/* use instance position from delegate*/
	_tmp0_ = NULL;
	dt = (_tmp0_ = VALA_DELEGATE_TYPE (vala_expression_get_target_type ((ValaExpression*) l)), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	vala_method_set_cinstance_parameter_position (vala_lambda_expression_get_method (l), vala_delegate_get_cinstance_parameter_position (vala_delegate_type_get_delegate_symbol (dt)));
	_tmp1_ = NULL;
	old_temp_vars = (_tmp1_ = self->temp_vars, (_tmp1_ == NULL) ? NULL : gee_collection_object_ref (_tmp1_));
	_tmp2_ = NULL;
	old_temp_ref_vars = (_tmp2_ = self->temp_ref_vars, (_tmp2_ == NULL) ? NULL : gee_collection_object_ref (_tmp2_));
	_tmp3_ = NULL;
	self->temp_vars = (_tmp3_ = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL)), _tmp3_);
	_tmp4_ = NULL;
	self->temp_ref_vars = (_tmp4_ = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal), (self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL)), _tmp4_);
	vala_code_node_accept_children ((ValaCodeNode*) l, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	self->temp_vars = (_tmp6_ = (_tmp5_ = old_temp_vars, (_tmp5_ == NULL) ? NULL : gee_collection_object_ref (_tmp5_)), (self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL)), _tmp6_);
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	self->temp_ref_vars = (_tmp8_ = (_tmp7_ = old_temp_ref_vars, (_tmp7_ == NULL) ? NULL : gee_collection_object_ref (_tmp7_)), (self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL)), _tmp8_);
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) l, (ValaCCodeNode*) (_tmp10_ = vala_ccode_identifier_new (_tmp9_ = vala_method_get_cname (vala_lambda_expression_get_method (l)))));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp9_ = (g_free (_tmp9_), NULL);
	(dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL));
	(old_temp_vars == NULL) ? NULL : (old_temp_vars = (gee_collection_object_unref (old_temp_vars), NULL));
	(old_temp_ref_vars == NULL) ? NULL : (old_temp_ref_vars = (gee_collection_object_unref (old_temp_ref_vars), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_convert_from_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* result;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* _result_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (actual_type != NULL, NULL);
	_tmp0_ = NULL;
	_result_ = (_tmp0_ = cexpr, (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
	_tmp1_ = FALSE;
	if (vala_ccode_base_module_is_reference_type_argument (self, actual_type)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = vala_ccode_base_module_is_nullable_value_type_argument (self, actual_type);
	}
	if (_tmp1_) {
		ValaCCodeExpression* _tmp3_;
		char* _tmp2_;
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		_result_ = (_tmp3_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, _tmp2_ = vala_data_type_get_cname (actual_type)), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp3_);
		_tmp2_ = (g_free (_tmp2_), NULL);
	} else {
		if (vala_ccode_base_module_is_signed_integer_type_argument (self, actual_type)) {
			ValaCCodeIdentifier* _tmp4_;
			ValaCCodeFunctionCall* _tmp5_;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp7_;
			ValaCCodeExpression* _tmp6_;
			_tmp4_ = NULL;
			_tmp5_ = NULL;
			cconv = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("GPOINTER_TO_INT"))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp5_);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			_result_ = (_tmp7_ = (_tmp6_ = (ValaCCodeExpression*) cconv, (_tmp6_ == NULL) ? NULL : vala_ccode_node_ref (_tmp6_)), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp7_);
			(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
		} else {
			if (vala_ccode_base_module_is_unsigned_integer_type_argument (self, actual_type)) {
				ValaCCodeIdentifier* _tmp8_;
				ValaCCodeFunctionCall* _tmp9_;
				ValaCCodeFunctionCall* cconv;
				ValaCCodeExpression* _tmp11_;
				ValaCCodeExpression* _tmp10_;
				_tmp8_ = NULL;
				_tmp9_ = NULL;
				cconv = (_tmp9_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("GPOINTER_TO_UINT"))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp9_);
				vala_ccode_function_call_add_argument (cconv, cexpr);
				_tmp11_ = NULL;
				_tmp10_ = NULL;
				_result_ = (_tmp11_ = (_tmp10_ = (ValaCCodeExpression*) cconv, (_tmp10_ == NULL) ? NULL : vala_ccode_node_ref (_tmp10_)), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp11_);
				(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
			}
		}
	}
	result = _result_;
	return result;
}


ValaCCodeExpression* vala_ccode_base_module_convert_to_generic_pointer (ValaCCodeBaseModule* self, ValaCCodeExpression* cexpr, ValaDataType* actual_type) {
	ValaCCodeExpression* result;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	g_return_val_if_fail (actual_type != NULL, NULL);
	_tmp0_ = NULL;
	_result_ = (_tmp0_ = cexpr, (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
	if (vala_ccode_base_module_is_signed_integer_type_argument (self, actual_type)) {
		ValaCCodeIdentifier* _tmp1_;
		ValaCCodeFunctionCall* _tmp2_;
		ValaCCodeFunctionCall* cconv;
		ValaCCodeExpression* _tmp4_;
		ValaCCodeExpression* _tmp3_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		cconv = (_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new ("GINT_TO_POINTER"))), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL)), _tmp2_);
		vala_ccode_function_call_add_argument (cconv, cexpr);
		_tmp4_ = NULL;
		_tmp3_ = NULL;
		_result_ = (_tmp4_ = (_tmp3_ = (ValaCCodeExpression*) cconv, (_tmp3_ == NULL) ? NULL : vala_ccode_node_ref (_tmp3_)), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp4_);
		(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
	} else {
		if (vala_ccode_base_module_is_unsigned_integer_type_argument (self, actual_type)) {
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeFunctionCall* _tmp6_;
			ValaCCodeFunctionCall* cconv;
			ValaCCodeExpression* _tmp8_;
			ValaCCodeExpression* _tmp7_;
			_tmp5_ = NULL;
			_tmp6_ = NULL;
			cconv = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("GUINT_TO_POINTER"))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp6_);
			vala_ccode_function_call_add_argument (cconv, cexpr);
			_tmp8_ = NULL;
			_tmp7_ = NULL;
			_result_ = (_tmp8_ = (_tmp7_ = (ValaCCodeExpression*) cconv, (_tmp7_ == NULL) ? NULL : vala_ccode_node_ref (_tmp7_)), (_result_ == NULL) ? NULL : (_result_ = (vala_ccode_node_unref (_result_), NULL)), _tmp8_);
			(cconv == NULL) ? NULL : (cconv = (vala_ccode_node_unref (cconv), NULL));
		}
	}
	result = _result_;
	return result;
}


/* manage memory and implicit casts*/
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeExpression* result;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* cexpr;
	gboolean _tmp1_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean boxing;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean unboxing;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean gvalue_boxing;
	gboolean _tmp24_;
	gboolean _tmp82_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0_ = NULL;
	cexpr = (_tmp0_ = source_cexpr, (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
	if (expression_type == NULL) {
		result = cexpr;
		return result;
	}
	_tmp1_ = FALSE;
	if (vala_data_type_get_value_owned (expression_type)) {
		_tmp1_ = vala_data_type_get_floating_reference (expression_type);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaObjectTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp2_;
		ValaObjectTypeSymbol* cl;
		char* _tmp4_;
		const char* _tmp7_;
		char* sink_func;
		/* floating reference, sink it.
		 */
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		cl = (_tmp3_ = (_tmp2_ = vala_data_type_get_data_type (expression_type), VALA_IS_OBJECT_TYPE_SYMBOL (_tmp2_) ? ((ValaObjectTypeSymbol*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
		_tmp4_ = NULL;
		if (cl != NULL) {
			char* _tmp5_;
			_tmp5_ = NULL;
			_tmp4_ = (_tmp5_ = vala_typesymbol_get_ref_sink_function ((ValaTypeSymbol*) cl), _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_);
		} else {
			char* _tmp6_;
			_tmp6_ = NULL;
			_tmp4_ = (_tmp6_ = NULL, _tmp4_ = (g_free (_tmp4_), NULL), _tmp6_);
		}
		_tmp7_ = NULL;
		sink_func = (_tmp7_ = _tmp4_, (_tmp7_ == NULL) ? NULL : g_strdup (_tmp7_));
		if (sink_func != NULL) {
			ValaCCodeIdentifier* _tmp8_;
			ValaCCodeFunctionCall* _tmp9_;
			ValaCCodeFunctionCall* csink;
			ValaCCodeExpression* _tmp11_;
			ValaCCodeExpression* _tmp10_;
			_tmp8_ = NULL;
			_tmp9_ = NULL;
			csink = (_tmp9_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new (sink_func))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp9_);
			vala_ccode_function_call_add_argument (csink, cexpr);
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			cexpr = (_tmp11_ = (_tmp10_ = (ValaCCodeExpression*) csink, (_tmp10_ == NULL) ? NULL : vala_ccode_node_ref (_tmp10_)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp11_);
			(csink == NULL) ? NULL : (csink = (vala_ccode_node_unref (csink), NULL));
		} else {
			char* _tmp12_;
			_tmp12_ = NULL;
			vala_report_error (NULL, _tmp12_ = g_strdup_printf ("type `%s' does not support floating references", vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_data_type (expression_type))));
			_tmp12_ = (g_free (_tmp12_), NULL);
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		_tmp4_ = (g_free (_tmp4_), NULL);
		sink_func = (g_free (sink_func), NULL);
	}
	_tmp13_ = FALSE;
	_tmp14_ = FALSE;
	_tmp15_ = FALSE;
	if (VALA_IS_VALUE_TYPE (expression_type)) {
		_tmp15_ = !vala_data_type_get_nullable (expression_type);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_tmp14_ = VALA_IS_VALUE_TYPE (target_type);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		_tmp13_ = vala_data_type_get_nullable (target_type);
	} else {
		_tmp13_ = FALSE;
	}
	boxing = _tmp13_;
	_tmp16_ = FALSE;
	_tmp17_ = FALSE;
	_tmp18_ = FALSE;
	if (VALA_IS_VALUE_TYPE (expression_type)) {
		_tmp18_ = vala_data_type_get_nullable (expression_type);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		_tmp17_ = VALA_IS_VALUE_TYPE (target_type);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		_tmp16_ = !vala_data_type_get_nullable (target_type);
	} else {
		_tmp16_ = FALSE;
	}
	unboxing = _tmp16_;
	_tmp19_ = FALSE;
	_tmp20_ = FALSE;
	_tmp21_ = FALSE;
	_tmp22_ = FALSE;
	if (vala_code_context_get_profile (self->priv->_context) == VALA_PROFILE_GOBJECT) {
		_tmp22_ = target_type != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		_tmp21_ = vala_data_type_get_data_type (target_type) == VALA_TYPESYMBOL (self->gvalue_type);
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		_tmp20_ = !VALA_IS_NULL_TYPE (expression_type);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		char* _tmp23_;
		_tmp23_ = NULL;
		_tmp19_ = _vala_strcmp0 (_tmp23_ = vala_data_type_get_type_id (expression_type), "G_TYPE_VALUE") != 0;
		_tmp23_ = (g_free (_tmp23_), NULL);
	} else {
		_tmp19_ = FALSE;
	}
	gvalue_boxing = _tmp19_;
	_tmp24_ = FALSE;
	if (vala_data_type_get_value_owned (expression_type)) {
		gboolean _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
		gboolean _tmp28_;
		_tmp25_ = FALSE;
		_tmp26_ = FALSE;
		_tmp27_ = FALSE;
		_tmp28_ = FALSE;
		if (target_type == NULL) {
			_tmp28_ = TRUE;
		} else {
			_tmp28_ = !vala_data_type_get_value_owned (target_type);
		}
		if (_tmp28_) {
			_tmp27_ = TRUE;
		} else {
			_tmp27_ = boxing;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			_tmp26_ = unboxing;
		}
		if (_tmp26_) {
			_tmp25_ = TRUE;
		} else {
			_tmp25_ = gvalue_boxing;
		}
		_tmp24_ = _tmp25_;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		ValaPointerType* _tmp30_;
		ValaDataType* _tmp29_;
		ValaPointerType* pointer_type;
		gboolean _tmp31_;
		/* value leaked, destroy it*/
		_tmp30_ = NULL;
		_tmp29_ = NULL;
		pointer_type = (_tmp30_ = (_tmp29_ = target_type, VALA_IS_POINTER_TYPE (_tmp29_) ? ((ValaPointerType*) _tmp29_) : NULL), (_tmp30_ == NULL) ? NULL : vala_code_node_ref (_tmp30_));
		_tmp31_ = FALSE;
		if (pointer_type != NULL) {
			_tmp31_ = !VALA_IS_VOID_TYPE (vala_pointer_type_get_base_type (pointer_type));
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
		} else {
			if (vala_ccode_base_module_requires_destroy (self, expression_type)) {
				ValaLocalVariable* decl;
				ValaCCodeExpression* _tmp33_;
				ValaCCodeExpression* _tmp32_;
				gboolean _tmp34_;
				decl = vala_ccode_base_module_get_temp_variable (self, expression_type, TRUE, (ValaCodeNode*) expression_type);
				gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
				gee_list_insert ((GeeList*) self->temp_ref_vars, 0, decl);
				_tmp33_ = NULL;
				_tmp32_ = NULL;
				cexpr = (_tmp33_ = (ValaCCodeExpression*) vala_ccode_assignment_new (_tmp32_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp33_);
				(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
				_tmp34_ = FALSE;
				if (VALA_IS_ARRAY_TYPE (expression_type)) {
					_tmp34_ = expr != NULL;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					ValaArrayType* _tmp35_;
					ValaArrayType* array_type;
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeExpression* _tmp43_;
					ValaCCodeExpression* _tmp45_;
					ValaCCodeExpression* _tmp44_;
					_tmp35_ = NULL;
					array_type = (_tmp35_ = VALA_ARRAY_TYPE (expression_type), (_tmp35_ == NULL) ? NULL : vala_code_node_ref (_tmp35_));
					ccomma = vala_ccode_comma_expression_new ();
					vala_ccode_comma_expression_append_expression (ccomma, cexpr);
					{
						gint dim;
						dim = 1;
						{
							gboolean _tmp36_;
							_tmp36_ = TRUE;
							while (TRUE) {
								char* _tmp38_;
								ValaDataType* _tmp37_;
								ValaLocalVariable* _tmp39_;
								ValaLocalVariable* len_decl;
								ValaCCodeAssignment* _tmp42_;
								ValaCCodeExpression* _tmp41_;
								ValaCCodeExpression* _tmp40_;
								if (!_tmp36_) {
									dim++;
								}
								_tmp36_ = FALSE;
								if (!(dim <= vala_array_type_get_rank (array_type))) {
									break;
								}
								_tmp38_ = NULL;
								_tmp37_ = NULL;
								_tmp39_ = NULL;
								len_decl = (_tmp39_ = vala_local_variable_new (_tmp37_ = vala_data_type_copy (self->int_type), _tmp38_ = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) decl), dim), NULL, NULL), _tmp38_ = (g_free (_tmp38_), NULL), (_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_code_node_unref (_tmp37_), NULL)), _tmp39_);
								gee_list_insert ((GeeList*) self->temp_vars, 0, len_decl);
								_tmp42_ = NULL;
								_tmp41_ = NULL;
								_tmp40_ = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_assignment_new (_tmp40_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) len_decl)), _tmp41_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), expr, dim), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
								(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
								(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
								(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
								(len_decl == NULL) ? NULL : (len_decl = (vala_code_node_unref (len_decl), NULL));
							}
						}
					}
					_tmp43_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, _tmp43_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)));
					(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
					_tmp45_ = NULL;
					_tmp44_ = NULL;
					cexpr = (_tmp45_ = (_tmp44_ = (ValaCCodeExpression*) ccomma, (_tmp44_ == NULL) ? NULL : vala_ccode_node_ref (_tmp44_)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp45_);
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
				}
				(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
			}
		}
		(pointer_type == NULL) ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL));
	}
	if (target_type == NULL) {
		/* value will be destroyed, no need for implicit casts*/
		result = cexpr;
		return result;
	}
	if (gvalue_boxing) {
		ValaLocalVariable* decl;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeFunctionCall* _tmp53_;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp58_;
		char* _tmp57_;
		ValaCCodeFunctionCall* _tmp60_;
		ValaCCodeIdentifier* _tmp59_;
		ValaCCodeExpression* _tmp64_;
		ValaCCodeExpression* _tmp66_;
		ValaCCodeExpression* _tmp65_;
		/* implicit conversion to GValue*/
		decl = vala_ccode_base_module_get_temp_variable (self, target_type, TRUE, (ValaCodeNode*) target_type);
		gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
		ccomma = vala_ccode_comma_expression_new ();
		if (vala_data_type_get_nullable (target_type)) {
			ValaCCodeIdentifier* _tmp46_;
			ValaCCodeFunctionCall* _tmp47_;
			ValaCCodeFunctionCall* newcall;
			ValaCCodeConstant* _tmp48_;
			ValaCCodeConstant* _tmp49_;
			ValaCCodeExpression* _tmp50_;
			ValaCCodeAssignment* _tmp51_;
			ValaCCodeAssignment* newassignment;
			_tmp46_ = NULL;
			_tmp47_ = NULL;
			newcall = (_tmp47_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new ("g_new0"))), (_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL)), _tmp47_);
			_tmp48_ = NULL;
			vala_ccode_function_call_add_argument (newcall, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_constant_new ("GValue")));
			(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
			_tmp49_ = NULL;
			vala_ccode_function_call_add_argument (newcall, (ValaCCodeExpression*) (_tmp49_ = vala_ccode_constant_new ("1")));
			(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
			_tmp50_ = NULL;
			_tmp51_ = NULL;
			newassignment = (_tmp51_ = vala_ccode_assignment_new (_tmp50_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)), (ValaCCodeExpression*) newcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL)), _tmp51_);
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) newassignment);
			(newcall == NULL) ? NULL : (newcall = (vala_ccode_node_unref (newcall), NULL));
			(newassignment == NULL) ? NULL : (newassignment = (vala_ccode_node_unref (newassignment), NULL));
		}
		_tmp52_ = NULL;
		_tmp53_ = NULL;
		ccall = (_tmp53_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp52_ = vala_ccode_identifier_new ("g_value_init"))), (_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL)), _tmp53_);
		if (vala_data_type_get_nullable (target_type)) {
			ValaCCodeExpression* _tmp54_;
			_tmp54_ = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp54_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)));
			(_tmp54_ == NULL) ? NULL : (_tmp54_ = (vala_ccode_node_unref (_tmp54_), NULL));
		} else {
			ValaCCodeUnaryExpression* _tmp56_;
			ValaCCodeExpression* _tmp55_;
			_tmp56_ = NULL;
			_tmp55_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp55_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)))));
			(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
			(_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL));
		}
		_tmp58_ = NULL;
		_tmp57_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp58_ = vala_ccode_identifier_new (_tmp57_ = vala_data_type_get_type_id (expression_type))));
		(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
		_tmp57_ = (g_free (_tmp57_), NULL);
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
		_tmp60_ = NULL;
		_tmp59_ = NULL;
		ccall = (_tmp60_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59_ = vala_ccode_module_get_value_setter_function ((ValaCCodeModule*) self, expression_type))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp60_);
		(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
		if (vala_data_type_get_nullable (target_type)) {
			ValaCCodeExpression* _tmp61_;
			_tmp61_ = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp61_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)));
			(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
		} else {
			ValaCCodeUnaryExpression* _tmp63_;
			ValaCCodeExpression* _tmp62_;
			_tmp63_ = NULL;
			_tmp62_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp63_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp62_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)))));
			(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
			(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
		}
		vala_ccode_function_call_add_argument (ccall, cexpr);
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
		_tmp64_ = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, _tmp64_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)));
		(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_ccode_node_unref (_tmp64_), NULL));
		_tmp66_ = NULL;
		_tmp65_ = NULL;
		cexpr = (_tmp66_ = (_tmp65_ = (ValaCCodeExpression*) ccomma, (_tmp65_ == NULL) ? NULL : vala_ccode_node_ref (_tmp65_)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp66_);
		result = cexpr;
		(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		return result;
	} else {
		if (boxing) {
			ValaCCodeUnaryExpression* _tmp68_;
			ValaCCodeExpression* _tmp67_;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp69_;
			/* value needs to be boxed*/
			_tmp68_ = NULL;
			_tmp67_ = NULL;
			unary = (_tmp68_ = (_tmp67_ = cexpr, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp67_) ? ((ValaCCodeUnaryExpression*) _tmp67_) : NULL), (_tmp68_ == NULL) ? NULL : vala_ccode_node_ref (_tmp68_));
			_tmp69_ = FALSE;
			if (unary != NULL) {
				_tmp69_ = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp69_ = FALSE;
			}
			if (_tmp69_) {
				ValaCCodeExpression* _tmp71_;
				ValaCCodeExpression* _tmp70_;
				/* *expr => expr*/
				_tmp71_ = NULL;
				_tmp70_ = NULL;
				cexpr = (_tmp71_ = (_tmp70_ = vala_ccode_unary_expression_get_inner (unary), (_tmp70_ == NULL) ? NULL : vala_ccode_node_ref (_tmp70_)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp71_);
			} else {
				gboolean _tmp72_;
				_tmp72_ = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (cexpr)) {
					_tmp72_ = TRUE;
				} else {
					_tmp72_ = VALA_IS_CCODE_MEMBER_ACCESS (cexpr);
				}
				if (_tmp72_) {
					ValaCCodeExpression* _tmp73_;
					_tmp73_ = NULL;
					cexpr = (_tmp73_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp73_);
				} else {
					ValaLocalVariable* decl;
					ValaCCodeCommaExpression* ccomma;
					ValaCCodeAssignment* _tmp75_;
					ValaCCodeExpression* _tmp74_;
					ValaCCodeUnaryExpression* _tmp77_;
					ValaCCodeExpression* _tmp76_;
					ValaCCodeExpression* _tmp79_;
					ValaCCodeExpression* _tmp78_;
					decl = vala_ccode_base_module_get_temp_variable (self, expression_type, vala_data_type_get_value_owned (expression_type), (ValaCodeNode*) expression_type);
					gee_list_insert ((GeeList*) self->temp_vars, 0, decl);
					ccomma = vala_ccode_comma_expression_new ();
					_tmp75_ = NULL;
					_tmp74_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp75_ = vala_ccode_assignment_new (_tmp74_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL));
					(_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL));
					_tmp77_ = NULL;
					_tmp76_ = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp77_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp76_ = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) decl)))));
					(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
					(_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL));
					_tmp79_ = NULL;
					_tmp78_ = NULL;
					cexpr = (_tmp79_ = (_tmp78_ = (ValaCCodeExpression*) ccomma, (_tmp78_ == NULL) ? NULL : vala_ccode_node_ref (_tmp78_)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp79_);
					(decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL));
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		} else {
			if (unboxing) {
				ValaCCodeExpression* _tmp80_;
				/* unbox value*/
				_tmp80_ = NULL;
				cexpr = (_tmp80_ = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp80_);
			} else {
				ValaCCodeExpression* _tmp81_;
				_tmp81_ = NULL;
				cexpr = (_tmp81_ = vala_ccode_base_module_get_implicit_cast_expression (self, cexpr, expression_type, target_type, expr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp81_);
			}
		}
	}
	_tmp82_ = FALSE;
	if (vala_data_type_get_value_owned (target_type)) {
		gboolean _tmp83_;
		gboolean _tmp84_;
		_tmp83_ = FALSE;
		_tmp84_ = FALSE;
		if (!vala_data_type_get_value_owned (expression_type)) {
			_tmp84_ = TRUE;
		} else {
			_tmp84_ = boxing;
		}
		if (_tmp84_) {
			_tmp83_ = TRUE;
		} else {
			_tmp83_ = unboxing;
		}
		_tmp82_ = _tmp83_;
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		gboolean _tmp85_;
		_tmp85_ = FALSE;
		if (vala_ccode_base_module_requires_copy (self, target_type)) {
			_tmp85_ = !VALA_IS_NULL_TYPE (expression_type);
		} else {
			_tmp85_ = FALSE;
		}
		/* need to copy value*/
		if (_tmp85_) {
			ValaCodeNode* _tmp86_;
			ValaCodeNode* node;
			ValaCCodeExpression* _tmp89_;
			_tmp86_ = NULL;
			node = (_tmp86_ = (ValaCodeNode*) expr, (_tmp86_ == NULL) ? NULL : vala_code_node_ref (_tmp86_));
			if (node == NULL) {
				ValaCodeNode* _tmp88_;
				ValaCodeNode* _tmp87_;
				_tmp88_ = NULL;
				_tmp87_ = NULL;
				node = (_tmp88_ = (_tmp87_ = (ValaCodeNode*) expression_type, (_tmp87_ == NULL) ? NULL : vala_code_node_ref (_tmp87_)), (node == NULL) ? NULL : (node = (vala_code_node_unref (node), NULL)), _tmp88_);
			}
			_tmp89_ = NULL;
			cexpr = (_tmp89_ = vala_ccode_base_module_get_ref_cexpression (self, target_type, cexpr, expr, node), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp89_);
			(node == NULL) ? NULL : (node = (vala_code_node_unref (node), NULL));
		}
	}
	result = cexpr;
	return result;
}


static ValaCCodeExpression* vala_ccode_base_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeExpression* result;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeExpression* cexpr;
	gboolean _tmp1_;
	ValaClass* _tmp3_;
	ValaTypeSymbol* _tmp2_;
	ValaClass* cl;
	ValaInterface* _tmp5_;
	ValaTypeSymbol* _tmp4_;
	ValaInterface* iface;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0_ = NULL;
	cexpr = (_tmp0_ = source_cexpr, (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
	_tmp1_ = FALSE;
	if (vala_data_type_get_data_type (expression_type) != NULL) {
		_tmp1_ = vala_data_type_get_data_type (expression_type) == vala_data_type_get_data_type (target_type);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		/* same type, no cast required*/
		result = cexpr;
		return result;
	}
	if (VALA_IS_NULL_TYPE (expression_type)) {
		/* null literal, no cast required when not converting to generic type pointer*/
		result = cexpr;
		return result;
	}
	vala_ccode_base_module_generate_type_declaration (self, target_type, self->source_declarations);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	cl = (_tmp3_ = (_tmp2_ = vala_data_type_get_data_type (target_type), VALA_IS_CLASS (_tmp2_) ? ((ValaClass*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	iface = (_tmp5_ = (_tmp4_ = vala_data_type_get_data_type (target_type), VALA_IS_INTERFACE (_tmp4_) ? ((ValaInterface*) _tmp4_) : NULL), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
	_tmp6_ = FALSE;
	if (vala_code_context_get_checking (self->priv->_context)) {
		gboolean _tmp7_;
		_tmp7_ = FALSE;
		if (iface != NULL) {
			_tmp7_ = TRUE;
		} else {
			gboolean _tmp8_;
			_tmp8_ = FALSE;
			if (cl != NULL) {
				_tmp8_ = !vala_class_get_is_compact (cl);
			} else {
				_tmp8_ = FALSE;
			}
			_tmp7_ = _tmp8_;
		}
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		/* checked cast for strict subtypes of GTypeInstance*/
		result = (ValaCCodeExpression*) vala_instance_cast_new (cexpr, vala_data_type_get_data_type (target_type));
		(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
		return result;
	} else {
		gboolean _tmp9_;
		_tmp9_ = FALSE;
		if (vala_data_type_get_data_type (target_type) != NULL) {
			char* _tmp11_;
			char* _tmp10_;
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			_tmp9_ = _vala_strcmp0 (_tmp10_ = vala_data_type_get_cname (expression_type), _tmp11_ = vala_data_type_get_cname (target_type)) != 0;
			_tmp11_ = (g_free (_tmp11_), NULL);
			_tmp10_ = (g_free (_tmp10_), NULL);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaStruct* _tmp13_;
			ValaTypeSymbol* _tmp12_;
			ValaStruct* st;
			gboolean _tmp14_;
			_tmp13_ = NULL;
			_tmp12_ = NULL;
			st = (_tmp13_ = (_tmp12_ = vala_data_type_get_data_type (target_type), VALA_IS_STRUCT (_tmp12_) ? ((ValaStruct*) _tmp12_) : NULL), (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_));
			_tmp14_ = FALSE;
			if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (target_type))) {
				_tmp14_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = FALSE;
				if (st != NULL) {
					_tmp15_ = vala_struct_is_simple_type (st);
				} else {
					_tmp15_ = FALSE;
				}
				_tmp14_ = _tmp15_;
			}
			if (_tmp14_) {
				char* _tmp16_;
				ValaCCodeExpression* _tmp17_;
				/* don't cast non-simple structs*/
				_tmp16_ = NULL;
				_tmp17_ = NULL;
				result = (_tmp17_ = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, _tmp16_ = vala_data_type_get_cname (target_type)), _tmp16_ = (g_free (_tmp16_), NULL), _tmp17_);
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
				(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
				return result;
			} else {
				result = cexpr;
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
				(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
				return result;
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		} else {
			result = cexpr;
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			return result;
		}
	}
	(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
}


ValaCCodeExpression* vala_ccode_base_module_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->get_implicit_cast_expression (self, source_cexpr, expression_type, target_type, expr);
}


ValaCCodeFunctionCall* vala_ccode_base_module_get_property_set_call (ValaCCodeBaseModule* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr, ValaExpression* rhs) {
	ValaCCodeFunctionCall* result;
	char* set_func;
	ValaProperty* _tmp21_;
	ValaProperty* base_property;
	ValaCCodeIdentifier* _tmp28_;
	ValaCCodeFunctionCall* _tmp29_;
	ValaCCodeFunctionCall* ccall;
	ValaArrayType* _tmp33_;
	ValaDataType* _tmp32_;
	ValaArrayType* array_type;
	gboolean _tmp34_;
	gboolean _tmp35_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	g_return_val_if_fail (ma != NULL, NULL);
	g_return_val_if_fail (cexpr != NULL, NULL);
	if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma))) {
		if (vala_property_get_base_property (prop) != NULL) {
			ValaClass* _tmp0_;
			ValaClass* base_class;
			ValaCCodeIdentifier* _tmp3_;
			char* _tmp2_;
			char* _tmp1_;
			ValaCCodeFunctionCall* _tmp4_;
			ValaCCodeFunctionCall* vcast;
			ValaCCodeIdentifier* _tmp7_;
			char* _tmp6_;
			char* _tmp5_;
			ValaCCodeMemberAccess* _tmp9_;
			char* _tmp8_;
			ValaCCodeFunctionCall* _tmp10_;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeExpression* _tmp11_;
			_tmp0_ = NULL;
			base_class = (_tmp0_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
			_tmp3_ = NULL;
			_tmp2_ = NULL;
			_tmp1_ = NULL;
			_tmp4_ = NULL;
			vcast = (_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new (_tmp2_ = g_strdup_printf ("%s_CLASS", _tmp1_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL)), _tmp2_ = (g_free (_tmp2_), NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp4_);
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (_tmp6_ = g_strdup_printf ("%s_parent_class", _tmp5_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->current_class, NULL)))));
			(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
			_tmp6_ = (g_free (_tmp6_), NULL);
			_tmp5_ = (g_free (_tmp5_), NULL);
			_tmp9_ = NULL;
			_tmp8_ = NULL;
			_tmp10_ = NULL;
			ccall = (_tmp10_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, _tmp8_ = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), _tmp8_ = (g_free (_tmp8_), NULL), _tmp10_);
			_tmp11_ = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp11_ = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
			(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
			vala_ccode_function_call_add_argument (ccall, cexpr);
			result = ccall;
			(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
			(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
			return result;
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaInterface* _tmp12_;
				ValaInterface* base_iface;
				char* _tmp14_;
				char* _tmp13_;
				char* _tmp15_;
				char* parent_iface_var;
				ValaCCodeMemberAccess* _tmp18_;
				char* _tmp17_;
				ValaCCodeIdentifier* _tmp16_;
				ValaCCodeFunctionCall* _tmp19_;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeExpression* _tmp20_;
				_tmp12_ = NULL;
				base_iface = (_tmp12_ = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp12_ == NULL) ? NULL : vala_code_node_ref (_tmp12_));
				_tmp14_ = NULL;
				_tmp13_ = NULL;
				_tmp15_ = NULL;
				parent_iface_var = (_tmp15_ = g_strdup_printf ("%s_%s_parent_iface", _tmp13_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->current_class, NULL), _tmp14_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_iface, NULL)), _tmp14_ = (g_free (_tmp14_), NULL), _tmp13_ = (g_free (_tmp13_), NULL), _tmp15_);
				_tmp18_ = NULL;
				_tmp17_ = NULL;
				_tmp16_ = NULL;
				_tmp19_ = NULL;
				ccall = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new (parent_iface_var)), _tmp17_ = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp17_ = (g_free (_tmp17_), NULL), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp19_);
				_tmp20_ = NULL;
				vala_ccode_function_call_add_argument (ccall, _tmp20_ = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
				(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
				vala_ccode_function_call_add_argument (ccall, cexpr);
				result = ccall;
				(base_iface == NULL) ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL));
				parent_iface_var = (g_free (parent_iface_var), NULL);
				return result;
			}
		}
	}
	set_func = g_strdup ("g_object_set");
	_tmp21_ = NULL;
	base_property = (_tmp21_ = prop, (_tmp21_ == NULL) ? NULL : vala_code_node_ref (_tmp21_));
	if (!vala_property_get_no_accessor_method (prop)) {
		if (vala_property_get_base_property (prop) != NULL) {
			ValaProperty* _tmp23_;
			ValaProperty* _tmp22_;
			_tmp23_ = NULL;
			_tmp22_ = NULL;
			base_property = (_tmp23_ = (_tmp22_ = vala_property_get_base_property (prop), (_tmp22_ == NULL) ? NULL : vala_code_node_ref (_tmp22_)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp23_);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaProperty* _tmp25_;
				ValaProperty* _tmp24_;
				_tmp25_ = NULL;
				_tmp24_ = NULL;
				base_property = (_tmp25_ = (_tmp24_ = vala_property_get_base_interface_property (prop), (_tmp24_ == NULL) ? NULL : vala_code_node_ref (_tmp24_)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp25_);
			}
		}
		if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
			char* _tmp26_;
			_tmp26_ = NULL;
			set_func = (_tmp26_ = vala_ccode_module_get_dynamic_property_setter_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_PROPERTY (prop)), set_func = (g_free (set_func), NULL), _tmp26_);
		} else {
			char* _tmp27_;
			vala_ccode_base_module_generate_property_accessor_declaration (self, vala_property_get_set_accessor (base_property), self->source_declarations);
			_tmp27_ = NULL;
			set_func = (_tmp27_ = vala_property_accessor_get_cname (vala_property_get_set_accessor (base_property)), set_func = (g_free (set_func), NULL), _tmp27_);
		}
	}
	_tmp28_ = NULL;
	_tmp29_ = NULL;
	ccall = (_tmp29_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_identifier_new (set_func))), (_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL)), _tmp29_);
	if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* _tmp30_;
		/* target instance is first argument */
		_tmp30_ = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp30_ = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
		(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
	}
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp31_;
		/* property name is second argument of g_object_set */
		_tmp31_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp31_ = vala_property_get_canonical_cconstant (prop)));
		(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	_tmp33_ = NULL;
	_tmp32_ = NULL;
	array_type = (_tmp33_ = (_tmp32_ = vala_property_get_property_type (prop), VALA_IS_ARRAY_TYPE (_tmp32_) ? ((ValaArrayType*) _tmp32_) : NULL), (_tmp33_ == NULL) ? NULL : vala_code_node_ref (_tmp33_));
	_tmp34_ = FALSE;
	_tmp35_ = FALSE;
	if (array_type != NULL) {
		_tmp35_ = !vala_property_get_no_array_length (prop);
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = rhs != NULL;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		{
			gint dim;
			dim = 1;
			{
				gboolean _tmp36_;
				_tmp36_ = TRUE;
				while (TRUE) {
					ValaCCodeExpression* _tmp37_;
					if (!_tmp36_) {
						dim++;
					}
					_tmp36_ = FALSE;
					if (!(dim <= vala_array_type_get_rank (array_type))) {
						break;
					}
					_tmp37_ = NULL;
					vala_ccode_function_call_add_argument (ccall, _tmp37_ = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), rhs, dim));
					(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
				}
			}
		}
	} else {
		gboolean _tmp38_;
		_tmp38_ = FALSE;
		if (VALA_IS_DELEGATE_TYPE (vala_property_get_property_type (prop))) {
			_tmp38_ = rhs != NULL;
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			ValaDelegateType* _tmp39_;
			ValaDelegateType* delegate_type;
			_tmp39_ = NULL;
			delegate_type = (_tmp39_ = VALA_DELEGATE_TYPE (vala_property_get_property_type (prop)), (_tmp39_ == NULL) ? NULL : vala_code_node_ref (_tmp39_));
			if (vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type))) {
				ValaCCodeExpression* _tmp40_;
				_tmp40_ = NULL;
				vala_ccode_function_call_add_argument (ccall, _tmp40_ = vala_ccode_base_module_get_delegate_target_cexpression (self, rhs));
				(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
			}
			(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
		}
	}
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* _tmp41_;
		_tmp41_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_constant_new ("NULL")));
		(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	}
	result = ccall;
	set_func = (g_free (set_func), NULL);
	(base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL));
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	return result;
}


/* indicates whether a given Expression eligable for an ADDRESS_OF operator
 * from a vala to C point of view all expressions denoting locals, fields and
 * parameters are eligable to an ADDRESS_OF operator */
gboolean vala_ccode_base_module_is_address_of_possible (ValaCCodeBaseModule* self, ValaExpression* e) {
	gboolean result;
	ValaMemberAccess* _tmp1_;
	ValaExpression* _tmp0_;
	ValaMemberAccess* ma;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	ma = (_tmp1_ = (_tmp0_ = e, VALA_IS_MEMBER_ACCESS (_tmp0_) ? ((ValaMemberAccess*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	if (ma == NULL) {
		result = FALSE;
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		return result;
	}
	if (vala_expression_get_symbol_reference ((ValaExpression*) ma) == NULL) {
		result = FALSE;
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		return result;
	}
	if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		result = TRUE;
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		return result;
	}
	if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		result = TRUE;
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		return result;
	}
	if (VALA_IS_FIELD (vala_expression_get_symbol_reference ((ValaExpression*) ma))) {
		result = TRUE;
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		return result;
	}
	result = FALSE;
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	return result;
}


/* retrieve the correct address_of expression for a give expression, creates temporary variables
 * where necessary, ce is the corresponding ccode expression for e */
ValaCCodeExpression* vala_ccode_base_module_get_address_of_expression (ValaCCodeBaseModule* self, ValaExpression* e, ValaCCodeExpression* ce) {
	ValaCCodeExpression* result;
	ValaCCodeCommaExpression* ccomma;
	ValaLocalVariable* temp_decl;
	ValaCCodeExpression* ctemp;
	ValaCCodeAssignment* _tmp0_;
	ValaCCodeUnaryExpression* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (e != NULL, NULL);
	g_return_val_if_fail (ce != NULL, NULL);
	/* is address of trivially possible?*/
	if (vala_ccode_base_module_is_address_of_possible (self, e)) {
		result = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ce);
		return result;
	}
	ccomma = vala_ccode_comma_expression_new ();
	temp_decl = vala_ccode_base_module_get_temp_variable (self, vala_expression_get_value_type (e), TRUE, NULL);
	ctemp = vala_ccode_base_module_get_variable_cexpression (self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
	gee_collection_add ((GeeCollection*) self->temp_vars, temp_decl);
	_tmp0_ = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp0_ = vala_ccode_assignment_new (ctemp, ce, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp1_ = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp1_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ctemp)));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	result = (ValaCCodeExpression*) ccomma;
	(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
	(ctemp == NULL) ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL));
	return result;
}


gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (wrapper_name != NULL, FALSE);
	result = gee_collection_add ((GeeCollection*) self->wrappers, wrapper_name);
	return result;
}


gboolean vala_ccode_base_module_add_generated_external_symbol (ValaCCodeBaseModule* self, ValaSymbol* external_symbol) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (external_symbol != NULL, FALSE);
	result = gee_collection_add ((GeeCollection*) self->priv->generated_external_symbols, external_symbol);
	return result;
}


ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym) {
	ValaDataType* result;
	ValaDataType* type;
	g_return_val_if_fail (sym != NULL, NULL);
	type = NULL;
	if (VALA_IS_CLASS (sym)) {
		ValaDataType* _tmp0_;
		_tmp0_ = NULL;
		type = (_tmp0_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp0_);
	} else {
		if (VALA_IS_INTERFACE (sym)) {
			ValaDataType* _tmp1_;
			_tmp1_ = NULL;
			type = (_tmp1_ = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp1_);
		} else {
			if (VALA_IS_STRUCT (sym)) {
				ValaStruct* _tmp2_;
				ValaStruct* st;
				_tmp2_ = NULL;
				st = (_tmp2_ = VALA_STRUCT (sym), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
				if (vala_struct_is_boolean_type (st)) {
					ValaDataType* _tmp3_;
					_tmp3_ = NULL;
					type = (_tmp3_ = (ValaDataType*) vala_boolean_type_new (st), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp3_);
				} else {
					if (vala_struct_is_integer_type (st)) {
						ValaDataType* _tmp4_;
						_tmp4_ = NULL;
						type = (_tmp4_ = (ValaDataType*) vala_integer_type_new (st, NULL, NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp4_);
					} else {
						if (vala_struct_is_floating_type (st)) {
							ValaDataType* _tmp5_;
							_tmp5_ = NULL;
							type = (_tmp5_ = (ValaDataType*) vala_floating_type_new (st), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp5_);
						} else {
							ValaDataType* _tmp6_;
							_tmp6_ = NULL;
							type = (_tmp6_ = (ValaDataType*) vala_struct_value_type_new (st), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp6_);
						}
					}
				}
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			} else {
				if (VALA_IS_ENUM (sym)) {
					ValaDataType* _tmp7_;
					_tmp7_ = NULL;
					type = (_tmp7_ = (ValaDataType*) vala_enum_value_type_new (VALA_ENUM (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp7_);
				} else {
					if (VALA_IS_ERROR_DOMAIN (sym)) {
						ValaDataType* _tmp8_;
						_tmp8_ = NULL;
						type = (_tmp8_ = (ValaDataType*) vala_error_type_new (VALA_ERROR_DOMAIN (sym), NULL, NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp8_);
					} else {
						if (VALA_IS_ERROR_CODE (sym)) {
							ValaDataType* _tmp9_;
							_tmp9_ = NULL;
							type = (_tmp9_ = (ValaDataType*) vala_error_type_new (VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol ((ValaSymbol*) sym)), VALA_ERROR_CODE (sym), NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp9_);
						} else {
							char* _tmp11_;
							char* _tmp10_;
							_tmp11_ = NULL;
							_tmp10_ = NULL;
							vala_report_error (NULL, _tmp11_ = g_strdup_printf ("internal error: `%s' is not a supported type", _tmp10_ = vala_symbol_get_full_name ((ValaSymbol*) sym)));
							_tmp11_ = (g_free (_tmp11_), NULL);
							_tmp10_ = (g_free (_tmp10_), NULL);
							result = (ValaDataType*) vala_invalid_type_new ();
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							return result;
						}
					}
				}
			}
		}
	}
	result = type;
	return result;
}


ValaCCodeExpression* vala_ccode_base_module_default_value_for_type (ValaCCodeBaseModule* self, ValaDataType* type, gboolean initializer_expression) {
	ValaCCodeExpression* result;
	ValaStruct* _tmp1_;
	ValaTypeSymbol* _tmp0_;
	ValaStruct* st;
	ValaArrayType* _tmp3_;
	ValaDataType* _tmp2_;
	ValaArrayType* array_type;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	st = (_tmp1_ = (_tmp0_ = vala_data_type_get_data_type (type), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	array_type = (_tmp3_ = (_tmp2_ = type, VALA_IS_ARRAY_TYPE (_tmp2_) ? ((ValaArrayType*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	_tmp4_ = FALSE;
	_tmp5_ = FALSE;
	if (initializer_expression) {
		_tmp5_ = !vala_data_type_get_nullable (type);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = FALSE;
		_tmp7_ = FALSE;
		if (st != NULL) {
			_tmp7_ = !vala_struct_is_simple_type (st);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			gboolean _tmp8_;
			_tmp8_ = FALSE;
			if (array_type != NULL) {
				_tmp8_ = vala_array_type_get_fixed_length (array_type);
			} else {
				_tmp8_ = FALSE;
			}
			_tmp6_ = _tmp8_;
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaCCodeInitializerList* clist;
		ValaCCodeConstant* _tmp9_;
		/* 0-initialize struct with struct initializer { 0 }
		 only allowed as initializer expression in C*/
		clist = vala_ccode_initializer_list_new ();
		_tmp9_ = NULL;
		vala_ccode_initializer_list_append (clist, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("0")));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		result = (ValaCCodeExpression*) clist;
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return result;
	} else {
		gboolean _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp10_ = FALSE;
		_tmp11_ = FALSE;
		_tmp12_ = FALSE;
		_tmp13_ = FALSE;
		_tmp14_ = FALSE;
		if (vala_data_type_get_data_type (type) != NULL) {
			_tmp14_ = vala_typesymbol_is_reference_type (vala_data_type_get_data_type (type));
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			_tmp13_ = vala_data_type_get_nullable (type);
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = VALA_IS_POINTER_TYPE (type);
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = VALA_IS_DELEGATE_TYPE (type);
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			gboolean _tmp15_;
			_tmp15_ = FALSE;
			if (array_type != NULL) {
				_tmp15_ = !vala_array_type_get_fixed_length (array_type);
			} else {
				_tmp15_ = FALSE;
			}
			_tmp10_ = _tmp15_;
		}
		if (_tmp10_) {
			result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			return result;
		} else {
			gboolean _tmp16_;
			_tmp16_ = FALSE;
			if (vala_data_type_get_data_type (type) != NULL) {
				char* _tmp17_;
				_tmp17_ = NULL;
				_tmp16_ = (_tmp17_ = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type))) != NULL;
				_tmp17_ = (g_free (_tmp17_), NULL);
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				char* _tmp18_;
				ValaCCodeExpression* _tmp19_;
				_tmp18_ = NULL;
				_tmp19_ = NULL;
				result = (_tmp19_ = (ValaCCodeExpression*) vala_ccode_constant_new (_tmp18_ = vala_typesymbol_get_default_value (vala_data_type_get_data_type (type))), _tmp18_ = (g_free (_tmp18_), NULL), _tmp19_);
				(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				return result;
			} else {
				if (vala_data_type_get_type_parameter (type) != NULL) {
					result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					return result;
				} else {
					if (VALA_IS_ERROR_TYPE (type)) {
						result = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
						(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	return result;
}


static ValaCCodeStatement* vala_ccode_base_module_create_property_type_check_statement (ValaCCodeBaseModule* self, ValaProperty* prop, gboolean check_return_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	ValaCCodeStatement* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (check_return_type) {
		result = vala_ccode_base_module_create_type_check_statement (self, (ValaCodeNode*) prop, vala_property_get_property_type (prop), t, non_null, var_name);
		return result;
	} else {
		ValaVoidType* _tmp0_;
		ValaCCodeStatement* _tmp1_;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		result = (_tmp1_ = vala_ccode_base_module_create_type_check_statement (self, (ValaCodeNode*) prop, (ValaDataType*) (_tmp0_ = vala_void_type_new (NULL)), t, non_null, var_name), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_code_node_unref (_tmp0_), NULL)), _tmp1_);
		return result;
	}
}


ValaCCodeStatement* vala_ccode_base_module_create_type_check_statement (ValaCCodeBaseModule* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaTypeSymbol* t, gboolean non_null, const char* var_name) {
	ValaCCodeStatement* result;
	ValaCCodeFunctionCall* ccheck;
	ValaCreationMethod* _tmp17_;
	ValaCodeNode* _tmp16_;
	ValaCreationMethod* cm;
	gboolean _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (method_node != NULL, NULL);
	g_return_val_if_fail (ret_type != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	if (!vala_code_context_get_assert (self->priv->_context)) {
		result = NULL;
		(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
		return result;
	} else {
		gboolean _tmp0_;
		_tmp0_ = FALSE;
		if (vala_code_context_get_checking (self->priv->_context)) {
			gboolean _tmp1_;
			gboolean _tmp2_;
			_tmp1_ = FALSE;
			_tmp2_ = FALSE;
			if (VALA_IS_CLASS (t)) {
				_tmp2_ = !vala_class_get_is_compact (VALA_CLASS (t));
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = VALA_IS_INTERFACE (t);
			}
			_tmp0_ = _tmp1_;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			ValaCCodeIdentifier* _tmp4_;
			char* _tmp3_;
			ValaCCodeFunctionCall* _tmp5_;
			ValaCCodeFunctionCall* ctype_check;
			ValaCCodeIdentifier* _tmp6_;
			ValaCCodeExpression* _tmp7_;
			ValaCCodeExpression* cexpr;
			_tmp4_ = NULL;
			_tmp3_ = NULL;
			_tmp5_ = NULL;
			ctype_check = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new (_tmp3_ = vala_ccode_base_module_get_type_check_function (self, t)))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp3_ = (g_free (_tmp3_), NULL), _tmp5_);
			_tmp6_ = NULL;
			vala_ccode_function_call_add_argument (ctype_check, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new (var_name)));
			(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
			_tmp7_ = NULL;
			cexpr = (_tmp7_ = (ValaCCodeExpression*) ctype_check, (_tmp7_ == NULL) ? NULL : vala_ccode_node_ref (_tmp7_));
			if (!non_null) {
				ValaCCodeConstant* _tmp9_;
				ValaCCodeIdentifier* _tmp8_;
				ValaCCodeBinaryExpression* _tmp10_;
				ValaCCodeBinaryExpression* cnull;
				ValaCCodeExpression* _tmp11_;
				_tmp9_ = NULL;
				_tmp8_ = NULL;
				_tmp10_ = NULL;
				cnull = (_tmp10_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new (var_name)), (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("NULL"))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp10_);
				_tmp11_ = NULL;
				cexpr = (_tmp11_ = (ValaCCodeExpression*) vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) cnull, (ValaCCodeExpression*) ctype_check), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp11_);
				(cnull == NULL) ? NULL : (cnull = (vala_ccode_node_unref (cnull), NULL));
			}
			vala_ccode_function_call_add_argument (ccheck, cexpr);
			(ctype_check == NULL) ? NULL : (ctype_check = (vala_ccode_node_unref (ctype_check), NULL));
			(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
		} else {
			if (!non_null) {
				result = NULL;
				(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
				return result;
			} else {
				gboolean _tmp12_;
				_tmp12_ = FALSE;
				if (t == VALA_TYPESYMBOL (self->glist_type)) {
					_tmp12_ = TRUE;
				} else {
					_tmp12_ = t == VALA_TYPESYMBOL (self->gslist_type);
				}
				if (_tmp12_) {
					/* NULL is empty list*/
					result = NULL;
					(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
					return result;
				} else {
					ValaCCodeConstant* _tmp14_;
					ValaCCodeIdentifier* _tmp13_;
					ValaCCodeBinaryExpression* _tmp15_;
					ValaCCodeBinaryExpression* cnonnull;
					_tmp14_ = NULL;
					_tmp13_ = NULL;
					_tmp15_ = NULL;
					cnonnull = (_tmp15_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new (var_name)), (ValaCCodeExpression*) (_tmp14_ = vala_ccode_constant_new ("NULL"))), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp15_);
					vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) cnonnull);
					(cnonnull == NULL) ? NULL : (cnonnull = (vala_ccode_node_unref (cnonnull), NULL));
				}
			}
		}
	}
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	cm = (_tmp17_ = (_tmp16_ = method_node, VALA_IS_CREATION_METHOD (_tmp16_) ? ((ValaCreationMethod*) _tmp16_) : NULL), (_tmp17_ == NULL) ? NULL : vala_code_node_ref (_tmp17_));
	_tmp18_ = FALSE;
	if (cm != NULL) {
		_tmp18_ = VALA_IS_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) cm));
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ValaCCodeIdentifier* _tmp19_;
		ValaCCodeConstant* _tmp20_;
		_tmp19_ = NULL;
		vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp19_ = vala_ccode_identifier_new ("g_return_val_if_fail")));
		(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
		_tmp20_ = NULL;
		vala_ccode_function_call_add_argument (ccheck, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_constant_new ("NULL")));
		(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	} else {
		if (VALA_IS_VOID_TYPE (ret_type)) {
			ValaCCodeIdentifier* _tmp21_;
			/* void function */
			_tmp21_ = NULL;
			vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("g_return_if_fail")));
			(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		} else {
			ValaCCodeIdentifier* _tmp22_;
			ValaCCodeExpression* cdefault;
			_tmp22_ = NULL;
			vala_ccode_function_call_set_call (ccheck, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_identifier_new ("g_return_val_if_fail")));
			(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
			cdefault = vala_ccode_base_module_default_value_for_type (self, ret_type, FALSE);
			if (cdefault != NULL) {
				vala_ccode_function_call_add_argument (ccheck, cdefault);
			} else {
				result = NULL;
				(cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL));
				(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
				(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
				return result;
			}
			(cdefault == NULL) ? NULL : (cdefault = (vala_ccode_node_unref (cdefault), NULL));
		}
	}
	result = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccheck);
	(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
	(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
	return result;
}


gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (!ellipsis) {
		if (param_pos >= 0) {
			result = (gint) (param_pos * 1000);
			return result;
		} else {
			result = (gint) ((100 + param_pos) * 1000);
			return result;
		}
	} else {
		if (param_pos >= 0) {
			result = (gint) ((100 + param_pos) * 1000);
			return result;
		} else {
			result = (gint) ((200 + param_pos) * 1000);
			return result;
		}
	}
}


ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node) {
	ValaCCodeNode* result;
	ValaCCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (vala_code_node_get_ccodenode (node) == NULL) {
		vala_code_node_accept (node, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	}
	_tmp0_ = NULL;
	result = (_tmp0_ = vala_code_node_get_ccodenode (node), (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
	return result;
}


static void vala_ccode_base_module_real_visit_class (ValaCCodeModule* base, ValaClass* cl) {
	ValaCCodeBaseModule * self;
	self = (ValaCCodeBaseModule*) base;
	g_return_if_fail (cl != NULL);
}


ValaCCodeStatement* vala_ccode_base_module_create_postcondition_statement (ValaCCodeBaseModule* self, ValaExpression* postcondition) {
	ValaCCodeStatement* result;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* cassert;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (postcondition != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	cassert = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_warn_if_fail"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) postcondition)));
	result = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) cassert);
	(cassert == NULL) ? NULL : (cassert = (vala_ccode_node_unref (cassert), NULL));
	return result;
}


static gboolean vala_ccode_base_module_real_is_gobject_property (ValaCCodeBaseModule* self, ValaProperty* prop) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean vala_ccode_base_module_is_gobject_property (ValaCCodeBaseModule* self, ValaProperty* prop) {
	return VALA_CCODE_BASE_MODULE_GET_CLASS (self)->is_gobject_property (self, prop);
}


ValaCodeContext* vala_ccode_base_module_get_context (ValaCCodeBaseModule* self) {
	ValaCodeContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_context;
	return result;
}


void vala_ccode_base_module_set_context (ValaCCodeBaseModule* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_context = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_context_ref (_tmp0_)), (self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)), _tmp1_);
}


static void vala_ccode_base_module_class_init (ValaCCodeBaseModuleClass * klass) {
	vala_ccode_base_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_ccode_base_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeBaseModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->emit = vala_ccode_base_module_real_emit;
	VALA_CCODE_MODULE_CLASS (klass)->get_value_setter_function = vala_ccode_base_module_real_get_value_setter_function;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_free = vala_ccode_base_module_real_append_vala_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_move = vala_ccode_base_module_real_append_vala_array_move;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_vala_array_length = vala_ccode_base_module_real_append_vala_array_length;
	VALA_CCODE_MODULE_CLASS (klass)->visit_source_file = vala_ccode_base_module_real_visit_source_file;
	VALA_CCODE_MODULE_CLASS (klass)->visit_enum = vala_ccode_base_module_real_visit_enum;
	VALA_CCODE_MODULE_CLASS (klass)->visit_member = vala_ccode_base_module_real_visit_member;
	VALA_CCODE_MODULE_CLASS (klass)->visit_constant = vala_ccode_base_module_real_visit_constant;
	VALA_CCODE_MODULE_CLASS (klass)->visit_field = vala_ccode_base_module_real_visit_field;
	VALA_CCODE_MODULE_CLASS (klass)->visit_formal_parameter = vala_ccode_base_module_real_visit_formal_parameter;
	VALA_CCODE_MODULE_CLASS (klass)->visit_property = vala_ccode_base_module_real_visit_property;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_class_struct_declaration = vala_ccode_base_module_real_generate_class_struct_declaration;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_struct_declaration = vala_ccode_base_module_real_generate_struct_declaration;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_delegate_declaration = vala_ccode_base_module_real_generate_delegate_declaration;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_cparameters = vala_ccode_base_module_real_generate_cparameters;
	VALA_CCODE_MODULE_CLASS (klass)->visit_property_accessor = vala_ccode_base_module_real_visit_property_accessor;
	VALA_CCODE_MODULE_CLASS (klass)->visit_destructor = vala_ccode_base_module_real_visit_destructor;
	VALA_CCODE_MODULE_CLASS (klass)->visit_block = vala_ccode_base_module_real_visit_block;
	VALA_CCODE_MODULE_CLASS (klass)->visit_empty_statement = vala_ccode_base_module_real_visit_empty_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_declaration_statement = vala_ccode_base_module_real_visit_declaration_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_local_variable = vala_ccode_base_module_real_visit_local_variable;
	VALA_CCODE_MODULE_CLASS (klass)->visit_initializer_list = vala_ccode_base_module_real_visit_initializer_list;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_dup_func_expression = vala_ccode_base_module_real_get_dup_func_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_struct_array_free = vala_ccode_base_module_real_append_struct_array_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_unref_expression = vala_ccode_base_module_real_get_unref_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_end_full_expression = vala_ccode_base_module_real_visit_end_full_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_expression_statement = vala_ccode_base_module_real_visit_expression_statement;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->append_local_free = vala_ccode_base_module_real_append_local_free;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->variable_accessible_in_finally = vala_ccode_base_module_real_variable_accessible_in_finally;
	VALA_CCODE_MODULE_CLASS (klass)->visit_return_statement = vala_ccode_base_module_real_visit_return_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_lock_statement = vala_ccode_base_module_real_visit_lock_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_delete_statement = vala_ccode_base_module_real_visit_delete_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_expression = vala_ccode_base_module_real_visit_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_boolean_literal = vala_ccode_base_module_real_visit_boolean_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_character_literal = vala_ccode_base_module_real_visit_character_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_integer_literal = vala_ccode_base_module_real_visit_integer_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_real_literal = vala_ccode_base_module_real_visit_real_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_string_literal = vala_ccode_base_module_real_visit_string_literal;
	VALA_CCODE_MODULE_CLASS (klass)->visit_null_literal = vala_ccode_base_module_real_visit_null_literal;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cname = vala_ccode_base_module_real_get_delegate_target_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cexpression = vala_ccode_base_module_real_get_delegate_target_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_destroy_notify_cname = vala_ccode_base_module_real_get_delegate_target_destroy_notify_cname;
	VALA_CCODE_MODULE_CLASS (klass)->visit_base_access = vala_ccode_base_module_real_visit_base_access;
	VALA_CCODE_MODULE_CLASS (klass)->visit_postfix_expression = vala_ccode_base_module_real_visit_postfix_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_ref_cexpression = vala_ccode_base_module_real_get_ref_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_class_declaration = vala_ccode_base_module_real_generate_class_declaration;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_interface_declaration = vala_ccode_base_module_real_generate_interface_declaration;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_method_declaration = vala_ccode_base_module_real_generate_method_declaration;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_error_domain_declaration = vala_ccode_base_module_real_generate_error_domain_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_object_creation_expression = vala_ccode_base_module_real_visit_object_creation_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_sizeof_expression = vala_ccode_base_module_real_visit_sizeof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_typeof_expression = vala_ccode_base_module_real_visit_typeof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_unary_expression = vala_ccode_base_module_real_visit_unary_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_cast_expression = vala_ccode_base_module_real_visit_cast_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_pointer_indirection = vala_ccode_base_module_real_visit_pointer_indirection;
	VALA_CCODE_MODULE_CLASS (klass)->visit_addressof_expression = vala_ccode_base_module_real_visit_addressof_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_reference_transfer_expression = vala_ccode_base_module_real_visit_reference_transfer_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_binary_expression = vala_ccode_base_module_real_visit_binary_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_type_check = vala_ccode_base_module_real_visit_type_check;
	VALA_CCODE_MODULE_CLASS (klass)->visit_lambda_expression = vala_ccode_base_module_real_visit_lambda_expression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_implicit_cast_expression = vala_ccode_base_module_real_get_implicit_cast_expression;
	VALA_CCODE_MODULE_CLASS (klass)->visit_class = vala_ccode_base_module_real_visit_class;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->is_gobject_property = vala_ccode_base_module_real_is_gobject_property;
}


static void vala_ccode_base_module_instance_init (ValaCCodeBaseModule * self) {
	self->priv = VALA_CCODE_BASE_MODULE_GET_PRIVATE (self);
	self->temp_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->temp_ref_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->next_temp_var_id = 0;
	self->in_creation_method = FALSE;
	self->in_constructor = FALSE;
	self->in_static_or_class_ctor = FALSE;
	self->current_method_inner_error = FALSE;
	self->next_coroutine_state = 1;
	self->in_plugin = FALSE;
	self->variable_name_map = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
}


static void vala_ccode_base_module_finalize (ValaCCodeModule* obj) {
	ValaCCodeBaseModule * self;
	self = VALA_CCODE_BASE_MODULE (obj);
	(self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL));
	(self->root_symbol == NULL) ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL));
	(self->current_symbol == NULL) ? NULL : (self->current_symbol = (vala_code_node_unref (self->current_symbol), NULL));
	(self->current_type_symbol == NULL) ? NULL : (self->current_type_symbol = (vala_code_node_unref (self->current_type_symbol), NULL));
	(self->current_class == NULL) ? NULL : (self->current_class = (vala_code_node_unref (self->current_class), NULL));
	(self->current_method == NULL) ? NULL : (self->current_method = (vala_code_node_unref (self->current_method), NULL));
	(self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL));
	(self->current_try == NULL) ? NULL : (self->current_try = (vala_code_node_unref (self->current_try), NULL));
	(self->current_property_accessor == NULL) ? NULL : (self->current_property_accessor = (vala_code_node_unref (self->current_property_accessor), NULL));
	(self->header_declarations == NULL) ? NULL : (self->header_declarations = (vala_ccode_declaration_space_unref (self->header_declarations), NULL));
	(self->internal_header_declarations == NULL) ? NULL : (self->internal_header_declarations = (vala_ccode_declaration_space_unref (self->internal_header_declarations), NULL));
	(self->source_declarations == NULL) ? NULL : (self->source_declarations = (vala_ccode_declaration_space_unref (self->source_declarations), NULL));
	(self->source_signal_marshaller_declaration == NULL) ? NULL : (self->source_signal_marshaller_declaration = (vala_ccode_node_unref (self->source_signal_marshaller_declaration), NULL));
	(self->source_type_member_definition == NULL) ? NULL : (self->source_type_member_definition = (vala_ccode_node_unref (self->source_type_member_definition), NULL));
	(self->class_init_fragment == NULL) ? NULL : (self->class_init_fragment = (vala_ccode_node_unref (self->class_init_fragment), NULL));
	(self->base_init_fragment == NULL) ? NULL : (self->base_init_fragment = (vala_ccode_node_unref (self->base_init_fragment), NULL));
	(self->class_finalize_fragment == NULL) ? NULL : (self->class_finalize_fragment = (vala_ccode_node_unref (self->class_finalize_fragment), NULL));
	(self->base_finalize_fragment == NULL) ? NULL : (self->base_finalize_fragment = (vala_ccode_node_unref (self->base_finalize_fragment), NULL));
	(self->instance_init_fragment == NULL) ? NULL : (self->instance_init_fragment = (vala_ccode_node_unref (self->instance_init_fragment), NULL));
	(self->instance_finalize_fragment == NULL) ? NULL : (self->instance_finalize_fragment = (vala_ccode_node_unref (self->instance_finalize_fragment), NULL));
	(self->source_signal_marshaller_definition == NULL) ? NULL : (self->source_signal_marshaller_definition = (vala_ccode_node_unref (self->source_signal_marshaller_definition), NULL));
	(self->module_init_fragment == NULL) ? NULL : (self->module_init_fragment = (vala_ccode_node_unref (self->module_init_fragment), NULL));
	(self->param_spec_struct == NULL) ? NULL : (self->param_spec_struct = (vala_ccode_node_unref (self->param_spec_struct), NULL));
	(self->closure_struct == NULL) ? NULL : (self->closure_struct = (vala_ccode_node_unref (self->closure_struct), NULL));
	(self->prop_enum == NULL) ? NULL : (self->prop_enum = (vala_ccode_node_unref (self->prop_enum), NULL));
	(self->function == NULL) ? NULL : (self->function = (vala_ccode_node_unref (self->function), NULL));
	(self->pre_statement_fragment == NULL) ? NULL : (self->pre_statement_fragment = (vala_ccode_node_unref (self->pre_statement_fragment), NULL));
	(self->temp_vars == NULL) ? NULL : (self->temp_vars = (gee_collection_object_unref (self->temp_vars), NULL));
	(self->temp_ref_vars == NULL) ? NULL : (self->temp_ref_vars = (gee_collection_object_unref (self->temp_ref_vars), NULL));
	(self->user_marshal_set == NULL) ? NULL : (self->user_marshal_set = (gee_collection_object_unref (self->user_marshal_set), NULL));
	(self->predefined_marshal_set == NULL) ? NULL : (self->predefined_marshal_set = (gee_collection_object_unref (self->predefined_marshal_set), NULL));
	(self->priv->reserved_identifiers == NULL) ? NULL : (self->priv->reserved_identifiers = (gee_collection_object_unref (self->priv->reserved_identifiers), NULL));
	(self->bool_type == NULL) ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL));
	(self->char_type == NULL) ? NULL : (self->char_type = (vala_code_node_unref (self->char_type), NULL));
	(self->uchar_type == NULL) ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL));
	(self->unichar_type == NULL) ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL));
	(self->short_type == NULL) ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL));
	(self->ushort_type == NULL) ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL));
	(self->int_type == NULL) ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL));
	(self->uint_type == NULL) ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL));
	(self->long_type == NULL) ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL));
	(self->ulong_type == NULL) ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL));
	(self->int8_type == NULL) ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL));
	(self->uint8_type == NULL) ? NULL : (self->uint8_type = (vala_code_node_unref (self->uint8_type), NULL));
	(self->int16_type == NULL) ? NULL : (self->int16_type = (vala_code_node_unref (self->int16_type), NULL));
	(self->uint16_type == NULL) ? NULL : (self->uint16_type = (vala_code_node_unref (self->uint16_type), NULL));
	(self->int32_type == NULL) ? NULL : (self->int32_type = (vala_code_node_unref (self->int32_type), NULL));
	(self->uint32_type == NULL) ? NULL : (self->uint32_type = (vala_code_node_unref (self->uint32_type), NULL));
	(self->int64_type == NULL) ? NULL : (self->int64_type = (vala_code_node_unref (self->int64_type), NULL));
	(self->uint64_type == NULL) ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL));
	(self->string_type == NULL) ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL));
	(self->float_type == NULL) ? NULL : (self->float_type = (vala_code_node_unref (self->float_type), NULL));
	(self->double_type == NULL) ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL));
	(self->gtype_type == NULL) ? NULL : (self->gtype_type = (vala_code_node_unref (self->gtype_type), NULL));
	(self->gobject_type == NULL) ? NULL : (self->gobject_type = (vala_code_node_unref (self->gobject_type), NULL));
	(self->gerror_type == NULL) ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL));
	(self->glist_type == NULL) ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL));
	(self->gslist_type == NULL) ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL));
	(self->gvaluearray_type == NULL) ? NULL : (self->gvaluearray_type = (vala_code_node_unref (self->gvaluearray_type), NULL));
	(self->gstringbuilder_type == NULL) ? NULL : (self->gstringbuilder_type = (vala_code_node_unref (self->gstringbuilder_type), NULL));
	(self->garray_type == NULL) ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL));
	(self->gbytearray_type == NULL) ? NULL : (self->gbytearray_type = (vala_code_node_unref (self->gbytearray_type), NULL));
	(self->gptrarray_type == NULL) ? NULL : (self->gptrarray_type = (vala_code_node_unref (self->gptrarray_type), NULL));
	(self->gquark_type == NULL) ? NULL : (self->gquark_type = (vala_code_node_unref (self->gquark_type), NULL));
	(self->gvalue_type == NULL) ? NULL : (self->gvalue_type = (vala_code_node_unref (self->gvalue_type), NULL));
	(self->mutex_type == NULL) ? NULL : (self->mutex_type = (vala_code_node_unref (self->mutex_type), NULL));
	(self->type_module_type == NULL) ? NULL : (self->type_module_type = (vala_code_node_unref (self->type_module_type), NULL));
	(self->dbus_object_type == NULL) ? NULL : (self->dbus_object_type = (vala_code_node_unref (self->dbus_object_type), NULL));
	self->module_init_param_name = (g_free (self->module_init_param_name), NULL);
	(self->wrappers == NULL) ? NULL : (self->wrappers = (gee_collection_object_unref (self->wrappers), NULL));
	(self->priv->generated_external_symbols == NULL) ? NULL : (self->priv->generated_external_symbols = (gee_collection_object_unref (self->priv->generated_external_symbols), NULL));
	(self->variable_name_map == NULL) ? NULL : (self->variable_name_map = (gee_collection_object_unref (self->variable_name_map), NULL));
	VALA_CCODE_MODULE_CLASS (vala_ccode_base_module_parent_class)->finalize (obj);
}


GType vala_ccode_base_module_get_type (void) {
	static GType vala_ccode_base_module_type_id = 0;
	if (vala_ccode_base_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBaseModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_base_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBaseModule), 0, (GInstanceInitFunc) vala_ccode_base_module_instance_init, NULL };
		vala_ccode_base_module_type_id = g_type_register_static (VALA_TYPE_CCODE_MODULE, "ValaCCodeBaseModule", &g_define_type_info, 0);
	}
	return vala_ccode_base_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




