/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.adaptator.impl;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.IXMLParser;
import com.izforge.izpack.adaptator.XMLException;
import com.izforge.izpack.adaptator.impl.LineNumberFilter;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLParser
implements IXMLParser {
    private LineNumberFilter filter;
    private String parsedItem = null;

    public XMLParser() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setXIncludeAware(true);
            XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
            this.filter = new LineNumberFilter(xMLReader);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new XMLException(sAXException);
        }
    }

    private IXMLElement searchFirstElement(DOMResult dOMResult) {
        for (Node node = dOMResult.getNode().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return new XMLElementImpl(node);
        }
        return null;
    }

    private DOMResult parseLineNrFromInputSource(InputSource inputSource) {
        DOMResult dOMResult = null;
        try {
            dOMResult = new DOMResult();
            SAXSource sAXSource = new SAXSource(inputSource);
            sAXSource.setXMLReader(this.filter);
            StreamSource streamSource = new StreamSource(IXMLParser.class.getResource("styleSheet.xsl").openStream());
            Transformer transformer = TransformerFactory.newInstance().newTransformer(streamSource);
            transformer.transform(sAXSource, dOMResult);
            this.filter.applyLN(dOMResult);
        }
        catch (TransformerException transformerException) {
            String string = null;
            if (this.parsedItem != null) {
                string = " in " + this.parsedItem;
            }
            if (transformerException.getLocator() == null && this.filter.getDocumentLocator() != null) {
                Locator locator = this.filter.getDocumentLocator();
                string = string + " at line " + locator.getLineNumber() + ", column " + locator.getColumnNumber();
            }
            if (string != null) {
                throw new XMLException("Error" + string + " : " + transformerException.getMessage(), transformerException);
            }
            throw new XMLException(transformerException);
        }
        catch (IOException iOException) {
            throw new XMLException(iOException);
        }
        finally {
            this.parsedItem = null;
        }
        return dOMResult;
    }

    public IXMLElement parse(InputStream inputStream) {
        this.parsedItem = null;
        InputSource inputSource = new InputSource(inputStream);
        DOMResult dOMResult = this.parseLineNrFromInputSource(inputSource);
        return this.searchFirstElement(dOMResult);
    }

    public IXMLElement parse(InputStream inputStream, String string) {
        this.parsedItem = string;
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        DOMResult dOMResult = this.parseLineNrFromInputSource(inputSource);
        return this.searchFirstElement(dOMResult);
    }

    public IXMLElement parse(String string) {
        this.parsedItem = null;
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(string);
        return this.parse(new ByteBufferInputStream(byteBuffer));
    }

    public IXMLElement parse(URL uRL) {
        this.parsedItem = uRL.toString();
        InputSource inputSource = new InputSource(uRL.toExternalForm());
        DOMResult dOMResult = this.parseLineNrFromInputSource(inputSource);
        return this.searchFirstElement(dOMResult);
    }

    public class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer buf;

        public ByteBufferInputStream(ByteBuffer byteBuffer) {
            this.buf = byteBuffer;
        }

        public synchronized int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            int n = this.buf.get() & 0xFF;
            return n;
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            n2 = Math.min(n2, this.buf.remaining());
            this.buf.get(byArray, n, n2);
            return n2;
        }

        public int available() throws IOException {
            return this.buf.remaining();
        }
    }
}

