//
// JSError.cs:
//
// Author:
//	Cesar Lopez Nataren (cesar@ciencias.unam.mx)
//
// (C) 2003, Cesar Lopez Nataren
//

//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

namespace Microsoft.JScript {

	public enum JSError {
		NoError,
		InvalidCall,
		OutOfMemory,
		TypeMismatch,
		OutOfStack,
		InternalError,
		FileNotFound,
		NeedObject,
		CantCreateObject,
		OLENoPropOrMethod,
		ActionNotSupported,
		NotCollection,


		SyntaxError,
		NoColon,
		NoSemicolon,
		NoLeftParen,
		NoRightParen,
		NoRightBracket,
		NoLeftCurly,
		NoRightCurly,
		NoIdentifier,
		NoEqual,
		IllegalChar,
		UnterminatedString,
		NoCommentEnd,
		BadReturn,
		BadBreak,
		BadContinue,
		BadHexDigit,
		NoWhile,
		BadLabel,
		NoLabel,
		DupDefault,
		NoMemberIdentifier,
		NoCcEnd,
		CcOff,
		NotConst,
		NoAt,
		NoCatch,
		InvalidElse,
		NoComma,
		DupVisibility,
		IllegalVisibility,
		BadSwitch,
		CcInvalidEnd,
		CcInvalidElse,
		CcInvalidElif,
		ErrEOF,
		IncompatibleVisibility,
		ClassNotAllowed,
		NeedCompileTimeConstant,
		DuplicateName,
		NeedType,
		NotInsideClass,
		InvalidPositionDirective,
		MustBeEOL,
		WrongDirective,
		CannotNestPositionDirective,
		CircularDefinition,
		Deprecated,
		IllegalUseOfThis,
		NotAccessible,
		CannotUseNameOfClass,
		MustImplementMethod,
		NeedInterface,
		UnreachableCatch,
		TypeCannotBeExtended,
		UndeclaredVariable,
		VariableLeftUninitialized,
		KeywordUsedAsIdentifier,
		NotAllowedInSuperConstructorCall,
		NotMeantToBeCalledDirectly,
		GetAndSetAreInconsistent,
		InvalidCustomAttribute,
		InvalidCustomAttributeArgument,
		InvalidCustomAttributeClassOrCtor,
		TooManyParameters,
		AmbiguousBindingBecauseOfWith,
		AmbiguousBindingBecauseOfEval,
		NoSuchMember,
		ItemNotAllowedOnExpandoClass,
		MethodNotAllowedOnExpandoClass,
		MethodClashOnExpandoSuperClass,
		BaseClassIsExpandoAlready,
		AbstractCannotBePrivate,
		NotIndexable,
		StaticMissingInStaticInit,
		MissingConstructForAttributes,
		OnlyClassesAllowed,
		ExpandoClassShouldNotImpleEnumerable,
		NonCLSCompliantMember,
		NotDeletable,
		PackageExpected,
		UselessExpression,
		HidesParentMember,
		CannotChangeVisibility,
		HidesAbstractInBase,
		NewNotSpecifiedInMethodDeclaration,
		MethodInBaseIsNotVirtual,
		NoMethodInBaseToNew,
		DifferentReturnTypeFromBase,
		ClashWithProperty,
		OverrideAndHideUsedTogether,
		InvalidLanguageOption,
		NoMethodInBaseToOverride,
		NotValidForConstructor,
		CannotReturnValueFromVoidFunction,
		AmbiguousMatch,
		AmbiguousConstructorCall,
		SuperClassConstructorNotAccessible,
		OctalLiteralsAreDeprecated,
		VariableMightBeUnitialized,
		NotOKToCallSuper,
		IllegalUseOfSuper,
		BadWayToLeaveFinally,
		NoCommaOrTypeDefinitionError,
		AbstractWithBody,
		NoRightParenOrComma,
		NoRightBracketOrComma,
		ExpressionExpected,
		UnexpectedSemicolon,
		TooManyTokensSkipped,
		BadVariableDeclaration,
		BadFunctionDeclaration,
		BadPropertyDeclaration,
		DoesNotHaveAnAddress,
		TooFewParameters,
		UselessAssignment,
		SuspectAssignment,
		SuspectSemicolon,
		ImpossibleConversion,
		FinalPrecludesAbstract,
		NeedInstance,
		CannotBeAbstract,
		InvalidBaseTypeForEnum,
		CannotInstantiateAbstractClass,
		ArrayMayBeCopied,
		AbstractCannotBeStatic,
		StaticIsAlreadyFinal,
		StaticMethodsCannotOverride,
		StaticMethodsCannotHide,
		ExpandoPrecludesOverride,
		IllegalParamArrayAttribute,
		ExpandoPrecludesAbstract,
		ShouldBeAbstract,
		BadModifierInInterface,
		VarIllegalInInterface,
		InterfaceIllegalInInterface,
		NoVarInEnum,
		InvalidImport,
		EnumNotAllowed,
		InvalidCustomAttributeTarget,
		PackageInWrongContext,
		ConstructorMayNotHaveReturnType,
		OnlyClassesAndPackagesAllowed,
		InvalidDebugDirective,
		CustomAttributeUsedMoreThanOnce,
		NestedInstanceTypeCannotBeExtendedByStatic,
		PropertyLevelAttributesMustBeOnGetter,
		BadThrow,
		ParamListNotLast,
		NoSuchType,
		BadOctalLiteral,
		InstanceNotAccessibleFromStatic,
		StaticRequiresTypeName,
		NonStaticWithTypeName,
		NoSuchStaticMember,
		SuspectLoopCondition,
		ExpectedAssembly,
		AssemblyAttributesMustBeGlobal,
		ExpandoPrecludesStatic,
		DuplicateMethod,
		NotAnExpandoFunction,
		NotValidVersionString,
		ExecutablesCannotBeLocalized,
		StringConcatIsSlow,
		CcInvalidInDebugger,
		ExpandoMustBePublic,
		DelegatesShouldNotBeExplicitlyConstructed,
		ImplicitlyReferencedAssemblyNotFound,
		PossibleBadConversion,
		PossibleBadConversionFromString,
		InvalidResource,
		WrongUseOfAddressOf,
		NonCLSCompliantType,
		MemberTypeCLSCompliantMismatch,
		TypeAssemblyCLSCompliantMismatch,


		CantAssignThis,
		NumberExpected,
		FunctionExpected,
		CannotAssignToFunctionResult,
		StringExpected,
		DateExpected,
		ObjectExpected,
		IllegalAssignment,
		UndefinedIdentifier,
		BooleanExpected,
		VBArrayExpected,
		EnumeratorExpected,
		RegExpExpected,
		RegExpSyntax,
		UncaughtException,
		InvalidPrototype,
		URIEncodeError,
		URIDecodeError,
		FractionOutOfRange,
		PrecisionOutOfRange,
		ArrayLengthConstructIncorrect,
		ArrayLengthAssignIncorrect,
		NeedArrayObject,
		NoConstructor,
		IllegalEval,
		NotYetImplemented,
		MustProvideNameForNamedParameter,
		DuplicateNamedParameter,
		MissingNameParameter,
		MoreNamedParametersThanArguments,
		NonSupportedInDebugger,
		AssignmentToReadOnly,
		WriteOnlyProperty,
		IncorrectNumberOfIndices,
		RefParamsNonSupportedInDebugger,
		CannotCallSecurityMethodLateBound,
		CannotUseStaticSecurityAttribute,


		FuncEvalAborted,
		FuncEvalTimedout,
		FuncEvalThreadSuspended,
		FuncEvalThreadSleepWaitJoin,
		FuncEvalBadThreadState,
		FuncEvalBadThreadNotStarted,
		NoFuncEvalAllowed,
		FuncEvalBadLocation,
		FuncEvalWebMethod,
		StaticVarNotAvailable,
		TypeObjectNotAvailable,
		ExceptionFromHResult
	}
}
