/* testdeque.c generated by valac 0.11.5, the Vala compiler
 * generated from testdeque.vala, do not modify */

/* testdeque.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_QUEUE_TESTS (queue_tests_get_type ())
#define QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUEUE_TESTS, QueueTests))
#define QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUEUE_TESTS, QueueTestsClass))
#define IS_QUEUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUEUE_TESTS))
#define IS_QUEUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUEUE_TESTS))
#define QUEUE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUEUE_TESTS, QueueTestsClass))

typedef struct _QueueTests QueueTests;
typedef struct _QueueTestsClass QueueTestsClass;
typedef struct _QueueTestsPrivate QueueTestsPrivate;

#define TYPE_DEQUE_TESTS (deque_tests_get_type ())
#define DEQUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEQUE_TESTS, DequeTests))
#define DEQUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEQUE_TESTS, DequeTestsClass))
#define IS_DEQUE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEQUE_TESTS))
#define IS_DEQUE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEQUE_TESTS))
#define DEQUE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEQUE_TESTS, DequeTestsClass))

typedef struct _DequeTests DequeTests;
typedef struct _DequeTestsClass DequeTestsClass;
typedef struct _DequeTestsPrivate DequeTestsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _QueueTests {
	CollectionTests parent_instance;
	QueueTestsPrivate * priv;
};

struct _QueueTestsClass {
	CollectionTestsClass parent_class;
};

struct _DequeTests {
	QueueTests parent_instance;
	DequeTestsPrivate * priv;
};

struct _DequeTestsClass {
	QueueTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer deque_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType queue_tests_get_type (void) G_GNUC_CONST;
GType deque_tests_get_type (void) G_GNUC_CONST;
enum  {
	DEQUE_TESTS_DUMMY_PROPERTY
};
DequeTests* deque_tests_construct (GType object_type, const gchar* name);
QueueTests* queue_tests_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void deque_tests_test_queue_use (DequeTests* self);
static void _deque_tests_test_queue_use_gee_test_case_test_method (gpointer self);
void deque_tests_test_stack_use (DequeTests* self);
static void _deque_tests_test_stack_use_gee_test_case_test_method (gpointer self);
void deque_tests_test_reversed_stack_use (DequeTests* self);
static void _deque_tests_test_reversed_stack_use_gee_test_case_test_method (gpointer self);


static void _deque_tests_test_queue_use_gee_test_case_test_method (gpointer self) {
	deque_tests_test_queue_use (self);
}


static void _deque_tests_test_stack_use_gee_test_case_test_method (gpointer self) {
	deque_tests_test_stack_use (self);
}


static void _deque_tests_test_reversed_stack_use_gee_test_case_test_method (gpointer self) {
	deque_tests_test_reversed_stack_use (self);
}


DequeTests* deque_tests_construct (GType object_type, const gchar* name) {
	DequeTests * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (DequeTests*) queue_tests_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[Deque] queue use", _deque_tests_test_queue_use_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Deque] stack use", _deque_tests_test_stack_use_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Deque] reversed stack use", _deque_tests_test_reversed_stack_use_gee_test_case_test_method, self);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void deque_tests_test_queue_use (DequeTests* self) {
	GeeCollection* _tmp0_;
	GeeDeque* _tmp1_;
	GeeDeque* test_deque;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* recipient;
	gboolean _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_ = NULL;
	gchar* _tmp22_;
	gpointer _tmp23_ = NULL;
	gchar* _tmp24_;
	gint _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	gint _tmp30_;
	gpointer _tmp31_ = NULL;
	gchar* _tmp32_;
	gpointer _tmp33_ = NULL;
	gchar* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gpointer _tmp43_ = NULL;
	gchar* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gpointer _tmp48_ = NULL;
	gchar* _tmp49_;
	gpointer _tmp50_ = NULL;
	gchar* _tmp51_;
	gpointer _tmp52_ = NULL;
	gchar* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_DEQUE (_tmp0_) ? ((GeeDeque*) _tmp0_) : NULL));
	test_deque = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	recipient = _tmp2_;
	g_assert (test_deque != NULL);
	_tmp3_ = gee_deque_offer_tail (test_deque, "one");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp4_ == 1);
	_tmp5_ = gee_deque_offer_tail (test_deque, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp6_ == 2);
	_tmp7_ = gee_deque_offer_tail (test_deque, "three");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp8_ == 3);
	_tmp9_ = gee_deque_offer_tail (test_deque, "four");
	g_assert (_tmp9_);
	_tmp10_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp10_ == 4);
	_tmp11_ = gee_deque_peek_head (test_deque);
	_tmp12_ = (gchar*) _tmp11_;
	g_assert (g_strcmp0 (_tmp12_, "one") == 0);
	_g_free0 (_tmp12_);
	_tmp13_ = gee_deque_poll_head (test_deque);
	_tmp14_ = (gchar*) _tmp13_;
	g_assert (g_strcmp0 (_tmp14_, "one") == 0);
	_g_free0 (_tmp14_);
	_tmp15_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp15_ == 3);
	_tmp16_ = gee_deque_peek_head (test_deque);
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "two") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_deque_poll_head (test_deque);
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "two") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp20_ == 2);
	_tmp21_ = gee_deque_peek_head (test_deque);
	_tmp22_ = (gchar*) _tmp21_;
	g_assert (g_strcmp0 (_tmp22_, "three") == 0);
	_g_free0 (_tmp22_);
	_tmp23_ = gee_deque_poll_head (test_deque);
	_tmp24_ = (gchar*) _tmp23_;
	g_assert (g_strcmp0 (_tmp24_, "three") == 0);
	_g_free0 (_tmp24_);
	_tmp25_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp25_ == 1);
	_tmp26_ = gee_deque_peek_head (test_deque);
	_tmp27_ = (gchar*) _tmp26_;
	g_assert (g_strcmp0 (_tmp27_, "four") == 0);
	_g_free0 (_tmp27_);
	_tmp28_ = gee_deque_poll_head (test_deque);
	_tmp29_ = (gchar*) _tmp28_;
	g_assert (g_strcmp0 (_tmp29_, "four") == 0);
	_g_free0 (_tmp29_);
	_tmp30_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp30_ == 0);
	_tmp31_ = gee_deque_peek_head (test_deque);
	_tmp32_ = (gchar*) _tmp31_;
	g_assert (_tmp32_ == NULL);
	_g_free0 (_tmp32_);
	_tmp33_ = gee_deque_poll_head (test_deque);
	_tmp34_ = (gchar*) _tmp33_;
	g_assert (_tmp34_ == NULL);
	_g_free0 (_tmp34_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp35_ = gee_deque_offer_tail (test_deque, "one");
	g_assert (_tmp35_);
	_tmp36_ = gee_deque_offer_tail (test_deque, "two");
	g_assert (_tmp36_);
	_tmp37_ = gee_deque_offer_tail (test_deque, "three");
	g_assert (_tmp37_);
	_tmp38_ = gee_deque_offer_tail (test_deque, "four");
	g_assert (_tmp38_);
	_tmp39_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp39_ == 4);
	_tmp40_ = gee_deque_drain_head (test_deque, (GeeCollection*) recipient, 1);
	g_assert (_tmp40_ == 1);
	_tmp41_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp41_ == 3);
	_tmp42_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp42_ == 1);
	_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 0);
	_tmp44_ = (gchar*) _tmp43_;
	g_assert (g_strcmp0 (_tmp44_, "one") == 0);
	_g_free0 (_tmp44_);
	_tmp45_ = gee_deque_drain_head (test_deque, (GeeCollection*) recipient, -1);
	g_assert (_tmp45_ == 3);
	_tmp46_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp46_ == 0);
	_tmp47_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp47_ == 4);
	_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 1);
	_tmp49_ = (gchar*) _tmp48_;
	g_assert (g_strcmp0 (_tmp49_, "two") == 0);
	_g_free0 (_tmp49_);
	_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 2);
	_tmp51_ = (gchar*) _tmp50_;
	g_assert (g_strcmp0 (_tmp51_, "three") == 0);
	_g_free0 (_tmp51_);
	_tmp52_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 3);
	_tmp53_ = (gchar*) _tmp52_;
	g_assert (g_strcmp0 (_tmp53_, "four") == 0);
	_g_free0 (_tmp53_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp54_ = gee_deque_drain_head (test_deque, (GeeCollection*) recipient, 1);
	g_assert (_tmp54_ == 0);
	_tmp55_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp55_ == 0);
	_tmp56_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp56_ == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp57_ = gee_deque_drain_head (test_deque, (GeeCollection*) recipient, -1);
	g_assert (_tmp57_ == 0);
	_tmp58_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp58_ == 0);
	_tmp59_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp59_ == 0);
	_g_object_unref0 (recipient);
	_g_object_unref0 (test_deque);
}


void deque_tests_test_stack_use (DequeTests* self) {
	GeeCollection* _tmp0_;
	GeeDeque* _tmp1_;
	GeeDeque* test_deque;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* recipient;
	gboolean _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_ = NULL;
	gchar* _tmp22_;
	gpointer _tmp23_ = NULL;
	gchar* _tmp24_;
	gint _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	gint _tmp30_;
	gpointer _tmp31_ = NULL;
	gchar* _tmp32_;
	gpointer _tmp33_ = NULL;
	gchar* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gpointer _tmp43_ = NULL;
	gchar* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gpointer _tmp48_ = NULL;
	gchar* _tmp49_;
	gpointer _tmp50_ = NULL;
	gchar* _tmp51_;
	gpointer _tmp52_ = NULL;
	gchar* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_DEQUE (_tmp0_) ? ((GeeDeque*) _tmp0_) : NULL));
	test_deque = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	recipient = _tmp2_;
	g_assert (test_deque != NULL);
	_tmp3_ = gee_deque_offer_head (test_deque, "one");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp4_ == 1);
	_tmp5_ = gee_deque_offer_head (test_deque, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp6_ == 2);
	_tmp7_ = gee_deque_offer_head (test_deque, "three");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp8_ == 3);
	_tmp9_ = gee_deque_offer_head (test_deque, "four");
	g_assert (_tmp9_);
	_tmp10_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp10_ == 4);
	_tmp11_ = gee_deque_peek_head (test_deque);
	_tmp12_ = (gchar*) _tmp11_;
	g_assert (g_strcmp0 (_tmp12_, "four") == 0);
	_g_free0 (_tmp12_);
	_tmp13_ = gee_deque_poll_head (test_deque);
	_tmp14_ = (gchar*) _tmp13_;
	g_assert (g_strcmp0 (_tmp14_, "four") == 0);
	_g_free0 (_tmp14_);
	_tmp15_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp15_ == 3);
	_tmp16_ = gee_deque_peek_head (test_deque);
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "three") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_deque_poll_head (test_deque);
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "three") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp20_ == 2);
	_tmp21_ = gee_deque_peek_head (test_deque);
	_tmp22_ = (gchar*) _tmp21_;
	g_assert (g_strcmp0 (_tmp22_, "two") == 0);
	_g_free0 (_tmp22_);
	_tmp23_ = gee_deque_poll_head (test_deque);
	_tmp24_ = (gchar*) _tmp23_;
	g_assert (g_strcmp0 (_tmp24_, "two") == 0);
	_g_free0 (_tmp24_);
	_tmp25_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp25_ == 1);
	_tmp26_ = gee_deque_peek_head (test_deque);
	_tmp27_ = (gchar*) _tmp26_;
	g_assert (g_strcmp0 (_tmp27_, "one") == 0);
	_g_free0 (_tmp27_);
	_tmp28_ = gee_deque_poll_head (test_deque);
	_tmp29_ = (gchar*) _tmp28_;
	g_assert (g_strcmp0 (_tmp29_, "one") == 0);
	_g_free0 (_tmp29_);
	_tmp30_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp30_ == 0);
	_tmp31_ = gee_deque_peek_head (test_deque);
	_tmp32_ = (gchar*) _tmp31_;
	g_assert (_tmp32_ == NULL);
	_g_free0 (_tmp32_);
	_tmp33_ = gee_deque_poll_head (test_deque);
	_tmp34_ = (gchar*) _tmp33_;
	g_assert (_tmp34_ == NULL);
	_g_free0 (_tmp34_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp35_ = gee_deque_offer_head (test_deque, "one");
	g_assert (_tmp35_);
	_tmp36_ = gee_deque_offer_head (test_deque, "two");
	g_assert (_tmp36_);
	_tmp37_ = gee_deque_offer_head (test_deque, "three");
	g_assert (_tmp37_);
	_tmp38_ = gee_deque_offer_head (test_deque, "four");
	g_assert (_tmp38_);
	_tmp39_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp39_ == 4);
	_tmp40_ = gee_deque_drain_head (test_deque, (GeeCollection*) recipient, 1);
	g_assert (_tmp40_ == 1);
	_tmp41_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp41_ == 3);
	_tmp42_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp42_ == 1);
	_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 0);
	_tmp44_ = (gchar*) _tmp43_;
	g_assert (g_strcmp0 (_tmp44_, "four") == 0);
	_g_free0 (_tmp44_);
	_tmp45_ = gee_deque_drain_head (test_deque, (GeeCollection*) recipient, -1);
	g_assert (_tmp45_ == 3);
	_tmp46_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp46_ == 0);
	_tmp47_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp47_ == 4);
	_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 1);
	_tmp49_ = (gchar*) _tmp48_;
	g_assert (g_strcmp0 (_tmp49_, "three") == 0);
	_g_free0 (_tmp49_);
	_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 2);
	_tmp51_ = (gchar*) _tmp50_;
	g_assert (g_strcmp0 (_tmp51_, "two") == 0);
	_g_free0 (_tmp51_);
	_tmp52_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 3);
	_tmp53_ = (gchar*) _tmp52_;
	g_assert (g_strcmp0 (_tmp53_, "one") == 0);
	_g_free0 (_tmp53_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp54_ = gee_deque_drain_head (test_deque, (GeeCollection*) recipient, 1);
	g_assert (_tmp54_ == 0);
	_tmp55_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp55_ == 0);
	_tmp56_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp56_ == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp57_ = gee_deque_drain_head (test_deque, (GeeCollection*) recipient, -1);
	g_assert (_tmp57_ == 0);
	_tmp58_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp58_ == 0);
	_tmp59_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp59_ == 0);
	_g_object_unref0 (recipient);
	_g_object_unref0 (test_deque);
}


void deque_tests_test_reversed_stack_use (DequeTests* self) {
	GeeCollection* _tmp0_;
	GeeDeque* _tmp1_;
	GeeDeque* test_deque;
	GeeArrayList* _tmp2_ = NULL;
	GeeArrayList* recipient;
	gboolean _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gint _tmp20_;
	gpointer _tmp21_ = NULL;
	gchar* _tmp22_;
	gpointer _tmp23_ = NULL;
	gchar* _tmp24_;
	gint _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	gint _tmp30_;
	gpointer _tmp31_ = NULL;
	gchar* _tmp32_;
	gpointer _tmp33_ = NULL;
	gchar* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gpointer _tmp43_ = NULL;
	gchar* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	gpointer _tmp48_ = NULL;
	gchar* _tmp49_;
	gpointer _tmp50_ = NULL;
	gchar* _tmp51_;
	gpointer _tmp52_ = NULL;
	gchar* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_DEQUE (_tmp0_) ? ((GeeDeque*) _tmp0_) : NULL));
	test_deque = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	recipient = _tmp2_;
	g_assert (test_deque != NULL);
	_tmp3_ = gee_deque_offer_tail (test_deque, "one");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp4_ == 1);
	_tmp5_ = gee_deque_offer_tail (test_deque, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp6_ == 2);
	_tmp7_ = gee_deque_offer_tail (test_deque, "three");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp8_ == 3);
	_tmp9_ = gee_deque_offer_tail (test_deque, "four");
	g_assert (_tmp9_);
	_tmp10_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp10_ == 4);
	_tmp11_ = gee_deque_peek_tail (test_deque);
	_tmp12_ = (gchar*) _tmp11_;
	g_assert (g_strcmp0 (_tmp12_, "four") == 0);
	_g_free0 (_tmp12_);
	_tmp13_ = gee_deque_poll_tail (test_deque);
	_tmp14_ = (gchar*) _tmp13_;
	g_assert (g_strcmp0 (_tmp14_, "four") == 0);
	_g_free0 (_tmp14_);
	_tmp15_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp15_ == 3);
	_tmp16_ = gee_deque_peek_tail (test_deque);
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "three") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_deque_poll_tail (test_deque);
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "three") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp20_ == 2);
	_tmp21_ = gee_deque_peek_tail (test_deque);
	_tmp22_ = (gchar*) _tmp21_;
	g_assert (g_strcmp0 (_tmp22_, "two") == 0);
	_g_free0 (_tmp22_);
	_tmp23_ = gee_deque_poll_tail (test_deque);
	_tmp24_ = (gchar*) _tmp23_;
	g_assert (g_strcmp0 (_tmp24_, "two") == 0);
	_g_free0 (_tmp24_);
	_tmp25_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp25_ == 1);
	_tmp26_ = gee_deque_peek_tail (test_deque);
	_tmp27_ = (gchar*) _tmp26_;
	g_assert (g_strcmp0 (_tmp27_, "one") == 0);
	_g_free0 (_tmp27_);
	_tmp28_ = gee_deque_poll_tail (test_deque);
	_tmp29_ = (gchar*) _tmp28_;
	g_assert (g_strcmp0 (_tmp29_, "one") == 0);
	_g_free0 (_tmp29_);
	_tmp30_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp30_ == 0);
	_tmp31_ = gee_deque_peek_tail (test_deque);
	_tmp32_ = (gchar*) _tmp31_;
	g_assert (_tmp32_ == NULL);
	_g_free0 (_tmp32_);
	_tmp33_ = gee_deque_poll_tail (test_deque);
	_tmp34_ = (gchar*) _tmp33_;
	g_assert (_tmp34_ == NULL);
	_g_free0 (_tmp34_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp35_ = gee_deque_offer_tail (test_deque, "one");
	g_assert (_tmp35_);
	_tmp36_ = gee_deque_offer_tail (test_deque, "two");
	g_assert (_tmp36_);
	_tmp37_ = gee_deque_offer_tail (test_deque, "three");
	g_assert (_tmp37_);
	_tmp38_ = gee_deque_offer_tail (test_deque, "four");
	g_assert (_tmp38_);
	_tmp39_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp39_ == 4);
	_tmp40_ = gee_deque_drain_tail (test_deque, (GeeCollection*) recipient, 1);
	g_assert (_tmp40_ == 1);
	_tmp41_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp41_ == 3);
	_tmp42_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp42_ == 1);
	_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 0);
	_tmp44_ = (gchar*) _tmp43_;
	g_assert (g_strcmp0 (_tmp44_, "four") == 0);
	_g_free0 (_tmp44_);
	_tmp45_ = gee_deque_drain_tail (test_deque, (GeeCollection*) recipient, -1);
	g_assert (_tmp45_ == 3);
	_tmp46_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp46_ == 0);
	_tmp47_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp47_ == 4);
	_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 1);
	_tmp49_ = (gchar*) _tmp48_;
	g_assert (g_strcmp0 (_tmp49_, "three") == 0);
	_g_free0 (_tmp49_);
	_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 2);
	_tmp51_ = (gchar*) _tmp50_;
	g_assert (g_strcmp0 (_tmp51_, "two") == 0);
	_g_free0 (_tmp51_);
	_tmp52_ = gee_abstract_list_get ((GeeAbstractList*) recipient, 3);
	_tmp53_ = (gchar*) _tmp52_;
	g_assert (g_strcmp0 (_tmp53_, "one") == 0);
	_g_free0 (_tmp53_);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp54_ = gee_deque_drain_tail (test_deque, (GeeCollection*) recipient, 1);
	g_assert (_tmp54_ == 0);
	_tmp55_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp55_ == 0);
	_tmp56_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp56_ == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) recipient);
	_tmp57_ = gee_deque_drain_tail (test_deque, (GeeCollection*) recipient, -1);
	g_assert (_tmp57_ == 0);
	_tmp58_ = gee_collection_get_size ((GeeCollection*) test_deque);
	g_assert (_tmp58_ == 0);
	_tmp59_ = gee_collection_get_size ((GeeCollection*) recipient);
	g_assert (_tmp59_ == 0);
	_g_object_unref0 (recipient);
	_g_object_unref0 (test_deque);
}


static void deque_tests_class_init (DequeTestsClass * klass) {
	deque_tests_parent_class = g_type_class_peek_parent (klass);
}


static void deque_tests_instance_init (DequeTests * self) {
}


GType deque_tests_get_type (void) {
	static volatile gsize deque_tests_type_id__volatile = 0;
	if (g_once_init_enter (&deque_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DequeTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deque_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DequeTests), 0, (GInstanceInitFunc) deque_tests_instance_init, NULL };
		GType deque_tests_type_id;
		deque_tests_type_id = g_type_register_static (TYPE_QUEUE_TESTS, "DequeTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&deque_tests_type_id__volatile, deque_tests_type_id);
	}
	return deque_tests_type_id__volatile;
}



