/****************************************************************************

 KHotKeys
 
 Copyright (C) 2005 Olivier Goffgart <ogoffart @ kde.org>

 Distributed under the terms of the GNU General Public License version 2.
 
****************************************************************************/

#include <qcolor.h>
#include <qevent.h>

#include "voicerecorder.h"
#include "soundrecorder.h"
#include "voicesignature.h"
#include "voices.h"
#include <kpushbutton.h>
#include <klineedit.h>
#include <klocale.h>
#include <ktempfile.h>
#include <qlabel.h>
#include <qpainter.h>
#include <kmessagebox.h>

#include <kstandarddirs.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#ifdef HAVE_ARTS

#include <arts/kplayobject.h>
#include <arts/kartsserver.h>
#include <arts/kartsdispatcher.h>
#include <arts/kplayobjectfactory.h>

#endif

namespace KHotKeys
{

VoiceRecorder::VoiceRecorder(const Sound& sound_P, const QString &voiceId, QWidget *parent, const char *name)
	: Voice_input_widget_ui(parent, name) , _recorder( SoundRecorder::create(this)) , _state(sNotModified), _tempFile(0L) ,  _voiceId(voiceId)
{
	_sound=sound_P;
	buttonPlay->setEnabled(sound_P.size() > 50);
	buttonStop->setEnabled(false);

	connect (_recorder , SIGNAL(recorded(const Sound& )) , this , SLOT(slotSoundRecorded(const Sound& ) ));

	//if(voiceid_P.isEmpty())
	emit recorded(false);
	
	drawSound();
}

VoiceRecorder::~VoiceRecorder()
{
	delete _tempFile;
}

void VoiceRecorder::slotRecordPressed()
{
       buttonRecord->setEnabled(false);
       buttonPlay->setEnabled(false);
       buttonStop->setEnabled(true);
      _recorder->start();
       label->setText(i18n("Recording ..."));
}

void VoiceRecorder::slotStopPressed()
{
       buttonRecord->setEnabled(true);
       buttonPlay->setEnabled(false);
       buttonStop->setEnabled(false);
       _recorder->stop();
}

void VoiceRecorder::slotPlayPressed()
{
#ifdef HAVE_ARTS
	/*if(!_modified)
	{
		QString fileName = locateLocal( "appdata", _original_voiuceid +  ".wav"  );
		KArtsDispatcher dispatcher;
		KArtsServer server;
		KDE::PlayObjectFactory factory( server.server() );
		KDE::PlayObject* playobj = factory.createPlayObject(fileName, true );
		playobj->play();
	}
	else
	{*/
	if(!_tempFile)
	{
		_tempFile=new KTempFile(QString::null,".wav");
		_tempFile->setAutoDelete(true);
	}
	_sound.save(_tempFile->name());
	KArtsDispatcher dispatcher;
	KArtsServer server;
	KDE::PlayObjectFactory factory( server.server() );
	KDE::PlayObject* playobj = factory.createPlayObject(_tempFile->name(), true );
	playobj->play();
#endif
}

Sound VoiceRecorder::sound() const
{
		return _sound;
}


void VoiceRecorder::slotSoundRecorded(const Sound &sound)
{
	buttonPlay->setEnabled(true);
	_sound=sound;

	bool correct=drawSound()  &&  sound.size()>50;
	if(correct)
	{
		QString vm=voice_handler->isNewSoundFarEnough( VoiceSignature(sound), _voiceId);
		if(!vm.isNull())
		{
			KMessageBox::sorry (this, i18n("The word you recorded is too close to the existing reference '%1', please record another word.").arg(vm) );
			//TODO: messagebox saying there are too much noise	
			correct=false;
		}
	}
	else
	{
		KMessageBox::sorry (this, i18n("Unable to extract voice information from noise.\n  If this message happens too often it means there is too much noice, or that your microphone is not good enough.") );
	}
		
	_state=correct ? sModified : sIncorrect;
	emit recorded(correct);
}


/*VoiceSignature VoiceRecorder::voiceSig() const
{
	if(voiceId().isEmpty())
		return VoiceSignature();
	QString fileName = locateLocal( "appdata", voiceId() +  ".wav"  );
	_sound.save( fileName );
	return VoiceSignature(_sound);
}*/

bool VoiceRecorder::drawSound()
{
	label->setText(QString::null);
	uint length=_sound.size();

	if(length < 2)
		return false;

	int width=label->width();
	int height=label->height();
	QPixmap pix(width,height);
	pix.fill(QColor(255,255,255));
	QPainter p;
	p.begin(&pix);

	p.setPen(QPen(QColor("green"),1));
	p.drawLine(0,height/2,width,height/2);
	
	p.setPen(QPen(QColor("red"),1));
	
	uint lx=0;
	uint ly=height/2;

	/***     DRAW THE SIGNAL     ******/
	for(uint f=1; f<length; f++)
	{
		uint nx=f*width/length;
		uint ny=(uint)(height/2* (1.0 - _sound.at(f)));
		p.drawLine(lx,ly,nx,ny);
		lx=nx; ly=ny;
	}

	unsigned int start=0 , stop=0;
	bool res=KHotKeys::VoiceSignature::window(_sound,&start,&stop);
	p.setPen(QPen(QColor("blue"),1));
	if(res)
	{
		p.drawLine(start*width/length ,0,start*width/length  ,height);
		p.drawLine(stop*width/length ,0,stop*width/length  ,height);
	}
	else
	{
		p.drawLine(0 ,0,  width  ,height);
		p.drawLine(width ,0,  0  ,height);
	}

	p.end();

	label->setPixmap(pix);
	return res;
}


} // namespace KHotKeys

#include "voicerecorder.moc"
