#include "digikam.h"
#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char *description =
    I18N_NOOP("A KDE Application");

static const char *version = "v0.5";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    { 0, 0, 0 }
};

int main(int argc, char **argv)
{
    KAboutData about("digikam", I18N_NOOP("digikam"), version, description, KAboutData::License_GPL, "(C) 2001 Renchi Raju", 0, 0, "renchi@green.tam.uiuc.edu");
    about.addAuthor( "Renchi Raju", 0, "renchi@green.tam.uiuc.edu" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;

    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name(), false);

    // see if we are starting with session management
    if (app.isRestored())
        RESTORE(Digikam)
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            Digikam *widget = new Digikam;
            widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                Digikam *widget = new Digikam;
                widget->show();
            }
        }
        args->clear();
    }

    return app.exec();
}
