// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Devices_Pwm_Provider_H
#define WINRT_Windows_Devices_Pwm_Provider_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Devices.Pwm.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Devices.Pwm.Provider.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmControllerProvider<D>::PinCount() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PinCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)this;
            check_hresult(_winrt_abi_type->get_PinCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmControllerProvider<D>::ActualFrequency() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ActualFrequency(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)this;
            check_hresult(_winrt_abi_type->get_ActualFrequency(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmControllerProvider<D>::SetDesiredFrequency(double frequency) const
    {
        double result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetDesiredFrequency(frequency, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)this;
            check_hresult(_winrt_abi_type->SetDesiredFrequency(frequency, &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmControllerProvider<D>::MaxFrequency() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxFrequency(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)this;
            check_hresult(_winrt_abi_type->get_MaxFrequency(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmControllerProvider<D>::MinFrequency() const
    {
        double value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinFrequency(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)this;
            check_hresult(_winrt_abi_type->get_MinFrequency(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmControllerProvider<D>::AcquirePin(int32_t pin) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AcquirePin(pin));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)this;
            check_hresult(_winrt_abi_type->AcquirePin(pin));
        }
    }
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmControllerProvider<D>::ReleasePin(int32_t pin) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReleasePin(pin));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)this;
            check_hresult(_winrt_abi_type->ReleasePin(pin));
        }
    }
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmControllerProvider<D>::EnablePin(int32_t pin) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->EnablePin(pin));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)this;
            check_hresult(_winrt_abi_type->EnablePin(pin));
        }
    }
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmControllerProvider<D>::DisablePin(int32_t pin) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DisablePin(pin));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)this;
            check_hresult(_winrt_abi_type->DisablePin(pin));
        }
    }
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmControllerProvider<D>::SetPulseParameters(int32_t pin, double dutyCycle, bool invertPolarity) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetPulseParameters(pin, dutyCycle, invertPolarity));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>**)this;
            check_hresult(_winrt_abi_type->SetPulseParameters(pin, dutyCycle, invertPolarity));
        }
    }
    template <typename D> auto consume_Windows_Devices_Pwm_Provider_IPwmProvider<D>::GetControllers() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Pwm::Provider::IPwmProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Pwm::Provider::IPwmProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetControllers(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Pwm::Provider::IPwmProvider>**)this;
            check_hresult(_winrt_abi_type->GetControllers(&result));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>{ result, take_ownership_from_abi };
    }
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider> : produce_base<D, winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>
    {
        int32_t __stdcall get_PinCount(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().PinCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ActualFrequency(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().ActualFrequency());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetDesiredFrequency(double frequency, double* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<double>(this->shim().SetDesiredFrequency(frequency));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxFrequency(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().MaxFrequency());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MinFrequency(double* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<double>(this->shim().MinFrequency());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AcquirePin(int32_t pin) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AcquirePin(pin);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReleasePin(int32_t pin) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReleasePin(pin);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall EnablePin(int32_t pin) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().EnablePin(pin);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DisablePin(int32_t pin) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DisablePin(pin);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetPulseParameters(int32_t pin, double dutyCycle, bool invertPolarity) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SetPulseParameters(pin, dutyCycle, invertPolarity);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Pwm::Provider::IPwmProvider> : produce_base<D, winrt::Windows::Devices::Pwm::Provider::IPwmProvider>
    {
        int32_t __stdcall GetControllers(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider>>(this->shim().GetControllers());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
}
WINRT_EXPORT namespace winrt::Windows::Devices::Pwm::Provider
{
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Devices::Pwm::Provider::IPwmControllerProvider> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Pwm::Provider::IPwmProvider> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
