"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const node_assert_1 = __importDefault(require("node:assert"));
const expect_1 = __importDefault(require("expect"));
const testUtil = __importStar(require("../testUtil"));
describe('Window API', () => {
    let nvim;
    before(() => __awaiter(void 0, void 0, void 0, function* () {
        [, nvim] = testUtil.startNvim();
    }));
    after(() => {
        testUtil.stopNvim();
    });
    it('gets the current Window', () => __awaiter(void 0, void 0, void 0, function* () {
        const win = yield nvim.window;
        (0, expect_1.default)(win).toBeInstanceOf(nvim.Window);
    }));
    it('get windowid by id', () => __awaiter(void 0, void 0, void 0, function* () {
        const win = yield nvim.window;
        const winid = yield nvim.call('win_getid');
        (0, expect_1.default)(win.id).toBe(winid);
    }));
    describe('Normal API calls', () => {
        let win;
        beforeEach(() => __awaiter(void 0, void 0, void 0, function* () {
            win = yield nvim.window;
        }));
        it('gets the current win number', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield win.number).toBe(1);
        }));
        it('is a valid win', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield win.valid).toBe(true);
        }));
        it('gets current tabpage from window', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield win.tabpage).toBeInstanceOf(nvim.Tabpage);
        }));
        it('gets current buffer from window', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield win.buffer).toBeInstanceOf(nvim.Buffer);
        }));
        it('gets current cursor position', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield win.cursor).toEqual([1, 0]);
        }));
        it('has same cursor position after appending a line to buffer', () => __awaiter(void 0, void 0, void 0, function* () {
            yield (yield win.buffer).append(['test']);
            (0, expect_1.default)(yield win.buffer.lines).toEqual(['', 'test']);
            (0, expect_1.default)(yield win.cursor).toEqual([1, 0]);
        }));
        it('changes cursor position', () => __awaiter(void 0, void 0, void 0, function* () {
            win.cursor = [2, 2];
            (0, expect_1.default)(yield win.cursor).toEqual([2, 2]);
        }));
        it('has correct height after ":split"', () => __awaiter(void 0, void 0, void 0, function* () {
            const currentHeight = yield win.height;
            yield nvim.command('split');
            (0, expect_1.default)(yield win.height).toEqual(Math.floor(currentHeight / 2));
            win.height = 5;
            (0, expect_1.default)(yield win.height).toEqual(5);
            yield nvim.command('q');
            (0, expect_1.default)(yield win.height).toEqual(currentHeight);
        }));
        it('has correct width after ":vsplit"', () => __awaiter(void 0, void 0, void 0, function* () {
            const width = yield win.width;
            yield nvim.command('vsplit');
            // XXX: Not sure if this is correct, but guessing after a vsplit we lose a col
            // to gutter?
            (0, expect_1.default)(yield win.width).toEqual(Math.floor(width / 2) - 1);
            win.width = 10;
            (0, expect_1.default)(yield win.width).toEqual(10);
            yield nvim.command('q');
            (0, expect_1.default)(yield win.width).toEqual(width);
        }));
        it('can get the window position', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield win.position).toEqual([0, 0]);
            (0, expect_1.default)(yield win.row).toBe(0);
            (0, expect_1.default)(yield win.col).toBe(0);
        }));
        it('has the right window positions in display cells', () => __awaiter(void 0, void 0, void 0, function* () {
            let windows;
            nvim.command('vsplit');
            // XXX If we re-use `win` without a new call to `nvim.window`,
            // then `win` will reference the new split
            win = yield nvim.window;
            (0, expect_1.default)(yield win.row).toBe(0);
            (0, expect_1.default)(yield win.col).toBe(0);
            windows = yield nvim.windows;
            // Set to new split
            [, nvim.window] = windows;
            win = yield nvim.window;
            (0, expect_1.default)(yield win.row).toBe(0);
            (0, expect_1.default)((yield win.col) > 0).toBe(true);
            nvim.command('split');
            windows = yield nvim.windows;
            [, , nvim.window] = windows;
            win = yield nvim.window;
            (0, expect_1.default)((yield win.row) > 0).toBe(true);
            (0, expect_1.default)((yield win.col) > 0).toBe(true);
        }));
        it('changes window options', () => __awaiter(void 0, void 0, void 0, function* () {
            const list = yield win.getOption('list');
            win.setOption('list', true);
            (0, expect_1.default)(yield win.getOption('list')).toBe(true);
            win.setOption('list', false);
            (0, expect_1.default)(yield win.getOption('list')).toBe(false);
            (0, node_assert_1.default)(list !== undefined);
            // Restore option
            win.setOption('list', list);
            (0, expect_1.default)(yield win.getOption('list')).toBe(list);
        }));
        it('returns null if variable is not found', () => __awaiter(void 0, void 0, void 0, function* () {
            const test = yield win.getVar('test');
            (0, expect_1.default)(test).toBe(null);
        }));
        it('can set a w: variable', () => __awaiter(void 0, void 0, void 0, function* () {
            win.setVar('test', 'testValue');
            (0, expect_1.default)(yield win.getVar('test')).toBe('testValue');
            (0, expect_1.default)(yield nvim.eval('w:test')).toBe('testValue');
        }));
        it('can delete a w: variable', () => __awaiter(void 0, void 0, void 0, function* () {
            win.deleteVar('test');
            (0, expect_1.default)(yield nvim.eval('exists("w:test")')).toBe(0);
            (0, expect_1.default)(yield win.getVar('test')).toBe(null);
        }));
    });
    describe('Chainable API calls', () => {
        it('gets the current tabpage', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.window.tabpage).toBeInstanceOf(nvim.Tabpage);
        }));
        it('is a valid window', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.window.valid).toBe(true);
        }));
        it('gets the current buffer', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield nvim.window.buffer).toBeInstanceOf(nvim.Buffer);
        }));
        it.skip('gets current lines in buffer', () => __awaiter(void 0, void 0, void 0, function* () {
            (0, expect_1.default)(yield (yield nvim.window.buffer).lines).toEqual(['test']);
        }));
    });
});
