/* Link testing for outcomes
(C) 2024 Niall Douglas <http://www.nedproductions.biz/> (6 commits)


Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#ifndef BOOST_OUTCOME_TEST_LINK_EXPERIMENTAL_C_RESULT_H
#define BOOST_OUTCOME_TEST_LINK_EXPERIMENTAL_C_RESULT_H

#include <boost/outcome/experimental/result.h>

#if MYLIB_SOURCE
#ifdef _MSC_VER
#define MYLIB_DECL __declspec(dllexport)
#else
#define MYLIB_DECL __attribute__((visibility("default")))
#endif
#else
#define MYLIB_DECL
#endif

BOOST_OUTCOME_C_DECLARE_RESULT_SYSTEM(mylib, intptr_t);

typedef BOOST_OUTCOME_C_RESULT_SYSTEM(mylib) mylib_result;

static int is_result_ok(mylib_result r)
{
  return BOOST_OUTCOME_C_RESULT_HAS_VALUE(r);
}

static int is_result_failed(mylib_result r)
{
  return BOOST_OUTCOME_C_RESULT_HAS_ERROR(r);
}

static mylib_result make_success_result(intptr_t v)
{
  return BOOST_OUTCOME_C_MAKE_RESULT_SYSTEM_SUCCESS(mylib, v);
}

static mylib_result make_failure_result(int v)
{
  return BOOST_OUTCOME_C_MAKE_RESULT_SYSTEM_FAILURE_SYSTEM(mylib, v);
}

static int is_result_equivalent(mylib_result r, int errcode)
{
  return outcome_status_code_equal_generic(&r, errcode);
}

static const char *result_failure_message(mylib_result r)
{
  return outcome_status_code_message(&r);
}

extern MYLIB_DECL mylib_result test_function(int x);

#endif
