; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
;RUN: llc < %s -mtriple=amdgcn -verify-machineinstrs | FileCheck --check-prefixes=SI %s
;RUN: llc < %s -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs | FileCheck --check-prefixes=VI %s
;RUN: llc < %s -mtriple=r600 -mcpu=redwood | FileCheck --check-prefixes=EG %s

define amdgpu_kernel void @test_select_v2i32(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1, <2 x i32> %val) {
; SI-LABEL: test_select_v2i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x0
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_gt_i32 s9, s5
; SI-NEXT:    s_cselect_b32 s5, s7, s9
; SI-NEXT:    s_cmp_gt_i32 s8, s4
; SI-NEXT:    s_cselect_b32 s4, s6, s8
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_select_v2i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[8:9], s[2:3], 0x0
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; VI-NEXT:    s_mov_b32 s3, 0xf000
; VI-NEXT:    s_mov_b32 s2, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_gt_i32 s9, s5
; VI-NEXT:    s_cselect_b32 s5, s7, s9
; VI-NEXT:    s_cmp_gt_i32 s8, s4
; VI-NEXT:    s_cselect_b32 s4, s6, s8
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: test_select_v2i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 1, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 5, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T1.XY, T1.X, 0, #1
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV T0.X, KC0[2].Z,
; EG-NEXT:     MOV * T1.X, KC0[2].W,
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     SETGT_INT * T0.W, T0.Y, T1.Y,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, T0.Y, KC0[3].Z,
; EG-NEXT:     SETGT_INT * T0.W, T0.X, T1.X,
; EG-NEXT:     CNDE_INT T0.X, PV.W, T0.X, KC0[3].Y,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %load0 = load <2 x i32>, ptr addrspace(1) %in0
  %load1 = load <2 x i32>, ptr addrspace(1) %in1
  %cmp = icmp sgt <2 x i32> %load0, %load1
  %result = select <2 x i1> %cmp, <2 x i32> %val, <2 x i32> %load0
  store <2 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_select_v2f32(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1) {
; SI-LABEL: test_select_v2f32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dwordx2 s[6:7], s[2:3], 0x0
; SI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s7
; SI-NEXT:    v_cmp_neq_f32_e32 vcc, s7, v1
; SI-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_cmp_neq_f32_e32 vcc, s6, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_select_v2f32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx2 s[8:9], s[8:9], 0x0
; VI-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_mov_b32_e32 v2, s3
; VI-NEXT:    v_cmp_neq_f32_e32 vcc, s3, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_cmp_neq_f32_e32 vcc, s2, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; VI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: test_select_v2f32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 1, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 5, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XY, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_64 T1.XY, T1.X, 0, #1
; EG-NEXT:     VTX_READ_64 T0.XY, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV T0.X, KC0[2].Z,
; EG-NEXT:     MOV * T1.X, KC0[2].W,
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     SETNE_DX10 * T0.W, T0.Y, T1.Y,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, T1.Y, T0.Y,
; EG-NEXT:     SETNE_DX10 * T0.W, T0.X, T1.X,
; EG-NEXT:     CNDE_INT T0.X, PV.W, T1.X, T0.X,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %0 = load <2 x float>, ptr addrspace(1) %in0
  %1 = load <2 x float>, ptr addrspace(1) %in1
  %cmp = fcmp une <2 x float> %0, %1
  %result = select <2 x i1> %cmp, <2 x float> %0, <2 x float> %1
  store <2 x float> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_select_v4i32(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1, <4 x i32> %val) {
; SI-LABEL: test_select_v4i32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x0
; SI-NEXT:    s_load_dwordx4 s[12:15], s[6:7], 0x0
; SI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x11
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_cmp_gt_i32 s10, s14
; SI-NEXT:    s_cselect_b32 s6, s6, s10
; SI-NEXT:    s_cmp_gt_i32 s9, s13
; SI-NEXT:    s_cselect_b32 s5, s5, s9
; SI-NEXT:    s_cmp_gt_i32 s11, s15
; SI-NEXT:    s_cselect_b32 s7, s7, s11
; SI-NEXT:    s_cmp_gt_i32 s8, s12
; SI-NEXT:    s_cselect_b32 s4, s4, s8
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_select_v4i32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[12:13], s[4:5], 0x34
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx4 s[8:11], s[2:3], 0x0
; VI-NEXT:    s_load_dwordx4 s[12:15], s[12:13], 0x0
; VI-NEXT:    s_load_dwordx4 s[16:19], s[4:5], 0x44
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_gt_i32 s10, s14
; VI-NEXT:    s_cselect_b32 s0, s18, s10
; VI-NEXT:    s_cmp_gt_i32 s9, s13
; VI-NEXT:    s_cselect_b32 s1, s17, s9
; VI-NEXT:    s_cmp_gt_i32 s11, s15
; VI-NEXT:    s_cselect_b32 s2, s19, s11
; VI-NEXT:    s_cmp_gt_i32 s8, s12
; VI-NEXT:    s_cselect_b32 s3, s16, s8
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    v_mov_b32_e32 v3, s2
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: test_select_v4i32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 1, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 9, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T1.X, 0, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV T0.X, KC0[2].Z,
; EG-NEXT:     MOV * T1.X, KC0[2].W,
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     SETGT_INT T1.W, T0.W, T1.W,
; EG-NEXT:     SETGT_INT * T2.W, T0.Z, T1.Z,
; EG-NEXT:     CNDE_INT * T0.W, PV.W, T0.W, KC0[4].X,
; EG-NEXT:     CNDE_INT T0.Z, T2.W, T0.Z, KC0[3].W,
; EG-NEXT:     SETGT_INT * T1.W, T0.Y, T1.Y,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, T0.Y, KC0[3].Z,
; EG-NEXT:     SETGT_INT * T1.W, T0.X, T1.X,
; EG-NEXT:     CNDE_INT T0.X, PV.W, T0.X, KC0[3].Y,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %load0 = load <4 x i32>, ptr addrspace(1) %in0
  %load1 = load <4 x i32>, ptr addrspace(1) %in1
  %cmp = icmp sgt <4 x i32> %load0, %load1
  %result = select <4 x i1> %cmp, <4 x i32> %val, <4 x i32> %load0
  store <4 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_select_v4f32(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1) {
; SI-LABEL: test_select_v4f32:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; SI-NEXT:    s_load_dwordx4 s[8:11], s[8:9], 0x0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s8
; SI-NEXT:    v_mov_b32_e32 v1, s9
; SI-NEXT:    v_mov_b32_e32 v2, s10
; SI-NEXT:    v_mov_b32_e32 v3, s11
; SI-NEXT:    v_mov_b32_e32 v4, s7
; SI-NEXT:    v_cmp_neq_f32_e32 vcc, s7, v3
; SI-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s6
; SI-NEXT:    v_cmp_neq_f32_e32 vcc, s6, v2
; SI-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s5
; SI-NEXT:    v_cmp_neq_f32_e32 vcc, s5, v1
; SI-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; SI-NEXT:    v_mov_b32_e32 v4, s4
; SI-NEXT:    v_cmp_neq_f32_e32 vcc, s4, v0
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: test_select_v4f32:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x34
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_mov_b32 s7, 0xf000
; VI-NEXT:    s_mov_b32 s6, -1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dwordx4 s[8:11], s[8:9], 0x0
; VI-NEXT:    s_mov_b32 s4, s0
; VI-NEXT:    s_mov_b32 s5, s1
; VI-NEXT:    s_load_dwordx4 s[0:3], s[2:3], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, s11
; VI-NEXT:    v_mov_b32_e32 v2, s10
; VI-NEXT:    v_mov_b32_e32 v1, s9
; VI-NEXT:    v_mov_b32_e32 v4, s3
; VI-NEXT:    v_cmp_neq_f32_e32 vcc, s3, v3
; VI-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_cmp_neq_f32_e32 vcc, s2, v2
; VI-NEXT:    v_mov_b32_e32 v0, s8
; VI-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; VI-NEXT:    v_mov_b32_e32 v4, s1
; VI-NEXT:    v_cmp_neq_f32_e32 vcc, s1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    v_cmp_neq_f32_e32 vcc, s0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; VI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; VI-NEXT:    s_endpgm
;
; EG-LABEL: test_select_v4f32:
; EG:       ; %bb.0: ; %entry
; EG-NEXT:    ALU 1, @10, KC0[CB0:0-32], KC1[]
; EG-NEXT:    TEX 1 @6
; EG-NEXT:    ALU 9, @12, KC0[CB0:0-32], KC1[]
; EG-NEXT:    MEM_RAT_CACHELESS STORE_RAW T0.XYZW, T1.X, 1
; EG-NEXT:    CF_END
; EG-NEXT:    PAD
; EG-NEXT:    Fetch clause starting at 6:
; EG-NEXT:     VTX_READ_128 T1.XYZW, T1.X, 0, #1
; EG-NEXT:     VTX_READ_128 T0.XYZW, T0.X, 0, #1
; EG-NEXT:    ALU clause starting at 10:
; EG-NEXT:     MOV T0.X, KC0[2].Z,
; EG-NEXT:     MOV * T1.X, KC0[2].W,
; EG-NEXT:    ALU clause starting at 12:
; EG-NEXT:     SETNE_DX10 T2.W, T0.W, T1.W,
; EG-NEXT:     SETNE_DX10 * T3.W, T0.Z, T1.Z,
; EG-NEXT:     CNDE_INT * T0.W, PV.W, T1.W, T0.W,
; EG-NEXT:     CNDE_INT T0.Z, T3.W, T1.Z, T0.Z,
; EG-NEXT:     SETNE_DX10 * T1.W, T0.Y, T1.Y,
; EG-NEXT:     CNDE_INT T0.Y, PV.W, T1.Y, T0.Y,
; EG-NEXT:     SETNE_DX10 * T1.W, T0.X, T1.X,
; EG-NEXT:     CNDE_INT T0.X, PV.W, T1.X, T0.X,
; EG-NEXT:     LSHR * T1.X, KC0[2].Y, literal.x,
; EG-NEXT:    2(2.802597e-45), 0(0.000000e+00)
entry:
  %0 = load <4 x float>, ptr addrspace(1) %in0
  %1 = load <4 x float>, ptr addrspace(1) %in1
  %cmp = fcmp une <4 x float> %0, %1
  %result = select <4 x i1> %cmp, <4 x float> %0, <4 x float> %1
  store <4 x float> %result, ptr addrspace(1) %out
  ret void
}
