#pragma once

#include <string>
#include "logging/Logger.hpp"
#include "m2n/SharedPointer.hpp"

namespace precice {
namespace m2n {

/// An M2N between participants with a configured direction
class BoundM2N {
public:
  /// Prepare to establish the connection
  void prepareEstablishment();

  /// Connect the Primary Ranks of the M2N
  void connectPrimaryRanks();

  /// Connect the Secondary ranks of the M2N
  void connectSecondaryRanks();

  /// pre-connect the Secondary ranks of the M2N
  void preConnectSecondaryRanks();

  /// Cleanup after having established the connection
  void cleanupEstablishment();

  PtrM2N      m2n;
  std::string localName;
  std::string remoteName;
  bool        isRequesting = false;

private:
  mutable logging::Logger _log{"impl::SolverInterfaceImpl"};

  /** Instructs the Primary rank wait for SecondaryRanks.
   *
   * Performs a collective operation which forces every secondary rank to sync with the Primary.
   * 
   * @note this does nothing if the participant is running serially.
   */
  void waitForSecondaryRanks();
};

} // namespace m2n
} // namespace precice
