# Статус коди Відповідей

Так само як Ви можете вказати модель відповіді, Ви також можете оголосити HTTP код статусу для відповіді за допомогою параметра `status_code` в будь-якій з *операцій шляху*:

* `@app.get()`
* `@app.post()`
* `@app.put()`
* `@app.delete()`
* тощо.

{* ../../docs_src/response_status_code/tutorial001.py hl[6] *}

/// note | Нотатка

Зверніть увагу, що `status_code` є параметром методу "декоратора" (`get`, `post` і т.д.), а не Вашої *функції операції шляху*, як усі інші параметри та тіло запиту.

///

Параметр `status_code` приймає число, яке відповідає HTTP коду статусу.

/// info | Інформація
`status_code` також може отримувати значення з `IntEnum`, наприклад, з Python <a href="https://docs.python.org/3/library/http.html#http.HTTPStatus" class="external-link" target="_blank">`http.HTTPStatus`</a>.

///

Він буде:

* Повертати вказаний код статусу у відповіді.
* Документувати його як такий у схемі OpenAPI (і, таким чином, в інтерфейсі користувача):

<img src="/img/tutorial/response-status-code/image01.png">

/// note | Нотатка

Деякі коди відповіді (див. наступний розділ) вказують, що відповідь не має тіла.

FastAPI знає про це і створить OpenAPI документацію, яка вказує, що тіла відповіді немає.

///

## Про HTTP статус коди

/// note | Нотатка

Якщо Ви вже знаєте, що таке HTTP коди статусу, переходьте до наступного розділу.

///

В HTTP Ви надсилаєте числовий код статусу з 3 цифр як частину відповіді.

Ці коди статусу мають пов’язану назву для їх розпізнавання, але найважливішою частиною є саме число.

Коротко:

* **`100 - 199`** "Інформаційні" відповіді. Ви рідко використовуєте їх напряму. Відповіді з такими кодами не можуть мати тіла.
* **`200 - 299`** "Успішні" відповіді. Це ті, які Ви використовуватимете найчастіше.
    * `200` - код за замовчуванням, який означає, що все пройшло "OK".
    * Інший приклад – `201`, "Created" (створено). Його зазвичай використовують після створення нового запису в базі даних.
    * Особливий випадок – `204`, "No Content" (немає вмісту). Ця відповідь використовується, коли немає даних для повернення клієнту, тому відповідь не повинна мати тіла.
* **`300 - 399`** "Перенаправлення". Відповіді з цими кодами можуть мати або не мати тіла, за винятком `304`, "Not Modified" (не змінено), яка не повинна мати тіла.
* **`400 - 499`** "Помилка клієнта". Це другий тип, який Ви, ймовірно, будете використовувати найчастіше.
    * Приклад `404`, "Not Found" (не знайдено).
    * Для загальних помилок клієнта можна використовувати `400`.
* `500 - 599` "Помилки сервера". Ви майже ніколи не використовуєте їх напряму. Якщо в коді Вашого застосунку або на сервері щось пішло не так, автоматично буде повернено один із цих кодів статусу.

/// tip | Порада

Щоб дізнатися більше про кожен код статусу і призначення кожного з них, перегляньте документацію <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Status" class="external-link" target="_blank"><abbr title="Mozilla Developer Network">MDN</abbr> про HTTP коди статусу</a>.

///

## Легкий спосіб запам'ятати назви

Розглянемо ще раз попередній приклад:

{* ../../docs_src/response_status_code/tutorial001.py hl[6] *}

`201` - це код статусу для "Created" (створено).

Але Вам не потрібно запам'ятовувати, що означає кожен із цих кодів.

Ви можете використовувати зручні змінні з `fastapi.status`

{* ../../docs_src/response_status_code/tutorial002.py hl[1,6] *}

Ці змінні просто для зручності. Вони містять ті ж самі числа, але Ви можете скористатися автозаповненням в редакторі:

<img src="/img/tutorial/response-status-code/image02.png">

/// note | Технічні деталі

Ви також можете використати `from starlette import status`.

**FastAPI** надає ті ж самі змінні `starlette.status` як `fastapi.status`, просто для зручності розробника. Однак вони походять безпосередньо зі Starlette.

///

## Зміна значення за замовчуванням

Далі, у Посібнику для досвідчених користувачів{.internal-link target=_blank}, Ви дізнаєтесь, як повернути інший код статусу, ніж той, який Ви оголосили тут.
