# Метадані та URL-адреси документації { #metadata-and-docs-urls }

Ви можете налаштувати кілька конфігурацій метаданих у Вашому додатку **FastAPI**.

## Метадані для API { #metadata-for-api }

Ви можете встановити такі поля, які використовуються в специфікації OpenAPI та в автоматично згенерованих інтерфейсах документації API:

| Параметр | Тип | Опис |
|------------|------|-------------|
| `title` | `str` | Назва API. |
| `summary` | `str` | Короткий підсумок API. <small>Доступно з OpenAPI 3.1.0, FastAPI 0.99.0.</small> |
| `description` | `str` | Короткий опис API. Може використовувати Markdown. |
| `version` | `string` | Версія API. Це версія Вашого додатка, а не OpenAPI. Наприклад, `2.5.0`. |
| `terms_of_service` | `str` | URL до умов використання API. Якщо вказано, має бути у форматі URL. |
| `contact` | `dict` | Інформація для контакту з опублікованим API. Може містити кілька полів. <details><summary><code>contact</code> поля</summary><table><thead><tr><th>Параметр</th><th>Тип</th><th>Опис</th></tr></thead><tbody><tr><td><code>name</code></td><td><code>str</code></td><td>Ідентифікаційне ім'я контактної особи або організації.</td></tr><tr><td><code>url</code></td><td><code>str</code></td><td>URL, що вказує на контактну інформацію. <strong>МАЄ</strong> бути у форматі URL.</td></tr><tr><td><code>email</code></td><td><code>str</code></td><td>Адреса електронної пошти контактної особи або організації. <strong>МАЄ</strong> бути у форматі адреси електронної пошти.</td></tr></tbody></table></details> |
| `license_info` | `dict` | Інформація про ліцензію для опублікованого API. Може містити кілька полів. <details><summary><code>license_info</code> поля</summary><table><thead><tr><th>Параметр</th><th>Тип</th><th>Опис</th></tr></thead><tbody><tr><td><code>name</code></td><td><code>str</code></td><td><strong>ОБОВ'ЯЗКОВО</strong> (якщо встановлено <code>license_info</code>). Назва ліцензії для API.</td></tr><tr><td><code>identifier</code></td><td><code>str</code></td><td>Ліцензійний вираз за <a href="https://spdx.org/licenses/" class="external-link" target="_blank">SPDX</a> для API. Поле <code>identifier</code> взаємовиключне з полем <code>url</code>. <small>Доступно з OpenAPI 3.1.0, FastAPI 0.99.0.</small></td></tr><tr><td><code>url</code></td><td><code>str</code></td><td>URL до ліцензії, яка використовується для API. <strong>МАЄ</strong> бути у форматі URL.</td></tr></tbody></table></details> |

Ви можете налаштувати їх наступним чином:

{* ../../docs_src/metadata/tutorial001_py39.py hl[3:16, 19:32] *}

/// tip | Порада

У полі `description` можна використовувати Markdown, і він буде відображатися у результаті.

///

З цією конфігурацією автоматична документація API виглядатиме так:

<img src="/img/tutorial/metadata/image01.png">

## Ідентифікатор ліцензії { #license-identifier }

З початку використання OpenAPI 3.1.0 та FastAPI 0.99.0 Ви також можете налаштувати `license_info` за допомогою `identifier` замість `url`.

Наприклад:

{* ../../docs_src/metadata/tutorial001_1_py39.py hl[31] *}

## Метадані для тегів { #metadata-for-tags }

Ви також можете додати додаткові метадані для різних тегів, які використовуються для групування операцій шляхів, за допомогою параметра `openapi_tags`.

Він приймає список, який містить один словник для кожного тега.

Кожен словник може містити:

* `name` (**обов'язково**): `str` з тією ж назвою тегу, яку Ви використовуєте у параметрі `tags` у Ваших *операціях шляху* та `APIRouter`s.
* `description`: `str` з коротким описом тегу. Може містити Markdown і буде показано в інтерфейсі документації.
* `externalDocs`: `dict`, який описує зовнішню документацію з такими полями:
    * `description`: `str` з коротким описом зовнішньої документації.
    * `url` (**обов'язково**): `str` з URL-адресою зовнішньої документації.

### Створення метаданих для тегів { #create-metadata-for-tags }

Спробуймо це на прикладі з тегами для `users` та `items`.

Створіть метадані для своїх тегів і передайте їх у параметр `openapi_tags`:

{* ../../docs_src/metadata/tutorial004_py39.py hl[3:16,18] *}

Зверніть увагу, що в описах можна використовувати Markdown, наприклад, "login" буде показано жирним шрифтом (**login**), а "fancy" буде показано курсивом (_fancy_).

/// tip | Порада

Вам не потрібно додавати метадані для всіх тегів, які Ви використовуєте.

///

### Використовуйте свої теги { #use-your-tags }

Використовуйте параметр `tags` зі своїми *операціями шляху* (і `APIRouter`s), щоб призначити їх до різних тегів:

{* ../../docs_src/metadata/tutorial004_py39.py hl[21,26] *}

/// info | Інформація

Детальніше про теги читайте в розділі [Конфігурація операції шляху](path-operation-configuration.md#tags){.internal-link target=_blank}.

///

### Перевірте документацію { #check-the-docs }

Тепер, якщо Ви перевірите документацію, вона покаже всі додаткові метадані:

<img src="/img/tutorial/metadata/image02.png">

### Порядок тегів { #order-of-tags }

Порядок кожного словника метаданих тегу також визначає порядок відображення в інтерфейсі документації.

Наприклад, хоча `users` мав би йти після `items` в алфавітному порядку, він відображається перед ними, оскільки ми додали їхні метадані як перший словник у списку.

## URL для OpenAPI { #openapi-url }

За замовчуванням схема OpenAPI надається за адресою `/openapi.json`.

Але Ви можете налаштувати це за допомогою параметра `openapi_url`.

Наприклад, щоб налаштувати його на `/api/v1/openapi.json`:

{* ../../docs_src/metadata/tutorial002_py39.py hl[3] *}

Якщо Ви хочете повністю вимкнути схему OpenAPI, Ви можете встановити `openapi_url=None`, це також вимкне інтерфейси документації, які її використовують.

## URL-адреси документації { #docs-urls }

Ви можете налаштувати два інтерфейси користувача для документації, які включені:

* **Swagger UI**: доступний за адресою `/docs`.
    * Ви можете змінити його URL за допомогою параметра `docs_url`.
    * Ви можете вимкнути його, встановивши `docs_url=None`.
* **ReDoc**: доступний за адресою `/redoc`.
    * Ви можете змінити його URL за допомогою параметра `redoc_url`.
    * Ви можете вимкнути його, встановивши `redoc_url=None`.

Наприклад, щоб налаштувати Swagger UI на `/documentation` і вимкнути ReDoc:

{* ../../docs_src/metadata/tutorial003_py39.py hl[3] *}
