# Свои статические ресурсы UI документации (самостоятельный хостинг) { #custom-docs-ui-static-assets-self-hosting }

Документация API использует **Swagger UI** и **ReDoc**, и для каждого из них нужны некоторые файлы JavaScript и CSS.

По умолчанию эти файлы отдаются с <abbr title="Content Delivery Network – Сеть доставки контента: Сервис, обычно состоящий из нескольких серверов, который предоставляет статические файлы, такие как JavaScript и CSS. Обычно используется, чтобы отдавать эти файлы с сервера, расположенного ближе к клиенту, что улучшает производительность.">CDN</abbr>.

Но это можно настроить: вы можете указать конкретный CDN или отдавать файлы самостоятельно.

## Пользовательский CDN для JavaScript и CSS { #custom-cdn-for-javascript-and-css }

Допустим, вы хотите использовать другой <abbr title="Content Delivery Network – Сеть доставки контента">CDN</abbr>, например `https://unpkg.com/`.

Это может быть полезно, если, например, вы живёте в стране, где некоторые URL ограничены.

### Отключить автоматическую документацию { #disable-the-automatic-docs }

Первый шаг — отключить автоматическую документацию, так как по умолчанию она использует стандартный CDN.

Чтобы отключить её, установите их URL в значение `None` при создании вашего приложения `FastAPI`:

{* ../../docs_src/custom_docs_ui/tutorial001_py310.py hl[8] *}

### Подключить пользовательскую документацию { #include-the-custom-docs }

Теперь вы можете создать *операции пути* для пользовательской документации.

Вы можете переиспользовать внутренние функции FastAPI для создания HTML-страниц документации и передать им необходимые аргументы:

* `openapi_url`: URL, по которому HTML-страница документации сможет получить схему OpenAPI для вашего API. Здесь можно использовать атрибут `app.openapi_url`.
* `title`: заголовок вашего API.
* `oauth2_redirect_url`: здесь можно использовать `app.swagger_ui_oauth2_redirect_url`, чтобы оставить значение по умолчанию.
* `swagger_js_url`: URL, по которому HTML для документации Swagger UI сможет получить файл **JavaScript**. Это URL вашего пользовательского CDN.
* `swagger_css_url`: URL, по которому HTML для документации Swagger UI сможет получить файл **CSS**. Это URL вашего пользовательского CDN.

Аналогично и для ReDoc...

{* ../../docs_src/custom_docs_ui/tutorial001_py310.py hl[2:6,11:19,22:24,27:33] *}

/// tip | Совет

*Операция пути* для `swagger_ui_redirect` — это вспомогательный эндпоинт на случай, когда вы используете OAuth2.

Если вы интегрируете свой API с провайдером OAuth2, вы сможете аутентифицироваться и вернуться к документации API с полученными учётными данными, а затем взаимодействовать с ним, используя реальную аутентификацию OAuth2.

Swagger UI сделает это за вас «за кулисами», но для этого ему нужен этот вспомогательный «redirect» эндпоинт.

///

### Создайте *операцию пути*, чтобы проверить { #create-a-path-operation-to-test-it }

Чтобы убедиться, что всё работает, создайте *операцию пути*:

{* ../../docs_src/custom_docs_ui/tutorial001_py310.py hl[36:38] *}

### Тестирование { #test-it }

Теперь вы должны иметь возможность открыть свою документацию по адресу <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a> и перезагрузить страницу — «ассеты» (статические файлы) будут загружаться с нового CDN.

## Самостоятельный хостинг JavaScript и CSS для документации { #self-hosting-javascript-and-css-for-docs }

Самостоятельный хостинг JavaScript и CSS может быть полезен, если, например, вам нужно, чтобы приложение продолжало работать в офлайне, без доступа к открытому Интернету, или в локальной сети.

Здесь вы увидите, как отдавать эти файлы самостоятельно, в том же приложении FastAPI, и настроить документацию на их использование.

### Структура файлов проекта { #project-file-structure }

Допустим, структура файлов вашего проекта выглядит так:

```
.
├── app
│   ├── __init__.py
│   ├── main.py
```

Теперь создайте директорию для хранения этих статических файлов.

Новая структура файлов может выглядеть так:

```
.
├── app
│   ├── __init__.py
│   ├── main.py
└── static/
```

### Скачайте файлы { #download-the-files }

Скачайте статические файлы, необходимые для документации, и поместите их в директорию `static/`.

Скорее всего, вы можете кликнуть правой кнопкой на каждой ссылке и выбрать что-то вроде «Сохранить ссылку как...».

**Swagger UI** использует файлы:

* <a href="https://cdn.jsdelivr.net/npm/swagger-ui-dist@5/swagger-ui-bundle.js" class="external-link" target="_blank">`swagger-ui-bundle.js`</a>
* <a href="https://cdn.jsdelivr.net/npm/swagger-ui-dist@5/swagger-ui.css" class="external-link" target="_blank">`swagger-ui.css`</a>

А **ReDoc** использует файл:

* <a href="https://cdn.jsdelivr.net/npm/redoc@2/bundles/redoc.standalone.js" class="external-link" target="_blank">`redoc.standalone.js`</a>

После этого структура файлов может выглядеть так:

```
.
├── app
│   ├── __init__.py
│   ├── main.py
└── static
    ├── redoc.standalone.js
    ├── swagger-ui-bundle.js
    └── swagger-ui.css
```

### Предоставьте доступ к статическим файлам { #serve-the-static-files }

* Импортируйте `StaticFiles`.
* Смонтируйте экземпляр `StaticFiles()` в определённый путь.

{* ../../docs_src/custom_docs_ui/tutorial002_py310.py hl[7,11] *}

### Протестируйте статические файлы { #test-the-static-files }

Запустите своё приложение и откройте <a href="http://127.0.0.1:8000/static/redoc.standalone.js" class="external-link" target="_blank">http://127.0.0.1:8000/static/redoc.standalone.js</a>.

Вы должны увидеть очень длинный JavaScript-файл для **ReDoc**.

Он может начинаться примерно так:

```JavaScript
/*! For license information please see redoc.standalone.js.LICENSE.txt */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t(require("null")):
...
```

Это подтверждает, что ваше приложение умеет отдавать статические файлы и что вы поместили файлы документации в нужное место.

Теперь можно настроить приложение так, чтобы документация использовала эти статические файлы.

### Отключить автоматическую документацию для статических файлов { #disable-the-automatic-docs-for-static-files }

Так же, как и при использовании пользовательского CDN, первым шагом будет отключение автоматической документации, так как по умолчанию она использует CDN.

Чтобы отключить её, установите их URL в значение `None` при создании вашего приложения `FastAPI`:

{* ../../docs_src/custom_docs_ui/tutorial002_py310.py hl[9] *}

### Подключить пользовательскую документацию со статическими файлами { #include-the-custom-docs-for-static-files }

Аналогично пользовательскому CDN, теперь вы можете создать *операции пути* для собственной документации.

Снова можно переиспользовать внутренние функции FastAPI для создания HTML-страниц документации и передать им необходимые аргументы:

* `openapi_url`: URL, по которому HTML-страница документации сможет получить схему OpenAPI для вашего API. Здесь можно использовать атрибут `app.openapi_url`.
* `title`: заголовок вашего API.
* `oauth2_redirect_url`: здесь можно использовать `app.swagger_ui_oauth2_redirect_url`, чтобы оставить значение по умолчанию.
* `swagger_js_url`: URL, по которому HTML для документации Swagger UI сможет получить файл **JavaScript**. **Это тот файл, который теперь отдаёт ваше собственное приложение**.
* `swagger_css_url`: URL, по которому HTML для документации Swagger UI сможет получить файл **CSS**. **Это тот файл, который теперь отдаёт ваше собственное приложение**.

Аналогично и для ReDoc...

{* ../../docs_src/custom_docs_ui/tutorial002_py310.py hl[2:6,14:22,25:27,30:36] *}

/// tip | Совет

*Операция пути* для `swagger_ui_redirect` — это вспомогательный эндпоинт на случай, когда вы используете OAuth2.

Если вы интегрируете свой API с провайдером OAuth2, вы сможете аутентифицироваться и вернуться к документации API с полученными учётными данными, а затем взаимодействовать с ним, используя реальную аутентификацию OAuth2.

Swagger UI сделает это за вас «за кулисами», но для этого ему нужен этот вспомогательный «redirect» эндпоинт.

///

### Создайте *операцию пути* для теста статических файлов { #create-a-path-operation-to-test-static-files }

Чтобы убедиться, что всё работает, создайте *операцию пути*:

{* ../../docs_src/custom_docs_ui/tutorial002_py310.py hl[39:41] *}

### Тестирование UI со статическими файлами { #test-static-files-ui }

Теперь вы можете отключить Wi‑Fi, открыть свою документацию по адресу <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a> и перезагрузить страницу.

Даже без Интернета вы сможете видеть документацию к своему API и взаимодействовать с ним.
