# Отримати поточного користувача { #get-current-user }

У попередньому розділі система безпеки (яка базується на системі впровадження залежностей) передавала функції операції шляху `token` як `str`:

{* ../../docs_src/security/tutorial001_an_py310.py hl[12] *}

Але це ще не дуже корисно.

Зробімо так, щоб вона повертала поточного користувача.

## Створити модель користувача { #create-a-user-model }

Спочатку створімо модель користувача в Pydantic.

Так само, як ми використовуємо Pydantic для оголошення тіл, ми можемо використовувати його будь-де:

{* ../../docs_src/security/tutorial002_an_py310.py hl[5,12:6] *}

## Створити залежність `get_current_user` { #create-a-get-current-user-dependency }

Створімо залежність `get_current_user`.

Пам'ятаєте, що залежності можуть мати підзалежності?

`get_current_user` матиме залежність із тим самим `oauth2_scheme`, який ми створили раніше.

Так само, як ми робили раніше безпосередньо в операції шляху, наша нова залежність `get_current_user` отримає `token` як `str` від підзалежності `oauth2_scheme`:

{* ../../docs_src/security/tutorial002_an_py310.py hl[25] *}

## Отримати користувача { #get-the-user }

`get_current_user` використає (фальшиву) утилітну функцію, яку ми створили, що приймає `token` як `str` і повертає нашу Pydantic-модель `User`:

{* ../../docs_src/security/tutorial002_an_py310.py hl[19:22,26:27] *}

## Впровадити поточного користувача { #inject-the-current-user }

Тепер ми можемо використати той самий `Depends` з нашим `get_current_user` в операції шляху:

{* ../../docs_src/security/tutorial002_an_py310.py hl[31] *}

Зверніть увагу, що ми оголошуємо тип `current_user` як Pydantic-модель `User`.

Це допоможе всередині функції з автодоповненням і перевірками типів.

/// tip | Порада

Можливо, ви пам'ятаєте, що тіла запиту також оголошуються моделями Pydantic.

Тут **FastAPI** не заплутається, тому що ви використовуєте `Depends`.

///

/// check | Перевірте

Те, як спроєктована ця система залежностей, дозволяє мати різні залежності (різні «залежні»), які всі повертають модель `User`.

Ми не обмежені наявністю лише однієї залежності, що може повертати такі дані.

///

## Інші моделі { #other-models }

Тепер ви можете отримувати поточного користувача безпосередньо у функціях операцій шляху та працювати з механізмами безпеки на рівні **впровадження залежностей**, використовуючи `Depends`.

І ви можете використовувати будь-яку модель або дані для вимог безпеки (у цьому випадку Pydantic-модель `User`).

Але ви не обмежені використанням якоїсь конкретної модели даних, класу чи типу.

Хочете мати id та email і не мати жодного username у вашій моделі? Без проблем. Ви можете використовувати ті самі інструменти.

Хочете мати просто `str`? Або лише `dict`? Або безпосередньо екземпляр класу моделі бази даних? Усе працює так само.

У вашій програмі насправді входять не користувачі, а роботи, боти чи інші системи, що мають лише токен доступу? Знову ж, усе працює так само.

Просто використовуйте будь-який тип моделі, будь-який клас, будь-яку базу даних, які потрібні вашій програмі. **FastAPI** подбає про це завдяки системі впровадження залежностей.

## Розмір коду { #code-size }

Цей приклад може здаватися багатослівним. Майте на увазі, що ми змішуємо безпеку, моделі даних, утилітні функції та операції шляху в одному файлі.

Але ось ключовий момент.

Речі, пов'язані з безпекою та впровадженням залежностей, пишуться один раз.

І ви можете зробити це настільки складним, наскільки потрібно. І все одно мати це написаним лише один раз, в одному місці. З усією гнучкістю.

Зате ви можете мати тисячі кінцевих точок (операцій шляху), що використовують одну й ту саму систему безпеки.

І всі вони (або будь-яка їхня частина, яку ви захочете) можуть скористатися повторним використанням цих залежностей або будь-яких інших, які ви створите.

І всі ці тисячі операцій шляху можуть бути всього у 3 рядки:

{* ../../docs_src/security/tutorial002_an_py310.py hl[30:32] *}

## Підсумок { #recap }

Тепер ви можете отримувати поточного користувача безпосередньо у вашій функції операції шляху.

Ми вже на півдорозі.

Потрібно лише додати операцію шляху, щоб користувач/клієнт міг фактично надіслати `username` і `password`.

Далі саме це.
