#include "pyErr.hpp"
#include "pyLIEF.hpp"

namespace LIEF::py {
void init_errors(nb::module_& m) {
  nb::class_<ok_t>(m, "ok_t",
      R"delim(
      Opaque value returned when a **void** function
      is executed successfully.
      )delim")
    .def("__bool__", [] (const ok_t&) { return true; });

  nb::class_<ok_error_t>(m, "ok_error_t",
      R"delim(
      Return either: :class:`~.ok_t` (success) or :class:`~.lief_errors` (error)
      )delim")
    .def_prop_ro("is_error", [] (const ok_error_t& val) { return !val.has_value(); })
    .def_prop_ro("is_value", [] (const ok_error_t& val) { return val.has_value(); })
    .def_prop_ro("error", [] (const ok_error_t& val) { return val.error(); })
    .def_prop_ro("value", [] (const ok_error_t& val) { return val.value(); })
    .def("__bool__", [] (const ok_error_t& val) { return val.has_value(); });


  nb::enum_<lief_errors>(m, "lief_errors", R"delim(
  Enum class which represents an error generated by LIEF's functions
  )delim")
    .value("read_error",        lief_errors::read_error)
    .value("not_found",         lief_errors::not_found)
    .value("not_implemented",   lief_errors::not_implemented)
    .value("not_supported",     lief_errors::not_supported)
    .value("corrupted",         lief_errors::corrupted)
    .value("conversion_error",  lief_errors::conversion_error)
    .value("read_out_of_bound", lief_errors::read_out_of_bound)
    .value("asn1_bad_tag",      lief_errors::asn1_bad_tag)
    .value("file_error",        lief_errors::file_error)
    .value("file_format_error", lief_errors::file_format_error)
    .value("parsing_error",     lief_errors::parsing_error)
    .value("build_error",       lief_errors::build_error)
    .value("data_too_large",    lief_errors::data_too_large)
    .value("require_extended_version", lief_errors::require_extended_version)
  ;
}
}
