pragma Ada_2012;

pragma Style_Checks (Off);
pragma Warnings (Off, "-gnatwu");

with Interfaces.C; use Interfaces.C;
with corecrt_h;

package sys_timeb_h is

  --*
  -- * This file has no copyright assigned and is placed in the Public Domain.
  -- * This file is part of the mingw-w64 runtime package.
  -- * No warranty is given; refer to the file DISCLAIMER.PD within this package.
  --  

   type uu_timeb32 is record
      time : aliased corecrt_h.uu_time32_t;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:54
      millitm : aliased unsigned_short;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:55
      timezone : aliased short;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:56
      dstflag : aliased short;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:57
   end record
   with Convention => C_Pass_By_Copy;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:53

   type timeb is record
      time : aliased corecrt_h.time_t;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:62
      millitm : aliased unsigned_short;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:63
      timezone : aliased short;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:64
      dstflag : aliased short;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:65
   end record
   with Convention => C_Pass_By_Copy;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:61

   type uu_timeb64 is record
      time : aliased corecrt_h.uu_time64_t;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:70
      millitm : aliased unsigned_short;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:71
      timezone : aliased short;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:72
      dstflag : aliased short;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:73
   end record
   with Convention => C_Pass_By_Copy;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:69

   --  skipped func _ftime64

   --  skipped func _ftime32

   type u_timespec32 is record
      tv_sec : aliased corecrt_h.uu_time32_t;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:90
      tv_nsec : aliased long;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:91
   end record
   with Convention => C_Pass_By_Copy;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:89

   type u_timespec64 is record
      tv_sec : aliased corecrt_h.uu_time64_t;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:95
      tv_nsec : aliased long;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:96
   end record
   with Convention => C_Pass_By_Copy;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:94

  -- Seconds  
   type timespec is record
      tv_sec : aliased corecrt_h.time_t;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:102
      tv_nsec : aliased long;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:103
   end record
   with Convention => C_Pass_By_Copy;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:101

  -- Nanoseconds  
  -- Timer period  
   type itimerspec is record
      it_interval : aliased timespec;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:107
      it_value : aliased timespec;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:108
   end record
   with Convention => C_Pass_By_Copy;  -- D:/a/msys64/ucrt64/include/sys/timeb.h:106

  -- Timer expiration  
   procedure ftime (arg1 : access timeb)  -- D:/a/msys64/ucrt64/include/sys/timeb.h:114
   with Import => True, 
        Convention => C, 
        External_Name => "_ftime64";

end sys_timeb_h;

pragma Style_Checks (On);
pragma Warnings (On, "-gnatwu");
