## -*- mode: Perl -*-
##
## Copyright (c) 2012, 2013, 2015, 2016 The University of Utah
## All rights reserved.
##
## This file is distributed under the University of Illinois Open Source
## License.  See the file COPYING for details.

###############################################################################

package creduce_config;

use strict;
use warnings;

use base 'Exporter';

use constant {
    bindir		=> q{/ucrt64/bin},
    libexecdir		=> q{/ucrt64/libexec},

    PACKAGE_BUGREPORT	=> q{creduce-bugs@flux.utah.edu},
    PACKAGE_NAME	=> q{creduce},
    PACKAGE_STRING	=> q{creduce 2.11.0},
    PACKAGE_URL		=> q{http://embed.cs.utah.edu/creduce/},
    PACKAGE_VERSION	=> q{2.11.0},

    VERSION		=> q{2.11.0},

    GIT_VERSION		=> q{},

    # External programs invoked.
    #
    CLANG_FORMAT	=> q{/ucrt64/bin/clang-format},
};

our @EXPORT = qw();
our @EXPORT_OK = qw(
    bindir
    libexecdir
    PACKAGE_BUGREPORT
    PACKAGE_NAME
    PACKAGE_STRING
    PACKAGE_URL
    PACKAGE_VERSION
    VERSION
    GIT_VERSION
    CLANG_FORMAT
    );
our %EXPORT_TAGS = qw();

###############################################################################

1;

## End of file.
