/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import * as os from 'os';
import * as path from 'path';
export function resolvePath(p) {
    if (!p) {
        return '';
    }
    let expandedPath = p;
    if (p.toLowerCase().startsWith('%userprofile%')) {
        expandedPath = os.homedir() + p.substring('%userprofile%'.length);
    }
    else if (p === '~' || p.startsWith('~/')) {
        expandedPath = os.homedir() + p.substring(1);
    }
    return path.normalize(expandedPath);
}
//# sourceMappingURL=resolvePath.js.map