/*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-develop.

Abstract: This is an autogenerated plain C Header file in order to allow an easy
 use of the 3MF Library

Interface version: 2.3.0

*/

#include "lib3mf_types.h"
#include "lib3mf_dynamic.h"
#ifdef _WIN32
#include <windows.h>
#else // _WIN32
#include <dlfcn.h>
#include <stdlib.h>
#endif // _WIN32

Lib3MFResult InitLib3MFWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable)
{
	if (pWrapperTable == NULL)
		return LIB3MF_ERROR_INVALIDPARAM;
	
	pWrapperTable->m_LibraryHandle = NULL;
	pWrapperTable->m_Base_ClassTypeId = NULL;
	pWrapperTable->m_Writer_WriteToFile = NULL;
	pWrapperTable->m_Writer_GetStreamSize = NULL;
	pWrapperTable->m_Writer_WriteToBuffer = NULL;
	pWrapperTable->m_Writer_WriteToCallback = NULL;
	pWrapperTable->m_Writer_SetProgressCallback = NULL;
	pWrapperTable->m_Writer_GetDecimalPrecision = NULL;
	pWrapperTable->m_Writer_SetDecimalPrecision = NULL;
	pWrapperTable->m_Writer_SetStrictModeActive = NULL;
	pWrapperTable->m_Writer_GetStrictModeActive = NULL;
	pWrapperTable->m_Writer_GetWarning = NULL;
	pWrapperTable->m_Writer_GetWarningCount = NULL;
	pWrapperTable->m_Writer_AddKeyWrappingCallback = NULL;
	pWrapperTable->m_Writer_SetContentEncryptionCallback = NULL;
	pWrapperTable->m_Reader_ReadFromFile = NULL;
	pWrapperTable->m_Reader_ReadFromBuffer = NULL;
	pWrapperTable->m_Reader_ReadFromCallback = NULL;
	pWrapperTable->m_Reader_SetProgressCallback = NULL;
	pWrapperTable->m_Reader_AddRelationToRead = NULL;
	pWrapperTable->m_Reader_RemoveRelationToRead = NULL;
	pWrapperTable->m_Reader_SetStrictModeActive = NULL;
	pWrapperTable->m_Reader_GetStrictModeActive = NULL;
	pWrapperTable->m_Reader_GetWarning = NULL;
	pWrapperTable->m_Reader_GetWarningCount = NULL;
	pWrapperTable->m_Reader_AddKeyWrappingCallback = NULL;
	pWrapperTable->m_Reader_SetContentEncryptionCallback = NULL;
	pWrapperTable->m_PackagePart_GetPath = NULL;
	pWrapperTable->m_PackagePart_SetPath = NULL;
	pWrapperTable->m_Resource_GetResourceID = NULL;
	pWrapperTable->m_Resource_GetUniqueResourceID = NULL;
	pWrapperTable->m_Resource_PackagePart = NULL;
	pWrapperTable->m_Resource_SetPackagePart = NULL;
	pWrapperTable->m_Resource_GetModelResourceID = NULL;
	pWrapperTable->m_ResourceIterator_MoveNext = NULL;
	pWrapperTable->m_ResourceIterator_MovePrevious = NULL;
	pWrapperTable->m_ResourceIterator_GetCurrent = NULL;
	pWrapperTable->m_ResourceIterator_Clone = NULL;
	pWrapperTable->m_ResourceIterator_Count = NULL;
	pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack = NULL;
	pWrapperTable->m_ObjectIterator_GetCurrentObject = NULL;
	pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject = NULL;
	pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject = NULL;
	pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D = NULL;
	pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup = NULL;
	pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup = NULL;
	pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup = NULL;
	pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials = NULL;
	pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup = NULL;
	pWrapperTable->m_MetaData_GetNameSpace = NULL;
	pWrapperTable->m_MetaData_SetNameSpace = NULL;
	pWrapperTable->m_MetaData_GetName = NULL;
	pWrapperTable->m_MetaData_SetName = NULL;
	pWrapperTable->m_MetaData_GetKey = NULL;
	pWrapperTable->m_MetaData_GetMustPreserve = NULL;
	pWrapperTable->m_MetaData_SetMustPreserve = NULL;
	pWrapperTable->m_MetaData_GetType = NULL;
	pWrapperTable->m_MetaData_SetType = NULL;
	pWrapperTable->m_MetaData_GetValue = NULL;
	pWrapperTable->m_MetaData_SetValue = NULL;
	pWrapperTable->m_MetaDataGroup_GetMetaDataCount = NULL;
	pWrapperTable->m_MetaDataGroup_GetMetaData = NULL;
	pWrapperTable->m_MetaDataGroup_GetMetaDataByKey = NULL;
	pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex = NULL;
	pWrapperTable->m_MetaDataGroup_RemoveMetaData = NULL;
	pWrapperTable->m_MetaDataGroup_AddMetaData = NULL;
	pWrapperTable->m_Object_GetType = NULL;
	pWrapperTable->m_Object_SetType = NULL;
	pWrapperTable->m_Object_GetName = NULL;
	pWrapperTable->m_Object_SetName = NULL;
	pWrapperTable->m_Object_GetPartNumber = NULL;
	pWrapperTable->m_Object_SetPartNumber = NULL;
	pWrapperTable->m_Object_IsMeshObject = NULL;
	pWrapperTable->m_Object_IsComponentsObject = NULL;
	pWrapperTable->m_Object_IsValid = NULL;
	pWrapperTable->m_Object_SetAttachmentAsThumbnail = NULL;
	pWrapperTable->m_Object_GetThumbnailAttachment = NULL;
	pWrapperTable->m_Object_ClearThumbnailAttachment = NULL;
	pWrapperTable->m_Object_GetOutbox = NULL;
	pWrapperTable->m_Object_GetUUID = NULL;
	pWrapperTable->m_Object_SetUUID = NULL;
	pWrapperTable->m_Object_GetMetaDataGroup = NULL;
	pWrapperTable->m_Object_SetSlicesMeshResolution = NULL;
	pWrapperTable->m_Object_GetSlicesMeshResolution = NULL;
	pWrapperTable->m_Object_HasSlices = NULL;
	pWrapperTable->m_Object_ClearSliceStack = NULL;
	pWrapperTable->m_Object_GetSliceStack = NULL;
	pWrapperTable->m_Object_AssignSliceStack = NULL;
	pWrapperTable->m_MeshObject_GetVertexCount = NULL;
	pWrapperTable->m_MeshObject_GetTriangleCount = NULL;
	pWrapperTable->m_MeshObject_GetVertex = NULL;
	pWrapperTable->m_MeshObject_SetVertex = NULL;
	pWrapperTable->m_MeshObject_AddVertex = NULL;
	pWrapperTable->m_MeshObject_GetVertices = NULL;
	pWrapperTable->m_MeshObject_GetTriangle = NULL;
	pWrapperTable->m_MeshObject_SetTriangle = NULL;
	pWrapperTable->m_MeshObject_AddTriangle = NULL;
	pWrapperTable->m_MeshObject_GetTriangleIndices = NULL;
	pWrapperTable->m_MeshObject_SetObjectLevelProperty = NULL;
	pWrapperTable->m_MeshObject_GetObjectLevelProperty = NULL;
	pWrapperTable->m_MeshObject_SetTriangleProperties = NULL;
	pWrapperTable->m_MeshObject_GetTriangleProperties = NULL;
	pWrapperTable->m_MeshObject_SetAllTriangleProperties = NULL;
	pWrapperTable->m_MeshObject_GetAllTriangleProperties = NULL;
	pWrapperTable->m_MeshObject_ClearAllProperties = NULL;
	pWrapperTable->m_MeshObject_SetGeometry = NULL;
	pWrapperTable->m_MeshObject_IsManifoldAndOriented = NULL;
	pWrapperTable->m_MeshObject_BeamLattice = NULL;
	pWrapperTable->m_BeamLattice_GetMinLength = NULL;
	pWrapperTable->m_BeamLattice_SetMinLength = NULL;
	pWrapperTable->m_BeamLattice_GetClipping = NULL;
	pWrapperTable->m_BeamLattice_SetClipping = NULL;
	pWrapperTable->m_BeamLattice_GetRepresentation = NULL;
	pWrapperTable->m_BeamLattice_SetRepresentation = NULL;
	pWrapperTable->m_BeamLattice_GetBallOptions = NULL;
	pWrapperTable->m_BeamLattice_SetBallOptions = NULL;
	pWrapperTable->m_BeamLattice_GetBeamCount = NULL;
	pWrapperTable->m_BeamLattice_GetBeam = NULL;
	pWrapperTable->m_BeamLattice_AddBeam = NULL;
	pWrapperTable->m_BeamLattice_SetBeam = NULL;
	pWrapperTable->m_BeamLattice_SetBeams = NULL;
	pWrapperTable->m_BeamLattice_GetBeams = NULL;
	pWrapperTable->m_BeamLattice_GetBallCount = NULL;
	pWrapperTable->m_BeamLattice_GetBall = NULL;
	pWrapperTable->m_BeamLattice_AddBall = NULL;
	pWrapperTable->m_BeamLattice_SetBall = NULL;
	pWrapperTable->m_BeamLattice_SetBalls = NULL;
	pWrapperTable->m_BeamLattice_GetBalls = NULL;
	pWrapperTable->m_BeamLattice_GetBeamSetCount = NULL;
	pWrapperTable->m_BeamLattice_AddBeamSet = NULL;
	pWrapperTable->m_BeamLattice_GetBeamSet = NULL;
	pWrapperTable->m_Component_GetObjectResource = NULL;
	pWrapperTable->m_Component_GetObjectResourceID = NULL;
	pWrapperTable->m_Component_GetUUID = NULL;
	pWrapperTable->m_Component_SetUUID = NULL;
	pWrapperTable->m_Component_HasTransform = NULL;
	pWrapperTable->m_Component_GetTransform = NULL;
	pWrapperTable->m_Component_SetTransform = NULL;
	pWrapperTable->m_ComponentsObject_AddComponent = NULL;
	pWrapperTable->m_ComponentsObject_GetComponent = NULL;
	pWrapperTable->m_ComponentsObject_GetComponentCount = NULL;
	pWrapperTable->m_BeamSet_SetName = NULL;
	pWrapperTable->m_BeamSet_GetName = NULL;
	pWrapperTable->m_BeamSet_SetIdentifier = NULL;
	pWrapperTable->m_BeamSet_GetIdentifier = NULL;
	pWrapperTable->m_BeamSet_GetReferenceCount = NULL;
	pWrapperTable->m_BeamSet_SetReferences = NULL;
	pWrapperTable->m_BeamSet_GetReferences = NULL;
	pWrapperTable->m_BeamSet_GetBallReferenceCount = NULL;
	pWrapperTable->m_BeamSet_SetBallReferences = NULL;
	pWrapperTable->m_BeamSet_GetBallReferences = NULL;
	pWrapperTable->m_BaseMaterialGroup_GetCount = NULL;
	pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs = NULL;
	pWrapperTable->m_BaseMaterialGroup_AddMaterial = NULL;
	pWrapperTable->m_BaseMaterialGroup_RemoveMaterial = NULL;
	pWrapperTable->m_BaseMaterialGroup_GetName = NULL;
	pWrapperTable->m_BaseMaterialGroup_SetName = NULL;
	pWrapperTable->m_BaseMaterialGroup_SetDisplayColor = NULL;
	pWrapperTable->m_BaseMaterialGroup_GetDisplayColor = NULL;
	pWrapperTable->m_ColorGroup_GetCount = NULL;
	pWrapperTable->m_ColorGroup_GetAllPropertyIDs = NULL;
	pWrapperTable->m_ColorGroup_AddColor = NULL;
	pWrapperTable->m_ColorGroup_RemoveColor = NULL;
	pWrapperTable->m_ColorGroup_SetColor = NULL;
	pWrapperTable->m_ColorGroup_GetColor = NULL;
	pWrapperTable->m_Texture2DGroup_GetCount = NULL;
	pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs = NULL;
	pWrapperTable->m_Texture2DGroup_AddTex2Coord = NULL;
	pWrapperTable->m_Texture2DGroup_GetTex2Coord = NULL;
	pWrapperTable->m_Texture2DGroup_RemoveTex2Coord = NULL;
	pWrapperTable->m_Texture2DGroup_GetTexture2D = NULL;
	pWrapperTable->m_CompositeMaterials_GetCount = NULL;
	pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs = NULL;
	pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup = NULL;
	pWrapperTable->m_CompositeMaterials_AddComposite = NULL;
	pWrapperTable->m_CompositeMaterials_RemoveComposite = NULL;
	pWrapperTable->m_CompositeMaterials_GetComposite = NULL;
	pWrapperTable->m_MultiPropertyGroup_GetCount = NULL;
	pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs = NULL;
	pWrapperTable->m_MultiPropertyGroup_AddMultiProperty = NULL;
	pWrapperTable->m_MultiPropertyGroup_SetMultiProperty = NULL;
	pWrapperTable->m_MultiPropertyGroup_GetMultiProperty = NULL;
	pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty = NULL;
	pWrapperTable->m_MultiPropertyGroup_GetLayerCount = NULL;
	pWrapperTable->m_MultiPropertyGroup_AddLayer = NULL;
	pWrapperTable->m_MultiPropertyGroup_GetLayer = NULL;
	pWrapperTable->m_MultiPropertyGroup_RemoveLayer = NULL;
	pWrapperTable->m_Attachment_GetPath = NULL;
	pWrapperTable->m_Attachment_SetPath = NULL;
	pWrapperTable->m_Attachment_PackagePart = NULL;
	pWrapperTable->m_Attachment_GetRelationShipType = NULL;
	pWrapperTable->m_Attachment_SetRelationShipType = NULL;
	pWrapperTable->m_Attachment_WriteToFile = NULL;
	pWrapperTable->m_Attachment_ReadFromFile = NULL;
	pWrapperTable->m_Attachment_ReadFromCallback = NULL;
	pWrapperTable->m_Attachment_GetStreamSize = NULL;
	pWrapperTable->m_Attachment_WriteToBuffer = NULL;
	pWrapperTable->m_Attachment_ReadFromBuffer = NULL;
	pWrapperTable->m_Texture2D_GetAttachment = NULL;
	pWrapperTable->m_Texture2D_SetAttachment = NULL;
	pWrapperTable->m_Texture2D_GetContentType = NULL;
	pWrapperTable->m_Texture2D_SetContentType = NULL;
	pWrapperTable->m_Texture2D_GetTileStyleUV = NULL;
	pWrapperTable->m_Texture2D_SetTileStyleUV = NULL;
	pWrapperTable->m_Texture2D_GetFilter = NULL;
	pWrapperTable->m_Texture2D_SetFilter = NULL;
	pWrapperTable->m_BuildItem_GetObjectResource = NULL;
	pWrapperTable->m_BuildItem_GetUUID = NULL;
	pWrapperTable->m_BuildItem_SetUUID = NULL;
	pWrapperTable->m_BuildItem_GetObjectResourceID = NULL;
	pWrapperTable->m_BuildItem_HasObjectTransform = NULL;
	pWrapperTable->m_BuildItem_GetObjectTransform = NULL;
	pWrapperTable->m_BuildItem_SetObjectTransform = NULL;
	pWrapperTable->m_BuildItem_GetPartNumber = NULL;
	pWrapperTable->m_BuildItem_SetPartNumber = NULL;
	pWrapperTable->m_BuildItem_GetMetaDataGroup = NULL;
	pWrapperTable->m_BuildItem_GetOutbox = NULL;
	pWrapperTable->m_BuildItemIterator_MoveNext = NULL;
	pWrapperTable->m_BuildItemIterator_MovePrevious = NULL;
	pWrapperTable->m_BuildItemIterator_GetCurrent = NULL;
	pWrapperTable->m_BuildItemIterator_Clone = NULL;
	pWrapperTable->m_BuildItemIterator_Count = NULL;
	pWrapperTable->m_Slice_SetVertices = NULL;
	pWrapperTable->m_Slice_GetVertices = NULL;
	pWrapperTable->m_Slice_GetVertexCount = NULL;
	pWrapperTable->m_Slice_AddPolygon = NULL;
	pWrapperTable->m_Slice_GetPolygonCount = NULL;
	pWrapperTable->m_Slice_SetPolygonIndices = NULL;
	pWrapperTable->m_Slice_GetPolygonIndices = NULL;
	pWrapperTable->m_Slice_GetPolygonIndexCount = NULL;
	pWrapperTable->m_Slice_GetZTop = NULL;
	pWrapperTable->m_SliceStack_GetBottomZ = NULL;
	pWrapperTable->m_SliceStack_GetSliceCount = NULL;
	pWrapperTable->m_SliceStack_GetSlice = NULL;
	pWrapperTable->m_SliceStack_AddSlice = NULL;
	pWrapperTable->m_SliceStack_GetSliceRefCount = NULL;
	pWrapperTable->m_SliceStack_AddSliceStackReference = NULL;
	pWrapperTable->m_SliceStack_GetSliceStackReference = NULL;
	pWrapperTable->m_SliceStack_CollapseSliceReferences = NULL;
	pWrapperTable->m_SliceStack_SetOwnPath = NULL;
	pWrapperTable->m_SliceStack_GetOwnPath = NULL;
	pWrapperTable->m_Consumer_GetConsumerID = NULL;
	pWrapperTable->m_Consumer_GetKeyID = NULL;
	pWrapperTable->m_Consumer_GetKeyValue = NULL;
	pWrapperTable->m_AccessRight_GetConsumer = NULL;
	pWrapperTable->m_AccessRight_GetWrappingAlgorithm = NULL;
	pWrapperTable->m_AccessRight_GetMgfAlgorithm = NULL;
	pWrapperTable->m_AccessRight_GetDigestMethod = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetKey = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetInitializationVector = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag = NULL;
	pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetDescriptor = NULL;
	pWrapperTable->m_ContentEncryptionParams_GetKeyUUID = NULL;
	pWrapperTable->m_ResourceData_GetPath = NULL;
	pWrapperTable->m_ResourceData_GetEncryptionAlgorithm = NULL;
	pWrapperTable->m_ResourceData_GetCompression = NULL;
	pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData = NULL;
	pWrapperTable->m_ResourceDataGroup_GetKeyUUID = NULL;
	pWrapperTable->m_ResourceDataGroup_AddAccessRight = NULL;
	pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer = NULL;
	pWrapperTable->m_ResourceDataGroup_RemoveAccessRight = NULL;
	pWrapperTable->m_KeyStore_AddConsumer = NULL;
	pWrapperTable->m_KeyStore_GetConsumerCount = NULL;
	pWrapperTable->m_KeyStore_GetConsumer = NULL;
	pWrapperTable->m_KeyStore_RemoveConsumer = NULL;
	pWrapperTable->m_KeyStore_FindConsumer = NULL;
	pWrapperTable->m_KeyStore_GetResourceDataGroupCount = NULL;
	pWrapperTable->m_KeyStore_AddResourceDataGroup = NULL;
	pWrapperTable->m_KeyStore_GetResourceDataGroup = NULL;
	pWrapperTable->m_KeyStore_RemoveResourceDataGroup = NULL;
	pWrapperTable->m_KeyStore_FindResourceDataGroup = NULL;
	pWrapperTable->m_KeyStore_AddResourceData = NULL;
	pWrapperTable->m_KeyStore_RemoveResourceData = NULL;
	pWrapperTable->m_KeyStore_FindResourceData = NULL;
	pWrapperTable->m_KeyStore_GetResourceDataCount = NULL;
	pWrapperTable->m_KeyStore_GetResourceData = NULL;
	pWrapperTable->m_KeyStore_GetUUID = NULL;
	pWrapperTable->m_KeyStore_SetUUID = NULL;
	pWrapperTable->m_Model_RootModelPart = NULL;
	pWrapperTable->m_Model_FindOrCreatePackagePart = NULL;
	pWrapperTable->m_Model_SetUnit = NULL;
	pWrapperTable->m_Model_GetUnit = NULL;
	pWrapperTable->m_Model_GetLanguage = NULL;
	pWrapperTable->m_Model_SetLanguage = NULL;
	pWrapperTable->m_Model_QueryWriter = NULL;
	pWrapperTable->m_Model_QueryReader = NULL;
	pWrapperTable->m_Model_GetResourceByID = NULL;
	pWrapperTable->m_Model_GetTexture2DByID = NULL;
	pWrapperTable->m_Model_GetPropertyTypeByID = NULL;
	pWrapperTable->m_Model_GetBaseMaterialGroupByID = NULL;
	pWrapperTable->m_Model_GetTexture2DGroupByID = NULL;
	pWrapperTable->m_Model_GetCompositeMaterialsByID = NULL;
	pWrapperTable->m_Model_GetMultiPropertyGroupByID = NULL;
	pWrapperTable->m_Model_GetMeshObjectByID = NULL;
	pWrapperTable->m_Model_GetComponentsObjectByID = NULL;
	pWrapperTable->m_Model_GetColorGroupByID = NULL;
	pWrapperTable->m_Model_GetSliceStackByID = NULL;
	pWrapperTable->m_Model_GetBuildUUID = NULL;
	pWrapperTable->m_Model_SetBuildUUID = NULL;
	pWrapperTable->m_Model_GetBuildItems = NULL;
	pWrapperTable->m_Model_GetOutbox = NULL;
	pWrapperTable->m_Model_GetResources = NULL;
	pWrapperTable->m_Model_GetObjects = NULL;
	pWrapperTable->m_Model_GetMeshObjects = NULL;
	pWrapperTable->m_Model_GetComponentsObjects = NULL;
	pWrapperTable->m_Model_GetTexture2Ds = NULL;
	pWrapperTable->m_Model_GetBaseMaterialGroups = NULL;
	pWrapperTable->m_Model_GetColorGroups = NULL;
	pWrapperTable->m_Model_GetTexture2DGroups = NULL;
	pWrapperTable->m_Model_GetCompositeMaterials = NULL;
	pWrapperTable->m_Model_GetMultiPropertyGroups = NULL;
	pWrapperTable->m_Model_GetSliceStacks = NULL;
	pWrapperTable->m_Model_MergeToModel = NULL;
	pWrapperTable->m_Model_AddMeshObject = NULL;
	pWrapperTable->m_Model_AddComponentsObject = NULL;
	pWrapperTable->m_Model_AddSliceStack = NULL;
	pWrapperTable->m_Model_AddTexture2DFromAttachment = NULL;
	pWrapperTable->m_Model_AddBaseMaterialGroup = NULL;
	pWrapperTable->m_Model_AddColorGroup = NULL;
	pWrapperTable->m_Model_AddTexture2DGroup = NULL;
	pWrapperTable->m_Model_AddCompositeMaterials = NULL;
	pWrapperTable->m_Model_AddMultiPropertyGroup = NULL;
	pWrapperTable->m_Model_AddBuildItem = NULL;
	pWrapperTable->m_Model_RemoveBuildItem = NULL;
	pWrapperTable->m_Model_GetMetaDataGroup = NULL;
	pWrapperTable->m_Model_AddAttachment = NULL;
	pWrapperTable->m_Model_RemoveAttachment = NULL;
	pWrapperTable->m_Model_GetAttachment = NULL;
	pWrapperTable->m_Model_FindAttachment = NULL;
	pWrapperTable->m_Model_GetAttachmentCount = NULL;
	pWrapperTable->m_Model_HasPackageThumbnailAttachment = NULL;
	pWrapperTable->m_Model_CreatePackageThumbnailAttachment = NULL;
	pWrapperTable->m_Model_GetPackageThumbnailAttachment = NULL;
	pWrapperTable->m_Model_RemovePackageThumbnailAttachment = NULL;
	pWrapperTable->m_Model_AddCustomContentType = NULL;
	pWrapperTable->m_Model_RemoveCustomContentType = NULL;
	pWrapperTable->m_Model_SetRandomNumberCallback = NULL;
	pWrapperTable->m_Model_GetKeyStore = NULL;
	pWrapperTable->m_GetLibraryVersion = NULL;
	pWrapperTable->m_GetPrereleaseInformation = NULL;
	pWrapperTable->m_GetBuildInformation = NULL;
	pWrapperTable->m_GetSpecificationVersion = NULL;
	pWrapperTable->m_CreateModel = NULL;
	pWrapperTable->m_Release = NULL;
	pWrapperTable->m_Acquire = NULL;
	pWrapperTable->m_SetJournal = NULL;
	pWrapperTable->m_GetLastError = NULL;
	pWrapperTable->m_GetSymbolLookupMethod = NULL;
	pWrapperTable->m_RetrieveProgressMessage = NULL;
	pWrapperTable->m_RGBAToColor = NULL;
	pWrapperTable->m_FloatRGBAToColor = NULL;
	pWrapperTable->m_ColorToRGBA = NULL;
	pWrapperTable->m_ColorToFloatRGBA = NULL;
	pWrapperTable->m_GetIdentityTransform = NULL;
	pWrapperTable->m_GetUniformScaleTransform = NULL;
	pWrapperTable->m_GetScaleTransform = NULL;
	pWrapperTable->m_GetTranslationTransform = NULL;
	
	return LIB3MF_SUCCESS;
}

Lib3MFResult ReleaseLib3MFWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable)
{
	if (pWrapperTable == NULL)
		return LIB3MF_ERROR_INVALIDPARAM;
	
	if (pWrapperTable->m_LibraryHandle != NULL) {
	#ifdef _WIN32
		HMODULE hModule = (HMODULE) pWrapperTable->m_LibraryHandle;
		FreeLibrary(hModule);
	#else // _WIN32
		dlclose(pWrapperTable->m_LibraryHandle);
	#endif // _WIN32
		return InitLib3MFWrapperTable(pWrapperTable);
	}
	
	return LIB3MF_SUCCESS;
}

Lib3MFResult LoadLib3MFWrapperTable(sLib3MFDynamicWrapperTable * pWrapperTable, const char * pLibraryFileName)
{
	if (pWrapperTable == NULL)
		return LIB3MF_ERROR_INVALIDPARAM;
	if (pLibraryFileName == NULL)
		return LIB3MF_ERROR_INVALIDPARAM;
	
	#ifdef _WIN32
	// Convert filename to UTF16-string
	int nLength = 0;
	while ((pLibraryFileName[nLength] != 0) && (nLength < MAX_PATH))
		nLength++;
	int nBufferSize = nLength * 2 + 2;
	wchar_t* wsLibraryFileName = (wchar_t*)malloc(nBufferSize*sizeof(wchar_t));
	memset(wsLibraryFileName, 0, nBufferSize*sizeof(wchar_t));
	int nResult = MultiByteToWideChar(CP_UTF8, 0, pLibraryFileName, nLength, wsLibraryFileName, nBufferSize);
	if (nResult == 0) {
		free(wsLibraryFileName);
		return LIB3MF_ERROR_COULDNOTLOADLIBRARY;
	}
	
	HMODULE hLibrary = LoadLibraryW(wsLibraryFileName);
	free(wsLibraryFileName);
	if (hLibrary == 0) 
		return LIB3MF_ERROR_COULDNOTLOADLIBRARY;
	#else // _WIN32
	void* hLibrary = dlopen(pLibraryFileName, RTLD_LAZY);
	if (hLibrary == 0) 
		return LIB3MF_ERROR_COULDNOTLOADLIBRARY;
	dlerror();
	#endif // _WIN32
	
	#ifdef _WIN32
	pWrapperTable->m_Base_ClassTypeId = (PLib3MFBase_ClassTypeIdPtr) GetProcAddress(hLibrary, "lib3mf_base_classtypeid");
	#else // _WIN32
	pWrapperTable->m_Base_ClassTypeId = (PLib3MFBase_ClassTypeIdPtr) dlsym(hLibrary, "lib3mf_base_classtypeid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Base_ClassTypeId == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_WriteToFile = (PLib3MFWriter_WriteToFilePtr) GetProcAddress(hLibrary, "lib3mf_writer_writetofile");
	#else // _WIN32
	pWrapperTable->m_Writer_WriteToFile = (PLib3MFWriter_WriteToFilePtr) dlsym(hLibrary, "lib3mf_writer_writetofile");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_WriteToFile == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_GetStreamSize = (PLib3MFWriter_GetStreamSizePtr) GetProcAddress(hLibrary, "lib3mf_writer_getstreamsize");
	#else // _WIN32
	pWrapperTable->m_Writer_GetStreamSize = (PLib3MFWriter_GetStreamSizePtr) dlsym(hLibrary, "lib3mf_writer_getstreamsize");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_GetStreamSize == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_WriteToBuffer = (PLib3MFWriter_WriteToBufferPtr) GetProcAddress(hLibrary, "lib3mf_writer_writetobuffer");
	#else // _WIN32
	pWrapperTable->m_Writer_WriteToBuffer = (PLib3MFWriter_WriteToBufferPtr) dlsym(hLibrary, "lib3mf_writer_writetobuffer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_WriteToBuffer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_WriteToCallback = (PLib3MFWriter_WriteToCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_writetocallback");
	#else // _WIN32
	pWrapperTable->m_Writer_WriteToCallback = (PLib3MFWriter_WriteToCallbackPtr) dlsym(hLibrary, "lib3mf_writer_writetocallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_WriteToCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_SetProgressCallback = (PLib3MFWriter_SetProgressCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_setprogresscallback");
	#else // _WIN32
	pWrapperTable->m_Writer_SetProgressCallback = (PLib3MFWriter_SetProgressCallbackPtr) dlsym(hLibrary, "lib3mf_writer_setprogresscallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_SetProgressCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_GetDecimalPrecision = (PLib3MFWriter_GetDecimalPrecisionPtr) GetProcAddress(hLibrary, "lib3mf_writer_getdecimalprecision");
	#else // _WIN32
	pWrapperTable->m_Writer_GetDecimalPrecision = (PLib3MFWriter_GetDecimalPrecisionPtr) dlsym(hLibrary, "lib3mf_writer_getdecimalprecision");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_GetDecimalPrecision == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_SetDecimalPrecision = (PLib3MFWriter_SetDecimalPrecisionPtr) GetProcAddress(hLibrary, "lib3mf_writer_setdecimalprecision");
	#else // _WIN32
	pWrapperTable->m_Writer_SetDecimalPrecision = (PLib3MFWriter_SetDecimalPrecisionPtr) dlsym(hLibrary, "lib3mf_writer_setdecimalprecision");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_SetDecimalPrecision == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_SetStrictModeActive = (PLib3MFWriter_SetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_writer_setstrictmodeactive");
	#else // _WIN32
	pWrapperTable->m_Writer_SetStrictModeActive = (PLib3MFWriter_SetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_writer_setstrictmodeactive");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_SetStrictModeActive == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_GetStrictModeActive = (PLib3MFWriter_GetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_writer_getstrictmodeactive");
	#else // _WIN32
	pWrapperTable->m_Writer_GetStrictModeActive = (PLib3MFWriter_GetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_writer_getstrictmodeactive");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_GetStrictModeActive == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_GetWarning = (PLib3MFWriter_GetWarningPtr) GetProcAddress(hLibrary, "lib3mf_writer_getwarning");
	#else // _WIN32
	pWrapperTable->m_Writer_GetWarning = (PLib3MFWriter_GetWarningPtr) dlsym(hLibrary, "lib3mf_writer_getwarning");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_GetWarning == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_GetWarningCount = (PLib3MFWriter_GetWarningCountPtr) GetProcAddress(hLibrary, "lib3mf_writer_getwarningcount");
	#else // _WIN32
	pWrapperTable->m_Writer_GetWarningCount = (PLib3MFWriter_GetWarningCountPtr) dlsym(hLibrary, "lib3mf_writer_getwarningcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_GetWarningCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_AddKeyWrappingCallback = (PLib3MFWriter_AddKeyWrappingCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_addkeywrappingcallback");
	#else // _WIN32
	pWrapperTable->m_Writer_AddKeyWrappingCallback = (PLib3MFWriter_AddKeyWrappingCallbackPtr) dlsym(hLibrary, "lib3mf_writer_addkeywrappingcallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_AddKeyWrappingCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Writer_SetContentEncryptionCallback = (PLib3MFWriter_SetContentEncryptionCallbackPtr) GetProcAddress(hLibrary, "lib3mf_writer_setcontentencryptioncallback");
	#else // _WIN32
	pWrapperTable->m_Writer_SetContentEncryptionCallback = (PLib3MFWriter_SetContentEncryptionCallbackPtr) dlsym(hLibrary, "lib3mf_writer_setcontentencryptioncallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Writer_SetContentEncryptionCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_ReadFromFile = (PLib3MFReader_ReadFromFilePtr) GetProcAddress(hLibrary, "lib3mf_reader_readfromfile");
	#else // _WIN32
	pWrapperTable->m_Reader_ReadFromFile = (PLib3MFReader_ReadFromFilePtr) dlsym(hLibrary, "lib3mf_reader_readfromfile");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_ReadFromFile == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_ReadFromBuffer = (PLib3MFReader_ReadFromBufferPtr) GetProcAddress(hLibrary, "lib3mf_reader_readfrombuffer");
	#else // _WIN32
	pWrapperTable->m_Reader_ReadFromBuffer = (PLib3MFReader_ReadFromBufferPtr) dlsym(hLibrary, "lib3mf_reader_readfrombuffer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_ReadFromBuffer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_ReadFromCallback = (PLib3MFReader_ReadFromCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_readfromcallback");
	#else // _WIN32
	pWrapperTable->m_Reader_ReadFromCallback = (PLib3MFReader_ReadFromCallbackPtr) dlsym(hLibrary, "lib3mf_reader_readfromcallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_ReadFromCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_SetProgressCallback = (PLib3MFReader_SetProgressCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_setprogresscallback");
	#else // _WIN32
	pWrapperTable->m_Reader_SetProgressCallback = (PLib3MFReader_SetProgressCallbackPtr) dlsym(hLibrary, "lib3mf_reader_setprogresscallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_SetProgressCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_AddRelationToRead = (PLib3MFReader_AddRelationToReadPtr) GetProcAddress(hLibrary, "lib3mf_reader_addrelationtoread");
	#else // _WIN32
	pWrapperTable->m_Reader_AddRelationToRead = (PLib3MFReader_AddRelationToReadPtr) dlsym(hLibrary, "lib3mf_reader_addrelationtoread");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_AddRelationToRead == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_RemoveRelationToRead = (PLib3MFReader_RemoveRelationToReadPtr) GetProcAddress(hLibrary, "lib3mf_reader_removerelationtoread");
	#else // _WIN32
	pWrapperTable->m_Reader_RemoveRelationToRead = (PLib3MFReader_RemoveRelationToReadPtr) dlsym(hLibrary, "lib3mf_reader_removerelationtoread");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_RemoveRelationToRead == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_SetStrictModeActive = (PLib3MFReader_SetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_reader_setstrictmodeactive");
	#else // _WIN32
	pWrapperTable->m_Reader_SetStrictModeActive = (PLib3MFReader_SetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_reader_setstrictmodeactive");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_SetStrictModeActive == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_GetStrictModeActive = (PLib3MFReader_GetStrictModeActivePtr) GetProcAddress(hLibrary, "lib3mf_reader_getstrictmodeactive");
	#else // _WIN32
	pWrapperTable->m_Reader_GetStrictModeActive = (PLib3MFReader_GetStrictModeActivePtr) dlsym(hLibrary, "lib3mf_reader_getstrictmodeactive");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_GetStrictModeActive == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_GetWarning = (PLib3MFReader_GetWarningPtr) GetProcAddress(hLibrary, "lib3mf_reader_getwarning");
	#else // _WIN32
	pWrapperTable->m_Reader_GetWarning = (PLib3MFReader_GetWarningPtr) dlsym(hLibrary, "lib3mf_reader_getwarning");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_GetWarning == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_GetWarningCount = (PLib3MFReader_GetWarningCountPtr) GetProcAddress(hLibrary, "lib3mf_reader_getwarningcount");
	#else // _WIN32
	pWrapperTable->m_Reader_GetWarningCount = (PLib3MFReader_GetWarningCountPtr) dlsym(hLibrary, "lib3mf_reader_getwarningcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_GetWarningCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_AddKeyWrappingCallback = (PLib3MFReader_AddKeyWrappingCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_addkeywrappingcallback");
	#else // _WIN32
	pWrapperTable->m_Reader_AddKeyWrappingCallback = (PLib3MFReader_AddKeyWrappingCallbackPtr) dlsym(hLibrary, "lib3mf_reader_addkeywrappingcallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_AddKeyWrappingCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Reader_SetContentEncryptionCallback = (PLib3MFReader_SetContentEncryptionCallbackPtr) GetProcAddress(hLibrary, "lib3mf_reader_setcontentencryptioncallback");
	#else // _WIN32
	pWrapperTable->m_Reader_SetContentEncryptionCallback = (PLib3MFReader_SetContentEncryptionCallbackPtr) dlsym(hLibrary, "lib3mf_reader_setcontentencryptioncallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Reader_SetContentEncryptionCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_PackagePart_GetPath = (PLib3MFPackagePart_GetPathPtr) GetProcAddress(hLibrary, "lib3mf_packagepart_getpath");
	#else // _WIN32
	pWrapperTable->m_PackagePart_GetPath = (PLib3MFPackagePart_GetPathPtr) dlsym(hLibrary, "lib3mf_packagepart_getpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_PackagePart_GetPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_PackagePart_SetPath = (PLib3MFPackagePart_SetPathPtr) GetProcAddress(hLibrary, "lib3mf_packagepart_setpath");
	#else // _WIN32
	pWrapperTable->m_PackagePart_SetPath = (PLib3MFPackagePart_SetPathPtr) dlsym(hLibrary, "lib3mf_packagepart_setpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_PackagePart_SetPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Resource_GetResourceID = (PLib3MFResource_GetResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_resource_getresourceid");
	#else // _WIN32
	pWrapperTable->m_Resource_GetResourceID = (PLib3MFResource_GetResourceIDPtr) dlsym(hLibrary, "lib3mf_resource_getresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Resource_GetResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Resource_GetUniqueResourceID = (PLib3MFResource_GetUniqueResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_resource_getuniqueresourceid");
	#else // _WIN32
	pWrapperTable->m_Resource_GetUniqueResourceID = (PLib3MFResource_GetUniqueResourceIDPtr) dlsym(hLibrary, "lib3mf_resource_getuniqueresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Resource_GetUniqueResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Resource_PackagePart = (PLib3MFResource_PackagePartPtr) GetProcAddress(hLibrary, "lib3mf_resource_packagepart");
	#else // _WIN32
	pWrapperTable->m_Resource_PackagePart = (PLib3MFResource_PackagePartPtr) dlsym(hLibrary, "lib3mf_resource_packagepart");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Resource_PackagePart == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Resource_SetPackagePart = (PLib3MFResource_SetPackagePartPtr) GetProcAddress(hLibrary, "lib3mf_resource_setpackagepart");
	#else // _WIN32
	pWrapperTable->m_Resource_SetPackagePart = (PLib3MFResource_SetPackagePartPtr) dlsym(hLibrary, "lib3mf_resource_setpackagepart");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Resource_SetPackagePart == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Resource_GetModelResourceID = (PLib3MFResource_GetModelResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_resource_getmodelresourceid");
	#else // _WIN32
	pWrapperTable->m_Resource_GetModelResourceID = (PLib3MFResource_GetModelResourceIDPtr) dlsym(hLibrary, "lib3mf_resource_getmodelresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Resource_GetModelResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIterator_MoveNext = (PLib3MFResourceIterator_MoveNextPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_movenext");
	#else // _WIN32
	pWrapperTable->m_ResourceIterator_MoveNext = (PLib3MFResourceIterator_MoveNextPtr) dlsym(hLibrary, "lib3mf_resourceiterator_movenext");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIterator_MoveNext == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIterator_MovePrevious = (PLib3MFResourceIterator_MovePreviousPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_moveprevious");
	#else // _WIN32
	pWrapperTable->m_ResourceIterator_MovePrevious = (PLib3MFResourceIterator_MovePreviousPtr) dlsym(hLibrary, "lib3mf_resourceiterator_moveprevious");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIterator_MovePrevious == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIterator_GetCurrent = (PLib3MFResourceIterator_GetCurrentPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_getcurrent");
	#else // _WIN32
	pWrapperTable->m_ResourceIterator_GetCurrent = (PLib3MFResourceIterator_GetCurrentPtr) dlsym(hLibrary, "lib3mf_resourceiterator_getcurrent");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIterator_GetCurrent == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIterator_Clone = (PLib3MFResourceIterator_ClonePtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_clone");
	#else // _WIN32
	pWrapperTable->m_ResourceIterator_Clone = (PLib3MFResourceIterator_ClonePtr) dlsym(hLibrary, "lib3mf_resourceiterator_clone");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIterator_Clone == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceIterator_Count = (PLib3MFResourceIterator_CountPtr) GetProcAddress(hLibrary, "lib3mf_resourceiterator_count");
	#else // _WIN32
	pWrapperTable->m_ResourceIterator_Count = (PLib3MFResourceIterator_CountPtr) dlsym(hLibrary, "lib3mf_resourceiterator_count");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceIterator_Count == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack = (PLib3MFSliceStackIterator_GetCurrentSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_slicestackiterator_getcurrentslicestack");
	#else // _WIN32
	pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack = (PLib3MFSliceStackIterator_GetCurrentSliceStackPtr) dlsym(hLibrary, "lib3mf_slicestackiterator_getcurrentslicestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStackIterator_GetCurrentSliceStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ObjectIterator_GetCurrentObject = (PLib3MFObjectIterator_GetCurrentObjectPtr) GetProcAddress(hLibrary, "lib3mf_objectiterator_getcurrentobject");
	#else // _WIN32
	pWrapperTable->m_ObjectIterator_GetCurrentObject = (PLib3MFObjectIterator_GetCurrentObjectPtr) dlsym(hLibrary, "lib3mf_objectiterator_getcurrentobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ObjectIterator_GetCurrentObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject = (PLib3MFMeshObjectIterator_GetCurrentMeshObjectPtr) GetProcAddress(hLibrary, "lib3mf_meshobjectiterator_getcurrentmeshobject");
	#else // _WIN32
	pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject = (PLib3MFMeshObjectIterator_GetCurrentMeshObjectPtr) dlsym(hLibrary, "lib3mf_meshobjectiterator_getcurrentmeshobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObjectIterator_GetCurrentMeshObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject = (PLib3MFComponentsObjectIterator_GetCurrentComponentsObjectPtr) GetProcAddress(hLibrary, "lib3mf_componentsobjectiterator_getcurrentcomponentsobject");
	#else // _WIN32
	pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject = (PLib3MFComponentsObjectIterator_GetCurrentComponentsObjectPtr) dlsym(hLibrary, "lib3mf_componentsobjectiterator_getcurrentcomponentsobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComponentsObjectIterator_GetCurrentComponentsObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D = (PLib3MFTexture2DIterator_GetCurrentTexture2DPtr) GetProcAddress(hLibrary, "lib3mf_texture2diterator_getcurrenttexture2d");
	#else // _WIN32
	pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D = (PLib3MFTexture2DIterator_GetCurrentTexture2DPtr) dlsym(hLibrary, "lib3mf_texture2diterator_getcurrenttexture2d");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DIterator_GetCurrentTexture2D == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup = (PLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup = (PLib3MFBaseMaterialGroupIterator_GetCurrentBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroupIterator_GetCurrentBaseMaterialGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup = (PLib3MFColorGroupIterator_GetCurrentColorGroupPtr) GetProcAddress(hLibrary, "lib3mf_colorgroupiterator_getcurrentcolorgroup");
	#else // _WIN32
	pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup = (PLib3MFColorGroupIterator_GetCurrentColorGroupPtr) dlsym(hLibrary, "lib3mf_colorgroupiterator_getcurrentcolorgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroupIterator_GetCurrentColorGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup = (PLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup = (PLib3MFTexture2DGroupIterator_GetCurrentTexture2DGroupPtr) dlsym(hLibrary, "lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroupIterator_GetCurrentTexture2DGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials = (PLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsPtr) GetProcAddress(hLibrary, "lib3mf_compositematerialsiterator_getcurrentcompositematerials");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials = (PLib3MFCompositeMaterialsIterator_GetCurrentCompositeMaterialsPtr) dlsym(hLibrary, "lib3mf_compositematerialsiterator_getcurrentcompositematerials");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterialsIterator_GetCurrentCompositeMaterials == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup = (PLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup = (PLib3MFMultiPropertyGroupIterator_GetCurrentMultiPropertyGroupPtr) dlsym(hLibrary, "lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroupIterator_GetCurrentMultiPropertyGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetNameSpace = (PLib3MFMetaData_GetNameSpacePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getnamespace");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetNameSpace = (PLib3MFMetaData_GetNameSpacePtr) dlsym(hLibrary, "lib3mf_metadata_getnamespace");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetNameSpace == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_SetNameSpace = (PLib3MFMetaData_SetNameSpacePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setnamespace");
	#else // _WIN32
	pWrapperTable->m_MetaData_SetNameSpace = (PLib3MFMetaData_SetNameSpacePtr) dlsym(hLibrary, "lib3mf_metadata_setnamespace");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_SetNameSpace == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetName = (PLib3MFMetaData_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getname");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetName = (PLib3MFMetaData_GetNamePtr) dlsym(hLibrary, "lib3mf_metadata_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_SetName = (PLib3MFMetaData_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setname");
	#else // _WIN32
	pWrapperTable->m_MetaData_SetName = (PLib3MFMetaData_SetNamePtr) dlsym(hLibrary, "lib3mf_metadata_setname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_SetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetKey = (PLib3MFMetaData_GetKeyPtr) GetProcAddress(hLibrary, "lib3mf_metadata_getkey");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetKey = (PLib3MFMetaData_GetKeyPtr) dlsym(hLibrary, "lib3mf_metadata_getkey");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetKey == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetMustPreserve = (PLib3MFMetaData_GetMustPreservePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getmustpreserve");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetMustPreserve = (PLib3MFMetaData_GetMustPreservePtr) dlsym(hLibrary, "lib3mf_metadata_getmustpreserve");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetMustPreserve == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_SetMustPreserve = (PLib3MFMetaData_SetMustPreservePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setmustpreserve");
	#else // _WIN32
	pWrapperTable->m_MetaData_SetMustPreserve = (PLib3MFMetaData_SetMustPreservePtr) dlsym(hLibrary, "lib3mf_metadata_setmustpreserve");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_SetMustPreserve == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetType = (PLib3MFMetaData_GetTypePtr) GetProcAddress(hLibrary, "lib3mf_metadata_gettype");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetType = (PLib3MFMetaData_GetTypePtr) dlsym(hLibrary, "lib3mf_metadata_gettype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_SetType = (PLib3MFMetaData_SetTypePtr) GetProcAddress(hLibrary, "lib3mf_metadata_settype");
	#else // _WIN32
	pWrapperTable->m_MetaData_SetType = (PLib3MFMetaData_SetTypePtr) dlsym(hLibrary, "lib3mf_metadata_settype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_SetType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_GetValue = (PLib3MFMetaData_GetValuePtr) GetProcAddress(hLibrary, "lib3mf_metadata_getvalue");
	#else // _WIN32
	pWrapperTable->m_MetaData_GetValue = (PLib3MFMetaData_GetValuePtr) dlsym(hLibrary, "lib3mf_metadata_getvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_GetValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaData_SetValue = (PLib3MFMetaData_SetValuePtr) GetProcAddress(hLibrary, "lib3mf_metadata_setvalue");
	#else // _WIN32
	pWrapperTable->m_MetaData_SetValue = (PLib3MFMetaData_SetValuePtr) dlsym(hLibrary, "lib3mf_metadata_setvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaData_SetValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaDataCount = (PLib3MFMetaDataGroup_GetMetaDataCountPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_getmetadatacount");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaDataCount = (PLib3MFMetaDataGroup_GetMetaDataCountPtr) dlsym(hLibrary, "lib3mf_metadatagroup_getmetadatacount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_GetMetaDataCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaData = (PLib3MFMetaDataGroup_GetMetaDataPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_getmetadata");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaData = (PLib3MFMetaDataGroup_GetMetaDataPtr) dlsym(hLibrary, "lib3mf_metadatagroup_getmetadata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_GetMetaData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaDataByKey = (PLib3MFMetaDataGroup_GetMetaDataByKeyPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_getmetadatabykey");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_GetMetaDataByKey = (PLib3MFMetaDataGroup_GetMetaDataByKeyPtr) dlsym(hLibrary, "lib3mf_metadatagroup_getmetadatabykey");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_GetMetaDataByKey == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex = (PLib3MFMetaDataGroup_RemoveMetaDataByIndexPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_removemetadatabyindex");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex = (PLib3MFMetaDataGroup_RemoveMetaDataByIndexPtr) dlsym(hLibrary, "lib3mf_metadatagroup_removemetadatabyindex");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_RemoveMetaDataByIndex == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_RemoveMetaData = (PLib3MFMetaDataGroup_RemoveMetaDataPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_removemetadata");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_RemoveMetaData = (PLib3MFMetaDataGroup_RemoveMetaDataPtr) dlsym(hLibrary, "lib3mf_metadatagroup_removemetadata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_RemoveMetaData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MetaDataGroup_AddMetaData = (PLib3MFMetaDataGroup_AddMetaDataPtr) GetProcAddress(hLibrary, "lib3mf_metadatagroup_addmetadata");
	#else // _WIN32
	pWrapperTable->m_MetaDataGroup_AddMetaData = (PLib3MFMetaDataGroup_AddMetaDataPtr) dlsym(hLibrary, "lib3mf_metadatagroup_addmetadata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MetaDataGroup_AddMetaData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetType = (PLib3MFObject_GetTypePtr) GetProcAddress(hLibrary, "lib3mf_object_gettype");
	#else // _WIN32
	pWrapperTable->m_Object_GetType = (PLib3MFObject_GetTypePtr) dlsym(hLibrary, "lib3mf_object_gettype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetType = (PLib3MFObject_SetTypePtr) GetProcAddress(hLibrary, "lib3mf_object_settype");
	#else // _WIN32
	pWrapperTable->m_Object_SetType = (PLib3MFObject_SetTypePtr) dlsym(hLibrary, "lib3mf_object_settype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetName = (PLib3MFObject_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_object_getname");
	#else // _WIN32
	pWrapperTable->m_Object_GetName = (PLib3MFObject_GetNamePtr) dlsym(hLibrary, "lib3mf_object_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetName = (PLib3MFObject_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_object_setname");
	#else // _WIN32
	pWrapperTable->m_Object_SetName = (PLib3MFObject_SetNamePtr) dlsym(hLibrary, "lib3mf_object_setname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetPartNumber = (PLib3MFObject_GetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_object_getpartnumber");
	#else // _WIN32
	pWrapperTable->m_Object_GetPartNumber = (PLib3MFObject_GetPartNumberPtr) dlsym(hLibrary, "lib3mf_object_getpartnumber");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetPartNumber == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetPartNumber = (PLib3MFObject_SetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_object_setpartnumber");
	#else // _WIN32
	pWrapperTable->m_Object_SetPartNumber = (PLib3MFObject_SetPartNumberPtr) dlsym(hLibrary, "lib3mf_object_setpartnumber");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetPartNumber == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_IsMeshObject = (PLib3MFObject_IsMeshObjectPtr) GetProcAddress(hLibrary, "lib3mf_object_ismeshobject");
	#else // _WIN32
	pWrapperTable->m_Object_IsMeshObject = (PLib3MFObject_IsMeshObjectPtr) dlsym(hLibrary, "lib3mf_object_ismeshobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_IsMeshObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_IsComponentsObject = (PLib3MFObject_IsComponentsObjectPtr) GetProcAddress(hLibrary, "lib3mf_object_iscomponentsobject");
	#else // _WIN32
	pWrapperTable->m_Object_IsComponentsObject = (PLib3MFObject_IsComponentsObjectPtr) dlsym(hLibrary, "lib3mf_object_iscomponentsobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_IsComponentsObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_IsValid = (PLib3MFObject_IsValidPtr) GetProcAddress(hLibrary, "lib3mf_object_isvalid");
	#else // _WIN32
	pWrapperTable->m_Object_IsValid = (PLib3MFObject_IsValidPtr) dlsym(hLibrary, "lib3mf_object_isvalid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_IsValid == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetAttachmentAsThumbnail = (PLib3MFObject_SetAttachmentAsThumbnailPtr) GetProcAddress(hLibrary, "lib3mf_object_setattachmentasthumbnail");
	#else // _WIN32
	pWrapperTable->m_Object_SetAttachmentAsThumbnail = (PLib3MFObject_SetAttachmentAsThumbnailPtr) dlsym(hLibrary, "lib3mf_object_setattachmentasthumbnail");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetAttachmentAsThumbnail == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetThumbnailAttachment = (PLib3MFObject_GetThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_object_getthumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Object_GetThumbnailAttachment = (PLib3MFObject_GetThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_object_getthumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_ClearThumbnailAttachment = (PLib3MFObject_ClearThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_object_clearthumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Object_ClearThumbnailAttachment = (PLib3MFObject_ClearThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_object_clearthumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_ClearThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetOutbox = (PLib3MFObject_GetOutboxPtr) GetProcAddress(hLibrary, "lib3mf_object_getoutbox");
	#else // _WIN32
	pWrapperTable->m_Object_GetOutbox = (PLib3MFObject_GetOutboxPtr) dlsym(hLibrary, "lib3mf_object_getoutbox");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetOutbox == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetUUID = (PLib3MFObject_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_object_getuuid");
	#else // _WIN32
	pWrapperTable->m_Object_GetUUID = (PLib3MFObject_GetUUIDPtr) dlsym(hLibrary, "lib3mf_object_getuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetUUID = (PLib3MFObject_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_object_setuuid");
	#else // _WIN32
	pWrapperTable->m_Object_SetUUID = (PLib3MFObject_SetUUIDPtr) dlsym(hLibrary, "lib3mf_object_setuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetMetaDataGroup = (PLib3MFObject_GetMetaDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_object_getmetadatagroup");
	#else // _WIN32
	pWrapperTable->m_Object_GetMetaDataGroup = (PLib3MFObject_GetMetaDataGroupPtr) dlsym(hLibrary, "lib3mf_object_getmetadatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetMetaDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_SetSlicesMeshResolution = (PLib3MFObject_SetSlicesMeshResolutionPtr) GetProcAddress(hLibrary, "lib3mf_object_setslicesmeshresolution");
	#else // _WIN32
	pWrapperTable->m_Object_SetSlicesMeshResolution = (PLib3MFObject_SetSlicesMeshResolutionPtr) dlsym(hLibrary, "lib3mf_object_setslicesmeshresolution");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_SetSlicesMeshResolution == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetSlicesMeshResolution = (PLib3MFObject_GetSlicesMeshResolutionPtr) GetProcAddress(hLibrary, "lib3mf_object_getslicesmeshresolution");
	#else // _WIN32
	pWrapperTable->m_Object_GetSlicesMeshResolution = (PLib3MFObject_GetSlicesMeshResolutionPtr) dlsym(hLibrary, "lib3mf_object_getslicesmeshresolution");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetSlicesMeshResolution == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_HasSlices = (PLib3MFObject_HasSlicesPtr) GetProcAddress(hLibrary, "lib3mf_object_hasslices");
	#else // _WIN32
	pWrapperTable->m_Object_HasSlices = (PLib3MFObject_HasSlicesPtr) dlsym(hLibrary, "lib3mf_object_hasslices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_HasSlices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_ClearSliceStack = (PLib3MFObject_ClearSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_object_clearslicestack");
	#else // _WIN32
	pWrapperTable->m_Object_ClearSliceStack = (PLib3MFObject_ClearSliceStackPtr) dlsym(hLibrary, "lib3mf_object_clearslicestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_ClearSliceStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_GetSliceStack = (PLib3MFObject_GetSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_object_getslicestack");
	#else // _WIN32
	pWrapperTable->m_Object_GetSliceStack = (PLib3MFObject_GetSliceStackPtr) dlsym(hLibrary, "lib3mf_object_getslicestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_GetSliceStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Object_AssignSliceStack = (PLib3MFObject_AssignSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_object_assignslicestack");
	#else // _WIN32
	pWrapperTable->m_Object_AssignSliceStack = (PLib3MFObject_AssignSliceStackPtr) dlsym(hLibrary, "lib3mf_object_assignslicestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Object_AssignSliceStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetVertexCount = (PLib3MFMeshObject_GetVertexCountPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvertexcount");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetVertexCount = (PLib3MFMeshObject_GetVertexCountPtr) dlsym(hLibrary, "lib3mf_meshobject_getvertexcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetVertexCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetTriangleCount = (PLib3MFMeshObject_GetTriangleCountPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettrianglecount");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetTriangleCount = (PLib3MFMeshObject_GetTriangleCountPtr) dlsym(hLibrary, "lib3mf_meshobject_gettrianglecount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetTriangleCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetVertex = (PLib3MFMeshObject_GetVertexPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvertex");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetVertex = (PLib3MFMeshObject_GetVertexPtr) dlsym(hLibrary, "lib3mf_meshobject_getvertex");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetVertex == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetVertex = (PLib3MFMeshObject_SetVertexPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setvertex");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetVertex = (PLib3MFMeshObject_SetVertexPtr) dlsym(hLibrary, "lib3mf_meshobject_setvertex");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetVertex == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_AddVertex = (PLib3MFMeshObject_AddVertexPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_addvertex");
	#else // _WIN32
	pWrapperTable->m_MeshObject_AddVertex = (PLib3MFMeshObject_AddVertexPtr) dlsym(hLibrary, "lib3mf_meshobject_addvertex");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_AddVertex == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetVertices = (PLib3MFMeshObject_GetVerticesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getvertices");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetVertices = (PLib3MFMeshObject_GetVerticesPtr) dlsym(hLibrary, "lib3mf_meshobject_getvertices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetVertices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetTriangle = (PLib3MFMeshObject_GetTrianglePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangle");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetTriangle = (PLib3MFMeshObject_GetTrianglePtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangle");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetTriangle == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetTriangle = (PLib3MFMeshObject_SetTrianglePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_settriangle");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetTriangle = (PLib3MFMeshObject_SetTrianglePtr) dlsym(hLibrary, "lib3mf_meshobject_settriangle");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetTriangle == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_AddTriangle = (PLib3MFMeshObject_AddTrianglePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_addtriangle");
	#else // _WIN32
	pWrapperTable->m_MeshObject_AddTriangle = (PLib3MFMeshObject_AddTrianglePtr) dlsym(hLibrary, "lib3mf_meshobject_addtriangle");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_AddTriangle == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetTriangleIndices = (PLib3MFMeshObject_GetTriangleIndicesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangleindices");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetTriangleIndices = (PLib3MFMeshObject_GetTriangleIndicesPtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangleindices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetTriangleIndices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetObjectLevelProperty = (PLib3MFMeshObject_SetObjectLevelPropertyPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setobjectlevelproperty");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetObjectLevelProperty = (PLib3MFMeshObject_SetObjectLevelPropertyPtr) dlsym(hLibrary, "lib3mf_meshobject_setobjectlevelproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetObjectLevelProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetObjectLevelProperty = (PLib3MFMeshObject_GetObjectLevelPropertyPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getobjectlevelproperty");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetObjectLevelProperty = (PLib3MFMeshObject_GetObjectLevelPropertyPtr) dlsym(hLibrary, "lib3mf_meshobject_getobjectlevelproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetObjectLevelProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetTriangleProperties = (PLib3MFMeshObject_SetTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_settriangleproperties");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetTriangleProperties = (PLib3MFMeshObject_SetTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_settriangleproperties");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetTriangleProperties == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetTriangleProperties = (PLib3MFMeshObject_GetTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_gettriangleproperties");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetTriangleProperties = (PLib3MFMeshObject_GetTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_gettriangleproperties");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetTriangleProperties == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetAllTriangleProperties = (PLib3MFMeshObject_SetAllTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setalltriangleproperties");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetAllTriangleProperties = (PLib3MFMeshObject_SetAllTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_setalltriangleproperties");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetAllTriangleProperties == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_GetAllTriangleProperties = (PLib3MFMeshObject_GetAllTrianglePropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_getalltriangleproperties");
	#else // _WIN32
	pWrapperTable->m_MeshObject_GetAllTriangleProperties = (PLib3MFMeshObject_GetAllTrianglePropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_getalltriangleproperties");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_GetAllTriangleProperties == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_ClearAllProperties = (PLib3MFMeshObject_ClearAllPropertiesPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_clearallproperties");
	#else // _WIN32
	pWrapperTable->m_MeshObject_ClearAllProperties = (PLib3MFMeshObject_ClearAllPropertiesPtr) dlsym(hLibrary, "lib3mf_meshobject_clearallproperties");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_ClearAllProperties == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_SetGeometry = (PLib3MFMeshObject_SetGeometryPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_setgeometry");
	#else // _WIN32
	pWrapperTable->m_MeshObject_SetGeometry = (PLib3MFMeshObject_SetGeometryPtr) dlsym(hLibrary, "lib3mf_meshobject_setgeometry");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_SetGeometry == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_IsManifoldAndOriented = (PLib3MFMeshObject_IsManifoldAndOrientedPtr) GetProcAddress(hLibrary, "lib3mf_meshobject_ismanifoldandoriented");
	#else // _WIN32
	pWrapperTable->m_MeshObject_IsManifoldAndOriented = (PLib3MFMeshObject_IsManifoldAndOrientedPtr) dlsym(hLibrary, "lib3mf_meshobject_ismanifoldandoriented");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_IsManifoldAndOriented == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MeshObject_BeamLattice = (PLib3MFMeshObject_BeamLatticePtr) GetProcAddress(hLibrary, "lib3mf_meshobject_beamlattice");
	#else // _WIN32
	pWrapperTable->m_MeshObject_BeamLattice = (PLib3MFMeshObject_BeamLatticePtr) dlsym(hLibrary, "lib3mf_meshobject_beamlattice");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MeshObject_BeamLattice == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetMinLength = (PLib3MFBeamLattice_GetMinLengthPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getminlength");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetMinLength = (PLib3MFBeamLattice_GetMinLengthPtr) dlsym(hLibrary, "lib3mf_beamlattice_getminlength");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetMinLength == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetMinLength = (PLib3MFBeamLattice_SetMinLengthPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setminlength");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetMinLength = (PLib3MFBeamLattice_SetMinLengthPtr) dlsym(hLibrary, "lib3mf_beamlattice_setminlength");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetMinLength == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetClipping = (PLib3MFBeamLattice_GetClippingPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getclipping");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetClipping = (PLib3MFBeamLattice_GetClippingPtr) dlsym(hLibrary, "lib3mf_beamlattice_getclipping");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetClipping == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetClipping = (PLib3MFBeamLattice_SetClippingPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setclipping");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetClipping = (PLib3MFBeamLattice_SetClippingPtr) dlsym(hLibrary, "lib3mf_beamlattice_setclipping");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetClipping == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetRepresentation = (PLib3MFBeamLattice_GetRepresentationPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getrepresentation");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetRepresentation = (PLib3MFBeamLattice_GetRepresentationPtr) dlsym(hLibrary, "lib3mf_beamlattice_getrepresentation");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetRepresentation == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetRepresentation = (PLib3MFBeamLattice_SetRepresentationPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setrepresentation");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetRepresentation = (PLib3MFBeamLattice_SetRepresentationPtr) dlsym(hLibrary, "lib3mf_beamlattice_setrepresentation");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetRepresentation == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBallOptions = (PLib3MFBeamLattice_GetBallOptionsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getballoptions");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBallOptions = (PLib3MFBeamLattice_GetBallOptionsPtr) dlsym(hLibrary, "lib3mf_beamlattice_getballoptions");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBallOptions == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetBallOptions = (PLib3MFBeamLattice_SetBallOptionsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setballoptions");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetBallOptions = (PLib3MFBeamLattice_SetBallOptionsPtr) dlsym(hLibrary, "lib3mf_beamlattice_setballoptions");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetBallOptions == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBeamCount = (PLib3MFBeamLattice_GetBeamCountPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeamcount");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBeamCount = (PLib3MFBeamLattice_GetBeamCountPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeamcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBeamCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBeam = (PLib3MFBeamLattice_GetBeamPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeam");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBeam = (PLib3MFBeamLattice_GetBeamPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeam");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBeam == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_AddBeam = (PLib3MFBeamLattice_AddBeamPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_addbeam");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_AddBeam = (PLib3MFBeamLattice_AddBeamPtr) dlsym(hLibrary, "lib3mf_beamlattice_addbeam");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_AddBeam == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetBeam = (PLib3MFBeamLattice_SetBeamPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setbeam");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetBeam = (PLib3MFBeamLattice_SetBeamPtr) dlsym(hLibrary, "lib3mf_beamlattice_setbeam");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetBeam == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetBeams = (PLib3MFBeamLattice_SetBeamsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setbeams");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetBeams = (PLib3MFBeamLattice_SetBeamsPtr) dlsym(hLibrary, "lib3mf_beamlattice_setbeams");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetBeams == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBeams = (PLib3MFBeamLattice_GetBeamsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeams");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBeams = (PLib3MFBeamLattice_GetBeamsPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeams");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBeams == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBallCount = (PLib3MFBeamLattice_GetBallCountPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getballcount");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBallCount = (PLib3MFBeamLattice_GetBallCountPtr) dlsym(hLibrary, "lib3mf_beamlattice_getballcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBallCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBall = (PLib3MFBeamLattice_GetBallPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getball");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBall = (PLib3MFBeamLattice_GetBallPtr) dlsym(hLibrary, "lib3mf_beamlattice_getball");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBall == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_AddBall = (PLib3MFBeamLattice_AddBallPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_addball");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_AddBall = (PLib3MFBeamLattice_AddBallPtr) dlsym(hLibrary, "lib3mf_beamlattice_addball");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_AddBall == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetBall = (PLib3MFBeamLattice_SetBallPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setball");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetBall = (PLib3MFBeamLattice_SetBallPtr) dlsym(hLibrary, "lib3mf_beamlattice_setball");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetBall == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_SetBalls = (PLib3MFBeamLattice_SetBallsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_setballs");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_SetBalls = (PLib3MFBeamLattice_SetBallsPtr) dlsym(hLibrary, "lib3mf_beamlattice_setballs");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_SetBalls == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBalls = (PLib3MFBeamLattice_GetBallsPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getballs");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBalls = (PLib3MFBeamLattice_GetBallsPtr) dlsym(hLibrary, "lib3mf_beamlattice_getballs");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBalls == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBeamSetCount = (PLib3MFBeamLattice_GetBeamSetCountPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeamsetcount");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBeamSetCount = (PLib3MFBeamLattice_GetBeamSetCountPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeamsetcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBeamSetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_AddBeamSet = (PLib3MFBeamLattice_AddBeamSetPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_addbeamset");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_AddBeamSet = (PLib3MFBeamLattice_AddBeamSetPtr) dlsym(hLibrary, "lib3mf_beamlattice_addbeamset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_AddBeamSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamLattice_GetBeamSet = (PLib3MFBeamLattice_GetBeamSetPtr) GetProcAddress(hLibrary, "lib3mf_beamlattice_getbeamset");
	#else // _WIN32
	pWrapperTable->m_BeamLattice_GetBeamSet = (PLib3MFBeamLattice_GetBeamSetPtr) dlsym(hLibrary, "lib3mf_beamlattice_getbeamset");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamLattice_GetBeamSet == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_GetObjectResource = (PLib3MFComponent_GetObjectResourcePtr) GetProcAddress(hLibrary, "lib3mf_component_getobjectresource");
	#else // _WIN32
	pWrapperTable->m_Component_GetObjectResource = (PLib3MFComponent_GetObjectResourcePtr) dlsym(hLibrary, "lib3mf_component_getobjectresource");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_GetObjectResource == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_GetObjectResourceID = (PLib3MFComponent_GetObjectResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_component_getobjectresourceid");
	#else // _WIN32
	pWrapperTable->m_Component_GetObjectResourceID = (PLib3MFComponent_GetObjectResourceIDPtr) dlsym(hLibrary, "lib3mf_component_getobjectresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_GetObjectResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_GetUUID = (PLib3MFComponent_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_component_getuuid");
	#else // _WIN32
	pWrapperTable->m_Component_GetUUID = (PLib3MFComponent_GetUUIDPtr) dlsym(hLibrary, "lib3mf_component_getuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_GetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_SetUUID = (PLib3MFComponent_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_component_setuuid");
	#else // _WIN32
	pWrapperTable->m_Component_SetUUID = (PLib3MFComponent_SetUUIDPtr) dlsym(hLibrary, "lib3mf_component_setuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_SetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_HasTransform = (PLib3MFComponent_HasTransformPtr) GetProcAddress(hLibrary, "lib3mf_component_hastransform");
	#else // _WIN32
	pWrapperTable->m_Component_HasTransform = (PLib3MFComponent_HasTransformPtr) dlsym(hLibrary, "lib3mf_component_hastransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_HasTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_GetTransform = (PLib3MFComponent_GetTransformPtr) GetProcAddress(hLibrary, "lib3mf_component_gettransform");
	#else // _WIN32
	pWrapperTable->m_Component_GetTransform = (PLib3MFComponent_GetTransformPtr) dlsym(hLibrary, "lib3mf_component_gettransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_GetTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Component_SetTransform = (PLib3MFComponent_SetTransformPtr) GetProcAddress(hLibrary, "lib3mf_component_settransform");
	#else // _WIN32
	pWrapperTable->m_Component_SetTransform = (PLib3MFComponent_SetTransformPtr) dlsym(hLibrary, "lib3mf_component_settransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Component_SetTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComponentsObject_AddComponent = (PLib3MFComponentsObject_AddComponentPtr) GetProcAddress(hLibrary, "lib3mf_componentsobject_addcomponent");
	#else // _WIN32
	pWrapperTable->m_ComponentsObject_AddComponent = (PLib3MFComponentsObject_AddComponentPtr) dlsym(hLibrary, "lib3mf_componentsobject_addcomponent");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComponentsObject_AddComponent == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComponentsObject_GetComponent = (PLib3MFComponentsObject_GetComponentPtr) GetProcAddress(hLibrary, "lib3mf_componentsobject_getcomponent");
	#else // _WIN32
	pWrapperTable->m_ComponentsObject_GetComponent = (PLib3MFComponentsObject_GetComponentPtr) dlsym(hLibrary, "lib3mf_componentsobject_getcomponent");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComponentsObject_GetComponent == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ComponentsObject_GetComponentCount = (PLib3MFComponentsObject_GetComponentCountPtr) GetProcAddress(hLibrary, "lib3mf_componentsobject_getcomponentcount");
	#else // _WIN32
	pWrapperTable->m_ComponentsObject_GetComponentCount = (PLib3MFComponentsObject_GetComponentCountPtr) dlsym(hLibrary, "lib3mf_componentsobject_getcomponentcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ComponentsObject_GetComponentCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_SetName = (PLib3MFBeamSet_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_beamset_setname");
	#else // _WIN32
	pWrapperTable->m_BeamSet_SetName = (PLib3MFBeamSet_SetNamePtr) dlsym(hLibrary, "lib3mf_beamset_setname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_SetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetName = (PLib3MFBeamSet_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_beamset_getname");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetName = (PLib3MFBeamSet_GetNamePtr) dlsym(hLibrary, "lib3mf_beamset_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_SetIdentifier = (PLib3MFBeamSet_SetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_beamset_setidentifier");
	#else // _WIN32
	pWrapperTable->m_BeamSet_SetIdentifier = (PLib3MFBeamSet_SetIdentifierPtr) dlsym(hLibrary, "lib3mf_beamset_setidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_SetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetIdentifier = (PLib3MFBeamSet_GetIdentifierPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getidentifier");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetIdentifier = (PLib3MFBeamSet_GetIdentifierPtr) dlsym(hLibrary, "lib3mf_beamset_getidentifier");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetIdentifier == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetReferenceCount = (PLib3MFBeamSet_GetReferenceCountPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getreferencecount");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetReferenceCount = (PLib3MFBeamSet_GetReferenceCountPtr) dlsym(hLibrary, "lib3mf_beamset_getreferencecount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetReferenceCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_SetReferences = (PLib3MFBeamSet_SetReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_setreferences");
	#else // _WIN32
	pWrapperTable->m_BeamSet_SetReferences = (PLib3MFBeamSet_SetReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_setreferences");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_SetReferences == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetReferences = (PLib3MFBeamSet_GetReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getreferences");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetReferences = (PLib3MFBeamSet_GetReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_getreferences");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetReferences == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetBallReferenceCount = (PLib3MFBeamSet_GetBallReferenceCountPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getballreferencecount");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetBallReferenceCount = (PLib3MFBeamSet_GetBallReferenceCountPtr) dlsym(hLibrary, "lib3mf_beamset_getballreferencecount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetBallReferenceCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_SetBallReferences = (PLib3MFBeamSet_SetBallReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_setballreferences");
	#else // _WIN32
	pWrapperTable->m_BeamSet_SetBallReferences = (PLib3MFBeamSet_SetBallReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_setballreferences");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_SetBallReferences == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BeamSet_GetBallReferences = (PLib3MFBeamSet_GetBallReferencesPtr) GetProcAddress(hLibrary, "lib3mf_beamset_getballreferences");
	#else // _WIN32
	pWrapperTable->m_BeamSet_GetBallReferences = (PLib3MFBeamSet_GetBallReferencesPtr) dlsym(hLibrary, "lib3mf_beamset_getballreferences");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BeamSet_GetBallReferences == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetCount = (PLib3MFBaseMaterialGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getcount");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetCount = (PLib3MFBaseMaterialGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_GetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs = (PLib3MFBaseMaterialGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getallpropertyids");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs = (PLib3MFBaseMaterialGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getallpropertyids");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_GetAllPropertyIDs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_AddMaterial = (PLib3MFBaseMaterialGroup_AddMaterialPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_addmaterial");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_AddMaterial = (PLib3MFBaseMaterialGroup_AddMaterialPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_addmaterial");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_AddMaterial == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_RemoveMaterial = (PLib3MFBaseMaterialGroup_RemoveMaterialPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_removematerial");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_RemoveMaterial = (PLib3MFBaseMaterialGroup_RemoveMaterialPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_removematerial");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_RemoveMaterial == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetName = (PLib3MFBaseMaterialGroup_GetNamePtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getname");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetName = (PLib3MFBaseMaterialGroup_GetNamePtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_GetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_SetName = (PLib3MFBaseMaterialGroup_SetNamePtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_setname");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_SetName = (PLib3MFBaseMaterialGroup_SetNamePtr) dlsym(hLibrary, "lib3mf_basematerialgroup_setname");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_SetName == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_SetDisplayColor = (PLib3MFBaseMaterialGroup_SetDisplayColorPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_setdisplaycolor");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_SetDisplayColor = (PLib3MFBaseMaterialGroup_SetDisplayColorPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_setdisplaycolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_SetDisplayColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetDisplayColor = (PLib3MFBaseMaterialGroup_GetDisplayColorPtr) GetProcAddress(hLibrary, "lib3mf_basematerialgroup_getdisplaycolor");
	#else // _WIN32
	pWrapperTable->m_BaseMaterialGroup_GetDisplayColor = (PLib3MFBaseMaterialGroup_GetDisplayColorPtr) dlsym(hLibrary, "lib3mf_basematerialgroup_getdisplaycolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BaseMaterialGroup_GetDisplayColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_GetCount = (PLib3MFColorGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_getcount");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_GetCount = (PLib3MFColorGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_colorgroup_getcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_GetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_GetAllPropertyIDs = (PLib3MFColorGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_getallpropertyids");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_GetAllPropertyIDs = (PLib3MFColorGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_colorgroup_getallpropertyids");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_GetAllPropertyIDs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_AddColor = (PLib3MFColorGroup_AddColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_addcolor");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_AddColor = (PLib3MFColorGroup_AddColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_addcolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_AddColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_RemoveColor = (PLib3MFColorGroup_RemoveColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_removecolor");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_RemoveColor = (PLib3MFColorGroup_RemoveColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_removecolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_RemoveColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_SetColor = (PLib3MFColorGroup_SetColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_setcolor");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_SetColor = (PLib3MFColorGroup_SetColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_setcolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_SetColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorGroup_GetColor = (PLib3MFColorGroup_GetColorPtr) GetProcAddress(hLibrary, "lib3mf_colorgroup_getcolor");
	#else // _WIN32
	pWrapperTable->m_ColorGroup_GetColor = (PLib3MFColorGroup_GetColorPtr) dlsym(hLibrary, "lib3mf_colorgroup_getcolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorGroup_GetColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_GetCount = (PLib3MFTexture2DGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_getcount");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_GetCount = (PLib3MFTexture2DGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_getcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_GetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs = (PLib3MFTexture2DGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_getallpropertyids");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs = (PLib3MFTexture2DGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_getallpropertyids");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_GetAllPropertyIDs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_AddTex2Coord = (PLib3MFTexture2DGroup_AddTex2CoordPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_addtex2coord");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_AddTex2Coord = (PLib3MFTexture2DGroup_AddTex2CoordPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_addtex2coord");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_AddTex2Coord == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_GetTex2Coord = (PLib3MFTexture2DGroup_GetTex2CoordPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_gettex2coord");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_GetTex2Coord = (PLib3MFTexture2DGroup_GetTex2CoordPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_gettex2coord");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_GetTex2Coord == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_RemoveTex2Coord = (PLib3MFTexture2DGroup_RemoveTex2CoordPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_removetex2coord");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_RemoveTex2Coord = (PLib3MFTexture2DGroup_RemoveTex2CoordPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_removetex2coord");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_RemoveTex2Coord == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2DGroup_GetTexture2D = (PLib3MFTexture2DGroup_GetTexture2DPtr) GetProcAddress(hLibrary, "lib3mf_texture2dgroup_gettexture2d");
	#else // _WIN32
	pWrapperTable->m_Texture2DGroup_GetTexture2D = (PLib3MFTexture2DGroup_GetTexture2DPtr) dlsym(hLibrary, "lib3mf_texture2dgroup_gettexture2d");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2DGroup_GetTexture2D == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_GetCount = (PLib3MFCompositeMaterials_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getcount");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_GetCount = (PLib3MFCompositeMaterials_GetCountPtr) dlsym(hLibrary, "lib3mf_compositematerials_getcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_GetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs = (PLib3MFCompositeMaterials_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getallpropertyids");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs = (PLib3MFCompositeMaterials_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_compositematerials_getallpropertyids");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_GetAllPropertyIDs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup = (PLib3MFCompositeMaterials_GetBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getbasematerialgroup");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup = (PLib3MFCompositeMaterials_GetBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_compositematerials_getbasematerialgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_GetBaseMaterialGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_AddComposite = (PLib3MFCompositeMaterials_AddCompositePtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_addcomposite");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_AddComposite = (PLib3MFCompositeMaterials_AddCompositePtr) dlsym(hLibrary, "lib3mf_compositematerials_addcomposite");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_AddComposite == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_RemoveComposite = (PLib3MFCompositeMaterials_RemoveCompositePtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_removecomposite");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_RemoveComposite = (PLib3MFCompositeMaterials_RemoveCompositePtr) dlsym(hLibrary, "lib3mf_compositematerials_removecomposite");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_RemoveComposite == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CompositeMaterials_GetComposite = (PLib3MFCompositeMaterials_GetCompositePtr) GetProcAddress(hLibrary, "lib3mf_compositematerials_getcomposite");
	#else // _WIN32
	pWrapperTable->m_CompositeMaterials_GetComposite = (PLib3MFCompositeMaterials_GetCompositePtr) dlsym(hLibrary, "lib3mf_compositematerials_getcomposite");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CompositeMaterials_GetComposite == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetCount = (PLib3MFMultiPropertyGroup_GetCountPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getcount");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetCount = (PLib3MFMultiPropertyGroup_GetCountPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_GetCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs = (PLib3MFMultiPropertyGroup_GetAllPropertyIDsPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getallpropertyids");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs = (PLib3MFMultiPropertyGroup_GetAllPropertyIDsPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getallpropertyids");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_GetAllPropertyIDs == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_AddMultiProperty = (PLib3MFMultiPropertyGroup_AddMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_addmultiproperty");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_AddMultiProperty = (PLib3MFMultiPropertyGroup_AddMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_addmultiproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_AddMultiProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_SetMultiProperty = (PLib3MFMultiPropertyGroup_SetMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_setmultiproperty");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_SetMultiProperty = (PLib3MFMultiPropertyGroup_SetMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_setmultiproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_SetMultiProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetMultiProperty = (PLib3MFMultiPropertyGroup_GetMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getmultiproperty");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetMultiProperty = (PLib3MFMultiPropertyGroup_GetMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getmultiproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_GetMultiProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty = (PLib3MFMultiPropertyGroup_RemoveMultiPropertyPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_removemultiproperty");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty = (PLib3MFMultiPropertyGroup_RemoveMultiPropertyPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_removemultiproperty");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_RemoveMultiProperty == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetLayerCount = (PLib3MFMultiPropertyGroup_GetLayerCountPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getlayercount");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetLayerCount = (PLib3MFMultiPropertyGroup_GetLayerCountPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getlayercount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_GetLayerCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_AddLayer = (PLib3MFMultiPropertyGroup_AddLayerPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_addlayer");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_AddLayer = (PLib3MFMultiPropertyGroup_AddLayerPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_addlayer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_AddLayer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetLayer = (PLib3MFMultiPropertyGroup_GetLayerPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_getlayer");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_GetLayer = (PLib3MFMultiPropertyGroup_GetLayerPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_getlayer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_GetLayer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_MultiPropertyGroup_RemoveLayer = (PLib3MFMultiPropertyGroup_RemoveLayerPtr) GetProcAddress(hLibrary, "lib3mf_multipropertygroup_removelayer");
	#else // _WIN32
	pWrapperTable->m_MultiPropertyGroup_RemoveLayer = (PLib3MFMultiPropertyGroup_RemoveLayerPtr) dlsym(hLibrary, "lib3mf_multipropertygroup_removelayer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_MultiPropertyGroup_RemoveLayer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_GetPath = (PLib3MFAttachment_GetPathPtr) GetProcAddress(hLibrary, "lib3mf_attachment_getpath");
	#else // _WIN32
	pWrapperTable->m_Attachment_GetPath = (PLib3MFAttachment_GetPathPtr) dlsym(hLibrary, "lib3mf_attachment_getpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_GetPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_SetPath = (PLib3MFAttachment_SetPathPtr) GetProcAddress(hLibrary, "lib3mf_attachment_setpath");
	#else // _WIN32
	pWrapperTable->m_Attachment_SetPath = (PLib3MFAttachment_SetPathPtr) dlsym(hLibrary, "lib3mf_attachment_setpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_SetPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_PackagePart = (PLib3MFAttachment_PackagePartPtr) GetProcAddress(hLibrary, "lib3mf_attachment_packagepart");
	#else // _WIN32
	pWrapperTable->m_Attachment_PackagePart = (PLib3MFAttachment_PackagePartPtr) dlsym(hLibrary, "lib3mf_attachment_packagepart");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_PackagePart == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_GetRelationShipType = (PLib3MFAttachment_GetRelationShipTypePtr) GetProcAddress(hLibrary, "lib3mf_attachment_getrelationshiptype");
	#else // _WIN32
	pWrapperTable->m_Attachment_GetRelationShipType = (PLib3MFAttachment_GetRelationShipTypePtr) dlsym(hLibrary, "lib3mf_attachment_getrelationshiptype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_GetRelationShipType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_SetRelationShipType = (PLib3MFAttachment_SetRelationShipTypePtr) GetProcAddress(hLibrary, "lib3mf_attachment_setrelationshiptype");
	#else // _WIN32
	pWrapperTable->m_Attachment_SetRelationShipType = (PLib3MFAttachment_SetRelationShipTypePtr) dlsym(hLibrary, "lib3mf_attachment_setrelationshiptype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_SetRelationShipType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_WriteToFile = (PLib3MFAttachment_WriteToFilePtr) GetProcAddress(hLibrary, "lib3mf_attachment_writetofile");
	#else // _WIN32
	pWrapperTable->m_Attachment_WriteToFile = (PLib3MFAttachment_WriteToFilePtr) dlsym(hLibrary, "lib3mf_attachment_writetofile");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_WriteToFile == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_ReadFromFile = (PLib3MFAttachment_ReadFromFilePtr) GetProcAddress(hLibrary, "lib3mf_attachment_readfromfile");
	#else // _WIN32
	pWrapperTable->m_Attachment_ReadFromFile = (PLib3MFAttachment_ReadFromFilePtr) dlsym(hLibrary, "lib3mf_attachment_readfromfile");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_ReadFromFile == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_ReadFromCallback = (PLib3MFAttachment_ReadFromCallbackPtr) GetProcAddress(hLibrary, "lib3mf_attachment_readfromcallback");
	#else // _WIN32
	pWrapperTable->m_Attachment_ReadFromCallback = (PLib3MFAttachment_ReadFromCallbackPtr) dlsym(hLibrary, "lib3mf_attachment_readfromcallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_ReadFromCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_GetStreamSize = (PLib3MFAttachment_GetStreamSizePtr) GetProcAddress(hLibrary, "lib3mf_attachment_getstreamsize");
	#else // _WIN32
	pWrapperTable->m_Attachment_GetStreamSize = (PLib3MFAttachment_GetStreamSizePtr) dlsym(hLibrary, "lib3mf_attachment_getstreamsize");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_GetStreamSize == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_WriteToBuffer = (PLib3MFAttachment_WriteToBufferPtr) GetProcAddress(hLibrary, "lib3mf_attachment_writetobuffer");
	#else // _WIN32
	pWrapperTable->m_Attachment_WriteToBuffer = (PLib3MFAttachment_WriteToBufferPtr) dlsym(hLibrary, "lib3mf_attachment_writetobuffer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_WriteToBuffer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Attachment_ReadFromBuffer = (PLib3MFAttachment_ReadFromBufferPtr) GetProcAddress(hLibrary, "lib3mf_attachment_readfrombuffer");
	#else // _WIN32
	pWrapperTable->m_Attachment_ReadFromBuffer = (PLib3MFAttachment_ReadFromBufferPtr) dlsym(hLibrary, "lib3mf_attachment_readfrombuffer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Attachment_ReadFromBuffer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_GetAttachment = (PLib3MFTexture2D_GetAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_getattachment");
	#else // _WIN32
	pWrapperTable->m_Texture2D_GetAttachment = (PLib3MFTexture2D_GetAttachmentPtr) dlsym(hLibrary, "lib3mf_texture2d_getattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_GetAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_SetAttachment = (PLib3MFTexture2D_SetAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_setattachment");
	#else // _WIN32
	pWrapperTable->m_Texture2D_SetAttachment = (PLib3MFTexture2D_SetAttachmentPtr) dlsym(hLibrary, "lib3mf_texture2d_setattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_SetAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_GetContentType = (PLib3MFTexture2D_GetContentTypePtr) GetProcAddress(hLibrary, "lib3mf_texture2d_getcontenttype");
	#else // _WIN32
	pWrapperTable->m_Texture2D_GetContentType = (PLib3MFTexture2D_GetContentTypePtr) dlsym(hLibrary, "lib3mf_texture2d_getcontenttype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_GetContentType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_SetContentType = (PLib3MFTexture2D_SetContentTypePtr) GetProcAddress(hLibrary, "lib3mf_texture2d_setcontenttype");
	#else // _WIN32
	pWrapperTable->m_Texture2D_SetContentType = (PLib3MFTexture2D_SetContentTypePtr) dlsym(hLibrary, "lib3mf_texture2d_setcontenttype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_SetContentType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_GetTileStyleUV = (PLib3MFTexture2D_GetTileStyleUVPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_gettilestyleuv");
	#else // _WIN32
	pWrapperTable->m_Texture2D_GetTileStyleUV = (PLib3MFTexture2D_GetTileStyleUVPtr) dlsym(hLibrary, "lib3mf_texture2d_gettilestyleuv");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_GetTileStyleUV == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_SetTileStyleUV = (PLib3MFTexture2D_SetTileStyleUVPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_settilestyleuv");
	#else // _WIN32
	pWrapperTable->m_Texture2D_SetTileStyleUV = (PLib3MFTexture2D_SetTileStyleUVPtr) dlsym(hLibrary, "lib3mf_texture2d_settilestyleuv");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_SetTileStyleUV == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_GetFilter = (PLib3MFTexture2D_GetFilterPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_getfilter");
	#else // _WIN32
	pWrapperTable->m_Texture2D_GetFilter = (PLib3MFTexture2D_GetFilterPtr) dlsym(hLibrary, "lib3mf_texture2d_getfilter");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_GetFilter == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Texture2D_SetFilter = (PLib3MFTexture2D_SetFilterPtr) GetProcAddress(hLibrary, "lib3mf_texture2d_setfilter");
	#else // _WIN32
	pWrapperTable->m_Texture2D_SetFilter = (PLib3MFTexture2D_SetFilterPtr) dlsym(hLibrary, "lib3mf_texture2d_setfilter");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Texture2D_SetFilter == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetObjectResource = (PLib3MFBuildItem_GetObjectResourcePtr) GetProcAddress(hLibrary, "lib3mf_builditem_getobjectresource");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetObjectResource = (PLib3MFBuildItem_GetObjectResourcePtr) dlsym(hLibrary, "lib3mf_builditem_getobjectresource");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetObjectResource == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetUUID = (PLib3MFBuildItem_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getuuid");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetUUID = (PLib3MFBuildItem_GetUUIDPtr) dlsym(hLibrary, "lib3mf_builditem_getuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_SetUUID = (PLib3MFBuildItem_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_builditem_setuuid");
	#else // _WIN32
	pWrapperTable->m_BuildItem_SetUUID = (PLib3MFBuildItem_SetUUIDPtr) dlsym(hLibrary, "lib3mf_builditem_setuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_SetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetObjectResourceID = (PLib3MFBuildItem_GetObjectResourceIDPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getobjectresourceid");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetObjectResourceID = (PLib3MFBuildItem_GetObjectResourceIDPtr) dlsym(hLibrary, "lib3mf_builditem_getobjectresourceid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetObjectResourceID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_HasObjectTransform = (PLib3MFBuildItem_HasObjectTransformPtr) GetProcAddress(hLibrary, "lib3mf_builditem_hasobjecttransform");
	#else // _WIN32
	pWrapperTable->m_BuildItem_HasObjectTransform = (PLib3MFBuildItem_HasObjectTransformPtr) dlsym(hLibrary, "lib3mf_builditem_hasobjecttransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_HasObjectTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetObjectTransform = (PLib3MFBuildItem_GetObjectTransformPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getobjecttransform");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetObjectTransform = (PLib3MFBuildItem_GetObjectTransformPtr) dlsym(hLibrary, "lib3mf_builditem_getobjecttransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetObjectTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_SetObjectTransform = (PLib3MFBuildItem_SetObjectTransformPtr) GetProcAddress(hLibrary, "lib3mf_builditem_setobjecttransform");
	#else // _WIN32
	pWrapperTable->m_BuildItem_SetObjectTransform = (PLib3MFBuildItem_SetObjectTransformPtr) dlsym(hLibrary, "lib3mf_builditem_setobjecttransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_SetObjectTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetPartNumber = (PLib3MFBuildItem_GetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getpartnumber");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetPartNumber = (PLib3MFBuildItem_GetPartNumberPtr) dlsym(hLibrary, "lib3mf_builditem_getpartnumber");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetPartNumber == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_SetPartNumber = (PLib3MFBuildItem_SetPartNumberPtr) GetProcAddress(hLibrary, "lib3mf_builditem_setpartnumber");
	#else // _WIN32
	pWrapperTable->m_BuildItem_SetPartNumber = (PLib3MFBuildItem_SetPartNumberPtr) dlsym(hLibrary, "lib3mf_builditem_setpartnumber");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_SetPartNumber == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetMetaDataGroup = (PLib3MFBuildItem_GetMetaDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getmetadatagroup");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetMetaDataGroup = (PLib3MFBuildItem_GetMetaDataGroupPtr) dlsym(hLibrary, "lib3mf_builditem_getmetadatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetMetaDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItem_GetOutbox = (PLib3MFBuildItem_GetOutboxPtr) GetProcAddress(hLibrary, "lib3mf_builditem_getoutbox");
	#else // _WIN32
	pWrapperTable->m_BuildItem_GetOutbox = (PLib3MFBuildItem_GetOutboxPtr) dlsym(hLibrary, "lib3mf_builditem_getoutbox");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItem_GetOutbox == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItemIterator_MoveNext = (PLib3MFBuildItemIterator_MoveNextPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_movenext");
	#else // _WIN32
	pWrapperTable->m_BuildItemIterator_MoveNext = (PLib3MFBuildItemIterator_MoveNextPtr) dlsym(hLibrary, "lib3mf_builditemiterator_movenext");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItemIterator_MoveNext == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItemIterator_MovePrevious = (PLib3MFBuildItemIterator_MovePreviousPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_moveprevious");
	#else // _WIN32
	pWrapperTable->m_BuildItemIterator_MovePrevious = (PLib3MFBuildItemIterator_MovePreviousPtr) dlsym(hLibrary, "lib3mf_builditemiterator_moveprevious");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItemIterator_MovePrevious == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItemIterator_GetCurrent = (PLib3MFBuildItemIterator_GetCurrentPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_getcurrent");
	#else // _WIN32
	pWrapperTable->m_BuildItemIterator_GetCurrent = (PLib3MFBuildItemIterator_GetCurrentPtr) dlsym(hLibrary, "lib3mf_builditemiterator_getcurrent");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItemIterator_GetCurrent == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItemIterator_Clone = (PLib3MFBuildItemIterator_ClonePtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_clone");
	#else // _WIN32
	pWrapperTable->m_BuildItemIterator_Clone = (PLib3MFBuildItemIterator_ClonePtr) dlsym(hLibrary, "lib3mf_builditemiterator_clone");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItemIterator_Clone == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_BuildItemIterator_Count = (PLib3MFBuildItemIterator_CountPtr) GetProcAddress(hLibrary, "lib3mf_builditemiterator_count");
	#else // _WIN32
	pWrapperTable->m_BuildItemIterator_Count = (PLib3MFBuildItemIterator_CountPtr) dlsym(hLibrary, "lib3mf_builditemiterator_count");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_BuildItemIterator_Count == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_SetVertices = (PLib3MFSlice_SetVerticesPtr) GetProcAddress(hLibrary, "lib3mf_slice_setvertices");
	#else // _WIN32
	pWrapperTable->m_Slice_SetVertices = (PLib3MFSlice_SetVerticesPtr) dlsym(hLibrary, "lib3mf_slice_setvertices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_SetVertices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetVertices = (PLib3MFSlice_GetVerticesPtr) GetProcAddress(hLibrary, "lib3mf_slice_getvertices");
	#else // _WIN32
	pWrapperTable->m_Slice_GetVertices = (PLib3MFSlice_GetVerticesPtr) dlsym(hLibrary, "lib3mf_slice_getvertices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetVertices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetVertexCount = (PLib3MFSlice_GetVertexCountPtr) GetProcAddress(hLibrary, "lib3mf_slice_getvertexcount");
	#else // _WIN32
	pWrapperTable->m_Slice_GetVertexCount = (PLib3MFSlice_GetVertexCountPtr) dlsym(hLibrary, "lib3mf_slice_getvertexcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetVertexCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_AddPolygon = (PLib3MFSlice_AddPolygonPtr) GetProcAddress(hLibrary, "lib3mf_slice_addpolygon");
	#else // _WIN32
	pWrapperTable->m_Slice_AddPolygon = (PLib3MFSlice_AddPolygonPtr) dlsym(hLibrary, "lib3mf_slice_addpolygon");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_AddPolygon == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetPolygonCount = (PLib3MFSlice_GetPolygonCountPtr) GetProcAddress(hLibrary, "lib3mf_slice_getpolygoncount");
	#else // _WIN32
	pWrapperTable->m_Slice_GetPolygonCount = (PLib3MFSlice_GetPolygonCountPtr) dlsym(hLibrary, "lib3mf_slice_getpolygoncount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetPolygonCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_SetPolygonIndices = (PLib3MFSlice_SetPolygonIndicesPtr) GetProcAddress(hLibrary, "lib3mf_slice_setpolygonindices");
	#else // _WIN32
	pWrapperTable->m_Slice_SetPolygonIndices = (PLib3MFSlice_SetPolygonIndicesPtr) dlsym(hLibrary, "lib3mf_slice_setpolygonindices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_SetPolygonIndices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetPolygonIndices = (PLib3MFSlice_GetPolygonIndicesPtr) GetProcAddress(hLibrary, "lib3mf_slice_getpolygonindices");
	#else // _WIN32
	pWrapperTable->m_Slice_GetPolygonIndices = (PLib3MFSlice_GetPolygonIndicesPtr) dlsym(hLibrary, "lib3mf_slice_getpolygonindices");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetPolygonIndices == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetPolygonIndexCount = (PLib3MFSlice_GetPolygonIndexCountPtr) GetProcAddress(hLibrary, "lib3mf_slice_getpolygonindexcount");
	#else // _WIN32
	pWrapperTable->m_Slice_GetPolygonIndexCount = (PLib3MFSlice_GetPolygonIndexCountPtr) dlsym(hLibrary, "lib3mf_slice_getpolygonindexcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetPolygonIndexCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Slice_GetZTop = (PLib3MFSlice_GetZTopPtr) GetProcAddress(hLibrary, "lib3mf_slice_getztop");
	#else // _WIN32
	pWrapperTable->m_Slice_GetZTop = (PLib3MFSlice_GetZTopPtr) dlsym(hLibrary, "lib3mf_slice_getztop");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Slice_GetZTop == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetBottomZ = (PLib3MFSliceStack_GetBottomZPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getbottomz");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetBottomZ = (PLib3MFSliceStack_GetBottomZPtr) dlsym(hLibrary, "lib3mf_slicestack_getbottomz");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetBottomZ == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetSliceCount = (PLib3MFSliceStack_GetSliceCountPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslicecount");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetSliceCount = (PLib3MFSliceStack_GetSliceCountPtr) dlsym(hLibrary, "lib3mf_slicestack_getslicecount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetSliceCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetSlice = (PLib3MFSliceStack_GetSlicePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslice");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetSlice = (PLib3MFSliceStack_GetSlicePtr) dlsym(hLibrary, "lib3mf_slicestack_getslice");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetSlice == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_AddSlice = (PLib3MFSliceStack_AddSlicePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_addslice");
	#else // _WIN32
	pWrapperTable->m_SliceStack_AddSlice = (PLib3MFSliceStack_AddSlicePtr) dlsym(hLibrary, "lib3mf_slicestack_addslice");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_AddSlice == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetSliceRefCount = (PLib3MFSliceStack_GetSliceRefCountPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslicerefcount");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetSliceRefCount = (PLib3MFSliceStack_GetSliceRefCountPtr) dlsym(hLibrary, "lib3mf_slicestack_getslicerefcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetSliceRefCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_AddSliceStackReference = (PLib3MFSliceStack_AddSliceStackReferencePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_addslicestackreference");
	#else // _WIN32
	pWrapperTable->m_SliceStack_AddSliceStackReference = (PLib3MFSliceStack_AddSliceStackReferencePtr) dlsym(hLibrary, "lib3mf_slicestack_addslicestackreference");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_AddSliceStackReference == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetSliceStackReference = (PLib3MFSliceStack_GetSliceStackReferencePtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getslicestackreference");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetSliceStackReference = (PLib3MFSliceStack_GetSliceStackReferencePtr) dlsym(hLibrary, "lib3mf_slicestack_getslicestackreference");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetSliceStackReference == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_CollapseSliceReferences = (PLib3MFSliceStack_CollapseSliceReferencesPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_collapseslicereferences");
	#else // _WIN32
	pWrapperTable->m_SliceStack_CollapseSliceReferences = (PLib3MFSliceStack_CollapseSliceReferencesPtr) dlsym(hLibrary, "lib3mf_slicestack_collapseslicereferences");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_CollapseSliceReferences == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_SetOwnPath = (PLib3MFSliceStack_SetOwnPathPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_setownpath");
	#else // _WIN32
	pWrapperTable->m_SliceStack_SetOwnPath = (PLib3MFSliceStack_SetOwnPathPtr) dlsym(hLibrary, "lib3mf_slicestack_setownpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_SetOwnPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SliceStack_GetOwnPath = (PLib3MFSliceStack_GetOwnPathPtr) GetProcAddress(hLibrary, "lib3mf_slicestack_getownpath");
	#else // _WIN32
	pWrapperTable->m_SliceStack_GetOwnPath = (PLib3MFSliceStack_GetOwnPathPtr) dlsym(hLibrary, "lib3mf_slicestack_getownpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SliceStack_GetOwnPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Consumer_GetConsumerID = (PLib3MFConsumer_GetConsumerIDPtr) GetProcAddress(hLibrary, "lib3mf_consumer_getconsumerid");
	#else // _WIN32
	pWrapperTable->m_Consumer_GetConsumerID = (PLib3MFConsumer_GetConsumerIDPtr) dlsym(hLibrary, "lib3mf_consumer_getconsumerid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Consumer_GetConsumerID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Consumer_GetKeyID = (PLib3MFConsumer_GetKeyIDPtr) GetProcAddress(hLibrary, "lib3mf_consumer_getkeyid");
	#else // _WIN32
	pWrapperTable->m_Consumer_GetKeyID = (PLib3MFConsumer_GetKeyIDPtr) dlsym(hLibrary, "lib3mf_consumer_getkeyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Consumer_GetKeyID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Consumer_GetKeyValue = (PLib3MFConsumer_GetKeyValuePtr) GetProcAddress(hLibrary, "lib3mf_consumer_getkeyvalue");
	#else // _WIN32
	pWrapperTable->m_Consumer_GetKeyValue = (PLib3MFConsumer_GetKeyValuePtr) dlsym(hLibrary, "lib3mf_consumer_getkeyvalue");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Consumer_GetKeyValue == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_AccessRight_GetConsumer = (PLib3MFAccessRight_GetConsumerPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getconsumer");
	#else // _WIN32
	pWrapperTable->m_AccessRight_GetConsumer = (PLib3MFAccessRight_GetConsumerPtr) dlsym(hLibrary, "lib3mf_accessright_getconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_AccessRight_GetConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_AccessRight_GetWrappingAlgorithm = (PLib3MFAccessRight_GetWrappingAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getwrappingalgorithm");
	#else // _WIN32
	pWrapperTable->m_AccessRight_GetWrappingAlgorithm = (PLib3MFAccessRight_GetWrappingAlgorithmPtr) dlsym(hLibrary, "lib3mf_accessright_getwrappingalgorithm");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_AccessRight_GetWrappingAlgorithm == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_AccessRight_GetMgfAlgorithm = (PLib3MFAccessRight_GetMgfAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getmgfalgorithm");
	#else // _WIN32
	pWrapperTable->m_AccessRight_GetMgfAlgorithm = (PLib3MFAccessRight_GetMgfAlgorithmPtr) dlsym(hLibrary, "lib3mf_accessright_getmgfalgorithm");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_AccessRight_GetMgfAlgorithm == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_AccessRight_GetDigestMethod = (PLib3MFAccessRight_GetDigestMethodPtr) GetProcAddress(hLibrary, "lib3mf_accessright_getdigestmethod");
	#else // _WIN32
	pWrapperTable->m_AccessRight_GetDigestMethod = (PLib3MFAccessRight_GetDigestMethodPtr) dlsym(hLibrary, "lib3mf_accessright_getdigestmethod");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_AccessRight_GetDigestMethod == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm = (PLib3MFContentEncryptionParams_GetEncryptionAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getencryptionalgorithm");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm = (PLib3MFContentEncryptionParams_GetEncryptionAlgorithmPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getencryptionalgorithm");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetEncryptionAlgorithm == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetKey = (PLib3MFContentEncryptionParams_GetKeyPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getkey");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetKey = (PLib3MFContentEncryptionParams_GetKeyPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getkey");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetKey == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetInitializationVector = (PLib3MFContentEncryptionParams_GetInitializationVectorPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getinitializationvector");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetInitializationVector = (PLib3MFContentEncryptionParams_GetInitializationVectorPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getinitializationvector");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetInitializationVector == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag = (PLib3MFContentEncryptionParams_GetAuthenticationTagPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getauthenticationtag");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag = (PLib3MFContentEncryptionParams_GetAuthenticationTagPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getauthenticationtag");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetAuthenticationTag == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag = (PLib3MFContentEncryptionParams_SetAuthenticationTagPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_setauthenticationtag");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag = (PLib3MFContentEncryptionParams_SetAuthenticationTagPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_setauthenticationtag");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_SetAuthenticationTag == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData = (PLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getadditionalauthenticationdata");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData = (PLib3MFContentEncryptionParams_GetAdditionalAuthenticationDataPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getadditionalauthenticationdata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetAdditionalAuthenticationData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetDescriptor = (PLib3MFContentEncryptionParams_GetDescriptorPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getdescriptor");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetDescriptor = (PLib3MFContentEncryptionParams_GetDescriptorPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getdescriptor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetDescriptor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetKeyUUID = (PLib3MFContentEncryptionParams_GetKeyUUIDPtr) GetProcAddress(hLibrary, "lib3mf_contentencryptionparams_getkeyuuid");
	#else // _WIN32
	pWrapperTable->m_ContentEncryptionParams_GetKeyUUID = (PLib3MFContentEncryptionParams_GetKeyUUIDPtr) dlsym(hLibrary, "lib3mf_contentencryptionparams_getkeyuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ContentEncryptionParams_GetKeyUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceData_GetPath = (PLib3MFResourceData_GetPathPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getpath");
	#else // _WIN32
	pWrapperTable->m_ResourceData_GetPath = (PLib3MFResourceData_GetPathPtr) dlsym(hLibrary, "lib3mf_resourcedata_getpath");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceData_GetPath == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceData_GetEncryptionAlgorithm = (PLib3MFResourceData_GetEncryptionAlgorithmPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getencryptionalgorithm");
	#else // _WIN32
	pWrapperTable->m_ResourceData_GetEncryptionAlgorithm = (PLib3MFResourceData_GetEncryptionAlgorithmPtr) dlsym(hLibrary, "lib3mf_resourcedata_getencryptionalgorithm");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceData_GetEncryptionAlgorithm == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceData_GetCompression = (PLib3MFResourceData_GetCompressionPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getcompression");
	#else // _WIN32
	pWrapperTable->m_ResourceData_GetCompression = (PLib3MFResourceData_GetCompressionPtr) dlsym(hLibrary, "lib3mf_resourcedata_getcompression");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceData_GetCompression == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData = (PLib3MFResourceData_GetAdditionalAuthenticationDataPtr) GetProcAddress(hLibrary, "lib3mf_resourcedata_getadditionalauthenticationdata");
	#else // _WIN32
	pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData = (PLib3MFResourceData_GetAdditionalAuthenticationDataPtr) dlsym(hLibrary, "lib3mf_resourcedata_getadditionalauthenticationdata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceData_GetAdditionalAuthenticationData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceDataGroup_GetKeyUUID = (PLib3MFResourceDataGroup_GetKeyUUIDPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_getkeyuuid");
	#else // _WIN32
	pWrapperTable->m_ResourceDataGroup_GetKeyUUID = (PLib3MFResourceDataGroup_GetKeyUUIDPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_getkeyuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceDataGroup_GetKeyUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceDataGroup_AddAccessRight = (PLib3MFResourceDataGroup_AddAccessRightPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_addaccessright");
	#else // _WIN32
	pWrapperTable->m_ResourceDataGroup_AddAccessRight = (PLib3MFResourceDataGroup_AddAccessRightPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_addaccessright");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceDataGroup_AddAccessRight == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer = (PLib3MFResourceDataGroup_FindAccessRightByConsumerPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_findaccessrightbyconsumer");
	#else // _WIN32
	pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer = (PLib3MFResourceDataGroup_FindAccessRightByConsumerPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_findaccessrightbyconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceDataGroup_FindAccessRightByConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ResourceDataGroup_RemoveAccessRight = (PLib3MFResourceDataGroup_RemoveAccessRightPtr) GetProcAddress(hLibrary, "lib3mf_resourcedatagroup_removeaccessright");
	#else // _WIN32
	pWrapperTable->m_ResourceDataGroup_RemoveAccessRight = (PLib3MFResourceDataGroup_RemoveAccessRightPtr) dlsym(hLibrary, "lib3mf_resourcedatagroup_removeaccessright");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ResourceDataGroup_RemoveAccessRight == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_AddConsumer = (PLib3MFKeyStore_AddConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_addconsumer");
	#else // _WIN32
	pWrapperTable->m_KeyStore_AddConsumer = (PLib3MFKeyStore_AddConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_addconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_AddConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetConsumerCount = (PLib3MFKeyStore_GetConsumerCountPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getconsumercount");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetConsumerCount = (PLib3MFKeyStore_GetConsumerCountPtr) dlsym(hLibrary, "lib3mf_keystore_getconsumercount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetConsumerCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetConsumer = (PLib3MFKeyStore_GetConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getconsumer");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetConsumer = (PLib3MFKeyStore_GetConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_getconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_RemoveConsumer = (PLib3MFKeyStore_RemoveConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_removeconsumer");
	#else // _WIN32
	pWrapperTable->m_KeyStore_RemoveConsumer = (PLib3MFKeyStore_RemoveConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_removeconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_RemoveConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_FindConsumer = (PLib3MFKeyStore_FindConsumerPtr) GetProcAddress(hLibrary, "lib3mf_keystore_findconsumer");
	#else // _WIN32
	pWrapperTable->m_KeyStore_FindConsumer = (PLib3MFKeyStore_FindConsumerPtr) dlsym(hLibrary, "lib3mf_keystore_findconsumer");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_FindConsumer == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataGroupCount = (PLib3MFKeyStore_GetResourceDataGroupCountPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedatagroupcount");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataGroupCount = (PLib3MFKeyStore_GetResourceDataGroupCountPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedatagroupcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetResourceDataGroupCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_AddResourceDataGroup = (PLib3MFKeyStore_AddResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_addresourcedatagroup");
	#else // _WIN32
	pWrapperTable->m_KeyStore_AddResourceDataGroup = (PLib3MFKeyStore_AddResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_addresourcedatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_AddResourceDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataGroup = (PLib3MFKeyStore_GetResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedatagroup");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataGroup = (PLib3MFKeyStore_GetResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetResourceDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_RemoveResourceDataGroup = (PLib3MFKeyStore_RemoveResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_removeresourcedatagroup");
	#else // _WIN32
	pWrapperTable->m_KeyStore_RemoveResourceDataGroup = (PLib3MFKeyStore_RemoveResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_removeresourcedatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_RemoveResourceDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_FindResourceDataGroup = (PLib3MFKeyStore_FindResourceDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_keystore_findresourcedatagroup");
	#else // _WIN32
	pWrapperTable->m_KeyStore_FindResourceDataGroup = (PLib3MFKeyStore_FindResourceDataGroupPtr) dlsym(hLibrary, "lib3mf_keystore_findresourcedatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_FindResourceDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_AddResourceData = (PLib3MFKeyStore_AddResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_addresourcedata");
	#else // _WIN32
	pWrapperTable->m_KeyStore_AddResourceData = (PLib3MFKeyStore_AddResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_addresourcedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_AddResourceData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_RemoveResourceData = (PLib3MFKeyStore_RemoveResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_removeresourcedata");
	#else // _WIN32
	pWrapperTable->m_KeyStore_RemoveResourceData = (PLib3MFKeyStore_RemoveResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_removeresourcedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_RemoveResourceData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_FindResourceData = (PLib3MFKeyStore_FindResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_findresourcedata");
	#else // _WIN32
	pWrapperTable->m_KeyStore_FindResourceData = (PLib3MFKeyStore_FindResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_findresourcedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_FindResourceData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataCount = (PLib3MFKeyStore_GetResourceDataCountPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedatacount");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetResourceDataCount = (PLib3MFKeyStore_GetResourceDataCountPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedatacount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetResourceDataCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetResourceData = (PLib3MFKeyStore_GetResourceDataPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getresourcedata");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetResourceData = (PLib3MFKeyStore_GetResourceDataPtr) dlsym(hLibrary, "lib3mf_keystore_getresourcedata");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetResourceData == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_GetUUID = (PLib3MFKeyStore_GetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_keystore_getuuid");
	#else // _WIN32
	pWrapperTable->m_KeyStore_GetUUID = (PLib3MFKeyStore_GetUUIDPtr) dlsym(hLibrary, "lib3mf_keystore_getuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_GetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_KeyStore_SetUUID = (PLib3MFKeyStore_SetUUIDPtr) GetProcAddress(hLibrary, "lib3mf_keystore_setuuid");
	#else // _WIN32
	pWrapperTable->m_KeyStore_SetUUID = (PLib3MFKeyStore_SetUUIDPtr) dlsym(hLibrary, "lib3mf_keystore_setuuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_KeyStore_SetUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RootModelPart = (PLib3MFModel_RootModelPartPtr) GetProcAddress(hLibrary, "lib3mf_model_rootmodelpart");
	#else // _WIN32
	pWrapperTable->m_Model_RootModelPart = (PLib3MFModel_RootModelPartPtr) dlsym(hLibrary, "lib3mf_model_rootmodelpart");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RootModelPart == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_FindOrCreatePackagePart = (PLib3MFModel_FindOrCreatePackagePartPtr) GetProcAddress(hLibrary, "lib3mf_model_findorcreatepackagepart");
	#else // _WIN32
	pWrapperTable->m_Model_FindOrCreatePackagePart = (PLib3MFModel_FindOrCreatePackagePartPtr) dlsym(hLibrary, "lib3mf_model_findorcreatepackagepart");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_FindOrCreatePackagePart == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_SetUnit = (PLib3MFModel_SetUnitPtr) GetProcAddress(hLibrary, "lib3mf_model_setunit");
	#else // _WIN32
	pWrapperTable->m_Model_SetUnit = (PLib3MFModel_SetUnitPtr) dlsym(hLibrary, "lib3mf_model_setunit");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_SetUnit == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetUnit = (PLib3MFModel_GetUnitPtr) GetProcAddress(hLibrary, "lib3mf_model_getunit");
	#else // _WIN32
	pWrapperTable->m_Model_GetUnit = (PLib3MFModel_GetUnitPtr) dlsym(hLibrary, "lib3mf_model_getunit");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetUnit == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetLanguage = (PLib3MFModel_GetLanguagePtr) GetProcAddress(hLibrary, "lib3mf_model_getlanguage");
	#else // _WIN32
	pWrapperTable->m_Model_GetLanguage = (PLib3MFModel_GetLanguagePtr) dlsym(hLibrary, "lib3mf_model_getlanguage");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetLanguage == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_SetLanguage = (PLib3MFModel_SetLanguagePtr) GetProcAddress(hLibrary, "lib3mf_model_setlanguage");
	#else // _WIN32
	pWrapperTable->m_Model_SetLanguage = (PLib3MFModel_SetLanguagePtr) dlsym(hLibrary, "lib3mf_model_setlanguage");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_SetLanguage == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_QueryWriter = (PLib3MFModel_QueryWriterPtr) GetProcAddress(hLibrary, "lib3mf_model_querywriter");
	#else // _WIN32
	pWrapperTable->m_Model_QueryWriter = (PLib3MFModel_QueryWriterPtr) dlsym(hLibrary, "lib3mf_model_querywriter");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_QueryWriter == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_QueryReader = (PLib3MFModel_QueryReaderPtr) GetProcAddress(hLibrary, "lib3mf_model_queryreader");
	#else // _WIN32
	pWrapperTable->m_Model_QueryReader = (PLib3MFModel_QueryReaderPtr) dlsym(hLibrary, "lib3mf_model_queryreader");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_QueryReader == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetResourceByID = (PLib3MFModel_GetResourceByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getresourcebyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetResourceByID = (PLib3MFModel_GetResourceByIDPtr) dlsym(hLibrary, "lib3mf_model_getresourcebyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetResourceByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetTexture2DByID = (PLib3MFModel_GetTexture2DByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2dbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetTexture2DByID = (PLib3MFModel_GetTexture2DByIDPtr) dlsym(hLibrary, "lib3mf_model_gettexture2dbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetTexture2DByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetPropertyTypeByID = (PLib3MFModel_GetPropertyTypeByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getpropertytypebyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetPropertyTypeByID = (PLib3MFModel_GetPropertyTypeByIDPtr) dlsym(hLibrary, "lib3mf_model_getpropertytypebyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetPropertyTypeByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetBaseMaterialGroupByID = (PLib3MFModel_GetBaseMaterialGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getbasematerialgroupbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetBaseMaterialGroupByID = (PLib3MFModel_GetBaseMaterialGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_getbasematerialgroupbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetBaseMaterialGroupByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetTexture2DGroupByID = (PLib3MFModel_GetTexture2DGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2dgroupbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetTexture2DGroupByID = (PLib3MFModel_GetTexture2DGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_gettexture2dgroupbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetTexture2DGroupByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetCompositeMaterialsByID = (PLib3MFModel_GetCompositeMaterialsByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getcompositematerialsbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetCompositeMaterialsByID = (PLib3MFModel_GetCompositeMaterialsByIDPtr) dlsym(hLibrary, "lib3mf_model_getcompositematerialsbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetCompositeMaterialsByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetMultiPropertyGroupByID = (PLib3MFModel_GetMultiPropertyGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getmultipropertygroupbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetMultiPropertyGroupByID = (PLib3MFModel_GetMultiPropertyGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_getmultipropertygroupbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetMultiPropertyGroupByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetMeshObjectByID = (PLib3MFModel_GetMeshObjectByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getmeshobjectbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetMeshObjectByID = (PLib3MFModel_GetMeshObjectByIDPtr) dlsym(hLibrary, "lib3mf_model_getmeshobjectbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetMeshObjectByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetComponentsObjectByID = (PLib3MFModel_GetComponentsObjectByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getcomponentsobjectbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetComponentsObjectByID = (PLib3MFModel_GetComponentsObjectByIDPtr) dlsym(hLibrary, "lib3mf_model_getcomponentsobjectbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetComponentsObjectByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetColorGroupByID = (PLib3MFModel_GetColorGroupByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getcolorgroupbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetColorGroupByID = (PLib3MFModel_GetColorGroupByIDPtr) dlsym(hLibrary, "lib3mf_model_getcolorgroupbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetColorGroupByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetSliceStackByID = (PLib3MFModel_GetSliceStackByIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getslicestackbyid");
	#else // _WIN32
	pWrapperTable->m_Model_GetSliceStackByID = (PLib3MFModel_GetSliceStackByIDPtr) dlsym(hLibrary, "lib3mf_model_getslicestackbyid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetSliceStackByID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetBuildUUID = (PLib3MFModel_GetBuildUUIDPtr) GetProcAddress(hLibrary, "lib3mf_model_getbuilduuid");
	#else // _WIN32
	pWrapperTable->m_Model_GetBuildUUID = (PLib3MFModel_GetBuildUUIDPtr) dlsym(hLibrary, "lib3mf_model_getbuilduuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetBuildUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_SetBuildUUID = (PLib3MFModel_SetBuildUUIDPtr) GetProcAddress(hLibrary, "lib3mf_model_setbuilduuid");
	#else // _WIN32
	pWrapperTable->m_Model_SetBuildUUID = (PLib3MFModel_SetBuildUUIDPtr) dlsym(hLibrary, "lib3mf_model_setbuilduuid");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_SetBuildUUID == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetBuildItems = (PLib3MFModel_GetBuildItemsPtr) GetProcAddress(hLibrary, "lib3mf_model_getbuilditems");
	#else // _WIN32
	pWrapperTable->m_Model_GetBuildItems = (PLib3MFModel_GetBuildItemsPtr) dlsym(hLibrary, "lib3mf_model_getbuilditems");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetBuildItems == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetOutbox = (PLib3MFModel_GetOutboxPtr) GetProcAddress(hLibrary, "lib3mf_model_getoutbox");
	#else // _WIN32
	pWrapperTable->m_Model_GetOutbox = (PLib3MFModel_GetOutboxPtr) dlsym(hLibrary, "lib3mf_model_getoutbox");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetOutbox == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetResources = (PLib3MFModel_GetResourcesPtr) GetProcAddress(hLibrary, "lib3mf_model_getresources");
	#else // _WIN32
	pWrapperTable->m_Model_GetResources = (PLib3MFModel_GetResourcesPtr) dlsym(hLibrary, "lib3mf_model_getresources");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetResources == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetObjects = (PLib3MFModel_GetObjectsPtr) GetProcAddress(hLibrary, "lib3mf_model_getobjects");
	#else // _WIN32
	pWrapperTable->m_Model_GetObjects = (PLib3MFModel_GetObjectsPtr) dlsym(hLibrary, "lib3mf_model_getobjects");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetObjects == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetMeshObjects = (PLib3MFModel_GetMeshObjectsPtr) GetProcAddress(hLibrary, "lib3mf_model_getmeshobjects");
	#else // _WIN32
	pWrapperTable->m_Model_GetMeshObjects = (PLib3MFModel_GetMeshObjectsPtr) dlsym(hLibrary, "lib3mf_model_getmeshobjects");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetMeshObjects == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetComponentsObjects = (PLib3MFModel_GetComponentsObjectsPtr) GetProcAddress(hLibrary, "lib3mf_model_getcomponentsobjects");
	#else // _WIN32
	pWrapperTable->m_Model_GetComponentsObjects = (PLib3MFModel_GetComponentsObjectsPtr) dlsym(hLibrary, "lib3mf_model_getcomponentsobjects");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetComponentsObjects == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetTexture2Ds = (PLib3MFModel_GetTexture2DsPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2ds");
	#else // _WIN32
	pWrapperTable->m_Model_GetTexture2Ds = (PLib3MFModel_GetTexture2DsPtr) dlsym(hLibrary, "lib3mf_model_gettexture2ds");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetTexture2Ds == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetBaseMaterialGroups = (PLib3MFModel_GetBaseMaterialGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_getbasematerialgroups");
	#else // _WIN32
	pWrapperTable->m_Model_GetBaseMaterialGroups = (PLib3MFModel_GetBaseMaterialGroupsPtr) dlsym(hLibrary, "lib3mf_model_getbasematerialgroups");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetBaseMaterialGroups == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetColorGroups = (PLib3MFModel_GetColorGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_getcolorgroups");
	#else // _WIN32
	pWrapperTable->m_Model_GetColorGroups = (PLib3MFModel_GetColorGroupsPtr) dlsym(hLibrary, "lib3mf_model_getcolorgroups");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetColorGroups == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetTexture2DGroups = (PLib3MFModel_GetTexture2DGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_gettexture2dgroups");
	#else // _WIN32
	pWrapperTable->m_Model_GetTexture2DGroups = (PLib3MFModel_GetTexture2DGroupsPtr) dlsym(hLibrary, "lib3mf_model_gettexture2dgroups");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetTexture2DGroups == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetCompositeMaterials = (PLib3MFModel_GetCompositeMaterialsPtr) GetProcAddress(hLibrary, "lib3mf_model_getcompositematerials");
	#else // _WIN32
	pWrapperTable->m_Model_GetCompositeMaterials = (PLib3MFModel_GetCompositeMaterialsPtr) dlsym(hLibrary, "lib3mf_model_getcompositematerials");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetCompositeMaterials == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetMultiPropertyGroups = (PLib3MFModel_GetMultiPropertyGroupsPtr) GetProcAddress(hLibrary, "lib3mf_model_getmultipropertygroups");
	#else // _WIN32
	pWrapperTable->m_Model_GetMultiPropertyGroups = (PLib3MFModel_GetMultiPropertyGroupsPtr) dlsym(hLibrary, "lib3mf_model_getmultipropertygroups");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetMultiPropertyGroups == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetSliceStacks = (PLib3MFModel_GetSliceStacksPtr) GetProcAddress(hLibrary, "lib3mf_model_getslicestacks");
	#else // _WIN32
	pWrapperTable->m_Model_GetSliceStacks = (PLib3MFModel_GetSliceStacksPtr) dlsym(hLibrary, "lib3mf_model_getslicestacks");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetSliceStacks == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_MergeToModel = (PLib3MFModel_MergeToModelPtr) GetProcAddress(hLibrary, "lib3mf_model_mergetomodel");
	#else // _WIN32
	pWrapperTable->m_Model_MergeToModel = (PLib3MFModel_MergeToModelPtr) dlsym(hLibrary, "lib3mf_model_mergetomodel");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_MergeToModel == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddMeshObject = (PLib3MFModel_AddMeshObjectPtr) GetProcAddress(hLibrary, "lib3mf_model_addmeshobject");
	#else // _WIN32
	pWrapperTable->m_Model_AddMeshObject = (PLib3MFModel_AddMeshObjectPtr) dlsym(hLibrary, "lib3mf_model_addmeshobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddMeshObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddComponentsObject = (PLib3MFModel_AddComponentsObjectPtr) GetProcAddress(hLibrary, "lib3mf_model_addcomponentsobject");
	#else // _WIN32
	pWrapperTable->m_Model_AddComponentsObject = (PLib3MFModel_AddComponentsObjectPtr) dlsym(hLibrary, "lib3mf_model_addcomponentsobject");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddComponentsObject == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddSliceStack = (PLib3MFModel_AddSliceStackPtr) GetProcAddress(hLibrary, "lib3mf_model_addslicestack");
	#else // _WIN32
	pWrapperTable->m_Model_AddSliceStack = (PLib3MFModel_AddSliceStackPtr) dlsym(hLibrary, "lib3mf_model_addslicestack");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddSliceStack == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddTexture2DFromAttachment = (PLib3MFModel_AddTexture2DFromAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_addtexture2dfromattachment");
	#else // _WIN32
	pWrapperTable->m_Model_AddTexture2DFromAttachment = (PLib3MFModel_AddTexture2DFromAttachmentPtr) dlsym(hLibrary, "lib3mf_model_addtexture2dfromattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddTexture2DFromAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddBaseMaterialGroup = (PLib3MFModel_AddBaseMaterialGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addbasematerialgroup");
	#else // _WIN32
	pWrapperTable->m_Model_AddBaseMaterialGroup = (PLib3MFModel_AddBaseMaterialGroupPtr) dlsym(hLibrary, "lib3mf_model_addbasematerialgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddBaseMaterialGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddColorGroup = (PLib3MFModel_AddColorGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addcolorgroup");
	#else // _WIN32
	pWrapperTable->m_Model_AddColorGroup = (PLib3MFModel_AddColorGroupPtr) dlsym(hLibrary, "lib3mf_model_addcolorgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddColorGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddTexture2DGroup = (PLib3MFModel_AddTexture2DGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addtexture2dgroup");
	#else // _WIN32
	pWrapperTable->m_Model_AddTexture2DGroup = (PLib3MFModel_AddTexture2DGroupPtr) dlsym(hLibrary, "lib3mf_model_addtexture2dgroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddTexture2DGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddCompositeMaterials = (PLib3MFModel_AddCompositeMaterialsPtr) GetProcAddress(hLibrary, "lib3mf_model_addcompositematerials");
	#else // _WIN32
	pWrapperTable->m_Model_AddCompositeMaterials = (PLib3MFModel_AddCompositeMaterialsPtr) dlsym(hLibrary, "lib3mf_model_addcompositematerials");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddCompositeMaterials == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddMultiPropertyGroup = (PLib3MFModel_AddMultiPropertyGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_addmultipropertygroup");
	#else // _WIN32
	pWrapperTable->m_Model_AddMultiPropertyGroup = (PLib3MFModel_AddMultiPropertyGroupPtr) dlsym(hLibrary, "lib3mf_model_addmultipropertygroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddMultiPropertyGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddBuildItem = (PLib3MFModel_AddBuildItemPtr) GetProcAddress(hLibrary, "lib3mf_model_addbuilditem");
	#else // _WIN32
	pWrapperTable->m_Model_AddBuildItem = (PLib3MFModel_AddBuildItemPtr) dlsym(hLibrary, "lib3mf_model_addbuilditem");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddBuildItem == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RemoveBuildItem = (PLib3MFModel_RemoveBuildItemPtr) GetProcAddress(hLibrary, "lib3mf_model_removebuilditem");
	#else // _WIN32
	pWrapperTable->m_Model_RemoveBuildItem = (PLib3MFModel_RemoveBuildItemPtr) dlsym(hLibrary, "lib3mf_model_removebuilditem");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RemoveBuildItem == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetMetaDataGroup = (PLib3MFModel_GetMetaDataGroupPtr) GetProcAddress(hLibrary, "lib3mf_model_getmetadatagroup");
	#else // _WIN32
	pWrapperTable->m_Model_GetMetaDataGroup = (PLib3MFModel_GetMetaDataGroupPtr) dlsym(hLibrary, "lib3mf_model_getmetadatagroup");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetMetaDataGroup == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddAttachment = (PLib3MFModel_AddAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_addattachment");
	#else // _WIN32
	pWrapperTable->m_Model_AddAttachment = (PLib3MFModel_AddAttachmentPtr) dlsym(hLibrary, "lib3mf_model_addattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RemoveAttachment = (PLib3MFModel_RemoveAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_removeattachment");
	#else // _WIN32
	pWrapperTable->m_Model_RemoveAttachment = (PLib3MFModel_RemoveAttachmentPtr) dlsym(hLibrary, "lib3mf_model_removeattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RemoveAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetAttachment = (PLib3MFModel_GetAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_getattachment");
	#else // _WIN32
	pWrapperTable->m_Model_GetAttachment = (PLib3MFModel_GetAttachmentPtr) dlsym(hLibrary, "lib3mf_model_getattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_FindAttachment = (PLib3MFModel_FindAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_findattachment");
	#else // _WIN32
	pWrapperTable->m_Model_FindAttachment = (PLib3MFModel_FindAttachmentPtr) dlsym(hLibrary, "lib3mf_model_findattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_FindAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetAttachmentCount = (PLib3MFModel_GetAttachmentCountPtr) GetProcAddress(hLibrary, "lib3mf_model_getattachmentcount");
	#else // _WIN32
	pWrapperTable->m_Model_GetAttachmentCount = (PLib3MFModel_GetAttachmentCountPtr) dlsym(hLibrary, "lib3mf_model_getattachmentcount");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetAttachmentCount == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_HasPackageThumbnailAttachment = (PLib3MFModel_HasPackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_haspackagethumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Model_HasPackageThumbnailAttachment = (PLib3MFModel_HasPackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_haspackagethumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_HasPackageThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_CreatePackageThumbnailAttachment = (PLib3MFModel_CreatePackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_createpackagethumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Model_CreatePackageThumbnailAttachment = (PLib3MFModel_CreatePackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_createpackagethumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_CreatePackageThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetPackageThumbnailAttachment = (PLib3MFModel_GetPackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_getpackagethumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Model_GetPackageThumbnailAttachment = (PLib3MFModel_GetPackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_getpackagethumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetPackageThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RemovePackageThumbnailAttachment = (PLib3MFModel_RemovePackageThumbnailAttachmentPtr) GetProcAddress(hLibrary, "lib3mf_model_removepackagethumbnailattachment");
	#else // _WIN32
	pWrapperTable->m_Model_RemovePackageThumbnailAttachment = (PLib3MFModel_RemovePackageThumbnailAttachmentPtr) dlsym(hLibrary, "lib3mf_model_removepackagethumbnailattachment");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RemovePackageThumbnailAttachment == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_AddCustomContentType = (PLib3MFModel_AddCustomContentTypePtr) GetProcAddress(hLibrary, "lib3mf_model_addcustomcontenttype");
	#else // _WIN32
	pWrapperTable->m_Model_AddCustomContentType = (PLib3MFModel_AddCustomContentTypePtr) dlsym(hLibrary, "lib3mf_model_addcustomcontenttype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_AddCustomContentType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_RemoveCustomContentType = (PLib3MFModel_RemoveCustomContentTypePtr) GetProcAddress(hLibrary, "lib3mf_model_removecustomcontenttype");
	#else // _WIN32
	pWrapperTable->m_Model_RemoveCustomContentType = (PLib3MFModel_RemoveCustomContentTypePtr) dlsym(hLibrary, "lib3mf_model_removecustomcontenttype");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_RemoveCustomContentType == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_SetRandomNumberCallback = (PLib3MFModel_SetRandomNumberCallbackPtr) GetProcAddress(hLibrary, "lib3mf_model_setrandomnumbercallback");
	#else // _WIN32
	pWrapperTable->m_Model_SetRandomNumberCallback = (PLib3MFModel_SetRandomNumberCallbackPtr) dlsym(hLibrary, "lib3mf_model_setrandomnumbercallback");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_SetRandomNumberCallback == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Model_GetKeyStore = (PLib3MFModel_GetKeyStorePtr) GetProcAddress(hLibrary, "lib3mf_model_getkeystore");
	#else // _WIN32
	pWrapperTable->m_Model_GetKeyStore = (PLib3MFModel_GetKeyStorePtr) dlsym(hLibrary, "lib3mf_model_getkeystore");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Model_GetKeyStore == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetLibraryVersion = (PLib3MFGetLibraryVersionPtr) GetProcAddress(hLibrary, "lib3mf_getlibraryversion");
	#else // _WIN32
	pWrapperTable->m_GetLibraryVersion = (PLib3MFGetLibraryVersionPtr) dlsym(hLibrary, "lib3mf_getlibraryversion");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetLibraryVersion == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetPrereleaseInformation = (PLib3MFGetPrereleaseInformationPtr) GetProcAddress(hLibrary, "lib3mf_getprereleaseinformation");
	#else // _WIN32
	pWrapperTable->m_GetPrereleaseInformation = (PLib3MFGetPrereleaseInformationPtr) dlsym(hLibrary, "lib3mf_getprereleaseinformation");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetPrereleaseInformation == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetBuildInformation = (PLib3MFGetBuildInformationPtr) GetProcAddress(hLibrary, "lib3mf_getbuildinformation");
	#else // _WIN32
	pWrapperTable->m_GetBuildInformation = (PLib3MFGetBuildInformationPtr) dlsym(hLibrary, "lib3mf_getbuildinformation");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetBuildInformation == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetSpecificationVersion = (PLib3MFGetSpecificationVersionPtr) GetProcAddress(hLibrary, "lib3mf_getspecificationversion");
	#else // _WIN32
	pWrapperTable->m_GetSpecificationVersion = (PLib3MFGetSpecificationVersionPtr) dlsym(hLibrary, "lib3mf_getspecificationversion");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetSpecificationVersion == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_CreateModel = (PLib3MFCreateModelPtr) GetProcAddress(hLibrary, "lib3mf_createmodel");
	#else // _WIN32
	pWrapperTable->m_CreateModel = (PLib3MFCreateModelPtr) dlsym(hLibrary, "lib3mf_createmodel");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_CreateModel == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Release = (PLib3MFReleasePtr) GetProcAddress(hLibrary, "lib3mf_release");
	#else // _WIN32
	pWrapperTable->m_Release = (PLib3MFReleasePtr) dlsym(hLibrary, "lib3mf_release");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Release == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_Acquire = (PLib3MFAcquirePtr) GetProcAddress(hLibrary, "lib3mf_acquire");
	#else // _WIN32
	pWrapperTable->m_Acquire = (PLib3MFAcquirePtr) dlsym(hLibrary, "lib3mf_acquire");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_Acquire == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_SetJournal = (PLib3MFSetJournalPtr) GetProcAddress(hLibrary, "lib3mf_setjournal");
	#else // _WIN32
	pWrapperTable->m_SetJournal = (PLib3MFSetJournalPtr) dlsym(hLibrary, "lib3mf_setjournal");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_SetJournal == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetLastError = (PLib3MFGetLastErrorPtr) GetProcAddress(hLibrary, "lib3mf_getlasterror");
	#else // _WIN32
	pWrapperTable->m_GetLastError = (PLib3MFGetLastErrorPtr) dlsym(hLibrary, "lib3mf_getlasterror");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetLastError == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetSymbolLookupMethod = (PLib3MFGetSymbolLookupMethodPtr) GetProcAddress(hLibrary, "lib3mf_getsymbollookupmethod");
	#else // _WIN32
	pWrapperTable->m_GetSymbolLookupMethod = (PLib3MFGetSymbolLookupMethodPtr) dlsym(hLibrary, "lib3mf_getsymbollookupmethod");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetSymbolLookupMethod == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_RetrieveProgressMessage = (PLib3MFRetrieveProgressMessagePtr) GetProcAddress(hLibrary, "lib3mf_retrieveprogressmessage");
	#else // _WIN32
	pWrapperTable->m_RetrieveProgressMessage = (PLib3MFRetrieveProgressMessagePtr) dlsym(hLibrary, "lib3mf_retrieveprogressmessage");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_RetrieveProgressMessage == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_RGBAToColor = (PLib3MFRGBAToColorPtr) GetProcAddress(hLibrary, "lib3mf_rgbatocolor");
	#else // _WIN32
	pWrapperTable->m_RGBAToColor = (PLib3MFRGBAToColorPtr) dlsym(hLibrary, "lib3mf_rgbatocolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_RGBAToColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_FloatRGBAToColor = (PLib3MFFloatRGBAToColorPtr) GetProcAddress(hLibrary, "lib3mf_floatrgbatocolor");
	#else // _WIN32
	pWrapperTable->m_FloatRGBAToColor = (PLib3MFFloatRGBAToColorPtr) dlsym(hLibrary, "lib3mf_floatrgbatocolor");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_FloatRGBAToColor == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorToRGBA = (PLib3MFColorToRGBAPtr) GetProcAddress(hLibrary, "lib3mf_colortorgba");
	#else // _WIN32
	pWrapperTable->m_ColorToRGBA = (PLib3MFColorToRGBAPtr) dlsym(hLibrary, "lib3mf_colortorgba");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorToRGBA == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_ColorToFloatRGBA = (PLib3MFColorToFloatRGBAPtr) GetProcAddress(hLibrary, "lib3mf_colortofloatrgba");
	#else // _WIN32
	pWrapperTable->m_ColorToFloatRGBA = (PLib3MFColorToFloatRGBAPtr) dlsym(hLibrary, "lib3mf_colortofloatrgba");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_ColorToFloatRGBA == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetIdentityTransform = (PLib3MFGetIdentityTransformPtr) GetProcAddress(hLibrary, "lib3mf_getidentitytransform");
	#else // _WIN32
	pWrapperTable->m_GetIdentityTransform = (PLib3MFGetIdentityTransformPtr) dlsym(hLibrary, "lib3mf_getidentitytransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetIdentityTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetUniformScaleTransform = (PLib3MFGetUniformScaleTransformPtr) GetProcAddress(hLibrary, "lib3mf_getuniformscaletransform");
	#else // _WIN32
	pWrapperTable->m_GetUniformScaleTransform = (PLib3MFGetUniformScaleTransformPtr) dlsym(hLibrary, "lib3mf_getuniformscaletransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetUniformScaleTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetScaleTransform = (PLib3MFGetScaleTransformPtr) GetProcAddress(hLibrary, "lib3mf_getscaletransform");
	#else // _WIN32
	pWrapperTable->m_GetScaleTransform = (PLib3MFGetScaleTransformPtr) dlsym(hLibrary, "lib3mf_getscaletransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetScaleTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	#ifdef _WIN32
	pWrapperTable->m_GetTranslationTransform = (PLib3MFGetTranslationTransformPtr) GetProcAddress(hLibrary, "lib3mf_gettranslationtransform");
	#else // _WIN32
	pWrapperTable->m_GetTranslationTransform = (PLib3MFGetTranslationTransformPtr) dlsym(hLibrary, "lib3mf_gettranslationtransform");
	dlerror();
	#endif // _WIN32
	if (pWrapperTable->m_GetTranslationTransform == NULL)
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	
	pWrapperTable->m_LibraryHandle = hLibrary;
	return LIB3MF_SUCCESS;
}

