/*
** ###################################################################
**     Processors:          MCXN947VDF_cm33_core0
**                          MCXN947VNL_cm33_core0
**
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    MCXNx4x Reference Manual
**     Version:             rev. 2.0, 2023-02-01
**     Build:               b240116
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MCXN947_cm33_core0
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2024 NXP
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2022-10-01)
**         Initial version
**     - rev. 2.0 (2023-02-01)
**         Initial version based on Rev. 2 Draft B
**
** ###################################################################
*/

/*!
 * @file MCXN947_cm33_core0.h
 * @version 2.0
 * @date 2023-02-01
 * @brief CMSIS Peripheral Access Layer for MCXN947_cm33_core0
 *
 * CMSIS Peripheral Access Layer for MCXN947_cm33_core0
 */

#if !defined(MCXN947_CM33_CORE0_H_)
#define MCXN947_CM33_CORE0_H_                    /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0200U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 172                /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M33 SV Hard Fault Interrupt */
  MemoryManagement_IRQn        = -12,              /**< Cortex-M33 Memory Management Interrupt */
  BusFault_IRQn                = -11,              /**< Cortex-M33 Bus Fault Interrupt */
  UsageFault_IRQn              = -10,              /**< Cortex-M33 Usage Fault Interrupt */
  SecureFault_IRQn             = -9,               /**< Cortex-M33 Secure Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M33 SV Call Interrupt */
  DebugMonitor_IRQn            = -4,               /**< Cortex-M33 Debug Monitor Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M33 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M33 System Tick Interrupt */

  /* Device specific interrupts */
  OR_IRQn                      = 0,                /**< OR IRQ */
  EDMA_0_CH0_IRQn              = 1,                /**< eDMA_0_CH0 error or transfer complete */
  EDMA_0_CH1_IRQn              = 2,                /**< eDMA_0_CH1 error or transfer complete */
  EDMA_0_CH2_IRQn              = 3,                /**< eDMA_0_CH2 error or transfer complete */
  EDMA_0_CH3_IRQn              = 4,                /**< eDMA_0_CH3 error or transfer complete */
  EDMA_0_CH4_IRQn              = 5,                /**< eDMA_0_CH4 error or transfer complete */
  EDMA_0_CH5_IRQn              = 6,                /**< eDMA_0_CH5 error or transfer complete */
  EDMA_0_CH6_IRQn              = 7,                /**< eDMA_0_CH6 error or transfer complete */
  EDMA_0_CH7_IRQn              = 8,                /**< eDMA_0_CH7 error or transfer complete */
  EDMA_0_CH8_IRQn              = 9,                /**< eDMA_0_CH8 error or transfer complete */
  EDMA_0_CH9_IRQn              = 10,               /**< eDMA_0_CH9 error or transfer complete */
  EDMA_0_CH10_IRQn             = 11,               /**< eDMA_0_CH10 error or transfer complete */
  EDMA_0_CH11_IRQn             = 12,               /**< eDMA_0_CH11 error or transfer complete */
  EDMA_0_CH12_IRQn             = 13,               /**< eDMA_0_CH12 error or transfer complete */
  EDMA_0_CH13_IRQn             = 14,               /**< eDMA_0_CH13 error or transfer complete */
  EDMA_0_CH14_IRQn             = 15,               /**< eDMA_0_CH14 error or transfer complete */
  EDMA_0_CH15_IRQn             = 16,               /**< eDMA_0_CH15 error or transfer complete */
  GPIO00_IRQn                  = 17,               /**< GPIO0 interrupt 0 */
  GPIO01_IRQn                  = 18,               /**< GPIO0 interrupt 1 */
  GPIO10_IRQn                  = 19,               /**< GPIO1 interrupt 0 */
  GPIO11_IRQn                  = 20,               /**< GPIO1 interrupt 1 */
  GPIO20_IRQn                  = 21,               /**< GPIO2 interrupt 0 */
  GPIO21_IRQn                  = 22,               /**< GPIO2 interrupt 1 */
  GPIO30_IRQn                  = 23,               /**< GPIO3 interrupt 0 */
  GPIO31_IRQn                  = 24,               /**< GPIO3 interrupt 1 */
  GPIO40_IRQn                  = 25,               /**< GPIO4 interrupt 0 */
  GPIO41_IRQn                  = 26,               /**< GPIO4 interrupt 1 */
  GPIO50_IRQn                  = 27,               /**< GPIO5 interrupt 0 */
  GPIO51_IRQn                  = 28,               /**< GPIO5 interrupt 1 */
  UTICK0_IRQn                  = 29,               /**< Micro-Tick Timer interrupt */
  MRT0_IRQn                    = 30,               /**< Multi-Rate Timer interrupt */
  CTIMER0_IRQn                 = 31,               /**< Standard counter/timer 0 interrupt */
  CTIMER1_IRQn                 = 32,               /**< Standard counter/timer 1 interrupt */
  SCT0_IRQn                    = 33,               /**< SCTimer/PWM interrupt */
  CTIMER2_IRQn                 = 34,               /**< Standard counter/timer 2 interrupt */
  LP_FLEXCOMM0_IRQn            = 35,               /**< LP_FLEXCOMM0 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM1_IRQn            = 36,               /**< LP_FLEXCOMM1 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM2_IRQn            = 37,               /**< LP_FLEXCOMM2 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM3_IRQn            = 38,               /**< LP_FLEXCOMM3 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM4_IRQn            = 39,               /**< LP_FLEXCOMM4 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM5_IRQn            = 40,               /**< LP_FLEXCOMM5 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM6_IRQn            = 41,               /**< LP_FLEXCOMM6 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM7_IRQn            = 42,               /**< LP_FLEXCOMM7 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM8_IRQn            = 43,               /**< LP_FLEXCOMM8 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  LP_FLEXCOMM9_IRQn            = 44,               /**< LP_FLEXCOMM9 (LPSPI interrupt or LPI2C interrupt or LPUART Receive/Transmit interrupt) */
  ADC0_IRQn                    = 45,               /**< Analog-to-Digital Converter 0 - General Purpose interrupt */
  ADC1_IRQn                    = 46,               /**< Analog-to-Digital Converter 1 - General Purpose interrupt */
  PINT0_IRQn                   = 47,               /**< Pin Interrupt Pattern Match Interrupt */
  PDM_EVENT_IRQn               = 48,               /**< Microphone Interface interrupt */
  Reserved65_IRQn              = 49,               /**< Reserved interrupt */
  USB0_FS_IRQn                 = 50,               /**< Universal Serial Bus - Full Speed interrupt */
  USB0_DCD_IRQn                = 51,               /**< Universal Serial Bus - Device Charge Detect interrupt */
  RTC_IRQn                     = 52,               /**< RTC Subsystem interrupt (RTC interrupt or Wake timer interrupt) */
  SMARTDMA_IRQn                = 53,               /**< SmartDMA_IRQ */
  MAILBOX_IRQn                 = 54,               /**< Inter-CPU Mailbox interrupt0 for CPU0 Inter-CPU Mailbox interrupt1 for CPU1 */
  CTIMER3_IRQn                 = 55,               /**< Standard counter/timer 3 interrupt */
  CTIMER4_IRQn                 = 56,               /**< Standard counter/timer 4 interrupt */
  OS_EVENT_IRQn                = 57,               /**< OS event timer interrupt */
  FLEXSPI0_IRQn                = 58,               /**< Flexible Serial Peripheral Interface interrupt */
  SAI0_IRQn                    = 59,               /**< Serial Audio Interface 0 interrupt */
  SAI1_IRQn                    = 60,               /**< Serial Audio Interface 1 interrupt */
  USDHC0_IRQn                  = 61,               /**< Ultra Secured Digital Host Controller interrupt */
  CAN0_IRQn                    = 62,               /**< Controller Area Network 0 interrupt */
  CAN1_IRQn                    = 63,               /**< Controller Area Network 1 interrupt */
  Reserved80_IRQn              = 64,               /**< Reserved interrupt */
  Reserved81_IRQn              = 65,               /**< Reserved interrupt */
  USB1_HS_PHY_IRQn             = 66,               /**< USBHS DCD or USBHS Phy interrupt */
  USB1_HS_IRQn                 = 67,               /**< USB High Speed OTG Controller interrupt  */
  SEC_HYPERVISOR_CALL_IRQn     = 68,               /**< AHB Secure Controller hypervisor call interrupt */
  Reserved85_IRQn              = 69,               /**< Reserved interrupt */
  PLU_IRQn                     = 70,               /**< Programmable Logic Unit interrupt */
  Freqme_IRQn                  = 71,               /**< Frequency Measurement interrupt */
  SEC_VIO_IRQn                 = 72,               /**< Secure violation interrupt (Memory Block Checker interrupt or secure AHB matrix violation interrupt) */
  ELS_IRQn                     = 73,               /**< ELS interrupt */
  PKC_IRQn                     = 74,               /**< PKC interrupt */
  PUF_IRQn                     = 75,               /**< Physical Unclonable Function interrupt */
  PQ_IRQn                      = 76,               /**< Power Quad interrupt */
  EDMA_1_CH0_IRQn              = 77,               /**< eDMA_1_CH0 error or transfer complete */
  EDMA_1_CH1_IRQn              = 78,               /**< eDMA_1_CH1 error or transfer complete */
  EDMA_1_CH2_IRQn              = 79,               /**< eDMA_1_CH2 error or transfer complete */
  EDMA_1_CH3_IRQn              = 80,               /**< eDMA_1_CH3 error or transfer complete */
  EDMA_1_CH4_IRQn              = 81,               /**< eDMA_1_CH4 error or transfer complete */
  EDMA_1_CH5_IRQn              = 82,               /**< eDMA_1_CH5 error or transfer complete */
  EDMA_1_CH6_IRQn              = 83,               /**< eDMA_1_CH6 error or transfer complete */
  EDMA_1_CH7_IRQn              = 84,               /**< eDMA_1_CH7 error or transfer complete */
  EDMA_1_CH8_IRQn              = 85,               /**< eDMA_1_CH8 error or transfer complete */
  EDMA_1_CH9_IRQn              = 86,               /**< eDMA_1_CH9 error or transfer complete */
  EDMA_1_CH10_IRQn             = 87,               /**< eDMA_1_CH10 error or transfer complete */
  EDMA_1_CH11_IRQn             = 88,               /**< eDMA_1_CH11 error or transfer complete */
  EDMA_1_CH12_IRQn             = 89,               /**< eDMA_1_CH12 error or transfer complete */
  EDMA_1_CH13_IRQn             = 90,               /**< eDMA_1_CH13 error or transfer complete */
  EDMA_1_CH14_IRQn             = 91,               /**< eDMA_1_CH14 error or transfer complete */
  EDMA_1_CH15_IRQn             = 92,               /**< eDMA_1_CH15 error or transfer complete */
  CDOG0_IRQn                   = 93,               /**< Code Watchdog Timer 0 interrupt */
  CDOG1_IRQn                   = 94,               /**< Code Watchdog Timer 1 interrupt */
  I3C0_IRQn                    = 95,               /**< Improved Inter Integrated Circuit interrupt 0 */
  I3C1_IRQn                    = 96,               /**< Improved Inter Integrated Circuit interrupt 1 */
  NPU_IRQn                     = 97,               /**< NPU interrupt */
  GDET_IRQn                    = 98,               /**< Digital Glitch Detect 0 interrupt  or Digital Glitch Detect 1 interrupt */
  VBAT0_IRQn                   = 99,               /**< VBAT interrupt( VBAT interrupt or digital tamper interrupt) */
  EWM0_IRQn                    = 100,              /**< External Watchdog Monitor interrupt */
  TSI_END_OF_SCAN_IRQn         = 101,              /**< TSI End of Scan interrupt */
  TSI_OUT_OF_SCAN_IRQn         = 102,              /**< TSI Out of Scan interrupt */
  EMVSIM0_IRQn                 = 103,              /**< EMVSIM0 interrupt */
  EMVSIM1_IRQn                 = 104,              /**< EMVSIM1 interrupt */
  FLEXIO_IRQn                  = 105,              /**< Flexible Input/Output interrupt */
  DAC0_IRQn                    = 106,              /**< Digital-to-Analog Converter 0 - General Purpose interrupt */
  DAC1_IRQn                    = 107,              /**< Digital-to-Analog Converter 1 - General Purpose interrupt */
  DAC2_IRQn                    = 108,              /**< 14-bit Digital-to-Analog Converter interrupt */
  HSCMP0_IRQn                  = 109,              /**< High-Speed comparator0 interrupt */
  HSCMP1_IRQn                  = 110,              /**< High-Speed comparator1 interrupt */
  HSCMP2_IRQn                  = 111,              /**< High-Speed comparator2 interrupt */
  FLEXPWM0_RELOAD_ERROR_IRQn   = 112,              /**< FlexPWM0_reload_error interrupt */
  FLEXPWM0_FAULT_IRQn          = 113,              /**< FlexPWM0_fault interrupt */
  FLEXPWM0_SUBMODULE0_IRQn     = 114,              /**< FlexPWM0 Submodule 0 capture/compare/reload interrupt */
  FLEXPWM0_SUBMODULE1_IRQn     = 115,              /**< FlexPWM0 Submodule 1 capture/compare/reload interrupt */
  FLEXPWM0_SUBMODULE2_IRQn     = 116,              /**< FlexPWM0 Submodule 2 capture/compare/reload interrupt */
  FLEXPWM0_SUBMODULE3_IRQn     = 117,              /**< FlexPWM0 Submodule 3 capture/compare/reload interrupt */
  FLEXPWM1_RELOAD_ERROR_IRQn   = 118,              /**< FlexPWM1_reload_error interrupt */
  FLEXPWM1_FAULT_IRQn          = 119,              /**< FlexPWM1_fault interrupt */
  FLEXPWM1_SUBMODULE0_IRQn     = 120,              /**< FlexPWM1 Submodule 0 capture/compare/reload interrupt */
  FLEXPWM1_SUBMODULE1_IRQn     = 121,              /**< FlexPWM1 Submodule 1 capture/compare/reload interrupt */
  FLEXPWM1_SUBMODULE2_IRQn     = 122,              /**< FlexPWM1 Submodule 2 capture/compare/reload interrupt */
  FLEXPWM1_SUBMODULE3_IRQn     = 123,              /**< FlexPWM1 Submodule 3 capture/compare/reload interrupt */
  ENC0_COMPARE_IRQn            = 124,              /**< ENC0_Compare interrupt */
  ENC0_HOME_IRQn               = 125,              /**< ENC0_Home interrupt */
  ENC0_WDG_SAB_IRQn            = 126,              /**< ENC0_WDG_IRQ/SAB interrupt */
  ENC0_IDX_IRQn                = 127,              /**< ENC0_IDX interrupt */
  ENC1_COMPARE_IRQn            = 128,              /**< ENC1_Compare interrupt */
  ENC1_HOME_IRQn               = 129,              /**< ENC1_Home interrupt */
  ENC1_WDG_SAB_IRQn            = 130,              /**< ENC1_WDG_IRQ/SAB interrupt */
  ENC1_IDX_IRQn                = 131,              /**< ENC1_IDX interrupt */
  ITRC0_IRQn                   = 132,              /**< Intrusion and Tamper Response Controller interrupt */
  BSP32_IRQn                   = 133,              /**< CoolFlux BSP32 interrupt */
  ELS_ERR_IRQn                 = 134,              /**< ELS error interrupt */
  PKC_ERR_IRQn                 = 135,              /**< PKC error interrupt */
  ERM_SINGLE_BIT_ERROR_IRQn    = 136,              /**< ERM Single Bit error interrupt */
  ERM_MULTI_BIT_ERROR_IRQn     = 137,              /**< ERM Multi Bit error interrupt */
  FMU0_IRQn                    = 138,              /**< Flash Management Unit interrupt */
  ETHERNET_IRQn                = 139,              /**< Ethernet QoS interrupt */
  ETHERNET_PMT_IRQn            = 140,              /**< Ethernet QoS power management interrupt */
  ETHERNET_MACLP_IRQn          = 141,              /**< Ethernet QoS MAC interrupt */
  SINC_FILTER_IRQn             = 142,              /**< SINC Filter interrupt  */
  LPTMR0_IRQn                  = 143,              /**< Low Power Timer 0 interrupt */
  LPTMR1_IRQn                  = 144,              /**< Low Power Timer 1 interrupt */
  SCG_IRQn                     = 145,              /**< System Clock Generator interrupt */
  SPC_IRQn                     = 146,              /**< System Power Controller interrupt */
  WUU_IRQn                     = 147,              /**< Wake Up Unit interrupt */
  PORT_EFT_IRQn                = 148,              /**< PORT0~5 EFT interrupt */
  ETB0_IRQn                    = 149,              /**< ETB counter expires interrupt */
  SM3_IRQn                     = 150,              /**< Secure Generic Interface (SGI) SAFO interrupt  */
  TRNG0_IRQn                   = 151,              /**< True Random Number Generator interrupt */
  WWDT0_IRQn                   = 152,              /**< Windowed Watchdog Timer 0 interrupt */
  WWDT1_IRQn                   = 153,              /**< Windowed Watchdog Timer 1 interrupt */
  CMC0_IRQn                    = 154,              /**< Core Mode Controller interrupt */
  CTI0_IRQn                    = 155               /**< Cross Trigger Interface interrupt */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M33 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M33 Core Configuration
 * @{
 */

#define __MPU_PRESENT                  1         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               3         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT                  1         /**< Defines if an FPU is present or not */
#define __DSP_PRESENT                  1         /**< Defines if Armv8-M Mainline core supports DSP instructions */
#define __SAUREGION_PRESENT            1         /**< Defines if an SAU is present or not */

#include "core_cm33.h"                 /* Core Peripheral Access Layer */
#include "system_MCXN947_cm33_core0.h" /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup dma_request
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the DMA hardware request
 *
 * Defines the structure for the DMA hardware request collections. The user can configure the
 * hardware request to trigger the DMA transfer accordingly. The index
 * of the hardware request varies according  to the to SoC.
 */
typedef enum _dma_request_source
{
    kDma0RequestMuxFlexSpi0Rx       = 1U,          /**< FlexSPI0 Receive event */
    kDma1RequestMuxFlexSpi0Rx       = 1U,          /**< FlexSPI0 Receive event */
    kDma0RequestMuxFlexSpi0Tx       = 2U,          /**< FlexSPI0 Transmit event */
    kDma1RequestMuxFlexSpi0Tx       = 2U,          /**< FlexSPI0 Transmit event */
    kDma0RequestMuxPinInt0          = 3U,          /**< PINT0 INT0 */
    kDma1RequestMuxPinInt0          = 3U,          /**< PINT0 INT0 */
    kDma0RequestMuxPinInt1          = 4U,          /**< PINT0 INT1 */
    kDma1RequestMuxPinInt1          = 4U,          /**< PINT0 INT1 */
    kDma0RequestMuxPinInt2          = 5U,          /**< PINT0 INT2 */
    kDma1RequestMuxPinInt2          = 5U,          /**< PINT0 INT2 */
    kDma0RequestMuxPinInt3          = 6U,          /**< PINT0 INT3 */
    kDma1RequestMuxPinInt3          = 6U,          /**< PINT0 INT3 */
    kDma0RequestMuxCtimer0M0        = 7U,          /**< CTIMER0 Match channel 0 request */
    kDma1RequestMuxCtimer0M0        = 7U,          /**< CTIMER0 Match channel 0 request */
    kDma0RequestMuxCtimer0M1        = 8U,          /**< CTIMER0 Match channel 1 request */
    kDma1RequestMuxCtimer0M1        = 8U,          /**< CTIMER0 Match channel 1 request */
    kDma0RequestMuxCtimer1M0        = 9U,          /**< CTIMER1 Match channel 0 request */
    kDma1RequestMuxCtimer1M0        = 9U,          /**< CTIMER1 Match channel 0 request */
    kDma0RequestMuxCtimer1M1        = 10U,         /**< CTIMER1 Match channel 1 request */
    kDma1RequestMuxCtimer1M1        = 10U,         /**< CTIMER1 Match channel 1 request */
    kDma0RequestMuxCtimer2M0        = 11U,         /**< CTIMER2 Match channel 0 request */
    kDma1RequestMuxCtimer2M0        = 11U,         /**< CTIMER2 Match channel 0 request */
    kDma0RequestMuxCtimer2M1        = 12U,         /**< CTIMER2 Match channel 1 request */
    kDma1RequestMuxCtimer2M1        = 12U,         /**< CTIMER2 Match channel 1 request */
    kDma0RequestMuxCtimer3M0        = 13U,         /**< CTIMER3 Match channel 0 request */
    kDma1RequestMuxCtimer3M0        = 13U,         /**< CTIMER3 Match channel 0 request */
    kDma0RequestMuxCtimer3M1        = 14U,         /**< CTIMER3 Match channel 1 request */
    kDma1RequestMuxCtimer3M1        = 14U,         /**< CTIMER3 Match channel 1 request */
    kDma0RequestMuxCtimer4M0        = 15U,         /**< CTIMER4 Match channel 0 request */
    kDma1RequestMuxCtimer4M0        = 15U,         /**< CTIMER4 Match channel 0 request */
    kDma0RequestMuxCtimer4M1        = 16U,         /**< CTIMER4 Match channel 1 request */
    kDma1RequestMuxCtimer4M1        = 16U,         /**< CTIMER4 Match channel 1 request */
    kDma0RequestMuxWuu0             = 17U,         /**< WUU0 Wake up event */
    kDma1RequestMuxWuu0             = 17U,         /**< WUU0 Wake up event */
    kDma0RequestMuxMicfil0FifoRequest = 18U,       /**< MICFIL0 FIFO_request */
    kDma1RequestMuxMicfil0FifoRequest = 18U,       /**< MICFIL0 FIFO_request */
    kDma0RequestMuxSct0Dma0         = 19U,         /**< SCT0 DMA0 */
    kDma1RequestMuxSct0Dma0         = 19U,         /**< SCT0 DMA0 */
    kDma0RequestMuxSct0Dma1         = 20U,         /**< SCT0 DMA1 */
    kDma1RequestMuxSct0Dma1         = 20U,         /**< SCT0 DMA1 */
    kDma0RequestMuxAdc0FifoARequest = 21U,         /**< ADC0 FIFO A request */
    kDma1RequestMuxAdc0FifoARequest = 21U,         /**< ADC0 FIFO A request */
    kDma0RequestMuxAdc0FifoBRequest = 22U,         /**< ADC0 FIFO B request */
    kDma1RequestMuxAdc0FifoBRequest = 22U,         /**< ADC0 FIFO B request */
    kDma0RequestMuxAdc1FifoARequest = 23U,         /**< ADC1 FIFO A request */
    kDma1RequestMuxAdc1FifoARequest = 23U,         /**< ADC1 FIFO A request */
    kDma0RequestMuxAdc1FifoBRequest = 24U,         /**< ADC1 FIFO B request */
    kDma1RequestMuxAdc1FifoBRequest = 24U,         /**< ADC1 FIFO B request */
    kDma0RequestMuxDac0FifoRequest  = 25U,         /**< DAC0 FIFO_request */
    kDma1RequestMuxDac0FifoRequest  = 25U,         /**< DAC0 FIFO_request */
    kDma0RequestMuxDac1FifoRequest  = 26U,         /**< DAC1 FIFO_request */
    kDma1RequestMuxDac1FifoRequest  = 26U,         /**< DAC1 FIFO_request */
    kDma0RequestMuxDac2FifoRequest  = 27U,         /**< DAC2 FIFO_request */
    kDma1RequestMuxDac2FifoRequest  = 27U,         /**< DAC2 FIFO_request */
    kDma0RequestMuxHsCmp0DmaRequest = 28U,         /**< CMP0 DMA_request */
    kDma1RequestMuxHsCmp0DmaRequest = 28U,         /**< CMP0 DMA_request */
    kDma0RequestMuxHsCmp1DmaRequest = 29U,         /**< CMP1 DMA_request */
    kDma1RequestMuxHsCmp1DmaRequest = 29U,         /**< CMP1 DMA_request */
    kDma0RequestMuxHsCmp2DmaRequest = 30U,         /**< CMP2 DMA_request */
    kDma1RequestMuxHsCmp2DmaRequest = 30U,         /**< CMP2 DMA_request */
    kDma0RequestMuxEvtg0Out0A       = 31U,         /**< EVTG0 OUT0A */
    kDma1RequestMuxEvtg0Out0A       = 31U,         /**< EVTG0 OUT0A */
    kDma0RequestMuxEvtg0Out0B       = 32U,         /**< EVTG0 OUT0B */
    kDma1RequestMuxEvtg0Out0B       = 32U,         /**< EVTG0 OUT0B */
    kDma0RequestMuxEvtg0Out1A       = 33U,         /**< EVTG0 OUT1A */
    kDma1RequestMuxEvtg0Out1A       = 33U,         /**< EVTG0 OUT1A */
    kDma0RequestMuxEvtg0Out1B       = 34U,         /**< EVTG0 OUT1B */
    kDma1RequestMuxEvtg0Out1B       = 34U,         /**< EVTG0 OUT1B */
    kDma0RequestMuxEvtg0Out2A       = 35U,         /**< EVTG0 OUT2A */
    kDma1RequestMuxEvtg0Out2A       = 35U,         /**< EVTG0 OUT2A */
    kDma0RequestMuxEvtg0Out2B       = 36U,         /**< EVTG0 OUT2B */
    kDma1RequestMuxEvtg0Out2B       = 36U,         /**< EVTG0 OUT2B */
    kDma0RequestMuxEvtg0Out3A       = 37U,         /**< EVTG0 OUT3A */
    kDma1RequestMuxEvtg0Out3A       = 37U,         /**< EVTG0 OUT3A */
    kDma0RequestMuxEvtg0Out3B       = 38U,         /**< EVTG0 OUT3B */
    kDma1RequestMuxEvtg0Out3B       = 38U,         /**< EVTG0 OUT3B */
    kDma0RequestMuxFlexPwm0ReqCapt0 = 39U,         /**< PWM0 capture0 request */
    kDma1RequestMuxFlexPwm0ReqCapt0 = 39U,         /**< PWM0 capture0 request */
    kDma0RequestMuxFlexPwm0ReqCapt1 = 40U,         /**< PWM0 capture1 request */
    kDma1RequestMuxFlexPwm0ReqCapt1 = 40U,         /**< PWM0 capture1 request */
    kDma0RequestMuxFlexPwm0ReqCapt2 = 41U,         /**< PWM0 capture2 request */
    kDma1RequestMuxFlexPwm0ReqCapt2 = 41U,         /**< PWM0 capture2 request */
    kDma0RequestMuxFlexPwm0ReqCapt3 = 42U,         /**< PWM0 capture3 request */
    kDma1RequestMuxFlexPwm0ReqCapt3 = 42U,         /**< PWM0 capture3 request */
    kDma0RequestMuxFlexPwm0ReqVal0  = 43U,         /**< PWM0 value0 request */
    kDma1RequestMuxFlexPwm0ReqVal0  = 43U,         /**< PWM0 value0 request */
    kDma0RequestMuxFlexPwm0ReqVal1  = 44U,         /**< PWM0 value1 request */
    kDma1RequestMuxFlexPwm0ReqVal1  = 44U,         /**< PWM0 value1 request */
    kDma0RequestMuxFlexPwm0ReqVal2  = 45U,         /**< PWM0 value2 request */
    kDma1RequestMuxFlexPwm0ReqVal2  = 45U,         /**< PWM0 value2 request */
    kDma0RequestMuxFlexPwm0ReqVal3  = 46U,         /**< PWM0 value3 request */
    kDma1RequestMuxFlexPwm0ReqVal3  = 46U,         /**< PWM0 value3 request */
    kDma0RequestMuxFlexPwm1ReqCapt0 = 47U,         /**< PWM1 capture0 request */
    kDma1RequestMuxFlexPwm1ReqCapt0 = 47U,         /**< PWM1 capture0 request */
    kDma0RequestMuxFlexPwm1ReqCapt1 = 48U,         /**< PWM1 capture1 request */
    kDma1RequestMuxFlexPwm1ReqCapt1 = 48U,         /**< PWM1 capture1 request */
    kDma0RequestMuxFlexPwm1ReqCapt2 = 49U,         /**< PWM1 capture2 request */
    kDma1RequestMuxFlexPwm1ReqCapt2 = 49U,         /**< PWM1 capture2 request */
    kDma0RequestMuxFlexPwm1ReqCapt3 = 50U,         /**< PWM1 capture3 request */
    kDma1RequestMuxFlexPwm1ReqCapt3 = 50U,         /**< PWM1 capture3 request */
    kDma0RequestMuxFlexPwm1ReqVal0  = 51U,         /**< PWM1 value0 request */
    kDma1RequestMuxFlexPwm1ReqVal0  = 51U,         /**< PWM1 value0 request */
    kDma0RequestMuxFlexPwm1ReqVal1  = 52U,         /**< PWM1 value1 request */
    kDma1RequestMuxFlexPwm1ReqVal1  = 52U,         /**< PWM1 value1 request */
    kDma0RequestMuxFlexPwm1ReqVal2  = 53U,         /**< PWM1 value2 request */
    kDma1RequestMuxFlexPwm1ReqVal2  = 53U,         /**< PWM1 value2 request */
    kDma0RequestMuxFlexPwm1ReqVal3  = 54U,         /**< PWM0 value3 request */
    kDma1RequestMuxFlexPwm1ReqVal3  = 54U,         /**< PWM0 value3 request */
    kDma0RequestMuxLptmr0           = 57U,         /**< LPTMR0 Counter match event */
    kDma1RequestMuxLptmr0           = 57U,         /**< LPTMR0 Counter match event */
    kDma0RequestMuxLptmr1           = 58U,         /**< LPTMR1 Counter match event */
    kDma1RequestMuxLptmr1           = 58U,         /**< LPTMR1 Counter match event */
    kDma0RequestMuxFlexCan0DmaRequest = 59U,       /**< CAN0 DMA request */
    kDma1RequestMuxFlexCan0DmaRequest = 59U,       /**< CAN0 DMA request */
    kDma0RequestMuxFlexCan1DmaRequest = 60U,       /**< CAN1 DMA request */
    kDma1RequestMuxFlexCan1DmaRequest = 60U,       /**< CAN1 DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister0Request = 61U, /**< FlexIO0 Shifter0 Status DMA request OR Timer0 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister0Request = 61U, /**< FlexIO0 Shifter0 Status DMA request OR Timer0 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister1Request = 62U, /**< FlexIO0 Shifter1 Status DMA request OR Timer1 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister1Request = 62U, /**< FlexIO0 Shifter1 Status DMA request OR Timer1 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister2Request = 63U, /**< FlexIO0 Shifter2 Status DMA request OR Timer2 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister2Request = 63U, /**< FlexIO0 Shifter2 Status DMA request OR Timer2 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister3Request = 64U, /**< FlexIO0 Shifter3 Status DMA request OR Timer3 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister3Request = 64U, /**< FlexIO0 Shifter3 Status DMA request OR Timer3 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister4Request = 65U, /**< FlexIO0 Shifter4 Status DMA request OR Timer4 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister4Request = 65U, /**< FlexIO0 Shifter4 Status DMA request OR Timer4 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister5Request = 66U, /**< FlexIO0 Shifter5 Status DMA request OR Timer5 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister5Request = 66U, /**< FlexIO0 Shifter5 Status DMA request OR Timer5 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister6Request = 67U, /**< FlexIO0 Shifter6 Status DMA request OR Timer6 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister6Request = 67U, /**< FlexIO0 Shifter6 Status DMA request OR Timer6 Status DMA request */
    kDma0RequestMuxFlexIO0ShiftRegister7Request = 68U, /**< FlexIO0 Shifter7 Status DMA request OR Timer7 Status DMA request */
    kDma1RequestMuxFlexIO0ShiftRegister7Request = 68U, /**< FlexIO0 Shifter7 Status DMA request OR Timer7 Status DMA request */
    kDma0RequestMuxLpFlexcomm0Rx    = 69U,         /**< LP_FLEXCOMM0 Receive request */
    kDma1RequestMuxLpFlexcomm0Rx    = 69U,         /**< LP_FLEXCOMM0 Receive request */
    kDma0RequestMuxLpFlexcomm0Tx    = 70U,         /**< LP_FLEXCOMM0 Transmit request */
    kDma1RequestMuxLpFlexcomm0Tx    = 70U,         /**< LP_FLEXCOMM0 Transmit request */
    kDma0RequestMuxLpFlexcomm1Rx    = 71U,         /**< LP_FLEXCOMM1 Receive request */
    kDma1RequestMuxLpFlexcomm1Rx    = 71U,         /**< LP_FLEXCOMM1 Receive request */
    kDma0RequestMuxLpFlexcomm1Tx    = 72U,         /**< LP_FLEXCOMM1 Transmit request */
    kDma1RequestMuxLpFlexcomm1Tx    = 72U,         /**< LP_FLEXCOMM1 Transmit request */
    kDma0RequestMuxLpFlexcomm2Rx    = 73U,         /**< LP_FLEXCOMM2 Receive request */
    kDma1RequestMuxLpFlexcomm2Rx    = 73U,         /**< LP_FLEXCOMM2 Receive request */
    kDma0RequestMuxLpFlexcomm2Tx    = 74U,         /**< LP_FLEXCOMM2 Transmit request */
    kDma1RequestMuxLpFlexcomm2Tx    = 74U,         /**< LP_FLEXCOMM2 Transmit request */
    kDma0RequestMuxLpFlexcomm3Rx    = 75U,         /**< LP_FLEXCOMM3 Receive request */
    kDma1RequestMuxLpFlexcomm3Rx    = 75U,         /**< LP_FLEXCOMM3 Receive request */
    kDma0RequestMuxLpFlexcomm3Tx    = 76U,         /**< LP_FLEXCOMM3 Transmit request */
    kDma1RequestMuxLpFlexcomm3Tx    = 76U,         /**< LP_FLEXCOMM3 Transmit request */
    kDma0RequestMuxLpFlexcomm4Rx    = 77U,         /**< LP_FLEXCOMM4 Receive request */
    kDma1RequestMuxLpFlexcomm4Rx    = 77U,         /**< LP_FLEXCOMM4 Receive request */
    kDma0RequestMuxLpFlexcomm4Tx    = 78U,         /**< LP_FLEXCOMM4 Transmit request */
    kDma1RequestMuxLpFlexcomm4Tx    = 78U,         /**< LP_FLEXCOMM4 Transmit request */
    kDma0RequestMuxLpFlexcomm5Rx    = 79U,         /**< LP_FLEXCOMM5 Receive request */
    kDma1RequestMuxLpFlexcomm5Rx    = 79U,         /**< LP_FLEXCOMM5 Receive request */
    kDma0RequestMuxLpFlexcomm5Tx    = 80U,         /**< LP_FLEXCOMM5 Transmit request */
    kDma1RequestMuxLpFlexcomm5Tx    = 80U,         /**< LP_FLEXCOMM5 Transmit request */
    kDma0RequestMuxLpFlexcomm6Rx    = 81U,         /**< LP_FLEXCOMM6 Receive request */
    kDma1RequestMuxLpFlexcomm6Rx    = 81U,         /**< LP_FLEXCOMM6 Receive request */
    kDma0RequestMuxLpFlexcomm6Tx    = 82U,         /**< LP_FLEXCOMM6 Transmit request */
    kDma1RequestMuxLpFlexcomm6Tx    = 82U,         /**< LP_FLEXCOMM6 Transmit request */
    kDma0RequestMuxLpFlexcomm7Rx    = 83U,         /**< LP_FLEXCOMM7 Receive request */
    kDma1RequestMuxLpFlexcomm7Rx    = 83U,         /**< LP_FLEXCOMM7 Receive request */
    kDma0RequestMuxLpFlexcomm7Tx    = 84U,         /**< LP_FLEXCOMM7 Transmit request */
    kDma1RequestMuxLpFlexcomm7Tx    = 84U,         /**< LP_FLEXCOMM7 Transmit request */
    kDma0RequestMuxLpFlexcomm8Rx    = 85U,         /**< LP_FLEXCOMM8 Receive request */
    kDma1RequestMuxLpFlexcomm8Rx    = 85U,         /**< LP_FLEXCOMM8 Receive request */
    kDma0RequestMuxLpFlexcomm8Tx    = 86U,         /**< LP_FLEXCOMM8 Transmit request */
    kDma1RequestMuxLpFlexcomm8Tx    = 86U,         /**< LP_FLEXCOMM8 Transmit request */
    kDma0RequestMuxLpFlexcomm9Rx    = 87U,         /**< LP_FLEXCOMM9 Receive request */
    kDma1RequestMuxLpFlexcomm9Rx    = 87U,         /**< LP_FLEXCOMM9 Receive request */
    kDma0RequestMuxLpFlexcomm9Tx    = 88U,         /**< LP_FLEXCOMM9 Transmit request */
    kDma1RequestMuxLpFlexcomm9Tx    = 88U,         /**< LP_FLEXCOMM9 Transmit request */
    kDma0RequestMuxEmvSim0Rx        = 91U,         /**< EMVSIM0 Receive request */
    kDma1RequestMuxEmvSim0Rx        = 91U,         /**< EMVSIM0 Receive request */
    kDma0RequestMuxEmvSim0Tx        = 92U,         /**< EMVSIM0 Transmit request */
    kDma1RequestMuxEmvSim0Tx        = 92U,         /**< EMVSIM0 Transmit request */
    kDma0RequestMuxEmvSim1Rx        = 93U,         /**< EMVSIM1 Receive request */
    kDma1RequestMuxEmvSim1Rx        = 93U,         /**< EMVSIM1 Receive request */
    kDma0RequestMuxEmvSim1Tx        = 94U,         /**< EMVSIM1 Transmit request */
    kDma1RequestMuxEmvSim1Tx        = 94U,         /**< EMVSIM1 Transmit request */
    kDma0RequestMuxI3c0Rx           = 95U,         /**< I3C0 Receive request */
    kDma1RequestMuxI3c0Rx           = 95U,         /**< I3C0 Receive request */
    kDma0RequestMuxI3c0Tx           = 96U,         /**< I3C0 Transmit request */
    kDma1RequestMuxI3c0Tx           = 96U,         /**< I3C0 Transmit request */
    kDma0RequestMuxI3c1Rx           = 97U,         /**< I3C1 Receive request */
    kDma1RequestMuxI3c1Rx           = 97U,         /**< I3C1 Receive request */
    kDma0RequestMuxI3c1Tx           = 98U,         /**< I3C1 Transmit request */
    kDma1RequestMuxI3c1Tx           = 98U,         /**< I3C1 Transmit request */
    kDma0RequestMuxSai0Rx           = 99U,         /**< SAI0 Receive request */
    kDma1RequestMuxSai0Rx           = 99U,         /**< SAI0 Receive request */
    kDma0RequestMuxSai0Tx           = 100U,        /**< SAI0 Transmit request */
    kDma1RequestMuxSai0Tx           = 100U,        /**< SAI0 Transmit request */
    kDma0RequestMuxSai1Rx           = 101U,        /**< SAI1 Receive request */
    kDma1RequestMuxSai1Rx           = 101U,        /**< SAI1 Receive request */
    kDma0RequestMuxSai1Tx           = 102U,        /**< SAI1 Transmit request */
    kDma1RequestMuxSai1Tx           = 102U,        /**< SAI1 Transmit request */
    kDma0RequestMuxSinc0IpdReqSincAlt0 = 103U,     /**< SINC0 ipd_req_sinc[0] or ipd_req_alt [0] */
    kDma1RequestMuxSinc0IpdReqSincAlt0 = 103U,     /**< SINC0 ipd_req_sinc[0] or ipd_req_alt [0] */
    kDma0RequestMuxSinc1IpdReqSincAlt1 = 104U,     /**< SINC0 ipd_req_sinc[1] or ipd_req_alt [1] */
    kDma1RequestMuxSinc1IpdReqSincAlt1 = 104U,     /**< SINC0 ipd_req_sinc[1] or ipd_req_alt [1] */
    kDma0RequestMuxSinc2IpdReqSincAlt2 = 105U,     /**< SINC0 ipd_req_sinc[2] or ipd_req_alt [2] */
    kDma1RequestMuxSinc2IpdReqSincAlt2 = 105U,     /**< SINC0 ipd_req_sinc[2] or ipd_req_alt [2] */
    kDma0RequestMuxSinc3IpdReqSincAlt3 = 106U,     /**< SINC0 ipd_req_sinc[3] or ipd_req_alt [3] */
    kDma1RequestMuxSinc3IpdReqSincAlt3 = 106U,     /**< SINC0 ipd_req_sinc[3] or ipd_req_alt [3] */
    kDma0RequestMuxSinc4IpdReqSincAlt4 = 107U,     /**< SINC0 ipd_req_sinc[4] or ipd_req_alt [4] */
    kDma1RequestMuxSinc4IpdReqSincAlt4 = 107U,     /**< SINC0 ipd_req_sinc[4] or ipd_req_alt [4] */
    kDma0RequestMuxGpio0PinEventRequest0 = 108U,   /**< GPIO0 Pin event request 0 */
    kDma1RequestMuxGpio0PinEventRequest0 = 108U,   /**< GPIO0 Pin event request 0 */
    kDma0RequestMuxGpio0PinEventRequest1 = 109U,   /**< GPIO0 Pin event request 1 */
    kDma1RequestMuxGpio0PinEventRequest1 = 109U,   /**< GPIO0 Pin event request 1 */
    kDma0RequestMuxGpio1PinEventRequest0 = 110U,   /**< GPIO1 Pin event request 0 */
    kDma1RequestMuxGpio1PinEventRequest0 = 110U,   /**< GPIO1 Pin event request 0 */
    kDma0RequestMuxGpio1PinEventRequest1 = 111U,   /**< GPIO1 Pin event request 1 */
    kDma1RequestMuxGpio1PinEventRequest1 = 111U,   /**< GPIO1 Pin event request 1 */
    kDma0RequestMuxGpio2PinEventRequest0 = 112U,   /**< GPIO2 Pin event request 0 */
    kDma1RequestMuxGpio2PinEventRequest0 = 112U,   /**< GPIO2 Pin event request 0 */
    kDma0RequestMuxGpio2PinEventRequest1 = 113U,   /**< GPIO2 Pin event request 1 */
    kDma1RequestMuxGpio2PinEventRequest1 = 113U,   /**< GPIO2 Pin event request 1 */
    kDma0RequestMuxGpio3PinEventRequest0 = 114U,   /**< GPIO3 Pin event request 0 */
    kDma1RequestMuxGpio3PinEventRequest0 = 114U,   /**< GPIO3 Pin event request 0 */
    kDma0RequestMuxGpio3PinEventRequest1 = 115U,   /**< GPIO3 Pin event request 1 */
    kDma1RequestMuxGpio3PinEventRequest1 = 115U,   /**< GPIO3 Pin event request 1 */
    kDma0RequestMuxGpio4PinEventRequest0 = 116U,   /**< GPIO4 Pin event request 0 */
    kDma1RequestMuxGpio4PinEventRequest0 = 116U,   /**< GPIO4 Pin event request 0 */
    kDma0RequestMuxGpio4PinEventRequest1 = 117U,   /**< GPIO4 Pin event request 1 */
    kDma1RequestMuxGpio4PinEventRequest1 = 117U,   /**< GPIO4 Pin event request 1 */
    kDma0RequestMuxGpio5PinEventRequest0 = 118U,   /**< GPIO5 Pin event request 0 */
    kDma1RequestMuxGpio5PinEventRequest0 = 118U,   /**< GPIO5 Pin event request 0 */
    kDma0RequestMuxGpio5PinEventRequest1 = 119U,   /**< GPIO5 Pin event request 1 */
    kDma1RequestMuxGpio5PinEventRequest1 = 119U,   /**< GPIO5 Pin event request 1 */
    kDma0RequestMuxTsi0EndOfScan    = 120U,        /**< TSI0 End of Scan */
    kDma1RequestMuxTsi0EndOfScan    = 120U,        /**< TSI0 End of Scan */
    kDma0RequestMuxTsi0OutOfRange   = 121U,        /**< TSI0 Out of Range */
    kDma1RequestMuxTsi0OutOfRange   = 121U,        /**< TSI0 Out of Range */
} dma_request_source_t;

/* @} */

/*!
 * @addtogroup eim_memory_channel
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the eim_memory_channel
 *
 * Defines the structure for the EIM resource collections.
 */

typedef enum _eim_memory_channel
{
    kEIM_MemoryChannelRAMX          = 0U,          /**< Memory RAMX */
    kEIM_MemoryChannelRAMA          = 1U,          /**< Memory RAMA  */
    kEIM_MemoryChannelRAMB          = 2U,          /**< Memory RAMB */
    kEIM_MemoryChannelRAMC          = 3U,          /**< Memory RAMC */
    kEIM_MemoryChannelRAMD          = 4U,          /**< Memory RAMD */
    kEIM_MemoryChannelRAME          = 5U,          /**< Memory RAME */
    kEIM_MemoryChannelRAMF          = 6U,          /**< Memory RAMF */
    kEIM_MemoryChannelLPCACRAM      = 7U,          /**< Memory LPCACRAM */
    kEIM_MemoryChannelPKCRAM        = 8U,          /**< Memory PKCRAM */
} eim_memory_channel_t;

/* @} */

/*!
 * @addtogroup eim_error_injection_channel_enable
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the eim_error_injection_channel_enable
 *
 * Defines the structure for the EIM error injection resource collections.
 */

typedef enum _eim_error_injection_channel_enable
{
    kEIM_MemoryChannelRAMXEnable    = 0x80000000U, /**< Memory channel 0(RAMX) error injection enable */
    kEIM_MemoryChannelRAMAEnable    = 0x40000000U, /**< Memory channel 1(RAMA) error injection enable  */
    kEIM_MemoryChannelRAMBEnable    = 0x20000000U, /**< Memory channel 2(RAMB) error injection enable */
    kEIM_MemoryChannelRAMCEnable    = 0x10000000U, /**< Memory channel 3(RAMC) error injection enable */
    kEIM_MemoryChannelRAMDEnable    = 0x8000000U,  /**< Memory channel 4(RAMD) error injection enable */
    kEIM_MemoryChannelRAMEEnable    = 0x4000000U,  /**< Memory channel 5(RAME) error injection enable */
    kEIM_MemoryChannelRAMFEnable    = 0x2000000U,  /**< Memory channel 6(RAMF) error injection enable */
    kEIM_MemoryChannelLPCACRAMEnable = 0x1000000U, /**< Memory channel 7(LPCACRAM) error injection enable */
    kEIM_MemoryChannelPKCRAMEnable  = 0x800000U,   /**< Memory channel 8(PKCRAM) error injection enable */
} eim_error_injection_channel_enable_t;

/* @} */

/*!
 * @addtogroup erm_memory_channel
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*!
 * @brief Structure for the erm_memory_channel
 *
 * Defines the structure for the ERM resource collections.
 */

typedef enum _erm_memory_channel
{
    kERM_MemoryChannelRAMX          = 0U,          /**< Memory RAMX */
    kERM_MemoryChannelRAMA          = 1U,          /**< Memory RAMA  */
    kERM_MemoryChannelRAMB          = 2U,          /**< Memory RAMB */
    kERM_MemoryChannelRAMC          = 3U,          /**< Memory RAMC */
    kERM_MemoryChannelRAMD          = 4U,          /**< Memory RAMD */
    kERM_MemoryChannelRAME          = 5U,          /**< Memory RAME */
    kERM_MemoryChannelRAMF          = 6U,          /**< Memory RAMF */
    kERM_MemoryChannelLPCACRAM      = 7U,          /**< Memory LPCACRAM */
    kERM_MemoryChannelPKCRAM        = 8U,          /**< Memory PKCRAM */
    kERM_MemoryChannelFLASH         = 9U,          /**< Memory FLASH */
} erm_memory_channel_t;

/* @} */


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t CTRL;                              /**< Control Register, offset: 0x10 */
  __IO uint32_t STAT;                              /**< Status Register, offset: 0x14 */
  __IO uint32_t IE;                                /**< Interrupt Enable Register, offset: 0x18 */
  __IO uint32_t DE;                                /**< DMA Enable Register, offset: 0x1C */
  __IO uint32_t CFG;                               /**< Configuration Register, offset: 0x20 */
  __IO uint32_t PAUSE;                             /**< Pause Register, offset: 0x24 */
       uint8_t RESERVED_1[12];
  __O  uint32_t SWTRIG;                            /**< Software Trigger Register, offset: 0x34 */
  __IO uint32_t TSTAT;                             /**< Trigger Status Register, offset: 0x38 */
       uint8_t RESERVED_2[4];
  __IO uint32_t OFSTRIM;                           /**< Offset Trim Register, offset: 0x40 */
       uint8_t RESERVED_3[92];
  __IO uint32_t TCTRL[4];                          /**< Trigger Control Register, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_4[48];
  __IO uint32_t FCTRL[2];                          /**< FIFO Control Register, array offset: 0xE0, array step: 0x4 */
       uint8_t RESERVED_5[8];
  __I  uint32_t GCC[2];                            /**< Gain Calibration Control, array offset: 0xF0, array step: 0x4 */
  __IO uint32_t GCR[2];                            /**< Gain Calculation Result, array offset: 0xF8, array step: 0x4 */
  struct {                                         /* offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDL;                              /**< Command Low Buffer Register, array offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDH;                              /**< Command High Buffer Register, array offset: 0x104, array step: 0x8 */
  } CMD[15];
       uint8_t RESERVED_6[136];
  __IO uint32_t CV[15];                            /**< Compare Value Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_7[196];
  __I  uint32_t RESFIFO[2];                        /**< Data Result FIFO Register, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_8[248];
  __IO uint32_t CAL_GAR[33];                       /**< Calibration General A-Side Registers, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_9[124];
  __IO uint32_t CAL_GBR[33];                       /**< Calibration General B-Side Registers, array offset: 0x500, array step: 0x4 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */

#define ADC_VERID_RES_MASK                       (0x1U)
#define ADC_VERID_RES_SHIFT                      (0U)
/*! RES - Resolution
 *  0b0..Up to 13-bit differential or 12-bit single-ended resolution supported.
 *  0b1..Up to 16-bit differential or 16-bit single-ended resolution supported. CMDLn[MODE] available for
 *       selecting the resolution of conversions for the associated command.
 */
#define ADC_VERID_RES(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_RES_SHIFT)) & ADC_VERID_RES_MASK)

#define ADC_VERID_DIFFEN_MASK                    (0x2U)
#define ADC_VERID_DIFFEN_SHIFT                   (1U)
/*! DIFFEN - Differential Supported
 *  0b0..Not supported
 *  0b1..Supported. CMDLn[CTYPE] controls fields implemented.
 */
#define ADC_VERID_DIFFEN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_DIFFEN_SHIFT)) & ADC_VERID_DIFFEN_MASK)

#define ADC_VERID_MVI_MASK                       (0x8U)
#define ADC_VERID_MVI_SHIFT                      (3U)
/*! MVI - Multiple Vref Implemented
 *  0b0..Single VREFH input supported.
 *  0b1..Multiple VREFH inputs supported.
 */
#define ADC_VERID_MVI(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MVI_SHIFT)) & ADC_VERID_MVI_MASK)

#define ADC_VERID_CSW_MASK                       (0x70U)
#define ADC_VERID_CSW_SHIFT                      (4U)
/*! CSW - Channel Scale Width
 *  0b000..Not supported.
 *  0b001..Supported with one-bit CSCALE control field.
 *  0b110..Supported with six-bit CSCALE control field.
 */
#define ADC_VERID_CSW(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CSW_SHIFT)) & ADC_VERID_CSW_MASK)

#define ADC_VERID_VR1RNGI_MASK                   (0x100U)
#define ADC_VERID_VR1RNGI_SHIFT                  (8U)
/*! VR1RNGI - Voltage Reference 1 Range Control Bit Implemented
 *  0b0..Range control not required.
 *  0b1..Range control required.
 */
#define ADC_VERID_VR1RNGI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_VR1RNGI_SHIFT)) & ADC_VERID_VR1RNGI_MASK)

#define ADC_VERID_IADCKI_MASK                    (0x200U)
#define ADC_VERID_IADCKI_SHIFT                   (9U)
/*! IADCKI - Internal ADC Clock Implemented
 *  0b0..Not implemented
 *  0b1..Implemented
 */
#define ADC_VERID_IADCKI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_IADCKI_SHIFT)) & ADC_VERID_IADCKI_MASK)

#define ADC_VERID_CALOFSI_MASK                   (0x400U)
#define ADC_VERID_CALOFSI_SHIFT                  (10U)
/*! CALOFSI - Calibration Function Implemented
 *  0b0..Not implemented
 *  0b1..Implemented
 */
#define ADC_VERID_CALOFSI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CALOFSI_SHIFT)) & ADC_VERID_CALOFSI_MASK)

#define ADC_VERID_NUM_SEC_MASK                   (0x800U)
#define ADC_VERID_NUM_SEC_SHIFT                  (11U)
/*! NUM_SEC - Number of Single-Ended Outputs Supported
 *  0b0..One
 *  0b1..Two
 */
#define ADC_VERID_NUM_SEC(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_SEC_SHIFT)) & ADC_VERID_NUM_SEC_MASK)

#define ADC_VERID_NUM_FIFO_MASK                  (0x7000U)
#define ADC_VERID_NUM_FIFO_SHIFT                 (12U)
/*! NUM_FIFO - Number of FIFOs
 *  0b000..N/A
 *  0b001..One
 *  0b010..Two
 *  0b011..Three
 *  0b100..Four
 */
#define ADC_VERID_NUM_FIFO(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_FIFO_SHIFT)) & ADC_VERID_NUM_FIFO_MASK)

#define ADC_VERID_MINOR_MASK                     (0xFF0000U)
#define ADC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number */
#define ADC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MINOR_SHIFT)) & ADC_VERID_MINOR_MASK)

#define ADC_VERID_MAJOR_MASK                     (0xFF000000U)
#define ADC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number */
#define ADC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MAJOR_SHIFT)) & ADC_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */

#define ADC_PARAM_TRIG_NUM_MASK                  (0xFFU)
#define ADC_PARAM_TRIG_NUM_SHIFT                 (0U)
/*! TRIG_NUM - Trigger Number */
#define ADC_PARAM_TRIG_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_TRIG_NUM_SHIFT)) & ADC_PARAM_TRIG_NUM_MASK)

#define ADC_PARAM_FIFOSIZE_MASK                  (0xFF00U)
#define ADC_PARAM_FIFOSIZE_SHIFT                 (8U)
/*! FIFOSIZE - Result FIFO Depth
 *  0b00000001..2
 *  0b00000100..4
 *  0b00001000..8
 *  0b00010000..16
 *  0b00100000..32
 *  0b01000000..64
 */
#define ADC_PARAM_FIFOSIZE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_FIFOSIZE_SHIFT)) & ADC_PARAM_FIFOSIZE_MASK)

#define ADC_PARAM_CV_NUM_MASK                    (0xFF0000U)
#define ADC_PARAM_CV_NUM_SHIFT                   (16U)
/*! CV_NUM - Compare Value Number */
#define ADC_PARAM_CV_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CV_NUM_SHIFT)) & ADC_PARAM_CV_NUM_MASK)

#define ADC_PARAM_CMD_NUM_MASK                   (0xFF000000U)
#define ADC_PARAM_CMD_NUM_SHIFT                  (24U)
/*! CMD_NUM - Command Buffer Number */
#define ADC_PARAM_CMD_NUM(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CMD_NUM_SHIFT)) & ADC_PARAM_CMD_NUM_MASK)
/*! @} */

/*! @name CTRL - Control Register */
/*! @{ */

#define ADC_CTRL_ADCEN_MASK                      (0x1U)
#define ADC_CTRL_ADCEN_SHIFT                     (0U)
/*! ADCEN - ADC Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_CTRL_ADCEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ADCEN_SHIFT)) & ADC_CTRL_ADCEN_MASK)

#define ADC_CTRL_RST_MASK                        (0x2U)
#define ADC_CTRL_RST_SHIFT                       (1U)
/*! RST - Software Reset
 *  0b0..ADC logic is not reset.
 *  0b1..ADC logic is reset.
 */
#define ADC_CTRL_RST(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RST_SHIFT)) & ADC_CTRL_RST_MASK)

#define ADC_CTRL_DOZEN_MASK                      (0x4U)
#define ADC_CTRL_DOZEN_SHIFT                     (2U)
/*! DOZEN - Doze Enable
 *  0b0..ADC is enabled in low-power mode.
 *  0b1..ADC is disabled in low-power mode.
 */
#define ADC_CTRL_DOZEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_DOZEN_SHIFT)) & ADC_CTRL_DOZEN_MASK)

#define ADC_CTRL_CAL_REQ_MASK                    (0x8U)
#define ADC_CTRL_CAL_REQ_SHIFT                   (3U)
/*! CAL_REQ - Auto-Calibration Request
 *  0b0..No request made.
 *  0b1..Request has been made.
 */
#define ADC_CTRL_CAL_REQ(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_REQ_SHIFT)) & ADC_CTRL_CAL_REQ_MASK)

#define ADC_CTRL_CALOFS_MASK                     (0x10U)
#define ADC_CTRL_CALOFS_SHIFT                    (4U)
/*! CALOFS - Offset Calibration Request
 *  0b0..Calibration function disabled
 *  0b1..Request for offset calibration function
 */
#define ADC_CTRL_CALOFS(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CALOFS_SHIFT)) & ADC_CTRL_CALOFS_MASK)

#define ADC_CTRL_RSTFIFO0_MASK                   (0x100U)
#define ADC_CTRL_RSTFIFO0_SHIFT                  (8U)
/*! RSTFIFO0 - Reset FIFO 0
 *  0b0..No effect.
 *  0b1..FIFO 0 is reset.
 */
#define ADC_CTRL_RSTFIFO0(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO0_SHIFT)) & ADC_CTRL_RSTFIFO0_MASK)

#define ADC_CTRL_RSTFIFO1_MASK                   (0x200U)
#define ADC_CTRL_RSTFIFO1_SHIFT                  (9U)
/*! RSTFIFO1 - Reset FIFO 1
 *  0b0..No effect.
 *  0b1..FIFO 1 is reset.
 */
#define ADC_CTRL_RSTFIFO1(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO1_SHIFT)) & ADC_CTRL_RSTFIFO1_MASK)

#define ADC_CTRL_CAL_AVGS_MASK                   (0xF0000U)
#define ADC_CTRL_CAL_AVGS_SHIFT                  (16U)
/*! CAL_AVGS - Auto-Calibration Averages
 *  0b0000..Single conversion.
 *  0b0001..2 conversions averaged.
 *  0b0010..4 conversions averaged.
 *  0b0011..8 conversions averaged.
 *  0b0100..16 conversions averaged.
 *  0b0101..32 conversions averaged.
 *  0b0110..64 conversions averaged.
 *  0b0111..128 conversions averaged.
 *  0b1000..256 conversions averaged.
 *  0b1001..512 conversions averaged.
 *  0b1010..1024 conversions averaged.
 */
#define ADC_CTRL_CAL_AVGS(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_AVGS_SHIFT)) & ADC_CTRL_CAL_AVGS_MASK)
/*! @} */

/*! @name STAT - Status Register */
/*! @{ */

#define ADC_STAT_RDY0_MASK                       (0x1U)
#define ADC_STAT_RDY0_SHIFT                      (0U)
/*! RDY0 - Result FIFO 0 Ready Flag
 *  0b0..Not above watermark
 *  0b1..Above watermark
 */
#define ADC_STAT_RDY0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY0_SHIFT)) & ADC_STAT_RDY0_MASK)

#define ADC_STAT_FOF0_MASK                       (0x2U)
#define ADC_STAT_FOF0_SHIFT                      (1U)
/*! FOF0 - Result FIFO 0 Overflow Flag
 *  0b0..No result FIFO 0 overflow has occurred since the last time that the flag was cleared.
 *  0b1..At least one result FIFO 0 overflow has occurred since the last time that the flag was cleared.
 */
#define ADC_STAT_FOF0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF0_SHIFT)) & ADC_STAT_FOF0_MASK)

#define ADC_STAT_RDY1_MASK                       (0x4U)
#define ADC_STAT_RDY1_SHIFT                      (2U)
/*! RDY1 - Result FIFO1 Ready Flag
 *  0b0..Not above watermark
 *  0b1..Above watermark
 */
#define ADC_STAT_RDY1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY1_SHIFT)) & ADC_STAT_RDY1_MASK)

#define ADC_STAT_FOF1_MASK                       (0x8U)
#define ADC_STAT_FOF1_SHIFT                      (3U)
/*! FOF1 - Result FIFO1 Overflow Flag
 *  0b0..No result FIFO1 overflow has occurred since the last time that the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time that the flag was cleared.
 */
#define ADC_STAT_FOF1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF1_SHIFT)) & ADC_STAT_FOF1_MASK)

#define ADC_STAT_TEXC_INT_MASK                   (0x100U)
#define ADC_STAT_TEXC_INT_SHIFT                  (8U)
/*! TEXC_INT - Interrupt Flag For High-Priority Trigger Exception
 *  0b0..No trigger exceptions have occurred.
 *  0b1..A trigger exception has occurred and is pending acknowledgment.
 */
#define ADC_STAT_TEXC_INT(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TEXC_INT_SHIFT)) & ADC_STAT_TEXC_INT_MASK)

#define ADC_STAT_TCOMP_INT_MASK                  (0x200U)
#define ADC_STAT_TCOMP_INT_SHIFT                 (9U)
/*! TCOMP_INT - Interrupt Flag For Trigger Completion
 *  0b0..Either IE[TCOMP_IE] = 0, or no trigger sequences have run to completion.
 *  0b1..Trigger sequence has been completed and all data is stored in the associated FIFO.
 */
#define ADC_STAT_TCOMP_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TCOMP_INT_SHIFT)) & ADC_STAT_TCOMP_INT_MASK)

#define ADC_STAT_CAL_RDY_MASK                    (0x400U)
#define ADC_STAT_CAL_RDY_SHIFT                   (10U)
/*! CAL_RDY - Calibration Ready
 *  0b0..Calibration is incomplete or has not been run.
 *  0b1..ADC is calibrated.
 */
#define ADC_STAT_CAL_RDY(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CAL_RDY_SHIFT)) & ADC_STAT_CAL_RDY_MASK)

#define ADC_STAT_ADC_ACTIVE_MASK                 (0x800U)
#define ADC_STAT_ADC_ACTIVE_SHIFT                (11U)
/*! ADC_ACTIVE - ADC Active
 *  0b0..ADC is idle. There are no pending triggers to service and no active commands are being processed.
 *  0b1..ADC is processing a conversion, running through the power-up delay, or servicing a trigger.
 */
#define ADC_STAT_ADC_ACTIVE(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_STAT_ADC_ACTIVE_SHIFT)) & ADC_STAT_ADC_ACTIVE_MASK)

#define ADC_STAT_TRGACT_MASK                     (0x30000U)
#define ADC_STAT_TRGACT_SHIFT                    (16U)
/*! TRGACT - Trigger Active
 *  0b00..Command (sequence) associated with Trigger 0 currently being executed.
 *  0b01..Command (sequence) associated with Trigger 1 currently being executed.
 *  0b10..Command (sequence) associated with Trigger 2 currently being executed.
 *  0b11..Command (sequence) associated with Trigger 3 currently being executed.
 */
#define ADC_STAT_TRGACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TRGACT_SHIFT)) & ADC_STAT_TRGACT_MASK)

#define ADC_STAT_CMDACT_MASK                     (0xF000000U)
#define ADC_STAT_CMDACT_SHIFT                    (24U)
/*! CMDACT - Command Active
 *  0b0000..No command currently in progress.
 *  0b0001..Command 1 currently being executed.
 *  0b0010..Command 2 currently being executed.
 *  0b0011-0b1111..Associated command number currently being executed.
 */
#define ADC_STAT_CMDACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CMDACT_SHIFT)) & ADC_STAT_CMDACT_MASK)
/*! @} */

/*! @name IE - Interrupt Enable Register */
/*! @{ */

#define ADC_IE_FWMIE0_MASK                       (0x1U)
#define ADC_IE_FWMIE0_SHIFT                      (0U)
/*! FWMIE0 - FIFO 0 Watermark Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_IE_FWMIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE0_SHIFT)) & ADC_IE_FWMIE0_MASK)

#define ADC_IE_FOFIE0_MASK                       (0x2U)
#define ADC_IE_FOFIE0_SHIFT                      (1U)
/*! FOFIE0 - Result FIFO 0 Overflow Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_IE_FOFIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE0_SHIFT)) & ADC_IE_FOFIE0_MASK)

#define ADC_IE_FWMIE1_MASK                       (0x4U)
#define ADC_IE_FWMIE1_SHIFT                      (2U)
/*! FWMIE1 - FIFO1 Watermark Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_IE_FWMIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE1_SHIFT)) & ADC_IE_FWMIE1_MASK)

#define ADC_IE_FOFIE1_MASK                       (0x8U)
#define ADC_IE_FOFIE1_SHIFT                      (3U)
/*! FOFIE1 - Result FIFO1 Overflow Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_IE_FOFIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE1_SHIFT)) & ADC_IE_FOFIE1_MASK)

#define ADC_IE_TEXC_IE_MASK                      (0x100U)
#define ADC_IE_TEXC_IE_SHIFT                     (8U)
/*! TEXC_IE - Trigger Exception Interrupt Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_IE_TEXC_IE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_IE_TEXC_IE_SHIFT)) & ADC_IE_TEXC_IE_MASK)

#define ADC_IE_TCOMP_IE_MASK                     (0xF0000U)
#define ADC_IE_TCOMP_IE_SHIFT                    (16U)
/*! TCOMP_IE - Trigger Completion Interrupt Enable
 *  0b0000..All disabled
 *  0b0001..Trigger completion interrupts are enabled for trigger source 0 only.
 *  0b0010..Trigger completion interrupts are enabled for trigger source 1 only.
 *  0b0011-0b1110..Associated trigger completion interrupts are enabled.
 *  0b1111..All enabled
 */
#define ADC_IE_TCOMP_IE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_IE_TCOMP_IE_SHIFT)) & ADC_IE_TCOMP_IE_MASK)
/*! @} */

/*! @name DE - DMA Enable Register */
/*! @{ */

#define ADC_DE_FWMDE0_MASK                       (0x1U)
#define ADC_DE_FWMDE0_SHIFT                      (0U)
/*! FWMDE0 - FIFO 0 Watermark DMA Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_DE_FWMDE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE0_SHIFT)) & ADC_DE_FWMDE0_MASK)

#define ADC_DE_FWMDE1_MASK                       (0x2U)
#define ADC_DE_FWMDE1_SHIFT                      (1U)
/*! FWMDE1 - FIFO1 Watermark DMA Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_DE_FWMDE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE1_SHIFT)) & ADC_DE_FWMDE1_MASK)
/*! @} */

/*! @name CFG - Configuration Register */
/*! @{ */

#define ADC_CFG_TPRICTRL_MASK                    (0x3U)
#define ADC_CFG_TPRICTRL_SHIFT                   (0U)
/*! TPRICTRL - ADC Trigger Priority Control
 *  0b00..Current conversion is aborted and the new command specified by the trigger is started.
 *  0b01..Current command is stopped after completing the current conversion. If averaging is enabled, the
 *        averaging loop is completed. CMDHn[LOOP] is ignored and the higher-priority trigger is serviced.
 *  0b10..Current command is completed (averaging, looping, compare) before servicing the higher-priority trigger.
 *  0b11..
 */
#define ADC_CFG_TPRICTRL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TPRICTRL_SHIFT)) & ADC_CFG_TPRICTRL_MASK)

#define ADC_CFG_PWRSEL_MASK                      (0x30U)
#define ADC_CFG_PWRSEL_SHIFT                     (4U)
/*! PWRSEL - Power Configuration Select
 *  0b0x..Low power
 *  0b1x..High power
 */
#define ADC_CFG_PWRSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWRSEL_SHIFT)) & ADC_CFG_PWRSEL_MASK)

#define ADC_CFG_REFSEL_MASK                      (0xC0U)
#define ADC_CFG_REFSEL_SHIFT                     (6U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..Option 1
 *  0b01..Option 2
 *  0b10..Option 3
 *  0b11..
 */
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)

#define ADC_CFG_TRES_MASK                        (0x100U)
#define ADC_CFG_TRES_SHIFT                       (8U)
/*! TRES - Trigger Resume Enable
 *  0b0..Not automatically resumed or restarted
 *  0b1..Automatically resumed or restarted
 */
#define ADC_CFG_TRES(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TRES_SHIFT)) & ADC_CFG_TRES_MASK)

#define ADC_CFG_TCMDRES_MASK                     (0x200U)
#define ADC_CFG_TCMDRES_SHIFT                    (9U)
/*! TCMDRES - Trigger Command Resume
 *  0b0..Trigger sequence automatically restarted.
 *  0b1..Trigger sequence resumed from the command that was executed prior to the exception.
 */
#define ADC_CFG_TCMDRES(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TCMDRES_SHIFT)) & ADC_CFG_TCMDRES_MASK)

#define ADC_CFG_HPT_EXDI_MASK                    (0x400U)
#define ADC_CFG_HPT_EXDI_SHIFT                   (10U)
/*! HPT_EXDI - High-Priority Trigger Exception Disable
 *  0b0..Enabled
 *  0b1..Disabled
 */
#define ADC_CFG_HPT_EXDI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_HPT_EXDI_SHIFT)) & ADC_CFG_HPT_EXDI_MASK)

#define ADC_CFG_PUDLY_MASK                       (0xFF0000U)
#define ADC_CFG_PUDLY_SHIFT                      (16U)
/*! PUDLY - Power-up Delay */
#define ADC_CFG_PUDLY(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PUDLY_SHIFT)) & ADC_CFG_PUDLY_MASK)

#define ADC_CFG_PWREN_MASK                       (0x10000000U)
#define ADC_CFG_PWREN_SHIFT                      (28U)
/*! PWREN - ADC Analog Pre-Enable
 *  0b0..ADC analog circuits are only enabled while conversions are active. Analog startup delays affect performance.
 *  0b1..ADC analog circuits are pre-enabled and ready to execute conversions without startup delays, at the cost
 *       of higher DC current consumption. A single power-up delay (CFG[PUDLY]) is executed immediately once PWREN
 *       is set. No detected triggers begin ADC operation until the power-up delay time has passed. After this
 *       initial delay expires, the analog circuits remain pre-enabled, and no additional delays are executed.
 */
#define ADC_CFG_PWREN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWREN_SHIFT)) & ADC_CFG_PWREN_MASK)
/*! @} */

/*! @name PAUSE - Pause Register */
/*! @{ */

#define ADC_PAUSE_PAUSEDLY_MASK                  (0x1FFU)
#define ADC_PAUSE_PAUSEDLY_SHIFT                 (0U)
/*! PAUSEDLY - Pause Delay */
#define ADC_PAUSE_PAUSEDLY(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEDLY_SHIFT)) & ADC_PAUSE_PAUSEDLY_MASK)

#define ADC_PAUSE_PAUSEEN_MASK                   (0x80000000U)
#define ADC_PAUSE_PAUSEEN_SHIFT                  (31U)
/*! PAUSEEN - Pause Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_PAUSE_PAUSEEN(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEEN_SHIFT)) & ADC_PAUSE_PAUSEEN_MASK)
/*! @} */

/*! @name SWTRIG - Software Trigger Register */
/*! @{ */

#define ADC_SWTRIG_SWT0_MASK                     (0x1U)
#define ADC_SWTRIG_SWT0_SHIFT                    (0U)
/*! SWT0 - Software Trigger 0
 *  0b0..No trigger 0 event generated.
 *  0b1..Trigger 0 event generated.
 */
#define ADC_SWTRIG_SWT0(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT0_SHIFT)) & ADC_SWTRIG_SWT0_MASK)

#define ADC_SWTRIG_SWT1_MASK                     (0x2U)
#define ADC_SWTRIG_SWT1_SHIFT                    (1U)
/*! SWT1 - Software Trigger 1
 *  0b0..No trigger 1 event generated.
 *  0b1..Trigger 1 event generated.
 */
#define ADC_SWTRIG_SWT1(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT1_SHIFT)) & ADC_SWTRIG_SWT1_MASK)

#define ADC_SWTRIG_SWT2_MASK                     (0x4U)
#define ADC_SWTRIG_SWT2_SHIFT                    (2U)
/*! SWT2 - Software Trigger 2
 *  0b0..No trigger 2 event generated.
 *  0b1..Trigger 2 event generated.
 */
#define ADC_SWTRIG_SWT2(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT2_SHIFT)) & ADC_SWTRIG_SWT2_MASK)

#define ADC_SWTRIG_SWT3_MASK                     (0x8U)
#define ADC_SWTRIG_SWT3_SHIFT                    (3U)
/*! SWT3 - Software Trigger 3
 *  0b0..No trigger 3 event generated.
 *  0b1..Trigger 3 event generated.
 */
#define ADC_SWTRIG_SWT3(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT3_SHIFT)) & ADC_SWTRIG_SWT3_MASK)
/*! @} */

/*! @name TSTAT - Trigger Status Register */
/*! @{ */

#define ADC_TSTAT_TEXC_NUM_MASK                  (0xFU)
#define ADC_TSTAT_TEXC_NUM_SHIFT                 (0U)
/*! TEXC_NUM - Trigger Exception Number
 *  0b0000..No triggers have been interrupted by a high-priority exception.
 *  0b0001..Trigger 0 has been interrupted by a high-priority exception.
 *  0b0010..Trigger 1 has been interrupted by a high-priority exception.
 *  0b0011-0b1110..Associated trigger sequence has interrupted by a high-priority exception.
 *  0b1111..Every trigger sequence has been interrupted by a high-priority exception.
 */
#define ADC_TSTAT_TEXC_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TEXC_NUM_SHIFT)) & ADC_TSTAT_TEXC_NUM_MASK)

#define ADC_TSTAT_TCOMP_FLAG_MASK                (0xF0000U)
#define ADC_TSTAT_TCOMP_FLAG_SHIFT               (16U)
/*! TCOMP_FLAG - Trigger Completion Flag
 *  0b0000..No triggers have been completed. Trigger completion interrupts are disabled.
 *  0b0001..Trigger 0 has been completed and trigger 0 has enabled completion interrupts.
 *  0b0010..Trigger 1 has been completed and trigger 1 has enabled completion interrupts.
 *  0b0011-0b1110..Associated trigger sequence has completed and has enabled completion interrupts.
 *  0b1111..Every trigger sequence has been completed and every trigger has enabled completion interrupts.
 */
#define ADC_TSTAT_TCOMP_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TCOMP_FLAG_SHIFT)) & ADC_TSTAT_TCOMP_FLAG_MASK)
/*! @} */

/*! @name OFSTRIM - Offset Trim Register */
/*! @{ */

#define ADC_OFSTRIM_OFSTRIM_A_MASK               (0x1FU)
#define ADC_OFSTRIM_OFSTRIM_A_SHIFT              (0U)
/*! OFSTRIM_A - Trim for Offset */
#define ADC_OFSTRIM_OFSTRIM_A(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_A_SHIFT)) & ADC_OFSTRIM_OFSTRIM_A_MASK)

#define ADC_OFSTRIM_OFSTRIM_B_MASK               (0x1F0000U)
#define ADC_OFSTRIM_OFSTRIM_B_SHIFT              (16U)
/*! OFSTRIM_B - Trim for Offset */
#define ADC_OFSTRIM_OFSTRIM_B(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_B_SHIFT)) & ADC_OFSTRIM_OFSTRIM_B_MASK)
/*! @} */

/*! @name TCTRL - Trigger Control Register */
/*! @{ */

#define ADC_TCTRL_HTEN_MASK                      (0x1U)
#define ADC_TCTRL_HTEN_SHIFT                     (0U)
/*! HTEN - Trigger Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_TCTRL_HTEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_HTEN_SHIFT)) & ADC_TCTRL_HTEN_MASK)

#define ADC_TCTRL_FIFO_SEL_A_MASK                (0x2U)
#define ADC_TCTRL_FIFO_SEL_A_SHIFT               (1U)
/*! FIFO_SEL_A - SAR Result Destination for Channel A
 *  0b0..FIFO 0
 *  0b1..FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_A(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_A_SHIFT)) & ADC_TCTRL_FIFO_SEL_A_MASK)

#define ADC_TCTRL_FIFO_SEL_B_MASK                (0x4U)
#define ADC_TCTRL_FIFO_SEL_B_SHIFT               (2U)
/*! FIFO_SEL_B - SAR Result Destination for Channel B
 *  0b0..FIFO 0
 *  0b1..FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_B(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_B_SHIFT)) & ADC_TCTRL_FIFO_SEL_B_MASK)

#define ADC_TCTRL_TPRI_MASK                      (0x300U)
#define ADC_TCTRL_TPRI_SHIFT                     (8U)
/*! TPRI - Trigger Priority Setting
 *  0b00..Highest priority, Level 1
 *  0b01-0b10..Set to corresponding priority level.
 *  0b11..Lowest priority, Level 4
 */
#define ADC_TCTRL_TPRI(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TPRI_SHIFT)) & ADC_TCTRL_TPRI_MASK)

#define ADC_TCTRL_RSYNC_MASK                     (0x8000U)
#define ADC_TCTRL_RSYNC_SHIFT                    (15U)
/*! RSYNC - Trigger Resync
 *  0b0..Disable
 *  0b1..Enable
 */
#define ADC_TCTRL_RSYNC(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_RSYNC_SHIFT)) & ADC_TCTRL_RSYNC_MASK)

#define ADC_TCTRL_TDLY_MASK                      (0xF0000U)
#define ADC_TCTRL_TDLY_SHIFT                     (16U)
/*! TDLY - Trigger Delay Select */
#define ADC_TCTRL_TDLY(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TDLY_SHIFT)) & ADC_TCTRL_TDLY_MASK)

#define ADC_TCTRL_TCMD_MASK                      (0xF000000U)
#define ADC_TCTRL_TCMD_SHIFT                     (24U)
/*! TCMD - Trigger Command Select
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..CMD1
 *  0b0010-0b1110..Corresponding CMD is executed
 *  0b1111..CMD15
 */
#define ADC_TCTRL_TCMD(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TCMD_SHIFT)) & ADC_TCTRL_TCMD_MASK)
/*! @} */

/* The count of ADC_TCTRL */
#define ADC_TCTRL_COUNT                          (4U)

/*! @name FCTRL - FIFO Control Register */
/*! @{ */

#define ADC_FCTRL_FCOUNT_MASK                    (0x1FU)
#define ADC_FCTRL_FCOUNT_SHIFT                   (0U)
/*! FCOUNT - Result FIFO Counter */
#define ADC_FCTRL_FCOUNT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FCOUNT_SHIFT)) & ADC_FCTRL_FCOUNT_MASK)

#define ADC_FCTRL_FWMARK_MASK                    (0xF0000U)
#define ADC_FCTRL_FWMARK_SHIFT                   (16U)
/*! FWMARK - Watermark Level Selection */
#define ADC_FCTRL_FWMARK(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FWMARK_SHIFT)) & ADC_FCTRL_FWMARK_MASK)
/*! @} */

/* The count of ADC_FCTRL */
#define ADC_FCTRL_COUNT                          (2U)

/*! @name GCC - Gain Calibration Control */
/*! @{ */

#define ADC_GCC_GAIN_CAL_MASK                    (0xFFFFU)
#define ADC_GCC_GAIN_CAL_SHIFT                   (0U)
/*! GAIN_CAL - Gain Calibration Value */
#define ADC_GCC_GAIN_CAL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_GCC_GAIN_CAL_SHIFT)) & ADC_GCC_GAIN_CAL_MASK)

#define ADC_GCC_RDY_MASK                         (0x1000000U)
#define ADC_GCC_RDY_SHIFT                        (24U)
/*! RDY - Gain Calibration Value Valid
 *  0b0..Invalid
 *  0b1..Valid
 */
#define ADC_GCC_RDY(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GCC_RDY_SHIFT)) & ADC_GCC_RDY_MASK)
/*! @} */

/* The count of ADC_GCC */
#define ADC_GCC_COUNT                            (2U)

/*! @name GCR - Gain Calculation Result */
/*! @{ */

#define ADC_GCR_GCALR_MASK                       (0xFFFFU)
#define ADC_GCR_GCALR_SHIFT                      (0U)
/*! GCALR - Gain Calculation Result */
#define ADC_GCR_GCALR(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_GCR_GCALR_SHIFT)) & ADC_GCR_GCALR_MASK)

#define ADC_GCR_RDY_MASK                         (0x1000000U)
#define ADC_GCR_RDY_SHIFT                        (24U)
/*! RDY - Gain Calculation Ready
 *  0b0..Invalid
 *  0b1..Valid
 */
#define ADC_GCR_RDY(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GCR_RDY_SHIFT)) & ADC_GCR_RDY_MASK)
/*! @} */

/* The count of ADC_GCR */
#define ADC_GCR_COUNT                            (2U)

/*! @name CMDL - Command Low Buffer Register */
/*! @{ */

#define ADC_CMDL_ADCH_MASK                       (0x1FU)
#define ADC_CMDL_ADCH_SHIFT                      (0U)
/*! ADCH - Input Channel Select
 *  0b00000..CH0A or CH0B or CH0A/CH0B pair.
 *  0b00001..CH1A or CH1B or CH1A/CH1B pair.
 *  0b00010..CH2A or CH2B or CH2A/CH2B pair.
 *  0b00011..CH3A or CH3B or CH3A/CH3B pair.
 *  0b00100-0b11101..Select corresponding channel CHnA or CHnB or CHnA/CHnB pair.
 *  0b11110..CH30A or CH30B or CH30A/CH30B pair.
 *  0b11111..CH31A or CH31B or CH31A/CH31B pair.
 */
#define ADC_CMDL_ADCH(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ADCH_SHIFT)) & ADC_CMDL_ADCH_MASK)

#define ADC_CMDL_CTYPE_MASK                      (0x60U)
#define ADC_CMDL_CTYPE_SHIFT                     (5U)
/*! CTYPE - Conversion Type
 *  0b00..Single-Ended mode. Only A-side channel is converted.
 *  0b01..Single-Ended mode. Only B-side channel is converted.
 *  0b10..Differential mode. A-B.
 *  0b11..Dual-Single-Ended mode. Both A-side and B-side channels are converted independently.
 */
#define ADC_CMDL_CTYPE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_CTYPE_SHIFT)) & ADC_CMDL_CTYPE_MASK)

#define ADC_CMDL_MODE_MASK                       (0x80U)
#define ADC_CMDL_MODE_SHIFT                      (7U)
/*! MODE - Select Resolution of Conversions
 *  0b0..Standard resolution. Single-ended 12-bit conversion; differential 13-bit conversion with 2's complement output.
 *  0b1..High resolution. Single-ended 16-bit conversion; differential 16-bit conversion with 2's complement output.
 */
#define ADC_CMDL_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_MODE_SHIFT)) & ADC_CMDL_MODE_MASK)

#define ADC_CMDL_ALTB_ADCH_MASK                  (0x1F0000U)
#define ADC_CMDL_ALTB_ADCH_SHIFT                 (16U)
/*! ALTB_ADCH - Alternate Channel B Input Channel Select
 *  0b00000..Select CH0B
 *  0b00001..Select CH1B
 *  0b00010..Select CH2B
 *  0b00011..Select CH3B
 *  0b00100-0b11101..Select corresponding channel CHnB
 *  0b11110..Select CH30B
 *  0b11111..Select CH31B
 */
#define ADC_CMDL_ALTB_ADCH(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ALTB_ADCH_SHIFT)) & ADC_CMDL_ALTB_ADCH_MASK)

#define ADC_CMDL_ALTBEN_MASK                     (0x200000U)
#define ADC_CMDL_ALTBEN_SHIFT                    (21U)
/*! ALTBEN - Alternate Channel B Select Enable
 *  0b0..ALTBEN_ADCH disabled. Channel-A and Channel-B inputs are selected based on ADCH settings.
 *  0b1..ALTBEN_ADCH enabled. Channel-A inputs are selected by ADCH setting and Channel-B inputs are selected by ALTB_ADCH setting.
 */
#define ADC_CMDL_ALTBEN(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ALTBEN_SHIFT)) & ADC_CMDL_ALTBEN_MASK)
/*! @} */

/* The count of ADC_CMDL */
#define ADC_CMDL_COUNT                           (15U)

/*! @name CMDH - Command High Buffer Register */
/*! @{ */

#define ADC_CMDH_CMPEN_MASK                      (0x3U)
#define ADC_CMDH_CMPEN_SHIFT                     (0U)
/*! CMPEN - Compare Function Enable
 *  0b00..Disabled
 *  0b01..
 *  0b10..Enabled. Store on true.
 *  0b11..Enabled. Repeat channel acquisition (sample, convert, and compare) until true.
 */
#define ADC_CMDH_CMPEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_CMPEN_SHIFT)) & ADC_CMDH_CMPEN_MASK)

#define ADC_CMDH_WAIT_TRIG_MASK                  (0x4U)
#define ADC_CMDH_WAIT_TRIG_SHIFT                 (2U)
/*! WAIT_TRIG - Wait for Trigger Assertion Before Execution
 *  0b0..Command executes automatically.
 *  0b1..Active trigger must be asserted again before executing this command.
 */
#define ADC_CMDH_WAIT_TRIG(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_WAIT_TRIG_SHIFT)) & ADC_CMDH_WAIT_TRIG_MASK)

#define ADC_CMDH_LWI_MASK                        (0x80U)
#define ADC_CMDH_LWI_SHIFT                       (7U)
/*! LWI - Loop with Increment
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define ADC_CMDH_LWI(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LWI_SHIFT)) & ADC_CMDH_LWI_MASK)

#define ADC_CMDH_STS_MASK                        (0x700U)
#define ADC_CMDH_STS_SHIFT                       (8U)
/*! STS - Sample Time Select
 *  0b000..Minimum sample time of 3.5 ADCK cycles.
 *  0b001..5.5 ADCK cycles
 *  0b010..7.5 ADCK cycles
 *  0b011..11.5 ADCK cycles
 *  0b100..19.5 ADCK cycles
 *  0b101..35.5 ADCK cycles
 *  0b110..67.5 ADCK cycles
 *  0b111..131.5 ADCK cycles
 */
#define ADC_CMDH_STS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_STS_SHIFT)) & ADC_CMDH_STS_MASK)

#define ADC_CMDH_AVGS_MASK                       (0xF000U)
#define ADC_CMDH_AVGS_SHIFT                      (12U)
/*! AVGS - Hardware Average Select
 *  0b0000..Single conversion
 *  0b0001..2
 *  0b0010..4
 *  0b0011..8
 *  0b0100..16
 *  0b0101..32
 *  0b0110..64
 *  0b0111..128
 *  0b1000..256
 *  0b1001..512
 *  0b1010..1024
 */
#define ADC_CMDH_AVGS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_AVGS_SHIFT)) & ADC_CMDH_AVGS_MASK)

#define ADC_CMDH_LOOP_MASK                       (0xF0000U)
#define ADC_CMDH_LOOP_SHIFT                      (16U)
/*! LOOP - Loop Count Select
 *  0b0000..Looping not enabled. Command executes one time.
 *  0b0001..Loop one time. Command executes two times.
 *  0b0010..Loop two times. Command executes three times.
 *  0b0011-0b1110..Loop corresponding number of times. Command executes LOOP + 1 times.
 *  0b1111..Loop 15 times. Command executes 16 times.
 */
#define ADC_CMDH_LOOP(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LOOP_SHIFT)) & ADC_CMDH_LOOP_MASK)

#define ADC_CMDH_NEXT_MASK                       (0xF000000U)
#define ADC_CMDH_NEXT_SHIFT                      (24U)
/*! NEXT - Next Command Select
 *  0b0000..No next command defined. Terminate conversions at completion of current command. If lower priority
 *          trigger pending, begin command associated with lower priority trigger.
 *  0b0001..CMD1
 *  0b0010-0b1110..Select corresponding CMD command buffer register as next command
 *  0b1111..CMD15
 */
#define ADC_CMDH_NEXT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_NEXT_SHIFT)) & ADC_CMDH_NEXT_MASK)
/*! @} */

/* The count of ADC_CMDH */
#define ADC_CMDH_COUNT                           (15U)

/*! @name CV - Compare Value Register */
/*! @{ */

#define ADC_CV_CVL_MASK                          (0xFFFFU)
#define ADC_CV_CVL_SHIFT                         (0U)
/*! CVL - Compare Value Low */
#define ADC_CV_CVL(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVL_SHIFT)) & ADC_CV_CVL_MASK)

#define ADC_CV_CVH_MASK                          (0xFFFF0000U)
#define ADC_CV_CVH_SHIFT                         (16U)
/*! CVH - Compare Value High */
#define ADC_CV_CVH(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVH_SHIFT)) & ADC_CV_CVH_MASK)
/*! @} */

/* The count of ADC_CV */
#define ADC_CV_COUNT                             (15U)

/*! @name RESFIFO - Data Result FIFO Register */
/*! @{ */

#define ADC_RESFIFO_D_MASK                       (0xFFFFU)
#define ADC_RESFIFO_D_SHIFT                      (0U)
/*! D - Data Result */
#define ADC_RESFIFO_D(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_D_SHIFT)) & ADC_RESFIFO_D_MASK)

#define ADC_RESFIFO_TSRC_MASK                    (0x30000U)
#define ADC_RESFIFO_TSRC_SHIFT                   (16U)
/*! TSRC - Trigger Source
 *  0b00..Trigger source 0
 *  0b01..Trigger source 1
 *  0b10..Trigger source 2
 *  0b11..Trigger source 3
 */
#define ADC_RESFIFO_TSRC(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_TSRC_SHIFT)) & ADC_RESFIFO_TSRC_MASK)

#define ADC_RESFIFO_LOOPCNT_MASK                 (0xF00000U)
#define ADC_RESFIFO_LOOPCNT_SHIFT                (20U)
/*! LOOPCNT - Loop Count Value
 *  0b0000..Result is from initial conversion in command.
 *  0b0001..Result is from second conversion in command.
 *  0b0010-0b1110..Result is from (LOOPCNT + 1) conversion in command.
 *  0b1111..Result is from 16th conversion in command.
 */
#define ADC_RESFIFO_LOOPCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_LOOPCNT_SHIFT)) & ADC_RESFIFO_LOOPCNT_MASK)

#define ADC_RESFIFO_CMDSRC_MASK                  (0xF000000U)
#define ADC_RESFIFO_CMDSRC_SHIFT                 (24U)
/*! CMDSRC - Command Buffer Source
 *  0b0000..Not a valid value CMDSRC value for a data word in RESFIFO. 0h is only found in the initial FIFO state,
 *          prior to the storage of an ADC conversion result into a RESFIFO buffer.
 *  0b0001..CMD1
 *  0b0010-0b1110..Corresponding command buffer used as control settings for this conversion.
 *  0b1111..CMD15
 */
#define ADC_RESFIFO_CMDSRC(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_CMDSRC_SHIFT)) & ADC_RESFIFO_CMDSRC_MASK)

#define ADC_RESFIFO_VALID_MASK                   (0x80000000U)
#define ADC_RESFIFO_VALID_SHIFT                  (31U)
/*! VALID - FIFO Entry is Valid
 *  0b0..FIFO is empty. Discard any read from RESFIFO.
 *  0b1..FIFO contains data. FIFO record read from RESFIFO is valid.
 */
#define ADC_RESFIFO_VALID(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_VALID_SHIFT)) & ADC_RESFIFO_VALID_MASK)
/*! @} */

/* The count of ADC_RESFIFO */
#define ADC_RESFIFO_COUNT                        (2U)

/*! @name CAL_GAR - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR_CAL_GAR_VAL_MASK             (0xFFFFU)  /* Merged from fields with different position or width, of widths (11, 12, 13, 14, 15, 16), largest definition used */
#define ADC_CAL_GAR_CAL_GAR_VAL_SHIFT            (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element */
#define ADC_CAL_GAR_CAL_GAR_VAL(x)               (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR_CAL_GAR_VAL_MASK)  /* Merged from fields with different position or width, of widths (11, 12, 13, 14, 15, 16), largest definition used */
/*! @} */

/* The count of ADC_CAL_GAR */
#define ADC_CAL_GAR_COUNT                        (33U)

/*! @name CAL_GBR - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR_CAL_GBR_VAL_MASK             (0xFFFFU)  /* Merged from fields with different position or width, of widths (11, 12, 13, 14, 15, 16), largest definition used */
#define ADC_CAL_GBR_CAL_GBR_VAL_SHIFT            (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element */
#define ADC_CAL_GBR_CAL_GBR_VAL(x)               (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR_CAL_GBR_VAL_MASK)  /* Merged from fields with different position or width, of widths (11, 12, 13, 14, 15, 16), largest definition used */
/*! @} */

/* The count of ADC_CAL_GBR */
#define ADC_CAL_GBR_COUNT                        (33U)


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral ADC0 base address */
  #define ADC0_BASE                                (0x5010D000u)
  /** Peripheral ADC0 base address */
  #define ADC0_BASE_NS                             (0x4010D000u)
  /** Peripheral ADC0 base pointer */
  #define ADC0                                     ((ADC_Type *)ADC0_BASE)
  /** Peripheral ADC0 base pointer */
  #define ADC0_NS                                  ((ADC_Type *)ADC0_BASE_NS)
  /** Peripheral ADC1 base address */
  #define ADC1_BASE                                (0x5010E000u)
  /** Peripheral ADC1 base address */
  #define ADC1_BASE_NS                             (0x4010E000u)
  /** Peripheral ADC1 base pointer */
  #define ADC1                                     ((ADC_Type *)ADC1_BASE)
  /** Peripheral ADC1 base pointer */
  #define ADC1_NS                                  ((ADC_Type *)ADC1_BASE_NS)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { ADC0_BASE, ADC1_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { ADC0, ADC1 }
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS_NS                        { ADC0_BASE_NS, ADC1_BASE_NS }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS_NS                         { ADC0_NS, ADC1_NS }
#else
  /** Peripheral ADC0 base address */
  #define ADC0_BASE                                (0x4010D000u)
  /** Peripheral ADC0 base pointer */
  #define ADC0                                     ((ADC_Type *)ADC0_BASE)
  /** Peripheral ADC1 base address */
  #define ADC1_BASE                                (0x4010E000u)
  /** Peripheral ADC1 base pointer */
  #define ADC1                                     ((ADC_Type *)ADC1_BASE)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { ADC0_BASE, ADC1_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { ADC0, ADC1 }
#endif
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS                                 { ADC0_IRQn, ADC1_IRQn }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AHBSC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AHBSC_Peripheral_Access_Layer AHBSC Peripheral Access Layer
 * @{
 */

/** AHBSC - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t FLASH00_MEM_RULE[4];               /**< Flash Memory Rule, array offset: 0x10, array step: 0x4 */
  __IO uint32_t FLASH01_MEM_RULE[4];               /**< Flash Memory Rule, array offset: 0x20, array step: 0x4 */
  __IO uint32_t FLASH02_MEM_RULE;                  /**< Flash Memory Rule, offset: 0x30 */
       uint8_t RESERVED_1[12];
  __IO uint32_t FLASH03_MEM_RULE;                  /**< Flash Memory Rule, offset: 0x40 */
       uint8_t RESERVED_2[28];
  __IO uint32_t ROM_MEM_RULE[4];                   /**< ROM Memory Rule, array offset: 0x60, array step: 0x4 */
       uint8_t RESERVED_3[16];
  __IO uint32_t RAMX_MEM_RULE[3];                  /**< RAMX Memory Rule, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_4[20];
  __IO uint32_t RAMA_MEM_RULE;                     /**< RAMA Memory Rule 0, offset: 0xA0 */
       uint8_t RESERVED_5[28];
  __IO uint32_t RAMB_MEM_RULE;                     /**< RAMB Memory Rule, offset: 0xC0 */
       uint8_t RESERVED_6[28];
  __IO uint32_t RAMC_MEM_RULE[2];                  /**< RAMC Memory Rule, array offset: 0xE0, array step: 0x4 */
       uint8_t RESERVED_7[24];
  __IO uint32_t RAMD_MEM_RULE[2];                  /**< RAMD Memory Rule, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_8[24];
  __IO uint32_t RAME_MEM_RULE[2];                  /**< RAME Memory Rule, array offset: 0x120, array step: 0x4 */
       uint8_t RESERVED_9[24];
  __IO uint32_t RAMF_MEM_RULE[2];                  /**< RAMF Memory Rule, array offset: 0x140, array step: 0x4 */
       uint8_t RESERVED_10[24];
  __IO uint32_t RAMG_MEM_RULE[2];                  /**< RAMG Memory Rule, array offset: 0x160, array step: 0x4 */
       uint8_t RESERVED_11[24];
  __IO uint32_t RAMH_MEM_RULE;                     /**< RAMH Memory Rule, offset: 0x180 */
       uint8_t RESERVED_12[28];
  __IO uint32_t APB_PERIPHERAL_GROUP0_MEM_RULE0;   /**< APB Bridge Group 0 Memory Rule 0, offset: 0x1A0 */
  __IO uint32_t APB_PERIPHERAL_GROUP0_MEM_RULE1;   /**< APB Bridge Group 0 Memory Rule 1, offset: 0x1A4 */
  __IO uint32_t APB_PERIPHERAL_GROUP0_MEM_RULE2;   /**< APB Bridge Group 0 Rule 2, offset: 0x1A8 */
  __IO uint32_t APB_PERIPHERAL_GROUP0_MEM_RULE3;   /**< APB Bridge Group 0 Memory Rule 3, offset: 0x1AC */
  __IO uint32_t APB_PERIPHERAL_GROUP1_MEM_RULE0;   /**< APB Bridge Group 1 Memory Rule 0, offset: 0x1B0 */
  __IO uint32_t APB_PERIPHERAL_GROUP1_MEM_RULE1;   /**< APB Bridge Group 1 Memory Rule 1, offset: 0x1B4 */
       uint8_t RESERVED_13[4];
  __IO uint32_t APB_PERIPHERAL_GROUP1_MEM_RULE2;   /**< APB Bridge Group 1 Memory Rule 2, offset: 0x1BC */
  __IO uint32_t AIPS_BRIDGE_GROUP0_MEM_RULE0;      /**< AIPS Bridge Group 0 Memory Rule 0, offset: 0x1C0 */
  __IO uint32_t AIPS_BRIDGE_GROUP0_MEM_RULE1;      /**< AIPS Bridge Group 0 Memory Rule 1, offset: 0x1C4 */
  __IO uint32_t AIPS_BRIDGE_GROUP0_MEM_RULE2;      /**< AIPS Bridge Group 0 Memory Rule 2, offset: 0x1C8 */
  __IO uint32_t AIPS_BRIDGE_GROUP0_MEM_RULE3;      /**< AIPS Bridge Group 0 Memory Rule 3, offset: 0x1CC */
  __IO uint32_t AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0; /**< AHB Peripheral 0 Slave Port 12 Slave Rule 0, offset: 0x1D0 */
  __IO uint32_t AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1; /**< AHB Peripheral 0 Slave Port 12 Slave Rule 1, offset: 0x1D4 */
  __IO uint32_t AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2; /**< AHB Peripheral 0 Slave Port 12 Slave Rule 2, offset: 0x1D8 */
       uint8_t RESERVED_14[4];
  __IO uint32_t AIPS_BRIDGE_GROUP1_MEM_RULE0;      /**< AIPS Bridge Group 1 Rule 0, offset: 0x1E0 */
  __IO uint32_t AIPS_BRIDGE_GROUP1_MEM_RULE1;      /**< AIPS Bridge Group 1 Rule 1, offset: 0x1E4 */
       uint8_t RESERVED_15[8];
  __IO uint32_t AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0; /**< AHB Peripheral 1 Slave Port 13 Slave Rule 0, offset: 0x1F0 */
  __IO uint32_t AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1; /**< AHB Peripheral 1 Slave Port 13 Slave Rule 1, offset: 0x1F4 */
  __IO uint32_t AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE2; /**< AHB Peripheral 1 Slave Port 13 Slave Rule 2, offset: 0x1F8 */
       uint8_t RESERVED_16[4];
  __IO uint32_t AIPS_BRIDGE_GROUP2_MEM_RULE0;      /**< AIPS Bridge Group 2 Rule 0, offset: 0x200 */
  __IO uint32_t AIPS_BRIDGE_GROUP2_MEM_RULE1;      /**< AIPS Bridge Group 2 Memory Rule 1, offset: 0x204 */
       uint8_t RESERVED_17[24];
  __IO uint32_t AIPS_BRIDGE_GROUP3_MEM_RULE0;      /**< AIPS Bridge Group 3 Rule 0, offset: 0x220 */
  __IO uint32_t AIPS_BRIDGE_GROUP3_MEM_RULE1;      /**< AIPS Bridge Group 3 Memory Rule 1, offset: 0x224 */
  __IO uint32_t AIPS_BRIDGE_GROUP3_MEM_RULE2;      /**< AIPS Bridge Group 3 Rule 2, offset: 0x228 */
  __IO uint32_t AIPS_BRIDGE_GROUP3_MEM_RULE3;      /**< AIPS Bridge Group 3 Rule 3, offset: 0x22C */
       uint8_t RESERVED_18[16];
  __IO uint32_t AIPS_BRIDGE_GROUP4_MEM_RULE0;      /**< AIPS Bridge Group 4 Rule 0, offset: 0x240 */
  __IO uint32_t AIPS_BRIDGE_GROUP4_MEM_RULE1;      /**< AIPS Bridge Group 4 Rule 1, offset: 0x244 */
  __IO uint32_t AIPS_BRIDGE_GROUP4_MEM_RULE2;      /**< AIPS Bridge Group 4 Rule 2, offset: 0x248 */
  __IO uint32_t AIPS_BRIDGE_GROUP4_MEM_RULE3;      /**< AIPS Bridge Group 4 Rule 3, offset: 0x24C */
  __IO uint32_t AHB_SECURE_CTRL_PERIPHERAL_RULE0;  /**< AHB Secure Control Peripheral Rule 0, offset: 0x250 */
       uint8_t RESERVED_19[28];
  __IO uint32_t FLEXSPI0_REGION0_MEM_RULE[4];      /**< FLEXSPI0 Region 0 Memory Rule, array offset: 0x270, array step: 0x4 */
  struct {                                         /* offset: 0x280, array step: 0x10 */
    __IO uint32_t FLEXSPI0_REGION_MEM_RULE0;         /**< FLEXSPI0 Region 1 Memory Rule 0..FLEXSPI0 Region 6 Memory Rule 0, array offset: 0x280, array step: 0x10 */
         uint8_t RESERVED_0[12];
  } FLEXSPI0_REGION1_6_MEM_RULE[6];
  __IO uint32_t FLEXSPI0_REGION7_MEM_RULE[4];      /**< FLEXSPI0 Region 7 Memory Rule, array offset: 0x2E0, array step: 0x4 */
  struct {                                         /* offset: 0x2F0, array step: 0x10 */
    __IO uint32_t FLEXSPI0_REGION_MEM_RULE0;         /**< FLEXSPI0 Region 8 Memory Rule 0..FLEXSPI0 Region 13 Memory Rule 0, array offset: 0x2F0, array step: 0x10 */
         uint8_t RESERVED_0[12];
  } FLEXSPI0_REGION8_13_MEM_RULE[6];
       uint8_t RESERVED_20[2736];
  __I  uint32_t SEC_VIO_ADDR[32];                  /**< Security Violation Address, array offset: 0xE00, array step: 0x4 */
  __I  uint32_t SEC_VIO_MISC_INFO[32];             /**< Security Violation Miscellaneous Information at Address, array offset: 0xE80, array step: 0x4 */
  __IO uint32_t SEC_VIO_INFO_VALID;                /**< Security Violation Info Validity for Address, offset: 0xF00 */
       uint8_t RESERVED_21[124];
  __IO uint32_t SEC_GPIO_MASK[2];                  /**< GPIO Mask for Port 0..GPIO Mask for Port 1, array offset: 0xF80, array step: 0x4 */
       uint8_t RESERVED_22[16];
  __IO uint32_t SEC_CPU1_INT_MASK0;                /**< Secure Interrupt Mask 0 for CPU1, offset: 0xF98 */
  __IO uint32_t SEC_CPU1_INT_MASK1;                /**< Secure Interrupt Mask 1 for CPU1, offset: 0xF9C */
  __IO uint32_t SEC_CPU1_INT_MASK2;                /**< Secure Interrupt Mask 2 for CPU1, offset: 0xFA0 */
  __IO uint32_t SEC_CPU1_INT_MASK3;                /**< Secure Interrupt Mask 3 for CPU1, offset: 0xFA4 */
  __IO uint32_t SEC_CPU1_INT_MASK4;                /**< Secure Interrupt Mask 4 for CPU1, offset: 0xFA8 */
       uint8_t RESERVED_23[16];
  __IO uint32_t SEC_GP_REG_LOCK;                   /**< Secure Mask Lock, offset: 0xFBC */
       uint8_t RESERVED_24[16];
  __IO uint32_t MASTER_SEC_LEVEL;                  /**< Master Secure Level, offset: 0xFD0 */
  __IO uint32_t MASTER_SEC_ANTI_POL_REG;           /**< Master Secure Level, offset: 0xFD4 */
       uint8_t RESERVED_25[20];
  __IO uint32_t CPU0_LOCK_REG;                     /**< Miscellaneous CPU0 Control Signals, offset: 0xFEC */
  __IO uint32_t CPU1_LOCK_REG;                     /**< Miscellaneous CPU1 Control Signals, offset: 0xFF0 */
       uint8_t RESERVED_26[4];
  __IO uint32_t MISC_CTRL_DP_REG;                  /**< Secure Control Duplicate, offset: 0xFF8 */
  __IO uint32_t MISC_CTRL_REG;                     /**< Secure Control, offset: 0xFFC */
} AHBSC_Type;

/* ----------------------------------------------------------------------------
   -- AHBSC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AHBSC_Register_Masks AHBSC Register Masks
 * @{
 */

/*! @name FLASH00_MEM_RULE - Flash Memory Rule */
/*! @{ */

#define AHBSC_FLASH00_MEM_RULE_RULE0_MASK        (0x3U)
#define AHBSC_FLASH00_MEM_RULE_RULE0_SHIFT       (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE0(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE0_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE0_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE1_MASK        (0x30U)
#define AHBSC_FLASH00_MEM_RULE_RULE1_SHIFT       (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE1(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE1_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE1_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE2_MASK        (0x300U)
#define AHBSC_FLASH00_MEM_RULE_RULE2_SHIFT       (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE2(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE2_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE2_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE3_MASK        (0x3000U)
#define AHBSC_FLASH00_MEM_RULE_RULE3_SHIFT       (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE3(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE3_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE3_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE4_MASK        (0x30000U)
#define AHBSC_FLASH00_MEM_RULE_RULE4_SHIFT       (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE4(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE4_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE4_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE5_MASK        (0x300000U)
#define AHBSC_FLASH00_MEM_RULE_RULE5_SHIFT       (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE5(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE5_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE5_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE6_MASK        (0x3000000U)
#define AHBSC_FLASH00_MEM_RULE_RULE6_SHIFT       (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE6(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE6_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE6_MASK)

#define AHBSC_FLASH00_MEM_RULE_RULE7_MASK        (0x30000000U)
#define AHBSC_FLASH00_MEM_RULE_RULE7_SHIFT       (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH00_MEM_RULE_RULE7(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH00_MEM_RULE_RULE7_SHIFT)) & AHBSC_FLASH00_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_FLASH00_MEM_RULE */
#define AHBSC_FLASH00_MEM_RULE_COUNT             (4U)

/*! @name FLASH01_MEM_RULE - Flash Memory Rule */
/*! @{ */

#define AHBSC_FLASH01_MEM_RULE_RULE0_MASK        (0x3U)
#define AHBSC_FLASH01_MEM_RULE_RULE0_SHIFT       (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH01_MEM_RULE_RULE0(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH01_MEM_RULE_RULE0_SHIFT)) & AHBSC_FLASH01_MEM_RULE_RULE0_MASK)

#define AHBSC_FLASH01_MEM_RULE_RULE1_MASK        (0x30U)
#define AHBSC_FLASH01_MEM_RULE_RULE1_SHIFT       (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH01_MEM_RULE_RULE1(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH01_MEM_RULE_RULE1_SHIFT)) & AHBSC_FLASH01_MEM_RULE_RULE1_MASK)

#define AHBSC_FLASH01_MEM_RULE_RULE2_MASK        (0x300U)
#define AHBSC_FLASH01_MEM_RULE_RULE2_SHIFT       (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH01_MEM_RULE_RULE2(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH01_MEM_RULE_RULE2_SHIFT)) & AHBSC_FLASH01_MEM_RULE_RULE2_MASK)

#define AHBSC_FLASH01_MEM_RULE_RULE3_MASK        (0x3000U)
#define AHBSC_FLASH01_MEM_RULE_RULE3_SHIFT       (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH01_MEM_RULE_RULE3(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH01_MEM_RULE_RULE3_SHIFT)) & AHBSC_FLASH01_MEM_RULE_RULE3_MASK)

#define AHBSC_FLASH01_MEM_RULE_RULE4_MASK        (0x30000U)
#define AHBSC_FLASH01_MEM_RULE_RULE4_SHIFT       (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH01_MEM_RULE_RULE4(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH01_MEM_RULE_RULE4_SHIFT)) & AHBSC_FLASH01_MEM_RULE_RULE4_MASK)

#define AHBSC_FLASH01_MEM_RULE_RULE5_MASK        (0x300000U)
#define AHBSC_FLASH01_MEM_RULE_RULE5_SHIFT       (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH01_MEM_RULE_RULE5(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH01_MEM_RULE_RULE5_SHIFT)) & AHBSC_FLASH01_MEM_RULE_RULE5_MASK)

#define AHBSC_FLASH01_MEM_RULE_RULE6_MASK        (0x3000000U)
#define AHBSC_FLASH01_MEM_RULE_RULE6_SHIFT       (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH01_MEM_RULE_RULE6(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH01_MEM_RULE_RULE6_SHIFT)) & AHBSC_FLASH01_MEM_RULE_RULE6_MASK)

#define AHBSC_FLASH01_MEM_RULE_RULE7_MASK        (0x30000000U)
#define AHBSC_FLASH01_MEM_RULE_RULE7_SHIFT       (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH01_MEM_RULE_RULE7(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH01_MEM_RULE_RULE7_SHIFT)) & AHBSC_FLASH01_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_FLASH01_MEM_RULE */
#define AHBSC_FLASH01_MEM_RULE_COUNT             (4U)

/*! @name FLASH02_MEM_RULE - Flash Memory Rule */
/*! @{ */

#define AHBSC_FLASH02_MEM_RULE_RULE0_MASK        (0x3U)
#define AHBSC_FLASH02_MEM_RULE_RULE0_SHIFT       (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH02_MEM_RULE_RULE0(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH02_MEM_RULE_RULE0_SHIFT)) & AHBSC_FLASH02_MEM_RULE_RULE0_MASK)

#define AHBSC_FLASH02_MEM_RULE_RULE1_MASK        (0x30U)
#define AHBSC_FLASH02_MEM_RULE_RULE1_SHIFT       (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH02_MEM_RULE_RULE1(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH02_MEM_RULE_RULE1_SHIFT)) & AHBSC_FLASH02_MEM_RULE_RULE1_MASK)

#define AHBSC_FLASH02_MEM_RULE_RULE2_MASK        (0x300U)
#define AHBSC_FLASH02_MEM_RULE_RULE2_SHIFT       (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH02_MEM_RULE_RULE2(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH02_MEM_RULE_RULE2_SHIFT)) & AHBSC_FLASH02_MEM_RULE_RULE2_MASK)

#define AHBSC_FLASH02_MEM_RULE_RULE3_MASK        (0x3000U)
#define AHBSC_FLASH02_MEM_RULE_RULE3_SHIFT       (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH02_MEM_RULE_RULE3(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH02_MEM_RULE_RULE3_SHIFT)) & AHBSC_FLASH02_MEM_RULE_RULE3_MASK)
/*! @} */

/*! @name FLASH03_MEM_RULE - Flash Memory Rule */
/*! @{ */

#define AHBSC_FLASH03_MEM_RULE_RULE0_MASK        (0x3U)
#define AHBSC_FLASH03_MEM_RULE_RULE0_SHIFT       (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE0(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE0_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE0_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE1_MASK        (0x30U)
#define AHBSC_FLASH03_MEM_RULE_RULE1_SHIFT       (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE1(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE1_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE1_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE2_MASK        (0x300U)
#define AHBSC_FLASH03_MEM_RULE_RULE2_SHIFT       (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE2(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE2_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE2_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE3_MASK        (0x3000U)
#define AHBSC_FLASH03_MEM_RULE_RULE3_SHIFT       (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE3(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE3_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE3_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE4_MASK        (0x30000U)
#define AHBSC_FLASH03_MEM_RULE_RULE4_SHIFT       (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE4(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE4_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE4_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE5_MASK        (0x300000U)
#define AHBSC_FLASH03_MEM_RULE_RULE5_SHIFT       (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE5(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE5_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE5_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE6_MASK        (0x3000000U)
#define AHBSC_FLASH03_MEM_RULE_RULE6_SHIFT       (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE6(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE6_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE6_MASK)

#define AHBSC_FLASH03_MEM_RULE_RULE7_MASK        (0x30000000U)
#define AHBSC_FLASH03_MEM_RULE_RULE7_SHIFT       (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLASH03_MEM_RULE_RULE7(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_FLASH03_MEM_RULE_RULE7_SHIFT)) & AHBSC_FLASH03_MEM_RULE_RULE7_MASK)
/*! @} */

/*! @name ROM_MEM_RULE - ROM Memory Rule */
/*! @{ */

#define AHBSC_ROM_MEM_RULE_RULE0_MASK            (0x3U)
#define AHBSC_ROM_MEM_RULE_RULE0_SHIFT           (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE0(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE0_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE0_MASK)

#define AHBSC_ROM_MEM_RULE_RULE1_MASK            (0x30U)
#define AHBSC_ROM_MEM_RULE_RULE1_SHIFT           (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE1(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE1_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE1_MASK)

#define AHBSC_ROM_MEM_RULE_RULE2_MASK            (0x300U)
#define AHBSC_ROM_MEM_RULE_RULE2_SHIFT           (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE2(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE2_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE2_MASK)

#define AHBSC_ROM_MEM_RULE_RULE3_MASK            (0x3000U)
#define AHBSC_ROM_MEM_RULE_RULE3_SHIFT           (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE3(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE3_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE3_MASK)

#define AHBSC_ROM_MEM_RULE_RULE4_MASK            (0x30000U)
#define AHBSC_ROM_MEM_RULE_RULE4_SHIFT           (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE4(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE4_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE4_MASK)

#define AHBSC_ROM_MEM_RULE_RULE5_MASK            (0x300000U)
#define AHBSC_ROM_MEM_RULE_RULE5_SHIFT           (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE5(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE5_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE5_MASK)

#define AHBSC_ROM_MEM_RULE_RULE6_MASK            (0x3000000U)
#define AHBSC_ROM_MEM_RULE_RULE6_SHIFT           (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE6(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE6_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE6_MASK)

#define AHBSC_ROM_MEM_RULE_RULE7_MASK            (0x30000000U)
#define AHBSC_ROM_MEM_RULE_RULE7_SHIFT           (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_ROM_MEM_RULE_RULE7(x)              (((uint32_t)(((uint32_t)(x)) << AHBSC_ROM_MEM_RULE_RULE7_SHIFT)) & AHBSC_ROM_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_ROM_MEM_RULE */
#define AHBSC_ROM_MEM_RULE_COUNT                 (4U)

/*! @name RAMX_MEM_RULE0_RAMX_MEM_RULE - RAMX Memory Rule */
/*! @{ */

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE0_MASK (0x3U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE1_MASK (0x30U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE2_MASK (0x300U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE3_MASK (0x3000U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE4_MASK (0x30000U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE5_MASK (0x300000U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE */
#define AHBSC_RAMX_MEM_RULE0_RAMX_MEM_RULE_COUNT (3U)

/*! @name RAMA_MEM_RULE - RAMA Memory Rule 0 */
/*! @{ */

#define AHBSC_RAMA_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMA_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMA_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMA_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMA_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMA_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMA_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMA_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMA_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMA_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMA_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMA_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMA_MEM_RULE_RULE7_MASK)
/*! @} */

/*! @name RAMB_MEM_RULE - RAMB Memory Rule */
/*! @{ */

#define AHBSC_RAMB_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMB_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMB_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMB_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMB_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMB_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMB_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMB_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMB_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMB_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMB_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMB_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMB_MEM_RULE_RULE7_MASK)
/*! @} */

/*! @name RAMC_MEM_RULE - RAMC Memory Rule */
/*! @{ */

#define AHBSC_RAMC_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMC_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMC_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMC_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMC_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMC_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMC_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMC_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMC_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMC_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMC_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMC_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMC_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_RAMC_MEM_RULE */
#define AHBSC_RAMC_MEM_RULE_COUNT                (2U)

/*! @name RAMD_MEM_RULE - RAMD Memory Rule */
/*! @{ */

#define AHBSC_RAMD_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMD_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMD_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMD_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMD_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMD_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMD_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMD_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMD_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMD_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMD_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMD_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMD_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_RAMD_MEM_RULE */
#define AHBSC_RAMD_MEM_RULE_COUNT                (2U)

/*! @name RAME_MEM_RULE - RAME Memory Rule */
/*! @{ */

#define AHBSC_RAME_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAME_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE0_MASK)

#define AHBSC_RAME_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAME_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE1_MASK)

#define AHBSC_RAME_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAME_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE2_MASK)

#define AHBSC_RAME_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAME_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE3_MASK)

#define AHBSC_RAME_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAME_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE4_MASK)

#define AHBSC_RAME_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAME_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE5_MASK)

#define AHBSC_RAME_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAME_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE6_MASK)

#define AHBSC_RAME_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAME_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAME_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAME_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAME_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_RAME_MEM_RULE */
#define AHBSC_RAME_MEM_RULE_COUNT                (2U)

/*! @name RAMF_MEM_RULE - RAMF Memory Rule */
/*! @{ */

#define AHBSC_RAMF_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMF_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMF_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMF_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMF_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMF_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMF_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMF_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMF_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMF_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMF_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMF_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMF_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMF_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMF_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMF_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMF_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMF_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMF_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMF_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMF_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMF_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMF_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMF_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMF_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMF_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMF_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMF_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMF_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMF_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMF_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMF_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMF_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMF_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMF_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMF_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMF_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMF_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMF_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMF_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_RAMF_MEM_RULE */
#define AHBSC_RAMF_MEM_RULE_COUNT                (2U)

/*! @name RAMG_MEM_RULE - RAMG Memory Rule */
/*! @{ */

#define AHBSC_RAMG_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMG_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMG_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMG_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMG_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMG_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMG_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMG_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMG_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMG_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMG_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMG_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMG_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMG_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMG_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMG_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMG_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMG_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMG_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMG_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMG_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMG_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMG_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMG_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMG_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMG_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMG_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMG_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMG_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMG_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMG_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMG_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMG_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMG_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMG_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMG_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMG_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMG_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMG_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMG_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_RAMG_MEM_RULE */
#define AHBSC_RAMG_MEM_RULE_COUNT                (2U)

/*! @name RAMH_MEM_RULE - RAMH Memory Rule */
/*! @{ */

#define AHBSC_RAMH_MEM_RULE_RULE0_MASK           (0x3U)
#define AHBSC_RAMH_MEM_RULE_RULE0_SHIFT          (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMH_MEM_RULE_RULE0(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMH_MEM_RULE_RULE0_SHIFT)) & AHBSC_RAMH_MEM_RULE_RULE0_MASK)

#define AHBSC_RAMH_MEM_RULE_RULE1_MASK           (0x30U)
#define AHBSC_RAMH_MEM_RULE_RULE1_SHIFT          (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMH_MEM_RULE_RULE1(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMH_MEM_RULE_RULE1_SHIFT)) & AHBSC_RAMH_MEM_RULE_RULE1_MASK)

#define AHBSC_RAMH_MEM_RULE_RULE2_MASK           (0x300U)
#define AHBSC_RAMH_MEM_RULE_RULE2_SHIFT          (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMH_MEM_RULE_RULE2(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMH_MEM_RULE_RULE2_SHIFT)) & AHBSC_RAMH_MEM_RULE_RULE2_MASK)

#define AHBSC_RAMH_MEM_RULE_RULE3_MASK           (0x3000U)
#define AHBSC_RAMH_MEM_RULE_RULE3_SHIFT          (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMH_MEM_RULE_RULE3(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMH_MEM_RULE_RULE3_SHIFT)) & AHBSC_RAMH_MEM_RULE_RULE3_MASK)

#define AHBSC_RAMH_MEM_RULE_RULE4_MASK           (0x30000U)
#define AHBSC_RAMH_MEM_RULE_RULE4_SHIFT          (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMH_MEM_RULE_RULE4(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMH_MEM_RULE_RULE4_SHIFT)) & AHBSC_RAMH_MEM_RULE_RULE4_MASK)

#define AHBSC_RAMH_MEM_RULE_RULE5_MASK           (0x300000U)
#define AHBSC_RAMH_MEM_RULE_RULE5_SHIFT          (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMH_MEM_RULE_RULE5(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMH_MEM_RULE_RULE5_SHIFT)) & AHBSC_RAMH_MEM_RULE_RULE5_MASK)

#define AHBSC_RAMH_MEM_RULE_RULE6_MASK           (0x3000000U)
#define AHBSC_RAMH_MEM_RULE_RULE6_SHIFT          (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMH_MEM_RULE_RULE6(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMH_MEM_RULE_RULE6_SHIFT)) & AHBSC_RAMH_MEM_RULE_RULE6_MASK)

#define AHBSC_RAMH_MEM_RULE_RULE7_MASK           (0x30000000U)
#define AHBSC_RAMH_MEM_RULE_RULE7_SHIFT          (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_RAMH_MEM_RULE_RULE7(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_RAMH_MEM_RULE_RULE7_SHIFT)) & AHBSC_RAMH_MEM_RULE_RULE7_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP0_MEM_RULE0 - APB Bridge Group 0 Memory Rule 0 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_SYSCON_MASK (0x3U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_SYSCON_SHIFT (0U)
/*! SYSCON - SYSCON
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_SYSCON(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_SYSCON_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_SYSCON_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_PINT0_MASK (0x30000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_PINT0_SHIFT (16U)
/*! PINT0 - PINT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_PINT0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_PINT0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_PINT0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_INPUTMUX_MASK (0x3000000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_INPUTMUX_SHIFT (24U)
/*! INPUTMUX - INPUTMUX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_INPUTMUX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_INPUTMUX_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE0_INPUTMUX_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP0_MEM_RULE1 - APB Bridge Group 0 Memory Rule 1 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER0_MASK (0x30000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER0_SHIFT (16U)
/*! CTIMER0 - CTIMER0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER1_MASK (0x300000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER1_SHIFT (20U)
/*! CTIMER1 - CTIMER1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER1_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER1_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER2_MASK (0x3000000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER2_SHIFT (24U)
/*! CTIMER2 - CTIMER2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER2_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER2_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER3_MASK (0x30000000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER3_SHIFT (28U)
/*! CTIMER3 - CTIMER3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER3_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE1_CTIMER3_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP0_MEM_RULE2 - APB Bridge Group 0 Rule 2 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_CTIMER4_MASK (0x3U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_CTIMER4_SHIFT (0U)
/*! CTIMER4 - CTIMER4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_CTIMER4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_CTIMER4_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_CTIMER4_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_FREQME0_MASK (0x30U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_FREQME0_SHIFT (4U)
/*! FREQME0 - FREQME0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_FREQME0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_FREQME0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_FREQME0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_UTCIK0_MASK (0x300U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_UTCIK0_SHIFT (8U)
/*! UTCIK0 - UTCIK0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_UTCIK0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_UTCIK0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_UTCIK0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_MRT0_MASK (0x3000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_MRT0_SHIFT (12U)
/*! MRT0 - MRT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_MRT0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_MRT0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_MRT0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_OSTIMER0_MASK (0x30000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_OSTIMER0_SHIFT (16U)
/*! OSTIMER0 - OSTIMER0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_OSTIMER0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_OSTIMER0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_OSTIMER0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT0_MASK (0x3000000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT0_SHIFT (24U)
/*! WWDT0 - WWDT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT1_MASK (0x30000000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT1_SHIFT (28U)
/*! WWDT1 - WWDT1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT1_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE2_WWDT1_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP0_MEM_RULE3 - APB Bridge Group 0 Memory Rule 3 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE3_CACHE64_POLSEL0_MASK (0x3000U)
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE3_CACHE64_POLSEL0_SHIFT (12U)
/*! CACHE64_POLSEL0 - CACHE64_POLSEL0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE3_CACHE64_POLSEL0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE3_CACHE64_POLSEL0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP0_MEM_RULE3_CACHE64_POLSEL0_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP1_MEM_RULE0 - APB Bridge Group 1 Memory Rule 0 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C0_MASK (0x30U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C0_SHIFT (4U)
/*! I3C0 - I3C0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C1_MASK (0x300U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C1_SHIFT (8U)
/*! I3C1 - I3C1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C1_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_I3C1_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_GDET_MASK (0x300000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_GDET_SHIFT (20U)
/*! GDET - GDET
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_GDET(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_GDET_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_GDET_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_ITRC_MASK (0x3000000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_ITRC_SHIFT (24U)
/*! ITRC - ITRC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_ITRC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_ITRC_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE0_ITRC_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP1_MEM_RULE1 - APB Bridge Group 1 Memory Rule 1 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PKC_MASK (0x3000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PKC_SHIFT (12U)
/*! PKC - PKC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PKC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PKC_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PKC_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS0_MASK (0x30000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS0_SHIFT (16U)
/*! PUF_ALIAS0 - PUF_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS0_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS0_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS1_MASK (0x300000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS1_SHIFT (20U)
/*! PUF_ALIAS1 - PUF_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS1_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS1_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS2_MASK (0x3000000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS2_SHIFT (24U)
/*! PUF_ALIAS2 - PUF_ALIAS2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS2_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS2_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS3_MASK (0x30000000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS3_SHIFT (28U)
/*! PUF_ALIAS3 - PUF_ALIAS3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS3_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE1_PUF_ALIAS3_MASK)
/*! @} */

/*! @name APB_PERIPHERAL_GROUP1_MEM_RULE2 - APB Bridge Group 1 Memory Rule 2 */
/*! @{ */

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SM3_MASK (0x30U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SM3_SHIFT (4U)
/*! SM3 - SM3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SM3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SM3_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SM3_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_COOLFLUX_MASK (0x300U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_COOLFLUX_SHIFT (8U)
/*! COOLFLUX - COOLFLUX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_COOLFLUX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_COOLFLUX_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_COOLFLUX_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SMARTDMA_MASK (0x3000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SMARTDMA_SHIFT (12U)
/*! SMARTDMA - SmartDMA
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SMARTDMA(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SMARTDMA_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_SMARTDMA_MASK)

#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_PLU_MASK (0x30000U)
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_PLU_SHIFT (16U)
/*! PLU - PLU
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_PLU(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_PLU_SHIFT)) & AHBSC_APB_PERIPHERAL_GROUP1_MEM_RULE2_PLU_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP0_MEM_RULE0 - AIPS Bridge Group 0 Memory Rule 0 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS0_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS0_SHIFT (0U)
/*! GPIO5_ALIAS0 - GPIO5_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS1_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS1_SHIFT (4U)
/*! GPIO5_ALIAS1 - GPIO5_ALIAS2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_GPIO5_ALIAS1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_PORT5_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_PORT5_SHIFT (8U)
/*! PORT5 - PORT5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_PORT5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_PORT5_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_PORT5_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_FMU0_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_FMU0_SHIFT (12U)
/*! FMU0 - FMU0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_FMU0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_FMU0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_FMU0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SCG0_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SCG0_SHIFT (16U)
/*! SCG0 - SCG0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SCG0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SCG0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SCG0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SPC0_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SPC0_SHIFT (20U)
/*! SPC0 - SPC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SPC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SPC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_SPC0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_WUU0_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_WUU0_SHIFT (24U)
/*! WUU0 - WUU0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_WUU0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_WUU0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_WUU0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_TRO0_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_TRO0_SHIFT (28U)
/*! TRO0 - TRO0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_TRO0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_TRO0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE0_TRO0_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP0_MEM_RULE1 - AIPS Bridge Group 0 Memory Rule 1 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR0_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR0_SHIFT (8U)
/*! LPTMR0 - LPTMR0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR1_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR1_SHIFT (12U)
/*! LPTMR1 - LPTMR1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_LPTMR1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_RTC_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_RTC_SHIFT (16U)
/*! RTC - RTC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_RTC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_RTC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_RTC_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_FMU_TEST_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_FMU_TEST_SHIFT (24U)
/*! FMU_TEST - FMU_TEST
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_FMU_TEST(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_FMU_TEST_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE1_FMU_TEST_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP0_MEM_RULE2 - AIPS Bridge Group 0 Memory Rule 2 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_TSI_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_TSI_SHIFT (0U)
/*! TSI - TSI
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_TSI(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_TSI_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_TSI_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP0_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP0_SHIFT (4U)
/*! CMP0 - CMP0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP1_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP1_SHIFT (8U)
/*! CMP1 - CMP1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP2_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP2_SHIFT (12U)
/*! CMP2 - CMP2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_CMP2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_SHIFT (16U)
/*! ELS - ELS
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS1_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS1_SHIFT (20U)
/*! ELS_ALIAS1 - ELS_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS2_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS2_SHIFT (24U)
/*! ELS_ALIAS2 - ELS_ALIAS2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS3_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS3_SHIFT (28U)
/*! ELS_ALIAS3 - ELS_ALIAS3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE2_ELS_ALIAS3_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP0_MEM_RULE3 - AIPS Bridge Group 0 Memory Rule 3 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_DIGTMP_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_DIGTMP_SHIFT (0U)
/*! DIGTMP - DIGTMP
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_DIGTMP(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_DIGTMP_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_DIGTMP_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_VBAT_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_VBAT_SHIFT (4U)
/*! VBAT - VBAT
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_VBAT(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_VBAT_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_VBAT_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_TRNG_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_TRNG_SHIFT (8U)
/*! TRNG - TRNG
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_TRNG(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_TRNG_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_TRNG_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_EIM0_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_EIM0_SHIFT (12U)
/*! EIM0 - EIM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_EIM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_EIM0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_EIM0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_ERM0_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_ERM0_SHIFT (16U)
/*! ERM0 - ERM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_ERM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_ERM0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_ERM0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_INTM0_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_INTM0_SHIFT (20U)
/*! INTM0 - INTM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_INTM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_INTM0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP0_MEM_RULE3_INTM0_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0 - AHB Peripheral 0 Slave Port 12 Slave Rule 0 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_EDMA0_CH15_MASK (0x30U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_EDMA0_CH15_SHIFT (4U)
/*! eDMA0_CH15 - eDMA0_CH15
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_EDMA0_CH15(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_EDMA0_CH15_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_EDMA0_CH15_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_SCT0_MASK (0x300U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_SCT0_SHIFT (8U)
/*! SCT0 - SCT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_SCT0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_SCT0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_SCT0_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM0_MASK (0x3000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM0_SHIFT (12U)
/*! LP_FLEXCOMM0 - LP_FLEXCOMM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM0_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM1_MASK (0x30000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM1_SHIFT (16U)
/*! LP_FLEXCOMM1 - LP_FLEXCOMM1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM1_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM2_MASK (0x300000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM2_SHIFT (20U)
/*! LP_FLEXCOMM2 - LP_FLEXCOMM2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM2_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM2_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM3_MASK (0x3000000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM3_SHIFT (24U)
/*! LP_FLEXCOMM3 - LP_FLEXCOMM3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM3_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_LP_FLEXCOMM3_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_GPIO0_ALIAS0_MASK (0x30000000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_GPIO0_ALIAS0_SHIFT (28U)
/*! GPIO0_ALIAS0 - GPIO0_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_GPIO0_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_GPIO0_ALIAS0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE0_GPIO0_ALIAS0_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1 - AHB Peripheral 0 Slave Port 12 Slave Rule 1 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO0_ALIAS1_MASK (0x3U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO0_ALIAS1_SHIFT (0U)
/*! GPIO0_ALIAS1 - GPIO0_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO0_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO0_ALIAS1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO0_ALIAS1_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS0_MASK (0x30U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS0_SHIFT (4U)
/*! GPIO1_ALIAS0 - GPIO1_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS0_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS1_MASK (0x300U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS1_SHIFT (8U)
/*! GPIO1_ALIAS1 - GPIO1_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO1_ALIAS1_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS0_MASK (0x3000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS0_SHIFT (12U)
/*! GPIO2_ALIAS0 - GPIO2_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS0_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS1_MASK (0x30000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS1_SHIFT (16U)
/*! GPIO2_ALIAS1 - GPIO2_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO2_ALIAS1_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS0_MASK (0x300000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS0_SHIFT (20U)
/*! GPIO3_ALIAS0 - GPIO3_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS0_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS1_MASK (0x3000000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS1_SHIFT (24U)
/*! GPIO3_ALIAS1 - GPIO3_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO3_ALIAS1_MASK)

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO4_ALIAS0_MASK (0x30000000U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO4_ALIAS0_SHIFT (28U)
/*! GPIO4_ALIAS0 - GPIO4_ALIAS0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO4_ALIAS0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO4_ALIAS0_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE1_GPIO4_ALIAS0_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2 - AHB Peripheral 0 Slave Port 12 Slave Rule 2 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2_GPIO4_ALIAS1_MASK (0x3U)
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2_GPIO4_ALIAS1_SHIFT (0U)
/*! GPIO4_ALIAS1 - GPIO4_ALIAS1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2_GPIO4_ALIAS1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2_GPIO4_ALIAS1_SHIFT)) & AHBSC_AHB_PERIPHERAL0_SLAVE_PORT_P12_SLAVE_RULE2_GPIO4_ALIAS1_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP1_MEM_RULE0 - AIPS Bridge Group 1 Rule 0 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_MP_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_MP_SHIFT (0U)
/*! eDMA0_MP - eDMA0_MP
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_MP(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_MP_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_MP_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH0_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH0_SHIFT (4U)
/*! eDMA0_CH0 - eDMA0_CH0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH1_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH1_SHIFT (8U)
/*! eDMA0_CH1 - eDMA0_CH1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH2_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH2_SHIFT (12U)
/*! eDMA0_CH2 - eDMA0_CH2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH3_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH3_SHIFT (16U)
/*! eDMA0_CH3 - FLEXSPI0 Registers
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH3_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH4_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH4_SHIFT (20U)
/*! eDMA0_CH4 - eDMA0_CH4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH4_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH4_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH5_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH5_SHIFT (24U)
/*! eDMA0_CH5 - eDMA0_CH5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH5_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH5_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH6_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH6_SHIFT (28U)
/*! eDMA0_CH6 - eDMA0_CH6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH6_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE0_EDMA0_CH6_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP1_MEM_RULE1 - AIPS Bridge Group 1 Rule 1 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH7_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH7_SHIFT (0U)
/*! eDMA0_CH7 - eDMA0_CH7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH7_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH7_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH8_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH8_SHIFT (4U)
/*! eDMA0_CH8 - eDMA0_CH8
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH8(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH8_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH8_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH9_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH9_SHIFT (8U)
/*! eDMA0_CH9 - eDMA0_CH9
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH9(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH9_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH9_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH10_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH10_SHIFT (12U)
/*! eDMA0_CH10 - eDMA0_CH10
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH10(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH10_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH10_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH11_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH11_SHIFT (16U)
/*! eDMA0_CH11 - FLEXSPI0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH11(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH11_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH11_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH12_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH12_SHIFT (20U)
/*! eDMA0_CH12 - eDMA0_CH12
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH12(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH12_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH12_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH13_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH13_SHIFT (24U)
/*! eDMA0_CH13 - eDMA0_CH13
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH13(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH13_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH13_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH14_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH14_SHIFT (28U)
/*! eDMA0_CH14 - eDMA0_CH14
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH14(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH14_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP1_MEM_RULE1_EDMA0_CH14_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0 - AHB Peripheral 1 Slave Port 13 Slave Rule 0 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_EDMA1_CH15_MASK (0x30U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_EDMA1_CH15_SHIFT (4U)
/*! eDMA1_CH15 - eDMA1_CH15
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_EDMA1_CH15(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_EDMA1_CH15_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_EDMA1_CH15_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_SEMA42_MASK (0x300U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_SEMA42_SHIFT (8U)
/*! SEMA42 - SEMA42
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_SEMA42(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_SEMA42_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_SEMA42_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_MAILBOX_MASK (0x3000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_MAILBOX_SHIFT (12U)
/*! MAILBOX - MAILBOX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_MAILBOX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_MAILBOX_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_MAILBOX_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_PKC_RAM_MASK (0x30000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_PKC_RAM_SHIFT (16U)
/*! PKC_RAM - PKC_RAM
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_PKC_RAM(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_PKC_RAM_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_PKC_RAM_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM4_MASK (0x300000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM4_SHIFT (20U)
/*! FLEXCOMM4 - FLEXCOMM4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM4_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM4_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM5_MASK (0x3000000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM5_SHIFT (24U)
/*! FLEXCOMM5 - FLEXCOMM5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM5_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM5_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM6_MASK (0x30000000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM6_SHIFT (28U)
/*! FLEXCOMM6 - FLEXCOMM6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM6_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE0_FLEXCOMM6_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1 - AHB Peripheral 1 Slave Port 13 Slave Rule 1 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM7_MASK (0x3U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM7_SHIFT (0U)
/*! FLEXCOMM7 - FLEXCOMM7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM7_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM7_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM8_MASK (0x30U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM8_SHIFT (4U)
/*! FLEXCOMM8 - FLEXCOMM8
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM8(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM8_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM8_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM9_MASK (0x300U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM9_SHIFT (8U)
/*! FLEXCOMM9 - FLEXCOMM9
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM9(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM9_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_FLEXCOMM9_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_USB_FS_OTG_RAM_MASK (0x3000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_USB_FS_OTG_RAM_SHIFT (12U)
/*! USB_FS_OTG_RAM - USB FS OTG RAM
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_USB_FS_OTG_RAM(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_USB_FS_OTG_RAM_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_USB_FS_OTG_RAM_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG0_MASK (0x30000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG0_SHIFT (16U)
/*! CDOG0 - CDOG0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG0_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG0_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG1_MASK (0x300000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG1_SHIFT (20U)
/*! CDOG1 - CDOG1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG1_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_CDOG1_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_DEBUG_MAILBOX_MASK (0x3000000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_DEBUG_MAILBOX_SHIFT (24U)
/*! DEBUG_MAILBOX - DEBUG_MAILBOX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_DEBUG_MAILBOX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_DEBUG_MAILBOX_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_DEBUG_MAILBOX_MASK)

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_NPU_MASK (0x30000000U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_NPU_SHIFT (28U)
/*! NPU - NPU
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_NPU(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_NPU_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE1_NPU_MASK)
/*! @} */

/*! @name AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE2 - AHB Peripheral 1 Slave Port 13 Slave Rule 2 */
/*! @{ */

#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE2_POWERQUAD_MASK (0x3U)
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE2_POWERQUAD_SHIFT (0U)
/*! POWERQUAD - POWERQUAD
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE2_POWERQUAD(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE2_POWERQUAD_SHIFT)) & AHBSC_AHB_PERIPHERAL1_SLAVE_PORT_P13_SLAVE_RULE2_POWERQUAD_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP2_MEM_RULE0 - AIPS Bridge Group 2 Rule 0 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_MP_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_MP_SHIFT (0U)
/*! eDMA1_MP - eDMA1_MP
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_MP(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_MP_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_MP_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH0_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH0_SHIFT (4U)
/*! eDMA1_CH0 - eDMA1_CH0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH1_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH1_SHIFT (8U)
/*! eDMA1_CH1 - eDMA1_CH1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH2_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH2_SHIFT (12U)
/*! eDMA1_CH2 - eDMA1_CH2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH3_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH3_SHIFT (16U)
/*! eDMA1_CH3 - eDMA1_CH3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH3_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH4_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH4_SHIFT (20U)
/*! eDMA1_CH4 - eDMA1_CH4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH4_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH4_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH5_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH5_SHIFT (24U)
/*! eDMA1_CH5 - eDMA1_CH5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH5_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH5_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH6_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH6_SHIFT (28U)
/*! eDMA1_CH6 - eDMA1_CH6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH6_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE0_EDMA1_CH6_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP2_MEM_RULE1 - AIPS Bridge Group 2 Memory Rule 1 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH7_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH7_SHIFT (0U)
/*! eDMA1_CH7 - eDMA1_CH7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH7_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH7_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH8_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH8_SHIFT (4U)
/*! eDMA1_CH8 - eDMA1_CH8
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH8(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH8_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH8_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH9_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH9_SHIFT (8U)
/*! eDMA1_CH9 - eDMA1_CH9
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH9(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH9_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH9_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH10_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH10_SHIFT (12U)
/*! eDMA1_CH10 - eDMA1_CH10
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH10(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH10_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH10_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH11_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH11_SHIFT (16U)
/*! eDMA1_CH11 - eDMA1_CH11
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH11(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH11_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH11_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH12_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH12_SHIFT (20U)
/*! eDMA1_CH12 - eDMA1_CH12
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH12(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH12_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH12_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH13_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH13_SHIFT (24U)
/*! eDMA1_CH13 - eDMA1_CH13
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH13(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH13_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH13_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH14_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH14_SHIFT (28U)
/*! eDMA1_CH14 - eDMA1_CH14
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH14(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH14_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP2_MEM_RULE1_EDMA1_CH14_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP3_MEM_RULE0 - AIPS Bridge Group 3 Rule 0 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_EWM0_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_EWM0_SHIFT (0U)
/*! EWM0 - EWM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_EWM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_EWM0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_EWM0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_LPCAC_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_LPCAC_SHIFT (4U)
/*! LPCAC - LPCAC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_LPCAC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_LPCAC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_LPCAC_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_FLEXSPI_CMX_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_FLEXSPI_CMX_SHIFT (8U)
/*! FLEXSPI_CMX - FLEXSPI_CMX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_FLEXSPI_CMX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_FLEXSPI_CMX_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_FLEXSPI_CMX_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_SFA_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_SFA_SHIFT (20U)
/*! SFA - SFA
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_SFA(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_SFA_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_SFA_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_MBC_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_MBC_SHIFT (28U)
/*! MBC - MBC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_MBC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_MBC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE0_MBC_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP3_MEM_RULE1 - AIPS Bridge Group 3 Memory Rule 1 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_FLEXSPI_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_FLEXSPI_SHIFT (0U)
/*! FLEXSPI - FLEXSPI
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_FLEXSPI(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_FLEXSPI_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_FLEXSPI_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_OTPC_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_OTPC_SHIFT (4U)
/*! OTPC - OTPC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_OTPC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_OTPC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_OTPC_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_CRC_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_CRC_SHIFT (12U)
/*! CRC - CRC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_CRC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_CRC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_CRC_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_NPX_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_NPX_SHIFT (16U)
/*! NPX - NPX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_NPX(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_NPX_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_NPX_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_PWM_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_PWM_SHIFT (24U)
/*! PWM - PWM
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_PWM(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_PWM_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_PWM_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_ENC_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_ENC_SHIFT (28U)
/*! ENC - ENC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_ENC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_ENC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE1_ENC_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP3_MEM_RULE2 - AIPS Bridge Group 3 Rule 2 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_PWM1_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_PWM1_SHIFT (0U)
/*! PWM1 - PWM1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_PWM1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_PWM1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_PWM1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_ENC1_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_ENC1_SHIFT (4U)
/*! ENC1 - ENC1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_ENC1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_ENC1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_ENC1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_EVTG_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_EVTG_SHIFT (8U)
/*! EVTG - EVTG
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_EVTG(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_EVTG_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_EVTG_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE0_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE0_SHIFT (16U)
/*! CAN0_RULE0 - CAN0 RULE0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE1_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE1_SHIFT (20U)
/*! CAN0_RULE1 - CAN0 RULE1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE2_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE2_SHIFT (24U)
/*! CAN0_RULE2 - CAN0 RULE2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE3_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE3_SHIFT (28U)
/*! CAN0_RULE3 - CAN0 RULE3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE2_CAN0_RULE3_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP3_MEM_RULE3 - AIPS Bridge Group 3 Rule 3 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE0_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE0_SHIFT (0U)
/*! CAN1_RULE0 - CAN1 RULE0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE1_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE1_SHIFT (4U)
/*! CAN1_RULE1 - CAN1 RULE1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE2_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE2_SHIFT (8U)
/*! CAN1_RULE2 - CAN1 RULE2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE3_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE3_SHIFT (12U)
/*! CAN1_RULE3 - CAN1 RULE3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_CAN1_RULE3_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBDCD_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBDCD_SHIFT (16U)
/*! USBDCD - USBDCD
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBDCD(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBDCD_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBDCD_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBFS_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBFS_SHIFT (20U)
/*! USBFS - USBFS
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBFS(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBFS_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP3_MEM_RULE3_USBFS_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP4_MEM_RULE0 - AIPS Bridge Group 4 Rule 0 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_ENET_MASK (0xFU)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_ENET_SHIFT (0U)
/*! ENET - ENET
 *  0b0000..Non-secure and non-privilege user access allowed
 *  0b0001..Non-secure and privilege access allowed
 *  0b0010..Secure and non-privilege user access allowed
 *  0b0011..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_ENET(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_ENET_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_ENET_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM0_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM0_SHIFT (12U)
/*! EMVSIM0 - EMVSIM0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM1_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM1_SHIFT (16U)
/*! EMVSIM1 - EMVSIM1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_EMVSIM1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_FLEXIO_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_FLEXIO_SHIFT (20U)
/*! FLEXIO - FLEXIO
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_FLEXIO(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_FLEXIO_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_FLEXIO_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI0_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI0_SHIFT (24U)
/*! SAI0 - SAI0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI1_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI1_SHIFT (28U)
/*! SAI1 - SAI1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE0_SAI1_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP4_MEM_RULE1 - AIPS Bridge Group 4 Rule 1 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_SINC0_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_SINC0_SHIFT (0U)
/*! SINC0 - SINC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_SINC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_SINC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_SINC0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USDHC0_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USDHC0_SHIFT (4U)
/*! uSDHC0 - uSDHC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USDHC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USDHC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USDHC0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHSPHY_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHSPHY_SHIFT (8U)
/*! USBHSPHY - USBHSPHY
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHSPHY(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHSPHY_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHSPHY_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHS_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHS_SHIFT (12U)
/*! USBHS - USBHS
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHS(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHS_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_USBHS_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_MICD_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_MICD_SHIFT (16U)
/*! MICD - MICD
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_MICD(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_MICD_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_MICD_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC0_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC0_SHIFT (20U)
/*! ADC0 - ADC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC1_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC1_SHIFT (24U)
/*! ADC1 - ADC1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_ADC1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_DAC0_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_DAC0_SHIFT (28U)
/*! DAC0 - DAC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_DAC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_DAC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE1_DAC0_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP4_MEM_RULE2 - AIPS Bridge Group 4 Rule 2 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP0_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP0_SHIFT (0U)
/*! OPAMP0 - OPAMP0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_VREF_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_VREF_SHIFT (4U)
/*! VREF - VREF
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_VREF(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_VREF_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_VREF_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_DAC_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_DAC_SHIFT (8U)
/*! DAC - DAC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_DAC(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_DAC_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_DAC_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP1_MASK (0x3000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP1_SHIFT (12U)
/*! OPAMP1 - OPAMP1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP1_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_HPDAC0_MASK (0x30000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_HPDAC0_SHIFT (16U)
/*! HPDAC0 - HPDAC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_HPDAC0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_HPDAC0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_HPDAC0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP2_MASK (0x300000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP2_SHIFT (20U)
/*! OPAMP2 - OPAMP2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_OPAMP2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT0_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT0_SHIFT (24U)
/*! PORT0 - PORT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT1_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT1_SHIFT (28U)
/*! PORT1 - PORT1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT1_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE2_PORT1_MASK)
/*! @} */

/*! @name AIPS_BRIDGE_GROUP4_MEM_RULE3 - AIPS Bridge Group 4 Rule 3 */
/*! @{ */

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT2_MASK (0x3U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT2_SHIFT (0U)
/*! PORT2 - PORT2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT2_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT2_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT3_MASK (0x30U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT3_SHIFT (4U)
/*! PORT3 - PORT3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT3_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT3_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT4_MASK (0x300U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT4_SHIFT (8U)
/*! PORT4 - PORT4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT4_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_PORT4_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_MTR0_MASK (0x3000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_MTR0_SHIFT (24U)
/*! MTR0 - MTR0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_MTR0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_MTR0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_MTR0_MASK)

#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_ATX0_MASK (0x30000000U)
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_ATX0_SHIFT (28U)
/*! ATX0 - ATX0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_ATX0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_ATX0_SHIFT)) & AHBSC_AIPS_BRIDGE_GROUP4_MEM_RULE3_ATX0_MASK)
/*! @} */

/*! @name AHB_SECURE_CTRL_PERIPHERAL_RULE0 - AHB Secure Control Peripheral Rule 0 */
/*! @{ */

#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE0_MASK (0x3U)
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE0_SHIFT)) & AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE0_MASK)

#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE1_MASK (0x30U)
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE1_SHIFT)) & AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE1_MASK)

#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE2_MASK (0x300U)
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE2_SHIFT)) & AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE2_MASK)

#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE3_MASK (0x3000U)
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE3_SHIFT)) & AHBSC_AHB_SECURE_CTRL_PERIPHERAL_RULE0_RULE3_MASK)
/*! @} */

/*! @name FLEXSPI0_REGION0_MEM_RULE - FLEXSPI0 Region 0 Memory Rule */
/*! @{ */

#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE0_MASK (0x3U)
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE0_SHIFT)) & AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE0_MASK)

#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE1_MASK (0x30U)
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE1_SHIFT)) & AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE1_MASK)

#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE2_MASK (0x300U)
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE2_SHIFT)) & AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE2_MASK)

#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE3_MASK (0x3000U)
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE3_SHIFT)) & AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE3_MASK)

#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE4_MASK (0x30000U)
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE4_SHIFT)) & AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE4_MASK)

#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE5_MASK (0x300000U)
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE5_SHIFT)) & AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE5_MASK)

#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE6_SHIFT)) & AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE6_MASK)

#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE7_SHIFT)) & AHBSC_FLEXSPI0_REGION0_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_FLEXSPI0_REGION0_MEM_RULE */
#define AHBSC_FLEXSPI0_REGION0_MEM_RULE_COUNT    (4U)

/*! @name FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0 - FLEXSPI0 Region 1 Memory Rule 0..FLEXSPI0 Region 6 Memory Rule 0 */
/*! @{ */

#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE0_MASK (0x3U)
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE0_SHIFT)) & AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE0_MASK)

#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE1_MASK (0x30U)
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE1_SHIFT)) & AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE1_MASK)

#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE2_MASK (0x300U)
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE2_SHIFT)) & AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE2_MASK)

#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE3_MASK (0x3000U)
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE3_SHIFT)) & AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE3_MASK)

#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE4_MASK (0x30000U)
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE4_SHIFT (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE4_SHIFT)) & AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE4_MASK)

#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE5_MASK (0x300000U)
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE5_SHIFT (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE5_SHIFT)) & AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE5_MASK)
/*! @} */

/* The count of AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0 */
#define AHBSC_FLEXSPI0_REGION1_6_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_COUNT (6U)

/*! @name FLEXSPI0_REGION7_MEM_RULE - FLEXSPI0 Region 7 Memory Rule */
/*! @{ */

#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE0_MASK (0x3U)
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE0_SHIFT)) & AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE0_MASK)

#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE1_MASK (0x30U)
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE1_SHIFT)) & AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE1_MASK)

#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE2_MASK (0x300U)
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE2_SHIFT)) & AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE2_MASK)

#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE3_MASK (0x3000U)
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE3_SHIFT)) & AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE3_MASK)

#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE4_MASK (0x30000U)
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE4_SHIFT)) & AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE4_MASK)

#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE5_MASK (0x300000U)
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE5_SHIFT)) & AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE5_MASK)

#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE6_MASK (0x3000000U)
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE6_SHIFT)) & AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE6_MASK)

#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE7_MASK (0x30000000U)
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE7_SHIFT)) & AHBSC_FLEXSPI0_REGION7_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHBSC_FLEXSPI0_REGION7_MEM_RULE */
#define AHBSC_FLEXSPI0_REGION7_MEM_RULE_COUNT    (4U)

/*! @name FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0 - FLEXSPI0 Region 8 Memory Rule 0..FLEXSPI0 Region 13 Memory Rule 0 */
/*! @{ */

#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE0_MASK (0x3U)
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE0_SHIFT)) & AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE0_MASK)

#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE1_MASK (0x30U)
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE1_SHIFT)) & AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE1_MASK)

#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE2_MASK (0x300U)
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE2_SHIFT)) & AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE2_MASK)

#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE3_MASK (0x3000U)
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE3_SHIFT)) & AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE3_MASK)

#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE4_MASK (0x30000U)
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE4_SHIFT (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE4_SHIFT)) & AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE4_MASK)

#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE5_MASK (0x300000U)
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE5_SHIFT (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE5_SHIFT)) & AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_RULE5_MASK)
/*! @} */

/* The count of AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0 */
#define AHBSC_FLEXSPI0_REGION8_13_MEM_RULE_FLEXSPI0_REGION_MEM_RULE0_COUNT (6U)

/*! @name SEC_VIO_ADDRN_SEC_VIO_ADDR - Security Violation Address */
/*! @{ */

#define AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_SEC_VIO_ADDR_MASK (0xFFFFFFFFU)
#define AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_SEC_VIO_ADDR_SHIFT (0U)
/*! SEC_VIO_ADDR - Security violation address for AHB layer a reset value 0 */
#define AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_SEC_VIO_ADDR(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_SEC_VIO_ADDR_SHIFT)) & AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_SEC_VIO_ADDR_MASK)
/*! @} */

/* The count of AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR */
#define AHBSC_SEC_VIO_ADDRN_SEC_VIO_ADDR_COUNT   (32U)

/*! @name SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO - Security Violation Miscellaneous Information at Address */
/*! @{ */

#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_MASK (0x1U)
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_SHIFT (0U)
/*! SEC_VIO_INFO_WRITE - Security violation access read/write indicator
 *  0b0..Read access
 *  0b1..Write access
 */
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_SHIFT)) & AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_MASK)

#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_MASK (0x2U)
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_SHIFT (1U)
/*! SEC_VIO_INFO_DATA_ACCESS - Security Violation Info Data Access
 *  0b0..Code
 *  0b1..Data
 */
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_SHIFT)) & AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_MASK)

#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_MASK (0xF0U)
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_SHIFT (4U)
/*! SEC_VIO_INFO_MASTER_SEC_LEVEL - Security Violation Info Master Security Level */
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_SHIFT)) & AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_MASK)

#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_MASK (0x1F00U)
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SHIFT (8U)
/*! SEC_VIO_INFO_MASTER - Security violation master number
 *  0b00000..M33 Code
 *  0b00001..M33 System
 *  0b00010..CPU1 (Mirco-CM33) Code
 *  0b00011..SMARTDMA Instruction
 *  0b00100..CPU1 (Mirco-CM33) system
 *  0b00101..SMARTDMA Data
 *  0b00110..eDMA0
 *  0b00111..eDMA1
 *  0b01000..PKC
 *  0b01001..ELS S50
 *  0b01010..PKC M0
 *  0b01011..NPU Operands
 *  0b01100..DSP Instruction
 *  0b01101..DSPX
 *  0b01110..DSPY
 *  0b10000..NPU Data
 *  0b10001..USB FS
 *  0b10010..Ethernet
 *  0b10011..USB HS
 *  0b10100..uSDHC
 */
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SHIFT)) & AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_MASK)
/*! @} */

/* The count of AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO */
#define AHBSC_SEC_VIO_MISC_INFON_SEC_VIO_MISC_INFO_COUNT (32U)

/*! @name SEC_VIO_INFO_VALID - Security Violation Info Validity for Address */
/*! @{ */

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_MASK (0x1U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_SHIFT (0U)
/*! VIO_INFO_VALID0 - Violation information valid flag for AHB port 0
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID0(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_MASK (0x2U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_SHIFT (1U)
/*! VIO_INFO_VALID1 - Violation information valid flag for AHB port 1
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID1(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_MASK (0x4U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_SHIFT (2U)
/*! VIO_INFO_VALID2 - Violation information valid flag for AHB port 2
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID2(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_MASK (0x8U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_SHIFT (3U)
/*! VIO_INFO_VALID3 - Violation information valid flag for AHB port 3
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID3(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_MASK (0x10U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_SHIFT (4U)
/*! VIO_INFO_VALID4 - Violation information valid flag for AHB port 4
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID4(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_MASK (0x20U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_SHIFT (5U)
/*! VIO_INFO_VALID5 - Violation information valid flag for AHB port 5
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID5(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_MASK (0x40U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_SHIFT (6U)
/*! VIO_INFO_VALID6 - Violation information valid flag for AHB port 6
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID6(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_MASK (0x80U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_SHIFT (7U)
/*! VIO_INFO_VALID7 - Violation information valid flag for AHB port 7
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID7(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_MASK (0x100U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_SHIFT (8U)
/*! VIO_INFO_VALID8 - Violation information valid flag for AHB port 8
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID8(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_MASK (0x200U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_SHIFT (9U)
/*! VIO_INFO_VALID9 - Violation information valid flag for AHB port 9
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID9(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_MASK (0x400U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_SHIFT (10U)
/*! VIO_INFO_VALID10 - Violation information valid flag for AHB port 10
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID10(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_MASK (0x800U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_SHIFT (11U)
/*! VIO_INFO_VALID11 - Violation information valid flag for AHB port 11
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID11(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_MASK (0x1000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_SHIFT (12U)
/*! VIO_INFO_VALID12 - Violation information valid flag for AHB port 12
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID12(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_MASK (0x2000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_SHIFT (13U)
/*! VIO_INFO_VALID13 - Violation information valid flag for AHB port 13
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID13(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_MASK (0x4000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_SHIFT (14U)
/*! VIO_INFO_VALID14 - Violation information valid flag for AHB port 14
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID14(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_MASK (0x8000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_SHIFT (15U)
/*! VIO_INFO_VALID15 - Violation information valid flag for AHB port 15
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID15(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_MASK (0x10000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_SHIFT (16U)
/*! VIO_INFO_VALID16 - Violation information valid flag for AHB port 16
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID16(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_MASK (0x20000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_SHIFT (17U)
/*! VIO_INFO_VALID17 - Violation information valid flag for AHB port 17
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID17(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_MASK)

#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_MASK (0x40000U)
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_SHIFT (18U)
/*! VIO_INFO_VALID18 - Violation information valid flag for AHB port 18
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID18(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_SHIFT)) & AHBSC_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_MASK)
/*! @} */

/*! @name SEC_GPIO_MASKN_SEC_GPIO_MASK - GPIO Mask for Port 0..GPIO Mask for Port 1 */
/*! @{ */

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN0_SEC_MASK_MASK (0x1U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN0_SEC_MASK_SHIFT (0U)
/*! PIO0_PIN0_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN0_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN0_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN0_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN0_SEC_MASK_MASK (0x1U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN0_SEC_MASK_SHIFT (0U)
/*! PIO1_PIN0_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN0_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN0_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN0_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN1_SEC_MASK_MASK (0x2U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN1_SEC_MASK_SHIFT (1U)
/*! PIO0_PIN1_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN1_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN1_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN1_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN1_SEC_MASK_MASK (0x2U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN1_SEC_MASK_SHIFT (1U)
/*! PIO1_PIN1_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN1_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN1_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN1_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN2_SEC_MASK_MASK (0x4U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN2_SEC_MASK_SHIFT (2U)
/*! PIO0_PIN2_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN2_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN2_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN2_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN2_SEC_MASK_MASK (0x4U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN2_SEC_MASK_SHIFT (2U)
/*! PIO1_PIN2_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN2_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN2_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN2_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN3_SEC_MASK_MASK (0x8U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN3_SEC_MASK_SHIFT (3U)
/*! PIO0_PIN3_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN3_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN3_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN3_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN3_SEC_MASK_MASK (0x8U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN3_SEC_MASK_SHIFT (3U)
/*! PIO1_PIN3_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN3_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN3_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN3_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN4_SEC_MASK_MASK (0x10U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN4_SEC_MASK_SHIFT (4U)
/*! PIO0_PIN4_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN4_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN4_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN4_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN4_SEC_MASK_MASK (0x10U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN4_SEC_MASK_SHIFT (4U)
/*! PIO1_PIN4_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN4_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN4_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN4_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN5_SEC_MASK_MASK (0x20U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN5_SEC_MASK_SHIFT (5U)
/*! PIO0_PIN5_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN5_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN5_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN5_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN5_SEC_MASK_MASK (0x20U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN5_SEC_MASK_SHIFT (5U)
/*! PIO1_PIN5_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN5_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN5_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN5_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN6_SEC_MASK_MASK (0x40U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN6_SEC_MASK_SHIFT (6U)
/*! PIO0_PIN6_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN6_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN6_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN6_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN6_SEC_MASK_MASK (0x40U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN6_SEC_MASK_SHIFT (6U)
/*! PIO1_PIN6_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN6_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN6_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN6_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN7_SEC_MASK_MASK (0x80U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN7_SEC_MASK_SHIFT (7U)
/*! PIO0_PIN7_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN7_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN7_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN7_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN7_SEC_MASK_MASK (0x80U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN7_SEC_MASK_SHIFT (7U)
/*! PIO1_PIN7_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN7_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN7_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN7_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN8_SEC_MASK_MASK (0x100U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN8_SEC_MASK_SHIFT (8U)
/*! PIO0_PIN8_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN8_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN8_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN8_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN8_SEC_MASK_MASK (0x100U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN8_SEC_MASK_SHIFT (8U)
/*! PIO1_PIN8_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN8_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN8_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN8_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN9_SEC_MASK_MASK (0x200U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN9_SEC_MASK_SHIFT (9U)
/*! PIO0_PIN9_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN9_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN9_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN9_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN9_SEC_MASK_MASK (0x200U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN9_SEC_MASK_SHIFT (9U)
/*! PIO1_PIN9_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN9_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN9_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN9_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN10_SEC_MASK_MASK (0x400U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN10_SEC_MASK_SHIFT (10U)
/*! PIO0_PIN10_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN10_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN10_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN10_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN10_SEC_MASK_MASK (0x400U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN10_SEC_MASK_SHIFT (10U)
/*! PIO1_PIN10_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN10_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN10_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN10_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN11_SEC_MASK_MASK (0x800U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN11_SEC_MASK_SHIFT (11U)
/*! PIO0_PIN11_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN11_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN11_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN11_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN11_SEC_MASK_MASK (0x800U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN11_SEC_MASK_SHIFT (11U)
/*! PIO1_PIN11_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN11_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN11_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN11_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN12_SEC_MASK_MASK (0x1000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN12_SEC_MASK_SHIFT (12U)
/*! PIO0_PIN12_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN12_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN12_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN12_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN12_SEC_MASK_MASK (0x1000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN12_SEC_MASK_SHIFT (12U)
/*! PIO1_PIN12_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN12_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN12_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN12_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN13_SEC_MASK_MASK (0x2000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN13_SEC_MASK_SHIFT (13U)
/*! PIO0_PIN13_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN13_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN13_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN13_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN13_SEC_MASK_MASK (0x2000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN13_SEC_MASK_SHIFT (13U)
/*! PIO1_PIN13_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN13_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN13_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN13_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN14_SEC_MASK_MASK (0x4000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN14_SEC_MASK_SHIFT (14U)
/*! PIO0_PIN14_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN14_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN14_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN14_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN14_SEC_MASK_MASK (0x4000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN14_SEC_MASK_SHIFT (14U)
/*! PIO1_PIN14_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN14_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN14_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN14_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN15_SEC_MASK_MASK (0x8000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN15_SEC_MASK_SHIFT (15U)
/*! PIO0_PIN15_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN15_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN15_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN15_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN15_SEC_MASK_MASK (0x8000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN15_SEC_MASK_SHIFT (15U)
/*! PIO1_PIN15_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN15_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN15_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN15_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN16_SEC_MASK_MASK (0x10000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN16_SEC_MASK_SHIFT (16U)
/*! PIO0_PIN16_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN16_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN16_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN16_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN16_SEC_MASK_MASK (0x10000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN16_SEC_MASK_SHIFT (16U)
/*! PIO1_PIN16_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN16_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN16_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN16_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN17_SEC_MASK_MASK (0x20000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN17_SEC_MASK_SHIFT (17U)
/*! PIO0_PIN17_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN17_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN17_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN17_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN17_SEC_MASK_MASK (0x20000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN17_SEC_MASK_SHIFT (17U)
/*! PIO1_PIN17_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN17_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN17_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN17_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN18_SEC_MASK_MASK (0x40000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN18_SEC_MASK_SHIFT (18U)
/*! PIO0_PIN18_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN18_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN18_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN18_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN18_SEC_MASK_MASK (0x40000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN18_SEC_MASK_SHIFT (18U)
/*! PIO1_PIN18_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN18_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN18_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN18_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN19_SEC_MASK_MASK (0x80000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN19_SEC_MASK_SHIFT (19U)
/*! PIO0_PIN19_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN19_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN19_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN19_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN19_SEC_MASK_MASK (0x80000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN19_SEC_MASK_SHIFT (19U)
/*! PIO1_PIN19_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN19_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN19_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN19_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN20_SEC_MASK_MASK (0x100000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN20_SEC_MASK_SHIFT (20U)
/*! PIO0_PIN20_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN20_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN20_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN20_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN20_SEC_MASK_MASK (0x100000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN20_SEC_MASK_SHIFT (20U)
/*! PIO1_PIN20_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN20_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN20_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN20_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN21_SEC_MASK_MASK (0x200000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN21_SEC_MASK_SHIFT (21U)
/*! PIO0_PIN21_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN21_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN21_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN21_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN21_SEC_MASK_MASK (0x200000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN21_SEC_MASK_SHIFT (21U)
/*! PIO1_PIN21_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN21_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN21_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN21_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN22_SEC_MASK_MASK (0x400000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN22_SEC_MASK_SHIFT (22U)
/*! PIO0_PIN22_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN22_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN22_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN22_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN22_SEC_MASK_MASK (0x400000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN22_SEC_MASK_SHIFT (22U)
/*! PIO1_PIN22_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN22_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN22_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN22_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN23_SEC_MASK_MASK (0x800000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN23_SEC_MASK_SHIFT (23U)
/*! PIO0_PIN23_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN23_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN23_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN23_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN23_SEC_MASK_MASK (0x800000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN23_SEC_MASK_SHIFT (23U)
/*! PIO1_PIN23_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN23_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN23_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN23_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN24_SEC_MASK_SHIFT (24U)
/*! PIO0_PIN24_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN24_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN24_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN24_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN24_SEC_MASK_SHIFT (24U)
/*! PIO1_PIN24_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN24_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN24_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN24_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN25_SEC_MASK_SHIFT (25U)
/*! PIO0_PIN25_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN25_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN25_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN25_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN25_SEC_MASK_SHIFT (25U)
/*! PIO1_PIN25_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN25_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN25_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN25_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN26_SEC_MASK_SHIFT (26U)
/*! PIO0_PIN26_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN26_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN26_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN26_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN26_SEC_MASK_SHIFT (26U)
/*! PIO1_PIN26_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN26_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN26_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN26_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN27_SEC_MASK_SHIFT (27U)
/*! PIO0_PIN27_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN27_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN27_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN27_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN27_SEC_MASK_SHIFT (27U)
/*! PIO1_PIN27_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN27_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN27_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN27_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN28_SEC_MASK_SHIFT (28U)
/*! PIO0_PIN28_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN28_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN28_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN28_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN28_SEC_MASK_SHIFT (28U)
/*! PIO1_PIN28_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN28_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN28_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN28_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN29_SEC_MASK_SHIFT (29U)
/*! PIO0_PIN29_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN29_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN29_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN29_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN29_SEC_MASK_SHIFT (29U)
/*! PIO1_PIN29_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN29_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN29_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN29_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN30_SEC_MASK_SHIFT (30U)
/*! PIO0_PIN30_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN30_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN30_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN30_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN30_SEC_MASK_SHIFT (30U)
/*! PIO1_PIN30_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN30_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN30_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN30_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN31_SEC_MASK_SHIFT (31U)
/*! PIO0_PIN31_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN31_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN31_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO0_PIN31_SEC_MASK_MASK)

#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN31_SEC_MASK_SHIFT (31U)
/*! PIO1_PIN31_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN31_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN31_SEC_MASK_SHIFT)) & AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_PIO1_PIN31_SEC_MASK_MASK)
/*! @} */

/* The count of AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK */
#define AHBSC_SEC_GPIO_MASKN_SEC_GPIO_MASK_COUNT (2U)

/*! @name SEC_CPU1_INT_MASK0 - Secure Interrupt Mask 0 for CPU1 */
/*! @{ */

#define AHBSC_SEC_CPU1_INT_MASK0_INT0_MASK_MASK  (0x1U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT0_MASK_SHIFT (0U)
/*! INT0_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT0_MASK(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT0_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT0_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT1_MASK_MASK  (0x2U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT1_MASK_SHIFT (1U)
/*! INT1_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT1_MASK(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT1_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT1_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT2_MASK_MASK  (0x4U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT2_MASK_SHIFT (2U)
/*! INT2_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT2_MASK(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT2_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT2_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT3_MASK_MASK  (0x8U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT3_MASK_SHIFT (3U)
/*! INT3_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT3_MASK(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT3_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT3_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT4_MASK_MASK  (0x10U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT4_MASK_SHIFT (4U)
/*! INT4_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT4_MASK(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT4_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT4_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT5_MASK_MASK  (0x20U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT5_MASK_SHIFT (5U)
/*! INT5_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT5_MASK(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT5_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT5_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT6_MASK_MASK  (0x40U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT6_MASK_SHIFT (6U)
/*! INT6_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT6_MASK(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT6_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT6_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT7_MASK_MASK  (0x80U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT7_MASK_SHIFT (7U)
/*! INT7_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT7_MASK(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT7_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT7_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT8_MASK_MASK  (0x100U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT8_MASK_SHIFT (8U)
/*! INT8_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT8_MASK(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT8_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT8_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT9_MASK_MASK  (0x200U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT9_MASK_SHIFT (9U)
/*! INT9_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT9_MASK(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT9_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT9_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT10_MASK_MASK (0x400U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT10_MASK_SHIFT (10U)
/*! INT10_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT10_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT10_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT10_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT11_MASK_MASK (0x800U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT11_MASK_SHIFT (11U)
/*! INT11_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT11_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT11_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT11_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT12_MASK_MASK (0x1000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT12_MASK_SHIFT (12U)
/*! INT12_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT12_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT12_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT12_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT13_MASK_MASK (0x2000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT13_MASK_SHIFT (13U)
/*! INT13_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT13_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT13_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT13_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT14_MASK_MASK (0x4000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT14_MASK_SHIFT (14U)
/*! INT14_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT14_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT14_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT14_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT15_MASK_MASK (0x8000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT15_MASK_SHIFT (15U)
/*! INT15_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT15_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT15_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT15_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT16_MASK_MASK (0x10000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT16_MASK_SHIFT (16U)
/*! INT16_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT16_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT16_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT16_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT17_MASK_MASK (0x20000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT17_MASK_SHIFT (17U)
/*! INT17_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT17_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT17_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT17_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT18_MASK_MASK (0x40000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT18_MASK_SHIFT (18U)
/*! INT18_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT18_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT18_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT18_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT19_MASK_MASK (0x80000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT19_MASK_SHIFT (19U)
/*! INT19_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT19_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT19_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT19_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT20_MASK_MASK (0x100000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT20_MASK_SHIFT (20U)
/*! INT20_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT20_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT20_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT20_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT21_MASK_MASK (0x200000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT21_MASK_SHIFT (21U)
/*! INT21_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT21_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT21_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT21_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT22_MASK_MASK (0x400000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT22_MASK_SHIFT (22U)
/*! INT22_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT22_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT22_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT22_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT23_MASK_MASK (0x800000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT23_MASK_SHIFT (23U)
/*! INT23_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT23_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT23_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT23_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT24_MASK_MASK (0x1000000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT24_MASK_SHIFT (24U)
/*! INT24_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT24_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT24_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT24_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT25_MASK_MASK (0x2000000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT25_MASK_SHIFT (25U)
/*! INT25_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT25_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT25_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT25_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT26_MASK_MASK (0x4000000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT26_MASK_SHIFT (26U)
/*! INT26_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT26_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT26_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT26_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT27_MASK_MASK (0x8000000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT27_MASK_SHIFT (27U)
/*! INT27_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT27_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT27_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT27_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT28_MASK_MASK (0x10000000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT28_MASK_SHIFT (28U)
/*! INT28_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT28_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT28_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT28_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT29_MASK_MASK (0x20000000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT29_MASK_SHIFT (29U)
/*! INT29_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT29_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT29_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT29_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT30_MASK_MASK (0x40000000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT30_MASK_SHIFT (30U)
/*! INT30_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT30_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT30_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT30_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK0_INT31_MASK_MASK (0x80000000U)
#define AHBSC_SEC_CPU1_INT_MASK0_INT31_MASK_SHIFT (31U)
/*! INT31_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK0_INT31_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK0_INT31_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK0_INT31_MASK_MASK)
/*! @} */

/*! @name SEC_CPU1_INT_MASK1 - Secure Interrupt Mask 1 for CPU1 */
/*! @{ */

#define AHBSC_SEC_CPU1_INT_MASK1_INT32_MASK_MASK (0x1U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT32_MASK_SHIFT (0U)
/*! INT32_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT32_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT32_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT32_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT33_MASK_MASK (0x2U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT33_MASK_SHIFT (1U)
/*! INT33_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT33_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT33_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT33_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT34_MASK_MASK (0x4U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT34_MASK_SHIFT (2U)
/*! INT34_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT34_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT34_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT34_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT35_MASK_MASK (0x8U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT35_MASK_SHIFT (3U)
/*! INT35_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT35_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT35_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT35_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT36_MASK_MASK (0x10U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT36_MASK_SHIFT (4U)
/*! INT36_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT36_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT36_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT36_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT37_MASK_MASK (0x20U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT37_MASK_SHIFT (5U)
/*! INT37_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT37_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT37_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT37_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT38_MASK_MASK (0x40U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT38_MASK_SHIFT (6U)
/*! INT38_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT38_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT38_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT38_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT39_MASK_MASK (0x80U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT39_MASK_SHIFT (7U)
/*! INT39_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT39_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT39_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT39_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT40_MASK_MASK (0x100U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT40_MASK_SHIFT (8U)
/*! INT40_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT40_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT40_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT40_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT41_MASK_MASK (0x200U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT41_MASK_SHIFT (9U)
/*! INT41_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT41_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT41_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT41_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT42_MASK_MASK (0x400U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT42_MASK_SHIFT (10U)
/*! INT42_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT42_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT42_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT42_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT43_MASK_MASK (0x800U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT43_MASK_SHIFT (11U)
/*! INT43_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT43_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT43_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT43_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT44_MASK_MASK (0x1000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT44_MASK_SHIFT (12U)
/*! INT44_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT44_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT44_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT44_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT45_MASK_MASK (0x2000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT45_MASK_SHIFT (13U)
/*! INT45_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT45_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT45_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT45_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT46_MASK_MASK (0x4000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT46_MASK_SHIFT (14U)
/*! INT46_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT46_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT46_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT46_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT47_MASK_MASK (0x8000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT47_MASK_SHIFT (15U)
/*! INT47_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT47_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT47_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT47_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT48_MASK_MASK (0x10000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT48_MASK_SHIFT (16U)
/*! INT48_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT48_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT48_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT48_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT49_MASK_MASK (0x20000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT49_MASK_SHIFT (17U)
/*! INT49_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT49_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT49_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT49_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT50_MASK_MASK (0x40000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT50_MASK_SHIFT (18U)
/*! INT50_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT50_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT50_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT50_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT51_MASK_MASK (0x80000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT51_MASK_SHIFT (19U)
/*! INT51_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT51_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT51_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT51_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT52_MASK_MASK (0x100000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT52_MASK_SHIFT (20U)
/*! INT52_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT52_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT52_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT52_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT53_MASK_MASK (0x200000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT53_MASK_SHIFT (21U)
/*! INT53_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT53_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT53_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT53_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT54_MASK_MASK (0x400000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT54_MASK_SHIFT (22U)
/*! INT54_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT54_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT54_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT54_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT55_MASK_MASK (0x800000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT55_MASK_SHIFT (23U)
/*! INT55_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT55_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT55_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT55_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT56_MASK_MASK (0x1000000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT56_MASK_SHIFT (24U)
/*! INT56_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT56_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT56_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT56_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT57_MASK_MASK (0x2000000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT57_MASK_SHIFT (25U)
/*! INT57_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT57_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT57_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT57_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT58_MASK_MASK (0x4000000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT58_MASK_SHIFT (26U)
/*! INT58_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT58_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT58_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT58_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT59_MASK_MASK (0x8000000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT59_MASK_SHIFT (27U)
/*! INT59_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT59_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT59_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT59_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT60_MASK_MASK (0x10000000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT60_MASK_SHIFT (28U)
/*! INT60_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT60_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT60_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT60_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT61_MASK_MASK (0x20000000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT61_MASK_SHIFT (29U)
/*! INT61_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT61_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT61_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT61_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT62_MASK_MASK (0x40000000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT62_MASK_SHIFT (30U)
/*! INT62_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT62_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT62_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT62_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK1_INT63_MASK_MASK (0x80000000U)
#define AHBSC_SEC_CPU1_INT_MASK1_INT63_MASK_SHIFT (31U)
/*! INT63_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK1_INT63_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK1_INT63_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK1_INT63_MASK_MASK)
/*! @} */

/*! @name SEC_CPU1_INT_MASK2 - Secure Interrupt Mask 2 for CPU1 */
/*! @{ */

#define AHBSC_SEC_CPU1_INT_MASK2_INT64_MASK_MASK (0x1U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT64_MASK_SHIFT (0U)
/*! INT64_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT64_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT64_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT64_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT65_MASK_MASK (0x2U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT65_MASK_SHIFT (1U)
/*! INT65_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT65_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT65_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT65_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT66_MASK_MASK (0x4U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT66_MASK_SHIFT (2U)
/*! INT66_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT66_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT66_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT66_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT67_MASK_MASK (0x8U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT67_MASK_SHIFT (3U)
/*! INT67_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT67_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT67_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT67_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT68_MASK_MASK (0x10U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT68_MASK_SHIFT (4U)
/*! INT68_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT68_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT68_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT68_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT69_MASK_MASK (0x20U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT69_MASK_SHIFT (5U)
/*! INT69_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT69_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT69_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT69_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT70_MASK_MASK (0x40U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT70_MASK_SHIFT (6U)
/*! INT70_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT70_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT70_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT70_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT71_MASK_MASK (0x80U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT71_MASK_SHIFT (7U)
/*! INT71_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT71_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT71_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT71_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT72_MASK_MASK (0x100U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT72_MASK_SHIFT (8U)
/*! INT72_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT72_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT72_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT72_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT73_MASK_MASK (0x200U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT73_MASK_SHIFT (9U)
/*! INT73_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT73_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT73_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT73_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT74_MASK_MASK (0x400U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT74_MASK_SHIFT (10U)
/*! INT74_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT74_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT74_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT74_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT75_MASK_MASK (0x800U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT75_MASK_SHIFT (11U)
/*! INT75_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT75_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT75_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT75_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT76_MASK_MASK (0x1000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT76_MASK_SHIFT (12U)
/*! INT76_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT76_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT76_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT76_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT77_MASK_MASK (0x2000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT77_MASK_SHIFT (13U)
/*! INT77_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT77_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT77_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT77_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT78_MASK_MASK (0x4000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT78_MASK_SHIFT (14U)
/*! INT78_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT78_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT78_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT78_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT79_MASK_MASK (0x8000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT79_MASK_SHIFT (15U)
/*! INT79_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT79_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT79_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT79_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT80_MASK_MASK (0x10000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT80_MASK_SHIFT (16U)
/*! INT80_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT80_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT80_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT80_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT81_MASK_MASK (0x20000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT81_MASK_SHIFT (17U)
/*! INT81_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT81_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT81_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT81_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT82_MASK_MASK (0x40000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT82_MASK_SHIFT (18U)
/*! INT82_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT82_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT82_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT82_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT83_MASK_MASK (0x80000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT83_MASK_SHIFT (19U)
/*! INT83_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT83_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT83_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT83_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT84_MASK_MASK (0x100000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT84_MASK_SHIFT (20U)
/*! INT84_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT84_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT84_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT84_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT85_MASK_MASK (0x200000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT85_MASK_SHIFT (21U)
/*! INT85_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT85_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT85_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT85_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT86_MASK_MASK (0x400000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT86_MASK_SHIFT (22U)
/*! INT86_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT86_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT86_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT86_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT87_MASK_MASK (0x800000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT87_MASK_SHIFT (23U)
/*! INT87_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT87_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT87_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT87_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT88_MASK_MASK (0x1000000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT88_MASK_SHIFT (24U)
/*! INT88_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT88_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT88_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT88_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT89_MASK_MASK (0x2000000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT89_MASK_SHIFT (25U)
/*! INT89_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT89_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT89_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT89_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT90_MASK_MASK (0x4000000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT90_MASK_SHIFT (26U)
/*! INT90_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT90_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT90_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT90_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT91_MASK_MASK (0x8000000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT91_MASK_SHIFT (27U)
/*! INT91_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT91_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT91_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT91_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT92_MASK_MASK (0x10000000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT92_MASK_SHIFT (28U)
/*! INT92_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT92_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT92_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT92_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT93_MASK_MASK (0x20000000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT93_MASK_SHIFT (29U)
/*! INT93_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT93_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT93_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT93_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT94_MASK_MASK (0x40000000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT94_MASK_SHIFT (30U)
/*! INT94_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT94_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT94_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT94_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK2_INT95_MASK_MASK (0x80000000U)
#define AHBSC_SEC_CPU1_INT_MASK2_INT95_MASK_SHIFT (31U)
/*! INT95_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK2_INT95_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK2_INT95_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK2_INT95_MASK_MASK)
/*! @} */

/*! @name SEC_CPU1_INT_MASK3 - Secure Interrupt Mask 3 for CPU1 */
/*! @{ */

#define AHBSC_SEC_CPU1_INT_MASK3_INT96_MASK_MASK (0x1U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT96_MASK_SHIFT (0U)
/*! INT96_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT96_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT96_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT96_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT97_MASK_MASK (0x2U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT97_MASK_SHIFT (1U)
/*! INT97_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT97_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT97_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT97_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT98_MASK_MASK (0x4U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT98_MASK_SHIFT (2U)
/*! INT98_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT98_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT98_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT98_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT99_MASK_MASK (0x8U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT99_MASK_SHIFT (3U)
/*! INT99_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT99_MASK(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT99_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT99_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT100_MASK_MASK (0x10U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT100_MASK_SHIFT (4U)
/*! INT100_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT100_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT100_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT100_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT101_MASK_MASK (0x20U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT101_MASK_SHIFT (5U)
/*! INT101_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT101_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT101_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT101_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT102_MASK_MASK (0x40U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT102_MASK_SHIFT (6U)
/*! INT102_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT102_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT102_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT102_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT103_MASK_MASK (0x80U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT103_MASK_SHIFT (7U)
/*! INT103_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT103_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT103_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT103_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT104_MASK_MASK (0x100U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT104_MASK_SHIFT (8U)
/*! INT104_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT104_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT104_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT104_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT105_MASK_MASK (0x200U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT105_MASK_SHIFT (9U)
/*! INT105_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT105_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT105_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT105_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT106_MASK_MASK (0x400U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT106_MASK_SHIFT (10U)
/*! INT106_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT106_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT106_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT106_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT107_MASK_MASK (0x800U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT107_MASK_SHIFT (11U)
/*! INT107_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT107_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT107_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT107_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT108_MASK_MASK (0x1000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT108_MASK_SHIFT (12U)
/*! INT108_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT108_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT108_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT108_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT109_MASK_MASK (0x2000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT109_MASK_SHIFT (13U)
/*! INT109_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT109_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT109_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT109_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT110_MASK_MASK (0x4000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT110_MASK_SHIFT (14U)
/*! INT110_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT110_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT110_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT110_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT111_MASK_MASK (0x8000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT111_MASK_SHIFT (15U)
/*! INT111_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT111_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT111_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT111_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT112_MASK_MASK (0x10000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT112_MASK_SHIFT (16U)
/*! INT112_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT112_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT112_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT112_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT113_MASK_MASK (0x20000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT113_MASK_SHIFT (17U)
/*! INT113_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT113_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT113_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT113_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT114_MASK_MASK (0x40000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT114_MASK_SHIFT (18U)
/*! INT114_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT114_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT114_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT114_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT115_MASK_MASK (0x80000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT115_MASK_SHIFT (19U)
/*! INT115_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT115_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT115_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT115_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT116_MASK_MASK (0x100000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT116_MASK_SHIFT (20U)
/*! INT116_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT116_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT116_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT116_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT117_MASK_MASK (0x200000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT117_MASK_SHIFT (21U)
/*! INT117_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT117_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT117_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT117_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT118_MASK_MASK (0x400000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT118_MASK_SHIFT (22U)
/*! INT118_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT118_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT118_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT118_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT119_MASK_MASK (0x800000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT119_MASK_SHIFT (23U)
/*! INT119_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT119_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT119_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT119_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT120_MASK_MASK (0x1000000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT120_MASK_SHIFT (24U)
/*! INT120_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT120_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT120_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT120_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT121_MASK_MASK (0x2000000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT121_MASK_SHIFT (25U)
/*! INT121_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT121_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT121_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT121_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT122_MASK_MASK (0x4000000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT122_MASK_SHIFT (26U)
/*! INT122_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT122_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT122_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT122_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT123_MASK_MASK (0x8000000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT123_MASK_SHIFT (27U)
/*! INT123_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT123_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT123_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT123_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT124_MASK_MASK (0x10000000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT124_MASK_SHIFT (28U)
/*! INT124_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT124_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT124_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT124_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT125_MASK_MASK (0x20000000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT125_MASK_SHIFT (29U)
/*! INT125_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT125_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT125_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT125_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT126_MASK_MASK (0x40000000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT126_MASK_SHIFT (30U)
/*! INT126_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT126_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT126_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT126_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK3_INT127_MASK_MASK (0x80000000U)
#define AHBSC_SEC_CPU1_INT_MASK3_INT127_MASK_SHIFT (31U)
/*! INT127_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK3_INT127_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK3_INT127_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK3_INT127_MASK_MASK)
/*! @} */

/*! @name SEC_CPU1_INT_MASK4 - Secure Interrupt Mask 4 for CPU1 */
/*! @{ */

#define AHBSC_SEC_CPU1_INT_MASK4_INT128_MASK_MASK (0x1U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT128_MASK_SHIFT (0U)
/*! INT128_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT128_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT128_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT128_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT129_MASK_MASK (0x2U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT129_MASK_SHIFT (1U)
/*! INT129_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT129_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT129_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT129_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT130_MASK_MASK (0x4U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT130_MASK_SHIFT (2U)
/*! INT130_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT130_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT130_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT130_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT131_MASK_MASK (0x8U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT131_MASK_SHIFT (3U)
/*! INT131_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT131_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT131_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT131_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT132_MASK_MASK (0x10U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT132_MASK_SHIFT (4U)
/*! INT132_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT132_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT132_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT132_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT133_MASK_MASK (0x20U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT133_MASK_SHIFT (5U)
/*! INT133_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT133_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT133_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT133_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT134_MASK_MASK (0x40U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT134_MASK_SHIFT (6U)
/*! INT134_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT134_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT134_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT134_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT135_MASK_MASK (0x80U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT135_MASK_SHIFT (7U)
/*! INT135_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT135_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT135_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT135_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT136_MASK_MASK (0x100U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT136_MASK_SHIFT (8U)
/*! INT136_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT136_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT136_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT136_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT137_MASK_MASK (0x200U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT137_MASK_SHIFT (9U)
/*! INT137_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT137_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT137_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT137_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT138_MASK_MASK (0x400U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT138_MASK_SHIFT (10U)
/*! INT138_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT138_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT138_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT138_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT139_MASK_MASK (0x800U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT139_MASK_SHIFT (11U)
/*! INT139_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT139_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT139_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT139_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT140_MASK_MASK (0x1000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT140_MASK_SHIFT (12U)
/*! INT140_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT140_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT140_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT140_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT141_MASK_MASK (0x2000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT141_MASK_SHIFT (13U)
/*! INT141_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT141_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT141_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT141_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT142_MASK_MASK (0x4000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT142_MASK_SHIFT (14U)
/*! INT142_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT142_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT142_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT142_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT143_MASK_MASK (0x8000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT143_MASK_SHIFT (15U)
/*! INT143_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT143_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT143_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT143_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT144_MASK_MASK (0x10000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT144_MASK_SHIFT (16U)
/*! INT144_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT144_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT144_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT144_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT145_MASK_MASK (0x20000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT145_MASK_SHIFT (17U)
/*! INT145_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT145_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT145_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT145_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT146_MASK_MASK (0x40000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT146_MASK_SHIFT (18U)
/*! INT146_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT146_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT146_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT146_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT147_MASK_MASK (0x80000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT147_MASK_SHIFT (19U)
/*! INT147_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT147_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT147_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT147_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT148_MASK_MASK (0x100000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT148_MASK_SHIFT (20U)
/*! INT148_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT148_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT148_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT148_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT149_MASK_MASK (0x200000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT149_MASK_SHIFT (21U)
/*! INT149_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT149_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT149_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT149_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT150_MASK_MASK (0x400000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT150_MASK_SHIFT (22U)
/*! INT150_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT150_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT150_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT150_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT151_MASK_MASK (0x800000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT151_MASK_SHIFT (23U)
/*! INT151_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT151_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT151_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT151_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT152_MASK_MASK (0x1000000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT152_MASK_SHIFT (24U)
/*! INT152_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT152_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT152_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT152_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT153_MASK_MASK (0x2000000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT153_MASK_SHIFT (25U)
/*! INT153_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT153_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT153_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT153_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT154_MASK_MASK (0x4000000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT154_MASK_SHIFT (26U)
/*! INT154_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT154_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT154_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT154_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT155_MASK_MASK (0x8000000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT155_MASK_SHIFT (27U)
/*! INT155_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT155_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT155_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT155_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT156_MASK_MASK (0x10000000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT156_MASK_SHIFT (28U)
/*! INT156_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT156_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT156_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT156_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT157_MASK_MASK (0x20000000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT157_MASK_SHIFT (29U)
/*! INT157_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT157_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT157_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT157_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT158_MASK_MASK (0x40000000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT158_MASK_SHIFT (30U)
/*! INT158_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT158_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT158_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT158_MASK_MASK)

#define AHBSC_SEC_CPU1_INT_MASK4_INT159_MASK_MASK (0x80000000U)
#define AHBSC_SEC_CPU1_INT_MASK4_INT159_MASK_SHIFT (31U)
/*! INT159_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHBSC_SEC_CPU1_INT_MASK4_INT159_MASK(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_CPU1_INT_MASK4_INT159_MASK_SHIFT)) & AHBSC_SEC_CPU1_INT_MASK4_INT159_MASK_MASK)
/*! @} */

/*! @name SEC_GP_REG_LOCK - Secure Mask Lock */
/*! @{ */

#define AHBSC_SEC_GP_REG_LOCK_SEC_GPIO_MASK0_LOCK_MASK (0x3U)
#define AHBSC_SEC_GP_REG_LOCK_SEC_GPIO_MASK0_LOCK_SHIFT (0U)
/*! SEC_GPIO_MASK0_LOCK - Secure GPIO _MASK0 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK0 cannot be written
 *  0b10..SEC_GPIO_MASK0 can be written
 *  0b11..Reserved
 */
#define AHBSC_SEC_GP_REG_LOCK_SEC_GPIO_MASK0_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GP_REG_LOCK_SEC_GPIO_MASK0_LOCK_SHIFT)) & AHBSC_SEC_GP_REG_LOCK_SEC_GPIO_MASK0_LOCK_MASK)

#define AHBSC_SEC_GP_REG_LOCK_SEC_GPIO_MASK1_LOCK_MASK (0xCU)
#define AHBSC_SEC_GP_REG_LOCK_SEC_GPIO_MASK1_LOCK_SHIFT (2U)
/*! SEC_GPIO_MASK1_LOCK - Secure GPIO _MASK1 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK1 cannot be written
 *  0b10..SEC_GPIO_MASK1 can be written
 *  0b11..Reserved
 */
#define AHBSC_SEC_GP_REG_LOCK_SEC_GPIO_MASK1_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GP_REG_LOCK_SEC_GPIO_MASK1_LOCK_SHIFT)) & AHBSC_SEC_GP_REG_LOCK_SEC_GPIO_MASK1_LOCK_MASK)

#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK0_LOCK_MASK (0x3000U)
#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK0_LOCK_SHIFT (12U)
/*! SEC_CPU1_INT_MASK0_LOCK - SEC_CPU1_INT_MASK0 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK0 cannot be written
 *  0b10..SEC_GPIO_MASK0 can be written
 *  0b11..Reserved
 */
#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK0_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK0_LOCK_SHIFT)) & AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK0_LOCK_MASK)

#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK1_LOCK_MASK (0xC000U)
#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK1_LOCK_SHIFT (14U)
/*! SEC_CPU1_INT_MASK1_LOCK - SEC_CPU1_INT_MASK1 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK1 cannot be written
 *  0b10..SEC_GPIO_MASK1 can be written
 *  0b11..Reserved
 */
#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK1_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK1_LOCK_SHIFT)) & AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK1_LOCK_MASK)

#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK2_LOCK_MASK (0x30000U)
#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK2_LOCK_SHIFT (16U)
/*! SEC_CPU1_INT_MASK2_LOCK - SEC_CPU1_INT_MASK2 Lock
 *  0b00..Reserved
 *  0b01..SEC_CPU1_INT_MASK2 cannot be written
 *  0b10..SEC_CPU1_INT_MASK2 can be written
 *  0b11..Reserved
 */
#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK2_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK2_LOCK_SHIFT)) & AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK2_LOCK_MASK)

#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK3_LOCK_MASK (0xC0000U)
#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK3_LOCK_SHIFT (18U)
/*! SEC_CPU1_INT_MASK3_LOCK - SEC_CPU1_INT_MASK3 Lock
 *  0b00..Reserved
 *  0b01..SEC_CPU1_INT_MASK3 cannot be written
 *  0b10..SEC_CPU1_INT_MASK3 can be written
 *  0b11..Reserved
 */
#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK3_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK3_LOCK_SHIFT)) & AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK3_LOCK_MASK)

#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK4_LOCK_MASK (0x300000U)
#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK4_LOCK_SHIFT (20U)
/*! SEC_CPU1_INT_MASK4_LOCK - SEC_CPU1_INT_MASK4 Lock
 *  0b00..Reserved
 *  0b01..SEC_CPU1_INT_MASK4 cannot be written
 *  0b10..SEC_CPU1_INT_MASK4 can be written
 *  0b11..Reserved
 */
#define AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK4_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK4_LOCK_SHIFT)) & AHBSC_SEC_GP_REG_LOCK_SEC_CPU1_INT_MASK4_LOCK_MASK)
/*! @} */

/*! @name MASTER_SEC_LEVEL - Master Secure Level */
/*! @{ */

#define AHBSC_MASTER_SEC_LEVEL_CPU1_MASK         (0xCU)
#define AHBSC_MASTER_SEC_LEVEL_CPU1_SHIFT        (2U)
/*! CPU1 - CPU1
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_CPU1(x)           (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_CPU1_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_CPU1_MASK)

#define AHBSC_MASTER_SEC_LEVEL_SMARTDMA_MASK     (0x30U)
#define AHBSC_MASTER_SEC_LEVEL_SMARTDMA_SHIFT    (4U)
/*! SMARTDMA - SMARTDMA Data
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_SMARTDMA(x)       (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_SMARTDMA_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_SMARTDMA_MASK)

#define AHBSC_MASTER_SEC_LEVEL_EDMA0_MASK        (0xC0U)
#define AHBSC_MASTER_SEC_LEVEL_EDMA0_SHIFT       (6U)
/*! eDMA0 - eDMA0
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_EDMA0(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_EDMA0_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_EDMA0_MASK)

#define AHBSC_MASTER_SEC_LEVEL_EDMA1_MASK        (0x300U)
#define AHBSC_MASTER_SEC_LEVEL_EDMA1_SHIFT       (8U)
/*! eDMA1 - eDMA1
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_EDMA1(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_EDMA1_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_EDMA1_MASK)

#define AHBSC_MASTER_SEC_LEVEL_PKC_MASK          (0xC00U)
#define AHBSC_MASTER_SEC_LEVEL_PKC_SHIFT         (10U)
/*! PKC - PKC
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_PKC(x)            (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_PKC_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_PKC_MASK)

#define AHBSC_MASTER_SEC_LEVEL_PQ_MASK           (0xC000U)
#define AHBSC_MASTER_SEC_LEVEL_PQ_SHIFT          (14U)
/*! PQ - PowerQuad
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_PQ(x)             (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_PQ_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_PQ_MASK)

#define AHBSC_MASTER_SEC_LEVEL_NPUO_MASK         (0x30000U)
#define AHBSC_MASTER_SEC_LEVEL_NPUO_SHIFT        (16U)
/*! NPUO - NPU Operands
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_NPUO(x)           (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_NPUO_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_NPUO_MASK)

#define AHBSC_MASTER_SEC_LEVEL_COOLFLUXI_MASK    (0xC0000U)
#define AHBSC_MASTER_SEC_LEVEL_COOLFLUXI_SHIFT   (18U)
/*! COOLFLUXI - Coolflux Instruction
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_COOLFLUXI(x)      (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_COOLFLUXI_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_COOLFLUXI_MASK)

#define AHBSC_MASTER_SEC_LEVEL_USB_FS_MASK       (0xC00000U)
#define AHBSC_MASTER_SEC_LEVEL_USB_FS_SHIFT      (22U)
/*! USB_FS - USB_FS
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_USB_FS(x)         (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_USB_FS_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_USB_FS_MASK)

#define AHBSC_MASTER_SEC_LEVEL_ETHERNET_MASK     (0x3000000U)
#define AHBSC_MASTER_SEC_LEVEL_ETHERNET_SHIFT    (24U)
/*! ETHERNET - Ethernet
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_ETHERNET(x)       (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_ETHERNET_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_ETHERNET_MASK)

#define AHBSC_MASTER_SEC_LEVEL_USB_HS_MASK       (0xC000000U)
#define AHBSC_MASTER_SEC_LEVEL_USB_HS_SHIFT      (26U)
/*! USB_HS - USB HS
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_USB_HS(x)         (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_USB_HS_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_USB_HS_MASK)

#define AHBSC_MASTER_SEC_LEVEL_USDHC_MASK        (0x30000000U)
#define AHBSC_MASTER_SEC_LEVEL_USDHC_SHIFT       (28U)
/*! USDHC - uSDHC
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHBSC_MASTER_SEC_LEVEL_USDHC(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_USDHC_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_USDHC_MASK)

#define AHBSC_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_MASK (0xC0000000U)
#define AHBSC_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_SHIFT (30U)
/*! MASTER_SEC_LEVEL_LOCK - Master SEC Level Lock
 *  0b00..Reserved
 *  0b01..MASTER_SEC_LEVEL_LOCK cannot be written
 *  0b10..MASTER_SEC_LEVEL_LOCK can be written
 *  0b11..Reserved
 */
#define AHBSC_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_SHIFT)) & AHBSC_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_MASK)
/*! @} */

/*! @name MASTER_SEC_ANTI_POL_REG - Master Secure Level */
/*! @{ */

#define AHBSC_MASTER_SEC_ANTI_POL_REG_CPU1_MASK  (0xCU)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_CPU1_SHIFT (2U)
/*! CPU1 - CPU1
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_CPU1(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_CPU1_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_CPU1_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_SMARTDMA_MASK (0x30U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_SMARTDMA_SHIFT (4U)
/*! SMARTDMA - SMARTDMA Data
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_SMARTDMA(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_SMARTDMA_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_SMARTDMA_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA0_MASK (0xC0U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA0_SHIFT (6U)
/*! eDMA0 - eDMA0
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA0(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA0_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA0_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA1_MASK (0x300U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA1_SHIFT (8U)
/*! eDMA1 - eDMA1
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA1(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA1_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_EDMA1_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_PKC_MASK   (0xC00U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_PKC_SHIFT  (10U)
/*! PKC - PKC
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_PKC(x)     (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_PKC_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_PKC_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_PQ_MASK    (0xC000U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_PQ_SHIFT   (14U)
/*! PQ - PowerQuad
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_PQ(x)      (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_PQ_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_PQ_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_NPUO_MASK  (0x30000U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_NPUO_SHIFT (16U)
/*! NPUO - NPU Operands
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_NPUO(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_NPUO_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_NPUO_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_COOLFLUXI_MASK (0xC0000U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_COOLFLUXI_SHIFT (18U)
/*! COOLFLUXI - Coolflux Instruction
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_COOLFLUXI(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_COOLFLUXI_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_COOLFLUXI_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_USB_FS_MASK (0xC00000U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_USB_FS_SHIFT (22U)
/*! USB_FS - USB_FS
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_USB_FS(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_USB_FS_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_USB_FS_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_ETHERNET_MASK (0x3000000U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_ETHERNET_SHIFT (24U)
/*! ETHERNET - Ethernet
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_ETHERNET(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_ETHERNET_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_ETHERNET_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_USB_HS_MASK (0xC000000U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_USB_HS_SHIFT (26U)
/*! USB_HS - USB HS
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_USB_HS(x)  (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_USB_HS_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_USB_HS_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_USDHC_MASK (0x30000000U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_USDHC_SHIFT (28U)
/*! USDHC - uSDHC
 *  0b00..Secure and privileged Master
 *  0b01..Secure and non-privileged Master
 *  0b10..Non-secure and privileged Master
 *  0b11..Non-secure and non-privileged Master
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_USDHC(x)   (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_USDHC_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_USDHC_MASK)

#define AHBSC_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_MASK (0xC0000000U)
#define AHBSC_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_SHIFT (30U)
/*! MASTER_SEC_LEVEL_ANTIPOL_LOCK - Master SEC Level Antipol Lock
 *  0b00..Reserved
 *  0b01..MASTER_SEC_LEVEL_LOCK cannot be written
 *  0b10..MASTER_SEC_LEVEL_LOCK can be written
 *  0b11..Reserved
 */
#define AHBSC_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_SHIFT)) & AHBSC_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_MASK)
/*! @} */

/*! @name CPU0_LOCK_REG - Miscellaneous CPU0 Control Signals */
/*! @{ */

#define AHBSC_CPU0_LOCK_REG_LOCK_NS_VTOR_MASK    (0x3U)
#define AHBSC_CPU0_LOCK_REG_LOCK_NS_VTOR_SHIFT   (0U)
/*! LOCK_NS_VTOR - LOCK_NS_VTOR
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCKNSVTOR is 1
 *  0b10..CM33 (CPU0) LOCKNSVTOR is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_LOCK_NS_VTOR(x)      (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_LOCK_NS_VTOR_SHIFT)) & AHBSC_CPU0_LOCK_REG_LOCK_NS_VTOR_MASK)

#define AHBSC_CPU0_LOCK_REG_LOCK_NS_MPU_MASK     (0xCU)
#define AHBSC_CPU0_LOCK_REG_LOCK_NS_MPU_SHIFT    (2U)
/*! LOCK_NS_MPU - LOCK_NS_MPU
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCK_NS_MPU is 1
 *  0b10..CM33 (CPU0) LOCK_NS_MPU is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_LOCK_NS_MPU(x)       (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_LOCK_NS_MPU_SHIFT)) & AHBSC_CPU0_LOCK_REG_LOCK_NS_MPU_MASK)

#define AHBSC_CPU0_LOCK_REG_LOCK_S_VTAIRCR_MASK  (0x30U)
#define AHBSC_CPU0_LOCK_REG_LOCK_S_VTAIRCR_SHIFT (4U)
/*! LOCK_S_VTAIRCR - LOCK_S_VTAIRCR
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCK_S_VTAIRCR is 1
 *  0b10..CM33 (CPU0) LOCK_S_VTAIRCR is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_LOCK_S_VTAIRCR(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_LOCK_S_VTAIRCR_SHIFT)) & AHBSC_CPU0_LOCK_REG_LOCK_S_VTAIRCR_MASK)

#define AHBSC_CPU0_LOCK_REG_LOCK_S_MPU_MASK      (0xC0U)
#define AHBSC_CPU0_LOCK_REG_LOCK_S_MPU_SHIFT     (6U)
/*! LOCK_S_MPU - LOCK_S_MPU
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCK_S_MPU is 1
 *  0b10..CM33 (CPU0) LOCK_S_MPU is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_LOCK_S_MPU(x)        (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_LOCK_S_MPU_SHIFT)) & AHBSC_CPU0_LOCK_REG_LOCK_S_MPU_MASK)

#define AHBSC_CPU0_LOCK_REG_LOCK_SAU_MASK        (0x300U)
#define AHBSC_CPU0_LOCK_REG_LOCK_SAU_SHIFT       (8U)
/*! LOCK_SAU - LOCK_SAU
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCK_SAU is 1
 *  0b10..CM33 (CPU0) LOCK_SAU is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_LOCK_SAU(x)          (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_LOCK_SAU_SHIFT)) & AHBSC_CPU0_LOCK_REG_LOCK_SAU_MASK)

#define AHBSC_CPU0_LOCK_REG_CM33_LOCK_REG_LOCK_MASK (0xC0000000U)
#define AHBSC_CPU0_LOCK_REG_CM33_LOCK_REG_LOCK_SHIFT (30U)
/*! CM33_LOCK_REG_LOCK - CM33_LOCK_REG_LOCK
 *  0b00..Reserved
 *  0b01..CM33_LOCK_REG_LOCK is 1
 *  0b10..CM33_LOCK_REG_LOCK is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU0_LOCK_REG_CM33_LOCK_REG_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU0_LOCK_REG_CM33_LOCK_REG_LOCK_SHIFT)) & AHBSC_CPU0_LOCK_REG_CM33_LOCK_REG_LOCK_MASK)
/*! @} */

/*! @name CPU1_LOCK_REG - Miscellaneous CPU1 Control Signals */
/*! @{ */

#define AHBSC_CPU1_LOCK_REG_LOCK_NS_VTOR_MASK    (0x3U)
#define AHBSC_CPU1_LOCK_REG_LOCK_NS_VTOR_SHIFT   (0U)
/*! LOCK_NS_VTOR - LOCK_NS_VTOR
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCKNSVTOR is 1
 *  0b10..CM33 (CPU0) LOCKNSVTOR is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU1_LOCK_REG_LOCK_NS_VTOR(x)      (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU1_LOCK_REG_LOCK_NS_VTOR_SHIFT)) & AHBSC_CPU1_LOCK_REG_LOCK_NS_VTOR_MASK)

#define AHBSC_CPU1_LOCK_REG_LOCK_NS_MPU_MASK     (0xCU)
#define AHBSC_CPU1_LOCK_REG_LOCK_NS_MPU_SHIFT    (2U)
/*! LOCK_NS_MPU - LOCK_NS_MPU
 *  0b00..Reserved
 *  0b01..CM33 (CPU0) LOCK_NS_MPU is 1
 *  0b10..CM33 (CPU0) LOCK_NS_MPU is 0
 *  0b11..Reserved
 */
#define AHBSC_CPU1_LOCK_REG_LOCK_NS_MPU(x)       (((uint32_t)(((uint32_t)(x)) << AHBSC_CPU1_LOCK_REG_LOCK_NS_MPU_SHIFT)) & AHBSC_CPU1_LOCK_REG_LOCK_NS_MPU_MASK)
/*! @} */

/*! @name MISC_CTRL_DP_REG - Secure Control Duplicate */
/*! @{ */

#define AHBSC_MISC_CTRL_DP_REG_WRITE_LOCK_MASK   (0x3U)
#define AHBSC_MISC_CTRL_DP_REG_WRITE_LOCK_SHIFT  (0U)
/*! WRITE_LOCK - Write Lock
 *  0b00..Reserved
 *  0b01..Writes to this register and to the Memory and Peripheral RULE registers are not allowed
 *  0b10..Writes to this register and to the Memory and Peripheral RULE registers are allowed
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_WRITE_LOCK(x)     (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_WRITE_LOCK_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_WRITE_LOCK_MASK)

#define AHBSC_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_MASK (0xCU)
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_SHIFT (2U)
/*! ENABLE_SECURE_CHECKING - Enable Secure Checking
 *  0b00..Reserved
 *  0b01..Enables secure checking. Violation can be detected when the security level of a transaction does not
 *        meet the security rule of the slave or memory to be accessed.
 *  0b10..Disables secure checking. Even if the security level of a transaction does not conform to the security
 *        rule of the slave or memory, it will not be detected as a violation.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_MASK)

#define AHBSC_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_MASK (0x30U)
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_SHIFT (4U)
/*! ENABLE_S_PRIV_CHECK - Enable Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enables the privilege checking of secure mode access.
 *  0b10..Disables the privilege checking of secure mode access.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_MASK)

#define AHBSC_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_MASK (0xC0U)
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_SHIFT (6U)
/*! ENABLE_NS_PRIV_CHECK - Enable Non-Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enables the privilege checking of non-secure mode access.
 *  0b10..Disables the privilege checking of non-secure mode access.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_MASK)

#define AHBSC_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_MASK (0x300U)
#define AHBSC_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_SHIFT (8U)
/*! DISABLE_VIOLATION_ABORT - Disable Violation Abort
 *  0b00..Reserved
 *  0b01..The violation detected by the secure checker will not cause an abort, but a secure_violation_irq
 *        (interrupt request) will still be asserted and serviced by ISR.
 *  0b10..The violation detected by the secure checker will cause an abort.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_MASK)

#define AHBSC_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_MASK (0xC00U)
#define AHBSC_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_SHIFT (10U)
/*! DISABLE_STRICT_MODE - Disable Strict Mode
 *  0b00..Reserved
 *  0b01..Master can access memories and peripherals at the same level or below that level.
 *  0b10..Master can access memories and peripherals at same level only
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_DISABLE_STRICT_MODE_MASK)

#define AHBSC_MISC_CTRL_DP_REG_IDAU_ALL_NS_MASK  (0xC000U)
#define AHBSC_MISC_CTRL_DP_REG_IDAU_ALL_NS_SHIFT (14U)
/*! IDAU_ALL_NS - IDAU All Non-Secure
 *  0b00..Reserved
 *  0b01..IDAU is disabled, which means that all memories are attributed as non-secure memory.
 *  0b10..IDAU is enabled (restrictive mode)
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_DP_REG_IDAU_ALL_NS(x)    (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_DP_REG_IDAU_ALL_NS_SHIFT)) & AHBSC_MISC_CTRL_DP_REG_IDAU_ALL_NS_MASK)
/*! @} */

/*! @name MISC_CTRL_REG - Secure Control */
/*! @{ */

#define AHBSC_MISC_CTRL_REG_WRITE_LOCK_MASK      (0x3U)
#define AHBSC_MISC_CTRL_REG_WRITE_LOCK_SHIFT     (0U)
/*! WRITE_LOCK - Write Lock
 *  0b00..Reserved
 *  0b01..Writes to this register and to the Memory and Peripheral RULE registers are not allowed
 *  0b10..Writes to this register and to the Memory and Peripheral RULE registers are allowed
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_WRITE_LOCK(x)        (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_WRITE_LOCK_SHIFT)) & AHBSC_MISC_CTRL_REG_WRITE_LOCK_MASK)

#define AHBSC_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_MASK (0xCU)
#define AHBSC_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_SHIFT (2U)
/*! ENABLE_SECURE_CHECKING - Enable Secure Checking
 *  0b00..Reserved
 *  0b01..Enables secure checking. Violation can be detected when the security level of a transaction does not
 *        meet the security rule of the slave or memory to be accessed.
 *  0b10..Disables secure checking. Even if the security level of a transaction does not conform to the security
 *        rule of the slave or memory, it will not be detected as a violation.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_ENABLE_SECURE_CHECKING(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_SHIFT)) & AHBSC_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_MASK)

#define AHBSC_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_MASK (0x30U)
#define AHBSC_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_SHIFT (4U)
/*! ENABLE_S_PRIV_CHECK - Enable Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enables privilege checking of secure mode access.
 *  0b10..Disables privilege checking of secure mode access.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_SHIFT)) & AHBSC_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_MASK)

#define AHBSC_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_MASK (0xC0U)
#define AHBSC_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_SHIFT (6U)
/*! ENABLE_NS_PRIV_CHECK - Enable Non-Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enables privilege checking of non-secure mode access.
 *  0b10..Disables privilege checking of non-secure mode access is disabled.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_SHIFT)) & AHBSC_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_MASK)

#define AHBSC_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_MASK (0x300U)
#define AHBSC_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_SHIFT (8U)
/*! DISABLE_VIOLATION_ABORT - Disable Violation Abort
 *  0b00..Reserved
 *  0b01..The violation detected by the secure checker will not cause an abort, but a secure_violation_irq
 *        (interrupt request) will still be asserted and serviced by ISR.
 *  0b10..The violation detected by the secure checker will cause an abort.
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_SHIFT)) & AHBSC_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_MASK)

#define AHBSC_MISC_CTRL_REG_DISABLE_STRICT_MODE_MASK (0xC00U)
#define AHBSC_MISC_CTRL_REG_DISABLE_STRICT_MODE_SHIFT (10U)
/*! DISABLE_STRICT_MODE - Disable Strict Mode
 *  0b00..Reserved
 *  0b01..Master strict mode is on and can access memories and peripherals at the same level or below that level
 *  0b10..Master strict mode is disabled and can access memories and peripherals at same level only
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_DISABLE_STRICT_MODE(x) (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_DISABLE_STRICT_MODE_SHIFT)) & AHBSC_MISC_CTRL_REG_DISABLE_STRICT_MODE_MASK)

#define AHBSC_MISC_CTRL_REG_IDAU_ALL_NS_MASK     (0xC000U)
#define AHBSC_MISC_CTRL_REG_IDAU_ALL_NS_SHIFT    (14U)
/*! IDAU_ALL_NS - IDAU All Non-Secure
 *  0b00..Reserved
 *  0b01..IDAU is disabled, which means that all memories are attributed as non-secure memory.
 *  0b10..IDAU is enabled (restrictive mode)
 *  0b11..Reserved
 */
#define AHBSC_MISC_CTRL_REG_IDAU_ALL_NS(x)       (((uint32_t)(((uint32_t)(x)) << AHBSC_MISC_CTRL_REG_IDAU_ALL_NS_SHIFT)) & AHBSC_MISC_CTRL_REG_IDAU_ALL_NS_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AHBSC_Register_Masks */


/* AHBSC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral AHBSC base address */
  #define AHBSC_BASE                               (0x50120000u)
  /** Peripheral AHBSC base address */
  #define AHBSC_BASE_NS                            (0x40120000u)
  /** Peripheral AHBSC base pointer */
  #define AHBSC                                    ((AHBSC_Type *)AHBSC_BASE)
  /** Peripheral AHBSC base pointer */
  #define AHBSC_NS                                 ((AHBSC_Type *)AHBSC_BASE_NS)
  /** Peripheral AHBSC_ALIAS1 base address */
  #define AHBSC_ALIAS1_BASE                        (0x50121000u)
  /** Peripheral AHBSC_ALIAS1 base address */
  #define AHBSC_ALIAS1_BASE_NS                     (0x40121000u)
  /** Peripheral AHBSC_ALIAS1 base pointer */
  #define AHBSC_ALIAS1                             ((AHBSC_Type *)AHBSC_ALIAS1_BASE)
  /** Peripheral AHBSC_ALIAS1 base pointer */
  #define AHBSC_ALIAS1_NS                          ((AHBSC_Type *)AHBSC_ALIAS1_BASE_NS)
  /** Peripheral AHBSC_ALIAS2 base address */
  #define AHBSC_ALIAS2_BASE                        (0x50122000u)
  /** Peripheral AHBSC_ALIAS2 base address */
  #define AHBSC_ALIAS2_BASE_NS                     (0x40122000u)
  /** Peripheral AHBSC_ALIAS2 base pointer */
  #define AHBSC_ALIAS2                             ((AHBSC_Type *)AHBSC_ALIAS2_BASE)
  /** Peripheral AHBSC_ALIAS2 base pointer */
  #define AHBSC_ALIAS2_NS                          ((AHBSC_Type *)AHBSC_ALIAS2_BASE_NS)
  /** Peripheral AHBSC_ALIAS3 base address */
  #define AHBSC_ALIAS3_BASE                        (0x50123000u)
  /** Peripheral AHBSC_ALIAS3 base address */
  #define AHBSC_ALIAS3_BASE_NS                     (0x40123000u)
  /** Peripheral AHBSC_ALIAS3 base pointer */
  #define AHBSC_ALIAS3                             ((AHBSC_Type *)AHBSC_ALIAS3_BASE)
  /** Peripheral AHBSC_ALIAS3 base pointer */
  #define AHBSC_ALIAS3_NS                          ((AHBSC_Type *)AHBSC_ALIAS3_BASE_NS)
  /** Array initializer of AHBSC peripheral base addresses */
  #define AHBSC_BASE_ADDRS                         { AHBSC_BASE, AHBSC_ALIAS1_BASE, AHBSC_ALIAS2_BASE, AHBSC_ALIAS3_BASE }
  /** Array initializer of AHBSC peripheral base pointers */
  #define AHBSC_BASE_PTRS                          { AHBSC, AHBSC_ALIAS1, AHBSC_ALIAS2, AHBSC_ALIAS3 }
  /** Array initializer of AHBSC peripheral base addresses */
  #define AHBSC_BASE_ADDRS_NS                      { AHBSC_BASE_NS, AHBSC_ALIAS1_BASE_NS, AHBSC_ALIAS2_BASE_NS, AHBSC_ALIAS3_BASE_NS }
  /** Array initializer of AHBSC peripheral base pointers */
  #define AHBSC_BASE_PTRS_NS                       { AHBSC_NS, AHBSC_ALIAS1_NS, AHBSC_ALIAS2_NS, AHBSC_ALIAS3_NS }
#else
  /** Peripheral AHBSC base address */
  #define AHBSC_BASE                               (0x40120000u)
  /** Peripheral AHBSC base pointer */
  #define AHBSC                                    ((AHBSC_Type *)AHBSC_BASE)
  /** Peripheral AHBSC_ALIAS1 base address */
  #define AHBSC_ALIAS1_BASE                        (0x40121000u)
  /** Peripheral AHBSC_ALIAS1 base pointer */
  #define AHBSC_ALIAS1                             ((AHBSC_Type *)AHBSC_ALIAS1_BASE)
  /** Peripheral AHBSC_ALIAS2 base address */
  #define AHBSC_ALIAS2_BASE                        (0x40122000u)
  /** Peripheral AHBSC_ALIAS2 base pointer */
  #define AHBSC_ALIAS2                             ((AHBSC_Type *)AHBSC_ALIAS2_BASE)
  /** Peripheral AHBSC_ALIAS3 base address */
  #define AHBSC_ALIAS3_BASE                        (0x40123000u)
  /** Peripheral AHBSC_ALIAS3 base pointer */
  #define AHBSC_ALIAS3                             ((AHBSC_Type *)AHBSC_ALIAS3_BASE)
  /** Array initializer of AHBSC peripheral base addresses */
  #define AHBSC_BASE_ADDRS                         { AHBSC_BASE, AHBSC_ALIAS1_BASE, AHBSC_ALIAS2_BASE, AHBSC_ALIAS3_BASE }
  /** Array initializer of AHBSC peripheral base pointers */
  #define AHBSC_BASE_PTRS                          { AHBSC, AHBSC_ALIAS1, AHBSC_ALIAS2, AHBSC_ALIAS3 }
#endif

/*!
 * @}
 */ /* end of group AHBSC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- BSP32 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BSP32_Peripheral_Access_Layer BSP32 Peripheral Access Layer
 * @{
 */

/** BSP32 - Register Layout Typedef */
typedef struct {
  __IO uint32_t OFFSET_PMEM;                       /**< Offset address register for program memory, offset: 0x0 */
  __IO uint32_t OFFSET_XMEM;                       /**< Offset address register for X-data memory, offset: 0x4 */
  __IO uint32_t OFFSET_YMEM;                       /**< Offset address register for Y-data memory, offset: 0x8 */
  __IO uint32_t OFFSET_MAILBOX;                    /**< Offset address register for mailbox peripheral, offset: 0xC */
  __O  uint32_t INTERRUPTS_EXTERNAL;               /**< External interrupt register, offset: 0x10 */
  __IO uint32_t INTERRUPTS_STATUS;                 /**< Interrupt status register, offset: 0x14 */
  __IO uint32_t CF_GATING_OVERRIDE;                /**< CoolFlux BSP32 gating override, offset: 0x18 */
  __IO uint32_t IVT_OFFSET;                        /**< CoolFlux BSP32 IVT offset register, offset: 0x1C */
  __I  uint32_t SLEEP_MODE;                        /**< CoolFlux BSP32 sleep mode register, offset: 0x20 */
  __IO uint32_t IVT0;                              /**< CoolFlux BSP32 IVT register 0 content, offset: 0x24 */
  __IO uint32_t IVT1;                              /**< CoolFlux BSP32 IVT register 1 content, offset: 0x28 */
  __IO uint32_t IVT2;                              /**< CoolFlux BSP32 IVT register 2 content, offset: 0x2C */
  __IO uint32_t IVT3;                              /**< CoolFlux BSP32 IVT register 3 content, offset: 0x30 */
  __IO uint32_t IVT_DISABLE;                       /**< CoolFlux BSP32 IVT disable register, offset: 0x34 */
} BSP32_Type;

/* ----------------------------------------------------------------------------
   -- BSP32 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BSP32_Register_Masks BSP32 Register Masks
 * @{
 */

/*! @name OFFSET_PMEM - Offset address register for program memory */
/*! @{ */

#define BSP32_OFFSET_PMEM_VAL_MASK               (0x3FU)
#define BSP32_OFFSET_PMEM_VAL_SHIFT              (0U)
/*! val - Offset address register for program memory */
#define BSP32_OFFSET_PMEM_VAL(x)                 (((uint32_t)(((uint32_t)(x)) << BSP32_OFFSET_PMEM_VAL_SHIFT)) & BSP32_OFFSET_PMEM_VAL_MASK)
/*! @} */

/*! @name OFFSET_XMEM - Offset address register for X-data memory */
/*! @{ */

#define BSP32_OFFSET_XMEM_VAL_MASK               (0xFFU)
#define BSP32_OFFSET_XMEM_VAL_SHIFT              (0U)
/*! val - Offset address register for X-data memory */
#define BSP32_OFFSET_XMEM_VAL(x)                 (((uint32_t)(((uint32_t)(x)) << BSP32_OFFSET_XMEM_VAL_SHIFT)) & BSP32_OFFSET_XMEM_VAL_MASK)
/*! @} */

/*! @name OFFSET_YMEM - Offset address register for Y-data memory */
/*! @{ */

#define BSP32_OFFSET_YMEM_VAL_MASK               (0xFFU)
#define BSP32_OFFSET_YMEM_VAL_SHIFT              (0U)
/*! val - Offset address register for Y-data memory */
#define BSP32_OFFSET_YMEM_VAL(x)                 (((uint32_t)(((uint32_t)(x)) << BSP32_OFFSET_YMEM_VAL_SHIFT)) & BSP32_OFFSET_YMEM_VAL_MASK)
/*! @} */

/*! @name OFFSET_MAILBOX - Offset address register for mailbox peripheral */
/*! @{ */

#define BSP32_OFFSET_MAILBOX_VAL_MASK            (0xFFFFFFU)
#define BSP32_OFFSET_MAILBOX_VAL_SHIFT           (0U)
/*! val - Offset address register for mailbox peripheral */
#define BSP32_OFFSET_MAILBOX_VAL(x)              (((uint32_t)(((uint32_t)(x)) << BSP32_OFFSET_MAILBOX_VAL_SHIFT)) & BSP32_OFFSET_MAILBOX_VAL_MASK)
/*! @} */

/*! @name INTERRUPTS_EXTERNAL - External interrupt register */
/*! @{ */

#define BSP32_INTERRUPTS_EXTERNAL_VAL_MASK       (0xFFFFFFFFU)
#define BSP32_INTERRUPTS_EXTERNAL_VAL_SHIFT      (0U)
/*! val - External interrupt register */
#define BSP32_INTERRUPTS_EXTERNAL_VAL(x)         (((uint32_t)(((uint32_t)(x)) << BSP32_INTERRUPTS_EXTERNAL_VAL_SHIFT)) & BSP32_INTERRUPTS_EXTERNAL_VAL_MASK)
/*! @} */

/*! @name INTERRUPTS_STATUS - Interrupt status register */
/*! @{ */

#define BSP32_INTERRUPTS_STATUS_VAL_MASK         (0x1U)
#define BSP32_INTERRUPTS_STATUS_VAL_SHIFT        (0U)
/*! val - Interrupt status register */
#define BSP32_INTERRUPTS_STATUS_VAL(x)           (((uint32_t)(((uint32_t)(x)) << BSP32_INTERRUPTS_STATUS_VAL_SHIFT)) & BSP32_INTERRUPTS_STATUS_VAL_MASK)
/*! @} */

/*! @name CF_GATING_OVERRIDE - CoolFlux BSP32 gating override */
/*! @{ */

#define BSP32_CF_GATING_OVERRIDE_VAL_MASK        (0x1U)
#define BSP32_CF_GATING_OVERRIDE_VAL_SHIFT       (0U)
/*! val - CoolFlux BSP32 gating override */
#define BSP32_CF_GATING_OVERRIDE_VAL(x)          (((uint32_t)(((uint32_t)(x)) << BSP32_CF_GATING_OVERRIDE_VAL_SHIFT)) & BSP32_CF_GATING_OVERRIDE_VAL_MASK)
/*! @} */

/*! @name IVT_OFFSET - CoolFlux BSP32 IVT offset register */
/*! @{ */

#define BSP32_IVT_OFFSET_VAL_MASK                (0xFFFFFFU)
#define BSP32_IVT_OFFSET_VAL_SHIFT               (0U)
/*! val - CoolFlux BSP32 IVT offset register */
#define BSP32_IVT_OFFSET_VAL(x)                  (((uint32_t)(((uint32_t)(x)) << BSP32_IVT_OFFSET_VAL_SHIFT)) & BSP32_IVT_OFFSET_VAL_MASK)
/*! @} */

/*! @name SLEEP_MODE - CoolFlux BSP32 sleep mode register */
/*! @{ */

#define BSP32_SLEEP_MODE_VAL_MASK                (0x1U)
#define BSP32_SLEEP_MODE_VAL_SHIFT               (0U)
/*! val - CoolFlux BSP32 sleep mode register */
#define BSP32_SLEEP_MODE_VAL(x)                  (((uint32_t)(((uint32_t)(x)) << BSP32_SLEEP_MODE_VAL_SHIFT)) & BSP32_SLEEP_MODE_VAL_MASK)
/*! @} */

/*! @name IVT0 - CoolFlux BSP32 IVT register 0 content */
/*! @{ */

#define BSP32_IVT0_VAL_MASK                      (0xFFFFFFU)
#define BSP32_IVT0_VAL_SHIFT                     (0U)
/*! val - CoolFlux BSP32 IVT register 0 content */
#define BSP32_IVT0_VAL(x)                        (((uint32_t)(((uint32_t)(x)) << BSP32_IVT0_VAL_SHIFT)) & BSP32_IVT0_VAL_MASK)
/*! @} */

/*! @name IVT1 - CoolFlux BSP32 IVT register 1 content */
/*! @{ */

#define BSP32_IVT1_VAL_MASK                      (0xFFFFFFU)
#define BSP32_IVT1_VAL_SHIFT                     (0U)
/*! val - CoolFlux BSP32 IVT register 1 content */
#define BSP32_IVT1_VAL(x)                        (((uint32_t)(((uint32_t)(x)) << BSP32_IVT1_VAL_SHIFT)) & BSP32_IVT1_VAL_MASK)
/*! @} */

/*! @name IVT2 - CoolFlux BSP32 IVT register 2 content */
/*! @{ */

#define BSP32_IVT2_VAL_MASK                      (0xFFFFFFU)
#define BSP32_IVT2_VAL_SHIFT                     (0U)
/*! val - CoolFlux BSP32 IVT register 2 content */
#define BSP32_IVT2_VAL(x)                        (((uint32_t)(((uint32_t)(x)) << BSP32_IVT2_VAL_SHIFT)) & BSP32_IVT2_VAL_MASK)
/*! @} */

/*! @name IVT3 - CoolFlux BSP32 IVT register 3 content */
/*! @{ */

#define BSP32_IVT3_VAL_MASK                      (0xFFFFFFU)
#define BSP32_IVT3_VAL_SHIFT                     (0U)
/*! val - CoolFlux BSP32 IVT register 3 content */
#define BSP32_IVT3_VAL(x)                        (((uint32_t)(((uint32_t)(x)) << BSP32_IVT3_VAL_SHIFT)) & BSP32_IVT3_VAL_MASK)
/*! @} */

/*! @name IVT_DISABLE - CoolFlux BSP32 IVT disable register */
/*! @{ */

#define BSP32_IVT_DISABLE_VAL_MASK               (0x1U)
#define BSP32_IVT_DISABLE_VAL_SHIFT              (0U)
/*! val - CoolFlux BSP32 IVT disable register */
#define BSP32_IVT_DISABLE_VAL(x)                 (((uint32_t)(((uint32_t)(x)) << BSP32_IVT_DISABLE_VAL_SHIFT)) & BSP32_IVT_DISABLE_VAL_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group BSP32_Register_Masks */


/* BSP32 - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral BSP32_0 base address */
  #define BSP32_0_BASE                             (0x50032000u)
  /** Peripheral BSP32_0 base address */
  #define BSP32_0_BASE_NS                          (0x40032000u)
  /** Peripheral BSP32_0 base pointer */
  #define BSP32_0                                  ((BSP32_Type *)BSP32_0_BASE)
  /** Peripheral BSP32_0 base pointer */
  #define BSP32_0_NS                               ((BSP32_Type *)BSP32_0_BASE_NS)
  /** Array initializer of BSP32 peripheral base addresses */
  #define BSP32_BASE_ADDRS                         { BSP32_0_BASE }
  /** Array initializer of BSP32 peripheral base pointers */
  #define BSP32_BASE_PTRS                          { BSP32_0 }
  /** Array initializer of BSP32 peripheral base addresses */
  #define BSP32_BASE_ADDRS_NS                      { BSP32_0_BASE_NS }
  /** Array initializer of BSP32 peripheral base pointers */
  #define BSP32_BASE_PTRS_NS                       { BSP32_0_NS }
#else
  /** Peripheral BSP32_0 base address */
  #define BSP32_0_BASE                             (0x40032000u)
  /** Peripheral BSP32_0 base pointer */
  #define BSP32_0                                  ((BSP32_Type *)BSP32_0_BASE)
  /** Array initializer of BSP32 peripheral base addresses */
  #define BSP32_BASE_ADDRS                         { BSP32_0_BASE }
  /** Array initializer of BSP32 peripheral base pointers */
  #define BSP32_BASE_PTRS                          { BSP32_0 }
#endif

/*!
 * @}
 */ /* end of group BSP32_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Peripheral_Access_Layer CACHE64_CTRL Peripheral Access Layer
 * @{
 */

/** CACHE64_CTRL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[2048];
  __IO uint32_t CCR;                               /**< Cache Control, offset: 0x800 */
  __IO uint32_t CLCR;                              /**< Cache Line Control, offset: 0x804 */
  __IO uint32_t CSAR;                              /**< Cache Search Address, offset: 0x808 */
  __IO uint32_t CCVR;                              /**< Cache Read/Write Value, offset: 0x80C */
} CACHE64_CTRL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Register_Masks CACHE64_CTRL Register Masks
 * @{
 */

/*! @name CCR - Cache Control */
/*! @{ */

#define CACHE64_CTRL_CCR_ENCACHE_MASK            (0x1U)
#define CACHE64_CTRL_CCR_ENCACHE_SHIFT           (0U)
/*! ENCACHE - Cache Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define CACHE64_CTRL_CCR_ENCACHE(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENCACHE_SHIFT)) & CACHE64_CTRL_CCR_ENCACHE_MASK)

#define CACHE64_CTRL_CCR_ENWRBUF_MASK            (0x2U)
#define CACHE64_CTRL_CCR_ENWRBUF_SHIFT           (1U)
/*! ENWRBUF - Enable Write Buffer
 *  0b0..Disables
 *  0b1..Enables
 */
#define CACHE64_CTRL_CCR_ENWRBUF(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENWRBUF_SHIFT)) & CACHE64_CTRL_CCR_ENWRBUF_MASK)

#define CACHE64_CTRL_CCR_FRCWT_MASK              (0x4U)
#define CACHE64_CTRL_CCR_FRCWT_SHIFT             (2U)
/*! FRCWT - Force Write Through Mode
 *  0b0..Does not force
 *  0b1..Force
 */
#define CACHE64_CTRL_CCR_FRCWT(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_FRCWT_SHIFT)) & CACHE64_CTRL_CCR_FRCWT_MASK)

#define CACHE64_CTRL_CCR_FRCNOALLC_MASK          (0x8U)
#define CACHE64_CTRL_CCR_FRCNOALLC_SHIFT         (3U)
/*! FRCNOALLC - Forces No Allocation On Cache Misses
 *  0b0..Allocation on cache misses
 *  0b1..Forces no allocation on cache misses (FRCWT must be asserted)
 */
#define CACHE64_CTRL_CCR_FRCNOALLC(x)            (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_FRCNOALLC_SHIFT)) & CACHE64_CTRL_CCR_FRCNOALLC_MASK)

#define CACHE64_CTRL_CCR_INVW0_MASK              (0x1000000U)
#define CACHE64_CTRL_CCR_INVW0_SHIFT             (24U)
/*! INVW0 - Invalidate Way 0
 *  0b0..No operation
 *  0b1..Invalidates all lines in way 0
 */
#define CACHE64_CTRL_CCR_INVW0(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW0_SHIFT)) & CACHE64_CTRL_CCR_INVW0_MASK)

#define CACHE64_CTRL_CCR_PUSHW0_MASK             (0x2000000U)
#define CACHE64_CTRL_CCR_PUSHW0_SHIFT            (25U)
/*! PUSHW0 - Push Way 0
 *  0b0..No operation
 *  0b1..Push all modified lines in way 0
 */
#define CACHE64_CTRL_CCR_PUSHW0(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW0_SHIFT)) & CACHE64_CTRL_CCR_PUSHW0_MASK)

#define CACHE64_CTRL_CCR_INVW1_MASK              (0x4000000U)
#define CACHE64_CTRL_CCR_INVW1_SHIFT             (26U)
/*! INVW1 - Invalidate Way 1
 *  0b0..No operation
 *  0b1..Invalidates all lines in way 1
 */
#define CACHE64_CTRL_CCR_INVW1(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW1_SHIFT)) & CACHE64_CTRL_CCR_INVW1_MASK)

#define CACHE64_CTRL_CCR_PUSHW1_MASK             (0x8000000U)
#define CACHE64_CTRL_CCR_PUSHW1_SHIFT            (27U)
/*! PUSHW1 - Push Way 1
 *  0b0..No operation
 *  0b1..Push all modified lines in way 1
 */
#define CACHE64_CTRL_CCR_PUSHW1(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW1_SHIFT)) & CACHE64_CTRL_CCR_PUSHW1_MASK)

#define CACHE64_CTRL_CCR_GO_MASK                 (0x80000000U)
#define CACHE64_CTRL_CCR_GO_SHIFT                (31U)
/*! GO - Initiate Cache Command
 *  0b0..Write: no effect; Read: no cache command active
 *  0b1..Write: initiates cache command; Read: cache command active
 */
#define CACHE64_CTRL_CCR_GO(x)                   (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_GO_SHIFT)) & CACHE64_CTRL_CCR_GO_MASK)
/*! @} */

/*! @name CLCR - Cache Line Control */
/*! @{ */

#define CACHE64_CTRL_CLCR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CLCR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect; Read: no line command active
 *  0b1..Write: initiate line command; Read: line command active
 */
#define CACHE64_CTRL_CLCR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LGO_SHIFT)) & CACHE64_CTRL_CLCR_LGO_MASK)

#define CACHE64_CTRL_CLCR_CACHEADDR_MASK         (0x1FFCU)
#define CACHE64_CTRL_CLCR_CACHEADDR_SHIFT        (2U)
/*! CACHEADDR - Cache Address */
#define CACHE64_CTRL_CLCR_CACHEADDR(x)           (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_CACHEADDR_SHIFT)) & CACHE64_CTRL_CLCR_CACHEADDR_MASK)

#define CACHE64_CTRL_CLCR_WSEL_MASK              (0x4000U)
#define CACHE64_CTRL_CLCR_WSEL_SHIFT             (14U)
/*! WSEL - Way Select
 *  0b0..Way 0
 *  0b1..Way 1
 */
#define CACHE64_CTRL_CLCR_WSEL(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_WSEL_SHIFT)) & CACHE64_CTRL_CLCR_WSEL_MASK)

#define CACHE64_CTRL_CLCR_TDSEL_MASK             (0x10000U)
#define CACHE64_CTRL_CLCR_TDSEL_SHIFT            (16U)
/*! TDSEL - Tag Or Data Select
 *  0b0..Data
 *  0b1..Tag
 */
#define CACHE64_CTRL_CLCR_TDSEL(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_TDSEL_SHIFT)) & CACHE64_CTRL_CLCR_TDSEL_MASK)

#define CACHE64_CTRL_CLCR_LCIVB_MASK             (0x100000U)
#define CACHE64_CTRL_CLCR_LCIVB_SHIFT            (20U)
/*! LCIVB - Line Command Initial Valid Bit
 *  0b0..Initial state 0
 *  0b1..Initial state 1
 */
#define CACHE64_CTRL_CLCR_LCIVB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIVB_SHIFT)) & CACHE64_CTRL_CLCR_LCIVB_MASK)

#define CACHE64_CTRL_CLCR_LCIMB_MASK             (0x200000U)
#define CACHE64_CTRL_CLCR_LCIMB_SHIFT            (21U)
/*! LCIMB - Line Command Initial Modified Bit
 *  0b0..Initial state 0
 *  0b1..Initial state 1
 */
#define CACHE64_CTRL_CLCR_LCIMB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIMB_SHIFT)) & CACHE64_CTRL_CLCR_LCIMB_MASK)

#define CACHE64_CTRL_CLCR_LCWAY_MASK             (0x400000U)
#define CACHE64_CTRL_CLCR_LCWAY_SHIFT            (22U)
/*! LCWAY - Line Command Way
 *  0b0..Way 0
 *  0b1..Way 1
 */
#define CACHE64_CTRL_CLCR_LCWAY(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCWAY_SHIFT)) & CACHE64_CTRL_CLCR_LCWAY_MASK)

#define CACHE64_CTRL_CLCR_LCMD_MASK              (0x3000000U)
#define CACHE64_CTRL_CLCR_LCMD_SHIFT             (24U)
/*! LCMD - Line Command
 *  0b00..Search and read or write
 *  0b01..Invalidate
 *  0b10..Push
 *  0b11..Clear
 */
#define CACHE64_CTRL_CLCR_LCMD(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCMD_SHIFT)) & CACHE64_CTRL_CLCR_LCMD_MASK)

#define CACHE64_CTRL_CLCR_LADSEL_MASK            (0x4000000U)
#define CACHE64_CTRL_CLCR_LADSEL_SHIFT           (26U)
/*! LADSEL - Line Address Select
 *  0b0..Cache
 *  0b1..Physical
 */
#define CACHE64_CTRL_CLCR_LADSEL(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LADSEL_SHIFT)) & CACHE64_CTRL_CLCR_LADSEL_MASK)

#define CACHE64_CTRL_CLCR_LACC_MASK              (0x8000000U)
#define CACHE64_CTRL_CLCR_LACC_SHIFT             (27U)
/*! LACC - Line Access Type
 *  0b0..Read
 *  0b1..Write
 */
#define CACHE64_CTRL_CLCR_LACC(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LACC_SHIFT)) & CACHE64_CTRL_CLCR_LACC_MASK)
/*! @} */

/*! @name CSAR - Cache Search Address */
/*! @{ */

#define CACHE64_CTRL_CSAR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CSAR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect; Read: no line command active
 *  0b1..Write: initiate line command; Read: line command active
 */
#define CACHE64_CTRL_CSAR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_LGO_SHIFT)) & CACHE64_CTRL_CSAR_LGO_MASK)

#define CACHE64_CTRL_CSAR_PHYADDR_MASK           (0xFFFFFFFEU)
#define CACHE64_CTRL_CSAR_PHYADDR_SHIFT          (1U)
/*! PHYADDR - Physical Address */
#define CACHE64_CTRL_CSAR_PHYADDR(x)             (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_PHYADDR_SHIFT)) & CACHE64_CTRL_CSAR_PHYADDR_MASK)
/*! @} */

/*! @name CCVR - Cache Read/Write Value */
/*! @{ */

#define CACHE64_CTRL_CCVR_DATA_MASK              (0xFFFFFFFFU)
#define CACHE64_CTRL_CCVR_DATA_SHIFT             (0U)
/*! DATA - Cache Read/Write Data */
#define CACHE64_CTRL_CCVR_DATA(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCVR_DATA_SHIFT)) & CACHE64_CTRL_CCVR_DATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Register_Masks */


/* CACHE64_CTRL - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE                       (0x5001B000u)
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE_NS                    (0x4001B000u)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0                            ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0_NS                         ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE_NS)
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS                  { CACHE64_CTRL0_BASE }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS                   { CACHE64_CTRL0 }
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS_NS               { CACHE64_CTRL0_BASE_NS }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS_NS                { CACHE64_CTRL0_NS }
#else
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE                       (0x4001B000u)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0                            ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE)
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS                  { CACHE64_CTRL0_BASE }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS                   { CACHE64_CTRL0 }
#endif
#if (__ARM_FEATURE_CMSE & 0x2)
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES                { 0x18000000u, 0x90000000u, 0xB0000000u}
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES                { 0x08000000u, 0x10000000u, 0x10000000u}
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES_NS             { 0x08000000u, 0x80000000u, 0xA0000000u}
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES_NS             { 0x08000000u, 0x10000000u, 0x10000000u}
#else
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES                { 0x08000000u, 0x80000000u, 0xA0000000u}
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES                { 0x08000000u, 0x10000000u, 0x10000000u}
#endif
/* Backward compatibility */


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Peripheral_Access_Layer CACHE64_POLSEL Peripheral Access Layer
 * @{
 */

/** CACHE64_POLSEL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[20];
  __IO uint32_t REG0_TOP;                          /**< Region 0 Top Boundary, offset: 0x14 */
  __IO uint32_t REG1_TOP;                          /**< Region 1 Top Boundary, offset: 0x18 */
  __IO uint32_t POLSEL;                            /**< Policy Select, offset: 0x1C */
} CACHE64_POLSEL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Register_Masks CACHE64_POLSEL Register Masks
 * @{
 */

/*! @name REG0_TOP - Region 0 Top Boundary */
/*! @{ */

#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK    (0x1FFFFC00U)
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT   (10U)
/*! REG0_TOP - Upper Limit Of Region 0 */
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT)) & CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK)
/*! @} */

/*! @name REG1_TOP - Region 1 Top Boundary */
/*! @{ */

#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK    (0x1FFFFC00U)
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT   (10U)
/*! REG1_TOP - Upper Limit Of Region 1 */
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT)) & CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK)
/*! @} */

/*! @name POLSEL - Policy Select */
/*! @{ */

#define CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK   (0x3U)
#define CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT  (0U)
/*! REG0_POLICY - Policy Select For Region 0
 *  0b00..Noncacheable
 *  0b01..Write-through
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG0_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK)

#define CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK   (0xCU)
#define CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT  (2U)
/*! REG1_POLICY - Policy Select For Region 1
 *  0b00..Noncacheable
 *  0b01..Write-through
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG1_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK)

#define CACHE64_POLSEL_POLSEL_REG2_POLICY_MASK   (0x30U)
#define CACHE64_POLSEL_POLSEL_REG2_POLICY_SHIFT  (4U)
/*! REG2_POLICY - Policy Select For Region 2
 *  0b00..Noncacheable
 *  0b01..Write-through
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG2_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG2_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG2_POLICY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Register_Masks */


/* CACHE64_POLSEL - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE                     (0x5001B000u)
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE_NS                  (0x4001B000u)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0_NS                       ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE_NS)
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS                { CACHE64_POLSEL0_BASE }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS                 { CACHE64_POLSEL0 }
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS_NS             { CACHE64_POLSEL0_BASE_NS }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS_NS              { CACHE64_POLSEL0_NS }
#else
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE                     (0x4001B000u)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE)
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS                { CACHE64_POLSEL0_BASE }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS                 { CACHE64_POLSEL0 }
#endif

/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< Control 1, offset: 0x4 */
  __IO uint32_t TIMER;                             /**< Free-Running Timer, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t RXMGMASK;                          /**< RX Message Buffers Global Mask, offset: 0x10 */
  __IO uint32_t RX14MASK;                          /**< Receive 14 Mask, offset: 0x14 */
  __IO uint32_t RX15MASK;                          /**< Receive 15 Mask, offset: 0x18 */
  __IO uint32_t ECR;                               /**< Error Counter, offset: 0x1C */
  __IO uint32_t ESR1;                              /**< Error and Status 1, offset: 0x20 */
       uint8_t RESERVED_1[4];
  __IO uint32_t IMASK1;                            /**< Interrupt Masks 1, offset: 0x28 */
       uint8_t RESERVED_2[4];
  __IO uint32_t IFLAG1;                            /**< Interrupt Flags 1, offset: 0x30 */
  __IO uint32_t CTRL2;                             /**< Control 2, offset: 0x34 */
  __I  uint32_t ESR2;                              /**< Error and Status 2, offset: 0x38 */
       uint8_t RESERVED_3[8];
  __I  uint32_t CRCR;                              /**< Cyclic Redundancy Check, offset: 0x44 */
  __IO uint32_t RXFGMASK;                          /**< Legacy RX FIFO Global Mask, offset: 0x48 */
  __I  uint32_t RXFIR;                             /**< Legacy RX FIFO Information, offset: 0x4C */
  __IO uint32_t CBT;                               /**< CAN Bit Timing, offset: 0x50 */
       uint8_t RESERVED_4[44];
  union {                                          /* offset: 0x80 */
    struct {                                         /* offset: 0x80, array step: 0x10 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 31 CS Register, array offset: 0x80, array step: 0x10 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 31 ID Register, array offset: 0x84, array step: 0x10 */
      __IO uint32_t WORD[2];                           /**< Message Buffer 0 WORD_8B Register..Message Buffer 31 WORD_8B Register, array offset: 0x88, array step: index*0x10, index2*0x4 */
    } MB_8B[32];
    struct {                                         /* offset: 0x80, array step: 0x18 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 20 CS Register, array offset: 0x80, array step: 0x18 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 20 ID Register, array offset: 0x84, array step: 0x18 */
      __IO uint32_t WORD[4];                           /**< Message Buffer 0 WORD_16B Register..Message Buffer 20 WORD_16B Register, array offset: 0x88, array step: index*0x18, index2*0x4 */
    } MB_16B[21];
    struct {                                         /* offset: 0x80, array step: 0x28 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 11 CS Register, array offset: 0x80, array step: 0x28 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 11 ID Register, array offset: 0x84, array step: 0x28 */
      __IO uint32_t WORD[8];                           /**< Message Buffer 0 WORD_32B Register..Message Buffer 11 WORD_32B Register, array offset: 0x88, array step: index*0x28, index2*0x4 */
    } MB_32B[12];
    struct {                                         /* offset: 0x80, array step: 0x48 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 6 CS Register, array offset: 0x80, array step: 0x48 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 6 ID Register, array offset: 0x84, array step: 0x48 */
      __IO uint32_t WORD[16];                          /**< Message Buffer 0 WORD_64B Register..Message Buffer 6 WORD_64B Register, array offset: 0x88, array step: index*0x48, index2*0x4 */
    } MB_64B[7];
    struct {                                         /* offset: 0x80, array step: 0x10 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 31 CS Register, array offset: 0x80, array step: 0x10 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 31 ID Register, array offset: 0x84, array step: 0x10 */
      __IO uint32_t WORD0;                             /**< Message Buffer 0 WORD0 Register..Message Buffer 31 WORD0 Register, array offset: 0x88, array step: 0x10 */
      __IO uint32_t WORD1;                             /**< Message Buffer 0 WORD1 Register..Message Buffer 31 WORD1 Register, array offset: 0x8C, array step: 0x10 */
    } MB[32];
  };
       uint8_t RESERVED_5[1536];
  __IO uint32_t RXIMR[32];                         /**< Receive Individual Mask, array offset: 0x880, array step: 0x4 */
       uint8_t RESERVED_6[512];
  __IO uint32_t CTRL1_PN;                          /**< Pretended Networking Control 1, offset: 0xB00 */
  __IO uint32_t CTRL2_PN;                          /**< Pretended Networking Control 2, offset: 0xB04 */
  __IO uint32_t WU_MTC;                            /**< Pretended Networking Wake-Up Match, offset: 0xB08 */
  __IO uint32_t FLT_ID1;                           /**< Pretended Networking ID Filter 1, offset: 0xB0C */
  __IO uint32_t FLT_DLC;                           /**< Pretended Networking Data Length Code (DLC) Filter, offset: 0xB10 */
  __IO uint32_t PL1_LO;                            /**< Pretended Networking Payload Low Filter 1, offset: 0xB14 */
  __IO uint32_t PL1_HI;                            /**< Pretended Networking Payload High Filter 1, offset: 0xB18 */
  __IO uint32_t FLT_ID2_IDMASK;                    /**< Pretended Networking ID Filter 2 or ID Mask, offset: 0xB1C */
  __IO uint32_t PL2_PLMASK_LO;                     /**< Pretended Networking Payload Low Filter 2 and Payload Low Mask, offset: 0xB20 */
  __IO uint32_t PL2_PLMASK_HI;                     /**< Pretended Networking Payload High Filter 2 and Payload High Mask, offset: 0xB24 */
       uint8_t RESERVED_7[24];
  struct {                                         /* offset: 0xB40, array step: 0x10 */
    __I  uint32_t CS;                                /**< Wake-Up Message Buffer, array offset: 0xB40, array step: 0x10 */
    __I  uint32_t ID;                                /**< Wake-Up Message Buffer for ID, array offset: 0xB44, array step: 0x10 */
    __I  uint32_t D03;                               /**< Wake-Up Message Buffer for Data 0-3, array offset: 0xB48, array step: 0x10 */
    __I  uint32_t D47;                               /**< Wake-Up Message Buffer Register Data 4-7, array offset: 0xB4C, array step: 0x10 */
  } WMB[4];
       uint8_t RESERVED_8[112];
  __IO uint32_t EPRS;                              /**< Enhanced CAN Bit Timing Prescalers, offset: 0xBF0 */
  __IO uint32_t ENCBT;                             /**< Enhanced Nominal CAN Bit Timing, offset: 0xBF4 */
  __IO uint32_t EDCBT;                             /**< Enhanced Data Phase CAN Bit Timing, offset: 0xBF8 */
  __IO uint32_t ETDC;                              /**< Enhanced Transceiver Delay Compensation, offset: 0xBFC */
  __IO uint32_t FDCTRL;                            /**< CAN FD Control, offset: 0xC00 */
  __IO uint32_t FDCBT;                             /**< CAN FD Bit Timing, offset: 0xC04 */
  __I  uint32_t FDCRC;                             /**< CAN FD CRC, offset: 0xC08 */
  __IO uint32_t ERFCR;                             /**< Enhanced RX FIFO Control, offset: 0xC0C */
  __IO uint32_t ERFIER;                            /**< Enhanced RX FIFO Interrupt Enable, offset: 0xC10 */
  __IO uint32_t ERFSR;                             /**< Enhanced RX FIFO Status, offset: 0xC14 */
       uint8_t RESERVED_9[9192];
  __IO uint32_t ERFFEL[32];                        /**< Enhanced RX FIFO Filter Element, array offset: 0x3000, array step: 0x4 */
} CAN_Type;

/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/*! @name MCR - Module Configuration */
/*! @{ */

#define CAN_MCR_MAXMB_MASK                       (0x7FU)
#define CAN_MCR_MAXMB_SHIFT                      (0U)
/*! MAXMB - Number of the Last Message Buffer */
#define CAN_MCR_MAXMB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MAXMB_SHIFT)) & CAN_MCR_MAXMB_MASK)

#define CAN_MCR_IDAM_MASK                        (0x300U)
#define CAN_MCR_IDAM_SHIFT                       (8U)
/*! IDAM - ID Acceptance Mode
 *  0b00..Format A: One full ID (standard and extended) per ID filter table element.
 *  0b01..Format B: Two full standard IDs or two partial 14-bit (standard and extended) IDs per ID filter table element.
 *  0b10..Format C: Four partial 8-bit standard IDs per ID filter table element.
 *  0b11..Format D: All frames rejected.
 */
#define CAN_MCR_IDAM(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IDAM_SHIFT)) & CAN_MCR_IDAM_MASK)

#define CAN_MCR_FDEN_MASK                        (0x800U)
#define CAN_MCR_FDEN_SHIFT                       (11U)
/*! FDEN - CAN FD Operation Enable
 *  0b1..Enable
 *  0b0..Disable
 */
#define CAN_MCR_FDEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FDEN_SHIFT)) & CAN_MCR_FDEN_MASK)

#define CAN_MCR_AEN_MASK                         (0x1000U)
#define CAN_MCR_AEN_SHIFT                        (12U)
/*! AEN - Abort Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_MCR_AEN(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_AEN_SHIFT)) & CAN_MCR_AEN_MASK)

#define CAN_MCR_LPRIOEN_MASK                     (0x2000U)
#define CAN_MCR_LPRIOEN_SHIFT                    (13U)
/*! LPRIOEN - Local Priority Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_LPRIOEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPRIOEN_SHIFT)) & CAN_MCR_LPRIOEN_MASK)

#define CAN_MCR_PNET_EN_MASK                     (0x4000U)
#define CAN_MCR_PNET_EN_SHIFT                    (14U)
/*! PNET_EN - Pretended Networking Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_PNET_EN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_PNET_EN_SHIFT)) & CAN_MCR_PNET_EN_MASK)

#define CAN_MCR_DMA_MASK                         (0x8000U)
#define CAN_MCR_DMA_SHIFT                        (15U)
/*! DMA - DMA Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_DMA(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_DMA_SHIFT)) & CAN_MCR_DMA_MASK)

#define CAN_MCR_IRMQ_MASK                        (0x10000U)
#define CAN_MCR_IRMQ_SHIFT                       (16U)
/*! IRMQ - Individual RX Masking and Queue Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_IRMQ(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IRMQ_SHIFT)) & CAN_MCR_IRMQ_MASK)

#define CAN_MCR_SRXDIS_MASK                      (0x20000U)
#define CAN_MCR_SRXDIS_SHIFT                     (17U)
/*! SRXDIS - Self-Reception Disable
 *  0b0..Enable
 *  0b1..Disable
 */
#define CAN_MCR_SRXDIS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SRXDIS_SHIFT)) & CAN_MCR_SRXDIS_MASK)

#define CAN_MCR_WAKSRC_MASK                      (0x80000U)
#define CAN_MCR_WAKSRC_SHIFT                     (19U)
/*! WAKSRC - Wake-Up Source
 *  0b0..No filter applied
 *  0b1..Filter applied
 */
#define CAN_MCR_WAKSRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKSRC_SHIFT)) & CAN_MCR_WAKSRC_MASK)

#define CAN_MCR_LPMACK_MASK                      (0x100000U)
#define CAN_MCR_LPMACK_SHIFT                     (20U)
/*! LPMACK - Low-Power Mode Acknowledge
 *  0b0..Not in a low-power mode
 *  0b1..In a low-power mode
 */
#define CAN_MCR_LPMACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPMACK_SHIFT)) & CAN_MCR_LPMACK_MASK)

#define CAN_MCR_WRNEN_MASK                       (0x200000U)
#define CAN_MCR_WRNEN_SHIFT                      (21U)
/*! WRNEN - Warning Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_WRNEN(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WRNEN_SHIFT)) & CAN_MCR_WRNEN_MASK)

#define CAN_MCR_SLFWAK_MASK                      (0x400000U)
#define CAN_MCR_SLFWAK_SHIFT                     (22U)
/*! SLFWAK - Self Wake-up
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_SLFWAK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SLFWAK_SHIFT)) & CAN_MCR_SLFWAK_MASK)

#define CAN_MCR_FRZACK_MASK                      (0x1000000U)
#define CAN_MCR_FRZACK_SHIFT                     (24U)
/*! FRZACK - Freeze Mode Acknowledge
 *  0b0..Not in Freeze mode, prescaler running.
 *  0b1..In Freeze mode, prescaler stopped.
 */
#define CAN_MCR_FRZACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZACK_SHIFT)) & CAN_MCR_FRZACK_MASK)

#define CAN_MCR_SOFTRST_MASK                     (0x2000000U)
#define CAN_MCR_SOFTRST_SHIFT                    (25U)
/*! SOFTRST - Soft Reset
 *  0b0..No reset
 *  0b1..Soft reset affects reset registers
 */
#define CAN_MCR_SOFTRST(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SOFTRST_SHIFT)) & CAN_MCR_SOFTRST_MASK)

#define CAN_MCR_WAKMSK_MASK                      (0x4000000U)
#define CAN_MCR_WAKMSK_SHIFT                     (26U)
/*! WAKMSK - Wake-up Interrupt Mask
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_MCR_WAKMSK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKMSK_SHIFT)) & CAN_MCR_WAKMSK_MASK)

#define CAN_MCR_NOTRDY_MASK                      (0x8000000U)
#define CAN_MCR_NOTRDY_SHIFT                     (27U)
/*! NOTRDY - FlexCAN Not Ready
 *  0b0..FlexCAN is in Normal mode, Listen-Only mode, or Loopback mode.
 *  0b1..FlexCAN is in Disable mode, Stop mode, or Freeze mode.
 */
#define CAN_MCR_NOTRDY(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_NOTRDY_SHIFT)) & CAN_MCR_NOTRDY_MASK)

#define CAN_MCR_HALT_MASK                        (0x10000000U)
#define CAN_MCR_HALT_SHIFT                       (28U)
/*! HALT - Halt FlexCAN
 *  0b0..No request
 *  0b1..Enter Freeze mode, if MCR[FRZ] = 1.
 */
#define CAN_MCR_HALT(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_HALT_SHIFT)) & CAN_MCR_HALT_MASK)

#define CAN_MCR_RFEN_MASK                        (0x20000000U)
#define CAN_MCR_RFEN_SHIFT                       (29U)
/*! RFEN - Legacy RX FIFO Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_RFEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_RFEN_SHIFT)) & CAN_MCR_RFEN_MASK)

#define CAN_MCR_FRZ_MASK                         (0x40000000U)
#define CAN_MCR_FRZ_SHIFT                        (30U)
/*! FRZ - Freeze Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZ_SHIFT)) & CAN_MCR_FRZ_MASK)

#define CAN_MCR_MDIS_MASK                        (0x80000000U)
#define CAN_MCR_MDIS_SHIFT                       (31U)
/*! MDIS - Module Disable
 *  0b0..Enable
 *  0b1..Disable
 */
#define CAN_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MDIS_SHIFT)) & CAN_MCR_MDIS_MASK)
/*! @} */

/*! @name CTRL1 - Control 1 */
/*! @{ */

#define CAN_CTRL1_PROPSEG_MASK                   (0x7U)
#define CAN_CTRL1_PROPSEG_SHIFT                  (0U)
/*! PROPSEG - Propagation Segment */
#define CAN_CTRL1_PROPSEG(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PROPSEG_SHIFT)) & CAN_CTRL1_PROPSEG_MASK)

#define CAN_CTRL1_LOM_MASK                       (0x8U)
#define CAN_CTRL1_LOM_SHIFT                      (3U)
/*! LOM - Listen-Only Mode
 *  0b0..Listen-Only mode is deactivated.
 *  0b1..FlexCAN module operates in Listen-Only mode.
 */
#define CAN_CTRL1_LOM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LOM_SHIFT)) & CAN_CTRL1_LOM_MASK)

#define CAN_CTRL1_LBUF_MASK                      (0x10U)
#define CAN_CTRL1_LBUF_SHIFT                     (4U)
/*! LBUF - Lowest Buffer Transmitted First
 *  0b0..Buffer with highest priority is transmitted first.
 *  0b1..Lowest number buffer is transmitted first.
 */
#define CAN_CTRL1_LBUF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LBUF_SHIFT)) & CAN_CTRL1_LBUF_MASK)

#define CAN_CTRL1_TSYN_MASK                      (0x20U)
#define CAN_CTRL1_TSYN_SHIFT                     (5U)
/*! TSYN - Timer Sync
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL1_TSYN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TSYN_SHIFT)) & CAN_CTRL1_TSYN_MASK)

#define CAN_CTRL1_BOFFREC_MASK                   (0x40U)
#define CAN_CTRL1_BOFFREC_SHIFT                  (6U)
/*! BOFFREC - Bus Off Recovery
 *  0b0..Enabled
 *  0b1..Disabled
 */
#define CAN_CTRL1_BOFFREC(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFREC_SHIFT)) & CAN_CTRL1_BOFFREC_MASK)

#define CAN_CTRL1_SMP_MASK                       (0x80U)
#define CAN_CTRL1_SMP_SHIFT                      (7U)
/*! SMP - CAN Bit Sampling
 *  0b0..One sample is used to determine the bit value.
 *  0b1..Three samples are used to determine the value of the received bit: the regular one (sample point) and two
 *       preceding samples. A majority rule is used.
 */
#define CAN_CTRL1_SMP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_SMP_SHIFT)) & CAN_CTRL1_SMP_MASK)

#define CAN_CTRL1_RWRNMSK_MASK                   (0x400U)
#define CAN_CTRL1_RWRNMSK_SHIFT                  (10U)
/*! RWRNMSK - RX Warning Interrupt Mask
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL1_RWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RWRNMSK_SHIFT)) & CAN_CTRL1_RWRNMSK_MASK)

#define CAN_CTRL1_TWRNMSK_MASK                   (0x800U)
#define CAN_CTRL1_TWRNMSK_SHIFT                  (11U)
/*! TWRNMSK - TX Warning Interrupt Mask
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL1_TWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TWRNMSK_SHIFT)) & CAN_CTRL1_TWRNMSK_MASK)

#define CAN_CTRL1_LPB_MASK                       (0x1000U)
#define CAN_CTRL1_LPB_SHIFT                      (12U)
/*! LPB - Loopback Mode
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL1_LPB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LPB_SHIFT)) & CAN_CTRL1_LPB_MASK)

#define CAN_CTRL1_ERRMSK_MASK                    (0x4000U)
#define CAN_CTRL1_ERRMSK_SHIFT                   (14U)
/*! ERRMSK - Error Interrupt Mask
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_CTRL1_ERRMSK(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_ERRMSK_SHIFT)) & CAN_CTRL1_ERRMSK_MASK)

#define CAN_CTRL1_BOFFMSK_MASK                   (0x8000U)
#define CAN_CTRL1_BOFFMSK_SHIFT                  (15U)
/*! BOFFMSK - Bus Off Interrupt Mask
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CAN_CTRL1_BOFFMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFMSK_SHIFT)) & CAN_CTRL1_BOFFMSK_MASK)

#define CAN_CTRL1_PSEG2_MASK                     (0x70000U)
#define CAN_CTRL1_PSEG2_SHIFT                    (16U)
/*! PSEG2 - Phase Segment 2 */
#define CAN_CTRL1_PSEG2(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG2_SHIFT)) & CAN_CTRL1_PSEG2_MASK)

#define CAN_CTRL1_PSEG1_MASK                     (0x380000U)
#define CAN_CTRL1_PSEG1_SHIFT                    (19U)
/*! PSEG1 - Phase Segment 1 */
#define CAN_CTRL1_PSEG1(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG1_SHIFT)) & CAN_CTRL1_PSEG1_MASK)

#define CAN_CTRL1_RJW_MASK                       (0xC00000U)
#define CAN_CTRL1_RJW_SHIFT                      (22U)
/*! RJW - Resync Jump Width */
#define CAN_CTRL1_RJW(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RJW_SHIFT)) & CAN_CTRL1_RJW_MASK)

#define CAN_CTRL1_PRESDIV_MASK                   (0xFF000000U)
#define CAN_CTRL1_PRESDIV_SHIFT                  (24U)
/*! PRESDIV - Prescaler Division Factor */
#define CAN_CTRL1_PRESDIV(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PRESDIV_SHIFT)) & CAN_CTRL1_PRESDIV_MASK)
/*! @} */

/*! @name TIMER - Free-Running Timer */
/*! @{ */

#define CAN_TIMER_TIMER_MASK                     (0xFFFFU)
#define CAN_TIMER_TIMER_SHIFT                    (0U)
/*! TIMER - Timer Value */
#define CAN_TIMER_TIMER(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_TIMER_TIMER_SHIFT)) & CAN_TIMER_TIMER_MASK)
/*! @} */

/*! @name RXMGMASK - RX Message Buffers Global Mask */
/*! @{ */

#define CAN_RXMGMASK_MG_MASK                     (0xFFFFFFFFU)
#define CAN_RXMGMASK_MG_SHIFT                    (0U)
/*! MG - Global Mask for RX Message Buffers */
#define CAN_RXMGMASK_MG(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXMGMASK_MG_SHIFT)) & CAN_RXMGMASK_MG_MASK)
/*! @} */

/*! @name RX14MASK - Receive 14 Mask */
/*! @{ */

#define CAN_RX14MASK_RX14M_MASK                  (0xFFFFFFFFU)
#define CAN_RX14MASK_RX14M_SHIFT                 (0U)
/*! RX14M - RX Buffer 14 Mask Bits */
#define CAN_RX14MASK_RX14M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX14MASK_RX14M_SHIFT)) & CAN_RX14MASK_RX14M_MASK)
/*! @} */

/*! @name RX15MASK - Receive 15 Mask */
/*! @{ */

#define CAN_RX15MASK_RX15M_MASK                  (0xFFFFFFFFU)
#define CAN_RX15MASK_RX15M_SHIFT                 (0U)
/*! RX15M - RX Buffer 15 Mask Bits */
#define CAN_RX15MASK_RX15M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX15MASK_RX15M_SHIFT)) & CAN_RX15MASK_RX15M_MASK)
/*! @} */

/*! @name ECR - Error Counter */
/*! @{ */

#define CAN_ECR_TXERRCNT_MASK                    (0xFFU)
#define CAN_ECR_TXERRCNT_SHIFT                   (0U)
/*! TXERRCNT - Transmit Error Counter */
#define CAN_ECR_TXERRCNT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_SHIFT)) & CAN_ECR_TXERRCNT_MASK)

#define CAN_ECR_RXERRCNT_MASK                    (0xFF00U)
#define CAN_ECR_RXERRCNT_SHIFT                   (8U)
/*! RXERRCNT - Receive Error Counter */
#define CAN_ECR_RXERRCNT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_SHIFT)) & CAN_ECR_RXERRCNT_MASK)

#define CAN_ECR_TXERRCNT_FAST_MASK               (0xFF0000U)
#define CAN_ECR_TXERRCNT_FAST_SHIFT              (16U)
/*! TXERRCNT_FAST - Transmit Error Counter for Fast Bits */
#define CAN_ECR_TXERRCNT_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_FAST_SHIFT)) & CAN_ECR_TXERRCNT_FAST_MASK)

#define CAN_ECR_RXERRCNT_FAST_MASK               (0xFF000000U)
#define CAN_ECR_RXERRCNT_FAST_SHIFT              (24U)
/*! RXERRCNT_FAST - Receive Error Counter for Fast Bits */
#define CAN_ECR_RXERRCNT_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_FAST_SHIFT)) & CAN_ECR_RXERRCNT_FAST_MASK)
/*! @} */

/*! @name ESR1 - Error and Status 1 */
/*! @{ */

#define CAN_ESR1_WAKINT_MASK                     (0x1U)
#define CAN_ESR1_WAKINT_SHIFT                    (0U)
/*! WAKINT - Wake-up Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..Indicates that a recessive-to-dominant transition was received on the CAN bus.
 */
#define CAN_ESR1_WAKINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_WAKINT_SHIFT)) & CAN_ESR1_WAKINT_MASK)

#define CAN_ESR1_ERRINT_MASK                     (0x2U)
#define CAN_ESR1_ERRINT_SHIFT                    (1U)
/*! ERRINT - Error Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..Indicates setting of any error flag in the Error and Status register.
 */
#define CAN_ESR1_ERRINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_SHIFT)) & CAN_ESR1_ERRINT_MASK)

#define CAN_ESR1_BOFFINT_MASK                    (0x4U)
#define CAN_ESR1_BOFFINT_SHIFT                   (2U)
/*! BOFFINT - Bus Off Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..FlexCAN module entered Bus Off state.
 */
#define CAN_ESR1_BOFFINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFINT_SHIFT)) & CAN_ESR1_BOFFINT_MASK)

#define CAN_ESR1_RX_MASK                         (0x8U)
#define CAN_ESR1_RX_SHIFT                        (3U)
/*! RX - FlexCAN in Reception Flag
 *  0b0..Not receiving
 *  0b1..Receiving
 */
#define CAN_ESR1_RX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RX_SHIFT)) & CAN_ESR1_RX_MASK)

#define CAN_ESR1_FLTCONF_MASK                    (0x30U)
#define CAN_ESR1_FLTCONF_SHIFT                   (4U)
/*! FLTCONF - Fault Confinement State
 *  0b00..Error Active
 *  0b01..Error Passive
 *  0b1x..Bus Off
 */
#define CAN_ESR1_FLTCONF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FLTCONF_SHIFT)) & CAN_ESR1_FLTCONF_MASK)

#define CAN_ESR1_TX_MASK                         (0x40U)
#define CAN_ESR1_TX_SHIFT                        (6U)
/*! TX - FlexCAN In Transmission
 *  0b0..Not transmitting
 *  0b1..Transmitting
 */
#define CAN_ESR1_TX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TX_SHIFT)) & CAN_ESR1_TX_MASK)

#define CAN_ESR1_IDLE_MASK                       (0x80U)
#define CAN_ESR1_IDLE_SHIFT                      (7U)
/*! IDLE - Idle
 *  0b0..Not IDLE
 *  0b1..IDLE
 */
#define CAN_ESR1_IDLE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_IDLE_SHIFT)) & CAN_ESR1_IDLE_MASK)

#define CAN_ESR1_RXWRN_MASK                      (0x100U)
#define CAN_ESR1_RXWRN_SHIFT                     (8U)
/*! RXWRN - RX Error Warning Flag
 *  0b0..No such occurrence.
 *  0b1..RXERRCNT is greater than or equal to 96.
 */
#define CAN_ESR1_RXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RXWRN_SHIFT)) & CAN_ESR1_RXWRN_MASK)

#define CAN_ESR1_TXWRN_MASK                      (0x200U)
#define CAN_ESR1_TXWRN_SHIFT                     (9U)
/*! TXWRN - TX Error Warning Flag
 *  0b0..No such occurrence.
 *  0b1..TXERRCNT is 96 or greater.
 */
#define CAN_ESR1_TXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TXWRN_SHIFT)) & CAN_ESR1_TXWRN_MASK)

#define CAN_ESR1_STFERR_MASK                     (0x400U)
#define CAN_ESR1_STFERR_SHIFT                    (10U)
/*! STFERR - Stuffing Error Flag
 *  0b0..No error
 *  0b1..Error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_SHIFT)) & CAN_ESR1_STFERR_MASK)

#define CAN_ESR1_FRMERR_MASK                     (0x800U)
#define CAN_ESR1_FRMERR_SHIFT                    (11U)
/*! FRMERR - Form Error Flag
 *  0b0..No error
 *  0b1..Error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_SHIFT)) & CAN_ESR1_FRMERR_MASK)

#define CAN_ESR1_CRCERR_MASK                     (0x1000U)
#define CAN_ESR1_CRCERR_SHIFT                    (12U)
/*! CRCERR - Cyclic Redundancy Check Error Flag
 *  0b0..No error
 *  0b1..Error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_SHIFT)) & CAN_ESR1_CRCERR_MASK)

#define CAN_ESR1_ACKERR_MASK                     (0x2000U)
#define CAN_ESR1_ACKERR_SHIFT                    (13U)
/*! ACKERR - Acknowledge Error Flag
 *  0b0..No error
 *  0b1..Error occurred since last read of this register.
 */
#define CAN_ESR1_ACKERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ACKERR_SHIFT)) & CAN_ESR1_ACKERR_MASK)

#define CAN_ESR1_BIT0ERR_MASK                    (0x4000U)
#define CAN_ESR1_BIT0ERR_SHIFT                   (14U)
/*! BIT0ERR - Bit0 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_SHIFT)) & CAN_ESR1_BIT0ERR_MASK)

#define CAN_ESR1_BIT1ERR_MASK                    (0x8000U)
#define CAN_ESR1_BIT1ERR_SHIFT                   (15U)
/*! BIT1ERR - Bit1 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_SHIFT)) & CAN_ESR1_BIT1ERR_MASK)

#define CAN_ESR1_RWRNINT_MASK                    (0x10000U)
#define CAN_ESR1_RWRNINT_SHIFT                   (16U)
/*! RWRNINT - RX Warning Interrupt Flag
 *  0b0..No such occurrence
 *  0b1..RX error counter changed from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_RWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RWRNINT_SHIFT)) & CAN_ESR1_RWRNINT_MASK)

#define CAN_ESR1_TWRNINT_MASK                    (0x20000U)
#define CAN_ESR1_TWRNINT_SHIFT                   (17U)
/*! TWRNINT - TX Warning Interrupt Flag
 *  0b0..No such occurrence
 *  0b1..TX error counter changed from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_TWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TWRNINT_SHIFT)) & CAN_ESR1_TWRNINT_MASK)

#define CAN_ESR1_SYNCH_MASK                      (0x40000U)
#define CAN_ESR1_SYNCH_SHIFT                     (18U)
/*! SYNCH - CAN Synchronization Status Flag
 *  0b0..Not synchronized
 *  0b1..Synchronized
 */
#define CAN_ESR1_SYNCH(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_SYNCH_SHIFT)) & CAN_ESR1_SYNCH_MASK)

#define CAN_ESR1_BOFFDONEINT_MASK                (0x80000U)
#define CAN_ESR1_BOFFDONEINT_SHIFT               (19U)
/*! BOFFDONEINT - Bus Off Done Interrupt Flag
 *  0b0..No such occurrence
 *  0b1..FlexCAN module has completed Bus Off process.
 */
#define CAN_ESR1_BOFFDONEINT(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFDONEINT_SHIFT)) & CAN_ESR1_BOFFDONEINT_MASK)

#define CAN_ESR1_ERRINT_FAST_MASK                (0x100000U)
#define CAN_ESR1_ERRINT_FAST_SHIFT               (20U)
/*! ERRINT_FAST - Fast Error Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..Error flag set in the data phase of CAN FD frames that have BRS = 1.
 */
#define CAN_ESR1_ERRINT_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_FAST_SHIFT)) & CAN_ESR1_ERRINT_FAST_MASK)

#define CAN_ESR1_ERROVR_MASK                     (0x200000U)
#define CAN_ESR1_ERROVR_SHIFT                    (21U)
/*! ERROVR - Error Overrun Flag
 *  0b0..No overrun
 *  0b1..Overrun
 */
#define CAN_ESR1_ERROVR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERROVR_SHIFT)) & CAN_ESR1_ERROVR_MASK)

#define CAN_ESR1_STFERR_FAST_MASK                (0x4000000U)
#define CAN_ESR1_STFERR_FAST_SHIFT               (26U)
/*! STFERR_FAST - Fast Stuffing Error Flag
 *  0b0..No such occurrence.
 *  0b1..A stuffing error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_FAST_SHIFT)) & CAN_ESR1_STFERR_FAST_MASK)

#define CAN_ESR1_FRMERR_FAST_MASK                (0x8000000U)
#define CAN_ESR1_FRMERR_FAST_SHIFT               (27U)
/*! FRMERR_FAST - Fast Form Error Flag
 *  0b0..No such occurrence.
 *  0b1..A form error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_FAST_SHIFT)) & CAN_ESR1_FRMERR_FAST_MASK)

#define CAN_ESR1_CRCERR_FAST_MASK                (0x10000000U)
#define CAN_ESR1_CRCERR_FAST_SHIFT               (28U)
/*! CRCERR_FAST - Fast Cyclic Redundancy Check Error Flag
 *  0b0..No such occurrence.
 *  0b1..A CRC error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_FAST_SHIFT)) & CAN_ESR1_CRCERR_FAST_MASK)

#define CAN_ESR1_BIT0ERR_FAST_MASK               (0x40000000U)
#define CAN_ESR1_BIT0ERR_FAST_SHIFT              (30U)
/*! BIT0ERR_FAST - Fast Bit0 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit transmitted as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_FAST_SHIFT)) & CAN_ESR1_BIT0ERR_FAST_MASK)

#define CAN_ESR1_BIT1ERR_FAST_MASK               (0x80000000U)
#define CAN_ESR1_BIT1ERR_FAST_SHIFT              (31U)
/*! BIT1ERR_FAST - Fast Bit1 Error Flag
 *  0b0..No such occurrence.
 *  0b1..At least one bit transmitted as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_FAST_SHIFT)) & CAN_ESR1_BIT1ERR_FAST_MASK)
/*! @} */

/*! @name IMASK1 - Interrupt Masks 1 */
/*! @{ */

#define CAN_IMASK1_BUF31TO0M_MASK                (0xFFFFFFFFU)
#define CAN_IMASK1_BUF31TO0M_SHIFT               (0U)
/*! BUF31TO0M - Buffer MBi Mask */
#define CAN_IMASK1_BUF31TO0M(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IMASK1_BUF31TO0M_SHIFT)) & CAN_IMASK1_BUF31TO0M_MASK)
/*! @} */

/*! @name IFLAG1 - Interrupt Flags 1 */
/*! @{ */

#define CAN_IFLAG1_BUF0I_MASK                    (0x1U)
#define CAN_IFLAG1_BUF0I_SHIFT                   (0U)
/*! BUF0I - Buffer MB0 Interrupt or Clear Legacy FIFO bit
 *  0b0..MB0 has no occurrence of successfully completed transmission or reception.
 *  0b1..MB0 has successfully completed transmission or reception.
 */
#define CAN_IFLAG1_BUF0I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF0I_SHIFT)) & CAN_IFLAG1_BUF0I_MASK)

#define CAN_IFLAG1_BUF4TO1I_MASK                 (0x1EU)
#define CAN_IFLAG1_BUF4TO1I_SHIFT                (1U)
/*! BUF4TO1I - Buffer MBi Interrupt or Reserved */
#define CAN_IFLAG1_BUF4TO1I(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF4TO1I_SHIFT)) & CAN_IFLAG1_BUF4TO1I_MASK)

#define CAN_IFLAG1_BUF5I_MASK                    (0x20U)
#define CAN_IFLAG1_BUF5I_SHIFT                   (5U)
/*! BUF5I - Buffer MB5 Interrupt or Frames available in Legacy RX FIFO
 *  0b0..No occurrence of completed transmission or reception, or no frames available
 *  0b1..MB5 completed transmission or reception, or frames available
 */
#define CAN_IFLAG1_BUF5I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF5I_SHIFT)) & CAN_IFLAG1_BUF5I_MASK)

#define CAN_IFLAG1_BUF6I_MASK                    (0x40U)
#define CAN_IFLAG1_BUF6I_SHIFT                   (6U)
/*! BUF6I - Buffer MB6 Interrupt or Legacy RX FIFO Warning
 *  0b0..No occurrence of MB6 completing transmission or reception, or FIFO not almost full.
 *  0b1..MB6 completed transmission or reception, or FIFO almost full.
 */
#define CAN_IFLAG1_BUF6I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF6I_SHIFT)) & CAN_IFLAG1_BUF6I_MASK)

#define CAN_IFLAG1_BUF7I_MASK                    (0x80U)
#define CAN_IFLAG1_BUF7I_SHIFT                   (7U)
/*! BUF7I - Buffer MB7 Interrupt or Legacy RX FIFO Overflow
 *  0b0..No occurrence of MB7 completing transmission or reception, or no FIFO overflow.
 *  0b1..MB7 completed transmission or reception, or FIFO overflow.
 */
#define CAN_IFLAG1_BUF7I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF7I_SHIFT)) & CAN_IFLAG1_BUF7I_MASK)

#define CAN_IFLAG1_BUF31TO8I_MASK                (0xFFFFFF00U)
#define CAN_IFLAG1_BUF31TO8I_SHIFT               (8U)
/*! BUF31TO8I - Buffer MBi Interrupt */
#define CAN_IFLAG1_BUF31TO8I(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF31TO8I_SHIFT)) & CAN_IFLAG1_BUF31TO8I_MASK)
/*! @} */

/*! @name CTRL2 - Control 2 */
/*! @{ */

#define CAN_CTRL2_EDFLTDIS_MASK                  (0x800U)
#define CAN_CTRL2_EDFLTDIS_SHIFT                 (11U)
/*! EDFLTDIS - Edge Filter Disable
 *  0b0..Enabled
 *  0b1..Disabled
 */
#define CAN_CTRL2_EDFLTDIS(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EDFLTDIS_SHIFT)) & CAN_CTRL2_EDFLTDIS_MASK)

#define CAN_CTRL2_ISOCANFDEN_MASK                (0x1000U)
#define CAN_CTRL2_ISOCANFDEN_SHIFT               (12U)
/*! ISOCANFDEN - ISO CAN FD Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_ISOCANFDEN(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ISOCANFDEN_SHIFT)) & CAN_CTRL2_ISOCANFDEN_MASK)

#define CAN_CTRL2_BTE_MASK                       (0x2000U)
#define CAN_CTRL2_BTE_SHIFT                      (13U)
/*! BTE - Bit Timing Expansion Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_BTE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_BTE_SHIFT)) & CAN_CTRL2_BTE_MASK)

#define CAN_CTRL2_PREXCEN_MASK                   (0x4000U)
#define CAN_CTRL2_PREXCEN_SHIFT                  (14U)
/*! PREXCEN - Protocol Exception Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CAN_CTRL2_PREXCEN(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PREXCEN_SHIFT)) & CAN_CTRL2_PREXCEN_MASK)

#define CAN_CTRL2_EACEN_MASK                     (0x10000U)
#define CAN_CTRL2_EACEN_SHIFT                    (16U)
/*! EACEN - Entire Frame Arbitration Field Comparison Enable for RX Message Buffers
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_EACEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EACEN_SHIFT)) & CAN_CTRL2_EACEN_MASK)

#define CAN_CTRL2_RRS_MASK                       (0x20000U)
#define CAN_CTRL2_RRS_SHIFT                      (17U)
/*! RRS - Remote Request Storing
 *  0b0..Generated
 *  0b1..Stored
 */
#define CAN_CTRL2_RRS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RRS_SHIFT)) & CAN_CTRL2_RRS_MASK)

#define CAN_CTRL2_MRP_MASK                       (0x40000U)
#define CAN_CTRL2_MRP_SHIFT                      (18U)
/*! MRP - Message Buffers Reception Priority
 *  0b0..Matching starts from Legacy RX FIFO or Enhanced RX FIFO and continues on message buffers.
 *  0b1..Matching starts from message buffers and continues on Legacy RX FIFO or Enhanced RX FIFO.
 */
#define CAN_CTRL2_MRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_MRP_SHIFT)) & CAN_CTRL2_MRP_MASK)

#define CAN_CTRL2_TASD_MASK                      (0xF80000U)
#define CAN_CTRL2_TASD_SHIFT                     (19U)
/*! TASD - Transmission Arbitration Start Delay */
#define CAN_CTRL2_TASD(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_TASD_SHIFT)) & CAN_CTRL2_TASD_MASK)

#define CAN_CTRL2_RFFN_MASK                      (0xF000000U)
#define CAN_CTRL2_RFFN_SHIFT                     (24U)
/*! RFFN - Number of Legacy Receive FIFO Filters */
#define CAN_CTRL2_RFFN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RFFN_SHIFT)) & CAN_CTRL2_RFFN_MASK)

#define CAN_CTRL2_BOFFDONEMSK_MASK               (0x40000000U)
#define CAN_CTRL2_BOFFDONEMSK_SHIFT              (30U)
/*! BOFFDONEMSK - Bus Off Done Interrupt Mask
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_BOFFDONEMSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_BOFFDONEMSK_SHIFT)) & CAN_CTRL2_BOFFDONEMSK_MASK)

#define CAN_CTRL2_ERRMSK_FAST_MASK               (0x80000000U)
#define CAN_CTRL2_ERRMSK_FAST_SHIFT              (31U)
/*! ERRMSK_FAST - Error Interrupt Mask for Errors Detected in the Data Phase of Fast CAN FD Frames
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL2_ERRMSK_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ERRMSK_FAST_SHIFT)) & CAN_CTRL2_ERRMSK_FAST_MASK)
/*! @} */

/*! @name ESR2 - Error and Status 2 */
/*! @{ */

#define CAN_ESR2_IMB_MASK                        (0x2000U)
#define CAN_ESR2_IMB_SHIFT                       (13U)
/*! IMB - Inactive Message Buffer
 *  0b0..Message buffer indicated by ESR2[LPTM] is not inactive.
 *  0b1..At least one message buffer is inactive.
 */
#define CAN_ESR2_IMB(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_IMB_SHIFT)) & CAN_ESR2_IMB_MASK)

#define CAN_ESR2_VPS_MASK                        (0x4000U)
#define CAN_ESR2_VPS_SHIFT                       (14U)
/*! VPS - Valid Priority Status
 *  0b0..Invalid
 *  0b1..Valid
 */
#define CAN_ESR2_VPS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_VPS_SHIFT)) & CAN_ESR2_VPS_MASK)

#define CAN_ESR2_LPTM_MASK                       (0x7F0000U)
#define CAN_ESR2_LPTM_SHIFT                      (16U)
/*! LPTM - Lowest Priority TX Message Buffer */
#define CAN_ESR2_LPTM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_LPTM_SHIFT)) & CAN_ESR2_LPTM_MASK)
/*! @} */

/*! @name CRCR - Cyclic Redundancy Check */
/*! @{ */

#define CAN_CRCR_TXCRC_MASK                      (0x7FFFU)
#define CAN_CRCR_TXCRC_SHIFT                     (0U)
/*! TXCRC - Transmitted CRC value */
#define CAN_CRCR_TXCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_TXCRC_SHIFT)) & CAN_CRCR_TXCRC_MASK)

#define CAN_CRCR_MBCRC_MASK                      (0x7F0000U)
#define CAN_CRCR_MBCRC_SHIFT                     (16U)
/*! MBCRC - CRC Message Buffer */
#define CAN_CRCR_MBCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_MBCRC_SHIFT)) & CAN_CRCR_MBCRC_MASK)
/*! @} */

/*! @name RXFGMASK - Legacy RX FIFO Global Mask */
/*! @{ */

#define CAN_RXFGMASK_FGM_MASK                    (0xFFFFFFFFU)
#define CAN_RXFGMASK_FGM_SHIFT                   (0U)
/*! FGM - Legacy RX FIFO Global Mask Bits */
#define CAN_RXFGMASK_FGM(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_RXFGMASK_FGM_SHIFT)) & CAN_RXFGMASK_FGM_MASK)
/*! @} */

/*! @name RXFIR - Legacy RX FIFO Information */
/*! @{ */

#define CAN_RXFIR_IDHIT_MASK                     (0x1FFU)
#define CAN_RXFIR_IDHIT_SHIFT                    (0U)
/*! IDHIT - Identifier Acceptance Filter Hit Indicator */
#define CAN_RXFIR_IDHIT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXFIR_IDHIT_SHIFT)) & CAN_RXFIR_IDHIT_MASK)
/*! @} */

/*! @name CBT - CAN Bit Timing */
/*! @{ */

#define CAN_CBT_EPSEG2_MASK                      (0x1FU)
#define CAN_CBT_EPSEG2_SHIFT                     (0U)
/*! EPSEG2 - Extended Phase Segment 2 */
#define CAN_CBT_EPSEG2(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG2_SHIFT)) & CAN_CBT_EPSEG2_MASK)

#define CAN_CBT_EPSEG1_MASK                      (0x3E0U)
#define CAN_CBT_EPSEG1_SHIFT                     (5U)
/*! EPSEG1 - Extended Phase Segment 1 */
#define CAN_CBT_EPSEG1(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG1_SHIFT)) & CAN_CBT_EPSEG1_MASK)

#define CAN_CBT_EPROPSEG_MASK                    (0xFC00U)
#define CAN_CBT_EPROPSEG_SHIFT                   (10U)
/*! EPROPSEG - Extended Propagation Segment */
#define CAN_CBT_EPROPSEG(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPROPSEG_SHIFT)) & CAN_CBT_EPROPSEG_MASK)

#define CAN_CBT_ERJW_MASK                        (0x1F0000U)
#define CAN_CBT_ERJW_SHIFT                       (16U)
/*! ERJW - Extended Resync Jump Width */
#define CAN_CBT_ERJW(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CBT_ERJW_SHIFT)) & CAN_CBT_ERJW_MASK)

#define CAN_CBT_EPRESDIV_MASK                    (0x7FE00000U)
#define CAN_CBT_EPRESDIV_SHIFT                   (21U)
/*! EPRESDIV - Extended Prescaler Division Factor */
#define CAN_CBT_EPRESDIV(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPRESDIV_SHIFT)) & CAN_CBT_EPRESDIV_MASK)

#define CAN_CBT_BTF_MASK                         (0x80000000U)
#define CAN_CBT_BTF_SHIFT                        (31U)
/*! BTF - Bit Timing Format Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CBT_BTF(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CBT_BTF_SHIFT)) & CAN_CBT_BTF_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB8B                        (32U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB8B                        (32U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB8B                      (32U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB8B2                     (2U)

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB16B                       (21U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB16B                       (21U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB16B                     (21U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB16B2                    (4U)

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB32B                       (12U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB32B                       (12U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB32B                     (12U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB32B2                    (8U)

/*! @name CS - Message Buffer 0 CS Register..Message Buffer 6 CS Register */
/*! @{ */

#define CAN_CS_TIME_STAMP_MASK                   (0xFFFFU)
#define CAN_CS_TIME_STAMP_SHIFT                  (0U)
/*! TIME_STAMP - Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running
 *    Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field
 *    appears on the CAN bus.
 */
#define CAN_CS_TIME_STAMP(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CS_TIME_STAMP_SHIFT)) & CAN_CS_TIME_STAMP_MASK)

#define CAN_CS_DLC_MASK                          (0xF0000U)
#define CAN_CS_DLC_SHIFT                         (16U)
/*! DLC - Length of the data to be stored/transmitted. */
#define CAN_CS_DLC(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_DLC_SHIFT)) & CAN_CS_DLC_MASK)

#define CAN_CS_RTR_MASK                          (0x100000U)
#define CAN_CS_RTR_SHIFT                         (20U)
/*! RTR - Remote Transmission Request. One/zero for remote/data frame. */
#define CAN_CS_RTR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_RTR_SHIFT)) & CAN_CS_RTR_MASK)

#define CAN_CS_IDE_MASK                          (0x200000U)
#define CAN_CS_IDE_SHIFT                         (21U)
/*! IDE - ID Extended. One/zero for extended/standard format frame. */
#define CAN_CS_IDE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_IDE_SHIFT)) & CAN_CS_IDE_MASK)

#define CAN_CS_SRR_MASK                          (0x400000U)
#define CAN_CS_SRR_SHIFT                         (22U)
/*! SRR - Substitute Remote Request. Contains a fixed recessive bit. */
#define CAN_CS_SRR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_SRR_SHIFT)) & CAN_CS_SRR_MASK)

#define CAN_CS_CODE_MASK                         (0xF000000U)
#define CAN_CS_CODE_SHIFT                        (24U)
/*! CODE - Message Buffer Code. This 4-bit field can be accessed (read or write) by the CPU and by
 *    the FlexCAN module itself, as part of the message buffer matching and arbitration process.
 */
#define CAN_CS_CODE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CS_CODE_SHIFT)) & CAN_CS_CODE_MASK)

#define CAN_CS_ESI_MASK                          (0x20000000U)
#define CAN_CS_ESI_SHIFT                         (29U)
/*! ESI - Error State Indicator. This bit indicates if the transmitting node is error active or error passive. */
#define CAN_CS_ESI(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_ESI_SHIFT)) & CAN_CS_ESI_MASK)

#define CAN_CS_BRS_MASK                          (0x40000000U)
#define CAN_CS_BRS_SHIFT                         (30U)
/*! BRS - Bit Rate Switch. This bit defines whether the bit rate is switched inside a CAN FD format frame. */
#define CAN_CS_BRS(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_BRS_SHIFT)) & CAN_CS_BRS_MASK)

#define CAN_CS_EDL_MASK                          (0x80000000U)
#define CAN_CS_EDL_SHIFT                         (31U)
/*! EDL - Extended Data Length. This bit distinguishes between CAN format and CAN FD format frames.
 *    The EDL bit must not be set for Message Buffers configured to RANSWER with code field 0b1010.
 */
#define CAN_CS_EDL(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_EDL_SHIFT)) & CAN_CS_EDL_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB64B                       (7U)

/*! @name ID - Message Buffer 0 ID Register..Message Buffer 6 ID Register */
/*! @{ */

#define CAN_ID_EXT_MASK                          (0x3FFFFU)
#define CAN_ID_EXT_SHIFT                         (0U)
/*! EXT - Contains extended (LOW word) identifier of message buffer. */
#define CAN_ID_EXT(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_EXT_SHIFT)) & CAN_ID_EXT_MASK)

#define CAN_ID_STD_MASK                          (0x1FFC0000U)
#define CAN_ID_STD_SHIFT                         (18U)
/*! STD - Contains standard/extended (HIGH word) identifier of message buffer. */
#define CAN_ID_STD(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_STD_SHIFT)) & CAN_ID_STD_MASK)

#define CAN_ID_PRIO_MASK                         (0xE0000000U)
#define CAN_ID_PRIO_SHIFT                        (29U)
/*! PRIO - Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only
 *    makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular
 *    ID to define the transmission priority.
 */
#define CAN_ID_PRIO(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ID_PRIO_SHIFT)) & CAN_ID_PRIO_MASK)
/*! @} */

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB64B                       (7U)

/*! @name WORD - Message Buffer 0 WORD_64B Register..Message Buffer 6 WORD_64B Register */
/*! @{ */

#define CAN_WORD_DATA_BYTE_3_MASK                (0xFFU)
#define CAN_WORD_DATA_BYTE_3_SHIFT               (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_3(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_3_SHIFT)) & CAN_WORD_DATA_BYTE_3_MASK)

#define CAN_WORD_DATA_BYTE_7_MASK                (0xFFU)
#define CAN_WORD_DATA_BYTE_7_SHIFT               (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_7(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_7_SHIFT)) & CAN_WORD_DATA_BYTE_7_MASK)

#define CAN_WORD_DATA_BYTE_11_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_11_SHIFT              (0U)
/*! DATA_BYTE_11 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_11(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_11_SHIFT)) & CAN_WORD_DATA_BYTE_11_MASK)

#define CAN_WORD_DATA_BYTE_15_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_15_SHIFT              (0U)
/*! DATA_BYTE_15 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_15(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_15_SHIFT)) & CAN_WORD_DATA_BYTE_15_MASK)

#define CAN_WORD_DATA_BYTE_19_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_19_SHIFT              (0U)
/*! DATA_BYTE_19 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_19(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_19_SHIFT)) & CAN_WORD_DATA_BYTE_19_MASK)

#define CAN_WORD_DATA_BYTE_23_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_23_SHIFT              (0U)
/*! DATA_BYTE_23 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_23(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_23_SHIFT)) & CAN_WORD_DATA_BYTE_23_MASK)

#define CAN_WORD_DATA_BYTE_27_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_27_SHIFT              (0U)
/*! DATA_BYTE_27 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_27(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_27_SHIFT)) & CAN_WORD_DATA_BYTE_27_MASK)

#define CAN_WORD_DATA_BYTE_31_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_31_SHIFT              (0U)
/*! DATA_BYTE_31 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_31(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_31_SHIFT)) & CAN_WORD_DATA_BYTE_31_MASK)

#define CAN_WORD_DATA_BYTE_35_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_35_SHIFT              (0U)
/*! DATA_BYTE_35 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_35(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_35_SHIFT)) & CAN_WORD_DATA_BYTE_35_MASK)

#define CAN_WORD_DATA_BYTE_39_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_39_SHIFT              (0U)
/*! DATA_BYTE_39 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_39(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_39_SHIFT)) & CAN_WORD_DATA_BYTE_39_MASK)

#define CAN_WORD_DATA_BYTE_43_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_43_SHIFT              (0U)
/*! DATA_BYTE_43 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_43(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_43_SHIFT)) & CAN_WORD_DATA_BYTE_43_MASK)

#define CAN_WORD_DATA_BYTE_47_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_47_SHIFT              (0U)
/*! DATA_BYTE_47 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_47(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_47_SHIFT)) & CAN_WORD_DATA_BYTE_47_MASK)

#define CAN_WORD_DATA_BYTE_51_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_51_SHIFT              (0U)
/*! DATA_BYTE_51 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_51(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_51_SHIFT)) & CAN_WORD_DATA_BYTE_51_MASK)

#define CAN_WORD_DATA_BYTE_55_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_55_SHIFT              (0U)
/*! DATA_BYTE_55 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_55(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_55_SHIFT)) & CAN_WORD_DATA_BYTE_55_MASK)

#define CAN_WORD_DATA_BYTE_59_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_59_SHIFT              (0U)
/*! DATA_BYTE_59 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_59(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_59_SHIFT)) & CAN_WORD_DATA_BYTE_59_MASK)

#define CAN_WORD_DATA_BYTE_63_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_63_SHIFT              (0U)
/*! DATA_BYTE_63 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_63(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_63_SHIFT)) & CAN_WORD_DATA_BYTE_63_MASK)

#define CAN_WORD_DATA_BYTE_2_MASK                (0xFF00U)
#define CAN_WORD_DATA_BYTE_2_SHIFT               (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_2(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_2_SHIFT)) & CAN_WORD_DATA_BYTE_2_MASK)

#define CAN_WORD_DATA_BYTE_6_MASK                (0xFF00U)
#define CAN_WORD_DATA_BYTE_6_SHIFT               (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_6(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_6_SHIFT)) & CAN_WORD_DATA_BYTE_6_MASK)

#define CAN_WORD_DATA_BYTE_10_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_10_SHIFT              (8U)
/*! DATA_BYTE_10 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_10(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_10_SHIFT)) & CAN_WORD_DATA_BYTE_10_MASK)

#define CAN_WORD_DATA_BYTE_14_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_14_SHIFT              (8U)
/*! DATA_BYTE_14 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_14(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_14_SHIFT)) & CAN_WORD_DATA_BYTE_14_MASK)

#define CAN_WORD_DATA_BYTE_18_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_18_SHIFT              (8U)
/*! DATA_BYTE_18 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_18(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_18_SHIFT)) & CAN_WORD_DATA_BYTE_18_MASK)

#define CAN_WORD_DATA_BYTE_22_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_22_SHIFT              (8U)
/*! DATA_BYTE_22 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_22(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_22_SHIFT)) & CAN_WORD_DATA_BYTE_22_MASK)

#define CAN_WORD_DATA_BYTE_26_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_26_SHIFT              (8U)
/*! DATA_BYTE_26 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_26(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_26_SHIFT)) & CAN_WORD_DATA_BYTE_26_MASK)

#define CAN_WORD_DATA_BYTE_30_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_30_SHIFT              (8U)
/*! DATA_BYTE_30 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_30(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_30_SHIFT)) & CAN_WORD_DATA_BYTE_30_MASK)

#define CAN_WORD_DATA_BYTE_34_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_34_SHIFT              (8U)
/*! DATA_BYTE_34 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_34(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_34_SHIFT)) & CAN_WORD_DATA_BYTE_34_MASK)

#define CAN_WORD_DATA_BYTE_38_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_38_SHIFT              (8U)
/*! DATA_BYTE_38 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_38(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_38_SHIFT)) & CAN_WORD_DATA_BYTE_38_MASK)

#define CAN_WORD_DATA_BYTE_42_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_42_SHIFT              (8U)
/*! DATA_BYTE_42 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_42(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_42_SHIFT)) & CAN_WORD_DATA_BYTE_42_MASK)

#define CAN_WORD_DATA_BYTE_46_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_46_SHIFT              (8U)
/*! DATA_BYTE_46 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_46(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_46_SHIFT)) & CAN_WORD_DATA_BYTE_46_MASK)

#define CAN_WORD_DATA_BYTE_50_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_50_SHIFT              (8U)
/*! DATA_BYTE_50 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_50(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_50_SHIFT)) & CAN_WORD_DATA_BYTE_50_MASK)

#define CAN_WORD_DATA_BYTE_54_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_54_SHIFT              (8U)
/*! DATA_BYTE_54 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_54(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_54_SHIFT)) & CAN_WORD_DATA_BYTE_54_MASK)

#define CAN_WORD_DATA_BYTE_58_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_58_SHIFT              (8U)
/*! DATA_BYTE_58 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_58(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_58_SHIFT)) & CAN_WORD_DATA_BYTE_58_MASK)

#define CAN_WORD_DATA_BYTE_62_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_62_SHIFT              (8U)
/*! DATA_BYTE_62 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_62(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_62_SHIFT)) & CAN_WORD_DATA_BYTE_62_MASK)

#define CAN_WORD_DATA_BYTE_1_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_1_SHIFT               (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_1(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_1_SHIFT)) & CAN_WORD_DATA_BYTE_1_MASK)

#define CAN_WORD_DATA_BYTE_5_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_5_SHIFT               (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_5(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_5_SHIFT)) & CAN_WORD_DATA_BYTE_5_MASK)

#define CAN_WORD_DATA_BYTE_9_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_9_SHIFT               (16U)
/*! DATA_BYTE_9 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_9(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_9_SHIFT)) & CAN_WORD_DATA_BYTE_9_MASK)

#define CAN_WORD_DATA_BYTE_13_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_13_SHIFT              (16U)
/*! DATA_BYTE_13 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_13(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_13_SHIFT)) & CAN_WORD_DATA_BYTE_13_MASK)

#define CAN_WORD_DATA_BYTE_17_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_17_SHIFT              (16U)
/*! DATA_BYTE_17 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_17(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_17_SHIFT)) & CAN_WORD_DATA_BYTE_17_MASK)

#define CAN_WORD_DATA_BYTE_21_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_21_SHIFT              (16U)
/*! DATA_BYTE_21 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_21(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_21_SHIFT)) & CAN_WORD_DATA_BYTE_21_MASK)

#define CAN_WORD_DATA_BYTE_25_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_25_SHIFT              (16U)
/*! DATA_BYTE_25 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_25(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_25_SHIFT)) & CAN_WORD_DATA_BYTE_25_MASK)

#define CAN_WORD_DATA_BYTE_29_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_29_SHIFT              (16U)
/*! DATA_BYTE_29 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_29(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_29_SHIFT)) & CAN_WORD_DATA_BYTE_29_MASK)

#define CAN_WORD_DATA_BYTE_33_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_33_SHIFT              (16U)
/*! DATA_BYTE_33 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_33(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_33_SHIFT)) & CAN_WORD_DATA_BYTE_33_MASK)

#define CAN_WORD_DATA_BYTE_37_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_37_SHIFT              (16U)
/*! DATA_BYTE_37 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_37(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_37_SHIFT)) & CAN_WORD_DATA_BYTE_37_MASK)

#define CAN_WORD_DATA_BYTE_41_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_41_SHIFT              (16U)
/*! DATA_BYTE_41 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_41(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_41_SHIFT)) & CAN_WORD_DATA_BYTE_41_MASK)

#define CAN_WORD_DATA_BYTE_45_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_45_SHIFT              (16U)
/*! DATA_BYTE_45 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_45(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_45_SHIFT)) & CAN_WORD_DATA_BYTE_45_MASK)

#define CAN_WORD_DATA_BYTE_49_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_49_SHIFT              (16U)
/*! DATA_BYTE_49 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_49(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_49_SHIFT)) & CAN_WORD_DATA_BYTE_49_MASK)

#define CAN_WORD_DATA_BYTE_53_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_53_SHIFT              (16U)
/*! DATA_BYTE_53 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_53(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_53_SHIFT)) & CAN_WORD_DATA_BYTE_53_MASK)

#define CAN_WORD_DATA_BYTE_57_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_57_SHIFT              (16U)
/*! DATA_BYTE_57 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_57(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_57_SHIFT)) & CAN_WORD_DATA_BYTE_57_MASK)

#define CAN_WORD_DATA_BYTE_61_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_61_SHIFT              (16U)
/*! DATA_BYTE_61 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_61(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_61_SHIFT)) & CAN_WORD_DATA_BYTE_61_MASK)

#define CAN_WORD_DATA_BYTE_0_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_0_SHIFT               (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_0(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_0_SHIFT)) & CAN_WORD_DATA_BYTE_0_MASK)

#define CAN_WORD_DATA_BYTE_4_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_4_SHIFT               (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_4(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_4_SHIFT)) & CAN_WORD_DATA_BYTE_4_MASK)

#define CAN_WORD_DATA_BYTE_8_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_8_SHIFT               (24U)
/*! DATA_BYTE_8 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_8(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_8_SHIFT)) & CAN_WORD_DATA_BYTE_8_MASK)

#define CAN_WORD_DATA_BYTE_12_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_12_SHIFT              (24U)
/*! DATA_BYTE_12 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_12(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_12_SHIFT)) & CAN_WORD_DATA_BYTE_12_MASK)

#define CAN_WORD_DATA_BYTE_16_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_16_SHIFT              (24U)
/*! DATA_BYTE_16 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_16(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_16_SHIFT)) & CAN_WORD_DATA_BYTE_16_MASK)

#define CAN_WORD_DATA_BYTE_20_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_20_SHIFT              (24U)
/*! DATA_BYTE_20 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_20(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_20_SHIFT)) & CAN_WORD_DATA_BYTE_20_MASK)

#define CAN_WORD_DATA_BYTE_24_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_24_SHIFT              (24U)
/*! DATA_BYTE_24 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_24(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_24_SHIFT)) & CAN_WORD_DATA_BYTE_24_MASK)

#define CAN_WORD_DATA_BYTE_28_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_28_SHIFT              (24U)
/*! DATA_BYTE_28 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_28(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_28_SHIFT)) & CAN_WORD_DATA_BYTE_28_MASK)

#define CAN_WORD_DATA_BYTE_32_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_32_SHIFT              (24U)
/*! DATA_BYTE_32 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_32(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_32_SHIFT)) & CAN_WORD_DATA_BYTE_32_MASK)

#define CAN_WORD_DATA_BYTE_36_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_36_SHIFT              (24U)
/*! DATA_BYTE_36 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_36(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_36_SHIFT)) & CAN_WORD_DATA_BYTE_36_MASK)

#define CAN_WORD_DATA_BYTE_40_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_40_SHIFT              (24U)
/*! DATA_BYTE_40 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_40(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_40_SHIFT)) & CAN_WORD_DATA_BYTE_40_MASK)

#define CAN_WORD_DATA_BYTE_44_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_44_SHIFT              (24U)
/*! DATA_BYTE_44 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_44(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_44_SHIFT)) & CAN_WORD_DATA_BYTE_44_MASK)

#define CAN_WORD_DATA_BYTE_48_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_48_SHIFT              (24U)
/*! DATA_BYTE_48 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_48(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_48_SHIFT)) & CAN_WORD_DATA_BYTE_48_MASK)

#define CAN_WORD_DATA_BYTE_52_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_52_SHIFT              (24U)
/*! DATA_BYTE_52 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_52(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_52_SHIFT)) & CAN_WORD_DATA_BYTE_52_MASK)

#define CAN_WORD_DATA_BYTE_56_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_56_SHIFT              (24U)
/*! DATA_BYTE_56 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_56(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_56_SHIFT)) & CAN_WORD_DATA_BYTE_56_MASK)

#define CAN_WORD_DATA_BYTE_60_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_60_SHIFT              (24U)
/*! DATA_BYTE_60 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD_DATA_BYTE_60(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_60_SHIFT)) & CAN_WORD_DATA_BYTE_60_MASK)
/*! @} */

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB64B                     (7U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB64B2                    (16U)

/* The count of CAN_CS */
#define CAN_CS_COUNT                             (32U)

/* The count of CAN_ID */
#define CAN_ID_COUNT                             (32U)

/*! @name WORD0 - Message Buffer 0 WORD0 Register..Message Buffer 31 WORD0 Register */
/*! @{ */

#define CAN_WORD0_DATA_BYTE_3_MASK               (0xFFU)
#define CAN_WORD0_DATA_BYTE_3_SHIFT              (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_3(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_3_SHIFT)) & CAN_WORD0_DATA_BYTE_3_MASK)

#define CAN_WORD0_DATA_BYTE_2_MASK               (0xFF00U)
#define CAN_WORD0_DATA_BYTE_2_SHIFT              (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_2(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_2_SHIFT)) & CAN_WORD0_DATA_BYTE_2_MASK)

#define CAN_WORD0_DATA_BYTE_1_MASK               (0xFF0000U)
#define CAN_WORD0_DATA_BYTE_1_SHIFT              (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_1(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_1_SHIFT)) & CAN_WORD0_DATA_BYTE_1_MASK)

#define CAN_WORD0_DATA_BYTE_0_MASK               (0xFF000000U)
#define CAN_WORD0_DATA_BYTE_0_SHIFT              (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD0_DATA_BYTE_0(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_0_SHIFT)) & CAN_WORD0_DATA_BYTE_0_MASK)
/*! @} */

/* The count of CAN_WORD0 */
#define CAN_WORD0_COUNT                          (32U)

/*! @name WORD1 - Message Buffer 0 WORD1 Register..Message Buffer 31 WORD1 Register */
/*! @{ */

#define CAN_WORD1_DATA_BYTE_7_MASK               (0xFFU)
#define CAN_WORD1_DATA_BYTE_7_SHIFT              (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_7(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_7_SHIFT)) & CAN_WORD1_DATA_BYTE_7_MASK)

#define CAN_WORD1_DATA_BYTE_6_MASK               (0xFF00U)
#define CAN_WORD1_DATA_BYTE_6_SHIFT              (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_6(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_6_SHIFT)) & CAN_WORD1_DATA_BYTE_6_MASK)

#define CAN_WORD1_DATA_BYTE_5_MASK               (0xFF0000U)
#define CAN_WORD1_DATA_BYTE_5_SHIFT              (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_5(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_5_SHIFT)) & CAN_WORD1_DATA_BYTE_5_MASK)

#define CAN_WORD1_DATA_BYTE_4_MASK               (0xFF000000U)
#define CAN_WORD1_DATA_BYTE_4_SHIFT              (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame. */
#define CAN_WORD1_DATA_BYTE_4(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_4_SHIFT)) & CAN_WORD1_DATA_BYTE_4_MASK)
/*! @} */

/* The count of CAN_WORD1 */
#define CAN_WORD1_COUNT                          (32U)

/*! @name RXIMR - Receive Individual Mask */
/*! @{ */

#define CAN_RXIMR_MI_MASK                        (0xFFFFFFFFU)
#define CAN_RXIMR_MI_SHIFT                       (0U)
/*! MI - Individual Mask Bits */
#define CAN_RXIMR_MI(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_RXIMR_MI_SHIFT)) & CAN_RXIMR_MI_MASK)
/*! @} */

/* The count of CAN_RXIMR */
#define CAN_RXIMR_COUNT                          (32U)

/*! @name CTRL1_PN - Pretended Networking Control 1 */
/*! @{ */

#define CAN_CTRL1_PN_FCS_MASK                    (0x3U)
#define CAN_CTRL1_PN_FCS_SHIFT                   (0U)
/*! FCS - Filtering Combination Selection
 *  0b00..Message ID filtering only
 *  0b01..Message ID filtering and payload filtering
 *  0b10..Message ID filtering occurring a specified number of times
 *  0b11..Message ID filtering and payload filtering a specified number of times
 */
#define CAN_CTRL1_PN_FCS(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_FCS_SHIFT)) & CAN_CTRL1_PN_FCS_MASK)

#define CAN_CTRL1_PN_IDFS_MASK                   (0xCU)
#define CAN_CTRL1_PN_IDFS_SHIFT                  (2U)
/*! IDFS - ID Filtering Selection
 *  0b00..Match ID contents to an exact target value
 *  0b01..Match an ID value greater than or equal to a specified target value
 *  0b10..Match an ID value smaller than or equal to a specified target value
 *  0b11..Match an ID value within a range of values, inclusive
 */
#define CAN_CTRL1_PN_IDFS(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_IDFS_SHIFT)) & CAN_CTRL1_PN_IDFS_MASK)

#define CAN_CTRL1_PN_PLFS_MASK                   (0x30U)
#define CAN_CTRL1_PN_PLFS_SHIFT                  (4U)
/*! PLFS - Payload Filtering Selection
 *  0b00..Match payload contents to an exact target value
 *  0b01..Match a payload value greater than or equal to a specified target value
 *  0b10..Match a payload value smaller than or equal to a specified target value
 *  0b11..Match upon a payload value within a range of values, inclusive
 */
#define CAN_CTRL1_PN_PLFS(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_PLFS_SHIFT)) & CAN_CTRL1_PN_PLFS_MASK)

#define CAN_CTRL1_PN_NMATCH_MASK                 (0xFF00U)
#define CAN_CTRL1_PN_NMATCH_SHIFT                (8U)
/*! NMATCH - Number of Messages Matching the Same Filtering Criteria
 *  0b00000001..Once
 *  0b00000010..Twice
 *  0b11111111..255 times
 */
#define CAN_CTRL1_PN_NMATCH(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_NMATCH_SHIFT)) & CAN_CTRL1_PN_NMATCH_MASK)

#define CAN_CTRL1_PN_WUMF_MSK_MASK               (0x10000U)
#define CAN_CTRL1_PN_WUMF_MSK_SHIFT              (16U)
/*! WUMF_MSK - Wake-up by Matching Flag Mask
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL1_PN_WUMF_MSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_WUMF_MSK_SHIFT)) & CAN_CTRL1_PN_WUMF_MSK_MASK)

#define CAN_CTRL1_PN_WTOF_MSK_MASK               (0x20000U)
#define CAN_CTRL1_PN_WTOF_MSK_SHIFT              (17U)
/*! WTOF_MSK - Wake-up by Timeout Flag Mask
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_CTRL1_PN_WTOF_MSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_WTOF_MSK_SHIFT)) & CAN_CTRL1_PN_WTOF_MSK_MASK)
/*! @} */

/*! @name CTRL2_PN - Pretended Networking Control 2 */
/*! @{ */

#define CAN_CTRL2_PN_MATCHTO_MASK                (0xFFFFU)
#define CAN_CTRL2_PN_MATCHTO_SHIFT               (0U)
/*! MATCHTO - Timeout for No Message Matching the Filtering Criteria */
#define CAN_CTRL2_PN_MATCHTO(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PN_MATCHTO_SHIFT)) & CAN_CTRL2_PN_MATCHTO_MASK)
/*! @} */

/*! @name WU_MTC - Pretended Networking Wake-Up Match */
/*! @{ */

#define CAN_WU_MTC_MCOUNTER_MASK                 (0xFF00U)
#define CAN_WU_MTC_MCOUNTER_SHIFT                (8U)
/*! MCOUNTER - Number of Matches in Pretended Networking */
#define CAN_WU_MTC_MCOUNTER(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_MCOUNTER_SHIFT)) & CAN_WU_MTC_MCOUNTER_MASK)

#define CAN_WU_MTC_WUMF_MASK                     (0x10000U)
#define CAN_WU_MTC_WUMF_SHIFT                    (16U)
/*! WUMF - Wake-up by Match Flag
 *  0b0..No event detected
 *  0b1..Event detected
 */
#define CAN_WU_MTC_WUMF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_WUMF_SHIFT)) & CAN_WU_MTC_WUMF_MASK)

#define CAN_WU_MTC_WTOF_MASK                     (0x20000U)
#define CAN_WU_MTC_WTOF_SHIFT                    (17U)
/*! WTOF - Wake-up by Timeout Flag Bit
 *  0b0..No event detected
 *  0b1..Event detected
 */
#define CAN_WU_MTC_WTOF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_WTOF_SHIFT)) & CAN_WU_MTC_WTOF_MASK)
/*! @} */

/*! @name FLT_ID1 - Pretended Networking ID Filter 1 */
/*! @{ */

#define CAN_FLT_ID1_FLT_ID1_MASK                 (0x1FFFFFFFU)
#define CAN_FLT_ID1_FLT_ID1_SHIFT                (0U)
/*! FLT_ID1 - ID Filter 1 for Pretended Networking filtering */
#define CAN_FLT_ID1_FLT_ID1(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_ID1_SHIFT)) & CAN_FLT_ID1_FLT_ID1_MASK)

#define CAN_FLT_ID1_FLT_RTR_MASK                 (0x20000000U)
#define CAN_FLT_ID1_FLT_RTR_SHIFT                (29U)
/*! FLT_RTR - Remote Transmission Request Filter
 *  0b0..Reject remote frame (accept data frame)
 *  0b1..Accept remote frame
 */
#define CAN_FLT_ID1_FLT_RTR(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_RTR_SHIFT)) & CAN_FLT_ID1_FLT_RTR_MASK)

#define CAN_FLT_ID1_FLT_IDE_MASK                 (0x40000000U)
#define CAN_FLT_ID1_FLT_IDE_SHIFT                (30U)
/*! FLT_IDE - ID Extended Filter
 *  0b0..Standard
 *  0b1..Extended
 */
#define CAN_FLT_ID1_FLT_IDE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_IDE_SHIFT)) & CAN_FLT_ID1_FLT_IDE_MASK)
/*! @} */

/*! @name FLT_DLC - Pretended Networking Data Length Code (DLC) Filter */
/*! @{ */

#define CAN_FLT_DLC_FLT_DLC_HI_MASK              (0xFU)
#define CAN_FLT_DLC_FLT_DLC_HI_SHIFT             (0U)
/*! FLT_DLC_HI - Upper Limit for Length of Data Bytes Filter */
#define CAN_FLT_DLC_FLT_DLC_HI(x)                (((uint32_t)(((uint32_t)(x)) << CAN_FLT_DLC_FLT_DLC_HI_SHIFT)) & CAN_FLT_DLC_FLT_DLC_HI_MASK)

#define CAN_FLT_DLC_FLT_DLC_LO_MASK              (0xF0000U)
#define CAN_FLT_DLC_FLT_DLC_LO_SHIFT             (16U)
/*! FLT_DLC_LO - Lower Limit for Length of Data Bytes Filter */
#define CAN_FLT_DLC_FLT_DLC_LO(x)                (((uint32_t)(((uint32_t)(x)) << CAN_FLT_DLC_FLT_DLC_LO_SHIFT)) & CAN_FLT_DLC_FLT_DLC_LO_MASK)
/*! @} */

/*! @name PL1_LO - Pretended Networking Payload Low Filter 1 */
/*! @{ */

#define CAN_PL1_LO_Data_byte_3_MASK              (0xFFU)
#define CAN_PL1_LO_Data_byte_3_SHIFT             (0U)
/*! Data_byte_3 - Data byte 3 */
#define CAN_PL1_LO_Data_byte_3(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_3_SHIFT)) & CAN_PL1_LO_Data_byte_3_MASK)

#define CAN_PL1_LO_Data_byte_2_MASK              (0xFF00U)
#define CAN_PL1_LO_Data_byte_2_SHIFT             (8U)
/*! Data_byte_2 - Data byte 2 */
#define CAN_PL1_LO_Data_byte_2(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_2_SHIFT)) & CAN_PL1_LO_Data_byte_2_MASK)

#define CAN_PL1_LO_Data_byte_1_MASK              (0xFF0000U)
#define CAN_PL1_LO_Data_byte_1_SHIFT             (16U)
/*! Data_byte_1 - Data byte 1 */
#define CAN_PL1_LO_Data_byte_1(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_1_SHIFT)) & CAN_PL1_LO_Data_byte_1_MASK)

#define CAN_PL1_LO_Data_byte_0_MASK              (0xFF000000U)
#define CAN_PL1_LO_Data_byte_0_SHIFT             (24U)
/*! Data_byte_0 - Data byte 0 */
#define CAN_PL1_LO_Data_byte_0(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_0_SHIFT)) & CAN_PL1_LO_Data_byte_0_MASK)
/*! @} */

/*! @name PL1_HI - Pretended Networking Payload High Filter 1 */
/*! @{ */

#define CAN_PL1_HI_Data_byte_7_MASK              (0xFFU)
#define CAN_PL1_HI_Data_byte_7_SHIFT             (0U)
/*! Data_byte_7 - Data byte 7 */
#define CAN_PL1_HI_Data_byte_7(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_7_SHIFT)) & CAN_PL1_HI_Data_byte_7_MASK)

#define CAN_PL1_HI_Data_byte_6_MASK              (0xFF00U)
#define CAN_PL1_HI_Data_byte_6_SHIFT             (8U)
/*! Data_byte_6 - Data byte 6 */
#define CAN_PL1_HI_Data_byte_6(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_6_SHIFT)) & CAN_PL1_HI_Data_byte_6_MASK)

#define CAN_PL1_HI_Data_byte_5_MASK              (0xFF0000U)
#define CAN_PL1_HI_Data_byte_5_SHIFT             (16U)
/*! Data_byte_5 - Data byte 5 */
#define CAN_PL1_HI_Data_byte_5(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_5_SHIFT)) & CAN_PL1_HI_Data_byte_5_MASK)

#define CAN_PL1_HI_Data_byte_4_MASK              (0xFF000000U)
#define CAN_PL1_HI_Data_byte_4_SHIFT             (24U)
/*! Data_byte_4 - Data byte 4 */
#define CAN_PL1_HI_Data_byte_4(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_4_SHIFT)) & CAN_PL1_HI_Data_byte_4_MASK)
/*! @} */

/*! @name FLT_ID2_IDMASK - Pretended Networking ID Filter 2 or ID Mask */
/*! @{ */

#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_MASK   (0x1FFFFFFFU)
#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_SHIFT  (0U)
/*! FLT_ID2_IDMASK - ID Filter 2 for Pretended Networking Filtering or ID Mask Bits for Pretended Networking ID Filtering */
#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK(x)     (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_SHIFT)) & CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_MASK)

#define CAN_FLT_ID2_IDMASK_RTR_MSK_MASK          (0x20000000U)
#define CAN_FLT_ID2_IDMASK_RTR_MSK_SHIFT         (29U)
/*! RTR_MSK - Remote Transmission Request Mask
 *  0b0..The corresponding bit in the filter is "don't care."
 *  0b1..The corresponding bit in the filter is checked.
 */
#define CAN_FLT_ID2_IDMASK_RTR_MSK(x)            (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_RTR_MSK_SHIFT)) & CAN_FLT_ID2_IDMASK_RTR_MSK_MASK)

#define CAN_FLT_ID2_IDMASK_IDE_MSK_MASK          (0x40000000U)
#define CAN_FLT_ID2_IDMASK_IDE_MSK_SHIFT         (30U)
/*! IDE_MSK - ID Extended Mask
 *  0b0..The corresponding bit in the filter is "don't care."
 *  0b1..The corresponding bit in the filter is checked.
 */
#define CAN_FLT_ID2_IDMASK_IDE_MSK(x)            (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_IDE_MSK_SHIFT)) & CAN_FLT_ID2_IDMASK_IDE_MSK_MASK)
/*! @} */

/*! @name PL2_PLMASK_LO - Pretended Networking Payload Low Filter 2 and Payload Low Mask */
/*! @{ */

#define CAN_PL2_PLMASK_LO_Data_byte_3_MASK       (0xFFU)
#define CAN_PL2_PLMASK_LO_Data_byte_3_SHIFT      (0U)
/*! Data_byte_3 - Data Byte 3 */
#define CAN_PL2_PLMASK_LO_Data_byte_3(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_3_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_3_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_2_MASK       (0xFF00U)
#define CAN_PL2_PLMASK_LO_Data_byte_2_SHIFT      (8U)
/*! Data_byte_2 - Data Byte 2 */
#define CAN_PL2_PLMASK_LO_Data_byte_2(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_2_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_2_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_1_MASK       (0xFF0000U)
#define CAN_PL2_PLMASK_LO_Data_byte_1_SHIFT      (16U)
/*! Data_byte_1 - Data Byte 1 */
#define CAN_PL2_PLMASK_LO_Data_byte_1(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_1_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_1_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_0_MASK       (0xFF000000U)
#define CAN_PL2_PLMASK_LO_Data_byte_0_SHIFT      (24U)
/*! Data_byte_0 - Data Byte 0 */
#define CAN_PL2_PLMASK_LO_Data_byte_0(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_0_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_0_MASK)
/*! @} */

/*! @name PL2_PLMASK_HI - Pretended Networking Payload High Filter 2 and Payload High Mask */
/*! @{ */

#define CAN_PL2_PLMASK_HI_Data_byte_7_MASK       (0xFFU)
#define CAN_PL2_PLMASK_HI_Data_byte_7_SHIFT      (0U)
/*! Data_byte_7 - Data Byte 7 */
#define CAN_PL2_PLMASK_HI_Data_byte_7(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_7_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_7_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_6_MASK       (0xFF00U)
#define CAN_PL2_PLMASK_HI_Data_byte_6_SHIFT      (8U)
/*! Data_byte_6 - Data Byte 6 */
#define CAN_PL2_PLMASK_HI_Data_byte_6(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_6_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_6_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_5_MASK       (0xFF0000U)
#define CAN_PL2_PLMASK_HI_Data_byte_5_SHIFT      (16U)
/*! Data_byte_5 - Data Byte 5 */
#define CAN_PL2_PLMASK_HI_Data_byte_5(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_5_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_5_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_4_MASK       (0xFF000000U)
#define CAN_PL2_PLMASK_HI_Data_byte_4_SHIFT      (24U)
/*! Data_byte_4 - Data Byte 4 */
#define CAN_PL2_PLMASK_HI_Data_byte_4(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_4_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_4_MASK)
/*! @} */

/*! @name WMB_CS - Wake-Up Message Buffer */
/*! @{ */

#define CAN_WMB_CS_DLC_MASK                      (0xF0000U)
#define CAN_WMB_CS_DLC_SHIFT                     (16U)
/*! DLC - Length of Data in Bytes */
#define CAN_WMB_CS_DLC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_DLC_SHIFT)) & CAN_WMB_CS_DLC_MASK)

#define CAN_WMB_CS_RTR_MASK                      (0x100000U)
#define CAN_WMB_CS_RTR_SHIFT                     (20U)
/*! RTR - Remote Transmission Request
 *  0b0..Data
 *  0b1..Remote
 */
#define CAN_WMB_CS_RTR(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_RTR_SHIFT)) & CAN_WMB_CS_RTR_MASK)

#define CAN_WMB_CS_IDE_MASK                      (0x200000U)
#define CAN_WMB_CS_IDE_SHIFT                     (21U)
/*! IDE - ID Extended Bit
 *  0b0..Standard
 *  0b1..Extended
 */
#define CAN_WMB_CS_IDE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_IDE_SHIFT)) & CAN_WMB_CS_IDE_MASK)

#define CAN_WMB_CS_SRR_MASK                      (0x400000U)
#define CAN_WMB_CS_SRR_SHIFT                     (22U)
/*! SRR - Substitute Remote Request
 *  0b0..Dominant
 *  0b1..Recessive
 */
#define CAN_WMB_CS_SRR(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_SRR_SHIFT)) & CAN_WMB_CS_SRR_MASK)
/*! @} */

/* The count of CAN_WMB_CS */
#define CAN_WMB_CS_COUNT                         (4U)

/*! @name WMB_ID - Wake-Up Message Buffer for ID */
/*! @{ */

#define CAN_WMB_ID_ID_MASK                       (0x1FFFFFFFU)
#define CAN_WMB_ID_ID_SHIFT                      (0U)
/*! ID - Received ID in Pretended Networking Mode */
#define CAN_WMB_ID_ID(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_WMB_ID_ID_SHIFT)) & CAN_WMB_ID_ID_MASK)
/*! @} */

/* The count of CAN_WMB_ID */
#define CAN_WMB_ID_COUNT                         (4U)

/*! @name WMB_D03 - Wake-Up Message Buffer for Data 0-3 */
/*! @{ */

#define CAN_WMB_D03_Data_byte_3_MASK             (0xFFU)
#define CAN_WMB_D03_Data_byte_3_SHIFT            (0U)
/*! Data_byte_3 - Data Byte 3 */
#define CAN_WMB_D03_Data_byte_3(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_3_SHIFT)) & CAN_WMB_D03_Data_byte_3_MASK)

#define CAN_WMB_D03_Data_byte_2_MASK             (0xFF00U)
#define CAN_WMB_D03_Data_byte_2_SHIFT            (8U)
/*! Data_byte_2 - Data Byte 2 */
#define CAN_WMB_D03_Data_byte_2(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_2_SHIFT)) & CAN_WMB_D03_Data_byte_2_MASK)

#define CAN_WMB_D03_Data_byte_1_MASK             (0xFF0000U)
#define CAN_WMB_D03_Data_byte_1_SHIFT            (16U)
/*! Data_byte_1 - Data Byte 1 */
#define CAN_WMB_D03_Data_byte_1(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_1_SHIFT)) & CAN_WMB_D03_Data_byte_1_MASK)

#define CAN_WMB_D03_Data_byte_0_MASK             (0xFF000000U)
#define CAN_WMB_D03_Data_byte_0_SHIFT            (24U)
/*! Data_byte_0 - Data Byte 0 */
#define CAN_WMB_D03_Data_byte_0(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_0_SHIFT)) & CAN_WMB_D03_Data_byte_0_MASK)
/*! @} */

/* The count of CAN_WMB_D03 */
#define CAN_WMB_D03_COUNT                        (4U)

/*! @name WMB_D47 - Wake-Up Message Buffer Register Data 4-7 */
/*! @{ */

#define CAN_WMB_D47_Data_byte_7_MASK             (0xFFU)
#define CAN_WMB_D47_Data_byte_7_SHIFT            (0U)
/*! Data_byte_7 - Data Byte 7 */
#define CAN_WMB_D47_Data_byte_7(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_7_SHIFT)) & CAN_WMB_D47_Data_byte_7_MASK)

#define CAN_WMB_D47_Data_byte_6_MASK             (0xFF00U)
#define CAN_WMB_D47_Data_byte_6_SHIFT            (8U)
/*! Data_byte_6 - Data Byte 6 */
#define CAN_WMB_D47_Data_byte_6(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_6_SHIFT)) & CAN_WMB_D47_Data_byte_6_MASK)

#define CAN_WMB_D47_Data_byte_5_MASK             (0xFF0000U)
#define CAN_WMB_D47_Data_byte_5_SHIFT            (16U)
/*! Data_byte_5 - Data Byte 5 */
#define CAN_WMB_D47_Data_byte_5(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_5_SHIFT)) & CAN_WMB_D47_Data_byte_5_MASK)

#define CAN_WMB_D47_Data_byte_4_MASK             (0xFF000000U)
#define CAN_WMB_D47_Data_byte_4_SHIFT            (24U)
/*! Data_byte_4 - Data Byte 4 */
#define CAN_WMB_D47_Data_byte_4(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_4_SHIFT)) & CAN_WMB_D47_Data_byte_4_MASK)
/*! @} */

/* The count of CAN_WMB_D47 */
#define CAN_WMB_D47_COUNT                        (4U)

/*! @name EPRS - Enhanced CAN Bit Timing Prescalers */
/*! @{ */

#define CAN_EPRS_ENPRESDIV_MASK                  (0x3FFU)
#define CAN_EPRS_ENPRESDIV_SHIFT                 (0U)
/*! ENPRESDIV - Extended Nominal Prescaler Division Factor */
#define CAN_EPRS_ENPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_EPRS_ENPRESDIV_SHIFT)) & CAN_EPRS_ENPRESDIV_MASK)

#define CAN_EPRS_EDPRESDIV_MASK                  (0x3FF0000U)
#define CAN_EPRS_EDPRESDIV_SHIFT                 (16U)
/*! EDPRESDIV - Extended Data Phase Prescaler Division Factor */
#define CAN_EPRS_EDPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_EPRS_EDPRESDIV_SHIFT)) & CAN_EPRS_EDPRESDIV_MASK)
/*! @} */

/*! @name ENCBT - Enhanced Nominal CAN Bit Timing */
/*! @{ */

#define CAN_ENCBT_NTSEG1_MASK                    (0xFFU)
#define CAN_ENCBT_NTSEG1_SHIFT                   (0U)
/*! NTSEG1 - Nominal Time Segment 1 */
#define CAN_ENCBT_NTSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NTSEG1_SHIFT)) & CAN_ENCBT_NTSEG1_MASK)

#define CAN_ENCBT_NTSEG2_MASK                    (0x7F000U)
#define CAN_ENCBT_NTSEG2_SHIFT                   (12U)
/*! NTSEG2 - Nominal Time Segment 2 */
#define CAN_ENCBT_NTSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NTSEG2_SHIFT)) & CAN_ENCBT_NTSEG2_MASK)

#define CAN_ENCBT_NRJW_MASK                      (0x1FC00000U)
#define CAN_ENCBT_NRJW_SHIFT                     (22U)
/*! NRJW - Nominal Resynchronization Jump Width */
#define CAN_ENCBT_NRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NRJW_SHIFT)) & CAN_ENCBT_NRJW_MASK)
/*! @} */

/*! @name EDCBT - Enhanced Data Phase CAN Bit Timing */
/*! @{ */

#define CAN_EDCBT_DTSEG1_MASK                    (0x1FU)
#define CAN_EDCBT_DTSEG1_SHIFT                   (0U)
/*! DTSEG1 - Data Phase Segment 1 */
#define CAN_EDCBT_DTSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DTSEG1_SHIFT)) & CAN_EDCBT_DTSEG1_MASK)

#define CAN_EDCBT_DTSEG2_MASK                    (0xF000U)
#define CAN_EDCBT_DTSEG2_SHIFT                   (12U)
/*! DTSEG2 - Data Phase Time Segment 2 */
#define CAN_EDCBT_DTSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DTSEG2_SHIFT)) & CAN_EDCBT_DTSEG2_MASK)

#define CAN_EDCBT_DRJW_MASK                      (0x3C00000U)
#define CAN_EDCBT_DRJW_SHIFT                     (22U)
/*! DRJW - Data Phase Resynchronization Jump Width */
#define CAN_EDCBT_DRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DRJW_SHIFT)) & CAN_EDCBT_DRJW_MASK)
/*! @} */

/*! @name ETDC - Enhanced Transceiver Delay Compensation */
/*! @{ */

#define CAN_ETDC_ETDCVAL_MASK                    (0xFFU)
#define CAN_ETDC_ETDCVAL_SHIFT                   (0U)
/*! ETDCVAL - Enhanced Transceiver Delay Compensation Value */
#define CAN_ETDC_ETDCVAL(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCVAL_SHIFT)) & CAN_ETDC_ETDCVAL_MASK)

#define CAN_ETDC_ETDCFAIL_MASK                   (0x8000U)
#define CAN_ETDC_ETDCFAIL_SHIFT                  (15U)
/*! ETDCFAIL - Transceiver Delay Compensation Fail
 *  0b0..In range
 *  0b1..Out of range
 */
#define CAN_ETDC_ETDCFAIL(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCFAIL_SHIFT)) & CAN_ETDC_ETDCFAIL_MASK)

#define CAN_ETDC_ETDCOFF_MASK                    (0x7F0000U)
#define CAN_ETDC_ETDCOFF_SHIFT                   (16U)
/*! ETDCOFF - Enhanced Transceiver Delay Compensation Offset */
#define CAN_ETDC_ETDCOFF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCOFF_SHIFT)) & CAN_ETDC_ETDCOFF_MASK)

#define CAN_ETDC_TDMDIS_MASK                     (0x40000000U)
#define CAN_ETDC_TDMDIS_SHIFT                    (30U)
/*! TDMDIS - Transceiver Delay Measurement Disable
 *  0b0..Enable
 *  0b1..Disable
 */
#define CAN_ETDC_TDMDIS(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_TDMDIS_SHIFT)) & CAN_ETDC_TDMDIS_MASK)

#define CAN_ETDC_ETDCEN_MASK                     (0x80000000U)
#define CAN_ETDC_ETDCEN_SHIFT                    (31U)
/*! ETDCEN - Transceiver Delay Compensation Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ETDC_ETDCEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCEN_SHIFT)) & CAN_ETDC_ETDCEN_MASK)
/*! @} */

/*! @name FDCTRL - CAN FD Control */
/*! @{ */

#define CAN_FDCTRL_TDCVAL_MASK                   (0x3FU)
#define CAN_FDCTRL_TDCVAL_SHIFT                  (0U)
/*! TDCVAL - Transceiver Delay Compensation Value */
#define CAN_FDCTRL_TDCVAL(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCVAL_SHIFT)) & CAN_FDCTRL_TDCVAL_MASK)

#define CAN_FDCTRL_TDCOFF_MASK                   (0x1F00U)
#define CAN_FDCTRL_TDCOFF_SHIFT                  (8U)
/*! TDCOFF - Transceiver Delay Compensation Offset */
#define CAN_FDCTRL_TDCOFF(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCOFF_SHIFT)) & CAN_FDCTRL_TDCOFF_MASK)

#define CAN_FDCTRL_TDCFAIL_MASK                  (0x4000U)
#define CAN_FDCTRL_TDCFAIL_SHIFT                 (14U)
/*! TDCFAIL - Transceiver Delay Compensation Fail
 *  0b0..In range
 *  0b1..Out of range
 */
#define CAN_FDCTRL_TDCFAIL(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCFAIL_SHIFT)) & CAN_FDCTRL_TDCFAIL_MASK)

#define CAN_FDCTRL_TDCEN_MASK                    (0x8000U)
#define CAN_FDCTRL_TDCEN_SHIFT                   (15U)
/*! TDCEN - Transceiver Delay Compensation Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_FDCTRL_TDCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCEN_SHIFT)) & CAN_FDCTRL_TDCEN_MASK)

#define CAN_FDCTRL_MBDSR0_MASK                   (0x30000U)
#define CAN_FDCTRL_MBDSR0_SHIFT                  (16U)
/*! MBDSR0 - Message Buffer Data Size for Region 0
 *  0b00..8 bytes
 *  0b01..16 bytes
 *  0b10..32 bytes
 *  0b11..64 bytes
 */
#define CAN_FDCTRL_MBDSR0(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_MBDSR0_SHIFT)) & CAN_FDCTRL_MBDSR0_MASK)

#define CAN_FDCTRL_FDRATE_MASK                   (0x80000000U)
#define CAN_FDCTRL_FDRATE_SHIFT                  (31U)
/*! FDRATE - Bit Rate Switch Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_FDCTRL_FDRATE(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_FDRATE_SHIFT)) & CAN_FDCTRL_FDRATE_MASK)
/*! @} */

/*! @name FDCBT - CAN FD Bit Timing */
/*! @{ */

#define CAN_FDCBT_FPSEG2_MASK                    (0x7U)
#define CAN_FDCBT_FPSEG2_SHIFT                   (0U)
/*! FPSEG2 - Fast Phase Segment 2 */
#define CAN_FDCBT_FPSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG2_SHIFT)) & CAN_FDCBT_FPSEG2_MASK)

#define CAN_FDCBT_FPSEG1_MASK                    (0xE0U)
#define CAN_FDCBT_FPSEG1_SHIFT                   (5U)
/*! FPSEG1 - Fast Phase Segment 1 */
#define CAN_FDCBT_FPSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG1_SHIFT)) & CAN_FDCBT_FPSEG1_MASK)

#define CAN_FDCBT_FPROPSEG_MASK                  (0x7C00U)
#define CAN_FDCBT_FPROPSEG_SHIFT                 (10U)
/*! FPROPSEG - Fast Propagation Segment */
#define CAN_FDCBT_FPROPSEG(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPROPSEG_SHIFT)) & CAN_FDCBT_FPROPSEG_MASK)

#define CAN_FDCBT_FRJW_MASK                      (0x70000U)
#define CAN_FDCBT_FRJW_SHIFT                     (16U)
/*! FRJW - Fast Resync Jump Width */
#define CAN_FDCBT_FRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FRJW_SHIFT)) & CAN_FDCBT_FRJW_MASK)

#define CAN_FDCBT_FPRESDIV_MASK                  (0x3FF00000U)
#define CAN_FDCBT_FPRESDIV_SHIFT                 (20U)
/*! FPRESDIV - Fast Prescaler Division Factor */
#define CAN_FDCBT_FPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPRESDIV_SHIFT)) & CAN_FDCBT_FPRESDIV_MASK)
/*! @} */

/*! @name FDCRC - CAN FD CRC */
/*! @{ */

#define CAN_FDCRC_FD_TXCRC_MASK                  (0x1FFFFFU)
#define CAN_FDCRC_FD_TXCRC_SHIFT                 (0U)
/*! FD_TXCRC - Extended Transmitted CRC value */
#define CAN_FDCRC_FD_TXCRC(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_TXCRC_SHIFT)) & CAN_FDCRC_FD_TXCRC_MASK)

#define CAN_FDCRC_FD_MBCRC_MASK                  (0x7F000000U)
#define CAN_FDCRC_FD_MBCRC_SHIFT                 (24U)
/*! FD_MBCRC - CRC Message Buffer Number for FD_TXCRC */
#define CAN_FDCRC_FD_MBCRC(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_MBCRC_SHIFT)) & CAN_FDCRC_FD_MBCRC_MASK)
/*! @} */

/*! @name ERFCR - Enhanced RX FIFO Control */
/*! @{ */

#define CAN_ERFCR_ERFWM_MASK                     (0x1FU)
#define CAN_ERFCR_ERFWM_SHIFT                    (0U)
/*! ERFWM - Enhanced RX FIFO Watermark */
#define CAN_ERFCR_ERFWM(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_ERFWM_SHIFT)) & CAN_ERFCR_ERFWM_MASK)

#define CAN_ERFCR_NFE_MASK                       (0x3F00U)
#define CAN_ERFCR_NFE_SHIFT                      (8U)
/*! NFE - Number of Enhanced RX FIFO Filter Elements */
#define CAN_ERFCR_NFE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_NFE_SHIFT)) & CAN_ERFCR_NFE_MASK)

#define CAN_ERFCR_NEXIF_MASK                     (0x7F0000U)
#define CAN_ERFCR_NEXIF_SHIFT                    (16U)
/*! NEXIF - Number of Extended ID Filter Elements */
#define CAN_ERFCR_NEXIF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_NEXIF_SHIFT)) & CAN_ERFCR_NEXIF_MASK)

#define CAN_ERFCR_DMALW_MASK                     (0x7C000000U)
#define CAN_ERFCR_DMALW_SHIFT                    (26U)
/*! DMALW - DMA Last Word */
#define CAN_ERFCR_DMALW(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_DMALW_SHIFT)) & CAN_ERFCR_DMALW_MASK)

#define CAN_ERFCR_ERFEN_MASK                     (0x80000000U)
#define CAN_ERFCR_ERFEN_SHIFT                    (31U)
/*! ERFEN - Enhanced RX FIFO enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFCR_ERFEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_ERFEN_SHIFT)) & CAN_ERFCR_ERFEN_MASK)
/*! @} */

/*! @name ERFIER - Enhanced RX FIFO Interrupt Enable */
/*! @{ */

#define CAN_ERFIER_ERFDAIE_MASK                  (0x10000000U)
#define CAN_ERFIER_ERFDAIE_SHIFT                 (28U)
/*! ERFDAIE - Enhanced RX FIFO Data Available Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFDAIE(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFDAIE_SHIFT)) & CAN_ERFIER_ERFDAIE_MASK)

#define CAN_ERFIER_ERFWMIIE_MASK                 (0x20000000U)
#define CAN_ERFIER_ERFWMIIE_SHIFT                (29U)
/*! ERFWMIIE - Enhanced RX FIFO Watermark Indication Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFWMIIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFWMIIE_SHIFT)) & CAN_ERFIER_ERFWMIIE_MASK)

#define CAN_ERFIER_ERFOVFIE_MASK                 (0x40000000U)
#define CAN_ERFIER_ERFOVFIE_SHIFT                (30U)
/*! ERFOVFIE - Enhanced RX FIFO Overflow Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFOVFIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFOVFIE_SHIFT)) & CAN_ERFIER_ERFOVFIE_MASK)

#define CAN_ERFIER_ERFUFWIE_MASK                 (0x80000000U)
#define CAN_ERFIER_ERFUFWIE_SHIFT                (31U)
/*! ERFUFWIE - Enhanced RX FIFO Underflow Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CAN_ERFIER_ERFUFWIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFUFWIE_SHIFT)) & CAN_ERFIER_ERFUFWIE_MASK)
/*! @} */

/*! @name ERFSR - Enhanced RX FIFO Status */
/*! @{ */

#define CAN_ERFSR_ERFEL_MASK                     (0x3FU)
#define CAN_ERFSR_ERFEL_SHIFT                    (0U)
/*! ERFEL - Enhanced RX FIFO Elements */
#define CAN_ERFSR_ERFEL(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFEL_SHIFT)) & CAN_ERFSR_ERFEL_MASK)

#define CAN_ERFSR_ERFF_MASK                      (0x10000U)
#define CAN_ERFSR_ERFF_SHIFT                     (16U)
/*! ERFF - Enhanced RX FIFO Full Flag
 *  0b0..Not full
 *  0b1..Full
 */
#define CAN_ERFSR_ERFF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFF_SHIFT)) & CAN_ERFSR_ERFF_MASK)

#define CAN_ERFSR_ERFE_MASK                      (0x20000U)
#define CAN_ERFSR_ERFE_SHIFT                     (17U)
/*! ERFE - Enhanced RX FIFO Empty Flag
 *  0b0..Not empty
 *  0b1..Empty
 */
#define CAN_ERFSR_ERFE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFE_SHIFT)) & CAN_ERFSR_ERFE_MASK)

#define CAN_ERFSR_ERFCLR_MASK                    (0x8000000U)
#define CAN_ERFSR_ERFCLR_SHIFT                   (27U)
/*! ERFCLR - Enhanced RX FIFO Clear
 *  0b0..No effect
 *  0b1..Clear enhanced RX FIFO content
 */
#define CAN_ERFSR_ERFCLR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFCLR_SHIFT)) & CAN_ERFSR_ERFCLR_MASK)

#define CAN_ERFSR_ERFDA_MASK                     (0x10000000U)
#define CAN_ERFSR_ERFDA_SHIFT                    (28U)
/*! ERFDA - Enhanced RX FIFO Data Available Flag
 *  0b0..No such occurrence
 *  0b1..At least one message stored in Enhanced RX FIFO
 */
#define CAN_ERFSR_ERFDA(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFDA_SHIFT)) & CAN_ERFSR_ERFDA_MASK)

#define CAN_ERFSR_ERFWMI_MASK                    (0x20000000U)
#define CAN_ERFSR_ERFWMI_SHIFT                   (29U)
/*! ERFWMI - Enhanced RX FIFO Watermark Indication Flag
 *  0b0..No such occurrence
 *  0b1..Number of messages in FIFO is greater than the watermark
 */
#define CAN_ERFSR_ERFWMI(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFWMI_SHIFT)) & CAN_ERFSR_ERFWMI_MASK)

#define CAN_ERFSR_ERFOVF_MASK                    (0x40000000U)
#define CAN_ERFSR_ERFOVF_SHIFT                   (30U)
/*! ERFOVF - Enhanced RX FIFO Overflow Flag
 *  0b0..No such occurrence
 *  0b1..Overflow
 */
#define CAN_ERFSR_ERFOVF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFOVF_SHIFT)) & CAN_ERFSR_ERFOVF_MASK)

#define CAN_ERFSR_ERFUFW_MASK                    (0x80000000U)
#define CAN_ERFSR_ERFUFW_SHIFT                   (31U)
/*! ERFUFW - Enhanced RX FIFO Underflow Flag
 *  0b0..No such occurrence
 *  0b1..Underflow
 */
#define CAN_ERFSR_ERFUFW(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFUFW_SHIFT)) & CAN_ERFSR_ERFUFW_MASK)
/*! @} */

/*! @name ERFFEL - Enhanced RX FIFO Filter Element */
/*! @{ */

#define CAN_ERFFEL_FEL_MASK                      (0xFFFFFFFFU)
#define CAN_ERFFEL_FEL_SHIFT                     (0U)
/*! FEL - Filter Element Bits */
#define CAN_ERFFEL_FEL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFFEL_FEL_SHIFT)) & CAN_ERFFEL_FEL_MASK)
/*! @} */

/* The count of CAN_ERFFEL */
#define CAN_ERFFEL_COUNT                         (32U)


/*!
 * @}
 */ /* end of group CAN_Register_Masks */


/* CAN - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CAN0 base address */
  #define CAN0_BASE                                (0x500D4000u)
  /** Peripheral CAN0 base address */
  #define CAN0_BASE_NS                             (0x400D4000u)
  /** Peripheral CAN0 base pointer */
  #define CAN0                                     ((CAN_Type *)CAN0_BASE)
  /** Peripheral CAN0 base pointer */
  #define CAN0_NS                                  ((CAN_Type *)CAN0_BASE_NS)
  /** Peripheral CAN1 base address */
  #define CAN1_BASE                                (0x500D8000u)
  /** Peripheral CAN1 base address */
  #define CAN1_BASE_NS                             (0x400D8000u)
  /** Peripheral CAN1 base pointer */
  #define CAN1                                     ((CAN_Type *)CAN1_BASE)
  /** Peripheral CAN1 base pointer */
  #define CAN1_NS                                  ((CAN_Type *)CAN1_BASE_NS)
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS                           { CAN0_BASE, CAN1_BASE }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS                            { CAN0, CAN1 }
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS_NS                        { CAN0_BASE_NS, CAN1_BASE_NS }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS_NS                         { CAN0_NS, CAN1_NS }
#else
  /** Peripheral CAN0 base address */
  #define CAN0_BASE                                (0x400D4000u)
  /** Peripheral CAN0 base pointer */
  #define CAN0                                     ((CAN_Type *)CAN0_BASE)
  /** Peripheral CAN1 base address */
  #define CAN1_BASE                                (0x400D8000u)
  /** Peripheral CAN1 base pointer */
  #define CAN1                                     ((CAN_Type *)CAN1_BASE)
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS                           { CAN0_BASE, CAN1_BASE }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS                            { CAN0, CAN1 }
#endif
/** Interrupt vectors for the CAN peripheral type */
#define CAN_Rx_Warning_IRQS                      { CAN0_IRQn, CAN1_IRQn }
#define CAN_Tx_Warning_IRQS                      { CAN0_IRQn, CAN1_IRQn }
#define CAN_Wake_Up_IRQS                         { CAN0_IRQn, CAN1_IRQn }
#define CAN_Error_IRQS                           { CAN0_IRQn, CAN1_IRQn }
#define CAN_Bus_Off_IRQS                         { CAN0_IRQn, CAN1_IRQn }
#define CAN_ORed_Message_buffer_IRQS             { CAN0_IRQn, CAN1_IRQn }

/*!
 * @}
 */ /* end of group CAN_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CDOG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CDOG_Peripheral_Access_Layer CDOG Peripheral Access Layer
 * @{
 */

/** CDOG - Register Layout Typedef */
typedef struct {
  __IO uint32_t CONTROL;                           /**< Control Register, offset: 0x0 */
  __IO uint32_t RELOAD;                            /**< Instruction Timer Reload Register, offset: 0x4 */
  __I  uint32_t INSTRUCTION_TIMER;                 /**< Instruction Timer Register, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __I  uint32_t STATUS;                            /**< Status 1 Register, offset: 0x10 */
  __I  uint32_t STATUS2;                           /**< Status 2 Register, offset: 0x14 */
  __IO uint32_t FLAGS;                             /**< Flags Register, offset: 0x18 */
  __IO uint32_t PERSISTENT;                        /**< Persistent Data Storage Register, offset: 0x1C */
  __O  uint32_t START;                             /**< START Command Register, offset: 0x20 */
  __O  uint32_t STOP;                              /**< STOP Command Register, offset: 0x24 */
  __O  uint32_t RESTART;                           /**< RESTART Command Register, offset: 0x28 */
  __O  uint32_t ADD;                               /**< ADD Command Register, offset: 0x2C */
  __O  uint32_t ADD1;                              /**< ADD1 Command Register, offset: 0x30 */
  __O  uint32_t ADD16;                             /**< ADD16 Command Register, offset: 0x34 */
  __O  uint32_t ADD256;                            /**< ADD256 Command Register, offset: 0x38 */
  __O  uint32_t SUB;                               /**< SUB Command Register, offset: 0x3C */
  __O  uint32_t SUB1;                              /**< SUB1 Command Register, offset: 0x40 */
  __O  uint32_t SUB16;                             /**< SUB16 Command Register, offset: 0x44 */
  __O  uint32_t SUB256;                            /**< SUB256 Command Register, offset: 0x48 */
  __O  uint32_t ASSERT16;                          /**< ASSERT16 Command Register, offset: 0x4C */
} CDOG_Type;

/* ----------------------------------------------------------------------------
   -- CDOG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CDOG_Register_Masks CDOG Register Masks
 * @{
 */

/*! @name CONTROL - Control Register */
/*! @{ */

#define CDOG_CONTROL_LOCK_CTRL_MASK              (0x3U)
#define CDOG_CONTROL_LOCK_CTRL_SHIFT             (0U)
/*! LOCK_CTRL - Lock control
 *  0b01..Locked
 *  0b10..Unlocked
 */
#define CDOG_CONTROL_LOCK_CTRL(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_LOCK_CTRL_SHIFT)) & CDOG_CONTROL_LOCK_CTRL_MASK)

#define CDOG_CONTROL_TIMEOUT_CTRL_MASK           (0x1CU)
#define CDOG_CONTROL_TIMEOUT_CTRL_SHIFT          (2U)
/*! TIMEOUT_CTRL - TIMEOUT fault control
 *  0b100..Disable both reset and interrupt
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 */
#define CDOG_CONTROL_TIMEOUT_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_TIMEOUT_CTRL_SHIFT)) & CDOG_CONTROL_TIMEOUT_CTRL_MASK)

#define CDOG_CONTROL_MISCOMPARE_CTRL_MASK        (0xE0U)
#define CDOG_CONTROL_MISCOMPARE_CTRL_SHIFT       (5U)
/*! MISCOMPARE_CTRL - MISCOMPARE fault control
 *  0b100..Disable both reset and interrupt
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 */
#define CDOG_CONTROL_MISCOMPARE_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_MISCOMPARE_CTRL_SHIFT)) & CDOG_CONTROL_MISCOMPARE_CTRL_MASK)

#define CDOG_CONTROL_SEQUENCE_CTRL_MASK          (0x700U)
#define CDOG_CONTROL_SEQUENCE_CTRL_SHIFT         (8U)
/*! SEQUENCE_CTRL - SEQUENCE fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_SEQUENCE_CTRL(x)            (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_SEQUENCE_CTRL_SHIFT)) & CDOG_CONTROL_SEQUENCE_CTRL_MASK)

#define CDOG_CONTROL_STATE_CTRL_MASK             (0x1C000U)
#define CDOG_CONTROL_STATE_CTRL_SHIFT            (14U)
/*! STATE_CTRL - STATE fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_STATE_CTRL(x)               (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_STATE_CTRL_SHIFT)) & CDOG_CONTROL_STATE_CTRL_MASK)

#define CDOG_CONTROL_ADDRESS_CTRL_MASK           (0xE0000U)
#define CDOG_CONTROL_ADDRESS_CTRL_SHIFT          (17U)
/*! ADDRESS_CTRL - ADDRESS fault control
 *  0b001..Enable reset
 *  0b010..Enable interrupt
 *  0b100..Disable both reset and interrupt
 */
#define CDOG_CONTROL_ADDRESS_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_ADDRESS_CTRL_SHIFT)) & CDOG_CONTROL_ADDRESS_CTRL_MASK)

#define CDOG_CONTROL_IRQ_PAUSE_MASK              (0x30000000U)
#define CDOG_CONTROL_IRQ_PAUSE_SHIFT             (28U)
/*! IRQ_PAUSE - IRQ pause control
 *  0b01..Keep the timer running
 *  0b10..Stop the timer
 */
#define CDOG_CONTROL_IRQ_PAUSE(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_IRQ_PAUSE_SHIFT)) & CDOG_CONTROL_IRQ_PAUSE_MASK)

#define CDOG_CONTROL_DEBUG_HALT_CTRL_MASK        (0xC0000000U)
#define CDOG_CONTROL_DEBUG_HALT_CTRL_SHIFT       (30U)
/*! DEBUG_HALT_CTRL - DEBUG_HALT control
 *  0b01..Keep the timer running
 *  0b10..Stop the timer
 */
#define CDOG_CONTROL_DEBUG_HALT_CTRL(x)          (((uint32_t)(((uint32_t)(x)) << CDOG_CONTROL_DEBUG_HALT_CTRL_SHIFT)) & CDOG_CONTROL_DEBUG_HALT_CTRL_MASK)
/*! @} */

/*! @name RELOAD - Instruction Timer Reload Register */
/*! @{ */

#define CDOG_RELOAD_RLOAD_MASK                   (0xFFFFFFFFU)
#define CDOG_RELOAD_RLOAD_SHIFT                  (0U)
/*! RLOAD - Instruction Timer reload value */
#define CDOG_RELOAD_RLOAD(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_RELOAD_RLOAD_SHIFT)) & CDOG_RELOAD_RLOAD_MASK)
/*! @} */

/*! @name INSTRUCTION_TIMER - Instruction Timer Register */
/*! @{ */

#define CDOG_INSTRUCTION_TIMER_INSTIM_MASK       (0xFFFFFFFFU)
#define CDOG_INSTRUCTION_TIMER_INSTIM_SHIFT      (0U)
/*! INSTIM - Current value of the Instruction Timer */
#define CDOG_INSTRUCTION_TIMER_INSTIM(x)         (((uint32_t)(((uint32_t)(x)) << CDOG_INSTRUCTION_TIMER_INSTIM_SHIFT)) & CDOG_INSTRUCTION_TIMER_INSTIM_MASK)
/*! @} */

/*! @name STATUS - Status 1 Register */
/*! @{ */

#define CDOG_STATUS_NUMTOF_MASK                  (0xFFU)
#define CDOG_STATUS_NUMTOF_SHIFT                 (0U)
/*! NUMTOF - Number of TIMEOUT faults since the last POR */
#define CDOG_STATUS_NUMTOF(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMTOF_SHIFT)) & CDOG_STATUS_NUMTOF_MASK)

#define CDOG_STATUS_NUMMISCOMPF_MASK             (0xFF00U)
#define CDOG_STATUS_NUMMISCOMPF_SHIFT            (8U)
/*! NUMMISCOMPF - Number of MISCOMPARE faults since the last POR */
#define CDOG_STATUS_NUMMISCOMPF(x)               (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMMISCOMPF_SHIFT)) & CDOG_STATUS_NUMMISCOMPF_MASK)

#define CDOG_STATUS_NUMILSEQF_MASK               (0xFF0000U)
#define CDOG_STATUS_NUMILSEQF_SHIFT              (16U)
/*! NUMILSEQF - Number of SEQUENCE faults since the last POR */
#define CDOG_STATUS_NUMILSEQF(x)                 (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_NUMILSEQF_SHIFT)) & CDOG_STATUS_NUMILSEQF_MASK)

#define CDOG_STATUS_CURST_MASK                   (0xF0000000U)
#define CDOG_STATUS_CURST_SHIFT                  (28U)
/*! CURST - Current State */
#define CDOG_STATUS_CURST(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS_CURST_SHIFT)) & CDOG_STATUS_CURST_MASK)
/*! @} */

/*! @name STATUS2 - Status 2 Register */
/*! @{ */

#define CDOG_STATUS2_NUMCNTF_MASK                (0xFFU)
#define CDOG_STATUS2_NUMCNTF_SHIFT               (0U)
/*! NUMCNTF - Number of CONTROL faults since the last POR */
#define CDOG_STATUS2_NUMCNTF(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMCNTF_SHIFT)) & CDOG_STATUS2_NUMCNTF_MASK)

#define CDOG_STATUS2_NUMILLSTF_MASK              (0xFF00U)
#define CDOG_STATUS2_NUMILLSTF_SHIFT             (8U)
/*! NUMILLSTF - Number of STATE faults since the last POR */
#define CDOG_STATUS2_NUMILLSTF(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMILLSTF_SHIFT)) & CDOG_STATUS2_NUMILLSTF_MASK)

#define CDOG_STATUS2_NUMILLA_MASK                (0xFF0000U)
#define CDOG_STATUS2_NUMILLA_SHIFT               (16U)
/*! NUMILLA - Number of ADDRESS faults since the last POR */
#define CDOG_STATUS2_NUMILLA(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_STATUS2_NUMILLA_SHIFT)) & CDOG_STATUS2_NUMILLA_MASK)
/*! @} */

/*! @name FLAGS - Flags Register */
/*! @{ */

#define CDOG_FLAGS_TO_FLAG_MASK                  (0x1U)
#define CDOG_FLAGS_TO_FLAG_SHIFT                 (0U)
/*! TO_FLAG - TIMEOUT fault flag
 *  0b0..A TIMEOUT fault has not occurred
 *  0b1..A TIMEOUT fault has occurred
 */
#define CDOG_FLAGS_TO_FLAG(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_TO_FLAG_SHIFT)) & CDOG_FLAGS_TO_FLAG_MASK)

#define CDOG_FLAGS_MISCOM_FLAG_MASK              (0x2U)
#define CDOG_FLAGS_MISCOM_FLAG_SHIFT             (1U)
/*! MISCOM_FLAG - MISCOMPARE fault flag
 *  0b0..A MISCOMPARE fault has not occurred
 *  0b1..A MISCOMPARE fault has occurred
 */
#define CDOG_FLAGS_MISCOM_FLAG(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_MISCOM_FLAG_SHIFT)) & CDOG_FLAGS_MISCOM_FLAG_MASK)

#define CDOG_FLAGS_SEQ_FLAG_MASK                 (0x4U)
#define CDOG_FLAGS_SEQ_FLAG_SHIFT                (2U)
/*! SEQ_FLAG - SEQUENCE fault flag
 *  0b0..A SEQUENCE fault has not occurred
 *  0b1..A SEQUENCE fault has occurred
 */
#define CDOG_FLAGS_SEQ_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_SEQ_FLAG_SHIFT)) & CDOG_FLAGS_SEQ_FLAG_MASK)

#define CDOG_FLAGS_CNT_FLAG_MASK                 (0x8U)
#define CDOG_FLAGS_CNT_FLAG_SHIFT                (3U)
/*! CNT_FLAG - CONTROL fault flag
 *  0b0..A CONTROL fault has not occurred
 *  0b1..A CONTROL fault has occurred
 */
#define CDOG_FLAGS_CNT_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_CNT_FLAG_SHIFT)) & CDOG_FLAGS_CNT_FLAG_MASK)

#define CDOG_FLAGS_STATE_FLAG_MASK               (0x10U)
#define CDOG_FLAGS_STATE_FLAG_SHIFT              (4U)
/*! STATE_FLAG - STATE fault flag
 *  0b0..A STATE fault has not occurred
 *  0b1..A STATE fault has occurred
 */
#define CDOG_FLAGS_STATE_FLAG(x)                 (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_STATE_FLAG_SHIFT)) & CDOG_FLAGS_STATE_FLAG_MASK)

#define CDOG_FLAGS_ADDR_FLAG_MASK                (0x20U)
#define CDOG_FLAGS_ADDR_FLAG_SHIFT               (5U)
/*! ADDR_FLAG - ADDRESS fault flag
 *  0b0..An ADDRESS fault has not occurred
 *  0b1..An ADDRESS fault has occurred
 */
#define CDOG_FLAGS_ADDR_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_ADDR_FLAG_SHIFT)) & CDOG_FLAGS_ADDR_FLAG_MASK)

#define CDOG_FLAGS_POR_FLAG_MASK                 (0x10000U)
#define CDOG_FLAGS_POR_FLAG_SHIFT                (16U)
/*! POR_FLAG - Power-on reset flag
 *  0b0..A Power-on reset event has not occurred
 *  0b1..A Power-on reset event has occurred
 */
#define CDOG_FLAGS_POR_FLAG(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_FLAGS_POR_FLAG_SHIFT)) & CDOG_FLAGS_POR_FLAG_MASK)
/*! @} */

/*! @name PERSISTENT - Persistent Data Storage Register */
/*! @{ */

#define CDOG_PERSISTENT_PERSIS_MASK              (0xFFFFFFFFU)
#define CDOG_PERSISTENT_PERSIS_SHIFT             (0U)
/*! PERSIS - Persistent Storage */
#define CDOG_PERSISTENT_PERSIS(x)                (((uint32_t)(((uint32_t)(x)) << CDOG_PERSISTENT_PERSIS_SHIFT)) & CDOG_PERSISTENT_PERSIS_MASK)
/*! @} */

/*! @name START - START Command Register */
/*! @{ */

#define CDOG_START_STRT_MASK                     (0xFFFFFFFFU)
#define CDOG_START_STRT_SHIFT                    (0U)
/*! STRT - Start command */
#define CDOG_START_STRT(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_START_STRT_SHIFT)) & CDOG_START_STRT_MASK)
/*! @} */

/*! @name STOP - STOP Command Register */
/*! @{ */

#define CDOG_STOP_STP_MASK                       (0xFFFFFFFFU)
#define CDOG_STOP_STP_SHIFT                      (0U)
/*! STP - Stop command */
#define CDOG_STOP_STP(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_STOP_STP_SHIFT)) & CDOG_STOP_STP_MASK)
/*! @} */

/*! @name RESTART - RESTART Command Register */
/*! @{ */

#define CDOG_RESTART_RSTRT_MASK                  (0xFFFFFFFFU)
#define CDOG_RESTART_RSTRT_SHIFT                 (0U)
/*! RSTRT - Restart command */
#define CDOG_RESTART_RSTRT(x)                    (((uint32_t)(((uint32_t)(x)) << CDOG_RESTART_RSTRT_SHIFT)) & CDOG_RESTART_RSTRT_MASK)
/*! @} */

/*! @name ADD - ADD Command Register */
/*! @{ */

#define CDOG_ADD_AD_MASK                         (0xFFFFFFFFU)
#define CDOG_ADD_AD_SHIFT                        (0U)
/*! AD - ADD Write Value */
#define CDOG_ADD_AD(x)                           (((uint32_t)(((uint32_t)(x)) << CDOG_ADD_AD_SHIFT)) & CDOG_ADD_AD_MASK)
/*! @} */

/*! @name ADD1 - ADD1 Command Register */
/*! @{ */

#define CDOG_ADD1_AD1_MASK                       (0xFFFFFFFFU)
#define CDOG_ADD1_AD1_SHIFT                      (0U)
/*! AD1 - ADD 1 */
#define CDOG_ADD1_AD1(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_ADD1_AD1_SHIFT)) & CDOG_ADD1_AD1_MASK)
/*! @} */

/*! @name ADD16 - ADD16 Command Register */
/*! @{ */

#define CDOG_ADD16_AD16_MASK                     (0xFFFFFFFFU)
#define CDOG_ADD16_AD16_SHIFT                    (0U)
/*! AD16 - ADD 16 */
#define CDOG_ADD16_AD16(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_ADD16_AD16_SHIFT)) & CDOG_ADD16_AD16_MASK)
/*! @} */

/*! @name ADD256 - ADD256 Command Register */
/*! @{ */

#define CDOG_ADD256_AD256_MASK                   (0xFFFFFFFFU)
#define CDOG_ADD256_AD256_SHIFT                  (0U)
/*! AD256 - ADD 256 */
#define CDOG_ADD256_AD256(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_ADD256_AD256_SHIFT)) & CDOG_ADD256_AD256_MASK)
/*! @} */

/*! @name SUB - SUB Command Register */
/*! @{ */

#define CDOG_SUB_SB_MASK                         (0xFFFFFFFFU)
#define CDOG_SUB_SB_SHIFT                        (0U)
/*! SB - Subtract Write Value */
#define CDOG_SUB_SB(x)                           (((uint32_t)(((uint32_t)(x)) << CDOG_SUB_SB_SHIFT)) & CDOG_SUB_SB_MASK)
/*! @} */

/*! @name SUB1 - SUB1 Command Register */
/*! @{ */

#define CDOG_SUB1_SB1_MASK                       (0xFFFFFFFFU)
#define CDOG_SUB1_SB1_SHIFT                      (0U)
/*! SB1 - Subtract 1 */
#define CDOG_SUB1_SB1(x)                         (((uint32_t)(((uint32_t)(x)) << CDOG_SUB1_SB1_SHIFT)) & CDOG_SUB1_SB1_MASK)
/*! @} */

/*! @name SUB16 - SUB16 Command Register */
/*! @{ */

#define CDOG_SUB16_SB16_MASK                     (0xFFFFFFFFU)
#define CDOG_SUB16_SB16_SHIFT                    (0U)
/*! SB16 - Subtract 16 */
#define CDOG_SUB16_SB16(x)                       (((uint32_t)(((uint32_t)(x)) << CDOG_SUB16_SB16_SHIFT)) & CDOG_SUB16_SB16_MASK)
/*! @} */

/*! @name SUB256 - SUB256 Command Register */
/*! @{ */

#define CDOG_SUB256_SB256_MASK                   (0xFFFFFFFFU)
#define CDOG_SUB256_SB256_SHIFT                  (0U)
/*! SB256 - Subtract 256 */
#define CDOG_SUB256_SB256(x)                     (((uint32_t)(((uint32_t)(x)) << CDOG_SUB256_SB256_SHIFT)) & CDOG_SUB256_SB256_MASK)
/*! @} */

/*! @name ASSERT16 - ASSERT16 Command Register */
/*! @{ */

#define CDOG_ASSERT16_AST16_MASK                 (0xFFFFFFFFU)
#define CDOG_ASSERT16_AST16_SHIFT                (0U)
/*! AST16 - ASSERT16 Command */
#define CDOG_ASSERT16_AST16(x)                   (((uint32_t)(((uint32_t)(x)) << CDOG_ASSERT16_AST16_SHIFT)) & CDOG_ASSERT16_AST16_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CDOG_Register_Masks */


/* CDOG - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CDOG0 base address */
  #define CDOG0_BASE                               (0x500BB000u)
  /** Peripheral CDOG0 base address */
  #define CDOG0_BASE_NS                            (0x400BB000u)
  /** Peripheral CDOG0 base pointer */
  #define CDOG0                                    ((CDOG_Type *)CDOG0_BASE)
  /** Peripheral CDOG0 base pointer */
  #define CDOG0_NS                                 ((CDOG_Type *)CDOG0_BASE_NS)
  /** Peripheral CDOG1 base address */
  #define CDOG1_BASE                               (0x500BC000u)
  /** Peripheral CDOG1 base address */
  #define CDOG1_BASE_NS                            (0x400BC000u)
  /** Peripheral CDOG1 base pointer */
  #define CDOG1                                    ((CDOG_Type *)CDOG1_BASE)
  /** Peripheral CDOG1 base pointer */
  #define CDOG1_NS                                 ((CDOG_Type *)CDOG1_BASE_NS)
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS                          { CDOG0_BASE, CDOG1_BASE }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS                           { CDOG0, CDOG1 }
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS_NS                       { CDOG0_BASE_NS, CDOG1_BASE_NS }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS_NS                        { CDOG0_NS, CDOG1_NS }
#else
  /** Peripheral CDOG0 base address */
  #define CDOG0_BASE                               (0x400BB000u)
  /** Peripheral CDOG0 base pointer */
  #define CDOG0                                    ((CDOG_Type *)CDOG0_BASE)
  /** Peripheral CDOG1 base address */
  #define CDOG1_BASE                               (0x400BC000u)
  /** Peripheral CDOG1 base pointer */
  #define CDOG1                                    ((CDOG_Type *)CDOG1_BASE)
  /** Array initializer of CDOG peripheral base addresses */
  #define CDOG_BASE_ADDRS                          { CDOG0_BASE, CDOG1_BASE }
  /** Array initializer of CDOG peripheral base pointers */
  #define CDOG_BASE_PTRS                           { CDOG0, CDOG1 }
#endif
/** Interrupt vectors for the CDOG peripheral type */
#define CDOG_IRQS                                { CDOG0_IRQn, CDOG1_IRQn }

/*!
 * @}
 */ /* end of group CDOG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMC_Peripheral_Access_Layer CMC Peripheral Access Layer
 * @{
 */

/** CMC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID, offset: 0x0 */
       uint8_t RESERVED_0[12];
  __IO uint32_t CKCTRL;                            /**< Clock Control, offset: 0x10 */
  __IO uint32_t CKSTAT;                            /**< Clock Status, offset: 0x14 */
  __IO uint32_t PMPROT;                            /**< Power Mode Protection, offset: 0x18 */
  __O  uint32_t GPMCTRL;                           /**< Global Power Mode Control, offset: 0x1C */
  __IO uint32_t PMCTRL[2];                         /**< Power Mode Control, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_1[88];
  __I  uint32_t SRS;                               /**< System Reset Status, offset: 0x80 */
  __IO uint32_t RPC;                               /**< Reset Pin Control, offset: 0x84 */
  __IO uint32_t SSRS;                              /**< Sticky System Reset Status, offset: 0x88 */
  __IO uint32_t SRIE;                              /**< System Reset Interrupt Enable, offset: 0x8C */
  __IO uint32_t SRIF;                              /**< System Reset Interrupt Flag, offset: 0x90 */
       uint8_t RESERVED_2[8];
  __I  uint32_t RSTCNT;                            /**< Reset Count Register, offset: 0x9C */
  __IO uint32_t MR[1];                             /**< Mode, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_3[12];
  __IO uint32_t FM[1];                             /**< Force Mode, array offset: 0xB0, array step: 0x4 */
       uint8_t RESERVED_4[12];
  __IO uint32_t SRAMDIS[1];                        /**< SRAM Disable, array offset: 0xC0, array step: 0x4 */
       uint8_t RESERVED_5[12];
  __IO uint32_t SRAMRET[1];                        /**< SRAM Retention, array offset: 0xD0, array step: 0x4 */
       uint8_t RESERVED_6[12];
  __IO uint32_t FLASHCR;                           /**< Flash Control, offset: 0xE0 */
       uint8_t RESERVED_7[28];
  __IO uint32_t BSR;                               /**< BootROM Status Register, offset: 0x100 */
       uint8_t RESERVED_8[8];
  __IO uint32_t BLR;                               /**< BootROM Lock Register, offset: 0x10C */
  __IO uint32_t CORECTL;                           /**< Core Control, offset: 0x110 */
       uint8_t RESERVED_9[12];
  __IO uint32_t DBGCTL;                            /**< Debug Control, offset: 0x120 */
} CMC_Type;

/* ----------------------------------------------------------------------------
   -- CMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMC_Register_Masks CMC Register Masks
 * @{
 */

/*! @name VERID - Version ID */
/*! @{ */

#define CMC_VERID_FEATURE_MASK                   (0xFFFFU)
#define CMC_VERID_FEATURE_SHIFT                  (0U)
/*! FEATURE - Feature Specification Number */
#define CMC_VERID_FEATURE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_VERID_FEATURE_SHIFT)) & CMC_VERID_FEATURE_MASK)

#define CMC_VERID_MINOR_MASK                     (0xFF0000U)
#define CMC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number */
#define CMC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_VERID_MINOR_SHIFT)) & CMC_VERID_MINOR_MASK)

#define CMC_VERID_MAJOR_MASK                     (0xFF000000U)
#define CMC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number */
#define CMC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_VERID_MAJOR_SHIFT)) & CMC_VERID_MAJOR_MASK)
/*! @} */

/*! @name CKCTRL - Clock Control */
/*! @{ */

#define CMC_CKCTRL_CKMODE_MASK                   (0xFU)
#define CMC_CKCTRL_CKMODE_SHIFT                  (0U)
/*! CKMODE - Clocking Mode
 *  0b0000..No clock gating
 *  0b1111..Core, platform, and peripheral clocks are gated, and core enters Low-Power mode.
 */
#define CMC_CKCTRL_CKMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKCTRL_CKMODE_SHIFT)) & CMC_CKCTRL_CKMODE_MASK)

#define CMC_CKCTRL_LOCK_MASK                     (0x80000000U)
#define CMC_CKCTRL_LOCK_SHIFT                    (31U)
/*! LOCK - Lock
 *  0b0..Allowed
 *  0b1..Blocked
 */
#define CMC_CKCTRL_LOCK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_CKCTRL_LOCK_SHIFT)) & CMC_CKCTRL_LOCK_MASK)
/*! @} */

/*! @name CKSTAT - Clock Status */
/*! @{ */

#define CMC_CKSTAT_CKMODE_MASK                   (0xFU)
#define CMC_CKSTAT_CKMODE_SHIFT                  (0U)
/*! CKMODE - Low Power Status
 *  0b0000..Core clock not gated
 *  0b1111..Core, platform, and peripheral clocks were gated, and power domain entered Low-Power mode
 *  *..
 */
#define CMC_CKSTAT_CKMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_CKMODE_SHIFT)) & CMC_CKSTAT_CKMODE_MASK)

#define CMC_CKSTAT_WAKEUP_MASK                   (0xFF00U)
#define CMC_CKSTAT_WAKEUP_SHIFT                  (8U)
/*! WAKEUP - Wake-up Source */
#define CMC_CKSTAT_WAKEUP(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_WAKEUP_SHIFT)) & CMC_CKSTAT_WAKEUP_MASK)

#define CMC_CKSTAT_VALID_MASK                    (0x80000000U)
#define CMC_CKSTAT_VALID_SHIFT                   (31U)
/*! VALID - Clock Status Valid
 *  0b0..Core clock not gated
 *  0b1..Core clock was gated due to Low-Power mode entry
 */
#define CMC_CKSTAT_VALID(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_VALID_SHIFT)) & CMC_CKSTAT_VALID_MASK)
/*! @} */

/*! @name PMPROT - Power Mode Protection */
/*! @{ */

#define CMC_PMPROT_LPMODE_MASK                   (0xFU)
#define CMC_PMPROT_LPMODE_SHIFT                  (0U)
/*! LPMODE - Low-Power Mode
 *  0b0000..Not allowed
 *  0b0001..Allowed
 *  0b0010..Allowed
 *  0b0011..Allowed
 *  0b0100..Allowed
 *  0b0101..Allowed
 *  0b0110..Allowed
 *  0b0111..Allowed
 *  0b1000..Allowed
 *  0b1001..Allowed
 *  0b1010..Allowed
 *  0b1011..Allowed
 *  0b1100..Allowed
 *  0b1101..Allowed
 *  0b1110..Allowed
 *  0b1111..Allowed
 */
#define CMC_PMPROT_LPMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_PMPROT_LPMODE_SHIFT)) & CMC_PMPROT_LPMODE_MASK)

#define CMC_PMPROT_LOCK_MASK                     (0x80000000U)
#define CMC_PMPROT_LOCK_SHIFT                    (31U)
/*! LOCK - Lock Register
 *  0b0..Allowed
 *  0b1..Blocked
 */
#define CMC_PMPROT_LOCK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_PMPROT_LOCK_SHIFT)) & CMC_PMPROT_LOCK_MASK)
/*! @} */

/*! @name GPMCTRL - Global Power Mode Control */
/*! @{ */

#define CMC_GPMCTRL_LPMODE_MASK                  (0xFU)
#define CMC_GPMCTRL_LPMODE_SHIFT                 (0U)
/*! LPMODE - Low-Power Mode */
#define CMC_GPMCTRL_LPMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CMC_GPMCTRL_LPMODE_SHIFT)) & CMC_GPMCTRL_LPMODE_MASK)
/*! @} */

/*! @name PMCTRL - Power Mode Control */
/*! @{ */

#define CMC_PMCTRL_LPMODE_MASK                   (0xFU)
#define CMC_PMCTRL_LPMODE_SHIFT                  (0U)
/*! LPMODE - Low-Power Mode
 *  0b0000..Active/Sleep
 *  0b0001..Deep Sleep
 *  0b0011..Power Down
 *  0b0111..Reserved
 *  0b1111..Deep-Power Down
 */
#define CMC_PMCTRL_LPMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_PMCTRL_LPMODE_SHIFT)) & CMC_PMCTRL_LPMODE_MASK)
/*! @} */

/* The count of CMC_PMCTRL */
#define CMC_PMCTRL_COUNT                         (2U)

/*! @name SRS - System Reset Status */
/*! @{ */

#define CMC_SRS_WAKEUP_MASK                      (0x1U)
#define CMC_SRS_WAKEUP_SHIFT                     (0U)
/*! WAKEUP - Wake-up Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_WAKEUP(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WAKEUP_SHIFT)) & CMC_SRS_WAKEUP_MASK)

#define CMC_SRS_POR_MASK                         (0x2U)
#define CMC_SRS_POR_SHIFT                        (1U)
/*! POR - Power-on Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_POR(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_POR_SHIFT)) & CMC_SRS_POR_MASK)

#define CMC_SRS_VD_MASK                          (0x4U)
#define CMC_SRS_VD_SHIFT                         (2U)
/*! VD - Voltage Detect Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_VD(x)                            (((uint32_t)(((uint32_t)(x)) << CMC_SRS_VD_SHIFT)) & CMC_SRS_VD_MASK)

#define CMC_SRS_WARM_MASK                        (0x10U)
#define CMC_SRS_WARM_SHIFT                       (4U)
/*! WARM - Warm Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_WARM(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WARM_SHIFT)) & CMC_SRS_WARM_MASK)

#define CMC_SRS_FATAL_MASK                       (0x20U)
#define CMC_SRS_FATAL_SHIFT                      (5U)
/*! FATAL - Fatal Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SRS_FATAL(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_FATAL_SHIFT)) & CMC_SRS_FATAL_MASK)

#define CMC_SRS_PIN_MASK                         (0x100U)
#define CMC_SRS_PIN_SHIFT                        (8U)
/*! PIN - Pin Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SRS_PIN(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_PIN_SHIFT)) & CMC_SRS_PIN_MASK)

#define CMC_SRS_DAP_MASK                         (0x200U)
#define CMC_SRS_DAP_SHIFT                        (9U)
/*! DAP - Debug Access Port Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SRS_DAP(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_DAP_SHIFT)) & CMC_SRS_DAP_MASK)

#define CMC_SRS_RSTACK_MASK                      (0x400U)
#define CMC_SRS_RSTACK_SHIFT                     (10U)
/*! RSTACK - Reset Timeout
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_RSTACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_RSTACK_SHIFT)) & CMC_SRS_RSTACK_MASK)

#define CMC_SRS_LPACK_MASK                       (0x800U)
#define CMC_SRS_LPACK_SHIFT                      (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_LPACK(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_LPACK_SHIFT)) & CMC_SRS_LPACK_MASK)

#define CMC_SRS_SCG_MASK                         (0x1000U)
#define CMC_SRS_SCG_SHIFT                        (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_SCG(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SCG_SHIFT)) & CMC_SRS_SCG_MASK)

#define CMC_SRS_WWDT0_MASK                       (0x2000U)
#define CMC_SRS_WWDT0_SHIFT                      (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_WWDT0(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WWDT0_SHIFT)) & CMC_SRS_WWDT0_MASK)

#define CMC_SRS_SW_MASK                          (0x4000U)
#define CMC_SRS_SW_SHIFT                         (14U)
/*! SW - Software Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_SW(x)                            (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SW_SHIFT)) & CMC_SRS_SW_MASK)

#define CMC_SRS_LOCKUP_MASK                      (0x8000U)
#define CMC_SRS_LOCKUP_SHIFT                     (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_LOCKUP(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_LOCKUP_SHIFT)) & CMC_SRS_LOCKUP_MASK)

#define CMC_SRS_CPU1_MASK                        (0x10000U)
#define CMC_SRS_CPU1_SHIFT                       (16U)
/*! CPU1 - CPU1 System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_CPU1(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_CPU1_SHIFT)) & CMC_SRS_CPU1_MASK)

#define CMC_SRS_VBAT_MASK                        (0x1000000U)
#define CMC_SRS_VBAT_SHIFT                       (24U)
/*! VBAT - VBAT System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_VBAT(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_VBAT_SHIFT)) & CMC_SRS_VBAT_MASK)

#define CMC_SRS_WWDT1_MASK                       (0x2000000U)
#define CMC_SRS_WWDT1_SHIFT                      (25U)
/*! WWDT1 - Windowed Watchdog 1 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_WWDT1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WWDT1_SHIFT)) & CMC_SRS_WWDT1_MASK)

#define CMC_SRS_CDOG0_MASK                       (0x4000000U)
#define CMC_SRS_CDOG0_SHIFT                      (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_CDOG0(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_CDOG0_SHIFT)) & CMC_SRS_CDOG0_MASK)

#define CMC_SRS_CDOG1_MASK                       (0x8000000U)
#define CMC_SRS_CDOG1_SHIFT                      (27U)
/*! CDOG1 - Code Watchdog 1 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SRS_CDOG1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_CDOG1_SHIFT)) & CMC_SRS_CDOG1_MASK)

#define CMC_SRS_JTAG_MASK                        (0x10000000U)
#define CMC_SRS_JTAG_SHIFT                       (28U)
/*! JTAG - JTAG System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_JTAG(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_JTAG_SHIFT)) & CMC_SRS_JTAG_MASK)

#define CMC_SRS_SECVIO_MASK                      (0x40000000U)
#define CMC_SRS_SECVIO_SHIFT                     (30U)
/*! SECVIO - Security Violation Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_SECVIO(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SECVIO_SHIFT)) & CMC_SRS_SECVIO_MASK)

#define CMC_SRS_TAMPER_MASK                      (0x80000000U)
#define CMC_SRS_TAMPER_SHIFT                     (31U)
/*! TAMPER - Tamper Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SRS_TAMPER(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_TAMPER_SHIFT)) & CMC_SRS_TAMPER_MASK)
/*! @} */

/*! @name RPC - Reset Pin Control */
/*! @{ */

#define CMC_RPC_FILTCFG_MASK                     (0x1FU)
#define CMC_RPC_FILTCFG_SHIFT                    (0U)
/*! FILTCFG - Reset Filter Configuration */
#define CMC_RPC_FILTCFG(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_RPC_FILTCFG_SHIFT)) & CMC_RPC_FILTCFG_MASK)

#define CMC_RPC_FILTEN_MASK                      (0x100U)
#define CMC_RPC_FILTEN_SHIFT                     (8U)
/*! FILTEN - Filter Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define CMC_RPC_FILTEN(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_RPC_FILTEN_SHIFT)) & CMC_RPC_FILTEN_MASK)

#define CMC_RPC_LPFEN_MASK                       (0x200U)
#define CMC_RPC_LPFEN_SHIFT                      (9U)
/*! LPFEN - Low-Power Filter Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define CMC_RPC_LPFEN(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_RPC_LPFEN_SHIFT)) & CMC_RPC_LPFEN_MASK)
/*! @} */

/*! @name SSRS - Sticky System Reset Status */
/*! @{ */

#define CMC_SSRS_WAKEUP_MASK                     (0x1U)
#define CMC_SSRS_WAKEUP_SHIFT                    (0U)
/*! WAKEUP - Wake-up Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_WAKEUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WAKEUP_SHIFT)) & CMC_SSRS_WAKEUP_MASK)

#define CMC_SSRS_POR_MASK                        (0x2U)
#define CMC_SSRS_POR_SHIFT                       (1U)
/*! POR - Power-on Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_POR(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_POR_SHIFT)) & CMC_SSRS_POR_MASK)

#define CMC_SSRS_VD_MASK                         (0x4U)
#define CMC_SSRS_VD_SHIFT                        (2U)
/*! VD - Voltage Detect Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_VD(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_VD_SHIFT)) & CMC_SSRS_VD_MASK)

#define CMC_SSRS_WARM_MASK                       (0x10U)
#define CMC_SSRS_WARM_SHIFT                      (4U)
/*! WARM - Warm Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_WARM(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WARM_SHIFT)) & CMC_SSRS_WARM_MASK)

#define CMC_SSRS_FATAL_MASK                      (0x20U)
#define CMC_SSRS_FATAL_SHIFT                     (5U)
/*! FATAL - Fatal Reset
 *  0b0..Reset was not generated
 *  0b1..Reset was generated
 */
#define CMC_SSRS_FATAL(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_FATAL_SHIFT)) & CMC_SSRS_FATAL_MASK)

#define CMC_SSRS_PIN_MASK                        (0x100U)
#define CMC_SSRS_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_PIN_SHIFT)) & CMC_SSRS_PIN_MASK)

#define CMC_SSRS_DAP_MASK                        (0x200U)
#define CMC_SSRS_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_DAP_SHIFT)) & CMC_SSRS_DAP_MASK)

#define CMC_SSRS_RSTACK_MASK                     (0x400U)
#define CMC_SSRS_RSTACK_SHIFT                    (10U)
/*! RSTACK - Reset Timeout
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_RSTACK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_RSTACK_SHIFT)) & CMC_SSRS_RSTACK_MASK)

#define CMC_SSRS_LPACK_MASK                      (0x800U)
#define CMC_SSRS_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_LPACK_SHIFT)) & CMC_SSRS_LPACK_MASK)

#define CMC_SSRS_SCG_MASK                        (0x1000U)
#define CMC_SSRS_SCG_SHIFT                       (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_SCG(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SCG_SHIFT)) & CMC_SSRS_SCG_MASK)

#define CMC_SSRS_WWDT0_MASK                      (0x2000U)
#define CMC_SSRS_WWDT0_SHIFT                     (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_WWDT0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WWDT0_SHIFT)) & CMC_SSRS_WWDT0_MASK)

#define CMC_SSRS_SW_MASK                         (0x4000U)
#define CMC_SSRS_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SW_SHIFT)) & CMC_SSRS_SW_MASK)

#define CMC_SSRS_LOCKUP_MASK                     (0x8000U)
#define CMC_SSRS_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_LOCKUP_SHIFT)) & CMC_SSRS_LOCKUP_MASK)

#define CMC_SSRS_CPU1_MASK                       (0x10000U)
#define CMC_SSRS_CPU1_SHIFT                      (16U)
/*! CPU1 - CPU1 Reset
 *  0b0..Reset not generated from CPU1 reset source.
 *  0b1..Reset generated from CPU1 reset source.
 */
#define CMC_SSRS_CPU1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_CPU1_SHIFT)) & CMC_SSRS_CPU1_MASK)

#define CMC_SSRS_VBAT_MASK                       (0x1000000U)
#define CMC_SSRS_VBAT_SHIFT                      (24U)
/*! VBAT - VBAT System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_VBAT(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_VBAT_SHIFT)) & CMC_SSRS_VBAT_MASK)

#define CMC_SSRS_WWDT1_MASK                      (0x2000000U)
#define CMC_SSRS_WWDT1_SHIFT                     (25U)
/*! WWDT1 - Windowed Watchdog 1 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_WWDT1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WWDT1_SHIFT)) & CMC_SSRS_WWDT1_MASK)

#define CMC_SSRS_CDOG0_MASK                      (0x4000000U)
#define CMC_SSRS_CDOG0_SHIFT                     (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_CDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_CDOG0_SHIFT)) & CMC_SSRS_CDOG0_MASK)

#define CMC_SSRS_CDOG1_MASK                      (0x8000000U)
#define CMC_SSRS_CDOG1_SHIFT                     (27U)
/*! CDOG1 - Code Watchdog 1 Reset
 *  0b0..Reset is not generated
 *  0b1..Reset is generated
 */
#define CMC_SSRS_CDOG1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_CDOG1_SHIFT)) & CMC_SSRS_CDOG1_MASK)

#define CMC_SSRS_JTAG_MASK                       (0x10000000U)
#define CMC_SSRS_JTAG_SHIFT                      (28U)
/*! JTAG - JTAG System Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_JTAG(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_JTAG_SHIFT)) & CMC_SSRS_JTAG_MASK)

#define CMC_SSRS_SECVIO_MASK                     (0x40000000U)
#define CMC_SSRS_SECVIO_SHIFT                    (30U)
/*! SECVIO - Security Violation Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_SECVIO(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SECVIO_SHIFT)) & CMC_SSRS_SECVIO_MASK)

#define CMC_SSRS_TAMPER_MASK                     (0x80000000U)
#define CMC_SSRS_TAMPER_SHIFT                    (31U)
/*! TAMPER - Tamper Reset
 *  0b0..Reset not generated
 *  0b1..Reset generated
 */
#define CMC_SSRS_TAMPER(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_TAMPER_SHIFT)) & CMC_SSRS_TAMPER_MASK)
/*! @} */

/*! @name SRIE - System Reset Interrupt Enable */
/*! @{ */

#define CMC_SRIE_PIN_MASK                        (0x100U)
#define CMC_SRIE_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_PIN_SHIFT)) & CMC_SRIE_PIN_MASK)

#define CMC_SRIE_DAP_MASK                        (0x200U)
#define CMC_SRIE_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_DAP_SHIFT)) & CMC_SRIE_DAP_MASK)

#define CMC_SRIE_LPACK_MASK                      (0x800U)
#define CMC_SRIE_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_LPACK_SHIFT)) & CMC_SRIE_LPACK_MASK)

#define CMC_SRIE_SCG_MASK                        (0x1000U)
#define CMC_SRIE_SCG_SHIFT                       (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_SCG(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_SCG_SHIFT)) & CMC_SRIE_SCG_MASK)

#define CMC_SRIE_WWDT0_MASK                      (0x2000U)
#define CMC_SRIE_WWDT0_SHIFT                     (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_WWDT0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_WWDT0_SHIFT)) & CMC_SRIE_WWDT0_MASK)

#define CMC_SRIE_SW_MASK                         (0x4000U)
#define CMC_SRIE_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_SW_SHIFT)) & CMC_SRIE_SW_MASK)

#define CMC_SRIE_LOCKUP_MASK                     (0x8000U)
#define CMC_SRIE_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_LOCKUP_SHIFT)) & CMC_SRIE_LOCKUP_MASK)

#define CMC_SRIE_CPU1_MASK                       (0x10000U)
#define CMC_SRIE_CPU1_SHIFT                      (16U)
/*! CPU1 - CPU1 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_CPU1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_CPU1_SHIFT)) & CMC_SRIE_CPU1_MASK)

#define CMC_SRIE_VBAT_MASK                       (0x1000000U)
#define CMC_SRIE_VBAT_SHIFT                      (24U)
/*! VBAT - VBAT System Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_VBAT(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_VBAT_SHIFT)) & CMC_SRIE_VBAT_MASK)

#define CMC_SRIE_WWDT1_MASK                      (0x2000000U)
#define CMC_SRIE_WWDT1_SHIFT                     (25U)
/*! WWDT1 - Windowed Watchdog 1 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_WWDT1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_WWDT1_SHIFT)) & CMC_SRIE_WWDT1_MASK)

#define CMC_SRIE_CDOG0_MASK                      (0x4000000U)
#define CMC_SRIE_CDOG0_SHIFT                     (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_CDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_CDOG0_SHIFT)) & CMC_SRIE_CDOG0_MASK)

#define CMC_SRIE_CDOG1_MASK                      (0x8000000U)
#define CMC_SRIE_CDOG1_SHIFT                     (27U)
/*! CDOG1 - Code Watchdog 1 Reset
 *  0b0..Interrupt disabled
 *  0b1..Interrupt enabled
 */
#define CMC_SRIE_CDOG1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_CDOG1_SHIFT)) & CMC_SRIE_CDOG1_MASK)
/*! @} */

/*! @name SRIF - System Reset Interrupt Flag */
/*! @{ */

#define CMC_SRIF_PIN_MASK                        (0x100U)
#define CMC_SRIF_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_PIN_SHIFT)) & CMC_SRIF_PIN_MASK)

#define CMC_SRIF_DAP_MASK                        (0x200U)
#define CMC_SRIF_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_DAP_SHIFT)) & CMC_SRIF_DAP_MASK)

#define CMC_SRIF_LPACK_MASK                      (0x800U)
#define CMC_SRIF_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_LPACK_SHIFT)) & CMC_SRIF_LPACK_MASK)

#define CMC_SRIF_WWDT0_MASK                      (0x2000U)
#define CMC_SRIF_WWDT0_SHIFT                     (13U)
/*! WWDT0 - Windowed Watchdog 0 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_WWDT0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_WWDT0_SHIFT)) & CMC_SRIF_WWDT0_MASK)

#define CMC_SRIF_SW_MASK                         (0x4000U)
#define CMC_SRIF_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_SW_SHIFT)) & CMC_SRIF_SW_MASK)

#define CMC_SRIF_LOCKUP_MASK                     (0x8000U)
#define CMC_SRIF_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_LOCKUP_SHIFT)) & CMC_SRIF_LOCKUP_MASK)

#define CMC_SRIF_CPU1_MASK                       (0x10000U)
#define CMC_SRIF_CPU1_SHIFT                      (16U)
/*! CPU1 - CPU1 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_CPU1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_CPU1_SHIFT)) & CMC_SRIF_CPU1_MASK)

#define CMC_SRIF_VBAT_MASK                       (0x1000000U)
#define CMC_SRIF_VBAT_SHIFT                      (24U)
/*! VBAT - VBAT System Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_VBAT(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_VBAT_SHIFT)) & CMC_SRIF_VBAT_MASK)

#define CMC_SRIF_WWDT1_MASK                      (0x2000000U)
#define CMC_SRIF_WWDT1_SHIFT                     (25U)
/*! WWDT1 - Windowed Watchdog 1 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_WWDT1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_WWDT1_SHIFT)) & CMC_SRIF_WWDT1_MASK)

#define CMC_SRIF_CDOG0_MASK                      (0x4000000U)
#define CMC_SRIF_CDOG0_SHIFT                     (26U)
/*! CDOG0 - Code Watchdog 0 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_CDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_CDOG0_SHIFT)) & CMC_SRIF_CDOG0_MASK)

#define CMC_SRIF_CDOG1_MASK                      (0x8000000U)
#define CMC_SRIF_CDOG1_SHIFT                     (27U)
/*! CDOG1 - Code Watchdog 1 Reset
 *  0b0..Reset source not pending
 *  0b1..Reset source pending
 */
#define CMC_SRIF_CDOG1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_CDOG1_SHIFT)) & CMC_SRIF_CDOG1_MASK)
/*! @} */

/*! @name RSTCNT - Reset Count Register */
/*! @{ */

#define CMC_RSTCNT_COUNT_MASK                    (0xFFU)
#define CMC_RSTCNT_COUNT_SHIFT                   (0U)
/*! COUNT - Count */
#define CMC_RSTCNT_COUNT(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_RSTCNT_COUNT_SHIFT)) & CMC_RSTCNT_COUNT_MASK)
/*! @} */

/*! @name MR - Mode */
/*! @{ */

#define CMC_MR_ISPMODE_n_MASK                    (0x1U)
#define CMC_MR_ISPMODE_n_SHIFT                   (0U)
/*! ISPMODE_n - In System Programming Mode */
#define CMC_MR_ISPMODE_n(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_MR_ISPMODE_n_SHIFT)) & CMC_MR_ISPMODE_n_MASK)
/*! @} */

/* The count of CMC_MR */
#define CMC_MR_COUNT                             (1U)

/*! @name FM - Force Mode */
/*! @{ */

#define CMC_FM_FORCECFG_MASK                     (0x1U)
#define CMC_FM_FORCECFG_SHIFT                    (0U)
/*! FORCECFG - Boot Configuration
 *  0b0..No effect
 *  0b1..Asserts
 */
#define CMC_FM_FORCECFG(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_FM_FORCECFG_SHIFT)) & CMC_FM_FORCECFG_MASK)
/*! @} */

/* The count of CMC_FM */
#define CMC_FM_COUNT                             (1U)

/*! @name SRAMDIS - SRAM Disable */
/*! @{ */

#define CMC_SRAMDIS_DIS0_MASK                    (0x1U)
#define CMC_SRAMDIS_DIS0_SHIFT                   (0U)
/*! DIS0 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS0(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS0_SHIFT)) & CMC_SRAMDIS_DIS0_MASK)

#define CMC_SRAMDIS_DIS1_MASK                    (0x2U)
#define CMC_SRAMDIS_DIS1_SHIFT                   (1U)
/*! DIS1 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS1(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS1_SHIFT)) & CMC_SRAMDIS_DIS1_MASK)

#define CMC_SRAMDIS_DIS2_MASK                    (0x4U)
#define CMC_SRAMDIS_DIS2_SHIFT                   (2U)
/*! DIS2 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS2(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS2_SHIFT)) & CMC_SRAMDIS_DIS2_MASK)

#define CMC_SRAMDIS_DIS3_MASK                    (0x8U)
#define CMC_SRAMDIS_DIS3_SHIFT                   (3U)
/*! DIS3 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS3(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS3_SHIFT)) & CMC_SRAMDIS_DIS3_MASK)

#define CMC_SRAMDIS_DIS4_MASK                    (0x10U)
#define CMC_SRAMDIS_DIS4_SHIFT                   (4U)
/*! DIS4 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS4(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS4_SHIFT)) & CMC_SRAMDIS_DIS4_MASK)

#define CMC_SRAMDIS_DIS5_MASK                    (0x20U)
#define CMC_SRAMDIS_DIS5_SHIFT                   (5U)
/*! DIS5 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS5(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS5_SHIFT)) & CMC_SRAMDIS_DIS5_MASK)

#define CMC_SRAMDIS_DIS6_MASK                    (0x40U)
#define CMC_SRAMDIS_DIS6_SHIFT                   (6U)
/*! DIS6 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS6(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS6_SHIFT)) & CMC_SRAMDIS_DIS6_MASK)

#define CMC_SRAMDIS_DIS7_MASK                    (0x80U)
#define CMC_SRAMDIS_DIS7_SHIFT                   (7U)
/*! DIS7 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS7(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS7_SHIFT)) & CMC_SRAMDIS_DIS7_MASK)

#define CMC_SRAMDIS_DIS8_MASK                    (0x100U)
#define CMC_SRAMDIS_DIS8_SHIFT                   (8U)
/*! DIS8 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS8(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS8_SHIFT)) & CMC_SRAMDIS_DIS8_MASK)

#define CMC_SRAMDIS_DIS9_MASK                    (0x200U)
#define CMC_SRAMDIS_DIS9_SHIFT                   (9U)
/*! DIS9 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS9(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS9_SHIFT)) & CMC_SRAMDIS_DIS9_MASK)

#define CMC_SRAMDIS_DIS10_MASK                   (0x400U)
#define CMC_SRAMDIS_DIS10_SHIFT                  (10U)
/*! DIS10 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS10(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS10_SHIFT)) & CMC_SRAMDIS_DIS10_MASK)

#define CMC_SRAMDIS_DIS11_MASK                   (0x800U)
#define CMC_SRAMDIS_DIS11_SHIFT                  (11U)
/*! DIS11 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS11(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS11_SHIFT)) & CMC_SRAMDIS_DIS11_MASK)

#define CMC_SRAMDIS_DIS12_MASK                   (0x1000U)
#define CMC_SRAMDIS_DIS12_SHIFT                  (12U)
/*! DIS12 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS12(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS12_SHIFT)) & CMC_SRAMDIS_DIS12_MASK)

#define CMC_SRAMDIS_DIS13_MASK                   (0x2000U)
#define CMC_SRAMDIS_DIS13_SHIFT                  (13U)
/*! DIS13 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS13(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS13_SHIFT)) & CMC_SRAMDIS_DIS13_MASK)

#define CMC_SRAMDIS_DIS14_MASK                   (0x4000U)
#define CMC_SRAMDIS_DIS14_SHIFT                  (14U)
/*! DIS14 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS14(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS14_SHIFT)) & CMC_SRAMDIS_DIS14_MASK)

#define CMC_SRAMDIS_DIS15_MASK                   (0x8000U)
#define CMC_SRAMDIS_DIS15_SHIFT                  (15U)
/*! DIS15 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS15(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS15_SHIFT)) & CMC_SRAMDIS_DIS15_MASK)

#define CMC_SRAMDIS_DIS16_MASK                   (0x10000U)
#define CMC_SRAMDIS_DIS16_SHIFT                  (16U)
/*! DIS16 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS16(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS16_SHIFT)) & CMC_SRAMDIS_DIS16_MASK)

#define CMC_SRAMDIS_DIS17_MASK                   (0x20000U)
#define CMC_SRAMDIS_DIS17_SHIFT                  (17U)
/*! DIS17 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS17(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS17_SHIFT)) & CMC_SRAMDIS_DIS17_MASK)

#define CMC_SRAMDIS_DIS18_MASK                   (0x40000U)
#define CMC_SRAMDIS_DIS18_SHIFT                  (18U)
/*! DIS18 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS18(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS18_SHIFT)) & CMC_SRAMDIS_DIS18_MASK)

#define CMC_SRAMDIS_DIS19_MASK                   (0x80000U)
#define CMC_SRAMDIS_DIS19_SHIFT                  (19U)
/*! DIS19 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS19(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS19_SHIFT)) & CMC_SRAMDIS_DIS19_MASK)

#define CMC_SRAMDIS_DIS20_MASK                   (0x100000U)
#define CMC_SRAMDIS_DIS20_SHIFT                  (20U)
/*! DIS20 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS20(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS20_SHIFT)) & CMC_SRAMDIS_DIS20_MASK)

#define CMC_SRAMDIS_DIS21_MASK                   (0x200000U)
#define CMC_SRAMDIS_DIS21_SHIFT                  (21U)
/*! DIS21 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS21(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS21_SHIFT)) & CMC_SRAMDIS_DIS21_MASK)

#define CMC_SRAMDIS_DIS22_MASK                   (0x400000U)
#define CMC_SRAMDIS_DIS22_SHIFT                  (22U)
/*! DIS22 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS22(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS22_SHIFT)) & CMC_SRAMDIS_DIS22_MASK)

#define CMC_SRAMDIS_DIS23_MASK                   (0x800000U)
#define CMC_SRAMDIS_DIS23_SHIFT                  (23U)
/*! DIS23 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS23(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS23_SHIFT)) & CMC_SRAMDIS_DIS23_MASK)

#define CMC_SRAMDIS_DIS24_MASK                   (0x1000000U)
#define CMC_SRAMDIS_DIS24_SHIFT                  (24U)
/*! DIS24 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS24(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS24_SHIFT)) & CMC_SRAMDIS_DIS24_MASK)

#define CMC_SRAMDIS_DIS25_MASK                   (0x2000000U)
#define CMC_SRAMDIS_DIS25_SHIFT                  (25U)
/*! DIS25 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS25(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS25_SHIFT)) & CMC_SRAMDIS_DIS25_MASK)

#define CMC_SRAMDIS_DIS26_MASK                   (0x4000000U)
#define CMC_SRAMDIS_DIS26_SHIFT                  (26U)
/*! DIS26 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS26(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS26_SHIFT)) & CMC_SRAMDIS_DIS26_MASK)

#define CMC_SRAMDIS_DIS27_MASK                   (0x8000000U)
#define CMC_SRAMDIS_DIS27_SHIFT                  (27U)
/*! DIS27 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS27(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS27_SHIFT)) & CMC_SRAMDIS_DIS27_MASK)

#define CMC_SRAMDIS_DIS28_MASK                   (0x10000000U)
#define CMC_SRAMDIS_DIS28_SHIFT                  (28U)
/*! DIS28 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS28(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS28_SHIFT)) & CMC_SRAMDIS_DIS28_MASK)

#define CMC_SRAMDIS_DIS29_MASK                   (0x20000000U)
#define CMC_SRAMDIS_DIS29_SHIFT                  (29U)
/*! DIS29 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS29(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS29_SHIFT)) & CMC_SRAMDIS_DIS29_MASK)

#define CMC_SRAMDIS_DIS30_MASK                   (0x40000000U)
#define CMC_SRAMDIS_DIS30_SHIFT                  (30U)
/*! DIS30 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS30(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS30_SHIFT)) & CMC_SRAMDIS_DIS30_MASK)

#define CMC_SRAMDIS_DIS31_MASK                   (0x80000000U)
#define CMC_SRAMDIS_DIS31_SHIFT                  (31U)
/*! DIS31 - SRAM Disable
 *  0b0..Enables
 *  0b1..Disables
 */
#define CMC_SRAMDIS_DIS31(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS31_SHIFT)) & CMC_SRAMDIS_DIS31_MASK)
/*! @} */

/* The count of CMC_SRAMDIS */
#define CMC_SRAMDIS_COUNT                        (1U)

/*! @name SRAMRET - SRAM Retention */
/*! @{ */

#define CMC_SRAMRET_RET0_MASK                    (0x1U)
#define CMC_SRAMRET_RET0_SHIFT                   (0U)
/*! RET0 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET0(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET0_SHIFT)) & CMC_SRAMRET_RET0_MASK)

#define CMC_SRAMRET_RET1_MASK                    (0x2U)
#define CMC_SRAMRET_RET1_SHIFT                   (1U)
/*! RET1 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET1(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET1_SHIFT)) & CMC_SRAMRET_RET1_MASK)

#define CMC_SRAMRET_RET2_MASK                    (0x4U)
#define CMC_SRAMRET_RET2_SHIFT                   (2U)
/*! RET2 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET2(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET2_SHIFT)) & CMC_SRAMRET_RET2_MASK)

#define CMC_SRAMRET_RET3_MASK                    (0x8U)
#define CMC_SRAMRET_RET3_SHIFT                   (3U)
/*! RET3 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET3(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET3_SHIFT)) & CMC_SRAMRET_RET3_MASK)

#define CMC_SRAMRET_RET4_MASK                    (0x10U)
#define CMC_SRAMRET_RET4_SHIFT                   (4U)
/*! RET4 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET4(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET4_SHIFT)) & CMC_SRAMRET_RET4_MASK)

#define CMC_SRAMRET_RET5_MASK                    (0x20U)
#define CMC_SRAMRET_RET5_SHIFT                   (5U)
/*! RET5 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET5(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET5_SHIFT)) & CMC_SRAMRET_RET5_MASK)

#define CMC_SRAMRET_RET6_MASK                    (0x40U)
#define CMC_SRAMRET_RET6_SHIFT                   (6U)
/*! RET6 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET6(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET6_SHIFT)) & CMC_SRAMRET_RET6_MASK)

#define CMC_SRAMRET_RET7_MASK                    (0x80U)
#define CMC_SRAMRET_RET7_SHIFT                   (7U)
/*! RET7 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET7(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET7_SHIFT)) & CMC_SRAMRET_RET7_MASK)

#define CMC_SRAMRET_RET8_MASK                    (0x100U)
#define CMC_SRAMRET_RET8_SHIFT                   (8U)
/*! RET8 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET8(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET8_SHIFT)) & CMC_SRAMRET_RET8_MASK)

#define CMC_SRAMRET_RET9_MASK                    (0x200U)
#define CMC_SRAMRET_RET9_SHIFT                   (9U)
/*! RET9 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET9(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET9_SHIFT)) & CMC_SRAMRET_RET9_MASK)

#define CMC_SRAMRET_RET10_MASK                   (0x400U)
#define CMC_SRAMRET_RET10_SHIFT                  (10U)
/*! RET10 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET10(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET10_SHIFT)) & CMC_SRAMRET_RET10_MASK)

#define CMC_SRAMRET_RET11_MASK                   (0x800U)
#define CMC_SRAMRET_RET11_SHIFT                  (11U)
/*! RET11 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET11(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET11_SHIFT)) & CMC_SRAMRET_RET11_MASK)

#define CMC_SRAMRET_RET12_MASK                   (0x1000U)
#define CMC_SRAMRET_RET12_SHIFT                  (12U)
/*! RET12 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET12(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET12_SHIFT)) & CMC_SRAMRET_RET12_MASK)

#define CMC_SRAMRET_RET13_MASK                   (0x2000U)
#define CMC_SRAMRET_RET13_SHIFT                  (13U)
/*! RET13 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET13(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET13_SHIFT)) & CMC_SRAMRET_RET13_MASK)

#define CMC_SRAMRET_RET14_MASK                   (0x4000U)
#define CMC_SRAMRET_RET14_SHIFT                  (14U)
/*! RET14 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET14(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET14_SHIFT)) & CMC_SRAMRET_RET14_MASK)

#define CMC_SRAMRET_RET15_MASK                   (0x8000U)
#define CMC_SRAMRET_RET15_SHIFT                  (15U)
/*! RET15 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET15(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET15_SHIFT)) & CMC_SRAMRET_RET15_MASK)

#define CMC_SRAMRET_RET16_MASK                   (0x10000U)
#define CMC_SRAMRET_RET16_SHIFT                  (16U)
/*! RET16 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET16(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET16_SHIFT)) & CMC_SRAMRET_RET16_MASK)

#define CMC_SRAMRET_RET17_MASK                   (0x20000U)
#define CMC_SRAMRET_RET17_SHIFT                  (17U)
/*! RET17 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET17(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET17_SHIFT)) & CMC_SRAMRET_RET17_MASK)

#define CMC_SRAMRET_RET18_MASK                   (0x40000U)
#define CMC_SRAMRET_RET18_SHIFT                  (18U)
/*! RET18 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET18(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET18_SHIFT)) & CMC_SRAMRET_RET18_MASK)

#define CMC_SRAMRET_RET19_MASK                   (0x80000U)
#define CMC_SRAMRET_RET19_SHIFT                  (19U)
/*! RET19 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET19(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET19_SHIFT)) & CMC_SRAMRET_RET19_MASK)

#define CMC_SRAMRET_RET20_MASK                   (0x100000U)
#define CMC_SRAMRET_RET20_SHIFT                  (20U)
/*! RET20 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET20(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET20_SHIFT)) & CMC_SRAMRET_RET20_MASK)

#define CMC_SRAMRET_RET21_MASK                   (0x200000U)
#define CMC_SRAMRET_RET21_SHIFT                  (21U)
/*! RET21 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET21(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET21_SHIFT)) & CMC_SRAMRET_RET21_MASK)

#define CMC_SRAMRET_RET22_MASK                   (0x400000U)
#define CMC_SRAMRET_RET22_SHIFT                  (22U)
/*! RET22 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET22(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET22_SHIFT)) & CMC_SRAMRET_RET22_MASK)

#define CMC_SRAMRET_RET23_MASK                   (0x800000U)
#define CMC_SRAMRET_RET23_SHIFT                  (23U)
/*! RET23 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET23(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET23_SHIFT)) & CMC_SRAMRET_RET23_MASK)

#define CMC_SRAMRET_RET24_MASK                   (0x1000000U)
#define CMC_SRAMRET_RET24_SHIFT                  (24U)
/*! RET24 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET24(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET24_SHIFT)) & CMC_SRAMRET_RET24_MASK)

#define CMC_SRAMRET_RET25_MASK                   (0x2000000U)
#define CMC_SRAMRET_RET25_SHIFT                  (25U)
/*! RET25 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET25(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET25_SHIFT)) & CMC_SRAMRET_RET25_MASK)

#define CMC_SRAMRET_RET26_MASK                   (0x4000000U)
#define CMC_SRAMRET_RET26_SHIFT                  (26U)
/*! RET26 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET26(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET26_SHIFT)) & CMC_SRAMRET_RET26_MASK)

#define CMC_SRAMRET_RET27_MASK                   (0x8000000U)
#define CMC_SRAMRET_RET27_SHIFT                  (27U)
/*! RET27 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET27(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET27_SHIFT)) & CMC_SRAMRET_RET27_MASK)

#define CMC_SRAMRET_RET28_MASK                   (0x10000000U)
#define CMC_SRAMRET_RET28_SHIFT                  (28U)
/*! RET28 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET28(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET28_SHIFT)) & CMC_SRAMRET_RET28_MASK)

#define CMC_SRAMRET_RET29_MASK                   (0x20000000U)
#define CMC_SRAMRET_RET29_SHIFT                  (29U)
/*! RET29 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET29(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET29_SHIFT)) & CMC_SRAMRET_RET29_MASK)

#define CMC_SRAMRET_RET30_MASK                   (0x40000000U)
#define CMC_SRAMRET_RET30_SHIFT                  (30U)
/*! RET30 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET30(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET30_SHIFT)) & CMC_SRAMRET_RET30_MASK)

#define CMC_SRAMRET_RET31_MASK                   (0x80000000U)
#define CMC_SRAMRET_RET31_SHIFT                  (31U)
/*! RET31 - SRAM Retention
 *  0b0..Retains
 *  0b1..Powers off
 */
#define CMC_SRAMRET_RET31(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET31_SHIFT)) & CMC_SRAMRET_RET31_MASK)
/*! @} */

/* The count of CMC_SRAMRET */
#define CMC_SRAMRET_COUNT                        (1U)

/*! @name FLASHCR - Flash Control */
/*! @{ */

#define CMC_FLASHCR_FLASHDIS_MASK                (0x1U)
#define CMC_FLASHCR_FLASHDIS_SHIFT               (0U)
/*! FLASHDIS - Flash Disable
 *  0b0..No effect
 *  0b1..Flash memory is disabled
 */
#define CMC_FLASHCR_FLASHDIS(x)                  (((uint32_t)(((uint32_t)(x)) << CMC_FLASHCR_FLASHDIS_SHIFT)) & CMC_FLASHCR_FLASHDIS_MASK)

#define CMC_FLASHCR_FLASHDOZE_MASK               (0x2U)
#define CMC_FLASHCR_FLASHDOZE_SHIFT              (1U)
/*! FLASHDOZE - Flash Doze
 *  0b0..No effect
 *  0b1..Flash memory is disabled when core is sleeping (CKMODE > 0)
 */
#define CMC_FLASHCR_FLASHDOZE(x)                 (((uint32_t)(((uint32_t)(x)) << CMC_FLASHCR_FLASHDOZE_SHIFT)) & CMC_FLASHCR_FLASHDOZE_MASK)
/*! @} */

/*! @name BSR - BootROM Status Register */
/*! @{ */

#define CMC_BSR_STAT_MASK                        (0xFFFFFFFFU)
#define CMC_BSR_STAT_SHIFT                       (0U)
/*! STAT - Provides status information written by the BootROM. */
#define CMC_BSR_STAT(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_BSR_STAT_SHIFT)) & CMC_BSR_STAT_MASK)
/*! @} */

/*! @name BLR - BootROM Lock Register */
/*! @{ */

#define CMC_BLR_LOCK_MASK                        (0x7U)
#define CMC_BLR_LOCK_SHIFT                       (0U)
/*! LOCK - Lock
 *  0b010..BootROM Status and Lock Registers can be written
 *  0b101..BootROM Status and Lock Registers cannot be written
 */
#define CMC_BLR_LOCK(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_BLR_LOCK_SHIFT)) & CMC_BLR_LOCK_MASK)
/*! @} */

/*! @name CORECTL - Core Control */
/*! @{ */

#define CMC_CORECTL_NPIE_MASK                    (0x1U)
#define CMC_CORECTL_NPIE_SHIFT                   (0U)
/*! NPIE - Non-maskable Pin Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define CMC_CORECTL_NPIE(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_CORECTL_NPIE_SHIFT)) & CMC_CORECTL_NPIE_MASK)
/*! @} */

/*! @name DBGCTL - Debug Control */
/*! @{ */

#define CMC_DBGCTL_SOD_MASK                      (0x1U)
#define CMC_DBGCTL_SOD_SHIFT                     (0U)
/*! SOD - Sleep Or Debug
 *  0b0..Remains enabled
 *  0b1..Disabled
 */
#define CMC_DBGCTL_SOD(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_DBGCTL_SOD_SHIFT)) & CMC_DBGCTL_SOD_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CMC_Register_Masks */


/* CMC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CMC0 base address */
  #define CMC0_BASE                                (0x50048000u)
  /** Peripheral CMC0 base address */
  #define CMC0_BASE_NS                             (0x40048000u)
  /** Peripheral CMC0 base pointer */
  #define CMC0                                     ((CMC_Type *)CMC0_BASE)
  /** Peripheral CMC0 base pointer */
  #define CMC0_NS                                  ((CMC_Type *)CMC0_BASE_NS)
  /** Array initializer of CMC peripheral base addresses */
  #define CMC_BASE_ADDRS                           { CMC0_BASE }
  /** Array initializer of CMC peripheral base pointers */
  #define CMC_BASE_PTRS                            { CMC0 }
  /** Array initializer of CMC peripheral base addresses */
  #define CMC_BASE_ADDRS_NS                        { CMC0_BASE_NS }
  /** Array initializer of CMC peripheral base pointers */
  #define CMC_BASE_PTRS_NS                         { CMC0_NS }
#else
  /** Peripheral CMC0 base address */
  #define CMC0_BASE                                (0x40048000u)
  /** Peripheral CMC0 base pointer */
  #define CMC0                                     ((CMC_Type *)CMC0_BASE)
  /** Array initializer of CMC peripheral base addresses */
  #define CMC_BASE_ADDRS                           { CMC0_BASE }
  /** Array initializer of CMC peripheral base pointers */
  #define CMC_BASE_PTRS                            { CMC0 }
#endif
/* Backward compatibility for CMC */
#define CMC_SRAMDIS_DIS_MASK                     (0xFFFFFFFFU)
#define CMC_SRAMDIS_DIS_SHIFT                    (0U)
/*! DIS - SRAM Disable */
#define CMC_SRAMDIS_DIS(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS_SHIFT)) & CMC_SRAMDIS_DIS_MASK)

#define CMC_SRAMRET_RET_MASK                     (0xFFFFFFFFU)
#define CMC_SRAMRET_RET_SHIFT                    (0U)
/*! RET - SRAM Retention */
#define CMC_SRAMRET_RET(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET_SHIFT)) & CMC_SRAMRET_RET_MASK)


/*!
 * @}
 */ /* end of group CMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    struct {                                         /* offset: 0x0 */
      __IO uint8_t DATALL;                             /**< CRC_DATALL register, offset: 0x0 */
      __IO uint8_t DATALU;                             /**< CRC_DATALU register, offset: 0x1 */
      __IO uint8_t DATAHL;                             /**< CRC_DATAHL register, offset: 0x2 */
      __IO uint8_t DATAHU;                             /**< CRC_DATAHU register, offset: 0x3 */
    } ACCESS8BIT;
    struct {                                         /* offset: 0x0 */
      __IO uint16_t DATAL;                             /**< CRC_DATAL register, offset: 0x0 */
      __IO uint16_t DATAH;                             /**< CRC_DATAH register, offset: 0x2 */
    } ACCESS16BIT;
    __IO uint32_t DATA;                              /**< CRC Data, offset: 0x0 */
  };
  union {                                          /* offset: 0x4 */
    struct {                                         /* offset: 0x4 */
      __IO uint8_t GPOLYLL;                            /**< CRC_GPOLYLL register, offset: 0x4 */
      __IO uint8_t GPOLYLU;                            /**< CRC_GPOLYLU register, offset: 0x5 */
      __IO uint8_t GPOLYHL;                            /**< CRC_GPOLYHL register, offset: 0x6 */
      __IO uint8_t GPOLYHU;                            /**< CRC_GPOLYHU register, offset: 0x7 */
    } GPOLY_ACCESS8BIT;
    struct {                                         /* offset: 0x4 */
      __IO uint16_t GPOLYL;                            /**< CRC_GPOLYL register, offset: 0x4 */
      __IO uint16_t GPOLYH;                            /**< CRC_GPOLYH register, offset: 0x6 */
    } GPOLY_ACCESS16BIT;
    __IO uint32_t GPOLY;                             /**< CRC Polynomial, offset: 0x4 */
  };
  union {                                          /* offset: 0x8 */
    struct {                                         /* offset: 0x8 */
           uint8_t RESERVED_0[3];
      __IO uint8_t CTRLHU;                             /**< CRC_CTRLHU register, offset: 0xB */
    } CTRL_ACCESS8BIT;
    __IO uint32_t CTRL;                              /**< CRC Control, offset: 0x8 */
  };
} CRC_Type;

/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/*! @name DATALL - CRC_DATALL register */
/*! @{ */

#define CRC_DATALL_DATALL_MASK                   (0xFFU)
#define CRC_DATALL_DATALL_SHIFT                  (0U)
#define CRC_DATALL_DATALL(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATALL_DATALL_SHIFT)) & CRC_DATALL_DATALL_MASK)
/*! @} */

/*! @name DATALU - CRC_DATALU register */
/*! @{ */

#define CRC_DATALU_DATALU_MASK                   (0xFFU)
#define CRC_DATALU_DATALU_SHIFT                  (0U)
#define CRC_DATALU_DATALU(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATALU_DATALU_SHIFT)) & CRC_DATALU_DATALU_MASK)
/*! @} */

/*! @name DATAHL - CRC_DATAHL register */
/*! @{ */

#define CRC_DATAHL_DATAHL_MASK                   (0xFFU)
#define CRC_DATAHL_DATAHL_SHIFT                  (0U)
#define CRC_DATAHL_DATAHL(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATAHL_DATAHL_SHIFT)) & CRC_DATAHL_DATAHL_MASK)
/*! @} */

/*! @name DATAHU - CRC_DATAHU register */
/*! @{ */

#define CRC_DATAHU_DATAHU_MASK                   (0xFFU)
#define CRC_DATAHU_DATAHU_SHIFT                  (0U)
#define CRC_DATAHU_DATAHU(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATAHU_DATAHU_SHIFT)) & CRC_DATAHU_DATAHU_MASK)
/*! @} */

/*! @name DATAL - CRC_DATAL register */
/*! @{ */

#define CRC_DATAL_DATAL_MASK                     (0xFFFFU)
#define CRC_DATAL_DATAL_SHIFT                    (0U)
#define CRC_DATAL_DATAL(x)                       (((uint16_t)(((uint16_t)(x)) << CRC_DATAL_DATAL_SHIFT)) & CRC_DATAL_DATAL_MASK)
/*! @} */

/*! @name DATAH - CRC_DATAH register */
/*! @{ */

#define CRC_DATAH_DATAH_MASK                     (0xFFFFU)
#define CRC_DATAH_DATAH_SHIFT                    (0U)
#define CRC_DATAH_DATAH(x)                       (((uint16_t)(((uint16_t)(x)) << CRC_DATAH_DATAH_SHIFT)) & CRC_DATAH_DATAH_MASK)
/*! @} */

/*! @name DATA - CRC Data */
/*! @{ */

#define CRC_DATA_LL_MASK                         (0xFFU)
#define CRC_DATA_LL_SHIFT                        (0U)
/*! LL - CRC Low Lower Byte */
#define CRC_DATA_LL(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_LL_SHIFT)) & CRC_DATA_LL_MASK)

#define CRC_DATA_LU_MASK                         (0xFF00U)
#define CRC_DATA_LU_SHIFT                        (8U)
/*! LU - CRC Low Upper Byte */
#define CRC_DATA_LU(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_LU_SHIFT)) & CRC_DATA_LU_MASK)

#define CRC_DATA_HL_MASK                         (0xFF0000U)
#define CRC_DATA_HL_SHIFT                        (16U)
/*! HL - CRC High Lower Byte */
#define CRC_DATA_HL(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_HL_SHIFT)) & CRC_DATA_HL_MASK)

#define CRC_DATA_HU_MASK                         (0xFF000000U)
#define CRC_DATA_HU_SHIFT                        (24U)
/*! HU - CRC High Upper Byte */
#define CRC_DATA_HU(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_HU_SHIFT)) & CRC_DATA_HU_MASK)
/*! @} */

/*! @name GPOLYLL - CRC_GPOLYLL register */
/*! @{ */

#define CRC_GPOLYLL_GPOLYLL_MASK                 (0xFFU)
#define CRC_GPOLYLL_GPOLYLL_SHIFT                (0U)
#define CRC_GPOLYLL_GPOLYLL(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYLL_GPOLYLL_SHIFT)) & CRC_GPOLYLL_GPOLYLL_MASK)
/*! @} */

/*! @name GPOLYLU - CRC_GPOLYLU register */
/*! @{ */

#define CRC_GPOLYLU_GPOLYLU_MASK                 (0xFFU)
#define CRC_GPOLYLU_GPOLYLU_SHIFT                (0U)
#define CRC_GPOLYLU_GPOLYLU(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYLU_GPOLYLU_SHIFT)) & CRC_GPOLYLU_GPOLYLU_MASK)
/*! @} */

/*! @name GPOLYHL - CRC_GPOLYHL register */
/*! @{ */

#define CRC_GPOLYHL_GPOLYHL_MASK                 (0xFFU)
#define CRC_GPOLYHL_GPOLYHL_SHIFT                (0U)
#define CRC_GPOLYHL_GPOLYHL(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYHL_GPOLYHL_SHIFT)) & CRC_GPOLYHL_GPOLYHL_MASK)
/*! @} */

/*! @name GPOLYHU - CRC_GPOLYHU register */
/*! @{ */

#define CRC_GPOLYHU_GPOLYHU_MASK                 (0xFFU)
#define CRC_GPOLYHU_GPOLYHU_SHIFT                (0U)
#define CRC_GPOLYHU_GPOLYHU(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYHU_GPOLYHU_SHIFT)) & CRC_GPOLYHU_GPOLYHU_MASK)
/*! @} */

/*! @name GPOLYL - CRC_GPOLYL register */
/*! @{ */

#define CRC_GPOLYL_GPOLYL_MASK                   (0xFFFFU)
#define CRC_GPOLYL_GPOLYL_SHIFT                  (0U)
#define CRC_GPOLYL_GPOLYL(x)                     (((uint16_t)(((uint16_t)(x)) << CRC_GPOLYL_GPOLYL_SHIFT)) & CRC_GPOLYL_GPOLYL_MASK)
/*! @} */

/*! @name GPOLYH - CRC_GPOLYH register */
/*! @{ */

#define CRC_GPOLYH_GPOLYH_MASK                   (0xFFFFU)
#define CRC_GPOLYH_GPOLYH_SHIFT                  (0U)
#define CRC_GPOLYH_GPOLYH(x)                     (((uint16_t)(((uint16_t)(x)) << CRC_GPOLYH_GPOLYH_SHIFT)) & CRC_GPOLYH_GPOLYH_MASK)
/*! @} */

/*! @name GPOLY - CRC Polynomial */
/*! @{ */

#define CRC_GPOLY_LOW_MASK                       (0xFFFFU)
#define CRC_GPOLY_LOW_SHIFT                      (0U)
/*! LOW - Low Polynomial Half-Word */
#define CRC_GPOLY_LOW(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_GPOLY_LOW_SHIFT)) & CRC_GPOLY_LOW_MASK)

#define CRC_GPOLY_HIGH_MASK                      (0xFFFF0000U)
#define CRC_GPOLY_HIGH_SHIFT                     (16U)
/*! HIGH - High Polynomial Half-Word */
#define CRC_GPOLY_HIGH(x)                        (((uint32_t)(((uint32_t)(x)) << CRC_GPOLY_HIGH_SHIFT)) & CRC_GPOLY_HIGH_MASK)
/*! @} */

/*! @name CTRLHU - CRC_CTRLHU register */
/*! @{ */

#define CRC_CTRLHU_TCRC_MASK                     (0x1U)
#define CRC_CTRLHU_TCRC_SHIFT                    (0U)
/*! TCRC - TCRC
 *  0b0..16-bit
 *  0b1..32-bit
 */
#define CRC_CTRLHU_TCRC(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TCRC_SHIFT)) & CRC_CTRLHU_TCRC_MASK)

#define CRC_CTRLHU_WAS_MASK                      (0x2U)
#define CRC_CTRLHU_WAS_SHIFT                     (1U)
/*! WAS - Write as Seed
 *  0b0..Data values
 *  0b1..Seed values
 */
#define CRC_CTRLHU_WAS(x)                        (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_WAS_SHIFT)) & CRC_CTRLHU_WAS_MASK)

#define CRC_CTRLHU_FXOR_MASK                     (0x4U)
#define CRC_CTRLHU_FXOR_SHIFT                    (2U)
/*! FXOR - Complement Read of CRC Data Register
 *  0b0..No XOR on reading
 *  0b1..Inverts or complements the read value of the CRC Data
 */
#define CRC_CTRLHU_FXOR(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_FXOR_SHIFT)) & CRC_CTRLHU_FXOR_MASK)

#define CRC_CTRLHU_TOTR_MASK                     (0x30U)
#define CRC_CTRLHU_TOTR_SHIFT                    (4U)
/*! TOTR - Transpose Type for Read
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed; bytes are not transposed
 *  0b10..Both bits in bytes and bytes are transposed
 *  0b11..Only bytes are transposed; no bits in a byte are transposed
 */
#define CRC_CTRLHU_TOTR(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TOTR_SHIFT)) & CRC_CTRLHU_TOTR_MASK)

#define CRC_CTRLHU_TOT_MASK                      (0xC0U)
#define CRC_CTRLHU_TOT_SHIFT                     (6U)
/*! TOT - Transpose Type for Writes
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed; bytes are not transposed
 *  0b10..Both bits in bytes and bytes are transposed
 *  0b11..Only bytes are transposed; no bits in a byte are transposed
 */
#define CRC_CTRLHU_TOT(x)                        (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TOT_SHIFT)) & CRC_CTRLHU_TOT_MASK)
/*! @} */

/*! @name CTRL - CRC Control */
/*! @{ */

#define CRC_CTRL_TCRC_MASK                       (0x1000000U)
#define CRC_CTRL_TCRC_SHIFT                      (24U)
/*! TCRC - TCRC
 *  0b0..16-bit
 *  0b1..32-bit
 */
#define CRC_CTRL_TCRC(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TCRC_SHIFT)) & CRC_CTRL_TCRC_MASK)

#define CRC_CTRL_WAS_MASK                        (0x2000000U)
#define CRC_CTRL_WAS_SHIFT                       (25U)
/*! WAS - Write as Seed
 *  0b0..Data values
 *  0b1..Seed values
 */
#define CRC_CTRL_WAS(x)                          (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_WAS_SHIFT)) & CRC_CTRL_WAS_MASK)

#define CRC_CTRL_FXOR_MASK                       (0x4000000U)
#define CRC_CTRL_FXOR_SHIFT                      (26U)
/*! FXOR - Complement Read of CRC Data Register
 *  0b0..No XOR on reading
 *  0b1..Inverts or complements the read value of the CRC Data
 */
#define CRC_CTRL_FXOR(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_FXOR_SHIFT)) & CRC_CTRL_FXOR_MASK)

#define CRC_CTRL_TOTR_MASK                       (0x30000000U)
#define CRC_CTRL_TOTR_SHIFT                      (28U)
/*! TOTR - Transpose Type for Read
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed; bytes are not transposed
 *  0b10..Both bits in bytes and bytes are transposed
 *  0b11..Only bytes are transposed; no bits in a byte are transposed
 */
#define CRC_CTRL_TOTR(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TOTR_SHIFT)) & CRC_CTRL_TOTR_MASK)

#define CRC_CTRL_TOT_MASK                        (0xC0000000U)
#define CRC_CTRL_TOT_SHIFT                       (30U)
/*! TOT - Transpose Type for Writes
 *  0b00..No transposition
 *  0b01..Bits in bytes are transposed; bytes are not transposed
 *  0b10..Both bits in bytes and bytes are transposed
 *  0b11..Only bytes are transposed; no bits in a byte are transposed
 */
#define CRC_CTRL_TOT(x)                          (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TOT_SHIFT)) & CRC_CTRL_TOT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CRC0 base address */
  #define CRC0_BASE                                (0x500CB000u)
  /** Peripheral CRC0 base address */
  #define CRC0_BASE_NS                             (0x400CB000u)
  /** Peripheral CRC0 base pointer */
  #define CRC0                                     ((CRC_Type *)CRC0_BASE)
  /** Peripheral CRC0 base pointer */
  #define CRC0_NS                                  ((CRC_Type *)CRC0_BASE_NS)
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS                           { CRC0_BASE }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS                            { CRC0 }
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS_NS                        { CRC0_BASE_NS }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS_NS                         { CRC0_NS }
#else
  /** Peripheral CRC0 base address */
  #define CRC0_BASE                                (0x400CB000u)
  /** Peripheral CRC0 base pointer */
  #define CRC0                                     ((CRC_Type *)CRC0_BASE)
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS                           { CRC0_BASE }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS                            { CRC0 }
#endif

/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Peripheral_Access_Layer CTIMER Peripheral Access Layer
 * @{
 */

/** CTIMER - Register Layout Typedef */
typedef struct {
  __IO uint32_t IR;                                /**< Interrupt, offset: 0x0 */
  __IO uint32_t TCR;                               /**< Timer Control, offset: 0x4 */
  __IO uint32_t TC;                                /**< Timer Counter, offset: 0x8 */
  __IO uint32_t PR;                                /**< Prescale, offset: 0xC */
  __IO uint32_t PC;                                /**< Prescale Counter, offset: 0x10 */
  __IO uint32_t MCR;                               /**< Match Control, offset: 0x14 */
  __IO uint32_t MR[4];                             /**< Match, array offset: 0x18, array step: 0x4 */
  __IO uint32_t CCR;                               /**< Capture Control, offset: 0x28 */
  __I  uint32_t CR[4];                             /**< Capture, array offset: 0x2C, array step: 0x4 */
  __IO uint32_t EMR;                               /**< External Match, offset: 0x3C */
       uint8_t RESERVED_0[48];
  __IO uint32_t CTCR;                              /**< Count Control, offset: 0x70 */
  __IO uint32_t PWMC;                              /**< PWM Control, offset: 0x74 */
  __IO uint32_t MSR[4];                            /**< Match Shadow, array offset: 0x78, array step: 0x4 */
} CTIMER_Type;

/* ----------------------------------------------------------------------------
   -- CTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Register_Masks CTIMER Register Masks
 * @{
 */

/*! @name IR - Interrupt */
/*! @{ */

#define CTIMER_IR_MR0INT_MASK                    (0x1U)
#define CTIMER_IR_MR0INT_SHIFT                   (0U)
/*! MR0INT - Interrupt Flag for Match Channel 0 Event */
#define CTIMER_IR_MR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR0INT_SHIFT)) & CTIMER_IR_MR0INT_MASK)

#define CTIMER_IR_MR1INT_MASK                    (0x2U)
#define CTIMER_IR_MR1INT_SHIFT                   (1U)
/*! MR1INT - Interrupt Flag for Match Channel 1 Event */
#define CTIMER_IR_MR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR1INT_SHIFT)) & CTIMER_IR_MR1INT_MASK)

#define CTIMER_IR_MR2INT_MASK                    (0x4U)
#define CTIMER_IR_MR2INT_SHIFT                   (2U)
/*! MR2INT - Interrupt Flag for Match Channel 2 Event */
#define CTIMER_IR_MR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR2INT_SHIFT)) & CTIMER_IR_MR2INT_MASK)

#define CTIMER_IR_MR3INT_MASK                    (0x8U)
#define CTIMER_IR_MR3INT_SHIFT                   (3U)
/*! MR3INT - Interrupt Flag for Match Channel 3 Event */
#define CTIMER_IR_MR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR3INT_SHIFT)) & CTIMER_IR_MR3INT_MASK)

#define CTIMER_IR_CR0INT_MASK                    (0x10U)
#define CTIMER_IR_CR0INT_SHIFT                   (4U)
/*! CR0INT - Interrupt Flag for Capture Channel 0 Event */
#define CTIMER_IR_CR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR0INT_SHIFT)) & CTIMER_IR_CR0INT_MASK)

#define CTIMER_IR_CR1INT_MASK                    (0x20U)
#define CTIMER_IR_CR1INT_SHIFT                   (5U)
/*! CR1INT - Interrupt Flag for Capture Channel 1 Event */
#define CTIMER_IR_CR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR1INT_SHIFT)) & CTIMER_IR_CR1INT_MASK)

#define CTIMER_IR_CR2INT_MASK                    (0x40U)
#define CTIMER_IR_CR2INT_SHIFT                   (6U)
/*! CR2INT - Interrupt Flag for Capture Channel 2 Event */
#define CTIMER_IR_CR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR2INT_SHIFT)) & CTIMER_IR_CR2INT_MASK)

#define CTIMER_IR_CR3INT_MASK                    (0x80U)
#define CTIMER_IR_CR3INT_SHIFT                   (7U)
/*! CR3INT - Interrupt Flag for Capture Channel 3 Event */
#define CTIMER_IR_CR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR3INT_SHIFT)) & CTIMER_IR_CR3INT_MASK)
/*! @} */

/*! @name TCR - Timer Control */
/*! @{ */

#define CTIMER_TCR_CEN_MASK                      (0x1U)
#define CTIMER_TCR_CEN_SHIFT                     (0U)
/*! CEN - Counter Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_CEN(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CEN_SHIFT)) & CTIMER_TCR_CEN_MASK)

#define CTIMER_TCR_CRST_MASK                     (0x2U)
#define CTIMER_TCR_CRST_SHIFT                    (1U)
/*! CRST - Counter Reset Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_CRST(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CRST_SHIFT)) & CTIMER_TCR_CRST_MASK)

#define CTIMER_TCR_AGCEN_MASK                    (0x10U)
#define CTIMER_TCR_AGCEN_SHIFT                   (4U)
/*! AGCEN - Allow Global Count Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_AGCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_AGCEN_SHIFT)) & CTIMER_TCR_AGCEN_MASK)

#define CTIMER_TCR_ATCEN_MASK                    (0x20U)
#define CTIMER_TCR_ATCEN_SHIFT                   (5U)
/*! ATCEN - Allow Trigger Count Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_TCR_ATCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_ATCEN_SHIFT)) & CTIMER_TCR_ATCEN_MASK)
/*! @} */

/*! @name TC - Timer Counter */
/*! @{ */

#define CTIMER_TC_TCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_TC_TCVAL_SHIFT                    (0U)
/*! TCVAL - Timer Counter Value */
#define CTIMER_TC_TCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TC_TCVAL_SHIFT)) & CTIMER_TC_TCVAL_MASK)
/*! @} */

/*! @name PR - Prescale */
/*! @{ */

#define CTIMER_PR_PRVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PR_PRVAL_SHIFT                    (0U)
/*! PRVAL - Prescale Reload Value */
#define CTIMER_PR_PRVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PR_PRVAL_SHIFT)) & CTIMER_PR_PRVAL_MASK)
/*! @} */

/*! @name PC - Prescale Counter */
/*! @{ */

#define CTIMER_PC_PCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PC_PCVAL_SHIFT                    (0U)
/*! PCVAL - Prescale Counter Value */
#define CTIMER_PC_PCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PC_PCVAL_SHIFT)) & CTIMER_PC_PCVAL_MASK)
/*! @} */

/*! @name MCR - Match Control */
/*! @{ */

#define CTIMER_MCR_MR0I_MASK                     (0x1U)
#define CTIMER_MCR_MR0I_SHIFT                    (0U)
/*! MR0I - Interrupt on MR0
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR0I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0I_SHIFT)) & CTIMER_MCR_MR0I_MASK)

#define CTIMER_MCR_MR0R_MASK                     (0x2U)
#define CTIMER_MCR_MR0R_SHIFT                    (1U)
/*! MR0R - Reset on MR0
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR0R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0R_SHIFT)) & CTIMER_MCR_MR0R_MASK)

#define CTIMER_MCR_MR0S_MASK                     (0x4U)
#define CTIMER_MCR_MR0S_SHIFT                    (2U)
/*! MR0S - Stop on MR0
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR0S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0S_SHIFT)) & CTIMER_MCR_MR0S_MASK)

#define CTIMER_MCR_MR1I_MASK                     (0x8U)
#define CTIMER_MCR_MR1I_SHIFT                    (3U)
/*! MR1I - Interrupt on MR1
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR1I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1I_SHIFT)) & CTIMER_MCR_MR1I_MASK)

#define CTIMER_MCR_MR1R_MASK                     (0x10U)
#define CTIMER_MCR_MR1R_SHIFT                    (4U)
/*! MR1R - Reset on MR1
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR1R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1R_SHIFT)) & CTIMER_MCR_MR1R_MASK)

#define CTIMER_MCR_MR1S_MASK                     (0x20U)
#define CTIMER_MCR_MR1S_SHIFT                    (5U)
/*! MR1S - Stop on MR1
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR1S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1S_SHIFT)) & CTIMER_MCR_MR1S_MASK)

#define CTIMER_MCR_MR2I_MASK                     (0x40U)
#define CTIMER_MCR_MR2I_SHIFT                    (6U)
/*! MR2I - Interrupt on MR2
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR2I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2I_SHIFT)) & CTIMER_MCR_MR2I_MASK)

#define CTIMER_MCR_MR2R_MASK                     (0x80U)
#define CTIMER_MCR_MR2R_SHIFT                    (7U)
/*! MR2R - Reset on MR2
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR2R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2R_SHIFT)) & CTIMER_MCR_MR2R_MASK)

#define CTIMER_MCR_MR2S_MASK                     (0x100U)
#define CTIMER_MCR_MR2S_SHIFT                    (8U)
/*! MR2S - Stop on MR2
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR2S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2S_SHIFT)) & CTIMER_MCR_MR2S_MASK)

#define CTIMER_MCR_MR3I_MASK                     (0x200U)
#define CTIMER_MCR_MR3I_SHIFT                    (9U)
/*! MR3I - Interrupt on MR3
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_MCR_MR3I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3I_SHIFT)) & CTIMER_MCR_MR3I_MASK)

#define CTIMER_MCR_MR3R_MASK                     (0x400U)
#define CTIMER_MCR_MR3R_SHIFT                    (10U)
/*! MR3R - Reset on MR3
 *  0b0..Does not reset
 *  0b1..Resets
 */
#define CTIMER_MCR_MR3R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3R_SHIFT)) & CTIMER_MCR_MR3R_MASK)

#define CTIMER_MCR_MR3S_MASK                     (0x800U)
#define CTIMER_MCR_MR3S_SHIFT                    (11U)
/*! MR3S - Stop on MR3
 *  0b0..Does not stop
 *  0b1..Stops
 */
#define CTIMER_MCR_MR3S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3S_SHIFT)) & CTIMER_MCR_MR3S_MASK)

#define CTIMER_MCR_MR0RL_MASK                    (0x1000000U)
#define CTIMER_MCR_MR0RL_SHIFT                   (24U)
/*! MR0RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR0RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0RL_SHIFT)) & CTIMER_MCR_MR0RL_MASK)

#define CTIMER_MCR_MR1RL_MASK                    (0x2000000U)
#define CTIMER_MCR_MR1RL_SHIFT                   (25U)
/*! MR1RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR1RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1RL_SHIFT)) & CTIMER_MCR_MR1RL_MASK)

#define CTIMER_MCR_MR2RL_MASK                    (0x4000000U)
#define CTIMER_MCR_MR2RL_SHIFT                   (26U)
/*! MR2RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR2RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2RL_SHIFT)) & CTIMER_MCR_MR2RL_MASK)

#define CTIMER_MCR_MR3RL_MASK                    (0x8000000U)
#define CTIMER_MCR_MR3RL_SHIFT                   (27U)
/*! MR3RL - Reload MR
 *  0b0..Does not reload
 *  0b1..Reloads
 */
#define CTIMER_MCR_MR3RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3RL_SHIFT)) & CTIMER_MCR_MR3RL_MASK)
/*! @} */

/*! @name MR - Match */
/*! @{ */

#define CTIMER_MR_MATCH_MASK                     (0xFFFFFFFFU)
#define CTIMER_MR_MATCH_SHIFT                    (0U)
/*! MATCH - Timer Counter Match Value */
#define CTIMER_MR_MATCH(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MR_MATCH_SHIFT)) & CTIMER_MR_MATCH_MASK)
/*! @} */

/* The count of CTIMER_MR */
#define CTIMER_MR_COUNT                          (4U)

/*! @name CCR - Capture Control */
/*! @{ */

#define CTIMER_CCR_CAP0RE_MASK                   (0x1U)
#define CTIMER_CCR_CAP0RE_SHIFT                  (0U)
/*! CAP0RE - Rising Edge of Capture Channel 0
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP0RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0RE_SHIFT)) & CTIMER_CCR_CAP0RE_MASK)

#define CTIMER_CCR_CAP0FE_MASK                   (0x2U)
#define CTIMER_CCR_CAP0FE_SHIFT                  (1U)
/*! CAP0FE - Falling Edge of Capture Channel 0
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP0FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0FE_SHIFT)) & CTIMER_CCR_CAP0FE_MASK)

#define CTIMER_CCR_CAP0I_MASK                    (0x4U)
#define CTIMER_CCR_CAP0I_SHIFT                   (2U)
/*! CAP0I - Generate Interrupt on Channel 0 Capture Event
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP0I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0I_SHIFT)) & CTIMER_CCR_CAP0I_MASK)

#define CTIMER_CCR_CAP1RE_MASK                   (0x8U)
#define CTIMER_CCR_CAP1RE_SHIFT                  (3U)
/*! CAP1RE - Rising Edge of Capture Channel 1
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP1RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1RE_SHIFT)) & CTIMER_CCR_CAP1RE_MASK)

#define CTIMER_CCR_CAP1FE_MASK                   (0x10U)
#define CTIMER_CCR_CAP1FE_SHIFT                  (4U)
/*! CAP1FE - Falling Edge of Capture Channel 1
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP1FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1FE_SHIFT)) & CTIMER_CCR_CAP1FE_MASK)

#define CTIMER_CCR_CAP1I_MASK                    (0x20U)
#define CTIMER_CCR_CAP1I_SHIFT                   (5U)
/*! CAP1I - Generate Interrupt on Channel 1 Capture Event
 *  0b0..Does not generates
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP1I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1I_SHIFT)) & CTIMER_CCR_CAP1I_MASK)

#define CTIMER_CCR_CAP2RE_MASK                   (0x40U)
#define CTIMER_CCR_CAP2RE_SHIFT                  (6U)
/*! CAP2RE - Rising Edge of Capture Channel 2
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP2RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2RE_SHIFT)) & CTIMER_CCR_CAP2RE_MASK)

#define CTIMER_CCR_CAP2FE_MASK                   (0x80U)
#define CTIMER_CCR_CAP2FE_SHIFT                  (7U)
/*! CAP2FE - Falling Edge of Capture Channel 2
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP2FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2FE_SHIFT)) & CTIMER_CCR_CAP2FE_MASK)

#define CTIMER_CCR_CAP2I_MASK                    (0x100U)
#define CTIMER_CCR_CAP2I_SHIFT                   (8U)
/*! CAP2I - Generate Interrupt on Channel 2 Capture Event
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP2I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2I_SHIFT)) & CTIMER_CCR_CAP2I_MASK)

#define CTIMER_CCR_CAP3RE_MASK                   (0x200U)
#define CTIMER_CCR_CAP3RE_SHIFT                  (9U)
/*! CAP3RE - Rising Edge of Capture Channel 3
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP3RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3RE_SHIFT)) & CTIMER_CCR_CAP3RE_MASK)

#define CTIMER_CCR_CAP3FE_MASK                   (0x400U)
#define CTIMER_CCR_CAP3FE_SHIFT                  (10U)
/*! CAP3FE - Falling Edge of Capture Channel 3
 *  0b0..Does not load
 *  0b1..Loads
 */
#define CTIMER_CCR_CAP3FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3FE_SHIFT)) & CTIMER_CCR_CAP3FE_MASK)

#define CTIMER_CCR_CAP3I_MASK                    (0x800U)
#define CTIMER_CCR_CAP3I_SHIFT                   (11U)
/*! CAP3I - Generate Interrupt on Channel 3 Capture Event
 *  0b0..Does not generate
 *  0b1..Generates
 */
#define CTIMER_CCR_CAP3I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3I_SHIFT)) & CTIMER_CCR_CAP3I_MASK)
/*! @} */

/*! @name CR - Capture */
/*! @{ */

#define CTIMER_CR_CAP_MASK                       (0xFFFFFFFFU)
#define CTIMER_CR_CAP_SHIFT                      (0U)
/*! CAP - Timer Counter Capture Value */
#define CTIMER_CR_CAP(x)                         (((uint32_t)(((uint32_t)(x)) << CTIMER_CR_CAP_SHIFT)) & CTIMER_CR_CAP_MASK)
/*! @} */

/* The count of CTIMER_CR */
#define CTIMER_CR_COUNT                          (4U)

/*! @name EMR - External Match */
/*! @{ */

#define CTIMER_EMR_EM0_MASK                      (0x1U)
#define CTIMER_EMR_EM0_SHIFT                     (0U)
/*! EM0 - External Match 0
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM0(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM0_SHIFT)) & CTIMER_EMR_EM0_MASK)

#define CTIMER_EMR_EM1_MASK                      (0x2U)
#define CTIMER_EMR_EM1_SHIFT                     (1U)
/*! EM1 - External Match 1
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM1(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM1_SHIFT)) & CTIMER_EMR_EM1_MASK)

#define CTIMER_EMR_EM2_MASK                      (0x4U)
#define CTIMER_EMR_EM2_SHIFT                     (2U)
/*! EM2 - External Match 2
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM2(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM2_SHIFT)) & CTIMER_EMR_EM2_MASK)

#define CTIMER_EMR_EM3_MASK                      (0x8U)
#define CTIMER_EMR_EM3_SHIFT                     (3U)
/*! EM3 - External Match 3
 *  0b0..Low
 *  0b1..High
 */
#define CTIMER_EMR_EM3(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM3_SHIFT)) & CTIMER_EMR_EM3_MASK)

#define CTIMER_EMR_EMC0_MASK                     (0x30U)
#define CTIMER_EMR_EMC0_SHIFT                    (4U)
/*! EMC0 - External Match Control 0
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC0(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC0_SHIFT)) & CTIMER_EMR_EMC0_MASK)

#define CTIMER_EMR_EMC1_MASK                     (0xC0U)
#define CTIMER_EMR_EMC1_SHIFT                    (6U)
/*! EMC1 - External Match Control 1
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC1(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC1_SHIFT)) & CTIMER_EMR_EMC1_MASK)

#define CTIMER_EMR_EMC2_MASK                     (0x300U)
#define CTIMER_EMR_EMC2_SHIFT                    (8U)
/*! EMC2 - External Match Control 2
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC2(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC2_SHIFT)) & CTIMER_EMR_EMC2_MASK)

#define CTIMER_EMR_EMC3_MASK                     (0xC00U)
#define CTIMER_EMR_EMC3_SHIFT                    (10U)
/*! EMC3 - External Match Control 3
 *  0b00..Does nothing
 *  0b01..Goes low
 *  0b10..Goes high
 *  0b11..Toggles
 */
#define CTIMER_EMR_EMC3(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC3_SHIFT)) & CTIMER_EMR_EMC3_MASK)
/*! @} */

/*! @name CTCR - Count Control */
/*! @{ */

#define CTIMER_CTCR_CTMODE_MASK                  (0x3U)
#define CTIMER_CTCR_CTMODE_SHIFT                 (0U)
/*! CTMODE - Counter Timer Mode
 *  0b00..Timer mode
 *  0b01..Counter mode rising edge
 *  0b10..Counter mode falling edge
 *  0b11..Counter mode dual edge
 */
#define CTIMER_CTCR_CTMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CTMODE_SHIFT)) & CTIMER_CTCR_CTMODE_MASK)

#define CTIMER_CTCR_CINSEL_MASK                  (0xCU)
#define CTIMER_CTCR_CINSEL_SHIFT                 (2U)
/*! CINSEL - Count Input Select
 *  0b00..Channel 0, CAPn[0] for CTIMERn
 *  0b01..Channel 1, CAPn[1] for CTIMERn
 *  0b10..Channel 2, CAPn[2] for CTIMERn
 *  0b11..Channel 3, CAPn[3] for CTIMERn
 */
#define CTIMER_CTCR_CINSEL(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CINSEL_SHIFT)) & CTIMER_CTCR_CINSEL_MASK)

#define CTIMER_CTCR_ENCC_MASK                    (0x10U)
#define CTIMER_CTCR_ENCC_SHIFT                   (4U)
/*! ENCC - Capture Channel Enable */
#define CTIMER_CTCR_ENCC(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_ENCC_SHIFT)) & CTIMER_CTCR_ENCC_MASK)

#define CTIMER_CTCR_SELCC_MASK                   (0xE0U)
#define CTIMER_CTCR_SELCC_SHIFT                  (5U)
/*! SELCC - Edge Select
 *  0b000..Capture channel 0 rising edge
 *  0b001..Capture channel 0 falling edge
 *  0b010..Capture channel 1 rising edge
 *  0b011..Capture channel 1 falling edge
 *  0b100..Capture channel 2 rising edge
 *  0b101..Capture channel 2 falling edge
 */
#define CTIMER_CTCR_SELCC(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_SELCC_SHIFT)) & CTIMER_CTCR_SELCC_MASK)
/*! @} */

/*! @name PWMC - PWM Control */
/*! @{ */

#define CTIMER_PWMC_PWMEN0_MASK                  (0x1U)
#define CTIMER_PWMC_PWMEN0_SHIFT                 (0U)
/*! PWMEN0 - PWM Mode Enable for Channel 0
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN0(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN0_SHIFT)) & CTIMER_PWMC_PWMEN0_MASK)

#define CTIMER_PWMC_PWMEN1_MASK                  (0x2U)
#define CTIMER_PWMC_PWMEN1_SHIFT                 (1U)
/*! PWMEN1 - PWM Mode Enable for Channel 1
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN1(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN1_SHIFT)) & CTIMER_PWMC_PWMEN1_MASK)

#define CTIMER_PWMC_PWMEN2_MASK                  (0x4U)
#define CTIMER_PWMC_PWMEN2_SHIFT                 (2U)
/*! PWMEN2 - PWM Mode Enable for Channel 2
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN2(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN2_SHIFT)) & CTIMER_PWMC_PWMEN2_MASK)

#define CTIMER_PWMC_PWMEN3_MASK                  (0x8U)
#define CTIMER_PWMC_PWMEN3_SHIFT                 (3U)
/*! PWMEN3 - PWM Mode Enable for Channel 3
 *  0b0..Disable
 *  0b1..Enable
 */
#define CTIMER_PWMC_PWMEN3(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN3_SHIFT)) & CTIMER_PWMC_PWMEN3_MASK)
/*! @} */

/*! @name MSR - Match Shadow */
/*! @{ */

#define CTIMER_MSR_MATCH_SHADOW_MASK             (0xFFFFFFFFU)
#define CTIMER_MSR_MATCH_SHADOW_SHIFT            (0U)
/*! MATCH_SHADOW - Timer Counter Match Shadow Value */
#define CTIMER_MSR_MATCH_SHADOW(x)               (((uint32_t)(((uint32_t)(x)) << CTIMER_MSR_MATCH_SHADOW_SHIFT)) & CTIMER_MSR_MATCH_SHADOW_MASK)
/*! @} */

/* The count of CTIMER_MSR */
#define CTIMER_MSR_COUNT                         (4U)


/*!
 * @}
 */ /* end of group CTIMER_Register_Masks */


/* CTIMER - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE                             (0x5000C000u)
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE_NS                          (0x4000C000u)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0_NS                               ((CTIMER_Type *)CTIMER0_BASE_NS)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE                             (0x5000D000u)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE_NS                          (0x4000D000u)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1_NS                               ((CTIMER_Type *)CTIMER1_BASE_NS)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE                             (0x5000E000u)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE_NS                          (0x4000E000u)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2_NS                               ((CTIMER_Type *)CTIMER2_BASE_NS)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE                             (0x5000F000u)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE_NS                          (0x4000F000u)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3_NS                               ((CTIMER_Type *)CTIMER3_BASE_NS)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE                             (0x50010000u)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE_NS                          (0x40010000u)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4_NS                               ((CTIMER_Type *)CTIMER4_BASE_NS)
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS_NS                     { CTIMER0_BASE_NS, CTIMER1_BASE_NS, CTIMER2_BASE_NS, CTIMER3_BASE_NS, CTIMER4_BASE_NS }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS_NS                      { CTIMER0_NS, CTIMER1_NS, CTIMER2_NS, CTIMER3_NS, CTIMER4_NS }
#else
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE                             (0x4000C000u)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE                             (0x4000D000u)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE                             (0x4000E000u)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE                             (0x4000F000u)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE                             (0x40010000u)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
#endif
/** Interrupt vectors for the CTIMER peripheral type */
#define CTIMER_IRQS                              { CTIMER0_IRQn, CTIMER1_IRQn, CTIMER2_IRQn, CTIMER3_IRQn, CTIMER4_IRQn }

/*!
 * @}
 */ /* end of group CTIMER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DIGTMP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DIGTMP_Peripheral_Access_Layer DIGTMP Peripheral Access Layer
 * @{
 */

/** DIGTMP - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t CR;                                /**< Control, offset: 0x10 */
  __IO uint32_t SR;                                /**< Status, offset: 0x14 */
  __IO uint32_t LR;                                /**< Lock, offset: 0x18 */
  __IO uint32_t IER;                               /**< Interrupt Enable, offset: 0x1C */
  __IO uint32_t TSR;                               /**< Tamper Seconds, offset: 0x20 */
  __IO uint32_t TER;                               /**< Tamper Enable, offset: 0x24 */
  __IO uint32_t PDR;                               /**< Pin Direction, offset: 0x28 */
  __IO uint32_t PPR;                               /**< Pin Polarity, offset: 0x2C */
  __IO uint32_t ATR[2];                            /**< Active Tamper, array offset: 0x30, array step: 0x4 */
       uint8_t RESERVED_1[8];
  __IO uint32_t PGFR[8];                           /**< Pin Glitch Filter, array offset: 0x40, array step: 0x4 */
} DIGTMP_Type;

/* ----------------------------------------------------------------------------
   -- DIGTMP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DIGTMP_Register_Masks DIGTMP Register Masks
 * @{
 */

/*! @name CR - Control */
/*! @{ */

#define DIGTMP_CR_SWR_MASK                       (0x1U)
#define DIGTMP_CR_SWR_SHIFT                      (0U)
/*! SWR - Software Reset
 *  0b0..No effect
 *  0b1..Perform a software reset
 */
#define DIGTMP_CR_SWR(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_SWR_SHIFT)) & DIGTMP_CR_SWR_MASK)

#define DIGTMP_CR_DEN_MASK                       (0x2U)
#define DIGTMP_CR_DEN_SHIFT                      (1U)
/*! DEN - Digital Tamper Enable
 *  0b0..Disables TDET clock and prescaler
 *  0b1..Enables TDET clock and prescaler
 */
#define DIGTMP_CR_DEN(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_DEN_SHIFT)) & DIGTMP_CR_DEN_MASK)

#define DIGTMP_CR_TFSR_MASK                      (0x4U)
#define DIGTMP_CR_TFSR_SHIFT                     (2U)
/*! TFSR - Tamper Force System Reset
 *  0b0..Do not force chip reset
 *  0b1..Force chip reset
 */
#define DIGTMP_CR_TFSR(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_TFSR_SHIFT)) & DIGTMP_CR_TFSR_MASK)

#define DIGTMP_CR_UM_MASK                        (0x8U)
#define DIGTMP_CR_UM_SHIFT                       (3U)
/*! UM - Update Mode
 *  0b0..No effect
 *  0b1..Allows the clearing of interrupts
 */
#define DIGTMP_CR_UM(x)                          (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_UM_SHIFT)) & DIGTMP_CR_UM_MASK)

#define DIGTMP_CR_ATCS0_MASK                     (0x10U)
#define DIGTMP_CR_ATCS0_SHIFT                    (4U)
/*! ATCS0 - Active Tamper Clock Source
 *  0b0..1 Hz prescaler clock
 *  0b1..64 Hz prescaler clock
 */
#define DIGTMP_CR_ATCS0(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_ATCS0_SHIFT)) & DIGTMP_CR_ATCS0_MASK)

#define DIGTMP_CR_ATCS1_MASK                     (0x20U)
#define DIGTMP_CR_ATCS1_SHIFT                    (5U)
/*! ATCS1 - Active Tamper Clock Source
 *  0b0..1 Hz prescaler clock
 *  0b1..64 Hz prescaler clock
 */
#define DIGTMP_CR_ATCS1(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_ATCS1_SHIFT)) & DIGTMP_CR_ATCS1_MASK)

#define DIGTMP_CR_DISTAM_MASK                    (0x100U)
#define DIGTMP_CR_DISTAM_SHIFT                   (8U)
/*! DISTAM - Disable Prescaler On Tamper
 *  0b0..No effect
 *  0b1..Automatically disables the prescaler after tamper detection
 */
#define DIGTMP_CR_DISTAM(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_DISTAM_SHIFT)) & DIGTMP_CR_DISTAM_MASK)

#define DIGTMP_CR_DPR_MASK                       (0xFFFE0000U)
#define DIGTMP_CR_DPR_SHIFT                      (17U)
/*! DPR - Digital Tamper Prescaler */
#define DIGTMP_CR_DPR(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_CR_DPR_SHIFT)) & DIGTMP_CR_DPR_MASK)
/*! @} */

/*! @name SR - Status */
/*! @{ */

#define DIGTMP_SR_DTF_MASK                       (0x1U)
#define DIGTMP_SR_DTF_SHIFT                      (0U)
/*! DTF - Digital Tamper Flag
 *  0b0..TDET tampering not detected
 *  0b1..TDET tampering detected
 */
#define DIGTMP_SR_DTF(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_DTF_SHIFT)) & DIGTMP_SR_DTF_MASK)

#define DIGTMP_SR_TAF_MASK                       (0x2U)
#define DIGTMP_SR_TAF_SHIFT                      (1U)
/*! TAF - Tamper Acknowledge Flag
 *  0b0..Digital Tamper Flag (SR[DTF]) is clear or chip reset has not occurred after Digital Tamper Flag (SR[DTF]) was set.
 *  0b1..Chip reset has occurred after Digital Tamper Flag (SR[DTF]) was set.
 */
#define DIGTMP_SR_TAF(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TAF_SHIFT)) & DIGTMP_SR_TAF_MASK)

#define DIGTMP_SR_TIF0_MASK                      (0x4U)
#define DIGTMP_SR_TIF0_SHIFT                     (2U)
/*! TIF0 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF0(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF0_SHIFT)) & DIGTMP_SR_TIF0_MASK)

#define DIGTMP_SR_TIF1_MASK                      (0x8U)
#define DIGTMP_SR_TIF1_SHIFT                     (3U)
/*! TIF1 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF1(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF1_SHIFT)) & DIGTMP_SR_TIF1_MASK)

#define DIGTMP_SR_TIF2_MASK                      (0x10U)
#define DIGTMP_SR_TIF2_SHIFT                     (4U)
/*! TIF2 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF2(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF2_SHIFT)) & DIGTMP_SR_TIF2_MASK)

#define DIGTMP_SR_TIF3_MASK                      (0x20U)
#define DIGTMP_SR_TIF3_SHIFT                     (5U)
/*! TIF3 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF3(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF3_SHIFT)) & DIGTMP_SR_TIF3_MASK)

#define DIGTMP_SR_TIF4_MASK                      (0x40U)
#define DIGTMP_SR_TIF4_SHIFT                     (6U)
/*! TIF4 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF4(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF4_SHIFT)) & DIGTMP_SR_TIF4_MASK)

#define DIGTMP_SR_TIF5_MASK                      (0x80U)
#define DIGTMP_SR_TIF5_SHIFT                     (7U)
/*! TIF5 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF5(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF5_SHIFT)) & DIGTMP_SR_TIF5_MASK)

#define DIGTMP_SR_TIF6_MASK                      (0x100U)
#define DIGTMP_SR_TIF6_SHIFT                     (8U)
/*! TIF6 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF6(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF6_SHIFT)) & DIGTMP_SR_TIF6_MASK)

#define DIGTMP_SR_TIF7_MASK                      (0x200U)
#define DIGTMP_SR_TIF7_SHIFT                     (9U)
/*! TIF7 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF7(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF7_SHIFT)) & DIGTMP_SR_TIF7_MASK)

#define DIGTMP_SR_TIF8_MASK                      (0x400U)
#define DIGTMP_SR_TIF8_SHIFT                     (10U)
/*! TIF8 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF8(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF8_SHIFT)) & DIGTMP_SR_TIF8_MASK)

#define DIGTMP_SR_TIF9_MASK                      (0x800U)
#define DIGTMP_SR_TIF9_SHIFT                     (11U)
/*! TIF9 - Tamper Input n Flag
 *  0b0..On-chip tamper not detected
 *  0b1..On-chip tamper detected
 */
#define DIGTMP_SR_TIF9(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TIF9_SHIFT)) & DIGTMP_SR_TIF9_MASK)

#define DIGTMP_SR_TPF0_MASK                      (0x10000U)
#define DIGTMP_SR_TPF0_SHIFT                     (16U)
/*! TPF0 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF0(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF0_SHIFT)) & DIGTMP_SR_TPF0_MASK)

#define DIGTMP_SR_TPF1_MASK                      (0x20000U)
#define DIGTMP_SR_TPF1_SHIFT                     (17U)
/*! TPF1 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF1(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF1_SHIFT)) & DIGTMP_SR_TPF1_MASK)

#define DIGTMP_SR_TPF2_MASK                      (0x40000U)
#define DIGTMP_SR_TPF2_SHIFT                     (18U)
/*! TPF2 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF2(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF2_SHIFT)) & DIGTMP_SR_TPF2_MASK)

#define DIGTMP_SR_TPF3_MASK                      (0x80000U)
#define DIGTMP_SR_TPF3_SHIFT                     (19U)
/*! TPF3 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF3(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF3_SHIFT)) & DIGTMP_SR_TPF3_MASK)

#define DIGTMP_SR_TPF4_MASK                      (0x100000U)
#define DIGTMP_SR_TPF4_SHIFT                     (20U)
/*! TPF4 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF4(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF4_SHIFT)) & DIGTMP_SR_TPF4_MASK)

#define DIGTMP_SR_TPF5_MASK                      (0x200000U)
#define DIGTMP_SR_TPF5_SHIFT                     (21U)
/*! TPF5 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF5(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF5_SHIFT)) & DIGTMP_SR_TPF5_MASK)

#define DIGTMP_SR_TPF6_MASK                      (0x400000U)
#define DIGTMP_SR_TPF6_SHIFT                     (22U)
/*! TPF6 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF6(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF6_SHIFT)) & DIGTMP_SR_TPF6_MASK)

#define DIGTMP_SR_TPF7_MASK                      (0x800000U)
#define DIGTMP_SR_TPF7_SHIFT                     (23U)
/*! TPF7 - Tamper Pin n Flag
 *  0b0..Pin tamper not detected
 *  0b1..Pin tamper detected
 */
#define DIGTMP_SR_TPF7(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_SR_TPF7_SHIFT)) & DIGTMP_SR_TPF7_MASK)
/*! @} */

/*! @name LR - Lock */
/*! @{ */

#define DIGTMP_LR_CRL_MASK                       (0x10U)
#define DIGTMP_LR_CRL_SHIFT                      (4U)
/*! CRL - Control Register Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_CRL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_CRL_SHIFT)) & DIGTMP_LR_CRL_MASK)

#define DIGTMP_LR_SRL_MASK                       (0x20U)
#define DIGTMP_LR_SRL_SHIFT                      (5U)
/*! SRL - Status Register Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_SRL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_SRL_SHIFT)) & DIGTMP_LR_SRL_MASK)

#define DIGTMP_LR_LRL_MASK                       (0x40U)
#define DIGTMP_LR_LRL_SHIFT                      (6U)
/*! LRL - Lock Register Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_LRL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_LRL_SHIFT)) & DIGTMP_LR_LRL_MASK)

#define DIGTMP_LR_IEL_MASK                       (0x80U)
#define DIGTMP_LR_IEL_SHIFT                      (7U)
/*! IEL - Interrupt Enable Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_IEL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_IEL_SHIFT)) & DIGTMP_LR_IEL_MASK)

#define DIGTMP_LR_TSL_MASK                       (0x100U)
#define DIGTMP_LR_TSL_SHIFT                      (8U)
/*! TSL - Tamper Seconds Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_TSL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_TSL_SHIFT)) & DIGTMP_LR_TSL_MASK)

#define DIGTMP_LR_TEL_MASK                       (0x200U)
#define DIGTMP_LR_TEL_SHIFT                      (9U)
/*! TEL - Tamper Enable Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_TEL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_TEL_SHIFT)) & DIGTMP_LR_TEL_MASK)

#define DIGTMP_LR_PDL_MASK                       (0x400U)
#define DIGTMP_LR_PDL_SHIFT                      (10U)
/*! PDL - Pin Direction Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_PDL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_PDL_SHIFT)) & DIGTMP_LR_PDL_MASK)

#define DIGTMP_LR_PPL_MASK                       (0x800U)
#define DIGTMP_LR_PPL_SHIFT                      (11U)
/*! PPL - Pin Polarity Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_PPL(x)                         (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_PPL_SHIFT)) & DIGTMP_LR_PPL_MASK)

#define DIGTMP_LR_ATL0_MASK                      (0x1000U)
#define DIGTMP_LR_ATL0_SHIFT                     (12U)
/*! ATL0 - Active Tamper Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_ATL0(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_ATL0_SHIFT)) & DIGTMP_LR_ATL0_MASK)

#define DIGTMP_LR_ATL1_MASK                      (0x2000U)
#define DIGTMP_LR_ATL1_SHIFT                     (13U)
/*! ATL1 - Active Tamper Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_ATL1(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_ATL1_SHIFT)) & DIGTMP_LR_ATL1_MASK)

#define DIGTMP_LR_GFL0_MASK                      (0x10000U)
#define DIGTMP_LR_GFL0_SHIFT                     (16U)
/*! GFL0 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL0(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL0_SHIFT)) & DIGTMP_LR_GFL0_MASK)

#define DIGTMP_LR_GFL1_MASK                      (0x20000U)
#define DIGTMP_LR_GFL1_SHIFT                     (17U)
/*! GFL1 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL1(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL1_SHIFT)) & DIGTMP_LR_GFL1_MASK)

#define DIGTMP_LR_GFL2_MASK                      (0x40000U)
#define DIGTMP_LR_GFL2_SHIFT                     (18U)
/*! GFL2 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL2(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL2_SHIFT)) & DIGTMP_LR_GFL2_MASK)

#define DIGTMP_LR_GFL3_MASK                      (0x80000U)
#define DIGTMP_LR_GFL3_SHIFT                     (19U)
/*! GFL3 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL3(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL3_SHIFT)) & DIGTMP_LR_GFL3_MASK)

#define DIGTMP_LR_GFL4_MASK                      (0x100000U)
#define DIGTMP_LR_GFL4_SHIFT                     (20U)
/*! GFL4 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL4(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL4_SHIFT)) & DIGTMP_LR_GFL4_MASK)

#define DIGTMP_LR_GFL5_MASK                      (0x200000U)
#define DIGTMP_LR_GFL5_SHIFT                     (21U)
/*! GFL5 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL5(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL5_SHIFT)) & DIGTMP_LR_GFL5_MASK)

#define DIGTMP_LR_GFL6_MASK                      (0x400000U)
#define DIGTMP_LR_GFL6_SHIFT                     (22U)
/*! GFL6 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL6(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL6_SHIFT)) & DIGTMP_LR_GFL6_MASK)

#define DIGTMP_LR_GFL7_MASK                      (0x800000U)
#define DIGTMP_LR_GFL7_SHIFT                     (23U)
/*! GFL7 - Glitch Filter Lock
 *  0b0..Locked and writes are ignored
 *  0b1..Not locked and writes complete as normal
 */
#define DIGTMP_LR_GFL7(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_LR_GFL7_SHIFT)) & DIGTMP_LR_GFL7_MASK)
/*! @} */

/*! @name IER - Interrupt Enable */
/*! @{ */

#define DIGTMP_IER_DTIE_MASK                     (0x1U)
#define DIGTMP_IER_DTIE_SHIFT                    (0U)
/*! DTIE - Digital Tamper Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_DTIE(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_DTIE_SHIFT)) & DIGTMP_IER_DTIE_MASK)

#define DIGTMP_IER_TIIE0_MASK                    (0x4U)
#define DIGTMP_IER_TIIE0_SHIFT                   (2U)
/*! TIIE0 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE0(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE0_SHIFT)) & DIGTMP_IER_TIIE0_MASK)

#define DIGTMP_IER_TIIE1_MASK                    (0x8U)
#define DIGTMP_IER_TIIE1_SHIFT                   (3U)
/*! TIIE1 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE1(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE1_SHIFT)) & DIGTMP_IER_TIIE1_MASK)

#define DIGTMP_IER_TIIE2_MASK                    (0x10U)
#define DIGTMP_IER_TIIE2_SHIFT                   (4U)
/*! TIIE2 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE2(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE2_SHIFT)) & DIGTMP_IER_TIIE2_MASK)

#define DIGTMP_IER_TIIE3_MASK                    (0x20U)
#define DIGTMP_IER_TIIE3_SHIFT                   (5U)
/*! TIIE3 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE3(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE3_SHIFT)) & DIGTMP_IER_TIIE3_MASK)

#define DIGTMP_IER_TIIE4_MASK                    (0x40U)
#define DIGTMP_IER_TIIE4_SHIFT                   (6U)
/*! TIIE4 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE4(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE4_SHIFT)) & DIGTMP_IER_TIIE4_MASK)

#define DIGTMP_IER_TIIE5_MASK                    (0x80U)
#define DIGTMP_IER_TIIE5_SHIFT                   (7U)
/*! TIIE5 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE5(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE5_SHIFT)) & DIGTMP_IER_TIIE5_MASK)

#define DIGTMP_IER_TIIE6_MASK                    (0x100U)
#define DIGTMP_IER_TIIE6_SHIFT                   (8U)
/*! TIIE6 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE6(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE6_SHIFT)) & DIGTMP_IER_TIIE6_MASK)

#define DIGTMP_IER_TIIE7_MASK                    (0x200U)
#define DIGTMP_IER_TIIE7_SHIFT                   (9U)
/*! TIIE7 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE7(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE7_SHIFT)) & DIGTMP_IER_TIIE7_MASK)

#define DIGTMP_IER_TIIE8_MASK                    (0x400U)
#define DIGTMP_IER_TIIE8_SHIFT                   (10U)
/*! TIIE8 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE8(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE8_SHIFT)) & DIGTMP_IER_TIIE8_MASK)

#define DIGTMP_IER_TIIE9_MASK                    (0x800U)
#define DIGTMP_IER_TIIE9_SHIFT                   (11U)
/*! TIIE9 - Tamper Input n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TIIE9(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TIIE9_SHIFT)) & DIGTMP_IER_TIIE9_MASK)

#define DIGTMP_IER_TPIE0_MASK                    (0x10000U)
#define DIGTMP_IER_TPIE0_SHIFT                   (16U)
/*! TPIE0 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE0(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE0_SHIFT)) & DIGTMP_IER_TPIE0_MASK)

#define DIGTMP_IER_TPIE1_MASK                    (0x20000U)
#define DIGTMP_IER_TPIE1_SHIFT                   (17U)
/*! TPIE1 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE1(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE1_SHIFT)) & DIGTMP_IER_TPIE1_MASK)

#define DIGTMP_IER_TPIE2_MASK                    (0x40000U)
#define DIGTMP_IER_TPIE2_SHIFT                   (18U)
/*! TPIE2 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE2(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE2_SHIFT)) & DIGTMP_IER_TPIE2_MASK)

#define DIGTMP_IER_TPIE3_MASK                    (0x80000U)
#define DIGTMP_IER_TPIE3_SHIFT                   (19U)
/*! TPIE3 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE3(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE3_SHIFT)) & DIGTMP_IER_TPIE3_MASK)

#define DIGTMP_IER_TPIE4_MASK                    (0x100000U)
#define DIGTMP_IER_TPIE4_SHIFT                   (20U)
/*! TPIE4 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE4(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE4_SHIFT)) & DIGTMP_IER_TPIE4_MASK)

#define DIGTMP_IER_TPIE5_MASK                    (0x200000U)
#define DIGTMP_IER_TPIE5_SHIFT                   (21U)
/*! TPIE5 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE5(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE5_SHIFT)) & DIGTMP_IER_TPIE5_MASK)

#define DIGTMP_IER_TPIE6_MASK                    (0x400000U)
#define DIGTMP_IER_TPIE6_SHIFT                   (22U)
/*! TPIE6 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE6(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE6_SHIFT)) & DIGTMP_IER_TPIE6_MASK)

#define DIGTMP_IER_TPIE7_MASK                    (0x800000U)
#define DIGTMP_IER_TPIE7_SHIFT                   (23U)
/*! TPIE7 - Tamper Pin n Interrupt Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_IER_TPIE7(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_IER_TPIE7_SHIFT)) & DIGTMP_IER_TPIE7_MASK)
/*! @} */

/*! @name TSR - Tamper Seconds */
/*! @{ */

#define DIGTMP_TSR_TTS_MASK                      (0xFFFFFFFFU)
#define DIGTMP_TSR_TTS_SHIFT                     (0U)
/*! TTS - Tamper Time Seconds */
#define DIGTMP_TSR_TTS(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_TSR_TTS_SHIFT)) & DIGTMP_TSR_TTS_MASK)
/*! @} */

/*! @name TER - Tamper Enable */
/*! @{ */

#define DIGTMP_TER_TIE0_MASK                     (0x4U)
#define DIGTMP_TER_TIE0_SHIFT                    (2U)
/*! TIE0 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE0(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE0_SHIFT)) & DIGTMP_TER_TIE0_MASK)

#define DIGTMP_TER_TIE1_MASK                     (0x8U)
#define DIGTMP_TER_TIE1_SHIFT                    (3U)
/*! TIE1 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE1(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE1_SHIFT)) & DIGTMP_TER_TIE1_MASK)

#define DIGTMP_TER_TIE2_MASK                     (0x10U)
#define DIGTMP_TER_TIE2_SHIFT                    (4U)
/*! TIE2 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE2(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE2_SHIFT)) & DIGTMP_TER_TIE2_MASK)

#define DIGTMP_TER_TIE3_MASK                     (0x20U)
#define DIGTMP_TER_TIE3_SHIFT                    (5U)
/*! TIE3 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE3(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE3_SHIFT)) & DIGTMP_TER_TIE3_MASK)

#define DIGTMP_TER_TIE4_MASK                     (0x40U)
#define DIGTMP_TER_TIE4_SHIFT                    (6U)
/*! TIE4 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE4(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE4_SHIFT)) & DIGTMP_TER_TIE4_MASK)

#define DIGTMP_TER_TIE5_MASK                     (0x80U)
#define DIGTMP_TER_TIE5_SHIFT                    (7U)
/*! TIE5 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE5(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE5_SHIFT)) & DIGTMP_TER_TIE5_MASK)

#define DIGTMP_TER_TIE6_MASK                     (0x100U)
#define DIGTMP_TER_TIE6_SHIFT                    (8U)
/*! TIE6 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE6(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE6_SHIFT)) & DIGTMP_TER_TIE6_MASK)

#define DIGTMP_TER_TIE7_MASK                     (0x200U)
#define DIGTMP_TER_TIE7_SHIFT                    (9U)
/*! TIE7 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE7(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE7_SHIFT)) & DIGTMP_TER_TIE7_MASK)

#define DIGTMP_TER_TIE8_MASK                     (0x400U)
#define DIGTMP_TER_TIE8_SHIFT                    (10U)
/*! TIE8 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE8(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE8_SHIFT)) & DIGTMP_TER_TIE8_MASK)

#define DIGTMP_TER_TIE9_MASK                     (0x800U)
#define DIGTMP_TER_TIE9_SHIFT                    (11U)
/*! TIE9 - Tamper Input Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TIE9(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TIE9_SHIFT)) & DIGTMP_TER_TIE9_MASK)

#define DIGTMP_TER_TPE0_MASK                     (0x10000U)
#define DIGTMP_TER_TPE0_SHIFT                    (16U)
/*! TPE0 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE0(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE0_SHIFT)) & DIGTMP_TER_TPE0_MASK)

#define DIGTMP_TER_TPE1_MASK                     (0x20000U)
#define DIGTMP_TER_TPE1_SHIFT                    (17U)
/*! TPE1 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE1(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE1_SHIFT)) & DIGTMP_TER_TPE1_MASK)

#define DIGTMP_TER_TPE2_MASK                     (0x40000U)
#define DIGTMP_TER_TPE2_SHIFT                    (18U)
/*! TPE2 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE2(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE2_SHIFT)) & DIGTMP_TER_TPE2_MASK)

#define DIGTMP_TER_TPE3_MASK                     (0x80000U)
#define DIGTMP_TER_TPE3_SHIFT                    (19U)
/*! TPE3 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE3(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE3_SHIFT)) & DIGTMP_TER_TPE3_MASK)

#define DIGTMP_TER_TPE4_MASK                     (0x100000U)
#define DIGTMP_TER_TPE4_SHIFT                    (20U)
/*! TPE4 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE4(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE4_SHIFT)) & DIGTMP_TER_TPE4_MASK)

#define DIGTMP_TER_TPE5_MASK                     (0x200000U)
#define DIGTMP_TER_TPE5_SHIFT                    (21U)
/*! TPE5 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE5(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE5_SHIFT)) & DIGTMP_TER_TPE5_MASK)

#define DIGTMP_TER_TPE6_MASK                     (0x400000U)
#define DIGTMP_TER_TPE6_SHIFT                    (22U)
/*! TPE6 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE6(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE6_SHIFT)) & DIGTMP_TER_TPE6_MASK)

#define DIGTMP_TER_TPE7_MASK                     (0x800000U)
#define DIGTMP_TER_TPE7_SHIFT                    (23U)
/*! TPE7 - Tamper Pin Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_TER_TPE7(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_TER_TPE7_SHIFT)) & DIGTMP_TER_TPE7_MASK)
/*! @} */

/*! @name PDR - Pin Direction */
/*! @{ */

#define DIGTMP_PDR_TPD0_MASK                     (0x1U)
#define DIGTMP_PDR_TPD0_SHIFT                    (0U)
/*! TPD0 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD0(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD0_SHIFT)) & DIGTMP_PDR_TPD0_MASK)

#define DIGTMP_PDR_TPD1_MASK                     (0x2U)
#define DIGTMP_PDR_TPD1_SHIFT                    (1U)
/*! TPD1 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD1(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD1_SHIFT)) & DIGTMP_PDR_TPD1_MASK)

#define DIGTMP_PDR_TPD2_MASK                     (0x4U)
#define DIGTMP_PDR_TPD2_SHIFT                    (2U)
/*! TPD2 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD2(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD2_SHIFT)) & DIGTMP_PDR_TPD2_MASK)

#define DIGTMP_PDR_TPD3_MASK                     (0x8U)
#define DIGTMP_PDR_TPD3_SHIFT                    (3U)
/*! TPD3 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD3(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD3_SHIFT)) & DIGTMP_PDR_TPD3_MASK)

#define DIGTMP_PDR_TPD4_MASK                     (0x10U)
#define DIGTMP_PDR_TPD4_SHIFT                    (4U)
/*! TPD4 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD4(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD4_SHIFT)) & DIGTMP_PDR_TPD4_MASK)

#define DIGTMP_PDR_TPD5_MASK                     (0x20U)
#define DIGTMP_PDR_TPD5_SHIFT                    (5U)
/*! TPD5 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD5(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD5_SHIFT)) & DIGTMP_PDR_TPD5_MASK)

#define DIGTMP_PDR_TPD6_MASK                     (0x40U)
#define DIGTMP_PDR_TPD6_SHIFT                    (6U)
/*! TPD6 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD6(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD6_SHIFT)) & DIGTMP_PDR_TPD6_MASK)

#define DIGTMP_PDR_TPD7_MASK                     (0x80U)
#define DIGTMP_PDR_TPD7_SHIFT                    (7U)
/*! TPD7 - Tamper Pin Direction
 *  0b0..Input
 *  0b1..Output and drives the inverse of the expected value (tamper pin is asserted)
 */
#define DIGTMP_PDR_TPD7(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPD7_SHIFT)) & DIGTMP_PDR_TPD7_MASK)

#define DIGTMP_PDR_TPOD0_MASK                    (0x10000U)
#define DIGTMP_PDR_TPOD0_SHIFT                   (16U)
/*! TPOD0 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD0(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD0_SHIFT)) & DIGTMP_PDR_TPOD0_MASK)

#define DIGTMP_PDR_TPOD1_MASK                    (0x20000U)
#define DIGTMP_PDR_TPOD1_SHIFT                   (17U)
/*! TPOD1 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD1(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD1_SHIFT)) & DIGTMP_PDR_TPOD1_MASK)

#define DIGTMP_PDR_TPOD2_MASK                    (0x40000U)
#define DIGTMP_PDR_TPOD2_SHIFT                   (18U)
/*! TPOD2 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD2(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD2_SHIFT)) & DIGTMP_PDR_TPOD2_MASK)

#define DIGTMP_PDR_TPOD3_MASK                    (0x80000U)
#define DIGTMP_PDR_TPOD3_SHIFT                   (19U)
/*! TPOD3 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD3(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD3_SHIFT)) & DIGTMP_PDR_TPOD3_MASK)

#define DIGTMP_PDR_TPOD4_MASK                    (0x100000U)
#define DIGTMP_PDR_TPOD4_SHIFT                   (20U)
/*! TPOD4 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD4(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD4_SHIFT)) & DIGTMP_PDR_TPOD4_MASK)

#define DIGTMP_PDR_TPOD5_MASK                    (0x200000U)
#define DIGTMP_PDR_TPOD5_SHIFT                   (21U)
/*! TPOD5 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD5(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD5_SHIFT)) & DIGTMP_PDR_TPOD5_MASK)

#define DIGTMP_PDR_TPOD6_MASK                    (0x400000U)
#define DIGTMP_PDR_TPOD6_SHIFT                   (22U)
/*! TPOD6 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD6(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD6_SHIFT)) & DIGTMP_PDR_TPOD6_MASK)

#define DIGTMP_PDR_TPOD7_MASK                    (0x800000U)
#define DIGTMP_PDR_TPOD7_SHIFT                   (23U)
/*! TPOD7 - Tamper Pin Output Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PDR_TPOD7(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PDR_TPOD7_SHIFT)) & DIGTMP_PDR_TPOD7_MASK)
/*! @} */

/*! @name PPR - Pin Polarity */
/*! @{ */

#define DIGTMP_PPR_TPP0_MASK                     (0x1U)
#define DIGTMP_PPR_TPP0_SHIFT                    (0U)
/*! TPP0 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP0(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP0_SHIFT)) & DIGTMP_PPR_TPP0_MASK)

#define DIGTMP_PPR_TPP1_MASK                     (0x2U)
#define DIGTMP_PPR_TPP1_SHIFT                    (1U)
/*! TPP1 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP1(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP1_SHIFT)) & DIGTMP_PPR_TPP1_MASK)

#define DIGTMP_PPR_TPP2_MASK                     (0x4U)
#define DIGTMP_PPR_TPP2_SHIFT                    (2U)
/*! TPP2 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP2(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP2_SHIFT)) & DIGTMP_PPR_TPP2_MASK)

#define DIGTMP_PPR_TPP3_MASK                     (0x8U)
#define DIGTMP_PPR_TPP3_SHIFT                    (3U)
/*! TPP3 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP3(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP3_SHIFT)) & DIGTMP_PPR_TPP3_MASK)

#define DIGTMP_PPR_TPP4_MASK                     (0x10U)
#define DIGTMP_PPR_TPP4_SHIFT                    (4U)
/*! TPP4 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP4(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP4_SHIFT)) & DIGTMP_PPR_TPP4_MASK)

#define DIGTMP_PPR_TPP5_MASK                     (0x20U)
#define DIGTMP_PPR_TPP5_SHIFT                    (5U)
/*! TPP5 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP5(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP5_SHIFT)) & DIGTMP_PPR_TPP5_MASK)

#define DIGTMP_PPR_TPP6_MASK                     (0x40U)
#define DIGTMP_PPR_TPP6_SHIFT                    (6U)
/*! TPP6 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP6(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP6_SHIFT)) & DIGTMP_PPR_TPP6_MASK)

#define DIGTMP_PPR_TPP7_MASK                     (0x80U)
#define DIGTMP_PPR_TPP7_SHIFT                    (7U)
/*! TPP7 - Tamper Pin n Polarity
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define DIGTMP_PPR_TPP7(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPP7_SHIFT)) & DIGTMP_PPR_TPP7_MASK)

#define DIGTMP_PPR_TPID0_MASK                    (0x10000U)
#define DIGTMP_PPR_TPID0_SHIFT                   (16U)
/*! TPID0 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID0(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID0_SHIFT)) & DIGTMP_PPR_TPID0_MASK)

#define DIGTMP_PPR_TPID1_MASK                    (0x20000U)
#define DIGTMP_PPR_TPID1_SHIFT                   (17U)
/*! TPID1 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID1(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID1_SHIFT)) & DIGTMP_PPR_TPID1_MASK)

#define DIGTMP_PPR_TPID2_MASK                    (0x40000U)
#define DIGTMP_PPR_TPID2_SHIFT                   (18U)
/*! TPID2 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID2(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID2_SHIFT)) & DIGTMP_PPR_TPID2_MASK)

#define DIGTMP_PPR_TPID3_MASK                    (0x80000U)
#define DIGTMP_PPR_TPID3_SHIFT                   (19U)
/*! TPID3 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID3(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID3_SHIFT)) & DIGTMP_PPR_TPID3_MASK)

#define DIGTMP_PPR_TPID4_MASK                    (0x100000U)
#define DIGTMP_PPR_TPID4_SHIFT                   (20U)
/*! TPID4 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID4(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID4_SHIFT)) & DIGTMP_PPR_TPID4_MASK)

#define DIGTMP_PPR_TPID5_MASK                    (0x200000U)
#define DIGTMP_PPR_TPID5_SHIFT                   (21U)
/*! TPID5 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID5(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID5_SHIFT)) & DIGTMP_PPR_TPID5_MASK)

#define DIGTMP_PPR_TPID6_MASK                    (0x400000U)
#define DIGTMP_PPR_TPID6_SHIFT                   (22U)
/*! TPID6 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID6(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID6_SHIFT)) & DIGTMP_PPR_TPID6_MASK)

#define DIGTMP_PPR_TPID7_MASK                    (0x800000U)
#define DIGTMP_PPR_TPID7_SHIFT                   (23U)
/*! TPID7 - Tamper Pin n Input Data
 *  0b0..Zero
 *  0b1..One
 */
#define DIGTMP_PPR_TPID7(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PPR_TPID7_SHIFT)) & DIGTMP_PPR_TPID7_MASK)
/*! @} */

/*! @name ATR - Active Tamper */
/*! @{ */

#define DIGTMP_ATR_ATSR_MASK                     (0xFFFFU)
#define DIGTMP_ATR_ATSR_SHIFT                    (0U)
/*! ATSR - Active Tamper Shift Register */
#define DIGTMP_ATR_ATSR(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_ATR_ATSR_SHIFT)) & DIGTMP_ATR_ATSR_MASK)

#define DIGTMP_ATR_ATP_MASK                      (0xFFFF0000U)
#define DIGTMP_ATR_ATP_SHIFT                     (16U)
/*! ATP - Active Tamper Polynomial */
#define DIGTMP_ATR_ATP(x)                        (((uint32_t)(((uint32_t)(x)) << DIGTMP_ATR_ATP_SHIFT)) & DIGTMP_ATR_ATP_MASK)
/*! @} */

/* The count of DIGTMP_ATR */
#define DIGTMP_ATR_COUNT                         (2U)

/*! @name PGFR - Pin Glitch Filter */
/*! @{ */

#define DIGTMP_PGFR_GFW_MASK                     (0x3FU)
#define DIGTMP_PGFR_GFW_SHIFT                    (0U)
/*! GFW - Glitch Filter Width */
#define DIGTMP_PGFR_GFW(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_GFW_SHIFT)) & DIGTMP_PGFR_GFW_MASK)

#define DIGTMP_PGFR_GFP_MASK                     (0x40U)
#define DIGTMP_PGFR_GFP_SHIFT                    (6U)
/*! GFP - Glitch Filter Prescaler
 *  0b0..512 Hz prescaler clock
 *  0b1..32.768 kHz clock
 */
#define DIGTMP_PGFR_GFP(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_GFP_SHIFT)) & DIGTMP_PGFR_GFP_MASK)

#define DIGTMP_PGFR_GFE_MASK                     (0x80U)
#define DIGTMP_PGFR_GFE_SHIFT                    (7U)
/*! GFE - Glitch Filter Enable
 *  0b0..Bypasses
 *  0b1..Enables
 */
#define DIGTMP_PGFR_GFE(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_GFE_SHIFT)) & DIGTMP_PGFR_GFE_MASK)

#define DIGTMP_PGFR_TPSW_MASK                    (0x300U)
#define DIGTMP_PGFR_TPSW_SHIFT                   (8U)
/*! TPSW - Tamper Pin Sample Width
 *  0b00..Continuous monitoring, pin sampling disabled
 *  0b01..2 cycles for pull enable and 1 cycle for input buffer enable
 *  0b10..4 cycles for pull enable and 2 cycles for input buffer enable
 *  0b11..8 cycles for pull enable and 4 cycles for input buffer enable
 */
#define DIGTMP_PGFR_TPSW(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_TPSW_SHIFT)) & DIGTMP_PGFR_TPSW_MASK)

#define DIGTMP_PGFR_TPSF_MASK                    (0xC00U)
#define DIGTMP_PGFR_TPSF_SHIFT                   (10U)
/*! TPSF - Tamper Pin Sample Frequency
 *  0b00..Every 8 cycles
 *  0b01..Every 32 cycles
 *  0b10..Every 128 cycles
 *  0b11..Every 512 cycles
 */
#define DIGTMP_PGFR_TPSF(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_TPSF_SHIFT)) & DIGTMP_PGFR_TPSF_MASK)

#define DIGTMP_PGFR_TPEX_MASK                    (0x30000U)
#define DIGTMP_PGFR_TPEX_SHIFT                   (16U)
/*! TPEX - Tamper Pin Expected
 *  0b00..Zero/passive tamper
 *  0b01..Active Tamper 0 output
 *  0b10..Active Tamper 1 output
 *  0b11..Active Tamper 0 output XORed with Active Tamper 1 output
 */
#define DIGTMP_PGFR_TPEX(x)                      (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_TPEX_SHIFT)) & DIGTMP_PGFR_TPEX_MASK)

#define DIGTMP_PGFR_TPE_MASK                     (0x1000000U)
#define DIGTMP_PGFR_TPE_SHIFT                    (24U)
/*! TPE - Tamper Pull Enable
 *  0b0..Disables
 *  0b1..Enables
 */
#define DIGTMP_PGFR_TPE(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_TPE_SHIFT)) & DIGTMP_PGFR_TPE_MASK)

#define DIGTMP_PGFR_TPS_MASK                     (0x2000000U)
#define DIGTMP_PGFR_TPS_SHIFT                    (25U)
/*! TPS - Tamper Pull Select
 *  0b0..Asserts
 *  0b1..Negates
 */
#define DIGTMP_PGFR_TPS(x)                       (((uint32_t)(((uint32_t)(x)) << DIGTMP_PGFR_TPS_SHIFT)) & DIGTMP_PGFR_TPS_MASK)
/*! @} */

/* The count of DIGTMP_PGFR */
#define DIGTMP_PGFR_COUNT                        (8U)


/*!
 * @}
 */ /* end of group DIGTMP_Register_Masks */


/* DIGTMP - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral TDET0 base address */
  #define TDET0_BASE                               (0x50058000u)
  /** Peripheral TDET0 base address */
  #define TDET0_BASE_NS                            (0x40058000u)
  /** Peripheral TDET0 base pointer */
  #define TDET0                                    ((DIGTMP_Type *)TDET0_BASE)
  /** Peripheral TDET0 base pointer */
  #define TDET0_NS                                 ((DIGTMP_Type *)TDET0_BASE_NS)
  /** Array initializer of DIGTMP peripheral base addresses */
  #define DIGTMP_BASE_ADDRS                        { TDET0_BASE }
  /** Array initializer of DIGTMP peripheral base pointers */
  #define DIGTMP_BASE_PTRS                         { TDET0 }
  /** Array initializer of DIGTMP peripheral base addresses */
  #define DIGTMP_BASE_ADDRS_NS                     { TDET0_BASE_NS }
  /** Array initializer of DIGTMP peripheral base pointers */
  #define DIGTMP_BASE_PTRS_NS                      { TDET0_NS }
#else
  /** Peripheral TDET0 base address */
  #define TDET0_BASE                               (0x40058000u)
  /** Peripheral TDET0 base pointer */
  #define TDET0                                    ((DIGTMP_Type *)TDET0_BASE)
  /** Array initializer of DIGTMP peripheral base addresses */
  #define DIGTMP_BASE_ADDRS                        { TDET0_BASE }
  /** Array initializer of DIGTMP peripheral base pointers */
  #define DIGTMP_BASE_PTRS                         { TDET0 }
#endif

/*!
 * @}
 */ /* end of group DIGTMP_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DM_Peripheral_Access_Layer DM Peripheral Access Layer
 * @{
 */

/** DM - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSW;                               /**< Command and Status Word, offset: 0x0 */
  __IO uint32_t REQUEST;                           /**< Request Value, offset: 0x4 */
  __IO uint32_t RETURN;                            /**< Return Value, offset: 0x8 */
       uint8_t RESERVED_0[240];
  __I  uint32_t ID;                                /**< Identification, offset: 0xFC */
} DM_Type;

/* ----------------------------------------------------------------------------
   -- DM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DM_Register_Masks DM Register Masks
 * @{
 */

/*! @name CSW - Command and Status Word */
/*! @{ */

#define DM_CSW_RESYNCH_REQ_MASK                  (0x1U)
#define DM_CSW_RESYNCH_REQ_SHIFT                 (0U)
/*! RESYNCH_REQ - Resynchronization Request
 *  0b0..No request
 *  0b1..Request for resynchronization
 */
#define DM_CSW_RESYNCH_REQ(x)                    (((uint32_t)(((uint32_t)(x)) << DM_CSW_RESYNCH_REQ_SHIFT)) & DM_CSW_RESYNCH_REQ_MASK)

#define DM_CSW_REQ_PENDING_MASK                  (0x2U)
#define DM_CSW_REQ_PENDING_SHIFT                 (1U)
/*! REQ_PENDING - Request Pending
 *  0b0..No request pending
 *  0b1..Request for resynchronization pending
 */
#define DM_CSW_REQ_PENDING(x)                    (((uint32_t)(((uint32_t)(x)) << DM_CSW_REQ_PENDING_SHIFT)) & DM_CSW_REQ_PENDING_MASK)

#define DM_CSW_DBG_OR_ERR_MASK                   (0x4U)
#define DM_CSW_DBG_OR_ERR_SHIFT                  (2U)
/*! DBG_OR_ERR - DBGMB Overrun Error
 *  0b0..No DBGMB Overrun error
 *  0b1..DBGMB overrun error. A DBGMB overrun occurred.
 */
#define DM_CSW_DBG_OR_ERR(x)                     (((uint32_t)(((uint32_t)(x)) << DM_CSW_DBG_OR_ERR_SHIFT)) & DM_CSW_DBG_OR_ERR_MASK)

#define DM_CSW_AHB_OR_ERR_MASK                   (0x8U)
#define DM_CSW_AHB_OR_ERR_SHIFT                  (3U)
/*! AHB_OR_ERR - AHB Overrun Error
 *  0b0..No AHB Overrun Error
 *  0b1..AHB Overrun Error. An AHB overrun occurred.
 */
#define DM_CSW_AHB_OR_ERR(x)                     (((uint32_t)(((uint32_t)(x)) << DM_CSW_AHB_OR_ERR_SHIFT)) & DM_CSW_AHB_OR_ERR_MASK)

#define DM_CSW_SOFT_RESET_MASK                   (0x10U)
#define DM_CSW_SOFT_RESET_SHIFT                  (4U)
/*! SOFT_RESET - Soft Reset */
#define DM_CSW_SOFT_RESET(x)                     (((uint32_t)(((uint32_t)(x)) << DM_CSW_SOFT_RESET_SHIFT)) & DM_CSW_SOFT_RESET_MASK)

#define DM_CSW_CHIP_RESET_REQ_MASK               (0x20U)
#define DM_CSW_CHIP_RESET_REQ_SHIFT              (5U)
/*! CHIP_RESET_REQ - Chip Reset Request */
#define DM_CSW_CHIP_RESET_REQ(x)                 (((uint32_t)(((uint32_t)(x)) << DM_CSW_CHIP_RESET_REQ_SHIFT)) & DM_CSW_CHIP_RESET_REQ_MASK)
/*! @} */

/*! @name REQUEST - Request Value */
/*! @{ */

#define DM_REQUEST_REQUEST_MASK                  (0xFFFFFFFFU)
#define DM_REQUEST_REQUEST_SHIFT                 (0U)
/*! REQUEST - Request Value */
#define DM_REQUEST_REQUEST(x)                    (((uint32_t)(((uint32_t)(x)) << DM_REQUEST_REQUEST_SHIFT)) & DM_REQUEST_REQUEST_MASK)
/*! @} */

/*! @name RETURN - Return Value */
/*! @{ */

#define DM_RETURN_RET_MASK                       (0xFFFFFFFFU)
#define DM_RETURN_RET_SHIFT                      (0U)
/*! RET - Return Value */
#define DM_RETURN_RET(x)                         (((uint32_t)(((uint32_t)(x)) << DM_RETURN_RET_SHIFT)) & DM_RETURN_RET_MASK)
/*! @} */

/*! @name ID - Identification */
/*! @{ */

#define DM_ID_ID_MASK                            (0xFFFFFFFFU)
#define DM_ID_ID_SHIFT                           (0U)
/*! ID - Identification Value */
#define DM_ID_ID(x)                              (((uint32_t)(((uint32_t)(x)) << DM_ID_ID_SHIFT)) & DM_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DM_Register_Masks */


/* DM - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DM0 base address */
  #define DM0_BASE                                 (0x500BD000u)
  /** Peripheral DM0 base address */
  #define DM0_BASE_NS                              (0x400BD000u)
  /** Peripheral DM0 base pointer */
  #define DM0                                      ((DM_Type *)DM0_BASE)
  /** Peripheral DM0 base pointer */
  #define DM0_NS                                   ((DM_Type *)DM0_BASE_NS)
  /** Array initializer of DM peripheral base addresses */
  #define DM_BASE_ADDRS                            { DM0_BASE }
  /** Array initializer of DM peripheral base pointers */
  #define DM_BASE_PTRS                             { DM0 }
  /** Array initializer of DM peripheral base addresses */
  #define DM_BASE_ADDRS_NS                         { DM0_BASE_NS }
  /** Array initializer of DM peripheral base pointers */
  #define DM_BASE_PTRS_NS                          { DM0_NS }
#else
  /** Peripheral DM0 base address */
  #define DM0_BASE                                 (0x400BD000u)
  /** Peripheral DM0 base pointer */
  #define DM0                                      ((DM_Type *)DM0_BASE)
  /** Array initializer of DM peripheral base addresses */
  #define DM_BASE_ADDRS                            { DM0_BASE }
  /** Array initializer of DM peripheral base pointers */
  #define DM_BASE_PTRS                             { DM0 }
#endif

/*!
 * @}
 */ /* end of group DM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t MP_CSR;                            /**< Management Page Control, offset: 0x0 */
  __I  uint32_t MP_ES;                             /**< Management Page Error Status, offset: 0x4 */
  __I  uint32_t MP_INT;                            /**< Management Page Interrupt Request Status, offset: 0x8 */
  __I  uint32_t MP_HRS;                            /**< Management Page Hardware Request Status, offset: 0xC */
       uint8_t RESERVED_0[240];
  __IO uint32_t CH_GRPRI[16];                      /**< Channel Arbitration Group, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_1[3776];
  struct {                                         /* offset: 0x1000, array step: 0x1000 */
    __IO uint32_t CH_CSR;                            /**< Channel Control and Status, array offset: 0x1000, array step: 0x1000 */
    __IO uint32_t CH_ES;                             /**< Channel Error Status, array offset: 0x1004, array step: 0x1000 */
    __IO uint32_t CH_INT;                            /**< Channel Interrupt Status, array offset: 0x1008, array step: 0x1000 */
    __IO uint32_t CH_SBR;                            /**< Channel System Bus, array offset: 0x100C, array step: 0x1000 */
    __IO uint32_t CH_PRI;                            /**< Channel Priority, array offset: 0x1010, array step: 0x1000 */
    __IO uint32_t CH_MUX;                            /**< Channel Multiplexor Configuration, array offset: 0x1014, array step: 0x1000 */
         uint8_t RESERVED_0[8];
    __IO uint32_t TCD_SADDR;                         /**< TCD Source Address, array offset: 0x1020, array step: 0x1000 */
    __IO uint16_t TCD_SOFF;                          /**< TCD Signed Source Address Offset, array offset: 0x1024, array step: 0x1000 */
    __IO uint16_t TCD_ATTR;                          /**< TCD Transfer Attributes, array offset: 0x1026, array step: 0x1000 */
    union {                                          /* offset: 0x1028, array step: 0x1000 */
      __IO uint32_t TCD_NBYTES_MLOFFNO;                /**< TCD Transfer Size Without Minor Loop Offsets, array offset: 0x1028, array step: 0x1000 */
      __IO uint32_t TCD_NBYTES_MLOFFYES;               /**< TCD Transfer Size with Minor Loop Offsets, array offset: 0x1028, array step: 0x1000 */
    };
    __IO uint32_t TCD_SLAST_SDA;                     /**< TCD Last Source Address Adjustment / Store DADDR Address, array offset: 0x102C, array step: 0x1000 */
    __IO uint32_t TCD_DADDR;                         /**< TCD Destination Address, array offset: 0x1030, array step: 0x1000 */
    __IO uint16_t TCD_DOFF;                          /**< TCD Signed Destination Address Offset, array offset: 0x1034, array step: 0x1000 */
    union {                                          /* offset: 0x1036, array step: 0x1000 */
      __IO uint16_t TCD_CITER_ELINKNO;                 /**< TCD Current Major Loop Count (Minor Loop Channel Linking Disabled), array offset: 0x1036, array step: 0x1000 */
      __IO uint16_t TCD_CITER_ELINKYES;                /**< TCD Current Major Loop Count (Minor Loop Channel Linking Enabled), array offset: 0x1036, array step: 0x1000 */
    };
    __IO uint32_t TCD_DLAST_SGA;                     /**< TCD Last Destination Address Adjustment / Scatter Gather Address, array offset: 0x1038, array step: 0x1000 */
    __IO uint16_t TCD_CSR;                           /**< TCD Control and Status, array offset: 0x103C, array step: 0x1000 */
    union {                                          /* offset: 0x103E, array step: 0x1000 */
      __IO uint16_t TCD_BITER_ELINKNO;                 /**< TCD Beginning Major Loop Count (Minor Loop Channel Linking Disabled), array offset: 0x103E, array step: 0x1000 */
      __IO uint16_t TCD_BITER_ELINKYES;                /**< TCD Beginning Major Loop Count (Minor Loop Channel Linking Enabled), array offset: 0x103E, array step: 0x1000 */
    };
         uint8_t RESERVED_1[4032];
  } CH[16];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name MP_CSR - Management Page Control */
/*! @{ */

#define DMA_MP_CSR_EDBG_MASK                     (0x2U)
#define DMA_MP_CSR_EDBG_SHIFT                    (1U)
/*! EDBG - Enable Debug
 *  0b0..Debug mode disabled
 *  0b1..Debug mode is enabled.
 */
#define DMA_MP_CSR_EDBG(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_EDBG_SHIFT)) & DMA_MP_CSR_EDBG_MASK)

#define DMA_MP_CSR_ERCA_MASK                     (0x4U)
#define DMA_MP_CSR_ERCA_SHIFT                    (2U)
/*! ERCA - Enable Round Robin Channel Arbitration
 *  0b0..Round-robin channel arbitration disabled
 *  0b1..Round-robin channel arbitration enabled
 */
#define DMA_MP_CSR_ERCA(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ERCA_SHIFT)) & DMA_MP_CSR_ERCA_MASK)

#define DMA_MP_CSR_HAE_MASK                      (0x10U)
#define DMA_MP_CSR_HAE_SHIFT                     (4U)
/*! HAE - Halt After Error
 *  0b0..Normal operation
 *  0b1..Any error causes the HALT field to be set to 1
 */
#define DMA_MP_CSR_HAE(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_HAE_SHIFT)) & DMA_MP_CSR_HAE_MASK)

#define DMA_MP_CSR_HALT_MASK                     (0x20U)
#define DMA_MP_CSR_HALT_SHIFT                    (5U)
/*! HALT - Halt DMA Operations
 *  0b0..Normal operation
 *  0b1..Stall the start of any new channels
 */
#define DMA_MP_CSR_HALT(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_HALT_SHIFT)) & DMA_MP_CSR_HALT_MASK)

#define DMA_MP_CSR_GCLC_MASK                     (0x40U)
#define DMA_MP_CSR_GCLC_SHIFT                    (6U)
/*! GCLC - Global Channel Linking Control
 *  0b0..Channel linking disabled for all channels
 *  0b1..Channel linking available and controlled by each channel's link settings
 */
#define DMA_MP_CSR_GCLC(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_GCLC_SHIFT)) & DMA_MP_CSR_GCLC_MASK)

#define DMA_MP_CSR_GMRC_MASK                     (0x80U)
#define DMA_MP_CSR_GMRC_SHIFT                    (7U)
/*! GMRC - Global Master ID Replication Control
 *  0b0..Master ID replication disabled for all channels
 *  0b1..Master ID replication available and controlled by each channel's CHn_SBR[EMI] setting
 */
#define DMA_MP_CSR_GMRC(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_GMRC_SHIFT)) & DMA_MP_CSR_GMRC_MASK)

#define DMA_MP_CSR_ECX_MASK                      (0x100U)
#define DMA_MP_CSR_ECX_SHIFT                     (8U)
/*! ECX - Cancel Transfer With Error
 *  0b0..Normal operation
 *  0b1..Cancel the remaining data transfer
 */
#define DMA_MP_CSR_ECX(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ECX_SHIFT)) & DMA_MP_CSR_ECX_MASK)

#define DMA_MP_CSR_CX_MASK                       (0x200U)
#define DMA_MP_CSR_CX_SHIFT                      (9U)
/*! CX - Cancel Transfer
 *  0b0..Normal operation
 *  0b1..Cancel the remaining data transfer
 */
#define DMA_MP_CSR_CX(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_CX_SHIFT)) & DMA_MP_CSR_CX_MASK)

#define DMA_MP_CSR_ACTIVE_ID_MASK                (0xF000000U)
#define DMA_MP_CSR_ACTIVE_ID_SHIFT               (24U)
/*! ACTIVE_ID - Active Channel ID */
#define DMA_MP_CSR_ACTIVE_ID(x)                  (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ACTIVE_ID_SHIFT)) & DMA_MP_CSR_ACTIVE_ID_MASK)

#define DMA_MP_CSR_ACTIVE_MASK                   (0x80000000U)
#define DMA_MP_CSR_ACTIVE_SHIFT                  (31U)
/*! ACTIVE - DMA Active Status
 *  0b0..eDMA is idle
 *  0b1..eDMA is executing a channel
 */
#define DMA_MP_CSR_ACTIVE(x)                     (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ACTIVE_SHIFT)) & DMA_MP_CSR_ACTIVE_MASK)
/*! @} */

/*! @name MP_ES - Management Page Error Status */
/*! @{ */

#define DMA_MP_ES_DBE_MASK                       (0x1U)
#define DMA_MP_ES_DBE_SHIFT                      (0U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error
 *  0b1..Last recorded error was a bus error on a destination write
 */
#define DMA_MP_ES_DBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DBE_SHIFT)) & DMA_MP_ES_DBE_MASK)

#define DMA_MP_ES_SBE_MASK                       (0x2U)
#define DMA_MP_ES_SBE_SHIFT                      (1U)
/*! SBE - Source Bus Error
 *  0b0..No source bus error
 *  0b1..Last recorded error was a bus error on a source read
 */
#define DMA_MP_ES_SBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SBE_SHIFT)) & DMA_MP_ES_SBE_MASK)

#define DMA_MP_ES_SGE_MASK                       (0x4U)
#define DMA_MP_ES_SGE_SHIFT                      (2U)
/*! SGE - Scatter/Gather Configuration Error
 *  0b0..No scatter/gather configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DLAST_SGA field
 */
#define DMA_MP_ES_SGE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SGE_SHIFT)) & DMA_MP_ES_SGE_MASK)

#define DMA_MP_ES_NCE_MASK                       (0x8U)
#define DMA_MP_ES_NCE_SHIFT                      (3U)
/*! NCE - NBYTES/CITER Configuration Error
 *  0b0..No NBYTES/CITER configuration error
 *  0b1..The last recorded error was NBYTES equal to zero or a CITER not equal to BITER error
 */
#define DMA_MP_ES_NCE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_NCE_SHIFT)) & DMA_MP_ES_NCE_MASK)

#define DMA_MP_ES_DOE_MASK                       (0x10U)
#define DMA_MP_ES_DOE_SHIFT                      (4U)
/*! DOE - Destination Offset Error
 *  0b0..No destination offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DOFF field
 */
#define DMA_MP_ES_DOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DOE_SHIFT)) & DMA_MP_ES_DOE_MASK)

#define DMA_MP_ES_DAE_MASK                       (0x20U)
#define DMA_MP_ES_DAE_SHIFT                      (5U)
/*! DAE - Destination Address Error
 *  0b0..No destination address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DADDR field
 */
#define DMA_MP_ES_DAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DAE_SHIFT)) & DMA_MP_ES_DAE_MASK)

#define DMA_MP_ES_SOE_MASK                       (0x40U)
#define DMA_MP_ES_SOE_SHIFT                      (6U)
/*! SOE - Source Offset Error
 *  0b0..No source offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SOFF field
 */
#define DMA_MP_ES_SOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SOE_SHIFT)) & DMA_MP_ES_SOE_MASK)

#define DMA_MP_ES_SAE_MASK                       (0x80U)
#define DMA_MP_ES_SAE_SHIFT                      (7U)
/*! SAE - Source Address Error
 *  0b0..No source address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SADDR field
 */
#define DMA_MP_ES_SAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SAE_SHIFT)) & DMA_MP_ES_SAE_MASK)

#define DMA_MP_ES_ECX_MASK                       (0x100U)
#define DMA_MP_ES_ECX_SHIFT                      (8U)
/*! ECX - Transfer Canceled
 *  0b0..No canceled transfers
 *  0b1..Last recorded entry was a canceled transfer by the error cancel transfer input
 */
#define DMA_MP_ES_ECX(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_ECX_SHIFT)) & DMA_MP_ES_ECX_MASK)

#define DMA_MP_ES_ERRCHN_MASK                    (0xF000000U)
#define DMA_MP_ES_ERRCHN_SHIFT                   (24U)
/*! ERRCHN - Error Channel Number or Canceled Channel Number */
#define DMA_MP_ES_ERRCHN(x)                      (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_ERRCHN_SHIFT)) & DMA_MP_ES_ERRCHN_MASK)

#define DMA_MP_ES_VLD_MASK                       (0x80000000U)
#define DMA_MP_ES_VLD_SHIFT                      (31U)
/*! VLD - Valid
 *  0b0..No CHn_ES[ERR] fields are set to 1
 *  0b1..At least one CHn_ES[ERR] field is set to 1, indicating a valid error exists that software has not cleared
 */
#define DMA_MP_ES_VLD(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_VLD_SHIFT)) & DMA_MP_ES_VLD_MASK)
/*! @} */

/*! @name MP_INT - Management Page Interrupt Request Status */
/*! @{ */

#define DMA_MP_INT_INT_MASK                      (0xFFFFU)
#define DMA_MP_INT_INT_SHIFT                     (0U)
/*! INT - Interrupt Request Status */
#define DMA_MP_INT_INT(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_INT_INT_SHIFT)) & DMA_MP_INT_INT_MASK)
/*! @} */

/*! @name MP_HRS - Management Page Hardware Request Status */
/*! @{ */

#define DMA_MP_HRS_HRS_MASK                      (0xFFFFFFFFU)
#define DMA_MP_HRS_HRS_SHIFT                     (0U)
/*! HRS - Hardware Request Status */
#define DMA_MP_HRS_HRS(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_HRS_HRS_SHIFT)) & DMA_MP_HRS_HRS_MASK)
/*! @} */

/*! @name CH_GRPRI - Channel Arbitration Group */
/*! @{ */

#define DMA_CH_GRPRI_GRPRI_MASK                  (0x1FU)
#define DMA_CH_GRPRI_GRPRI_SHIFT                 (0U)
/*! GRPRI - Arbitration Group For Channel n */
#define DMA_CH_GRPRI_GRPRI(x)                    (((uint32_t)(((uint32_t)(x)) << DMA_CH_GRPRI_GRPRI_SHIFT)) & DMA_CH_GRPRI_GRPRI_MASK)
/*! @} */

/* The count of DMA_CH_GRPRI */
#define DMA_CH_GRPRI_COUNT                       (16U)

/*! @name CH_CSR - Channel Control and Status */
/*! @{ */

#define DMA_CH_CSR_ERQ_MASK                      (0x1U)
#define DMA_CH_CSR_ERQ_SHIFT                     (0U)
/*! ERQ - Enable DMA Request
 *  0b0..DMA hardware request signal for corresponding channel disabled
 *  0b1..DMA hardware request signal for corresponding channel enabled
 */
#define DMA_CH_CSR_ERQ(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_ERQ_SHIFT)) & DMA_CH_CSR_ERQ_MASK)

#define DMA_CH_CSR_EARQ_MASK                     (0x2U)
#define DMA_CH_CSR_EARQ_SHIFT                    (1U)
/*! EARQ - Enable Asynchronous DMA Request
 *  0b0..Disable asynchronous DMA request for the channel
 *  0b1..Enable asynchronous DMA request for the channel
 */
#define DMA_CH_CSR_EARQ(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EARQ_SHIFT)) & DMA_CH_CSR_EARQ_MASK)

#define DMA_CH_CSR_EEI_MASK                      (0x4U)
#define DMA_CH_CSR_EEI_SHIFT                     (2U)
/*! EEI - Enable Error Interrupt
 *  0b0..Error signal for corresponding channel does not generate error interrupt
 *  0b1..Assertion of error signal for corresponding channel generates error interrupt request
 */
#define DMA_CH_CSR_EEI(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EEI_SHIFT)) & DMA_CH_CSR_EEI_MASK)

#define DMA_CH_CSR_EBW_MASK                      (0x8U)
#define DMA_CH_CSR_EBW_SHIFT                     (3U)
/*! EBW - Enable Buffered Writes
 *  0b0..Buffered writes on system bus disabled
 *  0b1..Buffered writes on system bus enabled
 */
#define DMA_CH_CSR_EBW(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EBW_SHIFT)) & DMA_CH_CSR_EBW_MASK)

#define DMA_CH_CSR_DONE_MASK                     (0x40000000U)
#define DMA_CH_CSR_DONE_SHIFT                    (30U)
/*! DONE - Channel Done */
#define DMA_CH_CSR_DONE(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_DONE_SHIFT)) & DMA_CH_CSR_DONE_MASK)

#define DMA_CH_CSR_ACTIVE_MASK                   (0x80000000U)
#define DMA_CH_CSR_ACTIVE_SHIFT                  (31U)
/*! ACTIVE - Channel Active */
#define DMA_CH_CSR_ACTIVE(x)                     (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_ACTIVE_SHIFT)) & DMA_CH_CSR_ACTIVE_MASK)
/*! @} */

/* The count of DMA_CH_CSR */
#define DMA_CH_CSR_COUNT                         (16U)

/*! @name CH_ES - Channel Error Status */
/*! @{ */

#define DMA_CH_ES_DBE_MASK                       (0x1U)
#define DMA_CH_ES_DBE_SHIFT                      (0U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error
 *  0b1..Last recorded error was bus error on destination write
 */
#define DMA_CH_ES_DBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DBE_SHIFT)) & DMA_CH_ES_DBE_MASK)

#define DMA_CH_ES_SBE_MASK                       (0x2U)
#define DMA_CH_ES_SBE_SHIFT                      (1U)
/*! SBE - Source Bus Error
 *  0b0..No source bus error
 *  0b1..Last recorded error was bus error on source read
 */
#define DMA_CH_ES_SBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SBE_SHIFT)) & DMA_CH_ES_SBE_MASK)

#define DMA_CH_ES_SGE_MASK                       (0x4U)
#define DMA_CH_ES_SGE_SHIFT                      (2U)
/*! SGE - Scatter/Gather Configuration Error
 *  0b0..No scatter/gather configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DLAST_SGA field
 */
#define DMA_CH_ES_SGE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SGE_SHIFT)) & DMA_CH_ES_SGE_MASK)

#define DMA_CH_ES_NCE_MASK                       (0x8U)
#define DMA_CH_ES_NCE_SHIFT                      (3U)
/*! NCE - NBYTES/CITER Configuration Error
 *  0b0..No NBYTES/CITER configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_NBYTES or TCDn_CITER fields
 */
#define DMA_CH_ES_NCE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_NCE_SHIFT)) & DMA_CH_ES_NCE_MASK)

#define DMA_CH_ES_DOE_MASK                       (0x10U)
#define DMA_CH_ES_DOE_SHIFT                      (4U)
/*! DOE - Destination Offset Error
 *  0b0..No destination offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DOFF field
 */
#define DMA_CH_ES_DOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DOE_SHIFT)) & DMA_CH_ES_DOE_MASK)

#define DMA_CH_ES_DAE_MASK                       (0x20U)
#define DMA_CH_ES_DAE_SHIFT                      (5U)
/*! DAE - Destination Address Error
 *  0b0..No destination address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DADDR field
 */
#define DMA_CH_ES_DAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DAE_SHIFT)) & DMA_CH_ES_DAE_MASK)

#define DMA_CH_ES_SOE_MASK                       (0x40U)
#define DMA_CH_ES_SOE_SHIFT                      (6U)
/*! SOE - Source Offset Error
 *  0b0..No source offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SOFF field
 */
#define DMA_CH_ES_SOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SOE_SHIFT)) & DMA_CH_ES_SOE_MASK)

#define DMA_CH_ES_SAE_MASK                       (0x80U)
#define DMA_CH_ES_SAE_SHIFT                      (7U)
/*! SAE - Source Address Error
 *  0b0..No source address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SADDR field
 */
#define DMA_CH_ES_SAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SAE_SHIFT)) & DMA_CH_ES_SAE_MASK)

#define DMA_CH_ES_ERR_MASK                       (0x80000000U)
#define DMA_CH_ES_ERR_SHIFT                      (31U)
/*! ERR - Error In Channel
 *  0b0..An error in this channel has not occurred
 *  0b1..An error in this channel has occurred
 */
#define DMA_CH_ES_ERR(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_ERR_SHIFT)) & DMA_CH_ES_ERR_MASK)
/*! @} */

/* The count of DMA_CH_ES */
#define DMA_CH_ES_COUNT                          (16U)

/*! @name CH_INT - Channel Interrupt Status */
/*! @{ */

#define DMA_CH_INT_INT_MASK                      (0x1U)
#define DMA_CH_INT_INT_SHIFT                     (0U)
/*! INT - Interrupt Request
 *  0b0..Interrupt request for corresponding channel cleared
 *  0b1..Interrupt request for corresponding channel active
 */
#define DMA_CH_INT_INT(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_INT_INT_SHIFT)) & DMA_CH_INT_INT_MASK)
/*! @} */

/* The count of DMA_CH_INT */
#define DMA_CH_INT_COUNT                         (16U)

/*! @name CH_SBR - Channel System Bus */
/*! @{ */

#define DMA_CH_SBR_MID_MASK                      (0x1FU)
#define DMA_CH_SBR_MID_SHIFT                     (0U)
/*! MID - Master ID */
#define DMA_CH_SBR_MID(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_MID_SHIFT)) & DMA_CH_SBR_MID_MASK)

#define DMA_CH_SBR_SEC_MASK                      (0x4000U)
#define DMA_CH_SBR_SEC_SHIFT                     (14U)
/*! SEC - Security Level
 *  0b0..Nonsecure protection level for DMA transfers
 *  0b1..Secure protection level for DMA transfers
 */
#define DMA_CH_SBR_SEC(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_SEC_SHIFT)) & DMA_CH_SBR_SEC_MASK)

#define DMA_CH_SBR_PAL_MASK                      (0x8000U)
#define DMA_CH_SBR_PAL_SHIFT                     (15U)
/*! PAL - Privileged Access Level
 *  0b0..User protection level for DMA transfers
 *  0b1..Privileged protection level for DMA transfers
 */
#define DMA_CH_SBR_PAL(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_PAL_SHIFT)) & DMA_CH_SBR_PAL_MASK)

#define DMA_CH_SBR_EMI_MASK                      (0x10000U)
#define DMA_CH_SBR_EMI_SHIFT                     (16U)
/*! EMI - Enable Master ID Replication
 *  0b0..Master ID replication is disabled
 *  0b1..Master ID replication is enabled
 */
#define DMA_CH_SBR_EMI(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_EMI_SHIFT)) & DMA_CH_SBR_EMI_MASK)
/*! @} */

/* The count of DMA_CH_SBR */
#define DMA_CH_SBR_COUNT                         (16U)

/*! @name CH_PRI - Channel Priority */
/*! @{ */

#define DMA_CH_PRI_APL_MASK                      (0x7U)
#define DMA_CH_PRI_APL_SHIFT                     (0U)
/*! APL - Arbitration Priority Level */
#define DMA_CH_PRI_APL(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_APL_SHIFT)) & DMA_CH_PRI_APL_MASK)

#define DMA_CH_PRI_DPA_MASK                      (0x40000000U)
#define DMA_CH_PRI_DPA_SHIFT                     (30U)
/*! DPA - Disable Preempt Ability
 *  0b0..Channel can suspend a lower-priority channel
 *  0b1..Channel cannot suspend any other channel, regardless of channel priority
 */
#define DMA_CH_PRI_DPA(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_DPA_SHIFT)) & DMA_CH_PRI_DPA_MASK)

#define DMA_CH_PRI_ECP_MASK                      (0x80000000U)
#define DMA_CH_PRI_ECP_SHIFT                     (31U)
/*! ECP - Enable Channel Preemption
 *  0b0..Channel cannot be suspended by a higher-priority channel's service request
 *  0b1..Channel can be temporarily suspended by a higher-priority channel's service request
 */
#define DMA_CH_PRI_ECP(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_ECP_SHIFT)) & DMA_CH_PRI_ECP_MASK)
/*! @} */

/* The count of DMA_CH_PRI */
#define DMA_CH_PRI_COUNT                         (16U)

/*! @name CH_MUX - Channel Multiplexor Configuration */
/*! @{ */

#define DMA_CH_MUX_SRC_MASK                      (0x7FU)
#define DMA_CH_MUX_SRC_SHIFT                     (0U)
/*! SRC - Service Request Source */
#define DMA_CH_MUX_SRC(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_MUX_SRC_SHIFT)) & DMA_CH_MUX_SRC_MASK)
/*! @} */

/* The count of DMA_CH_MUX */
#define DMA_CH_MUX_COUNT                         (16U)

/*! @name TCD_SADDR - TCD Source Address */
/*! @{ */

#define DMA_TCD_SADDR_SADDR_MASK                 (0xFFFFFFFFU)
#define DMA_TCD_SADDR_SADDR_SHIFT                (0U)
/*! SADDR - Source Address */
#define DMA_TCD_SADDR_SADDR(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_TCD_SADDR_SADDR_SHIFT)) & DMA_TCD_SADDR_SADDR_MASK)
/*! @} */

/* The count of DMA_TCD_SADDR */
#define DMA_TCD_SADDR_COUNT                      (16U)

/*! @name TCD_SOFF - TCD Signed Source Address Offset */
/*! @{ */

#define DMA_TCD_SOFF_SOFF_MASK                   (0xFFFFU)
#define DMA_TCD_SOFF_SOFF_SHIFT                  (0U)
/*! SOFF - Source Address Signed Offset */
#define DMA_TCD_SOFF_SOFF(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_SOFF_SOFF_SHIFT)) & DMA_TCD_SOFF_SOFF_MASK)
/*! @} */

/* The count of DMA_TCD_SOFF */
#define DMA_TCD_SOFF_COUNT                       (16U)

/*! @name TCD_ATTR - TCD Transfer Attributes */
/*! @{ */

#define DMA_TCD_ATTR_DSIZE_MASK                  (0x7U)
#define DMA_TCD_ATTR_DSIZE_SHIFT                 (0U)
/*! DSIZE - Destination Data Transfer Size */
#define DMA_TCD_ATTR_DSIZE(x)                    (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_DSIZE_SHIFT)) & DMA_TCD_ATTR_DSIZE_MASK)

#define DMA_TCD_ATTR_DMOD_MASK                   (0xF8U)
#define DMA_TCD_ATTR_DMOD_SHIFT                  (3U)
/*! DMOD - Destination Address Modulo */
#define DMA_TCD_ATTR_DMOD(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_DMOD_SHIFT)) & DMA_TCD_ATTR_DMOD_MASK)

#define DMA_TCD_ATTR_SSIZE_MASK                  (0x700U)
#define DMA_TCD_ATTR_SSIZE_SHIFT                 (8U)
/*! SSIZE - Source Data Transfer Size
 *  0b000..8-bit
 *  0b001..16-bit
 *  0b010..32-bit
 *  0b011..64-bit
 *  0b100..16-byte
 *  0b101..32-byte
 *  0b110..
 *  0b111..
 */
#define DMA_TCD_ATTR_SSIZE(x)                    (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_SSIZE_SHIFT)) & DMA_TCD_ATTR_SSIZE_MASK)

#define DMA_TCD_ATTR_SMOD_MASK                   (0xF800U)
#define DMA_TCD_ATTR_SMOD_SHIFT                  (11U)
/*! SMOD - Source Address Modulo
 *  0b00000..Source address modulo feature disabled
 *  0b00001..Source address modulo feature enabled for any non-zero value [1-31]
 */
#define DMA_TCD_ATTR_SMOD(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_SMOD_SHIFT)) & DMA_TCD_ATTR_SMOD_MASK)
/*! @} */

/* The count of DMA_TCD_ATTR */
#define DMA_TCD_ATTR_COUNT                       (16U)

/*! @name TCD_NBYTES_MLOFFNO - TCD Transfer Size Without Minor Loop Offsets */
/*! @{ */

#define DMA_TCD_NBYTES_MLOFFNO_NBYTES_MASK       (0x3FFFFFFFU)
#define DMA_TCD_NBYTES_MLOFFNO_NBYTES_SHIFT      (0U)
/*! NBYTES - Number of Bytes To Transfer Per Service Request */
#define DMA_TCD_NBYTES_MLOFFNO_NBYTES(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_NBYTES_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_NBYTES_MASK)

#define DMA_TCD_NBYTES_MLOFFNO_DMLOE_MASK        (0x40000000U)
#define DMA_TCD_NBYTES_MLOFFNO_DMLOE_SHIFT       (30U)
/*! DMLOE - Destination Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to DADDR
 *  0b1..Minor loop offset applied to DADDR
 */
#define DMA_TCD_NBYTES_MLOFFNO_DMLOE(x)          (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_DMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_DMLOE_MASK)

#define DMA_TCD_NBYTES_MLOFFNO_SMLOE_MASK        (0x80000000U)
#define DMA_TCD_NBYTES_MLOFFNO_SMLOE_SHIFT       (31U)
/*! SMLOE - Source Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to SADDR
 *  0b1..Minor loop offset applied to SADDR
 */
#define DMA_TCD_NBYTES_MLOFFNO_SMLOE(x)          (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_SMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_SMLOE_MASK)
/*! @} */

/* The count of DMA_TCD_NBYTES_MLOFFNO */
#define DMA_TCD_NBYTES_MLOFFNO_COUNT             (16U)

/*! @name TCD_NBYTES_MLOFFYES - TCD Transfer Size with Minor Loop Offsets */
/*! @{ */

#define DMA_TCD_NBYTES_MLOFFYES_NBYTES_MASK      (0x3FFU)
#define DMA_TCD_NBYTES_MLOFFYES_NBYTES_SHIFT     (0U)
/*! NBYTES - Number of Bytes To Transfer Per Service Request */
#define DMA_TCD_NBYTES_MLOFFYES_NBYTES(x)        (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_NBYTES_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_NBYTES_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_MLOFF_MASK       (0x3FFFFC00U)
#define DMA_TCD_NBYTES_MLOFFYES_MLOFF_SHIFT      (10U)
/*! MLOFF - Minor Loop Offset */
#define DMA_TCD_NBYTES_MLOFFYES_MLOFF(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_MLOFF_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_MLOFF_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_DMLOE_MASK       (0x40000000U)
#define DMA_TCD_NBYTES_MLOFFYES_DMLOE_SHIFT      (30U)
/*! DMLOE - Destination Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to DADDR
 *  0b1..Minor loop offset applied to DADDR
 */
#define DMA_TCD_NBYTES_MLOFFYES_DMLOE(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_DMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_DMLOE_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_SMLOE_MASK       (0x80000000U)
#define DMA_TCD_NBYTES_MLOFFYES_SMLOE_SHIFT      (31U)
/*! SMLOE - Source Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to SADDR
 *  0b1..Minor loop offset applied to SADDR
 */
#define DMA_TCD_NBYTES_MLOFFYES_SMLOE(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_SMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_SMLOE_MASK)
/*! @} */

/* The count of DMA_TCD_NBYTES_MLOFFYES */
#define DMA_TCD_NBYTES_MLOFFYES_COUNT            (16U)

/*! @name TCD_SLAST_SDA - TCD Last Source Address Adjustment / Store DADDR Address */
/*! @{ */

#define DMA_TCD_SLAST_SDA_SLAST_SDA_MASK         (0xFFFFFFFFU)
#define DMA_TCD_SLAST_SDA_SLAST_SDA_SHIFT        (0U)
/*! SLAST_SDA - Last Source Address Adjustment / Store DADDR Address */
#define DMA_TCD_SLAST_SDA_SLAST_SDA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_TCD_SLAST_SDA_SLAST_SDA_SHIFT)) & DMA_TCD_SLAST_SDA_SLAST_SDA_MASK)
/*! @} */

/* The count of DMA_TCD_SLAST_SDA */
#define DMA_TCD_SLAST_SDA_COUNT                  (16U)

/*! @name TCD_DADDR - TCD Destination Address */
/*! @{ */

#define DMA_TCD_DADDR_DADDR_MASK                 (0xFFFFFFFFU)
#define DMA_TCD_DADDR_DADDR_SHIFT                (0U)
/*! DADDR - Destination Address */
#define DMA_TCD_DADDR_DADDR(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_TCD_DADDR_DADDR_SHIFT)) & DMA_TCD_DADDR_DADDR_MASK)
/*! @} */

/* The count of DMA_TCD_DADDR */
#define DMA_TCD_DADDR_COUNT                      (16U)

/*! @name TCD_DOFF - TCD Signed Destination Address Offset */
/*! @{ */

#define DMA_TCD_DOFF_DOFF_MASK                   (0xFFFFU)
#define DMA_TCD_DOFF_DOFF_SHIFT                  (0U)
/*! DOFF - Destination Address Signed Offset */
#define DMA_TCD_DOFF_DOFF(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_DOFF_DOFF_SHIFT)) & DMA_TCD_DOFF_DOFF_MASK)
/*! @} */

/* The count of DMA_TCD_DOFF */
#define DMA_TCD_DOFF_COUNT                       (16U)

/*! @name TCD_CITER_ELINKNO - TCD Current Major Loop Count (Minor Loop Channel Linking Disabled) */
/*! @{ */

#define DMA_TCD_CITER_ELINKNO_CITER_MASK         (0x7FFFU)
#define DMA_TCD_CITER_ELINKNO_CITER_SHIFT        (0U)
/*! CITER - Current Major Iteration Count */
#define DMA_TCD_CITER_ELINKNO_CITER(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKNO_CITER_SHIFT)) & DMA_TCD_CITER_ELINKNO_CITER_MASK)

#define DMA_TCD_CITER_ELINKNO_ELINK_MASK         (0x8000U)
#define DMA_TCD_CITER_ELINKNO_ELINK_SHIFT        (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CITER_ELINKNO_ELINK(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKNO_ELINK_SHIFT)) & DMA_TCD_CITER_ELINKNO_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_CITER_ELINKNO */
#define DMA_TCD_CITER_ELINKNO_COUNT              (16U)

/*! @name TCD_CITER_ELINKYES - TCD Current Major Loop Count (Minor Loop Channel Linking Enabled) */
/*! @{ */

#define DMA_TCD_CITER_ELINKYES_CITER_MASK        (0x1FFU)
#define DMA_TCD_CITER_ELINKYES_CITER_SHIFT       (0U)
/*! CITER - Current Major Iteration Count */
#define DMA_TCD_CITER_ELINKYES_CITER(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_CITER_SHIFT)) & DMA_TCD_CITER_ELINKYES_CITER_MASK)

#define DMA_TCD_CITER_ELINKYES_LINKCH_MASK       (0x1E00U)
#define DMA_TCD_CITER_ELINKYES_LINKCH_SHIFT      (9U)
/*! LINKCH - Minor Loop Link Channel Number */
#define DMA_TCD_CITER_ELINKYES_LINKCH(x)         (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_LINKCH_SHIFT)) & DMA_TCD_CITER_ELINKYES_LINKCH_MASK)

#define DMA_TCD_CITER_ELINKYES_ELINK_MASK        (0x8000U)
#define DMA_TCD_CITER_ELINKYES_ELINK_SHIFT       (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CITER_ELINKYES_ELINK(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_ELINK_SHIFT)) & DMA_TCD_CITER_ELINKYES_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_CITER_ELINKYES */
#define DMA_TCD_CITER_ELINKYES_COUNT             (16U)

/*! @name TCD_DLAST_SGA - TCD Last Destination Address Adjustment / Scatter Gather Address */
/*! @{ */

#define DMA_TCD_DLAST_SGA_DLAST_SGA_MASK         (0xFFFFFFFFU)
#define DMA_TCD_DLAST_SGA_DLAST_SGA_SHIFT        (0U)
/*! DLAST_SGA - Last Destination Address Adjustment / Scatter Gather Address */
#define DMA_TCD_DLAST_SGA_DLAST_SGA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_TCD_DLAST_SGA_DLAST_SGA_SHIFT)) & DMA_TCD_DLAST_SGA_DLAST_SGA_MASK)
/*! @} */

/* The count of DMA_TCD_DLAST_SGA */
#define DMA_TCD_DLAST_SGA_COUNT                  (16U)

/*! @name TCD_CSR - TCD Control and Status */
/*! @{ */

#define DMA_TCD_CSR_START_MASK                   (0x1U)
#define DMA_TCD_CSR_START_SHIFT                  (0U)
/*! START - Channel Start
 *  0b0..Channel not explicitly started
 *  0b1..Channel explicitly started via a software-initiated service request
 */
#define DMA_TCD_CSR_START(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_START_SHIFT)) & DMA_TCD_CSR_START_MASK)

#define DMA_TCD_CSR_INTMAJOR_MASK                (0x2U)
#define DMA_TCD_CSR_INTMAJOR_SHIFT               (1U)
/*! INTMAJOR - Enable Interrupt If Major count complete
 *  0b0..End-of-major loop interrupt disabled
 *  0b1..End-of-major loop interrupt enabled
 */
#define DMA_TCD_CSR_INTMAJOR(x)                  (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_INTMAJOR_SHIFT)) & DMA_TCD_CSR_INTMAJOR_MASK)

#define DMA_TCD_CSR_INTHALF_MASK                 (0x4U)
#define DMA_TCD_CSR_INTHALF_SHIFT                (2U)
/*! INTHALF - Enable Interrupt If Major Counter Half-complete
 *  0b0..Halfway point interrupt disabled
 *  0b1..Halfway point interrupt enabled
 */
#define DMA_TCD_CSR_INTHALF(x)                   (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_INTHALF_SHIFT)) & DMA_TCD_CSR_INTHALF_MASK)

#define DMA_TCD_CSR_DREQ_MASK                    (0x8U)
#define DMA_TCD_CSR_DREQ_SHIFT                   (3U)
/*! DREQ - Disable Request
 *  0b0..No operation
 *  0b1..Clear the ERQ field to 0 upon major loop completion, thus disabling hardware service requests
 */
#define DMA_TCD_CSR_DREQ(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_DREQ_SHIFT)) & DMA_TCD_CSR_DREQ_MASK)

#define DMA_TCD_CSR_ESG_MASK                     (0x10U)
#define DMA_TCD_CSR_ESG_SHIFT                    (4U)
/*! ESG - Enable Scatter/Gather Processing
 *  0b0..Current channel's TCD is normal format
 *  0b1..Current channel's TCD specifies scatter/gather format.
 */
#define DMA_TCD_CSR_ESG(x)                       (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_ESG_SHIFT)) & DMA_TCD_CSR_ESG_MASK)

#define DMA_TCD_CSR_MAJORELINK_MASK              (0x20U)
#define DMA_TCD_CSR_MAJORELINK_SHIFT             (5U)
/*! MAJORELINK - Enable Link When Major Loop Complete
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CSR_MAJORELINK(x)                (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_MAJORELINK_SHIFT)) & DMA_TCD_CSR_MAJORELINK_MASK)

#define DMA_TCD_CSR_EEOP_MASK                    (0x40U)
#define DMA_TCD_CSR_EEOP_SHIFT                   (6U)
/*! EEOP - Enable End-Of-Packet Processing
 *  0b0..End-of-packet operation disabled
 *  0b1..End-of-packet hardware input signal enabled
 */
#define DMA_TCD_CSR_EEOP(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_EEOP_SHIFT)) & DMA_TCD_CSR_EEOP_MASK)

#define DMA_TCD_CSR_ESDA_MASK                    (0x80U)
#define DMA_TCD_CSR_ESDA_SHIFT                   (7U)
/*! ESDA - Enable Store Destination Address
 *  0b0..Ability to store destination address to system memory disabled
 *  0b1..Ability to store destination address to system memory enabled
 */
#define DMA_TCD_CSR_ESDA(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_ESDA_SHIFT)) & DMA_TCD_CSR_ESDA_MASK)

#define DMA_TCD_CSR_MAJORLINKCH_MASK             (0xF00U)
#define DMA_TCD_CSR_MAJORLINKCH_SHIFT            (8U)
/*! MAJORLINKCH - Major Loop Link Channel Number */
#define DMA_TCD_CSR_MAJORLINKCH(x)               (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_MAJORLINKCH_SHIFT)) & DMA_TCD_CSR_MAJORLINKCH_MASK)

#define DMA_TCD_CSR_BWC_MASK                     (0xC000U)
#define DMA_TCD_CSR_BWC_SHIFT                    (14U)
/*! BWC - Bandwidth Control
 *  0b00..No eDMA engine stalls
 *  0b01..
 *  0b10..eDMA engine stalls for 4 cycles after each R/W
 *  0b11..eDMA engine stalls for 8 cycles after each R/W
 */
#define DMA_TCD_CSR_BWC(x)                       (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_BWC_SHIFT)) & DMA_TCD_CSR_BWC_MASK)
/*! @} */

/* The count of DMA_TCD_CSR */
#define DMA_TCD_CSR_COUNT                        (16U)

/*! @name TCD_BITER_ELINKNO - TCD Beginning Major Loop Count (Minor Loop Channel Linking Disabled) */
/*! @{ */

#define DMA_TCD_BITER_ELINKNO_BITER_MASK         (0x7FFFU)
#define DMA_TCD_BITER_ELINKNO_BITER_SHIFT        (0U)
/*! BITER - Starting Major Iteration Count */
#define DMA_TCD_BITER_ELINKNO_BITER(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKNO_BITER_SHIFT)) & DMA_TCD_BITER_ELINKNO_BITER_MASK)

#define DMA_TCD_BITER_ELINKNO_ELINK_MASK         (0x8000U)
#define DMA_TCD_BITER_ELINKNO_ELINK_SHIFT        (15U)
/*! ELINK - Enables Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_BITER_ELINKNO_ELINK(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKNO_ELINK_SHIFT)) & DMA_TCD_BITER_ELINKNO_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_BITER_ELINKNO */
#define DMA_TCD_BITER_ELINKNO_COUNT              (16U)

/*! @name TCD_BITER_ELINKYES - TCD Beginning Major Loop Count (Minor Loop Channel Linking Enabled) */
/*! @{ */

#define DMA_TCD_BITER_ELINKYES_BITER_MASK        (0x1FFU)
#define DMA_TCD_BITER_ELINKYES_BITER_SHIFT       (0U)
/*! BITER - Starting Major Iteration Count */
#define DMA_TCD_BITER_ELINKYES_BITER(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_BITER_SHIFT)) & DMA_TCD_BITER_ELINKYES_BITER_MASK)

#define DMA_TCD_BITER_ELINKYES_LINKCH_MASK       (0x1E00U)
#define DMA_TCD_BITER_ELINKYES_LINKCH_SHIFT      (9U)
/*! LINKCH - Link Channel Number */
#define DMA_TCD_BITER_ELINKYES_LINKCH(x)         (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_LINKCH_SHIFT)) & DMA_TCD_BITER_ELINKYES_LINKCH_MASK)

#define DMA_TCD_BITER_ELINKYES_ELINK_MASK        (0x8000U)
#define DMA_TCD_BITER_ELINKYES_ELINK_SHIFT       (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_BITER_ELINKYES_ELINK(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_ELINK_SHIFT)) & DMA_TCD_BITER_ELINKYES_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_BITER_ELINKYES */
#define DMA_TCD_BITER_ELINKYES_COUNT             (16U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DMA0 base address */
  #define DMA0_BASE                                (0x50080000u)
  /** Peripheral DMA0 base address */
  #define DMA0_BASE_NS                             (0x40080000u)
  /** Peripheral DMA0 base pointer */
  #define DMA0                                     ((DMA_Type *)DMA0_BASE)
  /** Peripheral DMA0 base pointer */
  #define DMA0_NS                                  ((DMA_Type *)DMA0_BASE_NS)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE                                (0x500A0000u)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE_NS                             (0x400A0000u)
  /** Peripheral DMA1 base pointer */
  #define DMA1                                     ((DMA_Type *)DMA1_BASE)
  /** Peripheral DMA1 base pointer */
  #define DMA1_NS                                  ((DMA_Type *)DMA1_BASE_NS)
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS                           { DMA0_BASE, DMA1_BASE }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS                            { DMA0, DMA1 }
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS_NS                        { DMA0_BASE_NS, DMA1_BASE_NS }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS_NS                         { DMA0_NS, DMA1_NS }
#else
  /** Peripheral DMA0 base address */
  #define DMA0_BASE                                (0x40080000u)
  /** Peripheral DMA0 base pointer */
  #define DMA0                                     ((DMA_Type *)DMA0_BASE)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE                                (0x400A0000u)
  /** Peripheral DMA1 base pointer */
  #define DMA1                                     ((DMA_Type *)DMA1_BASE)
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS                           { DMA0_BASE, DMA1_BASE }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS                            { DMA0, DMA1 }
#endif
/** Interrupt vectors for the DMA peripheral type */
#define DMA_IRQS                                 { { EDMA_0_CH0_IRQn, EDMA_0_CH1_IRQn, EDMA_0_CH2_IRQn, EDMA_0_CH3_IRQn, EDMA_0_CH4_IRQn, EDMA_0_CH5_IRQn, EDMA_0_CH6_IRQn, EDMA_0_CH7_IRQn, EDMA_0_CH8_IRQn, EDMA_0_CH9_IRQn, EDMA_0_CH10_IRQn, EDMA_0_CH11_IRQn, EDMA_0_CH12_IRQn, EDMA_0_CH13_IRQn, EDMA_0_CH14_IRQn, EDMA_0_CH15_IRQn }, \
                                                   { EDMA_1_CH0_IRQn, EDMA_1_CH1_IRQn, EDMA_1_CH2_IRQn, EDMA_1_CH3_IRQn, EDMA_1_CH4_IRQn, EDMA_1_CH5_IRQn, EDMA_1_CH6_IRQn, EDMA_1_CH7_IRQn, EDMA_1_CH8_IRQn, EDMA_1_CH9_IRQn, EDMA_1_CH10_IRQn, EDMA_1_CH11_IRQn, EDMA_1_CH12_IRQn, EDMA_1_CH13_IRQn, EDMA_1_CH14_IRQn, EDMA_1_CH15_IRQn } }

/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EIM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Peripheral_Access_Layer EIM Peripheral Access Layer
 * @{
 */

/** EIM - Register Layout Typedef */
typedef struct {
  __IO uint32_t EIMCR;                             /**< Error Injection Module Configuration Register, offset: 0x0 */
  __IO uint32_t EICHEN;                            /**< Error Injection Channel Enable register, offset: 0x4 */
       uint8_t RESERVED_0[248];
  __IO uint32_t EICHD0_WORD0;                      /**< Error Injection Channel Descriptor 0, Word0, offset: 0x100 */
  __IO uint32_t EICHD0_WORD1;                      /**< Error Injection Channel Descriptor 0, Word1, offset: 0x104 */
       uint8_t RESERVED_1[56];
  __IO uint32_t EICHD1_WORD0;                      /**< Error Injection Channel Descriptor 1, Word0, offset: 0x140 */
  __IO uint32_t EICHD1_WORD1;                      /**< Error Injection Channel Descriptor 1, Word1, offset: 0x144 */
       uint8_t RESERVED_2[56];
  __IO uint32_t EICHD2_WORD0;                      /**< Error Injection Channel Descriptor 2, Word0, offset: 0x180 */
  __IO uint32_t EICHD2_WORD1;                      /**< Error Injection Channel Descriptor 2, Word1, offset: 0x184 */
       uint8_t RESERVED_3[56];
  __IO uint32_t EICHD3_WORD0;                      /**< Error Injection Channel Descriptor 3, Word0, offset: 0x1C0 */
  __IO uint32_t EICHD3_WORD1;                      /**< Error Injection Channel Descriptor 3, Word1, offset: 0x1C4 */
       uint8_t RESERVED_4[56];
  __IO uint32_t EICHD4_WORD0;                      /**< Error Injection Channel Descriptor 4, Word0, offset: 0x200 */
  __IO uint32_t EICHD4_WORD1;                      /**< Error Injection Channel Descriptor 4, Word1, offset: 0x204 */
       uint8_t RESERVED_5[56];
  __IO uint32_t EICHD5_WORD0;                      /**< Error Injection Channel Descriptor 5, Word0, offset: 0x240 */
  __IO uint32_t EICHD5_WORD1;                      /**< Error Injection Channel Descriptor 5, Word1, offset: 0x244 */
       uint8_t RESERVED_6[56];
  __IO uint32_t EICHD6_WORD0;                      /**< Error Injection Channel Descriptor 6, Word0, offset: 0x280 */
  __IO uint32_t EICHD6_WORD1;                      /**< Error Injection Channel Descriptor 6, Word1, offset: 0x284 */
       uint8_t RESERVED_7[56];
  __IO uint32_t EICHD7_WORD0;                      /**< Error Injection Channel Descriptor 7, Word0, offset: 0x2C0 */
  __IO uint32_t EICHD7_WORD1;                      /**< Error Injection Channel Descriptor 7, Word1, offset: 0x2C4 */
       uint8_t RESERVED_8[56];
  __IO uint32_t EICHD8_WORD0;                      /**< Error Injection Channel Descriptor 8, Word0, offset: 0x300 */
  __IO uint32_t EICHD8_WORD1;                      /**< Error Injection Channel Descriptor 8, Word1, offset: 0x304 */
} EIM_Type;

/* ----------------------------------------------------------------------------
   -- EIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EIM_Register_Masks EIM Register Masks
 * @{
 */

/*! @name EIMCR - Error Injection Module Configuration Register */
/*! @{ */

#define EIM_EIMCR_GEIEN_MASK                     (0x1U)
#define EIM_EIMCR_GEIEN_SHIFT                    (0U)
/*! GEIEN - Global Error Injection Enable
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define EIM_EIMCR_GEIEN(x)                       (((uint32_t)(((uint32_t)(x)) << EIM_EIMCR_GEIEN_SHIFT)) & EIM_EIMCR_GEIEN_MASK)
/*! @} */

/*! @name EICHEN - Error Injection Channel Enable register */
/*! @{ */

#define EIM_EICHEN_EICH8EN_MASK                  (0x800000U)
#define EIM_EICHEN_EICH8EN_SHIFT                 (23U)
/*! EICH8EN - Error Injection Channel 8 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 8
 *  0b1..Error injection is enabled on Error Injection Channel 8
 */
#define EIM_EICHEN_EICH8EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH8EN_SHIFT)) & EIM_EICHEN_EICH8EN_MASK)

#define EIM_EICHEN_EICH7EN_MASK                  (0x1000000U)
#define EIM_EICHEN_EICH7EN_SHIFT                 (24U)
/*! EICH7EN - Error Injection Channel 7 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 7
 *  0b1..Error injection is enabled on Error Injection Channel 7
 */
#define EIM_EICHEN_EICH7EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH7EN_SHIFT)) & EIM_EICHEN_EICH7EN_MASK)

#define EIM_EICHEN_EICH6EN_MASK                  (0x2000000U)
#define EIM_EICHEN_EICH6EN_SHIFT                 (25U)
/*! EICH6EN - Error Injection Channel 6 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 6
 *  0b1..Error injection is enabled on Error Injection Channel 6
 */
#define EIM_EICHEN_EICH6EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH6EN_SHIFT)) & EIM_EICHEN_EICH6EN_MASK)

#define EIM_EICHEN_EICH5EN_MASK                  (0x4000000U)
#define EIM_EICHEN_EICH5EN_SHIFT                 (26U)
/*! EICH5EN - Error Injection Channel 5 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 5
 *  0b1..Error injection is enabled on Error Injection Channel 5
 */
#define EIM_EICHEN_EICH5EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH5EN_SHIFT)) & EIM_EICHEN_EICH5EN_MASK)

#define EIM_EICHEN_EICH4EN_MASK                  (0x8000000U)
#define EIM_EICHEN_EICH4EN_SHIFT                 (27U)
/*! EICH4EN - Error Injection Channel 4 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 4
 *  0b1..Error injection is enabled on Error Injection Channel 4
 */
#define EIM_EICHEN_EICH4EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH4EN_SHIFT)) & EIM_EICHEN_EICH4EN_MASK)

#define EIM_EICHEN_EICH3EN_MASK                  (0x10000000U)
#define EIM_EICHEN_EICH3EN_SHIFT                 (28U)
/*! EICH3EN - Error Injection Channel 3 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 3
 *  0b1..Error injection is enabled on Error Injection Channel 3
 */
#define EIM_EICHEN_EICH3EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH3EN_SHIFT)) & EIM_EICHEN_EICH3EN_MASK)

#define EIM_EICHEN_EICH2EN_MASK                  (0x20000000U)
#define EIM_EICHEN_EICH2EN_SHIFT                 (29U)
/*! EICH2EN - Error Injection Channel 2 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 2
 *  0b1..Error injection is enabled on Error Injection Channel 2
 */
#define EIM_EICHEN_EICH2EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH2EN_SHIFT)) & EIM_EICHEN_EICH2EN_MASK)

#define EIM_EICHEN_EICH1EN_MASK                  (0x40000000U)
#define EIM_EICHEN_EICH1EN_SHIFT                 (30U)
/*! EICH1EN - Error Injection Channel 1 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 1
 *  0b1..Error injection is enabled on Error Injection Channel 1
 */
#define EIM_EICHEN_EICH1EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH1EN_SHIFT)) & EIM_EICHEN_EICH1EN_MASK)

#define EIM_EICHEN_EICH0EN_MASK                  (0x80000000U)
#define EIM_EICHEN_EICH0EN_SHIFT                 (31U)
/*! EICH0EN - Error Injection Channel 0 Enable
 *  0b0..Error injection is disabled on Error Injection Channel 0
 *  0b1..Error injection is enabled on Error Injection Channel 0
 */
#define EIM_EICHEN_EICH0EN(x)                    (((uint32_t)(((uint32_t)(x)) << EIM_EICHEN_EICH0EN_SHIFT)) & EIM_EICHEN_EICH0EN_MASK)
/*! @} */

/*! @name EICHD0_WORD0 - Error Injection Channel Descriptor 0, Word0 */
/*! @{ */

#define EIM_EICHD0_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD0_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD0_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD0_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD0_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD0_WORD1 - Error Injection Channel Descriptor 0, Word1 */
/*! @{ */

#define EIM_EICHD0_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD0_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD0_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD0_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD0_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD1_WORD0 - Error Injection Channel Descriptor 1, Word0 */
/*! @{ */

#define EIM_EICHD1_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD1_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD1_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD1_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD1_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD1_WORD1 - Error Injection Channel Descriptor 1, Word1 */
/*! @{ */

#define EIM_EICHD1_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD1_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD1_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD1_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD1_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD2_WORD0 - Error Injection Channel Descriptor 2, Word0 */
/*! @{ */

#define EIM_EICHD2_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD2_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD2_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD2_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD2_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD2_WORD1 - Error Injection Channel Descriptor 2, Word1 */
/*! @{ */

#define EIM_EICHD2_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD2_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD2_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD2_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD2_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD3_WORD0 - Error Injection Channel Descriptor 3, Word0 */
/*! @{ */

#define EIM_EICHD3_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD3_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD3_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD3_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD3_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD3_WORD1 - Error Injection Channel Descriptor 3, Word1 */
/*! @{ */

#define EIM_EICHD3_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD3_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD3_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD3_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD3_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD4_WORD0 - Error Injection Channel Descriptor 4, Word0 */
/*! @{ */

#define EIM_EICHD4_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD4_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD4_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD4_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD4_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD4_WORD1 - Error Injection Channel Descriptor 4, Word1 */
/*! @{ */

#define EIM_EICHD4_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD4_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD4_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD4_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD4_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD5_WORD0 - Error Injection Channel Descriptor 5, Word0 */
/*! @{ */

#define EIM_EICHD5_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD5_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD5_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD5_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD5_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD5_WORD1 - Error Injection Channel Descriptor 5, Word1 */
/*! @{ */

#define EIM_EICHD5_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD5_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD5_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD5_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD5_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD6_WORD0 - Error Injection Channel Descriptor 6, Word0 */
/*! @{ */

#define EIM_EICHD6_WORD0_CHKBIT_MASK_MASK        (0xFE000000U)
#define EIM_EICHD6_WORD0_CHKBIT_MASK_SHIFT       (25U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD6_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD6_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD6_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD6_WORD1 - Error Injection Channel Descriptor 6, Word1 */
/*! @{ */

#define EIM_EICHD6_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD6_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD6_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD6_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD6_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD7_WORD0 - Error Injection Channel Descriptor 7, Word0 */
/*! @{ */

#define EIM_EICHD7_WORD0_CHKBIT_MASK_MASK        (0x80000000U)
#define EIM_EICHD7_WORD0_CHKBIT_MASK_SHIFT       (31U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD7_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD7_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD7_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD7_WORD1 - Error Injection Channel Descriptor 7, Word1 */
/*! @{ */

#define EIM_EICHD7_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD7_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD7_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD7_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD7_WORD1_B0_3DATA_MASK_MASK)
/*! @} */

/*! @name EICHD8_WORD0 - Error Injection Channel Descriptor 8, Word0 */
/*! @{ */

#define EIM_EICHD8_WORD0_CHKBIT_MASK_MASK        (0xF0000000U)
#define EIM_EICHD8_WORD0_CHKBIT_MASK_SHIFT       (28U)
/*! CHKBIT_MASK - Checkbit Mask */
#define EIM_EICHD8_WORD0_CHKBIT_MASK(x)          (((uint32_t)(((uint32_t)(x)) << EIM_EICHD8_WORD0_CHKBIT_MASK_SHIFT)) & EIM_EICHD8_WORD0_CHKBIT_MASK_MASK)
/*! @} */

/*! @name EICHD8_WORD1 - Error Injection Channel Descriptor 8, Word1 */
/*! @{ */

#define EIM_EICHD8_WORD1_B0_3DATA_MASK_MASK      (0xFFFFFFFFU)
#define EIM_EICHD8_WORD1_B0_3DATA_MASK_SHIFT     (0U)
/*! B0_3DATA_MASK - Data Mask Bytes 0-3 */
#define EIM_EICHD8_WORD1_B0_3DATA_MASK(x)        (((uint32_t)(((uint32_t)(x)) << EIM_EICHD8_WORD1_B0_3DATA_MASK_SHIFT)) & EIM_EICHD8_WORD1_B0_3DATA_MASK_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group EIM_Register_Masks */


/* EIM - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral EIM0 base address */
  #define EIM0_BASE                                (0x5005B000u)
  /** Peripheral EIM0 base address */
  #define EIM0_BASE_NS                             (0x4005B000u)
  /** Peripheral EIM0 base pointer */
  #define EIM0                                     ((EIM_Type *)EIM0_BASE)
  /** Peripheral EIM0 base pointer */
  #define EIM0_NS                                  ((EIM_Type *)EIM0_BASE_NS)
  /** Array initializer of EIM peripheral base addresses */
  #define EIM_BASE_ADDRS                           { EIM0_BASE }
  /** Array initializer of EIM peripheral base pointers */
  #define EIM_BASE_PTRS                            { EIM0 }
  /** Array initializer of EIM peripheral base addresses */
  #define EIM_BASE_ADDRS_NS                        { EIM0_BASE_NS }
  /** Array initializer of EIM peripheral base pointers */
  #define EIM_BASE_PTRS_NS                         { EIM0_NS }
#else
  /** Peripheral EIM0 base address */
  #define EIM0_BASE                                (0x4005B000u)
  /** Peripheral EIM0 base pointer */
  #define EIM0                                     ((EIM_Type *)EIM0_BASE)
  /** Array initializer of EIM peripheral base addresses */
  #define EIM_BASE_ADDRS                           { EIM0_BASE }
  /** Array initializer of EIM peripheral base pointers */
  #define EIM_BASE_PTRS                            { EIM0 }
#endif

/*!
 * @}
 */ /* end of group EIM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EMVSIM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EMVSIM_Peripheral_Access_Layer EMVSIM Peripheral Access Layer
 * @{
 */

/** EMVSIM - Register Layout Typedef */
typedef struct {
  __I  uint32_t VER_ID;                            /**< Version ID, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameters, offset: 0x4 */
  __IO uint32_t CLKCFG;                            /**< Clock Configuration, offset: 0x8 */
  __IO uint32_t DIVISOR;                           /**< Baud Rate Divisor, offset: 0xC */
  __IO uint32_t CTRL;                              /**< Control, offset: 0x10 */
  __IO uint32_t INT_MASK;                          /**< Interrupt Mask, offset: 0x14 */
  __IO uint32_t RX_THD;                            /**< Receiver Threshold, offset: 0x18 */
  __IO uint32_t TX_THD;                            /**< Transmitter Threshold, offset: 0x1C */
  __IO uint32_t RX_STATUS;                         /**< Receive Status, offset: 0x20 */
  __IO uint32_t TX_STATUS;                         /**< Transmitter Status, offset: 0x24 */
  __IO uint32_t PCSR;                              /**< Port Control and Status, offset: 0x28 */
  __I  uint32_t RX_BUF;                            /**< Receive Data Read Buffer, offset: 0x2C */
  __O  uint32_t TX_BUF;                            /**< Transmit Data Buffer, offset: 0x30 */
  __IO uint32_t TX_GETU;                           /**< Transmitter Guard ETU Value, offset: 0x34 */
  __IO uint32_t CWT_VAL;                           /**< Character Wait Time Value, offset: 0x38 */
  __IO uint32_t BWT_VAL;                           /**< Block Wait Time Value, offset: 0x3C */
  __IO uint32_t BGT_VAL;                           /**< Block Guard Time Value, offset: 0x40 */
  __IO uint32_t GPCNT0_VAL;                        /**< General Purpose Counter 0 Timeout Value, offset: 0x44 */
  __IO uint32_t GPCNT1_VAL;                        /**< General Purpose Counter 1 Timeout Value, offset: 0x48 */
} EMVSIM_Type;

/* ----------------------------------------------------------------------------
   -- EMVSIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EMVSIM_Register_Masks EMVSIM Register Masks
 * @{
 */

/*! @name VER_ID - Version ID */
/*! @{ */

#define EMVSIM_VER_ID_VER_MASK                   (0xFFFFFFFFU)
#define EMVSIM_VER_ID_VER_SHIFT                  (0U)
/*! VER - Version ID */
#define EMVSIM_VER_ID_VER(x)                     (((uint32_t)(((uint32_t)(x)) << EMVSIM_VER_ID_VER_SHIFT)) & EMVSIM_VER_ID_VER_MASK)
/*! @} */

/*! @name PARAM - Parameters */
/*! @{ */

#define EMVSIM_PARAM_RX_FIFO_DEPTH_MASK          (0xFFU)
#define EMVSIM_PARAM_RX_FIFO_DEPTH_SHIFT         (0U)
/*! RX_FIFO_DEPTH - Receive FIFO Depth */
#define EMVSIM_PARAM_RX_FIFO_DEPTH(x)            (((uint32_t)(((uint32_t)(x)) << EMVSIM_PARAM_RX_FIFO_DEPTH_SHIFT)) & EMVSIM_PARAM_RX_FIFO_DEPTH_MASK)

#define EMVSIM_PARAM_TX_FIFO_DEPTH_MASK          (0xFF00U)
#define EMVSIM_PARAM_TX_FIFO_DEPTH_SHIFT         (8U)
/*! TX_FIFO_DEPTH - Transmit FIFO Depth */
#define EMVSIM_PARAM_TX_FIFO_DEPTH(x)            (((uint32_t)(((uint32_t)(x)) << EMVSIM_PARAM_TX_FIFO_DEPTH_SHIFT)) & EMVSIM_PARAM_TX_FIFO_DEPTH_MASK)
/*! @} */

/*! @name CLKCFG - Clock Configuration */
/*! @{ */

#define EMVSIM_CLKCFG_CLK_PRSC_MASK              (0xFFU)
#define EMVSIM_CLKCFG_CLK_PRSC_SHIFT             (0U)
/*! CLK_PRSC - Clock Prescaler Value */
#define EMVSIM_CLKCFG_CLK_PRSC(x)                (((uint32_t)(((uint32_t)(x)) << EMVSIM_CLKCFG_CLK_PRSC_SHIFT)) & EMVSIM_CLKCFG_CLK_PRSC_MASK)

#define EMVSIM_CLKCFG_GPCNT1_CLK_SEL_MASK        (0x300U)
#define EMVSIM_CLKCFG_GPCNT1_CLK_SEL_SHIFT       (8U)
/*! GPCNT1_CLK_SEL - General Purpose Counter 1 Clock Select
 *  0b00..Disable/reset
 *  0b01..Card clock
 *  0b10..Receive clock
 *  0b11..ETU clock (transmit clock)
 */
#define EMVSIM_CLKCFG_GPCNT1_CLK_SEL(x)          (((uint32_t)(((uint32_t)(x)) << EMVSIM_CLKCFG_GPCNT1_CLK_SEL_SHIFT)) & EMVSIM_CLKCFG_GPCNT1_CLK_SEL_MASK)

#define EMVSIM_CLKCFG_GPCNT0_CLK_SEL_MASK        (0xC00U)
#define EMVSIM_CLKCFG_GPCNT0_CLK_SEL_SHIFT       (10U)
/*! GPCNT0_CLK_SEL - General Purpose Counter 0 Clock Select
 *  0b00..Disable/reset
 *  0b01..Card clock
 *  0b10..Receive clock
 *  0b11..ETU clock (transmit clock)
 */
#define EMVSIM_CLKCFG_GPCNT0_CLK_SEL(x)          (((uint32_t)(((uint32_t)(x)) << EMVSIM_CLKCFG_GPCNT0_CLK_SEL_SHIFT)) & EMVSIM_CLKCFG_GPCNT0_CLK_SEL_MASK)
/*! @} */

/*! @name DIVISOR - Baud Rate Divisor */
/*! @{ */

#define EMVSIM_DIVISOR_DIVISOR_VALUE_MASK        (0x1FFU)
#define EMVSIM_DIVISOR_DIVISOR_VALUE_SHIFT       (0U)
/*! DIVISOR_VALUE - Divisor (F/D) Value
 *  0b000000000-0b000000100..Invalid. As per ISO 7816 specification, the minimum value of F/D is 5.
 *  0b000000101-0b011111111..Divisor value F/D
 */
#define EMVSIM_DIVISOR_DIVISOR_VALUE(x)          (((uint32_t)(((uint32_t)(x)) << EMVSIM_DIVISOR_DIVISOR_VALUE_SHIFT)) & EMVSIM_DIVISOR_DIVISOR_VALUE_MASK)
/*! @} */

/*! @name CTRL - Control */
/*! @{ */

#define EMVSIM_CTRL_IC_MASK                      (0x1U)
#define EMVSIM_CTRL_IC_SHIFT                     (0U)
/*! IC - Inverse Convention
 *  0b0..Direct
 *  0b1..Inverse
 */
#define EMVSIM_CTRL_IC(x)                        (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_IC_SHIFT)) & EMVSIM_CTRL_IC_MASK)

#define EMVSIM_CTRL_ICM_MASK                     (0x2U)
#define EMVSIM_CTRL_ICM_SHIFT                    (1U)
/*! ICM - Initial Character Mode
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_ICM(x)                       (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_ICM_SHIFT)) & EMVSIM_CTRL_ICM_MASK)

#define EMVSIM_CTRL_ANACK_MASK                   (0x4U)
#define EMVSIM_CTRL_ANACK_SHIFT                  (2U)
/*! ANACK - Auto NACK Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_ANACK(x)                     (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_ANACK_SHIFT)) & EMVSIM_CTRL_ANACK_MASK)

#define EMVSIM_CTRL_ONACK_MASK                   (0x8U)
#define EMVSIM_CTRL_ONACK_SHIFT                  (3U)
/*! ONACK - Overrun NACK Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_ONACK(x)                     (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_ONACK_SHIFT)) & EMVSIM_CTRL_ONACK_MASK)

#define EMVSIM_CTRL_FLSH_RX_MASK                 (0x100U)
#define EMVSIM_CTRL_FLSH_RX_SHIFT                (8U)
/*! FLSH_RX - Flush Receiver
 *  0b0..Normal
 *  0b1..Reset
 */
#define EMVSIM_CTRL_FLSH_RX(x)                   (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_FLSH_RX_SHIFT)) & EMVSIM_CTRL_FLSH_RX_MASK)

#define EMVSIM_CTRL_FLSH_TX_MASK                 (0x200U)
#define EMVSIM_CTRL_FLSH_TX_SHIFT                (9U)
/*! FLSH_TX - Flush Transmitter
 *  0b0..Normal
 *  0b1..Reset
 */
#define EMVSIM_CTRL_FLSH_TX(x)                   (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_FLSH_TX_SHIFT)) & EMVSIM_CTRL_FLSH_TX_MASK)

#define EMVSIM_CTRL_SW_RST_MASK                  (0x400U)
#define EMVSIM_CTRL_SW_RST_SHIFT                 (10U)
/*! SW_RST - Software Reset
 *  0b0..Normal
 *  0b1..Reset
 */
#define EMVSIM_CTRL_SW_RST(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_SW_RST_SHIFT)) & EMVSIM_CTRL_SW_RST_MASK)

#define EMVSIM_CTRL_KILL_CLOCKS_MASK             (0x800U)
#define EMVSIM_CTRL_KILL_CLOCKS_SHIFT            (11U)
/*! KILL_CLOCKS - Kill Internal Clocks
 *  0b0..Enable
 *  0b1..Disable
 */
#define EMVSIM_CTRL_KILL_CLOCKS(x)               (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_KILL_CLOCKS_SHIFT)) & EMVSIM_CTRL_KILL_CLOCKS_MASK)

#define EMVSIM_CTRL_DOZE_EN_MASK                 (0x1000U)
#define EMVSIM_CTRL_DOZE_EN_SHIFT                (12U)
/*! DOZE_EN - Doze Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_DOZE_EN(x)                   (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_DOZE_EN_SHIFT)) & EMVSIM_CTRL_DOZE_EN_MASK)

#define EMVSIM_CTRL_STOP_EN_MASK                 (0x2000U)
#define EMVSIM_CTRL_STOP_EN_SHIFT                (13U)
/*! STOP_EN - STOP Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_STOP_EN(x)                   (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_STOP_EN_SHIFT)) & EMVSIM_CTRL_STOP_EN_MASK)

#define EMVSIM_CTRL_RCV_EN_MASK                  (0x10000U)
#define EMVSIM_CTRL_RCV_EN_SHIFT                 (16U)
/*! RCV_EN - Receiver Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_RCV_EN(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_RCV_EN_SHIFT)) & EMVSIM_CTRL_RCV_EN_MASK)

#define EMVSIM_CTRL_XMT_EN_MASK                  (0x20000U)
#define EMVSIM_CTRL_XMT_EN_SHIFT                 (17U)
/*! XMT_EN - Transmitter Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_XMT_EN(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_XMT_EN_SHIFT)) & EMVSIM_CTRL_XMT_EN_MASK)

#define EMVSIM_CTRL_RCVR_11_MASK                 (0x40000U)
#define EMVSIM_CTRL_RCVR_11_SHIFT                (18U)
/*! RCVR_11 - Receiver 11 ETU Mode Enable
 *  0b0..12 ETU operation
 *  0b1..11 ETU operation
 */
#define EMVSIM_CTRL_RCVR_11(x)                   (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_RCVR_11_SHIFT)) & EMVSIM_CTRL_RCVR_11_MASK)

#define EMVSIM_CTRL_RX_DMA_EN_MASK               (0x80000U)
#define EMVSIM_CTRL_RX_DMA_EN_SHIFT              (19U)
/*! RX_DMA_EN - Receive DMA Enable
 *  0b0..Not asserted
 *  0b1..Asserted
 */
#define EMVSIM_CTRL_RX_DMA_EN(x)                 (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_RX_DMA_EN_SHIFT)) & EMVSIM_CTRL_RX_DMA_EN_MASK)

#define EMVSIM_CTRL_TX_DMA_EN_MASK               (0x100000U)
#define EMVSIM_CTRL_TX_DMA_EN_SHIFT              (20U)
/*! TX_DMA_EN - Transmit DMA Enable
 *  0b0..Not asserted
 *  0b1..Asserted
 */
#define EMVSIM_CTRL_TX_DMA_EN(x)                 (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_TX_DMA_EN_SHIFT)) & EMVSIM_CTRL_TX_DMA_EN_MASK)

#define EMVSIM_CTRL_INV_CRC_VAL_MASK             (0x1000000U)
#define EMVSIM_CTRL_INV_CRC_VAL_SHIFT            (24U)
/*! INV_CRC_VAL - Invert CRC Output Value Bits
 *  0b0..Not inverted
 *  0b1..Inverted
 */
#define EMVSIM_CTRL_INV_CRC_VAL(x)               (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_INV_CRC_VAL_SHIFT)) & EMVSIM_CTRL_INV_CRC_VAL_MASK)

#define EMVSIM_CTRL_CRC_OUT_FLIP_MASK            (0x2000000U)
#define EMVSIM_CTRL_CRC_OUT_FLIP_SHIFT           (25U)
/*! CRC_OUT_FLIP - CRC Output Value Bit Reversal Or Flip Control
 *  0b0..Not reversed
 *  0b1..Reversed
 */
#define EMVSIM_CTRL_CRC_OUT_FLIP(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_CRC_OUT_FLIP_SHIFT)) & EMVSIM_CTRL_CRC_OUT_FLIP_MASK)

#define EMVSIM_CTRL_CRC_IN_FLIP_MASK             (0x4000000U)
#define EMVSIM_CTRL_CRC_IN_FLIP_SHIFT            (26U)
/*! CRC_IN_FLIP - CRC Input Byte's Bit Reversal Or Flip Control
 *  0b0..Not reversed
 *  0b1..Reversed
 */
#define EMVSIM_CTRL_CRC_IN_FLIP(x)               (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_CRC_IN_FLIP_SHIFT)) & EMVSIM_CTRL_CRC_IN_FLIP_MASK)

#define EMVSIM_CTRL_CWT_EN_MASK                  (0x8000000U)
#define EMVSIM_CTRL_CWT_EN_SHIFT                 (27U)
/*! CWT_EN - CWT Counter Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_CWT_EN(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_CWT_EN_SHIFT)) & EMVSIM_CTRL_CWT_EN_MASK)

#define EMVSIM_CTRL_LRC_EN_MASK                  (0x10000000U)
#define EMVSIM_CTRL_LRC_EN_SHIFT                 (28U)
/*! LRC_EN - LRC Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_LRC_EN(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_LRC_EN_SHIFT)) & EMVSIM_CTRL_LRC_EN_MASK)

#define EMVSIM_CTRL_CRC_EN_MASK                  (0x20000000U)
#define EMVSIM_CTRL_CRC_EN_SHIFT                 (29U)
/*! CRC_EN - CRC Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_CRC_EN(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_CRC_EN_SHIFT)) & EMVSIM_CTRL_CRC_EN_MASK)

#define EMVSIM_CTRL_XMT_CRC_LRC_MASK             (0x40000000U)
#define EMVSIM_CTRL_XMT_CRC_LRC_SHIFT            (30U)
/*! XMT_CRC_LRC - Transmit CRC or LRC Enable
 *  0b0..Do not transmit
 *  0b1..Transmit
 */
#define EMVSIM_CTRL_XMT_CRC_LRC(x)               (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_XMT_CRC_LRC_SHIFT)) & EMVSIM_CTRL_XMT_CRC_LRC_MASK)

#define EMVSIM_CTRL_BWT_EN_MASK                  (0x80000000U)
#define EMVSIM_CTRL_BWT_EN_SHIFT                 (31U)
/*! BWT_EN - Block Wait Time Counter Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_CTRL_BWT_EN(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_CTRL_BWT_EN_SHIFT)) & EMVSIM_CTRL_BWT_EN_MASK)
/*! @} */

/*! @name INT_MASK - Interrupt Mask */
/*! @{ */

#define EMVSIM_INT_MASK_RDT_IM_MASK              (0x1U)
#define EMVSIM_INT_MASK_RDT_IM_SHIFT             (0U)
/*! RDT_IM - Receive Data Threshold Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_RDT_IM(x)                (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_RDT_IM_SHIFT)) & EMVSIM_INT_MASK_RDT_IM_MASK)

#define EMVSIM_INT_MASK_TC_IM_MASK               (0x2U)
#define EMVSIM_INT_MASK_TC_IM_SHIFT              (1U)
/*! TC_IM - Transmit Complete Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_TC_IM(x)                 (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_TC_IM_SHIFT)) & EMVSIM_INT_MASK_TC_IM_MASK)

#define EMVSIM_INT_MASK_RFO_IM_MASK              (0x4U)
#define EMVSIM_INT_MASK_RFO_IM_SHIFT             (2U)
/*! RFO_IM - Receive FIFO Overflow Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_RFO_IM(x)                (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_RFO_IM_SHIFT)) & EMVSIM_INT_MASK_RFO_IM_MASK)

#define EMVSIM_INT_MASK_ETC_IM_MASK              (0x8U)
#define EMVSIM_INT_MASK_ETC_IM_SHIFT             (3U)
/*! ETC_IM - Early Transmit Complete Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_ETC_IM(x)                (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_ETC_IM_SHIFT)) & EMVSIM_INT_MASK_ETC_IM_MASK)

#define EMVSIM_INT_MASK_TFE_IM_MASK              (0x10U)
#define EMVSIM_INT_MASK_TFE_IM_SHIFT             (4U)
/*! TFE_IM - Transmit FIFO Empty Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_TFE_IM(x)                (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_TFE_IM_SHIFT)) & EMVSIM_INT_MASK_TFE_IM_MASK)

#define EMVSIM_INT_MASK_TNACK_IM_MASK            (0x20U)
#define EMVSIM_INT_MASK_TNACK_IM_SHIFT           (5U)
/*! TNACK_IM - Transmit NACK Threshold Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_TNACK_IM(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_TNACK_IM_SHIFT)) & EMVSIM_INT_MASK_TNACK_IM_MASK)

#define EMVSIM_INT_MASK_TFF_IM_MASK              (0x40U)
#define EMVSIM_INT_MASK_TFF_IM_SHIFT             (6U)
/*! TFF_IM - Transmit FIFO Full Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_TFF_IM(x)                (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_TFF_IM_SHIFT)) & EMVSIM_INT_MASK_TFF_IM_MASK)

#define EMVSIM_INT_MASK_TDT_IM_MASK              (0x80U)
#define EMVSIM_INT_MASK_TDT_IM_SHIFT             (7U)
/*! TDT_IM - Transmit Data Threshold Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_TDT_IM(x)                (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_TDT_IM_SHIFT)) & EMVSIM_INT_MASK_TDT_IM_MASK)

#define EMVSIM_INT_MASK_GPCNT0_IM_MASK           (0x100U)
#define EMVSIM_INT_MASK_GPCNT0_IM_SHIFT          (8U)
/*! GPCNT0_IM - General Purpose Timer 0 Timeout Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_GPCNT0_IM(x)             (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_GPCNT0_IM_SHIFT)) & EMVSIM_INT_MASK_GPCNT0_IM_MASK)

#define EMVSIM_INT_MASK_CWT_ERR_IM_MASK          (0x200U)
#define EMVSIM_INT_MASK_CWT_ERR_IM_SHIFT         (9U)
/*! CWT_ERR_IM - Character Wait Time Error Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_CWT_ERR_IM(x)            (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_CWT_ERR_IM_SHIFT)) & EMVSIM_INT_MASK_CWT_ERR_IM_MASK)

#define EMVSIM_INT_MASK_RNACK_IM_MASK            (0x400U)
#define EMVSIM_INT_MASK_RNACK_IM_SHIFT           (10U)
/*! RNACK_IM - Receiver NACK Threshold Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_RNACK_IM(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_RNACK_IM_SHIFT)) & EMVSIM_INT_MASK_RNACK_IM_MASK)

#define EMVSIM_INT_MASK_BWT_ERR_IM_MASK          (0x800U)
#define EMVSIM_INT_MASK_BWT_ERR_IM_SHIFT         (11U)
/*! BWT_ERR_IM - Block Wait Time Error Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_BWT_ERR_IM(x)            (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_BWT_ERR_IM_SHIFT)) & EMVSIM_INT_MASK_BWT_ERR_IM_MASK)

#define EMVSIM_INT_MASK_BGT_ERR_IM_MASK          (0x1000U)
#define EMVSIM_INT_MASK_BGT_ERR_IM_SHIFT         (12U)
/*! BGT_ERR_IM - Block Guard Time Error Interrupt
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_BGT_ERR_IM(x)            (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_BGT_ERR_IM_SHIFT)) & EMVSIM_INT_MASK_BGT_ERR_IM_MASK)

#define EMVSIM_INT_MASK_GPCNT1_IM_MASK           (0x2000U)
#define EMVSIM_INT_MASK_GPCNT1_IM_SHIFT          (13U)
/*! GPCNT1_IM - General Purpose Counter 1 Timeout Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_GPCNT1_IM(x)             (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_GPCNT1_IM_SHIFT)) & EMVSIM_INT_MASK_GPCNT1_IM_MASK)

#define EMVSIM_INT_MASK_RX_DATA_IM_MASK          (0x4000U)
#define EMVSIM_INT_MASK_RX_DATA_IM_SHIFT         (14U)
/*! RX_DATA_IM - Receive Data Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_RX_DATA_IM(x)            (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_RX_DATA_IM_SHIFT)) & EMVSIM_INT_MASK_RX_DATA_IM_MASK)

#define EMVSIM_INT_MASK_PEF_IM_MASK              (0x8000U)
#define EMVSIM_INT_MASK_PEF_IM_SHIFT             (15U)
/*! PEF_IM - Parity Error Interrupt Mask
 *  0b0..Enable
 *  0b1..Masked
 */
#define EMVSIM_INT_MASK_PEF_IM(x)                (((uint32_t)(((uint32_t)(x)) << EMVSIM_INT_MASK_PEF_IM_SHIFT)) & EMVSIM_INT_MASK_PEF_IM_MASK)
/*! @} */

/*! @name RX_THD - Receiver Threshold */
/*! @{ */

#define EMVSIM_RX_THD_RDT_MASK                   (0xFU)
#define EMVSIM_RX_THD_RDT_SHIFT                  (0U)
/*! RDT - Receiver Data Threshold Value */
#define EMVSIM_RX_THD_RDT(x)                     (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_THD_RDT_SHIFT)) & EMVSIM_RX_THD_RDT_MASK)

#define EMVSIM_RX_THD_RNCK_THD_MASK              (0xF00U)
#define EMVSIM_RX_THD_RNCK_THD_SHIFT             (8U)
/*! RNCK_THD - Receiver NACK Threshold Value */
#define EMVSIM_RX_THD_RNCK_THD(x)                (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_THD_RNCK_THD_SHIFT)) & EMVSIM_RX_THD_RNCK_THD_MASK)
/*! @} */

/*! @name TX_THD - Transmitter Threshold */
/*! @{ */

#define EMVSIM_TX_THD_TDT_MASK                   (0xFU)
#define EMVSIM_TX_THD_TDT_SHIFT                  (0U)
/*! TDT - Transmitter Data Threshold Value */
#define EMVSIM_TX_THD_TDT(x)                     (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_THD_TDT_SHIFT)) & EMVSIM_TX_THD_TDT_MASK)

#define EMVSIM_TX_THD_TNCK_THD_MASK              (0xF00U)
#define EMVSIM_TX_THD_TNCK_THD_SHIFT             (8U)
/*! TNCK_THD - Transmitter NACK Threshold Value */
#define EMVSIM_TX_THD_TNCK_THD(x)                (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_THD_TNCK_THD_SHIFT)) & EMVSIM_TX_THD_TNCK_THD_MASK)
/*! @} */

/*! @name RX_STATUS - Receive Status */
/*! @{ */

#define EMVSIM_RX_STATUS_RFO_MASK                (0x1U)
#define EMVSIM_RX_STATUS_RFO_SHIFT               (0U)
/*! RFO - Receive FIFO Overflow Flag
 *  0b0..No overrun error
 *  0b1..Overrun error
 */
#define EMVSIM_RX_STATUS_RFO(x)                  (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_RFO_SHIFT)) & EMVSIM_RX_STATUS_RFO_MASK)

#define EMVSIM_RX_STATUS_RX_DATA_MASK            (0x10U)
#define EMVSIM_RX_STATUS_RX_DATA_SHIFT           (4U)
/*! RX_DATA - Receive Data Interrupt Flag
 *  0b0..No new byte
 *  0b1..New byte
 */
#define EMVSIM_RX_STATUS_RX_DATA(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_RX_DATA_SHIFT)) & EMVSIM_RX_STATUS_RX_DATA_MASK)

#define EMVSIM_RX_STATUS_RDTF_MASK               (0x20U)
#define EMVSIM_RX_STATUS_RDTF_SHIFT              (5U)
/*! RDTF - Receive Data Threshold Interrupt Flag
 *  0b0..Less than threshold
 *  0b1..Greater than or equal to threshold
 */
#define EMVSIM_RX_STATUS_RDTF(x)                 (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_RDTF_SHIFT)) & EMVSIM_RX_STATUS_RDTF_MASK)

#define EMVSIM_RX_STATUS_LRC_OK_MASK             (0x40U)
#define EMVSIM_RX_STATUS_LRC_OK_SHIFT            (6U)
/*! LRC_OK - LRC Check OK Flag
 *  0b0..No match
 *  0b1..Match
 */
#define EMVSIM_RX_STATUS_LRC_OK(x)               (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_LRC_OK_SHIFT)) & EMVSIM_RX_STATUS_LRC_OK_MASK)

#define EMVSIM_RX_STATUS_CRC_OK_MASK             (0x80U)
#define EMVSIM_RX_STATUS_CRC_OK_SHIFT            (7U)
/*! CRC_OK - CRC Check OK Flag
 *  0b0..Current CRC value does not match remainder.
 *  0b1..Current calculated CRC value matches the expected result.
 */
#define EMVSIM_RX_STATUS_CRC_OK(x)               (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_CRC_OK_SHIFT)) & EMVSIM_RX_STATUS_CRC_OK_MASK)

#define EMVSIM_RX_STATUS_CWT_ERR_MASK            (0x100U)
#define EMVSIM_RX_STATUS_CWT_ERR_SHIFT           (8U)
/*! CWT_ERR - Character Wait Time Error Flag
 *  0b0..No CWT violation
 *  0b1..CWT violation
 */
#define EMVSIM_RX_STATUS_CWT_ERR(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_CWT_ERR_SHIFT)) & EMVSIM_RX_STATUS_CWT_ERR_MASK)

#define EMVSIM_RX_STATUS_RTE_MASK                (0x200U)
#define EMVSIM_RX_STATUS_RTE_SHIFT               (9U)
/*! RTE - Received NACK Threshold Error Flag
 *  0b0..Less than
 *  0b1..Equal to
 */
#define EMVSIM_RX_STATUS_RTE(x)                  (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_RTE_SHIFT)) & EMVSIM_RX_STATUS_RTE_MASK)

#define EMVSIM_RX_STATUS_BWT_ERR_MASK            (0x400U)
#define EMVSIM_RX_STATUS_BWT_ERR_SHIFT           (10U)
/*! BWT_ERR - Block Wait Time Error Flag
 *  0b0..Not exceeded
 *  0b1..Exceeded
 */
#define EMVSIM_RX_STATUS_BWT_ERR(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_BWT_ERR_SHIFT)) & EMVSIM_RX_STATUS_BWT_ERR_MASK)

#define EMVSIM_RX_STATUS_BGT_ERR_MASK            (0x800U)
#define EMVSIM_RX_STATUS_BGT_ERR_SHIFT           (11U)
/*! BGT_ERR - Block Guard Time Error Flag
 *  0b0..Sufficient
 *  0b1..Too small
 */
#define EMVSIM_RX_STATUS_BGT_ERR(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_BGT_ERR_SHIFT)) & EMVSIM_RX_STATUS_BGT_ERR_MASK)

#define EMVSIM_RX_STATUS_PEF_MASK                (0x1000U)
#define EMVSIM_RX_STATUS_PEF_SHIFT               (12U)
/*! PEF - Parity Error Flag
 *  0b0..No error
 *  0b1..Error
 */
#define EMVSIM_RX_STATUS_PEF(x)                  (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_PEF_SHIFT)) & EMVSIM_RX_STATUS_PEF_MASK)

#define EMVSIM_RX_STATUS_FEF_MASK                (0x2000U)
#define EMVSIM_RX_STATUS_FEF_SHIFT               (13U)
/*! FEF - Frame Error Flag
 *  0b0..No error
 *  0b1..Error
 */
#define EMVSIM_RX_STATUS_FEF(x)                  (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_FEF_SHIFT)) & EMVSIM_RX_STATUS_FEF_MASK)

#define EMVSIM_RX_STATUS_RX_WPTR_MASK            (0xF0000U)
#define EMVSIM_RX_STATUS_RX_WPTR_SHIFT           (16U)
/*! RX_WPTR - Receive FIFO Write Pointer Value */
#define EMVSIM_RX_STATUS_RX_WPTR(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_RX_WPTR_SHIFT)) & EMVSIM_RX_STATUS_RX_WPTR_MASK)

#define EMVSIM_RX_STATUS_RX_CNT_MASK             (0xF000000U)
#define EMVSIM_RX_STATUS_RX_CNT_SHIFT            (24U)
/*! RX_CNT - Receive FIFO Byte Count
 *  0b0000..FIFO empty
 */
#define EMVSIM_RX_STATUS_RX_CNT(x)               (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_STATUS_RX_CNT_SHIFT)) & EMVSIM_RX_STATUS_RX_CNT_MASK)
/*! @} */

/*! @name TX_STATUS - Transmitter Status */
/*! @{ */

#define EMVSIM_TX_STATUS_TNTE_MASK               (0x1U)
#define EMVSIM_TX_STATUS_TNTE_SHIFT              (0U)
/*! TNTE - Transmit NACK Threshold Error Flag
 *  0b0..Threshold not reached
 *  0b1..Threshold reached
 */
#define EMVSIM_TX_STATUS_TNTE(x)                 (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_STATUS_TNTE_SHIFT)) & EMVSIM_TX_STATUS_TNTE_MASK)

#define EMVSIM_TX_STATUS_TFE_MASK                (0x8U)
#define EMVSIM_TX_STATUS_TFE_SHIFT               (3U)
/*! TFE - Transmit FIFO Empty Flag
 *  0b0..Not empty
 *  0b1..Empty
 */
#define EMVSIM_TX_STATUS_TFE(x)                  (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_STATUS_TFE_SHIFT)) & EMVSIM_TX_STATUS_TFE_MASK)

#define EMVSIM_TX_STATUS_ETCF_MASK               (0x10U)
#define EMVSIM_TX_STATUS_ETCF_SHIFT              (4U)
/*! ETCF - Early Transmit Complete Flag
 *  0b0..Pending or incomplete
 *  0b1..Complete
 */
#define EMVSIM_TX_STATUS_ETCF(x)                 (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_STATUS_ETCF_SHIFT)) & EMVSIM_TX_STATUS_ETCF_MASK)

#define EMVSIM_TX_STATUS_TCF_MASK                (0x20U)
#define EMVSIM_TX_STATUS_TCF_SHIFT               (5U)
/*! TCF - Transmit Complete Flag
 *  0b0..Pending or incomplete
 *  0b1..Complete
 */
#define EMVSIM_TX_STATUS_TCF(x)                  (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_STATUS_TCF_SHIFT)) & EMVSIM_TX_STATUS_TCF_MASK)

#define EMVSIM_TX_STATUS_TFF_MASK                (0x40U)
#define EMVSIM_TX_STATUS_TFF_SHIFT               (6U)
/*! TFF - Transmit FIFO Full Flag
 *  0b0..Not full
 *  0b1..Full
 */
#define EMVSIM_TX_STATUS_TFF(x)                  (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_STATUS_TFF_SHIFT)) & EMVSIM_TX_STATUS_TFF_MASK)

#define EMVSIM_TX_STATUS_TDTF_MASK               (0x80U)
#define EMVSIM_TX_STATUS_TDTF_SHIFT              (7U)
/*! TDTF - Transmit Data Threshold Flag
 *  0b0..Threshold exceeded or this field written to 0
 *  0b1..Threshold not exceeded
 */
#define EMVSIM_TX_STATUS_TDTF(x)                 (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_STATUS_TDTF_SHIFT)) & EMVSIM_TX_STATUS_TDTF_MASK)

#define EMVSIM_TX_STATUS_GPCNT0_TO_MASK          (0x100U)
#define EMVSIM_TX_STATUS_GPCNT0_TO_SHIFT         (8U)
/*! GPCNT0_TO - General Purpose Counter 0 Timeout Flag
 *  0b0..GPCNT0 not reached, or flag cleared
 *  0b1..GPCNT0 reached
 */
#define EMVSIM_TX_STATUS_GPCNT0_TO(x)            (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_STATUS_GPCNT0_TO_SHIFT)) & EMVSIM_TX_STATUS_GPCNT0_TO_MASK)

#define EMVSIM_TX_STATUS_GPCNT1_TO_MASK          (0x200U)
#define EMVSIM_TX_STATUS_GPCNT1_TO_SHIFT         (9U)
/*! GPCNT1_TO - General Purpose Counter 1 Timeout Flag
 *  0b0..GPCNT1 not reached, or flag cleared
 *  0b1..GPCNT1 reached
 */
#define EMVSIM_TX_STATUS_GPCNT1_TO(x)            (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_STATUS_GPCNT1_TO_SHIFT)) & EMVSIM_TX_STATUS_GPCNT1_TO_MASK)

#define EMVSIM_TX_STATUS_TX_RPTR_MASK            (0xF0000U)
#define EMVSIM_TX_STATUS_TX_RPTR_SHIFT           (16U)
/*! TX_RPTR - Transmit FIFO Read Pointer */
#define EMVSIM_TX_STATUS_TX_RPTR(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_STATUS_TX_RPTR_SHIFT)) & EMVSIM_TX_STATUS_TX_RPTR_MASK)

#define EMVSIM_TX_STATUS_TX_CNT_MASK             (0xF000000U)
#define EMVSIM_TX_STATUS_TX_CNT_SHIFT            (24U)
/*! TX_CNT - Transmit FIFO Byte Count
 *  0b0000..FIFO empty
 */
#define EMVSIM_TX_STATUS_TX_CNT(x)               (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_STATUS_TX_CNT_SHIFT)) & EMVSIM_TX_STATUS_TX_CNT_MASK)
/*! @} */

/*! @name PCSR - Port Control and Status */
/*! @{ */

#define EMVSIM_PCSR_SAPD_MASK                    (0x1U)
#define EMVSIM_PCSR_SAPD_SHIFT                   (0U)
/*! SAPD - Auto Power Down Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_PCSR_SAPD(x)                      (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_SAPD_SHIFT)) & EMVSIM_PCSR_SAPD_MASK)

#define EMVSIM_PCSR_SVCC_EN_MASK                 (0x2U)
#define EMVSIM_PCSR_SVCC_EN_SHIFT                (1U)
/*! SVCC_EN - Vcc Enable for Smart Card
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_PCSR_SVCC_EN(x)                   (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_SVCC_EN_SHIFT)) & EMVSIM_PCSR_SVCC_EN_MASK)

#define EMVSIM_PCSR_VCCENP_MASK                  (0x4U)
#define EMVSIM_PCSR_VCCENP_SHIFT                 (2U)
/*! VCCENP - VCC Enable Polarity Control
 *  0b0..Active high
 *  0b1..Active low
 */
#define EMVSIM_PCSR_VCCENP(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_VCCENP_SHIFT)) & EMVSIM_PCSR_VCCENP_MASK)

#define EMVSIM_PCSR_SRST_MASK                    (0x8U)
#define EMVSIM_PCSR_SRST_SHIFT                   (3U)
/*! SRST - Reset Smart Card
 *  0b0..Assert
 *  0b1..Deassert
 */
#define EMVSIM_PCSR_SRST(x)                      (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_SRST_SHIFT)) & EMVSIM_PCSR_SRST_MASK)

#define EMVSIM_PCSR_SCEN_MASK                    (0x10U)
#define EMVSIM_PCSR_SCEN_SHIFT                   (4U)
/*! SCEN - Clock Enable for Smart Card
 *  0b0..Disable
 *  0b1..Enable
 */
#define EMVSIM_PCSR_SCEN(x)                      (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_SCEN_SHIFT)) & EMVSIM_PCSR_SCEN_MASK)

#define EMVSIM_PCSR_SCSP_MASK                    (0x20U)
#define EMVSIM_PCSR_SCSP_SHIFT                   (5U)
/*! SCSP - Smart Card Clock Stop Polarity
 *  0b0..Logic 0
 *  0b1..Logic 1
 */
#define EMVSIM_PCSR_SCSP(x)                      (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_SCSP_SHIFT)) & EMVSIM_PCSR_SCSP_MASK)

#define EMVSIM_PCSR_SPD_MASK                     (0x80U)
#define EMVSIM_PCSR_SPD_SHIFT                    (7U)
/*! SPD - Auto Power-Down Control
 *  0b0..No
 *  0b1..Yes
 */
#define EMVSIM_PCSR_SPD(x)                       (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_SPD_SHIFT)) & EMVSIM_PCSR_SPD_MASK)

#define EMVSIM_PCSR_SPDIM_MASK                   (0x1000000U)
#define EMVSIM_PCSR_SPDIM_SHIFT                  (24U)
/*! SPDIM - Smart Card Presence Detect Interrupt Mask
 *  0b0..Enable
 *  0b1..Mask
 */
#define EMVSIM_PCSR_SPDIM(x)                     (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_SPDIM_SHIFT)) & EMVSIM_PCSR_SPDIM_MASK)

#define EMVSIM_PCSR_SPDIF_MASK                   (0x2000000U)
#define EMVSIM_PCSR_SPDIF_SHIFT                  (25U)
/*! SPDIF - Smart Card Presence Detect Interrupt Flag
 *  0b0..No insertion or removal
 *  0b1..Insertion or removal
 */
#define EMVSIM_PCSR_SPDIF(x)                     (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_SPDIF_SHIFT)) & EMVSIM_PCSR_SPDIF_MASK)

#define EMVSIM_PCSR_SPDP_MASK                    (0x4000000U)
#define EMVSIM_PCSR_SPDP_SHIFT                   (26U)
/*! SPDP - Smart Card Presence Detect Pin Status
 *  0b0..Logic low
 *  0b1..Logic high
 */
#define EMVSIM_PCSR_SPDP(x)                      (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_SPDP_SHIFT)) & EMVSIM_PCSR_SPDP_MASK)

#define EMVSIM_PCSR_SPDES_MASK                   (0x8000000U)
#define EMVSIM_PCSR_SPDES_SHIFT                  (27U)
/*! SPDES - SIM Presence Detect Edge Select
 *  0b0..Falling edge
 *  0b1..Rising edge
 */
#define EMVSIM_PCSR_SPDES(x)                     (((uint32_t)(((uint32_t)(x)) << EMVSIM_PCSR_SPDES_SHIFT)) & EMVSIM_PCSR_SPDES_MASK)
/*! @} */

/*! @name RX_BUF - Receive Data Read Buffer */
/*! @{ */

#define EMVSIM_RX_BUF_RX_BYTE_MASK               (0xFFU)
#define EMVSIM_RX_BUF_RX_BYTE_SHIFT              (0U)
/*! RX_BYTE - Receive Data Byte Read */
#define EMVSIM_RX_BUF_RX_BYTE(x)                 (((uint32_t)(((uint32_t)(x)) << EMVSIM_RX_BUF_RX_BYTE_SHIFT)) & EMVSIM_RX_BUF_RX_BYTE_MASK)
/*! @} */

/*! @name TX_BUF - Transmit Data Buffer */
/*! @{ */

#define EMVSIM_TX_BUF_TX_BYTE_MASK               (0xFFU)
#define EMVSIM_TX_BUF_TX_BYTE_SHIFT              (0U)
/*! TX_BYTE - Transmit Data Byte */
#define EMVSIM_TX_BUF_TX_BYTE(x)                 (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_BUF_TX_BYTE_SHIFT)) & EMVSIM_TX_BUF_TX_BYTE_MASK)
/*! @} */

/*! @name TX_GETU - Transmitter Guard ETU Value */
/*! @{ */

#define EMVSIM_TX_GETU_GETU_MASK                 (0xFFU)
#define EMVSIM_TX_GETU_GETU_SHIFT                (0U)
/*! GETU - Transmitter Guard Time Value in ETU */
#define EMVSIM_TX_GETU_GETU(x)                   (((uint32_t)(((uint32_t)(x)) << EMVSIM_TX_GETU_GETU_SHIFT)) & EMVSIM_TX_GETU_GETU_MASK)
/*! @} */

/*! @name CWT_VAL - Character Wait Time Value */
/*! @{ */

#define EMVSIM_CWT_VAL_CWT_MASK                  (0xFFFFU)
#define EMVSIM_CWT_VAL_CWT_SHIFT                 (0U)
/*! CWT - Character Wait Time Value */
#define EMVSIM_CWT_VAL_CWT(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_CWT_VAL_CWT_SHIFT)) & EMVSIM_CWT_VAL_CWT_MASK)
/*! @} */

/*! @name BWT_VAL - Block Wait Time Value */
/*! @{ */

#define EMVSIM_BWT_VAL_BWT_MASK                  (0xFFFFFFFFU)
#define EMVSIM_BWT_VAL_BWT_SHIFT                 (0U)
/*! BWT - Block Wait Time Value */
#define EMVSIM_BWT_VAL_BWT(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_BWT_VAL_BWT_SHIFT)) & EMVSIM_BWT_VAL_BWT_MASK)
/*! @} */

/*! @name BGT_VAL - Block Guard Time Value */
/*! @{ */

#define EMVSIM_BGT_VAL_BGT_MASK                  (0xFFFFU)
#define EMVSIM_BGT_VAL_BGT_SHIFT                 (0U)
/*! BGT - Block Guard Time Value */
#define EMVSIM_BGT_VAL_BGT(x)                    (((uint32_t)(((uint32_t)(x)) << EMVSIM_BGT_VAL_BGT_SHIFT)) & EMVSIM_BGT_VAL_BGT_MASK)
/*! @} */

/*! @name GPCNT0_VAL - General Purpose Counter 0 Timeout Value */
/*! @{ */

#define EMVSIM_GPCNT0_VAL_GPCNT0_MASK            (0xFFFFU)
#define EMVSIM_GPCNT0_VAL_GPCNT0_SHIFT           (0U)
/*! GPCNT0 - General Purpose Counter 0 Timeout Value */
#define EMVSIM_GPCNT0_VAL_GPCNT0(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_GPCNT0_VAL_GPCNT0_SHIFT)) & EMVSIM_GPCNT0_VAL_GPCNT0_MASK)
/*! @} */

/*! @name GPCNT1_VAL - General Purpose Counter 1 Timeout Value */
/*! @{ */

#define EMVSIM_GPCNT1_VAL_GPCNT1_MASK            (0xFFFFU)
#define EMVSIM_GPCNT1_VAL_GPCNT1_SHIFT           (0U)
/*! GPCNT1 - General Purpose Counter 1 Timeout Value */
#define EMVSIM_GPCNT1_VAL_GPCNT1(x)              (((uint32_t)(((uint32_t)(x)) << EMVSIM_GPCNT1_VAL_GPCNT1_SHIFT)) & EMVSIM_GPCNT1_VAL_GPCNT1_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group EMVSIM_Register_Masks */


/* EMVSIM - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral EMVSIM0 base address */
  #define EMVSIM0_BASE                             (0x50103000u)
  /** Peripheral EMVSIM0 base address */
  #define EMVSIM0_BASE_NS                          (0x40103000u)
  /** Peripheral EMVSIM0 base pointer */
  #define EMVSIM0                                  ((EMVSIM_Type *)EMVSIM0_BASE)
  /** Peripheral EMVSIM0 base pointer */
  #define EMVSIM0_NS                               ((EMVSIM_Type *)EMVSIM0_BASE_NS)
  /** Peripheral EMVSIM1 base address */
  #define EMVSIM1_BASE                             (0x50104000u)
  /** Peripheral EMVSIM1 base address */
  #define EMVSIM1_BASE_NS                          (0x40104000u)
  /** Peripheral EMVSIM1 base pointer */
  #define EMVSIM1                                  ((EMVSIM_Type *)EMVSIM1_BASE)
  /** Peripheral EMVSIM1 base pointer */
  #define EMVSIM1_NS                               ((EMVSIM_Type *)EMVSIM1_BASE_NS)
  /** Array initializer of EMVSIM peripheral base addresses */
  #define EMVSIM_BASE_ADDRS                        { EMVSIM0_BASE, EMVSIM1_BASE }
  /** Array initializer of EMVSIM peripheral base pointers */
  #define EMVSIM_BASE_PTRS                         { EMVSIM0, EMVSIM1 }
  /** Array initializer of EMVSIM peripheral base addresses */
  #define EMVSIM_BASE_ADDRS_NS                     { EMVSIM0_BASE_NS, EMVSIM1_BASE_NS }
  /** Array initializer of EMVSIM peripheral base pointers */
  #define EMVSIM_BASE_PTRS_NS                      { EMVSIM0_NS, EMVSIM1_NS }
#else
  /** Peripheral EMVSIM0 base address */
  #define EMVSIM0_BASE                             (0x40103000u)
  /** Peripheral EMVSIM0 base pointer */
  #define EMVSIM0                                  ((EMVSIM_Type *)EMVSIM0_BASE)
  /** Peripheral EMVSIM1 base address */
  #define EMVSIM1_BASE                             (0x40104000u)
  /** Peripheral EMVSIM1 base pointer */
  #define EMVSIM1                                  ((EMVSIM_Type *)EMVSIM1_BASE)
  /** Array initializer of EMVSIM peripheral base addresses */
  #define EMVSIM_BASE_ADDRS                        { EMVSIM0_BASE, EMVSIM1_BASE }
  /** Array initializer of EMVSIM peripheral base pointers */
  #define EMVSIM_BASE_PTRS                         { EMVSIM0, EMVSIM1 }
#endif
/** Interrupt vectors for the EMVSIM peripheral type */
#define EMVSIM_IRQS                              { EMVSIM0_IRQn, EMVSIM1_IRQn }

/*!
 * @}
 */ /* end of group EMVSIM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ENC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENC_Peripheral_Access_Layer ENC Peripheral Access Layer
 * @{
 */

/** ENC - Register Layout Typedef */
typedef struct {
  __IO uint16_t CTRL;                              /**< Control, offset: 0x0 */
  __IO uint16_t FILT;                              /**< Input Filter, offset: 0x2 */
  __IO uint16_t WTR;                               /**< Watchdog Timeout, offset: 0x4 */
  __IO uint16_t POSD;                              /**< Position Difference Counter, offset: 0x6 */
  __I  uint16_t POSDH;                             /**< Position Difference Hold, offset: 0x8 */
  __IO uint16_t REV;                               /**< Revolution Counter, offset: 0xA */
  __I  uint16_t REVH;                              /**< Revolution Hold, offset: 0xC */
  __IO uint16_t UPOS;                              /**< Upper Position Counter, offset: 0xE */
  __IO uint16_t LPOS;                              /**< Lower Position Counter, offset: 0x10 */
  __I  uint16_t UPOSH;                             /**< Upper Position Hold, offset: 0x12 */
  __I  uint16_t LPOSH;                             /**< Lower Position Hold, offset: 0x14 */
  __IO uint16_t UINIT;                             /**< Upper Initialization, offset: 0x16 */
  __IO uint16_t LINIT;                             /**< Lower Initialization, offset: 0x18 */
  __I  uint16_t IMR;                               /**< Input Monitor, offset: 0x1A */
  __IO uint16_t TST;                               /**< Test, offset: 0x1C */
  __IO uint16_t CTRL2;                             /**< Control 2, offset: 0x1E */
  __IO uint16_t UMOD;                              /**< Upper Modulus, offset: 0x20 */
  __IO uint16_t LMOD;                              /**< Lower Modulus, offset: 0x22 */
  __IO uint16_t UCOMP;                             /**< Upper Position Compare, offset: 0x24 */
  __IO uint16_t LCOMP;                             /**< Lower Position Compare, offset: 0x26 */
  __I  uint16_t LASTEDGE;                          /**< Last Edge Time, offset: 0x28 */
  __I  uint16_t LASTEDGEH;                         /**< Last Edge Time Hold, offset: 0x2A */
  __I  uint16_t POSDPER;                           /**< Position Difference Period Counter, offset: 0x2C */
  __I  uint16_t POSDPERBFR;                        /**< Position Difference Period Buffer, offset: 0x2E */
  __I  uint16_t POSDPERH;                          /**< Position Difference Period Hold, offset: 0x30 */
  __IO uint16_t CTRL3;                             /**< Control 3, offset: 0x32 */
} ENC_Type;

/* ----------------------------------------------------------------------------
   -- ENC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENC_Register_Masks ENC Register Masks
 * @{
 */

/*! @name CTRL - Control */
/*! @{ */

#define ENC_CTRL_CMPIE_MASK                      (0x1U)
#define ENC_CTRL_CMPIE_SHIFT                     (0U)
/*! CMPIE - Compare Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL_CMPIE(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_CMPIE_SHIFT)) & ENC_CTRL_CMPIE_MASK)

#define ENC_CTRL_CMPIRQ_MASK                     (0x2U)
#define ENC_CTRL_CMPIRQ_SHIFT                    (1U)
/*! CMPIRQ - Compare Interrupt Request
 *  0b0..No match has occurred
 *  0b1..COMP match has occurred
 */
#define ENC_CTRL_CMPIRQ(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_CMPIRQ_SHIFT)) & ENC_CTRL_CMPIRQ_MASK)

#define ENC_CTRL_WDE_MASK                        (0x4U)
#define ENC_CTRL_WDE_SHIFT                       (2U)
/*! WDE - Watchdog Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL_WDE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_WDE_SHIFT)) & ENC_CTRL_WDE_MASK)

#define ENC_CTRL_DIE_MASK                        (0x8U)
#define ENC_CTRL_DIE_SHIFT                       (3U)
/*! DIE - Watchdog Timeout Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL_DIE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_DIE_SHIFT)) & ENC_CTRL_DIE_MASK)

#define ENC_CTRL_DIRQ_MASK                       (0x10U)
#define ENC_CTRL_DIRQ_SHIFT                      (4U)
/*! DIRQ - Watchdog Timeout Interrupt Request
 *  0b0..Not occurred
 *  0b1..Occurred
 */
#define ENC_CTRL_DIRQ(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_DIRQ_SHIFT)) & ENC_CTRL_DIRQ_MASK)

#define ENC_CTRL_XNE_MASK                        (0x20U)
#define ENC_CTRL_XNE_SHIFT                       (5U)
/*! XNE - Select Positive and Negative Edge of INDEX Pulse
 *  0b0..Use positive edge
 *  0b1..Use negative edge
 */
#define ENC_CTRL_XNE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XNE_SHIFT)) & ENC_CTRL_XNE_MASK)

#define ENC_CTRL_XIP_MASK                        (0x40U)
#define ENC_CTRL_XIP_SHIFT                       (6U)
/*! XIP - INDEX Triggered Initialization of Position Counters UPOS and LPOS
 *  0b0..Does not initialize
 *  0b1..Initializes
 */
#define ENC_CTRL_XIP(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XIP_SHIFT)) & ENC_CTRL_XIP_MASK)

#define ENC_CTRL_XIE_MASK                        (0x80U)
#define ENC_CTRL_XIE_SHIFT                       (7U)
/*! XIE - INDEX Pulse Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL_XIE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XIE_SHIFT)) & ENC_CTRL_XIE_MASK)

#define ENC_CTRL_XIRQ_MASK                       (0x100U)
#define ENC_CTRL_XIRQ_SHIFT                      (8U)
/*! XIRQ - INDEX Pulse Interrupt Request
 *  0b0..Not occurred
 *  0b1..Occurred
 */
#define ENC_CTRL_XIRQ(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_XIRQ_SHIFT)) & ENC_CTRL_XIRQ_MASK)

#define ENC_CTRL_PH1_MASK                        (0x200U)
#define ENC_CTRL_PH1_SHIFT                       (9U)
/*! PH1 - Enable Signal Phase Count Mode
 *  0b0..Uses the standard quadrature decoder, where PHASEA and PHASEB represent a two-phase quadrature signal.
 *  0b1..Bypasses the quadrature decoder. A positive transition of the PHASEA input generates a count signal.
 *       PHASEB input and CTRL[REV] controls the counter direction. If the value of CTRL[REV] and PHASEB are identical;
 *       then count is up. If the value of CTRL[REV] and PHASEB is different, then count is down.
 */
#define ENC_CTRL_PH1(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_PH1_SHIFT)) & ENC_CTRL_PH1_MASK)

#define ENC_CTRL_REV_MASK                        (0x400U)
#define ENC_CTRL_REV_SHIFT                       (10U)
/*! REV - Enable Reverse Direction Counting
 *  0b0..Counts normally
 *  0b1..Counts in the reverse direction
 */
#define ENC_CTRL_REV(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_REV_SHIFT)) & ENC_CTRL_REV_MASK)

#define ENC_CTRL_SWIP_MASK                       (0x800U)
#define ENC_CTRL_SWIP_SHIFT                      (11U)
/*! SWIP - Software-Triggered Initialization of Position Counters UPOS and LPOS
 *  0b0..No action
 *  0b1..Initialize position counter
 */
#define ENC_CTRL_SWIP(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_SWIP_SHIFT)) & ENC_CTRL_SWIP_MASK)

#define ENC_CTRL_HNE_MASK                        (0x1000U)
#define ENC_CTRL_HNE_SHIFT                       (12U)
/*! HNE - Use Negative Edge of HOME Input
 *  0b0..Use positive-going edge-to-trigger initialization of position counters UPOS and LPOS
 *  0b1..Use negative-going edge-to-trigger initialization of position counters UPOS and LPOS
 */
#define ENC_CTRL_HNE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HNE_SHIFT)) & ENC_CTRL_HNE_MASK)

#define ENC_CTRL_HIP_MASK                        (0x2000U)
#define ENC_CTRL_HIP_SHIFT                       (13U)
/*! HIP - Enable HOME to Initialize Position Counters UPOS and LPOS
 *  0b0..No action
 *  0b1..HOME signal initializes the position counter
 */
#define ENC_CTRL_HIP(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HIP_SHIFT)) & ENC_CTRL_HIP_MASK)

#define ENC_CTRL_HIE_MASK                        (0x4000U)
#define ENC_CTRL_HIE_SHIFT                       (14U)
/*! HIE - HOME Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL_HIE(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HIE_SHIFT)) & ENC_CTRL_HIE_MASK)

#define ENC_CTRL_HIRQ_MASK                       (0x8000U)
#define ENC_CTRL_HIRQ_SHIFT                      (15U)
/*! HIRQ - HOME Signal Transition Interrupt Request
 *  0b0..Not occurred
 *  0b1..Occurred
 */
#define ENC_CTRL_HIRQ(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL_HIRQ_SHIFT)) & ENC_CTRL_HIRQ_MASK)
/*! @} */

/*! @name FILT - Input Filter */
/*! @{ */

#define ENC_FILT_FILT_PER_MASK                   (0xFFU)
#define ENC_FILT_FILT_PER_SHIFT                  (0U)
/*! FILT_PER - Input Filter Sample Period */
#define ENC_FILT_FILT_PER(x)                     (((uint16_t)(((uint16_t)(x)) << ENC_FILT_FILT_PER_SHIFT)) & ENC_FILT_FILT_PER_MASK)

#define ENC_FILT_FILT_CNT_MASK                   (0x700U)
#define ENC_FILT_FILT_CNT_SHIFT                  (8U)
/*! FILT_CNT - Input Filter Sample Count */
#define ENC_FILT_FILT_CNT(x)                     (((uint16_t)(((uint16_t)(x)) << ENC_FILT_FILT_CNT_SHIFT)) & ENC_FILT_FILT_CNT_MASK)

#define ENC_FILT_FILT_PRSC_MASK                  (0xE000U)
#define ENC_FILT_FILT_PRSC_SHIFT                 (13U)
/*! FILT_PRSC - Prescaler Divide IPBus Clock to FILT Clock */
#define ENC_FILT_FILT_PRSC(x)                    (((uint16_t)(((uint16_t)(x)) << ENC_FILT_FILT_PRSC_SHIFT)) & ENC_FILT_FILT_PRSC_MASK)
/*! @} */

/*! @name WTR - Watchdog Timeout */
/*! @{ */

#define ENC_WTR_WDOG_MASK                        (0xFFFFU)
#define ENC_WTR_WDOG_SHIFT                       (0U)
/*! WDOG - WDOG */
#define ENC_WTR_WDOG(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_WTR_WDOG_SHIFT)) & ENC_WTR_WDOG_MASK)
/*! @} */

/*! @name POSD - Position Difference Counter */
/*! @{ */

#define ENC_POSD_POSD_MASK                       (0xFFFFU)
#define ENC_POSD_POSD_SHIFT                      (0U)
/*! POSD - POSD */
#define ENC_POSD_POSD(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_POSD_POSD_SHIFT)) & ENC_POSD_POSD_MASK)
/*! @} */

/*! @name POSDH - Position Difference Hold */
/*! @{ */

#define ENC_POSDH_POSDH_MASK                     (0xFFFFU)
#define ENC_POSDH_POSDH_SHIFT                    (0U)
/*! POSDH - POSDH */
#define ENC_POSDH_POSDH(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_POSDH_POSDH_SHIFT)) & ENC_POSDH_POSDH_MASK)
/*! @} */

/*! @name REV - Revolution Counter */
/*! @{ */

#define ENC_REV_REV_MASK                         (0xFFFFU)
#define ENC_REV_REV_SHIFT                        (0U)
/*! REV - REV */
#define ENC_REV_REV(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_REV_REV_SHIFT)) & ENC_REV_REV_MASK)
/*! @} */

/*! @name REVH - Revolution Hold */
/*! @{ */

#define ENC_REVH_REVH_MASK                       (0xFFFFU)
#define ENC_REVH_REVH_SHIFT                      (0U)
/*! REVH - REVH */
#define ENC_REVH_REVH(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_REVH_REVH_SHIFT)) & ENC_REVH_REVH_MASK)
/*! @} */

/*! @name UPOS - Upper Position Counter */
/*! @{ */

#define ENC_UPOS_POS_MASK                        (0xFFFFU)
#define ENC_UPOS_POS_SHIFT                       (0U)
/*! POS - POS */
#define ENC_UPOS_POS(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_UPOS_POS_SHIFT)) & ENC_UPOS_POS_MASK)
/*! @} */

/*! @name LPOS - Lower Position Counter */
/*! @{ */

#define ENC_LPOS_POS_MASK                        (0xFFFFU)
#define ENC_LPOS_POS_SHIFT                       (0U)
/*! POS - POS */
#define ENC_LPOS_POS(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_LPOS_POS_SHIFT)) & ENC_LPOS_POS_MASK)
/*! @} */

/*! @name UPOSH - Upper Position Hold */
/*! @{ */

#define ENC_UPOSH_POSH_MASK                      (0xFFFFU)
#define ENC_UPOSH_POSH_SHIFT                     (0U)
/*! POSH - POSH */
#define ENC_UPOSH_POSH(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_UPOSH_POSH_SHIFT)) & ENC_UPOSH_POSH_MASK)
/*! @} */

/*! @name LPOSH - Lower Position Hold */
/*! @{ */

#define ENC_LPOSH_POSH_MASK                      (0xFFFFU)
#define ENC_LPOSH_POSH_SHIFT                     (0U)
/*! POSH - POSH */
#define ENC_LPOSH_POSH(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_LPOSH_POSH_SHIFT)) & ENC_LPOSH_POSH_MASK)
/*! @} */

/*! @name UINIT - Upper Initialization */
/*! @{ */

#define ENC_UINIT_INIT_MASK                      (0xFFFFU)
#define ENC_UINIT_INIT_SHIFT                     (0U)
/*! INIT - INIT */
#define ENC_UINIT_INIT(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_UINIT_INIT_SHIFT)) & ENC_UINIT_INIT_MASK)
/*! @} */

/*! @name LINIT - Lower Initialization */
/*! @{ */

#define ENC_LINIT_INIT_MASK                      (0xFFFFU)
#define ENC_LINIT_INIT_SHIFT                     (0U)
/*! INIT - INIT */
#define ENC_LINIT_INIT(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_LINIT_INIT_SHIFT)) & ENC_LINIT_INIT_MASK)
/*! @} */

/*! @name IMR - Input Monitor */
/*! @{ */

#define ENC_IMR_HOME_MASK                        (0x1U)
#define ENC_IMR_HOME_SHIFT                       (0U)
/*! HOME - HOME */
#define ENC_IMR_HOME(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_HOME_SHIFT)) & ENC_IMR_HOME_MASK)

#define ENC_IMR_INDEX_MASK                       (0x2U)
#define ENC_IMR_INDEX_SHIFT                      (1U)
/*! INDEX - INDEX */
#define ENC_IMR_INDEX(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_IMR_INDEX_SHIFT)) & ENC_IMR_INDEX_MASK)

#define ENC_IMR_PHB_MASK                         (0x4U)
#define ENC_IMR_PHB_SHIFT                        (2U)
/*! PHB - PHB */
#define ENC_IMR_PHB(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_IMR_PHB_SHIFT)) & ENC_IMR_PHB_MASK)

#define ENC_IMR_PHA_MASK                         (0x8U)
#define ENC_IMR_PHA_SHIFT                        (3U)
/*! PHA - PHA */
#define ENC_IMR_PHA(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_IMR_PHA_SHIFT)) & ENC_IMR_PHA_MASK)

#define ENC_IMR_FHOM_MASK                        (0x10U)
#define ENC_IMR_FHOM_SHIFT                       (4U)
/*! FHOM - FHOM */
#define ENC_IMR_FHOM(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FHOM_SHIFT)) & ENC_IMR_FHOM_MASK)

#define ENC_IMR_FIND_MASK                        (0x20U)
#define ENC_IMR_FIND_SHIFT                       (5U)
/*! FIND - FIND */
#define ENC_IMR_FIND(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FIND_SHIFT)) & ENC_IMR_FIND_MASK)

#define ENC_IMR_FPHB_MASK                        (0x40U)
#define ENC_IMR_FPHB_SHIFT                       (6U)
/*! FPHB - FPHB */
#define ENC_IMR_FPHB(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FPHB_SHIFT)) & ENC_IMR_FPHB_MASK)

#define ENC_IMR_FPHA_MASK                        (0x80U)
#define ENC_IMR_FPHA_SHIFT                       (7U)
/*! FPHA - FPHA */
#define ENC_IMR_FPHA(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_IMR_FPHA_SHIFT)) & ENC_IMR_FPHA_MASK)
/*! @} */

/*! @name TST - Test */
/*! @{ */

#define ENC_TST_TEST_COUNT_MASK                  (0xFFU)
#define ENC_TST_TEST_COUNT_SHIFT                 (0U)
/*! TEST_COUNT - TEST_COUNT */
#define ENC_TST_TEST_COUNT(x)                    (((uint16_t)(((uint16_t)(x)) << ENC_TST_TEST_COUNT_SHIFT)) & ENC_TST_TEST_COUNT_MASK)

#define ENC_TST_TEST_PERIOD_MASK                 (0x1F00U)
#define ENC_TST_TEST_PERIOD_SHIFT                (8U)
/*! TEST_PERIOD - TEST_PERIOD */
#define ENC_TST_TEST_PERIOD(x)                   (((uint16_t)(((uint16_t)(x)) << ENC_TST_TEST_PERIOD_SHIFT)) & ENC_TST_TEST_PERIOD_MASK)

#define ENC_TST_QDN_MASK                         (0x2000U)
#define ENC_TST_QDN_SHIFT                        (13U)
/*! QDN - Quadrature Decoder Negative Signal
 *  0b0..Positive quadrature decoder signal
 *  0b1..Negative quadrature decoder signal
 */
#define ENC_TST_QDN(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_TST_QDN_SHIFT)) & ENC_TST_QDN_MASK)

#define ENC_TST_TCE_MASK                         (0x4000U)
#define ENC_TST_TCE_SHIFT                        (14U)
/*! TCE - Test Counter Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_TST_TCE(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_TST_TCE_SHIFT)) & ENC_TST_TCE_MASK)

#define ENC_TST_TEN_MASK                         (0x8000U)
#define ENC_TST_TEN_SHIFT                        (15U)
/*! TEN - Test Mode Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_TST_TEN(x)                           (((uint16_t)(((uint16_t)(x)) << ENC_TST_TEN_SHIFT)) & ENC_TST_TEN_MASK)
/*! @} */

/*! @name CTRL2 - Control 2 */
/*! @{ */

#define ENC_CTRL2_UPDHLD_MASK                    (0x1U)
#define ENC_CTRL2_UPDHLD_SHIFT                   (0U)
/*! UPDHLD - Update Hold Registers
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL2_UPDHLD(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_UPDHLD_SHIFT)) & ENC_CTRL2_UPDHLD_MASK)

#define ENC_CTRL2_UPDPOS_MASK                    (0x2U)
#define ENC_CTRL2_UPDPOS_SHIFT                   (1U)
/*! UPDPOS - Update Position Registers
 *  0b0..No action
 *  0b1..Clear
 */
#define ENC_CTRL2_UPDPOS(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_UPDPOS_SHIFT)) & ENC_CTRL2_UPDPOS_MASK)

#define ENC_CTRL2_MOD_MASK                       (0x4U)
#define ENC_CTRL2_MOD_SHIFT                      (2U)
/*! MOD - Enable Modulo Counting
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL2_MOD(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_MOD_SHIFT)) & ENC_CTRL2_MOD_MASK)

#define ENC_CTRL2_DIR_MASK                       (0x8U)
#define ENC_CTRL2_DIR_SHIFT                      (3U)
/*! DIR - Count Direction Flag
 *  0b0..Down direction
 *  0b1..Up direction
 */
#define ENC_CTRL2_DIR(x)                         (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_DIR_SHIFT)) & ENC_CTRL2_DIR_MASK)

#define ENC_CTRL2_RUIE_MASK                      (0x10U)
#define ENC_CTRL2_RUIE_SHIFT                     (4U)
/*! RUIE - Roll-under Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL2_RUIE(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_RUIE_SHIFT)) & ENC_CTRL2_RUIE_MASK)

#define ENC_CTRL2_RUIRQ_MASK                     (0x20U)
#define ENC_CTRL2_RUIRQ_SHIFT                    (5U)
/*! RUIRQ - Roll-under Interrupt Request
 *  0b0..No roll-under has occurred
 *  0b1..Roll-under has occurred
 */
#define ENC_CTRL2_RUIRQ(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_RUIRQ_SHIFT)) & ENC_CTRL2_RUIRQ_MASK)

#define ENC_CTRL2_ROIE_MASK                      (0x40U)
#define ENC_CTRL2_ROIE_SHIFT                     (6U)
/*! ROIE - Roll-over Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL2_ROIE(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_ROIE_SHIFT)) & ENC_CTRL2_ROIE_MASK)

#define ENC_CTRL2_ROIRQ_MASK                     (0x80U)
#define ENC_CTRL2_ROIRQ_SHIFT                    (7U)
/*! ROIRQ - Roll-over Interrupt Request
 *  0b0..Did not occur
 *  0b1..Occurred
 */
#define ENC_CTRL2_ROIRQ(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_ROIRQ_SHIFT)) & ENC_CTRL2_ROIRQ_MASK)

#define ENC_CTRL2_REVMOD_MASK                    (0x100U)
#define ENC_CTRL2_REVMOD_SHIFT                   (8U)
/*! REVMOD - Revolution Counter Modulus Enable
 *  0b0..Use INDEX pulse
 *  0b1..Use modulus counting roll-over or roll-under
 */
#define ENC_CTRL2_REVMOD(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_REVMOD_SHIFT)) & ENC_CTRL2_REVMOD_MASK)

#define ENC_CTRL2_OUTCTL_MASK                    (0x200U)
#define ENC_CTRL2_OUTCTL_SHIFT                   (9U)
/*! OUTCTL - Output Control
 *  0b0..POSMATCH pulses when a match occurs between the position counters (POS) and the corresponding compare value (COMP )
 *  0b1..POSMATCH pulses when the UPOS, LPOS, REV, or POSD registers are read
 */
#define ENC_CTRL2_OUTCTL(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_OUTCTL_SHIFT)) & ENC_CTRL2_OUTCTL_MASK)

#define ENC_CTRL2_SABIE_MASK                     (0x400U)
#define ENC_CTRL2_SABIE_SHIFT                    (10U)
/*! SABIE - Simultaneous PHASEA and PHASEB Change Interrupt Enable
 *  0b0..Disable
 *  0b1..Enable
 */
#define ENC_CTRL2_SABIE(x)                       (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_SABIE_SHIFT)) & ENC_CTRL2_SABIE_MASK)

#define ENC_CTRL2_SABIRQ_MASK                    (0x800U)
#define ENC_CTRL2_SABIRQ_SHIFT                   (11U)
/*! SABIRQ - Simultaneous PHASEA and PHASEB Change Interrupt Request
 *  0b0..No simultaneous change has occurred
 *  0b1..A simultaneous change has occurred
 */
#define ENC_CTRL2_SABIRQ(x)                      (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_SABIRQ_SHIFT)) & ENC_CTRL2_SABIRQ_MASK)

#define ENC_CTRL2_INITPOS_MASK                   (0x1000U)
#define ENC_CTRL2_INITPOS_SHIFT                  (12U)
/*! INITPOS - Initialize Position Registers
 *  0b0..Don't initialize position counter
 *  0b1..Initialize position counter
 */
#define ENC_CTRL2_INITPOS(x)                     (((uint16_t)(((uint16_t)(x)) << ENC_CTRL2_INITPOS_SHIFT)) & ENC_CTRL2_INITPOS_MASK)
/*! @} */

/*! @name UMOD - Upper Modulus */
/*! @{ */

#define ENC_UMOD_MOD_MASK                        (0xFFFFU)
#define ENC_UMOD_MOD_SHIFT                       (0U)
/*! MOD - MOD */
#define ENC_UMOD_MOD(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_UMOD_MOD_SHIFT)) & ENC_UMOD_MOD_MASK)
/*! @} */

/*! @name LMOD - Lower Modulus */
/*! @{ */

#define ENC_LMOD_MOD_MASK                        (0xFFFFU)
#define ENC_LMOD_MOD_SHIFT                       (0U)
/*! MOD - MOD */
#define ENC_LMOD_MOD(x)                          (((uint16_t)(((uint16_t)(x)) << ENC_LMOD_MOD_SHIFT)) & ENC_LMOD_MOD_MASK)
/*! @} */

/*! @name UCOMP - Upper Position Compare */
/*! @{ */

#define ENC_UCOMP_COMP_MASK                      (0xFFFFU)
#define ENC_UCOMP_COMP_SHIFT                     (0U)
/*! COMP - COMP */
#define ENC_UCOMP_COMP(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_UCOMP_COMP_SHIFT)) & ENC_UCOMP_COMP_MASK)
/*! @} */

/*! @name LCOMP - Lower Position Compare */
/*! @{ */

#define ENC_LCOMP_COMP_MASK                      (0xFFFFU)
#define ENC_LCOMP_COMP_SHIFT                     (0U)
/*! COMP - COMP */
#define ENC_LCOMP_COMP(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_LCOMP_COMP_SHIFT)) & ENC_LCOMP_COMP_MASK)
/*! @} */

/*! @name LASTEDGE - Last Edge Time */
/*! @{ */

#define ENC_LASTEDGE_LASTEDGE_MASK               (0xFFFFU)
#define ENC_LASTEDGE_LASTEDGE_SHIFT              (0U)
/*! LASTEDGE - Last Edge Time Counter */
#define ENC_LASTEDGE_LASTEDGE(x)                 (((uint16_t)(((uint16_t)(x)) << ENC_LASTEDGE_LASTEDGE_SHIFT)) & ENC_LASTEDGE_LASTEDGE_MASK)
/*! @} */

/*! @name LASTEDGEH - Last Edge Time Hold */
/*! @{ */

#define ENC_LASTEDGEH_LASTEDGEH_MASK             (0xFFFFU)
#define ENC_LASTEDGEH_LASTEDGEH_SHIFT            (0U)
/*! LASTEDGEH - Last Edge Time Hold */
#define ENC_LASTEDGEH_LASTEDGEH(x)               (((uint16_t)(((uint16_t)(x)) << ENC_LASTEDGEH_LASTEDGEH_SHIFT)) & ENC_LASTEDGEH_LASTEDGEH_MASK)
/*! @} */

/*! @name POSDPER - Position Difference Period Counter */
/*! @{ */

#define ENC_POSDPER_POSDPER_MASK                 (0xFFFFU)
#define ENC_POSDPER_POSDPER_SHIFT                (0U)
/*! POSDPER - Position difference period */
#define ENC_POSDPER_POSDPER(x)                   (((uint16_t)(((uint16_t)(x)) << ENC_POSDPER_POSDPER_SHIFT)) & ENC_POSDPER_POSDPER_MASK)
/*! @} */

/*! @name POSDPERBFR - Position Difference Period Buffer */
/*! @{ */

#define ENC_POSDPERBFR_POSDPERBFR_MASK           (0xFFFFU)
#define ENC_POSDPERBFR_POSDPERBFR_SHIFT          (0U)
/*! POSDPERBFR - Position difference period buffer */
#define ENC_POSDPERBFR_POSDPERBFR(x)             (((uint16_t)(((uint16_t)(x)) << ENC_POSDPERBFR_POSDPERBFR_SHIFT)) & ENC_POSDPERBFR_POSDPERBFR_MASK)
/*! @} */

/*! @name POSDPERH - Position Difference Period Hold */
/*! @{ */

#define ENC_POSDPERH_POSDPERH_MASK               (0xFFFFU)
#define ENC_POSDPERH_POSDPERH_SHIFT              (0U)
/*! POSDPERH - Position difference period hold */
#define ENC_POSDPERH_POSDPERH(x)                 (((uint16_t)(((uint16_t)(x)) << ENC_POSDPERH_POSDPERH_SHIFT)) & ENC_POSDPERH_POSDPERH_MASK)
/*! @} */

/*! @name CTRL3 - Control 3 */
/*! @{ */

#define ENC_CTRL3_PMEN_MASK                      (0x1U)
#define ENC_CTRL3_PMEN_SHIFT                     (0U)
/*! PMEN - Period Measurement Function Enable
 *  0b0..Not used
 *  0b1..Used
 */
#define ENC_CTRL3_PMEN(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL3_PMEN_SHIFT)) & ENC_CTRL3_PMEN_MASK)

#define ENC_CTRL3_PRSC_MASK                      (0xF0U)
#define ENC_CTRL3_PRSC_SHIFT                     (4U)
/*! PRSC - Prescaler */
#define ENC_CTRL3_PRSC(x)                        (((uint16_t)(((uint16_t)(x)) << ENC_CTRL3_PRSC_SHIFT)) & ENC_CTRL3_PRSC_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ENC_Register_Masks */


/* ENC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral ENC0 base address */
  #define ENC0_BASE                                (0x500CF000u)
  /** Peripheral ENC0 base address */
  #define ENC0_BASE_NS                             (0x400CF000u)
  /** Peripheral ENC0 base pointer */
  #define ENC0                                     ((ENC_Type *)ENC0_BASE)
  /** Peripheral ENC0 base pointer */
  #define ENC0_NS                                  ((ENC_Type *)ENC0_BASE_NS)
  /** Peripheral ENC1 base address */
  #define ENC1_BASE                                (0x500D1000u)
  /** Peripheral ENC1 base address */
  #define ENC1_BASE_NS                             (0x400D1000u)
  /** Peripheral ENC1 base pointer */
  #define ENC1                                     ((ENC_Type *)ENC1_BASE)
  /** Peripheral ENC1 base pointer */
  #define ENC1_NS                                  ((ENC_Type *)ENC1_BASE_NS)
  /** Array initializer of ENC peripheral base addresses */
  #define ENC_BASE_ADDRS                           { ENC0_BASE, ENC1_BASE }
  /** Array initializer of ENC peripheral base pointers */
  #define ENC_BASE_PTRS                            { ENC0, ENC1 }
  /** Array initializer of ENC peripheral base addresses */
  #define ENC_BASE_ADDRS_NS                        { ENC0_BASE_NS, ENC1_BASE_NS }
  /** Array initializer of ENC peripheral base pointers */
  #define ENC_BASE_PTRS_NS                         { ENC0_NS, ENC1_NS }
#else
  /** Peripheral ENC0 base address */
  #define ENC0_BASE                                (0x400CF000u)
  /** Peripheral ENC0 base pointer */
  #define ENC0                                     ((ENC_Type *)ENC0_BASE)
  /** Peripheral ENC1 base address */
  #define ENC1_BASE                                (0x400D1000u)
  /** Peripheral ENC1 base pointer */
  #define ENC1                                     ((ENC_Type *)ENC1_BASE)
  /** Array initializer of ENC peripheral base addresses */
  #define ENC_BASE_ADDRS                           { ENC0_BASE, ENC1_BASE }
  /** Array initializer of ENC peripheral base pointers */
  #define ENC_BASE_PTRS                            { ENC0, ENC1 }
#endif
/** Interrupt vectors for the ENC peripheral type */
#define ENC_COMPARE_IRQS                         { ENC0_COMPARE_IRQn, ENC1_COMPARE_IRQn }
#define ENC_HOME_IRQS                            { ENC0_HOME_IRQn, ENC1_HOME_IRQn }
#define ENC_WDOG_IRQS                            { ENC0_WDG_SAB_IRQn, ENC1_WDG_SAB_IRQn }
#define ENC_INDEX_IRQS                           { ENC0_IDX_IRQn, ENC1_IDX_IRQn }

/*!
 * @}
 */ /* end of group ENC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ENET Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Peripheral_Access_Layer ENET Peripheral Access Layer
 * @{
 */

/** ENET - Register Layout Typedef */
typedef struct {
  __IO uint32_t MAC_CONFIGURATION;                 /**< MAC Configuration, offset: 0x0 */
  __IO uint32_t MAC_EXT_CONFIGURATION;             /**< MAC Extended Configuration Register, offset: 0x4 */
  __IO uint32_t MAC_PACKET_FILTER;                 /**< MAC Packet Filter, offset: 0x8 */
  __IO uint32_t MAC_WATCHDOG_TIMEOUT;              /**< Watchdog Timeout, offset: 0xC */
       uint8_t RESERVED_0[64];
  __IO uint32_t MAC_VLAN_TAG_CTRL;                 /**< MAC VLAN Tag Control, offset: 0x50 */
       uint8_t RESERVED_1[12];
  __IO uint32_t MAC_VLAN_INCL;                     /**< VLAN Tag Inclusion or Replacement, offset: 0x60 */
  __IO uint32_t MAC_INNER_VLAN_INCL;               /**< MAC Inner VLAN Tag Inclusion or Replacement, offset: 0x64 */
       uint8_t RESERVED_2[8];
  __IO uint32_t MAC_TX_FLOW_CTRL_Q[1];             /**< MAC Q0 Tx Flow Control, array offset: 0x70, array step: 0x4 */
       uint8_t RESERVED_3[28];
  __IO uint32_t MAC_RX_FLOW_CTRL;                  /**< MAC Rx Flow Control, offset: 0x90 */
  __IO uint32_t MAC_RXQ_CTRL4;                     /**< Receive Queue Control 4, offset: 0x94 */
       uint8_t RESERVED_4[8];
  __IO uint32_t MAC_RXQ_CTRL[3];                   /**< Receive Queue Control 0..Receive Queue Control 2, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_5[4];
  __I  uint32_t MAC_INTERRUPT_STATUS;              /**< Interrupt Status, offset: 0xB0 */
  __IO uint32_t MAC_INTERRUPT_ENABLE;              /**< Interrupt Enable, offset: 0xB4 */
  __I  uint32_t MAC_RX_TX_STATUS;                  /**< Receive Transmit Status, offset: 0xB8 */
       uint8_t RESERVED_6[4];
  __IO uint32_t MAC_PMT_CONTROL_STATUS;            /**< PMT Control and Status, offset: 0xC0 */
  __IO uint32_t MAC_RWK_PACKET_FILTER;             /**< Remote Wakeup Filter, offset: 0xC4 */
       uint8_t RESERVED_7[8];
  __IO uint32_t MAC_LPI_CONTROL_STATUS;            /**< LPI Control and Status, offset: 0xD0 */
  __IO uint32_t MAC_LPI_TIMERS_CONTROL;            /**< LPI Timers Control, offset: 0xD4 */
  __IO uint32_t MAC_LPI_ENTRY_TIMER;               /**< Tx LPI Entry Timer Control, offset: 0xD8 */
  __IO uint32_t MAC_ONEUS_TIC_COUNTER;             /**< One-microsecond Reference Timer, offset: 0xDC */
       uint8_t RESERVED_8[48];
  __I  uint32_t MAC_VERSION;                       /**< MAC Version, offset: 0x110 */
  __I  uint32_t MAC_DEBUG;                         /**< MAC Debug, offset: 0x114 */
       uint8_t RESERVED_9[4];
  __I  uint32_t MAC_HW_FEAT[4];                    /**< Hardware Features 0..Hardware Features 3, array offset: 0x11C, array step: 0x4 */
       uint8_t RESERVED_10[212];
  __IO uint32_t MAC_MDIO_ADDRESS;                  /**< MDIO Address, offset: 0x200 */
  __IO uint32_t MAC_MDIO_DATA;                     /**< MAC MDIO Data, offset: 0x204 */
       uint8_t RESERVED_11[40];
  __IO uint32_t MAC_CSR_SW_CTRL;                   /**< CSR Software Control, offset: 0x230 */
       uint8_t RESERVED_12[204];
  __IO uint32_t MAC_ADDRESS0_HIGH;                 /**< MAC Address0 High, offset: 0x300 */
  __IO uint32_t MAC_ADDRESS0_LOW;                  /**< MAC Address0 Low, offset: 0x304 */
       uint8_t RESERVED_13[1896];
  __IO uint32_t INDIR_ACCESS_CTRL;                 /**< Indirect Access Control, offset: 0xA70 */
  __IO uint32_t INDIR_ACCESS_DATA;                 /**< Indirect Access Data, offset: 0xA74 */
       uint8_t RESERVED_14[136];
  __IO uint32_t MAC_TIMESTAMP_CONTROL;             /**< Timestamp Control, offset: 0xB00 */
  __IO uint32_t MAC_SUB_SECOND_INCREMENT;          /**< Subsecond Increment, offset: 0xB04 */
  __I  uint32_t MAC_SYSTEM_TIME_SECONDS;           /**< System Time Seconds, offset: 0xB08 */
  __I  uint32_t MAC_SYSTEM_TIME_NANOSECONDS;       /**< System Time Nanoseconds, offset: 0xB0C */
  __IO uint32_t MAC_SYSTEM_TIME_SECONDS_UPDATE;    /**< System Time Seconds Update, offset: 0xB10 */
  __IO uint32_t MAC_SYSTEM_TIME_NANOSECONDS_UPDATE; /**< System Time Nanoseconds Update, offset: 0xB14 */
  __IO uint32_t MAC_TIMESTAMP_ADDEND;              /**< Timestamp Addend, offset: 0xB18 */
       uint8_t RESERVED_15[4];
  __I  uint32_t MAC_TIMESTAMP_STATUS;              /**< Timestamp Status, offset: 0xB20 */
       uint8_t RESERVED_16[12];
  __I  uint32_t MAC_TX_TIMESTAMP_STATUS_NANOSECONDS; /**< Transmit Timestamp Status Nanoseconds, offset: 0xB30 */
  __I  uint32_t MAC_TX_TIMESTAMP_STATUS_SECONDS;   /**< Transmit Timestamp Status Seconds, offset: 0xB34 */
       uint8_t RESERVED_17[32];
  __IO uint32_t MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND; /**< Timestamp Ingress Correction Nanosecond, offset: 0xB58 */
  __IO uint32_t MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND; /**< Timestamp Egress Correction Nanosecond, offset: 0xB5C */
       uint8_t RESERVED_18[8];
  __I  uint32_t MAC_TIMESTAMP_INGRESS_LATENCY;     /**< Timestamp Ingress Latency, offset: 0xB68 */
  __I  uint32_t MAC_TIMESTAMP_EGRESS_LATENCY;      /**< Timestamp Egress Latency, offset: 0xB6C */
  __IO uint32_t MAC_PPS_CONTROL;                   /**< PPS Control, offset: 0xB70 */
       uint8_t RESERVED_19[12];
  __IO uint32_t PPS0_TARGET_TIME_SECONDS;          /**< PPS0 Target Time Seconds, offset: 0xB80 */
  __IO uint32_t PPS0_TARGET_TIME_NANOSECONDS;      /**< PPS0 Target Time Nanoseconds, offset: 0xB84 */
       uint8_t RESERVED_20[120];
  __IO uint32_t MTL_OPERATION_MODE;                /**< MTL Operation Mode, offset: 0xC00 */
       uint8_t RESERVED_21[28];
  __I  uint32_t MTL_INTERRUPT_STATUS;              /**< MTL Interrupt Status, offset: 0xC20 */
       uint8_t RESERVED_22[12];
  __IO uint32_t MTL_RXQ_DMA_MAP0;                  /**< Receive Queue and DMA Channel Mapping 0, offset: 0xC30 */
       uint8_t RESERVED_23[204];
  struct {                                         /* offset: 0xD00, array step: 0x40 */
    __IO uint32_t MTL_TXQX_OP_MODE;                  /**< Queue 0 Transmit Operation Mode..Queue 1 Transmit Operation Mode, array offset: 0xD00, array step: 0x40 */
    __I  uint32_t MTL_TXQX_UNDRFLW;                  /**< Queue 0 Underflow Counter..Queue 1 Underflow Counter, array offset: 0xD04, array step: 0x40 */
    __I  uint32_t MTL_TXQX_DBG;                      /**< Queue 0 Transmit Debug..Queue 1 Transmit Debug, array offset: 0xD08, array step: 0x40 */
         uint8_t RESERVED_0[4];
    __IO uint32_t MTL_TXQX_ETS_CTRL;                 /**< Queue 1 ETS Control, array offset: 0xD10, array step: 0x40, valid indices: [1] */
    __I  uint32_t MTL_TXQX_ETS_STAT;                 /**< Queue 0 ETS Status..Queue 1 ETS Status, array offset: 0xD14, array step: 0x40 */
    __IO uint32_t MTL_TXQX_QNTM_WGHT;                /**< Queue 0 Quantum or Weights..Queue 1 idleSlopeCredit, Quantum or Weights, array offset: 0xD18, array step: 0x40 */
    __IO uint32_t MTL_TXQX_SNDSLP_CRDT;              /**< Queue 1 sendSlopeCredit, array offset: 0xD1C, array step: 0x40, valid indices: [1] */
    __IO uint32_t MTL_TXQX_HI_CRDT;                  /**< Queue 1 hiCredit, array offset: 0xD20, array step: 0x40, valid indices: [1] */
    __IO uint32_t MTL_TXQX_LO_CRDT;                  /**< Queue 1 loCredit, array offset: 0xD24, array step: 0x40, valid indices: [1] */
         uint8_t RESERVED_1[4];
    __IO uint32_t MTL_QX_INTCTRL_STAT;               /**< Queue 0 Interrupt Control Status..Queue 1 Interrupt Control Status, array offset: 0xD2C, array step: 0x40 */
    __IO uint32_t MTL_RXQX_OP_MODE;                  /**< Queue 0 Receive Operation Mode..Queue 1 Receive Operation Mode, array offset: 0xD30, array step: 0x40 */
    __I  uint32_t MTL_RXQX_MISSPKT_OVRFLW_CNT;       /**< Queue 0 Missed Packet and Overflow Counter..Queue 1 Missed Packet and Overflow Counter, array offset: 0xD34, array step: 0x40 */
    __I  uint32_t MTL_RXQX_DBG;                      /**< Queue 0 Receive Debug..Queue 1 Receive Debug, array offset: 0xD38, array step: 0x40 */
    __IO uint32_t MTL_RXQX_CTRL;                     /**< Queue 0 Receive Control..Queue 1 Receive Control, array offset: 0xD3C, array step: 0x40 */
  } MTL_QUEUE[2];
       uint8_t RESERVED_24[640];
  __IO uint32_t DMA_MODE;                          /**< DMA Bus Mode, offset: 0x1000 */
  __IO uint32_t DMA_SYSBUS_MODE;                   /**< DMA System Bus Mode, offset: 0x1004 */
  __I  uint32_t DMA_INTERRUPT_STATUS;              /**< DMA Interrupt Status, offset: 0x1008 */
  __I  uint32_t DMA_DEBUG_STATUS0;                 /**< DMA Debug Status 0, offset: 0x100C */
       uint8_t RESERVED_25[240];
  struct {                                         /* offset: 0x1100, array step: 0x80 */
    __IO uint32_t DMA_CHX_CTRL;                      /**< DMA Channel 0 Control..DMA Channel 1 Control, array offset: 0x1100, array step: 0x80 */
    __IO uint32_t DMA_CHX_TX_CTRL;                   /**< DMA Channel 0 Transmit Control..DMA Channel 1 Transmit Control, array offset: 0x1104, array step: 0x80 */
    __IO uint32_t DMA_CHX_RX_CTRL;                   /**< DMA Channel 0 Receive Control..DMA Channel 1 Receive Control, array offset: 0x1108, array step: 0x80 */
         uint8_t RESERVED_0[8];
    __IO uint32_t DMA_CHX_TXDESC_LIST_ADDR;          /**< Channel 0 Tx Descriptor List Address register..Channel 1 Tx Descriptor List Address, array offset: 0x1114, array step: 0x80 */
         uint8_t RESERVED_1[4];
    __IO uint32_t DMA_CHX_RXDESC_LIST_ADDR;          /**< Channel 0 Rx Descriptor List Address register..Channel 1 Rx Descriptor List Address, array offset: 0x111C, array step: 0x80 */
    __IO uint32_t DMA_CHX_TXDESC_TAIL_PTR;           /**< Channel 0 Tx Descriptor Tail Pointer..Channel 1 Tx Descriptor Tail Pointer, array offset: 0x1120, array step: 0x80 */
         uint8_t RESERVED_2[4];
    __IO uint32_t DMA_CHX_RXDESC_TAIL_PTR;           /**< Channel 0 Rx Descriptor Tail Pointer..Channel 1 Rx Descriptor Tail Pointer, array offset: 0x1128, array step: 0x80 */
    __IO uint32_t DMA_CHX_TXDESC_RING_LENGTH;        /**< Channel 0 Tx Descriptor Ring Length..Channel 1 Tx Descriptor Ring Length, array offset: 0x112C, array step: 0x80 */
    __IO uint32_t DMA_CHX_RX_CONTROL2;               /**< Channeli Receive Control..DMA Channel 1 Receive Control, array offset: 0x1130, array step: 0x80 */
    __IO uint32_t DMA_CHX_INT_EN;                    /**< Channeli Interrupt Enable..Channel 1 Interrupt Enable, array offset: 0x1134, array step: 0x80 */
    __IO uint32_t DMA_CHX_RX_INT_WDTIMER;            /**< Channel 0 Receive Interrupt Watchdog Timer..Channel 1 Receive Interrupt Watchdog Timer, array offset: 0x1138, array step: 0x80 */
    __IO uint32_t DMA_CHX_SLOT_FUNC_CTRL_STAT;       /**< Channel 0 Slot Function Control and Status..Channel 1 Slot Function Control and Status, array offset: 0x113C, array step: 0x80 */
         uint8_t RESERVED_3[4];
    __I  uint32_t DMA_CHX_CUR_HST_TXDESC;            /**< Channel 0 Current Application Transmit Descriptor..Channel 1 Current Application Transmit Descriptor, array offset: 0x1144, array step: 0x80 */
         uint8_t RESERVED_4[4];
    __I  uint32_t DMA_CHX_CUR_HST_RXDESC;            /**< Channel 0 Current Application Receive Descriptor..Channel 1 Current Application Receive Descriptor, array offset: 0x114C, array step: 0x80 */
         uint8_t RESERVED_5[4];
    __I  uint32_t DMA_CHX_CUR_HST_TXBUF;             /**< Channel 0 Current Application Transmit Buffer Address..Channel 1 Current Application Transmit Buffer Address, array offset: 0x1154, array step: 0x80 */
         uint8_t RESERVED_6[4];
    __I  uint32_t DMA_CHX_CUR_HST_RXBUF;             /**< Channel 0 Current Application Receive Buffer Address..Channel 1 Current Application Receive Buffer Address, array offset: 0x115C, array step: 0x80 */
    __IO uint32_t DMA_CHX_STAT;                      /**< DMA Channel 0 Status..DMA Channel 1 Status, array offset: 0x1160, array step: 0x80 */
    __I  uint32_t DMA_CHX_MISS_FRAME_CNT;            /**< Channel 0 Missed Frame Counter..Channel 1 Missed Frame Counter, array offset: 0x1164, array step: 0x80 */
         uint8_t RESERVED_7[4];
    __I  uint32_t DMA_CHX_RX_ERI_CNT;                /**< Channel 0 Receive ERI Counter..Channel 1 Receive ERI Counter, array offset: 0x116C, array step: 0x80 */
         uint8_t RESERVED_8[16];
  } DMA_CH[2];
} ENET_Type;

/* ----------------------------------------------------------------------------
   -- ENET Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ENET_Register_Masks ENET Register Masks
 * @{
 */

/*! @name MAC_CONFIGURATION - MAC Configuration */
/*! @{ */

#define ENET_MAC_CONFIGURATION_RE_MASK           (0x1U)
#define ENET_MAC_CONFIGURATION_RE_SHIFT          (0U)
/*! RE - Receiver Enable
 *  0b0..Receiver is disabled
 *  0b1..Receiver is enabled
 */
#define ENET_MAC_CONFIGURATION_RE(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_RE_SHIFT)) & ENET_MAC_CONFIGURATION_RE_MASK)

#define ENET_MAC_CONFIGURATION_TE_MASK           (0x2U)
#define ENET_MAC_CONFIGURATION_TE_SHIFT          (1U)
/*! TE - Transmitter Enable
 *  0b0..Transmitter is disabled
 *  0b1..Transmitter is enabled
 */
#define ENET_MAC_CONFIGURATION_TE(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_TE_SHIFT)) & ENET_MAC_CONFIGURATION_TE_MASK)

#define ENET_MAC_CONFIGURATION_PRELEN_MASK       (0xCU)
#define ENET_MAC_CONFIGURATION_PRELEN_SHIFT      (2U)
/*! PRELEN - Preamble Length for Transmit packets
 *  0b10..3 bytes of preamble
 *  0b01..5 bytes of preamble
 *  0b00..7 bytes of preamble
 *  0b11..Reserved
 */
#define ENET_MAC_CONFIGURATION_PRELEN(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_PRELEN_SHIFT)) & ENET_MAC_CONFIGURATION_PRELEN_MASK)

#define ENET_MAC_CONFIGURATION_DC_MASK           (0x10U)
#define ENET_MAC_CONFIGURATION_DC_SHIFT          (4U)
/*! DC - Deferral Check
 *  0b0..Deferral check function is disabled
 *  0b1..Deferral check function is enabled
 */
#define ENET_MAC_CONFIGURATION_DC(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_DC_SHIFT)) & ENET_MAC_CONFIGURATION_DC_MASK)

#define ENET_MAC_CONFIGURATION_BL_MASK           (0x60U)
#define ENET_MAC_CONFIGURATION_BL_SHIFT          (5U)
/*! BL - Back-Off Limit
 *  0b11..k = min(n,1)
 *  0b00..k = min(n,10)
 *  0b10..k = min(n,4)
 *  0b01..k = min(n,8)
 */
#define ENET_MAC_CONFIGURATION_BL(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_BL_SHIFT)) & ENET_MAC_CONFIGURATION_BL_MASK)

#define ENET_MAC_CONFIGURATION_DR_MASK           (0x100U)
#define ENET_MAC_CONFIGURATION_DR_SHIFT          (8U)
/*! DR - Disable Retry
 *  0b1..Disable Retry
 *  0b0..Enable Retry
 */
#define ENET_MAC_CONFIGURATION_DR(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_DR_SHIFT)) & ENET_MAC_CONFIGURATION_DR_MASK)

#define ENET_MAC_CONFIGURATION_DCRS_MASK         (0x200U)
#define ENET_MAC_CONFIGURATION_DCRS_SHIFT        (9U)
/*! DCRS - Disable Carrier Sense During Transmission
 *  0b1..Disable Carrier Sense During Transmission
 *  0b0..Enable Carrier Sense During Transmission
 */
#define ENET_MAC_CONFIGURATION_DCRS(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_DCRS_SHIFT)) & ENET_MAC_CONFIGURATION_DCRS_MASK)

#define ENET_MAC_CONFIGURATION_DO_MASK           (0x400U)
#define ENET_MAC_CONFIGURATION_DO_SHIFT          (10U)
/*! DO - Disable Receive Own
 *  0b1..Disable Receive Own
 *  0b0..Enable Receive Own
 */
#define ENET_MAC_CONFIGURATION_DO(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_DO_SHIFT)) & ENET_MAC_CONFIGURATION_DO_MASK)

#define ENET_MAC_CONFIGURATION_ECRSFD_MASK       (0x800U)
#define ENET_MAC_CONFIGURATION_ECRSFD_SHIFT      (11U)
/*! ECRSFD - Enable Carrier Sense Before Transmission in Full-Duplex Mode
 *  0b0..ECRSFD is disabled
 *  0b1..ECRSFD is enabled
 */
#define ENET_MAC_CONFIGURATION_ECRSFD(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_ECRSFD_SHIFT)) & ENET_MAC_CONFIGURATION_ECRSFD_MASK)

#define ENET_MAC_CONFIGURATION_LM_MASK           (0x1000U)
#define ENET_MAC_CONFIGURATION_LM_SHIFT          (12U)
/*! LM - Loopback Mode
 *  0b0..Loopback is disabled
 *  0b1..Loopback is enabled
 */
#define ENET_MAC_CONFIGURATION_LM(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_LM_SHIFT)) & ENET_MAC_CONFIGURATION_LM_MASK)

#define ENET_MAC_CONFIGURATION_DM_MASK           (0x2000U)
#define ENET_MAC_CONFIGURATION_DM_SHIFT          (13U)
/*! DM - Duplex Mode
 *  0b1..Full-duplex mode
 *  0b0..Half-duplex mode
 */
#define ENET_MAC_CONFIGURATION_DM(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_DM_SHIFT)) & ENET_MAC_CONFIGURATION_DM_MASK)

#define ENET_MAC_CONFIGURATION_FES_MASK          (0x4000U)
#define ENET_MAC_CONFIGURATION_FES_SHIFT         (14U)
/*! FES - Speed
 *  0b1..100 Mbps when PS bit is 1 and 2.5 Gbps when PS bit is 0
 *  0b0..10 Mbps when PS bit is 1 and 1 Gbps when PS bit is 0
 */
#define ENET_MAC_CONFIGURATION_FES(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_FES_SHIFT)) & ENET_MAC_CONFIGURATION_FES_MASK)

#define ENET_MAC_CONFIGURATION_PS_MASK           (0x8000U)
#define ENET_MAC_CONFIGURATION_PS_SHIFT          (15U)
/*! PS - Port Select
 *  0b0..For 1000 or 2500 Mbps operations
 *  0b1..For 10 or 100 Mbps operations
 */
#define ENET_MAC_CONFIGURATION_PS(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_PS_SHIFT)) & ENET_MAC_CONFIGURATION_PS_MASK)

#define ENET_MAC_CONFIGURATION_JE_MASK           (0x10000U)
#define ENET_MAC_CONFIGURATION_JE_SHIFT          (16U)
/*! JE - Jumbo Packet Enable
 *  0b0..Jumbo packet is disabled
 *  0b1..Jumbo packet is enabled
 */
#define ENET_MAC_CONFIGURATION_JE(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_JE_SHIFT)) & ENET_MAC_CONFIGURATION_JE_MASK)

#define ENET_MAC_CONFIGURATION_JD_MASK           (0x20000U)
#define ENET_MAC_CONFIGURATION_JD_SHIFT          (17U)
/*! JD - Jabber Disable
 *  0b1..Jabber is disabled
 *  0b0..Jabber is enabled
 */
#define ENET_MAC_CONFIGURATION_JD(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_JD_SHIFT)) & ENET_MAC_CONFIGURATION_JD_MASK)

#define ENET_MAC_CONFIGURATION_WD_MASK           (0x80000U)
#define ENET_MAC_CONFIGURATION_WD_SHIFT          (19U)
/*! WD - Watchdog Disable
 *  0b1..Watchdog is disabled
 *  0b0..Watchdog is enabled
 */
#define ENET_MAC_CONFIGURATION_WD(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_WD_SHIFT)) & ENET_MAC_CONFIGURATION_WD_MASK)

#define ENET_MAC_CONFIGURATION_ACS_MASK          (0x100000U)
#define ENET_MAC_CONFIGURATION_ACS_SHIFT         (20U)
/*! ACS - Automatic Pad or CRC Stripping
 *  0b0..Automatic Pad or CRC Stripping is disabled
 *  0b1..Automatic Pad or CRC Stripping is enabled
 */
#define ENET_MAC_CONFIGURATION_ACS(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_ACS_SHIFT)) & ENET_MAC_CONFIGURATION_ACS_MASK)

#define ENET_MAC_CONFIGURATION_CST_MASK          (0x200000U)
#define ENET_MAC_CONFIGURATION_CST_SHIFT         (21U)
/*! CST - CRC stripping for Type packets
 *  0b0..CRC stripping for Type packets is disabled
 *  0b1..CRC stripping for Type packets is enabled
 */
#define ENET_MAC_CONFIGURATION_CST(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_CST_SHIFT)) & ENET_MAC_CONFIGURATION_CST_MASK)

#define ENET_MAC_CONFIGURATION_S2KP_MASK         (0x400000U)
#define ENET_MAC_CONFIGURATION_S2KP_SHIFT        (22U)
/*! S2KP - IEEE 802.3as Support for 2K Packets
 *  0b0..Support upto 2K packet is disabled
 *  0b1..Support upto 2K packet is Enabled
 */
#define ENET_MAC_CONFIGURATION_S2KP(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_S2KP_SHIFT)) & ENET_MAC_CONFIGURATION_S2KP_MASK)

#define ENET_MAC_CONFIGURATION_GPSLCE_MASK       (0x800000U)
#define ENET_MAC_CONFIGURATION_GPSLCE_SHIFT      (23U)
/*! GPSLCE - Giant Packet Size Limit Control Enable
 *  0b0..Giant Packet Size Limit Control is disabled
 *  0b1..Giant Packet Size Limit Control is enabled
 */
#define ENET_MAC_CONFIGURATION_GPSLCE(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_GPSLCE_SHIFT)) & ENET_MAC_CONFIGURATION_GPSLCE_MASK)

#define ENET_MAC_CONFIGURATION_IPG_MASK          (0x7000000U)
#define ENET_MAC_CONFIGURATION_IPG_SHIFT         (24U)
/*! IPG - Inter-Packet Gap
 *  0b111..40 bit times IPG
 *  0b110..48 bit times IPG
 *  0b101..56 bit times IPG
 *  0b100..64 bit times IPG
 *  0b011..72 bit times IPG
 *  0b010..80 bit times IPG
 *  0b001..88 bit times IPG
 *  0b000..96 bit times IPG
 */
#define ENET_MAC_CONFIGURATION_IPG(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_IPG_SHIFT)) & ENET_MAC_CONFIGURATION_IPG_MASK)

#define ENET_MAC_CONFIGURATION_IPC_MASK          (0x8000000U)
#define ENET_MAC_CONFIGURATION_IPC_SHIFT         (27U)
/*! IPC - Checksum Offload
 *  0b0..IP header/payload checksum checking is disabled
 *  0b1..IP header/payload checksum checking is enabled
 */
#define ENET_MAC_CONFIGURATION_IPC(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_IPC_SHIFT)) & ENET_MAC_CONFIGURATION_IPC_MASK)

#define ENET_MAC_CONFIGURATION_SARC_MASK         (0x70000000U)
#define ENET_MAC_CONFIGURATION_SARC_SHIFT        (28U)
/*! SARC - Source Address Insertion or Replacement Control
 *  0b010..Contents of MAC Addr-0 inserted in SA field
 *  0b011..Contents of MAC Addr-0 replaces SA field
 *  0b110..Contents of MAC Addr-1 inserted in SA field
 *  0b111..Contents of MAC Addr-1 replaces SA field
 *  0b000..mti_sa_ctrl_i and ati_sa_ctrl_i input signals control the SA field generation
 */
#define ENET_MAC_CONFIGURATION_SARC(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CONFIGURATION_SARC_SHIFT)) & ENET_MAC_CONFIGURATION_SARC_MASK)
/*! @} */

/*! @name MAC_EXT_CONFIGURATION - MAC Extended Configuration Register */
/*! @{ */

#define ENET_MAC_EXT_CONFIGURATION_GPSL_MASK     (0x3FFFU)
#define ENET_MAC_EXT_CONFIGURATION_GPSL_SHIFT    (0U)
/*! GPSL - Giant Packet Size Limit */
#define ENET_MAC_EXT_CONFIGURATION_GPSL(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIGURATION_GPSL_SHIFT)) & ENET_MAC_EXT_CONFIGURATION_GPSL_MASK)

#define ENET_MAC_EXT_CONFIGURATION_DCRCC_MASK    (0x10000U)
#define ENET_MAC_EXT_CONFIGURATION_DCRCC_SHIFT   (16U)
/*! DCRCC - Disable CRC Checking for Received Packets
 *  0b1..CRC Checking is disabled
 *  0b0..CRC Checking is enabled
 */
#define ENET_MAC_EXT_CONFIGURATION_DCRCC(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIGURATION_DCRCC_SHIFT)) & ENET_MAC_EXT_CONFIGURATION_DCRCC_MASK)

#define ENET_MAC_EXT_CONFIGURATION_SPEN_MASK     (0x20000U)
#define ENET_MAC_EXT_CONFIGURATION_SPEN_SHIFT    (17U)
/*! SPEN - Slow Protocol Detection Enable
 *  0b0..Slow Protocol Detection is disabled
 *  0b1..Slow Protocol Detection is enabled
 */
#define ENET_MAC_EXT_CONFIGURATION_SPEN(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIGURATION_SPEN_SHIFT)) & ENET_MAC_EXT_CONFIGURATION_SPEN_MASK)

#define ENET_MAC_EXT_CONFIGURATION_USP_MASK      (0x40000U)
#define ENET_MAC_EXT_CONFIGURATION_USP_SHIFT     (18U)
/*! USP - Unicast Slow Protocol Packet Detect
 *  0b0..Unicast Slow Protocol Packet Detection is disabled
 *  0b1..Unicast Slow Protocol Packet Detection is enabled
 */
#define ENET_MAC_EXT_CONFIGURATION_USP(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIGURATION_USP_SHIFT)) & ENET_MAC_EXT_CONFIGURATION_USP_MASK)

#define ENET_MAC_EXT_CONFIGURATION_PDC_MASK      (0x80000U)
#define ENET_MAC_EXT_CONFIGURATION_PDC_SHIFT     (19U)
/*! PDC - Packet Duplication Control
 *  0b0..Packet Duplication Control is disabled
 *  0b1..Packet Duplication Control is enabled
 */
#define ENET_MAC_EXT_CONFIGURATION_PDC(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIGURATION_PDC_SHIFT)) & ENET_MAC_EXT_CONFIGURATION_PDC_MASK)

#define ENET_MAC_EXT_CONFIGURATION_EIPGEN_MASK   (0x1000000U)
#define ENET_MAC_EXT_CONFIGURATION_EIPGEN_SHIFT  (24U)
/*! EIPGEN - Extended Inter-Packet Gap Enable
 *  0b0..Extended Inter-Packet Gap is disabled
 *  0b1..Extended Inter-Packet Gap is enabled
 */
#define ENET_MAC_EXT_CONFIGURATION_EIPGEN(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIGURATION_EIPGEN_SHIFT)) & ENET_MAC_EXT_CONFIGURATION_EIPGEN_MASK)

#define ENET_MAC_EXT_CONFIGURATION_EIPG_MASK     (0x3E000000U)
#define ENET_MAC_EXT_CONFIGURATION_EIPG_SHIFT    (25U)
/*! EIPG - Extended Inter-Packet Gap */
#define ENET_MAC_EXT_CONFIGURATION_EIPG(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_EXT_CONFIGURATION_EIPG_SHIFT)) & ENET_MAC_EXT_CONFIGURATION_EIPG_MASK)
/*! @} */

/*! @name MAC_PACKET_FILTER - MAC Packet Filter */
/*! @{ */

#define ENET_MAC_PACKET_FILTER_PR_MASK           (0x1U)
#define ENET_MAC_PACKET_FILTER_PR_SHIFT          (0U)
/*! PR - Promiscuous Mode
 *  0b0..Promiscuous Mode is disabled
 *  0b1..Promiscuous Mode is enabled
 */
#define ENET_MAC_PACKET_FILTER_PR(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PACKET_FILTER_PR_SHIFT)) & ENET_MAC_PACKET_FILTER_PR_MASK)

#define ENET_MAC_PACKET_FILTER_DAIF_MASK         (0x8U)
#define ENET_MAC_PACKET_FILTER_DAIF_SHIFT        (3U)
/*! DAIF - DA Inverse Filtering
 *  0b0..DA Inverse Filtering is disabled
 *  0b1..DA Inverse Filtering is enabled
 */
#define ENET_MAC_PACKET_FILTER_DAIF(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PACKET_FILTER_DAIF_SHIFT)) & ENET_MAC_PACKET_FILTER_DAIF_MASK)

#define ENET_MAC_PACKET_FILTER_PM_MASK           (0x10U)
#define ENET_MAC_PACKET_FILTER_PM_SHIFT          (4U)
/*! PM - Pass All Multicast
 *  0b0..Pass All Multicast is disabled
 *  0b1..Pass All Multicast is enabled
 */
#define ENET_MAC_PACKET_FILTER_PM(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PACKET_FILTER_PM_SHIFT)) & ENET_MAC_PACKET_FILTER_PM_MASK)

#define ENET_MAC_PACKET_FILTER_DBF_MASK          (0x20U)
#define ENET_MAC_PACKET_FILTER_DBF_SHIFT         (5U)
/*! DBF - Disable Broadcast Packets
 *  0b1..Disable Broadcast Packets
 *  0b0..Enable Broadcast Packets
 */
#define ENET_MAC_PACKET_FILTER_DBF(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PACKET_FILTER_DBF_SHIFT)) & ENET_MAC_PACKET_FILTER_DBF_MASK)

#define ENET_MAC_PACKET_FILTER_PCF_MASK          (0xC0U)
#define ENET_MAC_PACKET_FILTER_PCF_SHIFT         (6U)
/*! PCF - Pass Control Packets
 *  0b00..MAC filters all control packets from reaching the application
 *  0b10..MAC forwards all control packets to the application even if they fail the address filter
 *  0b11..MAC forwards the control packets that pass the Address filter
 *  0b01..MAC forwards all control packets except Pause packets to the application even if they fail the address filter
 */
#define ENET_MAC_PACKET_FILTER_PCF(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PACKET_FILTER_PCF_SHIFT)) & ENET_MAC_PACKET_FILTER_PCF_MASK)

#define ENET_MAC_PACKET_FILTER_VTFE_MASK         (0x10000U)
#define ENET_MAC_PACKET_FILTER_VTFE_SHIFT        (16U)
/*! VTFE - VLAN Tag Filter Enable
 *  0b0..VLAN Tag Filter is disabled
 *  0b1..VLAN Tag Filter is enabled
 */
#define ENET_MAC_PACKET_FILTER_VTFE(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PACKET_FILTER_VTFE_SHIFT)) & ENET_MAC_PACKET_FILTER_VTFE_MASK)

#define ENET_MAC_PACKET_FILTER_RA_MASK           (0x80000000U)
#define ENET_MAC_PACKET_FILTER_RA_SHIFT          (31U)
/*! RA - Receive All
 *  0b0..Receive All is disabled
 *  0b1..Receive All is enabled
 */
#define ENET_MAC_PACKET_FILTER_RA(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PACKET_FILTER_RA_SHIFT)) & ENET_MAC_PACKET_FILTER_RA_MASK)
/*! @} */

/*! @name MAC_WATCHDOG_TIMEOUT - Watchdog Timeout */
/*! @{ */

#define ENET_MAC_WATCHDOG_TIMEOUT_WTO_MASK       (0xFU)
#define ENET_MAC_WATCHDOG_TIMEOUT_WTO_SHIFT      (0U)
/*! WTO - Watchdog Timeout
 *  0b1000..10 KB
 *  0b1001..11 KB
 *  0b1010..12 KB
 *  0b1011..13 KB
 *  0b1100..14 KB
 *  0b1101..15 KB
 *  0b1110..16383 Bytes
 *  0b0000..2 KB
 *  0b0001..3 KB
 *  0b0010..4 KB
 *  0b0011..5 KB
 *  0b0100..6 KB
 *  0b0101..7 KB
 *  0b0110..8 KB
 *  0b0111..9 KB
 *  0b1111..Reserved
 */
#define ENET_MAC_WATCHDOG_TIMEOUT_WTO(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_WATCHDOG_TIMEOUT_WTO_SHIFT)) & ENET_MAC_WATCHDOG_TIMEOUT_WTO_MASK)

#define ENET_MAC_WATCHDOG_TIMEOUT_PWE_MASK       (0x100U)
#define ENET_MAC_WATCHDOG_TIMEOUT_PWE_SHIFT      (8U)
/*! PWE - Programmable Watchdog Enable
 *  0b0..Programmable Watchdog is disabled
 *  0b1..Programmable Watchdog is enabled
 */
#define ENET_MAC_WATCHDOG_TIMEOUT_PWE(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_WATCHDOG_TIMEOUT_PWE_SHIFT)) & ENET_MAC_WATCHDOG_TIMEOUT_PWE_MASK)
/*! @} */

/*! @name MAC_VLAN_TAG_CTRL - MAC VLAN Tag Control */
/*! @{ */

#define ENET_MAC_VLAN_TAG_CTRL_VL_MASK           (0xFFFFU)
#define ENET_MAC_VLAN_TAG_CTRL_VL_SHIFT          (0U)
/*! VL - VLAN Tag Identifier for Receive Packets */
#define ENET_MAC_VLAN_TAG_CTRL_VL(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_VL_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_VL_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_ETV_MASK          (0x10000U)
#define ENET_MAC_VLAN_TAG_CTRL_ETV_SHIFT         (16U)
/*! ETV - Enable 12-Bit VLAN Tag Comparison
 *  0b0..12-bit VLAN Tag Comparison is disabled
 *  0b1..12-bit VLAN Tag Comparison is enabled
 */
#define ENET_MAC_VLAN_TAG_CTRL_ETV(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_ETV_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_ETV_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_VTIM_MASK         (0x20000U)
#define ENET_MAC_VLAN_TAG_CTRL_VTIM_SHIFT        (17U)
/*! VTIM - VLAN Tag Inverse Match Enable
 *  0b0..VLAN Tag Inverse Match is disabled
 *  0b1..VLAN Tag Inverse Match is enabled
 */
#define ENET_MAC_VLAN_TAG_CTRL_VTIM(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_VTIM_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_VTIM_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_ESVL_MASK         (0x40000U)
#define ENET_MAC_VLAN_TAG_CTRL_ESVL_SHIFT        (18U)
/*! ESVL - Enable S-VLAN
 *  0b0..S-VLAN is disabled
 *  0b1..S-VLAN is enabled
 */
#define ENET_MAC_VLAN_TAG_CTRL_ESVL(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_ESVL_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_ESVL_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_ERSVLM_MASK       (0x80000U)
#define ENET_MAC_VLAN_TAG_CTRL_ERSVLM_SHIFT      (19U)
/*! ERSVLM - Enable Receive S-VLAN Match
 *  0b0..Receive S-VLAN Match is disabled
 *  0b1..Receive S-VLAN Match is enabled
 */
#define ENET_MAC_VLAN_TAG_CTRL_ERSVLM(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_ERSVLM_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_ERSVLM_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_DOVLTC_MASK       (0x100000U)
#define ENET_MAC_VLAN_TAG_CTRL_DOVLTC_SHIFT      (20U)
/*! DOVLTC - Disable VLAN Type Check
 *  0b1..VLAN Type Check is disabled
 *  0b0..VLAN Type Check is enabled
 */
#define ENET_MAC_VLAN_TAG_CTRL_DOVLTC(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_DOVLTC_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_DOVLTC_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_EVLS_MASK         (0x600000U)
#define ENET_MAC_VLAN_TAG_CTRL_EVLS_SHIFT        (21U)
/*! EVLS - Enable VLAN Tag Stripping on Receive
 *  0b11..Always strip
 *  0b00..Do not strip
 *  0b10..Strip if VLAN filter fails
 *  0b01..Strip if VLAN filter passes
 */
#define ENET_MAC_VLAN_TAG_CTRL_EVLS(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_EVLS_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_EVLS_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_EVLRXS_MASK       (0x1000000U)
#define ENET_MAC_VLAN_TAG_CTRL_EVLRXS_SHIFT      (24U)
/*! EVLRXS - Enable VLAN Tag in Rx status
 *  0b0..VLAN Tag in Rx status is disabled
 *  0b1..VLAN Tag in Rx status is enabled
 */
#define ENET_MAC_VLAN_TAG_CTRL_EVLRXS(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_EVLRXS_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_EVLRXS_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_EDVLP_MASK        (0x4000000U)
#define ENET_MAC_VLAN_TAG_CTRL_EDVLP_SHIFT       (26U)
/*! EDVLP - Enable Double VLAN Processing
 *  0b0..Double VLAN Processing is disabled
 *  0b1..Double VLAN Processing is enabled
 */
#define ENET_MAC_VLAN_TAG_CTRL_EDVLP(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_EDVLP_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_EDVLP_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_ERIVLT_MASK       (0x8000000U)
#define ENET_MAC_VLAN_TAG_CTRL_ERIVLT_SHIFT      (27U)
/*! ERIVLT - Enable Inner VLAN Tag
 *  0b0..Inner VLAN tag is disabled
 *  0b1..Inner VLAN tag is enabled
 */
#define ENET_MAC_VLAN_TAG_CTRL_ERIVLT(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_ERIVLT_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_ERIVLT_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_EIVLS_MASK        (0x30000000U)
#define ENET_MAC_VLAN_TAG_CTRL_EIVLS_SHIFT       (28U)
/*! EIVLS - Enable Inner VLAN Tag Stripping on Receive
 *  0b11..Always strip
 *  0b00..Do not strip
 *  0b10..Strip if VLAN filter fails
 *  0b01..Strip if VLAN filter passes
 */
#define ENET_MAC_VLAN_TAG_CTRL_EIVLS(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_EIVLS_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_EIVLS_MASK)

#define ENET_MAC_VLAN_TAG_CTRL_EIVLRXS_MASK      (0x80000000U)
#define ENET_MAC_VLAN_TAG_CTRL_EIVLRXS_SHIFT     (31U)
/*! EIVLRXS - Enable Inner VLAN Tag in Rx Status
 *  0b0..Inner VLAN Tag in Rx status is disabled
 *  0b1..Inner VLAN Tag in Rx status is enabled
 */
#define ENET_MAC_VLAN_TAG_CTRL_EIVLRXS(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_TAG_CTRL_EIVLRXS_SHIFT)) & ENET_MAC_VLAN_TAG_CTRL_EIVLRXS_MASK)
/*! @} */

/*! @name MAC_VLAN_INCL - VLAN Tag Inclusion or Replacement */
/*! @{ */

#define ENET_MAC_VLAN_INCL_VLT_MASK              (0xFFFFU)
#define ENET_MAC_VLAN_INCL_VLT_SHIFT             (0U)
/*! VLT - VLAN Tag for Transmit Packets */
#define ENET_MAC_VLAN_INCL_VLT(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_INCL_VLT_SHIFT)) & ENET_MAC_VLAN_INCL_VLT_MASK)

#define ENET_MAC_VLAN_INCL_VLC_MASK              (0x30000U)
#define ENET_MAC_VLAN_INCL_VLC_SHIFT             (16U)
/*! VLC - VLAN Tag Control in Transmit Packets
 *  0b01..VLAN tag deletion
 *  0b10..VLAN tag insertion
 *  0b00..No VLAN tag deletion, insertion, or replacement
 *  0b11..VLAN tag replacement
 */
#define ENET_MAC_VLAN_INCL_VLC(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_INCL_VLC_SHIFT)) & ENET_MAC_VLAN_INCL_VLC_MASK)

#define ENET_MAC_VLAN_INCL_VLP_MASK              (0x40000U)
#define ENET_MAC_VLAN_INCL_VLP_SHIFT             (18U)
/*! VLP - VLAN Priority Control
 *  0b0..VLAN Priority Control is disabled
 *  0b1..VLAN Priority Control is enabled
 */
#define ENET_MAC_VLAN_INCL_VLP(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_INCL_VLP_SHIFT)) & ENET_MAC_VLAN_INCL_VLP_MASK)

#define ENET_MAC_VLAN_INCL_CSVL_MASK             (0x80000U)
#define ENET_MAC_VLAN_INCL_CSVL_SHIFT            (19U)
/*! CSVL - C-VLAN or S-VLAN
 *  0b0..C-VLAN type (0x8100) is inserted or replaced
 *  0b1..S-VLAN type (0x88A8) is inserted or replaced
 */
#define ENET_MAC_VLAN_INCL_CSVL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_INCL_CSVL_SHIFT)) & ENET_MAC_VLAN_INCL_CSVL_MASK)

#define ENET_MAC_VLAN_INCL_VLTI_MASK             (0x100000U)
#define ENET_MAC_VLAN_INCL_VLTI_SHIFT            (20U)
/*! VLTI - VLAN Tag Input
 *  0b0..VLAN Tag Input is disabled
 *  0b1..VLAN Tag Input is enabled
 */
#define ENET_MAC_VLAN_INCL_VLTI(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_INCL_VLTI_SHIFT)) & ENET_MAC_VLAN_INCL_VLTI_MASK)

#define ENET_MAC_VLAN_INCL_CBTI_MASK             (0x200000U)
#define ENET_MAC_VLAN_INCL_CBTI_SHIFT            (21U)
/*! CBTI - Channel based tag insertion
 *  0b0..Channel based tag insertion is disabled
 *  0b1..Channel based tag insertion is enabled
 */
#define ENET_MAC_VLAN_INCL_CBTI(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_INCL_CBTI_SHIFT)) & ENET_MAC_VLAN_INCL_CBTI_MASK)

#define ENET_MAC_VLAN_INCL_ADDR_MASK             (0x1000000U)
#define ENET_MAC_VLAN_INCL_ADDR_SHIFT            (24U)
/*! ADDR - Address */
#define ENET_MAC_VLAN_INCL_ADDR(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_INCL_ADDR_SHIFT)) & ENET_MAC_VLAN_INCL_ADDR_MASK)

#define ENET_MAC_VLAN_INCL_RDWR_MASK             (0x40000000U)
#define ENET_MAC_VLAN_INCL_RDWR_SHIFT            (30U)
/*! RDWR - Read write control
 *  0b0..Read operation of indirect access
 *  0b1..Write operation of indirect access
 */
#define ENET_MAC_VLAN_INCL_RDWR(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_INCL_RDWR_SHIFT)) & ENET_MAC_VLAN_INCL_RDWR_MASK)

#define ENET_MAC_VLAN_INCL_BUSY_MASK             (0x80000000U)
#define ENET_MAC_VLAN_INCL_BUSY_SHIFT            (31U)
/*! BUSY - Busy
 *  0b1..Busy status detected
 *  0b0..Busy status not detected
 */
#define ENET_MAC_VLAN_INCL_BUSY(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VLAN_INCL_BUSY_SHIFT)) & ENET_MAC_VLAN_INCL_BUSY_MASK)
/*! @} */

/*! @name MAC_INNER_VLAN_INCL - MAC Inner VLAN Tag Inclusion or Replacement */
/*! @{ */

#define ENET_MAC_INNER_VLAN_INCL_VLT_MASK        (0xFFFFU)
#define ENET_MAC_INNER_VLAN_INCL_VLT_SHIFT       (0U)
/*! VLT - VLAN Tag for Transmit Packets */
#define ENET_MAC_INNER_VLAN_INCL_VLT(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INNER_VLAN_INCL_VLT_SHIFT)) & ENET_MAC_INNER_VLAN_INCL_VLT_MASK)

#define ENET_MAC_INNER_VLAN_INCL_VLC_MASK        (0x30000U)
#define ENET_MAC_INNER_VLAN_INCL_VLC_SHIFT       (16U)
/*! VLC - VLAN Tag Control in Transmit Packets
 *  0b01..VLAN tag deletion
 *  0b10..VLAN tag insertion
 *  0b00..No VLAN tag deletion, insertion, or replacement
 *  0b11..VLAN tag replacement
 */
#define ENET_MAC_INNER_VLAN_INCL_VLC(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INNER_VLAN_INCL_VLC_SHIFT)) & ENET_MAC_INNER_VLAN_INCL_VLC_MASK)

#define ENET_MAC_INNER_VLAN_INCL_VLP_MASK        (0x40000U)
#define ENET_MAC_INNER_VLAN_INCL_VLP_SHIFT       (18U)
/*! VLP - VLAN Priority Control
 *  0b0..VLAN Priority Control is disabled
 *  0b1..VLAN Priority Control is enabled
 */
#define ENET_MAC_INNER_VLAN_INCL_VLP(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INNER_VLAN_INCL_VLP_SHIFT)) & ENET_MAC_INNER_VLAN_INCL_VLP_MASK)

#define ENET_MAC_INNER_VLAN_INCL_CSVL_MASK       (0x80000U)
#define ENET_MAC_INNER_VLAN_INCL_CSVL_SHIFT      (19U)
/*! CSVL - C-VLAN or S-VLAN
 *  0b0..C-VLAN type (0x8100) is inserted
 *  0b1..S-VLAN type (0x88A8) is inserted
 */
#define ENET_MAC_INNER_VLAN_INCL_CSVL(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INNER_VLAN_INCL_CSVL_SHIFT)) & ENET_MAC_INNER_VLAN_INCL_CSVL_MASK)

#define ENET_MAC_INNER_VLAN_INCL_VLTI_MASK       (0x100000U)
#define ENET_MAC_INNER_VLAN_INCL_VLTI_SHIFT      (20U)
/*! VLTI - VLAN Tag Input
 *  0b0..VLAN Tag Input is disabled
 *  0b1..VLAN Tag Input is enabled
 */
#define ENET_MAC_INNER_VLAN_INCL_VLTI(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INNER_VLAN_INCL_VLTI_SHIFT)) & ENET_MAC_INNER_VLAN_INCL_VLTI_MASK)
/*! @} */

/*! @name MAC_TX_FLOW_CTRL_Q - MAC Q0 Tx Flow Control */
/*! @{ */

#define ENET_MAC_TX_FLOW_CTRL_Q_FCB_BPA_MASK     (0x1U)
#define ENET_MAC_TX_FLOW_CTRL_Q_FCB_BPA_SHIFT    (0U)
/*! FCB_BPA - Flow Control Busy or Backpressure Activate
 *  0b0..Flow Control Busy or Backpressure Activate is disabled
 *  0b1..Flow Control Busy or Backpressure Activate is enabled
 */
#define ENET_MAC_TX_FLOW_CTRL_Q_FCB_BPA(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_FLOW_CTRL_Q_FCB_BPA_SHIFT)) & ENET_MAC_TX_FLOW_CTRL_Q_FCB_BPA_MASK)

#define ENET_MAC_TX_FLOW_CTRL_Q_TFE_MASK         (0x2U)
#define ENET_MAC_TX_FLOW_CTRL_Q_TFE_SHIFT        (1U)
/*! TFE - Transmit Flow Control Enable
 *  0b0..Transmit Flow Control is disabled
 *  0b1..Transmit Flow Control is enabled
 */
#define ENET_MAC_TX_FLOW_CTRL_Q_TFE(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_FLOW_CTRL_Q_TFE_SHIFT)) & ENET_MAC_TX_FLOW_CTRL_Q_TFE_MASK)

#define ENET_MAC_TX_FLOW_CTRL_Q_PLT_MASK         (0x70U)
#define ENET_MAC_TX_FLOW_CTRL_Q_PLT_SHIFT        (4U)
/*! PLT - Pause Low Threshold
 *  0b011..Pause Time minus 144 Slot Times (PT -144 slot times)
 *  0b100..Pause Time minus 256 Slot Times (PT -256 slot times)
 *  0b001..Pause Time minus 28 Slot Times (PT -28 slot times)
 *  0b010..Pause Time minus 36 Slot Times (PT -36 slot times)
 *  0b000..Pause Time minus 4 Slot Times (PT -4 slot times)
 *  0b101..Pause Time minus 512 Slot Times (PT -512 slot times)
 *  0b110..Reserved
 */
#define ENET_MAC_TX_FLOW_CTRL_Q_PLT(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_FLOW_CTRL_Q_PLT_SHIFT)) & ENET_MAC_TX_FLOW_CTRL_Q_PLT_MASK)

#define ENET_MAC_TX_FLOW_CTRL_Q_DZPQ_MASK        (0x80U)
#define ENET_MAC_TX_FLOW_CTRL_Q_DZPQ_SHIFT       (7U)
/*! DZPQ - Disable Zero-Quanta Pause
 *  0b1..Zero-Quanta Pause packet generation is disabled
 *  0b0..Zero-Quanta Pause packet generation is enabled
 */
#define ENET_MAC_TX_FLOW_CTRL_Q_DZPQ(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_FLOW_CTRL_Q_DZPQ_SHIFT)) & ENET_MAC_TX_FLOW_CTRL_Q_DZPQ_MASK)

#define ENET_MAC_TX_FLOW_CTRL_Q_PT_MASK          (0xFFFF0000U)
#define ENET_MAC_TX_FLOW_CTRL_Q_PT_SHIFT         (16U)
/*! PT - Pause Time */
#define ENET_MAC_TX_FLOW_CTRL_Q_PT(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_FLOW_CTRL_Q_PT_SHIFT)) & ENET_MAC_TX_FLOW_CTRL_Q_PT_MASK)
/*! @} */

/* The count of ENET_MAC_TX_FLOW_CTRL_Q */
#define ENET_MAC_TX_FLOW_CTRL_Q_COUNT            (1U)

/*! @name MAC_RX_FLOW_CTRL - MAC Rx Flow Control */
/*! @{ */

#define ENET_MAC_RX_FLOW_CTRL_RFE_MASK           (0x1U)
#define ENET_MAC_RX_FLOW_CTRL_RFE_SHIFT          (0U)
/*! RFE - Receive Flow Control Enable
 *  0b0..Receive Flow Control is disabled
 *  0b1..Receive Flow Control is enabled
 */
#define ENET_MAC_RX_FLOW_CTRL_RFE(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_FLOW_CTRL_RFE_SHIFT)) & ENET_MAC_RX_FLOW_CTRL_RFE_MASK)

#define ENET_MAC_RX_FLOW_CTRL_UP_MASK            (0x2U)
#define ENET_MAC_RX_FLOW_CTRL_UP_SHIFT           (1U)
/*! UP - Unicast Pause Packet Detect
 *  0b0..Unicast Pause Packet Detect disabled
 *  0b1..Unicast Pause Packet Detect enabled
 */
#define ENET_MAC_RX_FLOW_CTRL_UP(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_FLOW_CTRL_UP_SHIFT)) & ENET_MAC_RX_FLOW_CTRL_UP_MASK)
/*! @} */

/*! @name MAC_RXQ_CTRL4 - Receive Queue Control 4 */
/*! @{ */

#define ENET_MAC_RXQ_CTRL4_UFFQE_MASK            (0x1U)
#define ENET_MAC_RXQ_CTRL4_UFFQE_SHIFT           (0U)
/*! UFFQE - Unicast Address Filter Fail Packets Queuing Enable.
 *  0b0..Unicast Address Filter Fail Packets Queuing is disabled
 *  0b1..Unicast Address Filter Fail Packets Queuing is enabled
 */
#define ENET_MAC_RXQ_CTRL4_UFFQE(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL4_UFFQE_SHIFT)) & ENET_MAC_RXQ_CTRL4_UFFQE_MASK)

#define ENET_MAC_RXQ_CTRL4_UFFQ_MASK             (0x2U)
#define ENET_MAC_RXQ_CTRL4_UFFQ_SHIFT            (1U)
/*! UFFQ - Unicast Address Filter Fail Packets Queue. */
#define ENET_MAC_RXQ_CTRL4_UFFQ(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL4_UFFQ_SHIFT)) & ENET_MAC_RXQ_CTRL4_UFFQ_MASK)

#define ENET_MAC_RXQ_CTRL4_MFFQE_MASK            (0x100U)
#define ENET_MAC_RXQ_CTRL4_MFFQE_SHIFT           (8U)
/*! MFFQE - Multicast Address Filter Fail Packets Queuing Enable.
 *  0b0..Multicast Address Filter Fail Packets Queuing is disabled
 *  0b1..Multicast Address Filter Fail Packets Queuing is enabled
 */
#define ENET_MAC_RXQ_CTRL4_MFFQE(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL4_MFFQE_SHIFT)) & ENET_MAC_RXQ_CTRL4_MFFQE_MASK)

#define ENET_MAC_RXQ_CTRL4_MFFQ_MASK             (0x200U)
#define ENET_MAC_RXQ_CTRL4_MFFQ_SHIFT            (9U)
/*! MFFQ - Multicast Address Filter Fail Packets Queue. */
#define ENET_MAC_RXQ_CTRL4_MFFQ(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL4_MFFQ_SHIFT)) & ENET_MAC_RXQ_CTRL4_MFFQ_MASK)

#define ENET_MAC_RXQ_CTRL4_VFFQE_MASK            (0x10000U)
#define ENET_MAC_RXQ_CTRL4_VFFQE_SHIFT           (16U)
/*! VFFQE - VLAN Tag Filter Fail Packets Queuing Enable
 *  0b0..VLAN tag Filter Fail Packets Queuing is disabled
 *  0b1..VLAN tag Filter Fail Packets Queuing is enabled
 */
#define ENET_MAC_RXQ_CTRL4_VFFQE(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL4_VFFQE_SHIFT)) & ENET_MAC_RXQ_CTRL4_VFFQE_MASK)

#define ENET_MAC_RXQ_CTRL4_VFFQ_MASK             (0x20000U)
#define ENET_MAC_RXQ_CTRL4_VFFQ_SHIFT            (17U)
/*! VFFQ - VLAN Tag Filter Fail Packets Queue */
#define ENET_MAC_RXQ_CTRL4_VFFQ(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL4_VFFQ_SHIFT)) & ENET_MAC_RXQ_CTRL4_VFFQ_MASK)
/*! @} */

/*! @name MAC_RXQ_CTRL - Receive Queue Control 0..Receive Queue Control 2 */
/*! @{ */

#define ENET_MAC_RXQ_CTRL_AVCPQ_MASK             (0x7U)
#define ENET_MAC_RXQ_CTRL_AVCPQ_SHIFT            (0U)
/*! AVCPQ - AV Untagged Control Packets Queue
 *  0b000..Receive Queue 0
 *  0b001..Receive Queue 1
 */
#define ENET_MAC_RXQ_CTRL_AVCPQ(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_AVCPQ_SHIFT)) & ENET_MAC_RXQ_CTRL_AVCPQ_MASK)

#define ENET_MAC_RXQ_CTRL_PSRQ0_MASK             (0xFFU)
#define ENET_MAC_RXQ_CTRL_PSRQ0_SHIFT            (0U)
/*! PSRQ0 - Priorities Selected in the Receive Queue 0 */
#define ENET_MAC_RXQ_CTRL_PSRQ0(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_PSRQ0_SHIFT)) & ENET_MAC_RXQ_CTRL_PSRQ0_MASK)

#define ENET_MAC_RXQ_CTRL_RXQ0EN_MASK            (0x3U)
#define ENET_MAC_RXQ_CTRL_RXQ0EN_SHIFT           (0U)
/*! RXQ0EN - Receive Queue 0 Enable
 *  0b00..Queue not enabled
 *  0b01..Queue enabled for AV
 *  0b10..Queue enabled for DCB/Generic
 *  0b11..Reserved
 */
#define ENET_MAC_RXQ_CTRL_RXQ0EN(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_RXQ0EN_SHIFT)) & ENET_MAC_RXQ_CTRL_RXQ0EN_MASK)

#define ENET_MAC_RXQ_CTRL_RXQ1EN_MASK            (0xCU)
#define ENET_MAC_RXQ_CTRL_RXQ1EN_SHIFT           (2U)
/*! RXQ1EN - Receive Queue 1 Enable
 *  0b00..Queue not enabled
 *  0b01..Queue enabled for AV
 *  0b10..Queue enabled for DCB/Generic
 *  0b11..Reserved
 */
#define ENET_MAC_RXQ_CTRL_RXQ1EN(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_RXQ1EN_SHIFT)) & ENET_MAC_RXQ_CTRL_RXQ1EN_MASK)

#define ENET_MAC_RXQ_CTRL_PTPQ_MASK              (0x70U)
#define ENET_MAC_RXQ_CTRL_PTPQ_SHIFT             (4U)
/*! PTPQ - PTP Packets Queue
 *  0b000..Receive Queue 0
 *  0b001..Receive Queue 1
 */
#define ENET_MAC_RXQ_CTRL_PTPQ(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_PTPQ_SHIFT)) & ENET_MAC_RXQ_CTRL_PTPQ_MASK)

#define ENET_MAC_RXQ_CTRL_PSRQ1_MASK             (0xFF00U)
#define ENET_MAC_RXQ_CTRL_PSRQ1_SHIFT            (8U)
/*! PSRQ1 - Priorities Selected in the Receive Queue 1 */
#define ENET_MAC_RXQ_CTRL_PSRQ1(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_PSRQ1_SHIFT)) & ENET_MAC_RXQ_CTRL_PSRQ1_MASK)

#define ENET_MAC_RXQ_CTRL_UPQ_MASK               (0x7000U)
#define ENET_MAC_RXQ_CTRL_UPQ_SHIFT              (12U)
/*! UPQ - Untagged Packet Queue
 *  0b000..Receive Queue 0
 *  0b001..Receive Queue 1
 */
#define ENET_MAC_RXQ_CTRL_UPQ(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_UPQ_SHIFT)) & ENET_MAC_RXQ_CTRL_UPQ_MASK)

#define ENET_MAC_RXQ_CTRL_MCBCQ_MASK             (0x70000U)
#define ENET_MAC_RXQ_CTRL_MCBCQ_SHIFT            (16U)
/*! MCBCQ - Multicast and Broadcast Queue
 *  0b000..Receive Queue 0
 *  0b001..Receive Queue 1
 */
#define ENET_MAC_RXQ_CTRL_MCBCQ(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_MCBCQ_SHIFT)) & ENET_MAC_RXQ_CTRL_MCBCQ_MASK)

#define ENET_MAC_RXQ_CTRL_MCBCQEN_MASK           (0x100000U)
#define ENET_MAC_RXQ_CTRL_MCBCQEN_SHIFT          (20U)
/*! MCBCQEN - Multicast and Broadcast Queue Enable
 *  0b0..Multicast and Broadcast Queue is disabled
 *  0b1..Multicast and Broadcast Queue is enabled
 */
#define ENET_MAC_RXQ_CTRL_MCBCQEN(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_MCBCQEN_SHIFT)) & ENET_MAC_RXQ_CTRL_MCBCQEN_MASK)

#define ENET_MAC_RXQ_CTRL_TACPQE_MASK            (0x200000U)
#define ENET_MAC_RXQ_CTRL_TACPQE_SHIFT           (21U)
/*! TACPQE - Tagged AV Control Packets Queuing Enable.
 *  0b0..Tagged AV Control Packets Queuing is disabled
 *  0b1..Tagged AV Control Packets Queuing is enabled
 */
#define ENET_MAC_RXQ_CTRL_TACPQE(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_TACPQE_SHIFT)) & ENET_MAC_RXQ_CTRL_TACPQE_MASK)

#define ENET_MAC_RXQ_CTRL_TPQC_MASK              (0xC00000U)
#define ENET_MAC_RXQ_CTRL_TPQC_SHIFT             (22U)
/*! TPQC - Tagged PTP over Ethernet Packets Queuing Control. */
#define ENET_MAC_RXQ_CTRL_TPQC(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_TPQC_SHIFT)) & ENET_MAC_RXQ_CTRL_TPQC_MASK)

#define ENET_MAC_RXQ_CTRL_OMCBCQ_MASK            (0x10000000U)
#define ENET_MAC_RXQ_CTRL_OMCBCQ_SHIFT           (28U)
/*! OMCBCQ - OMCBCQ
 *  0b0..overriding MCBCQ priority disabled
 *  0b1..overriding MCBCQ priority enabled
 */
#define ENET_MAC_RXQ_CTRL_OMCBCQ(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_OMCBCQ_SHIFT)) & ENET_MAC_RXQ_CTRL_OMCBCQ_MASK)

#define ENET_MAC_RXQ_CTRL_TBRQE_MASK             (0x20000000U)
#define ENET_MAC_RXQ_CTRL_TBRQE_SHIFT            (29U)
/*! TBRQE - Type Field Based Rx Queuing Enable */
#define ENET_MAC_RXQ_CTRL_TBRQE(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RXQ_CTRL_TBRQE_SHIFT)) & ENET_MAC_RXQ_CTRL_TBRQE_MASK)
/*! @} */

/* The count of ENET_MAC_RXQ_CTRL */
#define ENET_MAC_RXQ_CTRL_COUNT                  (3U)

/*! @name MAC_INTERRUPT_STATUS - Interrupt Status */
/*! @{ */

#define ENET_MAC_INTERRUPT_STATUS_PHYIS_MASK     (0x8U)
#define ENET_MAC_INTERRUPT_STATUS_PHYIS_SHIFT    (3U)
/*! PHYIS - PHY Interrupt
 *  0b1..PHY Interrupt detected
 *  0b0..PHY Interrupt not detected
 */
#define ENET_MAC_INTERRUPT_STATUS_PHYIS(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_STATUS_PHYIS_SHIFT)) & ENET_MAC_INTERRUPT_STATUS_PHYIS_MASK)

#define ENET_MAC_INTERRUPT_STATUS_PMTIS_MASK     (0x10U)
#define ENET_MAC_INTERRUPT_STATUS_PMTIS_SHIFT    (4U)
/*! PMTIS - PMTIS
 *  0b1..PMT Interrupt status active
 *  0b0..PMT Interrupt status not active
 */
#define ENET_MAC_INTERRUPT_STATUS_PMTIS(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_STATUS_PMTIS_SHIFT)) & ENET_MAC_INTERRUPT_STATUS_PMTIS_MASK)

#define ENET_MAC_INTERRUPT_STATUS_LPIIS_MASK     (0x20U)
#define ENET_MAC_INTERRUPT_STATUS_LPIIS_SHIFT    (5U)
/*! LPIIS - LPIIS
 *  0b1..LPI Interrupt status active
 *  0b0..LPI Interrupt status not active
 */
#define ENET_MAC_INTERRUPT_STATUS_LPIIS(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_STATUS_LPIIS_SHIFT)) & ENET_MAC_INTERRUPT_STATUS_LPIIS_MASK)

#define ENET_MAC_INTERRUPT_STATUS_TSIS_MASK      (0x1000U)
#define ENET_MAC_INTERRUPT_STATUS_TSIS_SHIFT     (12U)
/*! TSIS - TSIS
 *  0b1..Timestamp Interrupt status active
 *  0b0..Timestamp Interrupt status not active
 */
#define ENET_MAC_INTERRUPT_STATUS_TSIS(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_STATUS_TSIS_SHIFT)) & ENET_MAC_INTERRUPT_STATUS_TSIS_MASK)

#define ENET_MAC_INTERRUPT_STATUS_TXSTSIS_MASK   (0x2000U)
#define ENET_MAC_INTERRUPT_STATUS_TXSTSIS_SHIFT  (13U)
/*! TXSTSIS - Transmit Status Interrupt
 *  0b1..Transmit Interrupt status active
 *  0b0..Transmit Interrupt status not active
 */
#define ENET_MAC_INTERRUPT_STATUS_TXSTSIS(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_STATUS_TXSTSIS_SHIFT)) & ENET_MAC_INTERRUPT_STATUS_TXSTSIS_MASK)

#define ENET_MAC_INTERRUPT_STATUS_RXSTSIS_MASK   (0x4000U)
#define ENET_MAC_INTERRUPT_STATUS_RXSTSIS_SHIFT  (14U)
/*! RXSTSIS - Receive Status Interrupt
 *  0b1..Receive Interrupt status active
 *  0b0..Receive Interrupt status not active
 */
#define ENET_MAC_INTERRUPT_STATUS_RXSTSIS(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_STATUS_RXSTSIS_SHIFT)) & ENET_MAC_INTERRUPT_STATUS_RXSTSIS_MASK)

#define ENET_MAC_INTERRUPT_STATUS_MDIOIS_MASK    (0x40000U)
#define ENET_MAC_INTERRUPT_STATUS_MDIOIS_SHIFT   (18U)
/*! MDIOIS - MDIO Interrupt Status
 *  0b1..MDIO Interrupt status active
 *  0b0..MDIO Interrupt status not active
 */
#define ENET_MAC_INTERRUPT_STATUS_MDIOIS(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_STATUS_MDIOIS_SHIFT)) & ENET_MAC_INTERRUPT_STATUS_MDIOIS_MASK)
/*! @} */

/*! @name MAC_INTERRUPT_ENABLE - Interrupt Enable */
/*! @{ */

#define ENET_MAC_INTERRUPT_ENABLE_PHYIE_MASK     (0x8U)
#define ENET_MAC_INTERRUPT_ENABLE_PHYIE_SHIFT    (3U)
/*! PHYIE - PHY Interrupt Enable
 *  0b0..PHY Interrupt is disabled
 *  0b1..PHY Interrupt is enabled
 */
#define ENET_MAC_INTERRUPT_ENABLE_PHYIE(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_ENABLE_PHYIE_SHIFT)) & ENET_MAC_INTERRUPT_ENABLE_PHYIE_MASK)

#define ENET_MAC_INTERRUPT_ENABLE_PMTIE_MASK     (0x10U)
#define ENET_MAC_INTERRUPT_ENABLE_PMTIE_SHIFT    (4U)
/*! PMTIE - PMT Interrupt Enable
 *  0b0..PMT Interrupt is disabled
 *  0b1..PMT Interrupt is enabled
 */
#define ENET_MAC_INTERRUPT_ENABLE_PMTIE(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_ENABLE_PMTIE_SHIFT)) & ENET_MAC_INTERRUPT_ENABLE_PMTIE_MASK)

#define ENET_MAC_INTERRUPT_ENABLE_LPIIE_MASK     (0x20U)
#define ENET_MAC_INTERRUPT_ENABLE_LPIIE_SHIFT    (5U)
/*! LPIIE - LPI Interrupt Enable
 *  0b0..LPI Interrupt is disabled
 *  0b1..LPI Interrupt is enabled
 */
#define ENET_MAC_INTERRUPT_ENABLE_LPIIE(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_ENABLE_LPIIE_SHIFT)) & ENET_MAC_INTERRUPT_ENABLE_LPIIE_MASK)

#define ENET_MAC_INTERRUPT_ENABLE_TSIE_MASK      (0x1000U)
#define ENET_MAC_INTERRUPT_ENABLE_TSIE_SHIFT     (12U)
/*! TSIE - Timestamp Interrupt Enable
 *  0b0..Timestamp Interrupt is disabled
 *  0b1..Timestamp Interrupt is enabled
 */
#define ENET_MAC_INTERRUPT_ENABLE_TSIE(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_ENABLE_TSIE_SHIFT)) & ENET_MAC_INTERRUPT_ENABLE_TSIE_MASK)

#define ENET_MAC_INTERRUPT_ENABLE_TXSTSIE_MASK   (0x2000U)
#define ENET_MAC_INTERRUPT_ENABLE_TXSTSIE_SHIFT  (13U)
/*! TXSTSIE - Transmit Status Interrupt Enable
 *  0b0..Timestamp Status Interrupt is disabled
 *  0b1..Timestamp Status Interrupt is enabled
 */
#define ENET_MAC_INTERRUPT_ENABLE_TXSTSIE(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_ENABLE_TXSTSIE_SHIFT)) & ENET_MAC_INTERRUPT_ENABLE_TXSTSIE_MASK)

#define ENET_MAC_INTERRUPT_ENABLE_RXSTSIE_MASK   (0x4000U)
#define ENET_MAC_INTERRUPT_ENABLE_RXSTSIE_SHIFT  (14U)
/*! RXSTSIE - Receive Status Interrupt Enable
 *  0b0..Receive Status Interrupt is disabled
 *  0b1..Receive Status Interrupt is enabled
 */
#define ENET_MAC_INTERRUPT_ENABLE_RXSTSIE(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_ENABLE_RXSTSIE_SHIFT)) & ENET_MAC_INTERRUPT_ENABLE_RXSTSIE_MASK)

#define ENET_MAC_INTERRUPT_ENABLE_MDIOIE_MASK    (0x40000U)
#define ENET_MAC_INTERRUPT_ENABLE_MDIOIE_SHIFT   (18U)
/*! MDIOIE - MDIO Interrupt Enable
 *  0b0..MDIO Interrupt is disabled
 *  0b1..MDIO Interrupt is enabled
 */
#define ENET_MAC_INTERRUPT_ENABLE_MDIOIE(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MAC_INTERRUPT_ENABLE_MDIOIE_SHIFT)) & ENET_MAC_INTERRUPT_ENABLE_MDIOIE_MASK)
/*! @} */

/*! @name MAC_RX_TX_STATUS - Receive Transmit Status */
/*! @{ */

#define ENET_MAC_RX_TX_STATUS_TJT_MASK           (0x1U)
#define ENET_MAC_RX_TX_STATUS_TJT_SHIFT          (0U)
/*! TJT - Transmit Jabber Timeout
 *  0b1..Transmit Jabber Timeout occurred
 *  0b0..No Transmit Jabber Timeout
 */
#define ENET_MAC_RX_TX_STATUS_TJT(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_TX_STATUS_TJT_SHIFT)) & ENET_MAC_RX_TX_STATUS_TJT_MASK)

#define ENET_MAC_RX_TX_STATUS_NCARR_MASK         (0x2U)
#define ENET_MAC_RX_TX_STATUS_NCARR_SHIFT        (1U)
/*! NCARR - No Carrier
 *  0b1..No carrier
 *  0b0..Carrier is present
 */
#define ENET_MAC_RX_TX_STATUS_NCARR(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_TX_STATUS_NCARR_SHIFT)) & ENET_MAC_RX_TX_STATUS_NCARR_MASK)

#define ENET_MAC_RX_TX_STATUS_LCARR_MASK         (0x4U)
#define ENET_MAC_RX_TX_STATUS_LCARR_SHIFT        (2U)
/*! LCARR - Loss of Carrier
 *  0b1..Loss of carrier
 *  0b0..Carrier is present
 */
#define ENET_MAC_RX_TX_STATUS_LCARR(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_TX_STATUS_LCARR_SHIFT)) & ENET_MAC_RX_TX_STATUS_LCARR_MASK)

#define ENET_MAC_RX_TX_STATUS_EXDEF_MASK         (0x8U)
#define ENET_MAC_RX_TX_STATUS_EXDEF_SHIFT        (3U)
/*! EXDEF - Excessive Deferral
 *  0b1..Excessive deferral
 *  0b0..No Excessive deferral
 */
#define ENET_MAC_RX_TX_STATUS_EXDEF(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_TX_STATUS_EXDEF_SHIFT)) & ENET_MAC_RX_TX_STATUS_EXDEF_MASK)

#define ENET_MAC_RX_TX_STATUS_LCOL_MASK          (0x10U)
#define ENET_MAC_RX_TX_STATUS_LCOL_SHIFT         (4U)
/*! LCOL - Late Collision
 *  0b1..Late collision is sensed
 *  0b0..No collision
 */
#define ENET_MAC_RX_TX_STATUS_LCOL(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_TX_STATUS_LCOL_SHIFT)) & ENET_MAC_RX_TX_STATUS_LCOL_MASK)

#define ENET_MAC_RX_TX_STATUS_EXCOL_MASK         (0x20U)
#define ENET_MAC_RX_TX_STATUS_EXCOL_SHIFT        (5U)
/*! EXCOL - Excessive Collisions
 *  0b1..Excessive collision is sensed
 *  0b0..No collision
 */
#define ENET_MAC_RX_TX_STATUS_EXCOL(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_TX_STATUS_EXCOL_SHIFT)) & ENET_MAC_RX_TX_STATUS_EXCOL_MASK)

#define ENET_MAC_RX_TX_STATUS_RWT_MASK           (0x100U)
#define ENET_MAC_RX_TX_STATUS_RWT_SHIFT          (8U)
/*! RWT - Receive Watchdog Timeout
 *  0b1..Receive watchdog timed out
 *  0b0..No receive watchdog timeout
 */
#define ENET_MAC_RX_TX_STATUS_RWT(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RX_TX_STATUS_RWT_SHIFT)) & ENET_MAC_RX_TX_STATUS_RWT_MASK)
/*! @} */

/*! @name MAC_PMT_CONTROL_STATUS - PMT Control and Status */
/*! @{ */

#define ENET_MAC_PMT_CONTROL_STATUS_PWRDWN_MASK  (0x1U)
#define ENET_MAC_PMT_CONTROL_STATUS_PWRDWN_SHIFT (0U)
/*! PWRDWN - Power Down
 *  0b0..Power down is disabled
 *  0b1..Power down is enabled
 */
#define ENET_MAC_PMT_CONTROL_STATUS_PWRDWN(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CONTROL_STATUS_PWRDWN_SHIFT)) & ENET_MAC_PMT_CONTROL_STATUS_PWRDWN_MASK)

#define ENET_MAC_PMT_CONTROL_STATUS_MGKPKTEN_MASK (0x2U)
#define ENET_MAC_PMT_CONTROL_STATUS_MGKPKTEN_SHIFT (1U)
/*! MGKPKTEN - Magic Packet Enable
 *  0b0..Magic Packet is disabled
 *  0b1..Magic Packet is enabled
 */
#define ENET_MAC_PMT_CONTROL_STATUS_MGKPKTEN(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CONTROL_STATUS_MGKPKTEN_SHIFT)) & ENET_MAC_PMT_CONTROL_STATUS_MGKPKTEN_MASK)

#define ENET_MAC_PMT_CONTROL_STATUS_RWKPKTEN_MASK (0x4U)
#define ENET_MAC_PMT_CONTROL_STATUS_RWKPKTEN_SHIFT (2U)
/*! RWKPKTEN - Remote Wake-Up Packet Enable
 *  0b0..Remote wake-up packet is disabled
 *  0b1..Remote wake-up packet is enabled
 */
#define ENET_MAC_PMT_CONTROL_STATUS_RWKPKTEN(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CONTROL_STATUS_RWKPKTEN_SHIFT)) & ENET_MAC_PMT_CONTROL_STATUS_RWKPKTEN_MASK)

#define ENET_MAC_PMT_CONTROL_STATUS_MGKPRCVD_MASK (0x20U)
#define ENET_MAC_PMT_CONTROL_STATUS_MGKPRCVD_SHIFT (5U)
/*! MGKPRCVD - Magic Packet Received
 *  0b1..Magic packet is received
 *  0b0..No Magic packet is received
 */
#define ENET_MAC_PMT_CONTROL_STATUS_MGKPRCVD(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CONTROL_STATUS_MGKPRCVD_SHIFT)) & ENET_MAC_PMT_CONTROL_STATUS_MGKPRCVD_MASK)

#define ENET_MAC_PMT_CONTROL_STATUS_RWKPRCVD_MASK (0x40U)
#define ENET_MAC_PMT_CONTROL_STATUS_RWKPRCVD_SHIFT (6U)
/*! RWKPRCVD - Remote Wake-Up Packet Received
 *  0b1..Remote wake-up packet is received
 *  0b0..Remote wake-up packet is received
 */
#define ENET_MAC_PMT_CONTROL_STATUS_RWKPRCVD(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CONTROL_STATUS_RWKPRCVD_SHIFT)) & ENET_MAC_PMT_CONTROL_STATUS_RWKPRCVD_MASK)

#define ENET_MAC_PMT_CONTROL_STATUS_GLBLUCAST_MASK (0x200U)
#define ENET_MAC_PMT_CONTROL_STATUS_GLBLUCAST_SHIFT (9U)
/*! GLBLUCAST - Global Unicast
 *  0b0..Global unicast is disabled
 *  0b1..Global unicast is enabled
 */
#define ENET_MAC_PMT_CONTROL_STATUS_GLBLUCAST(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CONTROL_STATUS_GLBLUCAST_SHIFT)) & ENET_MAC_PMT_CONTROL_STATUS_GLBLUCAST_MASK)

#define ENET_MAC_PMT_CONTROL_STATUS_RWKPFE_MASK  (0x400U)
#define ENET_MAC_PMT_CONTROL_STATUS_RWKPFE_SHIFT (10U)
/*! RWKPFE - Remote Wake-up Packet Forwarding Enable
 *  0b0..Remote Wake-up Packet Forwarding is disabled
 *  0b1..Remote Wake-up Packet Forwarding is enabled
 */
#define ENET_MAC_PMT_CONTROL_STATUS_RWKPFE(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CONTROL_STATUS_RWKPFE_SHIFT)) & ENET_MAC_PMT_CONTROL_STATUS_RWKPFE_MASK)

#define ENET_MAC_PMT_CONTROL_STATUS_RWKPTR_MASK  (0x1F000000U)
#define ENET_MAC_PMT_CONTROL_STATUS_RWKPTR_SHIFT (24U)
/*! RWKPTR - Remote Wake-up FIFO Pointer */
#define ENET_MAC_PMT_CONTROL_STATUS_RWKPTR(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CONTROL_STATUS_RWKPTR_SHIFT)) & ENET_MAC_PMT_CONTROL_STATUS_RWKPTR_MASK)

#define ENET_MAC_PMT_CONTROL_STATUS_RWKFILTRST_MASK (0x80000000U)
#define ENET_MAC_PMT_CONTROL_STATUS_RWKFILTRST_SHIFT (31U)
/*! RWKFILTRST - Remote Wake-Up Packet Filter Register Pointer Reset
 *  0b0..Remote Wake-Up Packet Filter Register Pointer is not Reset
 *  0b1..Remote Wake-Up Packet Filter Register Pointer is Reset
 */
#define ENET_MAC_PMT_CONTROL_STATUS_RWKFILTRST(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PMT_CONTROL_STATUS_RWKFILTRST_SHIFT)) & ENET_MAC_PMT_CONTROL_STATUS_RWKFILTRST_MASK)
/*! @} */

/*! @name MAC_RWK_PACKET_FILTER - Remote Wakeup Filter */
/*! @{ */

#define ENET_MAC_RWK_PACKET_FILTER_WKUPFRMFTR_MASK (0xFFFFFFFFU)
#define ENET_MAC_RWK_PACKET_FILTER_WKUPFRMFTR_SHIFT (0U)
/*! WKUPFRMFTR - RWK Packet Filter */
#define ENET_MAC_RWK_PACKET_FILTER_WKUPFRMFTR(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_RWK_PACKET_FILTER_WKUPFRMFTR_SHIFT)) & ENET_MAC_RWK_PACKET_FILTER_WKUPFRMFTR_MASK)
/*! @} */

/*! @name MAC_LPI_CONTROL_STATUS - LPI Control and Status */
/*! @{ */

#define ENET_MAC_LPI_CONTROL_STATUS_TLPIEN_MASK  (0x1U)
#define ENET_MAC_LPI_CONTROL_STATUS_TLPIEN_SHIFT (0U)
/*! TLPIEN - Transmit LPI Entry
 *  0b1..Transmit LPI entry detected
 *  0b0..Transmit LPI entry not detected
 */
#define ENET_MAC_LPI_CONTROL_STATUS_TLPIEN(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_TLPIEN_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_TLPIEN_MASK)

#define ENET_MAC_LPI_CONTROL_STATUS_TLPIEX_MASK  (0x2U)
#define ENET_MAC_LPI_CONTROL_STATUS_TLPIEX_SHIFT (1U)
/*! TLPIEX - Transmit LPI Exit
 *  0b1..Transmit LPI exit detected
 *  0b0..Transmit LPI exit not detected
 */
#define ENET_MAC_LPI_CONTROL_STATUS_TLPIEX(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_TLPIEX_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_TLPIEX_MASK)

#define ENET_MAC_LPI_CONTROL_STATUS_RLPIEN_MASK  (0x4U)
#define ENET_MAC_LPI_CONTROL_STATUS_RLPIEN_SHIFT (2U)
/*! RLPIEN - Receive LPI Entry
 *  0b1..Receive LPI entry detected
 *  0b0..Receive LPI entry not detected
 */
#define ENET_MAC_LPI_CONTROL_STATUS_RLPIEN(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_RLPIEN_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_RLPIEN_MASK)

#define ENET_MAC_LPI_CONTROL_STATUS_RLPIEX_MASK  (0x8U)
#define ENET_MAC_LPI_CONTROL_STATUS_RLPIEX_SHIFT (3U)
/*! RLPIEX - Receive LPI Exit
 *  0b1..Receive LPI exit detected
 *  0b0..Receive LPI exit not detected
 */
#define ENET_MAC_LPI_CONTROL_STATUS_RLPIEX(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_RLPIEX_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_RLPIEX_MASK)

#define ENET_MAC_LPI_CONTROL_STATUS_TLPIST_MASK  (0x100U)
#define ENET_MAC_LPI_CONTROL_STATUS_TLPIST_SHIFT (8U)
/*! TLPIST - Transmit LPI State
 *  0b1..Transmit LPI state detected
 *  0b0..Transmit LPI state not detected
 */
#define ENET_MAC_LPI_CONTROL_STATUS_TLPIST(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_TLPIST_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_TLPIST_MASK)

#define ENET_MAC_LPI_CONTROL_STATUS_RLPIST_MASK  (0x200U)
#define ENET_MAC_LPI_CONTROL_STATUS_RLPIST_SHIFT (9U)
/*! RLPIST - Receive LPI State
 *  0b1..Receive LPI state detected
 *  0b0..Receive LPI state not detected
 */
#define ENET_MAC_LPI_CONTROL_STATUS_RLPIST(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_RLPIST_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_RLPIST_MASK)

#define ENET_MAC_LPI_CONTROL_STATUS_LPIEN_MASK   (0x10000U)
#define ENET_MAC_LPI_CONTROL_STATUS_LPIEN_SHIFT  (16U)
/*! LPIEN - LPI Enable
 *  0b0..LPI state is disabled
 *  0b1..LPI state is enabled
 */
#define ENET_MAC_LPI_CONTROL_STATUS_LPIEN(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_LPIEN_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_LPIEN_MASK)

#define ENET_MAC_LPI_CONTROL_STATUS_PLS_MASK     (0x20000U)
#define ENET_MAC_LPI_CONTROL_STATUS_PLS_SHIFT    (17U)
/*! PLS - PHY Link Status
 *  0b0..link is down
 *  0b1..link is okay (UP)
 */
#define ENET_MAC_LPI_CONTROL_STATUS_PLS(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_PLS_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_PLS_MASK)

#define ENET_MAC_LPI_CONTROL_STATUS_LPITXA_MASK  (0x80000U)
#define ENET_MAC_LPI_CONTROL_STATUS_LPITXA_SHIFT (19U)
/*! LPITXA - LPI Tx Automate
 *  0b0..LPI Tx Automate is disabled
 *  0b1..LPI Tx Automate is enabled
 */
#define ENET_MAC_LPI_CONTROL_STATUS_LPITXA(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_LPITXA_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_LPITXA_MASK)

#define ENET_MAC_LPI_CONTROL_STATUS_LPIATE_MASK  (0x100000U)
#define ENET_MAC_LPI_CONTROL_STATUS_LPIATE_SHIFT (20U)
/*! LPIATE - LPI Timer Enable
 *  0b0..LPI Timer is disabled
 *  0b1..LPI Timer is enabled
 */
#define ENET_MAC_LPI_CONTROL_STATUS_LPIATE(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_LPIATE_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_LPIATE_MASK)

#define ENET_MAC_LPI_CONTROL_STATUS_LPITCSE_MASK (0x200000U)
#define ENET_MAC_LPI_CONTROL_STATUS_LPITCSE_SHIFT (21U)
/*! LPITCSE - LPI Tx Clock Stop Enable
 *  0b0..LPI Tx Clock Stop is disabled
 *  0b1..LPI Tx Clock Stop is enabled
 */
#define ENET_MAC_LPI_CONTROL_STATUS_LPITCSE(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_CONTROL_STATUS_LPITCSE_SHIFT)) & ENET_MAC_LPI_CONTROL_STATUS_LPITCSE_MASK)
/*! @} */

/*! @name MAC_LPI_TIMERS_CONTROL - LPI Timers Control */
/*! @{ */

#define ENET_MAC_LPI_TIMERS_CONTROL_TWT_MASK     (0xFFFFU)
#define ENET_MAC_LPI_TIMERS_CONTROL_TWT_SHIFT    (0U)
/*! TWT - LPI TW Timer */
#define ENET_MAC_LPI_TIMERS_CONTROL_TWT(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_TIMERS_CONTROL_TWT_SHIFT)) & ENET_MAC_LPI_TIMERS_CONTROL_TWT_MASK)

#define ENET_MAC_LPI_TIMERS_CONTROL_LST_MASK     (0x3FF0000U)
#define ENET_MAC_LPI_TIMERS_CONTROL_LST_SHIFT    (16U)
/*! LST - LPI LS Timer */
#define ENET_MAC_LPI_TIMERS_CONTROL_LST(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_TIMERS_CONTROL_LST_SHIFT)) & ENET_MAC_LPI_TIMERS_CONTROL_LST_MASK)
/*! @} */

/*! @name MAC_LPI_ENTRY_TIMER - Tx LPI Entry Timer Control */
/*! @{ */

#define ENET_MAC_LPI_ENTRY_TIMER_LPIET_MASK      (0xFFFF8U)
#define ENET_MAC_LPI_ENTRY_TIMER_LPIET_SHIFT     (3U)
/*! LPIET - LPI Entry Timer */
#define ENET_MAC_LPI_ENTRY_TIMER_LPIET(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_LPI_ENTRY_TIMER_LPIET_SHIFT)) & ENET_MAC_LPI_ENTRY_TIMER_LPIET_MASK)
/*! @} */

/*! @name MAC_ONEUS_TIC_COUNTER - One-microsecond Reference Timer */
/*! @{ */

#define ENET_MAC_ONEUS_TIC_COUNTER_TIC_1US_CNTR_MASK (0xFFFU)
#define ENET_MAC_ONEUS_TIC_COUNTER_TIC_1US_CNTR_SHIFT (0U)
/*! TIC_1US_CNTR - 1US TIC Counter */
#define ENET_MAC_ONEUS_TIC_COUNTER_TIC_1US_CNTR(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_ONEUS_TIC_COUNTER_TIC_1US_CNTR_SHIFT)) & ENET_MAC_ONEUS_TIC_COUNTER_TIC_1US_CNTR_MASK)
/*! @} */

/*! @name MAC_VERSION - MAC Version */
/*! @{ */

#define ENET_MAC_VERSION_SNPSVER_MASK            (0xFFU)
#define ENET_MAC_VERSION_SNPSVER_SHIFT           (0U)
/*! SNPSVER - Synopsys-defined Version */
#define ENET_MAC_VERSION_SNPSVER(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VERSION_SNPSVER_SHIFT)) & ENET_MAC_VERSION_SNPSVER_MASK)

#define ENET_MAC_VERSION_USERVER_MASK            (0xFF00U)
#define ENET_MAC_VERSION_USERVER_SHIFT           (8U)
/*! USERVER - User-defined Version */
#define ENET_MAC_VERSION_USERVER(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_VERSION_USERVER_SHIFT)) & ENET_MAC_VERSION_USERVER_MASK)
/*! @} */

/*! @name MAC_DEBUG - MAC Debug */
/*! @{ */

#define ENET_MAC_DEBUG_RPESTS_MASK               (0x1U)
#define ENET_MAC_DEBUG_RPESTS_SHIFT              (0U)
/*! RPESTS - MAC GMII or MII Receive Protocol Engine Status
 *  0b1..MAC GMII or MII Receive Protocol Engine Status detected
 *  0b0..MAC GMII or MII Receive Protocol Engine Status not detected
 */
#define ENET_MAC_DEBUG_RPESTS(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_DEBUG_RPESTS_SHIFT)) & ENET_MAC_DEBUG_RPESTS_MASK)

#define ENET_MAC_DEBUG_RFCFCSTS_MASK             (0x6U)
#define ENET_MAC_DEBUG_RFCFCSTS_SHIFT            (1U)
/*! RFCFCSTS - MAC Receive Packet Controller FIFO Status */
#define ENET_MAC_DEBUG_RFCFCSTS(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_DEBUG_RFCFCSTS_SHIFT)) & ENET_MAC_DEBUG_RFCFCSTS_MASK)

#define ENET_MAC_DEBUG_TPESTS_MASK               (0x10000U)
#define ENET_MAC_DEBUG_TPESTS_SHIFT              (16U)
/*! TPESTS - MAC GMII or MII Transmit Protocol Engine Status
 *  0b1..MAC GMII or MII Transmit Protocol Engine Status detected
 *  0b0..MAC GMII or MII Transmit Protocol Engine Status not detected
 */
#define ENET_MAC_DEBUG_TPESTS(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_DEBUG_TPESTS_SHIFT)) & ENET_MAC_DEBUG_TPESTS_MASK)

#define ENET_MAC_DEBUG_TFCSTS_MASK               (0x60000U)
#define ENET_MAC_DEBUG_TFCSTS_SHIFT              (17U)
/*! TFCSTS - MAC Transmit Packet Controller Status
 *  0b10..Generating and transmitting a Pause control packet (in full-duplex mode)
 *  0b00..Idle state
 *  0b11..Transferring input packet for transmission
 *  0b01..Waiting for one of the following: Status of the previous packet OR IPG or back off period to be over
 */
#define ENET_MAC_DEBUG_TFCSTS(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_DEBUG_TFCSTS_SHIFT)) & ENET_MAC_DEBUG_TFCSTS_MASK)
/*! @} */

/*! @name MAC_HW_FEAT - Hardware Features 0..Hardware Features 3 */
/*! @{ */

#define ENET_MAC_HW_FEAT_MIISEL_MASK             (0x1U)
#define ENET_MAC_HW_FEAT_MIISEL_SHIFT            (0U)
/*! MIISEL - 10 or 100 Mbps Support
 *  0b1..10 or 100 Mbps support
 *  0b0..No 10 or 100 Mbps support
 */
#define ENET_MAC_HW_FEAT_MIISEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_MIISEL_SHIFT)) & ENET_MAC_HW_FEAT_MIISEL_MASK)

#define ENET_MAC_HW_FEAT_NRVF_MASK               (0x7U)
#define ENET_MAC_HW_FEAT_NRVF_SHIFT              (0U)
/*! NRVF - Number of Extended VLAN Tag Filters Enabled
 *  0b011..16 Extended Rx VLAN Filters
 *  0b100..24 Extended Rx VLAN Filters
 *  0b101..32 Extended Rx VLAN Filters
 *  0b001..4 Extended Rx VLAN Filters
 *  0b010..8 Extended Rx VLAN Filters
 *  0b000..No Extended Rx VLAN Filters
 *  0b110..Reserved
 */
#define ENET_MAC_HW_FEAT_NRVF(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_NRVF_SHIFT)) & ENET_MAC_HW_FEAT_NRVF_MASK)

#define ENET_MAC_HW_FEAT_RXFIFOSIZE_MASK         (0x1FU)
#define ENET_MAC_HW_FEAT_RXFIFOSIZE_SHIFT        (0U)
/*! RXFIFOSIZE - MTL Receive FIFO Size
 *  0b00011..1024 bytes
 *  0b00000..128 bytes
 *  0b01010..128 KB
 *  0b00111..16384 bytes
 *  0b00100..2048 bytes
 *  0b00001..256 bytes
 *  0b01011..256 KB
 *  0b01000..32 KB
 *  0b00101..4096 bytes
 *  0b00010..512 bytes
 *  0b01001..64 KB
 *  0b00110..8192 bytes
 *  0b01100..Reserved
 */
#define ENET_MAC_HW_FEAT_RXFIFOSIZE(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RXFIFOSIZE_SHIFT)) & ENET_MAC_HW_FEAT_RXFIFOSIZE_MASK)

#define ENET_MAC_HW_FEAT_RXQCNT_MASK             (0xFU)
#define ENET_MAC_HW_FEAT_RXQCNT_SHIFT            (0U)
/*! RXQCNT - Number of MTL Receive Queues
 *  0b0000..1 MTL Rx Queue
 *  0b0001..2 MTL Rx Queues
 *  0b0010..3 MTL Rx Queues
 *  0b0011..4 MTL Rx Queues
 *  0b0100..5 MTL Rx Queues
 *  0b0101..6 MTL Rx Queues
 *  0b0110..7 MTL Rx Queues
 *  0b0111..8 MTL Rx Queues
 */
#define ENET_MAC_HW_FEAT_RXQCNT(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RXQCNT_SHIFT)) & ENET_MAC_HW_FEAT_RXQCNT_MASK)

#define ENET_MAC_HW_FEAT_GMIISEL_MASK            (0x2U)
#define ENET_MAC_HW_FEAT_GMIISEL_SHIFT           (1U)
/*! GMIISEL - 1000 Mbps Support
 *  0b1..1000 Mbps support
 *  0b0..No 1000 Mbps support
 */
#define ENET_MAC_HW_FEAT_GMIISEL(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_GMIISEL_SHIFT)) & ENET_MAC_HW_FEAT_GMIISEL_MASK)

#define ENET_MAC_HW_FEAT_HDSEL_MASK              (0x4U)
#define ENET_MAC_HW_FEAT_HDSEL_SHIFT             (2U)
/*! HDSEL - Half-duplex Support
 *  0b1..Half-duplex support
 *  0b0..No Half-duplex support
 */
#define ENET_MAC_HW_FEAT_HDSEL(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_HDSEL_SHIFT)) & ENET_MAC_HW_FEAT_HDSEL_MASK)

#define ENET_MAC_HW_FEAT_PCSSEL_MASK             (0x8U)
#define ENET_MAC_HW_FEAT_PCSSEL_SHIFT            (3U)
/*! PCSSEL - PCS Registers (TBI, SGMII, or RTBI PHY interface)
 *  0b1..PCS Registers (TBI, SGMII, or RTBI PHY interface)
 *  0b0..No PCS Registers (TBI, SGMII, or RTBI PHY interface)
 */
#define ENET_MAC_HW_FEAT_PCSSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_PCSSEL_SHIFT)) & ENET_MAC_HW_FEAT_PCSSEL_MASK)

#define ENET_MAC_HW_FEAT_CBTISEL_MASK            (0x10U)
#define ENET_MAC_HW_FEAT_CBTISEL_SHIFT           (4U)
/*! CBTISEL - Queue/Channel based VLAN tag insertion on Tx Enable
 *  0b1..Enable Queue/Channel based VLAN tag insertion on Tx feature is selected
 *  0b0..Enable Queue/Channel based VLAN tag insertion on Tx feature is not selected
 */
#define ENET_MAC_HW_FEAT_CBTISEL(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_CBTISEL_SHIFT)) & ENET_MAC_HW_FEAT_CBTISEL_MASK)

#define ENET_MAC_HW_FEAT_VLHASH_MASK             (0x10U)
#define ENET_MAC_HW_FEAT_VLHASH_SHIFT            (4U)
/*! VLHASH - VLAN Hash Filter Selected
 *  0b1..VLAN Hash Filter selected
 *  0b0..VLAN Hash Filter not selected
 */
#define ENET_MAC_HW_FEAT_VLHASH(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_VLHASH_SHIFT)) & ENET_MAC_HW_FEAT_VLHASH_MASK)

#define ENET_MAC_HW_FEAT_DVLAN_MASK              (0x20U)
#define ENET_MAC_HW_FEAT_DVLAN_SHIFT             (5U)
/*! DVLAN - Double VLAN Tag Processing Selected
 *  0b1..Double VLAN option is selected
 *  0b0..Double VLAN option is not selected
 */
#define ENET_MAC_HW_FEAT_DVLAN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_DVLAN_SHIFT)) & ENET_MAC_HW_FEAT_DVLAN_MASK)

#define ENET_MAC_HW_FEAT_SMASEL_MASK             (0x20U)
#define ENET_MAC_HW_FEAT_SMASEL_SHIFT            (5U)
/*! SMASEL - SMA (MDIO) Interface
 *  0b1..SMA (MDIO) Interface selected
 *  0b0..SMA (MDIO) Interface not selected
 */
#define ENET_MAC_HW_FEAT_SMASEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_SMASEL_SHIFT)) & ENET_MAC_HW_FEAT_SMASEL_MASK)

#define ENET_MAC_HW_FEAT_SPRAM_MASK              (0x20U)
#define ENET_MAC_HW_FEAT_SPRAM_SHIFT             (5U)
/*! SPRAM - Single Port RAM Enable
 *  0b1..Single Port RAM feature is selected
 *  0b0..Single Port RAM feature is not selected
 */
#define ENET_MAC_HW_FEAT_SPRAM(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_SPRAM_SHIFT)) & ENET_MAC_HW_FEAT_SPRAM_MASK)

#define ENET_MAC_HW_FEAT_RWKSEL_MASK             (0x40U)
#define ENET_MAC_HW_FEAT_RWKSEL_SHIFT            (6U)
/*! RWKSEL - PMT Remote Wake-up Packet Enable
 *  0b1..PMT Remote Wake-up Packet Enable option is selected
 *  0b0..PMT Remote Wake-up Packet Enable option is not selected
 */
#define ENET_MAC_HW_FEAT_RWKSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RWKSEL_SHIFT)) & ENET_MAC_HW_FEAT_RWKSEL_MASK)

#define ENET_MAC_HW_FEAT_TXFIFOSIZE_MASK         (0x7C0U)
#define ENET_MAC_HW_FEAT_TXFIFOSIZE_SHIFT        (6U)
/*! TXFIFOSIZE - MTL Transmit FIFO Size
 *  0b00011..1024 bytes
 *  0b00000..128 bytes
 *  0b01010..128 KB
 *  0b00111..16384 bytes
 *  0b00100..2048 bytes
 *  0b00001..256 bytes
 *  0b01000..32 KB
 *  0b00101..4096 bytes
 *  0b00010..512 bytes
 *  0b01001..64 KB
 *  0b00110..8192 bytes
 *  0b01011..Reserved
 */
#define ENET_MAC_HW_FEAT_TXFIFOSIZE(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TXFIFOSIZE_SHIFT)) & ENET_MAC_HW_FEAT_TXFIFOSIZE_MASK)

#define ENET_MAC_HW_FEAT_TXQCNT_MASK             (0x3C0U)
#define ENET_MAC_HW_FEAT_TXQCNT_SHIFT            (6U)
/*! TXQCNT - Number of MTL Transmit Queues
 *  0b0000..1 MTL Tx Queue
 *  0b0001..2 MTL Tx Queues
 *  0b0010..3 MTL Tx Queues
 *  0b0011..4 MTL Tx Queues
 *  0b0100..5 MTL Tx Queues
 *  0b0101..6 MTL Tx Queues
 *  0b0110..7 MTL Tx Queues
 *  0b0111..8 MTL Tx Queues
 */
#define ENET_MAC_HW_FEAT_TXQCNT(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TXQCNT_SHIFT)) & ENET_MAC_HW_FEAT_TXQCNT_MASK)

#define ENET_MAC_HW_FEAT_MGKSEL_MASK             (0x80U)
#define ENET_MAC_HW_FEAT_MGKSEL_SHIFT            (7U)
/*! MGKSEL - PMT Magic Packet Enable
 *  0b1..PMT Magic Packet Enable option is selected
 *  0b0..PMT Magic Packet Enable option is not selected
 */
#define ENET_MAC_HW_FEAT_MGKSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_MGKSEL_SHIFT)) & ENET_MAC_HW_FEAT_MGKSEL_MASK)

#define ENET_MAC_HW_FEAT_MMCSEL_MASK             (0x100U)
#define ENET_MAC_HW_FEAT_MMCSEL_SHIFT            (8U)
/*! MMCSEL - RMON Module Enable
 *  0b1..RMON Module Enable option is selected
 *  0b0..RMON Module Enable option is not selected
 */
#define ENET_MAC_HW_FEAT_MMCSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_MMCSEL_SHIFT)) & ENET_MAC_HW_FEAT_MMCSEL_MASK)

#define ENET_MAC_HW_FEAT_ARPOFFSEL_MASK          (0x200U)
#define ENET_MAC_HW_FEAT_ARPOFFSEL_SHIFT         (9U)
/*! ARPOFFSEL - ARP Offload Enabled
 *  0b1..ARP Offload Enable option is selected
 *  0b0..ARP Offload Enable option is not selected
 */
#define ENET_MAC_HW_FEAT_ARPOFFSEL(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ARPOFFSEL_SHIFT)) & ENET_MAC_HW_FEAT_ARPOFFSEL_MASK)

#define ENET_MAC_HW_FEAT_PDUPSEL_MASK            (0x200U)
#define ENET_MAC_HW_FEAT_PDUPSEL_SHIFT           (9U)
/*! PDUPSEL - Broadcast/Multicast Packet Duplication
 *  0b1..Broadcast/Multicast Packet Duplication feature is selected
 *  0b0..Broadcast/Multicast Packet Duplication feature is not selected
 */
#define ENET_MAC_HW_FEAT_PDUPSEL(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_PDUPSEL_SHIFT)) & ENET_MAC_HW_FEAT_PDUPSEL_MASK)

#define ENET_MAC_HW_FEAT_FRPSEL_MASK             (0x400U)
#define ENET_MAC_HW_FEAT_FRPSEL_SHIFT            (10U)
/*! FRPSEL - Flexible Receive Parser Selected
 *  0b1..Flexible Receive Parser feature is selected
 *  0b0..Flexible Receive Parser feature is not selected
 */
#define ENET_MAC_HW_FEAT_FRPSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_FRPSEL_SHIFT)) & ENET_MAC_HW_FEAT_FRPSEL_MASK)

#define ENET_MAC_HW_FEAT_FRPBS_MASK              (0x1800U)
#define ENET_MAC_HW_FEAT_FRPBS_SHIFT             (11U)
/*! FRPBS - Flexible Receive Parser Buffer size
 *  0b01..128 Bytes
 *  0b10..256 Bytes
 *  0b00..64 Bytes
 *  0b11..Reserved
 */
#define ENET_MAC_HW_FEAT_FRPBS(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_FRPBS_SHIFT)) & ENET_MAC_HW_FEAT_FRPBS_MASK)

#define ENET_MAC_HW_FEAT_OSTEN_MASK              (0x800U)
#define ENET_MAC_HW_FEAT_OSTEN_SHIFT             (11U)
/*! OSTEN - One-Step Timestamping Enable
 *  0b1..One-Step Timestamping feature is selected
 *  0b0..One-Step Timestamping feature is not selected
 */
#define ENET_MAC_HW_FEAT_OSTEN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_OSTEN_SHIFT)) & ENET_MAC_HW_FEAT_OSTEN_MASK)

#define ENET_MAC_HW_FEAT_PTOEN_MASK              (0x1000U)
#define ENET_MAC_HW_FEAT_PTOEN_SHIFT             (12U)
/*! PTOEN - PTP Offload Enable
 *  0b1..PTP Offload feature is selected
 *  0b0..PTP Offload feature is not selected
 */
#define ENET_MAC_HW_FEAT_PTOEN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_PTOEN_SHIFT)) & ENET_MAC_HW_FEAT_PTOEN_MASK)

#define ENET_MAC_HW_FEAT_RXCHCNT_MASK            (0xF000U)
#define ENET_MAC_HW_FEAT_RXCHCNT_SHIFT           (12U)
/*! RXCHCNT - Number of DMA Receive Channels
 *  0b0000..1 MTL Rx Channel
 *  0b0001..2 MTL Rx Channels
 *  0b0010..3 MTL Rx Channels
 *  0b0011..4 MTL Rx Channels
 *  0b0100..5 MTL Rx Channels
 *  0b0101..6 MTL Rx Channels
 *  0b0110..7 MTL Rx Channels
 *  0b0111..8 MTL Rx Channels
 */
#define ENET_MAC_HW_FEAT_RXCHCNT(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RXCHCNT_SHIFT)) & ENET_MAC_HW_FEAT_RXCHCNT_MASK)

#define ENET_MAC_HW_FEAT_TSSEL_MASK              (0x1000U)
#define ENET_MAC_HW_FEAT_TSSEL_SHIFT             (12U)
/*! TSSEL - IEEE 1588-2008 Timestamp Enabled
 *  0b1..IEEE 1588-2008 Timestamp Enable option is selected
 *  0b0..IEEE 1588-2008 Timestamp Enable option is not selected
 */
#define ENET_MAC_HW_FEAT_TSSEL(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TSSEL_SHIFT)) & ENET_MAC_HW_FEAT_TSSEL_MASK)

#define ENET_MAC_HW_FEAT_ADVTHWORD_MASK          (0x2000U)
#define ENET_MAC_HW_FEAT_ADVTHWORD_SHIFT         (13U)
/*! ADVTHWORD - IEEE 1588 High Word Register Enable
 *  0b1..IEEE 1588 High Word Register option is selected
 *  0b0..IEEE 1588 High Word Register option is not selected
 */
#define ENET_MAC_HW_FEAT_ADVTHWORD(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ADVTHWORD_SHIFT)) & ENET_MAC_HW_FEAT_ADVTHWORD_MASK)

#define ENET_MAC_HW_FEAT_EEESEL_MASK             (0x2000U)
#define ENET_MAC_HW_FEAT_EEESEL_SHIFT            (13U)
/*! EEESEL - Energy Efficient Ethernet Enabled
 *  0b1..Energy Efficient Ethernet Enable option is selected
 *  0b0..Energy Efficient Ethernet Enable option is not selected
 */
#define ENET_MAC_HW_FEAT_EEESEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_EEESEL_SHIFT)) & ENET_MAC_HW_FEAT_EEESEL_MASK)

#define ENET_MAC_HW_FEAT_FRPES_MASK              (0x6000U)
#define ENET_MAC_HW_FEAT_FRPES_SHIFT             (13U)
/*! FRPES - Flexible Receive Parser Table Entries size
 *  0b01..128 Entries
 *  0b10..256 Entries
 *  0b00..64 Entries
 *  0b11..Reserved
 */
#define ENET_MAC_HW_FEAT_FRPES(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_FRPES_SHIFT)) & ENET_MAC_HW_FEAT_FRPES_MASK)

#define ENET_MAC_HW_FEAT_ADDR64_MASK             (0xC000U)
#define ENET_MAC_HW_FEAT_ADDR64_SHIFT            (14U)
/*! ADDR64 - Address Width.
 *  0b00..32
 *  0b01..40
 *  0b10..48
 *  0b11..Reserved
 */
#define ENET_MAC_HW_FEAT_ADDR64(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ADDR64_SHIFT)) & ENET_MAC_HW_FEAT_ADDR64_MASK)

#define ENET_MAC_HW_FEAT_TXCOESEL_MASK           (0x4000U)
#define ENET_MAC_HW_FEAT_TXCOESEL_SHIFT          (14U)
/*! TXCOESEL - Transmit Checksum Offload Enabled
 *  0b1..Transmit Checksum Offload Enable option is selected
 *  0b0..Transmit Checksum Offload Enable option is not selected
 */
#define ENET_MAC_HW_FEAT_TXCOESEL(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TXCOESEL_SHIFT)) & ENET_MAC_HW_FEAT_TXCOESEL_MASK)

#define ENET_MAC_HW_FEAT_DCBEN_MASK              (0x10000U)
#define ENET_MAC_HW_FEAT_DCBEN_SHIFT             (16U)
/*! DCBEN - DCB Feature Enable
 *  0b1..DCB Feature is selected
 *  0b0..DCB Feature is not selected
 */
#define ENET_MAC_HW_FEAT_DCBEN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_DCBEN_SHIFT)) & ENET_MAC_HW_FEAT_DCBEN_MASK)

#define ENET_MAC_HW_FEAT_ESTSEL_MASK             (0x10000U)
#define ENET_MAC_HW_FEAT_ESTSEL_SHIFT            (16U)
/*! ESTSEL - Enhancements to Scheduled Traffic Enable
 *  0b1..Enable Enhancements to Scheduling Traffic feature is selected
 *  0b0..Enable Enhancements to Scheduling Traffic feature is not selected
 */
#define ENET_MAC_HW_FEAT_ESTSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ESTSEL_SHIFT)) & ENET_MAC_HW_FEAT_ESTSEL_MASK)

#define ENET_MAC_HW_FEAT_RDCSZ_MASK              (0x30000U)
#define ENET_MAC_HW_FEAT_RDCSZ_SHIFT             (16U)
/*! RDCSZ - Rx DMA Descriptor Cache Size in terms of 16 bytes descriptors: */
#define ENET_MAC_HW_FEAT_RDCSZ(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RDCSZ_SHIFT)) & ENET_MAC_HW_FEAT_RDCSZ_MASK)

#define ENET_MAC_HW_FEAT_RXCOESEL_MASK           (0x10000U)
#define ENET_MAC_HW_FEAT_RXCOESEL_SHIFT          (16U)
/*! RXCOESEL - Receive Checksum Offload Enabled
 *  0b1..Receive Checksum Offload Enable option is selected
 *  0b0..Receive Checksum Offload Enable option is not selected
 */
#define ENET_MAC_HW_FEAT_RXCOESEL(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RXCOESEL_SHIFT)) & ENET_MAC_HW_FEAT_RXCOESEL_MASK)

#define ENET_MAC_HW_FEAT_ESTDEP_MASK             (0xE0000U)
#define ENET_MAC_HW_FEAT_ESTDEP_SHIFT            (17U)
/*! ESTDEP - Depth of the Gate Control List
 *  0b101..1024
 *  0b010..128
 *  0b011..256
 *  0b100..512
 *  0b001..64
 *  0b000..No Depth configured
 *  0b110..Reserved
 */
#define ENET_MAC_HW_FEAT_ESTDEP(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ESTDEP_SHIFT)) & ENET_MAC_HW_FEAT_ESTDEP_MASK)

#define ENET_MAC_HW_FEAT_SPHEN_MASK              (0x20000U)
#define ENET_MAC_HW_FEAT_SPHEN_SHIFT             (17U)
/*! SPHEN - Split Header Feature Enable
 *  0b1..Split Header Feature is selected
 *  0b0..Split Header Feature is not selected
 */
#define ENET_MAC_HW_FEAT_SPHEN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_SPHEN_SHIFT)) & ENET_MAC_HW_FEAT_SPHEN_MASK)

#define ENET_MAC_HW_FEAT_ADDMACADRSEL_MASK       (0x7C0000U)
#define ENET_MAC_HW_FEAT_ADDMACADRSEL_SHIFT      (18U)
/*! ADDMACADRSEL - MAC Addresses 1-31 Selected */
#define ENET_MAC_HW_FEAT_ADDMACADRSEL(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ADDMACADRSEL_SHIFT)) & ENET_MAC_HW_FEAT_ADDMACADRSEL_MASK)

#define ENET_MAC_HW_FEAT_TSOEN_MASK              (0x40000U)
#define ENET_MAC_HW_FEAT_TSOEN_SHIFT             (18U)
/*! TSOEN - TCP Segmentation Offload Enable
 *  0b1..TCP Segmentation Offload Feature is selected
 *  0b0..TCP Segmentation Offload Feature is not selected
 */
#define ENET_MAC_HW_FEAT_TSOEN(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TSOEN_SHIFT)) & ENET_MAC_HW_FEAT_TSOEN_MASK)

#define ENET_MAC_HW_FEAT_TXCHCNT_MASK            (0x3C0000U)
#define ENET_MAC_HW_FEAT_TXCHCNT_SHIFT           (18U)
/*! TXCHCNT - Number of DMA Transmit Channels
 *  0b0000..1 MTL Tx Channel
 *  0b0001..2 MTL Tx Channels
 *  0b0010..3 MTL Tx Channels
 *  0b0011..4 MTL Tx Channels
 *  0b0100..5 MTL Tx Channels
 *  0b0101..6 MTL Tx Channels
 *  0b0110..7 MTL Tx Channels
 *  0b0111..8 MTL Tx Channels
 */
#define ENET_MAC_HW_FEAT_TXCHCNT(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TXCHCNT_SHIFT)) & ENET_MAC_HW_FEAT_TXCHCNT_MASK)

#define ENET_MAC_HW_FEAT_DBGMEMA_MASK            (0x80000U)
#define ENET_MAC_HW_FEAT_DBGMEMA_SHIFT           (19U)
/*! DBGMEMA - DMA Debug Registers Enable
 *  0b1..DMA Debug Registers option is selected
 *  0b0..DMA Debug Registers option is not selected
 */
#define ENET_MAC_HW_FEAT_DBGMEMA(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_DBGMEMA_SHIFT)) & ENET_MAC_HW_FEAT_DBGMEMA_MASK)

#define ENET_MAC_HW_FEAT_AVSEL_MASK              (0x100000U)
#define ENET_MAC_HW_FEAT_AVSEL_SHIFT             (20U)
/*! AVSEL - AV Feature Enable
 *  0b1..AV Feature is selected
 *  0b0..AV Feature is not selected
 */
#define ENET_MAC_HW_FEAT_AVSEL(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_AVSEL_SHIFT)) & ENET_MAC_HW_FEAT_AVSEL_MASK)

#define ENET_MAC_HW_FEAT_ESTWID_MASK             (0x300000U)
#define ENET_MAC_HW_FEAT_ESTWID_SHIFT            (20U)
/*! ESTWID - Width of the Time Interval field in the Gate Control List
 *  0b00..Width not configured
 *  0b01..16
 *  0b10..20
 *  0b11..24
 */
#define ENET_MAC_HW_FEAT_ESTWID(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ESTWID_SHIFT)) & ENET_MAC_HW_FEAT_ESTWID_MASK)

#define ENET_MAC_HW_FEAT_RAVSEL_MASK             (0x200000U)
#define ENET_MAC_HW_FEAT_RAVSEL_SHIFT            (21U)
/*! RAVSEL - Rx Side Only AV Feature Enable
 *  0b1..Rx Side Only AV Feature is selected
 *  0b0..Rx Side Only AV Feature is not selected
 */
#define ENET_MAC_HW_FEAT_RAVSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_RAVSEL_SHIFT)) & ENET_MAC_HW_FEAT_RAVSEL_MASK)

#define ENET_MAC_HW_FEAT_TDCSZ_MASK              (0xC00000U)
#define ENET_MAC_HW_FEAT_TDCSZ_SHIFT             (22U)
/*! TDCSZ - Tx DMA Descriptor Cache Size in terms of 16 bytes descriptors: */
#define ENET_MAC_HW_FEAT_TDCSZ(x)                (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TDCSZ_SHIFT)) & ENET_MAC_HW_FEAT_TDCSZ_MASK)

#define ENET_MAC_HW_FEAT_MACADR32SEL_MASK        (0x800000U)
#define ENET_MAC_HW_FEAT_MACADR32SEL_SHIFT       (23U)
/*! MACADR32SEL - MAC Addresses 32-63 Selected
 *  0b1..MAC Addresses 32-63 Select option is selected
 *  0b0..MAC Addresses 32-63 Select option is not selected
 */
#define ENET_MAC_HW_FEAT_MACADR32SEL(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_MACADR32SEL_SHIFT)) & ENET_MAC_HW_FEAT_MACADR32SEL_MASK)

#define ENET_MAC_HW_FEAT_POUOST_MASK             (0x800000U)
#define ENET_MAC_HW_FEAT_POUOST_SHIFT            (23U)
/*! POUOST - One Step for PTP over UDP/IP Feature Enable
 *  0b1..One Step for PTP over UDP/IP Feature is selected
 *  0b0..One Step for PTP over UDP/IP Feature is not selected
 */
#define ENET_MAC_HW_FEAT_POUOST(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_POUOST_SHIFT)) & ENET_MAC_HW_FEAT_POUOST_MASK)

#define ENET_MAC_HW_FEAT_HASHTBLSZ_MASK          (0x3000000U)
#define ENET_MAC_HW_FEAT_HASHTBLSZ_SHIFT         (24U)
/*! HASHTBLSZ - Hash Table Size
 *  0b10..128
 *  0b11..256
 *  0b01..64
 *  0b00..No hash table
 */
#define ENET_MAC_HW_FEAT_HASHTBLSZ(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_HASHTBLSZ_SHIFT)) & ENET_MAC_HW_FEAT_HASHTBLSZ_MASK)

#define ENET_MAC_HW_FEAT_MACADR64SEL_MASK        (0x1000000U)
#define ENET_MAC_HW_FEAT_MACADR64SEL_SHIFT       (24U)
/*! MACADR64SEL - MAC Addresses 64-127 Selected
 *  0b1..MAC Addresses 64-127 Select option is selected
 *  0b0..MAC Addresses 64-127 Select option is not selected
 */
#define ENET_MAC_HW_FEAT_MACADR64SEL(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_MACADR64SEL_SHIFT)) & ENET_MAC_HW_FEAT_MACADR64SEL_MASK)

#define ENET_MAC_HW_FEAT_PPSOUTNUM_MASK          (0x7000000U)
#define ENET_MAC_HW_FEAT_PPSOUTNUM_SHIFT         (24U)
/*! PPSOUTNUM - Number of PPS Outputs
 *  0b001..1 PPS output
 *  0b010..2 PPS output
 *  0b011..3 PPS output
 *  0b100..4 PPS output
 *  0b000..No PPS output
 *  0b101..Reserved
 */
#define ENET_MAC_HW_FEAT_PPSOUTNUM(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_PPSOUTNUM_SHIFT)) & ENET_MAC_HW_FEAT_PPSOUTNUM_MASK)

#define ENET_MAC_HW_FEAT_TSSTSSEL_MASK           (0x6000000U)
#define ENET_MAC_HW_FEAT_TSSTSSEL_SHIFT          (25U)
/*! TSSTSSEL - Timestamp System Time Source
 *  0b10..Both
 *  0b01..External
 *  0b00..Internal
 *  0b11..Reserved
 */
#define ENET_MAC_HW_FEAT_TSSTSSEL(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TSSTSSEL_SHIFT)) & ENET_MAC_HW_FEAT_TSSTSSEL_MASK)

#define ENET_MAC_HW_FEAT_FPESEL_MASK             (0x4000000U)
#define ENET_MAC_HW_FEAT_FPESEL_SHIFT            (26U)
/*! FPESEL - Frame Preemption Enable
 *  0b1..Frame Preemption Enable feature is selected
 *  0b0..Frame Preemption Enable feature is not selected
 */
#define ENET_MAC_HW_FEAT_FPESEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_FPESEL_SHIFT)) & ENET_MAC_HW_FEAT_FPESEL_MASK)

#define ENET_MAC_HW_FEAT_L3L4FNUM_MASK           (0x78000000U)
#define ENET_MAC_HW_FEAT_L3L4FNUM_SHIFT          (27U)
/*! L3L4FNUM - Total number of L3 or L4 Filters
 *  0b0001..1 L3 or L4 Filter
 *  0b0010..2 L3 or L4 Filters
 *  0b0011..3 L3 or L4 Filters
 *  0b0100..4 L3 or L4 Filters
 *  0b0101..5 L3 or L4 Filters
 *  0b0110..6 L3 or L4 Filters
 *  0b0111..7 L3 or L4 Filters
 *  0b1000..8 L3 or L4 Filters
 *  0b0000..No L3 or L4 Filter
 */
#define ENET_MAC_HW_FEAT_L3L4FNUM(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_L3L4FNUM_SHIFT)) & ENET_MAC_HW_FEAT_L3L4FNUM_MASK)

#define ENET_MAC_HW_FEAT_SAVLANINS_MASK          (0x8000000U)
#define ENET_MAC_HW_FEAT_SAVLANINS_SHIFT         (27U)
/*! SAVLANINS - Source Address or VLAN Insertion Enable
 *  0b1..Source Address or VLAN Insertion Enable option is selected
 *  0b0..Source Address or VLAN Insertion Enable option is not selected
 */
#define ENET_MAC_HW_FEAT_SAVLANINS(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_SAVLANINS_SHIFT)) & ENET_MAC_HW_FEAT_SAVLANINS_MASK)

#define ENET_MAC_HW_FEAT_TBSSEL_MASK             (0x8000000U)
#define ENET_MAC_HW_FEAT_TBSSEL_SHIFT            (27U)
/*! TBSSEL - Time Based Scheduling Enable
 *  0b1..Time Based Scheduling Enable feature is selected
 *  0b0..Time Based Scheduling Enable feature is not selected
 */
#define ENET_MAC_HW_FEAT_TBSSEL(x)               (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_TBSSEL_SHIFT)) & ENET_MAC_HW_FEAT_TBSSEL_MASK)

#define ENET_MAC_HW_FEAT_ACTPHYSEL_MASK          (0x70000000U)
#define ENET_MAC_HW_FEAT_ACTPHYSEL_SHIFT         (28U)
/*! ACTPHYSEL - Active PHY Selected
 *  0b000..GMII or MII
 *  0b111..RevMII
 *  0b001..RGMII
 *  0b100..RMII
 *  0b101..RTBI
 *  0b010..SGMII
 *  0b110..SMII
 *  0b011..TBI
 */
#define ENET_MAC_HW_FEAT_ACTPHYSEL(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ACTPHYSEL_SHIFT)) & ENET_MAC_HW_FEAT_ACTPHYSEL_MASK)

#define ENET_MAC_HW_FEAT_ASP_MASK                (0x30000000U)
#define ENET_MAC_HW_FEAT_ASP_SHIFT               (28U)
/*! ASP - Automotive Safety Package
 *  0b10..All the Automotive Safety features are selected without the "Parity Port Enable for external interface" feature
 *  0b11..All the Automotive Safety features are selected with the "Parity Port Enable for external interface" feature
 *  0b01..Only "ECC protection for external memory" feature is selected
 *  0b00..No Safety features selected
 */
#define ENET_MAC_HW_FEAT_ASP(x)                  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_ASP_SHIFT)) & ENET_MAC_HW_FEAT_ASP_MASK)

#define ENET_MAC_HW_FEAT_AUXSNAPNUM_MASK         (0x70000000U)
#define ENET_MAC_HW_FEAT_AUXSNAPNUM_SHIFT        (28U)
/*! AUXSNAPNUM - Number of Auxiliary Snapshot Inputs
 *  0b001..1 auxiliary input
 *  0b010..2 auxiliary input
 *  0b011..3 auxiliary input
 *  0b100..4 auxiliary input
 *  0b000..No auxiliary input
 *  0b101..Reserved
 */
#define ENET_MAC_HW_FEAT_AUXSNAPNUM(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_HW_FEAT_AUXSNAPNUM_SHIFT)) & ENET_MAC_HW_FEAT_AUXSNAPNUM_MASK)
/*! @} */

/* The count of ENET_MAC_HW_FEAT */
#define ENET_MAC_HW_FEAT_COUNT                   (4U)

/*! @name MAC_MDIO_ADDRESS - MDIO Address */
/*! @{ */

#define ENET_MAC_MDIO_ADDRESS_GB_MASK            (0x1U)
#define ENET_MAC_MDIO_ADDRESS_GB_SHIFT           (0U)
/*! GB - GMII Busy
 *  0b0..GMII Busy is disabled
 *  0b1..GMII Busy is enabled
 */
#define ENET_MAC_MDIO_ADDRESS_GB(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_GB_SHIFT)) & ENET_MAC_MDIO_ADDRESS_GB_MASK)

#define ENET_MAC_MDIO_ADDRESS_C45E_MASK          (0x2U)
#define ENET_MAC_MDIO_ADDRESS_C45E_SHIFT         (1U)
/*! C45E - Clause 45 PHY Enable
 *  0b0..Clause 45 PHY is disabled
 *  0b1..Clause 45 PHY is enabled
 */
#define ENET_MAC_MDIO_ADDRESS_C45E(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_C45E_SHIFT)) & ENET_MAC_MDIO_ADDRESS_C45E_MASK)

#define ENET_MAC_MDIO_ADDRESS_GOC_0_MASK         (0x4U)
#define ENET_MAC_MDIO_ADDRESS_GOC_0_SHIFT        (2U)
/*! GOC_0 - GMII Operation Command 0
 *  0b0..GMII Operation Command 0 is disabled
 *  0b1..GMII Operation Command 0 is enabled
 */
#define ENET_MAC_MDIO_ADDRESS_GOC_0(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_GOC_0_SHIFT)) & ENET_MAC_MDIO_ADDRESS_GOC_0_MASK)

#define ENET_MAC_MDIO_ADDRESS_GOC_1_MASK         (0x8U)
#define ENET_MAC_MDIO_ADDRESS_GOC_1_SHIFT        (3U)
/*! GOC_1 - GMII Operation Command 1
 *  0b0..GMII Operation Command 1 is disabled
 *  0b1..GMII Operation Command 1 is enabled
 */
#define ENET_MAC_MDIO_ADDRESS_GOC_1(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_GOC_1_SHIFT)) & ENET_MAC_MDIO_ADDRESS_GOC_1_MASK)

#define ENET_MAC_MDIO_ADDRESS_SKAP_MASK          (0x10U)
#define ENET_MAC_MDIO_ADDRESS_SKAP_SHIFT         (4U)
/*! SKAP - Skip Address Packet
 *  0b0..Skip Address Packet is disabled
 *  0b1..Skip Address Packet is enabled
 */
#define ENET_MAC_MDIO_ADDRESS_SKAP(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_SKAP_SHIFT)) & ENET_MAC_MDIO_ADDRESS_SKAP_MASK)

#define ENET_MAC_MDIO_ADDRESS_CR_MASK            (0xF00U)
#define ENET_MAC_MDIO_ADDRESS_CR_SHIFT           (8U)
/*! CR - CR */
#define ENET_MAC_MDIO_ADDRESS_CR(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_CR_SHIFT)) & ENET_MAC_MDIO_ADDRESS_CR_MASK)

#define ENET_MAC_MDIO_ADDRESS_NTC_MASK           (0x7000U)
#define ENET_MAC_MDIO_ADDRESS_NTC_SHIFT          (12U)
/*! NTC - NTC */
#define ENET_MAC_MDIO_ADDRESS_NTC(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_NTC_SHIFT)) & ENET_MAC_MDIO_ADDRESS_NTC_MASK)

#define ENET_MAC_MDIO_ADDRESS_RDA_MASK           (0x1F0000U)
#define ENET_MAC_MDIO_ADDRESS_RDA_SHIFT          (16U)
/*! RDA - Register/Device Address */
#define ENET_MAC_MDIO_ADDRESS_RDA(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_RDA_SHIFT)) & ENET_MAC_MDIO_ADDRESS_RDA_MASK)

#define ENET_MAC_MDIO_ADDRESS_PA_MASK            (0x3E00000U)
#define ENET_MAC_MDIO_ADDRESS_PA_SHIFT           (21U)
/*! PA - Physical Layer Address */
#define ENET_MAC_MDIO_ADDRESS_PA(x)              (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_PA_SHIFT)) & ENET_MAC_MDIO_ADDRESS_PA_MASK)

#define ENET_MAC_MDIO_ADDRESS_BTB_MASK           (0x4000000U)
#define ENET_MAC_MDIO_ADDRESS_BTB_SHIFT          (26U)
/*! BTB - Back to Back transactions
 *  0b0..Back to Back transactions disabled
 *  0b1..Back to Back transactions enabled
 */
#define ENET_MAC_MDIO_ADDRESS_BTB(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_BTB_SHIFT)) & ENET_MAC_MDIO_ADDRESS_BTB_MASK)

#define ENET_MAC_MDIO_ADDRESS_PSE_MASK           (0x8000000U)
#define ENET_MAC_MDIO_ADDRESS_PSE_SHIFT          (27U)
/*! PSE - Preamble Suppression Enable
 *  0b0..Preamble Suppression disabled
 *  0b1..Preamble Suppression enabled
 */
#define ENET_MAC_MDIO_ADDRESS_PSE(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_ADDRESS_PSE_SHIFT)) & ENET_MAC_MDIO_ADDRESS_PSE_MASK)
/*! @} */

/*! @name MAC_MDIO_DATA - MAC MDIO Data */
/*! @{ */

#define ENET_MAC_MDIO_DATA_GD_MASK               (0xFFFFU)
#define ENET_MAC_MDIO_DATA_GD_SHIFT              (0U)
/*! GD - GMII Data */
#define ENET_MAC_MDIO_DATA_GD(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_DATA_GD_SHIFT)) & ENET_MAC_MDIO_DATA_GD_MASK)

#define ENET_MAC_MDIO_DATA_RA_MASK               (0xFFFF0000U)
#define ENET_MAC_MDIO_DATA_RA_SHIFT              (16U)
/*! RA - Register Address */
#define ENET_MAC_MDIO_DATA_RA(x)                 (((uint32_t)(((uint32_t)(x)) << ENET_MAC_MDIO_DATA_RA_SHIFT)) & ENET_MAC_MDIO_DATA_RA_MASK)
/*! @} */

/*! @name MAC_CSR_SW_CTRL - CSR Software Control */
/*! @{ */

#define ENET_MAC_CSR_SW_CTRL_RCWE_MASK           (0x1U)
#define ENET_MAC_CSR_SW_CTRL_RCWE_SHIFT          (0U)
/*! RCWE - Register Clear on Write 1 Enable
 *  0b0..Register Clear on Write 1 is disabled
 *  0b1..Register Clear on Write 1 is enabled
 */
#define ENET_MAC_CSR_SW_CTRL_RCWE(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_CSR_SW_CTRL_RCWE_SHIFT)) & ENET_MAC_CSR_SW_CTRL_RCWE_MASK)
/*! @} */

/*! @name MAC_ADDRESS0_HIGH - MAC Address0 High */
/*! @{ */

#define ENET_MAC_ADDRESS0_HIGH_ADDRHI_MASK       (0xFFFFU)
#define ENET_MAC_ADDRESS0_HIGH_ADDRHI_SHIFT      (0U)
/*! ADDRHI - MAC Address0[47:32] */
#define ENET_MAC_ADDRESS0_HIGH_ADDRHI(x)         (((uint32_t)(((uint32_t)(x)) << ENET_MAC_ADDRESS0_HIGH_ADDRHI_SHIFT)) & ENET_MAC_ADDRESS0_HIGH_ADDRHI_MASK)

#define ENET_MAC_ADDRESS0_HIGH_DCS_MASK          (0x30000U)
#define ENET_MAC_ADDRESS0_HIGH_DCS_SHIFT         (16U)
/*! DCS - DMA Channel Select */
#define ENET_MAC_ADDRESS0_HIGH_DCS(x)            (((uint32_t)(((uint32_t)(x)) << ENET_MAC_ADDRESS0_HIGH_DCS_SHIFT)) & ENET_MAC_ADDRESS0_HIGH_DCS_MASK)

#define ENET_MAC_ADDRESS0_HIGH_AE_MASK           (0x80000000U)
#define ENET_MAC_ADDRESS0_HIGH_AE_SHIFT          (31U)
/*! AE - Address Enable
 *  0b0..INVALID : This bit must be always set to 1
 *  0b1..This bit is always set to 1
 */
#define ENET_MAC_ADDRESS0_HIGH_AE(x)             (((uint32_t)(((uint32_t)(x)) << ENET_MAC_ADDRESS0_HIGH_AE_SHIFT)) & ENET_MAC_ADDRESS0_HIGH_AE_MASK)
/*! @} */

/*! @name MAC_ADDRESS0_LOW - MAC Address0 Low */
/*! @{ */

#define ENET_MAC_ADDRESS0_LOW_ADDRLO_MASK        (0xFFFFFFFFU)
#define ENET_MAC_ADDRESS0_LOW_ADDRLO_SHIFT       (0U)
/*! ADDRLO - MAC Address0[31:0] */
#define ENET_MAC_ADDRESS0_LOW_ADDRLO(x)          (((uint32_t)(((uint32_t)(x)) << ENET_MAC_ADDRESS0_LOW_ADDRLO_SHIFT)) & ENET_MAC_ADDRESS0_LOW_ADDRLO_MASK)
/*! @} */

/*! @name INDIR_ACCESS_CTRL - Indirect Access Control */
/*! @{ */

#define ENET_INDIR_ACCESS_CTRL_OB_MASK           (0x1U)
#define ENET_INDIR_ACCESS_CTRL_OB_SHIFT          (0U)
/*! OB - Operation Busy. */
#define ENET_INDIR_ACCESS_CTRL_OB(x)             (((uint32_t)(((uint32_t)(x)) << ENET_INDIR_ACCESS_CTRL_OB_SHIFT)) & ENET_INDIR_ACCESS_CTRL_OB_MASK)

#define ENET_INDIR_ACCESS_CTRL_COM_MASK          (0x2U)
#define ENET_INDIR_ACCESS_CTRL_COM_SHIFT         (1U)
/*! COM - Command type
 *  0b1..Read operation
 *  0b0..Write operation
 */
#define ENET_INDIR_ACCESS_CTRL_COM(x)            (((uint32_t)(((uint32_t)(x)) << ENET_INDIR_ACCESS_CTRL_COM_SHIFT)) & ENET_INDIR_ACCESS_CTRL_COM_MASK)

#define ENET_INDIR_ACCESS_CTRL_AUTO_MASK         (0x20U)
#define ENET_INDIR_ACCESS_CTRL_AUTO_SHIFT        (5U)
/*! AUTO - Auto increment */
#define ENET_INDIR_ACCESS_CTRL_AUTO(x)           (((uint32_t)(((uint32_t)(x)) << ENET_INDIR_ACCESS_CTRL_AUTO_SHIFT)) & ENET_INDIR_ACCESS_CTRL_AUTO_MASK)

#define ENET_INDIR_ACCESS_CTRL_AOFF_MASK         (0xFF00U)
#define ENET_INDIR_ACCESS_CTRL_AOFF_SHIFT        (8U)
/*! AOFF - Address Offset */
#define ENET_INDIR_ACCESS_CTRL_AOFF(x)           (((uint32_t)(((uint32_t)(x)) << ENET_INDIR_ACCESS_CTRL_AOFF_SHIFT)) & ENET_INDIR_ACCESS_CTRL_AOFF_MASK)

#define ENET_INDIR_ACCESS_CTRL_MSEL_MASK         (0xF0000U)
#define ENET_INDIR_ACCESS_CTRL_MSEL_SHIFT        (16U)
/*! MSEL - Mode Select */
#define ENET_INDIR_ACCESS_CTRL_MSEL(x)           (((uint32_t)(((uint32_t)(x)) << ENET_INDIR_ACCESS_CTRL_MSEL_SHIFT)) & ENET_INDIR_ACCESS_CTRL_MSEL_MASK)
/*! @} */

/*! @name INDIR_ACCESS_DATA - Indirect Access Data */
/*! @{ */

#define ENET_INDIR_ACCESS_DATA_DATA_MASK         (0xFFFFFFFFU)
#define ENET_INDIR_ACCESS_DATA_DATA_SHIFT        (0U)
/*! DATA - This field contains data to read/write for Indirect address access associated with MAC_Indir_Access_Ctrl */
#define ENET_INDIR_ACCESS_DATA_DATA(x)           (((uint32_t)(((uint32_t)(x)) << ENET_INDIR_ACCESS_DATA_DATA_SHIFT)) & ENET_INDIR_ACCESS_DATA_DATA_MASK)
/*! @} */

/*! @name MAC_TIMESTAMP_CONTROL - Timestamp Control */
/*! @{ */

#define ENET_MAC_TIMESTAMP_CONTROL_TSENA_MASK    (0x1U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSENA_SHIFT   (0U)
/*! TSENA - Enable Timestamp
 *  0b0..Timestamp is disabled
 *  0b1..Timestamp is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSENA(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSENA_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSENA_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSCFUPDT_MASK (0x2U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSCFUPDT_SHIFT (1U)
/*! TSCFUPDT - Fine or Coarse Timestamp Update
 *  0b0..Coarse method is used to update system timestamp
 *  0b1..Fine method is used to update system timestamp
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSCFUPDT(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSCFUPDT_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSCFUPDT_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSINIT_MASK   (0x4U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSINIT_SHIFT  (2U)
/*! TSINIT - Initialize Timestamp
 *  0b0..Timestamp is not initialized
 *  0b1..Timestamp is initialized
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSINIT(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSINIT_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSINIT_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSUPDT_MASK   (0x8U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSUPDT_SHIFT  (3U)
/*! TSUPDT - Update Timestamp
 *  0b0..Timestamp is not updated
 *  0b1..Timestamp is updated
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSUPDT(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSUPDT_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSUPDT_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSTRIG_MASK   (0x10U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSTRIG_SHIFT  (4U)
/*! TSTRIG - Enable Timestamp Interrupt Trigger
 *  0b0..Timestamp Interrupt Trigger is not enabled
 *  0b1..Timestamp Interrupt Trigger is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSTRIG(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSTRIG_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSTRIG_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSADDREG_MASK (0x20U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSADDREG_SHIFT (5U)
/*! TSADDREG - Update Addend Register
 *  0b0..Addend Register is not updated
 *  0b1..Addend Register is updated
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSADDREG(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSADDREG_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSADDREG_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSENALL_MASK  (0x100U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSENALL_SHIFT (8U)
/*! TSENALL - Enable Timestamp for All Packets
 *  0b0..Timestamp for All Packets disabled
 *  0b1..Timestamp for All Packets enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSENALL(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSENALL_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSENALL_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSCTRLSSR_MASK (0x200U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSCTRLSSR_SHIFT (9U)
/*! TSCTRLSSR - Timestamp Digital or Binary Rollover Control
 *  0b0..Timestamp Digital Rollover Control is disabled and Binary Rollover Control is enabled
 *  0b1..Timestamp Digital Rollover Control is enabled and Binary Rollover Control is disabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSCTRLSSR(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSCTRLSSR_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSCTRLSSR_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSVER2ENA_MASK (0x400U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSVER2ENA_SHIFT (10U)
/*! TSVER2ENA - Enable PTP Packet Processing for Version 2 Format
 *  0b0..PTP Packet Processing for Version 2 Format is disabled
 *  0b1..PTP Packet Processing for Version 2 Format is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSVER2ENA(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSVER2ENA_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSVER2ENA_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSIPENA_MASK  (0x800U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSIPENA_SHIFT (11U)
/*! TSIPENA - Enable Processing of PTP over Ethernet Packets
 *  0b0..Processing of PTP over Ethernet Packets is disabled
 *  0b1..Processing of PTP over Ethernet Packets is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSIPENA(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSIPENA_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSIPENA_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSIPV6ENA_MASK (0x1000U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSIPV6ENA_SHIFT (12U)
/*! TSIPV6ENA - Enable Processing of PTP Packets Sent over IPv6-UDP
 *  0b0..Processing of PTP Packets Sent over IPv6-UDP is disabled
 *  0b1..Processing of PTP Packets Sent over IPv6-UDP is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSIPV6ENA(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSIPV6ENA_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSIPV6ENA_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSIPV4ENA_MASK (0x2000U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSIPV4ENA_SHIFT (13U)
/*! TSIPV4ENA - Enable Processing of PTP Packets Sent over IPv4-UDP
 *  0b0..Processing of PTP Packets Sent over IPv4-UDP is disabled
 *  0b1..Processing of PTP Packets Sent over IPv4-UDP is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSIPV4ENA(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSIPV4ENA_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSIPV4ENA_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSEVNTENA_MASK (0x4000U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSEVNTENA_SHIFT (14U)
/*! TSEVNTENA - Enable Timestamp Snapshot for Event Messages
 *  0b0..Timestamp Snapshot for Event Messages is disabled
 *  0b1..Timestamp Snapshot for Event Messages is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSEVNTENA(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSEVNTENA_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSEVNTENA_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSMSTRENA_MASK (0x8000U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSMSTRENA_SHIFT (15U)
/*! TSMSTRENA - Enable Snapshot for Messages Relevant to Master
 *  0b0..Snapshot for Messages Relevant to Master is disabled
 *  0b1..Snapshot for Messages Relevant to Master is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSMSTRENA(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSMSTRENA_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSMSTRENA_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_SNAPTYPSEL_MASK (0x30000U)
#define ENET_MAC_TIMESTAMP_CONTROL_SNAPTYPSEL_SHIFT (16U)
/*! SNAPTYPSEL - Select PTP packets for Taking Snapshots */
#define ENET_MAC_TIMESTAMP_CONTROL_SNAPTYPSEL(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_SNAPTYPSEL_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_SNAPTYPSEL_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TSENMACADDR_MASK (0x40000U)
#define ENET_MAC_TIMESTAMP_CONTROL_TSENMACADDR_SHIFT (18U)
/*! TSENMACADDR - Enable MAC Address for PTP Packet Filtering
 *  0b0..MAC Address for PTP Packet Filtering is disabled
 *  0b1..MAC Address for PTP Packet Filtering is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TSENMACADDR(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TSENMACADDR_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TSENMACADDR_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_ESTI_MASK     (0x100000U)
#define ENET_MAC_TIMESTAMP_CONTROL_ESTI_SHIFT    (20U)
/*! ESTI - External System Time Input
 *  0b0..External System Time Input is disabled
 *  0b1..External System Time Input is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_ESTI(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_ESTI_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_ESTI_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_TXTSSTSM_MASK (0x1000000U)
#define ENET_MAC_TIMESTAMP_CONTROL_TXTSSTSM_SHIFT (24U)
/*! TXTSSTSM - Transmit Timestamp Status Mode
 *  0b0..Transmit Timestamp Status Mode is disabled
 *  0b1..Transmit Timestamp Status Mode is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_TXTSSTSM(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_TXTSSTSM_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_TXTSSTSM_MASK)

#define ENET_MAC_TIMESTAMP_CONTROL_AV8021ASMEN_MASK (0x10000000U)
#define ENET_MAC_TIMESTAMP_CONTROL_AV8021ASMEN_SHIFT (28U)
/*! AV8021ASMEN - AV 802.
 *  0b0..AV 802.1AS Mode is disabled
 *  0b1..AV 802.1AS Mode is enabled
 */
#define ENET_MAC_TIMESTAMP_CONTROL_AV8021ASMEN(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_CONTROL_AV8021ASMEN_SHIFT)) & ENET_MAC_TIMESTAMP_CONTROL_AV8021ASMEN_MASK)
/*! @} */

/*! @name MAC_SUB_SECOND_INCREMENT - Subsecond Increment */
/*! @{ */

#define ENET_MAC_SUB_SECOND_INCREMENT_SNSINC_MASK (0xFF0000U)
#define ENET_MAC_SUB_SECOND_INCREMENT_SNSINC_SHIFT (16U)
/*! SNSINC - Sub-nanosecond Increment Value */
#define ENET_MAC_SUB_SECOND_INCREMENT_SNSINC(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SUB_SECOND_INCREMENT_SNSINC_SHIFT)) & ENET_MAC_SUB_SECOND_INCREMENT_SNSINC_MASK)
/*! @} */

/*! @name MAC_SYSTEM_TIME_SECONDS - System Time Seconds */
/*! @{ */

#define ENET_MAC_SYSTEM_TIME_SECONDS_TSS_MASK    (0xFFFFFFFFU)
#define ENET_MAC_SYSTEM_TIME_SECONDS_TSS_SHIFT   (0U)
/*! TSS - Timestamp Second */
#define ENET_MAC_SYSTEM_TIME_SECONDS_TSS(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYSTEM_TIME_SECONDS_TSS_SHIFT)) & ENET_MAC_SYSTEM_TIME_SECONDS_TSS_MASK)
/*! @} */

/*! @name MAC_SYSTEM_TIME_NANOSECONDS - System Time Nanoseconds */
/*! @{ */

#define ENET_MAC_SYSTEM_TIME_NANOSECONDS_TSSS_MASK (0x7FFFFFFFU)
#define ENET_MAC_SYSTEM_TIME_NANOSECONDS_TSSS_SHIFT (0U)
/*! TSSS - Timestamp Sub Seconds */
#define ENET_MAC_SYSTEM_TIME_NANOSECONDS_TSSS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYSTEM_TIME_NANOSECONDS_TSSS_SHIFT)) & ENET_MAC_SYSTEM_TIME_NANOSECONDS_TSSS_MASK)
/*! @} */

/*! @name MAC_SYSTEM_TIME_SECONDS_UPDATE - System Time Seconds Update */
/*! @{ */

#define ENET_MAC_SYSTEM_TIME_SECONDS_UPDATE_TSS_MASK (0xFFFFFFFFU)
#define ENET_MAC_SYSTEM_TIME_SECONDS_UPDATE_TSS_SHIFT (0U)
/*! TSS - Timestamp Seconds */
#define ENET_MAC_SYSTEM_TIME_SECONDS_UPDATE_TSS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYSTEM_TIME_SECONDS_UPDATE_TSS_SHIFT)) & ENET_MAC_SYSTEM_TIME_SECONDS_UPDATE_TSS_MASK)
/*! @} */

/*! @name MAC_SYSTEM_TIME_NANOSECONDS_UPDATE - System Time Nanoseconds Update */
/*! @{ */

#define ENET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_MASK (0x7FFFFFFFU)
#define ENET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_SHIFT (0U)
/*! TSSS - Timestamp Sub Seconds */
#define ENET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_SHIFT)) & ENET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_TSSS_MASK)

#define ENET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_MASK (0x80000000U)
#define ENET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_SHIFT (31U)
/*! ADDSUB - Add or Subtract Time
 *  0b0..Add time
 *  0b1..Subtract time
 */
#define ENET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_SHIFT)) & ENET_MAC_SYSTEM_TIME_NANOSECONDS_UPDATE_ADDSUB_MASK)
/*! @} */

/*! @name MAC_TIMESTAMP_ADDEND - Timestamp Addend */
/*! @{ */

#define ENET_MAC_TIMESTAMP_ADDEND_TSAR_MASK      (0xFFFFFFFFU)
#define ENET_MAC_TIMESTAMP_ADDEND_TSAR_SHIFT     (0U)
/*! TSAR - Timestamp Addend Register */
#define ENET_MAC_TIMESTAMP_ADDEND_TSAR(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_ADDEND_TSAR_SHIFT)) & ENET_MAC_TIMESTAMP_ADDEND_TSAR_MASK)
/*! @} */

/*! @name MAC_TIMESTAMP_STATUS - Timestamp Status */
/*! @{ */

#define ENET_MAC_TIMESTAMP_STATUS_TSSOVF_MASK    (0x1U)
#define ENET_MAC_TIMESTAMP_STATUS_TSSOVF_SHIFT   (0U)
/*! TSSOVF - Timestamp Seconds Overflow
 *  0b1..Timestamp Seconds Overflow status detected
 *  0b0..Timestamp Seconds Overflow status not detected
 */
#define ENET_MAC_TIMESTAMP_STATUS_TSSOVF(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_STATUS_TSSOVF_SHIFT)) & ENET_MAC_TIMESTAMP_STATUS_TSSOVF_MASK)

#define ENET_MAC_TIMESTAMP_STATUS_TSTARGT0_MASK  (0x2U)
#define ENET_MAC_TIMESTAMP_STATUS_TSTARGT0_SHIFT (1U)
/*! TSTARGT0 - Timestamp Target Time Reached
 *  0b1..Timestamp Target Time Reached status detected
 *  0b0..Timestamp Target Time Reached status not detected
 */
#define ENET_MAC_TIMESTAMP_STATUS_TSTARGT0(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_STATUS_TSTARGT0_SHIFT)) & ENET_MAC_TIMESTAMP_STATUS_TSTARGT0_MASK)

#define ENET_MAC_TIMESTAMP_STATUS_TSTRGTERR0_MASK (0x8U)
#define ENET_MAC_TIMESTAMP_STATUS_TSTRGTERR0_SHIFT (3U)
/*! TSTRGTERR0 - Timestamp Target Time Error
 *  0b1..Timestamp Target Time Error status detected
 *  0b0..Timestamp Target Time Error status not detected
 */
#define ENET_MAC_TIMESTAMP_STATUS_TSTRGTERR0(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_STATUS_TSTRGTERR0_SHIFT)) & ENET_MAC_TIMESTAMP_STATUS_TSTRGTERR0_MASK)

#define ENET_MAC_TIMESTAMP_STATUS_TXTSSIS_MASK   (0x8000U)
#define ENET_MAC_TIMESTAMP_STATUS_TXTSSIS_SHIFT  (15U)
/*! TXTSSIS - Tx Timestamp Status Interrupt Status
 *  0b1..Tx Timestamp Status Interrupt status detected
 *  0b0..Tx Timestamp Status Interrupt status not detected
 */
#define ENET_MAC_TIMESTAMP_STATUS_TXTSSIS(x)     (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_STATUS_TXTSSIS_SHIFT)) & ENET_MAC_TIMESTAMP_STATUS_TXTSSIS_MASK)
/*! @} */

/*! @name MAC_TX_TIMESTAMP_STATUS_NANOSECONDS - Transmit Timestamp Status Nanoseconds */
/*! @{ */

#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSLO_MASK (0x7FFFFFFFU)
#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSLO_SHIFT (0U)
/*! TXTSSLO - Transmit Timestamp Status Low */
#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSLO(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSLO_SHIFT)) & ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSLO_MASK)

#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSMIS_MASK (0x80000000U)
#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSMIS_SHIFT (31U)
/*! TXTSSMIS - TXTSSMIS
 *  0b1..Transmit Timestamp Status Missed status detected
 *  0b0..Transmit Timestamp Status Missed status not detected
 */
#define ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSMIS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSMIS_SHIFT)) & ENET_MAC_TX_TIMESTAMP_STATUS_NANOSECONDS_TXTSSMIS_MASK)
/*! @} */

/*! @name MAC_TX_TIMESTAMP_STATUS_SECONDS - Transmit Timestamp Status Seconds */
/*! @{ */

#define ENET_MAC_TX_TIMESTAMP_STATUS_SECONDS_TXTSSHI_MASK (0xFFFFFFFFU)
#define ENET_MAC_TX_TIMESTAMP_STATUS_SECONDS_TXTSSHI_SHIFT (0U)
/*! TXTSSHI - Transmit Timestamp Status High */
#define ENET_MAC_TX_TIMESTAMP_STATUS_SECONDS_TXTSSHI(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TX_TIMESTAMP_STATUS_SECONDS_TXTSSHI_SHIFT)) & ENET_MAC_TX_TIMESTAMP_STATUS_SECONDS_TXTSSHI_MASK)
/*! @} */

/*! @name MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND - Timestamp Ingress Correction Nanosecond */
/*! @{ */

#define ENET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_TSIC_MASK (0xFFFFFFFFU)
#define ENET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_TSIC_SHIFT (0U)
/*! TSIC - Timestamp Ingress Correction */
#define ENET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_TSIC(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_TSIC_SHIFT)) & ENET_MAC_TIMESTAMP_INGRESS_CORR_NANOSECOND_TSIC_MASK)
/*! @} */

/*! @name MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND - Timestamp Egress Correction Nanosecond */
/*! @{ */

#define ENET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_TSEC_MASK (0xFFFFFFFFU)
#define ENET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_TSEC_SHIFT (0U)
/*! TSEC - Timestamp Egress Correction */
#define ENET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_TSEC(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_TSEC_SHIFT)) & ENET_MAC_TIMESTAMP_EGRESS_CORR_NANOSECOND_TSEC_MASK)
/*! @} */

/*! @name MAC_TIMESTAMP_INGRESS_LATENCY - Timestamp Ingress Latency */
/*! @{ */

#define ENET_MAC_TIMESTAMP_INGRESS_LATENCY_ITLSNS_MASK (0xFF00U)
#define ENET_MAC_TIMESTAMP_INGRESS_LATENCY_ITLSNS_SHIFT (8U)
/*! ITLSNS - ITLSNS */
#define ENET_MAC_TIMESTAMP_INGRESS_LATENCY_ITLSNS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_INGRESS_LATENCY_ITLSNS_SHIFT)) & ENET_MAC_TIMESTAMP_INGRESS_LATENCY_ITLSNS_MASK)

#define ENET_MAC_TIMESTAMP_INGRESS_LATENCY_ITLNS_MASK (0xFFF0000U)
#define ENET_MAC_TIMESTAMP_INGRESS_LATENCY_ITLNS_SHIFT (16U)
/*! ITLNS - ITLNS */
#define ENET_MAC_TIMESTAMP_INGRESS_LATENCY_ITLNS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_INGRESS_LATENCY_ITLNS_SHIFT)) & ENET_MAC_TIMESTAMP_INGRESS_LATENCY_ITLNS_MASK)
/*! @} */

/*! @name MAC_TIMESTAMP_EGRESS_LATENCY - Timestamp Egress Latency */
/*! @{ */

#define ENET_MAC_TIMESTAMP_EGRESS_LATENCY_ETLSNS_MASK (0xFF00U)
#define ENET_MAC_TIMESTAMP_EGRESS_LATENCY_ETLSNS_SHIFT (8U)
/*! ETLSNS - Egress Timestamp Latency, in sub-nanoseconds */
#define ENET_MAC_TIMESTAMP_EGRESS_LATENCY_ETLSNS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_EGRESS_LATENCY_ETLSNS_SHIFT)) & ENET_MAC_TIMESTAMP_EGRESS_LATENCY_ETLSNS_MASK)

#define ENET_MAC_TIMESTAMP_EGRESS_LATENCY_ETLNS_MASK (0xFFF0000U)
#define ENET_MAC_TIMESTAMP_EGRESS_LATENCY_ETLNS_SHIFT (16U)
/*! ETLNS - Egress Timestamp Latency, in nanoseconds */
#define ENET_MAC_TIMESTAMP_EGRESS_LATENCY_ETLNS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MAC_TIMESTAMP_EGRESS_LATENCY_ETLNS_SHIFT)) & ENET_MAC_TIMESTAMP_EGRESS_LATENCY_ETLNS_MASK)
/*! @} */

/*! @name MAC_PPS_CONTROL - PPS Control */
/*! @{ */

#define ENET_MAC_PPS_CONTROL_PPSCTRL_PPSCMD_MASK (0xFU)
#define ENET_MAC_PPS_CONTROL_PPSCTRL_PPSCMD_SHIFT (0U)
/*! PPSCTRL_PPSCMD - PPS Output Frequency Control */
#define ENET_MAC_PPS_CONTROL_PPSCTRL_PPSCMD(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MAC_PPS_CONTROL_PPSCTRL_PPSCMD_SHIFT)) & ENET_MAC_PPS_CONTROL_PPSCTRL_PPSCMD_MASK)
/*! @} */

/*! @name PPS0_TARGET_TIME_SECONDS - PPS0 Target Time Seconds */
/*! @{ */

#define ENET_PPS0_TARGET_TIME_SECONDS_TSTRH0_MASK (0xFFFFFFFFU)
#define ENET_PPS0_TARGET_TIME_SECONDS_TSTRH0_SHIFT (0U)
/*! TSTRH0 - PPS Target Time Seconds Register */
#define ENET_PPS0_TARGET_TIME_SECONDS_TSTRH0(x)  (((uint32_t)(((uint32_t)(x)) << ENET_PPS0_TARGET_TIME_SECONDS_TSTRH0_SHIFT)) & ENET_PPS0_TARGET_TIME_SECONDS_TSTRH0_MASK)
/*! @} */

/*! @name PPS0_TARGET_TIME_NANOSECONDS - PPS0 Target Time Nanoseconds */
/*! @{ */

#define ENET_PPS0_TARGET_TIME_NANOSECONDS_TTSL0_MASK (0x7FFFFFFFU)
#define ENET_PPS0_TARGET_TIME_NANOSECONDS_TTSL0_SHIFT (0U)
/*! TTSL0 - Target Time Low for PPS Register */
#define ENET_PPS0_TARGET_TIME_NANOSECONDS_TTSL0(x) (((uint32_t)(((uint32_t)(x)) << ENET_PPS0_TARGET_TIME_NANOSECONDS_TTSL0_SHIFT)) & ENET_PPS0_TARGET_TIME_NANOSECONDS_TTSL0_MASK)
/*! @} */

/*! @name MTL_OPERATION_MODE - MTL Operation Mode */
/*! @{ */

#define ENET_MTL_OPERATION_MODE_DTXSTS_MASK      (0x2U)
#define ENET_MTL_OPERATION_MODE_DTXSTS_SHIFT     (1U)
/*! DTXSTS - Drop Transmit Status
 *  0b0..Drop Transmit Status is disabled
 *  0b1..Drop Transmit Status is enabled
 */
#define ENET_MTL_OPERATION_MODE_DTXSTS(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MTL_OPERATION_MODE_DTXSTS_SHIFT)) & ENET_MTL_OPERATION_MODE_DTXSTS_MASK)

#define ENET_MTL_OPERATION_MODE_RAA_MASK         (0x4U)
#define ENET_MTL_OPERATION_MODE_RAA_SHIFT        (2U)
/*! RAA - Receive Arbitration Algorithm
 *  0b0..Strict priority (SP)
 *  0b1..Weighted Strict Priority (WSP)
 */
#define ENET_MTL_OPERATION_MODE_RAA(x)           (((uint32_t)(((uint32_t)(x)) << ENET_MTL_OPERATION_MODE_RAA_SHIFT)) & ENET_MTL_OPERATION_MODE_RAA_MASK)

#define ENET_MTL_OPERATION_MODE_SCHALG_MASK      (0x60U)
#define ENET_MTL_OPERATION_MODE_SCHALG_SHIFT     (5U)
/*! SCHALG - Tx Scheduling Algorithm
 *  0b10..DWRR algorithm when DCB feature is selected.Otherwise, Reserved
 *  0b11..Strict priority algorithm
 *  0b01..WFQ algorithm when DCB feature is selected.Otherwise, Reserved
 *  0b00..WRR algorithm
 */
#define ENET_MTL_OPERATION_MODE_SCHALG(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MTL_OPERATION_MODE_SCHALG_SHIFT)) & ENET_MTL_OPERATION_MODE_SCHALG_MASK)

#define ENET_MTL_OPERATION_MODE_CNTPRST_MASK     (0x100U)
#define ENET_MTL_OPERATION_MODE_CNTPRST_SHIFT    (8U)
/*! CNTPRST - Counters Preset
 *  0b0..Counters Preset is disabled
 *  0b1..Counters Preset is enabled
 */
#define ENET_MTL_OPERATION_MODE_CNTPRST(x)       (((uint32_t)(((uint32_t)(x)) << ENET_MTL_OPERATION_MODE_CNTPRST_SHIFT)) & ENET_MTL_OPERATION_MODE_CNTPRST_MASK)

#define ENET_MTL_OPERATION_MODE_CNTCLR_MASK      (0x200U)
#define ENET_MTL_OPERATION_MODE_CNTCLR_SHIFT     (9U)
/*! CNTCLR - Counters Reset
 *  0b0..Counters are not reset
 *  0b1..All counters are reset
 */
#define ENET_MTL_OPERATION_MODE_CNTCLR(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MTL_OPERATION_MODE_CNTCLR_SHIFT)) & ENET_MTL_OPERATION_MODE_CNTCLR_MASK)
/*! @} */

/*! @name MTL_INTERRUPT_STATUS - MTL Interrupt Status */
/*! @{ */

#define ENET_MTL_INTERRUPT_STATUS_Q0IS_MASK      (0x1U)
#define ENET_MTL_INTERRUPT_STATUS_Q0IS_SHIFT     (0U)
/*! Q0IS - Queue 0 Interrupt status
 *  0b1..Queue 0 Interrupt status detected
 *  0b0..Queue 0 Interrupt status not detected
 */
#define ENET_MTL_INTERRUPT_STATUS_Q0IS(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MTL_INTERRUPT_STATUS_Q0IS_SHIFT)) & ENET_MTL_INTERRUPT_STATUS_Q0IS_MASK)

#define ENET_MTL_INTERRUPT_STATUS_Q1IS_MASK      (0x2U)
#define ENET_MTL_INTERRUPT_STATUS_Q1IS_SHIFT     (1U)
/*! Q1IS - Queue 1 Interrupt status
 *  0b1..Queue 1 Interrupt status detected
 *  0b0..Queue 1 Interrupt status not detected
 */
#define ENET_MTL_INTERRUPT_STATUS_Q1IS(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MTL_INTERRUPT_STATUS_Q1IS_SHIFT)) & ENET_MTL_INTERRUPT_STATUS_Q1IS_MASK)
/*! @} */

/*! @name MTL_RXQ_DMA_MAP0 - Receive Queue and DMA Channel Mapping 0 */
/*! @{ */

#define ENET_MTL_RXQ_DMA_MAP0_Q0MDMACH_MASK      (0x1U)
#define ENET_MTL_RXQ_DMA_MAP0_Q0MDMACH_SHIFT     (0U)
/*! Q0MDMACH - Queue 0 Mapped to DMA Channel */
#define ENET_MTL_RXQ_DMA_MAP0_Q0MDMACH(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MTL_RXQ_DMA_MAP0_Q0MDMACH_SHIFT)) & ENET_MTL_RXQ_DMA_MAP0_Q0MDMACH_MASK)

#define ENET_MTL_RXQ_DMA_MAP0_Q0DDMACH_MASK      (0x10U)
#define ENET_MTL_RXQ_DMA_MAP0_Q0DDMACH_SHIFT     (4U)
/*! Q0DDMACH - Queue 0 Enabled for DA-based DMA Channel Selection
 *  0b0..Queue 0 disabled for DA-based DMA Channel Selection
 *  0b1..Queue 0 enabled for DA-based DMA Channel Selection
 */
#define ENET_MTL_RXQ_DMA_MAP0_Q0DDMACH(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MTL_RXQ_DMA_MAP0_Q0DDMACH_SHIFT)) & ENET_MTL_RXQ_DMA_MAP0_Q0DDMACH_MASK)

#define ENET_MTL_RXQ_DMA_MAP0_Q1MDMACH_MASK      (0x100U)
#define ENET_MTL_RXQ_DMA_MAP0_Q1MDMACH_SHIFT     (8U)
/*! Q1MDMACH - Queue 1 Mapped to DMA Channel */
#define ENET_MTL_RXQ_DMA_MAP0_Q1MDMACH(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MTL_RXQ_DMA_MAP0_Q1MDMACH_SHIFT)) & ENET_MTL_RXQ_DMA_MAP0_Q1MDMACH_MASK)

#define ENET_MTL_RXQ_DMA_MAP0_Q1DDMACH_MASK      (0x1000U)
#define ENET_MTL_RXQ_DMA_MAP0_Q1DDMACH_SHIFT     (12U)
/*! Q1DDMACH - Queue 1 Enabled for DA-based DMA Channel Selection
 *  0b0..Queue 1 disabled for DA-based DMA Channel Selection
 *  0b1..Queue 1 enabled for DA-based DMA Channel Selection
 */
#define ENET_MTL_RXQ_DMA_MAP0_Q1DDMACH(x)        (((uint32_t)(((uint32_t)(x)) << ENET_MTL_RXQ_DMA_MAP0_Q1DDMACH_SHIFT)) & ENET_MTL_RXQ_DMA_MAP0_Q1DDMACH_MASK)
/*! @} */

/*! @name MTL_QUEUE_MTL_TXQX_OP_MODE - Queue 0 Transmit Operation Mode..Queue 1 Transmit Operation Mode */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_FTQ_MASK (0x1U)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_FTQ_SHIFT (0U)
/*! FTQ - Flush Transmit Queue
 *  0b0..Flush Transmit Queue is disabled
 *  0b1..Flush Transmit Queue is enabled
 */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_FTQ(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_FTQ_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_FTQ_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TSF_MASK (0x2U)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TSF_SHIFT (1U)
/*! TSF - Transmit Store and Forward
 *  0b0..Transmit Store and Forward is disabled
 *  0b1..Transmit Store and Forward is enabled
 */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TSF(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TSF_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TSF_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TXQEN_MASK (0xCU)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TXQEN_SHIFT (2U)
/*! TXQEN - Transmit Queue Enable
 *  0b00..Not enabled
 *  0b10..Enabled
 *  0b01..Enable in AV mode (Reserved in non-AV)
 *  0b11..Reserved
 */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TXQEN(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TXQEN_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TXQEN_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TTC_MASK (0x70U)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TTC_SHIFT (4U)
/*! TTC - Transmit Threshold Control
 *  0b011..128
 *  0b100..192
 *  0b101..256
 *  0b000..32
 *  0b110..384
 *  0b111..512
 *  0b001..64
 *  0b010..96
 */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TTC(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TTC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TTC_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TQS_MASK (0x70000U)
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TQS_SHIFT (16U)
/*! TQS - Transmit Queue Size */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TQS(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TQS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_TQS_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_OP_MODE */
#define ENET_MTL_QUEUE_MTL_TXQX_OP_MODE_COUNT    (2U)

/*! @name MTL_QUEUE_MTL_TXQX_UNDRFLW - Queue 0 Underflow Counter..Queue 1 Underflow Counter */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFFRMCNT_MASK (0x7FFU)
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFFRMCNT_SHIFT (0U)
/*! UFFRMCNT - Underflow Packet Counter */
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFFRMCNT(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFFRMCNT_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFFRMCNT_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFCNTOVF_MASK (0x800U)
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFCNTOVF_SHIFT (11U)
/*! UFCNTOVF - Overflow Bit for Underflow Packet Counter
 *  0b1..Overflow detected for Underflow Packet Counter
 *  0b0..Overflow not detected for Underflow Packet Counter
 */
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFCNTOVF(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFCNTOVF_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_UFCNTOVF_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW */
#define ENET_MTL_QUEUE_MTL_TXQX_UNDRFLW_COUNT    (2U)

/*! @name MTL_QUEUE_MTL_TXQX_DBG - Queue 0 Transmit Debug..Queue 1 Transmit Debug */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQPAUSED_MASK (0x1U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQPAUSED_SHIFT (0U)
/*! TXQPAUSED - Transmit Queue in Pause
 *  0b1..Transmit Queue in Pause status is detected
 *  0b0..Transmit Queue in Pause status is not detected
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQPAUSED(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQPAUSED_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQPAUSED_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TRCSTS_MASK  (0x6U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TRCSTS_SHIFT (1U)
/*! TRCSTS - MTL Tx Queue Read Controller Status
 *  0b11..Flushing the Tx queue because of the Packet Abort request from the MAC
 *  0b00..Idle state
 *  0b01..Read state (transferring data to the MAC transmitter)
 *  0b10..Waiting for pending Tx Status from the MAC transmitter
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TRCSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_TRCSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_TRCSTS_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TWCSTS_MASK  (0x8U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TWCSTS_SHIFT (3U)
/*! TWCSTS - MTL Tx Queue Write Controller Status
 *  0b1..MTL Tx Queue Write Controller status is detected
 *  0b0..MTL Tx Queue Write Controller status is not detected
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TWCSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_TWCSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_TWCSTS_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQSTS_MASK  (0x10U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQSTS_SHIFT (4U)
/*! TXQSTS - MTL Tx Queue Not Empty Status
 *  0b1..MTL Tx Queue Not Empty status is detected
 *  0b0..MTL Tx Queue Not Empty status is not detected
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_TXQSTS_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXSTSFSTS_MASK (0x20U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXSTSFSTS_SHIFT (5U)
/*! TXSTSFSTS - MTL Tx Status FIFO Full Status
 *  0b1..MTL Tx Status FIFO Full status is detected
 *  0b0..MTL Tx Status FIFO Full status is not detected
 */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_TXSTSFSTS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_TXSTSFSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_TXSTSFSTS_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_DBG_PTXQ_MASK    (0x70000U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_PTXQ_SHIFT   (16U)
/*! PTXQ - Number of Packets in the Transmit Queue */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_PTXQ(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_PTXQ_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_PTXQ_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_DBG_STXSTSF_MASK (0x700000U)
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_STXSTSF_SHIFT (20U)
/*! STXSTSF - Number of Status Words in Tx Status FIFO of Queue */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_STXSTSF(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_DBG_STXSTSF_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_DBG_STXSTSF_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_DBG */
#define ENET_MTL_QUEUE_MTL_TXQX_DBG_COUNT        (2U)

/*! @name MTL_QUEUE_MTL_TXQX_ETS_CTRL - Queue 1 ETS Control */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_AVALG_MASK (0x4U)
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_AVALG_SHIFT (2U)
/*! AVALG - AV Algorithm
 *  0b0..CBS Algorithm is disabled
 *  0b1..CBS Algorithm is enabled
 */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_AVALG(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_AVALG_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_AVALG_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_CC_MASK (0x8U)
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_CC_SHIFT (3U)
/*! CC - Credit Control
 *  0b0..Credit Control is disabled
 *  0b1..Credit Control is enabled
 */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_CC(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_CC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_CC_MASK)

#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_SLC_MASK (0x70U)
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_SLC_SHIFT (4U)
/*! SLC - Slot Count
 *  0b100..16 slots
 *  0b000..1 slot
 *  0b001..2 slots
 *  0b010..4 slots
 *  0b011..8 slots
 *  0b101..Reserved
 */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_SLC(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_SLC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_SLC_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_CTRL_COUNT   (2U)

/*! @name MTL_QUEUE_MTL_TXQX_ETS_STAT - Queue 0 ETS Status..Queue 1 ETS Status */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_ABS_MASK (0xFFFFFFU)
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_ABS_SHIFT (0U)
/*! ABS - Average Bits per Slot */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_ABS(x)  (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_ABS_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_ABS_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT */
#define ENET_MTL_QUEUE_MTL_TXQX_ETS_STAT_COUNT   (2U)

/*! @name MTL_QUEUE_MTL_TXQX_QNTM_WGHT - Queue 0 Quantum or Weights..Queue 1 idleSlopeCredit, Quantum or Weights */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_ISCQW_MASK (0x1FFFFFU)
#define ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_ISCQW_SHIFT (0U)
/*! ISCQW - idleSlopeCredit, Quantum or Weights */
#define ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_ISCQW(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_ISCQW_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_ISCQW_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT */
#define ENET_MTL_QUEUE_MTL_TXQX_QNTM_WGHT_COUNT  (2U)

/*! @name MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT - Queue 1 sendSlopeCredit */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_SSC_MASK (0x3FFFU)
#define ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_SSC_SHIFT (0U)
/*! SSC - sendSlopeCredit Value */
#define ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_SSC(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_SSC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_SSC_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT */
#define ENET_MTL_QUEUE_MTL_TXQX_SNDSLP_CRDT_COUNT (2U)

/*! @name MTL_QUEUE_MTL_TXQX_HI_CRDT - Queue 1 hiCredit */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_HC_MASK  (0x1FFFFFFFU)
#define ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_HC_SHIFT (0U)
/*! HC - hiCredit Value */
#define ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_HC(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_HC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_HC_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT */
#define ENET_MTL_QUEUE_MTL_TXQX_HI_CRDT_COUNT    (2U)

/*! @name MTL_QUEUE_MTL_TXQX_LO_CRDT - Queue 1 loCredit */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_LC_MASK  (0x1FFFFFFFU)
#define ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_LC_SHIFT (0U)
/*! LC - loCredit Value */
#define ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_LC(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_LC_SHIFT)) & ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_LC_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT */
#define ENET_MTL_QUEUE_MTL_TXQX_LO_CRDT_COUNT    (2U)

/*! @name MTL_QUEUE_MTL_QX_INTCTRL_STAT - Queue 0 Interrupt Control Status..Queue 1 Interrupt Control Status */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_TXUNFIS_MASK (0x1U)
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_TXUNFIS_SHIFT (0U)
/*! TXUNFIS - Transmit Queue Underflow Interrupt Status
 *  0b1..Transmit Queue Underflow Interrupt Status detected
 *  0b0..Transmit Queue Underflow Interrupt Status not detected
 */
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_TXUNFIS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_TXUNFIS_SHIFT)) & ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_TXUNFIS_MASK)

#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_ABPSIS_MASK (0x2U)
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_ABPSIS_SHIFT (1U)
/*! ABPSIS - Average Bits Per Slot Interrupt Status
 *  0b1..Average Bits Per Slot Interrupt Status detected
 *  0b0..Average Bits Per Slot Interrupt Status not detected
 */
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_ABPSIS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_ABPSIS_SHIFT)) & ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_ABPSIS_MASK)

#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_TXUIE_MASK (0x100U)
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_TXUIE_SHIFT (8U)
/*! TXUIE - Transmit Queue Underflow Interrupt Enable
 *  0b0..Transmit Queue Underflow Interrupt Status is disabled
 *  0b1..Transmit Queue Underflow Interrupt Status is enabled
 */
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_TXUIE(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_TXUIE_SHIFT)) & ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_TXUIE_MASK)

#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_ABPSIE_MASK (0x200U)
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_ABPSIE_SHIFT (9U)
/*! ABPSIE - Average Bits Per Slot Interrupt Enable
 *  0b0..Average Bits Per Slot Interrupt is disabled
 *  0b1..Average Bits Per Slot Interrupt is enabled
 */
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_ABPSIE(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_ABPSIE_SHIFT)) & ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_ABPSIE_MASK)

#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_RXOVFIS_MASK (0x10000U)
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_RXOVFIS_SHIFT (16U)
/*! RXOVFIS - Receive Queue Overflow Interrupt Status
 *  0b1..Receive Queue Overflow Interrupt Status detected
 *  0b0..Receive Queue Overflow Interrupt Status not detected
 */
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_RXOVFIS(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_RXOVFIS_SHIFT)) & ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_RXOVFIS_MASK)

#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_RXOIE_MASK (0x1000000U)
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_RXOIE_SHIFT (24U)
/*! RXOIE - Receive Queue Overflow Interrupt Enable
 *  0b0..Receive Queue Overflow Interrupt is disabled
 *  0b1..Receive Queue Overflow Interrupt is enabled
 */
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_RXOIE(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_RXOIE_SHIFT)) & ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_RXOIE_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT */
#define ENET_MTL_QUEUE_MTL_QX_INTCTRL_STAT_COUNT (2U)

/*! @name MTL_QUEUE_MTL_RXQX_OP_MODE - Queue 0 Receive Operation Mode..Queue 1 Receive Operation Mode */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RTC_MASK (0x3U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RTC_SHIFT (0U)
/*! RTC - Receive Queue Threshold Control
 *  0b11..128
 *  0b01..32
 *  0b00..64
 *  0b10..96
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RTC(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RTC_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RTC_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FUP_MASK (0x8U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FUP_SHIFT (3U)
/*! FUP - Forward Undersized Good Packets
 *  0b0..Forward Undersized Good Packets is disabled
 *  0b1..Forward Undersized Good Packets is enabled
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FUP(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FUP_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FUP_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FEP_MASK (0x10U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FEP_SHIFT (4U)
/*! FEP - Forward Error Packets
 *  0b0..Forward Error Packets is disabled
 *  0b1..Forward Error Packets is enabled
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FEP(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FEP_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_FEP_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RSF_MASK (0x20U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RSF_SHIFT (5U)
/*! RSF - Receive Queue Store and Forward
 *  0b0..Receive Queue Store and Forward is disabled
 *  0b1..Receive Queue Store and Forward is enabled
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RSF(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RSF_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RSF_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_DIS_TCP_EF_MASK (0x40U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_DIS_TCP_EF_SHIFT (6U)
/*! DIS_TCP_EF - Disable Dropping of TCP/IP Checksum Error Packets
 *  0b1..Dropping of TCP/IP Checksum Error Packets is disabled
 *  0b0..Dropping of TCP/IP Checksum Error Packets is enabled
 */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_DIS_TCP_EF(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_DIS_TCP_EF_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_DIS_TCP_EF_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RQS_MASK (0x700000U)
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RQS_SHIFT (20U)
/*! RQS - Receive Queue Size */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RQS(x)   (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RQS_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_RQS_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_RXQX_OP_MODE */
#define ENET_MTL_QUEUE_MTL_RXQX_OP_MODE_COUNT    (2U)

/*! @name MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT - Queue 0 Missed Packet and Overflow Counter..Queue 1 Missed Packet and Overflow Counter */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFPKTCNT_MASK (0x7FFU)
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFPKTCNT_SHIFT (0U)
/*! OVFPKTCNT - Overflow Packet Counter */
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFPKTCNT(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFPKTCNT_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFPKTCNT_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFCNTOVF_MASK (0x800U)
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFCNTOVF_SHIFT (11U)
/*! OVFCNTOVF - Overflow Counter Overflow Bit
 *  0b1..Overflow Counter overflow detected
 *  0b0..Overflow Counter overflow not detected
 */
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFCNTOVF(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFCNTOVF_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_OVFCNTOVF_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_MISPKTCNT_MASK (0x7FF0000U)
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_MISPKTCNT_SHIFT (16U)
/*! MISPKTCNT - Missed Packet Counter */
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_MISPKTCNT(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_MISPKTCNT_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_MISPKTCNT_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_MISCNTOVF_MASK (0x8000000U)
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_MISCNTOVF_SHIFT (27U)
/*! MISCNTOVF - Missed Packet Counter Overflow Bit
 *  0b1..Missed Packet Counter overflow detected
 *  0b0..Missed Packet Counter overflow not detected
 */
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_MISCNTOVF(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_MISCNTOVF_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_MISCNTOVF_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT */
#define ENET_MTL_QUEUE_MTL_RXQX_MISSPKT_OVRFLW_CNT_COUNT (2U)

/*! @name MTL_QUEUE_MTL_RXQX_DBG - Queue 0 Receive Debug..Queue 1 Receive Debug */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RWCSTS_MASK  (0x1U)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RWCSTS_SHIFT (0U)
/*! RWCSTS - MTL Rx Queue Write Controller Active Status
 *  0b1..MTL Rx Queue Write Controller Active Status detected
 *  0b0..MTL Rx Queue Write Controller Active Status not detected
 */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RWCSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_DBG_RWCSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_DBG_RWCSTS_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RRCSTS_MASK  (0x6U)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RRCSTS_SHIFT (1U)
/*! RRCSTS - MTL Rx Queue Read Controller State
 *  0b11..Flushing the packet data and status
 *  0b00..Idle state
 *  0b01..Reading packet data
 *  0b10..Reading packet status (or timestamp)
 */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RRCSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_DBG_RRCSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_DBG_RRCSTS_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RXQSTS_MASK  (0x30U)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RXQSTS_SHIFT (4U)
/*! RXQSTS - MTL Rx Queue Fill-Level Status
 *  0b10..Rx Queue fill-level above flow-control activate threshold
 *  0b01..Rx Queue fill-level below flow-control deactivate threshold
 *  0b00..Rx Queue empty
 *  0b11..Rx Queue full
 */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_RXQSTS(x)    (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_DBG_RXQSTS_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_DBG_RXQSTS_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_DBG_PRXQ_MASK    (0x3FFF0000U)
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_PRXQ_SHIFT   (16U)
/*! PRXQ - Number of Packets in Receive Queue */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_PRXQ(x)      (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_DBG_PRXQ_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_DBG_PRXQ_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_RXQX_DBG */
#define ENET_MTL_QUEUE_MTL_RXQX_DBG_COUNT        (2U)

/*! @name MTL_QUEUE_MTL_RXQX_CTRL - Queue 0 Receive Control..Queue 1 Receive Control */
/*! @{ */

#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_WEGT_MASK (0x7U)
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_WEGT_SHIFT (0U)
/*! RXQ_WEGT - Receive Queue Weight */
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_WEGT(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_WEGT_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_WEGT_MASK)

#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_FRM_ARBIT_MASK (0x8U)
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_FRM_ARBIT_SHIFT (3U)
/*! RXQ_FRM_ARBIT - Receive Queue Packet Arbitration
 *  0b0..Receive Queue Packet Arbitration is disabled
 *  0b1..Receive Queue Packet Arbitration is enabled
 */
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_FRM_ARBIT(x) (((uint32_t)(((uint32_t)(x)) << ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_FRM_ARBIT_SHIFT)) & ENET_MTL_QUEUE_MTL_RXQX_CTRL_RXQ_FRM_ARBIT_MASK)
/*! @} */

/* The count of ENET_MTL_QUEUE_MTL_RXQX_CTRL */
#define ENET_MTL_QUEUE_MTL_RXQX_CTRL_COUNT       (2U)

/*! @name DMA_MODE - DMA Bus Mode */
/*! @{ */

#define ENET_DMA_MODE_SWR_MASK                   (0x1U)
#define ENET_DMA_MODE_SWR_SHIFT                  (0U)
/*! SWR - Software Reset
 *  0b0..Software Reset is disabled
 *  0b1..Software Reset is enabled
 */
#define ENET_DMA_MODE_SWR(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_DMA_MODE_SWR_SHIFT)) & ENET_DMA_MODE_SWR_MASK)

#define ENET_DMA_MODE_DA_MASK                    (0x2U)
#define ENET_DMA_MODE_DA_SHIFT                   (1U)
/*! DA - DMA Tx or Rx Arbitration Scheme
 *  0b1..Fixed Priority
 *  0b0..Weighted Round-Robin with Rx:Tx or Tx:Rx
 */
#define ENET_DMA_MODE_DA(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_DMA_MODE_DA_SHIFT)) & ENET_DMA_MODE_DA_MASK)

#define ENET_DMA_MODE_TAA_MASK                   (0x1CU)
#define ENET_DMA_MODE_TAA_SHIFT                  (2U)
/*! TAA - Transmit Arbitration Algorithm
 *  0b000..Fixed priority
 *  0b011..Reserved (for 3'b011 to 3'b111)
 *  0b010..Weighted Round-Robin (WRR)
 *  0b001..Weighted Strict Priority (WSP)
 */
#define ENET_DMA_MODE_TAA(x)                     (((uint32_t)(((uint32_t)(x)) << ENET_DMA_MODE_TAA_SHIFT)) & ENET_DMA_MODE_TAA_MASK)

#define ENET_DMA_MODE_TXPR_MASK                  (0x800U)
#define ENET_DMA_MODE_TXPR_SHIFT                 (11U)
/*! TXPR - Transmit Priority
 *  0b0..Transmit Priority is disabled
 *  0b1..Transmit Priority is enabled
 */
#define ENET_DMA_MODE_TXPR(x)                    (((uint32_t)(((uint32_t)(x)) << ENET_DMA_MODE_TXPR_SHIFT)) & ENET_DMA_MODE_TXPR_MASK)

#define ENET_DMA_MODE_PR_MASK                    (0x7000U)
#define ENET_DMA_MODE_PR_SHIFT                   (12U)
/*! PR - Priority Ratio
 *  0b000..The priority ratio is 1:1
 *  0b001..The priority ratio is 2:1
 *  0b010..The priority ratio is 3:1
 *  0b011..The priority ratio is 4:1
 *  0b100..The priority ratio is 5:1
 *  0b101..The priority ratio is 6:1
 *  0b110..The priority ratio is 7:1
 *  0b111..The priority ratio is 8:1
 */
#define ENET_DMA_MODE_PR(x)                      (((uint32_t)(((uint32_t)(x)) << ENET_DMA_MODE_PR_SHIFT)) & ENET_DMA_MODE_PR_MASK)
/*! @} */

/*! @name DMA_SYSBUS_MODE - DMA System Bus Mode */
/*! @{ */

#define ENET_DMA_SYSBUS_MODE_FB_MASK             (0x1U)
#define ENET_DMA_SYSBUS_MODE_FB_SHIFT            (0U)
/*! FB - Fixed Burst Length
 *  0b0..Fixed Burst Length is disabled
 *  0b1..Fixed Burst Length is enabled
 */
#define ENET_DMA_SYSBUS_MODE_FB(x)               (((uint32_t)(((uint32_t)(x)) << ENET_DMA_SYSBUS_MODE_FB_SHIFT)) & ENET_DMA_SYSBUS_MODE_FB_MASK)

#define ENET_DMA_SYSBUS_MODE_AAL_MASK            (0x1000U)
#define ENET_DMA_SYSBUS_MODE_AAL_SHIFT           (12U)
/*! AAL - Address-Aligned Beats
 *  0b0..Address-Aligned Beats is disabled
 *  0b1..Address-Aligned Beats is enabled
 */
#define ENET_DMA_SYSBUS_MODE_AAL(x)              (((uint32_t)(((uint32_t)(x)) << ENET_DMA_SYSBUS_MODE_AAL_SHIFT)) & ENET_DMA_SYSBUS_MODE_AAL_MASK)

#define ENET_DMA_SYSBUS_MODE_MB_MASK             (0x4000U)
#define ENET_DMA_SYSBUS_MODE_MB_SHIFT            (14U)
/*! MB - Mixed Burst
 *  0b0..Mixed Burst is disabled
 *  0b1..Mixed Burst is enabled
 */
#define ENET_DMA_SYSBUS_MODE_MB(x)               (((uint32_t)(((uint32_t)(x)) << ENET_DMA_SYSBUS_MODE_MB_SHIFT)) & ENET_DMA_SYSBUS_MODE_MB_MASK)

#define ENET_DMA_SYSBUS_MODE_RB_MASK             (0x8000U)
#define ENET_DMA_SYSBUS_MODE_RB_SHIFT            (15U)
/*! RB - Rebuild INCRx Burst
 *  0b0..Rebuild INCRx Burst is disabled
 *  0b1..Rebuild INCRx Burst is enabled
 */
#define ENET_DMA_SYSBUS_MODE_RB(x)               (((uint32_t)(((uint32_t)(x)) << ENET_DMA_SYSBUS_MODE_RB_SHIFT)) & ENET_DMA_SYSBUS_MODE_RB_MASK)
/*! @} */

/*! @name DMA_INTERRUPT_STATUS - DMA Interrupt Status */
/*! @{ */

#define ENET_DMA_INTERRUPT_STATUS_DC0IS_MASK     (0x1U)
#define ENET_DMA_INTERRUPT_STATUS_DC0IS_SHIFT    (0U)
/*! DC0IS - DMA Channel 0 Interrupt Status
 *  0b1..DMA Channel 0 Interrupt Status detected
 *  0b0..DMA Channel 0 Interrupt Status not detected
 */
#define ENET_DMA_INTERRUPT_STATUS_DC0IS(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_INTERRUPT_STATUS_DC0IS_SHIFT)) & ENET_DMA_INTERRUPT_STATUS_DC0IS_MASK)

#define ENET_DMA_INTERRUPT_STATUS_DC1IS_MASK     (0x2U)
#define ENET_DMA_INTERRUPT_STATUS_DC1IS_SHIFT    (1U)
/*! DC1IS - DMA Channel 1 Interrupt Status
 *  0b1..DMA Channel 1 Interrupt Status detected
 *  0b0..DMA Channel 1 Interrupt Status not detected
 */
#define ENET_DMA_INTERRUPT_STATUS_DC1IS(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_INTERRUPT_STATUS_DC1IS_SHIFT)) & ENET_DMA_INTERRUPT_STATUS_DC1IS_MASK)

#define ENET_DMA_INTERRUPT_STATUS_MTLIS_MASK     (0x10000U)
#define ENET_DMA_INTERRUPT_STATUS_MTLIS_SHIFT    (16U)
/*! MTLIS - MTL Interrupt Status
 *  0b1..MTL Interrupt Status detected
 *  0b0..MTL Interrupt Status not detected
 */
#define ENET_DMA_INTERRUPT_STATUS_MTLIS(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_INTERRUPT_STATUS_MTLIS_SHIFT)) & ENET_DMA_INTERRUPT_STATUS_MTLIS_MASK)

#define ENET_DMA_INTERRUPT_STATUS_MACIS_MASK     (0x20000U)
#define ENET_DMA_INTERRUPT_STATUS_MACIS_SHIFT    (17U)
/*! MACIS - MAC Interrupt Status
 *  0b1..MAC Interrupt Status detected
 *  0b0..MAC Interrupt Status not detected
 */
#define ENET_DMA_INTERRUPT_STATUS_MACIS(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_INTERRUPT_STATUS_MACIS_SHIFT)) & ENET_DMA_INTERRUPT_STATUS_MACIS_MASK)
/*! @} */

/*! @name DMA_DEBUG_STATUS0 - DMA Debug Status 0 */
/*! @{ */

#define ENET_DMA_DEBUG_STATUS0_AXWHSTS_MASK      (0x1U)
#define ENET_DMA_DEBUG_STATUS0_AXWHSTS_SHIFT     (0U)
/*! AXWHSTS - AHB Master Status
 *  0b1..AXI Master Write Channel or AHB Master Status detected
 *  0b0..AXI Master Write Channel or AHB Master Status not detected
 */
#define ENET_DMA_DEBUG_STATUS0_AXWHSTS(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_DEBUG_STATUS0_AXWHSTS_SHIFT)) & ENET_DMA_DEBUG_STATUS0_AXWHSTS_MASK)

#define ENET_DMA_DEBUG_STATUS0_RPS0_MASK         (0xF00U)
#define ENET_DMA_DEBUG_STATUS0_RPS0_SHIFT        (8U)
/*! RPS0 - DMA Channel 0 Receive Process State
 *  0b0010..Reserved for future use
 *  0b0101..Running (Closing the Rx Descriptor)
 *  0b0001..Running (Fetching Rx Transfer Descriptor)
 *  0b0111..Running (Transferring the received packet data from the Rx buffer to the system memory)
 *  0b0011..Running (Waiting for Rx packet)
 *  0b0000..Stopped (Reset or Stop Receive Command issued)
 *  0b0100..Suspended (Rx Descriptor Unavailable)
 *  0b0110..Timestamp write state
 */
#define ENET_DMA_DEBUG_STATUS0_RPS0(x)           (((uint32_t)(((uint32_t)(x)) << ENET_DMA_DEBUG_STATUS0_RPS0_SHIFT)) & ENET_DMA_DEBUG_STATUS0_RPS0_MASK)

#define ENET_DMA_DEBUG_STATUS0_TPS0_MASK         (0xF000U)
#define ENET_DMA_DEBUG_STATUS0_TPS0_SHIFT        (12U)
/*! TPS0 - DMA Channel 0 Transmit Process State
 *  0b0101..Reserved for future use
 *  0b0111..Running (Closing Tx Descriptor)
 *  0b0001..Running (Fetching Tx Transfer Descriptor)
 *  0b0011..Running (Reading Data from system memory buffer and queuing it to the Tx buffer (Tx FIFO))
 *  0b0010..Running (Waiting for status)
 *  0b0000..Stopped (Reset or Stop Transmit Command issued)
 *  0b0110..Suspended (Tx Descriptor Unavailable or Tx Buffer Underflow)
 *  0b0100..Timestamp write state
 */
#define ENET_DMA_DEBUG_STATUS0_TPS0(x)           (((uint32_t)(((uint32_t)(x)) << ENET_DMA_DEBUG_STATUS0_TPS0_SHIFT)) & ENET_DMA_DEBUG_STATUS0_TPS0_MASK)

#define ENET_DMA_DEBUG_STATUS0_RPS1_MASK         (0xF0000U)
#define ENET_DMA_DEBUG_STATUS0_RPS1_SHIFT        (16U)
/*! RPS1 - DMA Channel 1 Receive Process State
 *  0b0010..Reserved for future use
 *  0b0101..Running (Closing the Rx Descriptor)
 *  0b0001..Running (Fetching Rx Transfer Descriptor)
 *  0b0111..Running (Transferring the received packet data from the Rx buffer to the system memory)
 *  0b0011..Running (Waiting for Rx packet)
 *  0b0000..Stopped (Reset or Stop Receive Command issued)
 *  0b0100..Suspended (Rx Descriptor Unavailable)
 *  0b0110..Timestamp write state
 */
#define ENET_DMA_DEBUG_STATUS0_RPS1(x)           (((uint32_t)(((uint32_t)(x)) << ENET_DMA_DEBUG_STATUS0_RPS1_SHIFT)) & ENET_DMA_DEBUG_STATUS0_RPS1_MASK)

#define ENET_DMA_DEBUG_STATUS0_TPS1_MASK         (0xF00000U)
#define ENET_DMA_DEBUG_STATUS0_TPS1_SHIFT        (20U)
/*! TPS1 - DMA Channel 1 Transmit Process State
 *  0b0101..Reserved for future use
 *  0b0111..Running (Closing Tx Descriptor)
 *  0b0001..Running (Fetching Tx Transfer Descriptor)
 *  0b0011..Running (Reading Data from system memory buffer and queuing it to the Tx buffer (Tx FIFO))
 *  0b0010..Running (Waiting for status)
 *  0b0000..Stopped (Reset or Stop Transmit Command issued)
 *  0b0110..Suspended (Tx Descriptor Unavailable or Tx Buffer Underflow)
 *  0b0100..Timestamp write state
 */
#define ENET_DMA_DEBUG_STATUS0_TPS1(x)           (((uint32_t)(((uint32_t)(x)) << ENET_DMA_DEBUG_STATUS0_TPS1_SHIFT)) & ENET_DMA_DEBUG_STATUS0_TPS1_MASK)
/*! @} */

/*! @name DMA_CH_DMA_CHX_CTRL - DMA Channel 0 Control..DMA Channel 1 Control */
/*! @{ */

#define ENET_DMA_CH_DMA_CHX_CTRL_PBLx8_MASK      (0x10000U)
#define ENET_DMA_CH_DMA_CHX_CTRL_PBLx8_SHIFT     (16U)
/*! PBLx8 - 8xPBL mode
 *  0b0..8xPBL mode is disabled
 *  0b1..8xPBL mode is enabled
 */
#define ENET_DMA_CH_DMA_CHX_CTRL_PBLx8(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_CTRL_PBLx8_SHIFT)) & ENET_DMA_CH_DMA_CHX_CTRL_PBLx8_MASK)

#define ENET_DMA_CH_DMA_CHX_CTRL_DSL_MASK        (0x1C0000U)
#define ENET_DMA_CH_DMA_CHX_CTRL_DSL_SHIFT       (18U)
/*! DSL - Descriptor Skip Length */
#define ENET_DMA_CH_DMA_CHX_CTRL_DSL(x)          (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_CTRL_DSL_SHIFT)) & ENET_DMA_CH_DMA_CHX_CTRL_DSL_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_CTRL */
#define ENET_DMA_CH_DMA_CHX_CTRL_COUNT           (2U)

/*! @name DMA_CH_DMA_CHX_TX_CTRL - DMA Channel 0 Transmit Control..DMA Channel 1 Transmit Control */
/*! @{ */

#define ENET_DMA_CH_DMA_CHX_TX_CTRL_ST_MASK      (0x1U)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_ST_SHIFT     (0U)
/*! ST - Start or Stop Transmission Command
 *  0b1..Start Transmission Command
 *  0b0..Stop Transmission Command
 */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_ST(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TX_CTRL_ST_SHIFT)) & ENET_DMA_CH_DMA_CHX_TX_CTRL_ST_MASK)

#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TCW_MASK     (0xEU)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TCW_SHIFT    (1U)
/*! TCW - Transmit Channel Weight */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TCW(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TX_CTRL_TCW_SHIFT)) & ENET_DMA_CH_DMA_CHX_TX_CTRL_TCW_MASK)

#define ENET_DMA_CH_DMA_CHX_TX_CTRL_OSF_MASK     (0x10U)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_OSF_SHIFT    (4U)
/*! OSF - Operate on Second Packet
 *  0b0..Operate on Second Packet disabled
 *  0b1..Operate on Second Packet enabled
 */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_OSF(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TX_CTRL_OSF_SHIFT)) & ENET_DMA_CH_DMA_CHX_TX_CTRL_OSF_MASK)

#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TxPBL_MASK   (0x3F0000U)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TxPBL_SHIFT  (16U)
/*! TxPBL - Transmit Programmable Burst Length */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_TxPBL(x)     (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TX_CTRL_TxPBL_SHIFT)) & ENET_DMA_CH_DMA_CHX_TX_CTRL_TxPBL_MASK)

#define ENET_DMA_CH_DMA_CHX_TX_CTRL_ETIC_MASK    (0x400000U)
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_ETIC_SHIFT   (22U)
/*! ETIC - Early Transmit Interrupt Control
 *  0b0..Early Transmit Interrupt is disabled
 *  0b1..Early Transmit Interrupt is enabled
 */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_ETIC(x)      (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TX_CTRL_ETIC_SHIFT)) & ENET_DMA_CH_DMA_CHX_TX_CTRL_ETIC_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_TX_CTRL */
#define ENET_DMA_CH_DMA_CHX_TX_CTRL_COUNT        (2U)

/*! @name DMA_CH_DMA_CHX_RX_CTRL - DMA Channel 0 Receive Control..DMA Channel 1 Receive Control */
/*! @{ */

#define ENET_DMA_CH_DMA_CHX_RX_CTRL_SR_MASK      (0x1U)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_SR_SHIFT     (0U)
/*! SR - Start or Stop Receive
 *  0b1..Start Receive
 *  0b0..Stop Receive
 */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_SR(x)        (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CTRL_SR_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CTRL_SR_MASK)

#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_X_0_MASK (0x6U)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_X_0_SHIFT (1U)
/*! RBSZ_X_0 - Receive Buffer size Low */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_X_0(x)  (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_X_0_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_X_0_MASK)

#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_13_Y_MASK (0x7FF8U)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_13_Y_SHIFT (3U)
/*! RBSZ_13_Y - Receive Buffer size High */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_13_Y(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_13_Y_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CTRL_RBSZ_13_Y_MASK)

#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RxPBL_MASK   (0x3F0000U)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RxPBL_SHIFT  (16U)
/*! RxPBL - Receive Programmable Burst Length */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RxPBL(x)     (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CTRL_RxPBL_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CTRL_RxPBL_MASK)

#define ENET_DMA_CH_DMA_CHX_RX_CTRL_ERIC_MASK    (0x400000U)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_ERIC_SHIFT   (22U)
/*! ERIC - Early Receive Interrupt Control
 *  0b0..Early Receive Interrupt is disabled
 *  0b1..Early Receive Interrupt is enabled
 */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_ERIC(x)      (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CTRL_ERIC_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CTRL_ERIC_MASK)

#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RPF_MASK     (0x80000000U)
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RPF_SHIFT    (31U)
/*! RPF - Rx Packet Flush.
 *  0b0..Rx Packet Flush is disabled
 *  0b1..Rx Packet Flush is enabled
 */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_RPF(x)       (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CTRL_RPF_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CTRL_RPF_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_RX_CTRL */
#define ENET_DMA_CH_DMA_CHX_RX_CTRL_COUNT        (2U)

/*! @name DMA_CH_DMA_CHX_TXDESC_LIST_ADDR - Channel 0 Tx Descriptor List Address register..Channel 1 Tx Descriptor List Address */
/*! @{ */

#define ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_TDESLA_MASK (0xFFFFFFFCU)
#define ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_TDESLA_SHIFT (2U)
/*! TDESLA - Start of Transmit List */
#define ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_TDESLA(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_TDESLA_SHIFT)) & ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_TDESLA_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR */
#define ENET_DMA_CH_DMA_CHX_TXDESC_LIST_ADDR_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_RXDESC_LIST_ADDR - Channel 0 Rx Descriptor List Address register..Channel 1 Rx Descriptor List Address */
/*! @{ */

#define ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_RDESLA_MASK (0xFFFFFFFCU)
#define ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_RDESLA_SHIFT (2U)
/*! RDESLA - Start of Receive List */
#define ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_RDESLA(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_RDESLA_SHIFT)) & ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_RDESLA_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR */
#define ENET_DMA_CH_DMA_CHX_RXDESC_LIST_ADDR_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_TXDESC_TAIL_PTR - Channel 0 Tx Descriptor Tail Pointer..Channel 1 Tx Descriptor Tail Pointer */
/*! @{ */

#define ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_TDTP_MASK (0xFFFFFFFCU)
#define ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_TDTP_SHIFT (2U)
/*! TDTP - Transmit Descriptor Tail Pointer */
#define ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_TDTP(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_TDTP_SHIFT)) & ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_TDTP_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR */
#define ENET_DMA_CH_DMA_CHX_TXDESC_TAIL_PTR_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_RXDESC_TAIL_PTR - Channel 0 Rx Descriptor Tail Pointer..Channel 1 Rx Descriptor Tail Pointer */
/*! @{ */

#define ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_RDTP_MASK (0xFFFFFFFCU)
#define ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_RDTP_SHIFT (2U)
/*! RDTP - Receive Descriptor Tail Pointer */
#define ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_RDTP(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_RDTP_SHIFT)) & ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_RDTP_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR */
#define ENET_DMA_CH_DMA_CHX_RXDESC_TAIL_PTR_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_TXDESC_RING_LENGTH - Channel 0 Tx Descriptor Ring Length..Channel 1 Tx Descriptor Ring Length */
/*! @{ */

#define ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_TDRL_MASK (0x3FFU)
#define ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_TDRL_SHIFT (0U)
/*! TDRL - Transmit Descriptor Ring Length */
#define ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_TDRL(x) (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_TDRL_SHIFT)) & ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_TDRL_MASK)
/*! @} */

/* The count of ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH */
#define ENET_DMA_CH_DMA_CHX_TXDESC_RING_LENGTH_COUNT (2U)

/*! @name DMA_CH_DMA_CHX_RX_CONTROL2 - Channeli Receive Control..DMA Channel 1 Receive Control */
/*! @{ */

#define ENET_DMA_CH_DMA_CHX_RX_CONTROL2_RDRL_MASK (0x3FFU)
#define ENET_DMA_CH_DMA_CHX_RX_CONTROL2_RDRL_SHIFT (0U)
/*! RDRL - Receive Descriptor Ring Length */
#define ENET_DMA_CH_DMA_CHX_RX_CONTROL2_RDRL(x)  (((uint32_t)(((uint32_t)(x)) << ENET_DMA_CH_DMA_CHX_RX_CONTROL2_RDRL_SHIFT)) & ENET_DMA_CH_DMA_CHX_RX_CONTROL2_RDRL_MASK)

#define ENET_DMA_CH_DMA_CHX_RX_CONTROL2_ARBS_MASK (0xFF0000U)
#define ENET_DMA_CH_DMA_CHX_RX_CONTROL2