%feature("docstring") OT::PointConditionalDistribution
"Distribution conditioned by a deterministic vector.

.. warning::
    This class is experimental and likely to be modified in future releases.
    To use it, import the ``openturns.experimental`` submodule.

Given a set of indices :math:`\\mathcal{I}`, a deterministic vector :math:`\\vect{x}_\\mathcal{I}` and a distribution :math:`L_\\theta(\\inputRV)`, we define the conditional distribution:

.. math::

    L_\\theta(\\inputRV_{\\bar{\\mathcal{I}}} | \\inputRV_\\mathcal{I} =\\inputReal_\\mathcal{I})

Parameters
----------
distribution : :class:`~openturns.Distribution`
    Distribution :math:`L_\\theta(\\inputRV)`
conditioningIndices : sequence of int
    Conditioning vector indices :math:`\\mathcal{I}`
conditioningValues : sequence of float
    Conditioning vector values :math:`\\vect{x}_\\mathcal{I}`

Notes
-----
Its probability density function is defined as:

.. math::

    \\dfrac{p_\\theta(\\inputReal_{\\bar{\\mathcal{I}}}, \\inputReal_{\\mathcal{I}})}{\\int p_\\theta(\\inputReal_{\\bar{\\mathcal{I}}}, \\inputReal_{\\mathcal{I}}') d \\inputReal_{\\mathcal{I}}'}

Examples
--------
>>> import openturns as ot
>>> import openturns.experimental as otexp
>>> indices = [1]
>>> values = [2.0]
>>> normal = ot.Normal(3)
>>> R = ot.CorrelationMatrix(3)
>>> R[1, 0] = R[2, 0] = R[2, 1] = 0.9
>>> normal.setR(R)
>>> distribution = otexp.PointConditionalDistribution(normal, indices, values)
>>> sample = distribution.getSample(2)"

// ----------------------------------------------------------------------------

%feature("docstring") OT::PointConditionalDistribution::getDistribution
"Underlying distribution accessor.

Returns
-------
distribution : :class:`~openturns.Distribution`
    Distribution :math:`L_\\theta(\\inputReal)`"

// ----------------------------------------------------------------------------

%feature("docstring") OT::PointConditionalDistribution::getConditioningIndices
"Conditioning vector indices accessor.

Returns
-------
conditioningIndices : :class:`~openturns.Indices`
    Conditioning vector indices :math:`\\mathcal{I}`"

// ----------------------------------------------------------------------------

%feature("docstring") OT::PointConditionalDistribution::getConditioningValues
"Conditioning vector values accessor.

Returns
-------
conditioningValues : :class:`~openturns.Point`
    Conditioning vector values :math:`\\vect{x}_\\mathcal{I}`"

// ----------------------------------------------------------------------------

%feature("docstring") OT::PointConditionalDistribution::getSimplifiedVersion
"Simplified distribution accessor.

Returns
-------
simplified : :class:`~openturns.Distribution`
    Simplified distribution when an analytical simplification is available."

// ---------------------------------------------------------------------

%feature("docstring") OT::PointConditionalDistribution::getIntegrationAlgorithm
"Accessor to the integration algorithm used to compute the CDF.

Returns
-------
algo : :class:`~openturns.IntegrationAlgorithm`
    Integration algorithm used to compute the CDF.
    Default value is :class:`openturns.experimental.CubaIntegration` if available or else :class:`openturns.SimplicialCubature`."

// ---------------------------------------------------------------------

%feature("docstring") OT::PointConditionalDistribution::setIntegrationAlgorithm
"Accessor to the integration algorithm used to compute the CDF.

Parameters
----------
algo : :class:`~openturns.IntegrationAlgorithm`
    Integration algorithm used to compute the CDF.
    Default value is :class:`openturns.experimental.CubaIntegration` if available or else :class:`openturns.SimplicialCubature`."
