#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesettype_ PETSCDUALSPACESETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesettype_ petscdualspacesettype
#endif
PETSC_EXTERN void petscdualspacesettype_(PetscDualSpace *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscDualSpaceSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegettype_ PETSCDUALSPACEGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegettype_ petscdualspacegettype
#endif
PETSC_EXTERN void petscdualspacegettype_(PetscDualSpace *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscDualSpaceGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspaceviewfromoptions_ PETSCDUALSPACEVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspaceviewfromoptions_ petscdualspaceviewfromoptions
#endif
PETSC_EXTERN void petscdualspaceviewfromoptions_(PetscDualSpace *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscDualSpaceViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspaceview_ PETSCDUALSPACEVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspaceview_ petscdualspaceview
#endif
PETSC_EXTERN void petscdualspaceview_(PetscDualSpace *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscDualSpaceView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesetfromoptions_ PETSCDUALSPACESETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesetfromoptions_ petscdualspacesetfromoptions
#endif
PETSC_EXTERN void petscdualspacesetfromoptions_(PetscDualSpace *a, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesetup_ PETSCDUALSPACESETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesetup_ petscdualspacesetup
#endif
PETSC_EXTERN void petscdualspacesetup_(PetscDualSpace *a, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacedestroy_ PETSCDUALSPACEDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacedestroy_ petscdualspacedestroy
#endif
PETSC_EXTERN void petscdualspacedestroy_(PetscDualSpace *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscDualSpaceDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacecreate_ PETSCDUALSPACECREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacecreate_ petscdualspacecreate
#endif
PETSC_EXTERN void petscdualspacecreate_(MPI_Fint *a, PetscDualSpace *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDualSpaceCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspaceduplicate_ PETSCDUALSPACEDUPLICATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspaceduplicate_ petscdualspaceduplicate
#endif
PETSC_EXTERN void petscdualspaceduplicate_(PetscDualSpace *a, PetscDualSpace *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDualSpaceDuplicate(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetdm_ PETSCDUALSPACEGETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetdm_ petscdualspacegetdm
#endif
PETSC_EXTERN void petscdualspacegetdm_(PetscDualSpace *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDualSpaceGetDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesetdm_ PETSCDUALSPACESETDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesetdm_ petscdualspacesetdm
#endif
PETSC_EXTERN void petscdualspacesetdm_(PetscDualSpace *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceSetDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetorder_ PETSCDUALSPACEGETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetorder_ petscdualspacegetorder
#endif
PETSC_EXTERN void petscdualspacegetorder_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDualSpaceGetOrder(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesetorder_ PETSCDUALSPACESETORDER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesetorder_ petscdualspacesetorder
#endif
PETSC_EXTERN void petscdualspacesetorder_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceSetOrder(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetnumcomponents_ PETSCDUALSPACEGETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetnumcomponents_ petscdualspacegetnumcomponents
#endif
PETSC_EXTERN void petscdualspacegetnumcomponents_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDualSpaceGetNumComponents(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesetnumcomponents_ PETSCDUALSPACESETNUMCOMPONENTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesetnumcomponents_ petscdualspacesetnumcomponents
#endif
PETSC_EXTERN void petscdualspacesetnumcomponents_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceSetNumComponents(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetfunctional_ PETSCDUALSPACEGETFUNCTIONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetfunctional_ petscdualspacegetfunctional
#endif
PETSC_EXTERN void petscdualspacegetfunctional_(PetscDualSpace *a, PetscInt *b, PetscQuadrature *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDualSpaceGetFunctional(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetdimension_ PETSCDUALSPACEGETDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetdimension_ petscdualspacegetdimension
#endif
PETSC_EXTERN void petscdualspacegetdimension_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDualSpaceGetDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetinteriordimension_ PETSCDUALSPACEGETINTERIORDIMENSION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetinteriordimension_ petscdualspacegetinteriordimension
#endif
PETSC_EXTERN void petscdualspacegetinteriordimension_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDualSpaceGetInteriorDimension(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetuniform_ PETSCDUALSPACEGETUNIFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetuniform_ petscdualspacegetuniform
#endif
PETSC_EXTERN void petscdualspacegetuniform_(PetscDualSpace *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PetscDualSpaceGetUniform(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetsection_ PETSCDUALSPACEGETSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetsection_ petscdualspacegetsection
#endif
PETSC_EXTERN void petscdualspacegetsection_(PetscDualSpace *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDualSpaceGetSection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetinteriorsection_ PETSCDUALSPACEGETINTERIORSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetinteriorsection_ petscdualspacegetinteriorsection
#endif
PETSC_EXTERN void petscdualspacegetinteriorsection_(PetscDualSpace *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscDualSpaceGetInteriorSection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspaceapplyall_ PETSCDUALSPACEAPPLYALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspaceapplyall_ petscdualspaceapplyall
#endif
PETSC_EXTERN void petscdualspaceapplyall_(PetscDualSpace *a, const PetscScalar *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  CHKFORTRANNULLSCALAR(c);
  *ierr = PetscDualSpaceApplyAll(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspaceapplyinterior_ PETSCDUALSPACEAPPLYINTERIOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspaceapplyinterior_ petscdualspaceapplyinterior
#endif
PETSC_EXTERN void petscdualspaceapplyinterior_(PetscDualSpace *a, const PetscScalar *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  CHKFORTRANNULLSCALAR(c);
  *ierr = PetscDualSpaceApplyInterior(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspaceapplyalldefault_ PETSCDUALSPACEAPPLYALLDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspaceapplyalldefault_ petscdualspaceapplyalldefault
#endif
PETSC_EXTERN void petscdualspaceapplyalldefault_(PetscDualSpace *a, const PetscScalar *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  CHKFORTRANNULLSCALAR(c);
  *ierr = PetscDualSpaceApplyAllDefault(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspaceapplyinteriordefault_ PETSCDUALSPACEAPPLYINTERIORDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspaceapplyinteriordefault_ petscdualspaceapplyinteriordefault
#endif
PETSC_EXTERN void petscdualspaceapplyinteriordefault_(PetscDualSpace *a, const PetscScalar *b, PetscScalar *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  CHKFORTRANNULLSCALAR(c);
  *ierr = PetscDualSpaceApplyInteriorDefault(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetalldata_ PETSCDUALSPACEGETALLDATA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetalldata_ petscdualspacegetalldata
#endif
PETSC_EXTERN void petscdualspacegetalldata_(PetscDualSpace *a, PetscQuadrature *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDualSpaceGetAllData(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacecreatealldatadefault_ PETSCDUALSPACECREATEALLDATADEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacecreatealldatadefault_ petscdualspacecreatealldatadefault
#endif
PETSC_EXTERN void petscdualspacecreatealldatadefault_(PetscDualSpace *a, PetscQuadrature *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDualSpaceCreateAllDataDefault(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetinteriordata_ PETSCDUALSPACEGETINTERIORDATA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetinteriordata_ petscdualspacegetinteriordata
#endif
PETSC_EXTERN void petscdualspacegetinteriordata_(PetscDualSpace *a, PetscQuadrature *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDualSpaceGetInteriorData(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacecreateinteriordatadefault_ PETSCDUALSPACECREATEINTERIORDATADEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacecreateinteriordatadefault_ petscdualspacecreateinteriordatadefault
#endif
PETSC_EXTERN void petscdualspacecreateinteriordatadefault_(PetscDualSpace *a, PetscQuadrature *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDualSpaceCreateInteriorDataDefault(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspaceequal_ PETSCDUALSPACEEQUAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspaceequal_ petscdualspaceequal
#endif
PETSC_EXTERN void petscdualspaceequal_(PetscDualSpace *a, PetscDualSpace *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscDualSpaceEqual(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetheightsubspace_ PETSCDUALSPACEGETHEIGHTSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetheightsubspace_ petscdualspacegetheightsubspace
#endif
PETSC_EXTERN void petscdualspacegetheightsubspace_(PetscDualSpace *a, PetscInt *b, PetscDualSpace *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDualSpaceGetHeightSubspace(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetpointsubspace_ PETSCDUALSPACEGETPOINTSUBSPACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetpointsubspace_ petscdualspacegetpointsubspace
#endif
PETSC_EXTERN void petscdualspacegetpointsubspace_(PetscDualSpace *a, PetscInt *b, PetscDualSpace *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscDualSpaceGetPointSubspace(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetformdegree_ PETSCDUALSPACEGETFORMDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetformdegree_ petscdualspacegetformdegree
#endif
PETSC_EXTERN void petscdualspacegetformdegree_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDualSpaceGetFormDegree(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacesetformdegree_ PETSCDUALSPACESETFORMDEGREE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacesetformdegree_ petscdualspacesetformdegree
#endif
PETSC_EXTERN void petscdualspacesetformdegree_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscDualSpaceSetFormDegree(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdualspace.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacegetderahm_ PETSCDUALSPACEGETDERAHM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacegetderahm_ petscdualspacegetderahm
#endif
PETSC_EXTERN void petscdualspacegetderahm_(PetscDualSpace *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscDualSpaceGetDeRahm(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacetransform_ PETSCDUALSPACETRANSFORM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacetransform_ petscdualspacetransform
#endif
PETSC_EXTERN void petscdualspacetransform_(PetscDualSpace *a, PetscDualSpaceTransformType *b, PetscBool *c, PetscFEGeom *d, PetscInt *e, PetscInt *f, PetscScalar g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(g);
  *ierr = PetscDualSpaceTransform(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, d, *e, *f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacetransformgradient_ PETSCDUALSPACETRANSFORMGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacetransformgradient_ petscdualspacetransformgradient
#endif
PETSC_EXTERN void petscdualspacetransformgradient_(PetscDualSpace *a, PetscDualSpaceTransformType *b, PetscBool *c, PetscFEGeom *d, PetscInt *e, PetscInt *f, PetscScalar g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(g);
  *ierr = PetscDualSpaceTransformGradient(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, d, *e, *f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacetransformhessian_ PETSCDUALSPACETRANSFORMHESSIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacetransformhessian_ petscdualspacetransformhessian
#endif
PETSC_EXTERN void petscdualspacetransformhessian_(PetscDualSpace *a, PetscDualSpaceTransformType *b, PetscBool *c, PetscFEGeom *d, PetscInt *e, PetscInt *f, PetscScalar g[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(g);
  *ierr = PetscDualSpaceTransformHessian(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, d, *e, *f, g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacepullback_ PETSCDUALSPACEPULLBACK
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacepullback_ petscdualspacepullback
#endif
PETSC_EXTERN void petscdualspacepullback_(PetscDualSpace *a, PetscFEGeom *b, PetscInt *c, PetscInt *d, PetscScalar e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(e);
  *ierr = PetscDualSpacePullback(*a, b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacepushforward_ PETSCDUALSPACEPUSHFORWARD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacepushforward_ petscdualspacepushforward
#endif
PETSC_EXTERN void petscdualspacepushforward_(PetscDualSpace *a, PetscFEGeom *b, PetscInt *c, PetscInt *d, PetscScalar e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(e);
  *ierr = PetscDualSpacePushforward(*a, b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacepushforwardgradient_ PETSCDUALSPACEPUSHFORWARDGRADIENT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacepushforwardgradient_ petscdualspacepushforwardgradient
#endif
PETSC_EXTERN void petscdualspacepushforwardgradient_(PetscDualSpace *a, PetscFEGeom *b, PetscInt *c, PetscInt *d, PetscScalar e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(e);
  *ierr = PetscDualSpacePushforwardGradient(*a, b, *c, *d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscfe.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscdualspacepushforwardhessian_ PETSCDUALSPACEPUSHFORWARDHESSIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscdualspacepushforwardhessian_ petscdualspacepushforwardhessian
#endif
PETSC_EXTERN void petscdualspacepushforwardhessian_(PetscDualSpace *a, PetscFEGeom *b, PetscInt *c, PetscInt *d, PetscScalar e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(e);
  *ierr = PetscDualSpacePushforwardHessian(*a, b, *c, *d, e);
  if (*ierr) return;
}
