#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsfsetgraphlayout_ PETSCSFSETGRAPHLAYOUT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsfsetgraphlayout_ petscsfsetgraphlayout
#endif
PETSC_EXTERN void petscsfsetgraphlayout_(PetscSF *a, PetscLayout *b, PetscInt *c, PetscInt *d, PetscCopyMode *e, const PetscInt *f, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(f);
  *ierr = PetscSFSetGraphLayout(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsfsetgraphsection_ PETSCSFSETGRAPHSECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsfsetgraphsection_ petscsfsetgraphsection
#endif
PETSC_EXTERN void petscsfsetgraphsection_(PetscSF *a, PetscSection *b, PetscSection *c, PetscErrorCode *ierr)
{
  *ierr = PetscSFSetGraphSection(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsfcreatesectionsf_ PETSCSFCREATESECTIONSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsfcreatesectionsf_ petscsfcreatesectionsf
#endif
PETSC_EXTERN void petscsfcreatesectionsf_(PetscSF *a, PetscSection *b, PetscInt c[], PetscSection *d, PetscSF *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscSFCreateSectionSF(*a, *b, c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsfcreatefromlayouts_ PETSCSFCREATEFROMLAYOUTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsfcreatefromlayouts_ petscsfcreatefromlayouts
#endif
PETSC_EXTERN void petscsfcreatefromlayouts_(PetscLayout *a, PetscLayout *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSFCreateFromLayouts(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsfcreatebymatchingindices_ PETSCSFCREATEBYMATCHINGINDICES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsfcreatebymatchingindices_ petscsfcreatebymatchingindices
#endif
PETSC_EXTERN void petscsfcreatebymatchingindices_(PetscLayout *a, PetscInt *b, const PetscInt *c, const PetscInt *d, PetscInt *e, PetscInt *f, const PetscInt *g, const PetscInt *h, PetscInt *i, PetscSF *j, PetscSF *k, PetscErrorCode *ierr)
{
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_k = !*(void**) k ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLOBJECT(j);
  CHKFORTRANNULLOBJECT(k);
  *ierr = PetscSFCreateByMatchingIndices(*a, *b, c, d, *e, *f, g, h, *i, j, k);
  if (*ierr) return;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
  if (! null_k && !*(void**) k) *(void **) k = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsfmerge_ PETSCSFMERGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsfmerge_ petscsfmerge
#endif
PETSC_EXTERN void petscsfmerge_(PetscSF *a, PetscSF *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscSFMerge(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscsf.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsfcreatestridedsf_ PETSCSFCREATESTRIDEDSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsfcreatestridedsf_ petscsfcreatestridedsf
#endif
PETSC_EXTERN void petscsfcreatestridedsf_(PetscSF *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscSF *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(e);
  *ierr = PetscSFCreateStridedSF(*a, *b, *c, *d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
