#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatebaijmkl_ MATCREATEBAIJMKL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatebaijmkl_ matcreatebaijmkl
#endif
PETSC_EXTERN void matcreatebaijmkl_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, const PetscInt h[], PetscInt *i, const PetscInt j[], Mat *k, PetscErrorCode *ierr)
{
  PetscBool null_k = !*(void**) k ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLINTEGER(j);
  CHKFORTRANNULLOBJECT(k);
  *ierr = MatCreateBAIJMKL(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, *g, h, *i, j, k);
  if (*ierr) return;
  if (! null_k && !*(void**) k) *(void **) k = (void *)-2;
}
