#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorlgctxnetworkdestroy_ TSMONITORLGCTXNETWORKDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorlgctxnetworkdestroy_ tsmonitorlgctxnetworkdestroy
#endif
PETSC_EXTERN void tsmonitorlgctxnetworkdestroy_(TSMonitorLGCtxNetwork *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSMonitorLGCtxNetworkDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorlgctxnetworkcreate_ TSMONITORLGCTXNETWORKCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorlgctxnetworkcreate_ tsmonitorlgctxnetworkcreate
#endif
PETSC_EXTERN void tsmonitorlgctxnetworkcreate_(TS *a, char b[], char c[], int *d, int *e, int *f, int *g, PetscInt *h, TSMonitorLGCtxNetwork *i, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  PetscBool null_i = !*(void**) i ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(i);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  CHKFORTRANNULLOBJECT(i);
  *ierr = TSMonitorLGCtxNetworkCreate(*a, c_b, c_c, *d, *e, *f, *g, *h, i);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
  if (! null_i && !*(void**) i) *(void **) i = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsmonitorlgctxnetworksolution_ TSMONITORLGCTXNETWORKSOLUTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsmonitorlgctxnetworksolution_ tsmonitorlgctxnetworksolution
#endif
PETSC_EXTERN void tsmonitorlgctxnetworksolution_(TS *a, PetscInt *b, PetscReal *c, Vec *d, void *e, PetscErrorCode *ierr)
{
  *ierr = TSMonitorLGCtxNetworkSolution(*a, *b, *c, *d, e);
  if (*ierr) return;
}
