#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpibaijsetpreallocationcsr_ MATMPIBAIJSETPREALLOCATIONCSR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpibaijsetpreallocationcsr_ matmpibaijsetpreallocationcsr
#endif
PETSC_EXTERN void matmpibaijsetpreallocationcsr_(Mat *a, PetscInt *b, const PetscInt c[], const PetscInt d[], const PetscScalar e[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLSCALAR(e);
  *ierr = MatMPIBAIJSetPreallocationCSR(*a, *b, c, d, e);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpibaijsetpreallocation_ MATMPIBAIJSETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpibaijsetpreallocation_ matmpibaijsetpreallocation
#endif
PETSC_EXTERN void matmpibaijsetpreallocation_(Mat *a, PetscInt *b, PetscInt *c, const PetscInt d[], PetscInt *e, const PetscInt f[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(f);
  *ierr = MatMPIBAIJSetPreallocation(*a, *b, *c, d, *e, f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatebaij_ MATCREATEBAIJ
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatebaij_ matcreatebaij
#endif
PETSC_EXTERN void matcreatebaij_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, PetscInt *g, const PetscInt h[], PetscInt *i, const PetscInt j[], Mat *k, PetscErrorCode *ierr)
{
  PetscBool null_k = !*(void**) k ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLINTEGER(j);
  CHKFORTRANNULLOBJECT(k);
  *ierr = MatCreateBAIJ(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, *g, h, *i, j, k);
  if (*ierr) return;
  if (! null_k && !*(void**) k) *(void **) k = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpibaijsethashtablefactor_ MATMPIBAIJSETHASHTABLEFACTOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpibaijsethashtablefactor_ matmpibaijsethashtablefactor
#endif
PETSC_EXTERN void matmpibaijsethashtablefactor_(Mat *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = MatMPIBAIJSetHashTableFactor(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatempibaijwitharrays_ MATCREATEMPIBAIJWITHARRAYS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatempibaijwitharrays_ matcreatempibaijwitharrays
#endif
PETSC_EXTERN void matcreatempibaijwitharrays_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, const PetscInt g[], const PetscInt h[], const PetscScalar i[], Mat *j, PetscErrorCode *ierr)
{
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(h);
  CHKFORTRANNULLSCALAR(i);
  CHKFORTRANNULLOBJECT(j);
  *ierr = MatCreateMPIBAIJWithArrays(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, g, h, i, j);
  if (*ierr) return;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
}
