#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetvi_ DMSETVI
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetvi_ dmsetvi
#endif
PETSC_EXTERN void dmsetvi_(DM *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = DMSetVI(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdestroyvi_ DMDESTROYVI
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdestroyvi_ dmdestroyvi
#endif
PETSC_EXTERN void dmdestroyvi_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMDestroyVI(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsnes.h>
#include <petscsnes.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define snesvigetinactiveset_ SNESVIGETINACTIVESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define snesvigetinactiveset_ snesvigetinactiveset
#endif
PETSC_EXTERN void snesvigetinactiveset_(SNES *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = SNESVIGetInactiveSet(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
