#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateexodus_ DMPLEXCREATEEXODUS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateexodus_ dmplexcreateexodus
#endif
PETSC_EXTERN void dmplexcreateexodus_(MPI_Fint *a, PetscExodusIIInt *b, PetscBool *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreateExodus(MPI_Comm_f2c(*(a)), *b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiisetzonalvariable_ PETSCVIEWEREXODUSIISETZONALVARIABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiisetzonalvariable_ petscviewerexodusiisetzonalvariable
#endif
PETSC_EXTERN void petscviewerexodusiisetzonalvariable_(PetscViewer *a, PetscExodusIIInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIISetZonalVariable(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiisetnodalvariable_ PETSCVIEWEREXODUSIISETNODALVARIABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiisetnodalvariable_ petscviewerexodusiisetnodalvariable
#endif
PETSC_EXTERN void petscviewerexodusiisetnodalvariable_(PetscViewer *a, PetscExodusIIInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIISetNodalVariable(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiigetzonalvariable_ PETSCVIEWEREXODUSIIGETZONALVARIABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiigetzonalvariable_ petscviewerexodusiigetzonalvariable
#endif
PETSC_EXTERN void petscviewerexodusiigetzonalvariable_(PetscViewer *a, PetscExodusIIInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIIGetZonalVariable(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiigetnodalvariable_ PETSCVIEWEREXODUSIIGETNODALVARIABLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiigetnodalvariable_ petscviewerexodusiigetnodalvariable
#endif
PETSC_EXTERN void petscviewerexodusiigetnodalvariable_(PetscViewer *a, PetscExodusIIInt *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIIGetNodalVariable(v_a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiisetzonalvariablename_ PETSCVIEWEREXODUSIISETZONALVARIABLENAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiisetzonalvariablename_ petscviewerexodusiisetzonalvariablename
#endif
PETSC_EXTERN void petscviewerexodusiisetzonalvariablename_(PetscViewer *a, PetscExodusIIInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIISetZonalVariableName(v_a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiisetnodalvariablename_ PETSCVIEWEREXODUSIISETNODALVARIABLENAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiisetnodalvariablename_ petscviewerexodusiisetnodalvariablename
#endif
PETSC_EXTERN void petscviewerexodusiisetnodalvariablename_(PetscViewer *a, PetscExodusIIInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIISetNodalVariableName(v_a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiigetzonalvariablename_ PETSCVIEWEREXODUSIIGETZONALVARIABLENAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiigetzonalvariablename_ petscviewerexodusiigetzonalvariablename
#endif
PETSC_EXTERN void petscviewerexodusiigetzonalvariablename_(PetscViewer *a, PetscExodusIIInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIIGetZonalVariableName(v_a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiigetnodalvariablename_ PETSCVIEWEREXODUSIIGETNODALVARIABLENAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiigetnodalvariablename_ petscviewerexodusiigetnodalvariablename
#endif
PETSC_EXTERN void petscviewerexodusiigetnodalvariablename_(PetscViewer *a, PetscExodusIIInt *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c = PETSC_NULLPTR;
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIIGetNodalVariableName(v_a, *b, (const char **)&c_c);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)c, c_c, l_c);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiigetnodalvariableindex_ PETSCVIEWEREXODUSIIGETNODALVARIABLEINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiigetnodalvariableindex_ petscviewerexodusiigetnodalvariableindex
#endif
PETSC_EXTERN void petscviewerexodusiigetnodalvariableindex_(PetscViewer *a, char b[], PetscExodusIIInt *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIIGetNodalVariableIndex(v_a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscviewerexodusiigetzonalvariableindex_ PETSCVIEWEREXODUSIIGETZONALVARIABLEINDEX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscviewerexodusiigetzonalvariableindex_ petscviewerexodusiigetzonalvariableindex
#endif
PETSC_EXTERN void petscviewerexodusiigetzonalvariableindex_(PetscViewer *a, char b[], int *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscViewerExodusIIGetZonalVariableIndex(v_a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
