#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veckokkosplacearray_ VECKOKKOSPLACEARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veckokkosplacearray_ veckokkosplacearray
#endif
PETSC_EXTERN void veckokkosplacearray_(Vec *a, PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = VecKokkosPlaceArray(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veckokkosresetarray_ VECKOKKOSRESETARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veckokkosresetarray_ veckokkosresetarray
#endif
PETSC_EXTERN void veckokkosresetarray_(Vec *a, PetscErrorCode *ierr)
{
  *ierr = VecKokkosResetArray(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreateseqkokkoswitharray_ VECCREATESEQKOKKOSWITHARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreateseqkokkoswitharray_ veccreateseqkokkoswitharray
#endif
PETSC_EXTERN void veccreateseqkokkoswitharray_(MPI_Fint *a, PetscInt *b, PetscInt *c, const PetscScalar d[], Vec *e, PetscErrorCode *ierr)
{
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLSCALAR(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = VecCreateSeqKokkosWithArray(MPI_Comm_f2c(*(a)), *b, *c, d, e);
  if (*ierr) return;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscvec.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define veccreateseqkokkos_ VECCREATESEQKOKKOS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define veccreateseqkokkos_ veccreateseqkokkos
#endif
PETSC_EXTERN void veccreateseqkokkos_(MPI_Fint *a, PetscInt *b, Vec *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = VecCreateSeqKokkos(MPI_Comm_f2c(*(a)), *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
