#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscboxrefresh_ PETSCBOXREFRESH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscboxrefresh_ petscboxrefresh
#endif
PETSC_EXTERN void petscboxrefresh_(MPI_Fint *a, char b[], char c[], char d[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c, PETSC_FORTRAN_CHARLEN_T l_d)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscBoxRefresh(MPI_Comm_f2c(*(a)), c_b, c, d, l_d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
  FIXRETURNCHAR(PETSC_TRUE, d, l_d);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscboxupload_ PETSCBOXUPLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscboxupload_ petscboxupload
#endif
PETSC_EXTERN void petscboxupload_(MPI_Fint *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscBoxUpload(MPI_Comm_f2c(*(a)), c_b, c_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
