#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdacreateaggregates_ DMDACREATEAGGREGATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdacreateaggregates_ dmdacreateaggregates
#endif
PETSC_EXTERN void dmdacreateaggregates_(DM *a, DM *b, Mat *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMDACreateAggregates(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
