#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreateaijviennacl_ MATCREATEAIJVIENNACL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreateaijviennacl_ matcreateaijviennacl
#endif
PETSC_EXTERN void matcreateaijviennacl_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscInt *f, const PetscInt g[], PetscInt *h, const PetscInt i[], Mat *j, PetscErrorCode *ierr)
{
  PetscBool null_j = !*(void**) j ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLINTEGER(i);
  CHKFORTRANNULLOBJECT(j);
  *ierr = MatCreateAIJViennaCL(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, *f, g, *h, i, j);
  if (*ierr) return;
  if (! null_j && !*(void**) j) *(void **) j = (void *)-2;
}
