#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagregisterintarray_ PETSCBAGREGISTERINTARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagregisterintarray_ petscbagregisterintarray
#endif
PETSC_EXTERN void petscbagregisterintarray_(PetscBag *a, void *b, PetscInt *c, char d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscBagRegisterIntArray(*a, b, *c, c_d, c_e);
  if (*ierr) return;
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagregisterrealarray_ PETSCBAGREGISTERREALARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagregisterrealarray_ petscbagregisterrealarray
#endif
PETSC_EXTERN void petscbagregisterrealarray_(PetscBag *a, void *b, PetscInt *c, char d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscBagRegisterRealArray(*a, b, *c, c_d, c_e);
  if (*ierr) return;
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagregisterint_ PETSCBAGREGISTERINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagregisterint_ petscbagregisterint
#endif
PETSC_EXTERN void petscbagregisterint_(PetscBag *a, void *b, PetscInt *c, char d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscBagRegisterInt(*a, b, *c, c_d, c_e);
  if (*ierr) return;
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagregisterint64_ PETSCBAGREGISTERINT64
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagregisterint64_ petscbagregisterint64
#endif
PETSC_EXTERN void petscbagregisterint64_(PetscBag *a, void *b, PetscInt64 *c, char d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscBagRegisterInt64(*a, b, *c, c_d, c_e);
  if (*ierr) return;
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagregisterboolarray_ PETSCBAGREGISTERBOOLARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagregisterboolarray_ petscbagregisterboolarray
#endif
PETSC_EXTERN void petscbagregisterboolarray_(PetscBag *a, void *b, PetscInt *c, char d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscBagRegisterBoolArray(*a, b, *c, c_d, c_e);
  if (*ierr) return;
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagregisterreal_ PETSCBAGREGISTERREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagregisterreal_ petscbagregisterreal
#endif
PETSC_EXTERN void petscbagregisterreal_(PetscBag *a, void *b, PetscReal *c, char d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscBagRegisterReal(*a, b, *c, c_d, c_e);
  if (*ierr) return;
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagregisterscalar_ PETSCBAGREGISTERSCALAR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagregisterscalar_ petscbagregisterscalar
#endif
PETSC_EXTERN void petscbagregisterscalar_(PetscBag *a, void *b, PetscScalar *c, char d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscBagRegisterScalar(*a, b, *c, c_d, c_e);
  if (*ierr) return;
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagregisterbool_ PETSCBAGREGISTERBOOL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagregisterbool_ petscbagregisterbool
#endif
PETSC_EXTERN void petscbagregisterbool_(PetscBag *a, void *b, PetscBool *c, char d[], char e[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_d, PETSC_FORTRAN_CHARLEN_T l_e)
{
  char* c_d;
  FIXCHAR(d, l_d, c_d);
  char* c_e;
  FIXCHAR(e, l_e, c_e);
  *ierr = PetscBagRegisterBool(*a, b, *c ? PETSC_TRUE : PETSC_FALSE, c_d, c_e);
  if (*ierr) return;
  FREECHAR(d, c_d);
  FREECHAR(e, c_e);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagdestroy_ PETSCBAGDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagdestroy_ petscbagdestroy
#endif
PETSC_EXTERN void petscbagdestroy_(PetscBag *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscBagDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagsetfromoptions_ PETSCBAGSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagsetfromoptions_ petscbagsetfromoptions
#endif
PETSC_EXTERN void petscbagsetfromoptions_(PetscBag *a, PetscErrorCode *ierr)
{
  *ierr = PetscBagSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagview_ PETSCBAGVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagview_ petscbagview
#endif
PETSC_EXTERN void petscbagview_(PetscBag *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscBagView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagviewfromoptions_ PETSCBAGVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagviewfromoptions_ petscbagviewfromoptions
#endif
PETSC_EXTERN void petscbagviewfromoptions_(PetscBag *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscBagViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagload_ PETSCBAGLOAD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagload_ petscbagload
#endif
PETSC_EXTERN void petscbagload_(PetscViewer *a, PetscBag *b, PetscErrorCode *ierr)
{
  PetscViewer v_a = PetscPatchDefaultViewers(a);
  *ierr = PetscBagLoad(v_a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagcreate_ PETSCBAGCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagcreate_ petscbagcreate
#endif
PETSC_EXTERN void petscbagcreate_(MPI_Fint *a, size_t *b, PetscBag *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(c);
  CHKFORTRANNULLOBJECT(c);
  *ierr = PetscBagCreate(MPI_Comm_f2c(*(a)), *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagsetname_ PETSCBAGSETNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagsetname_ petscbagsetname
#endif
PETSC_EXTERN void petscbagsetname_(PetscBag *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscBagSetName(*a, c_b, c_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbaggetdata_ PETSCBAGGETDATA
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbaggetdata_ petscbaggetdata
#endif
PETSC_EXTERN void petscbaggetdata_(PetscBag *a, PeCtx b, PetscErrorCode *ierr)
{
  *ierr = PetscBagGetData(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbagsetoptionsprefix_ PETSCBAGSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbagsetoptionsprefix_ petscbagsetoptionsprefix
#endif
PETSC_EXTERN void petscbagsetoptionsprefix_(PetscBag *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscBagSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbag.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbaggetnames_ PETSCBAGGETNAMES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbaggetnames_ petscbaggetnames
#endif
PETSC_EXTERN void petscbaggetnames_(PetscBag *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscBagGetNames(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
