-- mod-version:3
local syntax = require "core.syntax"

syntax.add {
  name = "AngelScript",
  files = { "%.as$", "%.asc$" },
  comment = "//",
  patterns = {
    { pattern = "//.-\n",                   type = "comment"  },
    { pattern = { "/%*", "%*/" },           type = "comment"  },
    { pattern = { "#", "[^\\]\n" },         type = "comment"  },
    { pattern = { '"', '"', '\\' },         type = "string"   },
    { pattern = { "'", "'", '\\' },         type = "string"   },
    { pattern = "-?0[xX]%x+",               type = "number"   },
    { pattern = "-?0[bB][0-1]+",            type = "number"   },
    { pattern = "-?0[oO][0-7]+",            type = "number"   },
    { pattern = "-?%d+[%d%.eE]*f?",         type = "number"   },
    { pattern = "-?%.?%d+f?",               type = "number"   },
    { pattern = "&inout",                   type = "keyword"  },
    { pattern = "&in",                      type = "keyword"  },
    { pattern = "&out",                     type = "keyword"  },
    { pattern = "[%a_][%w_]*@",             type = "keyword2" },
    { pattern = "[%-%+!~@%?:&|%^<>%*/=%%]", type = "operator" },
    { pattern = "[%a_][%w_]*%f[(]",         type = "function" },
    { pattern = "[%a_][%w_]*",              type = "symbol"   },
  },
  symbols = {
    -- Common
    ["shared"]     = "keyword",
    ["external"]   = "keyword",
    ["private"]    = "keyword",
    ["protected"]  = "keyword",
    ["const"]      = "keyword",
    ["final"]      = "keyword",
    ["abstract"]   = "keyword",
    ["class"]      = "keyword",
    ["typedef"]    = "keyword",
    ["namespace"]  = "keyword",
    ["interface"]  = "keyword",
    ["import"]     = "keyword",
    ["enum"]       = "keyword",
    ["funcdef"]    = "keyword",
    ["get"]        = "keyword",
    ["set"]        = "keyword",
    ["mixin"]      = "keyword",
    ["void"]       = "keyword2",
    ["int"]        = "keyword2",
    ["int8"]       = "keyword2",
    ["int16"]      = "keyword2",
    ["int32"]      = "keyword2",
    ["int64"]      = "keyword2",
    ["uint"]       = "keyword2",
    ["uint8"]      = "keyword2",
    ["uint16"]     = "keyword2",
    ["uint32"]     = "keyword2",
    ["uint64"]     = "keyword2",
    ["float"]      = "keyword2",
    ["double"]     = "keyword2",
    ["bool"]       = "keyword2",
    ["auto"]       = "keyword",
    ["override"]   = "keyword",
    ["explicit"]   = "keyword",
    ["property"]   = "keyword",
    ["break"]      = "keyword",
    ["continue"]   = "keyword",
    ["return"]     = "keyword",
    ["switch"]     = "keyword",
    ["case"]       = "keyword",
    ["default"]    = "keyword",
    ["for"]        = "keyword",
    ["while"]      = "keyword",
    ["do"]         = "keyword",
    ["if"]         = "keyword",
    ["else"]       = "keyword",
    ["try"]        = "keyword",
    ["catch"]      = "keyword",
    ["cast"]       = "keyword",
    ["function"]   = "keyword",
    ["true"]       = "literal",
    ["false"]      = "literal",
    ["null"]       = "literal",
    ["is"]         = "operator",
    ["and"]        = "operator",
    ["or"]         = "operator",
    ["xor"]        = "operator",
  },
}

