/* ============================================================================
 * Freetype GL - A C OpenGL Freetype engine
 * Platform:    Any
 * WWW:         http://code.google.com/p/freetype-gl/
 * ----------------------------------------------------------------------------
 * Copyright 2011,2012 Nicolas P. Rougier. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY NICOLAS P. ROUGIER ''AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL NICOLAS P. ROUGIER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of Nicolas P. Rougier.
 * ===============================================================================
 */
#include <stddef.h>
#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  wchar_t charcode;
  float kerning;
} kerning_t;

typedef struct {
  wchar_t charcode;
  int width, height;
  int offset_x, offset_y;
  float advance_x, advance_y;
  float s0, t0, s1, t1;
  size_t kerning_count;
  kerning_t kerning[1];
} texture_glyph_t;

typedef struct {
  size_t tex_width;
  size_t tex_height;
  size_t tex_depth;
  // This needs to be unsigned otherwise a lot of -Wnarrowing warnings appear
  // (one for each char...)
  unsigned char tex_data[65536];
  float size;
  float height;
  float linegap;
  float ascender;
  float descender;
  size_t glyphs_count;
  texture_glyph_t glyphs[96];
} texture_font_t;

texture_font_t font_data = {
    256, 256, 1,
    {0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   225, 255,
     255, 255, 162, 0,   0,   0,   187, 255, 255, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  128, 128, 57,  0,   0,   0,   0,   24,  128, 128, 65,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 122, 0,   0,
     0,   0,   0,   0,   23,  125, 205, 239, 245, 212, 139, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   173, 255, 255, 255, 255, 255, 122, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   34,  83,  103, 106, 0,   11,  117, 100, 76,  23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 255,
     18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  98,  114, 41,  0,   0,   0,
     165, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 132, 0,   0,   2,   78,  114, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   195, 255, 255, 255, 134, 0,   0,   0,   160, 255, 255, 255, 145, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   114, 255, 255, 66,  0,   0,   0,   0,   101, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,
     86,  169, 202, 194, 146, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   58,  254, 255, 210, 5,   0,   0,   0,   0,   0,   74,  240, 255, 255, 255, 255, 255, 255, 241, 76,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   128, 255, 255, 255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  150, 235, 255, 255, 255, 228, 0,   24,  255, 255, 255, 255, 221, 129,
     30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 252, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,
     255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  231, 255, 255, 252, 108, 0,   0,   200, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 160, 0,   4,
     187, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   0,   160, 255, 255, 255,
     28,  0,   0,   164, 255, 255, 255, 107, 0,   0,   0,   133, 255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   179, 255, 248, 8,   0,   0,   0,   0,   169, 255, 252, 16,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  185, 255, 255, 255, 255, 255, 251, 108, 0,   0,   0,   0,   0,   0,   0,   5,   212, 255,
     253, 55,  0,   0,   0,   0,   0,   66,  253, 255, 255, 252, 220, 244, 255, 255, 255, 248, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  255, 255, 255, 255, 255, 34,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   28,  172, 255, 255, 255, 255, 255, 255, 228, 0,   24,  255, 255, 255, 255, 255, 255, 251, 138, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   0,   0,   0,
     0,   48,  255, 255, 235, 0,   0,   0,   0,   3,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   183, 255, 255,
     255, 255, 253, 54,  0,   200, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 160, 0,   102, 255, 255, 255, 255, 255, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   134, 255, 255, 255, 80,  0,   0,   0,   106, 255, 255, 255, 88,  0,
     0,   0,   0,   0,   0,   0,   0,   3,   241, 255, 191, 0,   0,   0,   0,   1,   235, 255, 201, 0,   0,   0,   0,   0,   0,   0,   53,  139, 198, 238, 255, 255, 246, 225, 204, 161, 109, 38,  0,
     0,   0,   0,   165, 255, 255, 255, 255, 255, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   125, 255, 255, 145, 0,   0,   0,   0,   0,   11,  226, 255, 255, 198, 29,  0,   1,   86,  244, 255,
     255, 161, 0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  255, 255, 255, 255, 244, 1,   0,   0,   0,   0,   0,   0,   0,   0,   74,  242, 255, 255, 255, 255, 244, 174, 113, 66,  0,   5,   81,
     123, 190, 251, 255, 255, 255, 255, 220, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 160, 15,  0,   0,   48,  255, 255, 216, 0,   0,   0,   47,  203, 96,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 255, 255, 255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   160, 255, 255, 255, 28,  0,   0,   103, 255, 255, 255, 53,  0,   0,   0,   79,  255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   54,  255, 255, 126, 0,   0,   0,   0,   49,  255,
     255, 134, 0,   0,   0,   0,   0,   22,  178, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 0,   0,   0,   52,  255, 255, 253, 106, 12,  30,  175, 255, 255, 214, 0,   0,   0,   0,
     0,   39,  248, 255, 226, 12,  0,   0,   0,   0,   0,   97,  255, 255, 247, 29,  0,   0,   0,   0,   126, 255, 255, 226, 0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   245, 255, 255, 255, 202,
     0,   0,   0,   0,   0,   0,   0,   0,   103, 252, 255, 255, 255, 229, 110, 9,   0,   0,   0,   0,   0,   0,   0,   0,   22,  136, 244, 255, 255, 255, 239, 60,  0,   0,   0,   0,   0,   0,   0,
     55,  254, 255, 226, 69,  0,   48,  255, 255, 197, 0,   8,   135, 251, 255, 233, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   179, 255, 255, 255, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 255, 255, 255, 50,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   73,  255, 255, 255, 26,  0,   0,   0,   53,
     255, 255, 255, 31,  0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 60,  0,   0,   0,   0,   118, 255, 255, 67,  0,   0,   0,   0,   24,  220, 255, 255, 255, 255, 237, 255, 255, 231, 245,
     255, 255, 255, 140, 0,   0,   0,   146, 255, 255, 156, 0,   0,   0,   11,  237, 255, 255, 53,  0,   0,   0,   1,   193, 255, 255, 75,  0,   0,   0,   0,   0,   0,   183, 255, 255, 173, 0,   0,
     0,   0,   0,   55,  255, 255, 249, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   202, 255, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   88,  254, 255, 255, 255, 163, 15,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  197, 255, 255, 255, 240, 46,  0,   0,   0,   0,   0,   0,   184, 255, 255, 255, 255, 151, 59,  255, 255, 178, 65,  219, 255, 255, 255, 255, 128,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  230, 255, 255, 255, 255, 225, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   190, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   43,  255, 255, 251, 2,   0,   0,   0,   26,  255, 255, 253, 5,   0,   0,   0,   0,   0,   0,   0,   0,   185, 255, 245, 5,   0,
     0,   0,   0,   186, 255, 247, 8,   0,   0,   0,   0,   189, 255, 255, 255, 190, 53,  60,  255, 255, 92,  2,   41,  99,  165, 120, 0,   0,   0,   203, 255, 255, 62,  0,   0,   0,   0,   152, 255,
     255, 110, 0,   0,   0,   101, 255, 255, 169, 0,   0,   0,   0,   0,   0,   0,   221, 255, 255, 137, 0,   0,   0,   0,   0,   53,  255, 255, 239, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     157, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   51,  249, 255, 255, 255, 122, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   168, 255, 255, 255, 228, 18,
     0,   0,   0,   0,   0,   12,  117, 232, 255, 255, 255, 239, 255, 255, 239, 255, 255, 255, 255, 212, 90,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   18,  91,  201, 255, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   80,  115, 62,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   12,  255, 255, 227,
     0,   0,   0,   0,   3,   252, 255, 230, 0,   0,   0,   0,   0,   0,   0,   0,   5,   244, 255, 185, 0,   0,   0,   0,   7,   246, 255, 188, 0,   0,   0,   0,   78,  255, 255, 255, 164, 1,   0,
     60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   229, 255, 255, 14,  0,   0,   0,   0,   104, 255, 255, 136, 0,   0,   24,  239, 255, 238, 23,  0,   0,   0,   0,   0,   0,   0,   234,
     255, 255, 154, 0,   0,   0,   0,   0,   124, 255, 255, 195, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 70,  0,   0,   0,   0,   0,   10,  216, 255, 255, 255, 123, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   173, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   9,   110, 228, 255, 255, 255, 255, 255, 255, 255,
     205, 82,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   170, 255, 255, 160, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   0,   238, 255, 200, 0,   0,   0,   0,   0,   228, 255, 202, 0,   0,   0,   0,   0,   0,   0,   0,   59,
     255, 255, 120, 0,   0,   0,   0,   66,  255, 255, 121, 0,   0,   0,   0,   169, 255, 255, 255, 20,  0,   0,   60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   234, 255, 250, 0,   0,
     0,   0,   0,   82,  255, 255, 141, 0,   0,   170, 255, 255, 99,  0,   0,   0,   0,   0,   0,   0,   0,   204, 255, 255, 194, 0,   0,   0,   0,   15,  233, 255, 255, 118, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   66,  255, 255, 255, 26,  0,   0,   0,   0,   0,   131, 255, 255, 255, 166, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     9,   209, 255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,   0,   11,  189, 255, 255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255,
     212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   226, 255, 255, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 221, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,
     0,   0,   207, 255, 173, 0,   0,   0,   0,   0,   201, 255, 174, 0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   210, 255,
     255, 235, 0,   0,   0,   60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 10,  0,   0,   0,   0,   100, 255, 255, 123, 0,   76,  255, 255, 191, 1,   0,   0,   0,   0,
     0,   0,   0,   0,   137, 255, 255, 254, 46,  0,   0,   0,   171, 255, 255, 243, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 237, 0,   0,   0,   0,   0,   25,  245, 255,
     255, 229, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  250, 255, 255, 214, 3,   0,   0,   0,   0,   0,   9,   108, 224, 255, 255,
     255, 255, 255, 255, 255, 200, 79,  1,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   81,  255, 255,
     211, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  235, 255,
     255, 74,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   205, 255, 255, 255, 23,  0,   0,   60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,
     170, 255, 255, 49,  0,   0,   0,   0,   139, 255, 255, 77,  12,  226, 255, 247, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  255, 255, 255, 193, 1,   0,   130, 255, 255, 255, 108, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   231, 255, 194, 0,   0,   0,   0,   0,   142, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 89,  0,   0,   0,   14,  120, 233, 255, 255, 255, 241, 255, 255, 241, 255, 255, 255, 255, 213, 93,  4,   0,   176, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   51,  235, 255, 253, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   155, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160,
     255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 212, 212, 212, 212, 213, 255, 255, 240, 212, 212, 212, 212, 214, 255, 255, 238, 212, 212,
     212, 99,  0,   155, 255, 255, 255, 149, 0,   0,   60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   91,  255, 255, 135, 0,   0,   0,   2,   224, 255, 242, 12,  146, 255, 255, 122, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 255, 114, 149, 255, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   10,  239, 255, 255, 218, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  249, 255, 255, 196, 0,   0,   0,   185, 255,
     255, 255, 255, 157, 61,  255, 255, 178, 70,  222, 255, 255, 255, 255, 128, 0,   145, 212, 212, 212, 212, 212, 212, 212, 214, 255, 255, 248, 212, 212, 212, 212, 212, 212, 212, 212, 99,  0,   17,
     173, 251, 255, 253, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   57,  254, 255, 245, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   53,  255, 255, 123, 0,   0,   0,   0,   58,  255, 255, 111, 0,   0,   0,   0,   0,   56,  255, 255, 255, 255, 111, 0,   60,  255, 255, 92,  0,   0,   0,
     0,   0,   0,   0,   0,   6,   217, 255, 244, 60,  0,   3,   137, 255, 255, 131, 54,  253, 255, 210, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  249, 255, 255, 255, 255, 255,
     255, 170, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 41,  0,   0,   54,  254, 255, 230, 75,  0,   48,  255, 255, 197, 0,   10,  142, 252, 255, 233, 15,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  255, 255, 227, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   208, 255, 255, 121, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 52,  0,   0,   0,   0,   133,
     255, 255, 39,  0,   0,   0,   0,   0,   0,   154, 255, 255, 255, 255, 162, 76,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  239, 255, 255, 223, 237, 255, 255, 190, 12,  210,
     255, 253, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 255, 255, 149, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   173, 255, 255, 254, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  255, 255, 255,
     119, 0,   0,   0,   158, 168, 18,  0,   0,   48,  255, 255, 216, 0,   0,   0,   53,  209, 98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   28,  167, 101, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   112, 255, 255, 215, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 234, 1,   0,   0,   0,   0,   208, 255, 222, 0,   0,   0,   0,   0,   0,   0,   6,   184, 255, 255, 255, 255, 247, 255,
     255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   37,  175, 249, 255, 255, 233, 130, 8,   122, 255, 255, 146, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,
     252, 255, 255, 255, 213, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   242, 255, 255, 206, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   247, 255, 255, 193, 0,   0,   0,   6,   0,   0,   0,   0,   48,  255, 255, 235, 0,   0,   0,   0,
     4,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  241, 255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  252, 255, 165, 0,
     0,   0,   0,   27,  255, 255, 151, 0,   0,   0,   0,   0,   0,   0,   0,   5,   149, 255, 255, 255, 255, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   35,  28,
     2,   0,   36,  247, 255, 226, 13,  60,  158, 200, 197, 149, 47,  0,   0,   0,   0,   0,   0,   0,   64,  242, 255, 255, 255, 255, 255, 146, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  255, 255, 255, 147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   197, 255, 255, 241, 1,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 252, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  143, 208, 242, 252, 237, 196, 125, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  255, 255, 94,  0,   0,   0,   0,   101, 255, 255, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     69,  214, 255, 255, 255, 255, 254, 161, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   190, 255, 255, 76,  135, 255, 255, 255, 255, 255, 252, 114, 0,   0,   0,
     0,   0,   57,  245, 255, 255, 234, 250, 255, 255, 255, 109, 0,   0,   0,   0,   84,  255, 255, 255, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 255, 106, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   48,  255, 255,
     255, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   154, 254, 255,
     255, 255, 255, 255, 255, 255, 247, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   69,  255, 255, 242, 26,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     159, 255, 254, 23,  0,   0,   0,   0,   176, 255, 250, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   103, 230, 255, 255, 255, 255, 244, 116, 2,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   97,  255, 255, 169, 102, 255, 255, 255, 255, 255, 255, 255, 255, 86,  0,   0,   0,   24,  233, 255, 255, 223, 36,  94,  255, 255, 255, 252, 75,  0,   0,   0,   84,
     255, 255, 255, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  197, 255, 255, 255, 255, 246, 221, 247, 255, 255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   217, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255,
     255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   230, 255, 207, 0,   0,   0,   0,   6,   244, 255, 191, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 255, 255, 255, 193, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  237, 255, 239, 33,  238, 255, 255, 137, 18,  20,  146,
     255, 255, 231, 6,   0,   0,   172, 255, 255, 240, 34,  0,   0,   123, 255, 255, 255, 243, 48,  0,   0,   84,  255, 255, 255, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255,
     255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 72,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     170, 255, 255, 255, 215, 74,  1,   0,   7,   95,  235, 255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 210, 4,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 224, 255, 255, 255, 255, 215,
     17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   167, 255, 255, 100, 88,  255, 255, 196, 0,   0,   0,   1,   208, 255, 255, 83,  0,   50,  255, 255, 255, 91,  0,   0,   0,   0,   152, 255, 255,
     255, 228, 27,  0,   88,  255, 255, 246, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 212, 20,  0,   0,   0,   0,   0,   43,  243, 255, 255, 248, 27,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  246, 255, 254, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 92,  99,  247, 255, 255, 255, 169, 0,   0,   0,   0,   0,   0,   0,   0,   73,  255, 255, 192, 1,   149, 255, 255,
     103, 0,   0,   0,   0,   113, 255, 255, 144, 0,   147, 255, 255, 221, 2,   0,   0,   0,   0,   3,   178, 255, 255, 255, 207, 12,  107, 255, 255, 211, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   110, 255, 255, 255, 78,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 255, 56,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   204, 255, 255, 253, 52,  0,   0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   181,
     255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   145, 212, 212, 245, 255, 254, 212, 212, 212, 212, 212, 249, 255, 249, 212, 212, 212, 212, 212, 212, 99,  0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 92,
     0,   60,  246, 255, 255, 255, 39,  0,   0,   0,   0,   0,   0,   11,  224, 255, 248, 38,  0,   183, 255, 255, 56,  0,   0,   0,   0,   63,  255, 255, 174, 0,   210, 255, 255, 143, 0,   0,   0,
     0,   0,   0,   10,  201, 255, 255, 255, 179, 170, 255, 255, 154, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,   0,   97,  128, 128, 126, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   2,   50,  114, 165, 203, 233, 249, 242, 220, 174, 101, 14,  0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   0,   187,
     255, 255, 255, 248, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  255, 255, 238, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   235, 255, 203, 0,   0,   0,   0,   14,
     250, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 92,  0,   0,   134, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   142, 255, 255, 123,
     0,   0,   196, 255, 255, 33,  0,   0,   0,   0,   41,  255, 255, 182, 0,   240, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   21,  220, 255, 255, 255, 255, 255, 255, 71,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 255, 255, 147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     197, 255, 255, 241, 1,   0,   0,   0,   0,   0,   0,   9,   164, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  136, 231, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     232, 90,  0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 69,  0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   11,  226, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 130, 0,   0,   0,   0,   85,  255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   60,  255, 255, 92,  0,   0,   65,  255, 255, 255, 133, 0,   0,   0,   0,   0,   52,  252, 255, 211, 5,   0,   0,   186, 255, 255, 38,  0,   0,   0,   0,   51,  255, 255, 167, 0,   236, 255,
     255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   36,  234, 255, 255, 255, 255, 219, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   241, 255, 255, 205, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   247, 255, 255, 192, 0,   0,   0,   0,   0,   0,   52,  215, 255, 255, 255, 255, 252,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 255, 255, 247, 222, 218, 247, 255, 255, 255, 255, 254, 84,  0,   0,   0,   0,   1,   229, 255, 255, 239, 2,   0,   0,   0,   0,
     0,   0,   21,  236, 255, 255, 255, 255, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   138, 255, 255, 203, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   77,  115, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   129, 255, 255, 58,
     0,   0,   0,   0,   162, 255, 254, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 92,  0,   0,   70,  255, 255, 255, 107, 0,   0,   0,   0,   4,
     207, 255, 253, 56,  0,   0,   0,   158, 255, 255, 76,  0,   0,   0,   0,   95,  255, 255, 132, 0,   205, 255, 255, 186, 0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  245, 255, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 254, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   72,  255, 255, 255, 119, 0,   0,   0,   0,   21,  151, 252, 255, 255, 255, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 250, 177, 99,  39,  2,   0,
     0,   5,   79,  213, 255, 255, 255, 241, 13,  0,   0,   0,   34,  255, 255, 255, 180, 0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 201, 246, 255, 255, 233, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   43,  251, 255, 253, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   167, 255, 255, 255, 116,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   203, 255, 238, 3,   0,   0,   0,   3,   236, 255, 203, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   60,  255, 255, 92,  0,   0,   140, 255, 255, 255, 46,  0,   0,   0,   0,   118, 255, 255, 147, 0,   0,   0,   0,   103, 255, 255, 164, 0,   0,   0,   0,   188, 255,
     255, 72,  0,   131, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   29,  220, 255, 255, 255, 244, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255,
     255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 255, 41,  0,   0,   26,  140, 243, 255, 255, 255,
     220, 167, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 129, 23,  0,   0,   0,   0,   0,   0,   0,   0,   10,  197, 255, 255, 255, 105, 0,   0,   0,   76,  255, 255, 255, 128,
     0,   0,   0,   0,   0,   0,   72,  255, 255, 251, 46,  197, 255, 255, 255, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  255, 255, 255, 255, 243, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     22,  254, 255, 169, 0,   0,   0,   0,   60,  255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   169, 51,  0,   0,   0,   0,   0,   60,  255, 255, 92,  0,   53,  245, 255, 255, 195, 0,
     0,   0,   0,   34,  246, 255, 227, 13,  0,   0,   0,   0,   19,  248, 255, 254, 104, 1,   2,   124, 255, 255, 227, 3,   0,   26,  243, 255, 255, 243, 86,  0,   0,   0,   0,   0,   0,   74,  233,
     255, 255, 255, 255, 255, 222, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  239, 255, 255, 216, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   23,  248, 255, 255, 196, 0,   0,   0,   132, 255, 255, 255, 254, 155, 13,  120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 159, 0,   0,   0,   117, 255, 255, 255, 94,  0,   0,   0,   0,   0,   11,  223, 255, 255, 136, 0,   145, 255, 255, 255, 60,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 234, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   41,
     255, 255, 255, 255, 242, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 96,  0,   0,   0,   0,   137, 255, 255, 52,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   255, 255, 199, 123, 51,  4,   0,   60,  255, 255, 118, 134, 247, 255, 255, 245, 40,  0,   0,   0,   0,   186, 255, 255, 77,  0,   0,   0,   0,   0,   0,   129, 255, 255, 255,
     231, 234, 255, 255, 255, 84,  0,   0,   0,   96,  255, 255, 255, 255, 205, 125, 91,  95,  131, 200, 255, 255, 255, 236, 161, 255, 255, 255, 188, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   142, 255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 255, 89,  0,   0,   0,   132,
     255, 255, 198, 61,  0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   255, 255, 255, 185, 0,   0,   0,
     142, 255, 255, 255, 63,  0,   0,   0,   0,   0,   142, 255, 255, 221, 9,   0,   109, 255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  234, 255, 255, 97,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   167, 255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   167, 255, 255, 25,  0,   0,   0,   0,   214, 255, 232, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   255, 255, 255, 255, 255, 251, 226, 225, 255, 255, 255, 255, 255,
     255, 241, 69,  0,   0,   0,   0,   94,  255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   4,   168, 255, 255, 255, 255, 255, 255, 123, 0,   0,   0,   0,   0,   100, 247, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 214, 39,  3,   191, 255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  245, 255, 255, 227, 15,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  250, 255, 255, 214, 3,   0,   0,   0,   121, 163, 59,  0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  255, 255, 255, 166, 0,   0,   0,   155, 255, 255, 255, 51,  0,   0,   0,   0,   52,  252, 255, 255, 71,  0,   0,   92,
     255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 196, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   1,   77,  116, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 181, 41,  0,   0,   0,   0,   20,  235, 255, 239, 24,  0,   0,   0,   0,   0,   0,
     0,   0,   1,   96,  201, 245, 240, 184, 66,  0,   0,   0,   0,   0,   0,   0,   41,  164, 249, 255, 255, 255, 255, 255, 255, 227, 121, 7,   0,   0,   25,  233, 255, 255, 255, 92,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   208, 255, 255, 255, 78,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255,
     255, 109, 0,   0,   0,   167, 255, 255, 255, 41,  0,   0,   0,   4,   207, 255, 255, 165, 0,   0,   0,   75,  255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  253, 255, 252,
     46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  100, 161,
     206, 237, 251, 244, 230, 202, 151, 79,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  113, 160, 198, 228, 241, 252,
     255, 255, 204, 120, 47,  0,   0,   0,   0,   0,   0,   163, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   11,  67,  105, 121, 114, 92,  42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  216, 255, 255, 255, 120, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   171, 255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   210, 255, 255, 249, 24,  0,   0,   0,   172, 255, 255, 255, 36,  0,   0,   0,   119, 255, 255, 238,
     22,  0,   0,   0,   74,  255, 255, 255, 115, 0,   0,   0,   0,   0,   0,   0,   0,   3,   205, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   79,  115, 61,  0,   0,   0,   0,   0,   154, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 222, 57,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  249, 255, 255, 254, 117, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   165, 255,
     255, 255, 228, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   133, 255, 255, 255, 146, 0,   0,   0,   0,   161, 255, 255, 255, 36,  0,   0,   35,  246, 255, 255, 99,  0,   0,   0,   0,   84,  255, 255, 255, 103, 0,   0,   0,   0,   0,   0,   0,   0,
     109, 255, 255, 230, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   190, 255, 255, 255, 139, 0,   0,   0,
     0,   188, 255, 255, 255, 255, 239, 219, 223, 248, 255, 255, 255, 255, 249, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   62,  253, 255, 255, 152, 0,   0,   0,   0,   0,   0,
     0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,
     254, 255, 255, 255, 159, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  194, 255, 255, 255, 240, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120,
     255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  254, 255, 255, 227, 14,  0,   0,   0,   0,   148, 255, 255, 255, 37,  0,   0,
     188, 255, 255, 193, 1,   0,   0,   0,   0,   99,  255, 255, 255, 91,  0,   0,   0,   0,   0,   0,   0,   24,  240, 255, 255, 89,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 255, 255, 255, 49,  0,   0,   0,   188, 251, 178, 91,  30,  0,   0,   0,   7,   74,  209, 255, 255, 255, 230, 11,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  225, 255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 252, 255, 255, 255, 227, 107, 9,   0,   0,   0,   0,   0,   0,   0,   0,   21,
     132, 243, 255, 255, 255, 239, 61,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   52,  245, 255, 255, 250, 57,  0,   0,   0,   0,   0,   133, 255, 255, 255, 56,  0,   96,  255, 255, 249, 40,  0,   0,   0,   0,   0,   130, 255, 255, 255, 75,  0,   0,   0,
     0,   0,   0,   0,   165, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 255,
     255, 255, 95,  0,   0,   0,   94,  30,  0,   0,   0,   0,   0,   0,   0,   0,   10,  202, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 255, 152, 0,
     0,   0,   0,   0,   0,   0,   132, 255, 255, 253, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   75,  242, 255, 255, 255, 255, 243, 172, 112, 65,  0,   5,   79,  121, 188, 251, 255, 255, 255, 255, 220, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  233, 255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   96,  255,
     255, 255, 89,  22,  237, 255, 255, 129, 0,   0,   0,   0,   0,   0,   163, 255, 255, 255, 38,  0,   0,   0,   0,   0,   0,   65,  255, 255, 250, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 255, 255, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     51,  255, 255, 255, 195, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  146, 205, 239, 251, 239, 220, 197, 145, 87,  15,  0,   0,   0,   0,   0,   19,  98,  107, 32,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  174, 255, 255, 255, 255, 255, 255, 228, 0,
     24,  255, 255, 255, 255, 255, 255, 251, 139, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   22,  219, 255, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   54,  255, 255, 255, 144, 166, 255, 255, 217, 7,   0,   0,   0,   0,   0,   0,   216, 255, 255,
     249, 3,   0,   0,   0,   0,   0,   6,   215, 255, 255, 135, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   5,   190, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   227, 255, 255, 233, 0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  199, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 80,  0,   0,   0,   0,   42,  233, 255, 255, 244, 70,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  242, 255, 255,
     255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   51,  152, 235, 255, 255, 255, 228, 0,   24,  255, 255, 255, 255, 222, 130, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  207, 255, 255, 255, 135, 0,   0,   0,   0,   0,
     0,   0,   0,   12,  251, 255, 255, 236, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   18,  254, 255, 255, 207, 0,   0,   0,   0,   0,   0,   122, 255, 255, 225, 10,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   80,  115, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   206, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   95,  249, 255, 255, 255, 255, 244, 218, 230, 254, 255, 255, 255, 80,  0,   0,   0,   0,   182, 255, 255,
     255, 255, 225, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   199, 255, 255, 199, 227, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     36,  85,  105, 107, 0,   11,  118, 102, 77,  24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  200, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   190, 255, 255, 255, 255, 255, 158, 0,   0,   0,   0,   0,   0,
     0,   93,  255, 255, 255, 133, 0,   0,   0,   0,   0,   32,  245, 255, 255, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   234, 255, 255, 210, 0,   0,   0,   0,   0,   0,   0,
     92,  254, 255, 255, 250, 145, 39,  0,   0,   0,   13,  70,  153, 242, 80,  0,   0,   0,   0,   227, 255, 255, 255, 255, 255, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     130, 255, 255, 243, 35,  224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   193, 255, 255, 255, 142, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 255, 234, 19,  0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   39,  248, 255, 255, 235, 62,  0,   0,   0,   0,   0,   0,   0,   0,   14,  23,  0,   0,
     0,   0,   183, 255, 255, 255, 255, 226, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  252, 255, 255, 97,  0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   132,
     255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   79,  165, 221, 244, 245, 221, 173, 92,  6,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   13,  101, 181, 223, 246, 246, 219, 163, 74,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255,
     252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   172, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  246, 255, 255, 255, 93,  0,   0,
     0,   0,   0,   0,   0,   40,  253, 255, 255, 210, 1,   0,   0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   202, 255, 255, 252, 38,  0,   0,
     0,   0,   0,   0,   189, 255, 255, 253, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  233, 255, 255, 246, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   15,  223, 255, 255, 172, 0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   39,  205, 255, 255, 255, 255, 255, 255, 255, 255, 213, 51,  0,   0,   0,   0,   0,   0,   0,   0,   87,  230, 255, 255, 255, 255, 255, 255, 255, 255, 198, 33,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255,
     143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   2,   179, 255, 255, 255, 84,  0,   0,   0,   244, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   171, 255, 255, 255, 128, 0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 139, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   20,  100, 107, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 229, 19,  0,   0,   224, 255, 255, 152, 0,   0,   0,
     0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  239, 255, 255, 255, 242, 217, 234, 255, 255, 255, 255, 237,
     36,  0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 255, 250, 221, 240, 255, 255, 255, 255, 233, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  236,
     255, 255, 251, 92,  0,   0,   0,   0,   7,   152, 255, 255, 255, 200, 1,   0,   0,   0,   202, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 214, 255, 255, 255, 75,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   18,  52,  119, 225, 255, 255, 255,
     140, 1,   0,   0,   0,   0,   0,   0,   183, 255, 255, 244, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   91,  255, 255, 254, 69,  0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   10,  225, 255, 255, 231, 77,  3,   0,   0,   49,  193, 255, 255, 255, 187, 0,   0,   0,   0,   0,   97,  255, 255, 255, 218, 90,  5,   0,   2,   71,  216,
     255, 255, 255, 219, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,
     253, 255, 255, 189, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   74,  252, 255, 255, 255, 186, 109, 96,  133, 225, 255, 255, 255, 234, 34,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  255, 255, 255, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 255, 255, 255, 255, 223, 77,  0,   0,   0,   0,   0,   0,   0,   26,  252, 255, 255, 150, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  241, 255, 255, 143, 0,   0,   0,   0,   224, 255,
     255, 152, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 253, 210, 198, 184, 166, 123, 77,  17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 248, 45,  0,   0,   0,   0,
     0,   6,   193, 255, 255, 255, 41,  0,   0,   0,   34,  244, 255, 255, 193, 16,  0,   0,   0,   0,   0,   15,  200, 255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   223, 255, 255, 233, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   83,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 227, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   208, 255,
     255, 216, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 255, 255,
     255, 255, 255, 179, 81,  4,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   196, 255, 255, 211, 7,   0,   0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 249, 177, 70,  0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   51,  255, 255, 255, 90,  0,   0,   0,   158, 255, 255, 240, 25,  0,   0,
     0,   0,   0,   0,   0,   28,  241, 255, 255, 241, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   111, 255, 255, 255, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  172, 252, 255, 255, 255, 255, 255, 244, 145, 16,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  212, 212, 223, 234, 253, 255, 255, 255, 255, 255, 219, 72,  0,   0,   0,   0,   0,   151, 255, 255, 245, 6,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 248, 46,  0,   0,
     0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 179, 27,  0,   0,   0,   0,   0,   0,   232, 255, 255, 104,
     0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 112, 0,   0,   18,  250, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,   0,   0,   0,   0,   0,   0,   0,   0,   214, 255, 255, 219, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  81,  115, 124, 110, 69,  9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   29,  240, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   78,  114, 60,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   9,   49,  119, 213, 255, 255, 255, 254, 98,  0,   0,   0,   0,   202, 255, 255, 203, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  251, 255, 255, 114, 0,   0,   0,   0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     8,   19,  32,  67,  104, 168, 241, 255, 255, 255, 255, 224, 39,  0,   0,   0,   0,   0,   234, 255, 255, 134, 0,   0,   0,   0,   0,   0,   0,   36,  255, 255, 255, 86,  0,   0,   85,  255, 255,
     255, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 252, 0,
     0,   0,   0,   0,   0,   0,   0,   23,  255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   199, 255, 255, 228, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   187, 255, 255, 255, 136, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   118, 254, 255, 255, 253, 53,  0,   0,   0,
     239, 255, 255, 161, 0,   0,   0,   46,  147, 213, 245, 249, 222, 166, 76,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  221, 255, 255,
     187, 1,   0,   0,   0,   0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   120, 244, 255, 255, 255, 220, 11,  0,   0,   0,
     0,   194, 255, 255, 226, 9,   0,   0,   0,   0,   0,   0,   118, 255, 255, 252, 21,  0,   0,   138, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  255, 255, 255, 255, 28,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 212, 212, 212, 212, 212, 212, 232, 255, 255, 255, 212, 212, 212, 212, 212, 212, 192, 0,   52,  255, 255, 255, 113, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   101, 90,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   146, 255, 255, 253, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 255, 255, 255, 49,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 194, 0,   0,   1,   253, 255, 255, 134, 0,   7,   149, 254, 255, 255, 255, 255, 255, 255, 255, 201, 35,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   162, 255, 255, 237, 27,  0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  238, 255, 255, 255, 141, 0,   0,   0,   0,   113, 255, 255, 255, 156, 1,   0,   0,   0,   0,   18,  230, 255, 255, 164, 0,
     0,   0,   161, 255, 255, 210, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 232, 0,   60,  255, 255, 255, 230, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 39,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   105, 225, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   87,  255, 255, 255, 128, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 255, 255, 95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   214, 255,
     255, 254, 28,  0,   13,  255, 255, 255, 121, 23,  202, 255, 255, 255, 245, 219, 229, 254, 255, 255, 255, 242, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     25,  255, 255, 255, 239, 212, 212, 212, 212, 212, 212, 212, 212, 250, 255, 255, 238, 212, 212, 212, 212, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255,
     255, 237, 5,   0,   0,   0,   12,  228, 255, 255, 255, 161, 6,   0,   0,   13,  196, 255, 255, 241, 27,  0,   0,   0,   172, 255, 255, 202, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,
     255, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 232, 0,   60,  255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   108, 228, 255, 255, 255, 120, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   40,  243, 255, 255, 192, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255,
     255, 255, 255, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 73,  0,   24,  255, 255, 255, 118, 200, 255, 255, 210, 75,  5,   0,   0,
     25,  135, 253, 255, 255, 228, 21,  0,   0,   0,   0,   18,  99,  114, 40,  0,   0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 232, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   207, 255, 255, 255, 63,  0,   0,   0,   0,   62,  250, 255, 255, 255, 202, 34,  26,  204, 255,
     255, 250, 75,  0,   0,   0,   0,   156, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 48,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   112, 230, 255, 255, 255, 255, 197, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  212, 255, 255, 236, 27,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   190, 255, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   100, 255, 255, 255, 93,  0,   16,  255, 255, 255, 238, 255, 255, 182, 8,   0,   0,   0,   0,   0,   0,   96,  255, 255, 255, 155, 0,   0,   0,   40,  232, 255, 255, 252, 108, 0,
     0,   0,   0,   0,   0,   28,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 232, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   136, 255, 255, 255, 93,  0,   0,   0,   0,   0,   98,  253, 255, 255, 255, 240, 232, 255, 255, 247, 78,  0,   0,   0,   0,   0,   115, 255, 255, 255, 32,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   173, 255, 255, 255, 255, 196, 0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  116, 232, 255, 255, 255, 255, 193, 67,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   2,   80,  115, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 255, 74,  0,   4,   255, 255, 255, 255, 255, 223, 14,
     0,   0,   0,   0,   0,   0,   0,   0,   181, 255, 255, 246, 10,  0,   0,   183, 255, 255, 255, 255, 253, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   81,  243, 255,
     255, 255, 255, 255, 234, 58,  0,   0,   0,   0,   0,   0,   47,  255, 255, 255, 137, 0,   0,   0,   0,   0,   0,   0,   0,   59,  253, 255, 255, 255, 255, 208, 0,   176, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   124, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  119, 234, 255, 255, 255, 255, 188, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 143, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   162, 255, 255, 255, 38,  0,   0,   245, 255, 255, 255, 255, 99,  0,   0,   0,   0,   0,   0,   0,   0,   0,   78,  255, 255, 255, 67,  0,   0,   228, 255,
     255, 255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   146, 255, 255, 255, 91,  0,   0,   0,   0,   0,   0,   41,  216, 255, 255, 255, 255, 255, 207, 30,  0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 250,
     58,  0,   0,   0,   0,   0,   0,   36,  227, 255, 255, 232, 255, 255, 221, 0,   145, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 99,  0,   176,
     255, 202, 77,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  123, 236, 255, 255, 255, 255, 183,
     57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  240, 255, 255, 208, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  243, 255, 255, 213, 0,   0,   0,   210, 255,
     255, 255, 252, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  255, 255, 255, 104, 0,   0,   179, 255, 255, 255, 255, 255, 212, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   217, 255, 255, 255, 43,  0,   0,   0,   0,
     0,   78,  244, 255, 255, 255, 255, 255, 255, 255, 235, 60,  0,   0,   0,   0,   0,   0,   46,  247, 255, 255, 243, 110, 14,  0,   0,   14,  105, 236, 255, 255, 140, 167, 255, 255, 219, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 206, 80,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  127, 238, 255, 255, 255, 255, 178, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   192, 255,
     255, 247, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,
     19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   185, 255, 255, 255, 98,  0,   0,   0,   167, 255, 255, 255, 221, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   255, 255, 255,
     115, 0,   0,   42,  230, 255, 255, 255, 255, 225, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 217, 0,   0,   0,   0,   0,   93,  252, 255, 255, 253, 119, 67,  235, 255, 255, 255, 248, 83,  0,   0,   0,   0,
     0,   0,   95,  251, 255, 255, 255, 250, 223, 223, 250, 255, 255, 255, 154, 2,   180, 255, 255, 204, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   77,  216, 255, 255, 255, 255, 209, 84,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  130, 240, 255, 255, 255, 254,
     173, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  246, 153, 59,  1,   0,   0,   0,   0,   0,   0,   36,  195, 255, 255, 255, 189, 1,
     0,   0,   0,   120, 255, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  255, 255, 255, 98,  0,   0,   0,   18,  91,  201, 255, 255, 200, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   6,   15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  236, 255, 255, 255, 98,
     0,   0,   0,   0,   73,  252, 255, 255, 251, 88,  0,   0,   35,  221, 255, 255, 255, 251, 82,  0,   0,   0,   0,   0,   0,   59,  225, 255, 255, 255, 255, 255, 255, 255, 244, 100, 0,   0,   193,
     255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   89,  213, 255, 255, 255, 255, 212, 88,  2,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  134, 242, 255, 255, 255, 253, 168, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   23,  242, 255, 255, 203, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   76,  255, 255, 255, 229, 168, 118, 95,  92,  118, 181, 252, 255, 255, 255, 201, 14,  0,   0,   0,   0,   47,  255, 255, 255, 227, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   49,  255, 255, 255, 70,  0,   0,   0,   0,   0,   170, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   24,  241, 139, 47,  0,   0,   0,   0,   0,   0,   0,   79,  233, 255, 255, 255, 187, 2,   0,   0,   0,   24,  237, 255, 255, 255, 90,  0,   0,   0,   0,   27,  216, 255, 255,
     255, 246, 46,  0,   0,   0,   0,   0,   0,   8,   98,  181, 232, 251, 241, 201, 127, 23,  0,   0,   0,   227, 255, 255, 167, 0,   145, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212,
     212, 212, 212, 212, 212, 212, 212, 99,  0,   0,   0,   0,   2,   86,  211, 255, 255, 255, 255, 215, 91,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  166, 253, 255,
     255, 255, 247, 142, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   149, 255, 255, 255, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 149, 10,  0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 250, 12,  0,   0,   0,   0,   0,   226, 255, 255, 71,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 152, 0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 222, 163, 116, 94,  98,  133, 215, 255, 255,
     255, 255, 204, 17,  0,   0,   0,   0,   158, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   24,  222, 255, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   15,  255, 255, 255, 119, 0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   1,   83,  208,
     255, 255, 255, 255, 218, 95,  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   39,  163, 252, 255, 255, 255, 246, 144, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   19,  248, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  106, 197, 253, 255, 255, 255, 255, 255, 255, 255, 244, 163, 51,  0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 124, 0,   0,   0,
     0,   0,   0,   0,   0,   8,   222, 255, 255, 179, 0,   0,   0,   0,   0,   81,  255, 255, 211, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224,
     255, 255, 152, 0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 254, 154, 10,  0,   0,   0,   0,   20,  249, 255, 255, 227, 9,   0,   0,   0,   0,
     0,   0,   0,   42,  248, 255, 255, 255, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 69,  0,   176, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   1,   81,  206, 255, 255, 255, 255, 220, 98,  4,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   36,  159, 251, 255, 255, 255, 247, 146, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  65,  97,  117, 125,
     113, 95,  54,  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  241, 255, 255, 243, 41,  0,   0,   0,   0,   0,   0,   0,   138, 255, 255, 255, 57,  0,   0,   0,   0,   51,  235, 255,
     253, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   115, 180, 237, 255, 255, 255, 255,
     255, 255, 255, 244, 162, 49,  0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   150, 255, 255, 250, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   78,  203, 255, 255, 255, 255, 223, 102, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  156, 250, 255, 255, 255, 248, 148, 28,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 254, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255,
     255, 255, 229, 52,  0,   0,   0,   0,   6,   143, 255, 255, 255, 154, 0,   0,   0,   17,  173, 251, 255, 253, 94,  0,   0,   0,   0,   0,   16,  87,  155, 200, 233, 248, 248, 234, 202, 151, 67,
     2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  73,  105, 121, 121, 102, 61,  7,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 68,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 141, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   233, 255, 255, 174, 0,   0,   208, 255, 255,
     255, 255, 255, 252, 246, 237, 218, 190, 146, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   75,  200, 255, 255, 255, 255, 226, 105,
     7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  152, 249, 255, 255, 255, 249, 150, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 221, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  151, 208, 241, 251, 231, 207, 152, 70,  4,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   189, 255, 255, 255, 253, 170, 103, 96,  139, 231, 255, 255, 255, 202, 9,   0,   0,   0,
     36,  255, 255, 227, 79,  0,   0,   0,   0,   15,  161, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 202, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  255, 255, 255, 134, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 79,  0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 185, 24,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  161, 254, 255, 255, 255, 244, 139, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,
     149, 248, 255, 255, 255, 249, 152, 31,  0,   0,   0,   0,   0,   0,   0,   246, 255, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  200, 255, 255, 255, 255, 255, 255, 255, 255, 255, 214, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   14,  187, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 186, 13,  0,   0,   0,   0,   28,  167, 101, 11,  0,   0,   0,   0,   0,   40,  255, 255, 255, 255, 255, 242, 222,
     218, 242, 255, 255, 255, 255, 239, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  128, 128, 128, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     96,  255, 255, 255, 128, 0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  234, 255, 255, 208, 3,
     0,   0,   208, 255, 255, 253, 212, 212, 213, 221, 239, 255, 255, 255, 255, 255, 203, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  166, 253, 255, 255,
     255, 242, 135, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  145, 246, 255, 255, 255, 250, 154, 28,  0,   0,   0,   0,   6,   255, 255,
     255, 177, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  247, 255, 253, 176, 93,  48,  37,
     55,  102, 181, 253, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   106, 226, 255, 255, 255, 255, 255, 255, 216, 92,  1,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  255, 253, 187, 96,  33,  0,   0,   0,   1,   52,  189, 255, 255, 255, 213, 3,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   212, 255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 239, 31,  0,   0,   0,   0,   0,   0,   0,   14,  220, 255, 255,
     252, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   195, 255, 255, 254, 58,  0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   23,  101, 232, 255, 255, 255,
     108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  171, 254, 255, 255, 255, 240, 131, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   24,  141, 245, 255, 255, 255, 120, 0,   0,   0,   0,   18,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  252, 255, 218, 53,  0,   0,   0,   0,   0,   0,   0,   38,  187, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   52,  101, 122, 115, 92,  40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  170, 41,
     0,   0,   0,   0,   0,   0,   0,   0,   5,   198, 255, 255, 255, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  255, 255, 255, 255, 230, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   170, 255, 255, 255, 223, 53,  0,   0,   0,   0,   0,   34,  203, 255, 255, 255, 153, 0,   0,   0,   0,   88,  86,  7,   0,   0,   0,   0,   0,   0,   38,  207, 255,
     255, 255, 143, 0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   44,  250, 255, 255, 202, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  177, 255, 255,
     255, 255, 239, 128, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  138, 243, 255, 120, 0,   0,
     0,   0,   20,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  241, 255, 214, 21,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   149, 255, 254, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 117, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  230, 255, 255, 255, 254, 183, 113, 89,  104, 166,
     249, 255, 255, 255, 218, 17,  0,   0,   0,   0,   136, 255, 243, 176, 125, 96,  92,  121, 183, 253, 255, 255, 255, 169, 3,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   0,
     0,   0,   185, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  182, 255, 255, 255, 255, 237, 124, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  134, 106, 0,   0,   0,   0,   20,  255, 255, 255, 172, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 244, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   191, 255, 219, 7,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   4,   77,  158, 212, 239, 251, 238, 205, 156, 92,  17,  0,   0,   32,  255, 255, 255, 255, 255, 255, 255, 246, 234, 206, 165, 98,  19,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   67,  255, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 255, 255, 136, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   45,  222, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 211, 34,  0,   0,   0,   0,   0,   136, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 253, 133, 3,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   154, 255, 255, 249, 0,   0,   0,   0,   0,   0,   0,   0,   62,  187, 255,
     255, 255, 255, 235, 121, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,
     255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  253, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   90,  224, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     251, 41,  0,   32,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 244, 128, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255,
     255, 85,  0,   0,   0,   0,   0,   0,   0,   0,   21,  253, 255, 255, 255, 255, 255, 216, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  130, 232, 255,
     255, 255, 255, 255, 255, 255, 229, 121, 11,  0,   0,   0,   0,   0,   0,   95,  225, 255, 255, 255, 255, 255, 255, 255, 249, 168, 45,  0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,
     0,   0,   0,   0,   0,   0,   0,   171, 255, 255, 221, 0,   0,   0,   0,   0,   0,   59,  193, 255, 255, 255, 255, 232, 117, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     200, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 235, 9,   0,   0,   0,   27,  105, 166, 190, 209, 212, 212, 212, 16,  0,   0,
     177, 255, 199, 0,   0,   0,   0,   0,   0,   12,  170, 255, 255, 255, 255, 255, 229, 218, 237, 255, 255, 255, 255, 48,  0,   32,  255, 255, 255, 239, 212, 212, 214, 225, 247, 255, 255, 255, 255,
     255, 182, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  240, 255, 255, 242, 10,  0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 218, 255, 255,
     255, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   43,  92,  112, 124, 112, 92,  42,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     28,  76,  97,  116, 123, 107, 68,  11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   3,   233, 255, 255, 154, 0,   0,   0,   0,   0,   0,
     176, 255, 255, 255, 231, 113, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 12,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   12,  244, 255, 134, 0,   0,   2,   131, 248, 255, 255, 255, 255, 255, 255, 255, 20,  0,   0,   86,  255, 255, 28,  0,   0,   0,   0,   9,   194, 255, 255, 255, 246, 130, 27,  0,
     0,   0,   27,  95,  189, 255, 48,  0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   2,   43,  130, 243, 255, 255, 255, 155, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     1,   182, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 220, 123, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     208, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 254, 46,  0,   0,   0,   0,   0,   0,   176, 255, 228, 110, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   200, 255, 255, 254, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 234, 212, 212, 212,
     212, 212, 212, 212, 212, 212, 212, 212, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   74,  255, 255, 44,  0,   0,   151, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 20,  0,   0,   14,  253, 255, 83,  0,   0,   0,   0,   165, 255, 255, 255, 225, 42,  0,   0,   0,   0,   0,   0,   0,   0,   55,  24,  0,   32,  255, 255, 255, 160, 0,   0,   0,   0,
     0,   0,   0,   40,  230, 255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 199, 5,   0,   0,   0,   0,   0,   0,   0,   0,   10,  246, 255,
     255, 156, 51,  255, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   77,  158, 212, 240, 251, 238, 204, 155, 91,  16,  0,   0,   168, 255, 255, 255,
     24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   0,   72,  249, 255, 255, 140, 0,   0,
     0,   0,   0,   0,   0,   146, 106, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   126, 255, 228, 0,   0,   75,  255, 255, 255, 166, 57,  14,  1,   204, 255, 255, 20,  0,   0,   0,   208, 255, 137, 0,   0,   0,   84,  255, 255, 255, 239,
     35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   58,  253, 255, 255, 190, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   75,  254, 255, 255, 222, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   82,  255, 255, 255, 86,  1,   229, 255, 255, 254, 26,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   90,  224, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 37,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,
     0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   27,  149, 252, 255, 255, 158, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 171, 0,   0,   206, 255, 255, 158,
     0,   0,   0,   0,   204, 255, 255, 20,  0,   0,   0,   170, 255, 164, 0,   0,   4,   219, 255, 255, 255, 90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255,
     160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 255, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  242, 255, 255, 228, 34,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   162, 255, 255, 248, 13,  0,   149, 255, 255, 255, 105, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  170, 255, 255, 255, 255, 255, 229, 218, 238, 255, 255, 255, 255, 44,
     0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 253, 212, 212, 212, 212, 251, 255, 255, 232,
     96,  0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 132, 0,   49,  255, 255, 243, 19,  0,   0,   0,   0,   204, 255, 255, 20,  0,   0,   0,   145, 255, 180, 0,   0,   88,
     255, 255, 255, 200, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 118, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   35,  233, 255, 255, 234, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   237, 255, 255, 182, 0,   0,   67,  255, 255, 255, 185, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   9,   194, 255, 255, 255, 245, 128, 26,  0,   0,   0,   32,  103, 202, 255, 44,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255,
     255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 187, 57,  0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   223, 255, 103, 0,
     117, 255, 255, 172, 0,   0,   0,   0,   0,   204, 255, 255, 20,  0,   0,   0,   136, 255, 195, 0,   0,   185, 255, 255, 255, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   235, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   20,  218, 255, 255, 240, 49,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   65,  255, 255, 255, 102, 0,   0,   4,   237, 255, 255, 249, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 255, 224, 40,  0,   0,   0,   0,   0,
     0,   0,   0,   73,  26,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 165, 18,  0,   0,   0,   0,   172, 212, 212, 212, 212, 212, 233, 255, 255, 255, 223, 212, 212, 212, 212, 212, 125, 0,   0,   0,   0,   0,   0,   0,   0,   200, 255,
     255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   238, 255, 91,  0,   161, 255, 255, 114, 0,   0,   0,   0,   0,   204, 255, 255, 20,  0,   0,   0,   148,
     255, 181, 0,   14,  252, 255, 255, 240, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   188,
     255, 255, 235, 0,   0,   0,   0,   0,   0,   0,   2,   188, 255, 255, 242, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 253, 23,  0,   0,   0,   160, 255, 255,
     255, 89,  0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 237, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   4,   12,  34,  70,  133, 232, 255, 255, 255, 215, 25,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   244, 255, 87,  0,   178, 255, 255, 90,  0,   0,   0,   0,   41,  249, 255, 255, 21,  0,   0,   0,   184, 255, 161, 0,   76,  255, 255, 255, 169, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   153, 255, 255, 255, 17,  0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 77,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   223, 255, 255, 197, 0,   0,   0,   0,   78,  255, 255, 255, 169, 0,   0,   0,   0,   0,   0,   0,   4,   219, 255, 255, 255, 87,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255,
     255, 240, 0,   0,   0,   0,   0,   0,   14,  158, 255, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   235, 255, 97,  0,   171, 255, 255, 90,  0,   0,   0,   5,   200, 255, 255, 255,
     26,  0,   0,   9,   241, 255, 117, 0,   126, 255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   130, 255, 255, 255, 44,  0,   0,   0,   0,   0,   9,   238, 255, 255, 167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 255, 117, 0,   0,
     0,   0,   8,   244, 255, 255, 242, 7,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 199, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   1,   172, 255, 255, 255, 77,  0,   0,
     0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   222, 255, 118, 0,   136, 255, 255, 129, 0,   0,   0,   154, 255, 255, 255, 255, 49,  0,   0,   111, 255, 255, 41,  0,   163, 255, 255, 255, 67,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 61,  0,   0,   0,   0,   0,   78,  255, 255,
     255, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 255, 36,  0,   0,   0,   0,   0,   171, 255, 255, 255, 74,  0,   0,   0,   0,   0,   0,   185, 255, 255,
     255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,
     0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   34,  252, 255, 255, 177, 0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 152, 0,   65,  255, 255, 229, 42,  26,  158,
     255, 252, 223, 255, 255, 160, 14,  92,  247, 255, 188, 0,   0,   188, 255, 255, 255, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 70,  0,   0,   0,   0,   0,   121, 255, 255, 253, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255,
     255, 212, 0,   0,   0,   0,   0,   0,   89,  255, 255, 255, 154, 0,   0,   0,   0,   0,   14,  252, 255, 255, 240, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168,
     255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   215,
     255, 255, 237, 0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 254, 212, 212, 212, 212, 212,
     212, 212, 212, 212, 212, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 234, 212, 212, 212, 212, 212, 212, 212, 212, 212, 185, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255, 200, 0,   1,   203, 255, 255, 255, 255, 255, 255, 144, 127, 255, 255, 255, 255, 255, 255, 245, 42,  0,   0,   200, 255, 255, 255,
     23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 71,  0,   0,   0,
     0,   0,   138, 255, 255, 235, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   14,  248, 255, 255, 231, 2,   0,   0,   0,
     0,   76,  255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255,
     120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 3,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 232, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 249, 11,  0,   40,
     237, 255, 255, 255, 255, 192, 6,   26,  241, 255, 255, 255, 255, 245, 68,  0,   0,   0,   204, 255, 255, 255, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,
     255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 61,  0,   0,   0,   0,   0,   99,  176, 176, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   111, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   181, 255, 255, 255, 58,  0,   0,   0,   0,   126, 255, 255, 255, 111, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   223, 255, 255, 242, 0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 232, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 224, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  255, 255, 85,  0,   0,   31,  153, 203, 191, 117, 7,   0,   0,   43,  157, 201, 198, 142, 33,  0,   0,   0,
     0,   194, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255,
     255, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 138, 0,   0,   0,   0,   163, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   62,  255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   124,
     255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     213, 255, 180, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   18,  251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 218, 0,   0,   0,   0,   188, 255, 255, 255, 38,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240,
     0,   0,   0,   0,   0,   0,   0,   20,  218, 255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255, 254, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   200, 255, 255, 226, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 221, 216, 216, 216, 216, 216, 216,
     216, 216, 216, 243, 255, 255, 255, 43,  0,   0,   0,   200, 255, 255, 255, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 216, 212, 212, 212,
     212, 212, 212, 212, 212, 212, 223, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 240, 0,   0,   0,   0,   0,   15,  95,  225, 255, 255, 255, 202, 4,   0,   0,   0,   0,
     0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   11,  234, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 141, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   246, 255, 255, 171, 0,   0,   0,   0,   0,   0,   2,   83,  114, 51,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   174, 255, 255, 238, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 123, 0,   0,   0,   204, 255, 255, 255, 19,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,
     0,   208, 255, 255, 253, 212, 212, 212, 214, 228, 254, 255, 255, 255, 255, 234, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 122, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  255, 255, 255, 209, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 97,  0,   0,   0,   0,   0,   2,   182, 255, 255, 254, 102, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   244, 255, 255, 162, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   45,  255, 255, 255, 203, 0,   0,   0,   194, 255, 255, 255, 33,  0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 48,  0,   168, 255, 255,
     255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 190, 28,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 254, 123, 1,   0,   0,   0,   0,   0,   0,   0,   1,   129, 18,  0,   0,   0,   0,   0,   0,   1,   230, 255, 255, 255, 40,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   171, 255, 255, 247, 18,  0,   0,   0,   0,   0,   58,
     255, 255, 255, 255, 230, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   77,  255, 255, 255, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   218, 255, 255, 254, 28,  0,   0,   178,
     255, 255, 255, 51,  0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 255, 255, 255, 48,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,
     0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 253, 246, 229, 199, 149, 70,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  200, 255, 255, 197,
     70,  1,   0,   0,   0,   2,   66,  199, 255, 20,  0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 255, 147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255,
     255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   65,  254, 255, 255, 152, 0,   0,   0,   0,   0,   0,   57,  255, 255, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255,
     255, 246, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 255, 255, 255, 107, 0,   0,   144, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   92,  212, 212, 236, 255, 255, 255,
     48,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  172, 255, 255, 255, 237, 187, 169, 185, 232, 255, 255, 253, 17,  0,   0,   0,   0,   0,   0,   0,
     38,  252, 255, 255, 246, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   48,  234, 255, 255, 242, 27,  0,   0,
     0,   0,   0,   0,   1,   181, 255, 255, 254, 100, 0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   234, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255,
     255, 187, 0,   0,   104, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 48,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,
     255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   102, 212, 212, 212, 212, 212, 212, 212, 212, 212, 155, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255,
     255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   78,  194, 255, 255, 255, 255, 255, 255, 254, 184, 50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 179, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   32,  255, 255, 255, 160, 0,   0,   0,   0,   6,   54,  144, 249, 255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   0,   2,   83,  115, 51,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   60,  255, 255, 255, 96,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   227, 255, 255, 250, 16,  0,   44,  255, 255, 255, 211, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   144, 255, 255, 255, 48,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200,
     255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  77,  109, 123, 116, 86,  29,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   24,  235, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   32,  255, 255, 255, 239, 212, 212, 216, 228, 251, 255, 255, 255, 255, 255,
     130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   230, 255, 255, 255, 37,  0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 48,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 255, 255, 255, 255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   74,  251, 255, 255, 255, 159, 15,  0,   0,   0,
     0,   0,   0,   61,  182, 47,  0,   32,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 232, 92,  0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   27,  232, 255, 255, 224, 19,  0,   0,   120, 128, 128, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 144, 0,   0,
     0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 48,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 234, 212, 212, 212, 212,
     212, 212, 212, 212, 212, 212, 212, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 241, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   28,  253, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   89,  250, 255, 255, 255, 240, 154, 100, 89,  108, 154, 222, 255, 255, 48,  0,   32,  255, 255, 255, 255, 255, 255, 255, 247, 234,
     203, 159, 87,  10,  0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   0,   5,   198, 255, 255, 248, 52,  0,   0,   0,   240, 255, 255, 208, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  252, 255, 255, 244, 20,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 48,  0,   168, 255, 255, 255, 24,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   55,  219, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  255, 255, 255, 168, 0,
     0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 101, 0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   161,
     255, 255, 255, 171, 0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 48,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   200, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 80,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 255, 178, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   210, 255, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   105, 209, 255, 255, 255, 255, 255, 255, 255, 218, 138, 16,  0,   168, 255, 255, 239, 18,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   91,  255, 255, 255, 158, 0,   0,   0,   0,   0,   240,
     255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  236, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 48,  0,
     168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 255, 250, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   47,  255, 255, 255, 255, 196, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   31,  85,  113, 124, 111, 77,  27,  0,   0,   0,   0,   168, 255, 255, 255, 141, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 120, 0,   0,   24,
     255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   45,  245, 255, 255, 206, 8,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   75,  252, 255, 255, 255, 163, 23,  0,   0,   0,   0,   144, 255, 255, 255, 48,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255,
     255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   44,  143, 208, 242, 252, 237, 196, 125, 25,  0,   0,   0,   0,   0,   0,   0,   188, 255, 255, 255, 255, 255, 255, 254, 247, 237,
     213, 179, 124, 41,  0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 254, 248, 236, 212, 171, 105, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 255, 255,
     106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     168, 255, 255, 255, 248, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   0,   15,  219, 255, 255, 238, 33,  0,   0,
     0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   91,  251, 255, 255, 255, 250, 174, 124, 96,  89,  189,
     255, 255, 255, 48,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255,
     255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 212, 212, 212, 212, 212, 233, 255, 255, 255, 223, 212, 212, 212, 212, 212, 125, 0,   0,   0,   0,   0,   9,   154, 254, 255, 255, 255,
     255, 255, 255, 255, 247, 115, 0,   0,   0,   0,   0,   0,   188, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 154, 14,  0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 230, 84,  0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 255, 255, 199, 0,   0,   0,   0,   0,   0,   0,   0,   2,   229, 255, 255, 255, 255, 196, 0,
     0,   0,   0,   0,   0,   25,  118, 177, 222, 239, 251, 237, 218, 196, 144, 87,  21,  0,   0,   0,   0,   0,   168, 255, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,   0,   0,   244, 255,
     255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   1,   177, 255, 255, 254, 75,  0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   57,  220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 152, 0,   0,   0,   0,   11,  197, 255, 255, 255, 255, 245, 222, 250, 255, 255, 255, 255, 152, 0,   0,   0,   0,   0,   188, 255, 255, 255, 212,
     212, 214, 225, 239, 255, 255, 255, 255, 255, 255, 217, 16,  0,   0,   0,   60,  255, 255, 255, 234, 212, 212, 214, 225, 245, 255, 255, 255, 255, 255, 253, 80,  0,   0,   0,   0,   0,   0,   0,
     248, 255, 255, 255, 255, 255, 35,  0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 255, 255, 196, 0,   0,   0,   0,   6,   142, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120,
     0,   0,   0,   0,   0,   168, 255, 255, 255, 255, 254, 49,  0,   0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   123, 255, 255, 255,
     129, 0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   106, 207, 255,
     255, 255, 255, 255, 255, 255, 249, 200, 31,  0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 152, 0,   0,   0,   0,   170, 255,
     255, 255, 223, 80,  1,   0,   8,   108, 245, 255, 255, 255, 113, 0,   0,   0,   0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   18,  67,  150, 249, 255, 255, 255, 183, 1,   0,   0,   60,  255,
     255, 255, 132, 0,   0,   0,   0,   1,   30,  103, 222, 255, 255, 255, 239, 13,  0,   0,   0,   0,   0,   0,   248, 255, 255, 247, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   160, 255, 255,
     249, 255, 255, 196, 0,   0,   0,   6,   191, 255, 255, 255, 255, 254, 227, 216, 228, 252, 255, 255, 255, 120, 0,   0,   0,   0,   0,   168, 255, 255, 255, 255, 255, 186, 0,   0,   0,   0,   0,
     0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   69,  253, 255, 255, 184, 2,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  81,  111, 123, 109, 88,  57,  7,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 217, 25,  0,   0,   0,   0,   0,   55,  245, 255, 255, 248, 27,  0,   0,   0,
     188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   46,  236, 255, 255, 255, 78,  0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   13,  201, 255, 255, 255, 109, 0,
     0,   0,   0,   0,   0,   248, 255, 255, 180, 255, 255, 218, 0,   0,   0,   0,   0,   0,   9,   242, 255, 249, 184, 255, 255, 196, 0,   0,   0,   144, 255, 255, 255, 237, 107, 16,  0,   0,   0,
     6,   47,  109, 188, 116, 0,   0,   0,   0,   0,   168, 255, 255, 251, 255, 255, 255, 71,  0,   0,   0,   0,   0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   30,
     236, 255, 255, 224, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   46,  144, 208, 242, 252, 237, 195, 123, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   204, 255, 255, 250, 50,  0,   0,   0,   0,   0,   0,   0,   101, 255, 255, 255, 148, 0,   0,   0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 255,
     175, 0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   48,  255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   248, 255, 255, 105, 255, 255, 255, 55,  0,   0,   0,   0,
     0,   88,  255, 255, 180, 168, 255, 255, 196, 0,   0,   34,  251, 255, 255, 229, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   0,   0,   0,   0,   0,   168, 255, 255, 199, 220, 255, 255,
     208, 2,   0,   0,   0,   0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   7,   202, 255, 255, 248, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255,
     208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 232, 0,   168, 255,
     255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   0,   0,
     10,  157, 255, 255, 255, 255, 255, 255, 255, 255, 245, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   212, 255,
     255, 248, 18,  0,   0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   2,   235, 255, 255, 233, 0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     235, 255, 255, 178, 0,   0,   0,   0,   0,   0,   248, 255, 255, 26,  253, 255, 255, 148, 0,   0,   0,   0,   0,   181, 255, 255, 91,  168, 255, 255, 196, 0,   0,   120, 255, 255, 255, 85,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 102, 255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255,
     255, 168, 0,   154, 255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 232, 0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   0,   11,  198, 255, 255, 255, 255, 245, 222, 250, 255, 255, 255, 255, 144, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 255, 94,  0,   0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   193, 255, 255, 255, 4,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   232, 255, 255, 153, 0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   186, 255, 255,
     235, 4,   0,   0,   0,   21,  251, 255, 243, 10,  168, 255, 255, 196, 0,   0,   175, 255, 255, 253, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255,
     255, 196, 7,   229, 255, 255, 225, 7,   0,   0,   0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 97,  255, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  212, 212, 212, 212, 212, 212, 212, 212, 233, 255, 255, 255, 223, 212, 212, 212, 212, 212, 212,
     212, 192, 0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188,
     0,   0,   0,   0,   167, 255, 255, 255, 224, 81,  1,   0,   8,   109, 245, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   1,   229, 255, 255, 219, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   21,  254, 255, 255, 173, 0,   0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255, 254, 3,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,
     0,   0,   0,   0,   23,  254, 255, 255, 94,  0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   92,  255, 255, 255, 76,  0,   0,   0,   109, 255, 255, 161, 0,   168, 255, 255, 196, 0,   0,   197,
     255, 255, 247, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   102, 255, 255, 255, 117, 0,   0,   0,   0,   0,   244, 255, 255, 120,
     0,   0,   24,  255, 255, 255, 203, 247, 255, 255, 255, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   252, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 188, 0,   0,   0,   71,  255, 255, 255, 218, 25,  0,   0,   0,   0,   0,   56,  245, 255,
     255, 244, 22,  0,   0,   0,   0,   0,   0,   0,   34,  255, 255, 255, 152, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 233, 0,   0,   188, 255, 255, 255, 4,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   225, 255, 255, 230, 0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 247, 19,  0,   0,   0,   0,   0,   0,   248, 255,
     255, 0,   10,  243, 255, 255, 168, 0,   0,   0,   201, 255, 255, 68,  0,   168, 255, 255, 196, 0,   0,   188, 255, 255, 255, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   168, 255, 255, 196, 0,   4,   217, 255, 255, 238, 17,  0,   0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 170, 184, 255, 255, 255, 225, 21,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     4,   255, 255, 255, 188, 0,   0,   0,   196, 255, 255, 250, 52,  0,   0,   0,   0,   0,   0,   0,   103, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 107, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 18,  0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   43,  255, 255, 255, 173, 0,   0,   60,  255, 255, 255,
     132, 0,   0,   0,   0,   0,   0,   0,   26,  236, 255, 255, 144, 0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   160, 255, 255, 246, 13,  0,   37,  255, 255, 228, 2,   0,   168, 255,
     255, 196, 0,   0,   142, 255, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   83,  255, 255, 255, 140, 0,   0,   0,
     0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 17,  220, 255, 255, 255, 191, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   255, 255, 255, 187, 0,   0,   59,  255, 255, 255, 158, 0,   0,   0,   0,   0,
     0,   0,   0,   1,   214, 255, 255, 245, 14,  0,   0,   0,   0,   0,   0,   117, 255, 255, 255, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 255, 60,  0,   188, 255,
     255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 84,  0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   20,  202, 255, 255, 224, 17,  0,   0,   0,   0,
     0,   0,   0,   248, 255, 255, 0,   0,   66,  255, 255, 255, 97,  0,   130, 255, 255, 138, 0,   0,   168, 255, 255, 196, 0,   0,   55,  255, 255, 255, 255, 138, 1,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   200, 255, 255, 248, 31,  0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   44,  244, 255, 255,
     255, 144, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124,
     255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   9,   255, 255, 255, 182, 0,   0,   145, 255, 255, 255, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   142, 255,
     255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 84,  0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   75,  254, 255, 255, 214, 3,   0,
     0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   70,  221, 255, 255, 242, 53,  0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   1,   226, 255, 255, 189, 0,   221, 255, 255,
     45,  0,   0,   168, 255, 255, 196, 0,   0,   0,   176, 255, 255, 255, 255, 182, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   63,  255,
     255, 255, 163, 0,   0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   84,  255, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255,
     24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  255, 255, 255, 174, 0,   0,   223, 255, 255, 222, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  255, 255, 255, 165, 0,   0,   0,   0,   0,   0,   155, 255, 255, 255, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255,
     255, 97,  0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   98,  243, 255, 255, 252, 60,  0,   0,   0,   60,  255, 255, 255, 234, 212, 212, 212, 212, 216, 255, 255, 255, 218, 46,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   0,   134, 255, 255, 253, 85,  255, 255, 208, 0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   21,  223, 255, 255, 255, 255, 243,
     113, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   182, 255, 255, 254, 48,  0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168,
     0,   0,   0,   134, 255, 255, 255, 247, 51,  0,   0,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  255, 255, 255, 154, 0,   33,  255, 255, 255, 155, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   211, 255, 255, 228, 0,   0,   0,
     0,   0,   0,   167, 255, 255, 255, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 110, 0,   188, 255, 255, 255, 4,   0,   7,   21,  53,  106, 196, 255, 255, 255,
     254, 102, 0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 134, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   0,   40,  255, 255,
     255, 238, 255, 255, 115, 0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   32,  217, 255, 255, 255, 255, 255, 209, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196,
     0,   0,   0,   0,   46,  253, 255, 255, 186, 0,   0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   2,   182, 255, 255, 255, 225, 21,  0,   0,   0,   0,   0,   0,   0,
     240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 125, 0,   76,
     255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 255, 14,  0,   0,   0,   0,   0,   172, 255, 255, 255, 18,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   75,  255, 255, 255, 115, 0,   188, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 241, 84,  0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 113, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   0,   0,   202, 255, 255, 255, 255, 252, 24,  0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,
     15,  163, 255, 255, 255, 255, 255, 254, 161, 24,  0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   162, 255, 255, 255, 70,  0,   244, 255, 255, 120, 0,   0,
     24,  255, 255, 255, 168, 0,   0,   0,   0,   16,  219, 255, 255, 255, 192, 4,   0,   0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252,
     255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   115, 255, 255, 255, 76,  0,   119, 255, 255, 255, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255,
     255, 255, 54,  0,   0,   0,   0,   0,   161, 255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 255, 103, 0,   188, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 242, 149, 23,  0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   107, 255, 255, 255, 244, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 0,
     0,   0,   0,   108, 255, 255, 255, 255, 184, 0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   68,  212, 255, 255, 255, 255, 255, 241, 98,  0,   0,   0,   0,   0,   0,
     0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   32,  249, 255, 255, 207, 0,   244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   0,   43,  243, 255, 255, 255, 146, 0,
     0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  218, 255,
     255, 246, 15,  0,   144, 255, 255, 255, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   102, 255, 255, 255, 83,  0,   0,   0,   0,   0,   148, 255, 255, 255, 38,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 255, 91,  0,   188, 255, 255, 255, 212, 211, 203, 192, 165, 128, 72,  10,  0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,
     0,   0,   2,   199, 255, 255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   0,   0,   19,  250, 255, 255, 255, 91,  0,   0,   0,   0,   168, 255, 255, 196,
     0,   0,   0,   0,   0,   0,   0,   0,   3,   107, 237, 255, 255, 255, 255, 255, 156, 3,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   143, 255, 255, 255, 61,  244,
     255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   82,  254, 255, 255, 255, 95,  0,   0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   252, 255, 255, 120, 0,   243, 189, 81,  6,   0,   0,   0,   0,   0,   15,  175, 255, 255, 255, 144, 0,   0,   157, 255, 255, 255, 34,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   91,  255, 255, 255, 95,  0,   0,   0,   0,   0,   133, 255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 75,  0,   188, 255, 255, 255,
     4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   44,  250, 255, 255, 255, 85,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   248, 255, 255, 0,   0,   0,   0,   0,   82,  104, 104, 104, 10,  0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  154, 254, 255, 255, 255, 255,
     156, 0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   19,  241, 255, 255, 164, 244, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,
     132, 255, 255, 255, 247, 52,  0,   0,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255,
     255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   252, 255, 255, 120, 0,   244, 255, 255, 237, 171, 116, 91,  101,
     147, 233, 255, 255, 255, 214, 9,   0,   0,   170, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 108, 0,   0,   0,   0,   0,   96,  255, 255, 255,
     90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   147, 255, 255, 255, 38,  0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,
     255, 255, 255, 132, 0,   0,   0,   0,   0,   132, 255, 255, 255, 230, 15,  0,   0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  228, 255, 255, 255, 255, 90,  0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,
     123, 255, 255, 248, 251, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   2,   180, 255, 255, 255, 226, 22,  0,   0,   0,   240, 255, 255, 208, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 24,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   253, 255, 255, 120, 0,   244, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 208, 34,  0,   0,   0,   171, 255, 255, 255, 18,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   74,  255, 255, 255, 116, 0,   0,   0,   0,   0,   54,  255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 249, 3,
     0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   8,   218, 255, 255, 255, 152, 0,   0,
     0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   25,  212, 255, 255, 255, 221, 1,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   11,  231, 255, 255, 255, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,
     0,   0,   0,   0,   0,   0,   15,  217, 255, 255, 255, 193, 4,   0,   0,   240, 255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   255, 255, 255, 119, 0,   50,  144, 220,
     255, 255, 255, 255, 255, 255, 255, 241, 139, 9,   0,   0,   0,   0,   163, 255, 255, 255, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 105, 0,   0,   0,   0,
     0,   12,  251, 255, 255, 184, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   238, 255, 255, 207, 0,   0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 254, 59,  0,   0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  249, 255, 255, 255, 55,  0,   0,   0,   168, 255, 255, 196, 0,   0,
     0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 255, 255, 120, 0,   0,   24,  255, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   0,   0,   41,  242, 255, 255, 255, 147, 0,   0,   240, 255,
     255, 247, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   160,
     255, 255, 255, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   255, 255, 255, 111, 0,   0,   0,   0,   29,  75,  108, 122, 121, 102, 61,  5,   0,   0,   0,   0,   0,   0,   146, 255, 255,
     255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 91,  0,   0,   0,   0,   0,   0,   190, 255, 255, 245, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,
     255, 255, 255, 133, 0,   0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   157,
     255, 255, 255, 213, 5,   0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   150, 255, 255, 255, 102, 0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   4,   218, 255, 255, 255, 255, 120, 0,   0,   24,  255,
     255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  254, 255, 255, 255, 96,  0,   240, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 156, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  255, 255, 255,
     98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 255,
     77,  0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 54,  0,   0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   17,  233, 255, 255, 255, 125, 0,   0,   0,   0,   0,   0,   248, 255, 255, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   91,  255, 255, 255, 113, 0,   0,   0,   168,
     255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   240, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   132, 255, 255, 255, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  255, 255, 255, 68,  0,   86,  212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212,
     122, 0,   84,  255, 255, 255, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 43,  0,   0,   0,   0,   0,   0,   23,  246, 255, 255, 213, 4,   0,   0,   0,   0,
     0,   0,   0,   27,  247, 255, 255, 210, 1,   0,   0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,
     0,   0,   0,   0,   0,   88,  255, 255, 255, 248, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 255, 92,  0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   202, 255, 255, 255,
     120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   90,  255, 255, 255, 25,  0,   104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 148, 0,   39,  255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   176, 255, 255, 251, 5,   0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   1,   188, 255, 255, 255, 84,  0,   0,   0,   188, 255, 255, 255, 4,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   182, 255, 255, 255, 190, 0,   0,   0,   0,   0,   80,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255,
     40,  0,   0,   0,   168, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  255, 255, 255, 120, 0,   40,  128, 128, 128, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   60,  128, 128, 128, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 214, 0,   0,   104, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 148, 0,   2,   238, 255, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   230, 255, 255, 215, 0,   0,   0,   0,   0,   0,   0,   0,   21,  236, 255, 255,
     254, 118, 0,   0,   0,   0,   7,   167, 255, 255, 255, 200, 1,   0,   0,   0,   188, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  244, 255, 255, 255, 97,  0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     68,  0,   0,   0,   10,  50,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  243, 255, 255, 209, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   22,  253, 255, 255, 223, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   181, 255, 255, 227, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  244, 255, 255, 246, 36,  0,   0,
     0,   0,   0,   0,   0,   47,  253, 255, 255, 116, 0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   174, 255, 255, 238, 2,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   42,  255, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   74,  252, 255, 255, 255, 206, 117, 93,  130, 227, 255, 255, 255, 234, 34,  0,   0,   0,   0,   188,
     255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255, 255, 255, 237,
     21,  0,   0,   0,   66,  212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 217, 255, 255, 255, 255, 65,  0,   0,   0,   24,  255, 197, 99,  20,  0,   0,   0,   0,   0,   0,   0,   63,
     223, 255, 255, 255, 74,  0,   0,   0,   0,   0,   159, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 46,  0,   0,   0,   0,   196, 255, 255, 255, 48,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   12,  248, 255, 255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   148, 255, 255, 255, 219, 45,  0,   0,   0,   0,   0,   49,  228, 255, 255, 227, 11,  0,   0,   104, 255, 255, 255, 12,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255, 255, 255, 67,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   83,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 227, 47,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     121, 255, 255, 255, 213, 5,   0,   0,   0,   24,  255, 255, 255, 252, 202, 150, 111, 93,  96,  128, 200, 255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 56,  0,   0,   0,   0,   116, 255, 255, 255, 128, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 255, 69,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  214,
     255, 255, 255, 252, 177, 113, 91,  115, 179, 253, 255, 255, 251, 65,  0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  244, 255, 255,
     192, 0,   0,   0,   0,   0,   0,   0,   0,   12,  237, 255, 255, 236, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  172, 252, 255, 255, 255, 255, 255, 244, 145, 16,  0,   0,
     0,   0,   0,   0,   58,  128, 128, 123, 0,   0,   0,   0,   0,   49,  128, 128, 128, 14,  0,   0,   0,   0,   0,   86,  128, 128, 32,  0,   0,   136, 255, 255, 255, 104, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  245, 255, 255, 255, 62,  0,   0,   0,   0,   24,  255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 253, 130, 2,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 56,  0,   0,   0,   0,   36,  255, 255, 255,
     209, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 239, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  204, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 245, 81,  0,   0,   0,   0,
     104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 255, 255, 98,  0,   0,   0,   0,   0,   0,   0,   155, 255, 255, 255, 115, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  81,  115, 124, 110, 69,  9,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 12,  0,   0,   0,   0,   133, 255, 255, 255,
     64,  0,   0,   0,   0,   0,   195, 255, 255, 40,  0,   0,   0,   123, 255, 255, 253, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   178, 255, 255, 255, 161, 0,   0,   0,   0,   0,   1,   61,  144, 220, 255, 255, 255, 255, 255, 255, 255, 255, 246, 163, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   212, 255, 255, 255, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   240, 255, 255, 165, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   4,   118, 216, 255, 255, 255, 255, 255, 255, 251, 171, 37,  0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   23,  238, 255, 255, 245, 72,  0,   0,   0,   0,   0,   119, 255, 255, 255, 221, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 41,  0,   0,   0,   0,   177, 255, 255, 255, 112, 0,   0,   0,   0,   0,   225, 255, 255, 9,   0,   0,   0,   0,   109, 254, 255,
     249, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255, 255, 239, 22,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   26,  74,  105, 120, 123, 109, 92,  49,  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,
     0,   0,   132, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  84,  109, 123, 111, 75,  17,  0,   0,
     0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   89,  255, 255, 255, 251, 155, 65,  41,  78,  184, 255, 255, 255, 252,
     69,  0,   0,   0,   0,   0,   0,   20,  239, 255, 255, 255, 61,  0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  253, 255, 255, 185, 0,   0,   0,   0,   34,  255, 255, 255, 69,  0,   0,   0,
     0,   221, 255, 255, 255, 161, 0,   0,   0,   0,   3,   252, 255, 233, 0,   0,   0,   0,   0,   0,   96,  252, 255, 242, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   11,  225, 255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   51,  255, 255, 255, 194, 0,   0,   0,   0,   0,   0,   0,   0,   0,   151,
     255, 255, 249, 13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 68,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 94,  0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 205, 1,   0,   0,   0,
     0,   0,   0,   0,   0,   196, 255, 255, 251, 41,  0,   0,   0,   0,   6,   254, 255, 255, 98,  0,   0,   0,   10,  254, 255, 255, 255, 209, 0,   0,   0,   0,   30,  255, 255, 202, 0,   0,   0,
     0,   0,   0,   0,   84,  250, 255, 234, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 255, 255, 255, 201, 2,   0,   0,   0,   0,
     0,   0,   0,   115, 128, 128, 128, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  128, 128, 128, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255,
     255, 56,  0,   0,   0,   0,   0,   0,   226, 255, 255, 252, 21,  0,   0,   0,   0,   0,   0,   0,   1,   229, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  200, 255, 255, 255, 255, 255,
     255, 255, 202, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   218, 255, 255, 255, 97,  0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 144, 0,   0,   0,   0,   0,   0,   230, 255,
     255, 127, 0,   0,   0,   53,  255, 255, 255, 255, 250, 7,   0,   0,   0,   61,  255, 255, 171, 0,   0,   0,   0,   0,   0,   0,   0,   73,  246, 255, 224, 26,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  250, 255, 255, 252, 50,  0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 195, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   145, 255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   147, 255, 255, 255, 99,  0,   0,   0,   0,
     0,   0,   0,   55,  255, 255, 255, 103, 0,   0,   0,   0,   32,  246, 255, 253, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  120, 167, 253, 255, 249, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255,
     255, 230, 12,  0,   0,   0,   0,   0,   11,  228, 255, 255, 235, 16,  0,   0,   0,   0,   0,   0,   200, 255, 255, 155, 0,   0,   0,   97,  255, 255, 255, 255, 255, 50,  0,   0,   0,   91,  255,
     255, 139, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 147, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   9,   227, 255, 255, 255, 85,  0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  250, 255, 255, 181, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   67,  255, 255, 255, 179, 0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 254, 25,  0,   0,   0,   0,   0,   123, 255, 255, 203,
     2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  249, 30,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   170, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   189, 255, 255, 255, 133, 0,   0,   0,   0,   0,   133, 255, 255, 255, 103, 0,   0,   0,   0,
     0,   0,   0,   170, 255, 255, 184, 0,   0,   0,   141, 255, 252, 203, 255, 255, 99,  0,   0,   0,   122, 255, 255, 108, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 255, 231, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 222, 7,   0,   0,
     0,   0,   0,   0,   0,   0,   178, 255, 255, 252, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   4,   238, 255, 255,
     247, 11,  0,   0,   0,   0,   0,   0,   216, 255, 255, 200, 0,   0,   0,   0,   0,   0,   6,   217, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   208, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255,
     255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  251, 255, 251, 61,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   46,  253, 255, 255, 247, 32,  0,   0,   0,   34,  248, 255, 255, 208, 2,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 213, 0,   0,   0,   186, 255, 224, 164, 255, 255, 147,
     0,   0,   0,   152, 255, 255, 77,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  233, 255,
     255, 255, 90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   205, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   67,  255, 255, 255, 151, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 255, 84,  0,   0,   0,   0,   0,   40,  255, 255, 255, 120, 0,   0,   0,   0,   0,
     0,   0,   69,  255, 255, 239, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 250, 32,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 239, 73,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   154, 255, 255, 255, 170, 0,   0,   0,   176, 255, 255, 255, 63,
     0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 241, 0,   0,   0,   230, 255, 191, 129, 255, 255, 196, 0,   0,   0,   183, 255, 255, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  255,
     255, 255, 241, 22,  0,   0,   0,   0,   0,   2,   208, 255, 255, 242, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,
     0,   0,   83,  255, 255, 255, 164, 0,   0,   0,   0,   0,   120, 255, 255, 255, 41,  0,   0,   0,   0,   0,   0,   0,   0,   169, 255, 255, 163, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   211, 255, 255, 255, 157, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   196, 255, 255, 255, 183, 89,  28,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  241, 255, 255, 255, 60,  0,   69,  255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 14,  0,   18,  255, 255,
     151, 85,  255, 255, 242, 1,   0,   0,   213, 255, 255, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   54,  253, 255, 255, 249, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 153, 0,   0,   0,   0,   0,   100, 255, 255, 255, 122, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   11,  247, 255, 255, 239, 5,   0,   0,   0,   0,   201, 255, 255, 217, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   27,  242, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255,
     255, 255, 251, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  193, 255, 255, 255, 255, 255, 242, 224, 163, 0,   0,   0,   0,   0,   0,   0,   118, 255, 255, 255, 204, 6,   214,
     255, 255, 246, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  255, 255, 255, 43,  0,   62,  255, 255, 106, 36,  255, 255, 255, 37,  0,   0,   243, 255, 239, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   206, 255, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   37,  250, 255, 255, 252, 45,  0,   0,   0,   12,  232, 255, 255, 226, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,
     0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 255, 69,  0,   0,   0,   26,  254, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 213, 5,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   214, 255, 255, 197, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,
     144, 252, 255, 255, 255, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   7,   221, 255, 255, 255, 192, 255, 255, 255, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255,
     71,  0,   106, 255, 255, 62,  1,   241, 255, 255, 85,  0,   18,  255, 255, 208, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   110, 255, 255, 255, 222, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 255, 187, 0,   0,   0,   133, 255, 255, 255,
     92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 255, 149, 0,   0,   0,   105,
     255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   211, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   91,  255, 255, 203, 19,  242, 255, 252, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  138, 194, 227, 246, 253, 196, 0,   0,   0,   0,   0,   0,   0,   0,   83,
     255, 255, 255, 255, 255, 255, 226, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   245, 255, 255, 100, 0,   150, 255, 255, 17,  0,   193, 255, 255, 133, 0,   49,  255, 255, 176, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  241, 255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  238, 255, 255, 255, 76,  0,   30,  247, 255, 255, 204, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   21,  252, 255, 255, 228, 1,   0,   0,   186, 255, 255, 232, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   61,  254,
     255, 245, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   217, 255, 255, 74,  0,   131, 255, 255, 164, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   193, 255, 255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   216, 255, 255, 129, 0,   194, 255, 228, 0,   0,   143, 255, 255, 182, 0,   79,  255, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   167, 255, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 216, 4,
     166, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   194, 255, 255,
     255, 54,  0,   15,  250, 255, 255, 155, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   94,  255, 255, 201, 0,   0,   17,  241, 255, 253, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255,
     12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 99,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   50,  253, 255, 255, 255, 195, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 157, 0,   238, 255, 183, 0,   0,   93,  255, 255, 230, 0,
     110, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  255, 255, 255, 244, 30,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   220, 255, 255, 255, 161, 254, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 134, 0,   90,  255, 255, 255, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   22,  239, 255, 255, 75,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   219, 255, 255, 72,  0,   0,   0,   129, 255, 255, 167, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   214, 255, 255, 255, 168, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 186, 27,  255, 255, 139, 0,   0,   44,  255, 255, 255, 22,  141, 255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   217, 255, 255, 255, 118, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     83,  255, 255, 255, 255, 255, 255, 250, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   34,  255, 255, 255, 214, 0,   167, 255, 255, 243, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 222, 9,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 198, 0,   0,   0,   0,   16,  239, 255, 253, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 120,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  255, 255, 255, 255, 255, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 215, 71,  255, 255, 94,  0,   0,
     3,   246, 255, 255, 71,  171, 255, 255, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 212,
     5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 255, 255, 255, 145, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   209, 255, 255, 255, 32,  232, 255, 255, 172, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   204, 255, 255, 133, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   222, 255, 255, 69,  0,   0,   0,   0,
     0,   126, 255, 255, 171, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   224, 255, 255, 255, 255, 255, 200,
     1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 241, 110, 255, 255, 49,  0,   0,   0,   201, 255, 255, 119, 201, 255, 255, 20,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  247, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   53,  254, 255, 255, 255, 239, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   129, 255, 255, 255, 145, 255, 255, 255, 93,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,  253, 255, 249, 39,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 255, 255, 195, 0,   0,   0,   0,   0,   0,   14,  238, 255, 254, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  75,  109, 123, 112, 82,  42,  4,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   125, 255, 255, 255, 251, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 150,
     255, 252, 8,   0,   0,   0,   151, 255, 255, 156, 225, 255, 244, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   182,
     255, 255, 255, 161, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   167, 255, 255, 255, 119, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  255, 255, 255, 249, 255, 255, 251, 17,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   224, 255, 255, 66,
     0,   0,   0,   0,   0,   0,   0,   123, 255, 255, 174, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  184, 253, 255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  244, 255, 255,
     217, 97,  255, 255, 255, 227, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   36,  255, 255, 255, 205, 255, 216, 0,   0,   0,   0,   102, 255, 255, 188, 246, 255, 213, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  255, 255, 255, 238, 22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255,
     255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 255, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     17,  234, 255, 255, 90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 193, 0,   0,   0,   0,   0,   0,   0,   0,   13,  237, 255, 254, 48,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   138, 254, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   164, 255, 255, 255, 75,  1,   201, 255, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     7,   254, 255, 255, 255, 255, 171, 0,   0,   0,   0,   52,  255, 255, 237, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   185, 255, 255, 255, 241, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 115, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 72,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255,
     255, 255, 255, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 231, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,
     227, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   121, 255, 255, 177, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   165, 255, 255, 255, 255, 213, 134, 100, 92,  112, 156, 225, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     56,  254, 255, 255, 182, 0,   0,   58,  255, 255, 255, 245, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   232, 255, 255, 255, 255, 126, 0,   0,   0,   0,   7,   251, 255, 255, 255, 255,
     151, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   188, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  255, 255, 255, 255, 255, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   1,   196, 255, 255, 146, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 190, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  235, 255, 255,
     51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255,
     255, 235, 88,  0,   0,   0,   0,   0,   0,   128, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   1,   201, 255, 255, 250, 39,  0,   0,   0,   168, 255, 255, 255, 163, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   202, 255, 255, 255, 255, 81,  0,   0,   0,   0,   0,   209, 255, 255, 255, 255, 119, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   188, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 140, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     120, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   3,   237, 255, 255, 255, 207, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  252, 255, 252, 49,  0,   0,   0,   0,   0,
     0,   0,   0,   8,   229, 255, 255, 61,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   118, 255, 255, 181, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104,
     255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   50,  253, 255, 255, 231, 41,  0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 248, 0,   0,   0,   0,
     0,   0,   0,   0,   94,  255, 255, 255, 141, 0,   0,   0,   0,   31,  247, 255, 255, 254, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 255, 37,  0,   0,   0,   0,   0,
     159, 255, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   160, 255, 255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 255, 200, 2,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   11,  233, 255, 255, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   189, 255, 255, 254, 69,  0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   11,  229, 255, 255, 233, 15,  0,   0,   0,   0,   0,   134, 255, 255,
     255, 197, 0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 246, 2,   0,   0,   0,   0,   0,   110, 255, 255, 255, 255, 57,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   120, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  230, 255, 255,
     103, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   45,  255, 255, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255,
     248, 0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 255, 100, 0,   0,   0,   0,   0,   0,   13,  232, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 203, 0,
     0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255,
     16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   0,   14,  76,  103, 123, 116, 96,  62,  16,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 237, 20,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   132, 255, 255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 248, 0,   0,   0,   0,   0,   0,   32,  247, 255, 255, 205, 2,   0,   0,   0,   0,
     0,   0,   0,   100, 255, 255, 255, 224, 8,   0,   0,   0,   0,   0,   0,   0,   82,  255, 255, 255, 158, 0,   0,   0,   0,   0,   0,   13,  254, 255, 255, 248, 1,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255,
     56,  0,   0,   0,   0,   0,   0,   56,  183, 250, 255, 255, 255, 255, 255, 255, 254, 213, 141, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   189, 255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 255, 247, 5,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   128, 255, 255, 248, 0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   0,   2,   208, 255, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   51,
     255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   217, 255, 255, 219, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 72,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   0,   0,   7,   158, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  249, 255, 254, 60,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 214, 212, 212, 212,
     212, 212, 212, 212, 212, 212, 212, 122, 0,   0,   241, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 248, 0,   0,   0,   0,   0,   63,  255, 255, 255, 166, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   66,  255, 255, 255, 243, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   60,  255, 255, 255, 56,  0,   0,   0,   14,  200, 255, 255, 255, 255, 195, 127, 96,  96,  120, 167, 231, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255, 211, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 148, 0,   12,  255, 255, 255, 180, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   128, 255, 255, 248, 0,   0,   0,   0,   2,   207, 255, 255, 245, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   177, 255, 255, 255, 159, 0,   0,
     0,   0,   0,   0,   0,   0,   28,  85,  115, 121, 99,  51,  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  79,  112, 124, 116, 103, 79,  42,  6,   0,
     0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255,
     255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   3,   184, 255, 255, 255, 197, 44,  0,   0,
     0,   0,   0,   0,   1,   55,  153, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  225, 255, 255, 116, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 148, 0,   24,  255, 255, 255, 167, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   137, 255, 255, 248, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  191, 254, 255, 255, 255, 255, 255, 227, 100, 1,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  188, 254, 255, 255, 255, 255, 255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 56,  0,   0,   115, 255, 255, 255, 186, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 243, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255,
     255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   16,  255, 255,
     255, 176, 0,   0,   0,   0,   0,   0,   0,   0,   0,   21,  238, 255, 255, 248, 0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  64,  105, 121, 116, 90,  51,  10,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   5,   152, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 171, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  250, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 132, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   120, 255, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   159, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 222, 255, 255, 255, 56,  0,   15,  237, 255, 255, 241,
     22,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   180,
     255, 255, 173, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   252, 255, 255, 207, 0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 255, 248, 0,
     0,   0,   0,   0,   0,   0,   31,  160, 245, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   3,   179, 255, 255, 255, 229, 141, 95,  92,  131, 223,
     255, 255, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 253, 188, 118, 92,  104, 129, 178, 242, 132, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     192, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 56,  0,   95,  255, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  247, 255, 255, 72,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   211, 255, 255, 250, 16,  0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 255, 250, 0,   0,   0,   0,   0,   0,   94,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255, 255, 146, 8,   0,   0,   0,   0,   7,   167, 255, 255, 255, 60,  0,   0,   0,   0,   0,   0,   0,   25,  239, 255, 255, 227,
     57,  0,   0,   0,   0,   0,   0,   4,   21,  0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   14,  79,  118, 112, 65,  2,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   56,  113, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 56,  0,
     168, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   126, 255, 255, 220, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 114, 0,   0,   0,   0,   0,   0,   107, 254, 255,
     249, 255, 255, 255, 1,   0,   0,   0,   0,   111, 255, 255, 255, 255, 229, 148, 105, 90,  107, 145, 208, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   41,  251, 255, 255, 149, 0,   0,
     0,   0,   0,   0,   0,   6,   221, 255, 255, 168, 0,   0,   0,   0,   0,   0,   0,   141, 255, 255, 251, 55,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100,
     255, 255, 255, 16,  0,   0,   29,  154, 247, 255, 255, 255, 255, 220, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   96,  255, 255, 249, 61,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   210, 255, 255, 247, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   11,  64,  105, 121, 120, 105, 82,  115, 255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 243, 50,  0,   0,   0,   10,  148, 255, 255, 222, 125, 255, 255, 255, 19,  0,   0,   0,   74,  254, 255, 255, 251, 122, 6,   0,   0,
     0,   0,   0,   72,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   162, 255, 255, 234, 11,  0,   0,   0,   0,   0,   0,   0,   0,   130, 255, 255, 243, 2,   0,   0,   0,   0,   0,   0,
     220, 255, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   98,  244, 255, 255, 255, 255, 255, 255, 255, 252, 99,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   205, 255, 255, 255, 164, 0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   233, 255, 255, 218, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  111, 27,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   31,  160, 245, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 48,  0,   32,  255, 255,
     255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   166, 255, 255, 255, 244, 135, 92,  132,
     229, 255, 255, 232, 39,  78,  255, 255, 255, 47,  0,   0,   14,  233, 255, 255, 250, 79,  0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   11,  247, 255,
     255, 139, 0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 42,  0,   0,   0,   0,   0,   15,  255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   100, 255, 255, 255, 16,  125, 255, 255, 255, 185, 105, 99,  191, 255, 255, 255, 251, 57,  0,   0,   0,   0,   0,   0,   0,   0,   205, 255, 255, 255, 165, 0,   0,   0,   0,
     0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   237, 255, 255, 213, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   129, 255, 255, 239, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   94,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  199, 255, 255, 255, 255, 255, 255, 255, 255, 202, 31,  0,   40,  255, 255, 255, 91,  0,   0,   133, 255, 255, 255, 124,
     0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   75,  255, 255, 255, 227, 212, 212, 212, 212, 212, 212, 212, 212, 212, 227, 255, 255, 255, 75,  0,
     0,   0,   0,   0,   46,  255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 111, 255, 255, 232, 69,  0,   0,   0,   1,
     150, 255, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 251, 63,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   218, 255, 255, 241, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     237, 255, 255, 255, 128, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 255, 229, 148, 105, 90,  107, 145, 208, 255, 255, 255,
     48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   144,
     251, 255, 255, 255, 255, 220, 103, 3,   0,   0,   3,   242, 255, 255, 155, 0,   8,   236, 255, 255, 225, 3,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   0,   0,   0,
     0,   0,   122, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 91,  0,   0,   0,   0,   0,   67,  255, 255, 255, 45,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 250, 255, 219, 31,  0,   0,   0,   0,   0,   6,   219, 255, 255, 255, 41,  0,   0,   0,   0,   0,   0,   0,   0,   57,  114, 41,
     0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   175, 255, 255, 255, 51,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   237, 255, 255, 255, 129, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   74,  254, 255, 255, 251, 122, 6,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  94,  121, 107, 53,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,
     255, 255, 255, 122, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 103, 0,   0,   0,   0,   0,   75,  255, 255, 255, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 255, 232, 33,  0,
     0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 255, 150, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   132, 255, 255, 240, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  233, 255, 255, 250, 79,  0,   0,   0,   0,   0,   0,
     0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255,
     48,  0,   0,   0,   0,   0,   0,   145, 255, 255, 255, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255, 255, 36,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 253, 67,  0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 145, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  245,
     255, 255, 248, 37,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  112, 28,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   133, 255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   11,
     75,  115, 114, 80,  12,  0,   0,   0,   0,   0,   192, 255, 255, 255, 255, 255, 255, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   185, 255, 255, 252, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   124, 255, 255, 255, 72,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   192, 212, 212, 212, 225, 255, 255, 255, 218, 212, 212, 212, 212, 212, 212, 212, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255,
     255, 148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  255, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   134, 255, 255, 255, 200, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   236, 255, 255, 225, 3,   0,   0,
     0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   17,  142, 243, 255, 255, 255, 255, 240, 124, 2,   0,   0,   0,   192, 255, 255, 255, 255, 255, 255,
     255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   212, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   72,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   79,  255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   232, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  255, 255, 255, 171, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   8,   208, 255, 255, 255, 196, 39,  0,   0,   0,   0,   0,   0,   0,   15,  88,  46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 122, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,
     0,   51,  223, 255, 255, 255, 255, 255, 255, 255, 255, 169, 0,   0,   0,   159, 212, 212, 212, 212, 212, 236, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 223, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   15,  250, 255, 255, 212,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   232, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  255, 255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  217, 255, 255, 255, 250, 185, 120, 96,  92,  109, 136,
     193, 250, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255,
     255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  69,  248, 255, 255, 225, 133, 93,  129, 239, 255, 255, 255, 88,  0,   0,   0,   0,
     0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 232, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   2,   201, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   169, 255, 255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   54,
     255, 255, 255, 132, 0,   16,  255, 255, 255, 255, 255, 255, 255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  176, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   185, 255, 255, 252, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,
     32,  255, 255, 255, 123, 239, 255, 251, 125, 6,   0,   0,   0,   43,  246, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 255, 253, 9,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,
     0,   47,  252, 255, 255, 232, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  16,  0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 255, 88,  0,   16,  255, 255, 255, 255, 255, 255, 255, 255, 255, 36,  0,
     0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   0,   87,  250, 255, 255, 248, 81,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   71,  188, 252, 255,
     255, 255, 255, 255, 255, 255, 237, 173, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   212, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 251, 255, 249, 77,  0,   0,   0,   0,   0,   0,   156, 255, 255,
     246, 1,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   155, 255, 255,
     255, 66,  0,   0,   0,   0,   0,   0,   0,   69,  251, 255, 255, 255, 255, 47,  0,   0,   0,   0,   0,   0,   0,   0,   139, 255, 255, 255, 228, 56,  0,   0,   0,   0,   0,   0,   11,  95,  203,
     255, 28,  0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   174, 255, 255, 254, 22,  0,   13,  212, 212, 212, 212, 212, 225, 255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,
     104, 253, 255, 255, 243, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  74,  109, 124, 121, 105, 74,  33,  0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 223, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,
     255, 255, 255, 48,  0,   32,  255, 255, 255, 255, 249, 76,  0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 255, 19,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   63,  242, 255, 250, 255, 255, 255, 45,  0,
     0,   0,   0,   0,   0,   0,   0,   4,   184, 255, 255, 255, 255, 192, 124, 93,  99,  127, 184, 244, 255, 255, 255, 28,  0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   29,  252, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   0,   80,
     255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   122, 255, 255, 255, 236, 54,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 232, 0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   201, 255, 255, 255, 48,  0,   32,  255, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,
     0,   0,   87,  255, 255, 255, 31,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   11,  240, 255, 255, 255, 94,  0,   0,   0,   1,   107, 248, 255, 247, 120, 255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   161, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 212, 16,  0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,
     0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,
     0,   0,   1,   140, 255, 255, 255, 229, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   80,  121, 86,  4,   0,   0,   0,   0,   24,  101, 118, 47,  0,   0,   0,   0,   0,   49,
     212, 212, 212, 212, 212, 212, 212, 212, 231, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 255, 253, 9,   0,   0,   0,   0,   0,
     0,   0,   0,   120, 255, 255, 255, 255, 48,  0,   32,  255, 255, 255, 202, 3,   0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255,
     228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 255, 254, 159, 92,  117, 209, 255, 255, 250, 77,  72,
     255, 255, 255, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  198, 255, 255, 255, 255, 255, 255, 255, 228, 152, 62,  0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 191, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   3,   158, 255, 255, 255, 219, 32,  0,   0,   0,   0,   0,   0,   176, 255, 255,
     88,  0,   31,  208, 255, 255, 255, 198, 5,   0,   0,   102, 247, 255, 255, 253, 98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 4,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   155, 255, 255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   69,  251, 255, 255, 255, 255, 48,  0,   32,  255, 255, 255, 88,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 39,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 228, 61,  0,   73,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     30,  86,  116, 123, 109, 81,  33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   18,  158, 255, 255, 255, 240, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255,
     255, 255, 64,  0,   0,   7,   174, 255, 255, 255, 209, 23,  0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 88,  17,  220, 255, 255, 255, 255, 255, 107, 0,   110, 255, 255, 255, 255, 255, 242,
     9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 255, 170,
     0,   0,   0,   0,   0,   0,   63,  242, 255, 250, 255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   0,   0,   0,
     0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 240, 255, 255, 255, 255, 236,
     131, 14,  0,   0,   83,  255, 255, 255, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 188, 133, 102, 89,  109, 163, 241, 255, 255, 255, 247, 66,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   12,  188, 255, 255, 255, 196, 16,  0,   0,   0,   0,   0,   0,
     0,   0,   176, 255, 255, 88,  168, 255, 188, 100, 218, 255, 255, 176, 51,  251, 251, 136, 120, 253, 255, 255, 67,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255,
     4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  240, 255, 255, 255, 94,  0,   0,   0,   1,   107, 248, 255, 247, 120, 255, 255, 255, 48,  0,   32,  255,
     255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  82,  118, 114, 68,  5,   0,   0,   0,   0,   101, 255, 255, 253, 8,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   11,  75,  115, 114, 79,  11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   100, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 230, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,
     0,   0,   0,   52,  255, 255, 255, 64,  19,  202, 255, 255, 255, 183, 10,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 156, 255, 191, 4,   0,   75,  255, 255, 207, 187, 255, 86,
     0,   0,   185, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   110, 255, 255, 255, 254, 159, 92,  117, 209, 255, 255, 250, 77,  72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,
     0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   145, 255, 255, 214, 0,   0,   32,  255, 255, 255, 84,  0,   0,   17,  142, 243, 255, 255, 255, 255, 238, 120, 1,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235,
     137, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 91,  214, 255, 255, 255, 168, 5,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 253, 248, 33,  0,   0,   33,  255, 255, 242, 255, 161, 0,   0,   0,   152, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   112, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 228, 61,  0,   72,  255, 255,
     255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   229, 255, 255, 162, 0,   0,   32,  255,
     255, 255, 84,  0,   51,  223, 255, 255, 255, 255, 255, 255, 255, 255, 161, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  62,  99,  123, 119, 100, 55,  5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255,
     255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 180, 255, 255, 255, 252, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 137, 0,   0,   0,   20,  255,
     255, 255, 249, 29,  0,   0,   0,   145, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   109, 240, 255, 255, 255, 255, 236, 131, 14,  0,   0,   72,  255, 255, 255, 48,  0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     76,  255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     132, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 75,  0,   0,   32,  255, 255, 255, 84,  69,  248, 255, 255, 225, 133, 93,  129, 239, 255, 255, 255, 78,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  147, 255, 255, 255,
     232, 38,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 248, 22,  0,   0,   0,   16,  255, 255, 255, 163, 0,   0,   0,   0,   144, 255, 255, 120, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  82,  118, 114, 68,  5,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 249, 164, 56,  0,   0,   0,   0,   0,   0,   0,   23,  160, 255, 255, 255, 196,
     1,   0,   0,   32,  255, 255, 255, 123, 239, 255, 251, 125, 6,   0,   0,   0,   43,  246, 255, 255, 183, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  79,  118, 112, 65,  2,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  1,   162, 255, 255, 255, 226, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 160, 0,
     0,   0,   0,   16,  255, 255, 255, 61,  0,   0,   0,   0,   144, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   208, 255, 255, 255, 230, 161, 118, 94,  94,  120, 177, 248, 255, 255, 255, 224, 31,  0,   0,   0,   32,  255, 255, 255, 251, 255, 249, 77,  0,   0,   0,   0,   0,   0,
     156, 255, 255, 232, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255,
     255, 255, 16,  0,   0,   29,  154, 247, 255, 255, 255, 255, 220, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255,
     64,  0,   4,   175, 255, 255, 255, 219, 25,  0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 89,  0,   0,   0,   0,   16,  255, 255, 229, 1,   0,   0,   0,   0,   144, 255, 255, 120, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 4,   0,   0,   0,   0,   0,   0,   0,   0,   22,  82,  107, 121, 102, 73,  11,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,
     144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 188, 27,  0,   0,   0,   0,   32,  255, 255, 255, 255, 249, 76,  0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 255, 6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255,
     255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   98,  244, 255, 255, 255, 255, 255, 255, 255, 252, 99,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   7,   188, 255, 255, 255, 212, 19,  0,   0,   0,   0,   0,   0,   0,
     176, 255, 255, 88,  0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   144, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 4,   0,
     0,   0,   0,   0,   0,   64,  195, 253, 255, 255, 255, 255, 255, 248, 173, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255,
     84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   45,  142, 221, 255, 255, 255, 255, 255, 255, 255, 251, 186, 76,  0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 255, 120, 0,   0,   0,
     0,   0,   0,   0,   0,   87,  255, 255, 255, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   100, 255, 255, 255, 16,  125, 255, 255, 255, 185, 105, 99,  191, 255, 255, 255, 251, 57,  0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,
     0,   52,  255, 255, 255, 64,  0,   0,   0,   12,  200, 255, 255, 255, 204, 14,  0,   0,   0,   0,   0,   0,   176, 255, 255, 88,  0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,
     144, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 4,   0,   0,   0,   0,   3,   154, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 109,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,
     0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  77,  108,
     122, 119, 103, 64,  15,  0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 202, 3,   0,   0,   0,   0,   0,   0,   0,   0,   79,  255, 255, 255, 32,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 111, 255, 255, 232, 69,  0,   0,   0,   1,   150,
     255, 255, 255, 196, 0,   0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   17,  210, 255, 255, 255, 195, 10,
     0,   0,   0,   0,   0,   176, 255, 255, 88,  0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   144, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112,
     255, 255, 255, 4,   0,   0,   0,   1,   174, 255, 255, 255, 246, 166, 107, 90,  113, 183, 254, 255, 255, 255, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255,
     88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 37,  0,   0,   0,   0,   0,   0,   0,   0,   11,  64,  105, 121, 116, 90,  51,  10,  0,   0,   0,   0,   0,   28,  255, 255,
     236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 250, 255, 219, 31,  0,   0,   0,   0,   0,   6,   219, 255, 255, 255, 41,  0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 218,
     212, 212, 212, 212, 192, 0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   24,  219, 255, 255, 255, 186, 7,   0,   0,   0,   0,   176, 255, 255, 88,  0,   0,   0,   0,   16,  255, 255, 212,
     0,   0,   0,   0,   0,   144, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 4,   0,   0,   0,   121, 255, 255, 255, 203, 33,  0,   0,   0,   0,
     0,   59,  233, 255, 255, 254, 69,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   17,  76,  113, 123, 109, 84,  34,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,
     0,   0,   0,   0,   31,  160, 245, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 255, 232, 33,  0,   0,
     0,   0,   0,   0,   0,   120, 255, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   80,  255, 255, 255, 255, 255, 255, 255, 255, 232, 0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,
     32,  228, 255, 255, 255, 175, 4,   0,   0,   0,   176, 255, 255, 88,  0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   144, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   112, 255, 255, 255, 4,   0,   0,   29,  250, 255, 255, 221, 16,  0,   0,   0,   0,   0,   0,   0,   45,  248, 255, 255, 222, 3,   0,   0,   0,   0,   0,   0,   0,   35,  79,
     107, 120, 119, 100, 81,  53,  5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,
     0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,   0,   42,  170, 250, 255, 255, 255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   0,   0,   0,   94,  246, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 253, 67,  0,   0,   0,   0,   0,   0,   0,   0,   61,  255, 255, 255, 145, 0,   0,   0,   0,   0,   0,   0,
     80,  255, 255, 255, 255, 255, 255, 255, 255, 232, 0,   52,  255, 255, 255, 64,  0,   0,   0,   0,   0,   0,   0,   41,  235, 255, 255, 255, 164, 2,   0,   0,   176, 255, 255, 88,  0,   0,   0,
     0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   144, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 255, 3,   0,   0,   143, 255, 255, 255, 76,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 90,  0,   0,   0,   0,   3,   108, 216, 255, 255, 255, 255, 255, 255, 255, 255, 245, 191, 54,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,   110, 249, 255, 255, 255, 255,
     255, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255,
     255, 255, 40,  0,   0,   0,   0,   111, 255, 255, 255, 255, 229, 148, 105, 90,  107, 145, 208, 255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255,
     148, 0,   0,   0,   0,   0,   0,   0,   0,   0,   29,  255, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255, 255, 64,  0,
     0,   0,   0,   0,   0,   0,   0,   50,  241, 255, 255, 255, 153, 0,   0,   176, 255, 255, 88,  0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   144, 255, 255, 120, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   113, 255, 255, 252, 0,   0,   0,   228, 255, 255, 224, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  253, 255, 255, 175, 0,   0,   0,   9,
     187, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255,
     255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  131, 255, 255, 255, 193, 115, 89,  126, 255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   0,   74,  254, 255, 255, 251, 122, 6,   0,   0,   0,   0,
     0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  255, 255, 255, 171, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255,
     255, 88,  0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   144, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 244, 0,   0,   36,  255,
     255, 255, 159, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   213, 255, 255, 238, 1,   0,   0,   147, 255, 255, 255, 251, 177, 119, 94,  91,  106, 140, 185, 240, 255, 92,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 120, 255, 255,
     229, 70,  0,   0,   0,   36,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   14,  233, 255, 255, 250, 79,  0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,
     0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   33,  255, 255, 255, 159, 0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 88,  0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   144, 255,
     255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   138, 255, 255, 225, 0,   0,   71,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   169, 255, 255,
     255, 18,  0,   16,  249, 255, 255, 219, 34,  0,   0,   0,   0,   0,   0,   0,   3,   62,  41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   144, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 252, 255, 217, 28,  0,   0,   0,   0,   36,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   0,   133, 255, 255, 255, 124, 0,   0,
     0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   54,  255,
     255, 255, 132, 0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   176, 255, 255, 88,  0,   0,   0,   0,   16,  255, 255, 212, 0,   0,   0,   0,   0,   144, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   170, 255, 255,
     195, 0,   0,   90,  255, 255, 255, 99,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   151, 255, 255, 255, 38,  0,   64,  255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 251, 212, 212, 212, 212, 212, 212, 79,  0,   92,  255,
     255, 255, 255, 232, 31,  0,   0,   0,   0,   0,   36,  255, 255, 255, 48,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   8,   236, 255, 255, 225, 3,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,
     0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   106, 255, 255, 255, 88,  0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 88,  0,   0,   0,   0,   16,  255, 255, 212, 0,   0,
     0,   0,   0,   144, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   229, 255, 255, 148, 0,   0,   90,  255, 255, 255, 99,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   153, 255, 255, 255, 37,  0,   72,  255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 255, 255, 96,  0,   92,  255, 255, 255, 253, 67,  0,   0,   0,   0,   0,   0,   36,  255, 255, 255, 48,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   76,  255, 255,
     255, 122, 0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   174, 255, 255, 254, 22,  0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   98,  255, 255, 255, 80,  0,   0,   71,  255, 255, 255, 116, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   170, 255, 255, 255, 17,  0,   28,  254, 255, 255, 239, 83,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 96,  0,   92,  255, 255, 255, 147, 0,   0,   0,   0,   0,   0,   0,   2,   20,  20,  20,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,
     255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   142, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,
     28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   29,  252, 255, 255, 189, 0,   0,   0,   0,   0,   0,   0,   12,  255, 255,
     255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  0,   0,   0,   0,   0,   0,   0,   71,  241, 255, 255, 223, 4,   0,   0,   35,  255, 255, 255, 160, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   214, 255, 255, 236, 1,   0,   0,   169, 255, 255, 255, 255, 208, 101, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 29,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255,
     40,  0,   185, 255, 255, 252, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,
     0,   0,   0,   0,   0,   0,   0,   176, 255, 255, 255, 76,  0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255,
     28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   207, 217, 157,
     121, 97,  93,  120, 190, 254, 255, 255, 252, 67,  0,   0,   0,   0,   227, 255, 255, 225, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  253, 255, 255, 174, 0,   0,   0,   14,  187, 255,
     255, 255, 255, 255, 246, 170, 80,  7,   0,   0,   0,   0,   0,   0,   43,  255, 255, 255, 157, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 238, 11,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   32,  255, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 40,  0,   212, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,
     255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   126, 255, 255, 255, 191, 0,   0,   0,   0,   0,   0,
     0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 94,  0,   0,   0,   0,   0,   141, 255, 255,
     255, 76,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 88,  0,   0,   0,   0,   1,   92,  218, 255, 255, 255, 255, 255, 255, 237, 144, 32,  0,   0,   0,   0,   0,   183, 255,
     255, 248, 23,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   230, 255, 255, 134, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   224, 255, 255, 223, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100,
     255, 255, 255, 16,  0,   0,   0,   0,   0,   18,  158, 255, 255, 255, 240, 33,  0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   88,  255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   208, 255, 255, 255, 255, 255, 255, 255, 254, 189, 53,  0,   0,   0,   0,   0,   0,   28,  250, 255, 255, 221, 16,  0,   0,   0,   0,   0,   0,   0,   45,  248, 255, 255, 221, 3,   0,
     0,   0,   0,   0,   0,   2,   75,  177, 251, 255, 255, 255, 255, 255, 251, 140, 7,   0,   0,   0,   68,  255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255,
     249, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   138, 255, 255, 168, 0,   0,   0,   0,
     0,   67,  255, 255, 255, 31,  0,   0,   0,   0,   0,   81,  255, 255, 86,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   216, 255, 255, 232, 0,   0,   0,   0,   0,   0,
     0,   0,   0,   2,   201, 255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 188, 133, 102, 89,  109, 163, 241, 255, 255, 255, 246, 64,  0,   0,
     0,   0,   46,  212, 212, 212, 212, 214, 255, 255, 255, 229, 212, 212, 212, 212, 212, 212, 212, 212, 132, 0,   0,   88,  255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255,
     255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   13,  51,  88,  108, 121, 123, 109, 77,  23,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   120, 255, 255, 255, 203, 33,  0,   0,   0,   0,   0,   58,  232, 255, 255, 253, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  115, 212, 255, 255, 255, 255, 255, 191,
     5,   0,   0,   0,   209, 255, 255, 235, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   214, 255, 255, 158, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255,
     24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 209, 0,   0,   0,   0,   0,   137, 255, 255, 255, 109, 0,   0,   0,   0,   0,   123, 255, 255, 43,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   198, 255, 255, 253, 9,   0,   0,   0,   0,   0,   0,   0,   0,   120, 255, 255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,
     0,   0,   0,   0,   100, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 229, 57,  0,   0,   0,   0,   0,   56,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 160, 0,   0,   88,  255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   174, 255, 255, 255, 246, 165, 105, 89,  112, 182, 254, 255, 255,
     255, 123, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  168, 254, 255, 255, 255, 117, 0,   0,   0,   94,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   77,  255, 255, 254, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  255, 255,
     247, 3,   0,   0,   0,   0,   207, 255, 255, 255, 188, 0,   0,   0,   0,   0,   165, 255, 250, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   155, 255, 255, 255, 66,
     0,   0,   0,   0,   0,   0,   0,   69,  251, 255, 255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 234, 135,
     14,  0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 160, 0,   0,   88,  255, 255, 255, 28,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   132, 255, 255, 240, 0,   28,  233, 255, 255, 255, 102, 0,   0,   0,   0,   0,   0,   0,   0,   3,   189, 255, 255, 247, 51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   155, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 251, 110, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   64,  250, 255, 255, 207, 0,   0,   0,   5,   228, 255, 255, 217, 1,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   92,  255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  254, 255, 255, 36,  0,   0,   0,   21,  254, 255, 255, 255, 250, 15,  0,   0,   0,   0,   206,
     255, 213, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 255, 170, 0,   0,   0,   0,   0,   0,   63,  242, 255, 250, 255, 255, 255, 48,  0,   28,  255,
     255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 76,  89,  111, 125, 119, 100, 54,  4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   62,  251, 255, 255, 249, 57,  0,   0,
     0,   0,   0,   0,   0,   137, 255, 255, 255, 99,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   65,  195, 254, 255, 255, 255,
     255, 255, 249, 173, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   181, 255, 255, 237, 0,   0,   0,   0,   119, 255, 255, 255, 78,  0,   0,
     0,   0,   0,   0,   0,   56,  255, 255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   222, 255, 255, 78,  0,   0,   0,   90,  255, 255, 214, 255, 255, 89,  0,   0,   0,   2,   245, 255, 170, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     11,  240, 255, 255, 255, 94,  0,   0,   0,   1,   107, 248, 255, 247, 120, 255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 28,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   109, 255, 255, 255, 230, 26,  0,   0,   0,   0,   0,   81,  255, 255, 255, 154, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  83,  108, 122, 104, 75,  12,  0,   0,   0,   0,   0,   0,   0,   0,   97,  9,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   197, 255, 255, 218, 0,   0,   0,   0,   16,  243, 255, 255, 193, 0,   0,   0,   0,   0,   0,   0,   174, 255, 255, 205, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   178, 255, 255, 119, 0,   0,   0,   160, 255, 228, 131, 255, 255, 167,
     0,   0,   0,   34,  255, 255, 127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 255, 254, 159, 92,  117, 209, 255, 255, 250, 77,  72,  255, 255,
     255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   160,
     255, 255, 255, 199, 6,   0,   0,   0,   39,  241, 255, 255, 202, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228, 230, 122, 40,  0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 255, 151, 0,   0,   0,   0,   0,   145,
     255, 255, 255, 52,  0,   0,   0,   0,   0,   37,  253, 255, 255, 90,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   135, 255, 255, 160, 0,   0,   0,   228, 255, 175, 73,  255, 255, 240, 5,   0,   0,   76,  255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 255, 255, 255, 255, 255, 228, 61,  0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255,
     255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,
     255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   8,   204, 255, 255, 255, 155, 0,   0,   11,  213, 255, 255, 235, 30,  0,   0,   0,   0,
     0,   1,   211, 255, 255, 238, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   122, 255, 255, 240, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   228,
     255, 255, 255, 220, 169, 125, 101, 87,  96,  130, 204, 255, 255, 255, 244, 32,  0,   0,   0,   0,   0,   33,  252, 255, 255, 167, 0,   0,   0,   0,   0,   153, 255, 255, 225, 4,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 202, 0,   0,   43,  255, 255,
     116, 13,  249, 255, 255, 68,  0,   0,   117, 255, 255, 41,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   109, 240, 255, 255, 255, 255, 236, 131, 14,
     0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  255, 255, 255, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 240,
     0,   0,   0,   0,   0,   30,  234, 255, 255, 255, 105, 0,   168, 255, 255, 252, 68,  0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 255, 126, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   3,   226, 255, 255, 142, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   220, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 243, 68,  0,   0,
     0,   0,   0,   0,   0,   170, 255, 255, 251, 30,  0,   0,   0,   22,  247, 255, 255, 114, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   92,  255, 255, 255, 24,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  255, 255, 242, 0,   0,   113, 255, 255, 48,  0,   184, 255, 255, 147, 0,   0,   159, 255, 249, 4,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  82,  118, 114, 68,  5,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,
     0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   82,  255, 255, 255, 29,  0,   0,   0,   0,   0,   0,   0,   0,   21,  234, 255, 255, 240, 0,   0,   0,   0,   0,   0,   64,  251, 255, 255, 250, 156, 255, 255, 255, 121, 0,
     0,   0,   0,   0,   0,   0,   0,   1,   212, 255, 255, 239, 15,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   83,  255, 255, 253, 34,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   10,  87,  167, 231, 255, 255, 255, 255, 255, 255, 255, 255, 242, 159, 29,  0,   0,   0,   0,   0,   0,   0,   0,   55,  255, 255, 255, 141, 0,   0,   0,   132, 255, 255, 240,
     13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   253, 255, 255,
     29,  0,   182, 255, 234, 1,   0,   105, 255, 255, 224, 0,   0,   201, 255, 211, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   73,  255, 255, 255, 37,  0,   0,   0,   0,   0,   0,   0,   0,
     170, 255, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 255, 255, 255, 175, 1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  255, 255, 255, 129, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   192, 255, 255, 178, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   32,  72,  104, 118, 124, 113, 94,  53,  7,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 241, 14,  0,   11,  237, 255, 255, 138, 0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   218, 255, 255, 70,  6,   245, 255, 167, 0,   0,   27,  254, 255, 255, 48,  0,   242, 255, 168, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236,
     0,   0,   0,   0,   0,   0,   0,   100, 255, 255, 255, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   12,  255, 255, 255, 104, 0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  255, 255, 255, 56,  0,   0,   0,   0,   0,   0,   0,   119, 255, 255, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   163, 255, 255, 255,
     255, 217, 14,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   213, 255, 255, 240, 17,  0,   0,   0,   0,   0,   0,   0,   0,   44,  255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   81,  255, 255, 255, 115, 0,
     111, 255, 255, 250, 27,  0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 192, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   175, 255, 255, 111, 66,  255, 255, 98,  0,   0,   0,   203, 255, 255, 126, 28,  255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   255, 255, 255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  255, 255, 255, 104, 0,   0,   0,
     0,   0,   0,   122, 255, 255, 250, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   0,   14,  244, 255, 255, 255, 160, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   88,  255, 255,
     255, 132, 0,   0,   0,   0,   0,   0,   0,   0,   152, 255, 255, 213, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   27,  71,  103, 115, 126, 128, 128, 62,  0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   219, 255, 255, 226, 8,   224, 255, 255, 162, 0,   0,   0,   0,   0,   0,   0,   0,   49,  212, 212, 212, 212,
     212, 212, 212, 212, 212, 212, 212, 212, 251, 255, 255, 255, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 155, 126, 255, 255, 30,  0,   0,   0,   124, 255, 255, 198,
     69,  255, 255, 82,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,
     0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   84,  128, 128, 124, 113, 99,  63,  18,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   255,
     255, 255, 118, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   233, 255, 255, 220, 18,  0,   0,   0,   17,  161, 255, 255, 219, 147, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,
     0,   145, 255, 255, 255, 255, 255, 98,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   214, 255, 255, 242, 19,  0,   0,   0,   0,   0,   0,   16,  244, 255, 255, 104, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   68,  201, 255, 255, 255, 255, 255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     106, 255, 255, 255, 176, 255, 255, 255, 46,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 255, 255, 255, 243, 50,  0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   89,  255, 255, 201, 172, 255, 217, 0,   0,   0,   0,   45,  255, 255, 249, 116, 255, 255, 39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 255,
     255, 255, 252, 182, 40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   232, 255, 255, 153, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   131, 255,
     255, 255, 222, 113, 94,  148, 240, 255, 255, 230, 35,  132, 255, 255, 240, 0,   0,   0,   0,   0,   0,   0,   88,  255, 255, 255, 255, 255, 255, 248, 52,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   89,  255, 255, 255, 135, 0,   0,   0,   0,   0,   0,   113, 255, 255, 239, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   78,  254, 255, 255, 255, 255, 255, 255, 255,
     255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  237, 255, 255, 255, 255, 255, 186, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   79,  252, 255, 255, 250, 71,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  255, 255, 245, 220, 255, 148, 0,   0,   0,
     0,   0,   222, 255, 255, 207, 255, 248, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 255, 255, 255, 255, 255, 255, 242, 42,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   188, 255, 255, 228, 8,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9,   204, 255, 255, 255, 255, 255, 255, 255, 255, 207, 31,  0,   132, 255, 255, 240, 0,   0,
     0,   0,   0,   0,   42,  244, 255, 255, 200, 123, 255, 255, 255, 226, 21,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   215, 255, 255, 243, 20,  0,   0,   0,   0,   1,   219, 255, 255,
     139, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8,   231, 255, 255, 255, 207, 129, 97,  86,  84,  84,  40,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 255, 70,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   56,  246, 255, 255, 254, 93,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   6,   251, 255, 255, 255, 255, 80,  0,   0,   0,   0,   0,   143, 255, 255, 255, 255, 209, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   72,  255, 255, 255, 48,  0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,
     55,  84,  84,  87,  101, 139, 224, 255, 255, 255, 193, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   114, 255, 255, 255, 166, 7,   0,   0,   0,   0,   0,   25,  138,
     43,  0,   0,   0,   10,  153, 249, 255, 255, 255, 255, 233, 117, 5,   0,   0,   132, 255, 255, 240, 0,   0,   0,   0,   0,   13,  216, 255, 255, 236, 29,  0,   170, 255, 255, 255, 190, 3,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 138, 0,   0,   0,   0,   74,  255, 255, 252, 32,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 170,
     1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   24,  249, 255, 255, 255, 209, 0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   38,  235, 255, 255, 255, 120, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   215, 255, 255, 255,
     252, 15,  0,   0,   0,   0,   0,   64,  255, 255, 255, 255, 166, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   28,  255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  208, 255, 255, 255, 30,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  219, 255, 255, 255, 219, 131, 94,  94,  126, 187, 252, 255, 52,  0,   0,   0,   0,   0,   23,  87,  119, 112, 64,  4,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 253, 71,  0,   0,   11,  212, 255, 255, 255, 141, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,   216, 255, 255, 245, 22,  0,   0,
     0,   182, 255, 255, 175, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   110, 255, 255, 255, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   158, 255, 255, 255, 94,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   23,  222, 255, 255,
     255, 147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   172, 255, 255, 255, 199, 0,   0,   0,   0,   0,   0,   4,   237, 255, 255, 255, 123, 0,   0,   0,   0,
     0,   0,   16,  125, 189, 204, 175, 105, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   42,  68,  51,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   43,  232, 255, 255, 255, 255, 255,
     255, 255, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   116, 255, 255, 255, 127, 0,   0,   0,   0,   36,
     240, 255, 255, 255, 87,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   91,  255, 255, 255, 142, 0,   0,   36,  254, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     101, 255, 255, 255, 36,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   11,  204, 255, 255, 255, 172, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   129, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   162, 255, 255, 255, 80,  0,   0,   0,   0,   0,   42,  230, 255, 255, 255, 255, 255, 242, 127, 12,  0,   0,   0,   0,   0,   0,
     0,   177, 255, 182, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   85,  255, 255, 255, 55,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   18,  153, 243, 255, 255, 255, 255, 255, 255, 198, 100, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   63,  251, 255, 255, 184, 2,   0,   0,   0,   0,   0,   76,  254, 255, 255, 244, 45,  0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   217,
     255, 255, 246, 24,  0,   143, 255, 255, 210, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   64,  255, 255, 255, 74,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,
     182, 255, 255, 255, 194, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   86,  255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   83,  255, 255, 255,
     37,  0,   0,   0,   0,   10,  220, 255, 255, 255, 255, 255, 255, 255, 255, 232, 106, 4,   0,   0,   0,   0,   10,  235, 255, 156, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   123, 255, 255, 255, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   8,   69,  101, 122, 107, 82,  27,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  232, 255, 255, 225, 19,  0,
     0,   0,   0,   0,   0,   0,   127, 255, 255, 255, 220, 16,  0,   0,   0,   0,   0,   0,   0,   0,   0,   93,  255, 255, 255, 145, 11,  239, 255, 255, 101, 0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   14,  253, 255, 255, 125, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   156, 255, 255, 255, 212, 17,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   112, 255, 255, 147, 24,  13,  74,  177, 254, 255, 255, 255,
     220, 101, 13,  0,   7,   160, 255, 255, 89,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     173, 255, 255, 218, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   196, 255, 255, 249, 54,  0,   0,   0,   0,   0,   0,   0,   0,   1,   178, 255, 255, 255, 181, 2,   0,   0,   0,   0,
     0,   0,   0,   0,   3,   218, 255, 255, 247, 130, 255, 255, 237, 9,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   209, 255, 255, 181, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   128, 255, 255, 255, 227, 28,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   195, 255, 191, 0,   0,   0,   0,   0,   51,  197, 255, 255, 255, 255, 250, 220, 248, 255, 255, 216, 5,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   230, 255, 255, 161, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   144, 255, 255,
     255, 106, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   15,  218, 255, 255, 255, 130, 0,   0,   0,   0,   0,   0,   0,   0,   0,   94,  255, 255, 255, 255, 255, 255, 137, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   157, 255, 255, 236, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   99,  255, 255, 255, 239, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   236, 255, 94,  0,   0,   0,   0,
     0,   0,   0,   88,  218, 255, 255, 255, 255, 255, 255, 219, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   29,  255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   219, 255, 255, 255, 255, 252, 30,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   98,  255, 255, 255, 30,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   74,  251, 255, 255, 248, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 112, 29,  0,   0,   0,   0,   0,   0,   0,   0,   3,   80,  172, 233, 248, 213, 123, 11,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   76,  255, 255, 255, 50,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   95,  255, 255, 255, 255, 172,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 63,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   52,  244, 255, 255, 253, 85,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   108, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   220, 255, 255, 255, 62,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   53,
     255, 255, 255, 66,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   34,  233, 255, 255, 255, 109, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   111, 255, 255, 255, 4,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     160, 255, 255, 201, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   107, 255, 255, 254, 25,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  218, 255, 255, 255, 137, 0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   70,  255, 255, 255, 58,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   19,  244, 255, 255, 84,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   18,  225, 255, 255, 177, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   132, 255, 255, 255, 255, 213, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 212, 36,  0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   5,   220, 255,
     255, 191, 3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   139, 255, 255, 215, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   7,   76,  214, 255, 255, 230, 27,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255,
     255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 44,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   59,  249, 255, 255, 189, 58,  3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   46,  251, 255, 255, 79,  0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   16,  212, 213, 224, 251, 255, 255, 255, 203, 31,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   136, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 44,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   59,  226, 255, 255, 255, 246, 222, 212, 188, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   18,  219, 255, 255, 191, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 151, 2,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   10,  191, 255, 255, 255, 255, 255, 228, 0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   40,  207, 255, 255, 243, 34,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   20,  255, 255, 255, 255, 255, 255, 253, 150, 7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   22,  183, 255, 255, 255, 255, 255, 255, 228, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   76,  145, 104, 94,  118, 180, 250, 255, 255, 253, 88,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   14,  49,  125, 242, 255, 255, 192,
     6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   25,  224, 255, 255, 225, 107, 40,  11,  0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 255, 255, 255, 255, 248, 98,  0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   45,  243, 255, 255, 137, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   186, 255, 255, 219, 19,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 255, 255, 252, 173, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   131, 255, 255, 246, 11,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   49,  255, 255, 255, 82,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   26,  92,  117, 124, 109, 75,  18,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   60,  255, 255, 255, 59,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   104, 255, 255, 255, 12,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   53,  255, 255, 255, 68,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     113, 255, 255, 255, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   84,  255, 255, 255, 44,  0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 35,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   140, 255, 255, 249, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   46,  255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   191, 255, 255, 202, 0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   4,   246, 255, 255, 143, 0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   3,   242, 255, 255, 147, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   196, 255, 255, 197, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   45,
     255, 255, 255, 95,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   143, 255, 255, 248, 5,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   90,  255, 255, 255, 49,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 255, 43,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   110, 255, 255, 255, 33,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   82,
     255, 255, 255, 65,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   97,  255, 255, 255, 92,  0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   142, 255, 255, 255, 52,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   35,  254, 255, 255, 236, 78,  5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   12,  106, 252, 255, 255, 239, 5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   165, 255, 255, 255, 255, 250, 223,
     213, 212, 212, 102, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   139, 212, 212, 214, 227, 253, 255, 255, 255, 255, 118, 0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   14,  191, 255, 255, 255, 255, 255, 255, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   168, 255, 255, 255, 255, 255, 255, 255, 255, 156, 2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   2,
     75,  155, 200, 233, 245, 254, 255, 255, 124, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   168, 255, 255, 253, 243, 229, 192, 143, 56,  0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0},
    38.000000f, 50.669998f, 3.169998f, 38.000000f, -9.500000f, 96, {{L'\0', 0, 0, 0, 0, 0.000000f, 0.000000f, 0.011719f, 0.011719f, 0.015625f, 0.015625f, 0, {}},
                                                                    {L' ', 0, 0, 0, 0, 22.796875f, 0.000000f, 0.023438f, 0.003906f, 0.023438f, 0.003906f, 0, {}},
                                                                    {L'!', 7, 30, 8, 29, 22.796875f, 0.000000f, 0.027344f, 0.003906f, 0.054688f, 0.121094f, 0, {}},
                                                                    {L'"', 13, 10, 5, 30, 22.796875f, 0.000000f, 0.058594f, 0.003906f, 0.109375f, 0.042969f, 0, {}},
                                                                    {L'#', 21, 29, 1, 29, 22.796875f, 0.000000f, 0.113281f, 0.003906f, 0.195312f, 0.117188f, 0, {}},
                                                                    {L'$', 18, 34, 3, 31, 22.796875f, 0.000000f, 0.199219f, 0.003906f, 0.269531f, 0.136719f, 0, {}},
                                                                    {L'%', 23, 31, 0, 30, 22.796875f, 0.000000f, 0.273438f, 0.003906f, 0.363281f, 0.125000f, 0, {}},
                                                                    {L'&', 23, 31, 0, 30, 22.796875f, 0.000000f, 0.367188f, 0.003906f, 0.457031f, 0.125000f, 0, {}},
                                                                    {L'\'', 7, 11, 8, 30, 22.796875f, 0.000000f, 0.460938f, 0.003906f, 0.488281f, 0.046875f, 0, {}},
                                                                    {L'(', 17, 38, 3, 31, 22.796875f, 0.000000f, 0.492188f, 0.003906f, 0.558594f, 0.152344f, 0, {}},
                                                                    {L')', 18, 38, 2, 31, 22.796875f, 0.000000f, 0.562500f, 0.003906f, 0.632812f, 0.152344f, 0, {}},
                                                                    {L'*', 17, 17, 3, 30, 22.796875f, 0.000000f, 0.636719f, 0.003906f, 0.703125f, 0.070312f, 0, {}},
                                                                    {L'+', 21, 20, 1, 20, 22.796875f, 0.000000f, 0.707031f, 0.003906f, 0.789062f, 0.082031f, 0, {}},
                                                                    {L',', 8, 14, 7, 6, 22.796875f, 0.000000f, 0.792969f, 0.003906f, 0.824219f, 0.058594f, 0, {}},
                                                                    {L'-', 15, 3, 4, 13, 22.796875f, 0.000000f, 0.828125f, 0.003906f, 0.886719f, 0.015625f, 0, {}},
                                                                    {L'.', 7, 7, 8, 6, 22.796875f, 0.000000f, 0.890625f, 0.003906f, 0.917969f, 0.031250f, 0, {}},
                                                                    {L'/', 23, 30, 0, 30, 22.796875f, 0.000000f, 0.890625f, 0.035156f, 0.980469f, 0.152344f, 0, {}},
                                                                    {L'0', 21, 31, 1, 30, 22.796875f, 0.000000f, 0.792969f, 0.062500f, 0.875000f, 0.183594f, 0, {}},
                                                                    {L'1', 18, 29, 3, 29, 22.796875f, 0.000000f, 0.636719f, 0.085938f, 0.707031f, 0.199219f, 0, {}},
                                                                    {L'2', 19, 30, 2, 30, 22.796875f, 0.000000f, 0.710938f, 0.085938f, 0.785156f, 0.203125f, 0, {}},
                                                                    {L'3', 19, 31, 2, 30, 22.796875f, 0.000000f, 0.058594f, 0.121094f, 0.132812f, 0.242188f, 0, {}},
                                                                    {L'4', 22, 28, 0, 28, 22.796875f, 0.000000f, 0.273438f, 0.128906f, 0.359375f, 0.238281f, 0, {}},
                                                                    {L'5', 19, 30, 2, 29, 22.796875f, 0.000000f, 0.363281f, 0.128906f, 0.437500f, 0.246094f, 0, {}},
                                                                    {L'6', 21, 31, 1, 30, 22.796875f, 0.000000f, 0.136719f, 0.140625f, 0.218750f, 0.261719f, 0, {}},
                                                                    {L'7', 19, 28, 3, 28, 22.796875f, 0.000000f, 0.878906f, 0.156250f, 0.953125f, 0.265625f, 0, {}},
                                                                    {L'8', 19, 31, 2, 30, 22.796875f, 0.000000f, 0.441406f, 0.156250f, 0.515625f, 0.277344f, 0, {}},
                                                                    {L'9', 20, 31, 1, 30, 22.796875f, 0.000000f, 0.519531f, 0.156250f, 0.597656f, 0.277344f, 0, {}},
                                                                    {L':', 7, 22, 8, 21, 22.796875f, 0.000000f, 0.023438f, 0.125000f, 0.050781f, 0.210938f, 0, {}},
                                                                    {L';', 8, 29, 7, 21, 22.796875f, 0.000000f, 0.222656f, 0.140625f, 0.253906f, 0.253906f, 0, {}},
                                                                    {L'<', 21, 20, 1, 20, 22.796875f, 0.000000f, 0.789062f, 0.187500f, 0.871094f, 0.265625f, 0, {}},
                                                                    {L'=', 21, 9, 1, 14, 22.796875f, 0.000000f, 0.601562f, 0.203125f, 0.683594f, 0.238281f, 0, {}},
                                                                    {L'>', 21, 20, 1, 20, 22.796875f, 0.000000f, 0.687500f, 0.207031f, 0.769531f, 0.285156f, 0, {}},
                                                                    {L'?', 17, 31, 3, 30, 22.796875f, 0.000000f, 0.257812f, 0.242188f, 0.324219f, 0.363281f, 0, {}},
                                                                    {L'@', 23, 31, 0, 30, 22.796875f, 0.000000f, 0.003906f, 0.246094f, 0.093750f, 0.367188f, 0, {}},
                                                                    {L'A', 23, 29, 0, 29, 22.796875f, 0.000000f, 0.328125f, 0.250000f, 0.417969f, 0.363281f, 0, {}},
                                                                    {L'B', 18, 28, 3, 28, 22.796875f, 0.000000f, 0.601562f, 0.242188f, 0.671875f, 0.351562f, 0, {}},
                                                                    {L'C', 19, 31, 2, 30, 22.796875f, 0.000000f, 0.097656f, 0.265625f, 0.171875f, 0.386719f, 0, {}},
                                                                    {L'D', 20, 28, 2, 28, 22.796875f, 0.000000f, 0.175781f, 0.265625f, 0.253906f, 0.375000f, 0, {}},
                                                                    {L'E', 17, 28, 3, 28, 22.796875f, 0.000000f, 0.875000f, 0.269531f, 0.941406f, 0.378906f, 0, {}},
                                                                    {L'F', 17, 28, 4, 28, 22.796875f, 0.000000f, 0.773438f, 0.269531f, 0.839844f, 0.378906f, 0, {}},
                                                                    {L'G', 19, 31, 2, 30, 22.796875f, 0.000000f, 0.421875f, 0.281250f, 0.496094f, 0.402344f, 0, {}},
                                                                    {L'H', 19, 28, 2, 28, 22.796875f, 0.000000f, 0.500000f, 0.281250f, 0.574219f, 0.390625f, 0, {}},
                                                                    {L'I', 17, 28, 3, 28, 22.796875f, 0.000000f, 0.675781f, 0.289062f, 0.742188f, 0.398438f, 0, {}},
                                                                    {L'J', 16, 30, 2, 29, 22.796875f, 0.000000f, 0.578125f, 0.355469f, 0.640625f, 0.472656f, 0, {}},
                                                                    {L'K', 21, 28, 2, 28, 22.796875f, 0.000000f, 0.257812f, 0.367188f, 0.339844f, 0.476562f, 0, {}},
                                                                    {L'L', 16, 29, 4, 29, 22.796875f, 0.000000f, 0.343750f, 0.367188f, 0.406250f, 0.480469f, 0, {}},
                                                                    {L'M', 21, 28, 1, 28, 22.796875f, 0.000000f, 0.003906f, 0.371094f, 0.085938f, 0.480469f, 0, {}},
                                                                    {L'N', 19, 28, 2, 28, 22.796875f, 0.000000f, 0.175781f, 0.378906f, 0.250000f, 0.488281f, 0, {}},
                                                                    {L'O', 21, 31, 1, 30, 22.796875f, 0.000000f, 0.746094f, 0.382812f, 0.828125f, 0.503906f, 0, {}},
                                                                    {L'P', 19, 28, 3, 28, 22.796875f, 0.000000f, 0.832031f, 0.382812f, 0.906250f, 0.492188f, 0, {}},
                                                                    {L'Q', 22, 38, 1, 30, 22.796875f, 0.000000f, 0.644531f, 0.402344f, 0.730469f, 0.550781f, 0, {}},
                                                                    {L'R', 21, 28, 2, 28, 22.796875f, 0.000000f, 0.910156f, 0.382812f, 0.992188f, 0.492188f, 0, {}},
                                                                    {L'S', 19, 31, 2, 30, 22.796875f, 0.000000f, 0.089844f, 0.390625f, 0.164062f, 0.511719f, 0, {}},
                                                                    {L'T', 22, 28, 0, 28, 22.796875f, 0.000000f, 0.410156f, 0.406250f, 0.496094f, 0.515625f, 0, {}},
                                                                    {L'U', 19, 30, 2, 29, 22.796875f, 0.000000f, 0.500000f, 0.394531f, 0.574219f, 0.511719f, 0, {}},
                                                                    {L'V', 23, 29, 0, 29, 22.796875f, 0.000000f, 0.253906f, 0.484375f, 0.343750f, 0.597656f, 0, {}},
                                                                    {L'W', 23, 29, 0, 29, 22.796875f, 0.000000f, 0.832031f, 0.496094f, 0.921875f, 0.609375f, 0, {}},
                                                                    {L'X', 22, 28, 0, 28, 22.796875f, 0.000000f, 0.734375f, 0.507812f, 0.820312f, 0.617188f, 0, {}},
                                                                    {L'Y', 22, 29, 0, 29, 22.796875f, 0.000000f, 0.089844f, 0.515625f, 0.175781f, 0.628906f, 0, {}},
                                                                    {L'Z', 19, 28, 2, 28, 22.796875f, 0.000000f, 0.003906f, 0.484375f, 0.078125f, 0.593750f, 0, {}},
                                                                    {L'[', 16, 37, 6, 30, 22.796875f, 0.000000f, 0.578125f, 0.476562f, 0.640625f, 0.621094f, 0, {}},
                                                                    {L'\\', 23, 30, 0, 30, 22.796875f, 0.000000f, 0.347656f, 0.519531f, 0.437500f, 0.636719f, 0, {}},
                                                                    {L']', 16, 37, 1, 30, 22.796875f, 0.000000f, 0.179688f, 0.492188f, 0.242188f, 0.636719f, 0, {}},
                                                                    {L'^', 21, 20, 1, 29, 22.796875f, 0.000000f, 0.441406f, 0.519531f, 0.523438f, 0.597656f, 0, {}},
                                                                    {L'_', 21, 3, 1, 0, 22.796875f, 0.000000f, 0.644531f, 0.554688f, 0.726562f, 0.566406f, 0, {}},
                                                                    {L'`', 11, 6, 5, 30, 22.796875f, 0.000000f, 0.925781f, 0.496094f, 0.968750f, 0.519531f, 0, {}},
                                                                    {L'a', 20, 22, 1, 21, 22.796875f, 0.000000f, 0.644531f, 0.570312f, 0.722656f, 0.656250f, 0, {}},
                                                                    {L'b', 19, 31, 2, 30, 22.796875f, 0.000000f, 0.003906f, 0.597656f, 0.078125f, 0.718750f, 0, {}},
                                                                    {L'c', 18, 22, 3, 21, 22.796875f, 0.000000f, 0.246094f, 0.601562f, 0.316406f, 0.687500f, 0, {}},
                                                                    {L'd', 19, 31, 2, 30, 22.796875f, 0.000000f, 0.441406f, 0.601562f, 0.515625f, 0.722656f, 0, {}},
                                                                    {L'e', 19, 22, 2, 21, 22.796875f, 0.000000f, 0.824219f, 0.613281f, 0.898438f, 0.699219f, 0, {}},
                                                                    {L'f', 19, 31, 3, 31, 22.796875f, 0.000000f, 0.902344f, 0.613281f, 0.976562f, 0.734375f, 0, {}},
                                                                    {L'g', 19, 30, 2, 21, 22.796875f, 0.000000f, 0.726562f, 0.621094f, 0.800781f, 0.738281f, 0, {}},
                                                                    {L'h', 19, 30, 2, 30, 22.796875f, 0.000000f, 0.519531f, 0.625000f, 0.593750f, 0.742188f, 0, {}},
                                                                    {L'i', 16, 31, 2, 31, 22.796875f, 0.000000f, 0.082031f, 0.632812f, 0.144531f, 0.753906f, 0, {}},
                                                                    {L'j', 15, 40, 3, 31, 22.796875f, 0.000000f, 0.320312f, 0.640625f, 0.378906f, 0.796875f, 0, {}},
                                                                    {L'k', 20, 30, 3, 30, 22.796875f, 0.000000f, 0.148438f, 0.640625f, 0.226562f, 0.757812f, 0, {}},
                                                                    {L'l', 17, 30, 2, 30, 22.796875f, 0.000000f, 0.597656f, 0.660156f, 0.664062f, 0.777344f, 0, {}},
                                                                    {L'm', 21, 21, 1, 21, 22.796875f, 0.000000f, 0.230469f, 0.691406f, 0.312500f, 0.773438f, 0, {}},
                                                                    {L'n', 19, 21, 2, 21, 22.796875f, 0.000000f, 0.804688f, 0.703125f, 0.878906f, 0.785156f, 0, {}},
                                                                    {L'o', 21, 22, 1, 21, 22.796875f, 0.000000f, 0.382812f, 0.726562f, 0.464844f, 0.812500f, 0, {}},
                                                                    {L'p', 19, 29, 2, 21, 22.796875f, 0.000000f, 0.003906f, 0.722656f, 0.078125f, 0.835938f, 0, {}},
                                                                    {L'q', 19, 29, 2, 21, 22.796875f, 0.000000f, 0.882812f, 0.738281f, 0.957031f, 0.851562f, 0, {}},
                                                                    {L'r', 17, 21, 4, 21, 22.796875f, 0.000000f, 0.667969f, 0.742188f, 0.734375f, 0.824219f, 0, {}},
                                                                    {L's', 17, 22, 3, 21, 22.796875f, 0.000000f, 0.468750f, 0.746094f, 0.535156f, 0.832031f, 0, {}},
                                                                    {L't', 20, 28, 1, 27, 22.796875f, 0.000000f, 0.082031f, 0.761719f, 0.160156f, 0.871094f, 0, {}},
                                                                    {L'u', 18, 21, 2, 20, 22.796875f, 0.000000f, 0.164062f, 0.777344f, 0.234375f, 0.859375f, 0, {}},
                                                                    {L'v', 23, 20, 0, 20, 22.796875f, 0.000000f, 0.539062f, 0.781250f, 0.628906f, 0.859375f, 0, {}},
                                                                    {L'w', 23, 20, 0, 20, 22.796875f, 0.000000f, 0.738281f, 0.789062f, 0.828125f, 0.867188f, 0, {}},
                                                                    {L'x', 21, 20, 1, 20, 22.796875f, 0.000000f, 0.238281f, 0.800781f, 0.320312f, 0.878906f, 0, {}},
                                                                    {L'y', 23, 29, 0, 20, 22.796875f, 0.000000f, 0.324219f, 0.816406f, 0.414062f, 0.929688f, 0, {}},
                                                                    {L'z', 19, 20, 2, 20, 22.796875f, 0.000000f, 0.632812f, 0.828125f, 0.707031f, 0.906250f, 0, {}},
                                                                    {L'{', 18, 37, 3, 31, 22.796875f, 0.000000f, 0.417969f, 0.835938f, 0.488281f, 0.980469f, 0, {}},
                                                                    {L'|', 4, 30, 9, 30, 22.796875f, 0.000000f, 0.960938f, 0.738281f, 0.976562f, 0.855469f, 0, {}},
                                                                    {L'}', 17, 37, 2, 31, 22.796875f, 0.000000f, 0.003906f, 0.839844f, 0.070312f, 0.984375f, 0, {}},
                                                                    {L'~', 21, 7, 1, 14, 22.796875f, 0.000000f, 0.832031f, 0.855469f, 0.914062f, 0.882812f, 0, {}}, }};
#ifdef __cplusplus
}
#endif
