# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/ShyLU_Node clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "ShyLU_Node requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/ShyLU_Node build
## ---------------------------------------------------------------------------

set(ShyLU_Node_CXX_COMPILER "D:/a/msys64/ucrt64/bin/g++.exe")

set(ShyLU_Node_C_COMPILER "D:/a/msys64/ucrt64/bin/gcc.exe")

set(ShyLU_Node_Fortran_COMPILER "D:/a/msys64/ucrt64/bin/gfortran.exe")
# Deprecated!
set(ShyLU_Node_FORTRAN_COMPILER "D:/a/msys64/ucrt64/bin/gfortran.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/ShyLU_Node build
## ---------------------------------------------------------------------------

## Give the build type
set(ShyLU_Node_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(ShyLU_Node_CXX_FLAGS [[ ]])

set(ShyLU_Node_C_FLAGS [[  -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 ]])

set(ShyLU_Node_Fortran_FLAGS [[ ]])
# Deprecated
set(ShyLU_Node_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(ShyLU_Node_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(ShyLU_Node_SHARED_LIB_RPATH_COMMAND "/ucrt64/lib")
set(ShyLU_Node_BUILD_SHARED_LIBS "ON")

set(ShyLU_Node_LINKER D:/a/msys64/ucrt64/bin/ld.exe)
set(ShyLU_Node_AR D:/a/msys64/ucrt64/bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(ShyLU_Node_INSTALL_DIR "/ucrt64")

## List of package libraries
set(ShyLU_Node_LIBRARIES ShyLU_Node::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(ShyLU_Node_MPI_LIBRARIES "")
set(ShyLU_Node_MPI_LIBRARY_DIRS "")
set(ShyLU_Node_MPI_INCLUDE_DIRS "")
set(ShyLU_Node_MPI_EXEC "")
set(ShyLU_Node_MPI_EXEC_MAX_NUMPROCS "")
set(ShyLU_Node_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(ShyLU_Node_ENABLE_ShyLU_NodeHTS OFF)
set(ShyLU_Node_ENABLE_ShyLU_NodeTacho ON)
set(ShyLU_Node_ENABLE_ShyLU_NodeBasker OFF)
set(ShyLU_Node_ENABLE_ShyLU_NodeFastILU ON)

# Exported cache variables

# Include configuration of dependent packages
if (NOT TARGET ShyLU_NodeTacho::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../ShyLU_NodeTacho/ShyLU_NodeTachoConfig.cmake")
endif()
if (NOT TARGET ShyLU_NodeFastILU::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../ShyLU_NodeFastILU/ShyLU_NodeFastILUConfig.cmake")
endif()

# Import ShyLU_Node targets
include("${CMAKE_CURRENT_LIST_DIR}/ShyLU_NodeTargets.cmake")

# Standard TriBITS-compliant external package variables
set(ShyLU_Node_IS_TRIBITS_COMPLIANT TRUE)
set(ShyLU_Node_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(ShyLU_Node_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(ShyLU_Node_EXPORTED_PACKAGE_LIBS_NAMES "tacho;shylu_nodefastilu")

foreach(libname IN LISTS ShyLU_Node_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE ShyLU_Node::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'ShyLU_Node::${libname}', or better yet,"
      " 'ShyLU_Node::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'ShyLU_Node'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'ShyLU_Node_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
