; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx700 < %s | FileCheck -check-prefixes=GCN,GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define i32 @fneg_xor_select_i32(i1 %cond, i32 %arg0, i32 %arg1) {
; GCN-LABEL: fneg_xor_select_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, -v2, -v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_xor_select_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, -v2, -v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %select = select i1 %cond, i32 %arg0, i32 %arg1
  %fneg = xor i32 %select, -2147483648
  ret i32 %fneg
}

define <2 x i32> @fneg_xor_select_v2i32(<2 x i1> %cond, <2 x i32> %arg0, <2 x i32> %arg1) {
; GCN-LABEL: fneg_xor_select_v2i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, -v4, -v2, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e64 v1, -v5, -v3, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_xor_select_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, -v4, -v2, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, -v5, -v3, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %select = select <2 x i1> %cond, <2 x i32> %arg0, <2 x i32> %arg1
  %fneg = xor <2 x i32> %select, <i32 -2147483648, i32 -2147483648>
  ret <2 x i32> %fneg
}

define i32 @fneg_xor_select_i32_multi_use(i1 %cond, i32 %arg0, i32 %arg1, ptr addrspace(1) %ptr) {
; GFX7-LABEL: fneg_xor_select_i32_multi_use:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX7-NEXT:    flat_store_dword v[3:4], v0
; GFX7-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_xor_select_i32_multi_use:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX9-NEXT:    global_store_dword v[3:4], v0, off
; GFX9-NEXT:    v_xor_b32_e32 v0, 0x80000000, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_xor_select_i32_multi_use:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc_lo
; GFX11-NEXT:    v_xor_b32_e32 v0, 0x80000000, v1
; GFX11-NEXT:    global_store_b32 v[3:4], v1, off
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %select = select i1 %cond, i32 %arg0, i32 %arg1
  store i32 %select, ptr addrspace(1) %ptr
  %fneg = xor i32 %select, -2147483648
  ret i32 %fneg
}

define i64 @fneg_xor_select_i64(i1 %cond, i64 %arg0, i64 %arg1) {
; GCN-LABEL: fneg_xor_select_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v1, -v4, -v2, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_xor_select_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v1, -v4, -v2, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %select = select i1 %cond, i64 %arg0, i64 %arg1
  %fneg = xor i64 %select, 9223372036854775808
  ret i64 %fneg
}

define <2 x i64> @fneg_xor_select_v2i64(<2 x i1> %cond, <2 x i64> %arg0, <2 x i64> %arg1) {
; GCN-LABEL: fneg_xor_select_v2i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v6, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v2, v8, v4, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v1, -v7, -v3, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v3, -v9, -v5, s[4:5]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_xor_select_v2i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_dual_cndmask_b32 v0, v6, v2 :: v_dual_and_b32 v1, 1, v1
; GFX11-NEXT:    v_cmp_eq_u32_e64 s0, 1, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, -v7, -v3, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v8, v4, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v3, -v9, -v5, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %select = select <2 x i1> %cond, <2 x i64> %arg0, <2 x i64> %arg1
  %fneg = xor <2 x i64> %select, <i64 9223372036854775808, i64 9223372036854775808>
  ret <2 x i64> %fneg
}

define i16 @fneg_xor_select_i16(i1 %cond, i16 %arg0, i16 %arg1) {
; GCN-LABEL: fneg_xor_select_i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GCN-NEXT:    v_xor_b32_e32 v0, 0xffff8000, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: fneg_xor_select_i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_xor_b16 v0.l, 0x8000, v0.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: fneg_xor_select_i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v0, 0xffff8000, v0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %select = select i1 %cond, i16 %arg0, i16 %arg1
  %fneg = xor i16 %select, -32768
  ret i16 %fneg
}

define <2 x i16> @fneg_xor_select_v2i16(<2 x i1> %cond, <2 x i16> %arg0, <2 x i16> %arg1) {
; GFX7-LABEL: fneg_xor_select_v2i16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v4, v2, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v5, v3, vcc
; GFX7-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; GFX7-NEXT:    v_xor_b32_e32 v0, 0x8000, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_xor_select_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v3, v2, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_sdwa v1, v3, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: fneg_xor_select_v2i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 1, v1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v3.l, v2.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.h, v2.h, s0
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: fneg_xor_select_v2i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v3, v2 :: v_dual_and_b32 v1, 1, v1
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v5, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v0, 0x80008000, v0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %select = select <2 x i1> %cond, <2 x i16> %arg0, <2 x i16> %arg1
  %fneg = xor <2 x i16> %select, <i16 -32768, i16 -32768>
  ret <2 x i16> %fneg
}

define i16 @fneg_xor_select_i16_multi_use(i1 %cond, i16 %arg0, i16 %arg1, ptr addrspace(1) %ptr) {
; GFX7-LABEL: fneg_xor_select_i16_multi_use:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX7-NEXT:    flat_store_short v[3:4], v0
; GFX7-NEXT:    v_xor_b32_e32 v0, 0xffff8000, v0
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_xor_select_i16_multi_use:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GFX9-NEXT:    global_store_short v[3:4], v0, off
; GFX9-NEXT:    v_xor_b32_e32 v0, 0xffff8000, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: fneg_xor_select_i16_multi_use:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v2.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_xor_b16 v0.l, 0x8000, v0.h
; GFX11-TRUE16-NEXT:    global_store_d16_hi_b16 v[3:4], v0, off
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: fneg_xor_select_i16_multi_use:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v0, 0xffff8000, v1
; GFX11-FAKE16-NEXT:    global_store_b16 v[3:4], v1, off
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %select = select i1 %cond, i16 %arg0, i16 %arg1
  store i16 %select, ptr addrspace(1) %ptr
  %fneg = xor i16 %select, -32768
  ret i16 %fneg
}

define i64 @fneg_xor_select_i64_multi_user(i1 %cond, i64 %arg0, i64 %arg1, ptr addrspace(1) %ptr) {
; GFX7-LABEL: fneg_xor_select_i64_multi_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_mov_b32_e32 v7, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v3, v7, vcc
; GFX7-NEXT:    flat_store_dwordx2 v[5:6], v[0:1]
; GFX7-NEXT:    v_cndmask_b32_e64 v1, -v4, -v2, vcc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_xor_select_i64_multi_user:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_mov_b32_e32 v7, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v7, vcc
; GFX9-NEXT:    global_store_dwordx2 v[5:6], v[0:1], off
; GFX9-NEXT:    v_cndmask_b32_e64 v1, -v4, -v2, vcc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_xor_select_i64_multi_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v7, v1 :: v_dual_and_b32 v0, 1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v2 :: v_dual_cndmask_b32 v0, v3, v7
; GFX11-NEXT:    v_cndmask_b32_e64 v2, -v4, -v2, vcc_lo
; GFX11-NEXT:    global_store_b64 v[5:6], v[0:1], off
; GFX11-NEXT:    v_mov_b32_e32 v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %select = select i1 %cond, i64 %arg0, i64 %arg1
  store i64 %select, ptr addrspace(1) %ptr
  %fneg = xor i64 %select, 9223372036854775808
  ret i64 %fneg
}

define i32 @select_fneg_xor_select_i32(i1 %cond0, i1 %cond1, i32 %arg0, i32 %arg1) {
; GCN-LABEL: select_fneg_xor_select_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_xor_b32_e32 v2, 0x80000000, v2
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GCN-NEXT:    v_xor_b32_e32 v2, 0x80000000, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: select_fneg_xor_select_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    v_xor_b32_e32 v2, 0x80000000, v2
; GFX11-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-NEXT:    v_xor_b32_e32 v2, 0x80000000, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg0 = xor i32 %arg0, -2147483648
  %select0 = select i1 %cond0, i32 %arg1, i32 %fneg0
  %fneg1 = xor i32 %select0, -2147483648
  %select1 = select i1 %cond1, i32 %fneg1, i32 %select0
  ret i32 %select1
}

define float @select_fneg_select_f32(i1 %cond0, i1 %cond1, float %arg0, float %arg1) {
; GCN-LABEL: select_fneg_select_f32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, -v2, v3, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, -v0, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: select_fneg_select_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, -v2, v3, vcc_lo
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, -v0, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg0 = fneg float %arg0
  %select0 = select i1 %cond0, float %arg1, float %fneg0
  %fneg1 = fneg float %select0
  %select1 = select i1 %cond1, float %fneg1, float %select0
  ret float %select1
}

define double @fneg_xor_select_f64(i1 %cond, double %arg0, double %arg1) {
; GCN-LABEL: fneg_xor_select_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v1, -v4, -v2, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_xor_select_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v1, -v4, -v2, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %select = select i1 %cond, double %arg0, double %arg1
  %fneg = fneg double %select
  ret double %fneg
}

define double @fneg_xor_select_f64_multi_user(i1 %cond, double %arg0, double %arg1, ptr addrspace(1) %ptr) {
; GFX7-LABEL: fneg_xor_select_f64_multi_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_mov_b32_e32 v7, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v3, v7, vcc
; GFX7-NEXT:    flat_store_dwordx2 v[5:6], v[0:1]
; GFX7-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_xor_select_f64_multi_user:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_mov_b32_e32 v7, v1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v3, v7, vcc
; GFX9-NEXT:    global_store_dwordx2 v[5:6], v[0:1], off
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_xor_select_f64_multi_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v7, v1 :: v_dual_and_b32 v0, 1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v2 :: v_dual_cndmask_b32 v0, v3, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_xor_b32_e32 v2, 0x80000000, v1
; GFX11-NEXT:    global_store_b64 v[5:6], v[0:1], off
; GFX11-NEXT:    v_mov_b32_e32 v1, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %select = select i1 %cond, double %arg0, double %arg1
  store double %select, ptr addrspace(1) %ptr
  %fneg = fneg double %select
  ret double %fneg
}

define double @fneg_xor_select_i64_user_with_srcmods(i1 %cond, i64 %arg0, i64 %arg1) {
; GCN-LABEL: fneg_xor_select_i64_user_with_srcmods:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GCN-NEXT:    v_add_f64 v[0:1], -v[1:2], 2.0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_xor_select_i64_user_with_srcmods:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_cndmask_b32 v1, v3, v1
; GFX11-NEXT:    v_add_f64 v[0:1], -v[1:2], 2.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %select = select i1 %cond, i64 %arg0, i64 %arg1
  %fneg = xor i64 %select, 9223372036854775808
  %cast = bitcast i64 %fneg to double
  %add = fadd double %cast, 2.0
  ret double %add
}

define double @select_fneg_select_fneg_f64(i1 %cond0, i1 %cond1, double %arg0, double %arg1) {
; GCN-LABEL: select_fneg_select_fneg_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_xor_b32_e32 v3, 0x80000000, v3
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, v3, v5, vcc
; GCN-NEXT:    v_xor_b32_e32 v3, 0x80000000, v2
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: select_fneg_select_fneg_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    v_xor_b32_e32 v3, 0x80000000, v3
; GFX11-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v3, v5, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-NEXT:    v_xor_b32_e32 v3, 0x80000000, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg0 = fneg double %arg0
  %select0 = select i1 %cond0, double %arg1, double %fneg0
  %fneg1 = fneg double %select0
  %select1 = select i1 %cond1, double %fneg1, double %select0
  ret double %select1
}

define i64 @select_fneg_xor_select_i64(i1 %cond0, i1 %cond1, i64 %arg0, i64 %arg1) {
; GCN-LABEL: select_fneg_xor_select_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_xor_b32_e32 v3, 0x80000000, v3
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v2, v3, v5, vcc
; GCN-NEXT:    v_xor_b32_e32 v3, 0x80000000, v2
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: select_fneg_xor_select_i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-NEXT:    v_xor_b32_e32 v3, 0x80000000, v3
; GFX11-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v3, v5, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-NEXT:    v_xor_b32_e32 v3, 0x80000000, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fneg0 = xor i64 %arg0, 9223372036854775808
  %select0 = select i1 %cond0, i64 %arg1, i64 %fneg0
  %fneg1 = xor i64 %select0, 9223372036854775808
  %select1 = select i1 %cond1, i64 %fneg1, i64 %select0
  ret i64 %select1
}

define half @select_fneg_select_f16(i1 %cond0, i1 %cond1, half %arg0, half %arg1) {
; GFX7-LABEL: select_fneg_select_f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e64 v2, -v2
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX7-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, -v0, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: select_fneg_select_f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_xor_b32_e32 v2, 0x8000, v2
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GFX9-NEXT:    v_xor_b32_e32 v2, 0x8000, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: select_fneg_select_f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-TRUE16-NEXT:    v_xor_b16 v0.l, 0x8000, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-TRUE16-NEXT:    v_xor_b16 v0.h, 0x8000, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: select_fneg_select_f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v2, 0x8000, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v2, 0x8000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %fneg0 = fneg half %arg0
  %select0 = select i1 %cond0, half %arg1, half %fneg0
  %fneg1 = fneg half %select0
  %select1 = select i1 %cond1, half %fneg1, half %select0
  ret half %select1
}

define i16 @select_fneg_xor_select_i16(i1 %cond0, i1 %cond1, i16 %arg0, i16 %arg1) {
; GCN-LABEL: select_fneg_xor_select_i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    v_xor_b32_e32 v2, 0xffff8000, v2
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; GCN-NEXT:    v_xor_b32_e32 v2, 0xffff8000, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: select_fneg_xor_select_i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-TRUE16-NEXT:    v_xor_b16 v0.l, 0x8000, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-TRUE16-NEXT:    v_xor_b16 v0.h, 0x8000, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: select_fneg_xor_select_i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v2, 0xffff8000, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v2, 0xffff8000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %fneg0 = xor i16 %arg0, -32768
  %select0 = select i1 %cond0, i16 %arg1, i16 %fneg0
  %fneg1 = xor i16 %select0, -32768
  %select1 = select i1 %cond1, i16 %fneg1, i16 %select0
  ret i16 %select1
}

define <2 x half> @select_fneg_select_v2f16(<2 x i1> %cond0, <2 x i1> %cond1, <2 x half> %arg0, <2 x half> %arg1) {
; GFX7-LABEL: select_fneg_select_v2f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_xor_b32_e32 v4, 0x80008000, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v6
; GFX7-NEXT:    v_cvt_f32_f16_e32 v6, v7
; GFX7-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_cvt_f16_f32_e32 v6, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc
; GFX7-NEXT:    v_cvt_f16_f32_e32 v4, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX7-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX7-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX7-NEXT:    v_xor_b32_e32 v4, 0x80008000, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v5, v4
; GFX7-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX7-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: select_fneg_select_v2f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX9-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80008000, v4
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v3
; GFX9-NEXT:    v_cndmask_b32_sdwa v3, v1, v5, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v5, vcc
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_perm_b32 v1, v3, v0, s6
; GFX9-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX9-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_sdwa v3, v3, v1, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    v_perm_b32 v0, v3, v0, s6
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: select_fneg_select_v2f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v4, 0x80008000, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 1, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 1, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v4.h, v5.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v4.l, v5.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 1, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v0, 0x80008000, v1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v1.h, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: select_fneg_select_v2f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v4, 0x80008000, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v3
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v4, 0x80008000, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v1, v5 :: v_dual_and_b32 v2, 1, v2
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %fneg0 = fneg <2 x half> %arg0
  %select0 = select <2 x i1> %cond0, <2 x half> %arg1, <2 x half> %fneg0
  %fneg1 = fneg <2 x half> %select0
  %select1 = select <2 x i1> %cond1, <2 x half> %fneg1, <2 x half> %select0
  ret <2 x half> %select1
}

define <2 x i16> @select_fneg_xor_select_v2i16(<2 x i1> %cond0, <2 x i1> %cond1, <2 x i16> %arg0, <2 x i16> %arg1) {
; GFX7-LABEL: select_fneg_xor_select_v2i16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_xor_b32_e32 v5, 0xffff8000, v5
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX7-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX7-NEXT:    v_xor_b32_e32 v4, 0xffff8000, v4
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v5, v7, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX7-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v4, v6, vcc
; GFX7-NEXT:    v_xor_b32_e32 v5, 0x8000, v1
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v3
; GFX7-NEXT:    v_xor_b32_e32 v4, 0x8000, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: select_fneg_xor_select_v2i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX9-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX9-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v1
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80008000, v4
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[4:5], 1, v3
; GFX9-NEXT:    v_cndmask_b32_sdwa v3, v1, v5, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v1, v5, vcc
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_perm_b32 v1, v3, v0, s6
; GFX9-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80008000, v1
; GFX9-NEXT:    s_mov_b64 vcc, s[4:5]
; GFX9-NEXT:    v_cndmask_b32_sdwa v3, v3, v1, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    v_perm_b32 v0, v3, v0, s6
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: select_fneg_xor_select_v2i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v4, 0x80008000, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 1, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 1, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 1, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v4.h, v5.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v4.l, v5.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u32_e64 s0, 1, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v0, 0x80008000, v1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v1.h, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v1.l, v0.l, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: select_fneg_xor_select_v2i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v4, 0x80008000, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 1, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v4, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v7, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v3
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v4, 0x80008000, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v1, v5 :: v_dual_and_b32 v2, 1, v2
; GFX11-FAKE16-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 1, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %fneg0 = xor <2 x i16> %arg0, <i16 -32768, i16 -32768>
  %select0 = select <2 x i1> %cond0, <2 x i16> %arg1, <2 x i16> %fneg0
  %fneg1 = xor <2 x i16> %select0, <i16 -32768, i16 -32768>
  %select1 = select <2 x i1> %cond1, <2 x i16> %fneg1, <2 x i16> %select0
  ret <2 x i16> %select1
}

; pattern that appeared in rocm-device-libs to manually operate on the
; sign bit of the high half of a double
define double @cospiD_pattern0(i32 %arg, double %arg1, double %arg2) {
; GCN-LABEL: cospiD_pattern0:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v5, 1, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GCN-NEXT:    v_cndmask_b32_e32 v3, v1, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v4, vcc
; GCN-NEXT:    v_bfrev_b32_e32 v2, 1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc, 1, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; GCN-NEXT:    v_xor_b32_e32 v1, v1, v0
; GCN-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: cospiD_pattern0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v5, 1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v1, v3, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v2, v4, vcc_lo
; GFX11-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 0x80000000, vcc_lo
; GFX11-NEXT:    v_xor_b32_e32 v1, v1, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %i = and i32 %arg, 1
  %i3 = icmp eq i32 %i, 0
  %i4 = select i1 %i3, double %arg2, double %arg1
  %i5 = bitcast double %i4 to <2 x i32>
  %i6 = icmp sgt i32 %arg, 1
  %i7 = select i1 %i6, i32 -2147483648, i32 0
  %i8 = extractelement <2 x i32> %i5, i64 1
  %i9 = xor i32 %i8, %i7
  %i10 = insertelement <2 x i32> %i5, i32 %i9, i64 1
  %i11 = bitcast <2 x i32> %i10 to double
  ret double %i11
}

define double @cospiD_pattern1(i32 %arg, double %arg1, double %arg2) {
; GCN-LABEL: cospiD_pattern1:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v5, 1, v0
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v5
; GCN-NEXT:    v_cndmask_b32_e32 v3, v1, v3, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v4, vcc
; GCN-NEXT:    v_xor_b32_e32 v2, 0x80000000, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc, 1, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, v3
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: cospiD_pattern1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v5, 1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v5
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v1, v3, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v2, v4, vcc_lo
; GFX11-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 1, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_xor_b32_e32 v2, 0x80000000, v1
; GFX11-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %i = and i32 %arg, 1
  %i3 = icmp eq i32 %i, 0
  %i4 = select i1 %i3, double %arg2, double %arg1
  %i5 = icmp sgt i32 %arg, 1
  %i6 = fneg double %i4
  %i7 = select i1 %i5, double %i6, double %i4
  ret double %i7
}

; artifical example, scaled to operation on 16-bit halves of a float.
define float @cospiD_pattern0_half(i16 %arg, float %arg1, float %arg2) {
; GFX7-LABEL: cospiD_pattern0_half:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v3, v0, 0, 16
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX7-NEXT:    v_mov_b32_e32 v2, 0xffff8000
; GFX7-NEXT:    v_cmp_lt_i32_e32 vcc, 1, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff, v0
; GFX7-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX7-NEXT:    v_xor_b32_e32 v0, v0, v2
; GFX7-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: cospiD_pattern0_half:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v3, 1, v0
; GFX9-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_mov_b32_e32 v2, 0xffff8000
; GFX9-NEXT:    v_cmp_lt_i16_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; GFX9-NEXT:    v_xor_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: cospiD_pattern0_half:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, v0.l, 1
; GFX11-TRUE16-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 1, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e64 v0, v1, v2, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, 0, 0x8000, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_xor_b16 v0.h, v0.h, v1.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: cospiD_pattern0_half:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 1, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 1, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e64 v0, 0, 0xffff8000, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v0, v2, v0
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v1, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %i = and i16 %arg, 1
  %i3 = icmp eq i16 %i, 0
  %i4 = select i1 %i3, float %arg2, float %arg1
  %i5 = bitcast float %i4 to <2 x i16>
  %i6 = icmp sgt i16 %arg, 1
  %i7 = select i1 %i6, i16 -32768, i16 0
  %i8 = extractelement <2 x i16> %i5, i64 1
  %i9 = xor i16 %i8, %i7
  %i10 = insertelement <2 x i16> %i5, i16 %i9, i64 1
  %i11 = bitcast <2 x i16> %i10 to float
  ret float %i11
}

define float @cospiD_pattern1_half(i16 %arg, float %arg1, float %arg2) {
; GFX7-LABEL: cospiD_pattern1_half:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_bfe_i32 v3, v0, 0, 16
; GFX7-NEXT:    v_and_b32_e32 v0, 1, v0
; GFX7-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; GFX7-NEXT:    v_cmp_lt_i32_e32 vcc, 1, v3
; GFX7-NEXT:    v_cndmask_b32_e64 v0, v0, -v0, vcc
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: cospiD_pattern1_half:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_and_b32_e32 v3, 1, v0
; GFX9-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc
; GFX9-NEXT:    v_cmp_lt_i16_e32 vcc, 1, v0
; GFX9-NEXT:    v_cndmask_b32_e64 v0, v1, -v1, vcc
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: cospiD_pattern1_half:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, v0.l, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 1, v0.l
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e64 v0, v1, -v1, vcc_lo
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: cospiD_pattern1_half:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 1, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_lt_i16_e32 vcc_lo, 1, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e64 v0, v1, -v1, vcc_lo
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %i = and i16 %arg, 1
  %i3 = icmp eq i16 %i, 0
  %i4 = select i1 %i3, float %arg2, float %arg1
  %i5 = icmp sgt i16 %arg, 1
  %i6 = fneg float %i4
  %i7 = select i1 %i5, float %i6, float %i4
  ret float %i7
}

define double @fneg_f64_bitcast_vector_i64_to_f64(i64 %arg) {
; GCN-LABEL: fneg_f64_bitcast_vector_i64_to_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_vector_i64_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast i64 %arg to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_vector_v2i32_to_f64(<2 x i32> %arg) {
; GCN-LABEL: fneg_f64_bitcast_vector_v2i32_to_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_vector_v2i32_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <2 x i32> %arg to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_vector_v2f32_to_f64(<2 x float> %arg) {
; GCN-LABEL: fneg_f64_bitcast_vector_v2f32_to_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_vector_v2f32_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <2 x float> %arg to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_vector_v4i16_to_f64(<4 x i16> %arg) {
; GFX7-LABEL: fneg_f64_bitcast_vector_v4i16_to_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_f64_bitcast_vector_v4i16_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_vector_v4i16_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <4 x i16> %arg to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_vector_v4f16_to_f64(<4 x half> %arg) {
; GFX7-LABEL: fneg_f64_bitcast_vector_v4f16_to_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_f64_bitcast_vector_v4f16_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_vector_v4f16_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %bitcast = bitcast <4 x half> %arg to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_build_vector_v2i32_to_f64(i32 %elt0, i32 %elt1) {
; GCN-LABEL: fneg_f64_bitcast_build_vector_v2i32_to_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_build_vector_v2i32_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <2 x i32> poison, i32 %elt0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %elt1, i32 1
  %bitcast = bitcast <2 x i32> %insert.1 to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_build_vector_v2f32_to_f64(float %elt0, float %elt1) {
; GCN-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <2 x float> poison, float %elt0, i32 0
  %insert.1 = insertelement <2 x float> %insert.0, float %elt1, i32 1
  %bitcast = bitcast <2 x float> %insert.1 to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_build_vector_v4i16_to_f64(i16 %elt0, i16 %elt1, i16 %elt2, i16 %elt3) {
; GFX7-LABEL: fneg_f64_bitcast_build_vector_v4i16_to_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_f64_bitcast_build_vector_v4i16_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v2, v3, v2, s4
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: fneg_f64_bitcast_build_vector_v4i16_to_f64:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.h, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: fneg_f64_bitcast_build_vector_v4i16_to_f64:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v3, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <4 x i16> poison, i16 %elt0, i32 0
  %insert.1 = insertelement <4 x i16> %insert.0, i16 %elt1, i32 1
  %insert.2 = insertelement <4 x i16> %insert.1, i16 %elt2, i32 2
  %insert.3 = insertelement <4 x i16> %insert.2, i16 %elt3, i32 3
  %bitcast = bitcast <4 x i16> %insert.3 to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_build_vector_v4f16_to_f64(half %elt0, half %elt1, half %elt2, half %elt3) {
; GFX7-LABEL: fneg_f64_bitcast_build_vector_v4f16_to_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX7-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX7-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_f64_bitcast_build_vector_v4f16_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v2, v3, v2, s4
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: fneg_f64_bitcast_build_vector_v4f16_to_f64:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.h, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: fneg_f64_bitcast_build_vector_v4f16_to_f64:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v3, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <4 x half> poison, half %elt0, i32 0
  %insert.1 = insertelement <4 x half> %insert.0, half %elt1, i32 1
  %insert.2 = insertelement <4 x half> %insert.1, half %elt2, i32 2
  %insert.3 = insertelement <4 x half> %insert.2, half %elt3, i32 3
  %bitcast = bitcast <4 x half> %insert.3 to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_build_vector_v4bf16_to_f64(bfloat %elt0, bfloat %elt1, bfloat %elt2, bfloat %elt3) {
; GFX7-LABEL: fneg_f64_bitcast_build_vector_v4bf16_to_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; GFX7-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; GFX7-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_f64_bitcast_build_vector_v4bf16_to_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v2, v3, v2, s4
; GFX9-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: fneg_f64_bitcast_build_vector_v4bf16_to_f64:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.h, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: fneg_f64_bitcast_build_vector_v4bf16_to_f64:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v3, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_xor_b32_e32 v1, 0x80000000, v2
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <4 x bfloat> poison, bfloat %elt0, i32 0
  %insert.1 = insertelement <4 x bfloat> %insert.0, bfloat %elt1, i32 1
  %insert.2 = insertelement <4 x bfloat> %insert.1, bfloat %elt2, i32 2
  %insert.3 = insertelement <4 x bfloat> %insert.2, bfloat %elt3, i32 3
  %bitcast = bitcast <4 x bfloat> %insert.3 to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_build_vector_v2i32_to_f64_modifier_user(i32 %elt0, i32 %elt1, double %fp.val) {
; GCN-LABEL: fneg_f64_bitcast_build_vector_v2i32_to_f64_modifier_user:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[0:1], -v[0:1], v[2:3]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_build_vector_v2i32_to_f64_modifier_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f64 v[0:1], -v[0:1], v[2:3]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <2 x i32> poison, i32 %elt0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %elt1, i32 1
  %bitcast = bitcast <2 x i32> %insert.1 to double
  %fneg = fneg double %bitcast
  %fmul = fmul double %fneg, %fp.val
  ret double %fmul
}

define { double, double } @fneg_f64_bitcast_build_vector_v2i32_to_f64_multi_modifier_user(i32 %elt0, i32 %elt1, double %fp.val0, double %fp.val1) {
; GCN-LABEL: fneg_f64_bitcast_build_vector_v2i32_to_f64_multi_modifier_user:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mul_f64 v[6:7], -v[0:1], v[2:3]
; GCN-NEXT:    v_mul_f64 v[2:3], v[4:5], -v[0:1]
; GCN-NEXT:    v_mov_b32_e32 v0, v6
; GCN-NEXT:    v_mov_b32_e32 v1, v7
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_build_vector_v2i32_to_f64_multi_modifier_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f64 v[6:7], -v[0:1], v[2:3]
; GFX11-NEXT:    v_mul_f64 v[2:3], v[4:5], -v[0:1]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_dual_mov_b32 v0, v6 :: v_dual_mov_b32 v1, v7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <2 x i32> poison, i32 %elt0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %elt1, i32 1
  %bitcast = bitcast <2 x i32> %insert.1 to double
  %fneg = fneg double %bitcast
  %fmul0 = fmul double %fneg, %fp.val0
  %fmul1 = fmul double %fp.val1, %fneg
  %ret.0 = insertvalue { double, double } poison, double %fmul0, 0
  %ret.1 = insertvalue { double, double } %ret.0, double %fmul1, 1
  ret { double, double } %ret.1
}

define double @fneg_f64_bitcast_build_vector_v2i32_to_f64_modifier_user_integer_neg_source(i32 %elt0, i32 %elt1, double %fp.val) {
; GCN-LABEL: fneg_f64_bitcast_build_vector_v2i32_to_f64_modifier_user_integer_neg_source:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-NEXT:    v_mul_f64 v[0:1], -v[0:1], v[2:3]
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_build_vector_v2i32_to_f64_modifier_user_integer_neg_source:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], -v[0:1], v[2:3]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %neg.elt1 = xor i32 %elt1, -2147483648
  %insert.0 = insertelement <2 x i32> poison, i32 %elt0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %neg.elt1, i32 1
  %bitcast = bitcast <2 x i32> %insert.1 to double
  %fneg = fneg double %bitcast
  %fmul = fmul double %fneg, %fp.val
  ret double %fmul
}

define double @fneg_f64_bitcast_build_vector_v2f32_foldable_sources_to_f64(float %elt0, float %elt1) {
; GCN-LABEL: fneg_f64_bitcast_build_vector_v2f32_foldable_sources_to_f64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_sub_f32_e32 v1, -2.0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_build_vector_v2f32_foldable_sources_to_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_sub_f32_e32 v1, -2.0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %fadd = fadd nsz nnan float %elt1, 2.0
  %insert.0 = insertelement <2 x float> poison, float %elt0, i32 0
  %insert.1 = insertelement <2 x float> %insert.0, float %fadd, i32 1
  %bitcast = bitcast <2 x float> %insert.1 to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define double @fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_source_user(float %elt0, float %elt1, ptr addrspace(1) %ptr) {
; GFX7-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_source_user:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_source_user:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v[2:3], v[0:1], off
; GFX9-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_source_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v4, 0x80000000, v1
; GFX11-NEXT:    global_store_b64 v[2:3], v[0:1], off
; GFX11-NEXT:    v_mov_b32_e32 v1, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <2 x float> poison, float %elt0, i32 0
  %insert.1 = insertelement <2 x float> %insert.0, float %elt1, i32 1
  store <2 x float> %insert.1, ptr addrspace(1) %ptr
  %bitcast = bitcast <2 x float> %insert.1 to double
  %fneg = fneg double %bitcast
  ret double %fneg
}

define { double, <2 x float> } @fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_source_foldable_user(float %elt0, float %elt1, <2 x float> %arg.v2f32) {
; GCN-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_source_foldable_user:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f32_e32 v2, v0, v2
; GCN-NEXT:    v_add_f32_e32 v3, v1, v3
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_source_foldable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v4, 0x80000000, v1
; GFX11-NEXT:    v_dual_add_f32 v2, v0, v2 :: v_dual_add_f32 v3, v1, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v1, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <2 x float> poison, float %elt0, i32 0
  %insert.1 = insertelement <2 x float> %insert.0, float %elt1, i32 1
  %other.bitcast.source.user = fadd <2 x float> %insert.1, %arg.v2f32
  %bitcast = bitcast <2 x float> %insert.1 to double
  %fneg = fneg double %bitcast
  %ret.0 = insertvalue { double, <2 x float> } poison, double %fneg, 0
  %ret.1 = insertvalue { double, <2 x float> } %ret.0, <2 x float> %other.bitcast.source.user, 1
  ret { double, <2 x float> } %ret.1
}

define { double, double } @fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_user(float %elt0, float %elt1) {
; GCN-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_user:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v3, v1
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v3
; GCN-NEXT:    v_mov_b32_e32 v2, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v3, v1 :: v_dual_mov_b32 v2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <2 x float> poison, float %elt0, i32 0
  %insert.1 = insertelement <2 x float> %insert.0, float %elt1, i32 1
  %bitcast = bitcast <2 x float> %insert.1 to double
  %fneg = fneg double %bitcast
  %ret.0 = insertvalue { double, double } poison, double %fneg, 0
  %ret.1 = insertvalue { double, double } %ret.0, double %bitcast, 1
  ret { double, double } %ret.1
}

define { double, double } @fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_foldable_user(float %elt0, float %elt1, double %arg.f64) {
; GCN-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_foldable_user:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GCN-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: fneg_f64_bitcast_build_vector_v2f32_to_f64_bitcast_foldable_user:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_add_f64 v[2:3], v[0:1], v[2:3]
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x80000000, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %insert.0 = insertelement <2 x float> poison, float %elt0, i32 0
  %insert.1 = insertelement <2 x float> %insert.0, float %elt1, i32 1
  %bitcast = bitcast <2 x float> %insert.1 to double
  %other.bitcast.user = fadd double %bitcast, %arg.f64
  %fneg = fneg double %bitcast
  %ret.0 = insertvalue { double, double } poison, double %fneg, 0
  %ret.1 = insertvalue { double, double } %ret.0, double %other.bitcast.user, 1
  ret { double, double } %ret.1
}

; Check for correct bitcasting back when there are multiple uses
define amdgpu_kernel void @multiple_uses_fneg_select_f64(double %x, double %y, i1 %z, ptr addrspace(1) %dst) {
; GFX7-LABEL: multiple_uses_fneg_select_f64:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_load_dword s6, s[8:9], 0x4
; GFX7-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x6
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_bitcmp1_b32 s6, 0
; GFX7-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX7-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX7-NEXT:    v_mov_b32_e32 v0, s3
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    s_cselect_b32 s1, s1, s3
; GFX7-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX7-NEXT:    s_cselect_b32 s0, s0, s2
; GFX7-NEXT:    v_mov_b32_e32 v1, s1
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    v_cndmask_b32_e64 v1, v1, -v0, vcc
; GFX7-NEXT:    v_mov_b32_e32 v0, s0
; GFX7-NEXT:    v_mov_b32_e32 v3, s5
; GFX7-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX7-NEXT:    s_endpgm
;
; GFX9-LABEL: multiple_uses_fneg_select_f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s6, s[8:9], 0x10
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x18
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_bitcmp1_b32 s6, 0
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_and_b64 s[6:7], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v0, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    s_cselect_b32 s1, s1, s3
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX9-NEXT:    s_cselect_b32 s0, s0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_cndmask_b32_e64 v1, v1, -v0, vcc
; GFX9-NEXT:    v_mov_b32_e32 v0, s0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[4:5]
; GFX9-NEXT:    s_endpgm
;
; GFX11-LABEL: multiple_uses_fneg_select_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x2
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-NEXT:    s_load_b32 s6, s[4:5], 0x10
; GFX11-NEXT:    s_load_b64 s[4:5], s[4:5], 0x18
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, s1
; GFX11-NEXT:    s_bitcmp1_b32 s6, 0
; GFX11-NEXT:    s_cselect_b32 vcc_lo, -1, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, s3, v0, vcc_lo
; GFX11-NEXT:    s_and_b32 s6, vcc_lo, exec_lo
; GFX11-NEXT:    s_cselect_b32 s1, s1, s3
; GFX11-NEXT:    s_cselect_b32 s0, s0, s2
; GFX11-NEXT:    v_cndmask_b32_e64 v1, s1, -v0, vcc_lo
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[4:5]
; GFX11-NEXT:    s_endpgm
  %a = select i1 %z, double %x, double %y
  %b = fneg double %a
  %c = select i1 %z, double %a, double %b
  %d = fneg double %c
  store double %d, ptr addrspace(1) %dst
  ret void
}

define amdgpu_kernel void @fnge_select_f32_multi_use_regression(float %.i2369) {
; GCN-LABEL: fnge_select_f32_multi_use_regression:
; GCN:       ; %bb.0: ; %.entry
; GCN-NEXT:    s_load_dword s0, s[8:9], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_cmp_nlt_f32_e64 s[0:1], s0, 0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[0:1]
; GCN-NEXT:    v_cmp_nge_f32_e32 vcc, 0, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc
; GCN-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GCN-NEXT:    v_cmp_le_f32_e32 vcc, 0, v0
; GCN-NEXT:    s_and_b64 vcc, exec, vcc
; GCN-NEXT:    s_endpgm
;
; GFX11-LABEL: fnge_select_f32_multi_use_regression:
; GFX11:       ; %bb.0: ; %.entry
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlt_f32_e64 s0, s0, 0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    v_cmp_nge_f32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v1, 0, v0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e64 v0, -v0, v1
; GFX11-NEXT:    v_cmp_le_f32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_and_b32 vcc_lo, exec_lo, vcc_lo
; GFX11-NEXT:    s_endpgm
.entry:
  %i = fcmp uge float %.i2369, 0.000000e+00
  %.i2379 = select i1 %i, i32 1, i32 0
  %.i0436 = bitcast i32 %.i2379 to float
  %.i0440 = fneg float %.i0436
  %i1 = fcmp ugt float %.i0436, 0.000000e+00
  %.i2495 = select i1 %i1, i32 %.i2379, i32 0
  %.i0552 = bitcast i32 %.i2495 to float
  %.i0592 = fmul float %.i0440, %.i0552
  %.i0721 = fcmp oge float %.i0592, 0.000000e+00
  br i1 %.i0721, label %bb5, label %bb

bb:                                               ; preds = %.entry
  %i2 = call <2 x i32> @llvm.amdgcn.s.buffer.load.v2i32(<4 x i32> zeroinitializer, i32 1, i32 0)
  %i3 = shufflevector <2 x i32> %i2, <2 x i32> zeroinitializer, <4 x i32> <i32 0, i32 1, i32 poison, i32 poison>
  %i4 = bitcast <4 x i32> %i3 to <4 x float>
  %.i0753 = extractelement <4 x float> %i4, i64 0
  br label %bb5

bb5:                                              ; preds = %bb, %.entry
  ret void
}


declare <2 x i32> @llvm.amdgcn.s.buffer.load.v2i32(<4 x i32>, i32, i32 immarg) #0

attributes #0 = { nocallback nofree nosync nounwind willreturn memory(none) }
