; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --extra_scrub --version 5
; RUN: llc -mtriple=amdgcn-- -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN %s
; RUN: llc -mtriple=amdgcn-- -mcpu=tonga -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX89 %s
; RUN: llc -mtriple=amdgcn-- -mcpu=gfx900 -mattr=-flat-for-global -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GFX89 %s

define amdgpu_kernel void @extract_vector_elt_v2i16(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr) #0 {
;
; GCN-LABEL: extract_vector_elt_v2i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_load_dword s4, s[2:3], 0x0
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b32 s5, s4, 16
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    buffer_store_short v1, off, s[0:3], 0
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0 offset:20
; GCN-NEXT:    s_endpgm
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %p0 = extractelement <2 x i16> %vec, i32 0
  %p1 = extractelement <2 x i16> %vec, i32 1
  %out1 = getelementptr i16, ptr addrspace(1) %out, i32 10
  store i16 %p1, ptr addrspace(1) %out, align 2
  store i16 %p0, ptr addrspace(1) %out1, align 2
  ret void
}

define amdgpu_kernel void @extract_vector_elt_v2i16_dynamic_sgpr(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, [8 x i32], i32 %idx) #0 {
; GCN-LABEL: extract_vector_elt_v2i16_dynamic_sgpr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_load_dword s4, s[4:5], 0x15
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_load_dword s2, s[2:3], 0x0
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_lshl_b32 s4, s4, 4
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b32 s4, s2, s4
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; GFX89-LABEL: extract_vector_elt_v2i16_dynamic_sgpr:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_load_dword s8, s[4:5], 0x54
; GFX89-NEXT:    s_mov_b32 s7, 0xf000
; GFX89-NEXT:    s_mov_b32 s6, -1
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX89-NEXT:    s_mov_b32 s4, s0
; GFX89-NEXT:    s_lshl_b32 s0, s8, 4
; GFX89-NEXT:    s_mov_b32 s5, s1
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_lshr_b32 s0, s2, s0
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX89-NEXT:    s_endpgm
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %elt = extractelement <2 x i16> %vec, i32 %idx
  store i16 %elt, ptr addrspace(1) %out, align 2
  ret void
}

define amdgpu_kernel void @extract_vector_elt_v2i16_dynamic_vgpr(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, ptr addrspace(1) %idx.ptr) #0 {
;
; GCN-LABEL: extract_vector_elt_v2i16_dynamic_vgpr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    buffer_load_dword v3, v[1:2], s[4:7], 0 addr64 glc
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_load_dword s2, s[2:3], 0x0
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GCN-NEXT:    v_lshlrev_b32_e32 v0, 4, v3
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_lshr_b32_e32 v0, s2, v0
; GCN-NEXT:    buffer_store_short v0, v[1:2], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %tid.ext = sext i32 %tid to i64
  %gep = getelementptr inbounds i32, ptr addrspace(1) %idx.ptr, i64 %tid.ext
  %out.gep = getelementptr inbounds i16, ptr addrspace(1) %out, i64 %tid.ext
  %idx = load volatile i32, ptr addrspace(1) %gep
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %elt = extractelement <2 x i16> %vec, i32 %idx
  store i16 %elt, ptr addrspace(1) %out.gep, align 2
  ret void
}

define amdgpu_kernel void @extract_vector_elt_v3i16(ptr addrspace(1) %out, <3 x i16> %foo) #0 {
;
;
;
;
; GCN-LABEL: extract_vector_elt_v3i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    v_mov_b32_e32 v0, s3
; GCN-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GCN-NEXT:    s_waitcnt expcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    buffer_store_short v0, off, s[4:7], 0 offset:2
; GCN-NEXT:    s_endpgm
;
; GFX89-LABEL: extract_vector_elt_v3i16:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_mov_b32 s7, 0xf000
; GFX89-NEXT:    s_mov_b32 s6, -1
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s4, s0
; GFX89-NEXT:    s_mov_b32 s5, s1
; GFX89-NEXT:    v_mov_b32_e32 v0, s3
; GFX89-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    buffer_store_short v0, off, s[4:7], 0 offset:2
; GFX89-NEXT:    s_endpgm
  %p0 = extractelement <3 x i16> %foo, i32 0
  %p1 = extractelement <3 x i16> %foo, i32 2
  %out1 = getelementptr i16, ptr addrspace(1) %out, i32 1
  store i16 %p1, ptr addrspace(1) %out, align 2
  store i16 %p0, ptr addrspace(1) %out1, align 2
  ret void
}

define amdgpu_kernel void @extract_vector_elt_v4i16(ptr addrspace(1) %out, <4 x i16> %foo) #0 {
;
;
; GCN-LABEL: extract_vector_elt_v4i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_mov_b32 s5, s1
; GCN-NEXT:    v_mov_b32_e32 v0, s3
; GCN-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    buffer_store_short v0, off, s[4:7], 0 offset:20
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
;
; GFX89-LABEL: extract_vector_elt_v4i16:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX89-NEXT:    s_mov_b32 s7, 0xf000
; GFX89-NEXT:    s_mov_b32 s6, -1
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_mov_b32 s4, s0
; GFX89-NEXT:    s_mov_b32 s5, s1
; GFX89-NEXT:    v_mov_b32_e32 v0, s3
; GFX89-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s2
; GFX89-NEXT:    buffer_store_short v0, off, s[4:7], 0 offset:20
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    s_endpgm
  %p0 = extractelement <4 x i16> %foo, i32 0
  %p1 = extractelement <4 x i16> %foo, i32 2
  %out1 = getelementptr i16, ptr addrspace(1) %out, i32 10
  store volatile i16 %p1, ptr addrspace(1) %out, align 2
  store volatile i16 %p0, ptr addrspace(1) %out1, align 2
  ret void
}

define amdgpu_kernel void @dynamic_extract_vector_elt_v3i16(ptr addrspace(1) %out, [8 x i32], <3 x i16> %foo, i32 %idx) #0 {
;
;
; GCN-LABEL: dynamic_extract_vector_elt_v3i16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x15
; GCN-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x13
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s2, s2, 4
; GCN-NEXT:    s_lshr_b64 s[4:5], s[6:7], s2
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GCN-NEXT:    s_endpgm
;
; GFX89-LABEL: dynamic_extract_vector_elt_v3i16:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_load_dword s8, s[4:5], 0x54
; GFX89-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x4c
; GFX89-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX89-NEXT:    s_mov_b32 s3, 0xf000
; GFX89-NEXT:    s_mov_b32 s2, -1
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_lshl_b32 s4, s8, 4
; GFX89-NEXT:    s_lshr_b64 s[4:5], s[6:7], s4
; GFX89-NEXT:    v_mov_b32_e32 v0, s4
; GFX89-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX89-NEXT:    s_endpgm
  %p0 = extractelement <3 x i16> %foo, i32 %idx
  %out1 = getelementptr i16, ptr addrspace(1) %out, i32 1
  store i16 %p0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_insertelement_v4i16_dynamic_sgpr(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %idx) #0 {
;
;
;
; GCN-LABEL: v_insertelement_v4i16_dynamic_sgpr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_load_dword s8, s[4:5], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 3, v0
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GCN-NEXT:    buffer_load_dwordx2 v[3:4], v[1:2], s[4:7], 0 addr64
; GCN-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GCN-NEXT:    s_lshl_b32 s4, s8, 4
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshr_b64 v[3:4], v[3:4], s4
; GCN-NEXT:    buffer_store_short v3, v[1:2], s[0:3], 0 addr64
; GCN-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds i16, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <4 x i16>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <4 x i16> %vec, i32 %idx
  store i16 %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @reduce_load_vector_v8i16_extract_01(ptr addrspace(4) %ptr) #0 {
;
;
;
;
; GCN-LABEL: reduce_load_vector_v8i16_extract_01:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_load_dword s0, s[0:1], 0x0
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b32 s1, s0, 16
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
;
; GFX89-LABEL: reduce_load_vector_v8i16_extract_01:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX89-NEXT:    s_mov_b32 s3, 0xf000
; GFX89-NEXT:    s_mov_b32 s2, -1
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_lshr_b32 s1, s0, 16
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s1
; GFX89-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    s_endpgm
  %load = load <16 x i16>, ptr addrspace(4) %ptr
  %elt0 = extractelement <16 x i16> %load, i32 0
  %elt1 = extractelement <16 x i16> %load, i32 1
  store volatile i16 %elt0, ptr addrspace(1) poison, align 2
  store volatile i16 %elt1, ptr addrspace(1) poison, align 2
  ret void
}

define amdgpu_kernel void @reduce_load_vector_v8i16_extract_23(ptr addrspace(4) %ptr) #0 {
;
;
;
;
; GCN-LABEL: reduce_load_vector_v8i16_extract_23:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_load_dword s0, s[0:1], 0x1
; GCN-NEXT:    s_mov_b32 s3, 0xf000
; GCN-NEXT:    s_mov_b32 s2, -1
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b32 s1, s0, 16
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    s_endpgm
;
; GFX89-LABEL: reduce_load_vector_v8i16_extract_23:
; GFX89:       ; %bb.0:
; GFX89-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX89-NEXT:    s_mov_b32 s3, 0xf000
; GFX89-NEXT:    s_mov_b32 s2, -1
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_load_dword s0, s[0:1], 0x4
; GFX89-NEXT:    s_waitcnt lgkmcnt(0)
; GFX89-NEXT:    s_lshr_b32 s1, s0, 16
; GFX89-NEXT:    v_mov_b32_e32 v0, s0
; GFX89-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    v_mov_b32_e32 v0, s1
; GFX89-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX89-NEXT:    s_waitcnt vmcnt(0)
; GFX89-NEXT:    s_endpgm
  %load = load <16 x i16>, ptr addrspace(4) %ptr
  %elt2 = extractelement <16 x i16> %load, i32 2
  %elt3 = extractelement <16 x i16> %load, i32 3
  store volatile i16 %elt2, ptr addrspace(1) poison, align 2
  store volatile i16 %elt3, ptr addrspace(1) poison, align 2
  ret void
}

define amdgpu_kernel void @v_extractelement_v8i16_2(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
;
;
;
; GCN-LABEL: v_extractelement_v8i16_2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 4, v0
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    buffer_load_dword v3, v[1:2], s[8:11], 0 addr64 offset:4
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_short v3, v[1:2], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <8 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds i16, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <8 x i16>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <8 x i16> %vec, i32 2
  store i16 %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_extractelement_v8i16_6(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
;
;
;
; GCN-LABEL: v_extractelement_v8i16_6:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 4, v0
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    buffer_load_dword v3, v[1:2], s[8:11], 0 addr64 offset:12
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_short v3, v[1:2], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <8 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds i16, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <8 x i16>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <8 x i16> %vec, i32 6
  store i16 %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_extractelement_v8i16_dynamic_sgpr(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %n) #0 {
;
;
;
; GCN-LABEL: v_extractelement_v8i16_dynamic_sgpr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_load_dword s8, s[4:5], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; GCN-NEXT:    v_mov_b32_e32 v5, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GCN-NEXT:    buffer_load_dwordx4 v[1:4], v[4:5], s[4:7], 0 addr64
; GCN-NEXT:    v_lshlrev_b32_e32 v6, 1, v0
; GCN-NEXT:    v_mov_b32_e32 v7, v5
; GCN-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GCN-NEXT:    s_cmp_eq_u32 s8, 1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 2
; GCN-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GCN-NEXT:    v_lshrrev_b32_e32 v8, 16, v3
; GCN-NEXT:    v_lshrrev_b32_e32 v9, 16, v4
; GCN-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 3
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 4
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 5
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 6
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 7
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v9, vcc
; GCN-NEXT:    buffer_store_short v0, v[6:7], s[0:3], 0 addr64
; GCN-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <8 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds i16, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <8 x i16>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <8 x i16> %vec, i32 %n
  store i16 %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_extractelement_v16i16_2(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
;
;
;
; GCN-LABEL: v_extractelement_v16i16_2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 5, v0
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    buffer_load_dword v3, v[1:2], s[8:11], 0 addr64 offset:4
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_short v3, v[1:2], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <16 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds i16, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <16 x i16>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <16 x i16> %vec, i32 2
  store i16 %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_extractelement_v16i16_6(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
;
;
;
; GCN-LABEL: v_extractelement_v16i16_6:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 5, v0
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    v_mov_b32_e32 v2, 0
; GCN-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[8:9], s[2:3]
; GCN-NEXT:    buffer_load_dword v3, v[1:2], s[8:11], 0 addr64 offset:12
; GCN-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 1, v0
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    buffer_store_short v3, v[1:2], s[4:7], 0 addr64
; GCN-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <16 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds i16, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <16 x i16>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <16 x i16> %vec, i32 6
  store i16 %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_extractelement_v16i16_dynamic_sgpr(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %n) #0 {
;
;
;
; GCN-LABEL: v_extractelement_v16i16_dynamic_sgpr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GCN-NEXT:    s_load_dword s8, s[4:5], 0xd
; GCN-NEXT:    s_mov_b32 s7, 0xf000
; GCN-NEXT:    s_mov_b32 s6, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v5, 5, v0
; GCN-NEXT:    v_mov_b32_e32 v6, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b64 s[4:5], s[2:3]
; GCN-NEXT:    buffer_load_dwordx4 v[1:4], v[5:6], s[4:7], 0 addr64
; GCN-NEXT:    v_lshlrev_b32_e32 v9, 1, v0
; GCN-NEXT:    v_mov_b32_e32 v10, v6
; GCN-NEXT:    s_mov_b64 s[2:3], s[6:7]
; GCN-NEXT:    buffer_load_dwordx4 v[5:8], v[5:6], s[4:7], 0 addr64 offset:16
; GCN-NEXT:    s_cmp_eq_u32 s8, 1
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_lshrrev_b32_e32 v0, 16, v1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 2
; GCN-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GCN-NEXT:    v_lshrrev_b32_e32 v12, 16, v3
; GCN-NEXT:    v_lshrrev_b32_e32 v13, 16, v4
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshrrev_b32_e32 v14, 16, v5
; GCN-NEXT:    v_lshrrev_b32_e32 v15, 16, v6
; GCN-NEXT:    v_lshrrev_b32_e32 v16, 16, v7
; GCN-NEXT:    v_lshrrev_b32_e32 v17, 16, v8
; GCN-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 3
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 4
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v11, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 5
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 6
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v12, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 7
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 8
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v13, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 9
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 10
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v14, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 11
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 12
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v15, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 13
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v7, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 14
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_eq_u32 s8, 15
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v17, vcc
; GCN-NEXT:    buffer_store_short v0, v[9:10], s[0:3], 0 addr64
; GCN-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <16 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds i16, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <16 x i16>, ptr addrspace(1) %in.gep
  %vec.extract = extractelement <16 x i16> %vec, i32 %n
  store i16 %vec.extract, ptr addrspace(1) %out.gep
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
