; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test widening vector multiplication.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

; Test a v16i8 (even) -> v8i16 unsigned widening multiplication.
define <8 x i16> @f1(<16 x i8> %val1, <16 x i8> %val2) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmleb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <16 x i8> %val1, <16 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %zext1 = zext <8 x i8> %shuf1 to <8 x i16>
  %shuf2 = shufflevector <16 x i8> %val2, <16 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %zext2 = zext <8 x i8> %shuf2 to <8 x i16>
  %ret = mul <8 x i16> %zext1, %zext2
  ret <8 x i16> %ret
}

; Test a v16i8 (odd) -> v8i16 unsigned widening multiplication.
define <8 x i16> @f2(<16 x i8> %val1, <16 x i8> %val2) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlob %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <16 x i8> %val1, <16 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %zext1 = zext <8 x i8> %shuf1 to <8 x i16>
  %shuf2 = shufflevector <16 x i8> %val2, <16 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %zext2 = zext <8 x i8> %shuf2 to <8 x i16>
  %ret = mul <8 x i16> %zext1, %zext2
  ret <8 x i16> %ret
}

; Test a v16i8 (even) -> v8i16 signed widening multiplication.
define <8 x i16> @f3(<16 x i8> %val1, <16 x i8> %val2) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmeb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <16 x i8> %val1, <16 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %sext1 = sext <8 x i8> %shuf1 to <8 x i16>
  %shuf2 = shufflevector <16 x i8> %val2, <16 x i8> poison, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %sext2 = sext <8 x i8> %shuf2 to <8 x i16>
  %ret = mul <8 x i16> %sext1, %sext2
  ret <8 x i16> %ret
}

; Test a v16i8 (odd) -> v8i16 signed widening multiplication.
define <8 x i16> @f4(<16 x i8> %val1, <16 x i8> %val2) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmob %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <16 x i8> %val1, <16 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %sext1 = sext <8 x i8> %shuf1 to <8 x i16>
  %shuf2 = shufflevector <16 x i8> %val2, <16 x i8> poison, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %sext2 = sext <8 x i8> %shuf2 to <8 x i16>
  %ret = mul <8 x i16> %sext1, %sext2
  ret <8 x i16> %ret
}

; Test a v8i16 (even) -> v4i32 unsigned widening multiplication.
define <4 x i32> @f5(<8 x i16> %val1, <8 x i16> %val2) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmleh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <8 x i16> %val1, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %zext1 = zext <4 x i16> %shuf1 to <4 x i32>
  %shuf2 = shufflevector <8 x i16> %val2, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %zext2 = zext <4 x i16> %shuf2 to <4 x i32>
  %ret = mul <4 x i32> %zext1, %zext2
  ret <4 x i32> %ret
}

; Test a v8i16 (odd) -> v4i32 unsigned widening multiplication.
define <4 x i32> @f6(<8 x i16> %val1, <8 x i16> %val2) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmloh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <8 x i16> %val1, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %zext1 = zext <4 x i16> %shuf1 to <4 x i32>
  %shuf2 = shufflevector <8 x i16> %val2, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %zext2 = zext <4 x i16> %shuf2 to <4 x i32>
  %ret = mul <4 x i32> %zext1, %zext2
  ret <4 x i32> %ret
}

; Test a v8i16 (even) -> v4i32 signed widening multiplication.
define <4 x i32> @f7(<8 x i16> %val1, <8 x i16> %val2) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmeh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <8 x i16> %val1, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %sext1 = sext <4 x i16> %shuf1 to <4 x i32>
  %shuf2 = shufflevector <8 x i16> %val2, <8 x i16> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %sext2 = sext <4 x i16> %shuf2 to <4 x i32>
  %ret = mul <4 x i32> %sext1, %sext2
  ret <4 x i32> %ret
}

; Test a v8i16 (odd) -> v4i32 signed widening multiplication.
define <4 x i32> @f8(<8 x i16> %val1, <8 x i16> %val2) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmoh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <8 x i16> %val1, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %sext1 = sext <4 x i16> %shuf1 to <4 x i32>
  %shuf2 = shufflevector <8 x i16> %val2, <8 x i16> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %sext2 = sext <4 x i16> %shuf2 to <4 x i32>
  %ret = mul <4 x i32> %sext1, %sext2
  ret <4 x i32> %ret
}

; Test a v4i32 (even) -> v2i64 unsigned widening multiplication.
define <2 x i64> @f9(<4 x i32> %val1, <4 x i32> %val2) {
; CHECK-LABEL: f9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlef %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <4 x i32> %val1, <4 x i32> poison, <2 x i32> <i32 0, i32 2>
  %zext1 = zext <2 x i32> %shuf1 to <2 x i64>
  %shuf2 = shufflevector <4 x i32> %val2, <4 x i32> poison, <2 x i32> <i32 0, i32 2>
  %zext2 = zext <2 x i32> %shuf2 to <2 x i64>
  %ret = mul <2 x i64> %zext1, %zext2
  ret <2 x i64> %ret
}

; Test a v4i32 (odd) -> v2i64 unsigned widening multiplication.
define <2 x i64> @f10(<4 x i32> %val1, <4 x i32> %val2) {
; CHECK-LABEL: f10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlof %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <4 x i32> %val1, <4 x i32> poison, <2 x i32> <i32 1, i32 3>
  %zext1 = zext <2 x i32> %shuf1 to <2 x i64>
  %shuf2 = shufflevector <4 x i32> %val2, <4 x i32> poison, <2 x i32> <i32 1, i32 3>
  %zext2 = zext <2 x i32> %shuf2 to <2 x i64>
  %ret = mul <2 x i64> %zext1, %zext2
  ret <2 x i64> %ret
}

; Test a v4i32 (even) -> v2i64 signed widening multiplication.
define <2 x i64> @f11(<4 x i32> %val1, <4 x i32> %val2) {
; CHECK-LABEL: f11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmef %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <4 x i32> %val1, <4 x i32> poison, <2 x i32> <i32 0, i32 2>
  %sext1 = sext <2 x i32> %shuf1 to <2 x i64>
  %shuf2 = shufflevector <4 x i32> %val2, <4 x i32> poison, <2 x i32> <i32 0, i32 2>
  %sext2 = sext <2 x i32> %shuf2 to <2 x i64>
  %ret = mul <2 x i64> %sext1, %sext2
  ret <2 x i64> %ret
}

; Test a v4i32 (odd) -> v2i64 signed widening multiplication.
define <2 x i64> @f12(<4 x i32> %val1, <4 x i32> %val2) {
; CHECK-LABEL: f12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmof %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %shuf1 = shufflevector <4 x i32> %val1, <4 x i32> poison, <2 x i32> <i32 1, i32 3>
  %sext1 = sext <2 x i32> %shuf1 to <2 x i64>
  %shuf2 = shufflevector <4 x i32> %val2, <4 x i32> poison, <2 x i32> <i32 1, i32 3>
  %sext2 = sext <2 x i32> %shuf2 to <2 x i64>
  %ret = mul <2 x i64> %sext1, %sext2
  ret <2 x i64> %ret
}
