// NOTE: Assertions have been autogenerated by utils/update_mc_test_checks.py UTC_ARGS: --version 5
// RUN: llvm-mc -triple=amdgcn -show-encoding -mcpu=gfx1200 %s | FileCheck -check-prefix=GFX12 %s

s_add_nc_u64 s[0:1], s[2:3], s[4:5]
// GFX12: s_add_nc_u64 s[0:1], s[2:3], s[4:5]     ; encoding: [0x02,0x04,0x80,0xa9]

s_add_nc_u64 s[100:101], s[102:103], s[104:105]
// GFX12: s_add_nc_u64 s[100:101], s[102:103], s[104:105] ; encoding: [0x66,0x68,0xe4,0xa9]

s_add_nc_u64 s[0:1], s[104:105], s[102:103]
// GFX12: s_add_nc_u64 s[0:1], s[104:105], s[102:103] ; encoding: [0x68,0x66,0x80,0xa9]

s_add_nc_u64 s[104:105], s[0:1], s[102:103]
// GFX12: s_add_nc_u64 s[104:105], s[0:1], s[102:103] ; encoding: [0x00,0x66,0xe8,0xa9]

s_add_nc_u64 s[104:105], s[102:103], s[2:3]
// GFX12: s_add_nc_u64 s[104:105], s[102:103], s[2:3] ; encoding: [0x66,0x02,0xe8,0xa9]

s_add_nc_u64 s[104:105], s[0:1], s[2:3]
// GFX12: s_add_nc_u64 s[104:105], s[0:1], s[2:3] ; encoding: [0x00,0x02,0xe8,0xa9]

s_add_nc_u64 s[0:1], s[102:103], s[2:3]
// GFX12: s_add_nc_u64 s[0:1], s[102:103], s[2:3] ; encoding: [0x66,0x02,0x80,0xa9]

s_add_nc_u64 s[0:1], s[2:3], s[102:103]
// GFX12: s_add_nc_u64 s[0:1], s[2:3], s[102:103] ; encoding: [0x02,0x66,0x80,0xa9]

s_add_nc_u64 exec, s[0:1], s[2:3]
// GFX12: s_add_nc_u64 exec, s[0:1], s[2:3]       ; encoding: [0x00,0x02,0xfe,0xa9]

s_add_nc_u64 vcc, s[0:1], s[2:3]
// GFX12: s_add_nc_u64 vcc, s[0:1], s[2:3]        ; encoding: [0x00,0x02,0xea,0xa9]

s_add_nc_u64 s[0:1], exec, s[2:3]
// GFX12: s_add_nc_u64 s[0:1], exec, s[2:3]       ; encoding: [0x7e,0x02,0x80,0xa9]

s_add_nc_u64 s[0:1], vcc, s[2:3]
// GFX12: s_add_nc_u64 s[0:1], vcc, s[2:3]        ; encoding: [0x6a,0x02,0x80,0xa9]

s_add_nc_u64 s[0:1], 0, s[2:3]
// GFX12: s_add_nc_u64 s[0:1], 0, s[2:3]          ; encoding: [0x80,0x02,0x80,0xa9]

s_add_nc_u64 s[0:1], -1, s[2:3]
// GFX12: s_add_nc_u64 s[0:1], -1, s[2:3]         ; encoding: [0xc1,0x02,0x80,0xa9]

s_add_nc_u64 s[0:1], 0.5, s[2:3]
// GFX12: s_add_nc_u64 s[0:1], 0.5, s[2:3]        ; encoding: [0xf0,0x02,0x80,0xa9]

s_add_nc_u64 s[0:1], -4.0, s[2:3]
// GFX12: s_add_nc_u64 s[0:1], -4.0, s[2:3]       ; encoding: [0xf7,0x02,0x80,0xa9]

s_add_nc_u64 s[0:1], 0x3f717273, s[2:3]
// GFX12: s_add_nc_u64 s[0:1], 0x3f717273, s[2:3] ; encoding: [0xff,0x02,0x80,0xa9,0x73,0x72,0x71,0x3f]

s_add_nc_u64 s[0:1], 0xaf123456, s[2:3]
// GFX12: s_add_nc_u64 s[0:1], 0xaf123456, s[2:3] ; encoding: [0xff,0x02,0x80,0xa9,0x56,0x34,0x12,0xaf]

s_add_nc_u64 s[0:1], s[2:3], exec
// GFX12: s_add_nc_u64 s[0:1], s[2:3], exec       ; encoding: [0x02,0x7e,0x80,0xa9]

s_add_nc_u64 s[0:1], s[2:3], vcc
// GFX12: s_add_nc_u64 s[0:1], s[2:3], vcc        ; encoding: [0x02,0x6a,0x80,0xa9]

s_add_nc_u64 s[0:1], s[2:3], 0
// GFX12: s_add_nc_u64 s[0:1], s[2:3], 0          ; encoding: [0x02,0x80,0x80,0xa9]

s_add_nc_u64 s[0:1], s[2:3], -1
// GFX12: s_add_nc_u64 s[0:1], s[2:3], -1         ; encoding: [0x02,0xc1,0x80,0xa9]

s_add_nc_u64 s[0:1], s[2:3], 0.5
// GFX12: s_add_nc_u64 s[0:1], s[2:3], 0.5        ; encoding: [0x02,0xf0,0x80,0xa9]

s_add_nc_u64 s[0:1], s[2:3], -4.0
// GFX12: s_add_nc_u64 s[0:1], s[2:3], -4.0       ; encoding: [0x02,0xf7,0x80,0xa9]

s_add_nc_u64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_add_nc_u64 s[0:1], s[2:3], 0x3f717273 ; encoding: [0x02,0xff,0x80,0xa9,0x73,0x72,0x71,0x3f]

s_add_nc_u64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_add_nc_u64 s[0:1], s[2:3], 0xaf123456 ; encoding: [0x02,0xff,0x80,0xa9,0x56,0x34,0x12,0xaf]

s_sub_nc_u64 s[0:1], s[2:3], s[4:5]
// GFX12: s_sub_nc_u64 s[0:1], s[2:3], s[4:5]     ; encoding: [0x02,0x04,0x00,0xaa]

s_sub_nc_u64 s[100:101], s[102:103], s[104:105]
// GFX12: s_sub_nc_u64 s[100:101], s[102:103], s[104:105] ; encoding: [0x66,0x68,0x64,0xaa]

s_sub_nc_u64 s[0:1], s[104:105], s[102:103]
// GFX12: s_sub_nc_u64 s[0:1], s[104:105], s[102:103] ; encoding: [0x68,0x66,0x00,0xaa]

s_sub_nc_u64 s[104:105], s[0:1], s[102:103]
// GFX12: s_sub_nc_u64 s[104:105], s[0:1], s[102:103] ; encoding: [0x00,0x66,0x68,0xaa]

s_sub_nc_u64 s[104:105], s[102:103], s[2:3]
// GFX12: s_sub_nc_u64 s[104:105], s[102:103], s[2:3] ; encoding: [0x66,0x02,0x68,0xaa]

s_sub_nc_u64 s[104:105], s[0:1], s[2:3]
// GFX12: s_sub_nc_u64 s[104:105], s[0:1], s[2:3] ; encoding: [0x00,0x02,0x68,0xaa]

s_sub_nc_u64 s[0:1], s[102:103], s[2:3]
// GFX12: s_sub_nc_u64 s[0:1], s[102:103], s[2:3] ; encoding: [0x66,0x02,0x00,0xaa]

s_sub_nc_u64 s[0:1], s[2:3], s[102:103]
// GFX12: s_sub_nc_u64 s[0:1], s[2:3], s[102:103] ; encoding: [0x02,0x66,0x00,0xaa]

s_sub_nc_u64 exec, s[0:1], s[2:3]
// GFX12: s_sub_nc_u64 exec, s[0:1], s[2:3]       ; encoding: [0x00,0x02,0x7e,0xaa]

s_sub_nc_u64 vcc, s[0:1], s[2:3]
// GFX12: s_sub_nc_u64 vcc, s[0:1], s[2:3]        ; encoding: [0x00,0x02,0x6a,0xaa]

s_sub_nc_u64 s[0:1], exec, s[2:3]
// GFX12: s_sub_nc_u64 s[0:1], exec, s[2:3]       ; encoding: [0x7e,0x02,0x00,0xaa]

s_sub_nc_u64 s[0:1], vcc, s[2:3]
// GFX12: s_sub_nc_u64 s[0:1], vcc, s[2:3]        ; encoding: [0x6a,0x02,0x00,0xaa]

s_sub_nc_u64 s[0:1], 0, s[2:3]
// GFX12: s_sub_nc_u64 s[0:1], 0, s[2:3]          ; encoding: [0x80,0x02,0x00,0xaa]

s_sub_nc_u64 s[0:1], -1, s[2:3]
// GFX12: s_sub_nc_u64 s[0:1], -1, s[2:3]         ; encoding: [0xc1,0x02,0x00,0xaa]

s_sub_nc_u64 s[0:1], 0.5, s[2:3]
// GFX12: s_sub_nc_u64 s[0:1], 0.5, s[2:3]        ; encoding: [0xf0,0x02,0x00,0xaa]

s_sub_nc_u64 s[0:1], -4.0, s[2:3]
// GFX12: s_sub_nc_u64 s[0:1], -4.0, s[2:3]       ; encoding: [0xf7,0x02,0x00,0xaa]

s_sub_nc_u64 s[0:1], 0x3f717273, s[2:3]
// GFX12: s_sub_nc_u64 s[0:1], 0x3f717273, s[2:3] ; encoding: [0xff,0x02,0x00,0xaa,0x73,0x72,0x71,0x3f]

s_sub_nc_u64 s[0:1], 0xaf123456, s[2:3]
// GFX12: s_sub_nc_u64 s[0:1], 0xaf123456, s[2:3] ; encoding: [0xff,0x02,0x00,0xaa,0x56,0x34,0x12,0xaf]

s_sub_nc_u64 s[0:1], s[2:3], exec
// GFX12: s_sub_nc_u64 s[0:1], s[2:3], exec       ; encoding: [0x02,0x7e,0x00,0xaa]

s_sub_nc_u64 s[0:1], s[2:3], vcc
// GFX12: s_sub_nc_u64 s[0:1], s[2:3], vcc        ; encoding: [0x02,0x6a,0x00,0xaa]

s_sub_nc_u64 s[0:1], s[2:3], 0
// GFX12: s_sub_nc_u64 s[0:1], s[2:3], 0          ; encoding: [0x02,0x80,0x00,0xaa]

s_sub_nc_u64 s[0:1], s[2:3], -1
// GFX12: s_sub_nc_u64 s[0:1], s[2:3], -1         ; encoding: [0x02,0xc1,0x00,0xaa]

s_sub_nc_u64 s[0:1], s[2:3], 0.5
// GFX12: s_sub_nc_u64 s[0:1], s[2:3], 0.5        ; encoding: [0x02,0xf0,0x00,0xaa]

s_sub_nc_u64 s[0:1], s[2:3], -4.0
// GFX12: s_sub_nc_u64 s[0:1], s[2:3], -4.0       ; encoding: [0x02,0xf7,0x00,0xaa]

s_sub_nc_u64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_sub_nc_u64 s[0:1], s[2:3], 0x3f717273 ; encoding: [0x02,0xff,0x00,0xaa,0x73,0x72,0x71,0x3f]

s_sub_nc_u64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_sub_nc_u64 s[0:1], s[2:3], 0xaf123456 ; encoding: [0x02,0xff,0x00,0xaa,0x56,0x34,0x12,0xaf]

s_mul_u64 s[0:1], s[2:3], s[4:5]
// GFX12: s_mul_u64 s[0:1], s[2:3], s[4:5]        ; encoding: [0x02,0x04,0x80,0xaa]

s_mul_u64 s[100:101], s[102:103], s[104:105]
// GFX12: s_mul_u64 s[100:101], s[102:103], s[104:105] ; encoding: [0x66,0x68,0xe4,0xaa]

s_mul_u64 s[0:1], s[104:105], s[102:103]
// GFX12: s_mul_u64 s[0:1], s[104:105], s[102:103] ; encoding: [0x68,0x66,0x80,0xaa]

s_mul_u64 s[104:105], s[0:1], s[102:103]
// GFX12: s_mul_u64 s[104:105], s[0:1], s[102:103] ; encoding: [0x00,0x66,0xe8,0xaa]

s_mul_u64 s[104:105], s[102:103], s[2:3]
// GFX12: s_mul_u64 s[104:105], s[102:103], s[2:3] ; encoding: [0x66,0x02,0xe8,0xaa]

s_mul_u64 s[104:105], s[0:1], s[2:3]
// GFX12: s_mul_u64 s[104:105], s[0:1], s[2:3]    ; encoding: [0x00,0x02,0xe8,0xaa]

s_mul_u64 s[0:1], s[102:103], s[2:3]
// GFX12: s_mul_u64 s[0:1], s[102:103], s[2:3]    ; encoding: [0x66,0x02,0x80,0xaa]

s_mul_u64 s[0:1], s[2:3], s[102:103]
// GFX12: s_mul_u64 s[0:1], s[2:3], s[102:103]    ; encoding: [0x02,0x66,0x80,0xaa]

s_mul_u64 exec, s[0:1], s[2:3]
// GFX12: s_mul_u64 exec, s[0:1], s[2:3]          ; encoding: [0x00,0x02,0xfe,0xaa]

s_mul_u64 vcc, s[0:1], s[2:3]
// GFX12: s_mul_u64 vcc, s[0:1], s[2:3]           ; encoding: [0x00,0x02,0xea,0xaa]

s_mul_u64 s[0:1], exec, s[2:3]
// GFX12: s_mul_u64 s[0:1], exec, s[2:3]          ; encoding: [0x7e,0x02,0x80,0xaa]

s_mul_u64 s[0:1], vcc, s[2:3]
// GFX12: s_mul_u64 s[0:1], vcc, s[2:3]           ; encoding: [0x6a,0x02,0x80,0xaa]

s_mul_u64 s[0:1], 0, s[2:3]
// GFX12: s_mul_u64 s[0:1], 0, s[2:3]             ; encoding: [0x80,0x02,0x80,0xaa]

s_mul_u64 s[0:1], -1, s[2:3]
// GFX12: s_mul_u64 s[0:1], -1, s[2:3]            ; encoding: [0xc1,0x02,0x80,0xaa]

s_mul_u64 s[0:1], 0.5, s[2:3]
// GFX12: s_mul_u64 s[0:1], 0.5, s[2:3]           ; encoding: [0xf0,0x02,0x80,0xaa]

s_mul_u64 s[0:1], -4.0, s[2:3]
// GFX12: s_mul_u64 s[0:1], -4.0, s[2:3]          ; encoding: [0xf7,0x02,0x80,0xaa]

s_mul_u64 s[0:1], 0x3f717273, s[2:3]
// GFX12: s_mul_u64 s[0:1], 0x3f717273, s[2:3]    ; encoding: [0xff,0x02,0x80,0xaa,0x73,0x72,0x71,0x3f]

s_mul_u64 s[0:1], 0xaf123456, s[2:3]
// GFX12: s_mul_u64 s[0:1], 0xaf123456, s[2:3]    ; encoding: [0xff,0x02,0x80,0xaa,0x56,0x34,0x12,0xaf]

s_mul_u64 s[0:1], s[2:3], exec
// GFX12: s_mul_u64 s[0:1], s[2:3], exec          ; encoding: [0x02,0x7e,0x80,0xaa]

s_mul_u64 s[0:1], s[2:3], vcc
// GFX12: s_mul_u64 s[0:1], s[2:3], vcc           ; encoding: [0x02,0x6a,0x80,0xaa]

s_mul_u64 s[0:1], s[2:3], 0
// GFX12: s_mul_u64 s[0:1], s[2:3], 0             ; encoding: [0x02,0x80,0x80,0xaa]

s_mul_u64 s[0:1], s[2:3], -1
// GFX12: s_mul_u64 s[0:1], s[2:3], -1            ; encoding: [0x02,0xc1,0x80,0xaa]

s_mul_u64 s[0:1], s[2:3], 0.5
// GFX12: s_mul_u64 s[0:1], s[2:3], 0.5           ; encoding: [0x02,0xf0,0x80,0xaa]

s_mul_u64 s[0:1], s[2:3], -4.0
// GFX12: s_mul_u64 s[0:1], s[2:3], -4.0          ; encoding: [0x02,0xf7,0x80,0xaa]

s_mul_u64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_mul_u64 s[0:1], s[2:3], 0x3f717273    ; encoding: [0x02,0xff,0x80,0xaa,0x73,0x72,0x71,0x3f]

s_mul_u64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_mul_u64 s[0:1], s[2:3], 0xaf123456    ; encoding: [0x02,0xff,0x80,0xaa,0x56,0x34,0x12,0xaf]

s_add_f32 s5, s1, s2
// GFX12: s_add_f32 s5, s1, s2                    ; encoding: [0x01,0x02,0x05,0xa0]

s_add_f32 s105, s1, s2
// GFX12: s_add_f32 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0xa0]

s_add_f32 s5, s105, s2
// GFX12: s_add_f32 s5, s105, s2                  ; encoding: [0x69,0x02,0x05,0xa0]

s_add_f32 s5, s101, s2
// GFX12: s_add_f32 s5, s101, s2                  ; encoding: [0x65,0x02,0x05,0xa0]

s_add_f32 s5, vcc_lo, s2
// GFX12: s_add_f32 s5, vcc_lo, s2                ; encoding: [0x6a,0x02,0x05,0xa0]

s_add_f32 s5, vcc_hi, s2
// GFX12: s_add_f32 s5, vcc_hi, s2                ; encoding: [0x6b,0x02,0x05,0xa0]

s_add_f32 s5, m0, s2
// GFX12: s_add_f32 s5, m0, s2                    ; encoding: [0x7d,0x02,0x05,0xa0]

s_add_f32 s5, exec_lo, s2
// GFX12: s_add_f32 s5, exec_lo, s2               ; encoding: [0x7e,0x02,0x05,0xa0]

s_add_f32 s5, exec_hi, s2
// GFX12: s_add_f32 s5, exec_hi, s2               ; encoding: [0x7f,0x02,0x05,0xa0]

s_add_f32 s5, 0, s2
// GFX12: s_add_f32 s5, 0, s2                     ; encoding: [0x80,0x02,0x05,0xa0]

s_add_f32 s5, -1, s2
// GFX12: s_add_f32 s5, -1, s2                    ; encoding: [0xc1,0x02,0x05,0xa0]

s_add_f32 s5, 0.5, s2
// GFX12: s_add_f32 s5, 0.5, s2                   ; encoding: [0xf0,0x02,0x05,0xa0]

s_add_f32 s5, -4.0, s2
// GFX12: s_add_f32 s5, -4.0, s2                  ; encoding: [0xf7,0x02,0x05,0xa0]

s_add_f32 s5, 0xaf123456, s2
// GFX12: s_add_f32 s5, 0xaf123456, s2            ; encoding: [0xff,0x02,0x05,0xa0,0x56,0x34,0x12,0xaf]

s_add_f32 s5, 0x3f717273, s2
// GFX12: s_add_f32 s5, 0x3f717273, s2            ; encoding: [0xff,0x02,0x05,0xa0,0x73,0x72,0x71,0x3f]

s_add_f32 s5, s1, s105
// GFX12: s_add_f32 s5, s1, s105                  ; encoding: [0x01,0x69,0x05,0xa0]

s_sub_f32 s5, s1, s2
// GFX12: s_sub_f32 s5, s1, s2                    ; encoding: [0x01,0x02,0x85,0xa0]

s_sub_f32 s105, s1, s2
// GFX12: s_sub_f32 s105, s1, s2                  ; encoding: [0x01,0x02,0xe9,0xa0]

s_sub_f32 s5, s105, s2
// GFX12: s_sub_f32 s5, s105, s2                  ; encoding: [0x69,0x02,0x85,0xa0]

s_sub_f32 s5, s101, s2
// GFX12: s_sub_f32 s5, s101, s2                  ; encoding: [0x65,0x02,0x85,0xa0]

s_sub_f32 s5, vcc_lo, s2
// GFX12: s_sub_f32 s5, vcc_lo, s2                ; encoding: [0x6a,0x02,0x85,0xa0]

s_sub_f32 s5, vcc_hi, s2
// GFX12: s_sub_f32 s5, vcc_hi, s2                ; encoding: [0x6b,0x02,0x85,0xa0]

s_sub_f32 s5, m0, s2
// GFX12: s_sub_f32 s5, m0, s2                    ; encoding: [0x7d,0x02,0x85,0xa0]

s_sub_f32 s5, exec_lo, s2
// GFX12: s_sub_f32 s5, exec_lo, s2               ; encoding: [0x7e,0x02,0x85,0xa0]

s_sub_f32 s5, exec_hi, s2
// GFX12: s_sub_f32 s5, exec_hi, s2               ; encoding: [0x7f,0x02,0x85,0xa0]

s_sub_f32 s5, 0, s2
// GFX12: s_sub_f32 s5, 0, s2                     ; encoding: [0x80,0x02,0x85,0xa0]

s_sub_f32 s5, -1, s2
// GFX12: s_sub_f32 s5, -1, s2                    ; encoding: [0xc1,0x02,0x85,0xa0]

s_sub_f32 s5, 0.5, s2
// GFX12: s_sub_f32 s5, 0.5, s2                   ; encoding: [0xf0,0x02,0x85,0xa0]

s_sub_f32 s5, -4.0, s2
// GFX12: s_sub_f32 s5, -4.0, s2                  ; encoding: [0xf7,0x02,0x85,0xa0]

s_sub_f32 s5, 0xaf123456, s2
// GFX12: s_sub_f32 s5, 0xaf123456, s2            ; encoding: [0xff,0x02,0x85,0xa0,0x56,0x34,0x12,0xaf]

s_sub_f32 s5, 0x3f717273, s2
// GFX12: s_sub_f32 s5, 0x3f717273, s2            ; encoding: [0xff,0x02,0x85,0xa0,0x73,0x72,0x71,0x3f]

s_sub_f32 s5, s1, s105
// GFX12: s_sub_f32 s5, s1, s105                  ; encoding: [0x01,0x69,0x85,0xa0]

s_mul_f32 s5, s1, s2
// GFX12: s_mul_f32 s5, s1, s2                    ; encoding: [0x01,0x02,0x05,0xa2]

s_mul_f32 s105, s1, s2
// GFX12: s_mul_f32 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0xa2]

s_mul_f32 s5, s105, s2
// GFX12: s_mul_f32 s5, s105, s2                  ; encoding: [0x69,0x02,0x05,0xa2]

s_mul_f32 s5, s103, s2
// GFX12: s_mul_f32 s5, s103, s2                  ; encoding: [0x67,0x02,0x05,0xa2]

s_mul_f32 s5, vcc_lo, s2
// GFX12: s_mul_f32 s5, vcc_lo, s2                ; encoding: [0x6a,0x02,0x05,0xa2]

s_mul_f32 s5, vcc_hi, s2
// GFX12: s_mul_f32 s5, vcc_hi, s2                ; encoding: [0x6b,0x02,0x05,0xa2]

s_mul_f32 s5, ttmp11, s2
// GFX12: s_mul_f32 s5, ttmp11, s2                ; encoding: [0x77,0x02,0x05,0xa2]

s_mul_f32 s5, m0, s2
// GFX12: s_mul_f32 s5, m0, s2                    ; encoding: [0x7d,0x02,0x05,0xa2]

s_mul_f32 s5, exec_lo, s2
// GFX12: s_mul_f32 s5, exec_lo, s2               ; encoding: [0x7e,0x02,0x05,0xa2]

s_mul_f32 s5, exec_hi, s2
// GFX12: s_mul_f32 s5, exec_hi, s2               ; encoding: [0x7f,0x02,0x05,0xa2]

s_mul_f32 s5, 0, s2
// GFX12: s_mul_f32 s5, 0, s2                     ; encoding: [0x80,0x02,0x05,0xa2]

s_mul_f32 s5, -1, s2
// GFX12: s_mul_f32 s5, -1, s2                    ; encoding: [0xc1,0x02,0x05,0xa2]

s_mul_f32 s5, 0.5, s2
// GFX12: s_mul_f32 s5, 0.5, s2                   ; encoding: [0xf0,0x02,0x05,0xa2]

s_mul_f32 s5, -4.0, s2
// GFX12: s_mul_f32 s5, -4.0, s2                  ; encoding: [0xf7,0x02,0x05,0xa2]

s_mul_f32 s5, 0xaf123456, s2
// GFX12: s_mul_f32 s5, 0xaf123456, s2            ; encoding: [0xff,0x02,0x05,0xa2,0x56,0x34,0x12,0xaf]

s_mul_f32 s5, 0x3f717273, s2
// GFX12: s_mul_f32 s5, 0x3f717273, s2            ; encoding: [0xff,0x02,0x05,0xa2,0x73,0x72,0x71,0x3f]

s_mul_f32 s5, s1, s105
// GFX12: s_mul_f32 s5, s1, s105                  ; encoding: [0x01,0x69,0x05,0xa2]

s_min_num_f32 s5, s1, s2
// GFX12: s_min_num_f32 s5, s1, s2                ; encoding: [0x01,0x02,0x05,0xa1]

s_min_num_f32 s105, s1, s2
// GFX12: s_min_num_f32 s105, s1, s2              ; encoding: [0x01,0x02,0x69,0xa1]

s_min_num_f32 s5, s105, s2
// GFX12: s_min_num_f32 s5, s105, s2              ; encoding: [0x69,0x02,0x05,0xa1]

s_min_num_f32 s5, s103, s2
// GFX12: s_min_num_f32 s5, s103, s2              ; encoding: [0x67,0x02,0x05,0xa1]

s_min_num_f32 s5, vcc_lo, s2
// GFX12: s_min_num_f32 s5, vcc_lo, s2            ; encoding: [0x6a,0x02,0x05,0xa1]

s_min_num_f32 s5, vcc_hi, s2
// GFX12: s_min_num_f32 s5, vcc_hi, s2            ; encoding: [0x6b,0x02,0x05,0xa1]

s_min_num_f32 s5, ttmp11, s2
// GFX12: s_min_num_f32 s5, ttmp11, s2            ; encoding: [0x77,0x02,0x05,0xa1]

s_min_num_f32 s5, m0, s2
// GFX12: s_min_num_f32 s5, m0, s2                ; encoding: [0x7d,0x02,0x05,0xa1]

s_min_num_f32 s5, exec_lo, s2
// GFX12: s_min_num_f32 s5, exec_lo, s2           ; encoding: [0x7e,0x02,0x05,0xa1]

s_min_num_f32 s5, exec_hi, s2
// GFX12: s_min_num_f32 s5, exec_hi, s2           ; encoding: [0x7f,0x02,0x05,0xa1]

s_min_num_f32 s5, 0, s2
// GFX12: s_min_num_f32 s5, 0, s2                 ; encoding: [0x80,0x02,0x05,0xa1]

s_min_num_f32 s5, -1, s2
// GFX12: s_min_num_f32 s5, -1, s2                ; encoding: [0xc1,0x02,0x05,0xa1]

s_min_num_f32 s5, 0.5, s2
// GFX12: s_min_num_f32 s5, 0.5, s2               ; encoding: [0xf0,0x02,0x05,0xa1]

s_min_num_f32 s5, -4.0, s2
// GFX12: s_min_num_f32 s5, -4.0, s2              ; encoding: [0xf7,0x02,0x05,0xa1]

s_min_num_f32 s5, 0xaf123456, s2
// GFX12: s_min_num_f32 s5, 0xaf123456, s2        ; encoding: [0xff,0x02,0x05,0xa1,0x56,0x34,0x12,0xaf]

s_min_num_f32 s5, 0x3f717273, s2
// GFX12: s_min_num_f32 s5, 0x3f717273, s2        ; encoding: [0xff,0x02,0x05,0xa1,0x73,0x72,0x71,0x3f]

s_min_num_f32 s5, s1, s105
// GFX12: s_min_num_f32 s5, s1, s105              ; encoding: [0x01,0x69,0x05,0xa1]

s_max_num_f32 s5, s1, s2
// GFX12: s_max_num_f32 s5, s1, s2                ; encoding: [0x01,0x02,0x85,0xa1]

s_max_num_f32 s105, s1, s2
// GFX12: s_max_num_f32 s105, s1, s2              ; encoding: [0x01,0x02,0xe9,0xa1]

s_max_num_f32 s5, s105, s2
// GFX12: s_max_num_f32 s5, s105, s2              ; encoding: [0x69,0x02,0x85,0xa1]

s_max_num_f32 s5, s103, s2
// GFX12: s_max_num_f32 s5, s103, s2              ; encoding: [0x67,0x02,0x85,0xa1]

s_max_num_f32 s5, vcc_lo, s2
// GFX12: s_max_num_f32 s5, vcc_lo, s2            ; encoding: [0x6a,0x02,0x85,0xa1]

s_max_num_f32 s5, vcc_hi, s2
// GFX12: s_max_num_f32 s5, vcc_hi, s2            ; encoding: [0x6b,0x02,0x85,0xa1]

s_max_num_f32 s5, ttmp11, s2
// GFX12: s_max_num_f32 s5, ttmp11, s2            ; encoding: [0x77,0x02,0x85,0xa1]

s_max_num_f32 s5, m0, s2
// GFX12: s_max_num_f32 s5, m0, s2                ; encoding: [0x7d,0x02,0x85,0xa1]

s_max_num_f32 s5, exec_lo, s2
// GFX12: s_max_num_f32 s5, exec_lo, s2           ; encoding: [0x7e,0x02,0x85,0xa1]

s_max_num_f32 s5, exec_hi, s2
// GFX12: s_max_num_f32 s5, exec_hi, s2           ; encoding: [0x7f,0x02,0x85,0xa1]

s_max_num_f32 s5, 0, s2
// GFX12: s_max_num_f32 s5, 0, s2                 ; encoding: [0x80,0x02,0x85,0xa1]

s_max_num_f32 s5, -1, s2
// GFX12: s_max_num_f32 s5, -1, s2                ; encoding: [0xc1,0x02,0x85,0xa1]

s_max_num_f32 s5, 0.5, s2
// GFX12: s_max_num_f32 s5, 0.5, s2               ; encoding: [0xf0,0x02,0x85,0xa1]

s_max_num_f32 s5, -4.0, s2
// GFX12: s_max_num_f32 s5, -4.0, s2              ; encoding: [0xf7,0x02,0x85,0xa1]

s_max_num_f32 s5, 0xaf123456, s2
// GFX12: s_max_num_f32 s5, 0xaf123456, s2        ; encoding: [0xff,0x02,0x85,0xa1,0x56,0x34,0x12,0xaf]

s_max_num_f32 s5, 0x3f717273, s2
// GFX12: s_max_num_f32 s5, 0x3f717273, s2        ; encoding: [0xff,0x02,0x85,0xa1,0x73,0x72,0x71,0x3f]

s_max_num_f32 s5, s1, s105
// GFX12: s_max_num_f32 s5, s1, s105              ; encoding: [0x01,0x69,0x85,0xa1]

s_minimum_f32 s5, s1, s2
// GFX12: s_minimum_f32 s5, s1, s2                ; encoding: [0x01,0x02,0x85,0xa7]

s_minimum_f32 s105, s1, s2
// GFX12: s_minimum_f32 s105, s1, s2              ; encoding: [0x01,0x02,0xe9,0xa7]

s_minimum_f32 s5, s105, s2
// GFX12: s_minimum_f32 s5, s105, s2              ; encoding: [0x69,0x02,0x85,0xa7]

s_minimum_f32 s5, s103, s2
// GFX12: s_minimum_f32 s5, s103, s2              ; encoding: [0x67,0x02,0x85,0xa7]

s_minimum_f32 s5, vcc_lo, s2
// GFX12: s_minimum_f32 s5, vcc_lo, s2            ; encoding: [0x6a,0x02,0x85,0xa7]

s_minimum_f32 s5, vcc_hi, s2
// GFX12: s_minimum_f32 s5, vcc_hi, s2            ; encoding: [0x6b,0x02,0x85,0xa7]

s_minimum_f32 s5, ttmp11, s2
// GFX12: s_minimum_f32 s5, ttmp11, s2            ; encoding: [0x77,0x02,0x85,0xa7]

s_minimum_f32 s5, m0, s2
// GFX12: s_minimum_f32 s5, m0, s2                ; encoding: [0x7d,0x02,0x85,0xa7]

s_minimum_f32 s5, exec_lo, s2
// GFX12: s_minimum_f32 s5, exec_lo, s2           ; encoding: [0x7e,0x02,0x85,0xa7]

s_minimum_f32 s5, exec_hi, s2
// GFX12: s_minimum_f32 s5, exec_hi, s2           ; encoding: [0x7f,0x02,0x85,0xa7]

s_minimum_f32 s5, 0, s2
// GFX12: s_minimum_f32 s5, 0, s2                 ; encoding: [0x80,0x02,0x85,0xa7]

s_minimum_f32 s5, -1, s2
// GFX12: s_minimum_f32 s5, -1, s2                ; encoding: [0xc1,0x02,0x85,0xa7]

s_minimum_f32 s5, 0.5, s2
// GFX12: s_minimum_f32 s5, 0.5, s2               ; encoding: [0xf0,0x02,0x85,0xa7]

s_minimum_f32 s5, -4.0, s2
// GFX12: s_minimum_f32 s5, -4.0, s2              ; encoding: [0xf7,0x02,0x85,0xa7]

s_minimum_f32 s5, 0xaf123456, s2
// GFX12: s_minimum_f32 s5, 0xaf123456, s2        ; encoding: [0xff,0x02,0x85,0xa7,0x56,0x34,0x12,0xaf]

s_minimum_f32 s5, 0x3f717273, s2
// GFX12: s_minimum_f32 s5, 0x3f717273, s2        ; encoding: [0xff,0x02,0x85,0xa7,0x73,0x72,0x71,0x3f]

s_minimum_f32 s5, s1, s105
// GFX12: s_minimum_f32 s5, s1, s105              ; encoding: [0x01,0x69,0x85,0xa7]

s_maximum_f32 s5, s1, s2
// GFX12: s_maximum_f32 s5, s1, s2                ; encoding: [0x01,0x02,0x05,0xa8]

s_maximum_f32 s105, s1, s2
// GFX12: s_maximum_f32 s105, s1, s2              ; encoding: [0x01,0x02,0x69,0xa8]

s_maximum_f32 s5, s105, s2
// GFX12: s_maximum_f32 s5, s105, s2              ; encoding: [0x69,0x02,0x05,0xa8]

s_maximum_f32 s5, s103, s2
// GFX12: s_maximum_f32 s5, s103, s2              ; encoding: [0x67,0x02,0x05,0xa8]

s_maximum_f32 s5, vcc_lo, s2
// GFX12: s_maximum_f32 s5, vcc_lo, s2            ; encoding: [0x6a,0x02,0x05,0xa8]

s_maximum_f32 s5, vcc_hi, s2
// GFX12: s_maximum_f32 s5, vcc_hi, s2            ; encoding: [0x6b,0x02,0x05,0xa8]

s_maximum_f32 s5, ttmp11, s2
// GFX12: s_maximum_f32 s5, ttmp11, s2            ; encoding: [0x77,0x02,0x05,0xa8]

s_maximum_f32 s5, m0, s2
// GFX12: s_maximum_f32 s5, m0, s2                ; encoding: [0x7d,0x02,0x05,0xa8]

s_maximum_f32 s5, exec_lo, s2
// GFX12: s_maximum_f32 s5, exec_lo, s2           ; encoding: [0x7e,0x02,0x05,0xa8]

s_maximum_f32 s5, exec_hi, s2
// GFX12: s_maximum_f32 s5, exec_hi, s2           ; encoding: [0x7f,0x02,0x05,0xa8]

s_maximum_f32 s5, 0, s2
// GFX12: s_maximum_f32 s5, 0, s2                 ; encoding: [0x80,0x02,0x05,0xa8]

s_maximum_f32 s5, -1, s2
// GFX12: s_maximum_f32 s5, -1, s2                ; encoding: [0xc1,0x02,0x05,0xa8]

s_maximum_f32 s5, 0.5, s2
// GFX12: s_maximum_f32 s5, 0.5, s2               ; encoding: [0xf0,0x02,0x05,0xa8]

s_maximum_f32 s5, -4.0, s2
// GFX12: s_maximum_f32 s5, -4.0, s2              ; encoding: [0xf7,0x02,0x05,0xa8]

s_maximum_f32 s5, 0xaf123456, s2
// GFX12: s_maximum_f32 s5, 0xaf123456, s2        ; encoding: [0xff,0x02,0x05,0xa8,0x56,0x34,0x12,0xaf]

s_maximum_f32 s5, 0x3f717273, s2
// GFX12: s_maximum_f32 s5, 0x3f717273, s2        ; encoding: [0xff,0x02,0x05,0xa8,0x73,0x72,0x71,0x3f]

s_maximum_f32 s5, s1, s105
// GFX12: s_maximum_f32 s5, s1, s105              ; encoding: [0x01,0x69,0x05,0xa8]

s_fmac_f32 s5, s1, s2
// GFX12: s_fmac_f32 s5, s1, s2                   ; encoding: [0x01,0x02,0x85,0xa3]

s_fmac_f32 s105, s1, s2
// GFX12: s_fmac_f32 s105, s1, s2                 ; encoding: [0x01,0x02,0xe9,0xa3]

s_fmac_f32 s5, s105, s2
// GFX12: s_fmac_f32 s5, s105, s2                 ; encoding: [0x69,0x02,0x85,0xa3]

s_fmac_f32 s5, s103, s2
// GFX12: s_fmac_f32 s5, s103, s2                 ; encoding: [0x67,0x02,0x85,0xa3]

s_fmac_f32 s5, vcc_lo, s2
// GFX12: s_fmac_f32 s5, vcc_lo, s2               ; encoding: [0x6a,0x02,0x85,0xa3]

s_fmac_f32 s5, vcc_hi, s2
// GFX12: s_fmac_f32 s5, vcc_hi, s2               ; encoding: [0x6b,0x02,0x85,0xa3]

s_fmac_f32 s5, ttmp11, s2
// GFX12: s_fmac_f32 s5, ttmp11, s2               ; encoding: [0x77,0x02,0x85,0xa3]

s_fmac_f32 s5, m0, s2
// GFX12: s_fmac_f32 s5, m0, s2                   ; encoding: [0x7d,0x02,0x85,0xa3]

s_fmac_f32 s5, exec_lo, s2
// GFX12: s_fmac_f32 s5, exec_lo, s2              ; encoding: [0x7e,0x02,0x85,0xa3]

s_fmac_f32 s5, exec_hi, s2
// GFX12: s_fmac_f32 s5, exec_hi, s2              ; encoding: [0x7f,0x02,0x85,0xa3]

s_fmac_f32 s5, 0, s2
// GFX12: s_fmac_f32 s5, 0, s2                    ; encoding: [0x80,0x02,0x85,0xa3]

s_fmac_f32 s5, -1, s2
// GFX12: s_fmac_f32 s5, -1, s2                   ; encoding: [0xc1,0x02,0x85,0xa3]

s_fmac_f32 s5, 0.5, s2
// GFX12: s_fmac_f32 s5, 0.5, s2                  ; encoding: [0xf0,0x02,0x85,0xa3]

s_fmac_f32 s5, -4.0, s2
// GFX12: s_fmac_f32 s5, -4.0, s2                 ; encoding: [0xf7,0x02,0x85,0xa3]

s_fmac_f32 s5, 0xaf123456, s2
// GFX12: s_fmac_f32 s5, 0xaf123456, s2           ; encoding: [0xff,0x02,0x85,0xa3,0x56,0x34,0x12,0xaf]

s_fmac_f32 s5, 0x3f717273, s2
// GFX12: s_fmac_f32 s5, 0x3f717273, s2           ; encoding: [0xff,0x02,0x85,0xa3,0x73,0x72,0x71,0x3f]

s_fmac_f32 s5, s1, s105
// GFX12: s_fmac_f32 s5, s1, s105                 ; encoding: [0x01,0x69,0x85,0xa3]

s_fmamk_f32 s5, s1, 0x11213141, s3
// GFX12: s_fmamk_f32 s5, s1, 0x11213141, s3      ; encoding: [0x01,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s105, s1, 0x11213141, s3
// GFX12: s_fmamk_f32 s105, s1, 0x11213141, s3    ; encoding: [0x01,0x03,0x69,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, s105, 0x11213141, s3
// GFX12: s_fmamk_f32 s5, s105, 0x11213141, s3    ; encoding: [0x69,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, 0, 0x11213141, s3
// GFX12: s_fmamk_f32 s5, 0, 0x11213141, s3       ; encoding: [0x80,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, -1, 0x11213141, s3
// GFX12: s_fmamk_f32 s5, -1, 0x11213141, s3      ; encoding: [0xc1,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, 0.5, 0x11213141, s3
// GFX12: s_fmamk_f32 s5, 0.5, 0x11213141, s3     ; encoding: [0xf0,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, -4.0, 0x11213141, s3
// GFX12: s_fmamk_f32 s5, -4.0, 0x11213141, s3    ; encoding: [0xf7,0x03,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, s1, 0xa1b1c1d1, s3
// GFX12: s_fmamk_f32 s5, s1, 0xa1b1c1d1, s3      ; encoding: [0x01,0x03,0x05,0xa3,0xd1,0xc1,0xb1,0xa1]

s_fmamk_f32 s5, s1, 0x11213141, s105
// GFX12: s_fmamk_f32 s5, s1, 0x11213141, s105    ; encoding: [0x01,0x69,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, 0x11213141, 0x11213141, s105
// GFX12: s_fmamk_f32 s5, 0x11213141, 0x11213141, s105 ; encoding: [0xff,0x69,0x05,0xa3,0x41,0x31,0x21,0x11]
// GFX12 encoding: [0xff,0x69,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmamk_f32 s5, s105, 0x11213141, 0x11213141
// GFX12: s_fmamk_f32 s5, s105, 0x11213141, 0x11213141 ; encoding: [0x69,0xff,0x05,0xa3,0x41,0x31,0x21,0x11]
// GFX12 encoding: [0x69,0xff,0x05,0xa3,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, s1, s2, 0x11213141
// GFX12: s_fmaak_f32 s5, s1, s2, 0x11213141      ; encoding: [0x01,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s105, s1, s2, 0x11213141
// GFX12: s_fmaak_f32 s105, s1, s2, 0x11213141    ; encoding: [0x01,0x02,0xe9,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, s105, s2, 0x11213141
// GFX12: s_fmaak_f32 s5, s105, s2, 0x11213141    ; encoding: [0x69,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, 0, s2, 0x11213141
// GFX12: s_fmaak_f32 s5, 0, s2, 0x11213141       ; encoding: [0x80,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, -1, s2, 0x11213141
// GFX12: s_fmaak_f32 s5, -1, s2, 0x11213141      ; encoding: [0xc1,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, 0.5, s2, 0x11213141
// GFX12: s_fmaak_f32 s5, 0.5, s2, 0x11213141     ; encoding: [0xf0,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, -4.0, s2, 0x11213141
// GFX12: s_fmaak_f32 s5, -4.0, s2, 0x11213141    ; encoding: [0xf7,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, s1, s105, 0x11213141
// GFX12: s_fmaak_f32 s5, s1, s105, 0x11213141    ; encoding: [0x01,0x69,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, s1, s2, 0xa1b1c1d1
// GFX12: s_fmaak_f32 s5, s1, s2, 0xa1b1c1d1      ; encoding: [0x01,0x02,0x85,0xa2,0xd1,0xc1,0xb1,0xa1]

s_fmaak_f32 s5, 0x11213141, s2, 0x11213141
// GFX12: s_fmaak_f32 s5, 0x11213141, s2, 0x11213141 ; encoding: [0xff,0x02,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, s105, 0x11213141, 0x11213141
// GFX12: s_fmaak_f32 s5, s105, 0x11213141, 0x11213141 ; encoding: [0x69,0xff,0x85,0xa2,0x41,0x31,0x21,0x11]

s_fmaak_f32 s5, 0x11213141, 0x11213141, 0x11213141
// GFX12: s_fmaak_f32 s5, 0x11213141, 0x11213141, 0x11213141 ; encoding: [0xff,0xff,0x85,0xa2,0x41,0x31,0x21,0x11]

s_cvt_pk_rtz_f16_f32 s5, s1, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, s1, s2         ; encoding: [0x01,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s105, s1, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s105, s1, s2       ; encoding: [0x01,0x02,0x69,0xa4]

s_cvt_pk_rtz_f16_f32 s5, s105, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, s105, s2       ; encoding: [0x69,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, s103, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, s103, s2       ; encoding: [0x67,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, vcc_lo, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, vcc_lo, s2     ; encoding: [0x6a,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, vcc_hi, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, vcc_hi, s2     ; encoding: [0x6b,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, ttmp11, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, ttmp11, s2     ; encoding: [0x77,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, m0, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, m0, s2         ; encoding: [0x7d,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, exec_lo, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, exec_lo, s2    ; encoding: [0x7e,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, exec_hi, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, exec_hi, s2    ; encoding: [0x7f,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, 0, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, 0, s2          ; encoding: [0x80,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, -1, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, -1, s2         ; encoding: [0xc1,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, 0.5, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, 0.5, s2        ; encoding: [0xf0,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, -4.0, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, -4.0, s2       ; encoding: [0xf7,0x02,0x05,0xa4]

s_cvt_pk_rtz_f16_f32 s5, 0xaf123456, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, 0xaf123456, s2 ; encoding: [0xff,0x02,0x05,0xa4,0x56,0x34,0x12,0xaf]

s_cvt_pk_rtz_f16_f32 s5, 0x3f717273, s2
// GFX12: s_cvt_pk_rtz_f16_f32 s5, 0x3f717273, s2 ; encoding: [0xff,0x02,0x05,0xa4,0x73,0x72,0x71,0x3f]

s_cvt_pk_rtz_f16_f32 s5, s1, s105
// GFX12: s_cvt_pk_rtz_f16_f32 s5, s1, s105       ; encoding: [0x01,0x69,0x05,0xa4]

s_add_f16 s5, s1, s2
// GFX12: s_add_f16 s5, s1, s2                    ; encoding: [0x01,0x02,0x85,0xa4]

s_add_f16 s105, s1, s2
// GFX12: s_add_f16 s105, s1, s2                  ; encoding: [0x01,0x02,0xe9,0xa4]

s_add_f16 s5, s105, s2
// GFX12: s_add_f16 s5, s105, s2                  ; encoding: [0x69,0x02,0x85,0xa4]

s_add_f16 s5, s101, s2
// GFX12: s_add_f16 s5, s101, s2                  ; encoding: [0x65,0x02,0x85,0xa4]

s_add_f16 s5, vcc_lo, s2
// GFX12: s_add_f16 s5, vcc_lo, s2                ; encoding: [0x6a,0x02,0x85,0xa4]

s_add_f16 s5, vcc_hi, s2
// GFX12: s_add_f16 s5, vcc_hi, s2                ; encoding: [0x6b,0x02,0x85,0xa4]

s_add_f16 s5, m0, s2
// GFX12: s_add_f16 s5, m0, s2                    ; encoding: [0x7d,0x02,0x85,0xa4]

s_add_f16 s5, exec_lo, s2
// GFX12: s_add_f16 s5, exec_lo, s2               ; encoding: [0x7e,0x02,0x85,0xa4]

s_add_f16 s5, exec_hi, s2
// GFX12: s_add_f16 s5, exec_hi, s2               ; encoding: [0x7f,0x02,0x85,0xa4]

s_add_f16 s5, 0, s2
// GFX12: s_add_f16 s5, 0, s2                     ; encoding: [0x80,0x02,0x85,0xa4]

s_add_f16 s5, -1, s2
// GFX12: s_add_f16 s5, -1, s2                    ; encoding: [0xc1,0x02,0x85,0xa4]

s_add_f16 s5, 0.5, s2
// GFX12: s_add_f16 s5, 0.5, s2                   ; encoding: [0xf0,0x02,0x85,0xa4]

s_add_f16 s5, -4.0, s2
// GFX12: s_add_f16 s5, -4.0, s2                  ; encoding: [0xf7,0x02,0x85,0xa4]

s_add_f16 s5, 0xfe0b, s2
// GFX12: s_add_f16 s5, 0xfe0b, s2                ; encoding: [0xff,0x02,0x85,0xa4,0x0b,0xfe,0x00,0x00]

s_add_f16 s5, 0x3456, s2
// GFX12: s_add_f16 s5, 0x3456, s2                ; encoding: [0xff,0x02,0x85,0xa4,0x56,0x34,0x00,0x00]

s_add_f16 s5, s1, s105
// GFX12: s_add_f16 s5, s1, s105                  ; encoding: [0x01,0x69,0x85,0xa4]

s_sub_f16 s5, s1, s2
// GFX12: s_sub_f16 s5, s1, s2                    ; encoding: [0x01,0x02,0x05,0xa5]

s_sub_f16 s105, s1, s2
// GFX12: s_sub_f16 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0xa5]

s_sub_f16 s5, s105, s2
// GFX12: s_sub_f16 s5, s105, s2                  ; encoding: [0x69,0x02,0x05,0xa5]

s_sub_f16 s5, s101, s2
// GFX12: s_sub_f16 s5, s101, s2                  ; encoding: [0x65,0x02,0x05,0xa5]

s_sub_f16 s5, vcc_lo, s2
// GFX12: s_sub_f16 s5, vcc_lo, s2                ; encoding: [0x6a,0x02,0x05,0xa5]

s_sub_f16 s5, vcc_hi, s2
// GFX12: s_sub_f16 s5, vcc_hi, s2                ; encoding: [0x6b,0x02,0x05,0xa5]

s_sub_f16 s5, m0, s2
// GFX12: s_sub_f16 s5, m0, s2                    ; encoding: [0x7d,0x02,0x05,0xa5]

s_sub_f16 s5, exec_lo, s2
// GFX12: s_sub_f16 s5, exec_lo, s2               ; encoding: [0x7e,0x02,0x05,0xa5]

s_sub_f16 s5, exec_hi, s2
// GFX12: s_sub_f16 s5, exec_hi, s2               ; encoding: [0x7f,0x02,0x05,0xa5]

s_sub_f16 s5, 0, s2
// GFX12: s_sub_f16 s5, 0, s2                     ; encoding: [0x80,0x02,0x05,0xa5]

s_sub_f16 s5, -1, s2
// GFX12: s_sub_f16 s5, -1, s2                    ; encoding: [0xc1,0x02,0x05,0xa5]

s_sub_f16 s5, 0.5, s2
// GFX12: s_sub_f16 s5, 0.5, s2                   ; encoding: [0xf0,0x02,0x05,0xa5]

s_sub_f16 s5, -4.0, s2
// GFX12: s_sub_f16 s5, -4.0, s2                  ; encoding: [0xf7,0x02,0x05,0xa5]

s_sub_f16 s5, 0xfe0b, s2
// GFX12: s_sub_f16 s5, 0xfe0b, s2                ; encoding: [0xff,0x02,0x05,0xa5,0x0b,0xfe,0x00,0x00]

s_sub_f16 s5, 0x3456, s2
// GFX12: s_sub_f16 s5, 0x3456, s2                ; encoding: [0xff,0x02,0x05,0xa5,0x56,0x34,0x00,0x00]

s_sub_f16 s5, s1, s105
// GFX12: s_sub_f16 s5, s1, s105                  ; encoding: [0x01,0x69,0x05,0xa5]

s_mul_f16 s5, s1, s2
// GFX12: s_mul_f16 s5, s1, s2                    ; encoding: [0x01,0x02,0x85,0xa6]

s_mul_f16 s105, s1, s2
// GFX12: s_mul_f16 s105, s1, s2                  ; encoding: [0x01,0x02,0xe9,0xa6]

s_mul_f16 s5, s105, s2
// GFX12: s_mul_f16 s5, s105, s2                  ; encoding: [0x69,0x02,0x85,0xa6]

s_mul_f16 s5, s101, s2
// GFX12: s_mul_f16 s5, s101, s2                  ; encoding: [0x65,0x02,0x85,0xa6]

s_mul_f16 s5, vcc_lo, s2
// GFX12: s_mul_f16 s5, vcc_lo, s2                ; encoding: [0x6a,0x02,0x85,0xa6]

s_mul_f16 s5, vcc_hi, s2
// GFX12: s_mul_f16 s5, vcc_hi, s2                ; encoding: [0x6b,0x02,0x85,0xa6]

s_mul_f16 s5, m0, s2
// GFX12: s_mul_f16 s5, m0, s2                    ; encoding: [0x7d,0x02,0x85,0xa6]

s_mul_f16 s5, exec_lo, s2
// GFX12: s_mul_f16 s5, exec_lo, s2               ; encoding: [0x7e,0x02,0x85,0xa6]

s_mul_f16 s5, exec_hi, s2
// GFX12: s_mul_f16 s5, exec_hi, s2               ; encoding: [0x7f,0x02,0x85,0xa6]

s_mul_f16 s5, 0, s2
// GFX12: s_mul_f16 s5, 0, s2                     ; encoding: [0x80,0x02,0x85,0xa6]

s_mul_f16 s5, -1, s2
// GFX12: s_mul_f16 s5, -1, s2                    ; encoding: [0xc1,0x02,0x85,0xa6]

s_mul_f16 s5, 0.5, s2
// GFX12: s_mul_f16 s5, 0.5, s2                   ; encoding: [0xf0,0x02,0x85,0xa6]

s_mul_f16 s5, -4.0, s2
// GFX12: s_mul_f16 s5, -4.0, s2                  ; encoding: [0xf7,0x02,0x85,0xa6]

s_mul_f16 s5, 0xfe0b, s2
// GFX12: s_mul_f16 s5, 0xfe0b, s2                ; encoding: [0xff,0x02,0x85,0xa6,0x0b,0xfe,0x00,0x00]

s_mul_f16 s5, 0x3456, s2
// GFX12: s_mul_f16 s5, 0x3456, s2                ; encoding: [0xff,0x02,0x85,0xa6,0x56,0x34,0x00,0x00]

s_mul_f16 s5, s1, s105
// GFX12: s_mul_f16 s5, s1, s105                  ; encoding: [0x01,0x69,0x85,0xa6]

s_fmac_f16 s5, s1, s2
// GFX12: s_fmac_f16 s5, s1, s2                   ; encoding: [0x01,0x02,0x05,0xa7]

s_fmac_f16 s105, s1, s2
// GFX12: s_fmac_f16 s105, s1, s2                 ; encoding: [0x01,0x02,0x69,0xa7]

s_fmac_f16 s5, s105, s2
// GFX12: s_fmac_f16 s5, s105, s2                 ; encoding: [0x69,0x02,0x05,0xa7]

s_fmac_f16 s5, s103, s2
// GFX12: s_fmac_f16 s5, s103, s2                 ; encoding: [0x67,0x02,0x05,0xa7]

s_fmac_f16 s5, vcc_lo, s2
// GFX12: s_fmac_f16 s5, vcc_lo, s2               ; encoding: [0x6a,0x02,0x05,0xa7]

s_fmac_f16 s5, vcc_hi, s2
// GFX12: s_fmac_f16 s5, vcc_hi, s2               ; encoding: [0x6b,0x02,0x05,0xa7]

s_fmac_f16 s5, ttmp11, s2
// GFX12: s_fmac_f16 s5, ttmp11, s2               ; encoding: [0x77,0x02,0x05,0xa7]

s_fmac_f16 s5, m0, s2
// GFX12: s_fmac_f16 s5, m0, s2                   ; encoding: [0x7d,0x02,0x05,0xa7]

s_fmac_f16 s5, exec_lo, s2
// GFX12: s_fmac_f16 s5, exec_lo, s2              ; encoding: [0x7e,0x02,0x05,0xa7]

s_fmac_f16 s5, exec_hi, s2
// GFX12: s_fmac_f16 s5, exec_hi, s2              ; encoding: [0x7f,0x02,0x05,0xa7]

s_fmac_f16 s5, 0, s2
// GFX12: s_fmac_f16 s5, 0, s2                    ; encoding: [0x80,0x02,0x05,0xa7]

s_fmac_f16 s5, -1, s2
// GFX12: s_fmac_f16 s5, -1, s2                   ; encoding: [0xc1,0x02,0x05,0xa7]

s_fmac_f16 s5, 0.5, s2
// GFX12: s_fmac_f16 s5, 0.5, s2                  ; encoding: [0xf0,0x02,0x05,0xa7]

s_fmac_f16 s5, -4.0, s2
// GFX12: s_fmac_f16 s5, -4.0, s2                 ; encoding: [0xf7,0x02,0x05,0xa7]

s_fmac_f16 s5, 0x1234, s2
// GFX12: s_fmac_f16 s5, 0x1234, s2               ; encoding: [0xff,0x02,0x05,0xa7,0x34,0x12,0x00,0x00]

s_fmac_f16 s5, s1, s105
// GFX12: s_fmac_f16 s5, s1, s105                 ; encoding: [0x01,0x69,0x05,0xa7]

s_max_num_f16 s5, s1, s2
// GFX12: s_max_num_f16 s5, s1, s2                ; encoding: [0x01,0x02,0x05,0xa6]

s_max_num_f16 s105, s1, s2
// GFX12: s_max_num_f16 s105, s1, s2              ; encoding: [0x01,0x02,0x69,0xa6]

s_max_num_f16 s5, s105, s2
// GFX12: s_max_num_f16 s5, s105, s2              ; encoding: [0x69,0x02,0x05,0xa6]

s_max_num_f16 s5, s101, s2
// GFX12: s_max_num_f16 s5, s101, s2              ; encoding: [0x65,0x02,0x05,0xa6]

s_max_num_f16 s5, vcc_lo, s2
// GFX12: s_max_num_f16 s5, vcc_lo, s2            ; encoding: [0x6a,0x02,0x05,0xa6]

s_max_num_f16 s5, vcc_hi, s2
// GFX12: s_max_num_f16 s5, vcc_hi, s2            ; encoding: [0x6b,0x02,0x05,0xa6]

s_max_num_f16 s5, m0, s2
// GFX12: s_max_num_f16 s5, m0, s2                ; encoding: [0x7d,0x02,0x05,0xa6]

s_max_num_f16 s5, exec_lo, s2
// GFX12: s_max_num_f16 s5, exec_lo, s2           ; encoding: [0x7e,0x02,0x05,0xa6]

s_max_num_f16 s5, exec_hi, s2
// GFX12: s_max_num_f16 s5, exec_hi, s2           ; encoding: [0x7f,0x02,0x05,0xa6]

s_max_num_f16 s5, 0, s2
// GFX12: s_max_num_f16 s5, 0, s2                 ; encoding: [0x80,0x02,0x05,0xa6]

s_max_num_f16 s5, -1, s2
// GFX12: s_max_num_f16 s5, -1, s2                ; encoding: [0xc1,0x02,0x05,0xa6]

s_max_num_f16 s5, 0.5, s2
// GFX12: s_max_num_f16 s5, 0.5, s2               ; encoding: [0xf0,0x02,0x05,0xa6]

s_max_num_f16 s5, -4.0, s2
// GFX12: s_max_num_f16 s5, -4.0, s2              ; encoding: [0xf7,0x02,0x05,0xa6]

s_max_num_f16 s5, 0xfe0b, s2
// GFX12: s_max_num_f16 s5, 0xfe0b, s2            ; encoding: [0xff,0x02,0x05,0xa6,0x0b,0xfe,0x00,0x00]

s_max_num_f16 s5, 0x3456, s2
// GFX12: s_max_num_f16 s5, 0x3456, s2            ; encoding: [0xff,0x02,0x05,0xa6,0x56,0x34,0x00,0x00]

s_max_num_f16 s5, s1, s105
// GFX12: s_max_num_f16 s5, s1, s105              ; encoding: [0x01,0x69,0x05,0xa6]

s_min_num_f16 s5, s1, s2
// GFX12: s_min_num_f16 s5, s1, s2                ; encoding: [0x01,0x02,0x85,0xa5]

s_min_num_f16 s105, s1, s2
// GFX12: s_min_num_f16 s105, s1, s2              ; encoding: [0x01,0x02,0xe9,0xa5]

s_min_num_f16 s5, s105, s2
// GFX12: s_min_num_f16 s5, s105, s2              ; encoding: [0x69,0x02,0x85,0xa5]

s_min_num_f16 s5, s101, s2
// GFX12: s_min_num_f16 s5, s101, s2              ; encoding: [0x65,0x02,0x85,0xa5]

s_min_num_f16 s5, vcc_lo, s2
// GFX12: s_min_num_f16 s5, vcc_lo, s2            ; encoding: [0x6a,0x02,0x85,0xa5]

s_min_num_f16 s5, vcc_hi, s2
// GFX12: s_min_num_f16 s5, vcc_hi, s2            ; encoding: [0x6b,0x02,0x85,0xa5]

s_min_num_f16 s5, m0, s2
// GFX12: s_min_num_f16 s5, m0, s2                ; encoding: [0x7d,0x02,0x85,0xa5]

s_min_num_f16 s5, exec_lo, s2
// GFX12: s_min_num_f16 s5, exec_lo, s2           ; encoding: [0x7e,0x02,0x85,0xa5]

s_min_num_f16 s5, exec_hi, s2
// GFX12: s_min_num_f16 s5, exec_hi, s2           ; encoding: [0x7f,0x02,0x85,0xa5]

s_min_num_f16 s5, 0, s2
// GFX12: s_min_num_f16 s5, 0, s2                 ; encoding: [0x80,0x02,0x85,0xa5]

s_min_num_f16 s5, -1, s2
// GFX12: s_min_num_f16 s5, -1, s2                ; encoding: [0xc1,0x02,0x85,0xa5]

s_min_num_f16 s5, 0.5, s2
// GFX12: s_min_num_f16 s5, 0.5, s2               ; encoding: [0xf0,0x02,0x85,0xa5]

s_min_num_f16 s5, -4.0, s2
// GFX12: s_min_num_f16 s5, -4.0, s2              ; encoding: [0xf7,0x02,0x85,0xa5]

s_min_num_f16 s5, 0xfe0b, s2
// GFX12: s_min_num_f16 s5, 0xfe0b, s2            ; encoding: [0xff,0x02,0x85,0xa5,0x0b,0xfe,0x00,0x00]

s_min_num_f16 s5, 0x3456, s2
// GFX12: s_min_num_f16 s5, 0x3456, s2            ; encoding: [0xff,0x02,0x85,0xa5,0x56,0x34,0x00,0x00]

s_min_num_f16 s5, s1, s105
// GFX12: s_min_num_f16 s5, s1, s105              ; encoding: [0x01,0x69,0x85,0xa5]

s_maximum_f16 s5, s1, s2
// GFX12: s_maximum_f16 s5, s1, s2                ; encoding: [0x01,0x02,0x05,0xa9]

s_maximum_f16 s105, s1, s2
// GFX12: s_maximum_f16 s105, s1, s2              ; encoding: [0x01,0x02,0x69,0xa9]

s_maximum_f16 s5, s105, s2
// GFX12: s_maximum_f16 s5, s105, s2              ; encoding: [0x69,0x02,0x05,0xa9]

s_maximum_f16 s5, s101, s2
// GFX12: s_maximum_f16 s5, s101, s2              ; encoding: [0x65,0x02,0x05,0xa9]

s_maximum_f16 s5, vcc_lo, s2
// GFX12: s_maximum_f16 s5, vcc_lo, s2            ; encoding: [0x6a,0x02,0x05,0xa9]

s_maximum_f16 s5, vcc_hi, s2
// GFX12: s_maximum_f16 s5, vcc_hi, s2            ; encoding: [0x6b,0x02,0x05,0xa9]

s_maximum_f16 s5, m0, s2
// GFX12: s_maximum_f16 s5, m0, s2                ; encoding: [0x7d,0x02,0x05,0xa9]

s_maximum_f16 s5, exec_lo, s2
// GFX12: s_maximum_f16 s5, exec_lo, s2           ; encoding: [0x7e,0x02,0x05,0xa9]

s_maximum_f16 s5, exec_hi, s2
// GFX12: s_maximum_f16 s5, exec_hi, s2           ; encoding: [0x7f,0x02,0x05,0xa9]

s_maximum_f16 s5, 0, s2
// GFX12: s_maximum_f16 s5, 0, s2                 ; encoding: [0x80,0x02,0x05,0xa9]

s_maximum_f16 s5, -1, s2
// GFX12: s_maximum_f16 s5, -1, s2                ; encoding: [0xc1,0x02,0x05,0xa9]

s_maximum_f16 s5, 0.5, s2
// GFX12: s_maximum_f16 s5, 0.5, s2               ; encoding: [0xf0,0x02,0x05,0xa9]

s_maximum_f16 s5, -4.0, s2
// GFX12: s_maximum_f16 s5, -4.0, s2              ; encoding: [0xf7,0x02,0x05,0xa9]

s_maximum_f16 s5, 0xfe0b, s2
// GFX12: s_maximum_f16 s5, 0xfe0b, s2            ; encoding: [0xff,0x02,0x05,0xa9,0x0b,0xfe,0x00,0x00]

s_maximum_f16 s5, 0x3456, s2
// GFX12: s_maximum_f16 s5, 0x3456, s2            ; encoding: [0xff,0x02,0x05,0xa9,0x56,0x34,0x00,0x00]

s_maximum_f16 s5, s1, s105
// GFX12: s_maximum_f16 s5, s1, s105              ; encoding: [0x01,0x69,0x05,0xa9]

s_minimum_f16 s5, s1, s2
// GFX12: s_minimum_f16 s5, s1, s2                ; encoding: [0x01,0x02,0x85,0xa8]

s_minimum_f16 s105, s1, s2
// GFX12: s_minimum_f16 s105, s1, s2              ; encoding: [0x01,0x02,0xe9,0xa8]

s_minimum_f16 s5, s105, s2
// GFX12: s_minimum_f16 s5, s105, s2              ; encoding: [0x69,0x02,0x85,0xa8]

s_minimum_f16 s5, s101, s2
// GFX12: s_minimum_f16 s5, s101, s2              ; encoding: [0x65,0x02,0x85,0xa8]

s_minimum_f16 s5, vcc_lo, s2
// GFX12: s_minimum_f16 s5, vcc_lo, s2            ; encoding: [0x6a,0x02,0x85,0xa8]

s_minimum_f16 s5, vcc_hi, s2
// GFX12: s_minimum_f16 s5, vcc_hi, s2            ; encoding: [0x6b,0x02,0x85,0xa8]

s_minimum_f16 s5, m0, s2
// GFX12: s_minimum_f16 s5, m0, s2                ; encoding: [0x7d,0x02,0x85,0xa8]

s_minimum_f16 s5, exec_lo, s2
// GFX12: s_minimum_f16 s5, exec_lo, s2           ; encoding: [0x7e,0x02,0x85,0xa8]

s_minimum_f16 s5, exec_hi, s2
// GFX12: s_minimum_f16 s5, exec_hi, s2           ; encoding: [0x7f,0x02,0x85,0xa8]

s_minimum_f16 s5, 0, s2
// GFX12: s_minimum_f16 s5, 0, s2                 ; encoding: [0x80,0x02,0x85,0xa8]

s_minimum_f16 s5, -1, s2
// GFX12: s_minimum_f16 s5, -1, s2                ; encoding: [0xc1,0x02,0x85,0xa8]

s_minimum_f16 s5, 0.5, s2
// GFX12: s_minimum_f16 s5, 0.5, s2               ; encoding: [0xf0,0x02,0x85,0xa8]

s_minimum_f16 s5, -4.0, s2
// GFX12: s_minimum_f16 s5, -4.0, s2              ; encoding: [0xf7,0x02,0x85,0xa8]

s_minimum_f16 s5, 0xfe0b, s2
// GFX12: s_minimum_f16 s5, 0xfe0b, s2            ; encoding: [0xff,0x02,0x85,0xa8,0x0b,0xfe,0x00,0x00]

s_minimum_f16 s5, 0x3456, s2
// GFX12: s_minimum_f16 s5, 0x3456, s2            ; encoding: [0xff,0x02,0x85,0xa8,0x56,0x34,0x00,0x00]

s_minimum_f16 s5, s1, s105
// GFX12: s_minimum_f16 s5, s1, s105              ; encoding: [0x01,0x69,0x85,0xa8]

s_add_co_u32 s0, s1, s2
// GFX12: s_add_co_u32 s0, s1, s2                 ; encoding: [0x01,0x02,0x00,0x80]

s_add_co_u32 s105, s104, s103
// GFX12: s_add_co_u32 s105, s104, s103           ; encoding: [0x68,0x67,0x69,0x80]

s_add_co_u32 s0, s104, s103
// GFX12: s_add_co_u32 s0, s104, s103             ; encoding: [0x68,0x67,0x00,0x80]

s_add_co_u32 s105, s1, s103
// GFX12: s_add_co_u32 s105, s1, s103             ; encoding: [0x01,0x67,0x69,0x80]

s_add_co_u32 s105, s104, s2
// GFX12: s_add_co_u32 s105, s104, s2             ; encoding: [0x68,0x02,0x69,0x80]

s_add_co_u32 s105, s1, s2
// GFX12: s_add_co_u32 s105, s1, s2               ; encoding: [0x01,0x02,0x69,0x80]

s_add_co_u32 s0, s104, s2
// GFX12: s_add_co_u32 s0, s104, s2               ; encoding: [0x68,0x02,0x00,0x80]

s_add_co_u32 s0, s1, s103
// GFX12: s_add_co_u32 s0, s1, s103               ; encoding: [0x01,0x67,0x00,0x80]

s_add_co_u32 exec_lo, s1, s2
// GFX12: s_add_co_u32 exec_lo, s1, s2            ; encoding: [0x01,0x02,0x7e,0x80]

s_add_co_u32 exec_hi, s1, s2
// GFX12: s_add_co_u32 exec_hi, s1, s2            ; encoding: [0x01,0x02,0x7f,0x80]

s_add_co_u32 vcc_lo, s1, s2
// GFX12: s_add_co_u32 vcc_lo, s1, s2             ; encoding: [0x01,0x02,0x6a,0x80]

s_add_co_u32 vcc_hi, s1, s2
// GFX12: s_add_co_u32 vcc_hi, s1, s2             ; encoding: [0x01,0x02,0x6b,0x80]

s_add_co_u32 m0, s1, s2
// GFX12: s_add_co_u32 m0, s1, s2                 ; encoding: [0x01,0x02,0x7d,0x80]

s_add_co_u32 s0, exec_lo, s2
// GFX12: s_add_co_u32 s0, exec_lo, s2            ; encoding: [0x7e,0x02,0x00,0x80]

s_add_co_u32 s0, exec_hi, s2
// GFX12: s_add_co_u32 s0, exec_hi, s2            ; encoding: [0x7f,0x02,0x00,0x80]

s_add_co_u32 s0, vcc_lo, s2
// GFX12: s_add_co_u32 s0, vcc_lo, s2             ; encoding: [0x6a,0x02,0x00,0x80]

s_add_co_u32 s0, vcc_hi, s2
// GFX12: s_add_co_u32 s0, vcc_hi, s2             ; encoding: [0x6b,0x02,0x00,0x80]

s_add_co_u32 s0, m0, s2
// GFX12: s_add_co_u32 s0, m0, s2                 ; encoding: [0x7d,0x02,0x00,0x80]

s_add_co_u32 s0, 0, s2
// GFX12: s_add_co_u32 s0, 0, s2                  ; encoding: [0x80,0x02,0x00,0x80]

s_add_co_u32 s0, -1, s2
// GFX12: s_add_co_u32 s0, -1, s2                 ; encoding: [0xc1,0x02,0x00,0x80]

s_add_co_u32 s0, 0.5, s2
// GFX12: s_add_co_u32 s0, 0.5, s2                ; encoding: [0xf0,0x02,0x00,0x80]

s_add_co_u32 s0, -4.0, s2
// GFX12: s_add_co_u32 s0, -4.0, s2               ; encoding: [0xf7,0x02,0x00,0x80]

s_add_co_u32 s0, 0x3f717273, s2
// GFX12: s_add_co_u32 s0, 0x3f717273, s2         ; encoding: [0xff,0x02,0x00,0x80,0x73,0x72,0x71,0x3f]

s_add_co_u32 s0, 0xaf123456, s2
// GFX12: s_add_co_u32 s0, 0xaf123456, s2         ; encoding: [0xff,0x02,0x00,0x80,0x56,0x34,0x12,0xaf]

s_add_co_u32 s0, s1, exec_lo
// GFX12: s_add_co_u32 s0, s1, exec_lo            ; encoding: [0x01,0x7e,0x00,0x80]

s_add_co_u32 s0, s1, exec_hi
// GFX12: s_add_co_u32 s0, s1, exec_hi            ; encoding: [0x01,0x7f,0x00,0x80]

s_add_co_u32 s0, s1, vcc_lo
// GFX12: s_add_co_u32 s0, s1, vcc_lo             ; encoding: [0x01,0x6a,0x00,0x80]

s_add_co_u32 s0, s1, vcc_hi
// GFX12: s_add_co_u32 s0, s1, vcc_hi             ; encoding: [0x01,0x6b,0x00,0x80]

s_add_co_u32 s0, s1, m0
// GFX12: s_add_co_u32 s0, s1, m0                 ; encoding: [0x01,0x7d,0x00,0x80]

s_add_co_u32 s0, s1, 0
// GFX12: s_add_co_u32 s0, s1, 0                  ; encoding: [0x01,0x80,0x00,0x80]

s_add_co_u32 s0, s1, -1
// GFX12: s_add_co_u32 s0, s1, -1                 ; encoding: [0x01,0xc1,0x00,0x80]

s_add_co_u32 s0, s1, 0.5
// GFX12: s_add_co_u32 s0, s1, 0.5                ; encoding: [0x01,0xf0,0x00,0x80]

s_add_co_u32 s0, s1, -4.0
// GFX12: s_add_co_u32 s0, s1, -4.0               ; encoding: [0x01,0xf7,0x00,0x80]

s_add_co_u32 s0, s1, 0x3f717273
// GFX12: s_add_co_u32 s0, s1, 0x3f717273         ; encoding: [0x01,0xff,0x00,0x80,0x73,0x72,0x71,0x3f]

s_add_co_u32 s0, s1, 0xaf123456
// GFX12: s_add_co_u32 s0, s1, 0xaf123456         ; encoding: [0x01,0xff,0x00,0x80,0x56,0x34,0x12,0xaf]

s_sub_co_u32 s0, s1, s2
// GFX12: s_sub_co_u32 s0, s1, s2                 ; encoding: [0x01,0x02,0x80,0x80]

s_sub_co_u32 s105, s104, s103
// GFX12: s_sub_co_u32 s105, s104, s103           ; encoding: [0x68,0x67,0xe9,0x80]

s_sub_co_u32 s0, s104, s103
// GFX12: s_sub_co_u32 s0, s104, s103             ; encoding: [0x68,0x67,0x80,0x80]

s_sub_co_u32 s105, s1, s103
// GFX12: s_sub_co_u32 s105, s1, s103             ; encoding: [0x01,0x67,0xe9,0x80]

s_sub_co_u32 s105, s104, s2
// GFX12: s_sub_co_u32 s105, s104, s2             ; encoding: [0x68,0x02,0xe9,0x80]

s_sub_co_u32 s105, s1, s2
// GFX12: s_sub_co_u32 s105, s1, s2               ; encoding: [0x01,0x02,0xe9,0x80]

s_sub_co_u32 s0, s104, s2
// GFX12: s_sub_co_u32 s0, s104, s2               ; encoding: [0x68,0x02,0x80,0x80]

s_sub_co_u32 s0, s1, s103
// GFX12: s_sub_co_u32 s0, s1, s103               ; encoding: [0x01,0x67,0x80,0x80]

s_sub_co_u32 exec_lo, s1, s2
// GFX12: s_sub_co_u32 exec_lo, s1, s2            ; encoding: [0x01,0x02,0xfe,0x80]

s_sub_co_u32 exec_hi, s1, s2
// GFX12: s_sub_co_u32 exec_hi, s1, s2            ; encoding: [0x01,0x02,0xff,0x80]

s_sub_co_u32 vcc_lo, s1, s2
// GFX12: s_sub_co_u32 vcc_lo, s1, s2             ; encoding: [0x01,0x02,0xea,0x80]

s_sub_co_u32 vcc_hi, s1, s2
// GFX12: s_sub_co_u32 vcc_hi, s1, s2             ; encoding: [0x01,0x02,0xeb,0x80]

s_sub_co_u32 m0, s1, s2
// GFX12: s_sub_co_u32 m0, s1, s2                 ; encoding: [0x01,0x02,0xfd,0x80]

s_sub_co_u32 s0, exec_lo, s2
// GFX12: s_sub_co_u32 s0, exec_lo, s2            ; encoding: [0x7e,0x02,0x80,0x80]

s_sub_co_u32 s0, exec_hi, s2
// GFX12: s_sub_co_u32 s0, exec_hi, s2            ; encoding: [0x7f,0x02,0x80,0x80]

s_sub_co_u32 s0, vcc_lo, s2
// GFX12: s_sub_co_u32 s0, vcc_lo, s2             ; encoding: [0x6a,0x02,0x80,0x80]

s_sub_co_u32 s0, vcc_hi, s2
// GFX12: s_sub_co_u32 s0, vcc_hi, s2             ; encoding: [0x6b,0x02,0x80,0x80]

s_sub_co_u32 s0, m0, s2
// GFX12: s_sub_co_u32 s0, m0, s2                 ; encoding: [0x7d,0x02,0x80,0x80]

s_sub_co_u32 s0, 0, s2
// GFX12: s_sub_co_u32 s0, 0, s2                  ; encoding: [0x80,0x02,0x80,0x80]

s_sub_co_u32 s0, -1, s2
// GFX12: s_sub_co_u32 s0, -1, s2                 ; encoding: [0xc1,0x02,0x80,0x80]

s_sub_co_u32 s0, 0.5, s2
// GFX12: s_sub_co_u32 s0, 0.5, s2                ; encoding: [0xf0,0x02,0x80,0x80]

s_sub_co_u32 s0, -4.0, s2
// GFX12: s_sub_co_u32 s0, -4.0, s2               ; encoding: [0xf7,0x02,0x80,0x80]

s_sub_co_u32 s0, 0x3f717273, s2
// GFX12: s_sub_co_u32 s0, 0x3f717273, s2         ; encoding: [0xff,0x02,0x80,0x80,0x73,0x72,0x71,0x3f]

s_sub_co_u32 s0, 0xaf123456, s2
// GFX12: s_sub_co_u32 s0, 0xaf123456, s2         ; encoding: [0xff,0x02,0x80,0x80,0x56,0x34,0x12,0xaf]

s_sub_co_u32 s0, s1, exec_lo
// GFX12: s_sub_co_u32 s0, s1, exec_lo            ; encoding: [0x01,0x7e,0x80,0x80]

s_sub_co_u32 s0, s1, exec_hi
// GFX12: s_sub_co_u32 s0, s1, exec_hi            ; encoding: [0x01,0x7f,0x80,0x80]

s_sub_co_u32 s0, s1, vcc_lo
// GFX12: s_sub_co_u32 s0, s1, vcc_lo             ; encoding: [0x01,0x6a,0x80,0x80]

s_sub_co_u32 s0, s1, vcc_hi
// GFX12: s_sub_co_u32 s0, s1, vcc_hi             ; encoding: [0x01,0x6b,0x80,0x80]

s_sub_co_u32 s0, s1, m0
// GFX12: s_sub_co_u32 s0, s1, m0                 ; encoding: [0x01,0x7d,0x80,0x80]

s_sub_co_u32 s0, s1, 0
// GFX12: s_sub_co_u32 s0, s1, 0                  ; encoding: [0x01,0x80,0x80,0x80]

s_sub_co_u32 s0, s1, -1
// GFX12: s_sub_co_u32 s0, s1, -1                 ; encoding: [0x01,0xc1,0x80,0x80]

s_sub_co_u32 s0, s1, 0.5
// GFX12: s_sub_co_u32 s0, s1, 0.5                ; encoding: [0x01,0xf0,0x80,0x80]

s_sub_co_u32 s0, s1, -4.0
// GFX12: s_sub_co_u32 s0, s1, -4.0               ; encoding: [0x01,0xf7,0x80,0x80]

s_sub_co_u32 s0, s1, 0x3f717273
// GFX12: s_sub_co_u32 s0, s1, 0x3f717273         ; encoding: [0x01,0xff,0x80,0x80,0x73,0x72,0x71,0x3f]

s_sub_co_u32 s0, s1, 0xaf123456
// GFX12: s_sub_co_u32 s0, s1, 0xaf123456         ; encoding: [0x01,0xff,0x80,0x80,0x56,0x34,0x12,0xaf]

s_add_co_i32 s0, s1, s2
// GFX12: s_add_co_i32 s0, s1, s2                 ; encoding: [0x01,0x02,0x00,0x81]

s_add_co_i32 s105, s104, s103
// GFX12: s_add_co_i32 s105, s104, s103           ; encoding: [0x68,0x67,0x69,0x81]

s_add_co_i32 s0, s104, s103
// GFX12: s_add_co_i32 s0, s104, s103             ; encoding: [0x68,0x67,0x00,0x81]

s_add_co_i32 s105, s1, s103
// GFX12: s_add_co_i32 s105, s1, s103             ; encoding: [0x01,0x67,0x69,0x81]

s_add_co_i32 s105, s104, s2
// GFX12: s_add_co_i32 s105, s104, s2             ; encoding: [0x68,0x02,0x69,0x81]

s_add_co_i32 s105, s1, s2
// GFX12: s_add_co_i32 s105, s1, s2               ; encoding: [0x01,0x02,0x69,0x81]

s_add_co_i32 s0, s104, s2
// GFX12: s_add_co_i32 s0, s104, s2               ; encoding: [0x68,0x02,0x00,0x81]

s_add_co_i32 s0, s1, s103
// GFX12: s_add_co_i32 s0, s1, s103               ; encoding: [0x01,0x67,0x00,0x81]

s_add_co_i32 exec_lo, s1, s2
// GFX12: s_add_co_i32 exec_lo, s1, s2            ; encoding: [0x01,0x02,0x7e,0x81]

s_add_co_i32 exec_hi, s1, s2
// GFX12: s_add_co_i32 exec_hi, s1, s2            ; encoding: [0x01,0x02,0x7f,0x81]

s_add_co_i32 vcc_lo, s1, s2
// GFX12: s_add_co_i32 vcc_lo, s1, s2             ; encoding: [0x01,0x02,0x6a,0x81]

s_add_co_i32 vcc_hi, s1, s2
// GFX12: s_add_co_i32 vcc_hi, s1, s2             ; encoding: [0x01,0x02,0x6b,0x81]

s_add_co_i32 m0, s1, s2
// GFX12: s_add_co_i32 m0, s1, s2                 ; encoding: [0x01,0x02,0x7d,0x81]

s_add_co_i32 s0, exec_lo, s2
// GFX12: s_add_co_i32 s0, exec_lo, s2            ; encoding: [0x7e,0x02,0x00,0x81]

s_add_co_i32 s0, exec_hi, s2
// GFX12: s_add_co_i32 s0, exec_hi, s2            ; encoding: [0x7f,0x02,0x00,0x81]

s_add_co_i32 s0, vcc_lo, s2
// GFX12: s_add_co_i32 s0, vcc_lo, s2             ; encoding: [0x6a,0x02,0x00,0x81]

s_add_co_i32 s0, vcc_hi, s2
// GFX12: s_add_co_i32 s0, vcc_hi, s2             ; encoding: [0x6b,0x02,0x00,0x81]

s_add_co_i32 s0, m0, s2
// GFX12: s_add_co_i32 s0, m0, s2                 ; encoding: [0x7d,0x02,0x00,0x81]

s_add_co_i32 s0, 0, s2
// GFX12: s_add_co_i32 s0, 0, s2                  ; encoding: [0x80,0x02,0x00,0x81]

s_add_co_i32 s0, -1, s2
// GFX12: s_add_co_i32 s0, -1, s2                 ; encoding: [0xc1,0x02,0x00,0x81]

s_add_co_i32 s0, 0.5, s2
// GFX12: s_add_co_i32 s0, 0.5, s2                ; encoding: [0xf0,0x02,0x00,0x81]

s_add_co_i32 s0, -4.0, s2
// GFX12: s_add_co_i32 s0, -4.0, s2               ; encoding: [0xf7,0x02,0x00,0x81]

s_add_co_i32 s0, 0x3f717273, s2
// GFX12: s_add_co_i32 s0, 0x3f717273, s2         ; encoding: [0xff,0x02,0x00,0x81,0x73,0x72,0x71,0x3f]

s_add_co_i32 s0, 0xaf123456, s2
// GFX12: s_add_co_i32 s0, 0xaf123456, s2         ; encoding: [0xff,0x02,0x00,0x81,0x56,0x34,0x12,0xaf]

s_add_co_i32 s0, s1, exec_lo
// GFX12: s_add_co_i32 s0, s1, exec_lo            ; encoding: [0x01,0x7e,0x00,0x81]

s_add_co_i32 s0, s1, exec_hi
// GFX12: s_add_co_i32 s0, s1, exec_hi            ; encoding: [0x01,0x7f,0x00,0x81]

s_add_co_i32 s0, s1, vcc_lo
// GFX12: s_add_co_i32 s0, s1, vcc_lo             ; encoding: [0x01,0x6a,0x00,0x81]

s_add_co_i32 s0, s1, vcc_hi
// GFX12: s_add_co_i32 s0, s1, vcc_hi             ; encoding: [0x01,0x6b,0x00,0x81]

s_add_co_i32 s0, s1, m0
// GFX12: s_add_co_i32 s0, s1, m0                 ; encoding: [0x01,0x7d,0x00,0x81]

s_add_co_i32 s0, s1, 0
// GFX12: s_add_co_i32 s0, s1, 0                  ; encoding: [0x01,0x80,0x00,0x81]

s_add_co_i32 s0, s1, -1
// GFX12: s_add_co_i32 s0, s1, -1                 ; encoding: [0x01,0xc1,0x00,0x81]

s_add_co_i32 s0, s1, 0.5
// GFX12: s_add_co_i32 s0, s1, 0.5                ; encoding: [0x01,0xf0,0x00,0x81]

s_add_co_i32 s0, s1, -4.0
// GFX12: s_add_co_i32 s0, s1, -4.0               ; encoding: [0x01,0xf7,0x00,0x81]

s_add_co_i32 s0, s1, 0x3f717273
// GFX12: s_add_co_i32 s0, s1, 0x3f717273         ; encoding: [0x01,0xff,0x00,0x81,0x73,0x72,0x71,0x3f]

s_add_co_i32 s0, s1, 0xaf123456
// GFX12: s_add_co_i32 s0, s1, 0xaf123456         ; encoding: [0x01,0xff,0x00,0x81,0x56,0x34,0x12,0xaf]

s_sub_co_i32 s0, s1, s2
// GFX12: s_sub_co_i32 s0, s1, s2                 ; encoding: [0x01,0x02,0x80,0x81]

s_sub_co_i32 s105, s104, s103
// GFX12: s_sub_co_i32 s105, s104, s103           ; encoding: [0x68,0x67,0xe9,0x81]

s_sub_co_i32 s0, s104, s103
// GFX12: s_sub_co_i32 s0, s104, s103             ; encoding: [0x68,0x67,0x80,0x81]

s_sub_co_i32 s105, s1, s103
// GFX12: s_sub_co_i32 s105, s1, s103             ; encoding: [0x01,0x67,0xe9,0x81]

s_sub_co_i32 s105, s104, s2
// GFX12: s_sub_co_i32 s105, s104, s2             ; encoding: [0x68,0x02,0xe9,0x81]

s_sub_co_i32 s105, s1, s2
// GFX12: s_sub_co_i32 s105, s1, s2               ; encoding: [0x01,0x02,0xe9,0x81]

s_sub_co_i32 s0, s104, s2
// GFX12: s_sub_co_i32 s0, s104, s2               ; encoding: [0x68,0x02,0x80,0x81]

s_sub_co_i32 s0, s1, s103
// GFX12: s_sub_co_i32 s0, s1, s103               ; encoding: [0x01,0x67,0x80,0x81]

s_sub_co_i32 exec_lo, s1, s2
// GFX12: s_sub_co_i32 exec_lo, s1, s2            ; encoding: [0x01,0x02,0xfe,0x81]

s_sub_co_i32 exec_hi, s1, s2
// GFX12: s_sub_co_i32 exec_hi, s1, s2            ; encoding: [0x01,0x02,0xff,0x81]

s_sub_co_i32 vcc_lo, s1, s2
// GFX12: s_sub_co_i32 vcc_lo, s1, s2             ; encoding: [0x01,0x02,0xea,0x81]

s_sub_co_i32 vcc_hi, s1, s2
// GFX12: s_sub_co_i32 vcc_hi, s1, s2             ; encoding: [0x01,0x02,0xeb,0x81]

s_sub_co_i32 m0, s1, s2
// GFX12: s_sub_co_i32 m0, s1, s2                 ; encoding: [0x01,0x02,0xfd,0x81]

s_sub_co_i32 s0, exec_lo, s2
// GFX12: s_sub_co_i32 s0, exec_lo, s2            ; encoding: [0x7e,0x02,0x80,0x81]

s_sub_co_i32 s0, exec_hi, s2
// GFX12: s_sub_co_i32 s0, exec_hi, s2            ; encoding: [0x7f,0x02,0x80,0x81]

s_sub_co_i32 s0, vcc_lo, s2
// GFX12: s_sub_co_i32 s0, vcc_lo, s2             ; encoding: [0x6a,0x02,0x80,0x81]

s_sub_co_i32 s0, vcc_hi, s2
// GFX12: s_sub_co_i32 s0, vcc_hi, s2             ; encoding: [0x6b,0x02,0x80,0x81]

s_sub_co_i32 s0, m0, s2
// GFX12: s_sub_co_i32 s0, m0, s2                 ; encoding: [0x7d,0x02,0x80,0x81]

s_sub_co_i32 s0, 0, s2
// GFX12: s_sub_co_i32 s0, 0, s2                  ; encoding: [0x80,0x02,0x80,0x81]

s_sub_co_i32 s0, -1, s2
// GFX12: s_sub_co_i32 s0, -1, s2                 ; encoding: [0xc1,0x02,0x80,0x81]

s_sub_co_i32 s0, 0.5, s2
// GFX12: s_sub_co_i32 s0, 0.5, s2                ; encoding: [0xf0,0x02,0x80,0x81]

s_sub_co_i32 s0, -4.0, s2
// GFX12: s_sub_co_i32 s0, -4.0, s2               ; encoding: [0xf7,0x02,0x80,0x81]

s_sub_co_i32 s0, 0x3f717273, s2
// GFX12: s_sub_co_i32 s0, 0x3f717273, s2         ; encoding: [0xff,0x02,0x80,0x81,0x73,0x72,0x71,0x3f]

s_sub_co_i32 s0, 0xaf123456, s2
// GFX12: s_sub_co_i32 s0, 0xaf123456, s2         ; encoding: [0xff,0x02,0x80,0x81,0x56,0x34,0x12,0xaf]

s_sub_co_i32 s0, s1, exec_lo
// GFX12: s_sub_co_i32 s0, s1, exec_lo            ; encoding: [0x01,0x7e,0x80,0x81]

s_sub_co_i32 s0, s1, exec_hi
// GFX12: s_sub_co_i32 s0, s1, exec_hi            ; encoding: [0x01,0x7f,0x80,0x81]

s_sub_co_i32 s0, s1, vcc_lo
// GFX12: s_sub_co_i32 s0, s1, vcc_lo             ; encoding: [0x01,0x6a,0x80,0x81]

s_sub_co_i32 s0, s1, vcc_hi
// GFX12: s_sub_co_i32 s0, s1, vcc_hi             ; encoding: [0x01,0x6b,0x80,0x81]

s_sub_co_i32 s0, s1, m0
// GFX12: s_sub_co_i32 s0, s1, m0                 ; encoding: [0x01,0x7d,0x80,0x81]

s_sub_co_i32 s0, s1, 0
// GFX12: s_sub_co_i32 s0, s1, 0                  ; encoding: [0x01,0x80,0x80,0x81]

s_sub_co_i32 s0, s1, -1
// GFX12: s_sub_co_i32 s0, s1, -1                 ; encoding: [0x01,0xc1,0x80,0x81]

s_sub_co_i32 s0, s1, 0.5
// GFX12: s_sub_co_i32 s0, s1, 0.5                ; encoding: [0x01,0xf0,0x80,0x81]

s_sub_co_i32 s0, s1, -4.0
// GFX12: s_sub_co_i32 s0, s1, -4.0               ; encoding: [0x01,0xf7,0x80,0x81]

s_sub_co_i32 s0, s1, 0x3f717273
// GFX12: s_sub_co_i32 s0, s1, 0x3f717273         ; encoding: [0x01,0xff,0x80,0x81,0x73,0x72,0x71,0x3f]

s_sub_co_i32 s0, s1, 0xaf123456
// GFX12: s_sub_co_i32 s0, s1, 0xaf123456         ; encoding: [0x01,0xff,0x80,0x81,0x56,0x34,0x12,0xaf]

s_add_co_ci_u32 s0, s1, s2
// GFX12: s_add_co_ci_u32 s0, s1, s2              ; encoding: [0x01,0x02,0x00,0x82]

s_add_co_ci_u32 s105, s104, s103
// GFX12: s_add_co_ci_u32 s105, s104, s103        ; encoding: [0x68,0x67,0x69,0x82]

s_add_co_ci_u32 s0, s104, s103
// GFX12: s_add_co_ci_u32 s0, s104, s103          ; encoding: [0x68,0x67,0x00,0x82]

s_add_co_ci_u32 s105, s1, s103
// GFX12: s_add_co_ci_u32 s105, s1, s103          ; encoding: [0x01,0x67,0x69,0x82]

s_add_co_ci_u32 s105, s104, s2
// GFX12: s_add_co_ci_u32 s105, s104, s2          ; encoding: [0x68,0x02,0x69,0x82]

s_add_co_ci_u32 s105, s1, s2
// GFX12: s_add_co_ci_u32 s105, s1, s2            ; encoding: [0x01,0x02,0x69,0x82]

s_add_co_ci_u32 s0, s104, s2
// GFX12: s_add_co_ci_u32 s0, s104, s2            ; encoding: [0x68,0x02,0x00,0x82]

s_add_co_ci_u32 s0, s1, s103
// GFX12: s_add_co_ci_u32 s0, s1, s103            ; encoding: [0x01,0x67,0x00,0x82]

s_add_co_ci_u32 exec_lo, s1, s2
// GFX12: s_add_co_ci_u32 exec_lo, s1, s2         ; encoding: [0x01,0x02,0x7e,0x82]

s_add_co_ci_u32 exec_hi, s1, s2
// GFX12: s_add_co_ci_u32 exec_hi, s1, s2         ; encoding: [0x01,0x02,0x7f,0x82]

s_add_co_ci_u32 vcc_lo, s1, s2
// GFX12: s_add_co_ci_u32 vcc_lo, s1, s2          ; encoding: [0x01,0x02,0x6a,0x82]

s_add_co_ci_u32 vcc_hi, s1, s2
// GFX12: s_add_co_ci_u32 vcc_hi, s1, s2          ; encoding: [0x01,0x02,0x6b,0x82]

s_add_co_ci_u32 m0, s1, s2
// GFX12: s_add_co_ci_u32 m0, s1, s2              ; encoding: [0x01,0x02,0x7d,0x82]

s_add_co_ci_u32 s0, exec_lo, s2
// GFX12: s_add_co_ci_u32 s0, exec_lo, s2         ; encoding: [0x7e,0x02,0x00,0x82]

s_add_co_ci_u32 s0, exec_hi, s2
// GFX12: s_add_co_ci_u32 s0, exec_hi, s2         ; encoding: [0x7f,0x02,0x00,0x82]

s_add_co_ci_u32 s0, vcc_lo, s2
// GFX12: s_add_co_ci_u32 s0, vcc_lo, s2          ; encoding: [0x6a,0x02,0x00,0x82]

s_add_co_ci_u32 s0, vcc_hi, s2
// GFX12: s_add_co_ci_u32 s0, vcc_hi, s2          ; encoding: [0x6b,0x02,0x00,0x82]

s_add_co_ci_u32 s0, m0, s2
// GFX12: s_add_co_ci_u32 s0, m0, s2              ; encoding: [0x7d,0x02,0x00,0x82]

s_add_co_ci_u32 s0, 0, s2
// GFX12: s_add_co_ci_u32 s0, 0, s2               ; encoding: [0x80,0x02,0x00,0x82]

s_add_co_ci_u32 s0, -1, s2
// GFX12: s_add_co_ci_u32 s0, -1, s2              ; encoding: [0xc1,0x02,0x00,0x82]

s_add_co_ci_u32 s0, 0.5, s2
// GFX12: s_add_co_ci_u32 s0, 0.5, s2             ; encoding: [0xf0,0x02,0x00,0x82]

s_add_co_ci_u32 s0, -4.0, s2
// GFX12: s_add_co_ci_u32 s0, -4.0, s2            ; encoding: [0xf7,0x02,0x00,0x82]

s_add_co_ci_u32 s0, 0x3f717273, s2
// GFX12: s_add_co_ci_u32 s0, 0x3f717273, s2      ; encoding: [0xff,0x02,0x00,0x82,0x73,0x72,0x71,0x3f]

s_add_co_ci_u32 s0, 0xaf123456, s2
// GFX12: s_add_co_ci_u32 s0, 0xaf123456, s2      ; encoding: [0xff,0x02,0x00,0x82,0x56,0x34,0x12,0xaf]

s_add_co_ci_u32 s0, s1, exec_lo
// GFX12: s_add_co_ci_u32 s0, s1, exec_lo         ; encoding: [0x01,0x7e,0x00,0x82]

s_add_co_ci_u32 s0, s1, exec_hi
// GFX12: s_add_co_ci_u32 s0, s1, exec_hi         ; encoding: [0x01,0x7f,0x00,0x82]

s_add_co_ci_u32 s0, s1, vcc_lo
// GFX12: s_add_co_ci_u32 s0, s1, vcc_lo          ; encoding: [0x01,0x6a,0x00,0x82]

s_add_co_ci_u32 s0, s1, vcc_hi
// GFX12: s_add_co_ci_u32 s0, s1, vcc_hi          ; encoding: [0x01,0x6b,0x00,0x82]

s_add_co_ci_u32 s0, s1, m0
// GFX12: s_add_co_ci_u32 s0, s1, m0              ; encoding: [0x01,0x7d,0x00,0x82]

s_add_co_ci_u32 s0, s1, 0
// GFX12: s_add_co_ci_u32 s0, s1, 0               ; encoding: [0x01,0x80,0x00,0x82]

s_add_co_ci_u32 s0, s1, -1
// GFX12: s_add_co_ci_u32 s0, s1, -1              ; encoding: [0x01,0xc1,0x00,0x82]

s_add_co_ci_u32 s0, s1, 0.5
// GFX12: s_add_co_ci_u32 s0, s1, 0.5             ; encoding: [0x01,0xf0,0x00,0x82]

s_add_co_ci_u32 s0, s1, -4.0
// GFX12: s_add_co_ci_u32 s0, s1, -4.0            ; encoding: [0x01,0xf7,0x00,0x82]

s_add_co_ci_u32 s0, s1, 0x3f717273
// GFX12: s_add_co_ci_u32 s0, s1, 0x3f717273      ; encoding: [0x01,0xff,0x00,0x82,0x73,0x72,0x71,0x3f]

s_add_co_ci_u32 s0, s1, 0xaf123456
// GFX12: s_add_co_ci_u32 s0, s1, 0xaf123456      ; encoding: [0x01,0xff,0x00,0x82,0x56,0x34,0x12,0xaf]

s_sub_co_ci_u32 s0, s1, s2
// GFX12: s_sub_co_ci_u32 s0, s1, s2              ; encoding: [0x01,0x02,0x80,0x82]

s_sub_co_ci_u32 s105, s104, s103
// GFX12: s_sub_co_ci_u32 s105, s104, s103        ; encoding: [0x68,0x67,0xe9,0x82]

s_sub_co_ci_u32 s0, s104, s103
// GFX12: s_sub_co_ci_u32 s0, s104, s103          ; encoding: [0x68,0x67,0x80,0x82]

s_sub_co_ci_u32 s105, s1, s103
// GFX12: s_sub_co_ci_u32 s105, s1, s103          ; encoding: [0x01,0x67,0xe9,0x82]

s_sub_co_ci_u32 s105, s104, s2
// GFX12: s_sub_co_ci_u32 s105, s104, s2          ; encoding: [0x68,0x02,0xe9,0x82]

s_sub_co_ci_u32 s105, s1, s2
// GFX12: s_sub_co_ci_u32 s105, s1, s2            ; encoding: [0x01,0x02,0xe9,0x82]

s_sub_co_ci_u32 s0, s104, s2
// GFX12: s_sub_co_ci_u32 s0, s104, s2            ; encoding: [0x68,0x02,0x80,0x82]

s_sub_co_ci_u32 s0, s1, s103
// GFX12: s_sub_co_ci_u32 s0, s1, s103            ; encoding: [0x01,0x67,0x80,0x82]

s_sub_co_ci_u32 exec_lo, s1, s2
// GFX12: s_sub_co_ci_u32 exec_lo, s1, s2         ; encoding: [0x01,0x02,0xfe,0x82]

s_sub_co_ci_u32 exec_hi, s1, s2
// GFX12: s_sub_co_ci_u32 exec_hi, s1, s2         ; encoding: [0x01,0x02,0xff,0x82]

s_sub_co_ci_u32 vcc_lo, s1, s2
// GFX12: s_sub_co_ci_u32 vcc_lo, s1, s2          ; encoding: [0x01,0x02,0xea,0x82]

s_sub_co_ci_u32 vcc_hi, s1, s2
// GFX12: s_sub_co_ci_u32 vcc_hi, s1, s2          ; encoding: [0x01,0x02,0xeb,0x82]

s_sub_co_ci_u32 m0, s1, s2
// GFX12: s_sub_co_ci_u32 m0, s1, s2              ; encoding: [0x01,0x02,0xfd,0x82]

s_sub_co_ci_u32 s0, exec_lo, s2
// GFX12: s_sub_co_ci_u32 s0, exec_lo, s2         ; encoding: [0x7e,0x02,0x80,0x82]

s_sub_co_ci_u32 s0, exec_hi, s2
// GFX12: s_sub_co_ci_u32 s0, exec_hi, s2         ; encoding: [0x7f,0x02,0x80,0x82]

s_sub_co_ci_u32 s0, vcc_lo, s2
// GFX12: s_sub_co_ci_u32 s0, vcc_lo, s2          ; encoding: [0x6a,0x02,0x80,0x82]

s_sub_co_ci_u32 s0, vcc_hi, s2
// GFX12: s_sub_co_ci_u32 s0, vcc_hi, s2          ; encoding: [0x6b,0x02,0x80,0x82]

s_sub_co_ci_u32 s0, m0, s2
// GFX12: s_sub_co_ci_u32 s0, m0, s2              ; encoding: [0x7d,0x02,0x80,0x82]

s_sub_co_ci_u32 s0, 0, s2
// GFX12: s_sub_co_ci_u32 s0, 0, s2               ; encoding: [0x80,0x02,0x80,0x82]

s_sub_co_ci_u32 s0, -1, s2
// GFX12: s_sub_co_ci_u32 s0, -1, s2              ; encoding: [0xc1,0x02,0x80,0x82]

s_sub_co_ci_u32 s0, 0.5, s2
// GFX12: s_sub_co_ci_u32 s0, 0.5, s2             ; encoding: [0xf0,0x02,0x80,0x82]

s_sub_co_ci_u32 s0, -4.0, s2
// GFX12: s_sub_co_ci_u32 s0, -4.0, s2            ; encoding: [0xf7,0x02,0x80,0x82]

s_sub_co_ci_u32 s0, 0x3f717273, s2
// GFX12: s_sub_co_ci_u32 s0, 0x3f717273, s2      ; encoding: [0xff,0x02,0x80,0x82,0x73,0x72,0x71,0x3f]

s_sub_co_ci_u32 s0, 0xaf123456, s2
// GFX12: s_sub_co_ci_u32 s0, 0xaf123456, s2      ; encoding: [0xff,0x02,0x80,0x82,0x56,0x34,0x12,0xaf]

s_sub_co_ci_u32 s0, s1, exec_lo
// GFX12: s_sub_co_ci_u32 s0, s1, exec_lo         ; encoding: [0x01,0x7e,0x80,0x82]

s_sub_co_ci_u32 s0, s1, exec_hi
// GFX12: s_sub_co_ci_u32 s0, s1, exec_hi         ; encoding: [0x01,0x7f,0x80,0x82]

s_sub_co_ci_u32 s0, s1, vcc_lo
// GFX12: s_sub_co_ci_u32 s0, s1, vcc_lo          ; encoding: [0x01,0x6a,0x80,0x82]

s_sub_co_ci_u32 s0, s1, vcc_hi
// GFX12: s_sub_co_ci_u32 s0, s1, vcc_hi          ; encoding: [0x01,0x6b,0x80,0x82]

s_sub_co_ci_u32 s0, s1, m0
// GFX12: s_sub_co_ci_u32 s0, s1, m0              ; encoding: [0x01,0x7d,0x80,0x82]

s_sub_co_ci_u32 s0, s1, 0
// GFX12: s_sub_co_ci_u32 s0, s1, 0               ; encoding: [0x01,0x80,0x80,0x82]

s_sub_co_ci_u32 s0, s1, -1
// GFX12: s_sub_co_ci_u32 s0, s1, -1              ; encoding: [0x01,0xc1,0x80,0x82]

s_sub_co_ci_u32 s0, s1, 0.5
// GFX12: s_sub_co_ci_u32 s0, s1, 0.5             ; encoding: [0x01,0xf0,0x80,0x82]

s_sub_co_ci_u32 s0, s1, -4.0
// GFX12: s_sub_co_ci_u32 s0, s1, -4.0            ; encoding: [0x01,0xf7,0x80,0x82]

s_sub_co_ci_u32 s0, s1, 0x3f717273
// GFX12: s_sub_co_ci_u32 s0, s1, 0x3f717273      ; encoding: [0x01,0xff,0x80,0x82,0x73,0x72,0x71,0x3f]

s_sub_co_ci_u32 s0, s1, 0xaf123456
// GFX12: s_sub_co_ci_u32 s0, s1, 0xaf123456      ; encoding: [0x01,0xff,0x80,0x82,0x56,0x34,0x12,0xaf]

s_min_i32 s0, s1, s2
// GFX12: s_min_i32 s0, s1, s2                    ; encoding: [0x01,0x02,0x00,0x89]

s_min_i32 s105, s104, s103
// GFX12: s_min_i32 s105, s104, s103              ; encoding: [0x68,0x67,0x69,0x89]

s_min_i32 s0, s104, s103
// GFX12: s_min_i32 s0, s104, s103                ; encoding: [0x68,0x67,0x00,0x89]

s_min_i32 s105, s1, s103
// GFX12: s_min_i32 s105, s1, s103                ; encoding: [0x01,0x67,0x69,0x89]

s_min_i32 s105, s104, s2
// GFX12: s_min_i32 s105, s104, s2                ; encoding: [0x68,0x02,0x69,0x89]

s_min_i32 s105, s1, s2
// GFX12: s_min_i32 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0x89]

s_min_i32 s0, s104, s2
// GFX12: s_min_i32 s0, s104, s2                  ; encoding: [0x68,0x02,0x00,0x89]

s_min_i32 s0, s1, s103
// GFX12: s_min_i32 s0, s1, s103                  ; encoding: [0x01,0x67,0x00,0x89]

s_min_i32 exec_lo, s1, s2
// GFX12: s_min_i32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0x7e,0x89]

s_min_i32 exec_hi, s1, s2
// GFX12: s_min_i32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0x7f,0x89]

s_min_i32 vcc_lo, s1, s2
// GFX12: s_min_i32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0x6a,0x89]

s_min_i32 vcc_hi, s1, s2
// GFX12: s_min_i32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0x6b,0x89]

s_min_i32 m0, s1, s2
// GFX12: s_min_i32 m0, s1, s2                    ; encoding: [0x01,0x02,0x7d,0x89]

s_min_i32 s0, exec_lo, s2
// GFX12: s_min_i32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x00,0x89]

s_min_i32 s0, exec_hi, s2
// GFX12: s_min_i32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x00,0x89]

s_min_i32 s0, vcc_lo, s2
// GFX12: s_min_i32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x00,0x89]

s_min_i32 s0, vcc_hi, s2
// GFX12: s_min_i32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x00,0x89]

s_min_i32 s0, m0, s2
// GFX12: s_min_i32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x00,0x89]

s_min_i32 s0, 0, s2
// GFX12: s_min_i32 s0, 0, s2                     ; encoding: [0x80,0x02,0x00,0x89]

s_min_i32 s0, -1, s2
// GFX12: s_min_i32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x00,0x89]

s_min_i32 s0, 0.5, s2
// GFX12: s_min_i32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x00,0x89]

s_min_i32 s0, -4.0, s2
// GFX12: s_min_i32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x00,0x89]

s_min_i32 s0, 0x3f717273, s2
// GFX12: s_min_i32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x00,0x89,0x73,0x72,0x71,0x3f]

s_min_i32 s0, 0xaf123456, s2
// GFX12: s_min_i32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x00,0x89,0x56,0x34,0x12,0xaf]

s_min_i32 s0, s1, exec_lo
// GFX12: s_min_i32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x00,0x89]

s_min_i32 s0, s1, exec_hi
// GFX12: s_min_i32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x00,0x89]

s_min_i32 s0, s1, vcc_lo
// GFX12: s_min_i32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x00,0x89]

s_min_i32 s0, s1, vcc_hi
// GFX12: s_min_i32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x00,0x89]

s_min_i32 s0, s1, m0
// GFX12: s_min_i32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x00,0x89]

s_min_i32 s0, s1, 0
// GFX12: s_min_i32 s0, s1, 0                     ; encoding: [0x01,0x80,0x00,0x89]

s_min_i32 s0, s1, -1
// GFX12: s_min_i32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x00,0x89]

s_min_i32 s0, s1, 0.5
// GFX12: s_min_i32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x00,0x89]

s_min_i32 s0, s1, -4.0
// GFX12: s_min_i32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x00,0x89]

s_min_i32 s0, s1, 0x3f717273
// GFX12: s_min_i32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x00,0x89,0x73,0x72,0x71,0x3f]

s_min_i32 s0, s1, 0xaf123456
// GFX12: s_min_i32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x00,0x89,0x56,0x34,0x12,0xaf]

s_min_u32 s0, s1, s2
// GFX12: s_min_u32 s0, s1, s2                    ; encoding: [0x01,0x02,0x80,0x89]

s_min_u32 s105, s104, s103
// GFX12: s_min_u32 s105, s104, s103              ; encoding: [0x68,0x67,0xe9,0x89]

s_min_u32 s0, s104, s103
// GFX12: s_min_u32 s0, s104, s103                ; encoding: [0x68,0x67,0x80,0x89]

s_min_u32 s105, s1, s103
// GFX12: s_min_u32 s105, s1, s103                ; encoding: [0x01,0x67,0xe9,0x89]

s_min_u32 s105, s104, s2
// GFX12: s_min_u32 s105, s104, s2                ; encoding: [0x68,0x02,0xe9,0x89]

s_min_u32 s105, s1, s2
// GFX12: s_min_u32 s105, s1, s2                  ; encoding: [0x01,0x02,0xe9,0x89]

s_min_u32 s0, s104, s2
// GFX12: s_min_u32 s0, s104, s2                  ; encoding: [0x68,0x02,0x80,0x89]

s_min_u32 s0, s1, s103
// GFX12: s_min_u32 s0, s1, s103                  ; encoding: [0x01,0x67,0x80,0x89]

s_min_u32 exec_lo, s1, s2
// GFX12: s_min_u32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0xfe,0x89]

s_min_u32 exec_hi, s1, s2
// GFX12: s_min_u32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0xff,0x89]

s_min_u32 vcc_lo, s1, s2
// GFX12: s_min_u32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0xea,0x89]

s_min_u32 vcc_hi, s1, s2
// GFX12: s_min_u32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0xeb,0x89]

s_min_u32 m0, s1, s2
// GFX12: s_min_u32 m0, s1, s2                    ; encoding: [0x01,0x02,0xfd,0x89]

s_min_u32 s0, exec_lo, s2
// GFX12: s_min_u32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x80,0x89]

s_min_u32 s0, exec_hi, s2
// GFX12: s_min_u32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x80,0x89]

s_min_u32 s0, vcc_lo, s2
// GFX12: s_min_u32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x80,0x89]

s_min_u32 s0, vcc_hi, s2
// GFX12: s_min_u32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x80,0x89]

s_min_u32 s0, m0, s2
// GFX12: s_min_u32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x80,0x89]

s_min_u32 s0, 0, s2
// GFX12: s_min_u32 s0, 0, s2                     ; encoding: [0x80,0x02,0x80,0x89]

s_min_u32 s0, -1, s2
// GFX12: s_min_u32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x80,0x89]

s_min_u32 s0, 0.5, s2
// GFX12: s_min_u32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x80,0x89]

s_min_u32 s0, -4.0, s2
// GFX12: s_min_u32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x80,0x89]

s_min_u32 s0, 0x3f717273, s2
// GFX12: s_min_u32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x80,0x89,0x73,0x72,0x71,0x3f]

s_min_u32 s0, 0xaf123456, s2
// GFX12: s_min_u32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x80,0x89,0x56,0x34,0x12,0xaf]

s_min_u32 s0, s1, exec_lo
// GFX12: s_min_u32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x80,0x89]

s_min_u32 s0, s1, exec_hi
// GFX12: s_min_u32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x80,0x89]

s_min_u32 s0, s1, vcc_lo
// GFX12: s_min_u32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x80,0x89]

s_min_u32 s0, s1, vcc_hi
// GFX12: s_min_u32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x80,0x89]

s_min_u32 s0, s1, m0
// GFX12: s_min_u32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x80,0x89]

s_min_u32 s0, s1, 0
// GFX12: s_min_u32 s0, s1, 0                     ; encoding: [0x01,0x80,0x80,0x89]

s_min_u32 s0, s1, -1
// GFX12: s_min_u32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x80,0x89]

s_min_u32 s0, s1, 0.5
// GFX12: s_min_u32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x80,0x89]

s_min_u32 s0, s1, -4.0
// GFX12: s_min_u32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x80,0x89]

s_min_u32 s0, s1, 0x3f717273
// GFX12: s_min_u32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x80,0x89,0x73,0x72,0x71,0x3f]

s_min_u32 s0, s1, 0xaf123456
// GFX12: s_min_u32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x80,0x89,0x56,0x34,0x12,0xaf]

s_max_i32 s0, s1, s2
// GFX12: s_max_i32 s0, s1, s2                    ; encoding: [0x01,0x02,0x00,0x8a]

s_max_i32 s105, s104, s103
// GFX12: s_max_i32 s105, s104, s103              ; encoding: [0x68,0x67,0x69,0x8a]

s_max_i32 s0, s104, s103
// GFX12: s_max_i32 s0, s104, s103                ; encoding: [0x68,0x67,0x00,0x8a]

s_max_i32 s105, s1, s103
// GFX12: s_max_i32 s105, s1, s103                ; encoding: [0x01,0x67,0x69,0x8a]

s_max_i32 s105, s104, s2
// GFX12: s_max_i32 s105, s104, s2                ; encoding: [0x68,0x02,0x69,0x8a]

s_max_i32 s105, s1, s2
// GFX12: s_max_i32 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0x8a]

s_max_i32 s0, s104, s2
// GFX12: s_max_i32 s0, s104, s2                  ; encoding: [0x68,0x02,0x00,0x8a]

s_max_i32 s0, s1, s103
// GFX12: s_max_i32 s0, s1, s103                  ; encoding: [0x01,0x67,0x00,0x8a]

s_max_i32 exec_lo, s1, s2
// GFX12: s_max_i32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0x7e,0x8a]

s_max_i32 exec_hi, s1, s2
// GFX12: s_max_i32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0x7f,0x8a]

s_max_i32 vcc_lo, s1, s2
// GFX12: s_max_i32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0x6a,0x8a]

s_max_i32 vcc_hi, s1, s2
// GFX12: s_max_i32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0x6b,0x8a]

s_max_i32 m0, s1, s2
// GFX12: s_max_i32 m0, s1, s2                    ; encoding: [0x01,0x02,0x7d,0x8a]

s_max_i32 s0, exec_lo, s2
// GFX12: s_max_i32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x00,0x8a]

s_max_i32 s0, exec_hi, s2
// GFX12: s_max_i32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x00,0x8a]

s_max_i32 s0, vcc_lo, s2
// GFX12: s_max_i32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x00,0x8a]

s_max_i32 s0, vcc_hi, s2
// GFX12: s_max_i32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x00,0x8a]

s_max_i32 s0, m0, s2
// GFX12: s_max_i32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x00,0x8a]

s_max_i32 s0, 0, s2
// GFX12: s_max_i32 s0, 0, s2                     ; encoding: [0x80,0x02,0x00,0x8a]

s_max_i32 s0, -1, s2
// GFX12: s_max_i32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x00,0x8a]

s_max_i32 s0, 0.5, s2
// GFX12: s_max_i32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x00,0x8a]

s_max_i32 s0, -4.0, s2
// GFX12: s_max_i32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x00,0x8a]

s_max_i32 s0, 0x3f717273, s2
// GFX12: s_max_i32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x00,0x8a,0x73,0x72,0x71,0x3f]

s_max_i32 s0, 0xaf123456, s2
// GFX12: s_max_i32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x00,0x8a,0x56,0x34,0x12,0xaf]

s_max_i32 s0, s1, exec_lo
// GFX12: s_max_i32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x00,0x8a]

s_max_i32 s0, s1, exec_hi
// GFX12: s_max_i32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x00,0x8a]

s_max_i32 s0, s1, vcc_lo
// GFX12: s_max_i32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x00,0x8a]

s_max_i32 s0, s1, vcc_hi
// GFX12: s_max_i32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x00,0x8a]

s_max_i32 s0, s1, m0
// GFX12: s_max_i32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x00,0x8a]

s_max_i32 s0, s1, 0
// GFX12: s_max_i32 s0, s1, 0                     ; encoding: [0x01,0x80,0x00,0x8a]

s_max_i32 s0, s1, -1
// GFX12: s_max_i32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x00,0x8a]

s_max_i32 s0, s1, 0.5
// GFX12: s_max_i32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x00,0x8a]

s_max_i32 s0, s1, -4.0
// GFX12: s_max_i32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x00,0x8a]

s_max_i32 s0, s1, 0x3f717273
// GFX12: s_max_i32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x00,0x8a,0x73,0x72,0x71,0x3f]

s_max_i32 s0, s1, 0xaf123456
// GFX12: s_max_i32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x00,0x8a,0x56,0x34,0x12,0xaf]

s_max_u32 s0, s1, s2
// GFX12: s_max_u32 s0, s1, s2                    ; encoding: [0x01,0x02,0x80,0x8a]

s_max_u32 s105, s104, s103
// GFX12: s_max_u32 s105, s104, s103              ; encoding: [0x68,0x67,0xe9,0x8a]

s_max_u32 s0, s104, s103
// GFX12: s_max_u32 s0, s104, s103                ; encoding: [0x68,0x67,0x80,0x8a]

s_max_u32 s105, s1, s103
// GFX12: s_max_u32 s105, s1, s103                ; encoding: [0x01,0x67,0xe9,0x8a]

s_max_u32 s105, s104, s2
// GFX12: s_max_u32 s105, s104, s2                ; encoding: [0x68,0x02,0xe9,0x8a]

s_max_u32 s105, s1, s2
// GFX12: s_max_u32 s105, s1, s2                  ; encoding: [0x01,0x02,0xe9,0x8a]

s_max_u32 s0, s104, s2
// GFX12: s_max_u32 s0, s104, s2                  ; encoding: [0x68,0x02,0x80,0x8a]

s_max_u32 s0, s1, s103
// GFX12: s_max_u32 s0, s1, s103                  ; encoding: [0x01,0x67,0x80,0x8a]

s_max_u32 exec_lo, s1, s2
// GFX12: s_max_u32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0xfe,0x8a]

s_max_u32 exec_hi, s1, s2
// GFX12: s_max_u32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0xff,0x8a]

s_max_u32 vcc_lo, s1, s2
// GFX12: s_max_u32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0xea,0x8a]

s_max_u32 vcc_hi, s1, s2
// GFX12: s_max_u32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0xeb,0x8a]

s_max_u32 m0, s1, s2
// GFX12: s_max_u32 m0, s1, s2                    ; encoding: [0x01,0x02,0xfd,0x8a]

s_max_u32 s0, exec_lo, s2
// GFX12: s_max_u32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x80,0x8a]

s_max_u32 s0, exec_hi, s2
// GFX12: s_max_u32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x80,0x8a]

s_max_u32 s0, vcc_lo, s2
// GFX12: s_max_u32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x80,0x8a]

s_max_u32 s0, vcc_hi, s2
// GFX12: s_max_u32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x80,0x8a]

s_max_u32 s0, m0, s2
// GFX12: s_max_u32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x80,0x8a]

s_max_u32 s0, 0, s2
// GFX12: s_max_u32 s0, 0, s2                     ; encoding: [0x80,0x02,0x80,0x8a]

s_max_u32 s0, -1, s2
// GFX12: s_max_u32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x80,0x8a]

s_max_u32 s0, 0.5, s2
// GFX12: s_max_u32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x80,0x8a]

s_max_u32 s0, -4.0, s2
// GFX12: s_max_u32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x80,0x8a]

s_max_u32 s0, 0x3f717273, s2
// GFX12: s_max_u32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x80,0x8a,0x73,0x72,0x71,0x3f]

s_max_u32 s0, 0xaf123456, s2
// GFX12: s_max_u32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x80,0x8a,0x56,0x34,0x12,0xaf]

s_max_u32 s0, s1, exec_lo
// GFX12: s_max_u32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x80,0x8a]

s_max_u32 s0, s1, exec_hi
// GFX12: s_max_u32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x80,0x8a]

s_max_u32 s0, s1, vcc_lo
// GFX12: s_max_u32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x80,0x8a]

s_max_u32 s0, s1, vcc_hi
// GFX12: s_max_u32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x80,0x8a]

s_max_u32 s0, s1, m0
// GFX12: s_max_u32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x80,0x8a]

s_max_u32 s0, s1, 0
// GFX12: s_max_u32 s0, s1, 0                     ; encoding: [0x01,0x80,0x80,0x8a]

s_max_u32 s0, s1, -1
// GFX12: s_max_u32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x80,0x8a]

s_max_u32 s0, s1, 0.5
// GFX12: s_max_u32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x80,0x8a]

s_max_u32 s0, s1, -4.0
// GFX12: s_max_u32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x80,0x8a]

s_max_u32 s0, s1, 0x3f717273
// GFX12: s_max_u32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x80,0x8a,0x73,0x72,0x71,0x3f]

s_max_u32 s0, s1, 0xaf123456
// GFX12: s_max_u32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x80,0x8a,0x56,0x34,0x12,0xaf]

s_cselect_b32 s0, s1, s2
// GFX12: s_cselect_b32 s0, s1, s2                ; encoding: [0x01,0x02,0x00,0x98]

s_cselect_b32 s105, s104, s103
// GFX12: s_cselect_b32 s105, s104, s103          ; encoding: [0x68,0x67,0x69,0x98]

s_cselect_b32 s0, s104, s103
// GFX12: s_cselect_b32 s0, s104, s103            ; encoding: [0x68,0x67,0x00,0x98]

s_cselect_b32 s105, s1, s103
// GFX12: s_cselect_b32 s105, s1, s103            ; encoding: [0x01,0x67,0x69,0x98]

s_cselect_b32 s105, s104, s2
// GFX12: s_cselect_b32 s105, s104, s2            ; encoding: [0x68,0x02,0x69,0x98]

s_cselect_b32 s105, s1, s2
// GFX12: s_cselect_b32 s105, s1, s2              ; encoding: [0x01,0x02,0x69,0x98]

s_cselect_b32 s0, s104, s2
// GFX12: s_cselect_b32 s0, s104, s2              ; encoding: [0x68,0x02,0x00,0x98]

s_cselect_b32 s0, s1, s103
// GFX12: s_cselect_b32 s0, s1, s103              ; encoding: [0x01,0x67,0x00,0x98]

s_cselect_b32 exec_lo, s1, s2
// GFX12: s_cselect_b32 exec_lo, s1, s2           ; encoding: [0x01,0x02,0x7e,0x98]

s_cselect_b32 exec_hi, s1, s2
// GFX12: s_cselect_b32 exec_hi, s1, s2           ; encoding: [0x01,0x02,0x7f,0x98]

s_cselect_b32 vcc_lo, s1, s2
// GFX12: s_cselect_b32 vcc_lo, s1, s2            ; encoding: [0x01,0x02,0x6a,0x98]

s_cselect_b32 vcc_hi, s1, s2
// GFX12: s_cselect_b32 vcc_hi, s1, s2            ; encoding: [0x01,0x02,0x6b,0x98]

s_cselect_b32 m0, s1, s2
// GFX12: s_cselect_b32 m0, s1, s2                ; encoding: [0x01,0x02,0x7d,0x98]

s_cselect_b32 s0, exec_lo, s2
// GFX12: s_cselect_b32 s0, exec_lo, s2           ; encoding: [0x7e,0x02,0x00,0x98]

s_cselect_b32 s0, exec_hi, s2
// GFX12: s_cselect_b32 s0, exec_hi, s2           ; encoding: [0x7f,0x02,0x00,0x98]

s_cselect_b32 s0, vcc_lo, s2
// GFX12: s_cselect_b32 s0, vcc_lo, s2            ; encoding: [0x6a,0x02,0x00,0x98]

s_cselect_b32 s0, vcc_hi, s2
// GFX12: s_cselect_b32 s0, vcc_hi, s2            ; encoding: [0x6b,0x02,0x00,0x98]

s_cselect_b32 s0, m0, s2
// GFX12: s_cselect_b32 s0, m0, s2                ; encoding: [0x7d,0x02,0x00,0x98]

s_cselect_b32 s0, 0, s2
// GFX12: s_cselect_b32 s0, 0, s2                 ; encoding: [0x80,0x02,0x00,0x98]

s_cselect_b32 s0, -1, s2
// GFX12: s_cselect_b32 s0, -1, s2                ; encoding: [0xc1,0x02,0x00,0x98]

s_cselect_b32 s0, 0.5, s2
// GFX12: s_cselect_b32 s0, 0.5, s2               ; encoding: [0xf0,0x02,0x00,0x98]

s_cselect_b32 s0, -4.0, s2
// GFX12: s_cselect_b32 s0, -4.0, s2              ; encoding: [0xf7,0x02,0x00,0x98]

s_cselect_b32 s0, 0x3f717273, s2
// GFX12: s_cselect_b32 s0, 0x3f717273, s2        ; encoding: [0xff,0x02,0x00,0x98,0x73,0x72,0x71,0x3f]

s_cselect_b32 s0, 0xaf123456, s2
// GFX12: s_cselect_b32 s0, 0xaf123456, s2        ; encoding: [0xff,0x02,0x00,0x98,0x56,0x34,0x12,0xaf]

s_cselect_b32 s0, s1, exec_lo
// GFX12: s_cselect_b32 s0, s1, exec_lo           ; encoding: [0x01,0x7e,0x00,0x98]

s_cselect_b32 s0, s1, exec_hi
// GFX12: s_cselect_b32 s0, s1, exec_hi           ; encoding: [0x01,0x7f,0x00,0x98]

s_cselect_b32 s0, s1, vcc_lo
// GFX12: s_cselect_b32 s0, s1, vcc_lo            ; encoding: [0x01,0x6a,0x00,0x98]

s_cselect_b32 s0, s1, vcc_hi
// GFX12: s_cselect_b32 s0, s1, vcc_hi            ; encoding: [0x01,0x6b,0x00,0x98]

s_cselect_b32 s0, s1, m0
// GFX12: s_cselect_b32 s0, s1, m0                ; encoding: [0x01,0x7d,0x00,0x98]

s_cselect_b32 s0, s1, 0
// GFX12: s_cselect_b32 s0, s1, 0                 ; encoding: [0x01,0x80,0x00,0x98]

s_cselect_b32 s0, s1, -1
// GFX12: s_cselect_b32 s0, s1, -1                ; encoding: [0x01,0xc1,0x00,0x98]

s_cselect_b32 s0, s1, 0.5
// GFX12: s_cselect_b32 s0, s1, 0.5               ; encoding: [0x01,0xf0,0x00,0x98]

s_cselect_b32 s0, s1, -4.0
// GFX12: s_cselect_b32 s0, s1, -4.0              ; encoding: [0x01,0xf7,0x00,0x98]

s_cselect_b32 s0, s1, 0x3f717273
// GFX12: s_cselect_b32 s0, s1, 0x3f717273        ; encoding: [0x01,0xff,0x00,0x98,0x73,0x72,0x71,0x3f]

s_cselect_b32 s0, s1, 0xaf123456
// GFX12: s_cselect_b32 s0, s1, 0xaf123456        ; encoding: [0x01,0xff,0x00,0x98,0x56,0x34,0x12,0xaf]

s_cselect_b64 s[0:1], s[2:3], s[4:5]
// GFX12: s_cselect_b64 s[0:1], s[2:3], s[4:5]    ; encoding: [0x02,0x04,0x80,0x98]

s_cselect_b64 s[104:105], s[102:103], s[100:101]
// GFX12: s_cselect_b64 s[104:105], s[102:103], s[100:101] ; encoding: [0x66,0x64,0xe8,0x98]

s_cselect_b64 s[0:1], s[102:103], s[100:101]
// GFX12: s_cselect_b64 s[0:1], s[102:103], s[100:101] ; encoding: [0x66,0x64,0x80,0x98]

s_cselect_b64 s[104:105], s[2:3], s[100:101]
// GFX12: s_cselect_b64 s[104:105], s[2:3], s[100:101] ; encoding: [0x02,0x64,0xe8,0x98]

s_cselect_b64 s[104:105], s[102:103], s[4:5]
// GFX12: s_cselect_b64 s[104:105], s[102:103], s[4:5] ; encoding: [0x66,0x04,0xe8,0x98]

s_cselect_b64 s[104:105], s[2:3], s[4:5]
// GFX12: s_cselect_b64 s[104:105], s[2:3], s[4:5] ; encoding: [0x02,0x04,0xe8,0x98]

s_cselect_b64 s[0:1], s[102:103], s[4:5]
// GFX12: s_cselect_b64 s[0:1], s[102:103], s[4:5] ; encoding: [0x66,0x04,0x80,0x98]

s_cselect_b64 s[0:1], s[2:3], s[100:101]
// GFX12: s_cselect_b64 s[0:1], s[2:3], s[100:101] ; encoding: [0x02,0x64,0x80,0x98]

s_cselect_b64 exec, s[2:3], s[4:5]
// GFX12: s_cselect_b64 exec, s[2:3], s[4:5]      ; encoding: [0x02,0x04,0xfe,0x98]

s_cselect_b64 vcc, s[2:3], s[4:5]
// GFX12: s_cselect_b64 vcc, s[2:3], s[4:5]       ; encoding: [0x02,0x04,0xea,0x98]

s_cselect_b64 s[0:1], exec, s[4:5]
// GFX12: s_cselect_b64 s[0:1], exec, s[4:5]      ; encoding: [0x7e,0x04,0x80,0x98]

s_cselect_b64 s[0:1], vcc, s[4:5]
// GFX12: s_cselect_b64 s[0:1], vcc, s[4:5]       ; encoding: [0x6a,0x04,0x80,0x98]

s_cselect_b64 s[0:1], 0, s[4:5]
// GFX12: s_cselect_b64 s[0:1], 0, s[4:5]         ; encoding: [0x80,0x04,0x80,0x98]

s_cselect_b64 s[0:1], -1, s[4:5]
// GFX12: s_cselect_b64 s[0:1], -1, s[4:5]        ; encoding: [0xc1,0x04,0x80,0x98]

s_cselect_b64 s[0:1], 0.5, s[4:5]
// GFX12: s_cselect_b64 s[0:1], 0.5, s[4:5]       ; encoding: [0xf0,0x04,0x80,0x98]

s_cselect_b64 s[0:1], -4.0, s[4:5]
// GFX12: s_cselect_b64 s[0:1], -4.0, s[4:5]      ; encoding: [0xf7,0x04,0x80,0x98]

s_cselect_b64 s[0:1], 0x3f717273, s[4:5]
// GFX12: s_cselect_b64 s[0:1], 0x3f717273, s[4:5] ; encoding: [0xff,0x04,0x80,0x98,0x73,0x72,0x71,0x3f]

s_cselect_b64 s[0:1], 0xaf123456, s[4:5]
// GFX12: s_cselect_b64 s[0:1], 0xaf123456, s[4:5] ; encoding: [0xff,0x04,0x80,0x98,0x56,0x34,0x12,0xaf]

s_cselect_b64 s[0:1], s[2:3], exec
// GFX12: s_cselect_b64 s[0:1], s[2:3], exec      ; encoding: [0x02,0x7e,0x80,0x98]

s_cselect_b64 s[0:1], s[2:3], vcc
// GFX12: s_cselect_b64 s[0:1], s[2:3], vcc       ; encoding: [0x02,0x6a,0x80,0x98]

s_cselect_b64 s[0:1], s[2:3], 0
// GFX12: s_cselect_b64 s[0:1], s[2:3], 0         ; encoding: [0x02,0x80,0x80,0x98]

s_cselect_b64 s[0:1], s[2:3], -1
// GFX12: s_cselect_b64 s[0:1], s[2:3], -1        ; encoding: [0x02,0xc1,0x80,0x98]

s_cselect_b64 s[0:1], s[2:3], 0.5
// GFX12: s_cselect_b64 s[0:1], s[2:3], 0.5       ; encoding: [0x02,0xf0,0x80,0x98]

s_cselect_b64 s[0:1], s[2:3], -4.0
// GFX12: s_cselect_b64 s[0:1], s[2:3], -4.0      ; encoding: [0x02,0xf7,0x80,0x98]

s_cselect_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_cselect_b64 s[0:1], s[2:3], 0x3f717273 ; encoding: [0x02,0xff,0x80,0x98,0x73,0x72,0x71,0x3f]

s_cselect_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_cselect_b64 s[0:1], s[2:3], 0xaf123456 ; encoding: [0x02,0xff,0x80,0x98,0x56,0x34,0x12,0xaf]

s_and_b32 s0, s1, s2
// GFX12: s_and_b32 s0, s1, s2                    ; encoding: [0x01,0x02,0x00,0x8b]

s_and_b32 s105, s104, s103
// GFX12: s_and_b32 s105, s104, s103              ; encoding: [0x68,0x67,0x69,0x8b]

s_and_b32 s0, s104, s103
// GFX12: s_and_b32 s0, s104, s103                ; encoding: [0x68,0x67,0x00,0x8b]

s_and_b32 s105, s1, s103
// GFX12: s_and_b32 s105, s1, s103                ; encoding: [0x01,0x67,0x69,0x8b]

s_and_b32 s105, s104, s2
// GFX12: s_and_b32 s105, s104, s2                ; encoding: [0x68,0x02,0x69,0x8b]

s_and_b32 s105, s1, s2
// GFX12: s_and_b32 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0x8b]

s_and_b32 s0, s104, s2
// GFX12: s_and_b32 s0, s104, s2                  ; encoding: [0x68,0x02,0x00,0x8b]

s_and_b32 s0, s1, s103
// GFX12: s_and_b32 s0, s1, s103                  ; encoding: [0x01,0x67,0x00,0x8b]

s_and_b32 exec_lo, s1, s2
// GFX12: s_and_b32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0x7e,0x8b]

s_and_b32 exec_hi, s1, s2
// GFX12: s_and_b32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0x7f,0x8b]

s_and_b32 vcc_lo, s1, s2
// GFX12: s_and_b32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0x6a,0x8b]

s_and_b32 vcc_hi, s1, s2
// GFX12: s_and_b32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0x6b,0x8b]

s_and_b32 m0, s1, s2
// GFX12: s_and_b32 m0, s1, s2                    ; encoding: [0x01,0x02,0x7d,0x8b]

s_and_b32 s0, exec_lo, s2
// GFX12: s_and_b32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x00,0x8b]

s_and_b32 s0, exec_hi, s2
// GFX12: s_and_b32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x00,0x8b]

s_and_b32 s0, vcc_lo, s2
// GFX12: s_and_b32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x00,0x8b]

s_and_b32 s0, vcc_hi, s2
// GFX12: s_and_b32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x00,0x8b]

s_and_b32 s0, m0, s2
// GFX12: s_and_b32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x00,0x8b]

s_and_b32 s0, 0, s2
// GFX12: s_and_b32 s0, 0, s2                     ; encoding: [0x80,0x02,0x00,0x8b]

s_and_b32 s0, -1, s2
// GFX12: s_and_b32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x00,0x8b]

s_and_b32 s0, 0.5, s2
// GFX12: s_and_b32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x00,0x8b]

s_and_b32 s0, -4.0, s2
// GFX12: s_and_b32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x00,0x8b]

s_and_b32 s0, 0x3f717273, s2
// GFX12: s_and_b32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x00,0x8b,0x73,0x72,0x71,0x3f]

s_and_b32 s0, 0xaf123456, s2
// GFX12: s_and_b32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x00,0x8b,0x56,0x34,0x12,0xaf]

s_and_b32 s0, s1, exec_lo
// GFX12: s_and_b32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x00,0x8b]

s_and_b32 s0, s1, exec_hi
// GFX12: s_and_b32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x00,0x8b]

s_and_b32 s0, s1, vcc_lo
// GFX12: s_and_b32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x00,0x8b]

s_and_b32 s0, s1, vcc_hi
// GFX12: s_and_b32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x00,0x8b]

s_and_b32 s0, s1, m0
// GFX12: s_and_b32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x00,0x8b]

s_and_b32 s0, s1, 0
// GFX12: s_and_b32 s0, s1, 0                     ; encoding: [0x01,0x80,0x00,0x8b]

s_and_b32 s0, s1, -1
// GFX12: s_and_b32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x00,0x8b]

s_and_b32 s0, s1, 0.5
// GFX12: s_and_b32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x00,0x8b]

s_and_b32 s0, s1, -4.0
// GFX12: s_and_b32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x00,0x8b]

s_and_b32 s0, s1, 0x3f717273
// GFX12: s_and_b32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x00,0x8b,0x73,0x72,0x71,0x3f]

s_and_b32 s0, s1, 0xaf123456
// GFX12: s_and_b32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x00,0x8b,0x56,0x34,0x12,0xaf]

s_and_b32 s0, s1, null
// GFX12: s_and_b32 s0, s1, null                  ; encoding: [0x01,0x7c,0x00,0x8b]

s_and_b32 s0, null, s2
// GFX12: s_and_b32 s0, null, s2                  ; encoding: [0x7c,0x02,0x00,0x8b]

s_and_b32 null, s1, s2
// GFX12: s_and_b32 null, s1, s2                  ; encoding: [0x01,0x02,0x7c,0x8b]

s_and_b64 s[0:1], s[2:3], s[4:5]
// GFX12: s_and_b64 s[0:1], s[2:3], s[4:5]        ; encoding: [0x02,0x04,0x80,0x8b]

s_and_b64 s[104:105], s[102:103], s[100:101]
// GFX12: s_and_b64 s[104:105], s[102:103], s[100:101] ; encoding: [0x66,0x64,0xe8,0x8b]

s_and_b64 s[0:1], s[102:103], s[100:101]
// GFX12: s_and_b64 s[0:1], s[102:103], s[100:101] ; encoding: [0x66,0x64,0x80,0x8b]

s_and_b64 s[104:105], s[2:3], s[100:101]
// GFX12: s_and_b64 s[104:105], s[2:3], s[100:101] ; encoding: [0x02,0x64,0xe8,0x8b]

s_and_b64 s[104:105], s[102:103], s[4:5]
// GFX12: s_and_b64 s[104:105], s[102:103], s[4:5] ; encoding: [0x66,0x04,0xe8,0x8b]

s_and_b64 s[104:105], s[2:3], s[4:5]
// GFX12: s_and_b64 s[104:105], s[2:3], s[4:5]    ; encoding: [0x02,0x04,0xe8,0x8b]

s_and_b64 s[0:1], s[102:103], s[4:5]
// GFX12: s_and_b64 s[0:1], s[102:103], s[4:5]    ; encoding: [0x66,0x04,0x80,0x8b]

s_and_b64 s[0:1], s[2:3], s[100:101]
// GFX12: s_and_b64 s[0:1], s[2:3], s[100:101]    ; encoding: [0x02,0x64,0x80,0x8b]

s_and_b64 exec, s[2:3], s[4:5]
// GFX12: s_and_b64 exec, s[2:3], s[4:5]          ; encoding: [0x02,0x04,0xfe,0x8b]

s_and_b64 vcc, s[2:3], s[4:5]
// GFX12: s_and_b64 vcc, s[2:3], s[4:5]           ; encoding: [0x02,0x04,0xea,0x8b]

s_and_b64 s[0:1], exec, s[4:5]
// GFX12: s_and_b64 s[0:1], exec, s[4:5]          ; encoding: [0x7e,0x04,0x80,0x8b]

s_and_b64 s[0:1], vcc, s[4:5]
// GFX12: s_and_b64 s[0:1], vcc, s[4:5]           ; encoding: [0x6a,0x04,0x80,0x8b]

s_and_b64 s[0:1], 0, s[4:5]
// GFX12: s_and_b64 s[0:1], 0, s[4:5]             ; encoding: [0x80,0x04,0x80,0x8b]

s_and_b64 s[0:1], -1, s[4:5]
// GFX12: s_and_b64 s[0:1], -1, s[4:5]            ; encoding: [0xc1,0x04,0x80,0x8b]

s_and_b64 s[0:1], 0.5, s[4:5]
// GFX12: s_and_b64 s[0:1], 0.5, s[4:5]           ; encoding: [0xf0,0x04,0x80,0x8b]

s_and_b64 s[0:1], -4.0, s[4:5]
// GFX12: s_and_b64 s[0:1], -4.0, s[4:5]          ; encoding: [0xf7,0x04,0x80,0x8b]

s_and_b64 s[0:1], 0x3f717273, s[4:5]
// GFX12: s_and_b64 s[0:1], 0x3f717273, s[4:5]    ; encoding: [0xff,0x04,0x80,0x8b,0x73,0x72,0x71,0x3f]

s_and_b64 s[0:1], 0xaf123456, s[4:5]
// GFX12: s_and_b64 s[0:1], 0xaf123456, s[4:5]    ; encoding: [0xff,0x04,0x80,0x8b,0x56,0x34,0x12,0xaf]

s_and_b64 s[0:1], s[2:3], exec
// GFX12: s_and_b64 s[0:1], s[2:3], exec          ; encoding: [0x02,0x7e,0x80,0x8b]

s_and_b64 s[0:1], s[2:3], vcc
// GFX12: s_and_b64 s[0:1], s[2:3], vcc           ; encoding: [0x02,0x6a,0x80,0x8b]

s_and_b64 s[0:1], s[2:3], 0
// GFX12: s_and_b64 s[0:1], s[2:3], 0             ; encoding: [0x02,0x80,0x80,0x8b]

s_and_b64 s[0:1], s[2:3], -1
// GFX12: s_and_b64 s[0:1], s[2:3], -1            ; encoding: [0x02,0xc1,0x80,0x8b]

s_and_b64 s[0:1], s[2:3], 0.5
// GFX12: s_and_b64 s[0:1], s[2:3], 0.5           ; encoding: [0x02,0xf0,0x80,0x8b]

s_and_b64 s[0:1], s[2:3], -4.0
// GFX12: s_and_b64 s[0:1], s[2:3], -4.0          ; encoding: [0x02,0xf7,0x80,0x8b]

s_and_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_and_b64 s[0:1], s[2:3], 0x3f717273    ; encoding: [0x02,0xff,0x80,0x8b,0x73,0x72,0x71,0x3f]

s_and_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_and_b64 s[0:1], s[2:3], 0xaf123456    ; encoding: [0x02,0xff,0x80,0x8b,0x56,0x34,0x12,0xaf]

s_or_b32 s0, s1, s2
// GFX12: s_or_b32 s0, s1, s2                     ; encoding: [0x01,0x02,0x00,0x8c]

s_or_b32 s105, s104, s103
// GFX12: s_or_b32 s105, s104, s103               ; encoding: [0x68,0x67,0x69,0x8c]

s_or_b32 s0, s104, s103
// GFX12: s_or_b32 s0, s104, s103                 ; encoding: [0x68,0x67,0x00,0x8c]

s_or_b32 s105, s1, s103
// GFX12: s_or_b32 s105, s1, s103                 ; encoding: [0x01,0x67,0x69,0x8c]

s_or_b32 s105, s104, s2
// GFX12: s_or_b32 s105, s104, s2                 ; encoding: [0x68,0x02,0x69,0x8c]

s_or_b32 s105, s1, s2
// GFX12: s_or_b32 s105, s1, s2                   ; encoding: [0x01,0x02,0x69,0x8c]

s_or_b32 s0, s104, s2
// GFX12: s_or_b32 s0, s104, s2                   ; encoding: [0x68,0x02,0x00,0x8c]

s_or_b32 s0, s1, s103
// GFX12: s_or_b32 s0, s1, s103                   ; encoding: [0x01,0x67,0x00,0x8c]

s_or_b32 exec_lo, s1, s2
// GFX12: s_or_b32 exec_lo, s1, s2                ; encoding: [0x01,0x02,0x7e,0x8c]

s_or_b32 exec_hi, s1, s2
// GFX12: s_or_b32 exec_hi, s1, s2                ; encoding: [0x01,0x02,0x7f,0x8c]

s_or_b32 vcc_lo, s1, s2
// GFX12: s_or_b32 vcc_lo, s1, s2                 ; encoding: [0x01,0x02,0x6a,0x8c]

s_or_b32 vcc_hi, s1, s2
// GFX12: s_or_b32 vcc_hi, s1, s2                 ; encoding: [0x01,0x02,0x6b,0x8c]

s_or_b32 m0, s1, s2
// GFX12: s_or_b32 m0, s1, s2                     ; encoding: [0x01,0x02,0x7d,0x8c]

s_or_b32 s0, exec_lo, s2
// GFX12: s_or_b32 s0, exec_lo, s2                ; encoding: [0x7e,0x02,0x00,0x8c]

s_or_b32 s0, exec_hi, s2
// GFX12: s_or_b32 s0, exec_hi, s2                ; encoding: [0x7f,0x02,0x00,0x8c]

s_or_b32 s0, vcc_lo, s2
// GFX12: s_or_b32 s0, vcc_lo, s2                 ; encoding: [0x6a,0x02,0x00,0x8c]

s_or_b32 s0, vcc_hi, s2
// GFX12: s_or_b32 s0, vcc_hi, s2                 ; encoding: [0x6b,0x02,0x00,0x8c]

s_or_b32 s0, m0, s2
// GFX12: s_or_b32 s0, m0, s2                     ; encoding: [0x7d,0x02,0x00,0x8c]

s_or_b32 s0, 0, s2
// GFX12: s_or_b32 s0, 0, s2                      ; encoding: [0x80,0x02,0x00,0x8c]

s_or_b32 s0, -1, s2
// GFX12: s_or_b32 s0, -1, s2                     ; encoding: [0xc1,0x02,0x00,0x8c]

s_or_b32 s0, 0.5, s2
// GFX12: s_or_b32 s0, 0.5, s2                    ; encoding: [0xf0,0x02,0x00,0x8c]

s_or_b32 s0, -4.0, s2
// GFX12: s_or_b32 s0, -4.0, s2                   ; encoding: [0xf7,0x02,0x00,0x8c]

s_or_b32 s0, 0x3f717273, s2
// GFX12: s_or_b32 s0, 0x3f717273, s2             ; encoding: [0xff,0x02,0x00,0x8c,0x73,0x72,0x71,0x3f]

s_or_b32 s0, 0xaf123456, s2
// GFX12: s_or_b32 s0, 0xaf123456, s2             ; encoding: [0xff,0x02,0x00,0x8c,0x56,0x34,0x12,0xaf]

s_or_b32 s0, s1, exec_lo
// GFX12: s_or_b32 s0, s1, exec_lo                ; encoding: [0x01,0x7e,0x00,0x8c]

s_or_b32 s0, s1, exec_hi
// GFX12: s_or_b32 s0, s1, exec_hi                ; encoding: [0x01,0x7f,0x00,0x8c]

s_or_b32 s0, s1, vcc_lo
// GFX12: s_or_b32 s0, s1, vcc_lo                 ; encoding: [0x01,0x6a,0x00,0x8c]

s_or_b32 s0, s1, vcc_hi
// GFX12: s_or_b32 s0, s1, vcc_hi                 ; encoding: [0x01,0x6b,0x00,0x8c]

s_or_b32 s0, s1, m0
// GFX12: s_or_b32 s0, s1, m0                     ; encoding: [0x01,0x7d,0x00,0x8c]

s_or_b32 s0, s1, 0
// GFX12: s_or_b32 s0, s1, 0                      ; encoding: [0x01,0x80,0x00,0x8c]

s_or_b32 s0, s1, -1
// GFX12: s_or_b32 s0, s1, -1                     ; encoding: [0x01,0xc1,0x00,0x8c]

s_or_b32 s0, s1, 0.5
// GFX12: s_or_b32 s0, s1, 0.5                    ; encoding: [0x01,0xf0,0x00,0x8c]

s_or_b32 s0, s1, -4.0
// GFX12: s_or_b32 s0, s1, -4.0                   ; encoding: [0x01,0xf7,0x00,0x8c]

s_or_b32 s0, s1, 0x3f717273
// GFX12: s_or_b32 s0, s1, 0x3f717273             ; encoding: [0x01,0xff,0x00,0x8c,0x73,0x72,0x71,0x3f]

s_or_b32 s0, s1, 0xaf123456
// GFX12: s_or_b32 s0, s1, 0xaf123456             ; encoding: [0x01,0xff,0x00,0x8c,0x56,0x34,0x12,0xaf]

s_or_b64 s[0:1], s[2:3], s[4:5]
// GFX12: s_or_b64 s[0:1], s[2:3], s[4:5]         ; encoding: [0x02,0x04,0x80,0x8c]

s_or_b64 s[104:105], s[102:103], s[100:101]
// GFX12: s_or_b64 s[104:105], s[102:103], s[100:101] ; encoding: [0x66,0x64,0xe8,0x8c]

s_or_b64 s[0:1], s[102:103], s[100:101]
// GFX12: s_or_b64 s[0:1], s[102:103], s[100:101] ; encoding: [0x66,0x64,0x80,0x8c]

s_or_b64 s[104:105], s[2:3], s[100:101]
// GFX12: s_or_b64 s[104:105], s[2:3], s[100:101] ; encoding: [0x02,0x64,0xe8,0x8c]

s_or_b64 s[104:105], s[102:103], s[4:5]
// GFX12: s_or_b64 s[104:105], s[102:103], s[4:5] ; encoding: [0x66,0x04,0xe8,0x8c]

s_or_b64 s[104:105], s[2:3], s[4:5]
// GFX12: s_or_b64 s[104:105], s[2:3], s[4:5]     ; encoding: [0x02,0x04,0xe8,0x8c]

s_or_b64 s[0:1], s[102:103], s[4:5]
// GFX12: s_or_b64 s[0:1], s[102:103], s[4:5]     ; encoding: [0x66,0x04,0x80,0x8c]

s_or_b64 s[0:1], s[2:3], s[100:101]
// GFX12: s_or_b64 s[0:1], s[2:3], s[100:101]     ; encoding: [0x02,0x64,0x80,0x8c]

s_or_b64 exec, s[2:3], s[4:5]
// GFX12: s_or_b64 exec, s[2:3], s[4:5]           ; encoding: [0x02,0x04,0xfe,0x8c]

s_or_b64 vcc, s[2:3], s[4:5]
// GFX12: s_or_b64 vcc, s[2:3], s[4:5]            ; encoding: [0x02,0x04,0xea,0x8c]

s_or_b64 s[0:1], exec, s[4:5]
// GFX12: s_or_b64 s[0:1], exec, s[4:5]           ; encoding: [0x7e,0x04,0x80,0x8c]

s_or_b64 s[0:1], vcc, s[4:5]
// GFX12: s_or_b64 s[0:1], vcc, s[4:5]            ; encoding: [0x6a,0x04,0x80,0x8c]

s_or_b64 s[0:1], 0, s[4:5]
// GFX12: s_or_b64 s[0:1], 0, s[4:5]              ; encoding: [0x80,0x04,0x80,0x8c]

s_or_b64 s[0:1], -1, s[4:5]
// GFX12: s_or_b64 s[0:1], -1, s[4:5]             ; encoding: [0xc1,0x04,0x80,0x8c]

s_or_b64 s[0:1], 0.5, s[4:5]
// GFX12: s_or_b64 s[0:1], 0.5, s[4:5]            ; encoding: [0xf0,0x04,0x80,0x8c]

s_or_b64 s[0:1], -4.0, s[4:5]
// GFX12: s_or_b64 s[0:1], -4.0, s[4:5]           ; encoding: [0xf7,0x04,0x80,0x8c]

s_or_b64 s[0:1], 0x3f717273, s[4:5]
// GFX12: s_or_b64 s[0:1], 0x3f717273, s[4:5]     ; encoding: [0xff,0x04,0x80,0x8c,0x73,0x72,0x71,0x3f]

s_or_b64 s[0:1], 0xaf123456, s[4:5]
// GFX12: s_or_b64 s[0:1], 0xaf123456, s[4:5]     ; encoding: [0xff,0x04,0x80,0x8c,0x56,0x34,0x12,0xaf]

s_or_b64 s[0:1], s[2:3], exec
// GFX12: s_or_b64 s[0:1], s[2:3], exec           ; encoding: [0x02,0x7e,0x80,0x8c]

s_or_b64 s[0:1], s[2:3], vcc
// GFX12: s_or_b64 s[0:1], s[2:3], vcc            ; encoding: [0x02,0x6a,0x80,0x8c]

s_or_b64 s[0:1], s[2:3], 0
// GFX12: s_or_b64 s[0:1], s[2:3], 0              ; encoding: [0x02,0x80,0x80,0x8c]

s_or_b64 s[0:1], s[2:3], -1
// GFX12: s_or_b64 s[0:1], s[2:3], -1             ; encoding: [0x02,0xc1,0x80,0x8c]

s_or_b64 s[0:1], s[2:3], 0.5
// GFX12: s_or_b64 s[0:1], s[2:3], 0.5            ; encoding: [0x02,0xf0,0x80,0x8c]

s_or_b64 s[0:1], s[2:3], -4.0
// GFX12: s_or_b64 s[0:1], s[2:3], -4.0           ; encoding: [0x02,0xf7,0x80,0x8c]

s_or_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_or_b64 s[0:1], s[2:3], 0x3f717273     ; encoding: [0x02,0xff,0x80,0x8c,0x73,0x72,0x71,0x3f]

s_or_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_or_b64 s[0:1], s[2:3], 0xaf123456     ; encoding: [0x02,0xff,0x80,0x8c,0x56,0x34,0x12,0xaf]

s_xor_b32 s0, s1, s2
// GFX12: s_xor_b32 s0, s1, s2                    ; encoding: [0x01,0x02,0x00,0x8d]

s_xor_b32 s105, s104, s103
// GFX12: s_xor_b32 s105, s104, s103              ; encoding: [0x68,0x67,0x69,0x8d]

s_xor_b32 s0, s104, s103
// GFX12: s_xor_b32 s0, s104, s103                ; encoding: [0x68,0x67,0x00,0x8d]

s_xor_b32 s105, s1, s103
// GFX12: s_xor_b32 s105, s1, s103                ; encoding: [0x01,0x67,0x69,0x8d]

s_xor_b32 s105, s104, s2
// GFX12: s_xor_b32 s105, s104, s2                ; encoding: [0x68,0x02,0x69,0x8d]

s_xor_b32 s105, s1, s2
// GFX12: s_xor_b32 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0x8d]

s_xor_b32 s0, s104, s2
// GFX12: s_xor_b32 s0, s104, s2                  ; encoding: [0x68,0x02,0x00,0x8d]

s_xor_b32 s0, s1, s103
// GFX12: s_xor_b32 s0, s1, s103                  ; encoding: [0x01,0x67,0x00,0x8d]

s_xor_b32 exec_lo, s1, s2
// GFX12: s_xor_b32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0x7e,0x8d]

s_xor_b32 exec_hi, s1, s2
// GFX12: s_xor_b32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0x7f,0x8d]

s_xor_b32 vcc_lo, s1, s2
// GFX12: s_xor_b32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0x6a,0x8d]

s_xor_b32 vcc_hi, s1, s2
// GFX12: s_xor_b32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0x6b,0x8d]

s_xor_b32 m0, s1, s2
// GFX12: s_xor_b32 m0, s1, s2                    ; encoding: [0x01,0x02,0x7d,0x8d]

s_xor_b32 s0, exec_lo, s2
// GFX12: s_xor_b32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x00,0x8d]

s_xor_b32 s0, exec_hi, s2
// GFX12: s_xor_b32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x00,0x8d]

s_xor_b32 s0, vcc_lo, s2
// GFX12: s_xor_b32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x00,0x8d]

s_xor_b32 s0, vcc_hi, s2
// GFX12: s_xor_b32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x00,0x8d]

s_xor_b32 s0, m0, s2
// GFX12: s_xor_b32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x00,0x8d]

s_xor_b32 s0, 0, s2
// GFX12: s_xor_b32 s0, 0, s2                     ; encoding: [0x80,0x02,0x00,0x8d]

s_xor_b32 s0, -1, s2
// GFX12: s_xor_b32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x00,0x8d]

s_xor_b32 s0, 0.5, s2
// GFX12: s_xor_b32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x00,0x8d]

s_xor_b32 s0, -4.0, s2
// GFX12: s_xor_b32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x00,0x8d]

s_xor_b32 s0, 0x3f717273, s2
// GFX12: s_xor_b32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x00,0x8d,0x73,0x72,0x71,0x3f]

s_xor_b32 s0, 0xaf123456, s2
// GFX12: s_xor_b32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x00,0x8d,0x56,0x34,0x12,0xaf]

s_xor_b32 s0, s1, exec_lo
// GFX12: s_xor_b32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x00,0x8d]

s_xor_b32 s0, s1, exec_hi
// GFX12: s_xor_b32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x00,0x8d]

s_xor_b32 s0, s1, vcc_lo
// GFX12: s_xor_b32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x00,0x8d]

s_xor_b32 s0, s1, vcc_hi
// GFX12: s_xor_b32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x00,0x8d]

s_xor_b32 s0, s1, m0
// GFX12: s_xor_b32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x00,0x8d]

s_xor_b32 s0, s1, 0
// GFX12: s_xor_b32 s0, s1, 0                     ; encoding: [0x01,0x80,0x00,0x8d]

s_xor_b32 s0, s1, -1
// GFX12: s_xor_b32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x00,0x8d]

s_xor_b32 s0, s1, 0.5
// GFX12: s_xor_b32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x00,0x8d]

s_xor_b32 s0, s1, -4.0
// GFX12: s_xor_b32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x00,0x8d]

s_xor_b32 s0, s1, 0x3f717273
// GFX12: s_xor_b32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x00,0x8d,0x73,0x72,0x71,0x3f]

s_xor_b32 s0, s1, 0xaf123456
// GFX12: s_xor_b32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x00,0x8d,0x56,0x34,0x12,0xaf]

s_xor_b64 s[0:1], s[2:3], s[4:5]
// GFX12: s_xor_b64 s[0:1], s[2:3], s[4:5]        ; encoding: [0x02,0x04,0x80,0x8d]

s_xor_b64 s[104:105], s[102:103], s[100:101]
// GFX12: s_xor_b64 s[104:105], s[102:103], s[100:101] ; encoding: [0x66,0x64,0xe8,0x8d]

s_xor_b64 s[0:1], s[102:103], s[100:101]
// GFX12: s_xor_b64 s[0:1], s[102:103], s[100:101] ; encoding: [0x66,0x64,0x80,0x8d]

s_xor_b64 s[104:105], s[2:3], s[100:101]
// GFX12: s_xor_b64 s[104:105], s[2:3], s[100:101] ; encoding: [0x02,0x64,0xe8,0x8d]

s_xor_b64 s[104:105], s[102:103], s[4:5]
// GFX12: s_xor_b64 s[104:105], s[102:103], s[4:5] ; encoding: [0x66,0x04,0xe8,0x8d]

s_xor_b64 s[104:105], s[2:3], s[4:5]
// GFX12: s_xor_b64 s[104:105], s[2:3], s[4:5]    ; encoding: [0x02,0x04,0xe8,0x8d]

s_xor_b64 s[0:1], s[102:103], s[4:5]
// GFX12: s_xor_b64 s[0:1], s[102:103], s[4:5]    ; encoding: [0x66,0x04,0x80,0x8d]

s_xor_b64 s[0:1], s[2:3], s[100:101]
// GFX12: s_xor_b64 s[0:1], s[2:3], s[100:101]    ; encoding: [0x02,0x64,0x80,0x8d]

s_xor_b64 exec, s[2:3], s[4:5]
// GFX12: s_xor_b64 exec, s[2:3], s[4:5]          ; encoding: [0x02,0x04,0xfe,0x8d]

s_xor_b64 vcc, s[2:3], s[4:5]
// GFX12: s_xor_b64 vcc, s[2:3], s[4:5]           ; encoding: [0x02,0x04,0xea,0x8d]

s_xor_b64 s[0:1], exec, s[4:5]
// GFX12: s_xor_b64 s[0:1], exec, s[4:5]          ; encoding: [0x7e,0x04,0x80,0x8d]

s_xor_b64 s[0:1], vcc, s[4:5]
// GFX12: s_xor_b64 s[0:1], vcc, s[4:5]           ; encoding: [0x6a,0x04,0x80,0x8d]

s_xor_b64 s[0:1], 0, s[4:5]
// GFX12: s_xor_b64 s[0:1], 0, s[4:5]             ; encoding: [0x80,0x04,0x80,0x8d]

s_xor_b64 s[0:1], -1, s[4:5]
// GFX12: s_xor_b64 s[0:1], -1, s[4:5]            ; encoding: [0xc1,0x04,0x80,0x8d]

s_xor_b64 s[0:1], 0.5, s[4:5]
// GFX12: s_xor_b64 s[0:1], 0.5, s[4:5]           ; encoding: [0xf0,0x04,0x80,0x8d]

s_xor_b64 s[0:1], -4.0, s[4:5]
// GFX12: s_xor_b64 s[0:1], -4.0, s[4:5]          ; encoding: [0xf7,0x04,0x80,0x8d]

s_xor_b64 s[0:1], 0x3f717273, s[4:5]
// GFX12: s_xor_b64 s[0:1], 0x3f717273, s[4:5]    ; encoding: [0xff,0x04,0x80,0x8d,0x73,0x72,0x71,0x3f]

s_xor_b64 s[0:1], 0xaf123456, s[4:5]
// GFX12: s_xor_b64 s[0:1], 0xaf123456, s[4:5]    ; encoding: [0xff,0x04,0x80,0x8d,0x56,0x34,0x12,0xaf]

s_xor_b64 s[0:1], s[2:3], exec
// GFX12: s_xor_b64 s[0:1], s[2:3], exec          ; encoding: [0x02,0x7e,0x80,0x8d]

s_xor_b64 s[0:1], s[2:3], vcc
// GFX12: s_xor_b64 s[0:1], s[2:3], vcc           ; encoding: [0x02,0x6a,0x80,0x8d]

s_xor_b64 s[0:1], s[2:3], 0
// GFX12: s_xor_b64 s[0:1], s[2:3], 0             ; encoding: [0x02,0x80,0x80,0x8d]

s_xor_b64 s[0:1], s[2:3], -1
// GFX12: s_xor_b64 s[0:1], s[2:3], -1            ; encoding: [0x02,0xc1,0x80,0x8d]

s_xor_b64 s[0:1], s[2:3], 0.5
// GFX12: s_xor_b64 s[0:1], s[2:3], 0.5           ; encoding: [0x02,0xf0,0x80,0x8d]

s_xor_b64 s[0:1], s[2:3], -4.0
// GFX12: s_xor_b64 s[0:1], s[2:3], -4.0          ; encoding: [0x02,0xf7,0x80,0x8d]

s_xor_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_xor_b64 s[0:1], s[2:3], 0x3f717273    ; encoding: [0x02,0xff,0x80,0x8d,0x73,0x72,0x71,0x3f]

s_xor_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_xor_b64 s[0:1], s[2:3], 0xaf123456    ; encoding: [0x02,0xff,0x80,0x8d,0x56,0x34,0x12,0xaf]

s_andn2_b32 s0, s1, s2
// GFX12: s_and_not1_b32 s0, s1, s2               ; encoding: [0x01,0x02,0x00,0x91]

s_andn2_b32 s105, s104, s103
// GFX12: s_and_not1_b32 s105, s104, s103         ; encoding: [0x68,0x67,0x69,0x91]

s_andn2_b32 s0, s104, s103
// GFX12: s_and_not1_b32 s0, s104, s103           ; encoding: [0x68,0x67,0x00,0x91]

s_andn2_b32 s105, s1, s103
// GFX12: s_and_not1_b32 s105, s1, s103           ; encoding: [0x01,0x67,0x69,0x91]

s_andn2_b32 s105, s104, s2
// GFX12: s_and_not1_b32 s105, s104, s2           ; encoding: [0x68,0x02,0x69,0x91]

s_andn2_b32 s105, s1, s2
// GFX12: s_and_not1_b32 s105, s1, s2             ; encoding: [0x01,0x02,0x69,0x91]

s_andn2_b32 s0, s104, s2
// GFX12: s_and_not1_b32 s0, s104, s2             ; encoding: [0x68,0x02,0x00,0x91]

s_andn2_b32 s0, s1, s103
// GFX12: s_and_not1_b32 s0, s1, s103             ; encoding: [0x01,0x67,0x00,0x91]

s_andn2_b32 exec_lo, s1, s2
// GFX12: s_and_not1_b32 exec_lo, s1, s2          ; encoding: [0x01,0x02,0x7e,0x91]

s_andn2_b32 exec_hi, s1, s2
// GFX12: s_and_not1_b32 exec_hi, s1, s2          ; encoding: [0x01,0x02,0x7f,0x91]

s_andn2_b32 vcc_lo, s1, s2
// GFX12: s_and_not1_b32 vcc_lo, s1, s2           ; encoding: [0x01,0x02,0x6a,0x91]

s_andn2_b32 vcc_hi, s1, s2
// GFX12: s_and_not1_b32 vcc_hi, s1, s2           ; encoding: [0x01,0x02,0x6b,0x91]

s_andn2_b32 m0, s1, s2
// GFX12: s_and_not1_b32 m0, s1, s2               ; encoding: [0x01,0x02,0x7d,0x91]

s_andn2_b32 s0, exec_lo, s2
// GFX12: s_and_not1_b32 s0, exec_lo, s2          ; encoding: [0x7e,0x02,0x00,0x91]

s_andn2_b32 s0, exec_hi, s2
// GFX12: s_and_not1_b32 s0, exec_hi, s2          ; encoding: [0x7f,0x02,0x00,0x91]

s_andn2_b32 s0, vcc_lo, s2
// GFX12: s_and_not1_b32 s0, vcc_lo, s2           ; encoding: [0x6a,0x02,0x00,0x91]

s_andn2_b32 s0, vcc_hi, s2
// GFX12: s_and_not1_b32 s0, vcc_hi, s2           ; encoding: [0x6b,0x02,0x00,0x91]

s_andn2_b32 s0, m0, s2
// GFX12: s_and_not1_b32 s0, m0, s2               ; encoding: [0x7d,0x02,0x00,0x91]

s_andn2_b32 s0, 0, s2
// GFX12: s_and_not1_b32 s0, 0, s2                ; encoding: [0x80,0x02,0x00,0x91]

s_andn2_b32 s0, -1, s2
// GFX12: s_and_not1_b32 s0, -1, s2               ; encoding: [0xc1,0x02,0x00,0x91]

s_andn2_b32 s0, 0.5, s2
// GFX12: s_and_not1_b32 s0, 0.5, s2              ; encoding: [0xf0,0x02,0x00,0x91]

s_andn2_b32 s0, -4.0, s2
// GFX12: s_and_not1_b32 s0, -4.0, s2             ; encoding: [0xf7,0x02,0x00,0x91]

s_andn2_b32 s0, 0x3f717273, s2
// GFX12: s_and_not1_b32 s0, 0x3f717273, s2       ; encoding: [0xff,0x02,0x00,0x91,0x73,0x72,0x71,0x3f]

s_andn2_b32 s0, 0xaf123456, s2
// GFX12: s_and_not1_b32 s0, 0xaf123456, s2       ; encoding: [0xff,0x02,0x00,0x91,0x56,0x34,0x12,0xaf]

s_andn2_b32 s0, s1, exec_lo
// GFX12: s_and_not1_b32 s0, s1, exec_lo          ; encoding: [0x01,0x7e,0x00,0x91]

s_andn2_b32 s0, s1, exec_hi
// GFX12: s_and_not1_b32 s0, s1, exec_hi          ; encoding: [0x01,0x7f,0x00,0x91]

s_andn2_b32 s0, s1, vcc_lo
// GFX12: s_and_not1_b32 s0, s1, vcc_lo           ; encoding: [0x01,0x6a,0x00,0x91]

s_andn2_b32 s0, s1, vcc_hi
// GFX12: s_and_not1_b32 s0, s1, vcc_hi           ; encoding: [0x01,0x6b,0x00,0x91]

s_andn2_b32 s0, s1, m0
// GFX12: s_and_not1_b32 s0, s1, m0               ; encoding: [0x01,0x7d,0x00,0x91]

s_andn2_b32 s0, s1, 0
// GFX12: s_and_not1_b32 s0, s1, 0                ; encoding: [0x01,0x80,0x00,0x91]

s_andn2_b32 s0, s1, -1
// GFX12: s_and_not1_b32 s0, s1, -1               ; encoding: [0x01,0xc1,0x00,0x91]

s_andn2_b32 s0, s1, 0.5
// GFX12: s_and_not1_b32 s0, s1, 0.5              ; encoding: [0x01,0xf0,0x00,0x91]

s_andn2_b32 s0, s1, -4.0
// GFX12: s_and_not1_b32 s0, s1, -4.0             ; encoding: [0x01,0xf7,0x00,0x91]

s_andn2_b32 s0, s1, 0x3f717273
// GFX12: s_and_not1_b32 s0, s1, 0x3f717273       ; encoding: [0x01,0xff,0x00,0x91,0x73,0x72,0x71,0x3f]

s_andn2_b32 s0, s1, 0xaf123456
// GFX12: s_and_not1_b32 s0, s1, 0xaf123456       ; encoding: [0x01,0xff,0x00,0x91,0x56,0x34,0x12,0xaf]

s_andn2_b64 s[0:1], s[2:3], s[4:5]
// GFX12: s_and_not1_b64 s[0:1], s[2:3], s[4:5]   ; encoding: [0x02,0x04,0x80,0x91]

s_andn2_b64 s[104:105], s[102:103], s[100:101]
// GFX12: s_and_not1_b64 s[104:105], s[102:103], s[100:101] ; encoding: [0x66,0x64,0xe8,0x91]

s_andn2_b64 s[0:1], s[102:103], s[100:101]
// GFX12: s_and_not1_b64 s[0:1], s[102:103], s[100:101] ; encoding: [0x66,0x64,0x80,0x91]

s_andn2_b64 s[104:105], s[2:3], s[100:101]
// GFX12: s_and_not1_b64 s[104:105], s[2:3], s[100:101] ; encoding: [0x02,0x64,0xe8,0x91]

s_andn2_b64 s[104:105], s[102:103], s[4:5]
// GFX12: s_and_not1_b64 s[104:105], s[102:103], s[4:5] ; encoding: [0x66,0x04,0xe8,0x91]

s_andn2_b64 s[104:105], s[2:3], s[4:5]
// GFX12: s_and_not1_b64 s[104:105], s[2:3], s[4:5] ; encoding: [0x02,0x04,0xe8,0x91]

s_andn2_b64 s[0:1], s[102:103], s[4:5]
// GFX12: s_and_not1_b64 s[0:1], s[102:103], s[4:5] ; encoding: [0x66,0x04,0x80,0x91]

s_andn2_b64 s[0:1], s[2:3], s[100:101]
// GFX12: s_and_not1_b64 s[0:1], s[2:3], s[100:101] ; encoding: [0x02,0x64,0x80,0x91]

s_andn2_b64 exec, s[2:3], s[4:5]
// GFX12: s_and_not1_b64 exec, s[2:3], s[4:5]     ; encoding: [0x02,0x04,0xfe,0x91]

s_andn2_b64 vcc, s[2:3], s[4:5]
// GFX12: s_and_not1_b64 vcc, s[2:3], s[4:5]      ; encoding: [0x02,0x04,0xea,0x91]

s_andn2_b64 s[0:1], exec, s[4:5]
// GFX12: s_and_not1_b64 s[0:1], exec, s[4:5]     ; encoding: [0x7e,0x04,0x80,0x91]

s_andn2_b64 s[0:1], vcc, s[4:5]
// GFX12: s_and_not1_b64 s[0:1], vcc, s[4:5]      ; encoding: [0x6a,0x04,0x80,0x91]

s_andn2_b64 s[0:1], 0, s[4:5]
// GFX12: s_and_not1_b64 s[0:1], 0, s[4:5]        ; encoding: [0x80,0x04,0x80,0x91]

s_andn2_b64 s[0:1], -1, s[4:5]
// GFX12: s_and_not1_b64 s[0:1], -1, s[4:5]       ; encoding: [0xc1,0x04,0x80,0x91]

s_andn2_b64 s[0:1], 0.5, s[4:5]
// GFX12: s_and_not1_b64 s[0:1], 0.5, s[4:5]      ; encoding: [0xf0,0x04,0x80,0x91]

s_andn2_b64 s[0:1], -4.0, s[4:5]
// GFX12: s_and_not1_b64 s[0:1], -4.0, s[4:5]     ; encoding: [0xf7,0x04,0x80,0x91]

s_andn2_b64 s[0:1], 0x3f717273, s[4:5]
// GFX12: s_and_not1_b64 s[0:1], 0x3f717273, s[4:5] ; encoding: [0xff,0x04,0x80,0x91,0x73,0x72,0x71,0x3f]

s_andn2_b64 s[0:1], 0xaf123456, s[4:5]
// GFX12: s_and_not1_b64 s[0:1], 0xaf123456, s[4:5] ; encoding: [0xff,0x04,0x80,0x91,0x56,0x34,0x12,0xaf]

s_andn2_b64 s[0:1], s[2:3], exec
// GFX12: s_and_not1_b64 s[0:1], s[2:3], exec     ; encoding: [0x02,0x7e,0x80,0x91]

s_andn2_b64 s[0:1], s[2:3], vcc
// GFX12: s_and_not1_b64 s[0:1], s[2:3], vcc      ; encoding: [0x02,0x6a,0x80,0x91]

s_andn2_b64 s[0:1], s[2:3], 0
// GFX12: s_and_not1_b64 s[0:1], s[2:3], 0        ; encoding: [0x02,0x80,0x80,0x91]

s_andn2_b64 s[0:1], s[2:3], -1
// GFX12: s_and_not1_b64 s[0:1], s[2:3], -1       ; encoding: [0x02,0xc1,0x80,0x91]

s_andn2_b64 s[0:1], s[2:3], 0.5
// GFX12: s_and_not1_b64 s[0:1], s[2:3], 0.5      ; encoding: [0x02,0xf0,0x80,0x91]

s_andn2_b64 s[0:1], s[2:3], -4.0
// GFX12: s_and_not1_b64 s[0:1], s[2:3], -4.0     ; encoding: [0x02,0xf7,0x80,0x91]

s_andn2_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_and_not1_b64 s[0:1], s[2:3], 0x3f717273 ; encoding: [0x02,0xff,0x80,0x91,0x73,0x72,0x71,0x3f]

s_andn2_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_and_not1_b64 s[0:1], s[2:3], 0xaf123456 ; encoding: [0x02,0xff,0x80,0x91,0x56,0x34,0x12,0xaf]

s_orn2_b32 s0, s1, s2
// GFX12: s_or_not1_b32 s0, s1, s2                ; encoding: [0x01,0x02,0x00,0x92]

s_orn2_b32 s105, s104, s103
// GFX12: s_or_not1_b32 s105, s104, s103          ; encoding: [0x68,0x67,0x69,0x92]

s_orn2_b32 s0, s104, s103
// GFX12: s_or_not1_b32 s0, s104, s103            ; encoding: [0x68,0x67,0x00,0x92]

s_orn2_b32 s105, s1, s103
// GFX12: s_or_not1_b32 s105, s1, s103            ; encoding: [0x01,0x67,0x69,0x92]

s_orn2_b32 s105, s104, s2
// GFX12: s_or_not1_b32 s105, s104, s2            ; encoding: [0x68,0x02,0x69,0x92]

s_orn2_b32 s105, s1, s2
// GFX12: s_or_not1_b32 s105, s1, s2              ; encoding: [0x01,0x02,0x69,0x92]

s_orn2_b32 s0, s104, s2
// GFX12: s_or_not1_b32 s0, s104, s2              ; encoding: [0x68,0x02,0x00,0x92]

s_orn2_b32 s0, s1, s103
// GFX12: s_or_not1_b32 s0, s1, s103              ; encoding: [0x01,0x67,0x00,0x92]

s_orn2_b32 exec_lo, s1, s2
// GFX12: s_or_not1_b32 exec_lo, s1, s2           ; encoding: [0x01,0x02,0x7e,0x92]

s_orn2_b32 exec_hi, s1, s2
// GFX12: s_or_not1_b32 exec_hi, s1, s2           ; encoding: [0x01,0x02,0x7f,0x92]

s_orn2_b32 vcc_lo, s1, s2
// GFX12: s_or_not1_b32 vcc_lo, s1, s2            ; encoding: [0x01,0x02,0x6a,0x92]

s_orn2_b32 vcc_hi, s1, s2
// GFX12: s_or_not1_b32 vcc_hi, s1, s2            ; encoding: [0x01,0x02,0x6b,0x92]

s_orn2_b32 m0, s1, s2
// GFX12: s_or_not1_b32 m0, s1, s2                ; encoding: [0x01,0x02,0x7d,0x92]

s_orn2_b32 s0, exec_lo, s2
// GFX12: s_or_not1_b32 s0, exec_lo, s2           ; encoding: [0x7e,0x02,0x00,0x92]

s_orn2_b32 s0, exec_hi, s2
// GFX12: s_or_not1_b32 s0, exec_hi, s2           ; encoding: [0x7f,0x02,0x00,0x92]

s_orn2_b32 s0, vcc_lo, s2
// GFX12: s_or_not1_b32 s0, vcc_lo, s2            ; encoding: [0x6a,0x02,0x00,0x92]

s_orn2_b32 s0, vcc_hi, s2
// GFX12: s_or_not1_b32 s0, vcc_hi, s2            ; encoding: [0x6b,0x02,0x00,0x92]

s_orn2_b32 s0, m0, s2
// GFX12: s_or_not1_b32 s0, m0, s2                ; encoding: [0x7d,0x02,0x00,0x92]

s_orn2_b32 s0, 0, s2
// GFX12: s_or_not1_b32 s0, 0, s2                 ; encoding: [0x80,0x02,0x00,0x92]

s_orn2_b32 s0, -1, s2
// GFX12: s_or_not1_b32 s0, -1, s2                ; encoding: [0xc1,0x02,0x00,0x92]

s_orn2_b32 s0, 0.5, s2
// GFX12: s_or_not1_b32 s0, 0.5, s2               ; encoding: [0xf0,0x02,0x00,0x92]

s_orn2_b32 s0, -4.0, s2
// GFX12: s_or_not1_b32 s0, -4.0, s2              ; encoding: [0xf7,0x02,0x00,0x92]

s_orn2_b32 s0, 0x3f717273, s2
// GFX12: s_or_not1_b32 s0, 0x3f717273, s2        ; encoding: [0xff,0x02,0x00,0x92,0x73,0x72,0x71,0x3f]

s_orn2_b32 s0, 0xaf123456, s2
// GFX12: s_or_not1_b32 s0, 0xaf123456, s2        ; encoding: [0xff,0x02,0x00,0x92,0x56,0x34,0x12,0xaf]

s_orn2_b32 s0, s1, exec_lo
// GFX12: s_or_not1_b32 s0, s1, exec_lo           ; encoding: [0x01,0x7e,0x00,0x92]

s_orn2_b32 s0, s1, exec_hi
// GFX12: s_or_not1_b32 s0, s1, exec_hi           ; encoding: [0x01,0x7f,0x00,0x92]

s_orn2_b32 s0, s1, vcc_lo
// GFX12: s_or_not1_b32 s0, s1, vcc_lo            ; encoding: [0x01,0x6a,0x00,0x92]

s_orn2_b32 s0, s1, vcc_hi
// GFX12: s_or_not1_b32 s0, s1, vcc_hi            ; encoding: [0x01,0x6b,0x00,0x92]

s_orn2_b32 s0, s1, m0
// GFX12: s_or_not1_b32 s0, s1, m0                ; encoding: [0x01,0x7d,0x00,0x92]

s_orn2_b32 s0, s1, 0
// GFX12: s_or_not1_b32 s0, s1, 0                 ; encoding: [0x01,0x80,0x00,0x92]

s_orn2_b32 s0, s1, -1
// GFX12: s_or_not1_b32 s0, s1, -1                ; encoding: [0x01,0xc1,0x00,0x92]

s_orn2_b32 s0, s1, 0.5
// GFX12: s_or_not1_b32 s0, s1, 0.5               ; encoding: [0x01,0xf0,0x00,0x92]

s_orn2_b32 s0, s1, -4.0
// GFX12: s_or_not1_b32 s0, s1, -4.0              ; encoding: [0x01,0xf7,0x00,0x92]

s_orn2_b32 s0, s1, 0x3f717273
// GFX12: s_or_not1_b32 s0, s1, 0x3f717273        ; encoding: [0x01,0xff,0x00,0x92,0x73,0x72,0x71,0x3f]

s_orn2_b32 s0, s1, 0xaf123456
// GFX12: s_or_not1_b32 s0, s1, 0xaf123456        ; encoding: [0x01,0xff,0x00,0x92,0x56,0x34,0x12,0xaf]

s_orn2_b64 s[0:1], s[2:3], s[4:5]
// GFX12: s_or_not1_b64 s[0:1], s[2:3], s[4:5]    ; encoding: [0x02,0x04,0x80,0x92]

s_orn2_b64 s[104:105], s[102:103], s[100:101]
// GFX12: s_or_not1_b64 s[104:105], s[102:103], s[100:101] ; encoding: [0x66,0x64,0xe8,0x92]

s_orn2_b64 s[0:1], s[102:103], s[100:101]
// GFX12: s_or_not1_b64 s[0:1], s[102:103], s[100:101] ; encoding: [0x66,0x64,0x80,0x92]

s_orn2_b64 s[104:105], s[2:3], s[100:101]
// GFX12: s_or_not1_b64 s[104:105], s[2:3], s[100:101] ; encoding: [0x02,0x64,0xe8,0x92]

s_orn2_b64 s[104:105], s[102:103], s[4:5]
// GFX12: s_or_not1_b64 s[104:105], s[102:103], s[4:5] ; encoding: [0x66,0x04,0xe8,0x92]

s_orn2_b64 s[104:105], s[2:3], s[4:5]
// GFX12: s_or_not1_b64 s[104:105], s[2:3], s[4:5] ; encoding: [0x02,0x04,0xe8,0x92]

s_orn2_b64 s[0:1], s[102:103], s[4:5]
// GFX12: s_or_not1_b64 s[0:1], s[102:103], s[4:5] ; encoding: [0x66,0x04,0x80,0x92]

s_orn2_b64 s[0:1], s[2:3], s[100:101]
// GFX12: s_or_not1_b64 s[0:1], s[2:3], s[100:101] ; encoding: [0x02,0x64,0x80,0x92]

s_orn2_b64 exec, s[2:3], s[4:5]
// GFX12: s_or_not1_b64 exec, s[2:3], s[4:5]      ; encoding: [0x02,0x04,0xfe,0x92]

s_orn2_b64 vcc, s[2:3], s[4:5]
// GFX12: s_or_not1_b64 vcc, s[2:3], s[4:5]       ; encoding: [0x02,0x04,0xea,0x92]

s_orn2_b64 s[0:1], exec, s[4:5]
// GFX12: s_or_not1_b64 s[0:1], exec, s[4:5]      ; encoding: [0x7e,0x04,0x80,0x92]

s_orn2_b64 s[0:1], vcc, s[4:5]
// GFX12: s_or_not1_b64 s[0:1], vcc, s[4:5]       ; encoding: [0x6a,0x04,0x80,0x92]

s_orn2_b64 s[0:1], 0, s[4:5]
// GFX12: s_or_not1_b64 s[0:1], 0, s[4:5]         ; encoding: [0x80,0x04,0x80,0x92]

s_orn2_b64 s[0:1], -1, s[4:5]
// GFX12: s_or_not1_b64 s[0:1], -1, s[4:5]        ; encoding: [0xc1,0x04,0x80,0x92]

s_orn2_b64 s[0:1], 0.5, s[4:5]
// GFX12: s_or_not1_b64 s[0:1], 0.5, s[4:5]       ; encoding: [0xf0,0x04,0x80,0x92]

s_orn2_b64 s[0:1], -4.0, s[4:5]
// GFX12: s_or_not1_b64 s[0:1], -4.0, s[4:5]      ; encoding: [0xf7,0x04,0x80,0x92]

s_orn2_b64 s[0:1], 0x3f717273, s[4:5]
// GFX12: s_or_not1_b64 s[0:1], 0x3f717273, s[4:5] ; encoding: [0xff,0x04,0x80,0x92,0x73,0x72,0x71,0x3f]

s_orn2_b64 s[0:1], 0xaf123456, s[4:5]
// GFX12: s_or_not1_b64 s[0:1], 0xaf123456, s[4:5] ; encoding: [0xff,0x04,0x80,0x92,0x56,0x34,0x12,0xaf]

s_orn2_b64 s[0:1], s[2:3], exec
// GFX12: s_or_not1_b64 s[0:1], s[2:3], exec      ; encoding: [0x02,0x7e,0x80,0x92]

s_orn2_b64 s[0:1], s[2:3], vcc
// GFX12: s_or_not1_b64 s[0:1], s[2:3], vcc       ; encoding: [0x02,0x6a,0x80,0x92]

s_orn2_b64 s[0:1], s[2:3], 0
// GFX12: s_or_not1_b64 s[0:1], s[2:3], 0         ; encoding: [0x02,0x80,0x80,0x92]

s_orn2_b64 s[0:1], s[2:3], -1
// GFX12: s_or_not1_b64 s[0:1], s[2:3], -1        ; encoding: [0x02,0xc1,0x80,0x92]

s_orn2_b64 s[0:1], s[2:3], 0.5
// GFX12: s_or_not1_b64 s[0:1], s[2:3], 0.5       ; encoding: [0x02,0xf0,0x80,0x92]

s_orn2_b64 s[0:1], s[2:3], -4.0
// GFX12: s_or_not1_b64 s[0:1], s[2:3], -4.0      ; encoding: [0x02,0xf7,0x80,0x92]

s_orn2_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_or_not1_b64 s[0:1], s[2:3], 0x3f717273 ; encoding: [0x02,0xff,0x80,0x92,0x73,0x72,0x71,0x3f]

s_orn2_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_or_not1_b64 s[0:1], s[2:3], 0xaf123456 ; encoding: [0x02,0xff,0x80,0x92,0x56,0x34,0x12,0xaf]

s_nand_b32 s0, s1, s2
// GFX12: s_nand_b32 s0, s1, s2                   ; encoding: [0x01,0x02,0x00,0x8e]

s_nand_b32 s105, s104, s103
// GFX12: s_nand_b32 s105, s104, s103             ; encoding: [0x68,0x67,0x69,0x8e]

s_nand_b32 s0, s104, s103
// GFX12: s_nand_b32 s0, s104, s103               ; encoding: [0x68,0x67,0x00,0x8e]

s_nand_b32 s105, s1, s103
// GFX12: s_nand_b32 s105, s1, s103               ; encoding: [0x01,0x67,0x69,0x8e]

s_nand_b32 s105, s104, s2
// GFX12: s_nand_b32 s105, s104, s2               ; encoding: [0x68,0x02,0x69,0x8e]

s_nand_b32 s105, s1, s2
// GFX12: s_nand_b32 s105, s1, s2                 ; encoding: [0x01,0x02,0x69,0x8e]

s_nand_b32 s0, s104, s2
// GFX12: s_nand_b32 s0, s104, s2                 ; encoding: [0x68,0x02,0x00,0x8e]

s_nand_b32 s0, s1, s103
// GFX12: s_nand_b32 s0, s1, s103                 ; encoding: [0x01,0x67,0x00,0x8e]

s_nand_b32 exec_lo, s1, s2
// GFX12: s_nand_b32 exec_lo, s1, s2              ; encoding: [0x01,0x02,0x7e,0x8e]

s_nand_b32 exec_hi, s1, s2
// GFX12: s_nand_b32 exec_hi, s1, s2              ; encoding: [0x01,0x02,0x7f,0x8e]

s_nand_b32 vcc_lo, s1, s2
// GFX12: s_nand_b32 vcc_lo, s1, s2               ; encoding: [0x01,0x02,0x6a,0x8e]

s_nand_b32 vcc_hi, s1, s2
// GFX12: s_nand_b32 vcc_hi, s1, s2               ; encoding: [0x01,0x02,0x6b,0x8e]

s_nand_b32 m0, s1, s2
// GFX12: s_nand_b32 m0, s1, s2                   ; encoding: [0x01,0x02,0x7d,0x8e]

s_nand_b32 s0, exec_lo, s2
// GFX12: s_nand_b32 s0, exec_lo, s2              ; encoding: [0x7e,0x02,0x00,0x8e]

s_nand_b32 s0, exec_hi, s2
// GFX12: s_nand_b32 s0, exec_hi, s2              ; encoding: [0x7f,0x02,0x00,0x8e]

s_nand_b32 s0, vcc_lo, s2
// GFX12: s_nand_b32 s0, vcc_lo, s2               ; encoding: [0x6a,0x02,0x00,0x8e]

s_nand_b32 s0, vcc_hi, s2
// GFX12: s_nand_b32 s0, vcc_hi, s2               ; encoding: [0x6b,0x02,0x00,0x8e]

s_nand_b32 s0, m0, s2
// GFX12: s_nand_b32 s0, m0, s2                   ; encoding: [0x7d,0x02,0x00,0x8e]

s_nand_b32 s0, 0, s2
// GFX12: s_nand_b32 s0, 0, s2                    ; encoding: [0x80,0x02,0x00,0x8e]

s_nand_b32 s0, -1, s2
// GFX12: s_nand_b32 s0, -1, s2                   ; encoding: [0xc1,0x02,0x00,0x8e]

s_nand_b32 s0, 0.5, s2
// GFX12: s_nand_b32 s0, 0.5, s2                  ; encoding: [0xf0,0x02,0x00,0x8e]

s_nand_b32 s0, -4.0, s2
// GFX12: s_nand_b32 s0, -4.0, s2                 ; encoding: [0xf7,0x02,0x00,0x8e]

s_nand_b32 s0, 0x3f717273, s2
// GFX12: s_nand_b32 s0, 0x3f717273, s2           ; encoding: [0xff,0x02,0x00,0x8e,0x73,0x72,0x71,0x3f]

s_nand_b32 s0, 0xaf123456, s2
// GFX12: s_nand_b32 s0, 0xaf123456, s2           ; encoding: [0xff,0x02,0x00,0x8e,0x56,0x34,0x12,0xaf]

s_nand_b32 s0, s1, exec_lo
// GFX12: s_nand_b32 s0, s1, exec_lo              ; encoding: [0x01,0x7e,0x00,0x8e]

s_nand_b32 s0, s1, exec_hi
// GFX12: s_nand_b32 s0, s1, exec_hi              ; encoding: [0x01,0x7f,0x00,0x8e]

s_nand_b32 s0, s1, vcc_lo
// GFX12: s_nand_b32 s0, s1, vcc_lo               ; encoding: [0x01,0x6a,0x00,0x8e]

s_nand_b32 s0, s1, vcc_hi
// GFX12: s_nand_b32 s0, s1, vcc_hi               ; encoding: [0x01,0x6b,0x00,0x8e]

s_nand_b32 s0, s1, m0
// GFX12: s_nand_b32 s0, s1, m0                   ; encoding: [0x01,0x7d,0x00,0x8e]

s_nand_b32 s0, s1, 0
// GFX12: s_nand_b32 s0, s1, 0                    ; encoding: [0x01,0x80,0x00,0x8e]

s_nand_b32 s0, s1, -1
// GFX12: s_nand_b32 s0, s1, -1                   ; encoding: [0x01,0xc1,0x00,0x8e]

s_nand_b32 s0, s1, 0.5
// GFX12: s_nand_b32 s0, s1, 0.5                  ; encoding: [0x01,0xf0,0x00,0x8e]

s_nand_b32 s0, s1, -4.0
// GFX12: s_nand_b32 s0, s1, -4.0                 ; encoding: [0x01,0xf7,0x00,0x8e]

s_nand_b32 s0, s1, 0x3f717273
// GFX12: s_nand_b32 s0, s1, 0x3f717273           ; encoding: [0x01,0xff,0x00,0x8e,0x73,0x72,0x71,0x3f]

s_nand_b32 s0, s1, 0xaf123456
// GFX12: s_nand_b32 s0, s1, 0xaf123456           ; encoding: [0x01,0xff,0x00,0x8e,0x56,0x34,0x12,0xaf]

s_nand_b64 s[0:1], s[2:3], s[4:5]
// GFX12: s_nand_b64 s[0:1], s[2:3], s[4:5]       ; encoding: [0x02,0x04,0x80,0x8e]

s_nand_b64 s[104:105], s[102:103], s[100:101]
// GFX12: s_nand_b64 s[104:105], s[102:103], s[100:101] ; encoding: [0x66,0x64,0xe8,0x8e]

s_nand_b64 s[0:1], s[102:103], s[100:101]
// GFX12: s_nand_b64 s[0:1], s[102:103], s[100:101] ; encoding: [0x66,0x64,0x80,0x8e]

s_nand_b64 s[104:105], s[2:3], s[100:101]
// GFX12: s_nand_b64 s[104:105], s[2:3], s[100:101] ; encoding: [0x02,0x64,0xe8,0x8e]

s_nand_b64 s[104:105], s[102:103], s[4:5]
// GFX12: s_nand_b64 s[104:105], s[102:103], s[4:5] ; encoding: [0x66,0x04,0xe8,0x8e]

s_nand_b64 s[104:105], s[2:3], s[4:5]
// GFX12: s_nand_b64 s[104:105], s[2:3], s[4:5]   ; encoding: [0x02,0x04,0xe8,0x8e]

s_nand_b64 s[0:1], s[102:103], s[4:5]
// GFX12: s_nand_b64 s[0:1], s[102:103], s[4:5]   ; encoding: [0x66,0x04,0x80,0x8e]

s_nand_b64 s[0:1], s[2:3], s[100:101]
// GFX12: s_nand_b64 s[0:1], s[2:3], s[100:101]   ; encoding: [0x02,0x64,0x80,0x8e]

s_nand_b64 exec, s[2:3], s[4:5]
// GFX12: s_nand_b64 exec, s[2:3], s[4:5]         ; encoding: [0x02,0x04,0xfe,0x8e]

s_nand_b64 vcc, s[2:3], s[4:5]
// GFX12: s_nand_b64 vcc, s[2:3], s[4:5]          ; encoding: [0x02,0x04,0xea,0x8e]

s_nand_b64 s[0:1], exec, s[4:5]
// GFX12: s_nand_b64 s[0:1], exec, s[4:5]         ; encoding: [0x7e,0x04,0x80,0x8e]

s_nand_b64 s[0:1], vcc, s[4:5]
// GFX12: s_nand_b64 s[0:1], vcc, s[4:5]          ; encoding: [0x6a,0x04,0x80,0x8e]

s_nand_b64 s[0:1], 0, s[4:5]
// GFX12: s_nand_b64 s[0:1], 0, s[4:5]            ; encoding: [0x80,0x04,0x80,0x8e]

s_nand_b64 s[0:1], -1, s[4:5]
// GFX12: s_nand_b64 s[0:1], -1, s[4:5]           ; encoding: [0xc1,0x04,0x80,0x8e]

s_nand_b64 s[0:1], 0.5, s[4:5]
// GFX12: s_nand_b64 s[0:1], 0.5, s[4:5]          ; encoding: [0xf0,0x04,0x80,0x8e]

s_nand_b64 s[0:1], -4.0, s[4:5]
// GFX12: s_nand_b64 s[0:1], -4.0, s[4:5]         ; encoding: [0xf7,0x04,0x80,0x8e]

s_nand_b64 s[0:1], 0x3f717273, s[4:5]
// GFX12: s_nand_b64 s[0:1], 0x3f717273, s[4:5]   ; encoding: [0xff,0x04,0x80,0x8e,0x73,0x72,0x71,0x3f]

s_nand_b64 s[0:1], 0xaf123456, s[4:5]
// GFX12: s_nand_b64 s[0:1], 0xaf123456, s[4:5]   ; encoding: [0xff,0x04,0x80,0x8e,0x56,0x34,0x12,0xaf]

s_nand_b64 s[0:1], s[2:3], exec
// GFX12: s_nand_b64 s[0:1], s[2:3], exec         ; encoding: [0x02,0x7e,0x80,0x8e]

s_nand_b64 s[0:1], s[2:3], vcc
// GFX12: s_nand_b64 s[0:1], s[2:3], vcc          ; encoding: [0x02,0x6a,0x80,0x8e]

s_nand_b64 s[0:1], s[2:3], 0
// GFX12: s_nand_b64 s[0:1], s[2:3], 0            ; encoding: [0x02,0x80,0x80,0x8e]

s_nand_b64 s[0:1], s[2:3], -1
// GFX12: s_nand_b64 s[0:1], s[2:3], -1           ; encoding: [0x02,0xc1,0x80,0x8e]

s_nand_b64 s[0:1], s[2:3], 0.5
// GFX12: s_nand_b64 s[0:1], s[2:3], 0.5          ; encoding: [0x02,0xf0,0x80,0x8e]

s_nand_b64 s[0:1], s[2:3], -4.0
// GFX12: s_nand_b64 s[0:1], s[2:3], -4.0         ; encoding: [0x02,0xf7,0x80,0x8e]

s_nand_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_nand_b64 s[0:1], s[2:3], 0x3f717273   ; encoding: [0x02,0xff,0x80,0x8e,0x73,0x72,0x71,0x3f]

s_nand_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_nand_b64 s[0:1], s[2:3], 0xaf123456   ; encoding: [0x02,0xff,0x80,0x8e,0x56,0x34,0x12,0xaf]

s_nor_b32 s0, s1, s2
// GFX12: s_nor_b32 s0, s1, s2                    ; encoding: [0x01,0x02,0x00,0x8f]

s_nor_b32 s105, s104, s103
// GFX12: s_nor_b32 s105, s104, s103              ; encoding: [0x68,0x67,0x69,0x8f]

s_nor_b32 s0, s104, s103
// GFX12: s_nor_b32 s0, s104, s103                ; encoding: [0x68,0x67,0x00,0x8f]

s_nor_b32 s105, s1, s103
// GFX12: s_nor_b32 s105, s1, s103                ; encoding: [0x01,0x67,0x69,0x8f]

s_nor_b32 s105, s104, s2
// GFX12: s_nor_b32 s105, s104, s2                ; encoding: [0x68,0x02,0x69,0x8f]

s_nor_b32 s105, s1, s2
// GFX12: s_nor_b32 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0x8f]

s_nor_b32 s0, s104, s2
// GFX12: s_nor_b32 s0, s104, s2                  ; encoding: [0x68,0x02,0x00,0x8f]

s_nor_b32 s0, s1, s103
// GFX12: s_nor_b32 s0, s1, s103                  ; encoding: [0x01,0x67,0x00,0x8f]

s_nor_b32 exec_lo, s1, s2
// GFX12: s_nor_b32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0x7e,0x8f]

s_nor_b32 exec_hi, s1, s2
// GFX12: s_nor_b32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0x7f,0x8f]

s_nor_b32 vcc_lo, s1, s2
// GFX12: s_nor_b32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0x6a,0x8f]

s_nor_b32 vcc_hi, s1, s2
// GFX12: s_nor_b32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0x6b,0x8f]

s_nor_b32 m0, s1, s2
// GFX12: s_nor_b32 m0, s1, s2                    ; encoding: [0x01,0x02,0x7d,0x8f]

s_nor_b32 s0, exec_lo, s2
// GFX12: s_nor_b32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x00,0x8f]

s_nor_b32 s0, exec_hi, s2
// GFX12: s_nor_b32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x00,0x8f]

s_nor_b32 s0, vcc_lo, s2
// GFX12: s_nor_b32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x00,0x8f]

s_nor_b32 s0, vcc_hi, s2
// GFX12: s_nor_b32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x00,0x8f]

s_nor_b32 s0, m0, s2
// GFX12: s_nor_b32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x00,0x8f]

s_nor_b32 s0, 0, s2
// GFX12: s_nor_b32 s0, 0, s2                     ; encoding: [0x80,0x02,0x00,0x8f]

s_nor_b32 s0, -1, s2
// GFX12: s_nor_b32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x00,0x8f]

s_nor_b32 s0, 0.5, s2
// GFX12: s_nor_b32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x00,0x8f]

s_nor_b32 s0, -4.0, s2
// GFX12: s_nor_b32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x00,0x8f]

s_nor_b32 s0, 0x3f717273, s2
// GFX12: s_nor_b32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x00,0x8f,0x73,0x72,0x71,0x3f]

s_nor_b32 s0, 0xaf123456, s2
// GFX12: s_nor_b32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x00,0x8f,0x56,0x34,0x12,0xaf]

s_nor_b32 s0, s1, exec_lo
// GFX12: s_nor_b32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x00,0x8f]

s_nor_b32 s0, s1, exec_hi
// GFX12: s_nor_b32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x00,0x8f]

s_nor_b32 s0, s1, vcc_lo
// GFX12: s_nor_b32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x00,0x8f]

s_nor_b32 s0, s1, vcc_hi
// GFX12: s_nor_b32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x00,0x8f]

s_nor_b32 s0, s1, m0
// GFX12: s_nor_b32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x00,0x8f]

s_nor_b32 s0, s1, 0
// GFX12: s_nor_b32 s0, s1, 0                     ; encoding: [0x01,0x80,0x00,0x8f]

s_nor_b32 s0, s1, -1
// GFX12: s_nor_b32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x00,0x8f]

s_nor_b32 s0, s1, 0.5
// GFX12: s_nor_b32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x00,0x8f]

s_nor_b32 s0, s1, -4.0
// GFX12: s_nor_b32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x00,0x8f]

s_nor_b32 s0, s1, 0x3f717273
// GFX12: s_nor_b32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x00,0x8f,0x73,0x72,0x71,0x3f]

s_nor_b32 s0, s1, 0xaf123456
// GFX12: s_nor_b32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x00,0x8f,0x56,0x34,0x12,0xaf]

s_nor_b64 s[0:1], s[2:3], s[4:5]
// GFX12: s_nor_b64 s[0:1], s[2:3], s[4:5]        ; encoding: [0x02,0x04,0x80,0x8f]

s_nor_b64 s[104:105], s[102:103], s[100:101]
// GFX12: s_nor_b64 s[104:105], s[102:103], s[100:101] ; encoding: [0x66,0x64,0xe8,0x8f]

s_nor_b64 s[0:1], s[102:103], s[100:101]
// GFX12: s_nor_b64 s[0:1], s[102:103], s[100:101] ; encoding: [0x66,0x64,0x80,0x8f]

s_nor_b64 s[104:105], s[2:3], s[100:101]
// GFX12: s_nor_b64 s[104:105], s[2:3], s[100:101] ; encoding: [0x02,0x64,0xe8,0x8f]

s_nor_b64 s[104:105], s[102:103], s[4:5]
// GFX12: s_nor_b64 s[104:105], s[102:103], s[4:5] ; encoding: [0x66,0x04,0xe8,0x8f]

s_nor_b64 s[104:105], s[2:3], s[4:5]
// GFX12: s_nor_b64 s[104:105], s[2:3], s[4:5]    ; encoding: [0x02,0x04,0xe8,0x8f]

s_nor_b64 s[0:1], s[102:103], s[4:5]
// GFX12: s_nor_b64 s[0:1], s[102:103], s[4:5]    ; encoding: [0x66,0x04,0x80,0x8f]

s_nor_b64 s[0:1], s[2:3], s[100:101]
// GFX12: s_nor_b64 s[0:1], s[2:3], s[100:101]    ; encoding: [0x02,0x64,0x80,0x8f]

s_nor_b64 exec, s[2:3], s[4:5]
// GFX12: s_nor_b64 exec, s[2:3], s[4:5]          ; encoding: [0x02,0x04,0xfe,0x8f]

s_nor_b64 vcc, s[2:3], s[4:5]
// GFX12: s_nor_b64 vcc, s[2:3], s[4:5]           ; encoding: [0x02,0x04,0xea,0x8f]

s_nor_b64 s[0:1], exec, s[4:5]
// GFX12: s_nor_b64 s[0:1], exec, s[4:5]          ; encoding: [0x7e,0x04,0x80,0x8f]

s_nor_b64 s[0:1], vcc, s[4:5]
// GFX12: s_nor_b64 s[0:1], vcc, s[4:5]           ; encoding: [0x6a,0x04,0x80,0x8f]

s_nor_b64 s[0:1], 0, s[4:5]
// GFX12: s_nor_b64 s[0:1], 0, s[4:5]             ; encoding: [0x80,0x04,0x80,0x8f]

s_nor_b64 s[0:1], -1, s[4:5]
// GFX12: s_nor_b64 s[0:1], -1, s[4:5]            ; encoding: [0xc1,0x04,0x80,0x8f]

s_nor_b64 s[0:1], 0.5, s[4:5]
// GFX12: s_nor_b64 s[0:1], 0.5, s[4:5]           ; encoding: [0xf0,0x04,0x80,0x8f]

s_nor_b64 s[0:1], -4.0, s[4:5]
// GFX12: s_nor_b64 s[0:1], -4.0, s[4:5]          ; encoding: [0xf7,0x04,0x80,0x8f]

s_nor_b64 s[0:1], 0x3f717273, s[4:5]
// GFX12: s_nor_b64 s[0:1], 0x3f717273, s[4:5]    ; encoding: [0xff,0x04,0x80,0x8f,0x73,0x72,0x71,0x3f]

s_nor_b64 s[0:1], 0xaf123456, s[4:5]
// GFX12: s_nor_b64 s[0:1], 0xaf123456, s[4:5]    ; encoding: [0xff,0x04,0x80,0x8f,0x56,0x34,0x12,0xaf]

s_nor_b64 s[0:1], s[2:3], exec
// GFX12: s_nor_b64 s[0:1], s[2:3], exec          ; encoding: [0x02,0x7e,0x80,0x8f]

s_nor_b64 s[0:1], s[2:3], vcc
// GFX12: s_nor_b64 s[0:1], s[2:3], vcc           ; encoding: [0x02,0x6a,0x80,0x8f]

s_nor_b64 s[0:1], s[2:3], 0
// GFX12: s_nor_b64 s[0:1], s[2:3], 0             ; encoding: [0x02,0x80,0x80,0x8f]

s_nor_b64 s[0:1], s[2:3], -1
// GFX12: s_nor_b64 s[0:1], s[2:3], -1            ; encoding: [0x02,0xc1,0x80,0x8f]

s_nor_b64 s[0:1], s[2:3], 0.5
// GFX12: s_nor_b64 s[0:1], s[2:3], 0.5           ; encoding: [0x02,0xf0,0x80,0x8f]

s_nor_b64 s[0:1], s[2:3], -4.0
// GFX12: s_nor_b64 s[0:1], s[2:3], -4.0          ; encoding: [0x02,0xf7,0x80,0x8f]

s_nor_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_nor_b64 s[0:1], s[2:3], 0x3f717273    ; encoding: [0x02,0xff,0x80,0x8f,0x73,0x72,0x71,0x3f]

s_nor_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_nor_b64 s[0:1], s[2:3], 0xaf123456    ; encoding: [0x02,0xff,0x80,0x8f,0x56,0x34,0x12,0xaf]

s_xnor_b32 s0, s1, s2
// GFX12: s_xnor_b32 s0, s1, s2                   ; encoding: [0x01,0x02,0x00,0x90]

s_xnor_b32 s105, s104, s103
// GFX12: s_xnor_b32 s105, s104, s103             ; encoding: [0x68,0x67,0x69,0x90]

s_xnor_b32 s0, s104, s103
// GFX12: s_xnor_b32 s0, s104, s103               ; encoding: [0x68,0x67,0x00,0x90]

s_xnor_b32 s105, s1, s103
// GFX12: s_xnor_b32 s105, s1, s103               ; encoding: [0x01,0x67,0x69,0x90]

s_xnor_b32 s105, s104, s2
// GFX12: s_xnor_b32 s105, s104, s2               ; encoding: [0x68,0x02,0x69,0x90]

s_xnor_b32 s105, s1, s2
// GFX12: s_xnor_b32 s105, s1, s2                 ; encoding: [0x01,0x02,0x69,0x90]

s_xnor_b32 s0, s104, s2
// GFX12: s_xnor_b32 s0, s104, s2                 ; encoding: [0x68,0x02,0x00,0x90]

s_xnor_b32 s0, s1, s103
// GFX12: s_xnor_b32 s0, s1, s103                 ; encoding: [0x01,0x67,0x00,0x90]

s_xnor_b32 exec_lo, s1, s2
// GFX12: s_xnor_b32 exec_lo, s1, s2              ; encoding: [0x01,0x02,0x7e,0x90]

s_xnor_b32 exec_hi, s1, s2
// GFX12: s_xnor_b32 exec_hi, s1, s2              ; encoding: [0x01,0x02,0x7f,0x90]

s_xnor_b32 vcc_lo, s1, s2
// GFX12: s_xnor_b32 vcc_lo, s1, s2               ; encoding: [0x01,0x02,0x6a,0x90]

s_xnor_b32 vcc_hi, s1, s2
// GFX12: s_xnor_b32 vcc_hi, s1, s2               ; encoding: [0x01,0x02,0x6b,0x90]

s_xnor_b32 m0, s1, s2
// GFX12: s_xnor_b32 m0, s1, s2                   ; encoding: [0x01,0x02,0x7d,0x90]

s_xnor_b32 s0, exec_lo, s2
// GFX12: s_xnor_b32 s0, exec_lo, s2              ; encoding: [0x7e,0x02,0x00,0x90]

s_xnor_b32 s0, exec_hi, s2
// GFX12: s_xnor_b32 s0, exec_hi, s2              ; encoding: [0x7f,0x02,0x00,0x90]

s_xnor_b32 s0, vcc_lo, s2
// GFX12: s_xnor_b32 s0, vcc_lo, s2               ; encoding: [0x6a,0x02,0x00,0x90]

s_xnor_b32 s0, vcc_hi, s2
// GFX12: s_xnor_b32 s0, vcc_hi, s2               ; encoding: [0x6b,0x02,0x00,0x90]

s_xnor_b32 s0, m0, s2
// GFX12: s_xnor_b32 s0, m0, s2                   ; encoding: [0x7d,0x02,0x00,0x90]

s_xnor_b32 s0, 0, s2
// GFX12: s_xnor_b32 s0, 0, s2                    ; encoding: [0x80,0x02,0x00,0x90]

s_xnor_b32 s0, -1, s2
// GFX12: s_xnor_b32 s0, -1, s2                   ; encoding: [0xc1,0x02,0x00,0x90]

s_xnor_b32 s0, 0.5, s2
// GFX12: s_xnor_b32 s0, 0.5, s2                  ; encoding: [0xf0,0x02,0x00,0x90]

s_xnor_b32 s0, -4.0, s2
// GFX12: s_xnor_b32 s0, -4.0, s2                 ; encoding: [0xf7,0x02,0x00,0x90]

s_xnor_b32 s0, 0x3f717273, s2
// GFX12: s_xnor_b32 s0, 0x3f717273, s2           ; encoding: [0xff,0x02,0x00,0x90,0x73,0x72,0x71,0x3f]

s_xnor_b32 s0, 0xaf123456, s2
// GFX12: s_xnor_b32 s0, 0xaf123456, s2           ; encoding: [0xff,0x02,0x00,0x90,0x56,0x34,0x12,0xaf]

s_xnor_b32 s0, s1, exec_lo
// GFX12: s_xnor_b32 s0, s1, exec_lo              ; encoding: [0x01,0x7e,0x00,0x90]

s_xnor_b32 s0, s1, exec_hi
// GFX12: s_xnor_b32 s0, s1, exec_hi              ; encoding: [0x01,0x7f,0x00,0x90]

s_xnor_b32 s0, s1, vcc_lo
// GFX12: s_xnor_b32 s0, s1, vcc_lo               ; encoding: [0x01,0x6a,0x00,0x90]

s_xnor_b32 s0, s1, vcc_hi
// GFX12: s_xnor_b32 s0, s1, vcc_hi               ; encoding: [0x01,0x6b,0x00,0x90]

s_xnor_b32 s0, s1, m0
// GFX12: s_xnor_b32 s0, s1, m0                   ; encoding: [0x01,0x7d,0x00,0x90]

s_xnor_b32 s0, s1, 0
// GFX12: s_xnor_b32 s0, s1, 0                    ; encoding: [0x01,0x80,0x00,0x90]

s_xnor_b32 s0, s1, -1
// GFX12: s_xnor_b32 s0, s1, -1                   ; encoding: [0x01,0xc1,0x00,0x90]

s_xnor_b32 s0, s1, 0.5
// GFX12: s_xnor_b32 s0, s1, 0.5                  ; encoding: [0x01,0xf0,0x00,0x90]

s_xnor_b32 s0, s1, -4.0
// GFX12: s_xnor_b32 s0, s1, -4.0                 ; encoding: [0x01,0xf7,0x00,0x90]

s_xnor_b32 s0, s1, 0x3f717273
// GFX12: s_xnor_b32 s0, s1, 0x3f717273           ; encoding: [0x01,0xff,0x00,0x90,0x73,0x72,0x71,0x3f]

s_xnor_b32 s0, s1, 0xaf123456
// GFX12: s_xnor_b32 s0, s1, 0xaf123456           ; encoding: [0x01,0xff,0x00,0x90,0x56,0x34,0x12,0xaf]

s_xnor_b64 s[0:1], s[2:3], s[4:5]
// GFX12: s_xnor_b64 s[0:1], s[2:3], s[4:5]       ; encoding: [0x02,0x04,0x80,0x90]

s_xnor_b64 s[104:105], s[102:103], s[100:101]
// GFX12: s_xnor_b64 s[104:105], s[102:103], s[100:101] ; encoding: [0x66,0x64,0xe8,0x90]

s_xnor_b64 s[0:1], s[102:103], s[100:101]
// GFX12: s_xnor_b64 s[0:1], s[102:103], s[100:101] ; encoding: [0x66,0x64,0x80,0x90]

s_xnor_b64 s[104:105], s[2:3], s[100:101]
// GFX12: s_xnor_b64 s[104:105], s[2:3], s[100:101] ; encoding: [0x02,0x64,0xe8,0x90]

s_xnor_b64 s[104:105], s[102:103], s[4:5]
// GFX12: s_xnor_b64 s[104:105], s[102:103], s[4:5] ; encoding: [0x66,0x04,0xe8,0x90]

s_xnor_b64 s[104:105], s[2:3], s[4:5]
// GFX12: s_xnor_b64 s[104:105], s[2:3], s[4:5]   ; encoding: [0x02,0x04,0xe8,0x90]

s_xnor_b64 s[0:1], s[102:103], s[4:5]
// GFX12: s_xnor_b64 s[0:1], s[102:103], s[4:5]   ; encoding: [0x66,0x04,0x80,0x90]

s_xnor_b64 s[0:1], s[2:3], s[100:101]
// GFX12: s_xnor_b64 s[0:1], s[2:3], s[100:101]   ; encoding: [0x02,0x64,0x80,0x90]

s_xnor_b64 exec, s[2:3], s[4:5]
// GFX12: s_xnor_b64 exec, s[2:3], s[4:5]         ; encoding: [0x02,0x04,0xfe,0x90]

s_xnor_b64 vcc, s[2:3], s[4:5]
// GFX12: s_xnor_b64 vcc, s[2:3], s[4:5]          ; encoding: [0x02,0x04,0xea,0x90]

s_xnor_b64 s[0:1], exec, s[4:5]
// GFX12: s_xnor_b64 s[0:1], exec, s[4:5]         ; encoding: [0x7e,0x04,0x80,0x90]

s_xnor_b64 s[0:1], vcc, s[4:5]
// GFX12: s_xnor_b64 s[0:1], vcc, s[4:5]          ; encoding: [0x6a,0x04,0x80,0x90]

s_xnor_b64 s[0:1], 0, s[4:5]
// GFX12: s_xnor_b64 s[0:1], 0, s[4:5]            ; encoding: [0x80,0x04,0x80,0x90]

s_xnor_b64 s[0:1], -1, s[4:5]
// GFX12: s_xnor_b64 s[0:1], -1, s[4:5]           ; encoding: [0xc1,0x04,0x80,0x90]

s_xnor_b64 s[0:1], 0.5, s[4:5]
// GFX12: s_xnor_b64 s[0:1], 0.5, s[4:5]          ; encoding: [0xf0,0x04,0x80,0x90]

s_xnor_b64 s[0:1], -4.0, s[4:5]
// GFX12: s_xnor_b64 s[0:1], -4.0, s[4:5]         ; encoding: [0xf7,0x04,0x80,0x90]

s_xnor_b64 s[0:1], 0x3f717273, s[4:5]
// GFX12: s_xnor_b64 s[0:1], 0x3f717273, s[4:5]   ; encoding: [0xff,0x04,0x80,0x90,0x73,0x72,0x71,0x3f]

s_xnor_b64 s[0:1], 0xaf123456, s[4:5]
// GFX12: s_xnor_b64 s[0:1], 0xaf123456, s[4:5]   ; encoding: [0xff,0x04,0x80,0x90,0x56,0x34,0x12,0xaf]

s_xnor_b64 s[0:1], s[2:3], exec
// GFX12: s_xnor_b64 s[0:1], s[2:3], exec         ; encoding: [0x02,0x7e,0x80,0x90]

s_xnor_b64 s[0:1], s[2:3], vcc
// GFX12: s_xnor_b64 s[0:1], s[2:3], vcc          ; encoding: [0x02,0x6a,0x80,0x90]

s_xnor_b64 s[0:1], s[2:3], 0
// GFX12: s_xnor_b64 s[0:1], s[2:3], 0            ; encoding: [0x02,0x80,0x80,0x90]

s_xnor_b64 s[0:1], s[2:3], -1
// GFX12: s_xnor_b64 s[0:1], s[2:3], -1           ; encoding: [0x02,0xc1,0x80,0x90]

s_xnor_b64 s[0:1], s[2:3], 0.5
// GFX12: s_xnor_b64 s[0:1], s[2:3], 0.5          ; encoding: [0x02,0xf0,0x80,0x90]

s_xnor_b64 s[0:1], s[2:3], -4.0
// GFX12: s_xnor_b64 s[0:1], s[2:3], -4.0         ; encoding: [0x02,0xf7,0x80,0x90]

s_xnor_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_xnor_b64 s[0:1], s[2:3], 0x3f717273   ; encoding: [0x02,0xff,0x80,0x90,0x73,0x72,0x71,0x3f]

s_xnor_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_xnor_b64 s[0:1], s[2:3], 0xaf123456   ; encoding: [0x02,0xff,0x80,0x90,0x56,0x34,0x12,0xaf]

s_lshl_b32 s0, s1, s2
// GFX12: s_lshl_b32 s0, s1, s2                   ; encoding: [0x01,0x02,0x00,0x84]

s_lshl_b32 s105, s104, s103
// GFX12: s_lshl_b32 s105, s104, s103             ; encoding: [0x68,0x67,0x69,0x84]

s_lshl_b32 s0, s104, s103
// GFX12: s_lshl_b32 s0, s104, s103               ; encoding: [0x68,0x67,0x00,0x84]

s_lshl_b32 s105, s1, s103
// GFX12: s_lshl_b32 s105, s1, s103               ; encoding: [0x01,0x67,0x69,0x84]

s_lshl_b32 s105, s104, s2
// GFX12: s_lshl_b32 s105, s104, s2               ; encoding: [0x68,0x02,0x69,0x84]

s_lshl_b32 s105, s1, s2
// GFX12: s_lshl_b32 s105, s1, s2                 ; encoding: [0x01,0x02,0x69,0x84]

s_lshl_b32 s0, s104, s2
// GFX12: s_lshl_b32 s0, s104, s2                 ; encoding: [0x68,0x02,0x00,0x84]

s_lshl_b32 s0, s1, s103
// GFX12: s_lshl_b32 s0, s1, s103                 ; encoding: [0x01,0x67,0x00,0x84]

s_lshl_b32 exec_lo, s1, s2
// GFX12: s_lshl_b32 exec_lo, s1, s2              ; encoding: [0x01,0x02,0x7e,0x84]

s_lshl_b32 exec_hi, s1, s2
// GFX12: s_lshl_b32 exec_hi, s1, s2              ; encoding: [0x01,0x02,0x7f,0x84]

s_lshl_b32 vcc_lo, s1, s2
// GFX12: s_lshl_b32 vcc_lo, s1, s2               ; encoding: [0x01,0x02,0x6a,0x84]

s_lshl_b32 vcc_hi, s1, s2
// GFX12: s_lshl_b32 vcc_hi, s1, s2               ; encoding: [0x01,0x02,0x6b,0x84]

s_lshl_b32 m0, s1, s2
// GFX12: s_lshl_b32 m0, s1, s2                   ; encoding: [0x01,0x02,0x7d,0x84]

s_lshl_b32 s0, exec_lo, s2
// GFX12: s_lshl_b32 s0, exec_lo, s2              ; encoding: [0x7e,0x02,0x00,0x84]

s_lshl_b32 s0, exec_hi, s2
// GFX12: s_lshl_b32 s0, exec_hi, s2              ; encoding: [0x7f,0x02,0x00,0x84]

s_lshl_b32 s0, vcc_lo, s2
// GFX12: s_lshl_b32 s0, vcc_lo, s2               ; encoding: [0x6a,0x02,0x00,0x84]

s_lshl_b32 s0, vcc_hi, s2
// GFX12: s_lshl_b32 s0, vcc_hi, s2               ; encoding: [0x6b,0x02,0x00,0x84]

s_lshl_b32 s0, m0, s2
// GFX12: s_lshl_b32 s0, m0, s2                   ; encoding: [0x7d,0x02,0x00,0x84]

s_lshl_b32 s0, 0, s2
// GFX12: s_lshl_b32 s0, 0, s2                    ; encoding: [0x80,0x02,0x00,0x84]

s_lshl_b32 s0, -1, s2
// GFX12: s_lshl_b32 s0, -1, s2                   ; encoding: [0xc1,0x02,0x00,0x84]

s_lshl_b32 s0, 0.5, s2
// GFX12: s_lshl_b32 s0, 0.5, s2                  ; encoding: [0xf0,0x02,0x00,0x84]

s_lshl_b32 s0, -4.0, s2
// GFX12: s_lshl_b32 s0, -4.0, s2                 ; encoding: [0xf7,0x02,0x00,0x84]

s_lshl_b32 s0, 0x3f717273, s2
// GFX12: s_lshl_b32 s0, 0x3f717273, s2           ; encoding: [0xff,0x02,0x00,0x84,0x73,0x72,0x71,0x3f]

s_lshl_b32 s0, 0xaf123456, s2
// GFX12: s_lshl_b32 s0, 0xaf123456, s2           ; encoding: [0xff,0x02,0x00,0x84,0x56,0x34,0x12,0xaf]

s_lshl_b32 s0, s1, exec_lo
// GFX12: s_lshl_b32 s0, s1, exec_lo              ; encoding: [0x01,0x7e,0x00,0x84]

s_lshl_b32 s0, s1, exec_hi
// GFX12: s_lshl_b32 s0, s1, exec_hi              ; encoding: [0x01,0x7f,0x00,0x84]

s_lshl_b32 s0, s1, vcc_lo
// GFX12: s_lshl_b32 s0, s1, vcc_lo               ; encoding: [0x01,0x6a,0x00,0x84]

s_lshl_b32 s0, s1, vcc_hi
// GFX12: s_lshl_b32 s0, s1, vcc_hi               ; encoding: [0x01,0x6b,0x00,0x84]

s_lshl_b32 s0, s1, m0
// GFX12: s_lshl_b32 s0, s1, m0                   ; encoding: [0x01,0x7d,0x00,0x84]

s_lshl_b32 s0, s1, 0
// GFX12: s_lshl_b32 s0, s1, 0                    ; encoding: [0x01,0x80,0x00,0x84]

s_lshl_b32 s0, s1, -1
// GFX12: s_lshl_b32 s0, s1, -1                   ; encoding: [0x01,0xc1,0x00,0x84]

s_lshl_b32 s0, s1, 0.5
// GFX12: s_lshl_b32 s0, s1, 0.5                  ; encoding: [0x01,0xf0,0x00,0x84]

s_lshl_b32 s0, s1, -4.0
// GFX12: s_lshl_b32 s0, s1, -4.0                 ; encoding: [0x01,0xf7,0x00,0x84]

s_lshl_b32 s0, s1, 0x3f717273
// GFX12: s_lshl_b32 s0, s1, 0x3f717273           ; encoding: [0x01,0xff,0x00,0x84,0x73,0x72,0x71,0x3f]

s_lshl_b32 s0, s1, 0xaf123456
// GFX12: s_lshl_b32 s0, s1, 0xaf123456           ; encoding: [0x01,0xff,0x00,0x84,0x56,0x34,0x12,0xaf]

s_lshl_b64 s[0:1], s[2:3], s4
// GFX12: s_lshl_b64 s[0:1], s[2:3], s4           ; encoding: [0x02,0x04,0x80,0x84]

s_lshl_b64 s[104:105], s[102:103], s100
// GFX12: s_lshl_b64 s[104:105], s[102:103], s100 ; encoding: [0x66,0x64,0xe8,0x84]

s_lshl_b64 s[0:1], s[102:103], s100
// GFX12: s_lshl_b64 s[0:1], s[102:103], s100     ; encoding: [0x66,0x64,0x80,0x84]

s_lshl_b64 s[104:105], s[2:3], s100
// GFX12: s_lshl_b64 s[104:105], s[2:3], s100     ; encoding: [0x02,0x64,0xe8,0x84]

s_lshl_b64 s[104:105], s[102:103], s4
// GFX12: s_lshl_b64 s[104:105], s[102:103], s4   ; encoding: [0x66,0x04,0xe8,0x84]

s_lshl_b64 s[104:105], s[2:3], s4
// GFX12: s_lshl_b64 s[104:105], s[2:3], s4       ; encoding: [0x02,0x04,0xe8,0x84]

s_lshl_b64 s[0:1], s[102:103], s4
// GFX12: s_lshl_b64 s[0:1], s[102:103], s4       ; encoding: [0x66,0x04,0x80,0x84]

s_lshl_b64 s[0:1], s[2:3], s100
// GFX12: s_lshl_b64 s[0:1], s[2:3], s100         ; encoding: [0x02,0x64,0x80,0x84]

s_lshl_b64 exec, s[2:3], s4
// GFX12: s_lshl_b64 exec, s[2:3], s4             ; encoding: [0x02,0x04,0xfe,0x84]

s_lshl_b64 vcc, s[2:3], s4
// GFX12: s_lshl_b64 vcc, s[2:3], s4              ; encoding: [0x02,0x04,0xea,0x84]

s_lshl_b64 s[0:1], exec, s4
// GFX12: s_lshl_b64 s[0:1], exec, s4             ; encoding: [0x7e,0x04,0x80,0x84]

s_lshl_b64 s[0:1], vcc, s4
// GFX12: s_lshl_b64 s[0:1], vcc, s4              ; encoding: [0x6a,0x04,0x80,0x84]

s_lshl_b64 s[0:1], 0, s4
// GFX12: s_lshl_b64 s[0:1], 0, s4                ; encoding: [0x80,0x04,0x80,0x84]

s_lshl_b64 s[0:1], -1, s4
// GFX12: s_lshl_b64 s[0:1], -1, s4               ; encoding: [0xc1,0x04,0x80,0x84]

s_lshl_b64 s[0:1], 0.5, s4
// GFX12: s_lshl_b64 s[0:1], 0.5, s4              ; encoding: [0xf0,0x04,0x80,0x84]

s_lshl_b64 s[0:1], -4.0, s4
// GFX12: s_lshl_b64 s[0:1], -4.0, s4             ; encoding: [0xf7,0x04,0x80,0x84]

s_lshl_b64 s[0:1], 0x3f717273, s4
// GFX12: s_lshl_b64 s[0:1], 0x3f717273, s4       ; encoding: [0xff,0x04,0x80,0x84,0x73,0x72,0x71,0x3f]

s_lshl_b64 s[0:1], 0xaf123456, s4
// GFX12: s_lshl_b64 s[0:1], 0xaf123456, s4       ; encoding: [0xff,0x04,0x80,0x84,0x56,0x34,0x12,0xaf]

s_lshl_b64 s[0:1], s[2:3], exec_lo
// GFX12: s_lshl_b64 s[0:1], s[2:3], exec_lo      ; encoding: [0x02,0x7e,0x80,0x84]

s_lshl_b64 s[0:1], s[2:3], vcc_lo
// GFX12: s_lshl_b64 s[0:1], s[2:3], vcc_lo       ; encoding: [0x02,0x6a,0x80,0x84]

s_lshl_b64 s[0:1], s[2:3], 0
// GFX12: s_lshl_b64 s[0:1], s[2:3], 0            ; encoding: [0x02,0x80,0x80,0x84]

s_lshl_b64 s[0:1], s[2:3], -1
// GFX12: s_lshl_b64 s[0:1], s[2:3], -1           ; encoding: [0x02,0xc1,0x80,0x84]

s_lshl_b64 s[0:1], s[2:3], 0.5
// GFX12: s_lshl_b64 s[0:1], s[2:3], 0.5          ; encoding: [0x02,0xf0,0x80,0x84]

s_lshl_b64 s[0:1], s[2:3], -4.0
// GFX12: s_lshl_b64 s[0:1], s[2:3], -4.0         ; encoding: [0x02,0xf7,0x80,0x84]

s_lshl_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_lshl_b64 s[0:1], s[2:3], 0x3f717273   ; encoding: [0x02,0xff,0x80,0x84,0x73,0x72,0x71,0x3f]

s_lshl_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_lshl_b64 s[0:1], s[2:3], 0xaf123456   ; encoding: [0x02,0xff,0x80,0x84,0x56,0x34,0x12,0xaf]

s_lshr_b32 s0, s1, s2
// GFX12: s_lshr_b32 s0, s1, s2                   ; encoding: [0x01,0x02,0x00,0x85]

s_lshr_b32 s105, s104, s103
// GFX12: s_lshr_b32 s105, s104, s103             ; encoding: [0x68,0x67,0x69,0x85]

s_lshr_b32 s0, s104, s103
// GFX12: s_lshr_b32 s0, s104, s103               ; encoding: [0x68,0x67,0x00,0x85]

s_lshr_b32 s105, s1, s103
// GFX12: s_lshr_b32 s105, s1, s103               ; encoding: [0x01,0x67,0x69,0x85]

s_lshr_b32 s105, s104, s2
// GFX12: s_lshr_b32 s105, s104, s2               ; encoding: [0x68,0x02,0x69,0x85]

s_lshr_b32 s105, s1, s2
// GFX12: s_lshr_b32 s105, s1, s2                 ; encoding: [0x01,0x02,0x69,0x85]

s_lshr_b32 s0, s104, s2
// GFX12: s_lshr_b32 s0, s104, s2                 ; encoding: [0x68,0x02,0x00,0x85]

s_lshr_b32 s0, s1, s103
// GFX12: s_lshr_b32 s0, s1, s103                 ; encoding: [0x01,0x67,0x00,0x85]

s_lshr_b32 exec_lo, s1, s2
// GFX12: s_lshr_b32 exec_lo, s1, s2              ; encoding: [0x01,0x02,0x7e,0x85]

s_lshr_b32 exec_hi, s1, s2
// GFX12: s_lshr_b32 exec_hi, s1, s2              ; encoding: [0x01,0x02,0x7f,0x85]

s_lshr_b32 vcc_lo, s1, s2
// GFX12: s_lshr_b32 vcc_lo, s1, s2               ; encoding: [0x01,0x02,0x6a,0x85]

s_lshr_b32 vcc_hi, s1, s2
// GFX12: s_lshr_b32 vcc_hi, s1, s2               ; encoding: [0x01,0x02,0x6b,0x85]

s_lshr_b32 m0, s1, s2
// GFX12: s_lshr_b32 m0, s1, s2                   ; encoding: [0x01,0x02,0x7d,0x85]

s_lshr_b32 s0, exec_lo, s2
// GFX12: s_lshr_b32 s0, exec_lo, s2              ; encoding: [0x7e,0x02,0x00,0x85]

s_lshr_b32 s0, exec_hi, s2
// GFX12: s_lshr_b32 s0, exec_hi, s2              ; encoding: [0x7f,0x02,0x00,0x85]

s_lshr_b32 s0, vcc_lo, s2
// GFX12: s_lshr_b32 s0, vcc_lo, s2               ; encoding: [0x6a,0x02,0x00,0x85]

s_lshr_b32 s0, vcc_hi, s2
// GFX12: s_lshr_b32 s0, vcc_hi, s2               ; encoding: [0x6b,0x02,0x00,0x85]

s_lshr_b32 s0, m0, s2
// GFX12: s_lshr_b32 s0, m0, s2                   ; encoding: [0x7d,0x02,0x00,0x85]

s_lshr_b32 s0, 0, s2
// GFX12: s_lshr_b32 s0, 0, s2                    ; encoding: [0x80,0x02,0x00,0x85]

s_lshr_b32 s0, -1, s2
// GFX12: s_lshr_b32 s0, -1, s2                   ; encoding: [0xc1,0x02,0x00,0x85]

s_lshr_b32 s0, 0.5, s2
// GFX12: s_lshr_b32 s0, 0.5, s2                  ; encoding: [0xf0,0x02,0x00,0x85]

s_lshr_b32 s0, -4.0, s2
// GFX12: s_lshr_b32 s0, -4.0, s2                 ; encoding: [0xf7,0x02,0x00,0x85]

s_lshr_b32 s0, 0x3f717273, s2
// GFX12: s_lshr_b32 s0, 0x3f717273, s2           ; encoding: [0xff,0x02,0x00,0x85,0x73,0x72,0x71,0x3f]

s_lshr_b32 s0, 0xaf123456, s2
// GFX12: s_lshr_b32 s0, 0xaf123456, s2           ; encoding: [0xff,0x02,0x00,0x85,0x56,0x34,0x12,0xaf]

s_lshr_b32 s0, s1, exec_lo
// GFX12: s_lshr_b32 s0, s1, exec_lo              ; encoding: [0x01,0x7e,0x00,0x85]

s_lshr_b32 s0, s1, exec_hi
// GFX12: s_lshr_b32 s0, s1, exec_hi              ; encoding: [0x01,0x7f,0x00,0x85]

s_lshr_b32 s0, s1, vcc_lo
// GFX12: s_lshr_b32 s0, s1, vcc_lo               ; encoding: [0x01,0x6a,0x00,0x85]

s_lshr_b32 s0, s1, vcc_hi
// GFX12: s_lshr_b32 s0, s1, vcc_hi               ; encoding: [0x01,0x6b,0x00,0x85]

s_lshr_b32 s0, s1, m0
// GFX12: s_lshr_b32 s0, s1, m0                   ; encoding: [0x01,0x7d,0x00,0x85]

s_lshr_b32 s0, s1, 0
// GFX12: s_lshr_b32 s0, s1, 0                    ; encoding: [0x01,0x80,0x00,0x85]

s_lshr_b32 s0, s1, -1
// GFX12: s_lshr_b32 s0, s1, -1                   ; encoding: [0x01,0xc1,0x00,0x85]

s_lshr_b32 s0, s1, 0.5
// GFX12: s_lshr_b32 s0, s1, 0.5                  ; encoding: [0x01,0xf0,0x00,0x85]

s_lshr_b32 s0, s1, -4.0
// GFX12: s_lshr_b32 s0, s1, -4.0                 ; encoding: [0x01,0xf7,0x00,0x85]

s_lshr_b32 s0, s1, 0x3f717273
// GFX12: s_lshr_b32 s0, s1, 0x3f717273           ; encoding: [0x01,0xff,0x00,0x85,0x73,0x72,0x71,0x3f]

s_lshr_b32 s0, s1, 0xaf123456
// GFX12: s_lshr_b32 s0, s1, 0xaf123456           ; encoding: [0x01,0xff,0x00,0x85,0x56,0x34,0x12,0xaf]

s_lshr_b64 s[0:1], s[2:3], s4
// GFX12: s_lshr_b64 s[0:1], s[2:3], s4           ; encoding: [0x02,0x04,0x80,0x85]

s_lshr_b64 s[104:105], s[102:103], s100
// GFX12: s_lshr_b64 s[104:105], s[102:103], s100 ; encoding: [0x66,0x64,0xe8,0x85]

s_lshr_b64 s[0:1], s[102:103], s100
// GFX12: s_lshr_b64 s[0:1], s[102:103], s100     ; encoding: [0x66,0x64,0x80,0x85]

s_lshr_b64 s[104:105], s[2:3], s100
// GFX12: s_lshr_b64 s[104:105], s[2:3], s100     ; encoding: [0x02,0x64,0xe8,0x85]

s_lshr_b64 s[104:105], s[102:103], s4
// GFX12: s_lshr_b64 s[104:105], s[102:103], s4   ; encoding: [0x66,0x04,0xe8,0x85]

s_lshr_b64 s[104:105], s[2:3], s4
// GFX12: s_lshr_b64 s[104:105], s[2:3], s4       ; encoding: [0x02,0x04,0xe8,0x85]

s_lshr_b64 s[0:1], s[102:103], s4
// GFX12: s_lshr_b64 s[0:1], s[102:103], s4       ; encoding: [0x66,0x04,0x80,0x85]

s_lshr_b64 s[0:1], s[2:3], s100
// GFX12: s_lshr_b64 s[0:1], s[2:3], s100         ; encoding: [0x02,0x64,0x80,0x85]

s_lshr_b64 exec, s[2:3], s4
// GFX12: s_lshr_b64 exec, s[2:3], s4             ; encoding: [0x02,0x04,0xfe,0x85]

s_lshr_b64 vcc, s[2:3], s4
// GFX12: s_lshr_b64 vcc, s[2:3], s4              ; encoding: [0x02,0x04,0xea,0x85]

s_lshr_b64 s[0:1], exec, s4
// GFX12: s_lshr_b64 s[0:1], exec, s4             ; encoding: [0x7e,0x04,0x80,0x85]

s_lshr_b64 s[0:1], vcc, s4
// GFX12: s_lshr_b64 s[0:1], vcc, s4              ; encoding: [0x6a,0x04,0x80,0x85]

s_lshr_b64 s[0:1], 0, s4
// GFX12: s_lshr_b64 s[0:1], 0, s4                ; encoding: [0x80,0x04,0x80,0x85]

s_lshr_b64 s[0:1], -1, s4
// GFX12: s_lshr_b64 s[0:1], -1, s4               ; encoding: [0xc1,0x04,0x80,0x85]

s_lshr_b64 s[0:1], 0.5, s4
// GFX12: s_lshr_b64 s[0:1], 0.5, s4              ; encoding: [0xf0,0x04,0x80,0x85]

s_lshr_b64 s[0:1], -4.0, s4
// GFX12: s_lshr_b64 s[0:1], -4.0, s4             ; encoding: [0xf7,0x04,0x80,0x85]

s_lshr_b64 s[0:1], 0x3f717273, s4
// GFX12: s_lshr_b64 s[0:1], 0x3f717273, s4       ; encoding: [0xff,0x04,0x80,0x85,0x73,0x72,0x71,0x3f]

s_lshr_b64 s[0:1], 0xaf123456, s4
// GFX12: s_lshr_b64 s[0:1], 0xaf123456, s4       ; encoding: [0xff,0x04,0x80,0x85,0x56,0x34,0x12,0xaf]

s_lshr_b64 s[0:1], s[2:3], exec_lo
// GFX12: s_lshr_b64 s[0:1], s[2:3], exec_lo      ; encoding: [0x02,0x7e,0x80,0x85]

s_lshr_b64 s[0:1], s[2:3], vcc_lo
// GFX12: s_lshr_b64 s[0:1], s[2:3], vcc_lo       ; encoding: [0x02,0x6a,0x80,0x85]

s_lshr_b64 s[0:1], s[2:3], 0
// GFX12: s_lshr_b64 s[0:1], s[2:3], 0            ; encoding: [0x02,0x80,0x80,0x85]

s_lshr_b64 s[0:1], s[2:3], -1
// GFX12: s_lshr_b64 s[0:1], s[2:3], -1           ; encoding: [0x02,0xc1,0x80,0x85]

s_lshr_b64 s[0:1], s[2:3], 0.5
// GFX12: s_lshr_b64 s[0:1], s[2:3], 0.5          ; encoding: [0x02,0xf0,0x80,0x85]

s_lshr_b64 s[0:1], s[2:3], -4.0
// GFX12: s_lshr_b64 s[0:1], s[2:3], -4.0         ; encoding: [0x02,0xf7,0x80,0x85]

s_lshr_b64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_lshr_b64 s[0:1], s[2:3], 0x3f717273   ; encoding: [0x02,0xff,0x80,0x85,0x73,0x72,0x71,0x3f]

s_lshr_b64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_lshr_b64 s[0:1], s[2:3], 0xaf123456   ; encoding: [0x02,0xff,0x80,0x85,0x56,0x34,0x12,0xaf]

s_ashr_i32 s0, s1, s2
// GFX12: s_ashr_i32 s0, s1, s2                   ; encoding: [0x01,0x02,0x00,0x86]

s_ashr_i32 s105, s104, s103
// GFX12: s_ashr_i32 s105, s104, s103             ; encoding: [0x68,0x67,0x69,0x86]

s_ashr_i32 s0, s104, s103
// GFX12: s_ashr_i32 s0, s104, s103               ; encoding: [0x68,0x67,0x00,0x86]

s_ashr_i32 s105, s1, s103
// GFX12: s_ashr_i32 s105, s1, s103               ; encoding: [0x01,0x67,0x69,0x86]

s_ashr_i32 s105, s104, s2
// GFX12: s_ashr_i32 s105, s104, s2               ; encoding: [0x68,0x02,0x69,0x86]

s_ashr_i32 s105, s1, s2
// GFX12: s_ashr_i32 s105, s1, s2                 ; encoding: [0x01,0x02,0x69,0x86]

s_ashr_i32 s0, s104, s2
// GFX12: s_ashr_i32 s0, s104, s2                 ; encoding: [0x68,0x02,0x00,0x86]

s_ashr_i32 s0, s1, s103
// GFX12: s_ashr_i32 s0, s1, s103                 ; encoding: [0x01,0x67,0x00,0x86]

s_ashr_i32 exec_lo, s1, s2
// GFX12: s_ashr_i32 exec_lo, s1, s2              ; encoding: [0x01,0x02,0x7e,0x86]

s_ashr_i32 exec_hi, s1, s2
// GFX12: s_ashr_i32 exec_hi, s1, s2              ; encoding: [0x01,0x02,0x7f,0x86]

s_ashr_i32 vcc_lo, s1, s2
// GFX12: s_ashr_i32 vcc_lo, s1, s2               ; encoding: [0x01,0x02,0x6a,0x86]

s_ashr_i32 vcc_hi, s1, s2
// GFX12: s_ashr_i32 vcc_hi, s1, s2               ; encoding: [0x01,0x02,0x6b,0x86]

s_ashr_i32 m0, s1, s2
// GFX12: s_ashr_i32 m0, s1, s2                   ; encoding: [0x01,0x02,0x7d,0x86]

s_ashr_i32 s0, exec_lo, s2
// GFX12: s_ashr_i32 s0, exec_lo, s2              ; encoding: [0x7e,0x02,0x00,0x86]

s_ashr_i32 s0, exec_hi, s2
// GFX12: s_ashr_i32 s0, exec_hi, s2              ; encoding: [0x7f,0x02,0x00,0x86]

s_ashr_i32 s0, vcc_lo, s2
// GFX12: s_ashr_i32 s0, vcc_lo, s2               ; encoding: [0x6a,0x02,0x00,0x86]

s_ashr_i32 s0, vcc_hi, s2
// GFX12: s_ashr_i32 s0, vcc_hi, s2               ; encoding: [0x6b,0x02,0x00,0x86]

s_ashr_i32 s0, m0, s2
// GFX12: s_ashr_i32 s0, m0, s2                   ; encoding: [0x7d,0x02,0x00,0x86]

s_ashr_i32 s0, 0, s2
// GFX12: s_ashr_i32 s0, 0, s2                    ; encoding: [0x80,0x02,0x00,0x86]

s_ashr_i32 s0, -1, s2
// GFX12: s_ashr_i32 s0, -1, s2                   ; encoding: [0xc1,0x02,0x00,0x86]

s_ashr_i32 s0, 0.5, s2
// GFX12: s_ashr_i32 s0, 0.5, s2                  ; encoding: [0xf0,0x02,0x00,0x86]

s_ashr_i32 s0, -4.0, s2
// GFX12: s_ashr_i32 s0, -4.0, s2                 ; encoding: [0xf7,0x02,0x00,0x86]

s_ashr_i32 s0, 0x3f717273, s2
// GFX12: s_ashr_i32 s0, 0x3f717273, s2           ; encoding: [0xff,0x02,0x00,0x86,0x73,0x72,0x71,0x3f]

s_ashr_i32 s0, 0xaf123456, s2
// GFX12: s_ashr_i32 s0, 0xaf123456, s2           ; encoding: [0xff,0x02,0x00,0x86,0x56,0x34,0x12,0xaf]

s_ashr_i32 s0, s1, exec_lo
// GFX12: s_ashr_i32 s0, s1, exec_lo              ; encoding: [0x01,0x7e,0x00,0x86]

s_ashr_i32 s0, s1, exec_hi
// GFX12: s_ashr_i32 s0, s1, exec_hi              ; encoding: [0x01,0x7f,0x00,0x86]

s_ashr_i32 s0, s1, vcc_lo
// GFX12: s_ashr_i32 s0, s1, vcc_lo               ; encoding: [0x01,0x6a,0x00,0x86]

s_ashr_i32 s0, s1, vcc_hi
// GFX12: s_ashr_i32 s0, s1, vcc_hi               ; encoding: [0x01,0x6b,0x00,0x86]

s_ashr_i32 s0, s1, m0
// GFX12: s_ashr_i32 s0, s1, m0                   ; encoding: [0x01,0x7d,0x00,0x86]

s_ashr_i32 s0, s1, 0
// GFX12: s_ashr_i32 s0, s1, 0                    ; encoding: [0x01,0x80,0x00,0x86]

s_ashr_i32 s0, s1, -1
// GFX12: s_ashr_i32 s0, s1, -1                   ; encoding: [0x01,0xc1,0x00,0x86]

s_ashr_i32 s0, s1, 0.5
// GFX12: s_ashr_i32 s0, s1, 0.5                  ; encoding: [0x01,0xf0,0x00,0x86]

s_ashr_i32 s0, s1, -4.0
// GFX12: s_ashr_i32 s0, s1, -4.0                 ; encoding: [0x01,0xf7,0x00,0x86]

s_ashr_i32 s0, s1, 0x3f717273
// GFX12: s_ashr_i32 s0, s1, 0x3f717273           ; encoding: [0x01,0xff,0x00,0x86,0x73,0x72,0x71,0x3f]

s_ashr_i32 s0, s1, 0xaf123456
// GFX12: s_ashr_i32 s0, s1, 0xaf123456           ; encoding: [0x01,0xff,0x00,0x86,0x56,0x34,0x12,0xaf]

s_ashr_i64 s[0:1], s[2:3], s4
// GFX12: s_ashr_i64 s[0:1], s[2:3], s4           ; encoding: [0x02,0x04,0x80,0x86]

s_ashr_i64 s[104:105], s[102:103], s100
// GFX12: s_ashr_i64 s[104:105], s[102:103], s100 ; encoding: [0x66,0x64,0xe8,0x86]

s_ashr_i64 s[0:1], s[102:103], s100
// GFX12: s_ashr_i64 s[0:1], s[102:103], s100     ; encoding: [0x66,0x64,0x80,0x86]

s_ashr_i64 s[104:105], s[2:3], s100
// GFX12: s_ashr_i64 s[104:105], s[2:3], s100     ; encoding: [0x02,0x64,0xe8,0x86]

s_ashr_i64 s[104:105], s[102:103], s4
// GFX12: s_ashr_i64 s[104:105], s[102:103], s4   ; encoding: [0x66,0x04,0xe8,0x86]

s_ashr_i64 s[104:105], s[2:3], s4
// GFX12: s_ashr_i64 s[104:105], s[2:3], s4       ; encoding: [0x02,0x04,0xe8,0x86]

s_ashr_i64 s[0:1], s[102:103], s4
// GFX12: s_ashr_i64 s[0:1], s[102:103], s4       ; encoding: [0x66,0x04,0x80,0x86]

s_ashr_i64 s[0:1], s[2:3], s100
// GFX12: s_ashr_i64 s[0:1], s[2:3], s100         ; encoding: [0x02,0x64,0x80,0x86]

s_ashr_i64 exec, s[2:3], s4
// GFX12: s_ashr_i64 exec, s[2:3], s4             ; encoding: [0x02,0x04,0xfe,0x86]

s_ashr_i64 vcc, s[2:3], s4
// GFX12: s_ashr_i64 vcc, s[2:3], s4              ; encoding: [0x02,0x04,0xea,0x86]

s_ashr_i64 s[0:1], exec, s4
// GFX12: s_ashr_i64 s[0:1], exec, s4             ; encoding: [0x7e,0x04,0x80,0x86]

s_ashr_i64 s[0:1], vcc, s4
// GFX12: s_ashr_i64 s[0:1], vcc, s4              ; encoding: [0x6a,0x04,0x80,0x86]

s_ashr_i64 s[0:1], 0, s4
// GFX12: s_ashr_i64 s[0:1], 0, s4                ; encoding: [0x80,0x04,0x80,0x86]

s_ashr_i64 s[0:1], -1, s4
// GFX12: s_ashr_i64 s[0:1], -1, s4               ; encoding: [0xc1,0x04,0x80,0x86]

s_ashr_i64 s[0:1], 0.5, s4
// GFX12: s_ashr_i64 s[0:1], 0.5, s4              ; encoding: [0xf0,0x04,0x80,0x86]

s_ashr_i64 s[0:1], -4.0, s4
// GFX12: s_ashr_i64 s[0:1], -4.0, s4             ; encoding: [0xf7,0x04,0x80,0x86]

s_ashr_i64 s[0:1], 0x3f717273, s4
// GFX12: s_ashr_i64 s[0:1], 0x3f717273, s4       ; encoding: [0xff,0x04,0x80,0x86,0x73,0x72,0x71,0x3f]

s_ashr_i64 s[0:1], 0xaf123456, s4
// GFX12: s_ashr_i64 s[0:1], 0xaf123456, s4       ; encoding: [0xff,0x04,0x80,0x86,0x56,0x34,0x12,0xaf]

s_ashr_i64 s[0:1], s[2:3], exec_lo
// GFX12: s_ashr_i64 s[0:1], s[2:3], exec_lo      ; encoding: [0x02,0x7e,0x80,0x86]

s_ashr_i64 s[0:1], s[2:3], vcc_lo
// GFX12: s_ashr_i64 s[0:1], s[2:3], vcc_lo       ; encoding: [0x02,0x6a,0x80,0x86]

s_ashr_i64 s[0:1], s[2:3], 0
// GFX12: s_ashr_i64 s[0:1], s[2:3], 0            ; encoding: [0x02,0x80,0x80,0x86]

s_ashr_i64 s[0:1], s[2:3], -1
// GFX12: s_ashr_i64 s[0:1], s[2:3], -1           ; encoding: [0x02,0xc1,0x80,0x86]

s_ashr_i64 s[0:1], s[2:3], 0.5
// GFX12: s_ashr_i64 s[0:1], s[2:3], 0.5          ; encoding: [0x02,0xf0,0x80,0x86]

s_ashr_i64 s[0:1], s[2:3], -4.0
// GFX12: s_ashr_i64 s[0:1], s[2:3], -4.0         ; encoding: [0x02,0xf7,0x80,0x86]

s_ashr_i64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_ashr_i64 s[0:1], s[2:3], 0x3f717273   ; encoding: [0x02,0xff,0x80,0x86,0x73,0x72,0x71,0x3f]

s_ashr_i64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_ashr_i64 s[0:1], s[2:3], 0xaf123456   ; encoding: [0x02,0xff,0x80,0x86,0x56,0x34,0x12,0xaf]

s_bfm_b32 s0, s1, s2
// GFX12: s_bfm_b32 s0, s1, s2                    ; encoding: [0x01,0x02,0x00,0x95]

s_bfm_b32 s105, s104, s103
// GFX12: s_bfm_b32 s105, s104, s103              ; encoding: [0x68,0x67,0x69,0x95]

s_bfm_b32 s0, s104, s103
// GFX12: s_bfm_b32 s0, s104, s103                ; encoding: [0x68,0x67,0x00,0x95]

s_bfm_b32 s105, s1, s103
// GFX12: s_bfm_b32 s105, s1, s103                ; encoding: [0x01,0x67,0x69,0x95]

s_bfm_b32 s105, s104, s2
// GFX12: s_bfm_b32 s105, s104, s2                ; encoding: [0x68,0x02,0x69,0x95]

s_bfm_b32 s105, s1, s2
// GFX12: s_bfm_b32 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0x95]

s_bfm_b32 s0, s104, s2
// GFX12: s_bfm_b32 s0, s104, s2                  ; encoding: [0x68,0x02,0x00,0x95]

s_bfm_b32 s0, s1, s103
// GFX12: s_bfm_b32 s0, s1, s103                  ; encoding: [0x01,0x67,0x00,0x95]

s_bfm_b32 exec_lo, s1, s2
// GFX12: s_bfm_b32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0x7e,0x95]

s_bfm_b32 exec_hi, s1, s2
// GFX12: s_bfm_b32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0x7f,0x95]

s_bfm_b32 vcc_lo, s1, s2
// GFX12: s_bfm_b32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0x6a,0x95]

s_bfm_b32 vcc_hi, s1, s2
// GFX12: s_bfm_b32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0x6b,0x95]

s_bfm_b32 m0, s1, s2
// GFX12: s_bfm_b32 m0, s1, s2                    ; encoding: [0x01,0x02,0x7d,0x95]

s_bfm_b32 s0, exec_lo, s2
// GFX12: s_bfm_b32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x00,0x95]

s_bfm_b32 s0, exec_hi, s2
// GFX12: s_bfm_b32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x00,0x95]

s_bfm_b32 s0, vcc_lo, s2
// GFX12: s_bfm_b32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x00,0x95]

s_bfm_b32 s0, vcc_hi, s2
// GFX12: s_bfm_b32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x00,0x95]

s_bfm_b32 s0, m0, s2
// GFX12: s_bfm_b32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x00,0x95]

s_bfm_b32 s0, 0, s2
// GFX12: s_bfm_b32 s0, 0, s2                     ; encoding: [0x80,0x02,0x00,0x95]

s_bfm_b32 s0, -1, s2
// GFX12: s_bfm_b32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x00,0x95]

s_bfm_b32 s0, 0.5, s2
// GFX12: s_bfm_b32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x00,0x95]

s_bfm_b32 s0, -4.0, s2
// GFX12: s_bfm_b32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x00,0x95]

s_bfm_b32 s0, 0x3f717273, s2
// GFX12: s_bfm_b32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x00,0x95,0x73,0x72,0x71,0x3f]

s_bfm_b32 s0, 0xaf123456, s2
// GFX12: s_bfm_b32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x00,0x95,0x56,0x34,0x12,0xaf]

s_bfm_b32 s0, s1, exec_lo
// GFX12: s_bfm_b32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x00,0x95]

s_bfm_b32 s0, s1, exec_hi
// GFX12: s_bfm_b32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x00,0x95]

s_bfm_b32 s0, s1, vcc_lo
// GFX12: s_bfm_b32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x00,0x95]

s_bfm_b32 s0, s1, vcc_hi
// GFX12: s_bfm_b32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x00,0x95]

s_bfm_b32 s0, s1, m0
// GFX12: s_bfm_b32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x00,0x95]

s_bfm_b32 s0, s1, 0
// GFX12: s_bfm_b32 s0, s1, 0                     ; encoding: [0x01,0x80,0x00,0x95]

s_bfm_b32 s0, s1, -1
// GFX12: s_bfm_b32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x00,0x95]

s_bfm_b32 s0, s1, 0.5
// GFX12: s_bfm_b32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x00,0x95]

s_bfm_b32 s0, s1, -4.0
// GFX12: s_bfm_b32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x00,0x95]

s_bfm_b32 s0, s1, 0x3f717273
// GFX12: s_bfm_b32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x00,0x95,0x73,0x72,0x71,0x3f]

s_bfm_b32 s0, s1, 0xaf123456
// GFX12: s_bfm_b32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x00,0x95,0x56,0x34,0x12,0xaf]

s_bfm_b64 s[0:1], s2, s3
// GFX12: s_bfm_b64 s[0:1], s2, s3                ; encoding: [0x02,0x03,0x80,0x95]

s_bfm_b64 s[104:105], s103, s102
// GFX12: s_bfm_b64 s[104:105], s103, s102        ; encoding: [0x67,0x66,0xe8,0x95]

s_bfm_b64 s[0:1], s104, s103
// GFX12: s_bfm_b64 s[0:1], s104, s103            ; encoding: [0x68,0x67,0x80,0x95]

s_bfm_b64 s[104:105], s2, s103
// GFX12: s_bfm_b64 s[104:105], s2, s103          ; encoding: [0x02,0x67,0xe8,0x95]

s_bfm_b64 s[104:105], s104, s3
// GFX12: s_bfm_b64 s[104:105], s104, s3          ; encoding: [0x68,0x03,0xe8,0x95]

s_bfm_b64 s[104:105], s2, s3
// GFX12: s_bfm_b64 s[104:105], s2, s3            ; encoding: [0x02,0x03,0xe8,0x95]

s_bfm_b64 s[0:1], s104, s3
// GFX12: s_bfm_b64 s[0:1], s104, s3              ; encoding: [0x68,0x03,0x80,0x95]

s_bfm_b64 s[0:1], s2, s103
// GFX12: s_bfm_b64 s[0:1], s2, s103              ; encoding: [0x02,0x67,0x80,0x95]

s_bfm_b64 exec, s2, s3
// GFX12: s_bfm_b64 exec, s2, s3                  ; encoding: [0x02,0x03,0xfe,0x95]

s_bfm_b64 vcc, s2, s3
// GFX12: s_bfm_b64 vcc, s2, s3                   ; encoding: [0x02,0x03,0xea,0x95]

s_bfm_b64 s[0:1], exec_lo, s3
// GFX12: s_bfm_b64 s[0:1], exec_lo, s3           ; encoding: [0x7e,0x03,0x80,0x95]

s_bfm_b64 s[0:1], exec_hi, s3
// GFX12: s_bfm_b64 s[0:1], exec_hi, s3           ; encoding: [0x7f,0x03,0x80,0x95]

s_bfm_b64 s[0:1], vcc_lo, s3
// GFX12: s_bfm_b64 s[0:1], vcc_lo, s3            ; encoding: [0x6a,0x03,0x80,0x95]

s_bfm_b64 s[0:1], vcc_hi, s3
// GFX12: s_bfm_b64 s[0:1], vcc_hi, s3            ; encoding: [0x6b,0x03,0x80,0x95]

s_bfm_b64 s[0:1], m0, s3
// GFX12: s_bfm_b64 s[0:1], m0, s3                ; encoding: [0x7d,0x03,0x80,0x95]

s_bfm_b64 s[0:1], 0, s3
// GFX12: s_bfm_b64 s[0:1], 0, s3                 ; encoding: [0x80,0x03,0x80,0x95]

s_bfm_b64 s[0:1], -1, s3
// GFX12: s_bfm_b64 s[0:1], -1, s3                ; encoding: [0xc1,0x03,0x80,0x95]

s_bfm_b64 s[0:1], 0.5, s3
// GFX12: s_bfm_b64 s[0:1], 0.5, s3               ; encoding: [0xf0,0x03,0x80,0x95]

s_bfm_b64 s[0:1], -4.0, s3
// GFX12: s_bfm_b64 s[0:1], -4.0, s3              ; encoding: [0xf7,0x03,0x80,0x95]

s_bfm_b64 s[0:1], 0x3f717273, s3
// GFX12: s_bfm_b64 s[0:1], 0x3f717273, s3        ; encoding: [0xff,0x03,0x80,0x95,0x73,0x72,0x71,0x3f]

s_bfm_b64 s[0:1], 0xaf123456, s3
// GFX12: s_bfm_b64 s[0:1], 0xaf123456, s3        ; encoding: [0xff,0x03,0x80,0x95,0x56,0x34,0x12,0xaf]

s_bfm_b64 s[0:1], s2, exec_lo
// GFX12: s_bfm_b64 s[0:1], s2, exec_lo           ; encoding: [0x02,0x7e,0x80,0x95]

s_bfm_b64 s[0:1], s2, exec_hi
// GFX12: s_bfm_b64 s[0:1], s2, exec_hi           ; encoding: [0x02,0x7f,0x80,0x95]

s_bfm_b64 s[0:1], s2, vcc_lo
// GFX12: s_bfm_b64 s[0:1], s2, vcc_lo            ; encoding: [0x02,0x6a,0x80,0x95]

s_bfm_b64 s[0:1], s2, vcc_hi
// GFX12: s_bfm_b64 s[0:1], s2, vcc_hi            ; encoding: [0x02,0x6b,0x80,0x95]

s_bfm_b64 s[0:1], s2, m0
// GFX12: s_bfm_b64 s[0:1], s2, m0                ; encoding: [0x02,0x7d,0x80,0x95]

s_bfm_b64 s[0:1], s2, 0
// GFX12: s_bfm_b64 s[0:1], s2, 0                 ; encoding: [0x02,0x80,0x80,0x95]

s_bfm_b64 s[0:1], s2, -1
// GFX12: s_bfm_b64 s[0:1], s2, -1                ; encoding: [0x02,0xc1,0x80,0x95]

s_bfm_b64 s[0:1], s2, 0.5
// GFX12: s_bfm_b64 s[0:1], s2, 0.5               ; encoding: [0x02,0xf0,0x80,0x95]

s_bfm_b64 s[0:1], s2, -4.0
// GFX12: s_bfm_b64 s[0:1], s2, -4.0              ; encoding: [0x02,0xf7,0x80,0x95]

s_bfm_b64 s[0:1], s2, 0x3f717273
// GFX12: s_bfm_b64 s[0:1], s2, 0x3f717273        ; encoding: [0x02,0xff,0x80,0x95,0x73,0x72,0x71,0x3f]

s_bfm_b64 s[0:1], s2, 0xaf123456
// GFX12: s_bfm_b64 s[0:1], s2, 0xaf123456        ; encoding: [0x02,0xff,0x80,0x95,0x56,0x34,0x12,0xaf]

s_mul_i32 s0, s1, s2
// GFX12: s_mul_i32 s0, s1, s2                    ; encoding: [0x01,0x02,0x00,0x96]

s_mul_i32 s105, s104, s103
// GFX12: s_mul_i32 s105, s104, s103              ; encoding: [0x68,0x67,0x69,0x96]

s_mul_i32 s0, s104, s103
// GFX12: s_mul_i32 s0, s104, s103                ; encoding: [0x68,0x67,0x00,0x96]

s_mul_i32 s105, s1, s103
// GFX12: s_mul_i32 s105, s1, s103                ; encoding: [0x01,0x67,0x69,0x96]

s_mul_i32 s105, s104, s2
// GFX12: s_mul_i32 s105, s104, s2                ; encoding: [0x68,0x02,0x69,0x96]

s_mul_i32 s105, s1, s2
// GFX12: s_mul_i32 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0x96]

s_mul_i32 s0, s104, s2
// GFX12: s_mul_i32 s0, s104, s2                  ; encoding: [0x68,0x02,0x00,0x96]

s_mul_i32 s0, s1, s103
// GFX12: s_mul_i32 s0, s1, s103                  ; encoding: [0x01,0x67,0x00,0x96]

s_mul_i32 exec_lo, s1, s2
// GFX12: s_mul_i32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0x7e,0x96]

s_mul_i32 exec_hi, s1, s2
// GFX12: s_mul_i32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0x7f,0x96]

s_mul_i32 vcc_lo, s1, s2
// GFX12: s_mul_i32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0x6a,0x96]

s_mul_i32 vcc_hi, s1, s2
// GFX12: s_mul_i32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0x6b,0x96]

s_mul_i32 m0, s1, s2
// GFX12: s_mul_i32 m0, s1, s2                    ; encoding: [0x01,0x02,0x7d,0x96]

s_mul_i32 s0, exec_lo, s2
// GFX12: s_mul_i32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x00,0x96]

s_mul_i32 s0, exec_hi, s2
// GFX12: s_mul_i32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x00,0x96]

s_mul_i32 s0, vcc_lo, s2
// GFX12: s_mul_i32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x00,0x96]

s_mul_i32 s0, vcc_hi, s2
// GFX12: s_mul_i32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x00,0x96]

s_mul_i32 s0, m0, s2
// GFX12: s_mul_i32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x00,0x96]

s_mul_i32 s0, 0, s2
// GFX12: s_mul_i32 s0, 0, s2                     ; encoding: [0x80,0x02,0x00,0x96]

s_mul_i32 s0, -1, s2
// GFX12: s_mul_i32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x00,0x96]

s_mul_i32 s0, 0.5, s2
// GFX12: s_mul_i32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x00,0x96]

s_mul_i32 s0, -4.0, s2
// GFX12: s_mul_i32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x00,0x96]

s_mul_i32 s0, 0x3f717273, s2
// GFX12: s_mul_i32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x00,0x96,0x73,0x72,0x71,0x3f]

s_mul_i32 s0, 0xaf123456, s2
// GFX12: s_mul_i32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x00,0x96,0x56,0x34,0x12,0xaf]

s_mul_i32 s0, s1, exec_lo
// GFX12: s_mul_i32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x00,0x96]

s_mul_i32 s0, s1, exec_hi
// GFX12: s_mul_i32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x00,0x96]

s_mul_i32 s0, s1, vcc_lo
// GFX12: s_mul_i32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x00,0x96]

s_mul_i32 s0, s1, vcc_hi
// GFX12: s_mul_i32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x00,0x96]

s_mul_i32 s0, s1, m0
// GFX12: s_mul_i32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x00,0x96]

s_mul_i32 s0, s1, 0
// GFX12: s_mul_i32 s0, s1, 0                     ; encoding: [0x01,0x80,0x00,0x96]

s_mul_i32 s0, s1, -1
// GFX12: s_mul_i32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x00,0x96]

s_mul_i32 s0, s1, 0.5
// GFX12: s_mul_i32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x00,0x96]

s_mul_i32 s0, s1, -4.0
// GFX12: s_mul_i32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x00,0x96]

s_mul_i32 s0, s1, 0x3f717273
// GFX12: s_mul_i32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x00,0x96,0x73,0x72,0x71,0x3f]

s_mul_i32 s0, s1, 0xaf123456
// GFX12: s_mul_i32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x00,0x96,0x56,0x34,0x12,0xaf]

s_bfe_u32 s0, s1, s2
// GFX12: s_bfe_u32 s0, s1, s2                    ; encoding: [0x01,0x02,0x00,0x93]

s_bfe_u32 s105, s104, s103
// GFX12: s_bfe_u32 s105, s104, s103              ; encoding: [0x68,0x67,0x69,0x93]

s_bfe_u32 s0, s104, s103
// GFX12: s_bfe_u32 s0, s104, s103                ; encoding: [0x68,0x67,0x00,0x93]

s_bfe_u32 s105, s1, s103
// GFX12: s_bfe_u32 s105, s1, s103                ; encoding: [0x01,0x67,0x69,0x93]

s_bfe_u32 s105, s104, s2
// GFX12: s_bfe_u32 s105, s104, s2                ; encoding: [0x68,0x02,0x69,0x93]

s_bfe_u32 s105, s1, s2
// GFX12: s_bfe_u32 s105, s1, s2                  ; encoding: [0x01,0x02,0x69,0x93]

s_bfe_u32 s0, s104, s2
// GFX12: s_bfe_u32 s0, s104, s2                  ; encoding: [0x68,0x02,0x00,0x93]

s_bfe_u32 s0, s1, s103
// GFX12: s_bfe_u32 s0, s1, s103                  ; encoding: [0x01,0x67,0x00,0x93]

s_bfe_u32 exec_lo, s1, s2
// GFX12: s_bfe_u32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0x7e,0x93]

s_bfe_u32 exec_hi, s1, s2
// GFX12: s_bfe_u32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0x7f,0x93]

s_bfe_u32 vcc_lo, s1, s2
// GFX12: s_bfe_u32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0x6a,0x93]

s_bfe_u32 vcc_hi, s1, s2
// GFX12: s_bfe_u32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0x6b,0x93]

s_bfe_u32 m0, s1, s2
// GFX12: s_bfe_u32 m0, s1, s2                    ; encoding: [0x01,0x02,0x7d,0x93]

s_bfe_u32 s0, exec_lo, s2
// GFX12: s_bfe_u32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x00,0x93]

s_bfe_u32 s0, exec_hi, s2
// GFX12: s_bfe_u32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x00,0x93]

s_bfe_u32 s0, vcc_lo, s2
// GFX12: s_bfe_u32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x00,0x93]

s_bfe_u32 s0, vcc_hi, s2
// GFX12: s_bfe_u32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x00,0x93]

s_bfe_u32 s0, m0, s2
// GFX12: s_bfe_u32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x00,0x93]

s_bfe_u32 s0, 0, s2
// GFX12: s_bfe_u32 s0, 0, s2                     ; encoding: [0x80,0x02,0x00,0x93]

s_bfe_u32 s0, -1, s2
// GFX12: s_bfe_u32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x00,0x93]

s_bfe_u32 s0, 0.5, s2
// GFX12: s_bfe_u32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x00,0x93]

s_bfe_u32 s0, -4.0, s2
// GFX12: s_bfe_u32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x00,0x93]

s_bfe_u32 s0, 0x3f717273, s2
// GFX12: s_bfe_u32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x00,0x93,0x73,0x72,0x71,0x3f]

s_bfe_u32 s0, 0xaf123456, s2
// GFX12: s_bfe_u32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x00,0x93,0x56,0x34,0x12,0xaf]

s_bfe_u32 s0, s1, exec_lo
// GFX12: s_bfe_u32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x00,0x93]

s_bfe_u32 s0, s1, exec_hi
// GFX12: s_bfe_u32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x00,0x93]

s_bfe_u32 s0, s1, vcc_lo
// GFX12: s_bfe_u32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x00,0x93]

s_bfe_u32 s0, s1, vcc_hi
// GFX12: s_bfe_u32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x00,0x93]

s_bfe_u32 s0, s1, m0
// GFX12: s_bfe_u32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x00,0x93]

s_bfe_u32 s0, s1, 0
// GFX12: s_bfe_u32 s0, s1, 0                     ; encoding: [0x01,0x80,0x00,0x93]

s_bfe_u32 s0, s1, -1
// GFX12: s_bfe_u32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x00,0x93]

s_bfe_u32 s0, s1, 0.5
// GFX12: s_bfe_u32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x00,0x93]

s_bfe_u32 s0, s1, -4.0
// GFX12: s_bfe_u32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x00,0x93]

s_bfe_u32 s0, s1, 0x3f717273
// GFX12: s_bfe_u32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x00,0x93,0x73,0x72,0x71,0x3f]

s_bfe_u32 s0, s1, 0xaf123456
// GFX12: s_bfe_u32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x00,0x93,0x56,0x34,0x12,0xaf]

s_bfe_i32 s0, s1, s2
// GFX12: s_bfe_i32 s0, s1, s2                    ; encoding: [0x01,0x02,0x80,0x93]

s_bfe_i32 s105, s104, s103
// GFX12: s_bfe_i32 s105, s104, s103              ; encoding: [0x68,0x67,0xe9,0x93]

s_bfe_i32 s0, s104, s103
// GFX12: s_bfe_i32 s0, s104, s103                ; encoding: [0x68,0x67,0x80,0x93]

s_bfe_i32 s105, s1, s103
// GFX12: s_bfe_i32 s105, s1, s103                ; encoding: [0x01,0x67,0xe9,0x93]

s_bfe_i32 s105, s104, s2
// GFX12: s_bfe_i32 s105, s104, s2                ; encoding: [0x68,0x02,0xe9,0x93]

s_bfe_i32 s105, s1, s2
// GFX12: s_bfe_i32 s105, s1, s2                  ; encoding: [0x01,0x02,0xe9,0x93]

s_bfe_i32 s0, s104, s2
// GFX12: s_bfe_i32 s0, s104, s2                  ; encoding: [0x68,0x02,0x80,0x93]

s_bfe_i32 s0, s1, s103
// GFX12: s_bfe_i32 s0, s1, s103                  ; encoding: [0x01,0x67,0x80,0x93]

s_bfe_i32 exec_lo, s1, s2
// GFX12: s_bfe_i32 exec_lo, s1, s2               ; encoding: [0x01,0x02,0xfe,0x93]

s_bfe_i32 exec_hi, s1, s2
// GFX12: s_bfe_i32 exec_hi, s1, s2               ; encoding: [0x01,0x02,0xff,0x93]

s_bfe_i32 vcc_lo, s1, s2
// GFX12: s_bfe_i32 vcc_lo, s1, s2                ; encoding: [0x01,0x02,0xea,0x93]

s_bfe_i32 vcc_hi, s1, s2
// GFX12: s_bfe_i32 vcc_hi, s1, s2                ; encoding: [0x01,0x02,0xeb,0x93]

s_bfe_i32 m0, s1, s2
// GFX12: s_bfe_i32 m0, s1, s2                    ; encoding: [0x01,0x02,0xfd,0x93]

s_bfe_i32 s0, exec_lo, s2
// GFX12: s_bfe_i32 s0, exec_lo, s2               ; encoding: [0x7e,0x02,0x80,0x93]

s_bfe_i32 s0, exec_hi, s2
// GFX12: s_bfe_i32 s0, exec_hi, s2               ; encoding: [0x7f,0x02,0x80,0x93]

s_bfe_i32 s0, vcc_lo, s2
// GFX12: s_bfe_i32 s0, vcc_lo, s2                ; encoding: [0x6a,0x02,0x80,0x93]

s_bfe_i32 s0, vcc_hi, s2
// GFX12: s_bfe_i32 s0, vcc_hi, s2                ; encoding: [0x6b,0x02,0x80,0x93]

s_bfe_i32 s0, m0, s2
// GFX12: s_bfe_i32 s0, m0, s2                    ; encoding: [0x7d,0x02,0x80,0x93]

s_bfe_i32 s0, 0, s2
// GFX12: s_bfe_i32 s0, 0, s2                     ; encoding: [0x80,0x02,0x80,0x93]

s_bfe_i32 s0, -1, s2
// GFX12: s_bfe_i32 s0, -1, s2                    ; encoding: [0xc1,0x02,0x80,0x93]

s_bfe_i32 s0, 0.5, s2
// GFX12: s_bfe_i32 s0, 0.5, s2                   ; encoding: [0xf0,0x02,0x80,0x93]

s_bfe_i32 s0, -4.0, s2
// GFX12: s_bfe_i32 s0, -4.0, s2                  ; encoding: [0xf7,0x02,0x80,0x93]

s_bfe_i32 s0, 0x3f717273, s2
// GFX12: s_bfe_i32 s0, 0x3f717273, s2            ; encoding: [0xff,0x02,0x80,0x93,0x73,0x72,0x71,0x3f]

s_bfe_i32 s0, 0xaf123456, s2
// GFX12: s_bfe_i32 s0, 0xaf123456, s2            ; encoding: [0xff,0x02,0x80,0x93,0x56,0x34,0x12,0xaf]

s_bfe_i32 s0, s1, exec_lo
// GFX12: s_bfe_i32 s0, s1, exec_lo               ; encoding: [0x01,0x7e,0x80,0x93]

s_bfe_i32 s0, s1, exec_hi
// GFX12: s_bfe_i32 s0, s1, exec_hi               ; encoding: [0x01,0x7f,0x80,0x93]

s_bfe_i32 s0, s1, vcc_lo
// GFX12: s_bfe_i32 s0, s1, vcc_lo                ; encoding: [0x01,0x6a,0x80,0x93]

s_bfe_i32 s0, s1, vcc_hi
// GFX12: s_bfe_i32 s0, s1, vcc_hi                ; encoding: [0x01,0x6b,0x80,0x93]

s_bfe_i32 s0, s1, m0
// GFX12: s_bfe_i32 s0, s1, m0                    ; encoding: [0x01,0x7d,0x80,0x93]

s_bfe_i32 s0, s1, 0
// GFX12: s_bfe_i32 s0, s1, 0                     ; encoding: [0x01,0x80,0x80,0x93]

s_bfe_i32 s0, s1, -1
// GFX12: s_bfe_i32 s0, s1, -1                    ; encoding: [0x01,0xc1,0x80,0x93]

s_bfe_i32 s0, s1, 0.5
// GFX12: s_bfe_i32 s0, s1, 0.5                   ; encoding: [0x01,0xf0,0x80,0x93]

s_bfe_i32 s0, s1, -4.0
// GFX12: s_bfe_i32 s0, s1, -4.0                  ; encoding: [0x01,0xf7,0x80,0x93]

s_bfe_i32 s0, s1, 0x3f717273
// GFX12: s_bfe_i32 s0, s1, 0x3f717273            ; encoding: [0x01,0xff,0x80,0x93,0x73,0x72,0x71,0x3f]

s_bfe_i32 s0, s1, 0xaf123456
// GFX12: s_bfe_i32 s0, s1, 0xaf123456            ; encoding: [0x01,0xff,0x80,0x93,0x56,0x34,0x12,0xaf]

s_bfe_u64 s[0:1], s[2:3], s4
// GFX12: s_bfe_u64 s[0:1], s[2:3], s4            ; encoding: [0x02,0x04,0x00,0x94]

s_bfe_u64 s[104:105], s[102:103], s100
// GFX12: s_bfe_u64 s[104:105], s[102:103], s100  ; encoding: [0x66,0x64,0x68,0x94]

s_bfe_u64 s[0:1], s[102:103], s100
// GFX12: s_bfe_u64 s[0:1], s[102:103], s100      ; encoding: [0x66,0x64,0x00,0x94]

s_bfe_u64 s[104:105], s[2:3], s100
// GFX12: s_bfe_u64 s[104:105], s[2:3], s100      ; encoding: [0x02,0x64,0x68,0x94]

s_bfe_u64 s[104:105], s[102:103], s4
// GFX12: s_bfe_u64 s[104:105], s[102:103], s4    ; encoding: [0x66,0x04,0x68,0x94]

s_bfe_u64 s[104:105], s[2:3], s4
// GFX12: s_bfe_u64 s[104:105], s[2:3], s4        ; encoding: [0x02,0x04,0x68,0x94]

s_bfe_u64 s[0:1], s[102:103], s4
// GFX12: s_bfe_u64 s[0:1], s[102:103], s4        ; encoding: [0x66,0x04,0x00,0x94]

s_bfe_u64 s[0:1], s[2:3], s100
// GFX12: s_bfe_u64 s[0:1], s[2:3], s100          ; encoding: [0x02,0x64,0x00,0x94]

s_bfe_u64 exec, s[2:3], s4
// GFX12: s_bfe_u64 exec, s[2:3], s4              ; encoding: [0x02,0x04,0x7e,0x94]

s_bfe_u64 vcc, s[2:3], s4
// GFX12: s_bfe_u64 vcc, s[2:3], s4               ; encoding: [0x02,0x04,0x6a,0x94]

s_bfe_u64 s[0:1], exec, s4
// GFX12: s_bfe_u64 s[0:1], exec, s4              ; encoding: [0x7e,0x04,0x00,0x94]

s_bfe_u64 s[0:1], vcc, s4
// GFX12: s_bfe_u64 s[0:1], vcc, s4               ; encoding: [0x6a,0x04,0x00,0x94]

s_bfe_u64 s[0:1], 0, s4
// GFX12: s_bfe_u64 s[0:1], 0, s4                 ; encoding: [0x80,0x04,0x00,0x94]

s_bfe_u64 s[0:1], -1, s4
// GFX12: s_bfe_u64 s[0:1], -1, s4                ; encoding: [0xc1,0x04,0x00,0x94]

s_bfe_u64 s[0:1], 0.5, s4
// GFX12: s_bfe_u64 s[0:1], 0.5, s4               ; encoding: [0xf0,0x04,0x00,0x94]

s_bfe_u64 s[0:1], -4.0, s4
// GFX12: s_bfe_u64 s[0:1], -4.0, s4              ; encoding: [0xf7,0x04,0x00,0x94]

s_bfe_u64 s[0:1], 0x3f717273, s4
// GFX12: s_bfe_u64 s[0:1], 0x3f717273, s4        ; encoding: [0xff,0x04,0x00,0x94,0x73,0x72,0x71,0x3f]

s_bfe_u64 s[0:1], 0xaf123456, s4
// GFX12: s_bfe_u64 s[0:1], 0xaf123456, s4        ; encoding: [0xff,0x04,0x00,0x94,0x56,0x34,0x12,0xaf]

s_bfe_u64 s[0:1], s[2:3], exec_lo
// GFX12: s_bfe_u64 s[0:1], s[2:3], exec_lo       ; encoding: [0x02,0x7e,0x00,0x94]

s_bfe_u64 s[0:1], s[2:3], vcc_lo
// GFX12: s_bfe_u64 s[0:1], s[2:3], vcc_lo        ; encoding: [0x02,0x6a,0x00,0x94]

s_bfe_u64 s[0:1], s[2:3], 0
// GFX12: s_bfe_u64 s[0:1], s[2:3], 0             ; encoding: [0x02,0x80,0x00,0x94]

s_bfe_u64 s[0:1], s[2:3], -1
// GFX12: s_bfe_u64 s[0:1], s[2:3], -1            ; encoding: [0x02,0xc1,0x00,0x94]

s_bfe_u64 s[0:1], s[2:3], 0.5
// GFX12: s_bfe_u64 s[0:1], s[2:3], 0.5           ; encoding: [0x02,0xf0,0x00,0x94]

s_bfe_u64 s[0:1], s[2:3], -4.0
// GFX12: s_bfe_u64 s[0:1], s[2:3], -4.0          ; encoding: [0x02,0xf7,0x00,0x94]

s_bfe_u64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_bfe_u64 s[0:1], s[2:3], 0x3f717273    ; encoding: [0x02,0xff,0x00,0x94,0x73,0x72,0x71,0x3f]

s_bfe_u64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_bfe_u64 s[0:1], s[2:3], 0xaf123456    ; encoding: [0x02,0xff,0x00,0x94,0x56,0x34,0x12,0xaf]

s_bfe_i64 s[0:1], s[2:3], s4
// GFX12: s_bfe_i64 s[0:1], s[2:3], s4            ; encoding: [0x02,0x04,0x80,0x94]

s_bfe_i64 s[104:105], s[102:103], s100
// GFX12: s_bfe_i64 s[104:105], s[102:103], s100  ; encoding: [0x66,0x64,0xe8,0x94]

s_bfe_i64 s[0:1], s[102:103], s100
// GFX12: s_bfe_i64 s[0:1], s[102:103], s100      ; encoding: [0x66,0x64,0x80,0x94]

s_bfe_i64 s[104:105], s[2:3], s100
// GFX12: s_bfe_i64 s[104:105], s[2:3], s100      ; encoding: [0x02,0x64,0xe8,0x94]

s_bfe_i64 s[104:105], s[102:103], s4
// GFX12: s_bfe_i64 s[104:105], s[102:103], s4    ; encoding: [0x66,0x04,0xe8,0x94]

s_bfe_i64 s[104:105], s[2:3], s4
// GFX12: s_bfe_i64 s[104:105], s[2:3], s4        ; encoding: [0x02,0x04,0xe8,0x94]

s_bfe_i64 s[0:1], s[102:103], s4
// GFX12: s_bfe_i64 s[0:1], s[102:103], s4        ; encoding: [0x66,0x04,0x80,0x94]

s_bfe_i64 s[0:1], s[2:3], s100
// GFX12: s_bfe_i64 s[0:1], s[2:3], s100          ; encoding: [0x02,0x64,0x80,0x94]

s_bfe_i64 exec, s[2:3], s4
// GFX12: s_bfe_i64 exec, s[2:3], s4              ; encoding: [0x02,0x04,0xfe,0x94]

s_bfe_i64 vcc, s[2:3], s4
// GFX12: s_bfe_i64 vcc, s[2:3], s4               ; encoding: [0x02,0x04,0xea,0x94]

s_bfe_i64 s[0:1], exec, s4
// GFX12: s_bfe_i64 s[0:1], exec, s4              ; encoding: [0x7e,0x04,0x80,0x94]

s_bfe_i64 s[0:1], vcc, s4
// GFX12: s_bfe_i64 s[0:1], vcc, s4               ; encoding: [0x6a,0x04,0x80,0x94]

s_bfe_i64 s[0:1], 0, s4
// GFX12: s_bfe_i64 s[0:1], 0, s4                 ; encoding: [0x80,0x04,0x80,0x94]

s_bfe_i64 s[0:1], -1, s4
// GFX12: s_bfe_i64 s[0:1], -1, s4                ; encoding: [0xc1,0x04,0x80,0x94]

s_bfe_i64 s[0:1], 0.5, s4
// GFX12: s_bfe_i64 s[0:1], 0.5, s4               ; encoding: [0xf0,0x04,0x80,0x94]

s_bfe_i64 s[0:1], -4.0, s4
// GFX12: s_bfe_i64 s[0:1], -4.0, s4              ; encoding: [0xf7,0x04,0x80,0x94]

s_bfe_i64 s[0:1], 0x3f717273, s4
// GFX12: s_bfe_i64 s[0:1], 0x3f717273, s4        ; encoding: [0xff,0x04,0x80,0x94,0x73,0x72,0x71,0x3f]

s_bfe_i64 s[0:1], 0xaf123456, s4
// GFX12: s_bfe_i64 s[0:1], 0xaf123456, s4        ; encoding: [0xff,0x04,0x80,0x94,0x56,0x34,0x12,0xaf]

s_bfe_i64 s[0:1], s[2:3], exec_lo
// GFX12: s_bfe_i64 s[0:1], s[2:3], exec_lo       ; encoding: [0x02,0x7e,0x80,0x94]

s_bfe_i64 s[0:1], s[2:3], vcc_lo
// GFX12: s_bfe_i64 s[0:1], s[2:3], vcc_lo        ; encoding: [0x02,0x6a,0x80,0x94]

s_bfe_i64 s[0:1], s[2:3], 0
// GFX12: s_bfe_i64 s[0:1], s[2:3], 0             ; encoding: [0x02,0x80,0x80,0x94]

s_bfe_i64 s[0:1], s[2:3], -1
// GFX12: s_bfe_i64 s[0:1], s[2:3], -1            ; encoding: [0x02,0xc1,0x80,0x94]

s_bfe_i64 s[0:1], s[2:3], 0.5
// GFX12: s_bfe_i64 s[0:1], s[2:3], 0.5           ; encoding: [0x02,0xf0,0x80,0x94]

s_bfe_i64 s[0:1], s[2:3], -4.0
// GFX12: s_bfe_i64 s[0:1], s[2:3], -4.0          ; encoding: [0x02,0xf7,0x80,0x94]

s_bfe_i64 s[0:1], s[2:3], 0x3f717273
// GFX12: s_bfe_i64 s[0:1], s[2:3], 0x3f717273    ; encoding: [0x02,0xff,0x80,0x94,0x73,0x72,0x71,0x3f]

s_bfe_i64 s[0:1], s[2:3], 0xaf123456
// GFX12: s_bfe_i64 s[0:1], s[2:3], 0xaf123456    ; encoding: [0x02,0xff,0x80,0x94,0x56,0x34,0x12,0xaf]

s_absdiff_i32 s0, s1, s2
// GFX12: s_absdiff_i32 s0, s1, s2                ; encoding: [0x01,0x02,0x00,0x83]

s_absdiff_i32 s105, s104, s103
// GFX12: s_absdiff_i32 s105, s104, s103          ; encoding: [0x68,0x67,0x69,0x83]

s_absdiff_i32 s0, s104, s103
// GFX12: s_absdiff_i32 s0, s104, s103            ; encoding: [0x68,0x67,0x00,0x83]

s_absdiff_i32 s105, s1, s103
// GFX12: s_absdiff_i32 s105, s1, s103            ; encoding: [0x01,0x67,0x69,0x83]

s_absdiff_i32 s105, s104, s2
// GFX12: s_absdiff_i32 s105, s104, s2            ; encoding: [0x68,0x02,0x69,0x83]

s_absdiff_i32 s105, s1, s2
// GFX12: s_absdiff_i32 s105, s1, s2              ; encoding: [0x01,0x02,0x69,0x83]

s_absdiff_i32 s0, s104, s2
// GFX12: s_absdiff_i32 s0, s104, s2              ; encoding: [0x68,0x02,0x00,0x83]

s_absdiff_i32 s0, s1, s103
// GFX12: s_absdiff_i32 s0, s1, s103              ; encoding: [0x01,0x67,0x00,0x83]

s_absdiff_i32 exec_lo, s1, s2
// GFX12: s_absdiff_i32 exec_lo, s1, s2           ; encoding: [0x01,0x02,0x7e,0x83]

s_absdiff_i32 exec_hi, s1, s2
// GFX12: s_absdiff_i32 exec_hi, s1, s2           ; encoding: [0x01,0x02,0x7f,0x83]

s_absdiff_i32 vcc_lo, s1, s2
// GFX12: s_absdiff_i32 vcc_lo, s1, s2            ; encoding: [0x01,0x02,0x6a,0x83]

s_absdiff_i32 vcc_hi, s1, s2
// GFX12: s_absdiff_i32 vcc_hi, s1, s2            ; encoding: [0x01,0x02,0x6b,0x83]

s_absdiff_i32 m0, s1, s2
// GFX12: s_absdiff_i32 m0, s1, s2                ; encoding: [0x01,0x02,0x7d,0x83]

s_absdiff_i32 s0, exec_lo, s2
// GFX12: s_absdiff_i32 s0, exec_lo, s2           ; encoding: [0x7e,0x02,0x00,0x83]

s_absdiff_i32 s0, exec_hi, s2
// GFX12: s_absdiff_i32 s0, exec_hi, s2           ; encoding: [0x7f,0x02,0x00,0x83]

s_absdiff_i32 s0, vcc_lo, s2
// GFX12: s_absdiff_i32 s0, vcc_lo, s2            ; encoding: [0x6a,0x02,0x00,0x83]

s_absdiff_i32 s0, vcc_hi, s2
// GFX12: s_absdiff_i32 s0, vcc_hi, s2            ; encoding: [0x6b,0x02,0x00,0x83]

s_absdiff_i32 s0, m0, s2
// GFX12: s_absdiff_i32 s0, m0, s2                ; encoding: [0x7d,0x02,0x00,0x83]

s_absdiff_i32 s0, 0, s2
// GFX12: s_absdiff_i32 s0, 0, s2                 ; encoding: [0x80,0x02,0x00,0x83]

s_absdiff_i32 s0, -1, s2
// GFX12: s_absdiff_i32 s0, -1, s2                ; encoding: [0xc1,0x02,0x00,0x83]

s_absdiff_i32 s0, 0.5, s2
// GFX12: s_absdiff_i32 s0, 0.5, s2               ; encoding: [0xf0,0x02,0x00,0x83]

s_absdiff_i32 s0, -4.0, s2
// GFX12: s_absdiff_i32 s0, -4.0, s2              ; encoding: [0xf7,0x02,0x00,0x83]

s_absdiff_i32 s0, 0x3f717273, s2
// GFX12: s_absdiff_i32 s0, 0x3f717273, s2        ; encoding: [0xff,0x02,0x00,0x83,0x73,0x72,0x71,0x3f]

s_absdiff_i32 s0, 0xaf123456, s2
// GFX12: s_absdiff_i32 s0, 0xaf123456, s2        ; encoding: [0xff,0x02,0x00,0x83,0x56,0x34,0x12,0xaf]

s_absdiff_i32 s0, s1, exec_lo
// GFX12: s_absdiff_i32 s0, s1, exec_lo           ; encoding: [0x01,0x7e,0x00,0x83]

s_absdiff_i32 s0, s1, exec_hi
// GFX12: s_absdiff_i32 s0, s1, exec_hi           ; encoding: [0x01,0x7f,0x00,0x83]

s_absdiff_i32 s0, s1, vcc_lo
// GFX12: s_absdiff_i32 s0, s1, vcc_lo            ; encoding: [0x01,0x6a,0x00,0x83]

s_absdiff_i32 s0, s1, vcc_hi
// GFX12: s_absdiff_i32 s0, s1, vcc_hi            ; encoding: [0x01,0x6b,0x00,0x83]

s_absdiff_i32 s0, s1, m0
// GFX12: s_absdiff_i32 s0, s1, m0                ; encoding: [0x01,0x7d,0x00,0x83]

s_absdiff_i32 s0, s1, 0
// GFX12: s_absdiff_i32 s0, s1, 0                 ; encoding: [0x01,0x80,0x00,0x83]

s_absdiff_i32 s0, s1, -1
// GFX12: s_absdiff_i32 s0, s1, -1                ; encoding: [0x01,0xc1,0x00,0x83]

s_absdiff_i32 s0, s1, 0.5
// GFX12: s_absdiff_i32 s0, s1, 0.5               ; encoding: [0x01,0xf0,0x00,0x83]

s_absdiff_i32 s0, s1, -4.0
// GFX12: s_absdiff_i32 s0, s1, -4.0              ; encoding: [0x01,0xf7,0x00,0x83]

s_absdiff_i32 s0, s1, 0x3f717273
// GFX12: s_absdiff_i32 s0, s1, 0x3f717273        ; encoding: [0x01,0xff,0x00,0x83,0x73,0x72,0x71,0x3f]

s_absdiff_i32 s0, s1, 0xaf123456
// GFX12: s_absdiff_i32 s0, s1, 0xaf123456        ; encoding: [0x01,0xff,0x00,0x83,0x56,0x34,0x12,0xaf]

s_lshl1_add_u32 s0, s1, s2
// GFX12: s_lshl1_add_u32 s0, s1, s2              ; encoding: [0x01,0x02,0x00,0x87]

s_lshl1_add_u32 s105, s104, s103
// GFX12: s_lshl1_add_u32 s105, s104, s103        ; encoding: [0x68,0x67,0x69,0x87]

s_lshl1_add_u32 s0, s104, s103
// GFX12: s_lshl1_add_u32 s0, s104, s103          ; encoding: [0x68,0x67,0x00,0x87]

s_lshl1_add_u32 s105, s1, s103
// GFX12: s_lshl1_add_u32 s105, s1, s103          ; encoding: [0x01,0x67,0x69,0x87]

s_lshl1_add_u32 s105, s104, s2
// GFX12: s_lshl1_add_u32 s105, s104, s2          ; encoding: [0x68,0x02,0x69,0x87]

s_lshl1_add_u32 s105, s1, s2
// GFX12: s_lshl1_add_u32 s105, s1, s2            ; encoding: [0x01,0x02,0x69,0x87]

s_lshl1_add_u32 s0, s104, s2
// GFX12: s_lshl1_add_u32 s0, s104, s2            ; encoding: [0x68,0x02,0x00,0x87]

s_lshl1_add_u32 s0, s1, s103
// GFX12: s_lshl1_add_u32 s0, s1, s103            ; encoding: [0x01,0x67,0x00,0x87]

s_lshl1_add_u32 exec_lo, s1, s2
// GFX12: s_lshl1_add_u32 exec_lo, s1, s2         ; encoding: [0x01,0x02,0x7e,0x87]

s_lshl1_add_u32 exec_hi, s1, s2
// GFX12: s_lshl1_add_u32 exec_hi, s1, s2         ; encoding: [0x01,0x02,0x7f,0x87]

s_lshl1_add_u32 vcc_lo, s1, s2
// GFX12: s_lshl1_add_u32 vcc_lo, s1, s2          ; encoding: [0x01,0x02,0x6a,0x87]

s_lshl1_add_u32 vcc_hi, s1, s2
// GFX12: s_lshl1_add_u32 vcc_hi, s1, s2          ; encoding: [0x01,0x02,0x6b,0x87]

s_lshl1_add_u32 m0, s1, s2
// GFX12: s_lshl1_add_u32 m0, s1, s2              ; encoding: [0x01,0x02,0x7d,0x87]

s_lshl1_add_u32 s0, exec_lo, s2
// GFX12: s_lshl1_add_u32 s0, exec_lo, s2         ; encoding: [0x7e,0x02,0x00,0x87]

s_lshl1_add_u32 s0, exec_hi, s2
// GFX12: s_lshl1_add_u32 s0, exec_hi, s2         ; encoding: [0x7f,0x02,0x00,0x87]

s_lshl1_add_u32 s0, vcc_lo, s2
// GFX12: s_lshl1_add_u32 s0, vcc_lo, s2          ; encoding: [0x6a,0x02,0x00,0x87]

s_lshl1_add_u32 s0, vcc_hi, s2
// GFX12: s_lshl1_add_u32 s0, vcc_hi, s2          ; encoding: [0x6b,0x02,0x00,0x87]

s_lshl1_add_u32 s0, m0, s2
// GFX12: s_lshl1_add_u32 s0, m0, s2              ; encoding: [0x7d,0x02,0x00,0x87]

s_lshl1_add_u32 s0, 0, s2
// GFX12: s_lshl1_add_u32 s0, 0, s2               ; encoding: [0x80,0x02,0x00,0x87]

s_lshl1_add_u32 s0, -1, s2
// GFX12: s_lshl1_add_u32 s0, -1, s2              ; encoding: [0xc1,0x02,0x00,0x87]

s_lshl1_add_u32 s0, 0.5, s2
// GFX12: s_lshl1_add_u32 s0, 0.5, s2             ; encoding: [0xf0,0x02,0x00,0x87]

s_lshl1_add_u32 s0, -4.0, s2
// GFX12: s_lshl1_add_u32 s0, -4.0, s2            ; encoding: [0xf7,0x02,0x00,0x87]

s_lshl1_add_u32 s0, 0x3f717273, s2
// GFX12: s_lshl1_add_u32 s0, 0x3f717273, s2      ; encoding: [0xff,0x02,0x00,0x87,0x73,0x72,0x71,0x3f]

s_lshl1_add_u32 s0, 0xaf123456, s2
// GFX12: s_lshl1_add_u32 s0, 0xaf123456, s2      ; encoding: [0xff,0x02,0x00,0x87,0x56,0x34,0x12,0xaf]

s_lshl1_add_u32 s0, s1, exec_lo
// GFX12: s_lshl1_add_u32 s0, s1, exec_lo         ; encoding: [0x01,0x7e,0x00,0x87]

s_lshl1_add_u32 s0, s1, exec_hi
// GFX12: s_lshl1_add_u32 s0, s1, exec_hi         ; encoding: [0x01,0x7f,0x00,0x87]

s_lshl1_add_u32 s0, s1, vcc_lo
// GFX12: s_lshl1_add_u32 s0, s1, vcc_lo          ; encoding: [0x01,0x6a,0x00,0x87]

s_lshl1_add_u32 s0, s1, vcc_hi
// GFX12: s_lshl1_add_u32 s0, s1, vcc_hi          ; encoding: [0x01,0x6b,0x00,0x87]

s_lshl1_add_u32 s0, s1, m0
// GFX12: s_lshl1_add_u32 s0, s1, m0              ; encoding: [0x01,0x7d,0x00,0x87]

s_lshl1_add_u32 s0, s1, 0
// GFX12: s_lshl1_add_u32 s0, s1, 0               ; encoding: [0x01,0x80,0x00,0x87]

s_lshl1_add_u32 s0, s1, -1
// GFX12: s_lshl1_add_u32 s0, s1, -1              ; encoding: [0x01,0xc1,0x00,0x87]

s_lshl1_add_u32 s0, s1, 0.5
// GFX12: s_lshl1_add_u32 s0, s1, 0.5             ; encoding: [0x01,0xf0,0x00,0x87]

s_lshl1_add_u32 s0, s1, -4.0
// GFX12: s_lshl1_add_u32 s0, s1, -4.0            ; encoding: [0x01,0xf7,0x00,0x87]

s_lshl1_add_u32 s0, s1, 0x3f717273
// GFX12: s_lshl1_add_u32 s0, s1, 0x3f717273      ; encoding: [0x01,0xff,0x00,0x87,0x73,0x72,0x71,0x3f]

s_lshl1_add_u32 s0, s1, 0xaf123456
// GFX12: s_lshl1_add_u32 s0, s1, 0xaf123456      ; encoding: [0x01,0xff,0x00,0x87,0x56,0x34,0x12,0xaf]

s_lshl2_add_u32 s0, s1, s2
// GFX12: s_lshl2_add_u32 s0, s1, s2              ; encoding: [0x01,0x02,0x80,0x87]

s_lshl2_add_u32 s105, s104, s103
// GFX12: s_lshl2_add_u32 s105, s104, s103        ; encoding: [0x68,0x67,0xe9,0x87]

s_lshl2_add_u32 s0, s104, s103
// GFX12: s_lshl2_add_u32 s0, s104, s103          ; encoding: [0x68,0x67,0x80,0x87]

s_lshl2_add_u32 s105, s1, s103
// GFX12: s_lshl2_add_u32 s105, s1, s103          ; encoding: [0x01,0x67,0xe9,0x87]

s_lshl2_add_u32 s105, s104, s2
// GFX12: s_lshl2_add_u32 s105, s104, s2          ; encoding: [0x68,0x02,0xe9,0x87]

s_lshl2_add_u32 s105, s1, s2
// GFX12: s_lshl2_add_u32 s105, s1, s2            ; encoding: [0x01,0x02,0xe9,0x87]

s_lshl2_add_u32 s0, s104, s2
// GFX12: s_lshl2_add_u32 s0, s104, s2            ; encoding: [0x68,0x02,0x80,0x87]

s_lshl2_add_u32 s0, s1, s103
// GFX12: s_lshl2_add_u32 s0, s1, s103            ; encoding: [0x01,0x67,0x80,0x87]

s_lshl2_add_u32 exec_lo, s1, s2
// GFX12: s_lshl2_add_u32 exec_lo, s1, s2         ; encoding: [0x01,0x02,0xfe,0x87]

s_lshl2_add_u32 exec_hi, s1, s2
// GFX12: s_lshl2_add_u32 exec_hi, s1, s2         ; encoding: [0x01,0x02,0xff,0x87]

s_lshl2_add_u32 vcc_lo, s1, s2
// GFX12: s_lshl2_add_u32 vcc_lo, s1, s2          ; encoding: [0x01,0x02,0xea,0x87]

s_lshl2_add_u32 vcc_hi, s1, s2
// GFX12: s_lshl2_add_u32 vcc_hi, s1, s2          ; encoding: [0x01,0x02,0xeb,0x87]

s_lshl2_add_u32 m0, s1, s2
// GFX12: s_lshl2_add_u32 m0, s1, s2              ; encoding: [0x01,0x02,0xfd,0x87]

s_lshl2_add_u32 s0, exec_lo, s2
// GFX12: s_lshl2_add_u32 s0, exec_lo, s2         ; encoding: [0x7e,0x02,0x80,0x87]

s_lshl2_add_u32 s0, exec_hi, s2
// GFX12: s_lshl2_add_u32 s0, exec_hi, s2         ; encoding: [0x7f,0x02,0x80,0x87]

s_lshl2_add_u32 s0, vcc_lo, s2
// GFX12: s_lshl2_add_u32 s0, vcc_lo, s2          ; encoding: [0x6a,0x02,0x80,0x87]

s_lshl2_add_u32 s0, vcc_hi, s2
// GFX12: s_lshl2_add_u32 s0, vcc_hi, s2          ; encoding: [0x6b,0x02,0x80,0x87]

s_lshl2_add_u32 s0, m0, s2
// GFX12: s_lshl2_add_u32 s0, m0, s2              ; encoding: [0x7d,0x02,0x80,0x87]

s_lshl2_add_u32 s0, 0, s2
// GFX12: s_lshl2_add_u32 s0, 0, s2               ; encoding: [0x80,0x02,0x80,0x87]

s_lshl2_add_u32 s0, -1, s2
// GFX12: s_lshl2_add_u32 s0, -1, s2              ; encoding: [0xc1,0x02,0x80,0x87]

s_lshl2_add_u32 s0, 0.5, s2
// GFX12: s_lshl2_add_u32 s0, 0.5, s2             ; encoding: [0xf0,0x02,0x80,0x87]

s_lshl2_add_u32 s0, -4.0, s2
// GFX12: s_lshl2_add_u32 s0, -4.0, s2            ; encoding: [0xf7,0x02,0x80,0x87]

s_lshl2_add_u32 s0, 0x3f717273, s2
// GFX12: s_lshl2_add_u32 s0, 0x3f717273, s2      ; encoding: [0xff,0x02,0x80,0x87,0x73,0x72,0x71,0x3f]

s_lshl2_add_u32 s0, 0xaf123456, s2
// GFX12: s_lshl2_add_u32 s0, 0xaf123456, s2      ; encoding: [0xff,0x02,0x80,0x87,0x56,0x34,0x12,0xaf]

s_lshl2_add_u32 s0, s1, exec_lo
// GFX12: s_lshl2_add_u32 s0, s1, exec_lo         ; encoding: [0x01,0x7e,0x80,0x87]

s_lshl2_add_u32 s0, s1, exec_hi
// GFX12: s_lshl2_add_u32 s0, s1, exec_hi         ; encoding: [0x01,0x7f,0x80,0x87]

s_lshl2_add_u32 s0, s1, vcc_lo
// GFX12: s_lshl2_add_u32 s0, s1, vcc_lo          ; encoding: [0x01,0x6a,0x80,0x87]

s_lshl2_add_u32 s0, s1, vcc_hi
// GFX12: s_lshl2_add_u32 s0, s1, vcc_hi          ; encoding: [0x01,0x6b,0x80,0x87]

s_lshl2_add_u32 s0, s1, m0
// GFX12: s_lshl2_add_u32 s0, s1, m0              ; encoding: [0x01,0x7d,0x80,0x87]

s_lshl2_add_u32 s0, s1, 0
// GFX12: s_lshl2_add_u32 s0, s1, 0               ; encoding: [0x01,0x80,0x80,0x87]

s_lshl2_add_u32 s0, s1, -1
// GFX12: s_lshl2_add_u32 s0, s1, -1              ; encoding: [0x01,0xc1,0x80,0x87]

s_lshl2_add_u32 s0, s1, 0.5
// GFX12: s_lshl2_add_u32 s0, s1, 0.5             ; encoding: [0x01,0xf0,0x80,0x87]

s_lshl2_add_u32 s0, s1, -4.0
// GFX12: s_lshl2_add_u32 s0, s1, -4.0            ; encoding: [0x01,0xf7,0x80,0x87]

s_lshl2_add_u32 s0, s1, 0x3f717273
// GFX12: s_lshl2_add_u32 s0, s1, 0x3f717273      ; encoding: [0x01,0xff,0x80,0x87,0x73,0x72,0x71,0x3f]

s_lshl2_add_u32 s0, s1, 0xaf123456
// GFX12: s_lshl2_add_u32 s0, s1, 0xaf123456      ; encoding: [0x01,0xff,0x80,0x87,0x56,0x34,0x12,0xaf]

s_lshl3_add_u32 s0, s1, s2
// GFX12: s_lshl3_add_u32 s0, s1, s2              ; encoding: [0x01,0x02,0x00,0x88]

s_lshl3_add_u32 s105, s104, s103
// GFX12: s_lshl3_add_u32 s105, s104, s103        ; encoding: [0x68,0x67,0x69,0x88]

s_lshl3_add_u32 s0, s104, s103
// GFX12: s_lshl3_add_u32 s0, s104, s103          ; encoding: [0x68,0x67,0x00,0x88]

s_lshl3_add_u32 s105, s1, s103
// GFX12: s_lshl3_add_u32 s105, s1, s103          ; encoding: [0x01,0x67,0x69,0x88]

s_lshl3_add_u32 s105, s104, s2
// GFX12: s_lshl3_add_u32 s105, s104, s2          ; encoding: [0x68,0x02,0x69,0x88]

s_lshl3_add_u32 s105, s1, s2
// GFX12: s_lshl3_add_u32 s105, s1, s2            ; encoding: [0x01,0x02,0x69,0x88]

s_lshl3_add_u32 s0, s104, s2
// GFX12: s_lshl3_add_u32 s0, s104, s2            ; encoding: [0x68,0x02,0x00,0x88]

s_lshl3_add_u32 s0, s1, s103
// GFX12: s_lshl3_add_u32 s0, s1, s103            ; encoding: [0x01,0x67,0x00,0x88]

s_lshl3_add_u32 exec_lo, s1, s2
// GFX12: s_lshl3_add_u32 exec_lo, s1, s2         ; encoding: [0x01,0x02,0x7e,0x88]

s_lshl3_add_u32 exec_hi, s1, s2
// GFX12: s_lshl3_add_u32 exec_hi, s1, s2         ; encoding: [0x01,0x02,0x7f,0x88]

s_lshl3_add_u32 vcc_lo, s1, s2
// GFX12: s_lshl3_add_u32 vcc_lo, s1, s2          ; encoding: [0x01,0x02,0x6a,0x88]

s_lshl3_add_u32 vcc_hi, s1, s2
// GFX12: s_lshl3_add_u32 vcc_hi, s1, s2          ; encoding: [0x01,0x02,0x6b,0x88]

s_lshl3_add_u32 m0, s1, s2
// GFX12: s_lshl3_add_u32 m0, s1, s2              ; encoding: [0x01,0x02,0x7d,0x88]

s_lshl3_add_u32 s0, exec_lo, s2
// GFX12: s_lshl3_add_u32 s0, exec_lo, s2         ; encoding: [0x7e,0x02,0x00,0x88]

s_lshl3_add_u32 s0, exec_hi, s2
// GFX12: s_lshl3_add_u32 s0, exec_hi, s2         ; encoding: [0x7f,0x02,0x00,0x88]

s_lshl3_add_u32 s0, vcc_lo, s2
// GFX12: s_lshl3_add_u32 s0, vcc_lo, s2          ; encoding: [0x6a,0x02,0x00,0x88]

s_lshl3_add_u32 s0, vcc_hi, s2
// GFX12: s_lshl3_add_u32 s0, vcc_hi, s2          ; encoding: [0x6b,0x02,0x00,0x88]

s_lshl3_add_u32 s0, m0, s2
// GFX12: s_lshl3_add_u32 s0, m0, s2              ; encoding: [0x7d,0x02,0x00,0x88]

s_lshl3_add_u32 s0, 0, s2
// GFX12: s_lshl3_add_u32 s0, 0, s2               ; encoding: [0x80,0x02,0x00,0x88]

s_lshl3_add_u32 s0, -1, s2
// GFX12: s_lshl3_add_u32 s0, -1, s2              ; encoding: [0xc1,0x02,0x00,0x88]

s_lshl3_add_u32 s0, 0.5, s2
// GFX12: s_lshl3_add_u32 s0, 0.5, s2             ; encoding: [0xf0,0x02,0x00,0x88]

s_lshl3_add_u32 s0, -4.0, s2
// GFX12: s_lshl3_add_u32 s0, -4.0, s2            ; encoding: [0xf7,0x02,0x00,0x88]

s_lshl3_add_u32 s0, 0x3f717273, s2
// GFX12: s_lshl3_add_u32 s0, 0x3f717273, s2      ; encoding: [0xff,0x02,0x00,0x88,0x73,0x72,0x71,0x3f]

s_lshl3_add_u32 s0, 0xaf123456, s2
// GFX12: s_lshl3_add_u32 s0, 0xaf123456, s2      ; encoding: [0xff,0x02,0x00,0x88,0x56,0x34,0x12,0xaf]

s_lshl3_add_u32 s0, s1, exec_lo
// GFX12: s_lshl3_add_u32 s0, s1, exec_lo         ; encoding: [0x01,0x7e,0x00,0x88]

s_lshl3_add_u32 s0, s1, exec_hi
// GFX12: s_lshl3_add_u32 s0, s1, exec_hi         ; encoding: [0x01,0x7f,0x00,0x88]

s_lshl3_add_u32 s0, s1, vcc_lo
// GFX12: s_lshl3_add_u32 s0, s1, vcc_lo          ; encoding: [0x01,0x6a,0x00,0x88]

s_lshl3_add_u32 s0, s1, vcc_hi
// GFX12: s_lshl3_add_u32 s0, s1, vcc_hi          ; encoding: [0x01,0x6b,0x00,0x88]

s_lshl3_add_u32 s0, s1, m0
// GFX12: s_lshl3_add_u32 s0, s1, m0              ; encoding: [0x01,0x7d,0x00,0x88]

s_lshl3_add_u32 s0, s1, 0
// GFX12: s_lshl3_add_u32 s0, s1, 0               ; encoding: [0x01,0x80,0x00,0x88]

s_lshl3_add_u32 s0, s1, -1
// GFX12: s_lshl3_add_u32 s0, s1, -1              ; encoding: [0x01,0xc1,0x00,0x88]

s_lshl3_add_u32 s0, s1, 0.5
// GFX12: s_lshl3_add_u32 s0, s1, 0.5             ; encoding: [0x01,0xf0,0x00,0x88]

s_lshl3_add_u32 s0, s1, -4.0
// GFX12: s_lshl3_add_u32 s0, s1, -4.0            ; encoding: [0x01,0xf7,0x00,0x88]

s_lshl3_add_u32 s0, s1, 0x3f717273
// GFX12: s_lshl3_add_u32 s0, s1, 0x3f717273      ; encoding: [0x01,0xff,0x00,0x88,0x73,0x72,0x71,0x3f]

s_lshl3_add_u32 s0, s1, 0xaf123456
// GFX12: s_lshl3_add_u32 s0, s1, 0xaf123456      ; encoding: [0x01,0xff,0x00,0x88,0x56,0x34,0x12,0xaf]

s_lshl4_add_u32 s0, s1, s2
// GFX12: s_lshl4_add_u32 s0, s1, s2              ; encoding: [0x01,0x02,0x80,0x88]

s_lshl4_add_u32 s105, s104, s103
// GFX12: s_lshl4_add_u32 s105, s104, s103        ; encoding: [0x68,0x67,0xe9,0x88]

s_lshl4_add_u32 s0, s104, s103
// GFX12: s_lshl4_add_u32 s0, s104, s103          ; encoding: [0x68,0x67,0x80,0x88]

s_lshl4_add_u32 s105, s1, s103
// GFX12: s_lshl4_add_u32 s105, s1, s103          ; encoding: [0x01,0x67,0xe9,0x88]

s_lshl4_add_u32 s105, s104, s2
// GFX12: s_lshl4_add_u32 s105, s104, s2          ; encoding: [0x68,0x02,0xe9,0x88]

s_lshl4_add_u32 s105, s1, s2
// GFX12: s_lshl4_add_u32 s105, s1, s2            ; encoding: [0x01,0x02,0xe9,0x88]

s_lshl4_add_u32 s0, s104, s2
// GFX12: s_lshl4_add_u32 s0, s104, s2            ; encoding: [0x68,0x02,0x80,0x88]

s_lshl4_add_u32 s0, s1, s103
// GFX12: s_lshl4_add_u32 s0, s1, s103            ; encoding: [0x01,0x67,0x80,0x88]

s_lshl4_add_u32 exec_lo, s1, s2
// GFX12: s_lshl4_add_u32 exec_lo, s1, s2         ; encoding: [0x01,0x02,0xfe,0x88]

s_lshl4_add_u32 exec_hi, s1, s2
// GFX12: s_lshl4_add_u32 exec_hi, s1, s2         ; encoding: [0x01,0x02,0xff,0x88]

s_lshl4_add_u32 vcc_lo, s1, s2
// GFX12: s_lshl4_add_u32 vcc_lo, s1, s2          ; encoding: [0x01,0x02,0xea,0x88]

s_lshl4_add_u32 vcc_hi, s1, s2
// GFX12: s_lshl4_add_u32 vcc_hi, s1, s2          ; encoding: [0x01,0x02,0xeb,0x88]

s_lshl4_add_u32 m0, s1, s2
// GFX12: s_lshl4_add_u32 m0, s1, s2              ; encoding: [0x01,0x02,0xfd,0x88]

s_lshl4_add_u32 s0, exec_lo, s2
// GFX12: s_lshl4_add_u32 s0, exec_lo, s2         ; encoding: [0x7e,0x02,0x80,0x88]

s_lshl4_add_u32 s0, exec_hi, s2
// GFX12: s_lshl4_add_u32 s0, exec_hi, s2         ; encoding: [0x7f,0x02,0x80,0x88]

s_lshl4_add_u32 s0, vcc_lo, s2
// GFX12: s_lshl4_add_u32 s0, vcc_lo, s2          ; encoding: [0x6a,0x02,0x80,0x88]

s_lshl4_add_u32 s0, vcc_hi, s2
// GFX12: s_lshl4_add_u32 s0, vcc_hi, s2          ; encoding: [0x6b,0x02,0x80,0x88]

s_lshl4_add_u32 s0, m0, s2
// GFX12: s_lshl4_add_u32 s0, m0, s2              ; encoding: [0x7d,0x02,0x80,0x88]

s_lshl4_add_u32 s0, 0, s2
// GFX12: s_lshl4_add_u32 s0, 0, s2               ; encoding: [0x80,0x02,0x80,0x88]

s_lshl4_add_u32 s0, -1, s2
// GFX12: s_lshl4_add_u32 s0, -1, s2              ; encoding: [0xc1,0x02,0x80,0x88]

s_lshl4_add_u32 s0, 0.5, s2
// GFX12: s_lshl4_add_u32 s0, 0.5, s2             ; encoding: [0xf0,0x02,0x80,0x88]

s_lshl4_add_u32 s0, -4.0, s2
// GFX12: s_lshl4_add_u32 s0, -4.0, s2            ; encoding: [0xf7,0x02,0x80,0x88]

s_lshl4_add_u32 s0, 0x3f717273, s2
// GFX12: s_lshl4_add_u32 s0, 0x3f717273, s2      ; encoding: [0xff,0x02,0x80,0x88,0x73,0x72,0x71,0x3f]

s_lshl4_add_u32 s0, 0xaf123456, s2
// GFX12: s_lshl4_add_u32 s0, 0xaf123456, s2      ; encoding: [0xff,0x02,0x80,0x88,0x56,0x34,0x12,0xaf]

s_lshl4_add_u32 s0, s1, exec_lo
// GFX12: s_lshl4_add_u32 s0, s1, exec_lo         ; encoding: [0x01,0x7e,0x80,0x88]

s_lshl4_add_u32 s0, s1, exec_hi
// GFX12: s_lshl4_add_u32 s0, s1, exec_hi         ; encoding: [0x01,0x7f,0x80,0x88]

s_lshl4_add_u32 s0, s1, vcc_lo
// GFX12: s_lshl4_add_u32 s0, s1, vcc_lo          ; encoding: [0x01,0x6a,0x80,0x88]

s_lshl4_add_u32 s0, s1, vcc_hi
// GFX12: s_lshl4_add_u32 s0, s1, vcc_hi          ; encoding: [0x01,0x6b,0x80,0x88]

s_lshl4_add_u32 s0, s1, m0
// GFX12: s_lshl4_add_u32 s0, s1, m0              ; encoding: [0x01,0x7d,0x80,0x88]

s_lshl4_add_u32 s0, s1, 0
// GFX12: s_lshl4_add_u32 s0, s1, 0               ; encoding: [0x01,0x80,0x80,0x88]

s_lshl4_add_u32 s0, s1, -1
// GFX12: s_lshl4_add_u32 s0, s1, -1              ; encoding: [0x01,0xc1,0x80,0x88]

s_lshl4_add_u32 s0, s1, 0.5
// GFX12: s_lshl4_add_u32 s0, s1, 0.5             ; encoding: [0x01,0xf0,0x80,0x88]

s_lshl4_add_u32 s0, s1, -4.0
// GFX12: s_lshl4_add_u32 s0, s1, -4.0            ; encoding: [0x01,0xf7,0x80,0x88]

s_lshl4_add_u32 s0, s1, 0x3f717273
// GFX12: s_lshl4_add_u32 s0, s1, 0x3f717273      ; encoding: [0x01,0xff,0x80,0x88,0x73,0x72,0x71,0x3f]

s_lshl4_add_u32 s0, s1, 0xaf123456
// GFX12: s_lshl4_add_u32 s0, s1, 0xaf123456      ; encoding: [0x01,0xff,0x80,0x88,0x56,0x34,0x12,0xaf]

s_pack_ll_b32_b16 s0, s1, s2
// GFX12: s_pack_ll_b32_b16 s0, s1, s2            ; encoding: [0x01,0x02,0x00,0x99]

s_pack_ll_b32_b16 s105, s104, s103
// GFX12: s_pack_ll_b32_b16 s105, s104, s103      ; encoding: [0x68,0x67,0x69,0x99]

s_pack_ll_b32_b16 s0, s104, s103
// GFX12: s_pack_ll_b32_b16 s0, s104, s103        ; encoding: [0x68,0x67,0x00,0x99]

s_pack_ll_b32_b16 s105, s1, s103
// GFX12: s_pack_ll_b32_b16 s105, s1, s103        ; encoding: [0x01,0x67,0x69,0x99]

s_pack_ll_b32_b16 s105, s104, s2
// GFX12: s_pack_ll_b32_b16 s105, s104, s2        ; encoding: [0x68,0x02,0x69,0x99]

s_pack_ll_b32_b16 s105, s1, s2
// GFX12: s_pack_ll_b32_b16 s105, s1, s2          ; encoding: [0x01,0x02,0x69,0x99]

s_pack_ll_b32_b16 s0, s104, s2
// GFX12: s_pack_ll_b32_b16 s0, s104, s2          ; encoding: [0x68,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, s103
// GFX12: s_pack_ll_b32_b16 s0, s1, s103          ; encoding: [0x01,0x67,0x00,0x99]

s_pack_ll_b32_b16 exec_lo, s1, s2
// GFX12: s_pack_ll_b32_b16 exec_lo, s1, s2       ; encoding: [0x01,0x02,0x7e,0x99]

s_pack_ll_b32_b16 exec_hi, s1, s2
// GFX12: s_pack_ll_b32_b16 exec_hi, s1, s2       ; encoding: [0x01,0x02,0x7f,0x99]

s_pack_ll_b32_b16 vcc_lo, s1, s2
// GFX12: s_pack_ll_b32_b16 vcc_lo, s1, s2        ; encoding: [0x01,0x02,0x6a,0x99]

s_pack_ll_b32_b16 vcc_hi, s1, s2
// GFX12: s_pack_ll_b32_b16 vcc_hi, s1, s2        ; encoding: [0x01,0x02,0x6b,0x99]

s_pack_ll_b32_b16 m0, s1, s2
// GFX12: s_pack_ll_b32_b16 m0, s1, s2            ; encoding: [0x01,0x02,0x7d,0x99]

s_pack_ll_b32_b16 s0, exec_lo, s2
// GFX12: s_pack_ll_b32_b16 s0, exec_lo, s2       ; encoding: [0x7e,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, exec_hi, s2
// GFX12: s_pack_ll_b32_b16 s0, exec_hi, s2       ; encoding: [0x7f,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, vcc_lo, s2
// GFX12: s_pack_ll_b32_b16 s0, vcc_lo, s2        ; encoding: [0x6a,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, vcc_hi, s2
// GFX12: s_pack_ll_b32_b16 s0, vcc_hi, s2        ; encoding: [0x6b,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, m0, s2
// GFX12: s_pack_ll_b32_b16 s0, m0, s2            ; encoding: [0x7d,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, 0, s2
// GFX12: s_pack_ll_b32_b16 s0, 0, s2             ; encoding: [0x80,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, -1, s2
// GFX12: s_pack_ll_b32_b16 s0, -1, s2            ; encoding: [0xc1,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, 0.5, s2
// GFX12: s_pack_ll_b32_b16 s0, 0.5, s2           ; encoding: [0xf0,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, -4.0, s2
// GFX12: s_pack_ll_b32_b16 s0, -4.0, s2          ; encoding: [0xf7,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, 0x3f717273, s2
// GFX12: s_pack_ll_b32_b16 s0, 0x3f717273, s2    ; encoding: [0xff,0x02,0x00,0x99,0x73,0x72,0x71,0x3f]

s_pack_ll_b32_b16 s0, 0xaf123456, s2
// GFX12: s_pack_ll_b32_b16 s0, 0xaf123456, s2    ; encoding: [0xff,0x02,0x00,0x99,0x56,0x34,0x12,0xaf]

s_pack_ll_b32_b16 s0, s1, exec_lo
// GFX12: s_pack_ll_b32_b16 s0, s1, exec_lo       ; encoding: [0x01,0x7e,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, exec_hi
// GFX12: s_pack_ll_b32_b16 s0, s1, exec_hi       ; encoding: [0x01,0x7f,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, vcc_lo
// GFX12: s_pack_ll_b32_b16 s0, s1, vcc_lo        ; encoding: [0x01,0x6a,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, vcc_hi
// GFX12: s_pack_ll_b32_b16 s0, s1, vcc_hi        ; encoding: [0x01,0x6b,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, m0
// GFX12: s_pack_ll_b32_b16 s0, s1, m0            ; encoding: [0x01,0x7d,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, 0
// GFX12: s_pack_ll_b32_b16 s0, s1, 0             ; encoding: [0x01,0x80,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, -1
// GFX12: s_pack_ll_b32_b16 s0, s1, -1            ; encoding: [0x01,0xc1,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, 0.5
// GFX12: s_pack_ll_b32_b16 s0, s1, 0.5           ; encoding: [0x01,0xf0,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, -4.0
// GFX12: s_pack_ll_b32_b16 s0, s1, -4.0          ; encoding: [0x01,0xf7,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, 0x3f717273
// GFX12: s_pack_ll_b32_b16 s0, s1, 0x3f717273    ; encoding: [0x01,0xff,0x00,0x99,0x73,0x72,0x71,0x3f]

s_pack_ll_b32_b16 s0, s1, 0xaf123456
// GFX12: s_pack_ll_b32_b16 s0, s1, 0xaf123456    ; encoding: [0x01,0xff,0x00,0x99,0x56,0x34,0x12,0xaf]

s_pack_lh_b32_b16 s0, s1, s2
// GFX12: s_pack_lh_b32_b16 s0, s1, s2            ; encoding: [0x01,0x02,0x80,0x99]

s_pack_lh_b32_b16 s105, s104, s103
// GFX12: s_pack_lh_b32_b16 s105, s104, s103      ; encoding: [0x68,0x67,0xe9,0x99]

s_pack_lh_b32_b16 s0, s104, s103
// GFX12: s_pack_lh_b32_b16 s0, s104, s103        ; encoding: [0x68,0x67,0x80,0x99]

s_pack_lh_b32_b16 s105, s1, s103
// GFX12: s_pack_lh_b32_b16 s105, s1, s103        ; encoding: [0x01,0x67,0xe9,0x99]

s_pack_lh_b32_b16 s105, s104, s2
// GFX12: s_pack_lh_b32_b16 s105, s104, s2        ; encoding: [0x68,0x02,0xe9,0x99]

s_pack_lh_b32_b16 s105, s1, s2
// GFX12: s_pack_lh_b32_b16 s105, s1, s2          ; encoding: [0x01,0x02,0xe9,0x99]

s_pack_lh_b32_b16 s0, s104, s2
// GFX12: s_pack_lh_b32_b16 s0, s104, s2          ; encoding: [0x68,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, s103
// GFX12: s_pack_lh_b32_b16 s0, s1, s103          ; encoding: [0x01,0x67,0x80,0x99]

s_pack_lh_b32_b16 exec_lo, s1, s2
// GFX12: s_pack_lh_b32_b16 exec_lo, s1, s2       ; encoding: [0x01,0x02,0xfe,0x99]

s_pack_lh_b32_b16 exec_hi, s1, s2
// GFX12: s_pack_lh_b32_b16 exec_hi, s1, s2       ; encoding: [0x01,0x02,0xff,0x99]

s_pack_lh_b32_b16 vcc_lo, s1, s2
// GFX12: s_pack_lh_b32_b16 vcc_lo, s1, s2        ; encoding: [0x01,0x02,0xea,0x99]

s_pack_lh_b32_b16 vcc_hi, s1, s2
// GFX12: s_pack_lh_b32_b16 vcc_hi, s1, s2        ; encoding: [0x01,0x02,0xeb,0x99]

s_pack_lh_b32_b16 m0, s1, s2
// GFX12: s_pack_lh_b32_b16 m0, s1, s2            ; encoding: [0x01,0x02,0xfd,0x99]

s_pack_lh_b32_b16 s0, exec_lo, s2
// GFX12: s_pack_lh_b32_b16 s0, exec_lo, s2       ; encoding: [0x7e,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, exec_hi, s2
// GFX12: s_pack_lh_b32_b16 s0, exec_hi, s2       ; encoding: [0x7f,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, vcc_lo, s2
// GFX12: s_pack_lh_b32_b16 s0, vcc_lo, s2        ; encoding: [0x6a,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, vcc_hi, s2
// GFX12: s_pack_lh_b32_b16 s0, vcc_hi, s2        ; encoding: [0x6b,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, m0, s2
// GFX12: s_pack_lh_b32_b16 s0, m0, s2            ; encoding: [0x7d,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, 0, s2
// GFX12: s_pack_lh_b32_b16 s0, 0, s2             ; encoding: [0x80,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, -1, s2
// GFX12: s_pack_lh_b32_b16 s0, -1, s2            ; encoding: [0xc1,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, 0.5, s2
// GFX12: s_pack_lh_b32_b16 s0, 0.5, s2           ; encoding: [0xf0,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, -4.0, s2
// GFX12: s_pack_lh_b32_b16 s0, -4.0, s2          ; encoding: [0xf7,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, 0x3f717273, s2
// GFX12: s_pack_lh_b32_b16 s0, 0x3f717273, s2    ; encoding: [0xff,0x02,0x80,0x99,0x73,0x72,0x71,0x3f]

s_pack_lh_b32_b16 s0, 0xaf123456, s2
// GFX12: s_pack_lh_b32_b16 s0, 0xaf123456, s2    ; encoding: [0xff,0x02,0x80,0x99,0x56,0x34,0x12,0xaf]

s_pack_lh_b32_b16 s0, s1, exec_lo
// GFX12: s_pack_lh_b32_b16 s0, s1, exec_lo       ; encoding: [0x01,0x7e,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, exec_hi
// GFX12: s_pack_lh_b32_b16 s0, s1, exec_hi       ; encoding: [0x01,0x7f,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, vcc_lo
// GFX12: s_pack_lh_b32_b16 s0, s1, vcc_lo        ; encoding: [0x01,0x6a,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, vcc_hi
// GFX12: s_pack_lh_b32_b16 s0, s1, vcc_hi        ; encoding: [0x01,0x6b,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, m0
// GFX12: s_pack_lh_b32_b16 s0, s1, m0            ; encoding: [0x01,0x7d,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, 0
// GFX12: s_pack_lh_b32_b16 s0, s1, 0             ; encoding: [0x01,0x80,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, -1
// GFX12: s_pack_lh_b32_b16 s0, s1, -1            ; encoding: [0x01,0xc1,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, 0.5
// GFX12: s_pack_lh_b32_b16 s0, s1, 0.5           ; encoding: [0x01,0xf0,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, -4.0
// GFX12: s_pack_lh_b32_b16 s0, s1, -4.0          ; encoding: [0x01,0xf7,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, 0x3f717273
// GFX12: s_pack_lh_b32_b16 s0, s1, 0x3f717273    ; encoding: [0x01,0xff,0x80,0x99,0x73,0x72,0x71,0x3f]

s_pack_lh_b32_b16 s0, s1, 0xaf123456
// GFX12: s_pack_lh_b32_b16 s0, s1, 0xaf123456    ; encoding: [0x01,0xff,0x80,0x99,0x56,0x34,0x12,0xaf]

s_pack_hh_b32_b16 s0, s1, s2
// GFX12: s_pack_hh_b32_b16 s0, s1, s2            ; encoding: [0x01,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s105, s104, s103
// GFX12: s_pack_hh_b32_b16 s105, s104, s103      ; encoding: [0x68,0x67,0x69,0x9a]

s_pack_hh_b32_b16 s0, s104, s103
// GFX12: s_pack_hh_b32_b16 s0, s104, s103        ; encoding: [0x68,0x67,0x00,0x9a]

s_pack_hh_b32_b16 s105, s1, s103
// GFX12: s_pack_hh_b32_b16 s105, s1, s103        ; encoding: [0x01,0x67,0x69,0x9a]

s_pack_hh_b32_b16 s105, s104, s2
// GFX12: s_pack_hh_b32_b16 s105, s104, s2        ; encoding: [0x68,0x02,0x69,0x9a]

s_pack_hh_b32_b16 s105, s1, s2
// GFX12: s_pack_hh_b32_b16 s105, s1, s2          ; encoding: [0x01,0x02,0x69,0x9a]

s_pack_hh_b32_b16 s0, s104, s2
// GFX12: s_pack_hh_b32_b16 s0, s104, s2          ; encoding: [0x68,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, s103
// GFX12: s_pack_hh_b32_b16 s0, s1, s103          ; encoding: [0x01,0x67,0x00,0x9a]

s_pack_hh_b32_b16 exec_lo, s1, s2
// GFX12: s_pack_hh_b32_b16 exec_lo, s1, s2       ; encoding: [0x01,0x02,0x7e,0x9a]

s_pack_hh_b32_b16 exec_hi, s1, s2
// GFX12: s_pack_hh_b32_b16 exec_hi, s1, s2       ; encoding: [0x01,0x02,0x7f,0x9a]

s_pack_hh_b32_b16 vcc_lo, s1, s2
// GFX12: s_pack_hh_b32_b16 vcc_lo, s1, s2        ; encoding: [0x01,0x02,0x6a,0x9a]

s_pack_hh_b32_b16 vcc_hi, s1, s2
// GFX12: s_pack_hh_b32_b16 vcc_hi, s1, s2        ; encoding: [0x01,0x02,0x6b,0x9a]

s_pack_hh_b32_b16 m0, s1, s2
// GFX12: s_pack_hh_b32_b16 m0, s1, s2            ; encoding: [0x01,0x02,0x7d,0x9a]

s_pack_hh_b32_b16 s0, exec_lo, s2
// GFX12: s_pack_hh_b32_b16 s0, exec_lo, s2       ; encoding: [0x7e,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, exec_hi, s2
// GFX12: s_pack_hh_b32_b16 s0, exec_hi, s2       ; encoding: [0x7f,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, vcc_lo, s2
// GFX12: s_pack_hh_b32_b16 s0, vcc_lo, s2        ; encoding: [0x6a,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, vcc_hi, s2
// GFX12: s_pack_hh_b32_b16 s0, vcc_hi, s2        ; encoding: [0x6b,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, m0, s2
// GFX12: s_pack_hh_b32_b16 s0, m0, s2            ; encoding: [0x7d,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, 0, s2
// GFX12: s_pack_hh_b32_b16 s0, 0, s2             ; encoding: [0x80,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, -1, s2
// GFX12: s_pack_hh_b32_b16 s0, -1, s2            ; encoding: [0xc1,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, 0.5, s2
// GFX12: s_pack_hh_b32_b16 s0, 0.5, s2           ; encoding: [0xf0,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, -4.0, s2
// GFX12: s_pack_hh_b32_b16 s0, -4.0, s2          ; encoding: [0xf7,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, 0x3f717273, s2
// GFX12: s_pack_hh_b32_b16 s0, 0x3f717273, s2    ; encoding: [0xff,0x02,0x00,0x9a,0x73,0x72,0x71,0x3f]

s_pack_hh_b32_b16 s0, 0xaf123456, s2
// GFX12: s_pack_hh_b32_b16 s0, 0xaf123456, s2    ; encoding: [0xff,0x02,0x00,0x9a,0x56,0x34,0x12,0xaf]

s_pack_hh_b32_b16 s0, s1, exec_lo
// GFX12: s_pack_hh_b32_b16 s0, s1, exec_lo       ; encoding: [0x01,0x7e,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, exec_hi
// GFX12: s_pack_hh_b32_b16 s0, s1, exec_hi       ; encoding: [0x01,0x7f,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, vcc_lo
// GFX12: s_pack_hh_b32_b16 s0, s1, vcc_lo        ; encoding: [0x01,0x6a,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, vcc_hi
// GFX12: s_pack_hh_b32_b16 s0, s1, vcc_hi        ; encoding: [0x01,0x6b,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, m0
// GFX12: s_pack_hh_b32_b16 s0, s1, m0            ; encoding: [0x01,0x7d,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, 0
// GFX12: s_pack_hh_b32_b16 s0, s1, 0             ; encoding: [0x01,0x80,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, -1
// GFX12: s_pack_hh_b32_b16 s0, s1, -1            ; encoding: [0x01,0xc1,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, 0.5
// GFX12: s_pack_hh_b32_b16 s0, s1, 0.5           ; encoding: [0x01,0xf0,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, -4.0
// GFX12: s_pack_hh_b32_b16 s0, s1, -4.0          ; encoding: [0x01,0xf7,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, 0x3f717273
// GFX12: s_pack_hh_b32_b16 s0, s1, 0x3f717273    ; encoding: [0x01,0xff,0x00,0x9a,0x73,0x72,0x71,0x3f]

s_pack_hh_b32_b16 s0, s1, 0xaf123456
// GFX12: s_pack_hh_b32_b16 s0, s1, 0xaf123456    ; encoding: [0x01,0xff,0x00,0x9a,0x56,0x34,0x12,0xaf]

s_mul_hi_u32 s0, s1, s2
// GFX12: s_mul_hi_u32 s0, s1, s2                 ; encoding: [0x01,0x02,0x80,0x96]

s_mul_hi_u32 s105, s104, s103
// GFX12: s_mul_hi_u32 s105, s104, s103           ; encoding: [0x68,0x67,0xe9,0x96]

s_mul_hi_u32 s0, s104, s103
// GFX12: s_mul_hi_u32 s0, s104, s103             ; encoding: [0x68,0x67,0x80,0x96]

s_mul_hi_u32 s105, s1, s103
// GFX12: s_mul_hi_u32 s105, s1, s103             ; encoding: [0x01,0x67,0xe9,0x96]

s_mul_hi_u32 s105, s104, s2
// GFX12: s_mul_hi_u32 s105, s104, s2             ; encoding: [0x68,0x02,0xe9,0x96]

s_mul_hi_u32 s105, s1, s2
// GFX12: s_mul_hi_u32 s105, s1, s2               ; encoding: [0x01,0x02,0xe9,0x96]

s_mul_hi_u32 s0, s104, s2
// GFX12: s_mul_hi_u32 s0, s104, s2               ; encoding: [0x68,0x02,0x80,0x96]

s_mul_hi_u32 s0, s1, s103
// GFX12: s_mul_hi_u32 s0, s1, s103               ; encoding: [0x01,0x67,0x80,0x96]

s_mul_hi_u32 exec_lo, s1, s2
// GFX12: s_mul_hi_u32 exec_lo, s1, s2            ; encoding: [0x01,0x02,0xfe,0x96]

s_mul_hi_u32 exec_hi, s1, s2
// GFX12: s_mul_hi_u32 exec_hi, s1, s2            ; encoding: [0x01,0x02,0xff,0x96]

s_mul_hi_u32 vcc_lo, s1, s2
// GFX12: s_mul_hi_u32 vcc_lo, s1, s2             ; encoding: [0x01,0x02,0xea,0x96]

s_mul_hi_u32 vcc_hi, s1, s2
// GFX12: s_mul_hi_u32 vcc_hi, s1, s2             ; encoding: [0x01,0x02,0xeb,0x96]

s_mul_hi_u32 m0, s1, s2
// GFX12: s_mul_hi_u32 m0, s1, s2                 ; encoding: [0x01,0x02,0xfd,0x96]

s_mul_hi_u32 s0, exec_lo, s2
// GFX12: s_mul_hi_u32 s0, exec_lo, s2            ; encoding: [0x7e,0x02,0x80,0x96]

s_mul_hi_u32 s0, exec_hi, s2
// GFX12: s_mul_hi_u32 s0, exec_hi, s2            ; encoding: [0x7f,0x02,0x80,0x96]

s_mul_hi_u32 s0, vcc_lo, s2
// GFX12: s_mul_hi_u32 s0, vcc_lo, s2             ; encoding: [0x6a,0x02,0x80,0x96]

s_mul_hi_u32 s0, vcc_hi, s2
// GFX12: s_mul_hi_u32 s0, vcc_hi, s2             ; encoding: [0x6b,0x02,0x80,0x96]

s_mul_hi_u32 s0, m0, s2
// GFX12: s_mul_hi_u32 s0, m0, s2                 ; encoding: [0x7d,0x02,0x80,0x96]

s_mul_hi_u32 s0, 0, s2
// GFX12: s_mul_hi_u32 s0, 0, s2                  ; encoding: [0x80,0x02,0x80,0x96]

s_mul_hi_u32 s0, -1, s2
// GFX12: s_mul_hi_u32 s0, -1, s2                 ; encoding: [0xc1,0x02,0x80,0x96]

s_mul_hi_u32 s0, 0.5, s2
// GFX12: s_mul_hi_u32 s0, 0.5, s2                ; encoding: [0xf0,0x02,0x80,0x96]

s_mul_hi_u32 s0, -4.0, s2
// GFX12: s_mul_hi_u32 s0, -4.0, s2               ; encoding: [0xf7,0x02,0x80,0x96]

s_mul_hi_u32 s0, 0x3f717273, s2
// GFX12: s_mul_hi_u32 s0, 0x3f717273, s2         ; encoding: [0xff,0x02,0x80,0x96,0x73,0x72,0x71,0x3f]

s_mul_hi_u32 s0, 0xaf123456, s2
// GFX12: s_mul_hi_u32 s0, 0xaf123456, s2         ; encoding: [0xff,0x02,0x80,0x96,0x56,0x34,0x12,0xaf]

s_mul_hi_u32 s0, s1, exec_lo
// GFX12: s_mul_hi_u32 s0, s1, exec_lo            ; encoding: [0x01,0x7e,0x80,0x96]

s_mul_hi_u32 s0, s1, exec_hi
// GFX12: s_mul_hi_u32 s0, s1, exec_hi            ; encoding: [0x01,0x7f,0x80,0x96]

s_mul_hi_u32 s0, s1, vcc_lo
// GFX12: s_mul_hi_u32 s0, s1, vcc_lo             ; encoding: [0x01,0x6a,0x80,0x96]

s_mul_hi_u32 s0, s1, vcc_hi
// GFX12: s_mul_hi_u32 s0, s1, vcc_hi             ; encoding: [0x01,0x6b,0x80,0x96]

s_mul_hi_u32 s0, s1, m0
// GFX12: s_mul_hi_u32 s0, s1, m0                 ; encoding: [0x01,0x7d,0x80,0x96]

s_mul_hi_u32 s0, s1, 0
// GFX12: s_mul_hi_u32 s0, s1, 0                  ; encoding: [0x01,0x80,0x80,0x96]

s_mul_hi_u32 s0, s1, -1
// GFX12: s_mul_hi_u32 s0, s1, -1                 ; encoding: [0x01,0xc1,0x80,0x96]

s_mul_hi_u32 s0, s1, 0.5
// GFX12: s_mul_hi_u32 s0, s1, 0.5                ; encoding: [0x01,0xf0,0x80,0x96]

s_mul_hi_u32 s0, s1, -4.0
// GFX12: s_mul_hi_u32 s0, s1, -4.0               ; encoding: [0x01,0xf7,0x80,0x96]

s_mul_hi_u32 s0, s1, 0x3f717273
// GFX12: s_mul_hi_u32 s0, s1, 0x3f717273         ; encoding: [0x01,0xff,0x80,0x96,0x73,0x72,0x71,0x3f]

s_mul_hi_u32 s0, s1, 0xaf123456
// GFX12: s_mul_hi_u32 s0, s1, 0xaf123456         ; encoding: [0x01,0xff,0x80,0x96,0x56,0x34,0x12,0xaf]

s_mul_hi_i32 s0, s1, s2
// GFX12: s_mul_hi_i32 s0, s1, s2                 ; encoding: [0x01,0x02,0x00,0x97]

s_mul_hi_i32 s105, s104, s103
// GFX12: s_mul_hi_i32 s105, s104, s103           ; encoding: [0x68,0x67,0x69,0x97]

s_mul_hi_i32 s0, s104, s103
// GFX12: s_mul_hi_i32 s0, s104, s103             ; encoding: [0x68,0x67,0x00,0x97]

s_mul_hi_i32 s105, s1, s103
// GFX12: s_mul_hi_i32 s105, s1, s103             ; encoding: [0x01,0x67,0x69,0x97]

s_mul_hi_i32 s105, s104, s2
// GFX12: s_mul_hi_i32 s105, s104, s2             ; encoding: [0x68,0x02,0x69,0x97]

s_mul_hi_i32 s105, s1, s2
// GFX12: s_mul_hi_i32 s105, s1, s2               ; encoding: [0x01,0x02,0x69,0x97]

s_mul_hi_i32 s0, s104, s2
// GFX12: s_mul_hi_i32 s0, s104, s2               ; encoding: [0x68,0x02,0x00,0x97]

s_mul_hi_i32 s0, s1, s103
// GFX12: s_mul_hi_i32 s0, s1, s103               ; encoding: [0x01,0x67,0x00,0x97]

s_mul_hi_i32 exec_lo, s1, s2
// GFX12: s_mul_hi_i32 exec_lo, s1, s2            ; encoding: [0x01,0x02,0x7e,0x97]

s_mul_hi_i32 exec_hi, s1, s2
// GFX12: s_mul_hi_i32 exec_hi, s1, s2            ; encoding: [0x01,0x02,0x7f,0x97]

s_mul_hi_i32 vcc_lo, s1, s2
// GFX12: s_mul_hi_i32 vcc_lo, s1, s2             ; encoding: [0x01,0x02,0x6a,0x97]

s_mul_hi_i32 vcc_hi, s1, s2
// GFX12: s_mul_hi_i32 vcc_hi, s1, s2             ; encoding: [0x01,0x02,0x6b,0x97]

s_mul_hi_i32 m0, s1, s2
// GFX12: s_mul_hi_i32 m0, s1, s2                 ; encoding: [0x01,0x02,0x7d,0x97]

s_mul_hi_i32 s0, exec_lo, s2
// GFX12: s_mul_hi_i32 s0, exec_lo, s2            ; encoding: [0x7e,0x02,0x00,0x97]

s_mul_hi_i32 s0, exec_hi, s2
// GFX12: s_mul_hi_i32 s0, exec_hi, s2            ; encoding: [0x7f,0x02,0x00,0x97]

s_mul_hi_i32 s0, vcc_lo, s2
// GFX12: s_mul_hi_i32 s0, vcc_lo, s2             ; encoding: [0x6a,0x02,0x00,0x97]

s_mul_hi_i32 s0, vcc_hi, s2
// GFX12: s_mul_hi_i32 s0, vcc_hi, s2             ; encoding: [0x6b,0x02,0x00,0x97]

s_mul_hi_i32 s0, m0, s2
// GFX12: s_mul_hi_i32 s0, m0, s2                 ; encoding: [0x7d,0x02,0x00,0x97]

s_mul_hi_i32 s0, 0, s2
// GFX12: s_mul_hi_i32 s0, 0, s2                  ; encoding: [0x80,0x02,0x00,0x97]

s_mul_hi_i32 s0, -1, s2
// GFX12: s_mul_hi_i32 s0, -1, s2                 ; encoding: [0xc1,0x02,0x00,0x97]

s_mul_hi_i32 s0, 0.5, s2
// GFX12: s_mul_hi_i32 s0, 0.5, s2                ; encoding: [0xf0,0x02,0x00,0x97]

s_mul_hi_i32 s0, -4.0, s2
// GFX12: s_mul_hi_i32 s0, -4.0, s2               ; encoding: [0xf7,0x02,0x00,0x97]

s_mul_hi_i32 s0, 0x3f717273, s2
// GFX12: s_mul_hi_i32 s0, 0x3f717273, s2         ; encoding: [0xff,0x02,0x00,0x97,0x73,0x72,0x71,0x3f]

s_mul_hi_i32 s0, 0xaf123456, s2
// GFX12: s_mul_hi_i32 s0, 0xaf123456, s2         ; encoding: [0xff,0x02,0x00,0x97,0x56,0x34,0x12,0xaf]

s_mul_hi_i32 s0, s1, exec_lo
// GFX12: s_mul_hi_i32 s0, s1, exec_lo            ; encoding: [0x01,0x7e,0x00,0x97]

s_mul_hi_i32 s0, s1, exec_hi
// GFX12: s_mul_hi_i32 s0, s1, exec_hi            ; encoding: [0x01,0x7f,0x00,0x97]

s_mul_hi_i32 s0, s1, vcc_lo
// GFX12: s_mul_hi_i32 s0, s1, vcc_lo             ; encoding: [0x01,0x6a,0x00,0x97]

s_mul_hi_i32 s0, s1, vcc_hi
// GFX12: s_mul_hi_i32 s0, s1, vcc_hi             ; encoding: [0x01,0x6b,0x00,0x97]

s_mul_hi_i32 s0, s1, m0
// GFX12: s_mul_hi_i32 s0, s1, m0                 ; encoding: [0x01,0x7d,0x00,0x97]

s_mul_hi_i32 s0, s1, 0
// GFX12: s_mul_hi_i32 s0, s1, 0                  ; encoding: [0x01,0x80,0x00,0x97]

s_mul_hi_i32 s0, s1, -1
// GFX12: s_mul_hi_i32 s0, s1, -1                 ; encoding: [0x01,0xc1,0x00,0x97]

s_mul_hi_i32 s0, s1, 0.5
// GFX12: s_mul_hi_i32 s0, s1, 0.5                ; encoding: [0x01,0xf0,0x00,0x97]

s_mul_hi_i32 s0, s1, -4.0
// GFX12: s_mul_hi_i32 s0, s1, -4.0               ; encoding: [0x01,0xf7,0x00,0x97]

s_mul_hi_i32 s0, s1, 0x3f717273
// GFX12: s_mul_hi_i32 s0, s1, 0x3f717273         ; encoding: [0x01,0xff,0x00,0x97,0x73,0x72,0x71,0x3f]

s_mul_hi_i32 s0, s1, 0xaf123456
// GFX12: s_mul_hi_i32 s0, s1, 0xaf123456         ; encoding: [0x01,0xff,0x00,0x97,0x56,0x34,0x12,0xaf]

s_or_not1_b32 s5, s1, s2
// GFX12: s_or_not1_b32 s5, s1, s2                ; encoding: [0x01,0x02,0x05,0x92]

s_or_not1_b32 s5, s105, s105
// GFX12: s_or_not1_b32 s5, s105, s105            ; encoding: [0x69,0x69,0x05,0x92]

s_or_not1_b32 s5, vcc_lo, ttmp15
// GFX12: s_or_not1_b32 s5, vcc_lo, ttmp15        ; encoding: [0x6a,0x7b,0x05,0x92]

s_or_not1_b32 s5, vcc_hi, 0xaf123456
// GFX12: s_or_not1_b32 s5, vcc_hi, 0xaf123456    ; encoding: [0x6b,0xff,0x05,0x92,0x56,0x34,0x12,0xaf]

s_or_not1_b32 s5, ttmp15, src_scc
// GFX12: s_or_not1_b32 s5, ttmp15, src_scc       ; encoding: [0x7b,0xfd,0x05,0x92]

s_or_not1_b32 s105, m0, 0.5
// GFX12: s_or_not1_b32 s105, m0, 0.5             ; encoding: [0x7d,0xf0,0x69,0x92]

s_or_not1_b32 vcc_lo, exec_lo, -1
// GFX12: s_or_not1_b32 vcc_lo, exec_lo, -1       ; encoding: [0x7e,0xc1,0x6a,0x92]

s_or_not1_b32 vcc_hi, exec_hi, null
// GFX12: s_or_not1_b32 vcc_hi, exec_hi, null     ; encoding: [0x7f,0x7c,0x6b,0x92]

s_or_not1_b32 ttmp15, null, exec_lo
// GFX12: s_or_not1_b32 ttmp15, null, exec_lo     ; encoding: [0x7c,0x7e,0x7b,0x92]

s_or_not1_b32 m0, -1, exec_hi
// GFX12: s_or_not1_b32 m0, -1, exec_hi           ; encoding: [0xc1,0x7f,0x7d,0x92]

s_or_not1_b32 exec_lo, 0.5, m0
// GFX12: s_or_not1_b32 exec_lo, 0.5, m0          ; encoding: [0xf0,0x7d,0x7e,0x92]

s_or_not1_b32 exec_hi, src_scc, vcc_lo
// GFX12: s_or_not1_b32 exec_hi, src_scc, vcc_lo  ; encoding: [0xfd,0x6a,0x7f,0x92]

s_or_not1_b32 null, 0xaf123456, vcc_hi
// GFX12: s_or_not1_b32 null, 0xaf123456, vcc_hi  ; encoding: [0xff,0x6b,0x7c,0x92,0x56,0x34,0x12,0xaf]

s_pack_hl_b32_b16 s5, s1, s2
// GFX12: s_pack_hl_b32_b16 s5, s1, s2            ; encoding: [0x01,0x02,0x85,0x9a]

s_pack_hl_b32_b16 s5, s105, s105
// GFX12: s_pack_hl_b32_b16 s5, s105, s105        ; encoding: [0x69,0x69,0x85,0x9a]

s_pack_hl_b32_b16 s5, vcc_lo, ttmp15
// GFX12: s_pack_hl_b32_b16 s5, vcc_lo, ttmp15    ; encoding: [0x6a,0x7b,0x85,0x9a]

s_pack_hl_b32_b16 s5, vcc_hi, 0xfe0b
// GFX12: s_pack_hl_b32_b16 s5, vcc_hi, 0xfe0b    ; encoding: [0x6b,0xff,0x85,0x9a,0x0b,0xfe,0x00,0x00]

s_pack_hl_b32_b16 s5, ttmp15, src_scc
// GFX12: s_pack_hl_b32_b16 s5, ttmp15, src_scc   ; encoding: [0x7b,0xfd,0x85,0x9a]

s_pack_hl_b32_b16 s105, m0, 0.5
// GFX12: s_pack_hl_b32_b16 s105, m0, 0.5         ; encoding: [0x7d,0xf0,0xe9,0x9a]

s_pack_hl_b32_b16 vcc_lo, exec_lo, -1
// GFX12: s_pack_hl_b32_b16 vcc_lo, exec_lo, -1   ; encoding: [0x7e,0xc1,0xea,0x9a]

s_pack_hl_b32_b16 vcc_hi, exec_hi, null
// GFX12: s_pack_hl_b32_b16 vcc_hi, exec_hi, null ; encoding: [0x7f,0x7c,0xeb,0x9a]

s_pack_hl_b32_b16 ttmp15, null, exec_lo
// GFX12: s_pack_hl_b32_b16 ttmp15, null, exec_lo ; encoding: [0x7c,0x7e,0xfb,0x9a]

s_pack_hl_b32_b16 m0, -1, exec_hi
// GFX12: s_pack_hl_b32_b16 m0, -1, exec_hi       ; encoding: [0xc1,0x7f,0xfd,0x9a]

s_pack_hl_b32_b16 exec_lo, 0.5, m0
// GFX12: s_pack_hl_b32_b16 exec_lo, 0.5, m0      ; encoding: [0xf0,0x7d,0xfe,0x9a]

s_pack_hl_b32_b16 exec_hi, src_scc, vcc_lo
// GFX12: s_pack_hl_b32_b16 exec_hi, src_scc, vcc_lo ; encoding: [0xfd,0x6a,0xff,0x9a]

s_pack_hl_b32_b16 null, 0xaf123456, vcc_hi
// GFX12: s_pack_hl_b32_b16 null, 0xaf123456, vcc_hi ; encoding: [0xff,0x6b,0xfc,0x9a,0x56,0x34,0x12,0xaf]

s_and_not1_b32 s5, s1, s2
// GFX12: s_and_not1_b32 s5, s1, s2               ; encoding: [0x01,0x02,0x05,0x91]

s_and_not1_b32 s5, s105, s105
// GFX12: s_and_not1_b32 s5, s105, s105           ; encoding: [0x69,0x69,0x05,0x91]

s_and_not1_b32 s5, vcc_lo, ttmp15
// GFX12: s_and_not1_b32 s5, vcc_lo, ttmp15       ; encoding: [0x6a,0x7b,0x05,0x91]

s_and_not1_b32 s5, vcc_hi, 0xaf123456
// GFX12: s_and_not1_b32 s5, vcc_hi, 0xaf123456   ; encoding: [0x6b,0xff,0x05,0x91,0x56,0x34,0x12,0xaf]

s_and_not1_b32 s5, ttmp15, src_scc
// GFX12: s_and_not1_b32 s5, ttmp15, src_scc      ; encoding: [0x7b,0xfd,0x05,0x91]

s_and_not1_b32 s105, m0, 0.5
// GFX12: s_and_not1_b32 s105, m0, 0.5            ; encoding: [0x7d,0xf0,0x69,0x91]

s_and_not1_b32 vcc_lo, exec_lo, -1
// GFX12: s_and_not1_b32 vcc_lo, exec_lo, -1      ; encoding: [0x7e,0xc1,0x6a,0x91]

s_and_not1_b32 vcc_hi, exec_hi, null
// GFX12: s_and_not1_b32 vcc_hi, exec_hi, null    ; encoding: [0x7f,0x7c,0x6b,0x91]

s_and_not1_b32 ttmp15, null, exec_lo
// GFX12: s_and_not1_b32 ttmp15, null, exec_lo    ; encoding: [0x7c,0x7e,0x7b,0x91]

s_and_not1_b32 m0, -1, exec_hi
// GFX12: s_and_not1_b32 m0, -1, exec_hi          ; encoding: [0xc1,0x7f,0x7d,0x91]

s_and_not1_b32 exec_lo, 0.5, m0
// GFX12: s_and_not1_b32 exec_lo, 0.5, m0         ; encoding: [0xf0,0x7d,0x7e,0x91]

s_and_not1_b32 exec_hi, src_scc, vcc_lo
// GFX12: s_and_not1_b32 exec_hi, src_scc, vcc_lo ; encoding: [0xfd,0x6a,0x7f,0x91]

s_and_not1_b32 null, 0xaf123456, vcc_hi
// GFX12: s_and_not1_b32 null, 0xaf123456, vcc_hi ; encoding: [0xff,0x6b,0x7c,0x91,0x56,0x34,0x12,0xaf]

s_and_not1_b64 s[10:11], s[2:3], s[4:5]
// GFX12: s_and_not1_b64 s[10:11], s[2:3], s[4:5] ; encoding: [0x02,0x04,0x8a,0x91]

s_and_not1_b64 s[10:11], s[104:105], s[104:105]
// GFX12: s_and_not1_b64 s[10:11], s[104:105], s[104:105] ; encoding: [0x68,0x68,0x8a,0x91]

s_and_not1_b64 s[10:11], vcc, ttmp[14:15]
// GFX12: s_and_not1_b64 s[10:11], vcc, ttmp[14:15] ; encoding: [0x6a,0x7a,0x8a,0x91]

s_and_not1_b64 s[10:11], ttmp[14:15], 0xaf123456
// GFX12: s_and_not1_b64 s[10:11], ttmp[14:15], 0xaf123456 ; encoding: [0x7a,0xff,0x8a,0x91,0x56,0x34,0x12,0xaf]

s_and_not1_b64 s[10:11], exec, src_scc
// GFX12: s_and_not1_b64 s[10:11], exec, src_scc  ; encoding: [0x7e,0xfd,0x8a,0x91]

s_and_not1_b64 s[104:105], null, 0.5
// GFX12: s_and_not1_b64 s[104:105], null, 0.5    ; encoding: [0x7c,0xf0,0xe8,0x91]

s_and_not1_b64 vcc, -1, -1
// GFX12: s_and_not1_b64 vcc, -1, -1              ; encoding: [0xc1,0xc1,0xea,0x91]

s_and_not1_b64 ttmp[14:15], 0.5, null
// GFX12: s_and_not1_b64 ttmp[14:15], 0.5, null   ; encoding: [0xf0,0x7c,0xfa,0x91]

s_and_not1_b64 exec, src_scc, exec
// GFX12: s_and_not1_b64 exec, src_scc, exec      ; encoding: [0xfd,0x7e,0xfe,0x91]

s_and_not1_b64 null, 0xaf123456, vcc
// GFX12: s_and_not1_b64 null, 0xaf123456, vcc    ; encoding: [0xff,0x6a,0xfc,0x91,0x56,0x34,0x12,0xaf]

s_or_not1_b64 s[10:11], s[2:3], s[4:5]
// GFX12: s_or_not1_b64 s[10:11], s[2:3], s[4:5]  ; encoding: [0x02,0x04,0x8a,0x92]

s_or_not1_b64 s[10:11], s[104:105], s[104:105]
// GFX12: s_or_not1_b64 s[10:11], s[104:105], s[104:105] ; encoding: [0x68,0x68,0x8a,0x92]

s_or_not1_b64 s[10:11], vcc, ttmp[14:15]
// GFX12: s_or_not1_b64 s[10:11], vcc, ttmp[14:15] ; encoding: [0x6a,0x7a,0x8a,0x92]

s_or_not1_b64 s[10:11], ttmp[14:15], 0xaf123456
// GFX12: s_or_not1_b64 s[10:11], ttmp[14:15], 0xaf123456 ; encoding: [0x7a,0xff,0x8a,0x92,0x56,0x34,0x12,0xaf]

s_or_not1_b64 s[10:11], exec, src_scc
// GFX12: s_or_not1_b64 s[10:11], exec, src_scc   ; encoding: [0x7e,0xfd,0x8a,0x92]

s_or_not1_b64 s[104:105], null, 0.5
// GFX12: s_or_not1_b64 s[104:105], null, 0.5     ; encoding: [0x7c,0xf0,0xe8,0x92]

s_or_not1_b64 vcc, -1, -1
// GFX12: s_or_not1_b64 vcc, -1, -1               ; encoding: [0xc1,0xc1,0xea,0x92]

s_or_not1_b64 ttmp[14:15], 0.5, null
// GFX12: s_or_not1_b64 ttmp[14:15], 0.5, null    ; encoding: [0xf0,0x7c,0xfa,0x92]

s_or_not1_b64 exec, src_scc, exec
// GFX12: s_or_not1_b64 exec, src_scc, exec       ; encoding: [0xfd,0x7e,0xfe,0x92]

s_or_not1_b64 null, 0xaf123456, vcc
// GFX12: s_or_not1_b64 null, 0xaf123456, vcc     ; encoding: [0xff,0x6a,0xfc,0x92,0x56,0x34,0x12,0xaf]
