/* Generated by re2c */
#line 1 "real_world/scanner.re"
// re2c $INPUT -o $OUTPUT 
/* Id: scanner.re,v 1.37 2006/02/25 12:41:41 helly Exp */
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <sstream>
#include "scanner.h"
#include "parser.h"
#include "y.tab.h"
#include "globals.h"
#include "dfa.h"

extern YYSTYPE yylval;

#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif

#define	BSIZE	8192

#define	YYCTYPE		char
#define	YYCURSOR	cursor
#define	YYLIMIT		lim
#define	YYMARKER	ptr
#define	YYFILL(n)	{cursor = fill(cursor);}

#define	RETURN(i)	{cur = cursor; return i;}

namespace re2c
{

Scanner::Scanner(std::istream& i, std::ostream& o)
	: in(i)
	, out(o)
	, bot(NULL), tok(NULL), ptr(NULL), cur(NULL), pos(NULL), lim(NULL)
	, top(NULL), eof(NULL), tchar(0), tline(0), cline(1), iscfg(0)
{
    ;
}

char *Scanner::fill(char *cursor)
{
	if(!eof)
	{
		uint cnt = tok - bot;
		if(cnt)
		{
			memcpy(bot, tok, lim - tok);
			tok = bot;
			ptr -= cnt;
			cursor -= cnt;
			pos -= cnt;
			lim -= cnt;
		}
		if((top - lim) < BSIZE)
		{
			char *buf = new char[(lim - bot) + BSIZE];
			memcpy(buf, tok, lim - tok);
			tok = buf;
			ptr = &buf[ptr - bot];
			cursor = &buf[cursor - bot];
			pos = &buf[pos - bot];
			lim = &buf[lim - bot];
			top = &lim[BSIZE];
			delete [] bot;
			bot = buf;
		}
		in.read(lim, BSIZE);
		if ((cnt = in.gcount()) != BSIZE )
		{
			eof = &lim[cnt]; *eof++ = '\0';
		}
		lim += cnt;
	}
	return cursor;
}

#line 96 "real_world/scanner.re"


int Scanner::echo()
{
    char *cursor = cur;
    bool ignore_eoc = false;

    if (eof && cursor == eof) // Catch EOF
	{
    	return 0;
	}

    tok = cursor;
echo:

#line 97 "real_world/scanner.c"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00: goto yy1;
		case '\n': goto yy4;
		case '*': goto yy5;
		case '/': goto yy6;
		default: goto yy2;
	}
yy1:
	++YYCURSOR;
#line 136 "real_world/scanner.re"
	{
					out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok) - 1); // -1 so we don't write out the \0
					if(cursor == eof) {
						RETURN(0);
					}
				}
#line 118 "real_world/scanner.c"
yy2:
	++YYCURSOR;
yy3:
#line 142 "real_world/scanner.re"
	{
					goto echo;
				}
#line 126 "real_world/scanner.c"
yy4:
	++YYCURSOR;
#line 131 "real_world/scanner.re"
	{
					out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok));
					tok = pos = cursor; cline++;
				  	goto echo;
				}
#line 135 "real_world/scanner.c"
yy5:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/': goto yy7;
		default: goto yy3;
	}
yy6:
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '*': goto yy8;
		default: goto yy3;
	}
yy7:
	++YYCURSOR;
#line 122 "real_world/scanner.re"
	{
					if (ignore_eoc) {
						ignore_eoc = false;
					} else {
						out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok));
					}
					tok = pos = cursor;
					goto echo;
				}
#line 160 "real_world/scanner.c"
yy8:
	yych = *++YYCURSOR;
	switch (yych) {
		case '!': goto yy10;
		default: goto yy9;
	}
yy9:
	YYCURSOR = YYMARKER;
	goto yy3;
yy10:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'm': goto yy11;
		case 'r': goto yy12;
		default: goto yy9;
	}
yy11:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'a': goto yy13;
		default: goto yy9;
	}
yy12:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'e': goto yy14;
		default: goto yy9;
	}
yy13:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'x': goto yy15;
		default: goto yy9;
	}
yy14:
	yych = *++YYCURSOR;
	switch (yych) {
		case '2': goto yy16;
		default: goto yy9;
	}
yy15:
	yych = *++YYCURSOR;
	switch (yych) {
		case ':': goto yy17;
		default: goto yy9;
	}
yy16:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'c': goto yy18;
		default: goto yy9;
	}
yy17:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'r': goto yy19;
		default: goto yy9;
	}
yy18:
	++YYCURSOR;
#line 111 "real_world/scanner.re"
	{ 
					out.write((const char*)(tok), (const char*)(&cursor[-7]) - (const char*)(tok));
					tok = cursor;
					RETURN(1);
				}
#line 227 "real_world/scanner.c"
yy19:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'e': goto yy20;
		default: goto yy9;
	}
yy20:
	yych = *++YYCURSOR;
	switch (yych) {
		case '2': goto yy21;
		default: goto yy9;
	}
yy21:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'c': goto yy22;
		default: goto yy9;
	}
yy22:
	++YYCURSOR;
#line 116 "real_world/scanner.re"
	{
					out << "#define YYMAXFILL " << maxFill << std::endl;
					tok = pos = cursor;
					ignore_eoc = true;
					goto echo;
				}
#line 255 "real_world/scanner.c"
}
#line 145 "real_world/scanner.re"

}


int Scanner::scan()
{
    char *cursor = cur;
    uint depth;

scan:
    tchar = cursor - pos;
    tline = cline;
    tok = cursor;
	if (iscfg == 1)
	{
		goto config;
	}
	else if (iscfg == 2)
	{
   		goto value;
    }

#line 280 "real_world/scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case ' ': goto yy26;
		case '\n': goto yy28;
		case '\r': goto yy29;
		case '"': goto yy30;
		case '\'': goto yy32;
		case '(':
		case ')':
		case ';':
		case '=':
		case '\\':
		case '|': goto yy34;
		case '*': goto yy36;
		case '+':
		case '?': goto yy38;
		case '.': goto yy39;
		case '/': goto yy40;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy41;
		case '[': goto yy44;
		case 'r': goto yy46;
		case '{': goto yy47;
		default: goto yy24;
	}
yy24:
	++YYCURSOR;
yy25:
#line 242 "real_world/scanner.re"
	{ std::ostringstream msg;
				  msg << "unexpected character: ";
				  prtChOrHex(msg, *tok);
				  fatal(msg.str().c_str());
				  goto scan;
				}
#line 370 "real_world/scanner.c"
yy26:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case ' ': goto yy26;
		default: goto yy27;
	}
yy27:
#line 235 "real_world/scanner.re"
	{ goto scan; }
#line 383 "real_world/scanner.c"
yy28:
	++YYCURSOR;
#line 237 "real_world/scanner.re"
	{ if(cursor == eof) RETURN(0);
				  pos = cursor; cline++;
				  goto scan;
	    			}
#line 391 "real_world/scanner.c"
yy29:
	yych = *++YYCURSOR;
	switch (yych) {
		case '\n': goto yy28;
		default: goto yy25;
	}
yy30:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\n': goto yy31;
		default: goto yy50;
	}
yy31:
#line 184 "real_world/scanner.re"
	{ fatal("unterminated string constant (missing \")"); }
#line 408 "real_world/scanner.c"
yy32:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\n': goto yy33;
		default: goto yy55;
	}
yy33:
#line 185 "real_world/scanner.re"
	{ fatal("unterminated string constant (missing ')"); }
#line 419 "real_world/scanner.c"
yy34:
	++YYCURSOR;
yy35:
#line 197 "real_world/scanner.re"
	{ RETURN(*tok); }
#line 425 "real_world/scanner.c"
yy36:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/': goto yy58;
		default: goto yy37;
	}
yy37:
#line 199 "real_world/scanner.re"
	{ yylval.op = *tok;
				  RETURN(CLOSE); }
#line 436 "real_world/scanner.c"
yy38:
	++YYCURSOR;
	goto yy37;
yy39:
	++YYCURSOR;
#line 230 "real_world/scanner.re"
	{ cur = cursor;
				  yylval.regexp = mkDot();
				  return RANGE;
				}
#line 447 "real_world/scanner.c"
yy40:
	yych = *++YYCURSOR;
	switch (yych) {
		case '*': goto yy59;
		default: goto yy35;
	}
yy41:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy42:
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy41;
		default: goto yy43;
	}
yy43:
#line 226 "real_world/scanner.re"
	{ cur = cursor;
				  yylval.symbol = Symbol::find(token());
				  return ID; }
#line 529 "real_world/scanner.c"
yy44:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\n': goto yy45;
		case '^': goto yy64;
		default: goto yy61;
	}
yy45:
#line 195 "real_world/scanner.re"
	{ fatal("unterminated range (missing ])"); }
#line 541 "real_world/scanner.c"
yy46:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'e': goto yy65;
		default: goto yy42;
	}
yy47:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ',': goto yy66;
		case '0': goto yy68;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy69;
		default: goto yy48;
	}
yy48:
#line 167 "real_world/scanner.re"
	{ depth = 1;
				  goto code;
				}
#line 570 "real_world/scanner.c"
yy49:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy50:
	switch (yych) {
		case '\n': goto yy51;
		case '"': goto yy52;
		case '\\': goto yy53;
		default: goto yy49;
	}
yy51:
	YYCURSOR = YYMARKER;
	switch (yyaccept) {
		case 0: goto yy31;
		case 1: goto yy33;
		case 2: goto yy45;
		case 3: goto yy48;
		case 4: goto yy67;
		case 5: goto yy43;
		default: goto yy84;
	}
yy52:
	++YYCURSOR;
#line 176 "real_world/scanner.re"
	{ cur = cursor;
				  yylval.regexp = strToRE(token());
				  return STRING; }
#line 599 "real_world/scanner.c"
yy53:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy51;
		default: goto yy49;
	}
yy54:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy55:
	switch (yych) {
		case '\n': goto yy51;
		case '\'': goto yy56;
		case '\\': goto yy57;
		default: goto yy54;
	}
yy56:
	++YYCURSOR;
#line 180 "real_world/scanner.re"
	{ cur = cursor;
				  yylval.regexp = strToCaseInsensitiveRE(token());
				  return STRING; }
#line 625 "real_world/scanner.c"
yy57:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy51;
		default: goto yy54;
	}
yy58:
	++YYCURSOR;
#line 173 "real_world/scanner.re"
	{ tok = cursor;
				  RETURN(0); }
#line 639 "real_world/scanner.c"
yy59:
	++YYCURSOR;
#line 170 "real_world/scanner.re"
	{ depth = 1;
				  goto comment; }
#line 645 "real_world/scanner.c"
yy60:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy61:
	switch (yych) {
		case '\n': goto yy51;
		case '\\': goto yy62;
		case ']': goto yy63;
		default: goto yy60;
	}
yy62:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy51;
		default: goto yy60;
	}
yy63:
	++YYCURSOR;
#line 191 "real_world/scanner.re"
	{ cur = cursor;
				  yylval.regexp = ranToRE(token());
				  return RANGE; }
#line 671 "real_world/scanner.c"
yy64:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy51;
		case '\\': goto yy71;
		case ']': goto yy72;
		default: goto yy64;
	}
yy65:
	yych = *++YYCURSOR;
	switch (yych) {
		case '2': goto yy73;
		default: goto yy42;
	}
yy66:
	++YYCURSOR;
yy67:
#line 217 "real_world/scanner.re"
	{ fatal("illegal closure form, use '{n}', '{n,}', '{n,m}' where n and m are numbers"); }
#line 693 "real_world/scanner.c"
yy68:
	yych = *++YYCURSOR;
	switch (yych) {
		case ',': goto yy74;
		default: goto yy70;
	}
yy69:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
yy70:
	switch (yych) {
		case ',': goto yy76;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy69;
		case '}': goto yy75;
		default: goto yy51;
	}
yy71:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy51;
		default: goto yy64;
	}
yy72:
	++YYCURSOR;
#line 187 "real_world/scanner.re"
	{ cur = cursor;
				  yylval.regexp = invToRE(token());
				  return RANGE; }
#line 734 "real_world/scanner.c"
yy73:
	yych = *++YYCURSOR;
	switch (yych) {
		case 'c': goto yy77;
		default: goto yy42;
	}
yy74:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy78;
		case '}': goto yy79;
		default: goto yy67;
	}
yy75:
	++YYCURSOR;
#line 205 "real_world/scanner.re"
	{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = atoi((char *)tok+1);
				  RETURN(CLOSESIZE); }
#line 764 "real_world/scanner.c"
yy76:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy78;
		case '}': goto yy80;
		default: goto yy67;
	}
yy77:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ':': goto yy81;
		default: goto yy42;
	}
yy78:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy78;
		case '}': goto yy82;
		default: goto yy51;
	}
yy79:
	++YYCURSOR;
#line 202 "real_world/scanner.re"
	{ yylval.op = '*';
				  RETURN(CLOSE); }
#line 812 "real_world/scanner.c"
yy80:
	++YYCURSOR;
#line 213 "real_world/scanner.re"
	{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = -1;
				  RETURN(CLOSESIZE); }
#line 819 "real_world/scanner.c"
yy81:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy83;
		default: goto yy51;
	}
yy82:
	++YYCURSOR;
#line 209 "real_world/scanner.re"
	{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = MAX(yylval.extop.minsize,atoi(strchr((char *)tok, ',')+1));
				  RETURN(CLOSESIZE); }
#line 885 "real_world/scanner.c"
yy83:
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'Z':
		case '_':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'u':
		case 'v':
		case 'w':
		case 'x':
		case 'y':
		case 'z': goto yy83;
		case ':': goto yy81;
		default: goto yy84;
	}
yy84:
#line 219 "real_world/scanner.re"
	{ cur = cursor;
				  tok+= 5; /* skip "re2c:" */
				  iscfg = 1;
				  yylval.str = new Str(token());
				  return CONFIG;
				}
#line 966 "real_world/scanner.c"
}
#line 248 "real_world/scanner.re"


code:

#line 973 "real_world/scanner.c"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy88;
		case '"': goto yy89;
		case '\'': goto yy90;
		case '{': goto yy91;
		case '}': goto yy92;
		default: goto yy86;
	}
yy86:
	++YYCURSOR;
yy87:
#line 264 "real_world/scanner.re"
	{ goto code; }
#line 991 "real_world/scanner.c"
yy88:
	++YYCURSOR;
#line 260 "real_world/scanner.re"
	{ if(cursor == eof) fatal("missing '}'");
				  pos = cursor; cline++;
				  goto code;
				}
#line 999 "real_world/scanner.c"
yy89:
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\n': goto yy87;
		default: goto yy94;
	}
yy90:
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\n': goto yy87;
		default: goto yy98;
	}
yy91:
	++YYCURSOR;
#line 258 "real_world/scanner.re"
	{ ++depth;
				  goto code; }
#line 1017 "real_world/scanner.c"
yy92:
	++YYCURSOR;
#line 252 "real_world/scanner.re"
	{ if(--depth == 0){
					cur = cursor;
					yylval.token = new Token(token(), tline);
					return CODE;
				  }
				  goto code; }
#line 1027 "real_world/scanner.c"
yy93:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy94:
	switch (yych) {
		case '\n': goto yy95;
		case '"': goto yy86;
		case '\\': goto yy96;
		default: goto yy93;
	}
yy95:
	YYCURSOR = YYMARKER;
	goto yy87;
yy96:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy95;
		default: goto yy93;
	}
yy97:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy98:
	switch (yych) {
		case '\n': goto yy95;
		case '\'': goto yy86;
		case '\\': goto yy99;
		default: goto yy97;
	}
yy99:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy95;
		default: goto yy97;
	}
}
#line 265 "real_world/scanner.re"


comment:

#line 1075 "real_world/scanner.c"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy103;
		case '*': goto yy104;
		case '/': goto yy105;
		default: goto yy101;
	}
yy101:
	++YYCURSOR;
yy102:
#line 280 "real_world/scanner.re"
	{ if(cursor == eof) RETURN(0);
				  goto comment; }
#line 1092 "real_world/scanner.c"
yy103:
	++YYCURSOR;
#line 276 "real_world/scanner.re"
	{ if(cursor == eof) RETURN(0);
				  tok = pos = cursor; cline++;
				  goto comment;
				}
#line 1100 "real_world/scanner.c"
yy104:
	yych = *++YYCURSOR;
	switch (yych) {
		case '/': goto yy106;
		default: goto yy102;
	}
yy105:
	yych = *++YYCURSOR;
	switch (yych) {
		case '*': goto yy107;
		default: goto yy102;
	}
yy106:
	++YYCURSOR;
#line 269 "real_world/scanner.re"
	{ if(--depth == 0)
					goto scan;
				    else
					goto comment; }
#line 1120 "real_world/scanner.c"
yy107:
	++YYCURSOR;
#line 273 "real_world/scanner.re"
	{ ++depth;
				  fatal("ambiguous /* found");
				  goto comment; }
#line 1127 "real_world/scanner.c"
}
#line 282 "real_world/scanner.re"


config:

#line 1134 "real_world/scanner.c"
{
	YYCTYPE yych;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case ' ': goto yy110;
		case '=': goto yy112;
		default: goto yy109;
	}
yy109:
	++YYCURSOR;
#line 291 "real_world/scanner.re"
	{ fatal("missing '='"); }
#line 1149 "real_world/scanner.c"
yy110:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case ' ': goto yy110;
		default: goto yy111;
	}
yy111:
#line 286 "real_world/scanner.re"
	{ goto config; }
#line 1162 "real_world/scanner.c"
yy112:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case ' ': goto yy112;
		default: goto yy113;
	}
yy113:
#line 287 "real_world/scanner.re"
	{ iscfg = 2;
				  cur = cursor;
				  RETURN('='); 
				}
#line 1178 "real_world/scanner.c"
}
#line 292 "real_world/scanner.re"


value:

#line 1185 "real_world/scanner.c"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case '\n':
		case '\r':
		case ' ':
		case ';': goto yy115;
		case '"': goto yy118;
		case '\'': goto yy119;
		case '-': goto yy120;
		case '0': goto yy121;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy123;
		default: goto yy116;
	}
yy115:
#line 301 "real_world/scanner.re"
	{ cur = cursor;
				  yylval.str = new Str(token());
				  iscfg = 0;
				  return VALUE;
				}
#line 1218 "real_world/scanner.c"
yy116:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy117:
	switch (yych) {
		case '\t':
		case '\n':
		case '\r':
		case ' ':
		case ';': goto yy115;
		default: goto yy116;
	}
yy118:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case '\r':
		case ' ':
		case ';': goto yy124;
		case '\n': goto yy115;
		case '"': goto yy116;
		case '\\': goto yy126;
		default: goto yy118;
	}
yy119:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case '\r':
		case ' ':
		case ';': goto yy127;
		case '\n': goto yy115;
		case '\'': goto yy116;
		case '\\': goto yy128;
		default: goto yy119;
	}
yy120:
	yych = *++YYCURSOR;
	switch (yych) {
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy123;
		default: goto yy117;
	}
yy121:
	yych = *++YYCURSOR;
	switch (yych) {
		case '\t':
		case '\n':
		case '\r':
		case ' ':
		case ';': goto yy122;
		default: goto yy116;
	}
yy122:
#line 296 "real_world/scanner.re"
	{ cur = cursor;
				  yylval.number = atoi(token().to_string().c_str());
				  iscfg = 0;
				  return NUMBER;
				}
#line 1291 "real_world/scanner.c"
yy123:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case '\n':
		case '\r':
		case ' ':
		case ';': goto yy122;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy123;
		default: goto yy116;
	}
yy124:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy125;
		case '"': goto yy129;
		case '\\': goto yy130;
		default: goto yy124;
	}
yy125:
	YYCURSOR = YYMARKER;
	goto yy115;
yy126:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case '\r':
		case ' ':
		case ';': goto yy124;
		case '\n': goto yy115;
		default: goto yy118;
	}
yy127:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy125;
		case '\'': goto yy129;
		case '\\': goto yy131;
		default: goto yy127;
	}
yy128:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\t':
		case '\r':
		case ' ':
		case ';': goto yy127;
		case '\n': goto yy115;
		default: goto yy119;
	}
yy129:
	++YYCURSOR;
	goto yy115;
yy130:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy125;
		default: goto yy124;
	}
yy131:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	switch (yych) {
		case '\n': goto yy125;
		default: goto yy127;
	}
}
#line 306 "real_world/scanner.re"

}

void Scanner::fatal(uint ofs, const char *msg) const
{
	out.flush();
	std::cerr << "re2c: error: "
		<< "line " << tline << ", column " << (tchar + ofs + 1) << ": "
		<< msg << std::endl;
   	exit(1);
}

} // end namespace re2c

real_world/scanner.re:301:8: warning: rule matches empty string [-Wmatch-empty-string]
