/*
 * Decompiled with CFR 0.152.
 */
package com.pywebview;

import android.net.http.SslError;
import android.util.Log;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.pywebview.EventCallbackWrapper;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class PyWebViewClient
extends WebViewClient {
    private EventCallbackWrapper callbackWrapper = null;
    private boolean ignoreSslErrors = false;

    public void setCallback(EventCallbackWrapper callback, boolean ignoreSslErrors) {
        this.callbackWrapper = callback;
        this.ignoreSslErrors = ignoreSslErrors;
    }

    public void onPageFinished(WebView view, String url) {
        if (this.callbackWrapper != null) {
            this.callbackWrapper.callback("onPageFinished", url);
        }
        super.onPageFinished(view, url);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        if (this.ignoreSslErrors) {
            Log.d((String)"PyWebViewClient", (String)("SSL Error: " + error.getPrimaryError()));
            handler.proceed();
            return;
        }
        super.onReceivedSslError(view, handler, error);
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        String scheme;
        if (request != null && request.getUrl() != null && request.getMethod().equalsIgnoreCase("get") && ((scheme = request.getUrl().getScheme().trim()).equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https"))) {
            return this.executeRequest(request.getUrl().toString());
        }
        return null;
    }

    private WebResourceResponse executeRequest(String url) {
        try {
            URL urlObj = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
            List<String> cookies = connection.getHeaderFields().get("Set-Cookie");
            if (cookies != null) {
                String authority = urlObj.getAuthority();
                String port = "";
                String[] urlParts = url.split("://");
                String urlHost = urlParts + "://" + urlParts[1].split("/")[0];
                if (authority.contains(":")) {
                    port = ':' + authority.split(":")[1];
                }
                String cookieString = "{ \"url\": \"" + urlHost + "\", \"cookies\": [";
                for (String entry : cookies) {
                    cookieString = cookieString + "\"" + entry.replace("\"", "\\\"") + "\",";
                }
                cookieString = cookieString.substring(0, cookieString.length() - 1) + "]}";
                this.callbackWrapper.callback("onCookiesReceived", cookieString);
            }
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

