/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.bdjo;

import java.util.BitSet;
import org.bluray.application.AppAttributes;
import org.bluray.net.BDLocator;
import org.davic.net.Locator;
import org.dvb.application.AppID;
import org.dvb.application.AppIcon;
import org.dvb.application.IllegalProfileParameterException;
import org.dvb.application.LanguageNotAvailableException;
import org.dvb.user.GeneralPreference;
import org.dvb.user.UserPreferenceManager;
import org.videolan.Logger;
import org.videolan.StrUtil;
import org.videolan.bdjo.AppProfile;

public class AppEntry
implements AppAttributes {
    public static final int AUTOSTART = 1;
    public static final int PRESENT = 2;
    protected static final int DISC_BOUND = 1;
    protected static final int TITLE_BOUND = 2;
    protected static final int VISIBLE_TO_APPS = 1;
    protected static final int VISIBLE_TO_USERS = 2;
    private int controlCode;
    private int type;
    private AppID appid;
    private AppProfile[] profiles;
    private short priority;
    private int binding;
    private String[][] names;
    private AppIcon icon;
    private String basePath;
    private String classpathExt;
    private String initialClass;
    private String[] params;

    public AppIcon getAppIcon() {
        return this.icon;
    }

    public AppID getIdentifier() {
        return this.appid;
    }

    public boolean getIsServiceBound() {
        return (this.binding & 2) != 0;
    }

    public String getName() {
        UserPreferenceManager pm = UserPreferenceManager.getInstance();
        GeneralPreference p = new GeneralPreference("User Language");
        pm.read(p);
        String lang = p.getMostFavourite();
        if (lang != null) {
            try {
                return this.getName(lang);
            }
            catch (LanguageNotAvailableException languageNotAvailableException) {
                // empty catch block
            }
        }
        if (this.names == null || this.names.length < 1) {
            return null;
        }
        return this.names[0][1];
    }

    public String getName(String language) throws LanguageNotAvailableException {
        for (int i = 0; i < this.names.length; ++i) {
            if (!language.equals(this.names[i][0])) continue;
            return this.names[i][1];
        }
        throw new LanguageNotAvailableException();
    }

    public String[][] getNames() {
        return this.names;
    }

    public int getPriority() {
        return this.priority;
    }

    public String[] getProfiles() {
        String[] ret = new String[]{};
        for (int i = 0; i < this.profiles.length; ++i) {
            if (this.profiles[i].getProfile() == 1) {
                ret = new String[]{"mhp.profile.enhanced_broadcast"};
            }
            if (this.profiles[i].getProfile() != 2) continue;
            ret = new String[]{"mhp.profile.enhanced_broadcast", "mhp.profile.interactive_broadcast"};
        }
        return ret;
    }

    public Object getProperty(String name) {
        if (name.equals("dvb.j.location.base")) {
            return this.basePath;
        }
        if (name.equals("dvb.j.location.cpath.extension")) {
            return StrUtil.split(this.classpathExt, ';');
        }
        if (name.equals("dvb.transport.oc.component.tag")) {
            return null;
        }
        return null;
    }

    public Locator getServiceLocator() {
        Logger.unimplemented("AppEntry", "getServiceLocator");
        return null;
    }

    public int getType() {
        return this.type;
    }

    public int[] getVersions(String profile) throws IllegalProfileParameterException {
        if (profile.equals("mhp.profile.enhanced_broadcast")) {
            for (int i = 0; i < this.profiles.length; ++i) {
                if (this.profiles[i].getProfile() != 2) continue;
                return new int[]{this.profiles[i].getMajor(), this.profiles[i].getMinor(), this.profiles[i].getMicro()};
            }
            return null;
        }
        if (profile.equals("mhp.profile.interactive_broadcast")) {
            for (int i = 0; i < this.profiles.length; ++i) {
                if (this.profiles[i].getProfile() != 1) continue;
                return new int[]{this.profiles[i].getMajor(), this.profiles[i].getMinor(), this.profiles[i].getMicro()};
            }
            return null;
        }
        throw new IllegalProfileParameterException();
    }

    public boolean isStartable() {
        return this.controlCode == 1 || this.controlCode == 2;
    }

    public boolean isVisible() {
        return false;
    }

    public boolean isDiscBound() {
        return (this.binding & 1) != 0;
    }

    public AppEntry(int controlCode, int type, int orgId, short appId, AppProfile[] profiles, short priority, int binding, int visibility, String[][] names, String iconLocator, short iconFlags, String basePath, String classpathExt, String initialClass, String[] params) {
        this.controlCode = controlCode;
        this.type = type;
        this.appid = new AppID(orgId, appId);
        this.profiles = profiles;
        this.priority = priority;
        this.binding = binding;
        this.names = names;
        if (iconLocator != null && iconLocator.length() > 0) {
            try {
                BDLocator locator = new BDLocator("bd://JAR:" + basePath + "/" + iconLocator);
                BitSet flags = new BitSet(16);
                for (int i = 0; i < 9; ++i) {
                    if ((iconFlags & 1 << i) == 0) continue;
                    flags.set(i, true);
                }
                this.icon = new AppIcon(locator, flags);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.basePath = basePath;
        this.classpathExt = classpathExt;
        this.initialClass = initialClass;
        this.params = params;
        if ((binding & 3) == 0) {
            System.err.println("Disc unbound application: " + initialClass);
        }
    }

    public int getControlCode() {
        return this.controlCode;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getClassPathExt() {
        return this.classpathExt;
    }

    public String getInitialClass() {
        return this.initialClass;
    }

    public String[] getParams() {
        return this.params;
    }
}

