"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tabpage = void 0;
const Base_1 = require("./Base");
const types_1 = require("./types");
const createChainableApi_1 = require("./utils/createChainableApi");
const Window_1 = require("./Window");
class Tabpage extends Base_1.BaseApi {
    constructor() {
        super(...arguments);
        this.prefix = types_1.Metadata[types_1.ExtType.Tabpage].prefix;
    }
    /** Returns all windows of tabpage */
    get windows() {
        return this.request(`${this.prefix}list_wins`, [this]);
    }
    /** Gets the current window of tabpage */
    get window() {
        // Require is here otherwise we get circular refs
        return createChainableApi_1.createChainableApi.call(this, 'Window', Window_1.Window, () => this.request(`${this.prefix}get_win`, [this]));
    }
    /** Is current tabpage valid */
    get valid() {
        return this.request(`${this.prefix}is_valid`, [this]);
    }
    /** Tabpage number */
    get number() {
        return this.request(`${this.prefix}get_number`, [this]);
    }
    /** Invalid */
    getOption() {
        this.logger.error('Tabpage does not have `getOption`');
    }
    /** Invalid */
    setOption() {
        this.logger.error('Tabpage does not have `setOption`');
    }
}
exports.Tabpage = Tabpage;
