;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt --instrument-memory="load,memory.grow" -S -o - | filecheck %s

;; The test validates the instruction filter used in this pass.
(module
  (memory 256 256)
  ;; CHECK:      (type $0 (func (param i32 i32) (result i32)))

  ;; CHECK:      (type $1 (func))
  (type $1 (func))
  ;; CHECK:      (type $2 (func (param i32 i32 i32 i32) (result i32)))

  ;; CHECK:      (type $3 (func (param i32 i64) (result i64)))

  ;; CHECK:      (type $4 (func (param i32 f32) (result f32)))

  ;; CHECK:      (type $5 (func (param i32 f64) (result f64)))

  ;; CHECK:      (import "env" "memory_grow_pre" (func $memory_grow_pre (param i32 i32) (result i32)))

  ;; CHECK:      (import "env" "memory_grow_post" (func $memory_grow_post (param i32 i32) (result i32)))

  ;; CHECK:      (import "env" "load_ptr" (func $load_ptr (param i32 i32 i32 i32) (result i32)))

  ;; CHECK:      (import "env" "load_val_i32" (func $load_val_i32 (param i32 i32) (result i32)))

  ;; CHECK:      (import "env" "load_val_i64" (func $load_val_i64 (param i32 i64) (result i64)))

  ;; CHECK:      (import "env" "load_val_f32" (func $load_val_f32 (param i32 f32) (result f32)))

  ;; CHECK:      (import "env" "load_val_f64" (func $load_val_f64 (param i32 f64) (result f64)))

  ;; CHECK:      (import "env" "store_ptr" (func $store_ptr (param i32 i32 i32 i32) (result i32)))

  ;; CHECK:      (import "env" "store_val_i32" (func $store_val_i32 (param i32 i32) (result i32)))

  ;; CHECK:      (import "env" "store_val_i64" (func $store_val_i64 (param i32 i64) (result i64)))

  ;; CHECK:      (import "env" "store_val_f32" (func $store_val_f32 (param i32 f32) (result f32)))

  ;; CHECK:      (import "env" "store_val_f64" (func $store_val_f64 (param i32 f64) (result f64)))

  ;; CHECK:      (memory $0 256 256)

  ;; CHECK:      (func $A
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (call $load_val_i32
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (i32.load8_s
  ;; CHECK-NEXT:     (call $load_ptr
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (call $load_val_i32
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:    (i32.load8_u
  ;; CHECK-NEXT:     (call $load_ptr
  ;; CHECK-NEXT:      (i32.const 2)
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (call $load_val_i64
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:    (i64.load16_s offset=8 align=1
  ;; CHECK-NEXT:     (call $load_ptr
  ;; CHECK-NEXT:      (i32.const 3)
  ;; CHECK-NEXT:      (i32.const 2)
  ;; CHECK-NEXT:      (i32.const 8)
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (call $load_val_i64
  ;; CHECK-NEXT:    (i32.const 4)
  ;; CHECK-NEXT:    (i64.load32_s offset=10 align=2
  ;; CHECK-NEXT:     (call $load_ptr
  ;; CHECK-NEXT:      (i32.const 4)
  ;; CHECK-NEXT:      (i32.const 4)
  ;; CHECK-NEXT:      (i32.const 10)
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $A (type $1)
    ;; "*.load*" instructions in this function are instrumented because of the
    ;; "load" filter included in the command.
    (drop (i32.load8_s (i32.const 0)))
    (drop (i32.load8_u (i32.const 0)))
    (drop (i64.load16_s offset=8 align=1 (i32.const 0)))
    (drop (i64.load32_s offset=10 align=2 (i32.const 0)))
  )

  ;; CHECK:      (func $B
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (call $memory_grow_post
  ;; CHECK-NEXT:    (i32.const 5)
  ;; CHECK-NEXT:    (memory.grow
  ;; CHECK-NEXT:     (call $memory_grow_pre
  ;; CHECK-NEXT:      (i32.const 5)
  ;; CHECK-NEXT:      (i32.const 4)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $B (type $1)
    ;; "memory.grow" instructions in this function are instrumented because of the
    ;; "memory.grow" filter included in the command.
    (drop (memory.grow (i32.const 4)))
  )

  ;; CHECK:      (func $C
  ;; CHECK-NEXT:  (i32.store8
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (i32.store16
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (i64.store16 offset=5
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i64.const 5)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (f64.store offset=9 align=2
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (f64.const 9)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $C (type $1)
    ;; "*.store*" instructions in this function are not instrumented because the
    ;; filter is non-empty and doesn't specify "store" instructions.
    (i32.store8 (i32.const 0) (i32.const 1))
    (i32.store16 (i32.const 0) (i32.const 2))
    (i64.store16 offset=5 align=2 (i32.const 0) (i64.const 5))
    (f64.store offset=9 align=2 (i32.const 0) (f64.const 9))
  )
)
