///////////////////////////////////////////////////////////////////////////////
//                                                         
// LR0Element.cc
// -------------
// Dragon LR(0) element implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: LR0Element
// 
// Description: description of the LR(1) grammar element  
//
///////////////////////////////////////////////////////////////////////////////

#include "LR0Element.h"

LR0Element::LR0Element()
{
}

LR0Element::LR0Element(Production* pProd, int pos)
{
    _pProd = pProd;
    _pos = pos;
}

LR0Element::~LR0Element()
{
}

Chain LR0Element::asChain() const
{

    Chain s = _pProd->getName();

    s += "->";

    int i=0;
    while ( i < _pProd->getMaxPos() )
    {
	s += " ";
	if ( i == _pos )
	    s += ".";
	Chain sym;
	_pProd->getSymbolAtPos(sym, i);
	s += sym;
	i++;
    }
    if ( i == _pos )
	s += ".";
    
    return s;
}

bool LR0Element::getSymbolAtPos(Chain& s) const
{
    if (_pProd->getSymbolAtPos(s, _pos) )
	return true;
    return false;
}

bool LR0Element::getFollowUpSymbol(Chain& s) const
{
    if ( ( _pos + 1 ) <  _pProd->getMaxPos() )
    {
	_pProd->getSymbolAtPos(s, _pos+1);
	return true;
    }
    else
    {
	return false;
    }
}

bool LR0Element::isProdAtPos() const
{
    if (_pos >= _pProd->getMaxPos())
	return false;
    return (! _pProd->isTermAtPos(_pos) ) ;
}

unsigned long LR0Element::getProdId() const
{
    return _pProd->getId();
}

LR0Element LR0Element::jumpOver()
{
    return LR0Element(_pProd, _pos+1);
}

int LR0Element::getPos()
{
    return _pos;
}

Production* LR0Element::getProd()
{
    return _pProd;
}

LR0Element& LR0Element::operator = (const LR0Element& e)
{
    _pProd = e._pProd;
    _pos = e._pos;
    return (*this);   
}


bool LR0Element::operator == (const LR0Element& e) const
{
    if ( (_pProd == e._pProd ) && ( _pos == e._pos) )
	return true;
    return false;
}

ostream& operator << (ostream& s, LR0Element& e)
{
    s << e.asChain() << endl;
    return s;
}






