///////////////////////////////////////////////////////////////////////////////
//                                                         
// LR0Hash.cc
// ----------
// dragon LR0 hash implementation
// 
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: LR0Hash
// 
// Description:
//
///////////////////////////////////////////////////////////////////////////////

#include "LR0Hash.h"

LR0Hash::LR0Hash()
{
}

LR0Hash::LR0Hash(const SetT<LR0Element>& LR0Set)
{
    _LR0Set = (SetT<LR0Element>)LR0Set;
}
	
LR0Hash::LR0Hash(const SetT<LR0Element>& LR0Set, int id)
{
    _LR0Set = (SetT<LR0Element>)LR0Set;
    _id = id;

}

LR0Hash::~LR0Hash()
{
}

int LR0Hash::getId() const
{
    return _id;
}
	
SetT<LR0Element>& LR0Hash::getSet() const
{
    return ((LR0Hash*)this)->_LR0Set;
}
	
LR0Hash& LR0Hash::operator = (const LR0Hash& h)
{
    _id = h._id;
    _LR0Set = h._LR0Set;
    return (*this);
}
	
bool LR0Hash::operator == (const LR0Hash& h) const
{
    if (_LR0Set == (SetT<LR0Element>)h._LR0Set)
	return true;
    return false;
}







